# The LearningOnline Network with CAPA
# Wrapper for external and binary files as standalone resources
#
# $Id: lonwrapper.pm,v 1.26 2006/12/20 22:42:48 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonwrapper;

use strict;
use Apache::Constants qw(:common);
use Apache::lonnet;
use Apache::lonxml();
use Apache::lonenc();
use Apache::lonmenu();

# ================================================================ Main Handler

sub simple_menu {
#
# Producing the menu buttons
#
    return &Apache::loncommon::start_page('Menu',undef,
					  {'only_body' => 1,
					   'bgcolor'   => '#FFFFFF',}).
	&Apache::lonmenu::menubuttons(1,'web',1).
	&Apache::loncommon::end_page();
}


sub wrapper {
    my ($topurl,$bottomurl) = @_;

    if ($env{'browser.interface'} eq 'textual') {
#
# ssi-based rendering for text-based interface
#
	return 
	    &Apache::loncommon::start_page('Menu',undef,
					  {'bgcolor'        => '#FFFFFF',
					   'force_register' => 1,
				       }).
	    &Apache::lonnet::ssi_body($bottomurl).
	    &Apache::loncommon::end_page();
    }


    my %layout = ('border' => 0);
    if ($env{'environment.remote'} eq 'off') {
	$layout{'rows'} = "180,*";
    } else {
	$layout{'rows'} = "1,*";
	$topurl = "/adm/rat/empty.html";
    }

    my $start_page = 
	&Apache::loncommon::start_page(undef,undef,
				       {'force_register' => 1,
					'frameset'       => 1,
					'add_entries'    => \%layout, });

    my $end_page = 
	&Apache::loncommon::end_page({'frameset' => 1});
    
    foreach my $url ($topurl,$bottomurl) {
	if ($url !~ /^http:/) {
	    $url = &Apache::lonenc::check_encrypt($url);
	}
    }
#
# frame-based rendering for graphical interface
#
    my $result =<<ENDDOCUMENT;
$start_page
test
<frame src="$topurl" />
<frame src="$bottomurl" />
$end_page
ENDDOCUMENT

    return $result;
}

sub handler {
    my $r=shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

    return OK if $r->header_only;

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
					    ['wrapperdisplay']);
    if ($env{'form.wrapperdisplay'} eq 'menu') {
	$r->print(&simple_menu());
	return OK;
    }

    my $orgurl=$r->uri;
    my $url=$orgurl;
    $orgurl.=(($orgurl=~/\?/)?'&':'?').$ENV{'QUERY_STRING'};
    $orgurl.=(($orgurl=~/\?/)?'&':'?').'wrapperdisplay=menu';
    $url=~s/^\/adm\/wrapper//;
    my $is_ext = $url =~ m|^/ext/|;
    $url=~s{^/ext/}{http://};
    $url=~s|http://https://|https://|;
    $url=~s|&colon;|:|g;
#
# Actual URL
#
    if ($url=~/\.(problem|exam|quiz|assess|survey|form|library)$/) {
#
# This is uploaded homework
#
	$env{'request.state'}='uploaded';
	&Apache::lonhomework::renderpage($r,$url);
    } else {
#
# This is not homework
#
	if ($is_ext) {
	    $ENV{'QUERY_STRING'}=~s/(^|\&)symb=[^\&]*/$1/;
	}
	$url.=(($url=~/\?/)?'&':'?').$ENV{'QUERY_STRING'}; 
	# reappend the query arguments
	$r->print(&wrapper($orgurl,$url));
    } # not just the menu
    return OK;
} # handler

1;
__END__







