/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomIndexIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIterator;
import org.jmol.modelset.Bond;
import org.jmol.modelset.CellInfo;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Dipoles;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class ModelManager {
    private final Viewer viewer;
    private ModelLoader modelLoader;
    private ModelSet modelSet;
    private String fullPathName;
    private String fileName;
    private String modelSetName;
    int[] shapeSizes = new int[31];
    static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};

    public ModelManager(Viewer viewer) {
        this.viewer = viewer;
    }

    public void clear() {
        this.modelSetName = null;
        this.fileName = null;
        this.fullPathName = null;
        this.clearFrame();
    }

    void clearFrame() {
        this.modelLoader = null;
        this.modelSet = null;
    }

    public void zap() {
        this.clear();
        this.modelSetName = "zapped";
        this.fileName = "zapped";
        this.fullPathName = "zapped";
        this.modelLoader = new ModelLoader(this.viewer, "empty");
        this.modelSet = this.modelLoader;
    }

    public void merge(JmolAdapter jmolAdapter, Object object) {
        this.modelLoader = new ModelLoader(this.viewer, jmolAdapter, object, this.modelLoader);
        this.modelSet = this.modelLoader;
        if (this.modelSet.getAtomCount() == 0) {
            this.zap();
        }
    }

    public void setClientFile(String string, String string2, JmolAdapter jmolAdapter, Object object) {
        if (object == null) {
            this.clear();
            return;
        }
        this.fullPathName = string;
        this.fileName = string2;
        this.modelSetName = jmolAdapter.getAtomSetCollectionName(object);
        if (this.modelSetName != null) {
            this.modelSetName = this.modelSetName.trim();
            if (this.modelSetName.length() == 0) {
                this.modelSetName = null;
            }
        }
        if (this.modelSetName == null) {
            this.modelSetName = this.reduceFilename(string2);
        }
        this.clearFrame();
        this.modelLoader = new ModelLoader(this.viewer, jmolAdapter, object, null);
        this.modelSet = this.modelLoader;
        if (this.modelSet.getAtomCount() == 0) {
            this.zap();
        }
    }

    String reduceFilename(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (string.length() > 24) {
            string = string.substring(0, 20) + " ...";
        }
        return string;
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public String getModelSetName() {
        return this.modelSetName;
    }

    public String getModelSetFileName() {
        return this.fileName;
    }

    public String getModelSetPathName() {
        return this.fullPathName;
    }

    public Properties getModelSetProperties() {
        return this.modelSet.getModelSetProperties();
    }

    public String getModelSetProperty(String string) {
        return this.modelSet.getModelSetProperty(string);
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSet.getModelSetAuxiliaryInfo();
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSet.getModelSetAuxiliaryInfo(string);
    }

    public boolean modelSetHasVibrationVectors() {
        return this.modelSet.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int n) {
        return this.modelSet.modelHasVibrationVectors(n);
    }

    public String getModelSetTypeName() {
        return this.modelSet.getModelSetTypeName();
    }

    boolean isPDB() {
        return this.modelSet.isPDB();
    }

    boolean isPDB(int n) {
        return this.modelSet.mmset.getModel((int)n).isPDB;
    }

    public int getModelCount() {
        return this.modelSet.getModelCount();
    }

    public String getModelInfoAsString() {
        int n = this.getModelCount();
        String string = "model count = " + n + "\nmodelSetHasVibrationVectors:" + this.modelSetHasVibrationVectors();
        Properties properties = this.getModelSetProperties();
        string = string.concat(this.listProperties(properties));
        for (int i = 0; i < n; ++i) {
            string = string.concat("\n" + i + ":" + this.getModelName(-1 - i) + ":" + this.getModelTitle(i) + "\nmodelHasVibrationVectors:" + this.modelHasVibrationVectors(i));
        }
        return string;
    }

    public String getSymmetryInfoAsString() {
        int n = this.getModelCount();
        String string = "Symmetry Information:";
        for (int i = 0; i < n; ++i) {
            string = string + "\nmodel #" + this.getModelName(-1 - i) + "; name=" + this.getModelName(i) + "\n" + this.modelSet.getSymmetryInfoAsString(i);
        }
        return string;
    }

    public String getModelName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelName(n);
    }

    public String getModelTitle(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelTitle(n);
    }

    public String getModelFile(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelFile(n);
    }

    public int getModelNumber(int n) {
        return this.modelSet.getModelNumber(n);
    }

    public int getModelFileNumber(int n) {
        return this.modelSet.getModelFileNumber(n);
    }

    public Properties getModelProperties(int n) {
        return this.modelSet.getModelProperties(n);
    }

    public String getModelProperty(int n, String string) {
        return this.modelSet.getModelProperty(n, string);
    }

    public Hashtable getModelAuxiliaryInfo(int n) {
        return this.modelSet.getModelAuxiliaryInfo(n);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        return this.modelSet.getModelAuxiliaryInfo(n, string);
    }

    public int getModelNumberIndex(int n, boolean bl) {
        return this.modelSet.getModelNumberIndex(n, bl);
    }

    public float calcRotationRadius(Point3f point3f) {
        return this.modelSet.calcRotationRadius(point3f);
    }

    public float calcRotationRadius(BitSet bitSet) {
        return this.modelSet.calcRotationRadius(bitSet);
    }

    public Point3f getBoundBoxCenter() {
        return this.modelSet.getBoundBoxCenter();
    }

    public Point3f getAverageAtomPoint() {
        return this.modelSet.getAverageAtomPoint();
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.modelSet.getBoundBoxCornerVector();
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        return this.modelSet.getAtomSetCenter(bitSet);
    }

    public BitSet getAtomBits(String string) {
        return this.modelSet.getAtomBits(string);
    }

    public BitSet getAtomBits(String string, String string2) {
        return this.modelSet.getAtomBits(string, string2);
    }

    public BitSet getAtomBits(String string, int n) {
        return this.modelSet.getAtomBits(string, n);
    }

    public BitSet getAtomBits(String string, int[] nArray) {
        return this.modelSet.getAtomBits(string, nArray);
    }

    public int getAtomCount() {
        return this.modelSet.getAtomCount();
    }

    public int getAtomCountInModel(int n) {
        return n < 0 ? this.getAtomCount() : this.modelSet.getAtomCountInModel(n);
    }

    public int getBondCount() {
        return this.modelSet.getBondCount();
    }

    public int getBondCountInModel(int n) {
        return this.modelSet.getBondCountInModel(n);
    }

    public BitSet getBondsForSelectedAtoms(BitSet bitSet) {
        return this.modelSet.getBondsForSelectedAtoms(bitSet);
    }

    public int getGroupCount() {
        return this.modelSet.getGroupCount();
    }

    public int getGroupCountInModel(int n) {
        return n < 0 ? this.getGroupCount() : this.modelSet.getGroupCountInModel(n);
    }

    public int getChainCount() {
        return this.modelSet.getChainCount();
    }

    public int getChainCountInModel(int n) {
        return n < 0 ? this.getChainCount() : this.modelSet.getChainCountInModel(n);
    }

    public int getBioPolymerCount() {
        return this.modelSet.getBioPolymerCount();
    }

    public int getBioPolymerCountInModel(int n) {
        return n < 0 ? this.getBioPolymerCount() : this.modelSet.getBioPolymerCountInModel(n);
    }

    int getMoleuleCount() {
        return this.modelSet.getMoleculeCount();
    }

    public int makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        return this.modelSet.makeConnections(f, f2, s, n, bitSet, bitSet2, bitSet3, bl);
    }

    public void rebond() {
        this.modelSet.rebond();
    }

    public boolean frankClicked(int n, int n2) {
        return this.getShapeSize(30) != 0 && this.modelSet.frankClicked(n, n2);
    }

    public int findNearestAtomIndex(int n, int n2) {
        if (this.modelSet == null) {
            return -1;
        }
        return this.modelSet.findNearestAtomIndex(n, n2);
    }

    public BitSet findAtomsInRectangle(Rectangle rectangle) {
        return this.modelSet.findAtomsInRectangle(rectangle);
    }

    public void loadShape(int n) {
        this.modelSet.loadShape(n);
    }

    public void setShapeSize(int n, int n2, BitSet bitSet) {
        this.shapeSizes[n] = n2;
        this.modelSet.setShapeSize(n, n2, bitSet);
    }

    public int getShapeSize(int n) {
        return this.shapeSizes[n];
    }

    public void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        this.modelSet.setShapeProperty(n, string.intern(), object, bitSet);
    }

    public Object getShapeProperty(int n, String string, int n2) {
        return this.modelSet.getShapeProperty(n, string, n2);
    }

    public int getShapeIdFromObjectName(String string) {
        for (int i = 25; i < 30; ++i) {
            MeshCollection meshCollection = (MeshCollection)this.modelSet.getShape(i);
            if (meshCollection == null || meshCollection.getIndexFromName(string) < 0) continue;
            return i;
        }
        Dipoles dipoles = (Dipoles)this.modelSet.getShape(24);
        if (dipoles != null && dipoles.getIndexFromName(string) >= 0) {
            return 24;
        }
        return -1;
    }

    public int getAtomIndexFromAtomNumber(int n) {
        return this.modelSet.getAtomIndexFromAtomNumber(n);
    }

    public BitSet getElementsPresentBitSet(int n) {
        return this.modelSet.getElementsPresentBitSet(n);
    }

    public Hashtable getHeteroList(int n) {
        return this.modelSet.mmset.getHeteroList(n);
    }

    public BitSet getVisibleSet() {
        return this.modelSet.getVisibleSet();
    }

    public BitSet getClickableSet() {
        return this.modelSet.getClickableSet();
    }

    public BitSet getModelAtomBitSet(int n) {
        return this.modelSet.getModelAtomBitSet(n);
    }

    public BitSet getModelBitSet(BitSet bitSet) {
        return this.modelSet.getModelBitSet(bitSet);
    }

    BitSet getMoleculeBitSet(int n) {
        return this.modelSet.getMoleculeBitSet(n);
    }

    public void calcSelectedGroupsCount(BitSet bitSet) {
        this.modelSet.calcSelectedGroupsCount(bitSet);
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        this.modelSet.calcSelectedMonomersCount(bitSet);
    }

    public void calcSelectedMoleculesCount(BitSet bitSet) {
        this.modelSet.calcSelectedGroupsCount(bitSet);
    }

    public String getAtomInfo(int n) {
        return this.modelSet.getAtomAt(n).getInfo();
    }

    public String getAtomInfoXYZ(int n, boolean bl) {
        return this.modelSet.getAtomAt(n).getInfoXYZ(bl);
    }

    public String getElementSymbol(int n) {
        return this.modelSet.getAtomAt(n).getElementSymbol();
    }

    public int getElementNumber(int n) {
        return this.modelSet.getAtomAt(n).getElementNumber();
    }

    String getElementName(int n) {
        return JmolConstants.elementNameFromNumber(this.modelSet.getAtomAt(n).getAtomicAndIsotopeNumber());
    }

    public String getAtomName(int n) {
        return this.modelSet.getAtomAt(n).getAtomName();
    }

    boolean getAtomVisibility(int n) {
        return this.modelSet.getAtomAt(n).isVisible();
    }

    public int getAtomNumber(int n) {
        return this.modelSet.getAtomAt(n).getAtomNumber();
    }

    public float getAtomX(int n) {
        return this.modelSet.getAtomAt((int)n).x;
    }

    public float getAtomY(int n) {
        return this.modelSet.getAtomAt((int)n).y;
    }

    public float getAtomZ(int n) {
        return this.modelSet.getAtomAt((int)n).z;
    }

    public Point3f getAtomPoint3f(int n) {
        return this.modelSet.getAtomAt(n);
    }

    public float getAtomRadius(int n) {
        return this.modelSet.getAtomAt(n).getRadius();
    }

    public float getAtomVdwRadius(int n) {
        return this.modelSet.getAtomAt(n).getVanderwaalsRadiusFloat();
    }

    public short getAtomColix(int n) {
        return this.modelSet.getAtomAt(n).getColix();
    }

    public String getAtomChain(int n) {
        return "" + this.modelSet.getAtomAt(n).getChainID();
    }

    public String getAtomSequenceCode(int n) {
        return this.modelSet.getAtomAt(n).getSeqcodeString();
    }

    public int getAtomModelIndex(int n) {
        return this.modelSet.getAtomAt(n).getModelIndex();
    }

    public Point3f getBondPoint3f1(int n) {
        return this.modelSet.getBondAt(n).getAtom1();
    }

    public Point3f getBondPoint3f2(int n) {
        return this.modelSet.getBondAt(n).getAtom2();
    }

    public float getBondRadius(int n) {
        return this.modelSet.getBondAt(n).getRadius();
    }

    public short getBondOrder(int n) {
        return this.modelSet.getBondAt(n).getOrder();
    }

    float getBondLength(int n) {
        return this.getBondAtom1(n).distance(this.getBondAtom2(n));
    }

    Atom getBondAtom1(int n) {
        return this.modelSet.getBondAt(n).getAtom1();
    }

    Atom getBondAtom2(int n) {
        return this.modelSet.getBondAt(n).getAtom2();
    }

    public short getBondColix1(int n) {
        return this.modelSet.getBondAt(n).getColix1();
    }

    public short getBondColix2(int n) {
        return this.modelSet.getBondAt(n).getColix2();
    }

    public int getBondModelIndex(int n) {
        Atom atom = this.modelSet.getBondAt(n).getAtom1();
        if (atom != null) {
            return atom.getModelIndex();
        }
        atom = this.modelSet.getBondAt(n).getAtom2();
        if (atom != null) {
            return atom.getModelIndex();
        }
        return 0;
    }

    public BitSet getAtomsWithin(String string, String string2, BitSet bitSet) {
        if (string.equals("sequence")) {
            return this.withinSequence(string2, bitSet);
        }
        return null;
    }

    public BitSet getAtomsWithin(String string, BitSet bitSet) {
        if (string.equals("group")) {
            return this.withinGroup(bitSet);
        }
        if (string.equals("chain")) {
            return this.withinChain(bitSet);
        }
        if (string.equals("molecule")) {
            return this.withinMolecule(bitSet);
        }
        if (string.equals("model")) {
            return this.withinModel(bitSet);
        }
        if (string.equals("element")) {
            return this.withinElement(bitSet);
        }
        if (string.equals("site")) {
            return this.withinSite(bitSet);
        }
        return null;
    }

    BitSet withinGroup(BitSet bitSet) {
        Group group = null;
        BitSet bitSet2 = new BitSet();
        int n = this.getAtomCount();
        while (--n >= 0) {
            Atom atom;
            Group group2;
            if (!bitSet.get(n) || (group2 = (atom = this.modelSet.getAtomAt(n)).getGroup()) == group) continue;
            group2.selectAtoms(bitSet2);
            group = group2;
        }
        return bitSet2;
    }

    BitSet withinChain(BitSet bitSet) {
        Chain chain = null;
        BitSet bitSet2 = new BitSet();
        int n = this.getAtomCount();
        Atom[] atomArray = this.modelSet.atoms;
        int n2 = n;
        while (--n2 >= 0) {
            Chain chain2;
            if (!bitSet.get(n2) || (chain2 = atomArray[n2].getChain()) == chain) continue;
            int n3 = n;
            while (--n3 >= 0) {
                if (atomArray[n3].getChain() != chain2) continue;
                bitSet2.set(n3);
            }
            chain = chain2;
        }
        return bitSet2;
    }

    BitSet withinMolecule(BitSet bitSet) {
        return this.modelSet.getMoleculeBitSet(bitSet);
    }

    BitSet withinModel(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        int n = this.getAtomCount();
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            bitSet3.set(this.modelSet.getAtomAt((int)n).modelIndex);
        }
        n = this.getAtomCount();
        while (--n >= 0) {
            if (!bitSet3.get(this.modelSet.getAtomAt((int)n).modelIndex)) continue;
            bitSet2.set(n);
        }
        return bitSet2;
    }

    BitSet withinSite(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        int n = this.getAtomCount();
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            bitSet3.set(this.modelSet.getAtomAt((int)n).atomSite);
        }
        n = this.getAtomCount();
        while (--n >= 0) {
            if (!bitSet3.get(this.modelSet.getAtomAt((int)n).atomSite)) continue;
            bitSet2.set(n);
        }
        return bitSet2;
    }

    BitSet withinElement(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        int n = this.getAtomCount();
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            bitSet3.set(this.getElementNumber(n));
        }
        n = this.getAtomCount();
        while (--n >= 0) {
            if (!bitSet3.get(this.getElementNumber(n))) continue;
            bitSet2.set(n);
        }
        return bitSet2;
    }

    BitSet withinSequence(String string, BitSet bitSet) {
        String string2 = "";
        int n = string.length();
        BitSet bitSet2 = new BitSet();
        if (n == 0) {
            return bitSet2;
        }
        int n2 = this.viewer.getModelCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getBioPolymerCountInModel(i);
            block1: for (int j = 0; j < n3; ++j) {
                string2 = this.getPolymerSequence(i, j);
                int n4 = -1;
                while (true) {
                    ++n4;
                    if ((n4 = string2.indexOf(string, n4)) < 0) continue block1;
                    this.getPolymerSequenceAtoms(i, j, n4, n, bitSet, bitSet2);
                }
            }
        }
        return bitSet2;
    }

    void selectModelIndexAtoms(int n, BitSet bitSet) {
        int n2 = this.viewer.getAtomCount();
        while (--n2 >= 0) {
            if (this.modelSet.getAtomAt(n2).getModelIndex() != n) continue;
            bitSet.set(n2);
        }
    }

    public BitSet getAtomsWithin(float f, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            Atom atom = this.modelSet.getAtomAt(n);
            AtomIterator atomIterator = this.modelSet.getWithinModelIterator(atom, f);
            while (atomIterator.hasNext()) {
                bitSet2.set(atomIterator.next().getAtomIndex());
            }
        }
        return bitSet2;
    }

    public BitSet getAtomsWithin(float f, Point3f point3f) {
        BitSet bitSet = new BitSet();
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            Atom atom = this.modelSet.getAtomAt(n);
            if (!(atom.distance(point3f) <= f)) continue;
            bitSet.set(atom.atomIndex);
        }
        return bitSet;
    }

    public BitSet getAtomsWithin(float f, Point4f point4f) {
        return this.modelSet.getAtomsWithin(f, point4f);
    }

    public void loadCoordinates(String string) {
        this.modelSet.loadCoordinates(string);
    }

    public BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        int n2;
        int n3;
        BitSet bitSet2 = new BitSet();
        int n4 = this.getAtomCount();
        int[] nArray = new int[n4];
        int n5 = this.getBondCount();
        for (n3 = 0; n3 < n5; ++n3) {
            Bond bond = this.modelSet.getBondAt(n3);
            if (n != -2 && bond.order != n) continue;
            if (bitSet.get(bond.atom1.atomIndex)) {
                n2 = bond.atom2.atomIndex;
                nArray[n2] = nArray[n2] + 1;
                bitSet2.set(n2);
            }
            if (!bitSet.get(bond.atom2.atomIndex)) continue;
            n2 = bond.atom1.atomIndex;
            nArray[n2] = nArray[n2] + 1;
            bitSet2.set(n2);
        }
        n3 = f == 0.0f && f2 == 0.0f ? 1 : 0;
        n2 = n4;
        while (--n2 >= 0) {
            int n6 = nArray[n2];
            if ((float)n6 < f || (float)n6 > f2) {
                bitSet2.clear(n2);
                continue;
            }
            if (n3 == 0 || n6 != 0) continue;
            bitSet2.set(n2);
        }
        return bitSet2;
    }

    public String getModelExtract(BitSet bitSet) {
        int n;
        int n2 = this.getAtomCount();
        int n3 = this.getBondCount();
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[n2];
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < n2; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n] = ++n4;
            this.getAtomRecordMOL(stringBuffer2, n);
        }
        for (n = 0; n < n3; ++n) {
            short s;
            if (!bitSet.get(this.modelSet.getBondAt((int)n).getAtom1().atomIndex) || !bitSet.get(this.modelSet.getBondAt((int)n).getAtom2().atomIndex) || (s = this.getBondOrder(n)) < 1 || s >= 3) continue;
            this.getBondRecordMOL(stringBuffer2, n, nArray);
            ++n5;
        }
        if (n4 > 999 || n5 > 999) {
            Logger.error("ModelManager.java::getModel: ERROR atom/bond overflow");
            return "";
        }
        this.rFill(stringBuffer, "   ", "" + n4);
        this.rFill(stringBuffer, "   ", "" + n5);
        stringBuffer.append("  0  0  0\n");
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    void getAtomRecordMOL(StringBuffer stringBuffer, int n) {
        this.rFill(stringBuffer, "          ", this.safeTruncate(this.getAtomX(n), 9));
        this.rFill(stringBuffer, "          ", this.safeTruncate(this.getAtomY(n), 9));
        this.rFill(stringBuffer, "          ", this.safeTruncate(this.getAtomZ(n), 9));
        stringBuffer.append(" ").append((this.getElementSymbol(n) + "  ").substring(0, 2)).append("\n");
    }

    void getBondRecordMOL(StringBuffer stringBuffer, int n, int[] nArray) {
        Bond bond = this.modelSet.getBondAt(n);
        this.rFill(stringBuffer, "   ", "" + nArray[bond.getAtom1().atomIndex]);
        this.rFill(stringBuffer, "   ", "" + nArray[bond.getAtom2().atomIndex]);
        stringBuffer.append("  ").append(this.getBondOrder(n)).append("\n");
    }

    private void rFill(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string.substring(0, string.length() - string2.length()));
        stringBuffer.append(string2);
    }

    private String safeTruncate(float f, int n) {
        if ((double)f > -0.001 && (double)f < 0.001) {
            f = 0.0f;
        }
        return (f + "         ").substring(0, n);
    }

    public String getFileHeader() {
        if (this.modelSet.isPDB()) {
            return this.getFullPDBHeader();
        }
        String string = this.getModelSetProperty("fileHeader");
        if (string == null) {
            string = this.getModelSetName();
        }
        if (string != null) {
            return string;
        }
        return "no header information found";
    }

    public String getPDBHeader() {
        return this.modelSet.isPDB() ? this.getFullPDBHeader() : this.getFileHeader();
    }

    String getFullPDBHeader() {
        String string = this.viewer.getCurrentFileAsString();
        int n = string.length();
        int n2 = pdbRecords.length;
        block4: while (--n2 >= 0) {
            String string2 = pdbRecords[n2];
            int n3 = string.startsWith(string2) ? 0 : string.indexOf("\n" + string2);
            switch (n3) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    return "";
                }
            }
            if (n3 >= n) continue;
            n = ++n3;
        }
        return string.substring(0, n);
    }

    public Hashtable getModelInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = this.viewer.getModelCount();
        hashtable.put("modelSetName", this.getModelSetName());
        hashtable.put("modelCount", new Integer(n));
        hashtable.put("modelSetHasVibrationVectors", this.modelSetHasVibrationVectors());
        Properties properties = this.viewer.getModelSetProperties();
        if (properties != null) {
            hashtable.put("modelSetProperties", properties);
        }
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", new Integer(i));
            hashtable2.put("num", new Integer(this.viewer.getModelNumber(i)));
            hashtable2.put("name", this.getModelName(i));
            String string = this.getModelTitle(i);
            if (string != null) {
                hashtable2.put("title", string);
            }
            hashtable2.put("file", this.getModelFile(i));
            hashtable2.put("vibrationVectors", this.modelHasVibrationVectors(i));
            hashtable2.put("atomCount", new Integer(this.getAtomCountInModel(i)));
            hashtable2.put("bondCount", new Integer(this.getBondCountInModel(i)));
            hashtable2.put("groupCount", new Integer(this.getGroupCountInModel(i)));
            hashtable2.put("polymerCount", new Integer(this.getBioPolymerCountInModel(i)));
            hashtable2.put("chainCount", new Integer(this.getChainCountInModel(i)));
            properties = this.viewer.getModelProperties(i);
            if (properties != null) {
                hashtable2.put("modelProperties", properties);
            }
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public Hashtable getAuxiliaryInfo() {
        Hashtable hashtable = this.getModelSetAuxiliaryInfo();
        if (hashtable == null) {
            return hashtable;
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        int n = this.viewer.getModelCount();
        for (int i = 0; i < n; ++i) {
            Hashtable hashtable2 = this.getModelAuxiliaryInfo(i);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public Vector getAllAtomInfo(BitSet bitSet) {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        int n = this.viewer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            vector.addElement(this.getAtomInfoLong(i));
        }
        return vector;
    }

    public Vector getMoleculeInfo(BitSet bitSet) {
        return this.modelSet.getMoleculeInfo(bitSet);
    }

    public void getAtomIdentityInfo(int n, Hashtable hashtable) {
        hashtable.put("_ipt", new Integer(n));
        hashtable.put("atomno", new Integer(this.getAtomNumber(n)));
        hashtable.put("info", this.getAtomInfo(n));
        hashtable.put("sym", this.getElementSymbol(n));
    }

    Hashtable getAtomInfoLong(int n) {
        Atom atom = this.modelSet.getAtomAt(n);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(n, hashtable);
        hashtable.put("element", this.getElementName(n));
        hashtable.put("elemno", new Integer(this.getElementNumber(n)));
        hashtable.put("x", new Float(this.getAtomX(n)));
        hashtable.put("y", new Float(this.getAtomY(n)));
        hashtable.put("z", new Float(this.getAtomZ(n)));
        if (this.modelSet.vibrationVectors != null && this.modelSet.vibrationVectors[n] != null) {
            hashtable.put("vibVector", new Vector3f(this.modelSet.vibrationVectors[n]));
        }
        hashtable.put("bondCount", new Integer(atom.getCovalentBondCount()));
        hashtable.put("radius", new Float((double)atom.getRasMolRadius() / 120.0));
        hashtable.put("model", new Integer(atom.getModelNumberDotted()));
        hashtable.put("visible", this.getAtomVisibility(n));
        hashtable.put("clickabilityFlags", new Integer(atom.clickabilityFlags));
        hashtable.put("visibilityFlags", new Integer(atom.shapeVisibilityFlags));
        hashtable.put("spacefill", new Float(atom.getRadius()));
        String string = this.viewer.getHexColorFromIndex(atom.colixAtom);
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", new Integer(atom.colixAtom));
        boolean bl = atom.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", new Integer(atom.getFormalCharge()));
        hashtable.put("partialCharge", new Float(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", new Float(f));
        }
        if (this.isPDB(atom.modelIndex)) {
            hashtable.put("resname", atom.getGroup3());
            int n2 = atom.getSeqNumber();
            char c = atom.getInsertionCode();
            if (n2 > 0) {
                hashtable.put("resno", new Integer(n2));
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            char c2 = atom.getChainID();
            hashtable.put("name", this.getAtomName(n));
            hashtable.put("chain", c2 == '\u0000' ? "" : "" + c2);
            hashtable.put("atomID", new Integer(atom.getSpecialAtomID()));
            hashtable.put("groupID", new Integer(atom.getGroupID()));
            if (atom.alternateLocationID != 0) {
                hashtable.put("altLocation", "" + atom.alternateLocationID);
            }
            hashtable.put("structure", new Integer(atom.getProteinStructureType()));
            hashtable.put("polymerLength", new Integer(atom.getPolymerLength()));
            hashtable.put("occupancy", new Integer(atom.getOccupancy()));
            int n3 = atom.getBfactor100();
            hashtable.put("temp", new Integer(n3 < 0 ? 0 : n3 / 100));
        }
        return hashtable;
    }

    public Vector getAllBondInfo(BitSet bitSet) {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        int n = this.getBondCount();
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(this.modelSet.getBondAt((int)i).getAtom1().atomIndex) || !bitSet.get(this.modelSet.getBondAt((int)i).getAtom2().atomIndex)) continue;
            vector.addElement(this.getBondInfo(i));
        }
        return vector;
    }

    Hashtable getBondInfo(int n) {
        Bond bond = this.modelSet.getBondAt(n);
        Atom atom = this.getBondAtom1(n);
        Atom atom2 = this.getBondAtom2(n);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", new Integer(n));
        Hashtable hashtable2 = new Hashtable();
        this.getAtomIdentityInfo(atom.atomIndex, hashtable2);
        Hashtable hashtable3 = new Hashtable();
        this.getAtomIdentityInfo(atom2.atomIndex, hashtable3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("order", new Integer(this.getBondOrder(n)));
        hashtable.put("radius", new Float((double)bond.mad / 2000.0));
        hashtable.put("length_Ang", new Float(this.getBondLength(n)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = this.viewer.getHexColorFromIndex(bond.colix);
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", new Integer(bond.colix));
        boolean bl = bond.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        return hashtable;
    }

    String listProperties(Properties properties) {
        String string = "";
        if (properties == null) {
            string = string.concat("\nProperties: null");
        } else {
            Enumeration<?> enumeration = properties.propertyNames();
            string = string.concat("\nProperties:");
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = string.concat("\n " + string2 + "=" + properties.getProperty(string2));
            }
        }
        return string;
    }

    public Hashtable getAllChainInfo(BitSet bitSet) {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        int n = this.getModelCount();
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            Vector vector2 = this.getChainInfo(i, bitSet);
            if (vector2.size() <= 0) continue;
            hashtable2.put("modelIndex", new Integer(i));
            hashtable2.put("chains", vector2);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public void getPolymerPointsAndVectors(BitSet bitSet, Vector vector) {
        int n = this.viewer.getModelCount();
        boolean bl = this.viewer.getTraceAlpha();
        float f = this.viewer.getSheetSmoothing();
        int n2 = 0x7FFFFFFE;
        for (int i = 0; i < n; ++i) {
            int n3 = this.getBioPolymerCountInModel(i);
            for (int j = 0; j < n3; ++j) {
                n2 = this.modelSet.mmset.getModel(i).getBioPolymer(j).getPolymerPointsAndVectors(n2, bitSet, vector, bl, f);
            }
        }
    }

    Vector getChainInfo(int n, BitSet bitSet) {
        Model model = this.modelSet.mmset.getModel(n);
        int n2 = model.getChainCount();
        Vector vector = new Vector();
        for (int i = 0; i < n2; ++i) {
            Chain chain = model.getChain(i);
            Vector vector2 = new Vector();
            int n3 = chain.getGroupCount();
            Hashtable hashtable = new Hashtable();
            for (int j = 0; j < n3; ++j) {
                Group group = chain.getGroup(j);
                if (!bitSet.get(group.firstAtomIndex)) continue;
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                hashtable2.put("groupIndex", new Integer(j));
                hashtable2.put("groupID", new Short(group.getGroupID()));
                hashtable2.put("seqCode", group.getSeqcodeString());
                hashtable2.put("_apt1", new Integer(group.firstAtomIndex));
                hashtable2.put("_apt2", new Integer(group.lastAtomIndex));
                hashtable2.put("atomInfo1", this.getAtomInfo(group.firstAtomIndex));
                hashtable2.put("atomInfo2", this.getAtomInfo(group.lastAtomIndex));
                hashtable2.put("visibilityFlags", new Integer(group.shapeVisibilityFlags));
                vector2.addElement(hashtable2);
            }
            if (vector2.isEmpty()) continue;
            hashtable.put("residues", vector2);
            vector.addElement(hashtable);
        }
        return vector;
    }

    public Hashtable getAllPolymerInfo(BitSet bitSet) {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        int n = this.getModelCount();
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            Vector<Hashtable> vector2 = new Vector<Hashtable>();
            int n2 = this.getBioPolymerCountInModel(i);
            for (int j = 0; j < n2; ++j) {
                Hashtable hashtable3 = this.getPolymerInfo(i, j, bitSet);
                if (hashtable3.isEmpty()) continue;
                vector2.addElement(hashtable3);
            }
            if (vector2.size() <= 0) continue;
            hashtable2.put("modelIndex", new Integer(i));
            hashtable2.put("polymers", vector2);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.modelSet.mmset.getModel(n).getBioPolymer(n2).getLeadMidpoints();
    }

    String getPolymerSequence(int n, int n2) {
        return this.modelSet.mmset.getModel(n).getBioPolymer(n2).getSequence();
    }

    void getPolymerSequenceAtoms(int n, int n2, int n3, int n4, BitSet bitSet, BitSet bitSet2) {
        this.modelSet.mmset.getModel(n).getBioPolymer(n2).getPolymerSequenceAtoms(n, n2, n3, n4, bitSet, bitSet2);
    }

    Hashtable getPolymerInfo(int n, int n2, BitSet bitSet) {
        return this.modelSet.mmset.getModel(n).getBioPolymer(n2).getPolymerInfo(bitSet);
    }

    public void addStateScript(String string) {
        this.modelSet.addStateScript(string);
    }

    public String getState() {
        return this.modelSet.getState(true);
    }

    public String getStructureState() {
        return this.modelSet.getState(false);
    }

    public Hashtable getBoundBoxInfo() {
        Hashtable<String, Tuple3f> hashtable = new Hashtable<String, Tuple3f>();
        hashtable.put("center", this.getBoundBoxCenter());
        hashtable.put("edge", this.getBoundBoxCornerVector());
        return hashtable;
    }

    public void setModelVisibility() {
        if (this.modelSet == null) {
            return;
        }
        this.modelSet.setModelVisibility();
    }

    public boolean checkObjectClicked(int n, int n2, int n3) {
        Shape shape = this.modelSet.getShape(21);
        if (shape != null && shape.checkObjectClicked(n, n2, n3)) {
            return true;
        }
        shape = this.modelSet.getShape(28);
        return shape != null && shape.checkObjectClicked(n, n2, n3);
    }

    public boolean checkObjectHovered(int n, int n2) {
        if (this.modelSet == null) {
            return false;
        }
        Shape shape = this.modelSet.getShape(21);
        if (shape != null && shape.checkObjectHovered(n, n2)) {
            return true;
        }
        shape = this.modelSet.getShape(28);
        if (shape == null || !this.viewer.getDrawHover()) {
            return false;
        }
        return shape.checkObjectHovered(n, n2);
    }

    public void checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        Shape shape;
        for (int i = 0; !(i >= 31 || (shape = this.modelSet.getShape(i)) != null && shape.checkObjectDragged(n, n2, n3, n4, n5)); ++i) {
        }
    }

    public Hashtable getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 31; ++i) {
            String string;
            Shape shape = this.modelSet.getShape(i);
            if (shape == null || "Draw,Dipoles,Isosurface,LcaoOrbital,MolecularOrbital".indexOf(string = JmolConstants.shapeClassBases[i]) < 0) continue;
            Hashtable<String, Vector> hashtable2 = new Hashtable<String, Vector>();
            hashtable2.put("obj", shape.getShapeDetail());
            hashtable.put(string, hashtable2);
        }
        if (stringBuffer.length() > 0) {
            hashtable.put("shapeCommands", stringBuffer.toString());
        }
        return hashtable;
    }

    Point3f getAveragePosition(int n, int n2) {
        return this.modelSet.getAveragePosition(n, n2);
    }

    Vector3f getAtomVector(int n, int n2) {
        return this.modelSet.getAtomVector(n, n2);
    }

    public Vector3f getModelDipole() {
        return this.modelSet.getModelDipole();
    }

    public void getBondDipoles() {
        this.modelSet.getBondDipoles();
    }

    public boolean useXtalDefaults() {
        return this.modelSet.haveSymmetry();
    }

    public BitSet setConformation(int n, BitSet bitSet) {
        this.modelSet.setConformation(n, bitSet);
        return bitSet;
    }

    public BitSet setConformation(int n, int n2) {
        return this.modelSet.setConformation(n, n2);
    }

    public String getAltLocListInModel(int n) {
        if (n < 0) {
            return "";
        }
        return this.modelSet.getAltLocListInModel(n);
    }

    public int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        return this.modelSet.autoHbond(bitSet, bitSet2, bitSet3);
    }

    public boolean hbondsAreVisible(int n) {
        int n2 = this.getBondCount();
        Bond[] bondArray = this.modelSet.getBonds();
        int n3 = n2;
        while (--n3 >= 0) {
            if (n >= 0 && n != bondArray[n3].atom1.modelIndex || !bondArray[n3].isHydrogen() || bondArray[n3].mad <= 0) continue;
            return true;
        }
        return false;
    }

    public void toCartesian(int n, Point3f point3f) {
        this.modelSet.toCartesian(n, point3f);
    }

    public void toUnitCell(int n, Point3f point3f, Point3f point3f2) {
        this.modelSet.toUnitCell(n, point3f, point3f2);
    }

    public void toFractional(int n, Point3f point3f) {
        this.modelSet.toFractional(n, point3f);
    }

    public void clearBfactorRange() {
        this.modelSet.clearBfactorRange();
    }

    public void setZeroBased() {
        this.modelSet.setZeroBased();
    }

    public void setTrajectory(int n) {
        this.modelSet.setTrajectory(n);
    }

    public int getTrajectoryCount() {
        return this.modelSet.getTrajectoryCount();
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoord(n, f, f2, f3);
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoordRelative(n, f, f2, f3);
    }

    public void setAtomCoordRelative(Point3f point3f, BitSet bitSet) {
        this.modelSet.setAtomCoordRelative(bitSet, point3f.x, point3f.y, point3f.z);
    }

    public void invertSelected(Point3f point3f, Point4f point4f, BitSet bitSet) {
        this.modelSet.invertSelected(point3f, point4f, bitSet);
    }

    public void rotateSelected(Matrix3f matrix3f, Matrix3f matrix3f2, BitSet bitSet, boolean bl, boolean bl2) {
        this.modelSet.rotateSelected(matrix3f, matrix3f2, bitSet, bl, bl2);
    }

    public String getHybridizationAndAxes(int n, Vector3f vector3f, Vector3f vector3f2, String string, boolean bl) {
        return this.modelSet.getHybridizationAndAxes(n, vector3f, vector3f2, string, bl);
    }

    public String getUnitCellInfoText() {
        int n = this.viewer.getCurrentModelIndex();
        if (n < 0) {
            return "no single current model";
        }
        if (this.modelSet.cellInfos == null) {
            return "not applicable";
        }
        return this.modelSet.cellInfos[n].getUnitCellInfo();
    }

    public String getSpaceGroupInfoText(String string) {
        SpaceGroup spaceGroup;
        String string2 = "";
        int n = this.viewer.getCurrentModelIndex();
        if (string == null) {
            if (n < 0) {
                return "no single current model";
            }
            if (this.modelSet.cellInfos == null) {
                return "not applicable";
            }
            CellInfo cellInfo = this.modelSet.cellInfos[n];
            string = cellInfo.spaceGroup;
            if (string.indexOf("[") >= 0) {
                string = string.substring(0, string.indexOf("[")).trim();
            }
            if (string == "spacegroup unspecified") {
                return "no space group identified in file";
            }
            spaceGroup = SpaceGroup.determineSpaceGroup(string, cellInfo.getNotionalUnitCell());
            string2 = "\nSymmetry operations employed:" + this.modelSet.getModelSymmetryList(n);
        } else {
            if (string.equalsIgnoreCase("ALL")) {
                return SpaceGroup.dumpAll();
            }
            spaceGroup = SpaceGroup.determineSpaceGroup(string);
            if (spaceGroup == null) {
                spaceGroup = SpaceGroup.createSpaceGroup(string, false);
            }
        }
        if (spaceGroup == null) {
            return "could not identify space group from name: " + string;
        }
        return spaceGroup.dumpInfo() + string2;
    }

    public int getSpaceGroupIndexFromName(String string) {
        return SpaceGroup.determineSpaceGroupIndex(string);
    }

    public void setSelectionHaloEnabled(boolean bl) {
        this.modelSet.setSelectionHaloEnabled(bl);
    }

    public boolean getSelectionHaloEnabled() {
        return this.modelSet.getSelectionHaloEnabled();
    }

    public void calculateStructures(int n) {
        int n2 = this.modelSet.getModelCount();
        BitSet bitSet = new BitSet(n2);
        for (int i = 0; i < n2; ++i) {
            if (n < 0 || i == n) continue;
            bitSet.set(i);
        }
        this.modelSet.calculateStructuresAllExcept(bitSet);
    }

    public boolean getEchoStateActive() {
        return this.modelSet.getEchoStateActive();
    }

    public void setEchoStateActive(boolean bl) {
        this.modelSet.setEchoStateActive(bl);
    }

    public boolean havePartialCharges() {
        return this.modelSet.getPartialCharges() != null;
    }

    public void setFormalCharges(BitSet bitSet, int n) {
        this.modelSet.setFormalCharges(bitSet, n);
    }

    public UnitCell getUnitCell(int n) {
        if (n < 0) {
            return null;
        }
        return this.modelSet.cellInfos == null ? null : this.modelSet.cellInfos[n].getUnitCell();
    }

    public Point3f getUnitCellOffset(int n) {
        UnitCell unitCell = this.getUnitCell(n);
        if (unitCell == null) {
            return null;
        }
        return unitCell.getCartesianOffset();
    }

    public boolean setUnitCellOffset(int n, Point3f point3f) {
        UnitCell unitCell = this.getUnitCell(n);
        if (unitCell == null) {
            return false;
        }
        unitCell.setOffset(point3f);
        return true;
    }

    public boolean setUnitCellOffset(int n, int n2) {
        UnitCell unitCell = this.getUnitCell(n);
        if (unitCell == null) {
            return false;
        }
        unitCell.setOffset(n2);
        return true;
    }

    public BitSet getTaintedAtoms() {
        return this.modelSet.getTaintedAtoms();
    }

    public void setTaintedAtoms(BitSet bitSet) {
        this.modelSet.setTaintedAtoms(bitSet);
    }

    public Point3f[] calculateSurface(BitSet bitSet, BitSet bitSet2, float f) {
        return this.modelSet.calculateSurface(bitSet, bitSet2, f);
    }

    public AtomIterator getWithinModelIterator(Atom atom, float f) {
        return this.modelSet.getWithinModelIterator(atom, f);
    }

    public AtomIndexIterator getWithinAtomSetIterator(int n, float f, BitSet bitSet, boolean bl, boolean bl2) {
        return this.modelSet.getWithinAtomSetIterator(n, f, bitSet, bl, bl2);
    }

    public void fillAtomData(AtomData atomData, int n) {
        this.modelSet.fillAtomData(atomData, n);
    }

    public float[] getPartialCharges() {
        return this.modelSet.getPartialCharges();
    }

    public void setProteinType(BitSet bitSet, byte by) {
        this.modelSet.setProteinType(bitSet, by);
    }
}

