/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.MeshFileCollection;
import org.jmol.shapespecial.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class Isosurface
extends MeshFileCollection
implements MeshDataServer {
    IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    IsosurfaceMesh thisMesh;
    boolean logMessages;
    int lighting;
    private BitSet bsSelected;
    private BitSet bsIgnore;
    private boolean iHaveBitSets;
    private int modelIndex;
    private int atomIndex;
    private int moNumber;
    private short defaultColix;
    private Point3f center;
    private boolean isPhaseColored;
    protected SurfaceGenerator sg;
    private JvxlData jvxlData;
    private ColorEncoder colorEncoder = new ColorEncoder();
    int indexColorPositive;
    int indexColorNegative;
    int nLCAO = 0;
    Point4f lcaoDir = new Point4f();
    private boolean associateNormals;

    public void allocMesh(String string) {
        this.isomeshes = (IsosurfaceMesh[])ArrayUtil.ensureLength(this.isomeshes, this.meshCount + 1);
        this.meshes = this.isomeshes;
        IsosurfaceMesh isosurfaceMesh = new IsosurfaceMesh(string, this.g3d, this.colix);
        this.isomeshes[this.meshCount++] = isosurfaceMesh;
        this.thisMesh = isosurfaceMesh;
        this.currentMesh = isosurfaceMesh;
        this.jvxlData = this.thisMesh.jvxlData;
        this.sg.setJvxlData(this.jvxlData);
    }

    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.viewer, this, this.colorEncoder, null, this.jvxlData);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.isActiveLevel(0)) {
            Logger.debug("Isosurface state=" + this.sg.getState() + " setProperty: " + string + " = " + object);
        }
        if ("delete" == string) {
            this.setPropertySuper(string, object, bitSet);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            return;
        }
        if ("thisID" == string) {
            this.setPropertySuper("thisID", object, null);
            return;
        }
        if ("map" == string) {
            return;
        }
        if ("color" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.vertexColixes = null;
                this.thisMesh.isColorSolid = true;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.isomeshes[n].vertexColixes = null;
                    this.isomeshes[n].isColorSolid = true;
                }
            }
            this.setPropertySuper(string, object, bitSet);
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.setModelIndex();
            return;
        }
        if ("modelIndex" == string) {
            this.modelIndex = (Integer)object;
            this.sg.setModelIndex(this.modelIndex);
            return;
        }
        if ("lcaoCartoon" == string) {
            Vector3f[] vector3fArray = (Vector3f[])object;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (this.sg.setParameter("lcaoCartoon", object)) {
                return;
            }
            this.drawLcaoCartoon(vector3fArray[0], vector3fArray[1]);
            return;
        }
        if ("debug" == string) {
            this.logMessages = (Boolean)object;
        }
        if ("title" == string) {
            if (object instanceof String && "-".equals((String)object)) {
                object = null;
            }
            this.setPropertySuper(string, object, bitSet);
            this.sg.setParameter("title", this.title, bitSet);
            return;
        }
        if ("select" == string && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == string && this.iHaveBitSets) {
            return;
        }
        if ("atomIndex" == string) {
            this.atomIndex = (Integer)object;
        }
        if ("pocket" == string) {
            Boolean bl = (Boolean)object;
            int n = this.lighting = bl != false ? 2 : 0;
        }
        if ("colorRGB" == string) {
            int n = (Integer)object;
            this.defaultColix = Graphics3D.getColix(n);
        }
        if ("molecularOrbital" == string) {
            this.moNumber = (Integer)object;
        }
        if ("center" == string) {
            this.center.set((Point3f)object);
        }
        if ("phase" == string) {
            this.isPhaseColored = true;
        }
        if (this.sg.setParameter(string, object, bitSet)) {
            return;
        }
        if ("init" == string) {
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            this.script = (String)object;
            this.iHaveBitSets = this.getScriptBitSets(this.script);
            if (!this.iHaveBitSets) {
                this.sg.setParameter("select", bitSet);
            } else {
                this.sg.setParameter("select", this.bsSelected);
                this.sg.setParameter("ignore", this.bsIgnore);
            }
            this.initializeIsosurface();
            this.sg.setModelIndex(this.modelIndex);
            return;
        }
        if ("clear" == string) {
            this.discardTempData(true);
            return;
        }
        this.setPropertySuper(string, object, bitSet);
    }

    void setPropertySuper(String string, Object object, BitSet bitSet) {
        this.currentMesh = this.thisMesh;
        super.setProperty(string, object, bitSet);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
    }

    public Object getProperty(String string, int n) {
        if (string == "list") {
            return super.getProperty(string, n);
        }
        if (string == "moNumber") {
            return new Integer(this.moNumber);
        }
        if (this.thisMesh == null) {
            return "no current isosurface";
        }
        if (string == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (string == "jvxlFileData") {
            return JvxlReader.jvxlGetFile(this.jvxlData, this.title, "", true, n, this.thisMesh.getState(this.myType), this.shortScript());
        }
        if (string == "jvxlSurfaceData") {
            return JvxlReader.jvxlGetFile(this.jvxlData, this.title, "", false, 1, this.thisMesh.getState(this.myType), this.shortScript());
        }
        return super.getProperty(string, n);
    }

    String shortScript() {
        return this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand.substring(0, (this.thisMesh.scriptCommand + ";").indexOf(";"));
    }

    boolean getScriptBitSets(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf("# ({");
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf("})", n);
        this.bsSelected = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
        n = string.indexOf("({", n2);
        if (n < 0) {
            return false;
        }
        n2 = string.indexOf("})", n);
        this.bsIgnore = Escape.unescapeBitset(string.substring(n + 1, n2 + 1));
        return true;
    }

    String fixScript(String string, BitSet bitSet, BitSet bitSet2) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("# ({") >= 0) {
            return string;
        }
        if (string.charAt(0) == ' ') {
            return this.myType + " " + this.thisMesh.thisID + string;
        }
        if (!this.sg.getIUseBitSets()) {
            return string;
        }
        return string + "# " + (bitSet == null ? "({null})" : Escape.escape(bitSet)) + " " + (bitSet2 == null ? "({null})" : Escape.escape(bitSet2));
    }

    void initializeIsosurface() {
        this.lighting = 0;
        this.modelIndex = this.viewer.getCurrentModelIndex();
        boolean bl = this.isFixed = this.modelIndex < 0;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.title = null;
        this.atomIndex = -1;
        this.colix = (short)5;
        this.defaultColix = 0;
        this.bsIgnore = null;
        this.isPhaseColored = false;
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.initState();
    }

    void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    void checkFlags() {
        if (this.viewer.getTestFlag2()) {
            this.associateNormals = false;
        }
        if (this.logMessages) {
            Logger.debug("Isosurface using testflag2: no associative grouping = " + !this.associateNormals);
            Logger.debug("IsosurfaceRenderer using testflag3: separated triangles = " + this.viewer.getTestFlag3());
            Logger.debug("IsosurfaceRenderer using testflag4: show vertex normals = " + this.viewer.getTestFlag4());
            Logger.debug("For grid points, use: isosurface delete myiso gridpoints \"\"");
        }
    }

    void setRendering(String string) {
        this.line = string.toLowerCase();
        String[] stringArray = this.getTokens();
        for (int i = 1; i < stringArray.length; ++i) {
            super.setProperty(stringArray[i].intern(), Boolean.TRUE, null);
        }
    }

    void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    short getDefaultColix() {
        int n;
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.isCubeData()) {
            return this.colix;
        }
        if (this.sg.getCutoff() >= 0.0f) {
            this.indexColorPositive %= JmolConstants.argbsIsosurfacePositive.length;
            n = JmolConstants.argbsIsosurfacePositive[this.indexColorPositive++];
        } else {
            this.indexColorNegative %= JmolConstants.argbsIsosurfaceNegative.length;
            n = JmolConstants.argbsIsosurfaceNegative[this.indexColorNegative++];
        }
        return Graphics3D.getColix(n);
    }

    void drawLcaoCartoon(Vector3f vector3f, Vector3f vector3f2) {
        String string;
        boolean bl;
        String string2 = this.sg.setLcao();
        this.defaultColix = Graphics3D.getColix(this.sg.getColor(1));
        int n = this.sg.getColor(-1);
        Vector3f vector3f3 = new Vector3f();
        boolean bl2 = bl = string2.length() > 0 && string2.charAt(0) == '-';
        if (bl) {
            string2 = string2.substring(1);
        }
        int n2 = bl ? -1 : 1;
        vector3f3.cross(vector3f, vector3f2);
        String string3 = string = this.thisMesh == null ? "lcao" + ++this.nLCAO + "_" + string2 : this.thisMesh.thisID;
        if (this.thisMesh == null) {
            this.allocMesh(string);
        }
        if (string2.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            this.createLcaoLobe(vector3f2, n2);
            this.setProperty("thisID", string + "b", null);
            this.createLcaoLobe(vector3f2, -n2);
            this.thisMesh.colix = Graphics3D.getColix(n);
            return;
        }
        if (string2.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            this.createLcaoLobe(vector3f3, n2);
            this.setProperty("thisID", string + "b", null);
            this.createLcaoLobe(vector3f3, -n2);
            this.thisMesh.colix = Graphics3D.getColix(n);
            return;
        }
        if (string2.equals("pz")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            this.createLcaoLobe(vector3f, n2);
            this.setProperty("thisID", string + "b", null);
            this.createLcaoLobe(vector3f, -n2);
            this.thisMesh.colix = Graphics3D.getColix(n);
            return;
        }
        if (string2.equals("pxa")) {
            this.createLcaoLobe(vector3f2, n2);
            return;
        }
        if (string2.equals("pxb")) {
            this.createLcaoLobe(vector3f2, -n2);
            return;
        }
        if (string2.equals("pya")) {
            this.createLcaoLobe(vector3f3, n2);
            return;
        }
        if (string2.equals("pyb")) {
            this.createLcaoLobe(vector3f3, -n2);
            return;
        }
        if (string2.equals("pza")) {
            this.createLcaoLobe(vector3f, n2);
            return;
        }
        if (string2.equals("pzb")) {
            this.createLcaoLobe(vector3f, -n2);
            return;
        }
        if (string2.indexOf("sp") == 0 || string2.indexOf("lp") == 0) {
            this.createLcaoLobe(vector3f, n2);
            return;
        }
        this.createLcaoLobe(null, 1.0f);
    }

    void createLcaoLobe(Vector3f vector3f, float f) {
        this.initState();
        if (Logger.isActiveLevel(0)) {
            Logger.debug("creating isosurface " + this.thisMesh.thisID);
        }
        this.thisMesh.colix = this.defaultColix;
        if (vector3f == null) {
            this.setProperty("sphere", new Float(f / 2.0f), null);
            return;
        }
        this.lcaoDir.x = vector3f.x * f;
        this.lcaoDir.y = vector3f.y * f;
        this.lcaoDir.z = vector3f.z * f;
        this.lcaoDir.w = 0.7f;
        this.setProperty("lobe", this.lcaoDir, null);
    }

    public void invalidateTriangles() {
        this.thisMesh.invalidateTriangles();
    }

    public void fillMeshData(MeshData meshData, int n) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null);
            }
            this.thisMesh.clear("isosurface", this.sg.getIAddGridPoints(), this.thisMesh.showTriangles);
            this.thisMesh.colix = this.getDefaultColix();
            if (this.isPhaseColored) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        switch (n) {
            case 1: {
                meshData.vertices = this.thisMesh.vertices;
                meshData.vertexValues = this.thisMesh.vertexValues;
                meshData.vertexCount = this.thisMesh.vertexCount;
                meshData.vertexIncrement = this.thisMesh.vertexIncrement;
                meshData.polygonCount = this.thisMesh.polygonCount;
                meshData.polygonIndexes = this.thisMesh.polygonIndexes;
                return;
            }
            case 2: {
                if (this.thisMesh.vertexColixes == null || this.thisMesh.vertexCount > this.thisMesh.vertexColixes.length) {
                    this.thisMesh.vertexColixes = new short[this.thisMesh.vertexCount];
                }
                meshData.vertexColixes = this.thisMesh.vertexColixes;
                return;
            }
            case 3: {
                this.thisMesh.surfaceSet = meshData.surfaceSet;
                this.thisMesh.vertexSets = meshData.vertexSets;
                this.thisMesh.nSets = meshData.nSets;
                return;
            }
        }
    }

    public void notifySurfaceGenerationCompleted() {
        this.setModelIndex();
        this.thisMesh.initialize(this.sg.getPlane() != null ? 2 : this.lighting);
        this.setScriptInfo();
        this.setJvxlInfo();
    }

    public void notifySurfaceMappingCompleted() {
        this.setModelIndex();
        this.setScriptInfo();
        this.setJvxlInfo();
    }

    public Point3f[] calculateGeodesicSurface(BitSet bitSet, BitSet bitSet2, float f) {
        return this.viewer.calculateSurface(bitSet, bitSet2, f);
    }

    public int getSurfacePointIndex(float f, boolean bl, int n, int n2, int n3, Point3i point3i, int n4, int n5, float f2, float f3, Point3f point3f, Vector3f vector3f, boolean bl2) {
        return 0;
    }

    public int addVertexCopy(Point3f point3f, float f, int n) {
        return this.thisMesh.addVertexCopy(point3f, f, n, this.associateNormals);
    }

    public void addTriangleCheck(int n, int n2, int n3, int n4, boolean bl) {
        if (bl && !MeshData.checkCutoff(n, n2, n3, this.thisMesh.vertexValues)) {
            return;
        }
        this.thisMesh.addTriangleCheck(n, n2, n3, n4);
    }

    private void setModelIndex() {
        this.setModelIndex(this.atomIndex, this.modelIndex);
        this.thisMesh.ptCenter.set(this.center);
    }

    private void setScriptInfo() {
        this.thisMesh.title = this.sg.getTitle();
        this.thisMesh.scriptCommand = this.fixScript(this.sg.getScript(), this.sg.getBsSelected(), this.sg.getBsIgnore());
    }

    private void setJvxlInfo() {
        this.jvxlData.jvxlDefinitionLine = JvxlReader.jvxlGetDefinitionLine(this.jvxlData, false);
        this.jvxlData.jvxlInfoLine = JvxlReader.jvxlGetDefinitionLine(this.jvxlData, true);
    }

    public Vector getShapeDetail() {
        Vector vector = new Vector();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh == null) continue;
            hashtable.put("ID", isosurfaceMesh.thisID == null ? "<noid>" : isosurfaceMesh.thisID);
            hashtable.put("vertexCount", new Integer(isosurfaceMesh.vertexCount));
            if (isosurfaceMesh.ptCenter.x != Float.MAX_VALUE) {
                hashtable.put("center", isosurfaceMesh.ptCenter);
            }
            if (isosurfaceMesh.jvxlData.jvxlDefinitionLine != null) {
                hashtable.put("jvxlDefinitionLine", isosurfaceMesh.jvxlData.jvxlDefinitionLine);
            }
            hashtable.put("modelIndex", new Integer(isosurfaceMesh.modelIndex));
            if (isosurfaceMesh.title != null) {
                hashtable.put("title", isosurfaceMesh.title);
            }
            vector.addElement(hashtable);
        }
        return vector;
    }
}

