/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.Eval;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Compiler {
    private Viewer viewer;
    private String filename;
    private String script;
    private short[] lineNumbers;
    private int[] lineIndices;
    private Token[][] aatokenCompiled;
    private String errorMessage;
    private String errorLine;
    private boolean preDefining;
    private boolean isSilent;
    private boolean isShowScriptOutput;
    private boolean logMessages = false;
    private int cchScript;
    private short lineCurrent;
    private int ichToken;
    private int cchToken;
    private int iCommand;
    private int ichCurrentCommand;
    private boolean isNewSet;
    private boolean iHaveQuotedString = false;
    private Vector ltoken;
    private Token lastToken;
    private boolean isShowCommand;
    static String[] loadFormats = new String[]{"append", "files", "trajectory", "alchemy", "mol2", "mopac", "nmrpdb", "charmm", "xyz", "mdl", "pdb"};
    boolean isSetOrIf;
    boolean isSetOrDefine;
    Token tokenCommand;
    int tokCommand;
    Vector ltokenPostfix = null;
    Token[] atokenInfix;
    int itokenInfix;
    boolean isEmbeddedExpression;
    boolean isCommaAsOrAllowed;
    Token theToken;
    Object theValue;
    boolean haveString;
    private boolean residueSpecCodeGenerated;

    Compiler(Viewer viewer) {
        this.viewer = viewer;
    }

    boolean compile(String string, String string2, boolean bl, boolean bl2) {
        this.filename = string;
        this.isSilent = bl2;
        this.script = Compiler.cleanScriptComments(string2);
        this.logMessages = !bl2 && !bl && Logger.isActiveLevel(0);
        this.lineNumbers = null;
        this.lineIndices = null;
        this.aatokenCompiled = null;
        this.errorLine = null;
        this.errorMessage = null;
        this.preDefining = string == "#predefine";
        return this.compile0() ? true : this.handleError();
    }

    String getScript() {
        return this.script;
    }

    short[] getLineNumbers() {
        return this.lineNumbers;
    }

    int[] getLineIndices() {
        return this.lineIndices;
    }

    Token[][] getAatokenCompiled() {
        return this.aatokenCompiled;
    }

    static boolean tokAttr(int n, int n2) {
        return (n & n2) == n2;
    }

    static boolean tokAttrOr(int n, int n2, int n3) {
        return (n & n2) == n2 || (n & n3) == n3;
    }

    static int modelValue(String string) {
        int n = string.indexOf(".");
        if (n < 1 || string.charAt(0) == '-') {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        if (n > 0 && (n2 = Integer.parseInt(string.substring(0, n))) < 0) {
            n2 = -n2;
        }
        if (n < string.length() - 1) {
            try {
                n3 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2 * 1000000 + n3;
    }

    private void log(String string) {
        if (this.logMessages) {
            Logger.debug(string);
        }
    }

    private static String cleanScriptComments(String string) {
        int n;
        int n2;
        while ((n2 = string.indexOf("/**")) >= 0 && (n = string.indexOf("**/", n2 + 3)) >= 0) {
            string = string.substring(0, n2) + string.substring(n + 3);
        }
        while ((n2 = string.indexOf("/*")) >= 0 && (n = string.indexOf("*/", n2 + 2)) >= 0) {
            string = string.substring(0, n2) + string.substring(n + 2);
        }
        return string;
    }

    private void addTokenToPrefix(Token token) {
        this.ltoken.addElement(token);
        this.lastToken = token;
    }

    /*
     * Unable to fully structure code
     */
    private boolean compile0() {
        this.cchScript = this.script.length();
        this.ichToken = 0;
        this.lineCurrent = 1;
        this.iCommand = 0;
        var1_1 = 8;
        this.lineNumbers = new short[var1_1];
        this.lineIndices = new int[var1_1];
        this.isNewSet = false;
        this.isShowScriptOutput = false;
        var2_2 = new Vector<Token[]>();
        this.ltoken = new Vector<E>();
        var3_3 = 0;
        this.isNewSet = false;
        while (true) {
            block47: {
                block63: {
                    block50: {
                        block62: {
                            block61: {
                                block60: {
                                    block59: {
                                        block58: {
                                            block56: {
                                                block57: {
                                                    block55: {
                                                        block53: {
                                                            block54: {
                                                                block52: {
                                                                    block51: {
                                                                        block49: {
                                                                            block48: {
                                                                                var4_4 = this.ltoken.size();
                                                                                if (this.lookingAtLeadingWhitespace()) break block47;
                                                                                if (var4_4 == 0) {
                                                                                    this.ichCurrentCommand = this.ichToken;
                                                                                }
                                                                                if (this.lookingAtComment()) break block47;
                                                                                var5_5 = this.lookingAtEndOfLine();
                                                                                if (!var5_5 && !this.lookingAtEndOfStatement()) break block48;
                                                                                if (var4_4 > 0) {
                                                                                    if (!this.compileCommand()) {
                                                                                        return false;
                                                                                    }
                                                                                    this.iCommand = var2_2.size();
                                                                                    if (this.iCommand == var1_1) {
                                                                                        var6_6 = new short[var1_1 * 2];
                                                                                        System.arraycopy(this.lineNumbers, 0, var6_6, 0, var1_1);
                                                                                        this.lineNumbers = var6_6;
                                                                                        var7_15 = new int[var1_1 * 2];
                                                                                        System.arraycopy(this.lineIndices, 0, var7_15, 0, var1_1);
                                                                                        this.lineIndices = var7_15;
                                                                                        var1_1 *= 2;
                                                                                    }
                                                                                    this.lineNumbers[this.iCommand] = this.lineCurrent;
                                                                                    this.lineIndices[this.iCommand] = this.ichCurrentCommand;
                                                                                    var2_2.addElement(this.atokenInfix);
                                                                                    this.ltoken.setSize(0);
                                                                                    var4_4 = 0;
                                                                                    var3_3 = 0;
                                                                                    this.iHaveQuotedString = false;
                                                                                }
                                                                                if (this.ichToken >= this.cchScript) break;
                                                                                if (var5_5) {
                                                                                    this.lineCurrent = (short)(this.lineCurrent + 1);
                                                                                }
                                                                                break block47;
                                                                            }
                                                                            if (var4_4 != 0) break block49;
                                                                            this.isNewSet = false;
                                                                            break block50;
                                                                        }
                                                                        if (var4_4 != 1 || this.script.charAt(this.ichToken) != '=' || !Compiler.tokAttr(var3_3, 8192)) break block51;
                                                                        this.tokenCommand = Token.getTokenFromName("set");
                                                                        var3_3 = 21791;
                                                                        this.ltoken.insertElementAt(this.tokenCommand, 0);
                                                                        this.cchToken = 1;
                                                                        break block47;
                                                                    }
                                                                    if (!this.lookingAtString()) break block52;
                                                                    if (this.cchToken < 0) {
                                                                        return this.endOfCommandUnexpected();
                                                                    }
                                                                    var6_7 = (var3_3 == 2167051 || var3_3 == 2162957) && this.iHaveQuotedString == false ? this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1) : this.getUnescapedStringLiteral();
                                                                    this.addTokenToPrefix(new Token(4, var6_7));
                                                                    this.iHaveQuotedString = true;
                                                                    if (var3_3 == 0x210112 && var6_7.indexOf("@") < 0) {
                                                                        this.getData(var6_7);
                                                                    }
                                                                    break block47;
                                                                }
                                                                if (var3_3 != 2167051) break block53;
                                                                if (!this.lookingAtLoadFormat()) break block54;
                                                                var6_8 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                                                if ((var6_8 = var6_8.toLowerCase()).equals("append") || var6_8.equals("files")) {
                                                                    this.addTokenToPrefix(new Token(1, var6_8));
                                                                } else if (var6_8.equals("trajectory")) {
                                                                    this.addTokenToPrefix(new Token(334));
                                                                } else if (var6_8.indexOf("=") == 0) {
                                                                    this.addTokenToPrefix(new Token(4, var6_8));
                                                                }
                                                                break block47;
                                                            }
                                                            if (this.iHaveQuotedString || !this.lookingAtSpecialString()) break block53;
                                                            var6_9 = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                            var7_16 = var6_9.indexOf(" ");
                                                            if (var7_16 > 0) {
                                                                this.cchToken = var7_16;
                                                                var6_9 = var6_9.substring(0, var7_16);
                                                            }
                                                            this.addTokenToPrefix(new Token(4, var6_9));
                                                            this.iHaveQuotedString = true;
                                                            break block47;
                                                        }
                                                        if (var3_3 != 2162957 || this.iHaveQuotedString || !this.lookingAtSpecialString()) break block55;
                                                        var6_10 = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                        var7_17 = var6_10.indexOf(" ");
                                                        if (var7_17 > 0) {
                                                            this.cchToken = var7_17;
                                                            var6_10 = var6_10.substring(0, var7_17);
                                                        }
                                                        this.addTokenToPrefix(new Token(4, var6_10));
                                                        this.iHaveQuotedString = true;
                                                        break block47;
                                                    }
                                                    if (var3_3 != 301) break block56;
                                                    var6_11 = this.cchToken;
                                                    if (var4_4 <= 2 || this.iHaveQuotedString || !this.lookingAtSpecialString()) break block56;
                                                    var7_18 = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                    if (var7_18.indexOf(" ") >= 0) break block57;
                                                    this.addTokenToPrefix(new Token(4, var7_18));
                                                    this.iHaveQuotedString = true;
                                                    break block47;
                                                }
                                                this.cchToken = var6_11;
                                            }
                                            if (var3_3 == 2162957 && this.iHaveQuotedString || !Compiler.tokAttr(var3_3, 2048) || !this.lookingAtSpecialString()) break block58;
                                            var6_12 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                            this.addTokenToPrefix(new Token(4, var6_12));
                                            break block47;
                                        }
                                        var6_13 = this.lookingAtExponential();
                                        if (Float.isNaN(var6_13)) break block59;
                                        this.addTokenToPrefix(new Token(3, new Float(var6_13)));
                                        break block47;
                                    }
                                    if (!this.lookingAtDecimal()) break block60;
                                    var6_13 = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
                                    var7_19 = Compiler.modelValue(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
                                    this.ltoken.addElement(new Token(3, var7_19, new Float(var6_13)));
                                    break block47;
                                }
                                if (!this.lookingAtSeqcode()) break block61;
                                var7_20 = this.script.charAt(this.ichToken);
                                var8_24 = var7_20 == '*' || var7_20 == '^' ? 0 : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                                var9_29 = this.script.charAt(this.ichToken + this.cchToken - 1);
                                if (var9_29 == '^') {
                                    var9_29 = ' ';
                                }
                                var10_30 = Group.getSeqcode(var8_24, var9_29);
                                this.addTokenToPrefix(new Token(5, var10_30, "seqcode"));
                                break block47;
                            }
                            if (!this.lookingAtInteger(Compiler.tokAttr(var3_3, 4096))) break block62;
                            var7_21 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                            var8_25 = Integer.parseInt(var7_21);
                            this.addTokenToPrefix(new Token(2, var8_25, var7_21));
                            break block47;
                        }
                        if (Compiler.tokenAttr(this.lastToken, 0x210000)) break block50;
                        var7_22 = this.script.charAt(this.ichToken) == '[';
                        var8_26 = this.lookingAtBitset();
                        if (var8_26 == null) break block50;
                        if (var7_22) {
                            this.addTokenToPrefix(new Token(32839, new Bond.BondSet(var8_26)));
                        } else {
                            this.addTokenToPrefix(new Token(32839, var8_26));
                        }
                        break block47;
                    }
                    if (!this.lookingAtLookupToken()) break block63;
                    var6_14 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    if (var6_14.length() == 1) {
                        var7_23 = (Token)Token.map.get(var6_14);
                        if (var7_23 == null && (var7_23 = (Token)Token.map.get(var8_27 = var6_14.toLowerCase())) != null) {
                            var7_23 = new Token(var7_23.tok, var7_23.intValue, var6_14);
                        }
                    } else {
                        var6_14 = var6_14.toLowerCase();
                        var7_23 = (Token)Token.map.get(var6_14);
                    }
                    if (var7_23 == null) {
                        var7_23 = var6_14.indexOf("property_") == 0 ? new Token(860169, var6_14.toLowerCase()) : new Token(1, var6_14);
                    }
                    var8_28 = var7_23.tok;
                    switch (var3_3) {
                        case 0: {
                            this.ichCurrentCommand = this.ichToken;
                            var3_3 = var8_28;
                            if (!Compiler.tokAttr(var3_3, 256)) {
                                if (!Compiler.tokAttr(var8_28, 1) && !Compiler.tokAttr(var8_28, 8192)) {
                                    return this.commandExpected();
                                }
                                var3_3 = 21791;
                                this.isNewSet = true;
                            }
                            ** GOTO lbl215
                        }
                        case 21791: {
                            if (var4_4 == 1) {
                                if (var8_28 == 5308460) {
                                    var7_23 = (Token)this.ltoken.get(0);
                                    this.ltoken.removeElementAt(0);
                                    this.ltoken.addElement(Token.getTokenFromName("set"));
                                    var8_28 = var7_23.tok;
                                    var3_3 = 21791;
                                }
                                if (var8_28 != 1 && !Compiler.tokAttr(var8_28, 8192)) {
                                    return this.isNewSet != false ? this.commandExpected() : this.unrecognizedParameter("SET", var6_14);
                                }
                            }
                            ** GOTO lbl215
                        }
                        case 74505: {
                            if (var4_4 == 1) {
                                if (var8_28 != 1) {
                                    if (this.preDefining) {
                                        if (!Compiler.tokAttr(var8_28, 196608)) {
                                            return this.compileError("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + var6_14);
                                        }
                                    } else if (Compiler.tokAttr(var8_28, 196608)) {
                                        Logger.warn("WARNING: predefined term '" + var6_14 + "' has been redefined by the user until the next file load.");
                                    } else {
                                        Logger.warn("WARNING: redefining " + var6_14 + "; was " + var7_23 + "not all commands may continue to be functional for the life of the applet!");
                                        var7_23.tok = 1;
                                        var8_28 = 1;
                                        Token.map.put(var6_14, var7_23);
                                    }
                                }
                            } else {
                                if (var4_4 == 2 && var8_28 == 5308460) {
                                    this.ltoken.insertElementAt(Token.getTokenFromName("set"), 0);
                                    break;
                                }
                                if (var8_28 != 1 && var8_28 != 21791 && !Compiler.tokAttr(var8_28, 65536)) {
                                    return this.invalidExpressionToken(var6_14);
                                }
                            }
                            ** GOTO lbl215
                        }
                        case 772: {
                            if (var8_28 != 1 && var8_28 != 65541 && !Compiler.tokAttr(var8_28, 65536)) {
                                return this.invalidExpressionToken(var6_14);
                            }
                            ** GOTO lbl215
                        }
                        case 793: 
                        case 798: 
                        case 847: 
                        case 9067: {
                            if (var8_28 != 1 && !Compiler.tokAttr(var8_28, 65536)) {
                                return this.invalidExpressionToken(var6_14);
                            }
                        }
lbl215:
                        // 10 sources

                        default: {
                            this.addTokenToPrefix(var7_23);
                            break;
                        }
                    }
                    break block47;
                }
                if (var4_4 == 0 || this.isNewSet && var4_4 == 1) {
                    return this.commandExpected();
                }
                return this.unrecognizedToken(this.script);
            }
            this.ichToken += this.cchToken;
        }
        this.aatokenCompiled = new Token[var2_2.size()][];
        var2_2.copyInto((Object[])this.aatokenCompiled);
        return true;
    }

    private void getData(String string) {
        int n;
        this.ichToken += string.length() + 2;
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\r') {
            ++this.ichToken;
        }
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\n') {
            ++this.ichToken;
        }
        if ((n = this.script.indexOf("end \"" + string + "\"", this.ichToken)) < 0) {
            n = this.script.length();
        }
        String string2 = this.script.substring(this.ichToken, n);
        this.addTokenToPrefix(new Token(0x210112, string2));
        this.addTokenToPrefix(new Token(1, "end"));
        this.addTokenToPrefix(new Token(4, string));
        this.cchToken = n - this.ichToken + 6 + string.length();
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private static boolean eol(char c) {
        return c == ';' || c == '\r' || c == '\n';
    }

    private boolean lookingAtLeadingWhitespace() {
        int n;
        for (n = this.ichToken; n < this.cchScript && Compiler.isSpaceOrTab(this.script.charAt(n)); ++n) {
        }
        this.cchToken = n - this.ichToken;
        return this.cchToken > 0;
    }

    private boolean lookingAtComment() {
        int n;
        int n2 = 88;
        int n3 = -1;
        if (this.ichToken == this.ichCurrentCommand && this.ichToken < this.cchScript && this.script.charAt(this.ichToken) == '$') {
            this.isShowScriptOutput = true;
            for (n = this.ichToken; n2 != 93 && n < this.cchScript; ++n) {
                char c = this.script.charAt(n);
                n2 = c;
                if (Compiler.eol(c)) break;
            }
            this.cchToken = n - this.ichToken;
            this.isShowCommand = true;
            return true;
        }
        if (this.isShowScriptOutput) {
            if (!this.isShowCommand) {
                n3 = this.ichToken;
            }
            if (this.ichToken >= this.cchScript || Compiler.eol(this.script.charAt(this.ichToken))) {
                this.isShowCommand = false;
                return false;
            }
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n2 = c;
            if (Compiler.eol(c)) break;
            if (n2 == 35 && n3 == -1) {
                n3 = n;
            }
            ++n;
        }
        if (n3 == -1) {
            return false;
        }
        if (this.cchScript - n3 >= 3 && this.script.charAt(n3 + 1) == 'j' && this.script.charAt(n3 + 2) == 'c') {
            this.cchToken = n - this.ichToken;
            return true;
        }
        if (n3 != this.ichToken) {
            return false;
        }
        if (this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && Compiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return true;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            return true;
        }
        int n = this.ichToken;
        char c = this.script.charAt(n);
        if (c == '\r') {
            if (++n < this.cchScript && this.script.charAt(n) == '\n') {
                ++n;
            }
        } else if (c == '\n') {
            ++n;
        } else {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtEndOfStatement() {
        if (this.ichToken == this.cchScript || this.script.charAt(this.ichToken) != ';') {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private boolean lookingAtString() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        if (this.script.charAt(this.ichToken) != '\"') {
            return false;
        }
        int n = this.ichToken;
        boolean bl = false;
        while (++n < this.cchScript && ((c = this.script.charAt(n)) != '\"' || bl)) {
            bl = c == '\\' ? !bl : false;
        }
        this.cchToken = n == this.cchScript ? -1 : ++n - this.ichToken;
        return true;
    }

    String getUnescapedStringLiteral() {
        if (this.cchToken < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.cchToken - 2);
        int n = this.ichToken + this.cchToken - 1;
        int n2 = this.ichToken + 1;
        while (n2 < n) {
            int n3;
            if ((n3 = this.script.charAt(n2++)) == 92 && n2 < n) {
                n3 = this.script.charAt(n2++);
                switch (n3) {
                    case 98: {
                        n3 = 8;
                        break;
                    }
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    case 116: {
                        n3 = 9;
                        break;
                    }
                    case 114: {
                        n3 = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char c;
                        int n4;
                        int n5;
                        int n6 = n5 = n3 == 120 ? 2 : 4;
                        if (n2 >= n) break;
                        int n7 = 0;
                        int n8 = n5;
                        while (--n8 >= 0 && n2 < n && (n4 = Compiler.getHexitValue(c = this.script.charAt(n2))) >= 0) {
                            n7 <<= 4;
                            n7 += n4;
                            ++n2;
                        }
                        n3 = (char)n7;
                    }
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    static int getHexitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    private boolean lookingAtLoadFormat() {
        String string = this.script.substring(this.ichToken, Math.min(this.cchScript, this.ichToken + 10)).toLowerCase();
        int n = loadFormats.length;
        while (--n >= 0) {
            int n2;
            String string2 = loadFormats[n];
            int n3 = string2.length();
            if (string.indexOf(string2) != 0 || (n2 = this.ichToken + n3) >= this.cchScript || !Compiler.isSpaceOrTab(this.script.charAt(n2))) continue;
            this.cchToken = n3;
            return true;
        }
        return false;
    }

    private boolean lookingAtSpecialString() {
        int n;
        for (n = this.ichToken; n < this.cchScript && !Compiler.eol(this.script.charAt(n)); ++n) {
        }
        if (n > this.ichToken && this.script.charAt(this.ichToken) == '@') {
            return false;
        }
        this.cchToken = n - this.ichToken;
        this.log("lookingAtSpecialString cchToken=" + this.cchToken);
        return this.cchToken > 0;
    }

    private float lookingAtExponential() {
        boolean bl;
        boolean bl2;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int n = this.ichToken;
        boolean bl3 = bl2 = this.script.charAt(n) == '-';
        if (bl2) {
            ++n;
        }
        int n2 = n;
        boolean bl4 = false;
        int n3 = 88;
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl4 = true;
        }
        if (n < this.cchScript && n3 == 46) {
            ++n;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl4 = true;
        }
        if (n == this.cchScript || !bl4) {
            return Float.NaN;
        }
        int n4 = n;
        int n5 = 1;
        int n6 = 0;
        boolean bl5 = bl = n3 == 69 || n3 == 101;
        if (!bl || ++n == this.cchScript) {
            return Float.NaN;
        }
        n3 = this.script.charAt(n);
        if (n3 == 45 || n3 == 43) {
            ++n;
            int n7 = n5 = n3 == 45 ? -1 : 1;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            n6 = n6 * 10 + n3 - 48;
        }
        if (n6 == 0) {
            return Float.NaN;
        }
        this.cchToken = n - this.ichToken;
        double d = Float.valueOf(this.script.substring(n2, n4)).doubleValue();
        return (float)(d *= (double)(bl2 ? -1 : 1) * Math.pow(10.0, n5 * n6));
    }

    private boolean lookingAtDecimal() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            ++n;
        }
        boolean bl = false;
        int n2 = 88;
        while (n < this.cchScript) {
            char c2 = this.script.charAt(n++);
            n2 = c2;
            if (!Character.isDigit(c2)) break;
            bl = true;
        }
        if (n2 != 46) {
            return false;
        }
        if (n < this.cchScript && !Compiler.eol(c = this.script.charAt(n))) {
            if (Character.isLetter(c) || c == '?') {
                return false;
            }
            if (n + 1 < this.cchScript && (Character.isLetter(c = this.script.charAt(n + 1)) || c == '?')) {
                return false;
            }
        }
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
            bl = true;
        }
        this.cchToken = n - this.ichToken;
        return bl;
    }

    private boolean lookingAtSeqcode() {
        int n;
        char c = ' ';
        if (n + 1 < this.cchScript && this.script.charAt(n) == '*' && this.script.charAt(n + 1) == '^') {
            c = '^';
            ++n;
        } else {
            for (n = this.ichToken; n < this.cchScript; ++n) {
                char c2 = this.script.charAt(n);
                c = c2;
                if (!Character.isDigit(c2)) break;
            }
        }
        if (c != '^') {
            return false;
        }
        if ((c = ++n == this.cchScript ? (char)' ' : (char)this.script.charAt(n++)) != ' ' && c != '*' && c != '?' && !Character.isLetter(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtInteger(boolean bl) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (bl && this.script.charAt(this.ichToken) == '-') {
            ++n;
        }
        int n2 = n;
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
        }
        if (n2 == n) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    BitSet lookingAtBitset() {
        int n;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BitSet();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || this.script.charAt(this.ichToken) != '(' && this.script.charAt(this.ichToken) != '[') {
            return null;
        }
        char c = this.script.charAt(this.ichToken) == '(' ? (char)')' : ']';
        char c2 = ' ';
        for (n = this.ichToken + 2; n < this.cchScript; ++n) {
            char c3 = this.script.charAt(n);
            c2 = c3;
            if (c3 == '}' || !Character.isDigit(c2) && !Compiler.isSpaceOrTab(c2) && c2 != 58) break;
        }
        if (c2 != '}' || n + 1 == this.cchScript || this.script.charAt(n + 1) != c) {
            return null;
        }
        int n2 = -1;
        int n3 = 0;
        BitSet bitSet = new BitSet();
        int n4 = this.ichToken + 2;
        while (n4 < n) {
            while (Compiler.isSpaceOrTab(c2 = this.script.charAt(n4))) {
                ++n4;
            }
            n3 = n4;
            while (Character.isDigit(c2 = this.script.charAt(n3))) {
                ++n3;
            }
            if (n3 == n4) {
                return null;
            }
            int n5 = Integer.parseInt(this.script.substring(n4, n3));
            if (c2 == ':') {
                n2 = n5;
            } else {
                if (n2 >= 0) {
                    if (n2 > n5) {
                        return null;
                    }
                    for (int i = n2; i <= n5; ++i) {
                        bitSet.set(i);
                    }
                } else {
                    bitSet.set(n5);
                }
                n2 = -1;
            }
            n4 = ++n3;
        }
        if (n2 >= 0) {
            return null;
        }
        this.cchToken = n + 2 - this.ichToken;
        return bitSet;
    }

    private boolean lookingAtLookupToken() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        char c = this.script.charAt(n++);
        switch (c) {
            case '$': 
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case '@': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                break;
            }
            case '&': 
            case '|': {
                if (n >= this.cchScript || this.script.charAt(n) != c) break;
                ++n;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (n >= this.cchScript || (c = this.script.charAt(n)) != '<' && c != '=' && c != '>') break;
                ++n;
                break;
            }
            case '!': 
            case '/': {
                if (n >= this.cchScript || this.script.charAt(n) != '=') break;
                ++n;
                break;
            }
            default: {
                if (!Character.isLetter(c)) {
                    return false;
                }
            }
            case '?': 
            case '_': 
            case '~': {
                while (n < this.cchScript && (Character.isLetterOrDigit(c = this.script.charAt(n)) || c == '_' || c == '?' || c == '~') || c == '^' && n > this.ichToken && Character.isDigit(this.script.charAt(n - 1))) {
                    ++n;
                }
                break block0;
            }
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean compileCommand() {
        int n;
        int n2;
        this.tokenCommand = (Token)this.ltoken.firstElement();
        this.tokCommand = this.tokenCommand.tok;
        this.isSetOrIf = this.tokCommand == 21791 || this.tokCommand == 5484;
        this.isSetOrDefine = this.tokCommand == 21791 || this.tokCommand == 74505;
        this.isCommaAsOrAllowed = Compiler.tokAttr(this.tokCommand, 512);
        int n3 = this.ltoken.size();
        if (n3 == 1 && this.tokenCommand.intValue != Integer.MAX_VALUE && Compiler.tokAttr(this.tokenCommand.intValue, 33)) {
            this.addTokenToPrefix(Token.tokenOn);
        }
        this.atokenInfix = new Token[this.ltoken.size()];
        this.ltoken.copyInto(this.atokenInfix);
        if (this.logMessages) {
            for (n2 = 0; n2 < this.atokenInfix.length; ++n2) {
                Logger.debug(n2 + ": " + this.atokenInfix[n2]);
            }
        }
        if (Compiler.tokAttr(this.tokCommand, 16384) && !this.compileColorParam()) {
            return false;
        }
        this.isEmbeddedExpression = Compiler.tokAttr(this.tokCommand, 1024);
        n2 = Compiler.tokAttrOr(this.tokCommand, 512, 1024) ? 1 : 0;
        if (!Compiler.tokAttr(this.tokCommand, 5120) && this.tokCommand == 772 && this.tokAt(1) == 65541) {
            n2 = 0;
        }
        if (n2 != 0 && !this.compileExpression()) {
            return false;
        }
        n3 = this.atokenInfix.length;
        int n4 = 0;
        for (n = 1; n < n3; ++n) {
            if (this.tokAt(n) != 74505) continue;
            ++n4;
        }
        n3 -= n4;
        n = (this.tokenCommand.intValue & 0xF) + 1;
        if (!Compiler.tokAttr(this.tokenCommand.intValue, 16)) {
            if (n3 > n) {
                return this.badArgumentCount();
            }
            if (n3 < n) {
                return this.endOfCommandUnexpected();
            }
        } else if (n > 1 && n3 > n) {
            return this.badArgumentCount();
        }
        if (this.isNewSet && n3 < 3) {
            return this.commandExpected();
        }
        return true;
    }

    private boolean compileExpression() {
        int n = this.isSetOrDefine ? 2 : 1;
        this.ltokenPostfix = new Vector();
        this.itokenInfix = 0;
        for (int i = 0; i < n && this.addNextToken(); ++i) {
        }
        while (this.moreTokens()) {
            if (this.isEmbeddedExpression) {
                while (!this.isExpressionNext() && this.addNextToken()) {
                }
                if (!this.moreTokens()) break;
            }
            if (!this.isSetOrIf) {
                this.addTokenToPostfix(Token.tokenExpressionBegin);
            }
            if (!this.clauseOr(this.isCommaAsOrAllowed || !this.isSetOrIf && this.tokPeek(0x110000))) {
                return false;
            }
            if (!(this.isSetOrIf || this.isEmbeddedExpression && this.lastToken == Token.tokenCoordinateEnd)) {
                this.addTokenToPostfix(Token.tokenExpressionEnd);
            }
            if (!this.moreTokens() || this.isEmbeddedExpression) continue;
            return this.endOfExpressionExpected();
        }
        this.atokenInfix = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenInfix);
        return true;
    }

    private boolean isExpressionNext() {
        return this.tokPeek(65539) || !this.isSetOrIf && this.tokPeek(0x110000);
    }

    private static boolean tokenAttr(Token token, int n) {
        return token != null && (token.tok & n) == n;
    }

    private boolean moreTokens() {
        return this.itokenInfix < this.atokenInfix.length;
    }

    private int tokAt(int n) {
        return n < this.atokenInfix.length ? this.atokenInfix[n].tok : 0;
    }

    private int tokPeek() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return 0;
        }
        return this.atokenInfix[this.itokenInfix].tok;
    }

    private boolean tokPeek(int n) {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return false;
        }
        return this.atokenInfix[this.itokenInfix].tok == n;
    }

    private int intPeek() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return Integer.MAX_VALUE;
        }
        return this.atokenInfix[this.itokenInfix].intValue;
    }

    private Object valuePeek() {
        if (this.moreTokens()) {
            return this.atokenInfix[this.itokenInfix].value;
        }
        return "";
    }

    private Token tokenNext() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix++];
    }

    private boolean tokenNext(int n) {
        Token token = this.tokenNext();
        return token != null && token.tok == n;
    }

    private boolean returnToken() {
        --this.itokenInfix;
        return false;
    }

    private Token getToken() {
        this.theToken = this.tokenNext();
        this.theValue = this.theToken == null ? null : this.theToken.value;
        return this.theToken;
    }

    private boolean isToken(int n) {
        return this.theToken != null && this.theToken.tok == n;
    }

    private boolean getNumericalToken() {
        return this.getToken() != null && (this.isToken(2) || this.isToken(3));
    }

    private float floatValue() {
        switch (this.theToken.tok) {
            case 2: {
                return this.theToken.intValue;
            }
            case 3: {
                return ((Float)this.theValue).floatValue();
            }
        }
        return 0.0f;
    }

    private boolean addTokenToPostfix(Token token) {
        if (token == null) {
            return false;
        }
        if (this.logMessages) {
            this.log("addTokenToPostfix" + token);
        }
        this.ltokenPostfix.addElement(token);
        this.lastToken = token;
        return true;
    }

    private boolean addNextToken() {
        return this.addTokenToPostfix(this.tokenNext());
    }

    private boolean addNextTokenIf(int n) {
        return this.tokPeek(n) && this.addNextToken();
    }

    private boolean addSubstituteTokenIf(int n, Token token) {
        if (!this.tokPeek(n)) {
            return false;
        }
        ++this.itokenInfix;
        return this.addTokenToPostfix(token);
    }

    private boolean clauseOr(boolean bl) {
        int n;
        this.haveString = false;
        if (!this.clauseAnd()) {
            return false;
        }
        while ((n = this.tokPeek()) == 0x110010 || n == 0x110011 || n == 0x110012 || bl && n == 65547) {
            if (n == 65547 && !this.haveString) {
                this.addSubstituteTokenIf(65547, Token.tokenOr);
            } else {
                this.addNextToken();
            }
            if (this.clauseAnd()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        while (this.tokPeek(0x110018)) {
            this.addNextToken();
            if (this.clauseNot()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseNot() {
        if (this.tokPeek(0x110020)) {
            this.addNextToken();
            return this.clauseNot();
        }
        return this.clausePrimitive();
    }

    private boolean clausePrimitive() {
        int n = this.tokPeek();
        switch (n) {
            case 1: 
            case 5: 
            case 65538: 
            case 0x110008: 
            case 0x110030: 
            case 1114169: 
            case 1114170: {
                if (this.clauseResidueSpec()) {
                    return true;
                }
            }
            default: {
                if (Compiler.tokAttrOr(n, 860169, 327680)) {
                    return this.clauseComparator();
                }
                if (!Compiler.tokAttr(n, 196608)) break;
            }
            case 32839: 
            case 65549: 
            case 65551: {
                return this.addNextToken();
            }
            case 2: {
                if (this.clauseResidueSpec()) {
                    return true;
                }
            }
            case 1114168: {
                this.addNextToken();
                return true;
            }
            case 4: {
                this.haveString = true;
                return this.addNextToken();
            }
            case 74505: {
                this.addNextToken();
                if (this.tokPeek() != 0) {
                    return this.addTokenToPostfix(new Token(1, this.tokenNext().value));
                }
            }
            case 0: {
                return this.endOfCommandUnexpected();
            }
            case 75026: 
            case 860162: {
                this.addNextToken();
                if (this.tokPeek(32839)) {
                    this.addNextToken();
                } else if (this.tokPeek(74505)) {
                    this.addNextToken();
                    this.addNextToken();
                }
                return true;
            }
            case 327685: {
                return this.clauseCell();
            }
            case 2162729: {
                this.addNextToken();
                return this.clauseWithin();
            }
            case 2162730: {
                this.addNextToken();
                return this.clauseConnected();
            }
            case 2162700: {
                this.addNextToken();
                return this.clauseSubstructure();
            }
            case 3: {
                return this.addTokenToPostfix(new Token(65567, this.getToken().intValue, this.theValue));
            }
            case 0x110000: {
                this.addNextToken();
                if (!this.clauseOr(true)) {
                    return false;
                }
                if (!this.addNextTokenIf(0x110001)) {
                    return this.rightParenthesisExpected();
                }
                return this.checkForMath();
            }
            case 65539: {
                boolean bl = false;
                int n2 = this.ltokenPostfix.size();
                if (this.isSetOrIf) {
                    this.addTokenToPostfix(Token.tokenExpressionBegin);
                    this.tokenNext();
                } else if (this.isEmbeddedExpression) {
                    this.tokenNext();
                    --n2;
                } else {
                    this.addNextToken();
                }
                if (!this.clauseOr(false)) {
                    return false;
                }
                int n3 = 1;
                while (!this.tokPeek(65540)) {
                    boolean bl2 = this.addNextTokenIf(65547);
                    if (!this.clauseOr(false)) {
                        return bl2 || n3 < 3 ? false : this.rightBraceExpected();
                    }
                    ++n3;
                }
                boolean bl3 = bl = n3 >= 2;
                if (bl && (this.isSetOrIf || this.isEmbeddedExpression)) {
                    this.ltokenPostfix.set(n2, Token.tokenCoordinateBegin);
                    this.addTokenToPostfix(Token.tokenCoordinateEnd);
                    this.tokenNext();
                } else if (this.isSetOrIf) {
                    this.addTokenToPostfix(Token.tokenExpressionEnd);
                    this.tokenNext();
                } else if (this.isEmbeddedExpression) {
                    this.tokenNext();
                } else {
                    this.addNextToken();
                }
                return this.checkForMath();
            }
        }
        return this.unrecognizedExpressionToken();
    }

    private boolean checkForMath() {
        for (int i = 0; i < 2 && this.addNextTokenIf(0x110008); ++i) {
            if (!this.clauseItemSelector()) {
                return false;
            }
            if (this.addNextTokenIf(0x110009)) continue;
            return this.rightBracketExpected();
        }
        return true;
    }

    private boolean clauseWithin() {
        if (!this.addNextTokenIf(0x110000)) {
            return false;
        }
        if (this.getToken() == null) {
            return false;
        }
        float f = 0.0f;
        String string = null;
        switch (this.theToken.tok) {
            case 0x110030: {
                if (this.getToken() == null) {
                    return false;
                }
                if (this.theToken.tok != 2) {
                    return this.numberExpected();
                }
                f = -this.theToken.intValue;
                break;
            }
            case 2: 
            case 3: {
                f = this.floatValue();
                break;
            }
            case 4: 
            case 65544: 
            case 65545: 
            case 65548: 
            case 327686: 
            case 327694: 
            case 327699: 
            case 327949: {
                string = (String)this.theValue;
                break;
            }
            case 1: {
                string = ((String)this.theValue).toLowerCase();
                break;
            }
            default: {
                return this.unrecognizedParameter("WITHIN", "" + this.theToken.value);
            }
        }
        if (string == null) {
            this.addTokenToPostfix(new Token(3, new Float(f)));
        } else {
            this.addTokenToPostfix(new Token(4, string));
        }
        while (this.addNextTokenIf(65547)) {
            int n = this.tokPeek();
            boolean bl = false;
            if (string == null && n == 1 || n == 65548) {
                this.getToken();
                string = ((String)this.theValue).toLowerCase();
                if (Parser.isOneOf(string, "plane;hkl;coord")) {
                    this.addTokenToPostfix(new Token(4, string));
                } else {
                    this.returnToken();
                    if (n == 65539) {
                        bl = true;
                        this.addTokenToPostfix(new Token(4, "coord"));
                    }
                }
            }
            if (Parser.isOneOf(string, "plane;hkl;coord")) {
                bl = true;
            }
            this.addNextTokenIf(65547);
            if (bl) {
                block11: while (!this.tokPeek(0x110001)) {
                    switch (this.tokPeek()) {
                        case 0: {
                            return this.endOfCommandUnexpected();
                        }
                        case 0x110000: {
                            this.addTokenToPostfix(Token.tokenExpressionBegin);
                            this.addNextToken();
                            if (!this.clauseOr(false)) {
                                return this.unrecognizedParameter("WITHIN", "?");
                            }
                            if (!this.addNextTokenIf(0x110001)) {
                                return this.commaOrCloseExpected();
                            }
                            this.addTokenToPostfix(Token.tokenExpressionEnd);
                            continue block11;
                        }
                    }
                    this.addTokenToPostfix(this.getToken());
                }
                continue;
            }
            if (this.clauseOr(true)) continue;
            return this.endOfCommandUnexpected();
        }
        if (!this.addNextTokenIf(0x110001)) {
            return this.rightParenthesisExpected();
        }
        return true;
    }

    private boolean clauseConnected() {
        block10: {
            block11: {
                String string;
                block12: {
                    if (!this.addNextTokenIf(0x110000)) {
                        this.addTokenToPostfix(new Token(0x110000));
                        this.addTokenToPostfix(new Token(0x110001));
                        return true;
                    }
                    if (this.addNextTokenIf(2) && !this.addNextTokenIf(65547) || this.addNextTokenIf(2) && !this.addNextTokenIf(65547) || this.addNextTokenIf(3) && !this.addNextTokenIf(65547) || this.addNextTokenIf(3) && !this.addNextTokenIf(65547)) break block10;
                    if (this.tokPeek() != 1) break block11;
                    string = (String)this.getToken().value;
                    short s = JmolConstants.getBondOrderFromString(string);
                    if (s != -1) break block12;
                    this.returnToken();
                    break block11;
                }
                this.addTokenToPostfix(new Token(4, string));
                if (!this.addNextTokenIf(65547)) break block10;
            }
            if (this.addNextTokenIf(0x110001)) {
                return true;
            }
            if (!this.clauseOr(this.tokPeek(0x110000))) {
                return false;
            }
            if (this.addNextTokenIf(0x110001)) {
                return true;
            }
            if (!this.addNextTokenIf(65547)) {
                return false;
            }
            if (!this.clauseOr(this.tokPeek(0x110000))) {
                return false;
            }
        }
        if (!this.addNextTokenIf(0x110001)) {
            return this.rightParenthesisExpected();
        }
        return true;
    }

    private boolean clauseSubstructure() {
        if (!this.addNextTokenIf(0x110000)) {
            return false;
        }
        if (!this.addNextTokenIf(4)) {
            return this.stringExpected();
        }
        if (!this.addNextTokenIf(0x110001)) {
            return this.rightParenthesisExpected();
        }
        return true;
    }

    private boolean clauseItemSelector() {
        int n;
        while ((n = this.tokPeek()) != 0 && n != 0x110009) {
            if (!this.clauseOr(false)) {
                return false;
            }
            this.returnToken();
            if (this.tokPeek() != 1114169) {
                this.tokenNext();
            }
            if ((n = this.tokPeek()) == 0x110009 || !Compiler.tokAttr(n, 0x110000)) break;
            if (n == 0x110000) continue;
            this.addNextToken();
        }
        return true;
    }

    private boolean clauseComparator() {
        Token token = this.tokenNext();
        Token token2 = this.tokenNext();
        if (!Compiler.tokenAttr(token2, 0x410000)) {
            return this.comparisonOperatorExpected();
        }
        if (this.getToken() == null) {
            return this.unrecognizedExpressionToken();
        }
        boolean bl = this.isToken(0x110030);
        if (bl && this.getToken() == null) {
            return this.numberExpected();
        }
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 65539: 
            case 74505: {
                break;
            }
            default: {
                return this.numberOrVariableNameExpected();
            }
        }
        this.addTokenToPostfix(new Token(token2.tok, token.tok, token2.value + (bl ? " -" : "")));
        if (token.tok == 860169) {
            this.addTokenToPostfix(token);
        }
        if (this.isToken(65539)) {
            this.returnToken();
            return this.clausePrimitive();
        }
        this.addTokenToPostfix(this.theToken);
        if (this.theToken.tok == 74505) {
            this.addTokenToPostfix(this.getToken());
        }
        return true;
    }

    private boolean clauseCell() {
        Point3f point3f = new Point3f();
        this.tokenNext();
        if (!this.tokenNext(5308460)) {
            return this.equalSignExpected();
        }
        if (this.getToken() == null) {
            return this.coordinateExpected();
        }
        if (this.isToken(2)) {
            int n = this.theToken.intValue;
            point3f.x = n / 100 - 4;
            point3f.y = n % 100 / 10 - 4;
            point3f.z = n % 10 - 4;
            return this.addTokenToPostfix(new Token(327685, point3f));
        }
        if (!this.isToken(65539) || !this.getNumericalToken()) {
            return this.coordinateExpected();
        }
        point3f.x = this.floatValue();
        if (this.tokPeek(65547)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken()) {
            return this.coordinateExpected();
        }
        point3f.y = this.floatValue();
        if (this.tokPeek(65547)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken() || !this.tokenNext(65540)) {
            return this.coordinateExpected();
        }
        point3f.z = this.floatValue();
        return this.addTokenToPostfix(new Token(327685, point3f));
    }

    private boolean generateResidueSpecCode(Token token) {
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.addTokenToPostfix(token);
        this.residueSpecCodeGenerated = true;
        return true;
    }

    private boolean clauseResidueSpec() {
        boolean bl = false;
        this.residueSpecCodeGenerated = false;
        int n = this.tokPeek();
        if (n == 1114169 || n == 0x110008 || n == 1) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        boolean bl2 = false;
        if (n == 1114169 || n == 0x110030 || n == 2 || n == 5) {
            boolean bl3 = bl2 = n == 2;
            if (!this.clauseResNumSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 65538 || n == 1114169 || n == 1 || n == 2 && !bl2) {
            if (!this.clauseChainSpec(n)) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 65537) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 1114170) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 65538 || n == 1114168) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (!bl) {
            return this.residueSpecificationExpected();
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    private boolean clauseResNameSpec() {
        this.getToken();
        if (this.isToken(1114169) || this.isToken(0)) {
            return !this.isToken(0);
        }
        if (this.isToken(0x110008)) {
            int n;
            String string = "";
            while (this.getToken() != null && !this.isToken(0x110009)) {
                string = string + this.theValue;
            }
            if (!this.isToken(0x110009)) {
                return false;
            }
            if (string == "") {
                return true;
            }
            if (string.length() > 0 && (n = string.indexOf("*")) >= 0 && n != string.length() - 1) {
                return this.residueSpecificationExpected();
            }
            string = string.toUpperCase();
            return this.generateResidueSpecCode(new Token(65561, string));
        }
        if (!this.isToken(1)) {
            return this.identifierOrResidueSpecificationExpected();
        }
        if (this.tokPeek(1114169)) {
            String string = this.theValue + "*";
            this.getToken();
            return this.generateResidueSpecCode(new Token(1, string));
        }
        return this.generateResidueSpecCode(this.theToken);
    }

    private boolean clauseResNumSpec() {
        this.log("clauseResNumSpec()");
        if (this.tokPeek(1114169)) {
            return this.getToken() != null;
        }
        return this.clauseSequenceRange();
    }

    private boolean clauseSequenceRange() {
        Token token = this.getSequenceCode(false);
        if (token == null) {
            return false;
        }
        int n = this.tokPeek();
        if (n == 0x110030 || n == 2 && this.intPeek() < 0) {
            if (n == 0x110030) {
                this.tokenNext();
            } else if (this.tokPeek() == 2 && this.intPeek() < 0) {
                int n2;
                this.tokenNext().intValue = n2 = -this.intPeek();
                this.returnToken();
            }
            token.tok = 65563;
            this.generateResidueSpecCode(token);
            token = this.getSequenceCode(true);
            return this.addTokenToPostfix(token);
        }
        return this.generateResidueSpecCode(token);
    }

    private Token getSequenceCode(boolean bl) {
        boolean bl2 = false;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = this.tokPeek();
        if (n3 == 0x110030) {
            this.tokenNext();
            n3 = this.tokPeek();
            bl2 = true;
        }
        if (n3 == 5) {
            n = this.tokenNext().intValue * (bl2 ? -1 : 1);
        } else if (n3 == 2) {
            n2 = this.tokenNext().intValue * (bl2 ? -1 : 1);
        } else if (!bl) {
            if (bl2) {
                this.returnToken();
            }
            return null;
        }
        return new Token(65562, n2, new Integer(n));
    }

    private boolean clauseChainSpec(int n) {
        char c;
        if (n == 65538) {
            this.tokenNext();
            n = this.tokPeek();
            if (this.isSpecTerminator(n)) {
                return this.generateResidueSpecCode(new Token(65564, 0, "spec_chain"));
            }
        }
        if (n == 1114169) {
            return this.getToken() != null;
        }
        switch (n) {
            case 2: {
                this.getToken();
                int n2 = this.theToken.intValue;
                if (n2 < 0 || n2 > 9) {
                    return this.invalidChainSpecification();
                }
                c = (char)(48 + n2);
                break;
            }
            case 1: {
                String string = (String)this.getToken().value;
                if (string.length() != 1) {
                    return this.invalidChainSpecification();
                }
                c = string.charAt(0);
                if (c != '?') break;
                return true;
            }
            default: {
                return this.invalidChainSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(65564, c, "spec_chain"));
    }

    private boolean isSpecTerminator(int n) {
        switch (n) {
            case 0: 
            case 65547: 
            case 0x110001: 
            case 0x110010: 
            case 0x110018: 
            case 0x110020: 
            case 1114168: 
            case 1114170: {
                return true;
            }
        }
        return false;
    }

    private boolean clauseAlternateSpec() {
        this.tokenNext();
        int n = this.tokPeek();
        if (this.isSpecTerminator(n)) {
            return this.generateResidueSpecCode(new Token(65565, null));
        }
        String string = (String)this.getToken().value;
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 1114169: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(65565, string));
    }

    private boolean clauseModelSpec() {
        this.getToken();
        if (this.tokPeek(1114169)) {
            this.getToken();
            return true;
        }
        switch (this.tokPeek()) {
            case 2: {
                return this.generateResidueSpecCode(new Token(65566, new Integer(this.getToken().intValue)));
            }
            case 3: {
                return this.generateResidueSpecCode(new Token(65566, this.getToken().intValue, this.theValue));
            }
            case 0: 
            case 65540: 
            case 65547: {
                return this.generateResidueSpecCode(new Token(65566, new Integer(1)));
            }
        }
        return this.invalidModelSpecification();
    }

    private boolean clauseAtomSpec() {
        if (!this.tokenNext(65537)) {
            return this.invalidAtomSpecification();
        }
        if (this.getToken() == null) {
            return true;
        }
        String string = "";
        if (this.isToken(2)) {
            string = string + "" + this.theToken.intValue;
            if (this.getToken() == null) {
                return this.invalidAtomSpecification();
            }
        }
        switch (this.theToken.tok) {
            case 1114169: {
                return true;
            }
            case 1: {
                break;
            }
            default: {
                return this.invalidAtomSpecification();
            }
        }
        string = string + this.theValue;
        if (this.tokPeek(1114169)) {
            this.tokenNext();
            string = string + "*";
        }
        return this.generateResidueSpecCode(new Token(65568, string));
    }

    private boolean compileColorParam() {
        for (int i = 1; i < this.atokenInfix.length; ++i) {
            String string;
            int n;
            this.theToken = this.atokenInfix[i];
            if (this.isToken(65541)) {
                ++i;
                continue;
            }
            if (!this.isToken(1) || (n = Graphics3D.getArgbFromString(string = (String)this.theToken.value)) == 0) continue;
            this.theToken.tok = 49172;
            this.theToken.intValue = n;
        }
        return true;
    }

    private boolean commandExpected() {
        return this.compileError(GT._("command expected"));
    }

    private boolean invalidExpressionToken(String string) {
        return this.compileError(GT._("invalid expression token: {0}", string));
    }

    private boolean unrecognizedToken(String string) {
        return this.compileError(GT._("unrecognized token: {0}", string));
    }

    private boolean endOfCommandUnexpected() {
        return this.compileError(GT._("unexpected end of script command"));
    }

    private boolean badArgumentCount() {
        return this.compileError(GT._("bad argument count"));
    }

    private boolean endOfExpressionExpected() {
        return this.compileError(GT._("end of expression expected"));
    }

    private boolean rightParenthesisExpected() {
        return this.compileError(GT._("right parenthesis expected"));
    }

    private boolean rightBraceExpected() {
        return this.compileError(GT._("right brace expected"));
    }

    private boolean rightBracketExpected() {
        return this.compileError(GT._("right bracket expected"));
    }

    private boolean coordinateExpected() {
        return this.compileError(GT._("{ number number number } expected"));
    }

    private boolean unrecognizedExpressionToken() {
        return this.compileError(GT._("unrecognized expression token: {0}", "" + this.valuePeek()));
    }

    private boolean comparisonOperatorExpected() {
        return this.compileError(GT._("comparison operator expected"));
    }

    private boolean equalSignExpected() {
        return this.compileError(GT._("equal sign expected"));
    }

    private boolean numberExpected() {
        return this.compileError(GT._("number expected"));
    }

    private boolean numberOrVariableNameExpected() {
        return this.compileError(GT._("number or variable name expected"));
    }

    private boolean unrecognizedParameter(String string, String string2) {
        return this.compileError(GT._("unrecognized {0} parameter", string) + ": " + string2);
    }

    private boolean identifierOrResidueSpecificationExpected() {
        return this.compileError(GT._("identifier or residue specification expected"));
    }

    private boolean residueSpecificationExpected() {
        return this.compileError(GT._("residue specification (ALA, AL?, A*) expected"));
    }

    private boolean invalidChainSpecification() {
        return this.compileError(GT._("invalid chain specification"));
    }

    private boolean invalidModelSpecification() {
        return this.compileError(GT._("invalid model specification"));
    }

    private boolean invalidAtomSpecification() {
        return this.compileError(GT._("invalid atom specification"));
    }

    private boolean compileError(String string) {
        this.errorMessage = string;
        return false;
    }

    private boolean stringExpected() {
        return this.compileError(GT._("quoted string expected"));
    }

    private boolean commaOrCloseExpected() {
        return this.compileError(GT._("comma or right parenthesis expected"));
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    private boolean handleError() {
        int n = this.script.indexOf(13, this.ichCurrentCommand);
        if (n == -1 && (n = this.script.indexOf(10, this.ichCurrentCommand)) == -1) {
            n = this.script.length();
        }
        this.errorLine = this.script.substring(this.ichCurrentCommand, n);
        String string = (this.ichToken < this.errorLine.length() ? this.errorLine.substring(0, this.ichToken) + " >>>> " + this.errorLine.substring(this.ichToken) : this.errorLine) + " <<<<";
        this.errorMessage = "script compiler ERROR: " + this.errorMessage + Eval.setErrorLineMessage(this.filename, this.lineCurrent, this.iCommand, string);
        if (!this.isSilent) {
            this.viewer.addCommand(this.errorLine + "#??");
            Logger.error(this.errorMessage);
        }
        return false;
    }
}

