# The LearningOnline Network
# Create a course
#
# $Id: loncreatecourse.pm,v 1.104.2.2 2007/12/23 17:36:56 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::loncreatecourse;

use strict;
use Apache::Constants qw(:common :http);
use Apache::lonnet;
use Apache::loncommon;
use Apache::londocs;
use Apache::lonlocal;
use Apache::lonuserutils;
use Apache::lonclonecourse;
use LONCAPA::batchcreatecourse;
use LONCAPA;

# ===================================================== Phase one: fill-in form

sub print_course_creation_page {
    my $r=shift;
    my $crstype = 'Course';
#    my $crstype = 'Group';
#    if ($env{'form.phase'} eq 'courseone') {
#        $crstype = 'Course';
#    }
    my $defdom=$env{'request.role.domain'};
    my %host_servers = &Apache::lonnet::get_servers($defdom,'library');
    my $course_home = '<select name="course_home" size="1">'."\n";
    foreach my $server (sort(keys(%host_servers))) {
        $course_home .= qq{<option value="$server"};
        if ($server eq $Apache::lonnet::perlvar{'lonHostID'}) {
            $course_home .= " selected ";
        }
        $course_home .= qq{>$server $host_servers{$server}</option>};
    }
    $course_home .= "\n</select>\n";
    my $domform = &Apache::loncommon::select_dom_form($defdom,'ccdomain');
    my $cloneform=&Apache::loncommon::select_dom_form
	($env{'request.role.domain'},'clonedomain').
		     &Apache::loncommon::selectcourse_link
	     ('ccrs','clonecourse','clonedomain',undef,undef,undef,$crstype);
    my $coursebrowserjs=&Apache::loncommon::coursebrowser_javascript($env{'request.role.domain'});
    my ($enroll_table,$access_table,$krbdef,$krbdefdom,$krbform,$intform,$locform,
        $javascript_validations);
    if ($crstype eq 'Course') {
        my $starttime = time;
        my $endtime = time+(6*30*24*60*60); # 6 months from now, approx
        $enroll_table = &Apache::lonuserutils::date_setting_table($starttime,
                                                $endtime,'create_enrolldates');
        $access_table = &Apache::lonuserutils::date_setting_table($starttime,
                                               $endtime,'create_defaultdates');
        ($krbdef,$krbdefdom) =
        &Apache::loncommon::get_kerberos_defaults($defdom);
        $javascript_validations=&Apache::lonuserutils::javascript_validations(
                                                    'createcourse',$krbdefdom);
        my %param = ( formname      => 'document.ccrs',
                      kerb_def_dom  => $krbdefdom,
                      kerb_def_auth => $krbdef
                    );
        $krbform = &Apache::loncommon::authform_kerberos(%param);
        $intform = &Apache::loncommon::authform_internal(%param);
        $locform = &Apache::loncommon::authform_local(%param);
    } else {
        $javascript_validations = qq|
function validate(formname) {
    if (formname.title == '') {
        alert("A group title is required");
        return;
    }
    if (formname.ccuname == '') {
        alert("The username of the group coordinator is required");
    }
    formname.submit();
}
        |;
    }
    my %lt=&Apache::lonlocal::texthash(
		    'cinf' => "Course Information",
                    'ctit' => "Course Title",
                    'chsr' => "Course Home Server",
                    'cidn' => "Course ID/Number",
                    'opt'  => "optional",
                    'iinf' => "Institutional Information",
                    'stat' => "The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.",
                    'ccod' => "Course Code",
                    'toin' => "to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231",
                    'snid' => "Section Numbers and corresponding LON-CAPA section IDs",
                    'csli' => "a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2",
                    'crcs' => "Crosslisted courses",
                    'cscs' => "a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) sectionID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2",
                    'crco' => "Course Content",
                    'cncr' => "Completely new course",
                    'cecr' => "Clone an existing course", 
                    'map'  => "Map",
                    'smap' => "Select Map",
                    'sacr' => "Do NOT generate as standard course",
                    'ocik' => "only check if you know what you are doing",
                    'fres' => "First Resource",
                    'stco' => "standard courses only",
                    'blnk' => "Blank",
                    'sllb' => "Syllabus",
                    'navi' => "Navigate",
                    'cid'  => "Course ID",
                    'dmn'  => "Domain",
                    'asov' => "Additional settings, if specified below, will override cloned settings",
                    'assp' => "Assessment Parameters",
                    'oaas' => "Open all assessments",
                    'mssg' => "Messaging",
                    'scpf' => "Set course policy feedback to Course Coordinator",
                    'scfc' => "Set content feedback to Course Coordinator",
                    'cmmn' => "Communication",
                    'dsrd' => "Disable student resource discussion",
                    'dsuc' => "Disable student use of chatrooms",
                    'acco' => "Access Control",
                    'snak' => "Students need access key to enter course",
		    'kaut' => 
		    'Key authority (<tt>id@domain</tt>) if other than course',
                    'cc'   => "Course Coordinator",
                    'user' => "Username",
                    'aens' => "Automated enrollment settings",
                    'aesc' => "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",
                    'aadd' => "Automated adds",
                    'yes'  => "Yes",
                    'no'   => "No",
                    'audr' => "Automated drops",
                    'dacu' => "Duration of automated classlist updates",
                    'dacc' => "Default start and end dates for student access",
                    'psam' => "Please select the authentication mechanism",
                    'pcda' => "Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process",
                    'nech' => "Notification of enrollment changes",
                    'nccl' => "Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?",
                    'ndcl' => "Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?",
                    'irsp' => "Include retrieval of student photographs?",
		    'rshm' => 'Resource Space Home',
                    'cgrs' => "Course Group Settings",
                    'cgrq' => "Set a quota for the total disk space available for storage of course group portfolio files.",
                    'opco' => "Open Course",
                    'ginf' => "Group Information",
                    'gtit' => "Group Title",
                    'ghsr' => "Group Home Server",
                    'gidn' => "Group ID/Number",
                    'grco' => "Group Content",
                    'cngr' => "Completely new group",
                    'cegr' => "Clone an existing group",
                    'sagr' => "Do NOT generate as standard group",
                    'stgo' => "standard groups only",
                    'sgpf' => "Set group policy feedback to Group Coordinator",
                    'scfg' => "Set content feedback to Group Coordinator",
                    'dmrd' => "Disable member resource discussion",
                    'dmuc' => "Disable member use of chatrooms",
                    'mnak' => "Members need access key to enter group",
                    'kaug' =>
                    'Key authority (<tt>id@domain</tt>) if other than group',
                    'gc'   => "Group Coordinator",
                    'gid'  => "Group ID",
                    'crgr' => "Create Group",
                    'grts' => "Group Teams Settings",
                    'grtq' => "Set a quota for the total disk space available for storage of group team portfolio files.",

				       );
    my $js = <<END;
<script type="text/javascript">
var editbrowser = null;
function openbrowser(formname,elementname) {
    var url = '/res/?';
    if (editbrowser == null) {
        url += 'launch=1&';
    }
    url += 'catalogmode=interactive&';
    url += 'mode=edit&';
    url += 'form=' + formname + '&';
    url += 'element=' + elementname + '&';
    url += 'only=sequence' + '';
    var title = 'Browser';
    var options = 'scrollbars=1,resizable=1,menubar=0';
    options += ',width=700,height=600';
    editbrowser = open(url,title,options,'1');
    editbrowser.focus();
}
$javascript_validations
</script>
$coursebrowserjs
END

    my %titles = &Apache::lonlocal::texthash(
                  courseone => 'Create a New Course',
                  groupone => 'Create a New Group',
    );  
    my $start_page = 
        &Apache::loncommon::start_page($titles{$env{'form.phase'}},$js);
    my $end_page = 
        &Apache::loncommon::end_page();
    my $crumbs = 
	&Apache::lonhtmlcommon::breadcrumbs($crstype.' Information',
					    'Create_Course',undef,
					    'Create_Courses');
    $r->print($start_page.$crumbs);
    if ($crstype eq 'Course') {
        $r->print(<<ENDDOCUMENT);
<form action="/adm/createcourse" method="post" name="ccrs">
<h2>$lt{'cinf'}</h2>
<p>
<label><b>$lt{'ctit'}:</b>
<input type="text" size="50" name="title" /></label>
</p><p>
<label>
    <b>$lt{'chsr'}:</b>$course_home
</label>
</p><p>
<label>
    <b>$lt{'cidn'} ($lt{'opt'})</b>
    <input type="text" size="30" name="crsid" />
</label>
</p><p>
<h2>$lt{'iinf'}</h2>
<p>
$lt{'stat'}
</p><p>
<label>
    <b>$lt{'ccod'}</b>
    <input type="text" size="30" name="crscode" />
</label>
<br/>
($lt{'toin'})
</p><p>
<label>
    <b>$lt{'snid'}</b>
    <input type="text" size="30" name="crssections" />
</label>
<br/>
($lt{'csli'})
</p><p>
<label>
    <b>$lt{'crcs'}</b>
    <input type="text" size="30" name="crsxlist" />
</label>
<br/>
($lt{'cscs'})
</p>
<h2>$lt{'crco'}</h2>
<table border="2">
<tr><th>$lt{'cncr'}</th><th>$lt{'cecr'}</th></tr>
<tr><td>
<p>
<label>
    <b>$lt{'map'}:</b>
    <input type="text" size="50" name="topmap" />
</label>
<a href="javascript:openbrowser('ccrs','topmap')">$lt{'smap'}</a>
</p><p>
<label for="nonstd"><b>$lt{'sacr'}</b></label>
<br />
($lt{'ocik'}):
<input id="nonstd" type="checkbox" name="nonstandard" />
</p><p>
<b>$lt{'fres'}</b><br />($lt{'stco'}):
<label>
    <input type="radio" name="firstres" value="blank" />$lt{'blnk'}
</label>
&nbsp;
<label>
    <input type="radio" name="firstres" value="syl" checked />$lt{'sllb'}
</label>
&nbsp;
<label>
    <input type="radio" name="firstres" value="nav" />$lt{'navi'}
</label>
</p>
</td><td>
<label>
    $lt{'cid'}: <input type="text" size="25" name="clonecourse" value="" />
</label>
<br />
<label>
    $lt{'dmn'}: $cloneform
</label>
<br />
&nbsp;<br />
$lt{'asov'}.
</td></tr>
</table>
<h2>$lt{'assp'}</h2>
<p>
<label>
    <b>$lt{'oaas'}: </b>
    <input type="checkbox" name="openall" />
</label>
</p>
<h2>$lt{'mssg'}</h2>
<p>
<label>
    <b>$lt{'scpf'}: </b>
    <input type="checkbox" name="setpolicy" checked />
</label>
<br />
<label>
    <b>$lt{'scfc'}: </b>
    <input type="checkbox" name="setcontent" checked />
</label>
</p>
<h2>$lt{'cmmn'}</h2>
<p>
<label>
    <b>$lt{'dsrd'}: </b>
    <input type="checkbox" name="disresdis" />
</label>
<br />
<label>
    <b>$lt{'dsuc'}: </b>
    <input type="checkbox" name="disablechat" />
</label>
</p>
<h2>$lt{'acco'}</h2>
<p>
<label>
    <b>$lt{'snak'}: </b>
    <input type="checkbox" name="setkeys" />
</label>
<br />
<label>
    <b>$lt{'kaut'}: </b>
    <input type="text" size="30" name="keyauth" />
</label>
</p>
<h2>$lt{'rshm'}</h2>
<p>
<label>
    <b>$lt{'rshm'}: </b>
    <input type="text" name="reshome" size="30" value="/res/$defdom/" />
</label>
</p>
<p>
<h2>$lt{'aens'}</h2>
$lt{'aesc'}
</p>
<p>
<b>$lt{'aadd'}</b>
<label><input type="radio" name="autoadds" value="1" />$lt{'yes'}</label> 
<label><input type="radio" name="autoadds" value="0" checked="true" />$lt{'no'}
</label>
</p><p>
<b>$lt{'audr'}</b>
<label><input type="radio" name="autodrops" value="1" />$lt{'yes'}</label> 
<label><input type="radio" name="autodrops" value="0" checked="true" />$lt{'no'}</label>
</p><p>
<b>$lt{'dacu'}</b>
$enroll_table
</p><p>
<b>$lt{'dacc'}</b>
$access_table
<p></p>
<b>$lt{'psam'}.</b><br />
$lt{'pcda'}.
</p><p>
$krbform
<br />
$intform
<br />
$locform
</p><p>
<b>$lt{'nech'}</b><br />
$lt{'nccl'}<br/>
<label>
    <input type="radio" name="notify_owner" value="1" />$lt{'yes'}
</label> 
<label>
    <input type="radio" name="notify_owner" value="0" checked="true" />$lt{'no'}
</label>
<br />
$lt{'ndcl'}<br/>
<label>
    <input type="radio" name="notify_dc" value="1" />$lt{'yes'}
</label>
<label>
    <input type="radio" name="notify_dc" value="0" checked="true" />$lt{'no'}
</label>
</p><p>
<b>$lt{'irsp'}</b>
<label>
    <input type="radio" name="showphotos" value="1" />$lt{'yes'}
</label> 
<label>
    <input type="radio" name="showphotos" value="0" checked="true" />$lt{'no'}
</label>
</p>
<p>
<h2>$lt{'cgrs'}</h2>
$lt{'cgrq'}
<input type="text" name="crsquota" value="20" size="6" />Mb 
</p>
<hr />
<h2>$lt{'cc'}</h2>
<p>
<label>
    <b>$lt{'user'}:</b> <input type="text" size="15" name="ccuname" />
</label>
</p><p>
<label>
    <b>$lt{'dmn'}:</b> $domform
</label>
</p>
<p>
<input type="hidden" name="prevphase" value="courseone" />
<input type="hidden" name="phase" value="coursetwo" />
<input type="button" onClick="verify_message(this.form)" value="$lt{'opco'}" />
</p>
</form>
ENDDOCUMENT
    } elsif ($crstype eq 'Group') {
        $r->print(<<ENDDOCUMENT);
<form action="/adm/createcourse" method="post" name="ccrs">
<h2>$lt{'ginf'}</h2>
<p>
<label><b>$lt{'gtit'}:</b>
<input type="text" size="50" name="title" /></label>
</p><p>
<label>
    <b>$lt{'ghsr'}:</b>$course_home
</label>
</p><p>
<label>
    <b>$lt{'gidn'} ($lt{'opt'})</b>
    <input type="text" size="30" name="crsid" />
</label>
</p>
<h2>$lt{'grco'}</h2>
<table border="2">
<tr><th>$lt{'cngr'}</th><th>$lt{'cegr'}</th></tr>
<tr><td>
<p>
<label>
    <b>$lt{'map'}:</b>
    <input type="text" size="50" name="topmap" />
</label>
<a href="javascript:openbrowser('ccrs','topmap')">$lt{'smap'}</a>
</p><p>
<label for="nonstd"><b>$lt{'sagr'}</b></label>
<br />
($lt{'ocik'}):
<input id="nonstd" type="checkbox" name="nonstandard" />
</p><p>
<b>$lt{'fres'}</b><br />($lt{'stgo'}):
<label>
    <input type="radio" name="firstres" value="blank" />$lt{'blnk'}
</label>
&nbsp;
<label>
    <input type="radio" name="firstres" value="syl" checked />$lt{'sllb'}
</label>
&nbsp;
<label>
    <input type="radio" name="firstres" value="nav" />$lt{'navi'}
</label>
</p>
</td><td>
<label>
    $lt{'gid'}: <input type="text" size="25" name="clonecourse" value="" />
</label>
<br />
<label>
    $lt{'dmn'}: $cloneform
</label>
<br />
&nbsp;<br />
$lt{'asov'}.
</td></tr>
</table>
</p>
<p>
<h2>$lt{'mssg'}</h2>
<p>
<label>
    <b>$lt{'sgpf'}: </b>
    <input type="checkbox" name="setpolicy" checked />
</label>
<br />
<label>
    <b>$lt{'scfg'}: </b>
    <input type="checkbox" name="setcontent" checked />
</label>
</p>
<h2>$lt{'cmmn'}</h2>
<p>
<label>
    <b>$lt{'dmrd'}: </b>
    <input type="checkbox" name="disresdis" />
</label>
<br />
<label>
    <b>$lt{'dmuc'}: </b>
    <input type="checkbox" name="disablechat" />
</label>
</p>
<h2>$lt{'acco'}</h2>
<p>
<label>
    <b>$lt{'mnak'}: </b>
    <input type="checkbox" name="setkeys" />
</label>
<br />
<label>
    <b>$lt{'kaug'}: </b>
    <input type="text" size="30" name="keyauth" />
</label>
</p>
<h2>$lt{'rshm'}</h2>
<p>
<label>
    <b>$lt{'rshm'}: </b>
    <input type="text" name="reshome" size="30" value="/res/$defdom/" />
</label>
</p>
<p>
<h2>$lt{'grts'}</h2>
$lt{'grtq'}
<input type="text" name="crsquota" value="20" />Mb
</p>
<hr />
<h2>$lt{'gc'}</h2>
<p>
<label>
    <b>$lt{'user'}:</b> <input type="text" size="15" name="ccuname" />
</label>
</p><p>
<label>
    <b>$lt{'dmn'}:</b> $domform
</label>
</p>
<p>
<input type="hidden" name="prevphase" value="groupone" />
<input type="hidden" name="phase" value="grouptwo" />
<input type="button" onClick="validate(this.form)" value="$lt{'crgr'}" />
</p>
</form>
ENDDOCUMENT
    }
    $r->print($end_page);
}

# ====================================================== Phase two: make course

sub create_course {
    my $r=shift;
    my $ccuname =&LONCAPA::clean_username($env{'form.ccuname'});
    my $ccdomain=&LONCAPA::clean_domain($env{'form.ccdomain'});
    my $crstype = 'Group';
    my ($enrollstart,$enrollend,$startaccess,$endaccess);

    if ($env{'form.phase'} eq 'coursetwo') {
        $crstype='Course';
        $enrollstart=&Apache::lonhtmlcommon::get_date_from_form('startenroll');
        $enrollend=&Apache::lonhtmlcommon::get_date_from_form('endenroll');
    }
    $startaccess = &Apache::lonhtmlcommon::get_date_from_form('startaccess');
    $endaccess   = &Apache::lonhtmlcommon::get_date_from_form('endaccess');

    my $autharg;
    my $authtype;

    if ($env{'form.login'} eq 'krb') {
        $authtype = 'krb';
        $authtype .=$env{'form.krbver'};
        $autharg = $env{'form.krbarg'};
    } elsif ($env{'form.login'} eq 'int') {
        $authtype ='internal';
        if ((defined($env{'form.intarg'})) && ($env{'form.intarg'})) {
            $autharg = $env{'form.intarg'};
        }
    } elsif ($env{'form.login'} eq 'loc') {
        $authtype = 'localauth';
        if ((defined($env{'form.locarg'})) && ($env{'form.locarg'})) {
            $autharg = $env{'form.locarg'};
        }
    }
    my $logmsg;
    my $start_page=&Apache::loncommon::start_page('Create a New '.$crstype);
    my $crumbs = &Apache::lonhtmlcommon::breadcrumbs('Creation Outcome','Create_Course',undef,'Create_Courses');

    $r->print($start_page.$crumbs);

    my $args = {
               crstype => $crstype,
               ccuname => $ccuname,
               ccdomain => $ccdomain,
               cdescr => $env{'form.title'},
               curl => $env{'form.topmap'},
               course_domain => $env{'request.role.domain'},
               course_home =>  $env{'form.course_home'},
               nonstandard => $env{'form.nonstandard'},
               crscode => $env{'form.crscode'},
               crsquota => $env{'form.crsquota'},
               clonecourse => $env{'form.clonecourse'},
               clonedomain => $env{'form.clonedomain'},
               crsid => $env{'form.crsid'},
               curruser => $env{'user.name'}.':'.$env{'user.domain'},
               crssections => $env{'form.crssections'},
               crsxlist => $env{'form.crsxlist'},
               autoadds => $env{'form.autoadds'},
               autodrops => $env{'form.autodrops'},
               notify_owner => $env{'form.notify_owner'},
               notify_dc => $env{'form.notify_dc'},
               no_end_date => $env{'form.no_end_date'},
               showphotos => $env{'form.showphotos'},
               authtype => $authtype,
               autharg => $autharg,
               enrollstart => $enrollstart,
               enrollend => $enrollend,
               startaccess => $startaccess,
               endaccess => $endaccess,
               setpolicy => $env{'form.setpolicy'},
               setcontent => $env{'form.setcontent'},
               reshome => $env{'form.reshome'},
               setkeys => $env{'form.setkeys'},
               keyauth => $env{'form.keyauth'},
               disresdis => $env{'form.disresdis'},
               disablechat => $env{'form.disablechat'},
               openall => $env{'form.openall'},
               firstres => $env{'form.firstres'}
               };

    #
    # Verify data
    #
    # Check the veracity of the course coordinator
    if (&Apache::lonnet::homeserver($ccuname,$ccdomain) eq 'no_host') {
	$r->print('<form action="/adm/createuser" method="post" name="crtuser">');
        $r->print(&mt('No such user').' '.$ccuname.' '.&mt('at').' '.$ccdomain.'.<br />');
	$r->print(&mt("Please click Back on your browser and select another user, or "));
	$r->print('
	    <input type="hidden" name="phase" value="get_user_info" />
            <input type="hidden" name="ccuname" value="'.$ccuname.'" />
            <input type="hidden" name="ccdomain" value="'.$ccdomain.'" />
            <input name="userrole" type="submit" value="'.
		  &mt('Create User').'" />
	</form>'.&Apache::loncommon::end_page());
	return;
    }
    # Check the proposed home server for the course
    my %host_servers = 
	&Apache::lonnet::get_servers($env{'request.role.domain'},'library');
    if (! exists($host_servers{$env{'form.course_home'}})) {
        $r->print(&mt('Invalid home server for course').': '.
                  $env{'form.course_home'}.&Apache::loncommon::end_page());
        return;
    }
    my ($courseid,$crsudom,$crsunum);
    my ($success,$output) = 
	&Apache::loncommon::construct_course($args,\$logmsg,\$courseid,
					     \$crsudom,\$crsunum,
					     $env{'user.domain'},
					     $env{'user.name'});
    $r->print($output);
    if ($success) {
        #
	# Make the requested user a course coordinator or group coordinator
        #
	if (($ccdomain) && ($ccuname)) {
	    $r->print(&mt('Assigning role of [_1] Coordinator to [_2] at [_3]: ',
			  $crstype,$ccuname,$ccdomain).
		      &Apache::lonnet::assignrole($ccdomain,$ccuname,$courseid,
						  'cc').'<p>');
	}
	if ($env{'form.setkeys'}) {
	    $r->print(
		      '<p><a href="/adm/managekeys?cid='.$crsudom.'_'.$crsunum.'">'.&mt('Manage Access Keys').'</a></p>');
	}
        # Flush the course logs so reverse user roles immediately updated
	&Apache::lonnet::flushcourselogs();
	$r->print('<p>'.&mt('Roles will be active at next login').'.</p>');
    }
    $r->print('<p><a href="/adm/createcourse?phase='.lc($crstype).'one">'.
	      &mt('Create Another [_1]',$crstype).'</a></p>'.
	      &Apache::loncommon::end_page());
}

sub print_intro_page {
    my $r = shift;
    my $start_page =
        &Apache::loncommon::start_page('Create a New Course');
    my $crumbs = &Apache::lonhtmlcommon::breadcrumbs('Creation Options','Create_Course',undef,'Create_Courses');
    my $end_page =
        &Apache::loncommon::end_page();
    my $helplink=&Apache::loncommon::help_open_topic('Create_Course_GroupSpace',&mt('Help on Creating Courses and Groups'));

    my @choices = ({ internal_name => 'courseone',
                     name => &mt('Create a single course'),
                     short_description =>
    &mt('Create a new course by completing an online form.'),
                 },
#                   { internal_name => 'groupone',
#                     name => &mt('Create a single collaborative group space '),
#                     short_description =>
#    &mt('Create a new group space for non-course use by completing an online form .'),
#                 },
                   { internal_name => 'batchone',
                     name => &mt('Create courses/groups by uploading an attributes file'),
                     short_description =>
    &mt('Upload an attributes file containing specifications for one or more courses or groups in XML format'),
                     help => 'Batch_Creation',
                 },
    );
    my $options;
    foreach my $choice (@choices) {
        $options .='    <h3><a href="/adm/createcourse?phase='.
            $choice->{'internal_name'}.'" >'.
            $choice->{'name'}.'</a>';
        if (exists($choice->{'help'})) {
            $options .= &Apache::loncommon::help_open_topic($choice->{'help'});
        }
        $options .= "</h3>\n".'    '.('&nbsp;'x8).$choice->{'short_description'}.
            "\n";
    }

    $r->print(<<ENDDOCUMENT);
$start_page
$crumbs
$options
$end_page
ENDDOCUMENT
}

sub upload_batchfile {
    my $r = shift;
    my $start_page =
        &Apache::loncommon::start_page('Create a New Course or Group Space');
    my $crumbs = &Apache::lonhtmlcommon::breadcrumbs('Upload Course Attributes File','Create_Course',undef,'Create_Courses');
    my $end_page =
        &Apache::loncommon::end_page();
    $r->print($start_page.$crumbs);
    $r->print('<h3>'.&mt('Upload a courses attributes file').'</h3>');
    $r->print('<form name="batchcreate" method="post" '.
                'enctype="multipart/form-data" action="/adm/createcourse">'.
              '<input type="file" name="coursecreatorxml" />'.
              '<input type="hidden" name="phase" value="batchtwo"><br /><br />'.
              '<input type="submit" name="batchsubmit" '.
              'value="Create Courses/Groups" /></form>');
    $r->print($end_page);
    return;
}

sub process_batchfile {
    my $r = shift;
    my $start_page =
        &Apache::loncommon::start_page('Create a New Course or Group Space');
    my $crumbs = &Apache::lonhtmlcommon::breadcrumbs('Creation Outcome','Create_Course',undef,'Create_Courses');
    my $end_page =
        &Apache::loncommon::end_page();
    my $defdom=$env{'request.role.domain'};
    my $batchfilepath=&Apache::lonnet::userfileupload('coursecreatorxml',undef,
                                                      'batchupload',undef,undef,
                                                       undef,undef,$defdom);
    my ($batchdir,$filename) = ($batchfilepath =~ m-^(.+)/pending/([^/]+)$-);
    my ($result,$logmsg);
    if (-e "$batchfilepath") {
        open(FILE,"<$batchfilepath");
        my @buffer = <FILE>;
        close(FILE);
        if ((defined($filename)) && (defined($batchdir))) {
            my @requests = ($filename);
            my %courseids = ();
            ($result,$logmsg) = &LONCAPA::batchcreatecourse::create_courses(
                                        \@requests,\%courseids,'web',$defdom,
                                        $env{'user.name'},$env{'user.domain'});
            if ($result) {
                if (!-e "$batchdir/processed") {
                    mkdir("$batchdir/processed", 0755);
                    open(FILE,">$batchdir/processed/$filename");
                    print FILE @buffer;
                    close(FILE);
                    if (-e "$batchdir/processed/$filename") {
                        unlink("$batchdir/pending/$filename");
                    }
                }
            }
        }
    }
    $r->print($start_page.$crumbs.$logmsg.$result.'<br /><a href="/adm/createcourse">'.
              &mt('Creation options menu').'</a>'.$end_page);
 
}

# ===================================================================== Handler
sub handler {
    my $r = shift;

    if ($r->header_only) {
       &Apache::loncommon::content_type($r,'text/html');
       $r->send_http_header;
       return OK;
    }

    if (&Apache::lonnet::allowed('ccc',$env{'request.role.domain'})) {
       &Apache::loncommon::content_type($r,'text/html');
       $r->send_http_header;

       &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['phase']);
       &Apache::lonhtmlcommon::clear_breadcrumbs();
       &Apache::lonhtmlcommon::add_breadcrumb
          ({href=>"/adm/createcourse",
            text=>"Creation Options",
            faq=>79,bug=>'Dom Coord Interface',});
       if (($env{'form.phase'} eq 'coursetwo') ||
           ($env{'form.phase'} eq 'grouptwo')) {
           &Apache::lonhtmlcommon::add_breadcrumb
                 ({href=>"/adm/createcourse?phase=$env{'form.prevphase'}",
                   text=>&mt('[_1] Creation Settings',),
                   faq=>9,bug=>'Dom Coord Interface',});
          &Apache::lonhtmlcommon::add_breadcrumb
                 ({href=>"/adm/createcourse?phase=$env{'form.phase'}",
                   text=>"Creation Outcome",
                   faq=>9,bug=>'Dom Coord Interface',});
           &create_course($r);
       } elsif (($env{'form.phase'} eq 'courseone') || 
                ($env{'form.phase'} eq 'groupone')) {
           &Apache::lonhtmlcommon::add_breadcrumb
                 ({href=>"/adm/createcourse?phase=$env{'form.phase'}",
                   text=>&mt('[_1] Creation Settings',),
                   faq=>9,bug=>'Dom Coord Interface',});
	   &print_course_creation_page($r);
       } elsif ($env{'form.phase'} eq 'batchone') {
           &Apache::lonhtmlcommon::add_breadcrumb
                 ({href=>"/adm/createcourse?phase=$env{'form.phase'}",
                   text=>"Upload Description File",
                   faq=>9,bug=>'Dom Coord Interface',});
           &upload_batchfile($r);
       } elsif ($env{'form.phase'} eq 'batchtwo') {
           &Apache::lonhtmlcommon::add_breadcrumb
                 ({href=>"/adm/createcourse?phase=$env{'form.prevphase'}",
                   text=>"Upload Description File",
                   faq=>9,bug=>'Dom Coord Interface',});
           &Apache::lonhtmlcommon::add_breadcrumb
                 ({href=>"/adm/createcourse?phase=$env{'form.phase'}",
                   text=>"Creation Outcome",
                   faq=>9,bug=>'Dom Coord Interface',});
           &process_batchfile($r);
       } else {
           &print_intro_page($r);
       }
   } else {
      $env{'user.error.msg'}=
        "/adm/createcourse:ccc:0:0:Cannot create courses or groups";
      return HTTP_NOT_ACCEPTABLE; 
   }
   return OK;
}

1;
__END__
