# The LearningOnline Network with CAPA
# Handler to show differences between file versions
#
# $Id: londiff.pm,v 1.23 2007/01/15 18:34:32 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::londiff;

use strict;
use Apache::File;
use File::Copy;
use File::Compare;
use Algorithm::Diff qw(diff);
use Apache::Constants qw(:common :http :methods);
use Apache::loncacc();
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonretrieve();
use Apache::lonlocal;
use LONCAPA();

sub get_split_file {
    my ($fn,$style)=@_;
    my $f1;
    my @f1;
    if ($style eq 'local') {
	if (-e $fn) {
	    my $fh=Apache::File->new($fn);
	    my $line;	
	    while($line=<$fh>) {
		$f1.=$line;
	    }
	}
    } elsif ($style eq 'remote') {
	$f1=&Apache::lonnet::getfile($fn);
    }
    @f1=split(/\r\n|\r|\n/,$f1);
    return @f1;
}

sub are_different_files {
    my ($fileone,$filetwo)=@_;
    return &compare($fileone,$filetwo);
}

sub handler {

    my $r=shift;
# Get query string for limited number of parameters

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
					    ['filename','versiontwo',
					     'versionone','filetwo']);
# Get the files

    my $cuname=$env{'user.name'};
    my $cudom=$env{'user.domain'};

    if ($env{'form.filename'}=~/^\/res\//) {
	($cudom,$cuname,$env{'form.filename'})=
	    ($env{'form.filename'}=~m{^/res/($LONCAPA::domain_re)/($LONCAPA::username_re)/(.*)$});
    } else {
	unless (($cuname,$cudom)=
		&Apache::loncacc::constructaccess($env{'form.filename'},
						  $r->dir_config('lonDefDomain'))) {
	    $r->log_reason($cuname.':'.$cudom.
			   ' trying to get diffs file '.$env{'form.filename'}.
			   '  - not authorized', 
			   $r->filename); 
	    return HTTP_NOT_ACCEPTABLE;
	}
    }
  
    my $efn=$env{'form.filename'};

    $efn=~s{/\~($LONCAPA::username_re)}{}g;

    my @f1=();
    my @f2=();

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

    $r->print(&Apache::loncommon::start_page('Resource Differences'));

  
    $r->print('<h1>'.($env{'form.filetwo'}?'':&mt('Compare versions of')).
	      ' <tt>'.$efn.'</tt></h1>');
   
    if (($cuname ne $env{'user.name'}) || ($cudom ne $env{'user.domain'})) {
	$r->print('<h3><span class="LC_diff_coauthor">Co-Author: '.$cuname.' at '.$cudom.
		  '</span></h3>');
    }


    if (&Apache::loncommon::fileembstyle(($efn=~/\.(\w+)$/)) eq 'ssi'
	|| $efn =~ /\.meta$/) {
	$r->print('<p><span class="LC_diff_removed">');
	if ($env{'form.versionone'} eq 'priv') {
	    my $fn='/home/'.$cuname.'/public_html/'.$efn;
	    @f1=&get_split_file($fn,'local');
	    $r->print('<b>'.&mt('Construction Space Version').'</b>');
	} else {
	    my $fn=
		'/home/httpd/html/res/'.$cudom.'/'.$cuname.'/';
	    if ($env{'form.versionone'}) {
		my ($main,$suffix,$is_meta)=
		    &Apache::lonretrieve::get_file_info($efn);
		
		$fn.=($efn =~m|(.*/)[^/]+|)[0];
		# add on to $fn the path information in $efn
		$fn.=$main.'.'.$env{'form.versionone'}.'.'.$suffix;
		$r->print('<b>'.&mt('Version').' '.$env{'form.versionone'}.'</b>');
	    } else {
		$fn.=$efn;
		$r->print('<b>'.&mt('Current Version').'</b>');
	    }
	    @f1=&get_split_file($fn,'remote');
	}
	
	$r->print('</span><br />'.&mt('versus').'<br /><span class="LC_diff_added">');

	if ($env{'form.filetwo'}) {
	    my $efn2=$env{'form.filetwo'};
	    $efn2=~s{/\~($LONCAPA::username_re)}{}g;
	    my $fn='/home/'.$cuname.'/public_html/'.$efn2;
	    @f2=&get_split_file($fn,'local');
	    $r->print('<tt>'.$efn2.'</tt>');
	} elsif ($env{'form.versiontwo'} eq 'priv') {
	    my $fn='/home/'.$cuname.'/public_html/'.$efn;
	    @f2=&get_split_file($fn,'local');
	    $r->print('<b>'.&mt('Construction Space Version').'</b>');
	} else {
	    my $fn=
		'/home/httpd/html/res/'.$cudom.'/'.$cuname.'/';
	    if ($env{'form.versiontwo'}) {
		my ($main,$suffix,$is_meta)=
		    &Apache::lonretrieve::get_file_info($efn);
		# add on to $fn the path information in $efn
		$fn.=($efn =~m|(.*/)[^/]+|)[0];
		$fn.=$main.'.'.$env{'form.versiontwo'}.'.'.$suffix;
		$r->print('<b>'.&mt('Version').' '.$env{'form.versiontwo'}.'</b>');
	    } else {
		$fn.=$efn;
		$r->print('<b>'.&mt('Current Version').'</b>');
	    }
	    @f2=&get_split_file($fn,'remote');
	}
	$r->print('</span></p>');
# Run diff

	my $diffs = diff(\@f1, \@f2);
	
# Start page output

	my $chunk;
	my $line;

	$r->print('<pre>');
	
	foreach $chunk (@$diffs) {
	 
	    foreach $line (@$chunk) {
		my ($sign, $lineno, $text) = @$line;
		$text=&HTML::Entities::encode($text,'<>&"');
		$lineno=substr($lineno.'        ',0,7);
		$r->print('<span class="'.(($sign eq '+')?'LC_diff_added'
                                                         :'LC_diff_removed').'">'.
			  $sign.' '.$lineno.' '.$text."</span>\n");
	    }
	    $r->print("</pre><hr /><pre>\n");
	}
	$r->print('</pre>');
	
    } else {
	$r->print('<h1><span class="LC_warning">'.&mt('Binary File').'</span></h1>');
    }
    $r->print('<center><a href="javascript:window.close();">'.&mt('Close This Window').'</a></center>');
    $r->print(&Apache::loncommon::end_page()); 
    return OK;  
}


1;
__END__




