/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Shape;
import org.jmol.shape.Text;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.JmolConstants;

public class Labels
extends AtomShape {
    String[] strings;
    String[] formats;
    short[] bgcolixes;
    byte[] fids;
    int[] offsets;
    Hashtable atomLabels = new Hashtable();
    Text text;
    BitSet bsFontSet;
    BitSet bsBgColixSet;
    int defaultOffset;
    byte defaultFontId;
    short defaultColix;
    short defaultBgcolix;
    byte defaultPaletteID;
    int defaultAlignment;
    int defaultPointer;
    byte zeroFontId;
    int zeroOffset;
    boolean defaultsOnlyForNone = true;
    static final int ZPOS_FLAGS = 48;
    static final int FRONT_FLAG = 32;
    static final int GROUP_FLAG = 16;
    static final int POINTER_FLAGS = 3;
    static final int ALIGN_FLAGS = 12;
    static final int FLAGS = 63;

    public void initShape() {
        super.initShape();
        this.defaultFontId = this.zeroFontId = this.g3d.getFont3D((String)"SansSerif", (String)"Plain", (int)13).fid;
        this.defaultColix = 0;
        this.defaultBgcolix = 0;
        this.zeroOffset = 1028;
        this.defaultOffset = 1028;
        this.translucentAllowed = false;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        this.isActive = true;
        if ("color" == string) {
            this.isActive = true;
            int n = 0;
            byte by = JmolConstants.pidOf(object);
            short s = Graphics3D.getColix((Object)object);
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (!bitSet.get(n2)) continue;
                this.setColix(n2, s, by, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultColix = s;
                this.defaultPaletteID = by;
            }
            return;
        }
        if ("label" == string) {
            this.isActive = true;
            if (this.bsSizeSet == null) {
                this.bsSizeSet = new BitSet();
            }
            String string2 = (String)object;
            int n = this.atomCount;
            while (--n >= 0) {
                Atom atom;
                if (!bitSet.get(n)) continue;
                String string3 = (atom = this.atoms[n]).formatLabel(string2);
                atom.setShapeVisibility(this.myVisibilityFlag, string3 != null);
                if (this.strings == null || n >= this.strings.length) {
                    this.strings = ArrayUtil.ensureLength((String[])this.strings, (int)(n + 1));
                }
                if (this.formats == null || n >= this.formats.length) {
                    this.formats = ArrayUtil.ensureLength((String[])this.formats, (int)(n + 1));
                }
                this.strings[n] = string3;
                this.formats[n] = string2;
                this.bsSizeSet.set(n, string2 != null);
                this.text = this.getLabel(n);
                if (this.text != null) {
                    this.text.setText(string3);
                }
                if (this.defaultOffset != this.zeroOffset) {
                    this.setOffsets(n, this.defaultOffset, -1);
                }
                if (this.defaultAlignment != 1) {
                    this.setAlignment(n, this.defaultAlignment, -1);
                }
                if (this.defaultPointer != 0) {
                    this.setPointer(n, this.defaultPointer, -1);
                }
                if (this.defaultColix != 0 || this.defaultPaletteID != 0) {
                    this.setColix(n, this.defaultColix, this.defaultPaletteID, -1);
                }
                if (this.defaultBgcolix != 0) {
                    this.setBgcolix(n, this.defaultBgcolix, -1);
                }
                if (this.defaultFontId == this.zeroFontId) continue;
                this.setFont(n, this.defaultFontId, -1);
            }
            return;
        }
        if ("bgcolor" == string) {
            this.isActive = true;
            if (this.bsBgColixSet == null) {
                this.bsBgColixSet = new BitSet();
            }
            short s = Graphics3D.getColix((Object)object);
            int n = 0;
            int n3 = this.atomCount;
            while (--n3 >= 0) {
                if (!bitSet.get(n3)) continue;
                this.setBgcolix(n3, s, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultBgcolix = s;
            }
            return;
        }
        if (this.bsFontSet == null) {
            this.bsFontSet = new BitSet();
        }
        if ("fontsize" == string) {
            int n = (Integer)object;
            if (n < 0) {
                this.fids = null;
                return;
            }
            byte by = this.g3d.getFontFid(n);
            int n4 = 0;
            int n5 = this.atomCount;
            while (--n5 >= 0) {
                if (!bitSet.get(n5)) continue;
                this.setFont(n5, by, n4++);
            }
            if (n4 == 0 || !this.defaultsOnlyForNone) {
                this.defaultFontId = by;
            }
            return;
        }
        if ("font" == string) {
            byte by = ((Font3D)object).fid;
            int n = 0;
            int n6 = this.atomCount;
            while (--n6 >= 0) {
                if (!bitSet.get(n6)) continue;
                this.setFont(n6, by, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultFontId = by;
            }
            return;
        }
        if ("offset" == string) {
            int n = (Integer)object;
            if (n == 0) {
                n = Short.MAX_VALUE;
            } else if (n == this.zeroOffset) {
                n = 0;
            }
            int n7 = 0;
            int n8 = this.atomCount;
            while (--n8 >= 0) {
                if (!bitSet.get(n8)) continue;
                this.setOffsets(n8, n, n7++);
            }
            if (n7 == 0 || !this.defaultsOnlyForNone) {
                this.defaultOffset = n | this.defaultOffset & 0x30;
            }
            return;
        }
        if ("align" == string) {
            String string4 = (String)object;
            int n = 1;
            if (string4.equalsIgnoreCase("right")) {
                n = 3;
            } else if (string4.equalsIgnoreCase("center")) {
                n = 2;
            }
            int n9 = 0;
            int n10 = this.atomCount;
            while (--n10 >= 0) {
                if (!bitSet.get(n10)) continue;
                this.setAlignment(n10, n, n9++);
            }
            if (n9 == 0 || !this.defaultsOnlyForNone) {
                this.defaultAlignment = n;
            }
            return;
        }
        if ("pointer" == string) {
            int n = (Integer)object;
            int n11 = 0;
            int n12 = this.atomCount;
            while (--n12 >= 0) {
                if (!bitSet.get(n12)) continue;
                this.setPointer(n12, n, n11++);
            }
            if (n11 == 0 || !this.defaultsOnlyForNone) {
                this.defaultPointer = n;
            }
            return;
        }
        if ("front" == string) {
            boolean bl = (Boolean)object;
            int n = 0;
            int n13 = this.atomCount;
            while (--n13 >= 0) {
                if (!bitSet.get(n13)) continue;
                this.setFront(n13, bl, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultOffset = this.defaultOffset & 0xFFFFFFCF | (bl ? 32 : 0);
            }
            return;
        }
        if ("group" == string) {
            boolean bl = (Boolean)object;
            int n = 0;
            int n14 = this.atomCount;
            while (--n14 >= 0) {
                if (!bitSet.get(n14)) continue;
                this.setGroup(n14, bl, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultOffset = this.defaultOffset & 0xFFFFFFCF | (bl ? 16 : 0);
            }
            return;
        }
        if ("toggleLabel" == string) {
            int n = this.atomCount;
            while (--n >= 0) {
                Atom atom = this.atoms[n];
                if (bitSet.get(n)) {
                    if (this.formats == null || n >= this.formats.length) {
                        this.formats = ArrayUtil.ensureLength((String[])this.formats, (int)(n + 1));
                    }
                    if (this.strings != null && this.strings.length > n && this.strings[n] != null) {
                        this.strings[n] = null;
                        this.formats[n] = null;
                        this.bsSizeSet.clear(n);
                    } else {
                        String string5 = this.viewer.getStandardLabelFormat();
                        this.strings = ArrayUtil.ensureLength((String[])this.strings, (int)(n + 1));
                        this.strings[n] = atom.formatLabel(string5);
                        this.formats[n] = string5;
                        this.bsSizeSet.set(n);
                    }
                } else if (this.strings != null && n < this.strings.length) {
                    this.strings[n] = null;
                }
                atom.setShapeVisibility(this.myVisibilityFlag, this.strings != null && n < this.strings.length && this.strings[n] != null);
            }
            return;
        }
    }

    void putLabel(int n, Text text) {
        if (text == null) {
            this.atomLabels.remove((Object)this.atoms[n]);
        } else {
            this.atomLabels.put(this.atoms[n], text);
        }
    }

    Text getLabel(int n) {
        return (Text)this.atomLabels.get((Object)this.atoms[n]);
    }

    void setColix(int n, short s, byte by, int n2) {
        this.setColixAndPalette(s, by, n);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setColix(this.colixes[n]);
        }
    }

    void setBgcolix(int n, short s, int n2) {
        if (this.bgcolixes == null || n >= this.bgcolixes.length) {
            if (s == 0) {
                return;
            }
            this.bgcolixes = ArrayUtil.ensureLength((short[])this.bgcolixes, (int)(n + 1));
        }
        this.bgcolixes[n] = s;
        this.bsBgColixSet.set(n, s != 0);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setBgColix(s);
        }
    }

    void setOffsets(int n, int n2, int n3) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength((int[])this.offsets, (int)(n + 1));
        }
        this.offsets[n] = (this.offsets[n] & 0x3F) + (n2 << 6);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setOffset(n2);
        }
    }

    void setAlignment(int n, int n2, int n3) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 1) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength((int[])this.offsets, (int)(n + 1));
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFF3) + (n2 << 2);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setAlignment(n2);
        }
    }

    void setPointer(int n, int n2, int n3) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength((int[])this.offsets, (int)(n + 1));
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFFC) + n2;
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setPointer(n2);
        }
    }

    void setFront(int n, boolean bl, int n2) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (!bl) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength((int[])this.offsets, (int)(n + 1));
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFCF) + (bl ? 32 : 0);
    }

    void setGroup(int n, boolean bl, int n2) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (!bl) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength((int[])this.offsets, (int)(n + 1));
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFCF) + (bl ? 16 : 0);
    }

    void setFont(int n, byte by, int n2) {
        if (this.fids == null || n >= this.fids.length) {
            if (by == this.zeroFontId) {
                return;
            }
            this.fids = ArrayUtil.ensureLength((byte[])this.fids, (int)(n + 1));
        }
        this.fids[n] = by;
        this.bsFontSet.set(n);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setFid(by);
        }
    }

    public void setModelClickability() {
        if (this.strings == null) {
            return;
        }
        int n = this.strings.length;
        while (--n >= 0) {
            String string = this.strings[n];
            if (string == null || this.modelSet.atoms.length <= n || this.modelSet.isAtomHidden(n)) continue;
            this.modelSet.atoms[n].setClickable(this.myVisibilityFlag);
        }
    }

    public void getDefaultState(StringBuffer stringBuffer) {
        Shape.appendCmd(stringBuffer, "\n# label defaults;\nselect none");
        Shape.appendCmd(stringBuffer, this.getColorCommand("label", this.defaultPaletteID, this.defaultColix));
        Shape.appendCmd(stringBuffer, "background label " + this.encodeColor(this.defaultBgcolix));
        Shape.appendCmd(stringBuffer, "labelOffset = " + Text.getXOffset(this.defaultOffset) + " " + -Text.getYOffset(this.defaultOffset));
        String string = Text.getAlignment(this.defaultAlignment);
        Shape.appendCmd(stringBuffer, "labelAlignment = " + (string.length() < 5 ? "left" : string));
        String string2 = Text.getPointer(this.defaultPointer);
        Shape.appendCmd(stringBuffer, "labelPointer = " + (string2.length() == 0 ? "off" : string2));
        if ((this.defaultOffset & 0x20) != 0) {
            Shape.appendCmd(stringBuffer, "set labelFront");
        }
        if ((this.defaultOffset & 0x10) != 0) {
            Shape.appendCmd(stringBuffer, "set labelGroup");
        }
        Shape.appendCmd(stringBuffer, Shape.getFontCommand("label", Font3D.getFont3D((byte)this.defaultFontId)));
    }

    public String getShapeState() {
        if (!this.isActive) {
            return "";
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.bsSizeSet == null || !this.bsSizeSet.get(n)) continue;
            Shape.setStateInfo(hashtable, n, "label " + Escape.escape((String)this.formats[n]));
            if (this.bsColixSet != null && this.bsColixSet.get(n)) {
                Shape.setStateInfo(hashtable2, n, this.getColorCommand("label", this.paletteIDs[n], this.colixes[n]));
            }
            if (this.bsBgColixSet != null && this.bsBgColixSet.get(n)) {
                Shape.setStateInfo(hashtable2, n, "background label " + this.encodeColor(this.bgcolixes[n]));
            }
            if (this.offsets != null && this.offsets.length > n) {
                int n2 = this.offsets[n];
                Shape.setStateInfo(hashtable2, n, "labelOffset = " + Text.getXOffset(n2 >> 6) + " " + -Text.getYOffset(n2 >> 6));
                String string = Text.getAlignment(n2 >> 2);
                String string2 = Text.getPointer(n2);
                if (string2.length() > 0) {
                    Shape.setStateInfo(hashtable2, n, "labelPointer = " + string2);
                }
                if ((n2 & 0x20) != 0) {
                    Shape.setStateInfo(hashtable2, n, "set labelFront");
                }
                if ((n2 & 0x10) != 0) {
                    Shape.setStateInfo(hashtable2, n, "set labelGroup");
                }
                if (string.length() > 0) {
                    Shape.setStateInfo(hashtable3, n, "labelAlignment = " + string);
                }
            }
            if (this.bsFontSet == null || !this.bsFontSet.get(n)) continue;
            Shape.setStateInfo(hashtable2, n, Shape.getFontCommand("label", Font3D.getFont3D((byte)this.fids[n])));
        }
        return Shape.getShapeCommands(hashtable, hashtable2, this.atomCount) + Shape.getShapeCommands(null, hashtable3, this.atomCount);
    }
}

