/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.JmolConstants;

public class ColorEncoder {
    private int palette = 0;
    private static final String[] colorSchemes = new String[]{"roygb", "bgyor", "rwb", "bwr", "low", "high"};
    private static final int ROYGB = 0;
    private static final int BGYOR = 1;
    private static final int RWB = 2;
    private static final int BWR = 3;
    private static final int LOW = 4;
    private static final int HIGH = 5;
    private static final int ihalf = JmolConstants.argbsRoygbScale.length / 3;

    public int setColorScheme(String string) {
        this.palette = ColorEncoder.getColorScheme(string);
        return this.palette;
    }

    public static final int getColorScheme(String string) {
        for (int i = 0; i < colorSchemes.length; ++i) {
            if (!colorSchemes[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return 0;
    }

    public static final short getColorIndexFromPalette(float f, float f2, float f3, int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = JmolConstants.argbsRoygbScale[ColorEncoder.quantize(f, f2, f3, JmolConstants.argbsRoygbScale.length)];
                break;
            }
            case 1: {
                n2 = JmolConstants.argbsRoygbScale[ColorEncoder.quantize(-f, -f3, -f2, JmolConstants.argbsRoygbScale.length)];
                break;
            }
            case 4: {
                n2 = JmolConstants.argbsRoygbScale[ColorEncoder.quantize(f, f2, f3, ihalf)];
                break;
            }
            case 5: {
                n2 = JmolConstants.argbsRoygbScale[ihalf + ColorEncoder.quantize(f, f2, f3, ihalf) * 2];
                break;
            }
            case 2: {
                n2 = JmolConstants.argbsRwbScale[ColorEncoder.quantize(f, f2, f3, JmolConstants.argbsRwbScale.length)];
                break;
            }
            case 3: {
                n2 = JmolConstants.argbsRwbScale[ColorEncoder.quantize(-f, -f3, -f2, JmolConstants.argbsRwbScale.length)];
                break;
            }
            default: {
                n2 = -8355712;
            }
        }
        return ColorEncoder.getColorIndex(n2);
    }

    public static final short getColorIndex(int n) {
        return Graphics3D.getColix(n);
    }

    public static final int quantize(float f, float f2, float f3, int n) {
        float f4 = f3 - f2;
        if (f4 <= 0.0f || Float.isNaN(f)) {
            return n / 2;
        }
        float f5 = f - f2;
        if (f5 <= 0.0f) {
            return 0;
        }
        float f6 = f4 / (float)n;
        int n2 = (int)(f5 / f6 + 1.0E-4f);
        if (n2 >= n) {
            n2 = n - 1;
        }
        return n2;
    }

    public short getColorIndexFromPalette(float f, float f2, float f3) {
        return ColorEncoder.getColorIndexFromPalette(f, f2, f3, this.palette);
    }
}

