/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class SpartanArchive {
    int atomCount = 0;
    String bondData;
    int bondCount = 0;
    int moCount = 0;
    int shellCount = 0;
    int gaussianCount = 0;
    String calculationType = "";
    BufferedReader reader;
    String line;
    AtomSetCollection atomSetCollection;
    AtomSetCollectionReader r;
    Hashtable moData;
    Vector orbitals = new Vector();

    String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    SpartanArchive(AtomSetCollectionReader atomSetCollectionReader, AtomSetCollection atomSetCollection, Hashtable hashtable) {
        this.initialize(atomSetCollectionReader, atomSetCollection, hashtable, "");
    }

    SpartanArchive(AtomSetCollectionReader atomSetCollectionReader, AtomSetCollection atomSetCollection, Hashtable hashtable, String string) {
        this.initialize(atomSetCollectionReader, atomSetCollection, hashtable, string);
    }

    private void initialize(AtomSetCollectionReader atomSetCollectionReader, AtomSetCollection atomSetCollection, Hashtable hashtable, String string) {
        this.r = atomSetCollectionReader;
        this.reader = atomSetCollectionReader.reader;
        this.atomSetCollection = atomSetCollection;
        this.moData = hashtable;
        hashtable.put("energyUnits", "");
        this.bondData = string;
    }

    int readArchive(String string, boolean bl) throws Exception {
        this.atomCount = this.setInfo(string);
        String string2 = this.line = bl ? "GEOMETRY" : "";
        while (this.line != null) {
            if (this.line.equals("GEOMETRY")) {
                this.readAtoms();
                if (this.bondData.length() > 0) {
                    this.addBonds(this.bondData);
                }
            } else if (this.line.indexOf("BASIS") == 0) {
                this.readBasis();
            } else if (this.line.indexOf("WAVEFUNC") == 0 || this.line.indexOf("BETA") == 0) {
                this.readMolecularOrbital();
                this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
            } else if (this.line.equals("ENDARCHIVE") || this.line.equals("END Compound Document Entry: Archive")) break;
            this.readLine();
        }
        return this.atomCount;
    }

    static String[] getTokens(String string) {
        return Parser.getTokens(string);
    }

    int parseInt(String string) {
        return this.r.parseInt(string);
    }

    float parseFloat(String string) {
        return this.r.parseFloat(string);
    }

    int setInfo(String string) throws Exception {
        String[] stringArray = SpartanArchive.getTokens(string);
        if (Logger.isActiveLevel(0)) {
            Logger.debug("reading Spartan archive info :" + string);
        }
        this.atomCount = this.parseInt(stringArray[0]);
        this.moCount = this.parseInt(stringArray[1]);
        this.shellCount = this.parseInt(stringArray[2]);
        this.gaussianCount = this.parseInt(stringArray[3]);
        this.calculationType = stringArray[9];
        String string2 = (String)this.moData.get("calculationType");
        if (string2 != null) {
            this.calculationType = this.calculationType + string2;
        }
        this.moData.put("calculationType", this.calculationType);
        return this.atomCount;
    }

    void readAtoms() throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            String[] stringArray = this.getTokens();
            float f = this.parseFloat(stringArray[1]);
            float f2 = this.parseFloat(stringArray[2]);
            float f3 = this.parseFloat(stringArray[3]);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(this.parseInt(stringArray[0]));
            atom.x = f * 0.5291772f;
            atom.y = f2 * 0.5291772f;
            atom.z = f3 * 0.5291772f;
        }
        if (Logger.isActiveLevel(0)) {
            Logger.debug(this.atomCount + " atoms read");
        }
    }

    void addBonds(String string) {
        this.addBonds(string, 0);
    }

    void addBonds(String string, int n) {
        String[] stringArray = SpartanArchive.getTokens(string);
        this.bondCount = 0;
        int n2 = this.atomCount;
        while (n2 < stringArray.length) {
            int n3;
            int n4 = this.parseInt(stringArray[n2++]) - 1 + n;
            int n5 = this.parseInt(stringArray[n2++]) - 1 + n;
            if ((n3 = this.parseInt(stringArray[n2++])) <= 0) continue;
            this.atomSetCollection.addBond(new Bond(n4, n5, n3 < 4 ? n3 : 1));
            ++this.bondCount;
        }
        if (Logger.isActiveLevel(0)) {
            Logger.debug(this.bondCount + " bonds read");
        }
    }

    void readBasis() throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        Vector<int[]> vector = new Vector<int[]>();
        float[][] fArrayArray = new float[this.gaussianCount][];
        int[] nArray = new int[this.gaussianCount];
        for (n3 = 0; n3 < this.shellCount; ++n3) {
            this.readLine();
            String[] stringArray = this.getTokens();
            objectArray = new int[4];
            objectArray[0] = this.parseInt(stringArray[3]) - 1;
            n2 = this.parseInt(stringArray[0]);
            objectArray[1] = n2 == 0 ? 0 : n2 + 1;
            int n4 = objectArray[2] = this.parseInt(stringArray[2]) - 1;
            n = objectArray[3] = this.parseInt(stringArray[1]);
            for (int i = 0; i < n; ++i) {
                nArray[n4 + i] = n2;
            }
            vector.addElement((int[])objectArray);
        }
        for (n3 = 0; n3 < this.gaussianCount; ++n3) {
            float f = this.parseFloat(this.readLine());
            objectArray = SpartanArchive.getTokens(this.readLine());
            n2 = objectArray.length;
            float[] fArray = new float[n2 + 1];
            fArray[0] = f;
            n = nArray[n3];
            switch (n) {
                case 1: {
                    fArray[2] = this.parseFloat((String)objectArray[1]);
                }
                case 0: {
                    fArray[1] = this.parseFloat((String)objectArray[0]);
                    break;
                }
                case 2: {
                    fArray[1] = this.parseFloat((String)objectArray[2]);
                    break;
                }
                case 3: {
                    fArray[1] = this.parseFloat((String)objectArray[3]);
                }
            }
            fArrayArray[n3] = fArray;
        }
        this.moData.put("shells", vector);
        this.moData.put("gaussians", fArrayArray);
        if (Logger.isActiveLevel(0)) {
            Logger.debug(vector.size() + " slater shells read");
            Logger.debug(fArrayArray.length + " gaussian primitives read");
        }
    }

    void readMolecularOrbital() throws Exception {
        int n;
        int n2 = 0;
        String[] stringArray = SpartanArchive.getTokens("");
        float[] fArray = new float[this.moCount];
        float[][] fArray2 = new float[this.moCount][this.moCount];
        for (n = 0; n < this.moCount; ++n) {
            if (n2 == stringArray.length) {
                stringArray = SpartanArchive.getTokens(this.readLine());
                n2 = 0;
            }
            fArray[n] = this.parseFloat(stringArray[n2++]);
        }
        for (n = 0; n < this.moCount; ++n) {
            for (int i = 0; i < this.moCount; ++i) {
                if (n2 == stringArray.length) {
                    stringArray = SpartanArchive.getTokens(this.readLine());
                    n2 = 0;
                }
                fArray2[n][i] = this.parseFloat(stringArray[n2++]);
            }
        }
        for (n = 0; n < this.moCount; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("energy", new Float(fArray[n]));
            hashtable.put("coefficients", fArray2[n]);
            this.orbitals.addElement(hashtable);
        }
        if (Logger.isActiveLevel(0)) {
            Logger.debug(this.orbitals.size() + " molecular orbitals read");
        }
        this.moData.put("mos", this.orbitals);
    }

    void readProperties() throws Exception {
        Logger.debug("Reading PROPARC properties records...");
        while (!(this.readLine() == null || this.line.length() >= 10 && this.line.substring(0, 10).equals("ENDPROPARC"))) {
            if (this.line.length() >= 4 && this.line.substring(0, 4).equals("PROP")) {
                this.readProperty();
            }
            if (this.line.length() >= 6 && this.line.substring(0, 6).equals("DIPOLE")) {
                this.readDipole();
            }
            if (this.line.length() < 7 || !this.line.substring(0, 7).equals("VIBFREQ")) continue;
            this.readVibFreqs();
        }
    }

    void readDipole() throws Exception {
        this.readLine();
        String[] stringArray = this.getTokens();
        if (stringArray.length != 3) {
            return;
        }
        Vector3f vector3f = new Vector3f(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]));
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("dipole", vector3f);
    }

    void readProperty() throws Exception {
        String[] stringArray = this.getTokens();
        if (stringArray.length == 0) {
            return;
        }
        boolean bl = stringArray[1].equals("STRING");
        String string = stringArray[2];
        Object object = new Object();
        Vector<Object> vector = new Vector<Object>();
        if (stringArray[3].equals("=")) {
            object = bl ? this.getQuotedString(stringArray[4].substring(0, 1)) : new Float(this.parseFloat(stringArray[4]));
        } else if (stringArray[stringArray.length - 1].equals("BEGIN")) {
            int n = this.parseInt(stringArray[stringArray.length - 2]);
            if (n == 0) {
                n = 1;
            }
            boolean bl2 = stringArray.length == 6;
            Vector<Float> vector2 = new Vector<Float>();
            while (this.readLine() != null && !this.line.substring(0, 3).equals("END")) {
                if (bl) {
                    object = this.getQuotedString("\"");
                    vector.addElement(object);
                    continue;
                }
                String[] stringArray2 = this.getTokens();
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (bl2) {
                        vector2.addElement(new Float(this.parseFloat(stringArray2[i])));
                        if ((i + 1) % n != 0) continue;
                        vector.addElement(vector2);
                        vector2 = new Vector();
                        continue;
                    }
                    object = new Float(this.parseFloat(stringArray2[i]));
                    vector.addElement(object);
                }
            }
            object = null;
        } else if (Logger.isActiveLevel(0)) {
            Logger.debug(" Skipping property line " + this.line);
        }
        if (object != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(string, object);
        }
        if (vector.size() != 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(string, vector);
        }
    }

    void readVibFreqs() throws Exception {
        Cloneable cloneable;
        int n;
        this.readLine();
        String string = "";
        int n2 = this.parseInt(this.line);
        Vector<Cloneable> vector = new Vector<Cloneable>();
        Vector<Cloneable> vector2 = new Vector<Cloneable>();
        if (Logger.isActiveLevel(0)) {
            Logger.debug("reading VIBFREQ vibration records: frequencyCount = " + n2);
        }
        for (n = 0; n < n2; ++n) {
            int n3 = this.atomSetCollection.getAtomCount();
            this.atomSetCollection.cloneLastAtomSet();
            this.addBonds(this.bondData, n3);
            this.readLine();
            cloneable = new Hashtable();
            float f = this.parseFloat(this.line);
            ((Hashtable)cloneable).put("freq", new Float(f));
            if (this.line.length() > 15 && !(string = this.line.substring(15, this.line.length())).equals("???")) {
                ((Hashtable)cloneable).put("label", string);
            }
            vector2.addElement(cloneable);
            this.atomSetCollection.setAtomSetName(string + " " + f + " cm^-1");
            this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", vector2);
        n = this.atomSetCollection.getFirstAtomSetAtomCount();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        cloneable = new Vector();
        Vector<Float> vector3 = new Vector<Float>();
        int n4 = 0;
        int n5 = n;
        int n6 = 3;
        float[] fArray = new float[3];
        while (this.readLine() != null) {
            String[] stringArray = this.getTokens();
            for (int i = 0; i < stringArray.length; ++i) {
                float f;
                fArray[i % n6] = f = this.parseFloat(stringArray[i]);
                vector3.addElement(new Float(f));
                if ((i + 1) % n6 != 0) continue;
                atomArray[n5].addVibrationVector(fArray[0], fArray[1], fArray[2]);
                ((Vector)cloneable).addElement(vector3);
                vector3 = new Vector();
                ++n5;
            }
            if (n5 % n != 0) continue;
            vector.addElement(cloneable);
            cloneable = new Vector();
            if (++n4 != n2) continue;
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", vector);
    }

    String getQuotedString(String string) {
        int n = this.line.indexOf(string);
        int n2 = this.line.lastIndexOf(string);
        return n2 == n ? "" : this.line.substring(n + 1, n2);
    }

    String readLine() throws Exception {
        this.line = this.reader.readLine();
        return this.line;
    }
}

