# The LearningOnline Network
# "About Me" Personal Information
#
# $Id: lonaboutme.pm,v 1.69 2008/01/20 22:25:05 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonaboutme;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lontexconvert;
use Apache::lonfeedback;
use Apache::lonrss();
use Apache::lonlocal;
use Apache::lonmsgdisplay();
use HTML::Entities();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
    my $target=$env{'form.grade_target'};
# ------------------------------------------------------------ Print the screen
    if ($target eq 'tex') {
	$r->print(&Apache::lonprintout::print_latex_header($env{'form.latex_type'}));
    }
    my (undef,undef,$cdom,$cnum,undef,$action)=split(/\//,$r->uri);
    my $is_course;
# Is this even a user?
    if (&Apache::lonnet::homeserver($cnum,$cdom) eq 'no_host') {
	&Apache::loncommon::simple_error_page($r,'No info',
					      'No user information available');
        return OK;
    } else {
        $is_course = &Apache::lonnet::is_course($cdom,$cnum);
    }

# --------------------------------------------------------- The syllabus fields
    my %syllabusfields=&Apache::lonlocal::texthash(
       'aaa_contactinfo'   => 'Contact Information',
       'bbb_aboutme'       => 'About Me',
       'ccc_webreferences' => 'Web References');

# ------------------------------------------------------------ Get Query String
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
					    ['forceedit','forcestudent',
					     'register','popup']);

# ----------------------------------------------- Available Portfolio file display 
    if (($target ne 'tex') && ($action eq 'portfolio')) {
        &display_portfolio_header($r,$is_course);
        my ($blocked,$blocktext) = 
           &Apache::loncommon::blocking_status('port',$cnum,$cdom);
        if (!$blocked) {
            &display_portfolio_files($r,$is_course);
        } else {
            $r->print($blocktext);
        }
        $r->print(&Apache::loncommon::end_page());
        return OK;
    }

    if ($is_course) {
        if ($target ne 'tex') {
            my $start_page =
                &Apache::loncommon::start_page(
                    "Course Information",
                     undef,
                     {'function' => $env{'forcestudent'},
                      'domain'   => $cdom,
                      'force_register' => $env{'forceregister'},});
            $r->print($start_page);
            $r->print('<h2>'.&mt('Group files').'</h2>');
            &print_portfiles_link($r,$is_course);
            $r->print(&Apache::loncommon::end_page());
        }
        return OK;
    }

# --------------------------------------------------------------- Force Student
    my $forcestudent='';
    if ($env{'form.forcestudent'}) { $forcestudent='student'; };

    my $forceregister = '';
    if ($forcestudent eq '') {
        $forceregister = $env{'form.register'};
    }
       
# --------------------------------------- There is such a user, get environment
    my %courseenv=&Apache::lonnet::dump('environment',$cdom,$cnum);
    if ($target ne 'tex') {
	my $rss_link = &Apache::lonrss::rss_link($cnum,$cdom);
        my $args = {'function' => $forcestudent,
                    'domain'   => $cdom,
                    'force_register' => $forceregister};
        if ($env{'form.popup'}) {
            $args->{'no_nav_bar'} = 1;
        }
	my $start_page = 
	    &Apache::loncommon::start_page("Personal Information",$rss_link,$args);
	$r->print($start_page);
	$r->print('<h1>'.&Apache::loncommon::plainname($cnum,$cdom).'</h1>');
    } else {
	$r->print('\noindent{\large\textbf{'.&Apache::loncommon::plainname($cnum,$cdom).'}}\\\\\\\\');
    }
    if ($courseenv{'nickname'}) {
       $r->print(
         '<h2>&quot;'.$courseenv{'nickname'}.
         '&quot;</h2>');
    }
    if ($target ne 'tex') {
	$r->print('<h3>'.&Apache::lonnet::domain($cdom,'description').'</h3>'.
		  '<p>'.&Apache::loncommon::messagewrapper(&mt('Send me a message'),$cnum,$cdom).'</p>'.&Apache::lonrss::advertisefeeds($cnum,$cdom));
    } else {
	$r->print('\textbf{'.&Apache::lonnet::domain($cdom,'description').'}\\\\');
    }
    my %syllabus=&Apache::lonnet::dump('aboutme',$cdom,$cnum);
    my $allowed=0;

# does this user have privileges to post, etc?

       my $privleged=$allowed=(($env{'user.name'} eq $cnum) && 
			       ($env{'user.domain'} eq $cdom));
       if ($forcestudent or $target eq 'tex') { $allowed=0; }
 
       if ($allowed) {
           my $query_string = &build_query_string({'forcestudent' => '1','popup' => $env{'form.popup'}});
	   $r->print('<p><b>'.&mt('Privacy Note').':</b> '.
		     &mt('The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.').
		     '</p>'.
		     &Apache::loncommon::help_open_topic('Uploaded_Templates_TextBoxes',&mt('Help with filling in text boxes')).'</p><p><a href="'.$r->uri.$query_string.'">'.&mt('Show Public View').'</a>'.
		     &Apache::loncommon::help_open_topic('Uploaded_Templates_PublicView').'</p>');
       } elsif ($privleged && $target ne 'tex') {
           my $query_string = &build_query_string({'forceedit' => '1','popup' => $env{'form.popup'}});
	   $r->print('<p><a href="'.$r->uri.$query_string.'"><font size="+1">'.
		     &mt('Edit').'</font></a></p>');
       }
      if (($env{'form.uploaddoc.filename'}) &&
          ($env{'form.storeupl'}) && ($allowed)) {
 	  if ($env{'form.uploaddoc.filename'}=~/\.(gif|jpg|png|jpeg)$/i) {
	      if ($syllabus{'uploaded.photourl'}) {
		  &Apache::lonnet::removeuploadedurl($syllabus{'uploaded.photourl'});
	      }
	      $syllabus{'uploaded.photourl'}=
                 &Apache::lonnet::userfileupload('uploaddoc',undef,'aboutme');
 	  }
          $syllabus{'uploaded.lastmodified'}=time;
          &Apache::lonnet::put('aboutme',\%syllabus,$cdom,$cnum);
       }
    if ($allowed && $env{'form.delupl'}) {
	if ($syllabus{'uploaded.photourl'}) {
	    &Apache::lonnet::removeuploadedurl($syllabus{'uploaded.photourl'});
	    delete($syllabus{'uploaded.photourl'});
	    &Apache::lonnet::del('aboutme',['uploaded.photourl'],$cdom,$cnum);
	}
    }
       if (($allowed) && ($env{'form.storesyl'})) {
	   foreach my $syl_field (keys(%syllabusfields)) {
               my $field=$env{'form.'.$syl_field};
               $field=~s/\s+$//s;
               $field=&Apache::lonfeedback::clear_out_html($field,
                                                           $env{'user.adv'});
	       $syllabus{$syl_field}=$field;
           }
           $syllabus{'uploaded.lastmodified'}=time;
           &Apache::lonnet::put('aboutme',\%syllabus,$cdom,$cnum);
       }

# ---------------------------------------------------------------- Get syllabus
    if (($syllabus{'uploaded.lastmodified'}) || ($allowed)) {
       my $lastmod=$syllabus{'uploaded.lastmodified'};
       $lastmod=($lastmod?&Apache::lonlocal::locallocaltime($lastmod):&mt('never'));
       $r->print(&mt('Last updated').': '.$lastmod);
       if ($syllabus{'uploaded.photourl'}) {
	   &Apache::lonnet::allowuploaded('/adm/aboutme',
					  $syllabus{'uploaded.photourl'});
	   my $image=
               qq{<img src="$syllabus{'uploaded.photourl'}" align="right" />};
	   if ($target eq 'tex') {
	       $image=&Apache::lonxml::xmlparse($r,'tex',$image);
	   }
	   $r->print($image);
       }
       if ($allowed) {
           $r->print(
	 '<form method="post">
               <input type="submit" name="delupl" value="'.&mt('Delete Photo').'" />
          </form>'.
	 '<form method="post" enctype="multipart/form-data">'.
         '<h3>'.&mt('Upload a Photo').'</h3>'.
         '<input type="file" name="uploaddoc" size="50" />'.
         '<input type="submit" name="storeupl" value="'.&mt('Upload').'" />'.
         '<input type="hidden" name="popup" value="'.$env{'form.popup'}.'" />'.
	 '</form><form method="post">');

       }
       foreach my $field (sort(keys(%syllabusfields))) {
          if (($syllabus{$field}) || ($allowed)) {
              my $message=$syllabus{$field};
	      &Apache::lonfeedback::newline_to_br(\$message);
              $message
             =~s/(http\:\/\/[^\s]+)/\<a href=\"$1\"\>\<tt\>$1\<\/tt\>\<\/a\>/g;
	      if ($allowed) {
		  $message=&Apache::lonspeller::markeduptext($message);
	      }
	      $message=&Apache::lontexconvert::msgtexconverted($message);
	      if ($target ne 'tex') {
		  $r->print('<h3>'.$syllabusfields{$field}.'</h3><blockquote>'.
                            $message.'</blockquote>');
	      } else {
		     $r->print('\\\\\textbf{'.$syllabusfields{$field}.'}\\\\'.
			       &Apache::lonxml::xmlparse($r,'tex',$message).'\\\\');
	      }
              if ($allowed) {
                 $r->print('<br /><textarea cols="80" rows="6" name="'.$field.'">'.
			   &HTML::Entities::encode($syllabus{$field},'"&<>').
           '</textarea><input type="submit" name="storesyl" value="'.
			   &mt('Save').'" />');
	      }
	  }
       }
       if ($allowed) {
           if ($env{'form.popup'}) {
               $r->print('<input type="hidden" name="popup" value="'.
                         $env{'form.popup'}.'" />');
           }
	   $r->print('</form>');
       }
       if ($target ne 'tex') {$r->print('<br />');} else {$r->print('\\\\');}
    } else {
       $r->print('<p>'.&mt('No personal information provided').'.</p>');
    }

    if ($target ne 'tex') {
        &print_portfiles_link($r,$is_course);
    }

    if ($env{'request.course.id'}
	&& &Apache::lonnet::allowed('srm',$env{'request.course.id'})
	&& &in_course($cdom,$cnum)) {
	if ($target ne 'tex') {
	    $r->print('<a name="coursecomment" />');
	    $r->print('<hr /><h3>'.
		      &mt('User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course').'</h3>'.
		      &mt('Shared by course faculty and staff').
		      &Apache::loncommon::help_open_topic("Course_Face_To_Face_Records,Course_Critical_Message").
		      '<br />');
	    &Apache::lonmsgdisplay::disfacetoface($r,$cnum,$cdom);
	    $r->print('<hr />');
	    if (&Apache::lonnet::allowed('vsa',
					 $env{'request.course.id'}) ||
		&Apache::lonnet::allowed('vsa',
					 $env{'request.course.id'}.'/'.
					 $env{'request.course.sec'})) {
		$r->print(&Apache::loncommon::track_student_link
			  ('View recent activity by this student',
			   $cnum,$cdom).('&nbsp;'x2));
	    }
	    $r->print(&Apache::loncommon::noteswrapper('Add Records',$cnum,$cdom));
	} else {
	    $r->print('\\\\\textbf{'.&mt('User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course').'}\\\\'.&mt('Shared by course faculty and staff').'\\\\\\\\');
	    &Apache::lonmsgdisplay::disfacetoface($r,$cnum,$cdom);
	}
    }
    if ($target ne 'tex') {
        if ($env{'form.popup'}) {
            $r->print('<p><a href="javascript:window.close()">'.&mt('Close window').'</a>');
        }
	$r->print(&Apache::loncommon::end_page());
    } else {
	$r->print('\end{document}');
    }
    return OK;
}

sub in_course {
    my ($udom,$uname,$cdom,$cnum,$type) = @_;
    $type ||= 'any';
    if (!defined($cdom) || !defined($cnum)) {
	my $cid  = $env{'request.course.id'};
	$cdom = $env{'course.'.$cid.'.domain'};
	$cnum = $env{'course.'.$cid.'.num'};
    }
    my %roles = &Apache::lonnet::dump('roles',$udom,$uname);
    my @course_roles = grep(m{^/\Q$cdom\E/\Q$cnum\E[/_]}, keys(%roles));
    return 0 if (!@course_roles);
    return 1 if ($type eq 'any');
    my $now = time();
    foreach my $role (@course_roles) {
	my (undef,$role_end,$role_start)=split(/\_/,$roles{$role});
	my $status = 'active';
	if ($role_start > 0 && $now < $role_start) {
	    $status = 'future';
	}
	if ($role_end > 0 && $now > $role_end) {
	    $status = 'previous';
	}
	return 1 if ($status eq $type);
    }
    return 0;
}

sub aboutme_info {
    my ($r,$is_course) = @_;
    my (undef,undef,$cdom,$cnum)=split(/\//,$r->uri);
    my $name;
    if (!$is_course) {
        $name = &Apache::loncommon::plainname($cnum,$cdom);
    }
    return ($cdom,$cnum,$name);
}

sub print_portfiles_link {
    my ($r,$is_course) = @_;
    my ($cdom,$cnum,$name) = &aboutme_info($r,$is_course);
    my $filecounts = &portfolio_files($r,'showlink',undef,$is_course,
                                      $cdom,$cnum,$name);
    my $query_string = &build_query_string();
    my $output;
    my %lt = &Apache::lonlocal::texthash(
                         vpfi => 'Viewable portfolio files',
                         vgpf => 'Viewable group portfolio files',
                         difl => 'Display file listing',
             );                     
    if ($filecounts->{'both'} > 0) {
        $output = '<h3>'.($is_course?$lt{'vgpf'}:$lt{'vpfi'}).'</h3>';
        $output .= '<a href="/adm/'.$cdom.'/'.$cnum.'/aboutme/portfolio'.
                   $query_string.'">'.$lt{'difl'}.
                   '</a><br /><br />';
        if ($filecounts->{'both'} == 1) {
            if ($is_course) {
                $output .= &mt('One group portfolio file is available.').'<ul>';
            } else {
                $output .= &mt('One portfolio file owned by [_1] is available.',$name).'<ul>';
            }
        } else {
            if ($is_course) {
                $output .= &mt('A total of [_1] group portfolio files are available.',$filecounts->{'both'}).'<ul>';
            } else {
                $output .= &mt('A total of [_1] portfolio files owned by [_2] are available.',$filecounts->{'both'},$name).'<ul>';
            }
        }
        if ($filecounts->{'withoutpass'}) {
	    $output .= '<li>'.&mt('[quant,_1,file is,files are] publicly accessible.',$filecounts->{'withoutpass'}).'</li>';
        }
        if ($filecounts->{'withpass'}) {
	    $output .= '<li>'.&mt('[quant,_1,file requires,files require] a passphrase for access.',$filecounts->{'withpass'}).'</li>';
        }
        $output .= '</ul>';
    }
    $r->print($output);
    return;
}

sub build_query_string {
    my ($new_items) = @_;
    my $query_string;
    my @formelements = ('register'); 
    my $new = 0;
    if (ref($new_items) eq 'HASH') {
        $new = 1;
        if (!defined($new_items->{'forceedit'}) && 
            !defined($new_items->{'forcestudent'})) {
            push(@formelements,('forceedit','forcestudent'));
        }
    } else {
        push(@formelements,('forceedit','forcestudent'));
    }
    foreach my $element (@formelements) {
        if (exists($env{'form.'.$element})) {
            if ((!$new) || (!defined($new_items->{$element}))) {
                $query_string .= '&amp;'.$element.'='.$env{'form.'.$element};
            }
        }
    }
    if ($new) {
        foreach my $key (keys(%{$new_items})) {
            $query_string .= '&amp;'.$key.'='.$new_items->{$key};
        }
    }
    $query_string =~ s/^\&amp;/\?/;
    return $query_string;
}

sub display_portfolio_header {
    my ($r,$is_course) = @_;
    my ($cdom,$cnum,$name) = &aboutme_info($r,$is_course);
    my $query_string = &build_query_string();
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    my $forcestudent='';
    if ($env{'form.forcestudent'}) { $forcestudent='student'; };

    my $output;
    if ($is_course) {
        $output = 
            &Apache::loncommon::start_page('Viewable group portfolio files',undef,
                                            {'function' => $forcestudent,
                                             'domain'   => $cdom,});
        $output .= '<h3>'.&mt('Group Portfolio files').'</h3>';
    } else {
        $output  =
            &Apache::loncommon::start_page('Viewable portfolio files',undef,
                                            {'function' => $forcestudent,
                                             'domain'   => $cdom,});
        if (!($env{'user.name'} eq 'public' && $env{'user.domain'} eq 'public')) {
            &Apache::lonhtmlcommon::add_breadcrumb
                ({href=>"/adm/$cdom/$cnum/aboutme".$query_string,
                  text=>"Personal information - $name",
                  title=>"Go to personal information page for $name"},                 {href=>"/adm/$cdom/$cnum/aboutme/portfolio",
                  text=>"Viewable files - $name",
                  title=>"Viewable portfolio files for $name"}
            );
            $output .= &Apache::lonhtmlcommon::breadcrumbs(&mt('Viewable portfolio files.'));
        }
        $output .= '<h3>'.&mt('Portfolio files for [_1]',$name).'</h3>';
    }
    $r->print($output);
    return;
}

sub display_portfolio_files {
    my ($r,$is_course) = @_;
    my ($cdom,$cnum,$name) = &aboutme_info($r,$is_course);
    my %lt = ( withoutpass => 'passphrase not required',
	       withpass    => 'passphrase protected',
	       both        => 'all access types ',);
    %lt = &Apache::lonlocal::texthash(%lt);

    my $portaccess = 'withoutpass';
    if (exists($env{'form.portaccess'})) {
        $portaccess = $env{'form.portaccess'};
    }

    my $output = '<form action="'.&HTML::Entities::encode($r->uri,'<>&"')
	.'" name="displaystatus" method="post">'.
	&mt('File access type: ').'<select name="portaccess">';
    foreach my $type ('withoutpass','withpass','both') {
        $output .= '<option value="'.$type.'" ';
        if ($portaccess eq $type) {
            $output .= 'selected="selected"';
        }
        $output .= '>'.$lt{$type}.'</option>';
    }
    $output .= '</select>'."\n".
               '<input type="submit" name="portaccessbutton" value="'.
               &mt('Update display').'" />';
    $output .= '</form><br /><br />';
    $r->print($output);
    my $filecounts = &portfolio_files($r,'listfiles',\%lt,$is_course,
                                      $cdom,$cnum,$name);
    if (!($env{'user.name'} eq 'public' && $env{'user.domain'} eq 'public')) {
        my $query_string = &build_query_string();
        $r->print('<br /><br /><a href="/adm/'.$cdom.'/'.$cnum.
                  '/aboutme'.$query_string.'">');
        if ($is_course) {
            $r->print(&mt('Course Information page'));
        } else {
            $r->print(&mt('Information about [_1]',$name));
        }
        $r->print('</a>');
    }
    return;
}

sub portfolio_files {
    my ($r,$mode,$lt,$is_course,$cdom,$cnum,$name) = @_;
    my $filecounts = {
                       withpass    => 0,
                       withoutpass => 0,
                       both        => 0,
                     };
    my $current_permissions =
	&Apache::lonnet::get_portfile_permissions($cdom,$cnum);
    my %access_controls = 
	&Apache::lonnet::get_access_controls($current_permissions);
    my $portaccess;
    if ($mode eq 'showlink') {
        $portaccess = 'both';
    } else {
        $portaccess = 'withoutpass';
        if (exists($env{'form.portaccess'})) {
            $portaccess = $env{'form.portaccess'};
        }
    }

    my $diroutput;
    if ($is_course) {
        my %files_by_group;
        foreach my $filename (sort(keys(%access_controls))) {
            my ($group,$path) = split('/',$filename,2);
            $files_by_group{$group}{$path} = $access_controls{$filename}; 
        }
        foreach my $group (sort(keys(%files_by_group))) {
            my %fileshash;
            my $grpout .= &build_hierarchy($r,$cdom,$cnum,$portaccess,
                                           $is_course,$filecounts,$mode,
                                           $files_by_group{$group},
                                           \%fileshash,$group);
            if ($grpout) {
                $diroutput .= '<h3>'.$group.'</h3>'.$grpout.'<br />';
            }
        }
    } else {
        my %allfileshash;
        $diroutput = &build_hierarchy($r,$cdom,$cnum,$portaccess,$is_course,
                                      $filecounts,$mode,\%access_controls,
                                      \%allfileshash);
    }
    if ($mode eq 'listfiles') {
        if ($filecounts->{'both'}) {
             $r->print($diroutput);
        } else {
            my $access_text;
            if (ref($lt) eq 'HASH') {
                $access_text = $lt->{$portaccess};   
            }
            $r->print(&mt('There are no available files of the specified access type: [_1]',$access_text));
        }
    }
    return $filecounts;
}

{ 
    my $count=0;
    sub portfolio_table_start {
	$count=0;
	return '<table class="LC_aboutme_port">';
    }
    sub portfolio_row_start {
	$count++;
	my $class = ($count%2)?'LC_odd_row'
	                      :'LC_even_row';
	return '<tr class="'.$class.'">';
    }
}

sub build_hierarchy {
    my ($r,$cdom,$cnum,$portaccess,$is_course,$filecounts,$mode,$access_info,
        $allfileshash,$group) = @_;
    foreach my $filename (sort(keys(%{$access_info}))) {
        my $access_status =
           &Apache::lonnet::get_portfolio_access($cdom,$cnum,$filename,$group,                                                 $$access_info{$filename});
        if ($portaccess eq 'both') {
            if (($access_status ne 'ok') &&
                ($access_status !~  /^[^:]+:guest_/)) {
                next;
            }
        } elsif ($portaccess eq 'withoutpass') {
            if ($access_status ne 'ok') {
                next;
            }
        } elsif ($portaccess eq 'withpass') {
            if ($access_status !~  /^[^:]+:guest_/) {
                next;
            }
        }
        if ($mode eq 'listfiles') {
            $filename =~ s/^\///;
            my @pathitems = split('/',$filename);
            my $lasthash = $allfileshash;
            while (@pathitems > 1) {
                my $newlevel = shift(@pathitems);
                if (!exists($lasthash->{$newlevel})) {
                    $lasthash->{$newlevel} = {};
                }
                $lasthash = $lasthash->{$newlevel};
            }
            $lasthash->{$pathitems[0]} = $filename;
        }
        if ($access_status eq 'ok') {
            $filecounts->{'withoutpass'} ++;
        } elsif ($access_status =~  /^[^:]+:guest_/) {
            $filecounts->{'withpass'} ++;
        }
    }
    $filecounts->{'both'} =  $filecounts->{'withoutpass'} +
                              $filecounts->{'withpass'};
    my $output;
    if ($mode eq 'listfiles') {
        if ($filecounts->{'both'} > 0) {
            $output = &portfolio_table_start();
            $output .= &parse_directory($r,0,$allfileshash,'',$is_course,
                                        $group);
            $output .= '</table>';
        }
    }
    return $output;
}

sub parse_directory {
    my ($r,$depth,$currhash,$path,$is_course,$group) = @_;
    my ($cdom,$cnum,$name) = &aboutme_info($r,$is_course);
    $depth++;
    my $output;

    my $portfolio_root = &Apache::portfolio::get_portfolio_root($cdom,$cnum,
                                                                $group);
    my %dirlist = map {
	    ((split('&',$_,2))[0],1)
	} &Apache::lonnet::dirlist($path,$cdom,$cnum,$portfolio_root);
    foreach my $item (sort(keys(%{$currhash}))) {
        $output .= &portfolio_row_start();
        $output .= '<td style="padding-left: '.($depth*25).'px">';
        if (ref($currhash->{$item}) eq 'HASH') {
            my $title=&HTML::Entities::encode($item,'<>&"');
            $output .= '<img src="'.&Apache::loncommon::lonhttpdurl("/adm/lonIcons/navmap.folder.open.gif").'" alt="'.&mt('Folder').' '.$title.'" class="LC_icon" />&nbsp;'.$title;
	    $output .= '</td><td></td></tr>';
            $output .= &parse_directory($r,$depth,$currhash->{$item},
					$path.'/'.$item,$is_course,$group);
        } else {
	    my $file_name; 
	    if ($currhash->{$item} =~ m|/([^/]+)$|) {
		$file_name = $1;
	    } else {
		$file_name = $currhash->{$item};
	    }
	    my $have_meta = exists($dirlist{$file_name.'.meta'});
            my $url;
            if ($is_course) {
                $url = '/uploaded/'.$cdom.'/'.$cnum.'/groups/'.$group.
                       '/portfolio/'.$currhash->{$item};
            } else { 
	        $url = '/uploaded/'.$cdom.'/'.$cnum.'/portfolio/'.
		       $currhash->{$item};
            }
            my $showname;
	    if ($have_meta) {
		$showname = &Apache::lonnet::metadata($url,'title');
	    }
	    if ($showname eq '') {
		$showname = $file_name;
	    } else {
		$showname = $file_name.' ('.$showname.')';
	    }

            $showname=&HTML::Entities::encode($showname,'<>&"');
            $output .= '<a href="'.$url.'">'.
		'<img alt="" src="'.&Apache::loncommon::icon($currhash->{$item}).'" class="LC_icon" />'.
		'&nbsp;'.$showname.'</a>';
	    $output.='</td><td>';
	    if ($have_meta) {
		$output.= '<a href="'.$url.'.meta"><img alt="'.&mt('Catalog Information').'" src="'.
		&Apache::loncommon::lonhttpdurl('/res/adm/pages/catalog.gif').
		'" class="LC_icon" /></a>';
	    }
	    $output .= '</td></tr>';
        }
    }
    return $output;
}

1;
__END__
