/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class FrameRenderer {
    boolean logTime;
    long timeBegin;
    Viewer viewer;
    ShapeRenderer[] renderers = new ShapeRenderer[31];

    FrameRenderer(Viewer viewer) {
        this.viewer = viewer;
    }

    void render(Graphics3D graphics3D, ModelSet modelSet) {
        if (modelSet == null || !this.viewer.mustRenderFlag()) {
            return;
        }
        this.logTime = this.viewer.getTestFlag1();
        this.viewer.finalizeTransformParameters();
        if (this.logTime) {
            this.timeBegin = System.currentTimeMillis();
        }
        for (int i = 0; i < 31; ++i) {
            Shape shape = modelSet.getShape(i);
            if (shape == null) continue;
            this.getRenderer(i, graphics3D).render(graphics3D, modelSet, shape);
        }
        if (this.logTime) {
            Logger.info((String)("render time: " + (System.currentTimeMillis() - this.timeBegin) + " ms"));
        }
    }

    ShapeRenderer getRenderer(int n, Graphics3D graphics3D) {
        if (this.renderers[n] == null) {
            this.renderers[n] = this.allocateRenderer(n, graphics3D);
        }
        return this.renderers[n];
    }

    public void clear() {
        for (int i = 0; i < 31; ++i) {
            this.renderers[i] = null;
        }
    }

    ShapeRenderer allocateRenderer(int n, Graphics3D graphics3D) {
        String string = JmolConstants.getShapeClassName(n) + "Renderer";
        try {
            Class<?> clazz = Class.forName(string);
            ShapeRenderer shapeRenderer = (ShapeRenderer)clazz.newInstance();
            shapeRenderer.setViewerG3dShapeID(this.viewer, graphics3D, n);
            return shapeRenderer;
        }
        catch (Exception exception) {
            Logger.error((String)("Could not instantiate renderer:" + string), (Throwable)exception);
            return null;
        }
    }
}

