/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.LimitedLineReader;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

class Resolver {
    private static final String classBase = "org.jmol.adapter.readers.";
    private static final String[] readerSets = new String[]{"cifpdb.", "Cif;Pdb;", "molxyz.", "Mol;Xyz;", "xml.", "Xml;"};
    static final String[][] checkSpecialTags = new String[][]{{"Jme"}, {"V3000"}, {"Mol"}, {"Xyz"}, {"MopacGraphf"}, {"FoldingXyz"}, {"Cube"}, {"Odyssey"}};
    static final int LEADER_CHAR_MAX = 20;
    static final String[] cubeRecords = new String[]{"Cube", "JVXL", "#JVXL"};
    static final String[] mol2Records = new String[]{"Mol2", "mol2", "@<TRIPOS>"};
    static final String[] webmoRecords = new String[]{"WebMO", "[HEADER]"};
    static final String[][] fileStartsWithRecords = new String[][]{cubeRecords, mol2Records, webmoRecords};
    static final String[] pqrRecords = new String[]{"Pqr", "REMARK   1 PQR"};
    static final String[] pdbRecords = new String[]{"Pdb", "HEADER", "OBSLTE", "TITLE ", "CAVEAT", "COMPND", "SOURCE", "KEYWDS", "EXPDTA", "AUTHOR", "REVDAT", "SPRSDE", "JRNL  ", "REMARK", "DBREF ", "SEQADV", "SEQRES", "MODRES", "HELIX ", "SHEET ", "TURN  ", "CRYST1", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "ATOM  ", "HETATM", "MODEL "};
    static final String[] shelxRecords = new String[]{"Shelx", "TITL ", "ZERR ", "LATT ", "SYMM ", "CELL "};
    static final String[] cifRecords = new String[]{"Cif", "data_", "_publ"};
    static final String[] ghemicalMMRecords = new String[]{"GhemicalMM", "!Header mm1gp", "!Header gpr"};
    static final String[] jaguarRecords = new String[]{"Jaguar", "  |  Jaguar version"};
    static final String[] hinRecords = new String[]{"Hin", "mol "};
    static final String[] mdlRecords = new String[]{"Mol", "$MDL "};
    static final String[] spartanSmolRecords = new String[]{"SpartanSmol", "INPUT="};
    static final String[] csfRecords = new String[]{"Csf", "local_transform"};
    static final String[][] lineStartsWithRecords = new String[][]{pqrRecords, pdbRecords, shelxRecords, cifRecords, ghemicalMMRecords, jaguarRecords, hinRecords, mdlRecords, spartanSmolRecords, csfRecords, mol2Records};
    static final String[] xmlRecords = new String[]{"Xml", "<?xml", "<atom", "<molecule", "<reaction", "<cml", "<bond", ".dtd\"", "<list>", "<entry", "<identifier", "http://www.xml-cml.org/schema/cml2/core"};
    static final String[] gaussianRecords = new String[]{"Gaussian", "Entering Gaussian System", "Entering Link 1", "1998 Gaussian, Inc."};
    static final String[] mopacRecords = new String[]{"Mopac", "MOPAC 93 (c) Fujitsu", "MOPAC2002 (c) Fujitsu", "MOPAC FOR LINUX (PUBLIC DOMAIN VERSION)"};
    static final String[] qchemRecords = new String[]{"Qchem", "Welcome to Q-Chem", "A Quantum Leap Into The Future Of Chemistry"};
    static final String[] gamessRecords = new String[]{"Gamess", "GAMESS"};
    static final String[] spartanBinaryRecords = new String[]{"SpartanSmol", "|PropertyArchive"};
    static final String[] spartanRecords = new String[]{"Spartan", "Spartan"};
    static final String[] adfRecords = new String[]{"Adf", "Amsterdam Density Functional"};
    static final String[] psiRecords = new String[]{"Psi", "    PSI  3"};
    static final String[] nwchemRecords = new String[]{"NWChem", " argument  1 = "};
    static final String[] jmolDataRecords = new String[]{"JmolData", "Jmol Coordinate Data"};
    static final String[][] containsRecords = new String[][]{xmlRecords, gaussianRecords, mopacRecords, qchemRecords, gamessRecords, spartanBinaryRecords, spartanRecords, mol2Records, adfRecords, psiRecords, nwchemRecords, jmolDataRecords};

    Resolver() {
    }

    private static final String getReaderClassBase(String string) {
        String string2 = "more.";
        for (int i = 1; i < readerSets.length; i += 2) {
            if (readerSets[i].indexOf(string + ";") < 0) continue;
            string2 = readerSets[i - 1];
            break;
        }
        return classBase + string2 + string + "Reader";
    }

    static String getFileType(BufferedReader bufferedReader) {
        try {
            return Resolver.determineAtomSetCollectionReader(bufferedReader, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Object resolve(String string, String string2, BufferedReader bufferedReader) throws Exception {
        return Resolver.resolve(string, string2, bufferedReader, null);
    }

    static Object resolve(String string, String string2, BufferedReader bufferedReader, Hashtable hashtable) throws Exception {
        String string3;
        AtomSetCollectionReader atomSetCollectionReader = null;
        if (string2 != null) {
            string3 = Resolver.getReaderFromType(string2);
            if (string3 == null) {
                return "unrecognized file format type " + string2;
            }
            Logger.info("The Resolver assumes " + string3);
        } else {
            string3 = Resolver.determineAtomSetCollectionReader(bufferedReader, true);
            if (string3.indexOf("\n") >= 0) {
                return "unrecognized file format for file " + string + "\n" + string3;
            }
            Logger.info("The Resolver thinks " + string3);
        }
        String string4 = null;
        String string5 = null;
        try {
            string4 = Resolver.getReaderClassBase(string3);
            Class<?> clazz = Class.forName(string4);
            atomSetCollectionReader = (AtomSetCollectionReader)clazz.newInstance();
        }
        catch (Exception exception) {
            string5 = "File reader was not found:" + string4;
            Logger.error(string5);
            return string5;
        }
        atomSetCollectionReader.initialize(hashtable);
        AtomSetCollection atomSetCollection = atomSetCollectionReader.readAtomSetCollection(bufferedReader);
        bufferedReader.close();
        bufferedReader = null;
        return Resolver.finalize(atomSetCollection, "file " + string);
    }

    static Object DOMResolve(Object object) throws Exception {
        AtomSetCollectionReader atomSetCollectionReader;
        String string = null;
        try {
            string = "org.jmol.adapter.readers.xml.XmlReader";
            Class<?> clazz = Class.forName(string);
            atomSetCollectionReader = (AtomSetCollectionReader)clazz.newInstance();
        }
        catch (Exception exception) {
            String string2 = "File reader was not found:" + string;
            Logger.error(string2, exception);
            return string2;
        }
        atomSetCollectionReader.initialize();
        AtomSetCollection atomSetCollection = atomSetCollectionReader.readAtomSetCollectionFromDOM(object);
        return Resolver.finalize(atomSetCollection, "DOM node");
    }

    static Object finalize(AtomSetCollection atomSetCollection, String string) {
        int n = atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            atomSetCollection.setAtomSetAuxiliaryInfo("fileName", string, n);
        }
        atomSetCollection.freeze();
        if (atomSetCollection.errorMessage != null) {
            return atomSetCollection.errorMessage + "\nfor " + string + "\ntype " + atomSetCollection.fileTypeName;
        }
        if (atomSetCollection.atomCount == 0) {
            return "No atoms found\nfor " + string + "\ntype " + atomSetCollection.fileTypeName;
        }
        return atomSetCollection;
    }

    static String determineAtomSetCollectionReader(BufferedReader bufferedReader, boolean bl) throws Exception {
        String string;
        int n;
        String[] stringArray;
        int n2;
        String[] stringArray2 = new String[16];
        LimitedLineReader limitedLineReader = new LimitedLineReader(bufferedReader, 16384);
        int n3 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = limitedLineReader.readLineWithNewline();
            if (stringArray2[i].length() <= 0) continue;
            ++n3;
        }
        if (n3 == 1 && stringArray2[0].length() > 0 && Character.isDigit(stringArray2[0].charAt(0))) {
            return "Jme";
        }
        if (Resolver.checkMopacGraphf(stringArray2)) {
            return "MopacGraphf";
        }
        if (Resolver.checkV3000(stringArray2)) {
            return "V3000";
        }
        if (Resolver.checkOdyssey(stringArray2)) {
            return "Odyssey";
        }
        if (Resolver.checkMol(stringArray2)) {
            return "Mol";
        }
        if (Resolver.checkXyz(stringArray2)) {
            return "Xyz";
        }
        if (Resolver.checkFoldingXyz(stringArray2)) {
            return "FoldingXyz";
        }
        if (Resolver.checkCube(stringArray2)) {
            return "Cube";
        }
        String string2 = limitedLineReader.getLeader(20);
        for (n2 = 0; n2 < fileStartsWithRecords.length; ++n2) {
            stringArray = fileStartsWithRecords[n2];
            for (n = 1; n < stringArray.length; ++n) {
                string = stringArray[n];
                if (!string2.startsWith(string)) continue;
                return stringArray[0];
            }
        }
        for (n2 = 0; n2 < lineStartsWithRecords.length; ++n2) {
            stringArray = lineStartsWithRecords[n2];
            for (n = 1; n < stringArray.length; ++n) {
                string = stringArray[n];
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].startsWith(string)) continue;
                    return stringArray[0];
                }
            }
        }
        String string3 = limitedLineReader.getHeader();
        for (int i = 0; i < containsRecords.length; ++i) {
            String[] stringArray3 = containsRecords[i];
            for (int j = 1; j < stringArray3.length; ++j) {
                String string4 = stringArray3[j];
                if (string3.indexOf(string4) == -1) continue;
                return stringArray3[0];
            }
        }
        return bl ? "\n" + stringArray2[0] + "\n" + stringArray2[1] + "\n" + stringArray2[2] + "\n" : null;
    }

    public static final String getReaderFromType(String string) {
        string = string.toLowerCase();
        String string2 = null;
        string2 = Resolver.checkType(checkSpecialTags, string);
        if (string2 != null) {
            return string2;
        }
        string2 = Resolver.checkType(fileStartsWithRecords, string);
        if (string2 != null) {
            return string2;
        }
        string2 = Resolver.checkType(lineStartsWithRecords, string);
        if (string2 != null) {
            return string2;
        }
        return Resolver.checkType(containsRecords, string);
    }

    private static final String checkType(String[][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i][0].toLowerCase().equals(string)) continue;
            return stringArray[i][0];
        }
        return null;
    }

    private static boolean checkOdyssey(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("C "); ++n) {
        }
        return stringArray[n].charAt(0) == ' ' && (n += 2) < stringArray.length && TextFormat.replaceAllCharacters(stringArray[n], "\r\n", "").equals("0 1");
    }

    private static boolean checkV3000(String[] stringArray) {
        String string;
        return stringArray[3].length() >= 6 && (string = stringArray[3].trim()).endsWith("V3000");
    }

    private static boolean checkMol(String[] stringArray) {
        if (stringArray[3].length() >= 6) {
            String string = stringArray[3].trim();
            if (string.endsWith("V2000") || string.endsWith("v2000")) {
                return true;
            }
            try {
                Integer.parseInt(stringArray[3].substring(0, 3).trim());
                Integer.parseInt(stringArray[3].substring(3, 6).trim());
                return stringArray[0].indexOf("@<TRIPOS>") != 0 && stringArray[1].indexOf("@<TRIPOS>") != 0 && stringArray[2].indexOf("@<TRIPOS>") != 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkXyz(String[] stringArray) {
        try {
            Integer.parseInt(stringArray[0].trim());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean checkFoldingXyz(String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0].trim(), " \t");
        if (stringTokenizer.countTokens() < 2) {
            return false;
        }
        try {
            Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        String string = stringArray[1].trim();
        if (string.length() == 0) {
            string = stringArray[2].trim();
        }
        if ((stringTokenizer = new StringTokenizer(string, " \t")).countTokens() == 0) {
            return false;
        }
        try {
            Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static boolean checkMopacGraphf(String[] stringArray) {
        return stringArray[0].indexOf("MOPAC-Graphical data") == 6;
    }

    private static boolean checkCube(String[] stringArray) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[2]);
            if (stringTokenizer == null || stringTokenizer.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(stringTokenizer.nextToken());
            int n = 3;
            while (--n >= 0) {
                new Float(stringTokenizer.nextToken());
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[3]);
            if (stringTokenizer2 == null || stringTokenizer2.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(stringTokenizer2.nextToken());
            int n2 = 3;
            while (--n2 >= 0) {
                Float f = new Float(stringTokenizer2.nextToken());
                if (!(f.floatValue() < 0.0f)) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

