# The LearningOnline Network
# User Authentication Module
#
# $Id: lonauth.pm,v 1.89 2007/10/01 23:56:14 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonauth;

use strict;
use LONCAPA;
use Apache::Constants qw(:common);
use CGI qw(:standard);
use DynaLoader; # for Crypt::DES version
use Crypt::DES;
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonmenu();
use Fcntl qw(:flock);
use Apache::lonlocal;
 
# ------------------------------------------------------------ Successful login
sub success {
    my ($r, $username, $domain, $authhost, $lowerurl, $extra_env,
	$form) = @_;

# ------------------------------------------------------------ Get cookie ready
    my $cookie =
	&Apache::loncommon::init_user_environment($r, $username, $domain,
						  $authhost, $form,
						  {'extra_env' => $extra_env,});

    my $public=($username eq 'public' && $domain eq 'public');

    if ($public or $lowerurl eq 'noredirect') { return $cookie; }

# -------------------------------------------------------------------- Log this

    &Apache::lonnet::log($domain,$username,$authhost,
                         "Login $ENV{'REMOTE_ADDR'}");

# ------------------------------------------------- Check for critical messages

    my @what=&Apache::lonnet::dump('critical',$domain,$username);
    if ($what[0]) {
	if (($what[0] ne 'con_lost') && ($what[0]!~/^error\:/)) {
	    $lowerurl='/adm/email?critical=display';
        }
    }

# ------------------------------------------------------------ Get cookie ready
    $cookie="lonID=$cookie; path=/";
# -------------------------------------------------------- Menu script and info
    my $windowinfo=&Apache::lonmenu::open($env{'browser.os'});
    my $startupremote=&Apache::lonmenu::startupremote($lowerurl);
    my $remoteinfo=&Apache::lonmenu::load_remote_msg($lowerurl);
    my $setflags=&Apache::lonmenu::setflags();
    my $maincall=&Apache::lonmenu::maincall();
    my $start_page=&Apache::loncommon::start_page('Successful Login',
						  $startupremote,
						  {'no_inline_link' => 1,});
    my $end_page  =&Apache::loncommon::end_page();

    my $continuelink;
    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off')) {
	$continuelink="<a href=\"$lowerurl\">".&mt('Continue')."</a>";
    }
# ------------------------------------------------- Output for successful login

    &Apache::loncommon::content_type($r,'text/html');
    $r->header_out('Set-cookie' => $cookie);
    $r->send_http_header;

    my %lt=&Apache::lonlocal::texthash(
				       'wel' => 'Welcome',
				       'mes' => 'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up',
				       'pro' => 'Problems',
				       'log' => 'loginproblems.html',
				       );
    $r->print(<<ENDSUCCESS);
$start_page
$setflags
$windowinfo
<h1>$lt{'wel'}</h1>
$lt{'mes'}.<p>
<a href="/adm/$lt{'log'}">$lt{'pro'}?</a></p>
$remoteinfo
$maincall
$continuelink
$end_page
ENDSUCCESS
}

# --------------------------------------------------------------- Failed login!

sub failed {
    my ($r,$message,$form) = @_;
    my $start_page = &Apache::loncommon::start_page('Unsuccessful Login',undef,
						    {'no_inline_link' => 1,});
    my $end_page   = &Apache::loncommon::end_page();

    $message = &mt($message);
    my %lt=('sorry'  => &mt('Sorry ...'),
	    'please' => 
	    &mt('Please [_1]log in again[_2].',
		"<a href=\"/adm/login?username=$form->{'uname'}&domain=$form->{'udom'}\">",
		'</a>'),
	    'problemspage' => &mt('loginproblems.html'),
	    'problems'     => 'Problems',
	    );
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

    $r->print(<<ENDFAILED);
$start_page
<h1>$lt{'sorry'}</h1>
<p><b>$message</b></p>
<p>$lt{'please'}</p>
<p>
<a href="/adm/$lt{'problemspage'}">$lt{'problems'}</a></p>
$end_page
ENDFAILED
}

# ------------------------------------------------------------------ Rerouting!

sub reroute {
    my ($r) = @_;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    my $msg='<h1>Sorry ...</h1>
             Please <a href="/">log in again</a>.';
    &Apache::loncommon::simple_error_page($r,'Rerouting',$msg);
}

# ---------------------------------------------------------------- Main handler

sub handler {
    my $r = shift;
    my $form;
# Are we re-routing?
    if (-e '/home/httpd/html/lon-status/reroute.txt') {
	&reroute($r);
	return OK;
    }

    &Apache::lonlocal::get_language_handle($r);

# -------------------------------- Prevent users from attempting to login twice
    my $handle = &Apache::lonnet::check_for_valid_session($r);
    if ($handle ne '') {
# Indeed, a valid token is found
	&Apache::loncommon::content_type($r,'text/html');
	$r->send_http_header;
	my $start_page = 
	    &Apache::loncommon::start_page('Already logged in');
	my $end_page = 
	    &Apache::loncommon::end_page();
	$r->print(<<ENDFAILED);
$start_page
<h1>You are already logged in</h1>
<p>Please either <a href="/adm/roles">continue the current session</a> or
<a href="/adm/logout">logout</a>.</p>
<p>
<a href="/adm/loginproblems.html">Problems?</a></p>
$end_page
ENDFAILED
       return OK;
    }

# ---------------------------------------------------- No valid token, continue


    my $buffer;
    if ($r->header_in('Content-length') > 0) {
	$r->read($buffer,$r->header_in('Content-length'),0);
    }
    my %form;
    foreach my $pair (split(/&/,$buffer)) {
       my ($name,$value) = split(/=/,$pair);
       $value =~ tr/+/ /;
       $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
       $form{$name}=$value;
    } 

    if ((!$form{'uname'}) || (!$form{'upass0'}) || (!$form{'udom'})) {
	&failed($r,'Username, password and domain need to be specified.',
		\%form);
        return OK;
    }

# split user logging in and "su"-user

    ($form{'uname'},$form{'suname'})=split(/\:/,$form{'uname'});
    $form{'uname'} = &LONCAPA::clean_username($form{'uname'});
    $form{'suname'}= &LONCAPA::clean_username($form{'suname'});
    $form{'udom'}  = &LONCAPA::clean_domain(  $form{'udom'});

    my $role   = $r->dir_config('lonRole');
    my $domain = $r->dir_config('lonDefDomain');
    my $prodir = $r->dir_config('lonUsersDir');

# ---------------------------------------- Get the information from login token

    my $tmpinfo=Apache::lonnet::reply('tmpget:'.$form{'logtoken'},
                                      $form{'serverid'});

    if (($tmpinfo=~/^error/) || ($tmpinfo eq 'con_lost')) {
	&failed($r,'Information needed to verify your login information is missing, inaccessible or expired.',\%form);
        return OK;
    } else {
	my $reply = &Apache::lonnet::reply('tmpdel:'.$form{'logtoken'},
					   $form{'serverid'});
        if ( $reply ne 'ok' ) {
            &failed($r,'Session could not be opened.',\%form);
	    &Apache::lonnet::logthis("ERROR got a reply of $reply when trying to contact ". $form{'serverid'}." to get login token");
	    return OK;
	}
    }
    my ($key,$firsturl)=split(/&/,$tmpinfo);

    my $keybin=pack("H16",$key);

    my $cipher;
    if ($Crypt::DES::VERSION>=2.03) {
	$cipher=new Crypt::DES $keybin;
    }
    else {
	$cipher=new DES $keybin;
    }
    my $upass='';
    for (my $i=0;$i<=2;$i++) {
	my $chunk=
	    $cipher->decrypt(unpack("a8",pack("H16",substr($form{'upass'.$i},0,16))));

	$chunk.=
	    $cipher->decrypt(unpack("a8",pack("H16",substr($form{'upass'.$i},16,16))));

	$chunk=substr($chunk,1,ord(substr($chunk,0,1)));
	$upass.=$chunk;
    }

# ---------------------------------------------------------------- Authenticate
    my $authhost=Apache::lonnet::authenticate($form{'uname'},
                                              $upass,
                                              $form{'udom'});
    
# --------------------------------------------------------------------- Failed?

    if ($authhost eq 'no_host') {
	&failed($r,'Username and/or password could not be authenticated.',
		\%form);
        return OK;
    }

    if (($firsturl eq '') || 
	($firsturl=~/^\/adm\/(logout|remote)/)) {
	$firsturl='/adm/roles';
    }
# --------------------------------- Are we attempting to login as somebody else?
    if ($form{'suname'}) {
# ------------ see if the original user has enough privileges to pull this stunt
	if (&Apache::lonnet::privileged($form{'uname'},$form{'udom'})) {
# ---------------------------------------------------- see if the su-user exists
	    unless (&Apache::lonnet::homeserver($form{'suname'},$form{'udom'})
		eq 'no_host') {
		&Apache::lonnet::logthis(&Apache::lonnet::homeserver($form{'suname'},$form{'udom'}));
# ------------------------------ see if the su-user is not too highly privileged
		unless (&Apache::lonnet::privileged($form{'suname'},$form{'udom'})) {
# -------------------------------------------------------- actually switch users
		    &Apache::lonnet::logperm('User '.$form{'uname'}.' at '.$form{'udom'}.
			' logging in as '.$form{'suname'});
		    $form{'uname'}=$form{'suname'};
		} else {
		    &Apache::lonnet::logthis('Attempted switch user to privileged user');
		}
	    }
	} else {
	    &Apache::lonnet::logthis('Non-privileged user attempting switch user');
	}
    }

    if ($r->dir_config("lonBalancer") eq 'yes') {
	&success($r,$form{'uname'},$form{'udom'},$authhost,'noredirect',undef,
		 \%form);
	$r->internal_redirect('/adm/switchserver');
    } else {
	&success($r,$form{'uname'},$form{'udom'},$authhost,$firsturl,undef,
		 \%form);
    }
    return OK;
}

1;
__END__


