#
# LON-CAPA helpers for cgi-bin scripts
#
# $Id: loncgi.pm,v 1.8 2006/09/19 21:36:31 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#############################################
#############################################

=pod

=head1 NAME

loncgi

=head1 SYNOPSIS

Provides subroutines for checking a LON-CAPA cookie and loading the users
environment.

=head1 Subroutines

=over 4 

=cut

#############################################
#############################################
package LONCAPA::loncgi;

use strict;
use warnings FATAL=>'all';
no warnings 'uninitialized';

use lib '/home/httpd/lib/perl/';
use CGI();
use CGI::Cookie();
use Fcntl qw(:flock);
use LONCAPA;
use LONCAPA::Configuration();
use GDBM_File;

my $lonidsdir;

BEGIN {
    my $perlvar=LONCAPA::Configuration::read_conf('loncapa.conf');
    delete $perlvar->{'lonReceipt'};
    $lonidsdir = $perlvar->{'lonIDsDir'};
}

#############################################
#############################################

=pod

=item check_cookie_and_load_env

Inputs: none

Returns: 1 if the user has a LON-CAPA cookie 0 if not.
Loads the users environment into the %env hash if the cookie is correct.

=cut

#############################################
#############################################
sub check_cookie_and_load_env {
    my %cookies=fetch CGI::Cookie;
    if (exists($cookies{'lonID'}) && 
        -e "$lonidsdir/".$cookies{'lonID'}->value.".id") {
        # cookie found
        &transfer_profile_to_env($cookies{'lonID'}->value);
        return 1;
    } else {
        # No cookie found
        return 0;
    }
}

#############################################
#############################################

=pod

=item check_cookie

Inputs: none

Returns: 1 if the user has a LON-CAPA cookie and 0 if not.

=cut

#############################################
#############################################
sub check_cookie {
    my %cookies=fetch CGI::Cookie;
    if (exists($cookies{'lonID'}) && 
        -e "$lonidsdir/".$cookies{'lonID'}->value.".id") {
        # cookie found
        return 1;
    } else {
        # No cookie found
        return 0;
    }
}

#############################################
#############################################

=pod

=item transfer_profile_to_env

Load the users environment into the %env hash.

Inputs: $handle, the name of the users LON-CAPA cookie.

Returns: undef

=cut

#############################################
#############################################
sub transfer_profile_to_env {
    my ($handle)=@_;
   if (tie(my %disk_env,'GDBM_File',"$lonidsdir/$handle.id",&GDBM_READER(),
	    0640)) {
	%Apache::lonnet::env = %disk_env;
	untie(%disk_env);
    }
    $Apache::lonnet::env{'user.environment'} = "$lonidsdir/$handle.id";
    return undef;
}

#############################################
#############################################


=pod

=back

=cut

1;

__END__
