/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.i18n.GT;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class PickingManager {
    Viewer viewer;
    int pickingMode = 1;
    int pickingStyleSelect = 0;
    int pickingStyleMeasure = 4;
    boolean drawHover = false;
    int queuedAtomCount = 0;
    int[] queuedAtomIndexes = new int[4];
    int[] countPlusIndices = new int[5];

    PickingManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    void clear() {
        this.pickingMode = 1;
        this.drawHover = false;
    }

    void atomPicked(int n, int n2) {
        boolean bl;
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = bl = (n2 & 8) != 0;
        if (n == -1) {
            if (this.pickingStyleSelect == 2 && !bl2 && !bl) {
                this.viewer.script("select none");
            }
            if (this.pickingMode == 14 || this.pickingStyleMeasure == 3) {
                this.queuedAtomCount = 0;
            }
            if (this.pickingMode == 3) {
                this.viewer.script("zoomTo out");
            }
            return;
        }
        ModelSet modelSet = this.viewer.getModelSet();
        switch (this.pickingMode) {
            case 0: {
                break;
            }
            case 1: {
                this.viewer.setStatusAtomPicked(n, this.viewer.getAtomInfoXYZ(n));
                break;
            }
            case 14: 
            case 15: {
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(n);
                if (this.queuedAtomCount < 2) break;
                float f = modelSet.getDistance(this.queuedAtomIndexes[0], n);
                String string = "Distance " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " : " + f;
                this.viewer.setStatusNewPickingModeMeasurement(2, string);
                if (this.pickingMode != 14 && this.pickingStyleMeasure != 3) break;
                this.toggleMeasurement(2);
                break;
            }
            case 16: {
                if (this.queuedAtomCount >= 3) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(n);
                if (this.queuedAtomCount < 3) break;
                float f = modelSet.getAngle(this.queuedAtomIndexes[0], this.queuedAtomIndexes[1], n);
                String string = "Angle " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[2]) + " : " + f;
                this.viewer.setStatusNewPickingModeMeasurement(3, string);
                if (this.pickingStyleMeasure != 3) break;
                this.toggleMeasurement(3);
                break;
            }
            case 17: {
                if (this.queuedAtomCount >= 4) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(n);
                if (this.queuedAtomCount < 4) break;
                float f = modelSet.getTorsion(this.queuedAtomIndexes[0], this.queuedAtomIndexes[1], this.queuedAtomIndexes[2], n);
                String string = "Torsion " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[2]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[3]) + " : " + f;
                this.viewer.setStatusNewPickingModeMeasurement(4, string);
                if (this.pickingStyleMeasure != 3) break;
                this.toggleMeasurement(4);
                break;
            }
            case 2: {
                this.viewer.script("toggleLabel = {atomindex=" + n + "}");
                break;
            }
            case 3: {
                this.viewer.script("zoomTo (atomindex=" + n + ")");
                break;
            }
            case 8: {
                this.applyMouseStyle("atomIndex=" + n, bl2, bl);
                this.viewer.clearClickCount();
                break;
            }
            case 9: {
                this.applyMouseStyle("within(group, atomIndex=" + n + ")", bl2, bl);
                this.viewer.clearClickCount();
                break;
            }
            case 10: {
                this.applyMouseStyle("within(chain, atomIndex=" + n + ")", bl2, bl);
                this.viewer.clearClickCount();
                break;
            }
            case 11: {
                this.applyMouseStyle("visible and within(molecule, atomIndex=" + n + ")", bl2, bl);
                this.viewer.clearClickCount();
                break;
            }
            case 12: {
                this.applyMouseStyle("visible and within(site, atomIndex=" + n + ")", bl2, bl);
                this.viewer.clearClickCount();
                break;
            }
            case 13: {
                this.applyMouseStyle("visible and within(element, atomIndex=" + n + ")", bl2, bl);
                this.viewer.clearClickCount();
                break;
            }
            case 5: {
                if (this.viewer.getSpinOn()) {
                    this.viewer.script("spin off");
                    break;
                }
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                if (this.queuedAtomCount == 1 && this.queuedAtomIndexes[0] == n) break;
                this.queueAtom(n);
                if (this.queuedAtomCount < 2) {
                    if (this.viewer.getSpinOn()) {
                        this.viewer.script("spin off");
                    }
                    this.viewer.scriptStatus(this.queuedAtomCount == 1 ? GT._((String)"pick one more atom in order to spin the model around an axis") : GT._((String)"pick two atoms in order to spin the model around an axis"));
                    break;
                }
                this.viewer.script("spin (atomindex=" + this.queuedAtomIndexes[0] + ") (atomIndex=" + n + ") " + this.viewer.getPickingSpinRate());
            }
        }
    }

    void toggleMeasurement(int n) {
        this.countPlusIndices[0] = n;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            int n3 = this.queuedAtomIndexes[i];
            if (n2 == n3) {
                this.queuedAtomCount = i;
                return;
            }
            int n4 = n3;
            this.countPlusIndices[i + 1] = n4;
            n2 = n4;
        }
        this.viewer.script(Measurement.getMeasurementScript(this.countPlusIndices));
    }

    void applyMouseStyle(String string, boolean bl, boolean bl2) {
        string = "(" + string + ")";
        if (this.pickingStyleSelect == 2) {
            if (bl && bl2) {
                this.viewer.script("select selected and not " + string);
            } else if (bl) {
                this.viewer.script("select selected tog " + string);
            } else if (bl2) {
                this.viewer.script("select selected or " + string);
            } else {
                this.viewer.script("select " + string);
            }
        } else if (bl | this.pickingStyleSelect == 0) {
            this.viewer.script("select selected tog " + string);
        } else {
            this.viewer.script("select " + string);
        }
    }

    int getPickingMode() {
        return this.pickingMode;
    }

    void setPickingMode(int n) {
        this.pickingMode = n;
        this.queuedAtomCount = 0;
    }

    void setPickingStyle(int n) {
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)(" setPickingStyle " + n + ": " + JmolConstants.getPickingStyleName(n)));
        }
        if (n >= 3) {
            this.pickingStyleMeasure = n;
            this.queuedAtomCount = 0;
        } else {
            this.pickingStyleSelect = n;
        }
    }

    void setDrawHover(boolean bl) {
        this.drawHover = bl;
    }

    boolean getDrawHover() {
        return this.drawHover;
    }

    void queueAtom(int n) {
        this.queuedAtomIndexes[this.queuedAtomCount++] = n;
        this.viewer.setStatusAtomPicked(n, "Atom #" + this.queuedAtomCount + ":" + this.viewer.getAtomInfo(n));
    }
}

