/*
 * Decompiled with CFR 0.152.
 */
package Display;

import Display.ComListener;
import Display.DocListener;
import Display.FocListener;
import Display.InputComponent;
import Display.LanguageManager;
import Display.MseSelectListener;
import Display.StatusBar;
import Display.TextBox;
import Tree.BinaryOperator;
import Tree.BuildTree;
import Tree.Function;
import Tree.Grouping;
import Tree.MathObject;
import Tree.Matrix;
import Tree.NaryFunction;
import Tree.NaryOperator;
import Tree.Precedence;
import Tree.RealNumber;
import Tree.Text;
import Tree.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class AddComponent {
    private static InputComponent[] inputComponents;
    private BuildTree buildTree;
    private JPanel jPanelWorkspace;
    private MouseListener textBoxListener;
    private StatusBar statusBar;
    private LanguageManager langMan;
    private MathObject copyTree;
    private MathObject savedState;
    private MathObject[] savedStates;
    private int savedLocation;
    private boolean selectionComponentFound;
    private JPanel selectionLayer;
    private int firstLocation;
    private int lastLocation;
    public static final int LAYOUT = 0;
    public static final int NARY = 1;
    public static final int BINARY = 2;
    public static final int FUNCTION = 3;
    public static final int SYMBOL = 4;
    public static final int GROUPING = 5;
    public static final int BLANK_WORKSPACE = 0;
    public static final int ONTO_BOX = 1;
    public static final int ONTO_GRAPHIC = 2;
    public static final int ONTO_SELECTION = 3;

    public AddComponent(InputComponent[] inputComponents, JPanel jPanelWorkspace, BuildTree buildTree, MouseListener textBoxListener, StatusBar statusBar, LanguageManager langMan) {
        AddComponent.inputComponents = inputComponents;
        this.statusBar = statusBar;
        this.jPanelWorkspace = jPanelWorkspace;
        this.buildTree = buildTree;
        this.textBoxListener = textBoxListener;
        this.langMan = langMan;
        this.copyTree = null;
        this.selectionComponentFound = false;
        this.savedStates = new MathObject[10];
        this.savedLocation = 0;
    }

    public static int getID(String name) {
        int id = -1;
        try {
            int i = name.indexOf(45);
            id = Integer.parseInt(name.substring(0, i));
        }
        catch (NullPointerException ex) {
        }
        catch (NumberFormatException ex) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return id;
    }

    public static int getGroup(String name) {
        int i = AddComponent.getID(name);
        if (i != -1) {
            return inputComponents[AddComponent.getID(name)].getGroup();
        }
        return -1;
    }

    public static String getName(String tag) {
        String name = "";
        try {
            int i = tag.indexOf(45);
            name = tag.substring(++i);
        }
        catch (NullPointerException ex) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return name;
    }

    public TextBox createBox(boolean small) {
        TextBox newBox = new TextBox();
        newBox.setBorder(new EtchedBorder());
        newBox.setHighlighter(null);
        if (small) {
            newBox.setFont(new Font("Monospaced", 0, 10));
        } else {
            newBox.setFont(new Font("Monospaced", 0, 16));
        }
        newBox.addMouseListener(this.textBoxListener);
        newBox.getDocument().addDocumentListener(new DocListener(newBox));
        newBox.addFocusListener(new FocListener(this));
        newBox.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 86 && evt.isControlDown()) {
                    AddComponent.this.paste();
                }
                if (evt.getKeyCode() == 88 && evt.isControlDown()) {
                    try {
                        AddComponent.this.cut(AddComponent.this.jPanelWorkspace, AddComponent.this.buildTree);
                    }
                    catch (ParseException ex) {
                        AddComponent.this.statusBar.println(ex.getMessage());
                    }
                }
                if (evt.getKeyCode() == 67 && evt.isControlDown()) {
                    try {
                        AddComponent.this.copy(AddComponent.this.jPanelWorkspace, AddComponent.this.buildTree);
                    }
                    catch (ParseException ex) {
                        AddComponent.this.statusBar.println(ex.getMessage());
                    }
                }
            }
        });
        newBox.setColumns(1);
        return newBox;
    }

    public static JPanel createPanel(String tag) {
        JPanel newPanel = new JPanel(new FlowLayout(1, 0, 0));
        newPanel.setBackground(new Color(255, 255, 255));
        newPanel.setName(tag);
        return newPanel;
    }

    public JLabel createSymbol(InputComponent newComponent) {
        JLabel newLabel = new JLabel(newComponent.getDisplayText(), 4);
        newLabel.setFont(new Font("Lucida Sans Unicode", 0, 16));
        newLabel.setName(newComponent.getTag());
        return newLabel;
    }

    public static JPanel getOperator(JPanel layer, int n) {
        JPanel newPanel = AddComponent.createPanel("");
        newPanel.add(layer.getComponent(n - 1));
        newPanel.add(layer.getComponent(n - 1));
        newPanel.add(layer.getComponent(n - 1));
        return newPanel;
    }

    public static int getComponentPosition(JPanel layer, JComponent comp) {
        Component[] components = layer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!comp.equals(components[i])) continue;
            return i;
        }
        return -1;
    }

    public void addOperator(JPanel layer, int n, InputComponent newComponent, int status, boolean layoutPanel, JPanel argumentPanel) {
        if (status == 0) {
            layer.add((Component)this.createBox(false), n);
            layer.add((Component)this.createSymbol(newComponent), n + 1);
            layer.add((Component)this.createBox(false), n + 2);
            layer.getComponent(n).requestFocusInWindow();
        }
        if (status == 1) {
            layer.add((Component)this.createSymbol(newComponent), n + 1);
            layer.add((Component)this.createBox(false), n + 2);
            layer.getComponent(n + 2).requestFocusInWindow();
        }
        if (status == 2) {
            Component[] components = layer.getComponents();
            int oldSymbolGroup = layoutPanel ? 0 : AddComponent.getGroup(components[n].getName());
            if (oldSymbolGroup == 1 || oldSymbolGroup == 2) {
                layer.add((Component)this.createSymbol(newComponent), n + 2);
                layer.add((Component)this.createBox(false), n + 3);
                layer.getComponent(n + 3).requestFocusInWindow();
            } else {
                JPanel parent = (JPanel)layer.getParent();
                int j = AddComponent.getComponentPosition(parent, layer);
                parent.add((Component)this.createSymbol(newComponent), j + 1);
                parent.add((Component)this.createBox(false), j + 2);
                parent.getComponent(j + 2).requestFocusInWindow();
            }
        }
        if (status == 3) {
            int i = argumentPanel.getComponentCount();
            int j = 0;
            while (argumentPanel.getComponentCount() > 0) {
                layer.add(argumentPanel.getComponent(0), n + j);
                ++j;
            }
            layer.add((Component)this.createSymbol(newComponent), n + i);
            layer.add((Component)this.createBox(false), n + i + 1);
            layer.getComponent(n + i + 1).requestFocusInWindow();
        }
        layer.revalidate();
    }

    public void addFunction(JPanel layer, int n, InputComponent newComponent, int status, boolean layoutPanel, JPanel argument) {
        JLabel bracket1 = new JLabel("(");
        JLabel bracket2 = new JLabel(")");
        bracket1.setName(newComponent.getTag());
        bracket2.setName(newComponent.getTag());
        JPanel newPanel = AddComponent.createPanel(newComponent.getTag());
        newPanel.add(this.createSymbol(newComponent));
        newPanel.add(bracket1);
        JPanel argumentPanel = null;
        if (status == 0) {
            argumentPanel = AddComponent.createPanel("");
            argumentPanel.add(this.createBox(false));
            newPanel.add(argumentPanel);
            newPanel.add(bracket2);
            layer.add((Component)newPanel, n);
            argumentPanel.getComponent(0).requestFocusInWindow();
        }
        if (status == 1) {
            argumentPanel = AddComponent.createPanel("");
            argumentPanel.add(layer.getComponent(n));
            newPanel.add(argumentPanel);
            newPanel.add(bracket2);
            layer.add((Component)newPanel, n);
            argumentPanel.getComponent(0).requestFocusInWindow();
        }
        if (status == 2) {
            Component[] components = layer.getComponents();
            int oldSymbolGroup = layoutPanel ? 0 : AddComponent.getGroup(components[n].getName());
            if (oldSymbolGroup == 1 || oldSymbolGroup == 2) {
                argumentPanel = AddComponent.createPanel("");
                argumentPanel = AddComponent.getOperator(layer, n);
                newPanel.add(argumentPanel);
                newPanel.add(bracket2);
                layer.add((Component)newPanel, n - 1);
            } else {
                JPanel parentLayer = (JPanel)layer.getParent();
                argumentPanel = AddComponent.createPanel("");
                int j = AddComponent.getComponentPosition(parentLayer, layer);
                argumentPanel.add(layer);
                newPanel.add(argumentPanel);
                newPanel.add(bracket2);
                parentLayer.add((Component)newPanel, j);
            }
        }
        if (status == 3) {
            argumentPanel = argument;
            newPanel.add(argumentPanel);
            newPanel.add(bracket2);
            layer.add((Component)newPanel, n);
        }
        layer.revalidate();
        argumentPanel.addComponentListener(new ComListener(argumentPanel, 0, 1, 3));
    }

    public void addGrouping(JPanel layer, int n, InputComponent newComponent, int status, boolean layoutPanel, JPanel argument) {
        int i = newComponent.getDisplayText().indexOf(" ");
        String left = newComponent.getDisplayText().substring(0, i);
        String right = newComponent.getDisplayText().substring(i + 1, i + 2);
        JLabel bracket1 = new JLabel(left);
        JLabel bracket2 = new JLabel(right);
        bracket1.setName(newComponent.getTag());
        bracket2.setName(newComponent.getTag());
        JPanel newPanel = AddComponent.createPanel(newComponent.getTag());
        newPanel.add(bracket1);
        JPanel argumentPanel = null;
        if (status == 0) {
            argumentPanel = AddComponent.createPanel("");
            argumentPanel.add(this.createBox(false));
            newPanel.add(argumentPanel);
            newPanel.add(bracket2);
            layer.add((Component)newPanel, n);
            argumentPanel.getComponent(0).requestFocusInWindow();
        }
        if (status == 1) {
            argumentPanel = AddComponent.createPanel("");
            argumentPanel.add(layer.getComponent(n));
            newPanel.add(argumentPanel);
            newPanel.add(bracket2);
            layer.add((Component)newPanel, n);
            argumentPanel.getComponent(0).requestFocusInWindow();
        }
        if (status == 2) {
            Component[] components = layer.getComponents();
            int oldSymbolGroup = layoutPanel ? 0 : AddComponent.getGroup(components[n].getName());
            if (oldSymbolGroup == 1 || oldSymbolGroup == 2) {
                argumentPanel = AddComponent.createPanel("");
                argumentPanel = AddComponent.getOperator(layer, n);
                newPanel.add(argumentPanel);
                newPanel.add(bracket2);
                layer.add((Component)newPanel, n - 1);
            } else {
                JPanel parentLayer = (JPanel)layer.getParent();
                argumentPanel = AddComponent.createPanel("");
                argumentPanel.add(layer);
                int j = AddComponent.getComponentPosition(parentLayer, layer);
                newPanel.add(argumentPanel);
                newPanel.add(bracket2);
                parentLayer.add((Component)newPanel, j);
            }
        }
        if (status == 3) {
            argumentPanel = argument;
            newPanel.add(argumentPanel);
            newPanel.add(bracket2);
            layer.add((Component)newPanel, n);
        }
        argumentPanel.addComponentListener(new ComListener(argumentPanel, 0, 0, 2));
        layer.revalidate();
    }

    public void addSymbol(JPanel layer, int n, InputComponent newComponent, int status) {
        if (status == 1) {
            JTextField temp = (JTextField)layer.getComponent(n);
            temp.setText(temp.getText() + newComponent.getDisplayText());
            temp.requestFocus();
        }
        layer.revalidate();
    }

    public void addLayout(JPanel layer, int n, InputComponent newComponent, int status, boolean layoutPanel, int matrix_m, int matrix_n, JPanel selection) {
        int newSymbolID = newComponent.getID();
        JPanel newPanel = new JPanel(new GridBagLayout());
        newPanel.setBackground(new Color(255, 255, 255));
        newPanel.setName(newComponent.getTag());
        if (newSymbolID == 7 || newSymbolID == 8) {
            GridBagConstraints arg = new GridBagConstraints();
            GridBagConstraints supscript = new GridBagConstraints();
            GridBagConstraints subscript = new GridBagConstraints();
            arg.gridx = 0;
            subscript.gridx = 1;
            supscript.gridx = 1;
            arg.gridy = 1;
            subscript.gridy = 2;
            supscript.gridy = 0;
            arg.gridheight = 2;
            subscript.gridheight = 2;
            supscript.gridheight = 2;
            JPanel argumentPanel = AddComponent.createPanel("");
            JPanel scriptPanel = AddComponent.createPanel("");
            scriptPanel.add(this.createBox(false));
            JTextField temp = new JTextField();
            temp.setName("");
            temp.setEditable(false);
            temp.setBorder(BorderFactory.createEmptyBorder());
            if (status == 0) {
                argumentPanel.add(this.createBox(false));
                if (newSymbolID == 8) {
                    newPanel.add((Component)argumentPanel, arg);
                    newPanel.add((Component)scriptPanel, subscript);
                    newPanel.add((Component)temp, supscript);
                } else {
                    newPanel.add((Component)argumentPanel, arg);
                    newPanel.add((Component)scriptPanel, supscript);
                }
                layer.add((Component)newPanel, n);
                argumentPanel.getComponent(0).requestFocusInWindow();
            }
            if (status == 1) {
                argumentPanel.add(layer.getComponent(n));
                if (newSymbolID == 8) {
                    newPanel.add((Component)argumentPanel, arg);
                    newPanel.add((Component)scriptPanel, subscript);
                    newPanel.add((Component)temp, supscript);
                } else {
                    newPanel.add((Component)argumentPanel, arg);
                    newPanel.add((Component)scriptPanel, supscript);
                }
                layer.add((Component)newPanel, n);
                argumentPanel.getComponent(0).requestFocusInWindow();
            }
            if (status == 2) {
                subscript.anchor = 15;
                Component[] components = layer.getComponents();
                int oldSymbolGroup = layoutPanel ? 0 : AddComponent.getGroup(components[n].getName());
                if (oldSymbolGroup == 1 || oldSymbolGroup == 2) {
                    argumentPanel = AddComponent.getOperator(layer, n);
                    if (newSymbolID == 8) {
                        newPanel.add((Component)argumentPanel, arg);
                        newPanel.add((Component)scriptPanel, subscript);
                        newPanel.add((Component)temp, supscript);
                    } else {
                        newPanel.add((Component)argumentPanel, arg);
                        newPanel.add((Component)scriptPanel, supscript);
                    }
                    layer.add((Component)newPanel, n - 1);
                } else {
                    JPanel parentLayer = (JPanel)layer.getParent();
                    int j = AddComponent.getComponentPosition(parentLayer, layer);
                    argumentPanel.add(layer);
                    if (newSymbolID == 8) {
                        newPanel.add((Component)argumentPanel, arg);
                        newPanel.add((Component)scriptPanel, subscript);
                        newPanel.add((Component)temp, supscript);
                    } else {
                        newPanel.add((Component)argumentPanel, arg);
                        newPanel.add((Component)scriptPanel, supscript);
                    }
                    parentLayer.add((Component)newPanel, j);
                }
            }
            if (status == 3) {
                subscript.anchor = 15;
                argumentPanel = selection;
                if (newSymbolID == 8) {
                    newPanel.add((Component)argumentPanel, arg);
                    newPanel.add((Component)scriptPanel, subscript);
                    newPanel.add((Component)temp, supscript);
                } else {
                    newPanel.add((Component)argumentPanel, arg);
                    newPanel.add((Component)scriptPanel, supscript);
                }
                layer.add((Component)newPanel, n);
            }
        } else if (newSymbolID == 29) {
            GridBagConstraints arg = new GridBagConstraints();
            GridBagConstraints script = new GridBagConstraints();
            script.gridx = 1;
            arg.gridx = 0;
            script.gridy = 0;
            arg.gridy = 1;
            script.gridheight = 2;
            arg.gridheight = 2;
            newPanel.add((Component)this.createSymbol(newComponent), arg);
            JPanel scriptPanel = AddComponent.createPanel("");
            if (status == 0) {
                scriptPanel.add(this.createBox(false));
                newPanel.add((Component)scriptPanel, script);
                layer.add((Component)newPanel, n);
                scriptPanel.getComponent(0).requestFocusInWindow();
            }
            if (status == 1) {
                scriptPanel.add(layer.getComponent(n));
                newPanel.add((Component)scriptPanel, script);
                layer.add((Component)newPanel, n);
                scriptPanel.getComponent(0).requestFocusInWindow();
            }
        } else if (newSymbolID == 9) {
            JLabel bracket1 = new JLabel("[");
            JLabel bracket2 = new JLabel("]");
            bracket1.setName(newComponent.getTag());
            bracket2.setName(newComponent.getTag());
            JPanel parentLayer = AddComponent.createPanel(newComponent.getTag());
            JPanel matrix = new JPanel(new GridLayout(matrix_m, matrix_n, 4, 4));
            matrix.setBackground(new Color(255, 255, 255));
            matrix.setName("");
            parentLayer.add(bracket1);
            for (int i = 0; i < matrix_m * matrix_n; ++i) {
                JPanel box = AddComponent.createPanel("");
                box.add(this.createBox(false));
                matrix.add(box);
            }
            if (status == 0) {
                parentLayer.add(matrix);
                parentLayer.add(bracket2);
                layer.add((Component)parentLayer, n);
                matrix.addComponentListener(new ComListener(matrix, 0, 0, 2));
            } else if (status == 1) {
                layer.remove(n);
                parentLayer.add(matrix);
                parentLayer.add(bracket2);
                layer.add((Component)parentLayer, n);
                matrix.addComponentListener(new ComListener(matrix, 0, 0, 2));
            } else {
                JOptionPane.showMessageDialog(null, this.langMan.readLangFile("AddMatrix"), "DragMath", 0);
            }
        } else {
            JLabel newLabel;
            JSeparator bar;
            GridBagConstraints mid;
            GridBagConstraints arg1 = null;
            JPanel argPanel1 = AddComponent.createPanel("");
            if (newSymbolID == 5 || newSymbolID == 6) {
                GridBagConstraints nw = new GridBagConstraints();
                GridBagConstraints ne = new GridBagConstraints();
                GridBagConstraints sw = new GridBagConstraints();
                GridBagConstraints se = new GridBagConstraints();
                nw.gridx = 0;
                ne.gridx = 1;
                sw.gridx = 0;
                se.gridx = 1;
                nw.gridy = 0;
                ne.gridy = 0;
                sw.gridy = 1;
                se.gridy = 1;
                sw.anchor = 13;
                ne.fill = 2;
                ne.anchor = 15;
                JSeparator bar2 = new JSeparator();
                bar2.setForeground(new Color(0, 0, 0));
                newPanel.add((Component)this.createSymbol(newComponent), sw);
                newPanel.add((Component)bar2, ne);
                if (newSymbolID == 6) {
                    JPanel topPanel = AddComponent.createPanel("");
                    topPanel.add(this.createBox(false));
                    newPanel.add((Component)topPanel, nw);
                }
                arg1 = se;
            }
            if (newSymbolID == 1) {
                GridBagConstraints top = new GridBagConstraints();
                mid = new GridBagConstraints();
                GridBagConstraints bot = new GridBagConstraints();
                top.insets = new Insets(0, 5, 0, 5);
                bot.insets = new Insets(0, 5, 0, 5);
                top.gridx = 0;
                mid.gridx = 0;
                bot.gridx = 0;
                top.gridy = 0;
                mid.gridy = 1;
                bot.gridy = 2;
                mid.fill = 2;
                bar = new JSeparator();
                bar.setForeground(new Color(0, 0, 0));
                bar.setName(newComponent.getTag());
                JPanel bottomPanel = AddComponent.createPanel("");
                bottomPanel.add(this.createBox(false));
                arg1 = top;
                newPanel.add((Component)bar, mid);
                newPanel.add((Component)bottomPanel, bot);
            }
            if (newSymbolID == 37 || newSymbolID == 46 || newSymbolID == 84 || newSymbolID == 54 || newSymbolID == 55 || newSymbolID == 56) {
                JSeparator bar3;
                GridBagConstraints bot;
                GridBagConstraints mid2;
                GridBagConstraints top;
                JPanel fraction;
                GridBagConstraints left = new GridBagConstraints();
                GridBagConstraints right = new GridBagConstraints();
                left.gridx = 0;
                right.gridx = 1;
                if (newSymbolID == 37) {
                    newPanel.add((Component)this.createSymbol(newComponent), right);
                    arg1 = left;
                }
                if (newSymbolID == 46) {
                    fraction = new JPanel(new GridBagLayout());
                    fraction.setBackground(new Color(255, 255, 255));
                    fraction.setName("");
                    top = new GridBagConstraints();
                    mid2 = new GridBagConstraints();
                    bot = new GridBagConstraints();
                    top.gridy = 0;
                    mid2.gridy = 1;
                    bot.gridy = 2;
                    mid2.fill = 2;
                    bar3 = new JSeparator();
                    bar3.setForeground(new Color(0, 0, 0));
                    bar3.setName("");
                    JLabel newLabel2 = new JLabel("d", 4);
                    newLabel2.setFont(new Font("Lucida Sans Unicode", 0, 16));
                    newLabel2.setName("");
                    JLabel newLabel22 = new JLabel("d", 4);
                    newLabel22.setFont(new Font("Lucida Sans Unicode", 0, 16));
                    newLabel22.setName("");
                    fraction.add((Component)newLabel2, top);
                    fraction.add((Component)bar3, mid2);
                    JPanel bottomPanel = AddComponent.createPanel("");
                    JPanel argPanel2 = AddComponent.createPanel("");
                    bottomPanel.add(newLabel22);
                    argPanel2.add(this.createBox(false));
                    bottomPanel.add(argPanel2);
                    fraction.add((Component)bottomPanel, bot);
                    newPanel.add((Component)fraction, left);
                    arg1 = right;
                }
                if (newSymbolID == 84) {
                    fraction = new JPanel(new GridBagLayout());
                    fraction.setBackground(new Color(255, 255, 255));
                    fraction.setName("");
                    top = new GridBagConstraints();
                    mid2 = new GridBagConstraints();
                    bot = new GridBagConstraints();
                    top.gridy = 0;
                    mid2.gridy = 1;
                    bot.gridy = 2;
                    mid2.fill = 2;
                    bar3 = new JSeparator();
                    bar3.setForeground(new Color(0, 0, 0));
                    bar3.setName("");
                    char partial = '\u2202';
                    newLabel = new JLabel(String.valueOf(partial), 4);
                    newLabel.setFont(new Font("Lucida Sans Unicode", 0, 16));
                    newLabel.setName("");
                    JLabel newLabel2 = new JLabel(String.valueOf(partial), 4);
                    newLabel2.setFont(new Font("Lucida Sans Unicode", 0, 16));
                    newLabel2.setName("");
                    fraction.add((Component)newLabel, top);
                    fraction.add((Component)bar3, mid2);
                    JPanel bottomPanel = AddComponent.createPanel("");
                    JPanel argPanel2 = AddComponent.createPanel("");
                    bottomPanel.add(newLabel2);
                    argPanel2.add(this.createBox(false));
                    bottomPanel.add(argPanel2);
                    fraction.add((Component)bottomPanel, bot);
                    newPanel.add((Component)fraction, left);
                    arg1 = right;
                }
                if (newSymbolID == 56) {
                    GridBagConstraints top2 = new GridBagConstraints();
                    GridBagConstraints bot2 = new GridBagConstraints();
                    top2.gridy = 0;
                    bot2.gridy = 1;
                    JPanel limit = new JPanel(new GridBagLayout());
                    limit.setBackground(new Color(255, 255, 255));
                    limit.setName("");
                    JLabel newLabel3 = new JLabel("lim", 4);
                    newLabel3.setFont(new Font("Lucida Sans Unicode", 0, 16));
                    newLabel3.setName("");
                    char arrow = '\u2192';
                    JLabel newLabel2 = new JLabel(String.valueOf(arrow), 4);
                    newLabel2.setFont(new Font("Lucida Sans Unicode", 0, 16));
                    newLabel2.setName("");
                    limit.add((Component)newLabel3, top2);
                    JPanel bottomPanel = AddComponent.createPanel("");
                    JPanel argPanel2 = AddComponent.createPanel("");
                    JPanel argPanel3 = AddComponent.createPanel("");
                    argPanel2.add(this.createBox(false));
                    argPanel3.add(this.createBox(false));
                    bottomPanel.add(argPanel2);
                    bottomPanel.add(newLabel2);
                    bottomPanel.add(argPanel3);
                    limit.add((Component)bottomPanel, bot2);
                    left.gridheight = 2;
                    newPanel.add((Component)limit, left);
                    arg1 = right;
                }
                if (newSymbolID == 54 || newSymbolID == 55) {
                    newPanel.add((Component)this.createLimitsLayout(newComponent), left);
                    arg1 = right;
                }
            }
            if (newSymbolID == 45 || newSymbolID == 50 || newSymbolID == 53) {
                GridBagConstraints pos1 = new GridBagConstraints();
                GridBagConstraints pos2 = new GridBagConstraints();
                GridBagConstraints pos3 = new GridBagConstraints();
                GridBagConstraints pos4 = new GridBagConstraints();
                pos1.gridx = 0;
                pos2.gridx = 1;
                pos3.gridx = 2;
                pos4.gridx = 3;
                JPanel argPanel2 = AddComponent.createPanel("");
                argPanel2.add(this.createBox(false));
                JLabel bracket1 = new JLabel("(");
                JLabel bracket2 = new JLabel(")");
                if (newSymbolID == 45) {
                    JLabel newLabel4 = new JLabel(newComponent.getDisplayText(), 4);
                    newLabel4.setFont(new Font("Lucida Sans Unicode", 0, 25));
                    newLabel4.setName("");
                    newPanel.add((Component)newLabel4, pos1);
                }
                if (newSymbolID == 53) {
                    JPanel symbolPanel = new JPanel(new GridBagLayout());
                    symbolPanel.setBackground(new Color(255, 255, 255));
                    symbolPanel.setName("");
                    GridBagConstraints top = new GridBagConstraints();
                    GridBagConstraints mid3 = new GridBagConstraints();
                    GridBagConstraints bot = new GridBagConstraints();
                    top.gridy = 0;
                    mid3.gridy = 1;
                    bot.gridy = 2;
                    JPanel argPanel3 = AddComponent.createPanel("");
                    JPanel argPanel4 = AddComponent.createPanel("");
                    argPanel3.add(this.createBox(false));
                    argPanel4.add(this.createBox(false));
                    symbolPanel.add((Component)argPanel3, top);
                    JLabel newLabel5 = new JLabel(newComponent.getDisplayText(), 4);
                    newLabel5.setFont(new Font("Lucida Sans Unicode", 0, 25));
                    newLabel5.setName("");
                    symbolPanel.add((Component)newLabel5, mid3);
                    symbolPanel.add((Component)argPanel4, bot);
                    newPanel.add((Component)symbolPanel, pos1);
                }
                if (newSymbolID == 45 || newSymbolID == 53) {
                    JLabel newLabel6 = new JLabel("d", 4);
                    newLabel6.setFont(new Font("Lucida Sans Unicode", 0, 16));
                    newLabel6.setName(newComponent.getTag());
                    newPanel.add((Component)newLabel6, pos3);
                    newPanel.add((Component)argPanel2, pos4);
                    arg1 = pos2;
                }
                if (newSymbolID == 50) {
                    bracket1.setName(newComponent.getTag());
                    bracket2.setName(newComponent.getTag());
                    newPanel.add((Component)argPanel2, pos1);
                    newPanel.add((Component)bracket1, pos2);
                    newPanel.add((Component)bracket2, pos4);
                    arg1 = pos3;
                }
            }
            if (newSymbolID == 57) {
                GridBagConstraints arg = new GridBagConstraints();
                mid = new GridBagConstraints();
                GridBagConstraints subscript = new GridBagConstraints();
                arg.gridx = 0;
                subscript.gridx = 2;
                mid.gridx = 1;
                arg.gridy = 0;
                subscript.gridy = 1;
                mid.gridy = 0;
                mid.gridheight = 2;
                mid.insets = new Insets(0, 3, 0, 3);
                mid.fill = 3;
                bar = new JSeparator();
                bar.setOrientation(1);
                bar.setForeground(new Color(0, 0, 0));
                bar.setName(newComponent.getTag());
                newPanel.add((Component)bar, mid);
                JPanel argumentPanel = AddComponent.createPanel("");
                JPanel scriptPanel = AddComponent.createPanel("");
                JPanel argumentPanel1 = AddComponent.createPanel("");
                JPanel argumentPanel2 = AddComponent.createPanel("");
                argumentPanel1.add(this.createBox(false));
                argumentPanel2.add(this.createBox(false));
                newLabel = new JLabel("=", 4);
                newLabel.setFont(new Font("Lucida Sans Unicode", 0, 16));
                newLabel.setName("");
                scriptPanel.add(argumentPanel1);
                scriptPanel.add(newLabel);
                scriptPanel.add(argumentPanel2);
                newPanel.add((Component)scriptPanel, subscript);
                arg1 = arg;
            }
            if (status == 0) {
                argPanel1.add(this.createBox(false));
                newPanel.add((Component)argPanel1, arg1);
                layer.add((Component)newPanel, n);
                argPanel1.getComponent(0).requestFocusInWindow();
            }
            if (status == 1) {
                argPanel1.add(layer.getComponent(n));
                newPanel.add((Component)argPanel1, arg1);
                layer.add((Component)newPanel, n);
                argPanel1.getComponent(0).requestFocusInWindow();
            }
            if (status == 2) {
                Component[] components = layer.getComponents();
                int oldSymbolGroup = layoutPanel ? 0 : AddComponent.getGroup(components[n].getName());
                if (oldSymbolGroup == 1 || oldSymbolGroup == 2) {
                    argPanel1 = AddComponent.getOperator(layer, n);
                    newPanel.add((Component)argPanel1, arg1);
                    layer.add((Component)newPanel, n - 1);
                } else {
                    JPanel parentLayer = (JPanel)layer.getParent();
                    int j = AddComponent.getComponentPosition(parentLayer, layer);
                    argPanel1.add(layer);
                    newPanel.add((Component)argPanel1, arg1);
                    parentLayer.add((Component)newPanel, j);
                }
            }
            if (status == 3) {
                argPanel1 = selection;
                newPanel.add((Component)argPanel1, arg1);
                layer.add((Component)newPanel, n);
            }
            if (newSymbolID == 5 || newSymbolID == 6) {
                argPanel1.addComponentListener(new ComListener(argPanel1, 1, 0, 0));
            }
            if (newSymbolID == 45) {
                // empty if block
            }
            if (newSymbolID == 53) {
                // empty if block
            }
            if (newSymbolID == 50) {
                argPanel1.addComponentListener(new ComListener(argPanel1, 0, 1, 2));
            }
        }
        layer.revalidate();
    }

    public JPanel createLimitsLayout(InputComponent newComponent) {
        JPanel symbolPanel = new JPanel(new GridBagLayout());
        symbolPanel.setBackground(new Color(255, 255, 255));
        symbolPanel.setName("");
        GridBagConstraints top = new GridBagConstraints();
        GridBagConstraints mid = new GridBagConstraints();
        GridBagConstraints bot = new GridBagConstraints();
        top.gridy = 0;
        mid.gridy = 1;
        bot.gridy = 2;
        JPanel argPanel2 = AddComponent.createPanel("");
        JPanel argPanel3 = AddComponent.createPanel("");
        JPanel argPanel4 = AddComponent.createPanel("");
        JPanel bottomPanel = AddComponent.createPanel("");
        argPanel2.add(this.createBox(false));
        argPanel3.add(this.createBox(false));
        argPanel4.add(this.createBox(false));
        symbolPanel.add((Component)argPanel2, top);
        bottomPanel.add(argPanel3);
        JLabel equalSign = new JLabel("=", 4);
        equalSign.setFont(new Font("Lucida Sans Unicode", 0, 16));
        equalSign.setName("");
        bottomPanel.add(equalSign);
        bottomPanel.add(argPanel4);
        JLabel newLabel = new JLabel(newComponent.getDisplayText(), 4);
        newLabel.setFont(new Font("Lucida Sans Unicode", 0, 25));
        newLabel.setName("");
        symbolPanel.add((Component)newLabel, mid);
        symbolPanel.add((Component)bottomPanel, bot);
        return symbolPanel;
    }

    public void pasteTree(JPanel layer, int n, MathObject start, int status) {
        if (start != null) {
            JPanel tempArgument;
            JTextField temp;
            if (start.getClass().getName().equals("Tree.Text")) {
                Text textObj = (Text)start;
                layer.add((Component)this.createBox(false), n);
                temp = (JTextField)layer.getComponent(n);
                temp.setText(textObj.getText());
                if (temp.getText().length() > 0) {
                    temp.setBorder(new EmptyBorder(temp.getInsets()));
                }
            }
            if (start.getClass().getName().equals("Tree.Variable")) {
                Variable variableObj = (Variable)start;
                layer.add((Component)this.createBox(false), n);
                temp = (JTextField)layer.getComponent(n);
                temp.setText(String.valueOf(variableObj.getVarName()));
                if (temp.getText().length() > 0) {
                    temp.setBorder(new EmptyBorder(temp.getInsets()));
                }
            }
            if (start.getClass().getName().equals("Tree.RealNumber")) {
                RealNumber numberObj = (RealNumber)start;
                layer.add((Component)this.createBox(false), n);
                temp = (JTextField)layer.getComponent(n);
                temp.setText(String.valueOf(numberObj.getNumber()));
                if (temp.getText().length() > 0) {
                    temp.setBorder(new EmptyBorder(temp.getInsets()));
                }
            }
            if (start.getClass().getName().equals("Tree.BinaryOperator")) {
                BinaryOperator binaryObj = (BinaryOperator)start;
                boolean brackets = false;
                if (binaryObj.getParent() != null && binaryObj.getParent().getID() != 1 && Precedence.value[binaryObj.getID()] < Precedence.value[binaryObj.getParent().getID()]) {
                    brackets = true;
                }
                if (brackets) {
                    Grouping newBrackets = new Grouping(31, "BracketsRnd");
                    newBrackets.setChild(binaryObj);
                    binaryObj.setParent(newBrackets);
                    this.pasteTree(layer, 0, newBrackets, 0);
                } else {
                    tempArgument = null;
                    int first = -1;
                    int second = -1;
                    if (binaryObj.getID() == 1) {
                        first = 2;
                        second = 1;
                    }
                    if (binaryObj.getID() == 50) {
                        first = 0;
                        second = 3;
                    }
                    if (binaryObj.getID() == 7 || binaryObj.getID() == 8) {
                        first = 0;
                        second = 1;
                    }
                    if (binaryObj.getID() == 6) {
                        first = 3;
                        second = 2;
                    }
                    if (first != -1) {
                        this.addLayout(layer, n, inputComponents[binaryObj.getID()], status, false, 0, 0, null);
                        JPanel tempLayer = (JPanel)layer.getComponent(n);
                        tempArgument = (JPanel)tempLayer.getComponent(first);
                        tempArgument.remove(0);
                        this.pasteTree(tempArgument, 0, binaryObj.getLeftChild(), 0);
                        tempArgument = (JPanel)tempLayer.getComponent(second);
                        tempArgument.remove(0);
                        this.pasteTree(tempArgument, 0, binaryObj.getRightChild(), 0);
                    } else {
                        this.addOperator(layer, n, inputComponents[binaryObj.getID()], status, false, null);
                        JComponent temp2 = (JComponent)layer.getComponent(n + 2);
                        layer.remove(n);
                        this.pasteTree(layer, n, binaryObj.getLeftChild(), 0);
                        int i = AddComponent.getComponentPosition(layer, temp2);
                        layer.remove(i);
                        this.pasteTree(layer, i, binaryObj.getRightChild(), 0);
                    }
                }
            }
            if (start.getClass().getName().equals("Tree.NaryFunction")) {
                NaryFunction naryFunctionObj = (NaryFunction)start;
                if (naryFunctionObj.getID() == 54 || naryFunctionObj.getID() == 55) {
                    this.addLayout(layer, n, inputComponents[naryFunctionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(1);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(0), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(0);
                    tempArgument = (JPanel)tempArgument.getComponent(2);
                    tempArgument = (JPanel)tempArgument.getComponent(0);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(1), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(0);
                    tempArgument = (JPanel)tempArgument.getComponent(2);
                    tempArgument = (JPanel)tempArgument.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(2), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(0);
                    tempArgument = (JPanel)tempArgument.getComponent(0);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(3), 0);
                }
                if (naryFunctionObj.getID() == 53) {
                    this.addLayout(layer, n, inputComponents[naryFunctionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(3);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(0), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(1), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(0);
                    tempArgument = (JPanel)tempArgument.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(2), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(0);
                    tempArgument = (JPanel)tempArgument.getComponent(0);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(3), 0);
                }
                if (naryFunctionObj.getID() == 56) {
                    this.addLayout(layer, n, inputComponents[naryFunctionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(1);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(0), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(0);
                    tempArgument = (JPanel)tempArgument.getComponent(1);
                    tempArgument = (JPanel)tempArgument.getComponent(0);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(1), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(0);
                    tempArgument = (JPanel)tempArgument.getComponent(1);
                    tempArgument = (JPanel)tempArgument.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(2), 0);
                }
                if (naryFunctionObj.getID() == 57) {
                    this.addLayout(layer, n, inputComponents[naryFunctionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(0), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(1);
                    tempArgument = (JPanel)tempArgument.getComponent(0);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(1), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(1);
                    tempArgument = (JPanel)tempArgument.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(2), 0);
                }
                if (naryFunctionObj.getID() == 45) {
                    this.addLayout(layer, n, inputComponents[naryFunctionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(3);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(0), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(1), 0);
                }
                if (naryFunctionObj.getID() == 46 || naryFunctionObj.getID() == 84) {
                    this.addLayout(layer, n, inputComponents[naryFunctionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(1);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(0), 0);
                    tempArgument = (JPanel)tempLayer.getComponent(0);
                    tempArgument = (JPanel)tempArgument.getComponent(2);
                    tempArgument = (JPanel)tempArgument.getComponent(1);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, naryFunctionObj.getChild(1), 0);
                }
            }
            if (start.getClass().getName().equals("Tree.Function")) {
                Function functionObj = (Function)start;
                if (functionObj.getID() == 5) {
                    this.addLayout(layer, n, inputComponents[functionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, functionObj.getChild(), 0);
                } else if (functionObj.getID() == 29) {
                    this.addLayout(layer, n, inputComponents[functionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(1);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, functionObj.getChild(), 0);
                } else if (functionObj.getID() == 37) {
                    this.addLayout(layer, n, inputComponents[functionObj.getID()], status, false, 0, 0, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(1);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, functionObj.getChild(), 0);
                } else {
                    this.addFunction(layer, n, inputComponents[functionObj.getID()], status, false, null);
                    JPanel tempLayer = (JPanel)layer.getComponent(n);
                    tempArgument = (JPanel)tempLayer.getComponent(2);
                    tempArgument.remove(0);
                    this.pasteTree(tempArgument, 0, functionObj.getChild(), 0);
                }
            }
            if (start.getClass().getName().equals("Tree.Matrix")) {
                Matrix matrixObj = (Matrix)start;
                int matrix_m = matrixObj.getM();
                int matrix_n = matrixObj.getN();
                this.addLayout(layer, n, inputComponents[matrixObj.getID()], status, false, matrix_m, matrix_n, null);
                JPanel tempLayer = (JPanel)layer.getComponent(n);
                JPanel argumentLayer = (JPanel)tempLayer.getComponent(1);
                Component[] components = argumentLayer.getComponents();
                MathObject[][] array = matrixObj.getArray();
                int x = 0;
                for (int y = 0; y < matrix_m; ++y) {
                    while (x < matrix_n) {
                        int i = x + y * matrix_n;
                        JPanel temp3 = (JPanel)components[i];
                        temp3.remove(0);
                        this.pasteTree(temp3, 0, matrixObj.getElement(y, x), 0);
                        ++x;
                    }
                    x = 0;
                }
            }
            if (start.getClass().getName().equals("Tree.Grouping")) {
                Grouping groupingObj = (Grouping)start;
                this.addGrouping(layer, n, inputComponents[groupingObj.getID()], status, false, null);
                JPanel tempLayer = (JPanel)layer.getComponent(n);
                JPanel tempArgument2 = (JPanel)tempLayer.getComponent(1);
                tempArgument2.remove(0);
                this.pasteTree(tempArgument2, 0, groupingObj.getChild(), 0);
            }
            if (start.getClass().getName().equals("Tree.NaryOperator")) {
                NaryOperator naryObj = (NaryOperator)start;
                boolean brackets = false;
                if (naryObj.getParent() != null && naryObj.getParent().getID() != 1 && Precedence.value[naryObj.getID()] < Precedence.value[naryObj.getParent().getID()]) {
                    brackets = true;
                }
                if (brackets) {
                    Grouping newBrackets = new Grouping(31, "BracketsRnd");
                    newBrackets.setChild(naryObj);
                    naryObj.setParent(newBrackets);
                    this.pasteTree(layer, n, newBrackets, 0);
                } else {
                    int i;
                    this.addOperator(layer, n, inputComponents[naryObj.getID()], status, false, null);
                    int j = n;
                    for (i = naryObj.getSize() - 2; i > 0; --i) {
                        this.addOperator(layer, j += 2, inputComponents[naryObj.getID()], 1, false, null);
                    }
                    JComponent temp4 = null;
                    for (i = naryObj.getSize(); i > 1; --i) {
                        temp4 = (JComponent)layer.getComponent(n + 2);
                        layer.remove(n);
                        this.pasteTree(layer, n, naryObj.getChild(i - 1), 0);
                        n = AddComponent.getComponentPosition(layer, temp4);
                    }
                    layer.remove(n);
                    this.pasteTree(layer, n, naryObj.getChild(i - 1), 0);
                }
            }
        }
        layer.repaint();
        layer.revalidate();
    }

    public void delete(JPanel layer) {
        this.saveState(true);
        this.remove(layer);
    }

    public void remove(JPanel layer) {
        boolean last = false;
        for (int i = 0; i < layer.getComponentCount(); ++i) {
            if (layer.getComponent(i).getBackground().equals(MseSelectListener.SELECT)) {
                JComponent temp;
                if (i == layer.getComponentCount() - 1) {
                    if (i > 0 && layer.getComponent(i - 1).getBackground() != MseSelectListener.SELECT && layer.getComponent(i - 1).getClass().getName().equals("javax.swing.JLabel")) {
                        last = true;
                    }
                } else if (layer.getComponent(i + 1).getBackground() != MseSelectListener.SELECT) {
                    if (i == 0) {
                        if (layer.getComponent(i + 1).getClass().getName().equals("javax.swing.JLabel")) {
                            last = true;
                        }
                    } else {
                        if ((layer.getComponent(i - 1).getClass().getName().equals("javax.swing.JPanel") || layer.getComponent(i - 1).getClass().getName().equals("Display.TextBox")) && (layer.getComponent(i + 1).getClass().getName().equals("javax.swing.JPanel") || layer.getComponent(i + 1).getClass().getName().equals("Display.TextBox"))) {
                            last = true;
                        }
                        if (layer.getComponent(i - 1).getClass().getName().equals("javax.swing.JLabel") && layer.getComponent(i + 1).getClass().getName().equals("javax.swing.JLabel")) {
                            last = true;
                        }
                    }
                }
                if (layer.getComponent(i).getClass().getName().equals("javax.swing.JPanel")) {
                    if (layer.getComponent(i).getName().equals("")) {
                        temp = (JPanel)layer.getComponent(i);
                        temp.removeAll();
                        temp.add(this.createBox(false));
                        continue;
                    }
                    if (last) {
                        last = false;
                        layer.remove(i);
                        layer.add((Component)this.createBox(false), i);
                        i = -1;
                        continue;
                    }
                    layer.remove(i);
                    if (layer.getComponentCount() == 0 && layer != this.jPanelWorkspace) {
                        layer.add(this.createBox(false));
                    }
                    i = -1;
                    continue;
                }
                if (layer.getComponent(i).getClass().getName().equals("javax.swing.JLabel")) {
                    if (!last) {
                        layer.remove(i);
                        i = -1;
                    }
                    if (!last) continue;
                    last = false;
                    temp = (JLabel)layer.getComponent(i);
                    temp.setOpaque(false);
                    temp.setBackground(MseSelectListener.DESELECT);
                    continue;
                }
                layer.remove(i);
                if (last) {
                    layer.add((Component)this.createBox(false), i);
                    last = false;
                }
                i = -1;
                continue;
            }
            if (!layer.getComponent(i).getClass().getName().equals("javax.swing.JPanel")) continue;
            this.remove((JPanel)layer.getComponent(i));
        }
        layer.repaint();
        layer.revalidate();
    }

    public void cut(JPanel layer, BuildTree buildTree) throws ParseException {
        this.selectionComponentFound = false;
        this.getSelection(layer);
        this.copyTree = null;
        if (this.selectionComponentFound) {
            this.copyTree = buildTree.generateTree(this.selectionLayer, true, this.firstLocation, this.lastLocation);
            this.statusBar.println("Cut");
            this.delete(layer);
        } else {
            this.statusBar.println(this.langMan.readLangFile("NoCut"));
        }
    }

    public void getSelection(JPanel layer) {
        Component[] components = layer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Color colour = new Color(Color.LIGHT_GRAY.getRGB());
            if (components[i].getBackground().equals(colour)) {
                if (!this.selectionComponentFound) {
                    this.firstLocation = i;
                    this.selectionLayer = (JPanel)components[i].getParent();
                    this.selectionComponentFound = true;
                }
                this.lastLocation = i;
                continue;
            }
            if (!components[i].getClass().getName().equals("javax.swing.JPanel")) continue;
            this.getSelection((JPanel)components[i]);
        }
    }

    public void paste() {
        JComponent focusComp = (JComponent)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusComp.getClass().getName().equals("Display.TextBox")) {
            if (this.copyTree != null) {
                this.saveState(true);
                JPanel parent = (JPanel)focusComp.getParent();
                int i = AddComponent.getComponentPosition(parent, focusComp);
                parent.remove(focusComp);
                this.pasteTree(parent, i, this.copyTree, 0);
            } else {
                this.statusBar.println(this.langMan.readLangFile("NoPaste"));
            }
        } else {
            this.statusBar.println(this.langMan.readLangFile("NoBox"));
        }
    }

    public void copy(JPanel layer, BuildTree buildTree) throws ParseException {
        this.selectionComponentFound = false;
        this.copyTree = null;
        this.getSelection(layer);
        if (this.selectionComponentFound) {
            this.copyTree = buildTree.generateTree(this.selectionLayer, true, this.firstLocation, this.lastLocation);
            this.statusBar.println(this.langMan.readLangFile("Copied"));
            MseSelectListener.deSelect(this.jPanelWorkspace);
        } else {
            this.statusBar.println(this.langMan.readLangFile("NoCopy"));
        }
    }

    public MathObject checkSelection(JPanel layer, BuildTree buildTree, InputComponent newComponent) throws ParseException {
        this.selectionComponentFound = false;
        MathObject tree = null;
        this.getSelection(layer);
        if (this.selectionComponentFound) {
            try {
                tree = buildTree.generateTree(this.selectionLayer, true, this.firstLocation, this.lastLocation);
            }
            catch (ParseException err) {
                int i = newComponent.getGroup();
                if (i == 1 || i == 2) {
                    this.selectionLayer.remove(this.firstLocation);
                    this.selectionLayer.add((Component)this.createSymbol(newComponent), this.firstLocation);
                    this.selectionLayer.revalidate();
                    throw new ParseException("Replaced operator", 0);
                }
                throw new ParseException(err.getMessage(), err.getErrorOffset());
            }
        }
        return tree;
    }

    public void saveState(MathObject tree) {
        this.savedStates[this.savedLocation] = tree;
        if (this.savedLocation == 4) {
            this.deleteSavedState();
        } else {
            ++this.savedLocation;
        }
        for (int i = this.savedLocation; i < 5; ++i) {
            this.savedStates[i] = null;
        }
    }

    public void saveState(boolean clearRedo) {
        try {
            this.savedStates[this.savedLocation] = this.buildTree.generateTree(this.jPanelWorkspace, false, 0, 0);
            if (this.savedLocation == 4) {
                this.deleteSavedState();
            } else {
                ++this.savedLocation;
            }
            if (clearRedo) {
                for (int i = this.savedLocation; i < 5; ++i) {
                    this.savedStates[i] = null;
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void deleteSavedState() {
        for (int i = 0; i < 4; ++i) {
            this.savedStates[i] = this.savedStates[i + 1];
        }
        this.savedStates[4] = null;
    }

    public void undoState() {
        if (this.savedLocation > 0) {
            this.saveState(false);
            --this.savedLocation;
            this.jPanelWorkspace.removeAll();
            this.jPanelWorkspace.repaint();
            --this.savedLocation;
            this.pasteTree(this.jPanelWorkspace, 0, this.savedStates[this.savedLocation], 0);
        }
    }

    public void redoState() {
        if (this.savedLocation < 4 && this.savedStates[this.savedLocation + 1] != null) {
            this.jPanelWorkspace.removeAll();
            this.jPanelWorkspace.repaint();
            ++this.savedLocation;
            this.pasteTree(this.jPanelWorkspace, 0, this.savedStates[this.savedLocation], 0);
        }
    }

    public void resetUndoRedo() {
        this.savedLocation = 0;
        for (int i = 0; i < 5; ++i) {
            this.savedStates[i] = null;
        }
    }
}

