# The LearningOnline Network with CAPA
# programatic image drawing
#
# $Id: drawimage.pm,v 1.10 2008/03/12 02:46:52 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::drawimage;
use strict;
use Apache::loncommon;
use lib '/home/httpd/lib/perl/';
use LONCAPA;
 

my %args;
my $cgi_id;
my @cgi_ids;
BEGIN {
    &Apache::lonxml::register('Apache::drawimage',('drawimage'));
}

sub start_drawimage {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    &Apache::lonxml::register('Apache::drawimage',('text','line','rectangle','arc','fill','polygon','image'));
    if ($target eq 'web' || $target eq 'tex') {
	my $new_id=&Apache::loncommon::get_cgi_id();
	if ($cgi_id) { push(@cgi_ids,$cgi_id); } else { undef(%args); }
	$cgi_id=$new_id;
    }
    return '';
}

sub end_drawimage {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
	my $width = &Apache::lonxml::get_param('width',$parstack,$safeeval);
	my $height =&Apache::lonxml::get_param('height',$parstack,$safeeval);
	my $bgcolor =&Apache::lonxml::get_param('bgcolor',$parstack,$safeeval);
	if (!$width) { $width=300; }
	if (!$height) { $height=300; }
	$result.="<img width='$width' height='$height'
                           src='/adm/randomlabel.png?token=$cgi_id' />\n";
	$args{"cgi.$cgi_id.SIZE"}=join(':',($width,$height));
	$args{"cgi.$cgi_id.BGCOLOR"}=join(':',($bgcolor));
	&Apache::lonnet::appenv(\%args);
	if (@cgi_ids) {
	    $cgi_id=pop(@cgi_ids);
	} else {
	    undef($cgi_id);
	}
    } elsif ($target eq 'edit') {
    } elsif ($target eq 'modified') {
    }
    
    &Apache::lonxml::register('Apache::drawimage',
			      ('text','line','rectangle','arc','fill',
			       'polygon'));
    return $result;
}

sub start_text {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
	&Apache::lonxml::startredirection();
    }
    return $result;
}

sub end_text {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
        my $x     = &Apache::lonxml::get_param('x',$parstack,$safeeval);
        my $y     = &Apache::lonxml::get_param('y',$parstack,$safeeval);
        my $font  = &Apache::lonxml::get_param('font',$parstack,$safeeval);
        my $color = &Apache::lonxml::get_param('color',$parstack,$safeeval);
        my $direction = &Apache::lonxml::get_param('direction',$parstack,$safeeval);
	my $text  = &Apache::lonxml::endredirection();
        $text = &escape($text);
        $args{"cgi.$cgi_id.OBJTYPE"}.='LABEL:';
	my $i=$args{"cgi.$cgi_id.OBJCOUNT"}++;
	$args{"cgi.$cgi_id.OBJ$i"}=join(':',($x,$y,$text,$font,$color,$direction));
    }
    return $result;
}

sub start_line {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
	my $x1 = &Apache::lonxml::get_param('x1',$parstack,$safeeval);
	my $y1 = &Apache::lonxml::get_param('y1',$parstack,$safeeval);
	my $x2 = &Apache::lonxml::get_param('x2',$parstack,$safeeval);
	my $y2 = &Apache::lonxml::get_param('y2',$parstack,$safeeval);
	my $color = &Apache::lonxml::get_param('color',$parstack,$safeeval);
	my $thickness = &Apache::lonxml::get_param('thickness',$parstack,$safeeval);
	my $i=$args{"cgi.$cgi_id.OBJCOUNT"}++;
	$args{"cgi.$cgi_id.OBJ$i"}=join(':',($x1,$y1,$x2,$y2,$color,$thickness));
	$args{"cgi.$cgi_id.OBJTYPE"}.='LINE:';
    }
    return $result;
}

sub end_line {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    return $result;
}

sub start_rectangle {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
	my $x1 = &Apache::lonxml::get_param('x1',$parstack,$safeeval);
	my $y1 = &Apache::lonxml::get_param('y1',$parstack,$safeeval);
	my $x2 = &Apache::lonxml::get_param('x2',$parstack,$safeeval);
	my $y2 = &Apache::lonxml::get_param('y2',$parstack,$safeeval);
	my $color = &Apache::lonxml::get_param('color',$parstack,$safeeval);
	my $thickness = &Apache::lonxml::get_param('thickness',$parstack,
						   $safeeval);
	my $filled = &Apache::lonxml::get_param('filled',$parstack,
						$safeeval);
	my $i=$args{"cgi.$cgi_id.OBJCOUNT"}++;
	$args{"cgi.$cgi_id.OBJ$i"}=
	    join(':',($x1,$y1,$x2,$y2,$color,$thickness,$filled));
	$args{"cgi.$cgi_id.OBJTYPE"}.='RECTANGLE:';
    }
    return $result;
}

sub end_rectangle {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    return $result;
}

sub start_arc {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
	my $x = &Apache::lonxml::get_param('x',$parstack,$safeeval);
	my $y = &Apache::lonxml::get_param('y',$parstack,$safeeval);
	my $width = &Apache::lonxml::get_param('width',$parstack,$safeeval);
	my $height = &Apache::lonxml::get_param('height',$parstack,$safeeval);
	my $start = &Apache::lonxml::get_param('start',$parstack,$safeeval);
	my $end = &Apache::lonxml::get_param('end',$parstack,$safeeval);
	my $color = &Apache::lonxml::get_param('color',$parstack,$safeeval);
	my $thickness = &Apache::lonxml::get_param('thickness',$parstack,$safeeval);
	my $filled = &Apache::lonxml::get_param('filled',$parstack,$safeeval);
	my $i=$args{"cgi.$cgi_id.OBJCOUNT"}++;
	$args{"cgi.$cgi_id.OBJ$i"}=
	    join(':',($x,$y,$width,$height,$start,$end,$color,$thickness,
		      $filled));
	$args{"cgi.$cgi_id.OBJTYPE"}.='ARC:';
    }
    return $result;
}

sub end_arc {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    return $result;
}

sub start_fill {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
	my $x = &Apache::lonxml::get_param('x',$parstack,$safeeval);
	my $y = &Apache::lonxml::get_param('y',$parstack,$safeeval);
	my $color = &Apache::lonxml::get_param('color',$parstack,$safeeval);
	my $i=$args{"cgi.$cgi_id.OBJCOUNT"}++;
	$args{"cgi.$cgi_id.OBJ$i"}=join(':',($x,$y,$color));
	$args{"cgi.$cgi_id.OBJTYPE"}.='FILL:';
    }
    return $result;
}

sub end_fill {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    return $result;
}

my @polygon;
sub start_polygon {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    &Apache::lonxml::register('Apache::drawimage',('point'));
    if ($target eq 'web') {
	undef(@polygon);
    }
    return $result;
}

sub end_polygon {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;    
    if ($target eq 'web') {
	my $color=&Apache::lonxml::get_param('color',$parstack,$safeeval);
	my $filled=&Apache::lonxml::get_param('filled',$parstack,$safeeval);
	my $open=&Apache::lonxml::get_param('open',$parstack,$safeeval);
	my $thickness = &Apache::lonxml::get_param('thickness',$parstack,
						   $safeeval);
	my $i=$args{"cgi.$cgi_id.OBJCOUNT"}++;
	$args{"cgi.$cgi_id.OBJTYPE"}.='POLYGON:';
	$args{"cgi.$cgi_id.OBJ$i"}=join(':',($color,$thickness,$open,$filled));
	$args{"cgi.$cgi_id.OBJEXTRA$i"}=join('-',@polygon);
    }
    &Apache::lonxml::deregister('Apache::drawimage',('point'));
    return $result;
}

sub start_point {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web') {
	my $x = &Apache::lonxml::get_param('x',$parstack,$safeeval);
        my $y = &Apache::lonxml::get_param('y',$parstack,$safeeval);
	push (@polygon,"($x,$y)");
    }
    return $result;
}

sub end_point {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    return $result;
}

sub start_image {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
	&Apache::lonxml::startredirection();
    }
    return $result;
}

sub end_image {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'web' || $target eq 'tex') {
	my $bgimg=&Apache::lonxml::endredirection();
	my $x = &Apache::lonxml::get_param('x',$parstack,$safeeval);
        my $y = &Apache::lonxml::get_param('y',$parstack,$safeeval);
	my $clipx = &Apache::lonxml::get_param('clipx',$parstack,$safeeval);
        my $clipy = &Apache::lonxml::get_param('clipy',$parstack,$safeeval);
	my $clipwidth = 
	    &Apache::lonxml::get_param('clipwidth',$parstack,$safeeval);
        my $clipheight = 
	    &Apache::lonxml::get_param('clipheight',$parstack,$safeeval);
	my $scaledwidth = 
	    &Apache::lonxml::get_param('scaledwidth',$parstack,$safeeval);
        my $scaledheight = 
	    &Apache::lonxml::get_param('scaledheight',$parstack,$safeeval);
	my $transparent = 
	    &Apache::lonxml::get_param('transparent',$parstack,$safeeval);
	$bgimg=&Apache::imageresponse::clean_up_image($bgimg);
	my $i=$args{"cgi.$cgi_id.OBJCOUNT"}++;
	$args{"cgi.$cgi_id.OBJTYPE"}.='IMAGE:';
	$args{"cgi.$cgi_id.OBJ$i"} = 
	    join(':',($x,$y,&escape($bgimg),$transparent,
		      $clipx,$clipy,$scaledwidth,$scaledheight,$clipwidth,$clipheight));
    }
    return $result;
}
1;
__END__
