# The LearningOnline Network with CAPA
# Display authors in domain for selection of ad loc co-author role by Domain Coordinator. 
#
# $Id: lonpickauthor.pm,v 1.1 2008/05/19 17:13:06 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#
###############################################################
###############################################################

package Apache::lonpickauthor;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lonlocal;
use Apache::lonroles;
use Apache::lonuserutils;
use LONCAPA;

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

# ------------------------------------------------------------ Print the screen
    $r->print(&Apache::loncommon::start_page("Selecting an Author",undef,
                                             {'no_nav_bar' => 1}));


    &Apache::loncommon::get_unprocessed_cgi
        ($ENV{'QUERY_STRING'},['form','roledom','sortby']);
    my $then=$env{'user.login.time'};
    my (%dcroles,%dom_roles,$earlyout,$domdesc);
    my $numdc = &Apache::lonroles::check_fordc(\%dcroles,$then);
    if ($env{'form.roledom'} ne '') {
        $domdesc = &Apache::lonnet::domain($env{'form.roledom'});
        if ($domdesc eq '') {
            $earlyout = $earlyout = &mt('Invalid domain'); 
        } elsif ($numdc) {
            if ($dcroles{$env{'form.roledom'}}) {
                %dom_roles = &Apache::lonnet::get_domain_roles($env{'form.roledom'},['au']);
                if (keys(%dom_roles) == 0) {
                    $earlyout = &mt('There are no library servers containing Construction spaces currently in domain: [_1], so you can not assume a co-author role.',$domdesc); 
                }
            } else {
                $earlyout = &mt('You do not have a domain coordinator role in domain: [_1], so cannot choose a Construction space for which you can assume a co-author role.',$domdesc);
            }
        } else {
            $earlyout = &mt('You do not have a domain coordinator role, so cannot choose a Construction space for which you can assume a co-author role.');
        }
    } else {
        $earlyout = &mt('Invalid domain'); 
    }
    if ($earlyout) {
        $r->print('<span class="LC_error">'.$earlyout.'</span>');
        $r->print(&Apache::loncommon::end_page());
        return OK;
    }
    $r->print(<<ENDSCRIPT);
<script type="text/javascript">
function username_display_launch(username,domain) {
    document.location.href = '/adm/'+domain+'/'+username+'/aboutme';
    return;
}

function gochoose(uname) {
    var coauthorTarget = "ca./$env{'form.roledom'}/"+uname;
    opener.document.title='Role selected. Please stand by.';
    opener.status='Role selected. Please stand by.';
    opener.document.$env{'form.form'}.newrole.value=coauthorTarget
    opener.document.$env{'form.form'}.submit();
    self.close();
}
</script>
ENDSCRIPT
    my $formname = 'pickauthor';
    my $caller = 'pickauthor';
    my $context = 'domain';
    my $format = 'html';
    my (%userlist,%userinfo);
    my ($indexhash,$keylist) = &Apache::lonuserutils::make_keylist_array();
    my ($permission,$allowed) = &Apache::lonuserutils::get_permission($context);
    $env{'form.roletype'} = 'domain';
    $env{'form.showrole'} = 'au';
    foreach my $key (keys(%dom_roles)) {
        if (ref($dom_roles{$key}) eq 'HASH') {
            &Apache::lonuserutils::gather_userinfo($context,$format,\%userlist,$indexhash,
                                                  \%userinfo,$dom_roles{$key},$permission);
        }
    }
    if (keys(%userlist) > 0) {
        $r->print('<form name="'.$formname.'" action="/adm/pickauthor">');
        &Apache::lonuserutils::show_users_list($r,$context,$caller,$permission,
                                               'Any',\%userlist,$keylist,$formname);
        $r->print('<input type="hidden" name="roledom" value="'.$env{'form.roledom'}.'" />'."\n".
                  '<input type="hidden" name="form" value="'.$env{'form.form'}.'" /></form>');
    } else {
       $r->print(&mt('There are no author roles currently in domain: [_1], so there are no Construction spaces for which you can assume a co-author role.',$domdesc));
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

1;
