# The LearningOnline Network
# Uploaded File Replication Manager
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonuploadrep;

use strict;
use Apache::Constants qw(:common :http);
use Apache::lonrep();
use Apache::lonnet;
use LONCAPA();

sub handler {
    my $r = shift;
    if ($r->uri =~m{^/*uploaded/($LONCAPA::domain_re)/($LONCAPA::name_re)/(.+)$}) {
        my $chome=&Apache::lonnet::homeserver($2,$1);
	my @ids=&Apache::lonnet::current_machine_ids();
	foreach my $id (@ids) { if ($id eq $chome) { return OK; } }
        my $filename =  $Apache::lonnet::perlvar{'lonDocRoot'}.'/userfiles/'.$1.'/'.$2.'/'.$3;
        my ($info, $rtncode);
        if (-f $filename) {
            &Apache::lonnet::getuploaded('HEAD',$r->uri,$1,$2,\$info,\$rtncode);
            if ($rtncode eq '404') {
                unlink($filename);
            } elsif ( ($info > 0) && ($info =~ /\d+/) )  {
                my @statinfo = stat($filename); 
                if ($statinfo[9] >= $info ) {
                    &Apache::lonrep::update_filename($r,$filename);
                    return OK;
                }
            }
        }
        my $response=&Apache::lonnet::repcopy_userfile($r->uri);
        if ($response eq 'ok') {
	    &Apache::lonrep::update_filename($r,$filename);
            return OK;
        }
    }
    my $handle = &Apache::lonnet::check_for_valid_session($r);
    if ($handle) {
        $r->log_reason('Copying failed in lonuploadrep for '.$handle);
        return HTTP_NOT_FOUND;
    } else {
        $r->log_reason('Copying failed in lonuploadrep for unknown user'); 
        return FORBIDDEN;
    }
}

1;
__END__
