
# The LearningOnline Network with CAPA
# Handler to upload files into construction space
#
# $Id: lonupload.pm,v 1.37 2008/06/17 02:20:08 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::lonupload;

use strict;
use Apache::File;
use File::Copy;
use File::Basename;
use Apache::Constants qw(:common :http :methods);
use Apache::loncacc;
use Apache::loncommon();
use Apache::lonnet;
use HTML::Entities();
use Apache::lonlocal;
use Apache::lonnet;
use LONCAPA();

my $DEBUG=0;

sub Debug {
    # Put out the indicated message but only if DEBUG is true.
    if ($DEBUG) {
	my ($r,$message) = @_;
	$r->log_reason($message);
    }
}

sub upfile_store {
    my $r=shift;
	
    my $fname=$env{'form.upfile.filename'};
    $fname=~s/\W//g;
    
    chomp($env{'form.upfile'});
  
    my $datatoken=$env{'user.name'}.'_'.$env{'user.domain'}.
		  '_upload_'.$fname.'_'.time.'_'.$$;
    {
       my $fh=Apache::File->new('>'.$r->dir_config('lonDaemons').
                                   '/tmp/'.$datatoken.'.tmp');
       print $fh $env{'form.upfile'};
    }
    return $datatoken;
}

sub phaseone {
    my ($r,$fn,$uname,$udom,$mode)=@_;
    my $action = '/adm/upload';
    if ($mode eq 'testbank') {
        $action = '/adm/testbank';
    } elsif ($mode eq 'imsimport') {
        $action = '/adm/imsimport';
    }
    $env{'form.upfile.filename'}=~s/\\/\//g;
    $env{'form.upfile.filename'}=~s/^.*\/([^\/]+)$/$1/;
    if ($env{'form.upfile.filename'}) {
	$fn=~s/\/[^\/]+$//;
	$fn=~s/([^\/])$/$1\//;
	$fn.=$env{'form.upfile.filename'};
	$fn=~s/^\///;
	$fn=~s/(\/)+/\//g;

#    Fn is the full path to the destination filename.
#    

	&Debug($r, "Filename for upload: $fn");
	if (($fn) && ($fn!~/\/$/)) {
	    $r->print('<form action="'.$action.'" method="post" name="fileupload">'.
		      '<input type="hidden" name="phase" value="two" />'.
		      '<input type="hidden" name="datatoken" value="'.
		      &upfile_store.'" />'.
		      '<input type="hidden" name="uploaduname" value="'.$uname.
		      '" />'.&mt('Save uploaded file as ').
                      "<span class='LC_filename'>/priv/$uname/</span>".
                      '<input type="text" size="50" name="filename" value="'.$fn.
                      '" /><br />'.
		      '<br />'.&mt('Choose file type:').'
<select name="filetype">
 <option value="standard" selected>'.&mt('Regular file').'
 <option value="testbank">'.&mt('Testbank file').'
 <option value="imsimport">'.&mt('IMS package').'
</select>'.&Apache::loncommon::help_open_topic("Uploading_File_Options").'
<br />
<br />
');
            $r->print('<input type="button" value="'.&mt('Save').'" onClick="javascript:verifyForm()"/></form>');
	    # Check for bad extension and warn user
	    if ($fn=~/\.(\w+)$/ && 
		(&Apache::loncommon::fileembstyle($1) eq 'hdn')) {
		$r->print('<span class="LC_error">'.&mt('The extension on this file,').
			  ' "'.$1.'"'.&mt(', is reserved internally by LON-CAPA.').
			  ' <br />'.&mt('Please change the extension.').'</span>');
	    } elsif($fn=~/\.(\w+)$/ && 
		    !defined(&Apache::loncommon::fileembstyle($1))) {
		$r->print('<span class="LC_error">'.&mt('The extension on this file,').
			  ' "'.$1.'"'.&mt(', is not recognized by LON-CAPA.').
			  ' <br />'.&mt('Please change the extension.').
			  '</span>');
	    }
	} else {
	    $r->print('<span class="LC_error">'.&mt('Illegal filename.').'</span>');
	}
    } else {
	$r->print('<span class="LC_error">'.&mt('No upload file specified.').'</span>');
    }
}

sub phasetwo {
    my ($r,$tfn,$uname,$udom,$mode)=@_;
    my $output;
    my $action = '/adm/upload';
    my $returnflag = '';
    if ($mode eq 'testbank') {
        $action = '/adm/testbank';
    } elsif ($mode eq 'imsimport') {
        $action = '/adm/imsimport';
    }
    my $fn='/priv/'.$uname.'/'.$tfn;
    $fn=~s/\/+/\//g;
    &Debug($r, "Filename is ".$tfn);
    if ($tfn) {
	&Debug($r, "Filename for tfn = ".$tfn);
	my $target='/home/'.$uname.'/public_html'.$tfn;
	&Debug($r, "target -> ".$target);
#     target is the full filesystem path of the destination file.
	my $base = &File::Basename::basename($fn);
	my $path = &File::Basename::dirname($fn);
	$base    = &HTML::Entities::encode($base,'<>&"');
	my $url  = $path."/".$base; 
	&Debug($r, "URL is now ".$url);
	my $datatoken=$env{'form.datatoken'};
	if (($fn) && ($datatoken)) {
            if ($env{'form.cancel'}) {
                my $source=$r->dir_config('lonDaemons').'/tmp/'.$datatoken.'.tmp';
                my $dirpath=$path.'/';
                $dirpath=~s/\/+/\//g;
                $output .= &mt('Upload cancelled.').'<br /><font size="+2"><a href="'.$dirpath.'">'.
                          &mt('Back to Directory').'</a></font>';
	    } elsif ((-e $target) && (!$env{'form.override'})) {
		$output .= '<form action="'.$action.'" method="post">'.
			  &mt('File [_1] exists. Overwrite?','<span class="LC_filename">'.$fn.'</span>').
			  '<input type="hidden" name="phase" value="two" />'.
			  '<input type="hidden" name="filename" value="'.$url.'" />'.
			  '<input type="hidden" name="datatoken" value="'.$datatoken.'" />'.
			  '<input type="submit" name="override" value="'.&mt('Yes').'" />'.
                          '<input type="submit" name="cancel" value="'.&mt('Cancel').'" />'.
                          '</form>';
            } else {
		my $source=$r->dir_config('lonDaemons').'/tmp/'.$datatoken.'.tmp';
		my $dirpath=$path.'/';
		$dirpath=~s/\/+/\//g;
		# Check for bad extension and disallow upload
                my $result;
                ($result,$returnflag) = &check_extension($fn,$mode,$source,$target,$action,$dirpath,$url);
                $output .= $result;
	    }
	} else {
	    $output .= '<span class="LC_error">'.
		      &mt('Please use browser "Back" button and pick a filename').
		      '</span><br />';
	}
    } else {
	$output .= '<span class="LC_error">'.
		   &mt('Please use browser "Back" button and pick a filename').
		   '</span><br />';
    }
    return ($output,$returnflag);
}

sub check_extension {
    my ($fn,$mode,$source,$target,$action,$dirpath,$url) = @_;
    my ($result,$returnflag);
    # Check for bad extension and disallow upload
    if ($fn=~/\.(\w+)$/ &&
        (&Apache::loncommon::fileembstyle($1) eq 'hdn')) {
        $result .= &mt('File [_1] could not be copied.',
                      '<span class="LC_filename">'.$fn.'</span> ').
                  '<br /><span class="LC_error">'.
                  &mt('The extension on this file is reserved internally by LON-CAPA.').
                  '</span>';
    } elsif ($fn=~/\.(\w+)$/ &&
             !defined(&Apache::loncommon::fileembstyle($1))) {
        $result .= &mt('File [_1] could not be copied.',
                      '<span class="LC_filename">'.$fn.'</span> ').
                  '<br /><span class="LC_error">'.
                  &mt('The extension on this file is not recognized by LON-CAPA.').
                  '</span>';
    } elsif (-d $target) {
        $result .= &mt('File [_1] could not be copied.',
                      '<span class="LC_filename">'.$fn.'</span>').
                  '<br /><span class="LC_error">'.
                  &mt('The target is an existing directory.').
                  '</span>';
    } elsif (copy($source,$target)) {
        chmod(0660, $target); # Set permissions to rw-rw---.
        if ($mode eq 'testbank' || $mode eq 'imsimport') {
            $returnflag = 'ok';
            $result .= &mt('Your file - [_1] - was uploaded successfully',$fn).'<br /><br />';
        } else {
            $result .= &mt('File copied.').'<br />';
        }
        # Check for embedded objects.
        my (%allfiles,%codebase);
        my ($text,$header,$css,$js);
        if (($mode ne 'imsimport') && ($target =~ /\.(htm|html|shtml)$/i)) {
            my (%allfiles,%codebase);
            &Apache::lonnet::extract_embedded_items($target,\%allfiles,\%codebase);
            if (keys(%allfiles) > 0) {
                my $state = <<STATE;
    <input type="hidden" name="action"      value="upload_embedded" />
    <input type="hidden" name="currentpath" value="$env{'form.currentpath'}" />
    <input type="hidden" name="mode"        value="$mode" />
    <input type="hidden" name="phase"       value="three" />
    <input type="hidden" name="filename" value="$url" />
STATE
                $result .= "<h3>".&mt("Reference Warning")."</h3>".
                           "<p>".&mt("Completed upload of the file. This file contained references to other files.")."</p>".
                          "<p>".&mt("Please select the locations from which the referenced files are to be uploaded.")."</p>".
                          &Apache::loncommon::ask_for_embedded_content($action,$state,\%allfiles,\%codebase,
                                      {'error_on_invalid_names'   => 1,
                                       'ignore_remote_references' => 1,});
                if ($mode eq 'testbank') {
                    $returnflag = 'embedded';
                    $result .=  '<p>'.&mt('Or [_1]continue[_2] the testbank import without these files','<a href="javascript:document.testbankForm.submit();">','</a>').'</p>';
                }
            }
        }
        if (($mode ne 'imsimport') && ($mode ne 'testbank')) {
            $result .= '<br /><font size="+2"><a href="'.$url.'">'.
                        &mt('View file').'</a></font>';
        }
    } else {
        $result .= &mt('Failed to copy: [_1].',$!);
    }
    if ($mode ne 'imsimport' && $mode ne 'testbank') {
        $result .= '<br /><font size="+2"><a href="'.$dirpath.'">'.
                   &mt('Back to Directory').'</a></font><br />';
    }
    return ($result,$returnflag);
}

sub phasethree {
    my ($r,$fn,$uname,$udom,$mode) = @_;
    my $result;
    my $dir_root = '/home/'.$uname.'/public_html';
    my $url_root = '/priv/'.$uname;
    my $base = &File::Basename::basename($fn);
    my $path = &File::Basename::dirname($fn);
    $result = &Apache::loncommon::upload_embedded($mode,$path,$uname,$udom,
                                                  $dir_root,$url_root);
    if ($mode ne 'imsimport' && $mode ne 'testbank') {
        $result = '<br /><font size="+2"><a href="'.$url_root.$fn.'">'.
                  &mt('View main file').'</a></font>'.
                  '<br /><font size="+2"><a href="'.$url_root.$path.'">'.
                  &mt('Back to Directory').'</a></font><br />';
    }
    return $result;
}

# ---------------------------------------------------------------- Main Handler
sub handler {

    my $r=shift;

    my $uname;
    my $udom;
    my $javascript = '';
#
# phase two: re-attach user
#
    if ($env{'form.uploaduname'}) {
	$env{'form.filename'}='/priv/'.$env{'form.uploaduname'}.'/'.
	    $env{'form.filename'};
    }

    unless ($env{'form.phase'} eq 'two') {
        $javascript = qq|
function verifyForm() {
    var mode = document.fileupload.filetype.options[document.fileupload.filetype.selectedIndex].value
    if (mode == "testbank") {
        document.fileupload.action = "/adm/testbank";
    }
    if (mode == "imsimport") {
        document.fileupload.action = "/adm/imsimport";
    }
    if (mode == "standard") {
        document.fileupload.action = "/adm/upload";
    }
    document.fileupload.submit();
}
	|;
    }
    ($uname,$udom)=
	&Apache::loncacc::constructaccess($env{'form.filename'},
					  $r->dir_config('lonDefDomain'));

    unless (($uname) && ($udom)) {
	$r->log_reason($uname.' at '.$udom.
		       ' trying to publish file '.$env{'form.filename'}.
		       ' - not authorized', 
		       $r->filename); 
	return HTTP_NOT_ACCEPTABLE;
    }
    
    my $fn;
    if ($env{'form.filename'}) {
	$fn=$env{'form.filename'};
	$fn=~s/^http\:\/\/[^\/]+\///;
	$fn=~s/^\///;
	$fn=~s{(~|priv/)($LONCAPA::username_re)}{};
	$fn=~s/\/+/\//g;
    } else {
	$r->log_reason($env{'user.name'}.' at '.$env{'user.domain'}.
		       ' unspecified filename for upload', $r->filename); 
	return HTTP_NOT_FOUND;
    }

# ----------------------------------------------------------- Start page output


    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

   $javascript = "<script type=\"text/javascript\">\n//<!--\n".
	$javascript."\n// --></script>\n";

    $r->print(&Apache::loncommon::start_page('Upload file to Construction Space',
					     $javascript));
  
    if (($uname ne $env{'user.name'}) || ($udom ne $env{'user.domain'})) {
	$r->print('<h3><span class="LC_error">'.&mt('Co-Author').': '.$uname.
		  &mt(' at ').$udom.'</span></h3>');
    }

    if ($env{'form.phase'} eq 'three') {
        my $output = &phasethree($r,$fn,$uname,$udom,'author');
        $r->print($output);
    } elsif ($env{'form.phase'} eq 'two') {
	my ($output,$returnflag) = &phasetwo($r,$fn,$uname,$udom);
        $r->print($output);
    } else {
	&phaseone($r,$fn,$uname,$udom);
    }

    $r->print(&Apache::loncommon::end_page());
    return OK;  
}

1;
__END__

=head1 NAME

Apache::lonupload - upload files into construction space

=head1 SYNOPSIS

Invoked by /etc/httpd/conf/srm.conf:

 <Location /adm/upload>
 PerlAccessHandler       Apache::lonacc
 SetHandler perl-script
 PerlHandler Apache::lonupload
 ErrorDocument     403 /adm/login
 ErrorDocument     404 /adm/notfound.html
 ErrorDocument     406 /adm/unauthorized.html
 ErrorDocument	  500 /adm/errorhandler
 </Location>

=head1 INTRODUCTION

This module uploads a file sitting on a client computer into 
library server construction space.

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 HANDLER SUBROUTINE

This routine is called by Apache and mod_perl.

=over 4

=item *

Initialize variables

=item *

Start page output

=item *

output relevant interface phase (phaseone or phasetwo or phasethree)

=item *

(phase one is to specify upload file; phase two is to handle conditions
subsequent to specification--like overwriting an existing file; phase three
is to handle processing of secondary uploads - of embedded objects in an
html file).

=back

=head1 OTHER SUBROUTINES

=over 4

=item *

phaseone() : Interface for specifying file to upload.

=item *

phasetwo() : Interface for handling post-conditions about uploading (such
as overwriting an existing file).

=item *

phasethree() : Interface for handling secondary uploads of embedded objects
in an html file.

=item *

upfile_store() : Store contents of uploaded file into temporary space.  Invoked
by phaseone subroutine.

= item *

check_extension() : Checks if filename extension is permitted and checks type
 of file - if html file, calls parser to check for embedded objects.
 Invoked by phasetwo subroutine.

=back

=cut
