/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.SpartanArchive;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class SpartanSmolReader
extends AtomSetCollectionReader {
    boolean isCompoundDocument;
    String modelName = "Spartan file";
    int atomCount;
    Hashtable moData = new Hashtable();

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        String string = "";
        SpartanArchive spartanArchive = null;
        try {
            this.readLine();
            this.isCompoundDocument = this.line.indexOf("Compound Document") >= 0;
            this.atomSetCollection = new AtomSetCollection("spartan " + (this.isCompoundDocument ? "compound document file" : "smol"));
            while (this.line != null) {
                if (this.line.equals("HESSIAN") && string != null) {
                    while (this.readLine() != null && this.line.indexOf("ENDHESS") < 0) {
                        string = string + this.line + " ";
                    }
                }
                if (this.line.equals("BEGINARCHIVE") || this.line.equals("BEGIN Compound Document Entry: Archive")) {
                    spartanArchive = new SpartanArchive(this, this.atomSetCollection, this.moData, string);
                    string = null;
                    this.readArchiveHeader();
                    this.atomCount = spartanArchive.readArchive(this.line, false);
                    if (this.atomCount > 0) {
                        this.atomSetCollection.setAtomSetName(this.modelName);
                    }
                } else if (this.atomCount > 0 && this.line.indexOf("BEGINPROPARC") == 0 || this.line.equals("BEGIN Compound Document Entry: PropertyArchive")) {
                    spartanArchive.readProperties();
                    if (!this.atomSetCollection.setAtomSetCollectionPartialCharges("MULCHARGES")) {
                        this.atomSetCollection.setAtomSetCollectionPartialCharges("Q1_CHARGES");
                    }
                    Float f = (Float)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("HOMO_N");
                    if (this.moData != null && f != null) {
                        this.moData.put("HOMO", new Integer(f.intValue()));
                    }
                } else if (this.line.indexOf("5D shell") >= 0) {
                    this.moData.put("calculationType", this.line);
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        if (this.atomCount > 0 && spartanArchive != null && string != null) {
            spartanArchive.addBonds(string);
        }
        return this.atomSetCollection;
    }

    void readArchiveHeader() throws Exception {
        String string = this.readLine();
        Logger.debug(string);
        this.atomSetCollection.setCollectionName(string);
        this.modelName = this.readLine();
        Logger.debug(this.modelName);
        this.readLine();
    }
}

