/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;

public class UnitCell {
    static final float toRadians = (float)Math.PI / 180;
    static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};
    public static final int INFO_A = 0;
    public static final int INFO_B = 1;
    public static final int INFO_C = 2;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_BETA = 4;
    public static final int INFO_GAMMA = 5;
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    float[] notionalUnitcell;
    Matrix4f matrixNotional;
    Matrix4f matrixCartesianToFractional;
    Matrix4f matrixFractionalToCartesian;
    Point3f[] vertices;
    Point3f cartesianOffset = new Point3f();
    Point3f fractionalOffset = new Point3f();

    public UnitCell(float[] fArray) {
        this.setUnitCell(fArray);
    }

    public final void toCartesian(Point3f point3f) {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixFractionalToCartesian.transform(point3f);
    }

    public final void toFractional(Point3f point3f) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(point3f);
    }

    private final void toFractionalUnitCell(Point3f point3f) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(point3f);
        point3f.x = (float)((double)point3f.x - Math.floor(point3f.x));
        point3f.y = (float)((double)point3f.y - Math.floor(point3f.y));
        point3f.z = (float)((double)point3f.z - Math.floor(point3f.z));
    }

    public final void toUnitCell(Point3f point3f, Point3f point3f2) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.toFractionalUnitCell(point3f);
        if (point3f2 == null) {
            point3f2 = this.fractionalOffset;
        }
        point3f.add(point3f2);
        this.matrixFractionalToCartesian.transform(point3f);
    }

    public void setOffset(Point3f point3f) {
        this.fractionalOffset.set(point3f);
        this.cartesianOffset.set(point3f);
        this.matrixFractionalToCartesian.transform(this.cartesianOffset);
    }

    public void setOffset(int n) {
        Point3f point3f = new Point3f();
        point3f.x = n / 100 - 5;
        point3f.y = n % 100 / 10 - 5;
        point3f.z = n % 10 - 5;
        this.setOffset(point3f);
    }

    public final String dumpInfo(boolean bl) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + (bl ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    public Point3f[] getVertices() {
        return this.vertices;
    }

    public Point3f getCartesianOffset() {
        return this.cartesianOffset;
    }

    public Point3f getFractionalOffset() {
        return this.fractionalOffset;
    }

    public float[] getNotionalUnitCell() {
        return this.notionalUnitcell;
    }

    public float getInfo(int n) {
        switch (n) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
        }
        return Float.NaN;
    }

    private void setUnitCell(float[] fArray) {
        if (fArray == null || fArray[0] == 0.0f) {
            return;
        }
        this.notionalUnitcell = fArray;
        this.a = fArray[0];
        this.b = fArray[1];
        this.c = fArray[2];
        this.alpha = fArray[3];
        this.beta = fArray[4];
        this.gamma = fArray[5];
        this.calcNotionalMatrix();
        this.constructFractionalMatrices();
        this.calcUnitcellVertices();
    }

    private final void calcNotionalMatrix() {
        this.matrixNotional = new Matrix4f();
        float f = (float)Math.cos((float)Math.PI / 180 * this.alpha);
        float f2 = (float)Math.cos((float)Math.PI / 180 * this.beta);
        float f3 = (float)Math.cos((float)Math.PI / 180 * this.gamma);
        float f4 = (float)Math.sin((float)Math.PI / 180 * this.gamma);
        this.matrixNotional.setColumn(0, this.a, 0.0f, 0.0f, 0.0f);
        this.matrixNotional.setColumn(1, this.b * f3, this.b * f4, 0.0f, 0.0f);
        float f5 = this.a * this.b * this.c * (float)Math.sqrt(1.0 - (double)(f * f) - (double)(f2 * f2) - (double)(f3 * f3) + 2.0 * (double)f * (double)f2 * (double)f3);
        this.matrixNotional.setColumn(2, this.c * f2, this.c * (f - f2 * f3) / f4, f5 / (this.a * this.b * f4), 0.0f);
        this.matrixNotional.setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    private final void constructFractionalMatrices() {
        if (this.notionalUnitcell.length > 6 && !Float.isNaN(this.notionalUnitcell[6])) {
            float[] fArray = new float[16];
            for (int i = 0; i < 16; ++i) {
                fArray[i] = this.notionalUnitcell[6 + i];
            }
            this.matrixCartesianToFractional = new Matrix4f(fArray);
            this.matrixFractionalToCartesian = new Matrix4f();
            this.matrixFractionalToCartesian.invert(this.matrixCartesianToFractional);
        } else {
            this.matrixFractionalToCartesian = this.matrixNotional;
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        }
    }

    private final void calcUnitcellVertices() {
        this.vertices = new Point3f[8];
        int n = 8;
        while (--n >= 0) {
            this.vertices[n] = new Point3f();
            this.matrixFractionalToCartesian.transform(unitCubePoints[n], this.vertices[n]);
        }
    }
}

