/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import org.jmol.api.JmolAdapter;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.viewer.MonitorInputStream;
import org.jmol.viewer.Viewer;

class FileManager {
    Viewer viewer;
    JmolAdapter modelAdapter;
    private String openErrorMessage;
    URL appletDocumentBase = null;
    URL appletCodeBase = null;
    String appletProxy;
    private String nameAsGiven = "zapped";
    private String fullPathName;
    String fileName;
    String fileType;
    String inlineData;
    String[] inlineDataArray;
    private String loadScript;
    private File file;
    private FileOpenThread fileOpenThread;
    private FilesOpenThread filesOpenThread;
    private DOMOpenThread aDOMOpenThread;
    final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};

    FileManager(Viewer viewer, JmolAdapter jmolAdapter) {
        this.viewer = viewer;
        this.modelAdapter = jmolAdapter;
        this.clear();
    }

    String getState() {
        StringBuffer stringBuffer = new StringBuffer("# file state;\n\n");
        stringBuffer.append(this.loadScript);
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    String getFileTypeName(String string) {
        int n = string.indexOf("::");
        if (n >= 0) {
            return string.substring(0, n);
        }
        Object object = this.getUnzippedBufferedReaderOrErrorMessageFromName(string);
        if (!(object instanceof BufferedReader)) {
            return null;
        }
        return this.modelAdapter.getFileTypeName((BufferedReader)object);
    }

    void clear() {
        this.setLoadScript("", false);
    }

    void setLoadScript(String string, boolean bl) {
        if (this.loadScript == null || !bl) {
            this.loadScript = "";
        }
        this.loadScript = this.loadScript + "\n" + this.viewer.getLoadState() + string + "\n";
    }

    void openFile(String string, Hashtable hashtable, String string2, boolean bl) {
        this.setLoadScript(string2, bl);
        int n = string.indexOf("::");
        this.nameAsGiven = n >= 0 ? string.substring(n + 2) : string;
        this.fileType = n >= 0 ? string.substring(0, n) : null;
        Logger.info("\nFileManager.openFile(" + this.nameAsGiven + ") //" + string);
        this.fileName = null;
        this.fullPathName = null;
        this.openErrorMessage = null;
        this.classifyName(this.nameAsGiven);
        if (this.openErrorMessage != null) {
            Logger.error("file ERROR: " + this.openErrorMessage);
            return;
        }
        this.fileOpenThread = new FileOpenThread(this.fullPathName, this.nameAsGiven, this.fileType, null, hashtable);
        this.fileOpenThread.run();
    }

    void openFiles(String string, String[] stringArray, String string2, boolean bl) {
        this.setLoadScript(string2, bl);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("::");
            this.nameAsGiven = n >= 0 ? stringArray[i].substring(n + 2) : stringArray[i];
            this.fileType = n >= 0 ? stringArray[i].substring(0, n) : null;
            this.fileName = null;
            this.fullPathName = null;
            this.openErrorMessage = null;
            this.classifyName(this.nameAsGiven);
            if (this.openErrorMessage != null) {
                Logger.error("file ERROR: " + this.openErrorMessage);
                return;
            }
            stringArray2[i] = this.fullPathName;
            stringArray4[i] = this.fileType;
            stringArray3[i] = this.nameAsGiven;
        }
        this.fileName = this.nameAsGiven = string;
        this.fullPathName = this.nameAsGiven;
        this.inlineData = "";
        this.filesOpenThread = new FilesOpenThread(stringArray2, stringArray3, stringArray4, null);
        this.filesOpenThread.run();
    }

    void openStringInline(String string, Hashtable hashtable, boolean bl) {
        String string2 = bl ? "append" : "model";
        String string3 = "data \"" + string2 + " inline\"" + string + "end \"" + string2 + " inline\";";
        this.setLoadScript(string3, bl);
        String string4 = "";
        Logger.info("FileManager.openStringInline(" + string4 + ")");
        this.openErrorMessage = null;
        this.fileName = "string";
        this.fullPathName = "string";
        this.inlineData = string;
        this.fileOpenThread = new FileOpenThread(this.fullPathName, this.fullPathName, null, new BufferedReader(new StringReader(string)), hashtable);
        this.fileOpenThread.run();
    }

    void openStringsInline(String[] stringArray, Hashtable hashtable, boolean bl) {
        this.loadScript = "dataSeparator = \"~~~next file~~~\";\ndata \"model inline\"";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                this.loadScript = this.loadScript + "~~~next file~~~";
            }
            this.loadScript = this.loadScript + stringArray[i];
        }
        this.loadScript = this.loadScript + "end \"model inline\";";
        this.setLoadScript(this.loadScript, bl);
        String string = "";
        Logger.info("FileManager.openStringInline(string[]" + string + ")");
        this.openErrorMessage = null;
        this.fileName = "string[]";
        this.fullPathName = "string[]";
        this.inlineDataArray = stringArray;
        String[] stringArray2 = new String[stringArray.length];
        Reader[] readerArray = new StringReader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "string[" + i + "]";
            readerArray[i] = new StringReader(stringArray[i]);
        }
        this.filesOpenThread = new FilesOpenThread(stringArray2, stringArray2, null, readerArray);
        this.filesOpenThread.run();
    }

    void openDOM(Object object) {
        this.openErrorMessage = null;
        this.fileName = "JSNode";
        this.fullPathName = "JSNode";
        this.inlineData = "";
        this.aDOMOpenThread = new DOMOpenThread(object);
        this.aDOMOpenThread.run();
    }

    void openReader(String string, String string2, Reader reader) {
        this.openBufferedReader(string, string2, new BufferedReader(reader));
    }

    void openBufferedReader(String string, String string2, BufferedReader bufferedReader) {
        this.openErrorMessage = null;
        this.fullPathName = string;
        this.fileName = string2;
        this.fileType = null;
        this.fileOpenThread = new FileOpenThread(string, string, this.fileType, bufferedReader, null);
        this.fileOpenThread.run();
    }

    boolean isGzip(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4];
        inputStream.mark(5);
        int n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        return n == 4 && byArray[0] == 31 && byArray[1] == -117;
    }

    boolean isCompoundDocument(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[8];
        inputStream.mark(9);
        int n = inputStream.read(byArray, 0, 8);
        inputStream.reset();
        return n == 8 && byArray[0] == -48 && byArray[1] == -49 && byArray[2] == 17 && byArray[3] == -32 && byArray[4] == -95 && byArray[5] == -79 && byArray[6] == 26 && byArray[7] == -31;
    }

    String getFileAsString(String string) {
        Logger.info("FileManager.getFileAsString(" + string + ")");
        Object object = this.getInputStreamOrErrorMessageFromName(string);
        if (object instanceof String) {
            return "Error:" + object;
        }
        try {
            String string2;
            BufferedInputStream bufferedInputStream;
            FilterInputStream filterInputStream = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (this.isCompoundDocument(filterInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                return "" + compoundDocument.getAllData();
            }
            if (this.isGzip(filterInputStream)) {
                filterInputStream = new GZIPInputStream(bufferedInputStream);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(filterInputStream));
            StringBuffer stringBuffer = new StringBuffer(8192);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    Object waitForClientFileOrErrorMessage() {
        Object object = null;
        if (this.fileOpenThread != null) {
            object = this.fileOpenThread.clientFile;
            if (this.fileOpenThread.errorMessage != null) {
                this.openErrorMessage = this.fileOpenThread.errorMessage;
            } else if (object == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.fileOpenThread = null;
        } else if (this.filesOpenThread != null) {
            object = this.filesOpenThread.clientFile;
            if (this.filesOpenThread.errorMessage != null) {
                this.openErrorMessage = this.filesOpenThread.errorMessage;
            } else if (object == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
        } else if (this.aDOMOpenThread != null) {
            object = this.aDOMOpenThread.clientFile;
            if (this.aDOMOpenThread.errorMessage != null) {
                this.openErrorMessage = this.aDOMOpenThread.errorMessage;
            } else if (object == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.aDOMOpenThread = null;
        }
        if (this.openErrorMessage != null) {
            return this.openErrorMessage;
        }
        return object;
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        if (this.appletDocumentBase == null) {
            return "";
        }
        return this.appletDocumentBase.toString();
    }

    void setAppletContext(URL uRL, URL uRL2, String string) {
        this.appletDocumentBase = uRL;
        Logger.info("appletDocumentBase=" + uRL);
        this.appletCodeBase = uRL2;
        this.appletProxy = string;
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    void dumpDocumentBase(String string) {
        Logger.info("dumpDocumentBase:" + string);
        Object object = this.getInputStreamOrErrorMessageFromName(string);
        if (object instanceof String) {
            Logger.error("file ERROR:" + object);
        } else {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    Logger.info(string2);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                Logger.error("exception caught:" + exception);
            }
        }
    }

    private void classifyName(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.viewer.getDefaultDirectory();
        if (this.appletDocumentBase != null) {
            try {
                if (string2 != null && string.indexOf(":") < 0) {
                    string = string2 + "/" + string;
                }
                URL uRL = new URL(this.appletDocumentBase, string);
                this.fullPathName = uRL.toString();
                this.fileName = this.fullPathName.substring(this.fullPathName.lastIndexOf(47) + 1, this.fullPathName.length());
            }
            catch (MalformedURLException malformedURLException) {
                this.openErrorMessage = malformedURLException.getMessage();
            }
            return;
        }
        for (int i = 0; i < this.urlPrefixes.length; ++i) {
            if (!string.startsWith(this.urlPrefixes[i])) continue;
            try {
                URL uRL = new URL(string);
                this.fullPathName = uRL.toString();
                this.fileName = this.fullPathName.substring(this.fullPathName.lastIndexOf(47) + 1, this.fullPathName.length());
            }
            catch (MalformedURLException malformedURLException) {
                this.openErrorMessage = malformedURLException.getMessage();
            }
            return;
        }
        if (string.indexOf(":") < 0 && string2 != null) {
            string = string2 + "/" + string;
        }
        this.file = new File(string);
        this.fullPathName = this.file.getAbsolutePath();
        this.fileName = this.file.getName();
    }

    Object getInputStreamOrErrorMessageFromName(String string) {
        String string2 = null;
        int n = this.urlPrefixes.length;
        while (--n >= 0 && !string.startsWith(this.urlPrefixes[n])) {
        }
        boolean bl = n >= 0;
        boolean bl2 = this.appletDocumentBase != null;
        String string3 = this.viewer.getDefaultDirectory();
        try {
            InputStream inputStream;
            int n2;
            if (bl2 || bl) {
                if (bl2 && bl && this.appletProxy != null) {
                    string = this.appletProxy + "?url=" + URLEncoder.encode(string, "utf-8");
                } else if (!bl && string3 != null) {
                    string = string3 + "/" + string;
                }
                URL uRL = bl2 ? new URL(this.appletDocumentBase, string) : new URL(string);
                Logger.info("FileManager opening " + uRL.toString());
                URLConnection uRLConnection = uRL.openConnection();
                n2 = uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
            } else {
                if (!bl && string.indexOf(":") < 0 && string3 != null) {
                    string = string3 + "/" + string;
                }
                Logger.info("FileManager opening " + string);
                File file = new File(string);
                n2 = (int)file.length();
                inputStream = new FileInputStream(file);
            }
            return new MonitorInputStream(inputStream, n2);
        }
        catch (Exception exception) {
            string2 = "" + exception;
            return string2;
        }
    }

    Object getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String string) {
        Object object = this.getInputStreamOrErrorMessageFromName(string);
        if (object instanceof String) {
            return object;
        }
        try {
            BufferedInputStream bufferedInputStream;
            FilterInputStream filterInputStream = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (this.isCompoundDocument(filterInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                return this.getBufferedReaderForString("" + compoundDocument.getAllData());
            }
            if (this.isGzip(filterInputStream)) {
                filterInputStream = new GZIPInputStream(bufferedInputStream);
            }
            return new BufferedReader(new InputStreamReader(filterInputStream));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    class FilesOpenThread
    implements Runnable {
        String errorMessage;
        String[] fullPathNamesInThread;
        String[] namesAsGivenInThread;
        String[] fileTypesInThread;
        Object clientFile;
        Reader[] reader;

        FilesOpenThread(String[] stringArray, String[] stringArray2, String[] stringArray3, Reader[] readerArray) {
            this.fullPathNamesInThread = stringArray;
            this.namesAsGivenInThread = stringArray2;
            this.fileTypesInThread = stringArray3;
            this.reader = readerArray;
        }

        public void run() {
            if (this.reader != null) {
                this.openReader(this.reader);
            } else {
                InputStream[] inputStreamArray = new InputStream[this.namesAsGivenInThread.length];
                for (int i = 0; i < this.namesAsGivenInThread.length; ++i) {
                    Object object = FileManager.this.getInputStreamOrErrorMessageFromName(this.namesAsGivenInThread[i]);
                    if (!(object instanceof InputStream)) {
                        this.errorMessage = object == null ? "error opening:" + this.namesAsGivenInThread[i] : (String)object;
                        return;
                    }
                    inputStreamArray[i] = (InputStream)object;
                }
                this.openInputStream(inputStreamArray);
            }
            if (this.errorMessage != null) {
                Logger.error("file ERROR: " + this.errorMessage);
            }
        }

        private void openInputStream(InputStream[] inputStreamArray) {
            Reader[] readerArray = new Reader[inputStreamArray.length];
            for (int i = 0; i < inputStreamArray.length; ++i) {
                BufferedInputStream bufferedInputStream;
                BufferedInputStream bufferedInputStream2 = bufferedInputStream = new BufferedInputStream(inputStreamArray[i], 8192);
                try {
                    if (FileManager.this.isCompoundDocument(bufferedInputStream2)) {
                        CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                        readerArray[i] = new StringReader("" + compoundDocument.getAllData());
                        continue;
                    }
                    if (FileManager.this.isGzip(bufferedInputStream2)) {
                        readerArray[i] = new InputStreamReader(new GZIPInputStream(bufferedInputStream));
                        continue;
                    }
                    readerArray[i] = new InputStreamReader(bufferedInputStream2);
                    continue;
                }
                catch (Exception exception) {
                    this.errorMessage = exception.getMessage();
                    return;
                }
            }
            this.openReader(readerArray);
        }

        private void openReader(Reader[] readerArray) {
            BufferedReader[] bufferedReaderArray = new BufferedReader[readerArray.length];
            for (int i = 0; i < readerArray.length; ++i) {
                bufferedReaderArray[i] = new BufferedReader(readerArray[i]);
            }
            Object object = FileManager.this.modelAdapter.openBufferedReaders(this.fullPathNamesInThread, this.fileTypesInThread, bufferedReaderArray);
            if (object instanceof String) {
                this.errorMessage = (String)object;
            } else {
                this.clientFile = object;
            }
        }
    }

    class FileOpenThread
    implements Runnable {
        String errorMessage;
        String fullPathNameInThread;
        String nameAsGivenInThread;
        String fileTypeInThread;
        Object clientFile;
        BufferedReader reader;
        Hashtable htParams;

        FileOpenThread(String string, String string2, String string3, BufferedReader bufferedReader, Hashtable hashtable) {
            this.fullPathNameInThread = string;
            this.nameAsGivenInThread = string2;
            this.fileTypeInThread = string3;
            this.reader = bufferedReader;
            this.htParams = hashtable;
        }

        public void run() {
            if (this.reader != null) {
                this.openBufferedReader(this.reader);
            } else {
                Object object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(this.nameAsGivenInThread);
                if (object instanceof BufferedReader) {
                    this.openBufferedReader((BufferedReader)object);
                } else {
                    String string = this.errorMessage = object == null ? "error opening:" + this.nameAsGivenInThread : (String)object;
                }
            }
            if (this.errorMessage != null) {
                Logger.error("file ERROR: " + this.fullPathNameInThread + "\n" + this.errorMessage);
            }
        }

        private void openBufferedReader(BufferedReader bufferedReader) {
            Object object = FileManager.this.modelAdapter.openBufferedReader(this.fullPathNameInThread, this.fileTypeInThread, bufferedReader, this.htParams);
            if (object instanceof String) {
                this.errorMessage = (String)object;
            } else {
                this.clientFile = object;
            }
        }
    }

    class DOMOpenThread
    implements Runnable {
        String errorMessage;
        Object aDOMNode;
        Object clientFile;

        DOMOpenThread(Object object) {
            this.aDOMNode = object;
        }

        public void run() {
            this.clientFile = FileManager.this.modelAdapter.openDOMReader(this.aDOMNode);
            this.errorMessage = null;
        }
    }
}

