/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Vector;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class ScriptManager {
    Viewer viewer;
    Thread queueThread;
    Vector scriptQueue = new Vector();
    boolean useQueue = true;
    boolean scriptQueueRunning;

    ScriptManager(Viewer viewer) {
        this.viewer = viewer;
    }

    public void setQueue(boolean bl) {
        this.useQueue = bl;
        if (!bl) {
            this.clearQueue();
        }
    }

    public String addScript(String string) {
        return (String)this.addScript("string", string, "", false, false);
    }

    public String addScript(String string, boolean bl, boolean bl2) {
        return (String)this.addScript("String", string, "", bl, bl2);
    }

    public Object addScript(String string, String string2, String string3, boolean bl, boolean bl2) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(string2);
        vector.addElement(string3);
        vector.addElement(string);
        vector.addElement(bl ? Boolean.TRUE : Boolean.FALSE);
        vector.addElement(bl2 ? Boolean.TRUE : Boolean.FALSE);
        if (!this.useQueue) {
            this.clearQueue();
            this.viewer.haltScriptExecution();
        }
        this.scriptQueue.addElement(vector);
        if (Logger.isActiveLevel(0)) {
            Logger.debug(this.scriptQueue.size() + " scripts; added: " + string2);
        }
        this.startScriptQueue();
        return "pending";
    }

    public int getScriptCount() {
        return this.scriptQueue.size();
    }

    public void clearQueue() {
        this.scriptQueue.clear();
    }

    public void waitForQueue() {
        int n = 0;
        while (this.queueThread != null) {
            try {
                Thread.sleep(100L);
                if (n++ % 10 != 0 || !Logger.isActiveLevel(0)) continue;
                Logger.debug("...scriptManager waiting for queue: " + this.scriptQueue.size());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    Object runNextScript() {
        if (this.scriptQueue.size() == 0) {
            return null;
        }
        Vector vector = (Vector)this.scriptQueue.get(0);
        String string = (String)vector.get(0);
        String string2 = (String)vector.get(1);
        String string3 = (String)vector.get(2);
        boolean bl = (Boolean)vector.get(3);
        boolean bl2 = (Boolean)vector.get(4);
        if (Logger.isActiveLevel(0)) {
            Logger.debug(this.scriptQueue.size() + " scripts; running: " + string);
        }
        this.scriptQueue.removeElementAt(0);
        Object object = this.runScript(string3, string, string2, bl, bl2);
        if (this.scriptQueue.size() == 0) {
            return null;
        }
        return object;
    }

    private Object runScript(String string, String string2, String string3, boolean bl, boolean bl2) {
        return this.viewer.evalStringWaitStatus(string, string2, string3, bl, bl2);
    }

    private void startScriptQueue() {
        if (this.scriptQueueRunning) {
            return;
        }
        this.scriptQueueRunning = true;
        this.queueThread = new Thread(new ScriptQueueRunnable());
        this.queueThread.start();
    }

    class ScriptQueueRunnable
    implements Runnable {
        ScriptQueueRunnable() {
        }

        public void run() {
            while (ScriptManager.this.scriptQueue.size() != 0) {
                ScriptManager.this.runNextScript();
            }
            ScriptManager.this.scriptQueueRunning = false;
            ScriptManager.this.queueThread = null;
        }

        public void stop() {
            ScriptManager.this.scriptQueueRunning = false;
        }
    }
}

