/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.Mmset;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Compiler;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Eval {
    static final int scriptLevelMax = 10;
    static final int MAX_IF_DEPTH = 10;
    Compiler compiler;
    int scriptLevel;
    int scriptReportingLevel;
    Context[] stack = new Context[10];
    String filename;
    String script;
    String thisCommand;
    short[] linenumbers;
    int[] lineIndices;
    Token[][] aatoken;
    int pc;
    int lineEnd;
    int pcEnd;
    long timeBeginExecution;
    long timeEndExecution;
    boolean error;
    String errorMessage;
    Token[] statement;
    int statementLength;
    Viewer viewer;
    BitSet bsSubset;
    int iToken;
    int[] ifs;
    boolean isSyntaxCheck;
    boolean isScriptCheck;
    boolean tQuiet;
    boolean logMessages = false;
    boolean debugScript = false;
    boolean fileOpenCheck = true;
    StringBuffer outputBuffer;
    static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    private Boolean interruptExecution = Boolean.FALSE;
    private Boolean executionPaused = Boolean.FALSE;
    boolean isExecuting = false;
    Thread currentThread = null;
    int commandHistoryLevelMax = 0;
    final StringBuffer strbufLog = new StringBuffer(80);
    Token[] tempStatement;
    boolean isBondSet;
    Token expressionResult;
    boolean coordinatesAreFractional;
    int theTok;
    Token theToken;
    Hashtable variables = new Hashtable();
    Object[] data;
    int lastMoNumber = 0;
    boolean ignoreError;

    Eval(Viewer viewer) {
        this.compiler = new Compiler(viewer);
        this.viewer = viewer;
        this.clearDefinitionsAndLoadPredefined();
    }

    public static Object evaluateExpression(Viewer viewer, String string) {
        Eval eval = new Eval(viewer);
        try {
            if (eval.loadScript(null, "e_x_p_r_e_s_s_i_o_n = " + string)) {
                eval.statement = eval.aatoken[0];
                eval.statementLength = eval.statement.length;
                return eval.parameterExpression(2, "");
            }
        }
        catch (Exception exception) {
            Logger.error((String)("Error evaluating: " + string + "\n" + exception));
        }
        return "ERROR";
    }

    static BitSet getAtomBitSet(Eval eval, Viewer viewer, Object object) {
        if (object instanceof BitSet) {
            return (BitSet)object;
        }
        if (eval == null) {
            eval = new Eval(viewer);
        }
        BitSet bitSet = new BitSet();
        try {
            eval.pushContext();
            String string = "select (" + object + ")";
            string = TextFormat.replaceAllCharacters((String)string, (String)"\n\r", (String)"),(");
            string = TextFormat.simpleReplace((String)string, (String)"()", (String)"(none)");
            if (eval.loadScript(null, string)) {
                eval.statement = eval.aatoken[0];
                bitSet = eval.expression(eval.statement, 1, false, false, true);
            }
            eval.popContext();
        }
        catch (Exception exception) {
            Logger.error((String)("getAtomBitSet " + object + "\n" + exception));
        }
        return bitSet;
    }

    static Vector getAtomBitSetVector(Eval eval, Viewer viewer, Object object) {
        Vector<Integer> vector = new Vector<Integer>();
        BitSet bitSet = Eval.getAtomBitSet(eval, viewer, object);
        int n = viewer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            vector.addElement(new Integer(i));
        }
        return vector;
    }

    void haltExecution() {
        this.resumePausedExecution();
        this.interruptExecution = Boolean.TRUE;
    }

    boolean isScriptExecuting() {
        return this.isExecuting && this.interruptExecution == false;
    }

    public void runEval(boolean bl, boolean bl2) {
        boolean bl3 = this.fileOpenCheck;
        this.fileOpenCheck = bl2;
        this.viewer.pushHoldRepaint();
        this.interruptExecution = Boolean.FALSE;
        this.executionPaused = Boolean.FALSE;
        this.isExecuting = true;
        this.currentThread = Thread.currentThread();
        this.isSyntaxCheck = this.isScriptCheck = bl;
        this.timeBeginExecution = System.currentTimeMillis();
        try {
            this.instructionDispatchLoop(false);
        }
        catch (ScriptException scriptException) {
            this.error = true;
            this.setErrorMessage(scriptException.toString());
            this.scriptStatus(this.errorMessage);
        }
        this.timeEndExecution = System.currentTimeMillis();
        this.fileOpenCheck = bl3;
        if (this.errorMessage == null && this.interruptExecution.booleanValue()) {
            this.errorMessage = "execution interrupted";
        } else if (!this.tQuiet && !this.isSyntaxCheck) {
            this.viewer.scriptStatus("Script completed");
        }
        this.isScriptCheck = false;
        this.isSyntaxCheck = false;
        this.isExecuting = false;
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint();
    }

    boolean hadRuntimeError() {
        return this.error;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    void setErrorMessage(String string) {
        if (this.errorMessage == null) {
            this.errorMessage = GT._((String)"script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    private void runScript(String string) throws ScriptException {
        this.pushContext();
        if (this.loadScript(null, string)) {
            this.instructionDispatchLoop(false);
        }
        this.popContext();
    }

    void runScript(String string, StringBuffer stringBuffer) throws ScriptException {
        this.pushContext();
        this.outputBuffer = stringBuffer;
        if (this.loadScript(null, string)) {
            this.instructionDispatchLoop(false);
        }
        this.popContext();
    }

    void pushContext() throws ScriptException {
        if (this.scriptLevel == 10) {
            this.evalError(GT._((String)"too many script levels"));
        }
        Context context = new Context();
        context.filename = this.filename;
        context.script = this.script;
        context.linenumbers = this.linenumbers;
        context.lineIndices = this.lineIndices;
        context.aatoken = this.aatoken;
        context.statement = this.statement;
        context.statementLength = this.statementLength;
        context.pc = this.pc;
        context.lineEnd = this.lineEnd;
        context.pcEnd = this.pcEnd;
        context.iToken = this.iToken;
        context.ifs = this.ifs;
        context.outputBuffer = this.outputBuffer;
        this.stack[this.scriptLevel++] = context;
        if (this.isScriptCheck) {
            Logger.info((String)("-->>-------------".substring(0, this.scriptLevel + 5) + this.filename));
        }
    }

    void popContext() {
        if (this.isScriptCheck) {
            Logger.info((String)("--<<-------------".substring(0, this.scriptLevel + 5) + this.filename));
        }
        if (this.scriptLevel == 0) {
            return;
        }
        Context context = this.stack[--this.scriptLevel];
        this.stack[this.scriptLevel] = null;
        this.filename = context.filename;
        this.script = context.script;
        this.linenumbers = context.linenumbers;
        this.lineIndices = context.lineIndices;
        this.aatoken = context.aatoken;
        this.statement = context.statement;
        this.statementLength = context.statementLength;
        this.pc = context.pc;
        this.lineEnd = context.lineEnd;
        this.pcEnd = context.pcEnd;
        this.iToken = context.iToken;
        this.ifs = context.ifs;
        this.outputBuffer = context.outputBuffer;
    }

    boolean loadScript(String string, String string2) {
        this.filename = string;
        if (!this.compiler.compile(string, string2, false, false)) {
            this.error = true;
            this.errorMessage = this.compiler.getErrorMessage();
            return false;
        }
        this.script = this.compiler.getScript();
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.linenumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        return true;
    }

    Object checkScriptSilent(String string) {
        if (!this.compiler.compile(null, string, false, true)) {
            return this.compiler.getErrorMessage();
        }
        this.isSyntaxCheck = true;
        this.isScriptCheck = false;
        this.errorMessage = null;
        this.script = this.compiler.getScript();
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.linenumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        try {
            this.instructionDispatchLoop(false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
        }
        this.isSyntaxCheck = false;
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.compiler.getScript());
        vector.addElement(this.compiler.getAatokenCompiled());
        vector.addElement(this.compiler.getLineNumbers());
        vector.addElement(this.compiler.getLineIndices());
        return vector;
    }

    void clearState(boolean bl) {
        int n = 10;
        while (--n >= 0) {
            this.stack[n] = null;
        }
        this.scriptLevel = 0;
        this.error = false;
        this.errorMessage = null;
        this.tQuiet = bl;
    }

    boolean loadScriptString(String string, boolean bl) {
        this.clearState(bl);
        return this.loadScript(null, string);
    }

    boolean loadScriptFile(String string, boolean bl) {
        this.clearState(bl);
        return this.loadScriptFileInternal(string);
    }

    private boolean loadScriptFileInternal(String string) {
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.loadScript(string, this.viewer.eval(string.substring(11)));
        }
        Object object = this.viewer.getInputStreamOrErrorMessageFromName(string);
        if (!(object instanceof InputStream)) {
            return this.loadError((String)object);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return this.ioError(string);
        }
        try {
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.loadScript(string, stringBuffer.toString());
    }

    boolean loadError(String string) {
        this.error = true;
        this.errorMessage = string;
        return false;
    }

    boolean fileNotFound(String string) {
        return this.loadError("file not found:" + string);
    }

    boolean ioError(String string) {
        return this.loadError("io error reading:" + string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Eval\n pc:");
        stringBuffer.append(this.pc);
        stringBuffer.append("\n");
        stringBuffer.append(this.aatoken.length);
        stringBuffer.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            stringBuffer.append("----\n");
            Token[] tokenArray = this.aatoken[i];
            for (int j = 0; j < tokenArray.length; ++j) {
                stringBuffer.append(tokenArray[j]);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("END\n");
        return stringBuffer.toString();
    }

    private void clearPredefined(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.predefine(stringArray[i]);
        }
    }

    void clearDefinitionsAndLoadPredefined() {
        String string;
        this.variables.clear();
        this.bsSubset = null;
        this.viewer.setSelectionSubset(null);
        if (this.viewer.getModelSet() == null || this.viewer.getAtomCount() == 0) {
            return;
        }
        this.clearPredefined(JmolConstants.predefinedStatic);
        this.clearPredefined(JmolConstants.predefinedVariable);
        int n = 4;
        int n2 = JmolConstants.elementNumberMax;
        while (--n2 > 1) {
            string = "@" + JmolConstants.elementNameFromNumber(n2) + " _e=" + n2;
            this.predefine(string);
        }
        n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 1) {
            string = "@_" + JmolConstants.elementSymbolFromNumber(n2) + " " + JmolConstants.elementNameFromNumber(n2);
            this.predefine(string);
        }
        n2 = n;
        while (--n2 >= 0) {
            string = "@" + JmolConstants.altElementNameFromIndex(n2) + " _e=" + JmolConstants.altElementNumberFromIndex(n2);
            this.predefine(string);
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= n) {
            string = " element=" + JmolConstants.altElementNumberFromIndex(n2);
            String string2 = "@_" + JmolConstants.altElementSymbolFromIndex(n2);
            this.predefine(string2 + string);
            string2 = "@_" + JmolConstants.altIsotopeSymbolFromIndex(n2);
            this.predefine(string2 + string);
            string2 = "@" + JmolConstants.altElementNameFromIndex(n2);
            if (string2.length() <= 1) continue;
            this.predefine(string2 + string);
        }
    }

    void predefine(String string) {
        if (this.compiler.compile("#predefine", string, true, false)) {
            Token[][] tokenArray = this.compiler.getAatokenCompiled();
            if (tokenArray.length != 1) {
                this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
                return;
            }
            Token[] tokenArray2 = tokenArray[0];
            if (tokenArray2.length > 2) {
                this.iToken = 1;
                int n = tokenArray2[1].tok;
                if (n == 1 || Compiler.tokAttr(n, 196608)) {
                    String string2 = (String)tokenArray2[1].value;
                    this.variables.put(string2, tokenArray2);
                } else {
                    this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
                }
            } else {
                this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            }
        } else {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + this.compiler.getErrorMessage());
        }
    }

    void setShapeProperty(int n, String string, Object object) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeProperty(n, string, object);
        }
    }

    void setShapeSize(int n, int n2) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeSize(n, n2);
        }
    }

    void setBooleanProperty(String string, boolean bl) {
        if (!this.isSyntaxCheck) {
            this.viewer.setBooleanProperty(string, bl);
        }
    }

    void setIntProperty(String string, int n) {
        if (!this.isSyntaxCheck) {
            this.viewer.setIntProperty(string, n);
        }
    }

    void setFloatProperty(String string, float f) {
        if (!this.isSyntaxCheck) {
            this.viewer.setFloatProperty(string, f);
        }
    }

    void setStringProperty(String string, String string2) {
        if (!this.isSyntaxCheck || string.equalsIgnoreCase("defaultdirectory")) {
            this.viewer.setStringProperty(string, string2);
        }
    }

    void pauseExecution() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.delay(100L);
        this.viewer.popHoldRepaint();
        this.executionPaused = Boolean.TRUE;
    }

    boolean isExecutionPaused() {
        return this.executionPaused;
    }

    void resumePausedExecution() {
        this.executionPaused = Boolean.FALSE;
    }

    boolean checkContinue() {
        if (!this.interruptExecution.booleanValue()) {
            if (!this.executionPaused.booleanValue()) {
                return true;
            }
            if (Logger.isActiveLevel((int)0)) {
                Logger.debug((String)("script execution paused at this command: " + this.thisCommand));
            }
            try {
                while (this.executionPaused.booleanValue()) {
                    Thread.sleep(100L);
                    String string = this.viewer.getInterruptScript();
                    if (string == "") continue;
                    this.resumePausedExecution();
                    this.error = false;
                    --this.pc;
                    try {
                        this.runScript(string);
                    }
                    catch (Exception exception) {
                        this.error = true;
                        this.errorMessage = exception.toString();
                    }
                    ++this.pc;
                    if (this.error) {
                        this.scriptStatus(this.errorMessage);
                    }
                    this.pauseExecution();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.debug((String)"script execution resumed");
        }
        return this.interruptExecution == false;
    }

    void fixVariables() throws ScriptException {
        int n;
        for (n = 1; n < this.statementLength && this.statement[n].tok != 74505; ++n) {
        }
        if (n == this.statementLength) {
            return;
        }
        Token[] tokenArray = new Token[this.statementLength];
        tokenArray[0] = this.statement[0];
        boolean bl = false;
        int n2 = 1;
        for (n = 1; n < this.statementLength; ++n) {
            int n3 = this.statement[n].tok;
            switch (n3) {
                case 74505: {
                    String string = this.parameterAsString(++n);
                    Object object = this.viewer.getParameter(string);
                    if (object instanceof Boolean) {
                        tokenArray[n2] = (Boolean)object != false ? Token.tokenOn : Token.tokenOff;
                    } else if (object instanceof Integer) {
                        Object object2;
                        tokenArray[n2] = bl && (object2 = this.viewer.getParameter(string + "_set")) != null ? new Token(798, "" + object2) : new Token(2, (Integer)object, object);
                    } else if (object instanceof Float) {
                        tokenArray[n2] = new Token(3, Compiler.modelValue("" + object), object);
                    } else if (object instanceof String && ((String)object).length() > 0) {
                        tokenArray[n2] = (object = this.getStringObjectAsToken((String)object)) instanceof Token ? (Token)object : new Token(bl ? 798 : (((String)object).indexOf(".") >= 0 ? 4 : 1), (String)object);
                    } else {
                        Point3f point3f = this.getDrawObjectCenter(string);
                        if (point3f == null) {
                            this.invalidArgument();
                        }
                        tokenArray[n2] = new Token(7, point3f);
                    }
                    if (n2 != 1 || this.statement[0].tok != 21791 || tokenArray[n2].tok == 1) break;
                    this.invalidArgument();
                    break;
                }
                case 65636: 
                case 65637: {
                    bl = n3 == 65636;
                    tokenArray[n2] = this.statement[n];
                    break;
                }
                default: {
                    tokenArray[n2] = this.statement[n];
                }
            }
            ++n2;
        }
        this.statement = tokenArray;
        this.statementLength = n2;
    }

    Object getStringObjectAsToken(String string) {
        Object object = string;
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '{') {
            object = Escape.unescapePoint((String)string);
        } else if (string.indexOf("({") == 0) {
            object = Escape.unescapeBitset((String)string);
        } else if (string.indexOf("[{") == 0) {
            return new Token(32839, new Bond.BondSet(Escape.unescapeBitset((String)string)));
        }
        if (object instanceof Point3f) {
            return new Token(7, object);
        }
        if (object instanceof Point4f) {
            return new Token(8, object);
        }
        if (object instanceof BitSet) {
            return new Token(32839, object);
        }
        return object;
    }

    void instructionDispatchLoop(boolean bl) throws ScriptException {
        long l = 0L;
        int n = 0;
        this.ifs = new int[11];
        this.ifs[0] = 0;
        this.debugScript = !this.isSyntaxCheck && this.viewer.getDebugScript();
        boolean bl2 = this.logMessages = this.debugScript && Logger.isActiveLevel((int)0);
        if (this.logMessages) {
            l = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.instructionDispatchLoop():" + l);
            this.viewer.scriptStatus(this.toString());
        }
        if (!this.isSyntaxCheck && this.scriptLevel <= this.commandHistoryLevelMax) {
            this.viewer.addCommand(this.script);
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd && this.checkContinue()) {
            block118: {
                int n2;
                Token token;
                block117: {
                    block116: {
                        token = this.aatoken[this.pc][0];
                        this.statement = this.aatoken[this.pc];
                        this.statementLength = this.statement.length;
                        this.fixVariables();
                        if (this.linenumbers[this.pc] > this.lineEnd) break;
                        this.thisCommand = this.getCommand();
                        this.iToken = 0;
                        String string = this.viewer.getInterruptScript();
                        if (string != "") {
                            this.runScript(string);
                        }
                        if (bl || !this.isSyntaxCheck) {
                            n2 = this.viewer.getScriptDelay();
                            if (bl || n2 > 0 && this.scriptLevel > 0) {
                                if (n2 > 0) {
                                    this.delay(n2);
                                }
                                this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.linenumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                            }
                        }
                        if (!this.isSyntaxCheck) break block116;
                        if (this.isScriptCheck) {
                            Logger.info((String)this.thisCommand);
                        }
                        if (this.statementLength != 1) break block117;
                        break block118;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(n + (token.tok == 365 || token.tok == 366 ? -1 : 0));
                    }
                    if (this.logMessages) {
                        Logger.debug((String)token.toString());
                    }
                    if (n > 0 && this.ifs[n] < 0 && token.tok != 366 && token.tok != 5484 && token.tok != 365) break block118;
                }
                switch (token.tok) {
                    case 5484: {
                        for (n2 = 1; n2 <= n; ++n2) {
                            if (this.ifs[n2] != this.pc && this.ifs[n2] != -1 - this.pc) continue;
                            n = n2 - 1;
                            break;
                        }
                        if (++n == 10) {
                            this.evalError(GT._((String)"Too many nested {0} commands", (String)"IF"));
                        }
                        this.ifs[n] = this.ifs[n - 1] >= 0 && this.ifCmd() ? this.pc : -1 - this.pc;
                        break;
                    }
                    case 365: {
                        if (n < 1) {
                            this.evalError(GT._((String)"Invalid {0} command", (String)"ELSE"));
                        }
                        if (this.isSyntaxCheck) break;
                        this.ifs[n] = -1 - this.ifs[n];
                        break;
                    }
                    case 366: {
                        if (--n >= 0) break;
                        this.evalError(GT._((String)"Invalid {0} command", (String)"ENDIF"));
                        break;
                    }
                    case 196864: {
                        this.proteinShape(9);
                        break;
                    }
                    case 24833: {
                        this.background(1);
                        break;
                    }
                    case 772: {
                        this.center(1);
                        break;
                    }
                    case 881923: {
                        this.color();
                        break;
                    }
                    case 0x210112: {
                        this.data();
                        break;
                    }
                    case 74505: {
                        this.define();
                        break;
                    }
                    case 10507: {
                        this.echo(1);
                        break;
                    }
                    case 2405: {
                        this.message();
                        break;
                    }
                    case 32824: {
                        break;
                    }
                    case 268: {
                        if (!this.isSyntaxCheck && this.pc > 0) {
                            this.viewer.clearScriptQueue();
                        }
                    }
                    case 277: {
                        if (this.isSyntaxCheck) break;
                        this.interruptExecution = this.pc > 0 || !this.viewer.usingScriptQueue() ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 2959625: {
                        this.label(1);
                        break;
                    }
                    case 2385: {
                        this.hover();
                        break;
                    }
                    case 2167051: {
                        this.load();
                        break;
                    }
                    case 75026: {
                        this.monitor();
                        break;
                    }
                    case 278: {
                        this.refresh();
                        break;
                    }
                    case 305: {
                        this.initialize();
                        break;
                    }
                    case 280: {
                        this.reset();
                        break;
                    }
                    case 5403: {
                        this.rotate(false, false);
                        break;
                    }
                    case 2162957: 
                    case 2165006: {
                        this.script(token.tok == 2165006);
                        break;
                    }
                    case 8554: {
                        this.history(1);
                        break;
                    }
                    case 798: {
                        this.select();
                        break;
                    }
                    case 4394: {
                        this.translate();
                        break;
                    }
                    case 5494: {
                        this.invertSelected();
                        break;
                    }
                    case 5495: {
                        this.rotate(false, true);
                        break;
                    }
                    case 4454: {
                        this.translateSelected();
                        break;
                    }
                    case 302: {
                        this.zap();
                        break;
                    }
                    case 5423: {
                        this.zoom(false);
                        break;
                    }
                    case 5424: {
                        this.zoom(true);
                        break;
                    }
                    case 316: {
                        this.delay();
                        break;
                    }
                    case 317: {
                        this.delay();
                        if (this.isSyntaxCheck) break;
                        this.pc = -1;
                        break;
                    }
                    case 373: {
                        this.gotocmd();
                        break;
                    }
                    case 4414: {
                        this.move();
                        break;
                    }
                    case 9067: {
                        this.display();
                        break;
                    }
                    case 847: {
                        this.hide();
                        break;
                    }
                    case 793: {
                        this.restrict();
                        break;
                    }
                    case 197487: {
                        this.subset();
                        break;
                    }
                    case 8553: {
                        this.setSelectionHalo(1);
                        break;
                    }
                    case 21791: {
                        this.set();
                        break;
                    }
                    case 5409: {
                        this.slab(false);
                        break;
                    }
                    case 5426: {
                        this.slab(true);
                        break;
                    }
                    case 307: {
                        this.star();
                        break;
                    }
                    case 328980: {
                        this.structure();
                        break;
                    }
                    case 341: {
                        this.halo();
                        break;
                    }
                    case 4387: {
                        this.spacefill();
                        break;
                    }
                    case 300: {
                        this.wireframe();
                        break;
                    }
                    case 4435: {
                        this.vector();
                        break;
                    }
                    case 5473: {
                        this.dipole();
                        break;
                    }
                    case 323: {
                        this.animation();
                        break;
                    }
                    case 4434: {
                        this.vibration();
                        break;
                    }
                    case 359: {
                        this.calculate();
                        break;
                    }
                    case 1290: {
                        this.dots(1, 7);
                        break;
                    }
                    case 8487: {
                        this.proteinShape(12);
                        break;
                    }
                    case 340: {
                        this.proteinShape(13);
                        break;
                    }
                    case 282: {
                        this.proteinShape(14);
                        break;
                    }
                    case 297: {
                        this.proteinShape(10);
                        break;
                    }
                    case 259: {
                        this.proteinShape(11);
                        break;
                    }
                    case 342: {
                        this.proteinShape(15);
                        break;
                    }
                    case 13632: {
                        this.rotate(true, false);
                        break;
                    }
                    case 8484: {
                        this.ssbond();
                        break;
                    }
                    case 73997: {
                        this.hbond(true);
                        break;
                    }
                    case 288: {
                        this.show();
                        break;
                    }
                    case 327944: {
                        this.file();
                        break;
                    }
                    case 324: 
                    case 327949: {
                        this.frame(1, false);
                        break;
                    }
                    case 334: {
                        this.frame(1, true);
                        break;
                    }
                    case 336: {
                        this.font();
                        break;
                    }
                    case 5464: {
                        this.moveto();
                        break;
                    }
                    case 5492: {
                        this.navigate();
                        break;
                    }
                    case 345: {
                        this.bondorder();
                        break;
                    }
                    case 346: {
                        this.console();
                        break;
                    }
                    case 347: {
                        this.pmesh();
                        break;
                    }
                    case 21855: {
                        this.draw();
                        break;
                    }
                    case 17756: {
                        this.polyhedra();
                        break;
                    }
                    case 1367: {
                        this.dots(1, 8);
                        break;
                    }
                    case 349: {
                        this.centerAt();
                        break;
                    }
                    case 21854: {
                        this.isosurface(26);
                        break;
                    }
                    case 17764: {
                        this.lcaoCartoon();
                        break;
                    }
                    case 20835: {
                        this.mo(false);
                        break;
                    }
                    case 20774: {
                        this.stereo();
                        break;
                    }
                    case 17671: {
                        this.connect();
                        break;
                    }
                    case 1376: {
                        this.getProperty();
                        break;
                    }
                    case 354: {
                        this.configuration();
                        break;
                    }
                    case 8560: {
                        this.setAxes(1);
                        break;
                    }
                    case 8561: {
                        this.setBoundbox(1);
                        break;
                    }
                    case 205170: {
                        this.setUnitcell(1);
                        break;
                    }
                    case 8563: {
                        this.setFrank(1);
                        break;
                    }
                    case 2318: {
                        this.help();
                        break;
                    }
                    case 284: {
                        this.save();
                        break;
                    }
                    case 360: {
                        this.restore();
                        break;
                    }
                    case 301: {
                        this.write();
                        break;
                    }
                    case 35091: {
                        this.pause();
                        break;
                    }
                    default: {
                        this.unrecognizedCommand();
                    }
                }
                if (!this.isSyntaxCheck) {
                    this.viewer.setCursor(0);
                }
            }
            ++this.pc;
        }
    }

    boolean ifCmd() throws ScriptException {
        return (Boolean)this.parameterExpression(1, null);
    }

    int getLinenumber() {
        return this.linenumbers[this.pc];
    }

    String getCommand() {
        int n = this.lineIndices[this.pc];
        int n2 = this.pc + 1 == this.lineIndices.length || this.lineIndices[this.pc + 1] == 0 ? this.script.length() : this.lineIndices[this.pc + 1];
        String string = "";
        try {
            string = this.script.substring(n, n2);
            int n3 = string.indexOf("\n");
            if (n3 >= 0) {
                string = string.substring(0, n3);
            }
            if ((n3 = string.indexOf("\r")) >= 0) {
                string = string.substring(0, n3);
            }
            if (!string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error((String)("darn problem in Eval getCommand: ichBegin=" + n + " ichEnd=" + n2 + " len = " + this.script.length() + " script = " + this.script + "\n" + exception));
        }
        return string;
    }

    void logDebugScript(int n) {
        this.strbufLog.setLength(0);
        if (this.logMessages) {
            Logger.debug((String)this.statement[0].toString());
            for (int i = 1; i < this.statementLength; ++i) {
                Logger.debug((String)this.statement[i].toString());
            }
        }
        this.iToken = -2;
        String string = n > 0 ? "                          ".substring(0, n * 2) : "";
        this.strbufLog.append(string).append(this.statementAsString());
        this.viewer.scriptStatus(this.strbufLog.toString());
    }

    BitSet expression(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.badArgumentCount();
        }
        return this.expression(this.statement, n, true, false, true);
    }

    BitSet expression(Token[] tokenArray, int n, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        this.isBondSet = false;
        if (tokenArray != this.statement) {
            this.tempStatement = this.statement;
            this.statement = tokenArray;
        }
        Rpn rpn = new Rpn(10);
        int n2 = Integer.MAX_VALUE;
        boolean bl4 = false;
        this.iToken = 1000;
        boolean bl5 = n < 0;
        boolean bl6 = false;
        int n3 = this.viewer.getAtomCount();
        if (bl5) {
            n = -n;
        }
        int n4 = n + 1;
        block35: for (int i = n; i < n4; ++i) {
            this.iToken = i;
            Token token = tokenArray[i];
            Object object = tokenArray[i].value;
            switch (token.tok) {
                case 65636: {
                    n = i;
                    n4 = tokenArray.length;
                    continue block35;
                }
                case 65637: {
                    break block35;
                }
                case 65539: {
                    Point3f point3f;
                    if (!this.isPoint3f(i) || (point3f = this.getPoint3f(i, true)) == null) continue block35;
                    rpn.addX(point3f);
                    i = this.iToken;
                    continue block35;
                }
                case 65540: {
                    continue block35;
                }
                case 0x110008: {
                    bl6 = true;
                    rpn.addOp(token);
                    continue block35;
                }
                case 0x110009: {
                    bl6 = false;
                    rpn.addOp(token);
                    continue block35;
                }
                case 1: {
                    Object object2 = this.viewer.getParameter((String)object);
                    if (object2 instanceof String) {
                        object2 = this.getStringObjectAsToken("" + object2);
                    }
                    if (object2 instanceof String) {
                        object2 = this.lookupIdentifierValue((String)object);
                    }
                    rpn.addX(object2);
                    continue block35;
                }
                case 798: {
                    rpn.addX(Eval.getAtomBitSet(this, this.viewer, (String)object));
                    continue block35;
                }
                case 4: {
                    rpn.addX(token);
                    Object object2 = (String)object;
                    if (object2.equals("plane")) {
                        rpn.addX(new Token(8, this.planeParameter(i + 2)));
                        i = this.iToken;
                        continue block35;
                    }
                    if (object2.equals("hkl")) {
                        rpn.addX(new Token(8, this.hklParameter(i + 2)));
                        i = this.iToken;
                        continue block35;
                    }
                    if (!object2.equals("coord")) continue block35;
                    rpn.addX(this.getPoint3f(i + 2, true));
                    i = this.iToken;
                    continue block35;
                }
                case 65547: 
                case 2162700: 
                case 2162729: 
                case 2162730: {
                    rpn.addOp(token);
                    continue block35;
                }
                case 65551: {
                    rpn.addX(BitSetUtil.setAll((int)n3));
                    continue block35;
                }
                case 65549: {
                    rpn.addX(new BitSet());
                    continue block35;
                }
                case 196611: {
                    rpn.addX(BitSetUtil.copy((BitSet)this.viewer.getSelectionSet()));
                    continue block35;
                }
                case 197487: {
                    rpn.addX(BitSetUtil.copy((BitSet)(this.bsSubset == null ? BitSetUtil.setAll((int)n3) : this.bsSubset)));
                    continue block35;
                }
                case 196628: {
                    rpn.addX(BitSetUtil.copy((BitSet)this.viewer.getHiddenSet()));
                    continue block35;
                }
                case 196629: {
                    rpn.addX(BitSetUtil.copyInvert((BitSet)this.viewer.getHiddenSet(), (int)n3));
                    continue block35;
                }
                case 196625: {
                    if (!this.isSyntaxCheck && !bl4) {
                        this.viewer.setModelVisibility();
                    }
                    bl4 = true;
                    rpn.addX(this.viewer.getVisibleSet());
                    continue block35;
                }
                case 196626: {
                    if (!this.isSyntaxCheck && bl) {
                        this.refresh();
                    }
                    rpn.addX(this.viewer.getClickableSet());
                    continue block35;
                }
                case 196614: 
                case 196615: 
                case 196616: 
                case 196617: 
                case 196618: 
                case 196619: 
                case 196627: 
                case 196630: 
                case 196631: 
                case 204801: 
                case 204802: 
                case 205170: {
                    rpn.addX(this.getAtomBits(((String)object).toLowerCase()));
                    continue block35;
                }
                case 65568: {
                    rpn.addX(this.viewer.getAtomBits("SpecAtom", (String)object));
                    continue block35;
                }
                case 65561: {
                    rpn.addX(this.viewer.getAtomBits("SpecName", (String)object));
                    continue block35;
                }
                case 65565: {
                    rpn.addX(this.getAtomBits("SpecAlternate", (String)object));
                    continue block35;
                }
                case 65566: 
                case 65567: {
                    int n5 = token.intValue;
                    if (n5 == Integer.MAX_VALUE) {
                        n5 = (Integer)object;
                        if (!this.viewer.haveFileSet()) {
                            rpn.addX(this.getAtomBits("SpecModel", n5));
                            continue block35;
                        }
                        n5 = n5 < 1000 ? (n5 *= 1000000) : n5 / 1000 * 1000000 + n5 % 1000;
                    }
                    rpn.addX(this.bitSetForModelNumberSet(new int[]{n5}, 1));
                    continue block35;
                }
                case 65560: {
                    rpn.addX(this.getAtomBits("SpecResid", token.intValue));
                    continue block35;
                }
                case 65564: {
                    rpn.addX(this.getAtomBits("SpecChain", token.intValue));
                    continue block35;
                }
                case 65562: {
                    if (bl6) {
                        rpn.addX(token.intValue);
                        continue block35;
                    }
                    rpn.addX(this.getAtomBits("SpecSeqcode", Eval.getSeqCode(token)));
                    continue block35;
                }
                case 65563: {
                    if (bl6) {
                        rpn.addX(token.intValue);
                        rpn.addX(Token.tokenMinus);
                        rpn.addX(tokenArray[++i].intValue);
                        continue block35;
                    }
                    rpn.addX(this.getAtomBits("SpecSeqcodeRange", new int[]{Eval.getSeqCode(token), Eval.getSeqCode(tokenArray[++i])}));
                    continue block35;
                }
                case 327685: {
                    Point3f point3f = (Point3f)object;
                    rpn.addX(this.getAtomBits("Cell", new int[]{(int)(point3f.x * 1000.0f), (int)(point3f.y * 1000.0f), (int)(point3f.z * 1000.0f)}));
                    continue block35;
                }
                case 196621: {
                    rpn.addX(this.viewer.getModelAtomBitSet(this.viewer.getCurrentModelIndex()));
                    continue block35;
                }
                case 196608: 
                case 196613: 
                case 196620: 
                case 196864: 
                case 204804: {
                    rpn.addX(this.lookupIdentifierValue((String)object));
                    continue block35;
                }
                case 5308456: 
                case 5308457: 
                case 5308458: 
                case 5308459: 
                case 5308460: 
                case 5308461: {
                    String string;
                    Object object2 = tokenArray[++i].value;
                    int n6 = token.tok;
                    int n7 = token.intValue;
                    String string2 = string = n7 == 860169 ? (String)object2 : null;
                    if (string != null) {
                        object2 = tokenArray[++i].value;
                    }
                    if (this.isSyntaxCheck) {
                        rpn.addX(new BitSet());
                        continue block35;
                    }
                    boolean bl7 = n7 == 327949;
                    boolean bl8 = n7 == 335889;
                    int n8 = tokenArray[i].tok;
                    n2 = tokenArray[i].intValue;
                    boolean bl9 = n8 == 1;
                    float f = Float.NaN;
                    if (bl9) {
                        if ((object2 = this.viewer.getParameter((String)object2)) instanceof Integer) {
                            n2 = (Integer)object2;
                            f = n2;
                        } else if (object2 instanceof Float && bl7) {
                            n2 = Mmset.modelFileNumberFromFloat(((Float)object2).floatValue());
                        }
                    }
                    if (object2 instanceof Integer || n8 == 2) {
                        f = n2 *= Compiler.tokAttr(n7, 327712) ? 100 : 1;
                        if (bl7 && this.viewer.haveFileSet() && n2 >= 1000 && n2 < 1000000) {
                            n2 = n2 / 1000 * 1000000 + n2 % 1000;
                            n7 = -327949;
                        }
                    } else if (object2 instanceof Float) {
                        if (bl7) {
                            n7 = -327949;
                        } else {
                            f = ((Float)object2).floatValue();
                            n2 = (int)(f * (bl8 ? 250.0f : 100.0f));
                        }
                    } else {
                        this.invalidArgument();
                    }
                    if (bl7 && n2 >= 1000000 && n2 % 1000000 == 0) {
                        n2 /= 1000000;
                        n7 = 327944;
                    }
                    if (((String)object).indexOf("-") >= 0) {
                        n2 = -n2;
                    }
                    float[] fArray = n7 == 860169 ? Viewer.getDataFloat(string) : null;
                    rpn.addX(this.comparatorInstruction(token, n7, fArray, n6, n2, f));
                    continue block35;
                }
                case 3: 
                case 7: 
                case 8: 
                case 32839: {
                    rpn.addX(object);
                    continue block35;
                }
                case 2: {
                    rpn.addX(token.intValue);
                    continue block35;
                }
                default: {
                    if (Compiler.tokAttr(token.tok, 0x110000)) {
                        rpn.addOp(token);
                        continue block35;
                    }
                    this.unrecognizedExpression();
                }
            }
        }
        this.expressionResult = rpn.getResult(bl2);
        if (this.expressionResult == null) {
            if (bl2) {
                return null;
            }
            if (!this.isSyntaxCheck) {
                rpn.dumpStacks();
            }
            this.endOfStatementUnexpected();
        }
        if (!bl3 && !(this.expressionResult.value instanceof BitSet)) {
            return null;
        }
        BitSet bitSet = this.expressionResult.value instanceof BitSet ? (BitSet)this.expressionResult.value : new BitSet();
        this.isBondSet = this.expressionResult.value instanceof Bond.BondSet;
        if (!bl5 && this.bsSubset != null && !this.isBondSet) {
            bitSet.and(this.bsSubset);
        }
        if (this.tempStatement != null) {
            this.statement = this.tempStatement;
            this.tempStatement = null;
        }
        return bitSet;
    }

    static int getSeqCode(Token token) {
        return token.intValue != Integer.MAX_VALUE ? Group.getSeqcode(token.intValue, ' ') : (Integer)token.value;
    }

    BitSet lookupIdentifierValue(String string) throws ScriptException {
        BitSet bitSet = this.lookupValue(string, false);
        if (bitSet != null) {
            return BitSetUtil.copy((BitSet)bitSet);
        }
        bitSet = this.getAtomBits("IdentifierOrNull", string);
        return bitSet == null ? new BitSet() : bitSet;
    }

    BitSet getAtomBits(String string) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(string);
    }

    BitSet getAtomBits(String string, String string2) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(string, string2);
    }

    BitSet getAtomBits(String string, int n) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(string, n);
    }

    BitSet getAtomBits(String string, int[] nArray) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(string, nArray);
    }

    BitSet lookupValue(String string, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        Object object = this.variables.get(string);
        boolean bl2 = false;
        if (object == null) {
            object = this.variables.get("!" + string);
            boolean bl3 = bl2 = object != null;
        }
        if (object != null) {
            if (object instanceof Token[]) {
                this.pushContext();
                object = this.expression((Token[])object, -2, true, false, true);
                this.popContext();
                if (!bl2) {
                    this.variables.put(string, object);
                }
            }
            return (BitSet)object;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    BitSet comparatorInstruction(Token token, int n, float[] fArray, int n2, int n3, float f) throws ScriptException {
        BitSet bitSet = new BitSet();
        int n4 = Integer.MAX_VALUE;
        BitSet bitSet2 = null;
        int n5 = n2;
        int n6 = n3;
        int n7 = this.viewer.getAtomCount();
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        int[] nArray = null;
        int n11 = 0;
        float f2 = 0.0f;
        ModelSet modelSet = this.viewer.getModelSet();
        block28: for (int i = 0; i < n7; ++i) {
            int n12;
            boolean bl = false;
            Atom atom = modelSet.getAtomAt(i);
            switch (n) {
                default: {
                    n4 = (int)this.atomProperty(modelSet, atom, n, true);
                    if (n4 != Integer.MAX_VALUE) break;
                    continue block28;
                }
                case 860169: {
                    if (fArray == null || fArray.length <= i) continue block28;
                    f2 = fArray[i];
                    switch (n2) {
                        case 5308459: {
                            bl = f2 < f;
                            break;
                        }
                        case 5308458: {
                            bl = f2 <= f;
                            break;
                        }
                        case 5308457: {
                            bl = f2 >= f;
                            break;
                        }
                        case 5308456: {
                            bl = f2 > f;
                            break;
                        }
                        case 5308460: {
                            bl = f2 == f;
                            break;
                        }
                        case 5308461: {
                            boolean bl2 = bl = f2 != f;
                        }
                    }
                    if (!bl) continue block28;
                    bitSet.set(i);
                    continue block28;
                }
                case 327701: {
                    bitSet2 = atom.getAtomSymmetry();
                    if (n6 < 1000) break;
                    n3 = n6 % 1000;
                    if (atom.getModelIndex() != n10) {
                        n10 = atom.getModelIndex();
                        nArray = modelSet.getModelCellRange(n10);
                        n11 = modelSet.getModelSymmetryCount(n10);
                    }
                    n12 = n6 / 1000 - 1;
                    if (n11 == 0 || n12 < 0 || !(bl = bitSet2.get(n12))) continue block28;
                    n5 = 65549;
                    n4 = atom.getSymmetryTranslation(n12, nArray, n11);
                }
            }
            if (bitSet2 != null) {
                switch (n5) {
                    case 5308459: {
                        n8 = n3 - 1;
                        n9 = 0;
                        break;
                    }
                    case 5308458: {
                        n8 = n3;
                        n9 = 0;
                        break;
                    }
                    case 5308457: {
                        n8 = bitSet2.size();
                        n9 = n3 - 1;
                        break;
                    }
                    case 5308456: {
                        n8 = bitSet2.size();
                        n9 = n3;
                        break;
                    }
                    case 5308460: {
                        n8 = n3;
                        n9 = n3 - 1;
                        break;
                    }
                    case 5308461: {
                        boolean bl3 = bl = !bitSet2.get(n3);
                    }
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                if (n8 > bitSet2.size()) {
                    n8 = bitSet2.size();
                }
                for (n12 = n9; n12 < n8; ++n12) {
                    if (!bitSet2.get(n12)) continue;
                    bl = true;
                    break;
                }
                if (!bl || n4 == Integer.MAX_VALUE) {
                    n2 = 65549;
                }
            }
            switch (n2) {
                case 5308459: {
                    bl = n4 < n3;
                    break;
                }
                case 5308458: {
                    bl = n4 <= n3;
                    break;
                }
                case 5308457: {
                    bl = n4 >= n3;
                    break;
                }
                case 5308456: {
                    bl = n4 > n3;
                    break;
                }
                case 5308460: {
                    bl = n4 == n3;
                    break;
                }
                case 5308461: {
                    boolean bl4 = bl = n4 != n3;
                }
            }
            if (!bl) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    float atomProperty(ModelSet modelSet, Atom atom, int n, boolean bl) throws ScriptException {
        float f = 0.0f;
        switch (n) {
            case 327681: {
                return atom.getAtomNumber();
            }
            case 327684: {
                return atom.getAtomIndex();
            }
            case 327687: {
                return atom.getElementNumber();
            }
            case 327686: {
                return atom.getAtomicAndIsotopeNumber();
            }
            case 335881: {
                return atom.getFormalCharge();
            }
            case 327718: {
                f = atom.getPartialCharge();
                return bl ? f * 100.0f : f;
            }
            case 327699: {
                return atom.getAtomSite();
            }
            case 327694: {
                return atom.getMoleculeNumber();
            }
            case 327722: {
                f = atom.getBfactor100();
                return f < 0.0f ? 2.1474836E9f : (bl ? f : f / 100.0f);
            }
            case 327721: {
                modelSet.getSurfaceDistanceMax();
                f = atom.getSurfaceDistance100();
                return bl ? f : f / 100.0f;
            }
            case 327695: {
                return atom.getOccupancy();
            }
            case 327696: {
                return atom.getPolymerLength();
            }
            case 327698: {
                return atom.getResno();
            }
            case 327690: {
                f = atom.getGroupID();
                return f < 0.0f ? 2.1474836E9f : f;
            }
            case 327682: {
                return atom.getSpecialAtomID();
            }
            case 328980: {
                return atom.getProteinStructureType();
            }
            case 335889: {
                return atom.getRasMolRadius();
            }
            case 327702: {
                return (float)(bl ? 100 : 1) * atom.getVanderwaalsRadiusFloat();
            }
            case 327720: {
                f = atom.getGroupPsi();
                return bl ? f * 100.0f : f;
            }
            case 327719: {
                f = atom.getGroupPhi();
                return bl ? f * 100.0f : f;
            }
            case 327683: {
                return atom.getCovalentBondCount();
            }
            case 327944: {
                return atom.getModelFileIndex() + 1;
            }
            case 327949: {
                return atom.getModelNumber() % 1000000;
            }
            case -327949: {
                return atom.getModelFileNumber();
            }
            case 327712: {
                f = ((Tuple3f)atom).x;
                return bl ? f * 100.0f : f;
            }
            case 327713: {
                f = ((Tuple3f)atom).y;
                return bl ? f * 100.0f : f;
            }
            case 327714: {
                f = ((Tuple3f)atom).z;
                return bl ? f * 100.0f : f;
            }
            case 327715: {
                f = atom.getFractionalCoord('X');
                return bl ? f * 100.0f : f;
            }
            case 327716: {
                f = atom.getFractionalCoord('Y');
                return bl ? f * 100.0f : f;
            }
            case 327717: {
                f = atom.getFractionalCoord('Z');
                return bl ? f * 100.0f : f;
            }
        }
        this.unrecognizedAtomProperty(Token.nameOf(n));
        return 0.0f;
    }

    void checkStatementLength(int n) throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength != n) {
            this.badArgumentCount();
        }
    }

    void checkLength34() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength < 3 || this.statementLength > 4) {
            this.badArgumentCount();
        }
    }

    int checkLength23() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength < 2 || this.statementLength > 3) {
            this.badArgumentCount();
        }
        return this.statementLength;
    }

    void checkLength2() throws ScriptException {
        this.checkStatementLength(2);
    }

    void checkLength3() throws ScriptException {
        this.checkStatementLength(3);
    }

    void checkLength4() throws ScriptException {
        this.checkStatementLength(4);
    }

    int modelNumberParameter(int n) {
        int n2 = 0;
        boolean bl = false;
        switch (this.tokAt(n)) {
            case 2: {
                bl = true;
            }
            case 3: {
                n2 = this.statement[n].intValue;
                break;
            }
            default: {
                return -1;
            }
        }
        return this.viewer.getModelNumberIndex(n2, bl);
    }

    String optParameterAsString(int n) throws ScriptException {
        if (n >= this.statementLength) {
            return "";
        }
        return this.parameterAsString(n);
    }

    String parameterAsString(int n) throws ScriptException {
        this.getToken(n);
        if (this.theToken == null) {
            this.endOfStatementUnexpected();
        }
        return this.theTok == 2 ? "" + this.theToken.intValue : "" + this.theToken.value;
    }

    int intParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 2) {
            return this.theToken.intValue;
        }
        return this.integerExpected();
    }

    boolean isFloatParameter(int n) {
        switch (this.tokAt(n)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    float floatParameter(int n) throws ScriptException {
        if (this.checkToken(n)) {
            this.getToken(n);
            switch (this.theTok) {
                case 2: 
                case 65562: {
                    return this.theToken.intValue;
                }
                case 3: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        return this.numberExpected();
    }

    int floatParameterSet(int n, float[] fArray) throws ScriptException {
        if (this.tokAt(n) == 65539) {
            ++n;
        }
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.floatParameter(n++);
        }
        if (this.tokAt(n) == 65540) {
            ++n;
        }
        return n;
    }

    String stringParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 4) {
            return (String)this.theToken.value;
        }
        return this.stringExpected();
    }

    String objectNameParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 1) {
            return this.parameterAsString(n);
        }
        return this.objectNameExpected();
    }

    float radiusParameter(int n, float f) throws ScriptException {
        boolean bl;
        if (!this.checkToken(n)) {
            if (Float.isNaN(f)) {
                this.numberExpected();
            }
            return f;
        }
        this.getToken(n);
        float f2 = Float.NaN;
        boolean bl2 = bl = this.theTok == 0x110031;
        if (bl) {
            ++n;
        }
        boolean bl3 = this.tokAt(n + 1) == 1114170;
        switch (this.tokAt(n)) {
            case 2: {
                f2 = this.intParameter(n);
            }
            case 3: {
                if (Float.isNaN(f2)) {
                    f2 = this.floatParameter(n);
                }
                if (!(f2 < 0.0f)) break;
                bl = true;
                break;
            }
            default: {
                f2 = f;
                --n;
            }
        }
        this.iToken = n + (bl3 ? 1 : 0);
        if (Float.isNaN(f2)) {
            this.numberExpected();
        }
        if (f2 == 0.0f) {
            return 0.0f;
        }
        if (bl3) {
            if (f2 <= -100.0f) {
                this.invalidArgument();
            }
            f2 += (float)(bl ? 200 : 100);
        } else if (!bl) {
            if (f2 < 0.0f || f2 > 10.0f) {
                this.numberOutOfRange(0.0f, 10.0f);
            }
            f2 += 10.0f;
        }
        return f2;
    }

    int setShapeByNameParameter(int n) throws ScriptException {
        String string = this.objectNameParameter(n);
        int n2 = this.viewer.getShapeIdFromObjectName(string);
        if (!this.isSyntaxCheck && n2 < 0) {
            this.objectNameExpected();
        }
        this.setShapeProperty(n2, "thisID", string);
        return n2;
    }

    float getRasmolAngstroms(int n) throws ScriptException {
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 2: {
                    return (float)this.intParameter(n) / 250.0f;
                }
                case 3: {
                    return this.floatParameter(n);
                }
            }
        }
        return this.numberExpected();
    }

    boolean booleanParameter(int n) throws ScriptException {
        if (this.statementLength == n) {
            return true;
        }
        this.checkStatementLength(n + 1);
        switch (this.getToken((int)n).tok) {
            case 32769: {
                return true;
            }
            case 32768: {
                return false;
            }
        }
        this.booleanExpected();
        return false;
    }

    Point3f atomCenterOrCoordinateParameter(int n) throws ScriptException {
        switch (this.getToken((int)n).tok) {
            case 32839: 
            case 65636: {
                BitSet bitSet = this.expression(this.statement, n, true, false, false);
                if (bitSet != null) {
                    return this.viewer.getAtomSetCenter(bitSet);
                }
                if (this.expressionResult.value instanceof Point3f) {
                    return (Point3f)this.expressionResult.value;
                }
                this.invalidArgument();
            }
            case 7: 
            case 65539: {
                return this.getPoint3f(n, true);
            }
        }
        this.invalidArgument();
        return null;
    }

    boolean isCenterParameter(int n) {
        int n2 = this.tokAt(n);
        return n2 == 65541 || n2 == 65539 || n2 == 65636 || n2 == 7 || n2 == 32839;
    }

    Point3f centerParameter(int n) throws ScriptException {
        Point3f point3f = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 65541: {
                    String string = this.objectNameParameter(++n);
                    if (this.tokAt(n + 1) == 0x110008) {
                        string = string + "." + this.intParameter(n + 2);
                        if (this.getToken((int)(n + 3)).tok != 0x110009) {
                            this.invalidArgument();
                        }
                    }
                    if (this.isSyntaxCheck) {
                        return new Point3f();
                    }
                    point3f = this.getDrawObjectCenter(string);
                    if (point3f != null) break;
                    this.drawObjectNotDefined(string);
                    break;
                }
                case 7: 
                case 32839: 
                case 65539: 
                case 65636: {
                    point3f = this.atomCenterOrCoordinateParameter(n);
                }
            }
        }
        if (point3f == null) {
            this.coordinateOrNameOrExpressionRequired();
        }
        return point3f;
    }

    Point4f planeParameter(int n) throws ScriptException {
        block26: {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            if (n >= this.statementLength) break block26;
            switch (this.getToken((int)n).tok) {
                case 8: {
                    return (Point4f)this.theToken.value;
                }
                case 65541: {
                    String string = this.objectNameParameter(++n);
                    if (this.isSyntaxCheck) {
                        return new Point4f();
                    }
                    int n2 = this.viewer.getShapeIdFromObjectName(string);
                    switch (n2) {
                        case 28: {
                            this.setShapeProperty(28, "thisID", string);
                            Point3f[] point3fArray = (Point3f[])this.viewer.getShapeProperty(28, "vertices");
                            if (point3fArray != null) {
                                if (point3fArray.length < 3) break;
                                Vector3f vector3f3 = new Vector3f();
                                float f = Graphics3D.getNormalThroughPoints((Point3f)point3fArray[0], (Point3f)point3fArray[1], (Point3f)point3fArray[2], (Vector3f)vector3f3, (Vector3f)vector3f, (Vector3f)vector3f2);
                                return new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                            }
                            break block26;
                        }
                        case 26: {
                            this.setShapeProperty(26, "thisID", string);
                            Point4f point4f = (Point4f)this.viewer.getShapeProperty(26, "plane");
                            if (point4f != null) {
                                return point4f;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 1: 
                case 4: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("xy")) {
                        return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("xz")) {
                        return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("yz")) {
                        return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    if (string.equalsIgnoreCase("x")) {
                        if (!this.checkToken(++n) || this.getToken((int)n++).tok != 5308460) {
                            this.evalError("x=?");
                        }
                        return new Point4f(1.0f, 0.0f, 0.0f, -this.floatParameter(n));
                    }
                    if (string.equalsIgnoreCase("y")) {
                        if (!this.checkToken(++n) || this.getToken((int)n++).tok != 5308460) {
                            this.evalError("y=?");
                        }
                        return new Point4f(0.0f, 1.0f, 0.0f, -this.floatParameter(n));
                    }
                    if (!string.equalsIgnoreCase("z")) break;
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 5308460) {
                        this.evalError("z=?");
                    }
                    return new Point4f(0.0f, 0.0f, 1.0f, -this.floatParameter(n));
                }
                case 65539: {
                    if (!this.isPoint3f(n)) {
                        return this.getPoint4f(n);
                    }
                }
                case 32839: 
                case 65636: {
                    Point3f point3f = this.atomCenterOrCoordinateParameter(n);
                    if (this.getToken((int)(++this.iToken)).tok == 65547) {
                        ++this.iToken;
                    }
                    Point3f point3f2 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 65547) {
                        ++this.iToken;
                    }
                    Point3f point3f3 = this.atomCenterOrCoordinateParameter(this.iToken);
                    n = this.iToken;
                    Vector3f vector3f4 = new Vector3f();
                    float f = Graphics3D.getNormalThroughPoints((Point3f)point3f, (Point3f)point3f2, (Point3f)point3f3, (Vector3f)vector3f4, (Vector3f)vector3f, (Vector3f)vector3f2);
                    Point4f point4f = new Point4f(vector3f4.x, vector3f4.y, vector3f4.z, f);
                    if (Logger.isActiveLevel((int)0)) {
                        Logger.debug((String)("points: " + point3f + point3f2 + point3f3 + " defined plane: " + point4f));
                    }
                    return point4f;
                }
            }
        }
        this.evalError(GT._((String)"plane expected -- either three points or atom expressions or {0} or {1} or {2}", (Object[])new Object[]{"{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx"}));
        return null;
    }

    Point4f hklParameter(int n) throws ScriptException {
        Point3f point3f = this.viewer.getCurrentUnitCellOffset();
        if (point3f == null) {
            if (this.isSyntaxCheck) {
                point3f = new Point3f();
            } else {
                this.evalError(GT._((String)"No unit cell"));
            }
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f point3f2 = (Point3f)this.getPointOrPlane(n, false, true, false, true, 3, 3);
        Point3f point3f3 = new Point3f(point3f2.x == 0.0f ? 1.0f : 1.0f / point3f2.x, 0.0f, 0.0f);
        Point3f point3f4 = new Point3f(0.0f, point3f2.y == 0.0f ? 1.0f : 1.0f / point3f2.y, 0.0f);
        Point3f point3f5 = new Point3f(0.0f, 0.0f, point3f2.z == 0.0f ? 1.0f : 1.0f / point3f2.z);
        if (point3f2.x == 0.0f && point3f2.y == 0.0f && point3f2.z == 0.0f) {
            this.evalError(GT._((String)"Miller indices cannot all be zero."));
        } else if (point3f2.x == 0.0f && point3f2.y == 0.0f) {
            point3f3.set(1.0f, 0.0f, point3f5.z);
            point3f4.set(0.0f, 1.0f, point3f5.z);
        } else if (point3f2.y == 0.0f && point3f2.z == 0.0f) {
            point3f4.set(point3f3.x, 0.0f, 1.0f);
            point3f5.set(point3f3.x, 1.0f, 0.0f);
        } else if (point3f2.z == 0.0f && point3f2.x == 0.0f) {
            point3f5.set(0.0f, point3f4.y, 1.0f);
            point3f3.set(1.0f, point3f4.y, 0.0f);
        } else if (point3f2.x == 0.0f) {
            point3f3.set(1.0f, point3f4.y, 0.0f);
        } else if (point3f2.y == 0.0f) {
            point3f4.set(0.0f, 1.0f, point3f5.z);
        } else if (point3f2.z == 0.0f) {
            point3f5.set(point3f3.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(point3f3);
        this.viewer.toCartesian(point3f4);
        this.viewer.toCartesian(point3f5);
        point3f3.add((Tuple3f)point3f);
        point3f4.add((Tuple3f)point3f);
        point3f5.add((Tuple3f)point3f);
        Vector3f vector3f3 = new Vector3f();
        float f = Graphics3D.getNormalThroughPoints((Point3f)point3f3, (Point3f)point3f4, (Point3f)point3f5, (Vector3f)vector3f3, (Vector3f)vector3f, (Vector3f)vector3f2);
        Point4f point4f = new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
        Logger.info((String)("defined plane: " + point4f));
        return point4f;
    }

    short getMadParameter() throws ScriptException {
        short s = 1;
        switch (this.getToken((int)1).tok) {
            case 32769: {
                break;
            }
            case 32768: {
                s = 0;
                break;
            }
            case 2: {
                s = this.getMadInteger(this.intParameter(1));
                break;
            }
            case 3: {
                s = this.getMadFloat(this.floatParameter(1));
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        return s;
    }

    short getMadInteger(int n) throws ScriptException {
        if (n < 0 || n > 750) {
            this.numberOutOfRange(0, 750);
        }
        return (short)(n * 4 * 2);
    }

    short getMadFloat(float f) throws ScriptException {
        if (f < 0.0f || f > 3.0f) {
            this.numberOutOfRange(0.0f, 3.0f);
        }
        return (short)(f * 1000.0f * 2.0f);
    }

    short getSetAxesTypeMad(int n) throws ScriptException {
        this.checkStatementLength(n + 1);
        short s = 0;
        switch (this.getToken((int)n).tok) {
            case 32769: {
                s = 1;
            }
            case 32768: {
                break;
            }
            case 2: {
                int n2 = this.intParameter(n);
                if (n2 < -1 || n2 >= 20) {
                    this.numberOutOfRange(-1, 19);
                }
                s = (short)n2;
                break;
            }
            case 3: {
                float f = this.floatParameter(n);
                if (f < 0.0f || f >= 2.0f) {
                    this.numberOutOfRange(0.01f, 1.99f);
                }
                s = (short)(f * 1000.0f * 2.0f);
                break;
            }
            case 32798: {
                s = -1;
                break;
            }
            default: {
                this.booleanOrNumberExpected("DOTTED");
            }
        }
        return s;
    }

    boolean isColorParam(int n) {
        int n2 = this.tokAt(n);
        return n2 == 49172 || n2 == 0x110008;
    }

    int getArgbParam(int n) throws ScriptException {
        return this.getArgbParam(n, false);
    }

    int getArgbParamLast(int n, boolean bl) throws ScriptException {
        int n2 = this.getArgbParam(n, bl);
        this.checkStatementLength(this.iToken + 1);
        return n2;
    }

    int getArgbParam(int n, boolean bl) throws ScriptException {
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 4: {
                    return Graphics3D.getArgbFromString((String)this.parameterAsString(n));
                }
                case 0x110008: {
                    return this.getColorTriad(++n);
                }
                case 49172: {
                    return this.theToken.intValue;
                }
                case 65549: {
                    if (!bl) break;
                    return 0;
                }
            }
        }
        this.colorExpected();
        return 0;
    }

    int getArgbOrPaletteParam(int n) throws ScriptException {
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 49172: 
                case 0x110008: {
                    return this.getArgbParam(n);
                }
                case 32773: {
                    return 32773;
                }
                case 32814: 
                case 65549: {
                    return 32814;
                }
            }
        }
        this.evalError(GT._((String)"a color or palette name (Jmol, Rasmol) is required"));
        return 0;
    }

    int getColorTriad(int n) throws ScriptException {
        int[] nArray = new int[3];
        int n2 = 0;
        this.getToken(n);
        switch (this.theTok) {
            case 2: {
                while (n < this.statementLength) {
                    this.getToken(n);
                    switch (this.theTok) {
                        case 65547: {
                            break;
                        }
                        case 2: {
                            if (n2 > 2) {
                                this.badRGBColor();
                            }
                            nArray[n2++] = this.theToken.intValue;
                            break;
                        }
                        case 65562: {
                            if (n2 > 2) {
                                this.badRGBColor();
                            }
                            nArray[n2++] = (Integer)this.theToken.value;
                            break;
                        }
                        case 0x110009: {
                            if (n2 == 3) {
                                return 0xFF000000 | nArray[0] << 16 | nArray[1] << 8 | nArray[2];
                            }
                        }
                        default: {
                            this.badRGBColor();
                        }
                    }
                    ++n;
                }
                this.badRGBColor();
            }
            case 7: {
                Point3f point3f = (Point3f)this.theToken.value;
                if (this.getToken((int)(++n)).tok != 0x110009) {
                    this.badRGBColor();
                }
                return 0xFF000000 | (int)point3f.x << 16 | (int)point3f.y << 8 | (int)point3f.z;
            }
            case 1: {
                String string = this.parameterAsString(n);
                if (this.getToken((int)(++n)).tok != 0x110009 || string.length() != 7 || string.charAt(0) != 'x') break;
                try {
                    return 0xFF000000 | Integer.parseInt(string.substring(1), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    this.badRGBColor();
                }
            }
        }
        this.badRGBColor();
        return 0;
    }

    boolean isPoint3f(int n) {
        this.ignoreError = true;
        boolean bl = true;
        try {
            this.getPoint3f(n, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.ignoreError = false;
        return bl;
    }

    Point3f getPoint3f(int n, boolean bl) throws ScriptException {
        return (Point3f)this.getPointOrPlane(n, false, bl, true, false, 3, 3);
    }

    Point4f getPoint4f(int n) throws ScriptException {
        return (Point4f)this.getPointOrPlane(n, false, false, false, false, 4, 4);
    }

    Object getPointOrPlane(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) throws ScriptException {
        float[] fArray = new float[6];
        int n4 = 0;
        this.coordinatesAreFractional = bl4;
        if (this.tokAt(n) == 7) {
            if (n2 <= 3 && n3 >= 3) {
                return (Point3f)this.getToken((int)n).value;
            }
            this.invalidArgument();
        }
        if (this.tokAt(n) == 8) {
            if (n2 <= 4 && n3 >= 4) {
                return (Point4f)this.getToken((int)n).value;
            }
            this.invalidArgument();
        }
        int n5 = 1;
        block9: for (int i = n; i < this.statement.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 65539: 
                case 65547: 
                case 0x110018: {
                    continue block9;
                }
                case 65540: {
                    break block9;
                }
                case 65563: {
                    if (n4 == 6) {
                        this.invalidArgument();
                    }
                    fArray[n4++] = this.theToken.intValue;
                    n5 = -1;
                    continue block9;
                }
                case 2: 
                case 65562: {
                    if (n4 == 6) {
                        this.invalidArgument();
                    }
                    fArray[n4++] = this.theToken.intValue * n5;
                    n5 = 1;
                    continue block9;
                }
                case 1114168: {
                    this.getToken(++i);
                }
                case 65566: {
                    if (--n4 < 0 || bl) {
                        this.invalidArgument();
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else {
                        int n7 = n4++;
                        fArray[n7] = fArray[n7] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block9;
                }
                case 3: 
                case 65567: {
                    if (bl) {
                        this.invalidArgument();
                    }
                    if (n4 == 6) {
                        this.invalidArgument();
                    }
                    fArray[n4++] = ((Float)this.theToken.value).floatValue();
                    continue block9;
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.invalidArgument();
        }
        if (n4 == 3) {
            Point3f point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
            if (this.coordinatesAreFractional && bl3 && !this.isSyntaxCheck) {
                this.viewer.toCartesian(point3f);
            }
            return point3f;
        }
        if (n4 == 4) {
            if (this.coordinatesAreFractional) {
                this.invalidArgument();
            }
            Point4f point4f = new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
            return point4f;
        }
        return fArray;
    }

    Token getToken(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.endOfStatementUnexpected();
        }
        this.theToken = this.statement[n];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    int tokAt(int n) {
        return n < this.statementLength ? this.statement[n].tok : 0;
    }

    boolean checkToken(int n) {
        this.iToken = n;
        return this.iToken < this.statementLength;
    }

    void help() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.statementLength == 1 ? "" : this.parameterAsString(1);
        Token token = Token.getTokenFromName(string);
        if (token != null && (token.tok & 0x100) != 0) {
            string = "?command=" + string;
        }
        this.viewer.getHelp(string);
    }

    void move() throws ScriptException {
        int n;
        if (this.statementLength > 11) {
            this.badArgumentCount();
        }
        Vector3f vector3f = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        Vector3f vector3f2 = new Vector3f((float)this.intParameter(5), (float)this.intParameter(6), (float)this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.statementLength == 11 ? this.intParameter(10) : 30;
        if (this.isSyntaxCheck) {
            return;
        }
        this.refresh();
        this.viewer.move(vector3f, f, vector3f2, f2, f3, n);
    }

    void moveto() throws ScriptException {
        float f;
        float f2;
        float f3;
        if (this.statementLength == 2 && this.isFloatParameter(1)) {
            float f4 = this.floatParameter(1);
            if (this.isSyntaxCheck) {
                return;
            }
            if (f4 > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(f4, null, new Point3f(0.0f, 0.0f, 1.0f), 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        Point3f point3f = new Point3f();
        Point3f point3f2 = null;
        int n = 1;
        float f5 = f3 = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        if (f3 < 0.0f) {
            this.invalidArgument();
        }
        float f6 = Float.NaN;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 90.0f;
        switch (this.getToken((int)n).tok) {
            case 7: 
            case 65539: {
                if (this.isPoint3f(n)) {
                    point3f = this.getPoint3f(n, true);
                    n = this.iToken + 1;
                    f9 = this.floatParameter(n++);
                    break;
                }
                Point4f point4f = this.getPoint4f(n);
                n = this.iToken + 1;
                point3f.set(point4f.x, point4f.y, point4f.z);
                f9 = point4f.w;
                break;
            }
            case 32835: {
                point3f.set(1.0f, 0.0f, 0.0f);
                f9 = 0.0f;
                ++n;
                break;
            }
            case 32836: {
                point3f.set(0.0f, 1.0f, 0.0f);
                f9 = 180.0f;
                ++n;
                break;
            }
            case 32833: {
                point3f.set(0.0f, 1.0f, 0.0f);
                ++n;
                break;
            }
            case 32834: {
                point3f.set(0.0f, -1.0f, 0.0f);
                ++n;
                break;
            }
            case 32837: {
                point3f.set(1.0f, 0.0f, 0.0f);
                ++n;
                break;
            }
            case 32838: {
                point3f.set(-1.0f, 0.0f, 0.0f);
                ++n;
                break;
            }
            default: {
                point3f = new Point3f(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f9 = this.floatParameter(n++);
            }
        }
        boolean bl = !this.viewer.isInPosition(point3f, f9);
        float f10 = this.viewer.getZoomPercentFloat();
        if (n != this.statementLength && !this.isCenterParameter(n)) {
            f6 = this.floatParameter(n++);
        }
        if (n != this.statementLength && !this.isCenterParameter(n)) {
            f7 = this.floatParameter(n++);
            f8 = this.floatParameter(n++);
            if (!bl && Math.abs(f7 - this.viewer.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f8 - this.viewer.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        float f11 = 0.0f;
        if (n != this.statementLength) {
            int n2 = n;
            point3f2 = this.centerParameter(n);
            if (!bl && (double)point3f2.distance(this.viewer.getRotationCenter()) >= 0.1) {
                bl = true;
            }
            n = this.iToken + 1;
            f2 = this.viewer.getRotationRadius();
            if (n != this.statementLength && !this.isCenterParameter(n)) {
                if (f6 == 0.0f || Float.isNaN(f6)) {
                    f = Math.abs(this.getZoomFactor(n, n2, f2, f10));
                    n = this.iToken + 1;
                    if (Float.isNaN(f)) {
                        this.invalidArgument();
                    }
                    f6 = f;
                } else {
                    f11 = this.floatParameter(n++);
                    if (!bl && (double)Math.abs(f11 - this.viewer.getRotationRadius()) >= 0.1) {
                        bl = true;
                    }
                }
            }
        }
        if (f6 == 0.0f || Float.isNaN(f6)) {
            f6 = 100.0f;
        }
        if (!bl && Math.abs(f6 - f10) >= 1.0f) {
            bl = true;
        }
        Point3f point3f3 = null;
        f2 = Float.NaN;
        f = Float.NaN;
        float f12 = Float.NaN;
        if (n != this.statementLength) {
            point3f3 = this.centerParameter(n);
            n = this.iToken + 1;
            if (n != this.statementLength) {
                f2 = this.floatParameter(n++);
                f = this.floatParameter(n++);
            }
            if (n != this.statementLength) {
                f12 = this.floatParameter(n++);
            }
        }
        if (n != this.statementLength) {
            this.badArgumentCount();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (!bl) {
            f3 = 0.0f;
        }
        if (f3 > 0.0f) {
            this.refresh();
        }
        this.viewer.moveTo(f3, point3f2, point3f, f9, f6, f7, f8, f11, point3f3, f2, f, f12);
    }

    void navigate() throws ScriptException {
        if (this.statementLength == 1) {
            this.setBooleanProperty("navigationMode", true);
            return;
        }
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 32768: 
                case 32769: {
                    this.setBooleanProperty("navigationMode", this.theTok == 32769);
                }
            }
            this.invalidArgument();
            return;
        }
        if (!this.viewer.getNavigationMode()) {
            this.setBooleanProperty("navigationMode", true);
        }
        block16: for (int i = 1; i < this.statementLength; ++i) {
            float f;
            float f2 = f = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (f < 0.0f) {
                this.invalidArgument();
            }
            if (!this.isSyntaxCheck && f > 0.0f) {
                this.refresh();
            }
            switch (this.getToken((int)i).tok) {
                case 5426: {
                    float f3 = this.floatParameter(++i);
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.setNavigationDepthPercent(f, f3);
                    continue block16;
                }
                case 772: {
                    Point3f point3f = this.centerParameter(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navigate(f, point3f);
                    continue block16;
                }
                case 5403: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1: {
                            String string = this.parameterAsString(i++);
                            if (string.equalsIgnoreCase("x")) {
                                vector3f.set(1.0f, 0.0f, 0.0f);
                                break;
                            }
                            if (string.equalsIgnoreCase("y")) {
                                vector3f.set(0.0f, 1.0f, 0.0f);
                                break;
                            }
                            if (string.equalsIgnoreCase("z")) {
                                vector3f.set(0.0f, 0.0f, 1.0f);
                                break;
                            }
                            this.invalidArgument();
                        }
                        case 7: 
                        case 65539: {
                            vector3f.set((Tuple3f)this.getPoint3f(i, true));
                            i = this.iToken + 1;
                        }
                    }
                    float f4 = this.floatParameter(i);
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navigate(f, vector3f, f4);
                    continue block16;
                }
                case 4394: {
                    Point3f[][] point3fArrayArray;
                    Point3f point3f;
                    float f5 = Float.NaN;
                    float f6 = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        f5 = this.floatParameter(i);
                        f6 = this.floatParameter(++i);
                    } else if (this.getToken((int)i).tok == 1) {
                        point3fArrayArray = this.parameterAsString(i);
                        if (point3fArrayArray.equalsIgnoreCase("x")) {
                            f5 = this.floatParameter(++i);
                        } else if (point3fArrayArray.equalsIgnoreCase("y")) {
                            f6 = this.floatParameter(++i);
                        } else {
                            this.invalidArgument();
                        }
                    } else {
                        point3f = this.centerParameter(i);
                        i = this.iToken;
                        if (this.isSyntaxCheck) continue block16;
                        this.viewer.navTranslate(f, point3f);
                        continue block16;
                    }
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navTranslatePercent(f, f5, f6);
                    continue block16;
                }
                case 1114168: {
                    continue block16;
                }
                case 297: {
                    Vector vector = new Vector();
                    BitSet bitSet = this.expression(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.getPolymerPointsAndVectors(bitSet, vector);
                    int n = vector.size();
                    if (n <= 0) continue block16;
                    Point3f[][] point3fArrayArray = new Point3f[n][];
                    for (int j = 0; j < n; ++j) {
                        point3fArrayArray[j] = (Point3f[])vector.get(j);
                    }
                    this.viewer.navigate(f, point3fArrayArray);
                    continue block16;
                }
                case 1: {
                    float[] fArray = null;
                    String string = this.parameterAsString(i);
                    if (string.equalsIgnoreCase("path")) {
                        int n;
                        Object object;
                        if (this.getToken((int)(i + 1)).tok == 65541) {
                            ++i;
                            object = this.objectNameParameter(++i);
                            if (this.isSyntaxCheck) {
                                return;
                            }
                            this.setShapeProperty(28, "thisID", object);
                            Point3f[] point3fArray = (Point3f[])this.viewer.getShapeProperty(28, "vertices");
                            this.refresh();
                            if (point3fArray == null) {
                                this.invalidArgument();
                            }
                            n = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                            int n2 = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                            if (this.isSyntaxCheck) continue block16;
                            this.viewer.navigate(f, point3fArray, fArray, n, n2);
                            continue block16;
                        }
                        object = new Vector();
                        while (this.isCenterParameter(i + 1)) {
                            ((Vector)object).addElement(this.centerParameter(++i));
                            i = this.iToken;
                        }
                        if (((Vector)object).size() > 0) {
                            Point3f[] point3fArray = new Point3f[((Vector)object).size()];
                            for (n = 0; n < ((Vector)object).size(); ++n) {
                                point3fArray[n] = (Point3f)((Vector)object).get(n);
                            }
                            if (this.isSyntaxCheck) continue block16;
                            this.viewer.navigate(f, point3fArray, fArray, 0, Integer.MAX_VALUE);
                            continue block16;
                        }
                    }
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
    }

    void bondorder() throws ScriptException {
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 2: {
                n = (short)this.intParameter(1);
                if (n >= 0 && n <= 3) break;
                this.invalidArgument();
                break;
            }
            case 73997: {
                n = 128;
                break;
            }
            case 3: {
                float f = this.floatParameter(1);
                if (f == (float)((short)f)) {
                    n = (short)f;
                    if (n >= 0 && n <= 3) break;
                    this.invalidArgument();
                    break;
                }
                if (f == 0.5f) {
                    n = 128;
                    break;
                }
                if (f == 1.5f) {
                    n = 9;
                    break;
                }
                this.invalidArgument();
                break;
            }
            case 1: {
                n = JmolConstants.getBondOrderFromString(this.parameterAsString(1));
                if (n >= 1) break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.setShapeProperty(1, "bondOrder", new Short((short)n));
    }

    void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 32768: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(false);
                break;
            }
            case 32769: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(true);
                this.viewer.clearConsole();
                break;
            }
            default: {
                this.evalError("console ON|OFF");
            }
        }
    }

    void centerAt() throws ScriptException {
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 32815: {
                string = "absolute";
                break;
            }
            case 32816: {
                string = "average";
                break;
            }
            case 8561: {
                string = "boundbox";
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            point3f.x = this.floatParameter(2);
            point3f.y = this.floatParameter(3);
            point3f.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            point3f = this.centerParameter(2);
            this.checkStatementLength(this.iToken + 1);
        } else {
            this.checkLength2();
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCenterAt(string, point3f);
        }
    }

    void stereo() throws ScriptException {
        int n = 1;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = new int[2];
        int n2 = 0;
        String string = "";
        block7: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 32769: {
                    this.checkLength2();
                    this.iToken = 1;
                    string = " on";
                    continue block7;
                }
                case 32768: {
                    this.checkLength2();
                    this.iToken = 1;
                    n = 0;
                    string = " off";
                    continue block7;
                }
                case 49172: 
                case 0x110008: {
                    if (n2 > 1) {
                        this.badArgumentCount();
                    }
                    if (!bl) {
                        f = 3.0f;
                    }
                    nArray[n2++] = this.getArgbParam(i);
                    i = this.iToken;
                    if (n2 == 1) {
                        nArray[n2] = ~nArray[0];
                    }
                    string = string + " " + Escape.escapeColor((int)nArray[n2 - 1]);
                    continue block7;
                }
                case 2: 
                case 3: {
                    f = this.floatParameter(i);
                    bl = true;
                    string = string + " " + f;
                    continue block7;
                }
                case 1: {
                    String string2 = this.parameterAsString(i);
                    string = string + " " + string2;
                    if (!bl) {
                        f = 3.0f;
                    }
                    if (string2.equalsIgnoreCase("redblue")) {
                        n = 3;
                        continue block7;
                    }
                    if (string2.equalsIgnoreCase("redcyan")) {
                        n = 2;
                        continue block7;
                    }
                    if (string2.equalsIgnoreCase("redgreen")) {
                        n = 4;
                        continue block7;
                    }
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        this.setFloatProperty("stereoDegrees", f);
        this.checkStatementLength(this.iToken + 1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (n2 > 0) {
            this.viewer.setStereoMode(nArray, string);
        } else {
            this.viewer.setStereoMode(n, string);
        }
    }

    void connect() throws ScriptException {
        int n;
        float[] fArray = new float[2];
        BitSet[] bitSetArray = new BitSet[2];
        bitSetArray[0] = bitSetArray[1] = this.viewer.getSelectionSet();
        float f = Float.NaN;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        int n4 = 0;
        short s = -1;
        int n5 = 3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n6 = 0;
        int n7 = 0;
        BitSet bitSet = new BitSet();
        boolean bl5 = false;
        if (this.statementLength == 1) {
            this.viewer.rebond();
            return;
        }
        block10: for (n = 1; n < this.statementLength; ++n) {
            switch (this.getToken((int)n).tok) {
                case 32768: 
                case 32769: {
                    this.checkLength2();
                    if (!this.isSyntaxCheck) {
                        this.viewer.rebond();
                    }
                    return;
                }
                case 2: 
                case 3: {
                    if (++n7 > 2) {
                        this.badArgumentCount();
                    }
                    if (n6 > 0 || bl2 || bl4) {
                        this.invalidParameterOrder();
                    }
                    fArray[n3++] = this.floatParameter(n);
                    continue block10;
                }
                case 32839: 
                case 65636: {
                    if (++n6 > 2 || bl5 && n6 > 1) {
                        this.badArgumentCount();
                    }
                    if (bl2 || bl4) {
                        this.invalidParameterOrder();
                    }
                    bitSetArray[n4++] = this.expression(n);
                    bl5 = this.isBondSet;
                    n = this.iToken;
                    continue block10;
                }
                case 1: 
                case 73997: {
                    String string2 = this.parameterAsString(n);
                    int n8 = JmolConstants.bondOrderNames.length;
                    while (--n8 >= 0) {
                        if (!string2.equalsIgnoreCase(JmolConstants.bondOrderNames[n8])) continue;
                        if (bl2) {
                            this.incompatibleArguments();
                        }
                        string2 = JmolConstants.bondOrderNames[n8];
                        s = JmolConstants.getBondOrderFromString(string2);
                        bl2 = true;
                        continue block10;
                    }
                    if (++n != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    if ((n5 = JmolConstants.connectOperationFromString(string2)) < 0) {
                        this.invalidArgument();
                    }
                    bl3 = true;
                    continue block10;
                }
                case 32808: 
                case 32809: {
                    if (string != null) {
                        this.invalidArgument();
                    }
                    bl4 = true;
                    string = this.parameterAsString(n);
                    if (this.theTok != 32809 || !this.isFloatParameter(n + 1)) continue block10;
                    f2 = this.floatParameter(++n);
                    continue block10;
                }
                case 335889: {
                    f = this.floatParameter(++n);
                    bl4 = true;
                    continue block10;
                }
                case 49172: 
                case 0x110008: {
                    n2 = this.getArgbParam(n);
                    n = this.iToken;
                    bl4 = true;
                    continue block10;
                }
                case 32810: 
                case 65549: {
                    if (++n != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    n5 = 0;
                    if (bl4) {
                        this.invalidArgument();
                    }
                    bl = true;
                    continue block10;
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n3 < 2) {
            if (n3 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (string != null || !Float.isNaN(f) || n2 != Integer.MIN_VALUE) {
            if (!bl2) {
                s = -2;
            }
            if (!bl3) {
                n5 = 1;
            }
        }
        n = this.viewer.makeConnections(fArray[0], fArray[1], s, n5, bitSetArray[0], bitSetArray[1], bitSet, bl5);
        if (bl) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatus(GT._((String)"{0} connections deleted", (int)n));
            }
            return;
        }
        if (bl4) {
            this.viewer.selectBonds(bitSet);
            if (!Float.isNaN(f)) {
                this.viewer.setShapeSize(1, (int)(f * 2000.0f), bitSet);
            }
            if (n2 != Integer.MIN_VALUE) {
                this.viewer.setShapeProperty(1, "color", new Integer(n2), bitSet);
            }
            if (string != null) {
                if (f2 == Float.MAX_VALUE) {
                    f2 = this.viewer.getDefaultTranslucent();
                }
                this.viewer.setShapeProperty(1, "translucentLevel", new Float(f2));
                this.viewer.setShapeProperty(1, "translucency", string, bitSet);
            }
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatus(GT._((String)"{0} connections modified or created", (int)n));
        }
    }

    void getProperty() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = this.optParameterAsString(2);
        int n = this.tokAt(2);
        BitSet bitSet = n == 65636 || n == 32839 ? this.expression(2) : null;
        int n2 = PropertyManager.getPropertyNumber(string2);
        if (string2.length() > 0 && n2 < 0) {
            string2 = "";
            string3 = "";
        } else if (n2 >= 0 && this.statementLength < 3 && (string3 = PropertyManager.getDefaultParam(n2)).equals("(visible)")) {
            this.viewer.setModelVisibility();
            bitSet = this.viewer.getVisibleSet();
        }
        string = (String)this.viewer.getProperty("readable", string2, bitSet == null ? string3 : bitSet);
        this.showString(string);
    }

    void background(int n) throws ScriptException {
        this.getToken(n);
        if (this.isColorParam(n) || this.theTok == 65549) {
            int n2 = this.getArgbParamLast(n, true);
            if (!this.isSyntaxCheck) {
                this.viewer.setObjectArgb("background", n2);
            }
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    void center(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        Point3f point3f = this.centerParameter(n);
        if (point3f == null) {
            this.invalidArgument();
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setNewRotationCenter(point3f);
        }
    }

    void color() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 65541: {
                this.colorNamedObject(2);
                return;
            }
            case 4387: 
            case 32773: 
            case 32782: 
            case 32789: 
            case 32790: 
            case 32806: 
            case 32808: 
            case 32809: 
            case 32814: 
            case 49172: 
            case 65542: 
            case 65543: 
            case 65544: 
            case 65545: 
            case 65549: 
            case 196608: 
            case 327694: 
            case 327702: 
            case 327718: 
            case 327721: 
            case 327722: 
            case 328980: 
            case 335881: 
            case 860169: 
            case 0x110008: {
                this.colorObject(851969, 1);
                return;
            }
            case 24833: {
                int n = this.getArgbParamLast(2, true);
                if (!this.isSyntaxCheck) {
                    this.viewer.setObjectArgb("background", n);
                }
                return;
            }
            case 32839: 
            case 65636: {
                this.colorObject(851969, -1);
                return;
            }
            case 32805: {
                int n = this.getArgbParamLast(2, false);
                if (!this.isSyntaxCheck) {
                    this.viewer.setRubberbandArgb(n);
                }
                return;
            }
            case 8553: {
                int n = this.getArgbParamLast(2, true);
                if (this.isSyntaxCheck) {
                    return;
                }
                this.viewer.loadShape(17);
                this.setShapeProperty(17, "argbSelection", new Integer(n));
                return;
            }
            case 1: 
            case 8560: 
            case 8561: 
            case 204802: 
            case 205170: {
                String string = this.parameterAsString(1);
                int n = this.getArgbOrPaletteParam(2);
                this.checkStatementLength(this.iToken + 1);
                if (string.equalsIgnoreCase("axes")) {
                    this.setStringProperty("axesColor", Escape.escapeColor((int)n));
                    return;
                }
                if (StateManager.getObjectIdFromName(string) >= 0) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setObjectArgb(string, n);
                    }
                    return;
                }
                if (this.changeElementColor(string, n)) {
                    return;
                }
                this.invalidArgument();
            }
        }
        this.colorObject(this.theTok, 2);
    }

    private boolean changeElementColor(String string, int n) {
        int n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(JmolConstants.elementNameFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(JmolConstants.altElementNameFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + JmolConstants.elementSymbolFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + JmolConstants.altElementSymbolFromIndex(n2))) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + JmolConstants.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    void colorNamedObject(int n) throws ScriptException {
        int n2 = this.setShapeByNameParameter(n);
        this.colorShape(n2, n + 1, false);
    }

    void colorObject(int n, int n2) throws ScriptException {
        this.colorShape(this.getShapeType(n), n2, false);
    }

    void colorShape(int n, int n2, boolean bl) throws ScriptException {
        String string = null;
        Number number = null;
        BitSet bitSet = null;
        String string2 = "";
        int n3 = 0;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bitSet = this.expression(-n2);
            n2 = this.iToken + 1;
            if (!this.isSyntaxCheck) {
                if (this.isBondSet) {
                    this.viewer.selectBonds(bitSet);
                    n = 1;
                } else {
                    this.viewer.select(bitSet, true);
                }
            }
        }
        if (bl) {
            this.getToken(n2);
        } else {
            bl = this.getToken((int)n2).tok == 24833;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        }
        if (!this.isSyntaxCheck && n == 25 && !this.mo(true)) {
            return;
        }
        if (this.theTok == 32809 || this.theTok == 32808) {
            string = this.parameterAsString(n2++);
            if (this.theTok == 32809 && this.isFloatParameter(n2)) {
                f = this.floatParameter(n2++);
            }
        }
        if (n2 < this.statementLength && this.tokAt(n2) != 32769 && this.tokAt(n2) != 32768) {
            int n4 = this.getToken((int)n2).tok;
            if (this.isColorParam(n2)) {
                int n5 = this.getArgbParam(n2, false);
                Integer n6 = number = n5 == 0 ? null : new Integer(n5);
                if (string == null && this.tokAt(n2 = this.iToken + 1) != 0) {
                    this.getToken(n2);
                    if (string == null && (this.theTok == 32809 || this.theTok == 32808)) {
                        string = this.parameterAsString(n2);
                        if (this.theTok == 32809 && this.isFloatParameter(n2 + 1)) {
                            f = this.floatParameter(++n2);
                        }
                    }
                }
            } else if (n == 27) {
                --this.iToken;
            } else {
                Object object;
                int n7;
                String string3 = this.parameterAsString(n2).toLowerCase();
                int n8 = n7 = n4 == 4387 ? 1 : JmolConstants.getPaletteID(string3);
                if (n7 == -1 || n7 == 18 && n != 2) {
                    this.invalidArgument();
                }
                if (n7 == 83) {
                    if (string3.equals("property") && Compiler.tokAttr(this.getToken((int)(++n2)).tok, 327680)) {
                        if (!this.isSyntaxCheck) {
                            object = this.getBitsetProperty(null, this.getToken((int)n2).tok | 0xC0, null, null, null, null, false);
                            if (object instanceof float[]) {
                                this.viewer.setCurrentColorRange((float[])object, null);
                            } else {
                                this.invalidArgument();
                            }
                        }
                    } else if (!this.isSyntaxCheck) {
                        this.viewer.setCurrentColorRange(string3);
                    }
                    if (this.tokAt(n2 + 1) == 32815) {
                        float f2 = this.floatParameter(n2 + 2);
                        float f3 = this.floatParameter(n2 + 3);
                        this.viewer.setCurrentColorRange(f2, f3);
                        n2 += 3;
                    }
                }
                if (n7 == 84) {
                    string3 = this.parameterAsString(++n2);
                    object = new float[this.viewer.getAtomCount()];
                    Parser.parseFloatArray((String)("" + this.viewer.getParameter(string3)), null, (float[])object);
                    this.viewer.setCurrentColorRange((float[])object, null);
                    n7 = 83;
                }
                number = new Byte((byte)n7);
                this.checkStatementLength(n2 + 1);
            }
            if (this.isSyntaxCheck) {
                return;
            }
            switch (n4) {
                case 327721: {
                    this.viewer.getModelSet().getSurfaceDistanceMax();
                    break;
                }
                case 327722: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 65544: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 32806: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 327694: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
            int n9 = n == 2 ? 1920 : (n == 3 ? 64 : (n3 = n == 1 ? 7 : 0));
            if (n3 == 0) {
                this.viewer.loadShape(n);
                this.setShapeProperty(n, string2 + "color", number);
            } else {
                this.setShapeProperty(1, "type", new Integer(n3));
                this.setShapeProperty(1, string2 + "color", number);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f);
        }
        if (n3 != 0) {
            this.viewer.setShapeProperty(1, "type", new Integer(7));
        }
    }

    void setShapeTranslucency(int n, String string, String string2, float f) {
        if (f == Float.MAX_VALUE) {
            f = this.viewer.getDefaultTranslucent();
        }
        this.setShapeProperty(n, "translucentLevel", new Float(f));
        this.setShapeProperty(n, string + "translucency", string2);
    }

    void data() throws ScriptException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                string = this.parameterAsString(2);
            }
            case 2: 
            case 4: {
                string2 = this.parameterAsString(1);
                if (string2.equalsIgnoreCase("clear")) {
                    if (!this.isSyntaxCheck) {
                        Viewer.setData(null, null, 0, 0, 0);
                    }
                    return;
                }
                int n = string2.indexOf("@");
                if (n >= 0) {
                    string = "" + this.viewer.getParameter(string2.substring(n + 1));
                    string2 = string2.substring(0, n).trim();
                    break;
                }
                if (string != null || (n = string2.indexOf(" ")) < 0) break;
                string = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
                bl = true;
                break;
            }
            default: {
                this.badArgumentCount();
            }
        }
        String string3 = string2 + " ";
        string3 = string3.substring(0, string3.indexOf(" "));
        this.data = new Object[3];
        this.data[0] = string2;
        this.data[1] = string;
        boolean bl2 = string3.equalsIgnoreCase("model");
        boolean bl3 = string3.equalsIgnoreCase("append");
        if (!this.isSyntaxCheck || this.isScriptCheck && (bl2 || bl3) && this.fileOpenCheck) {
            if (string3.toLowerCase().indexOf("property_") == 0) {
                BitSet bitSet = this.viewer.getSelectedAtoms();
                int n = bl ? Integer.MIN_VALUE : (Integer)this.viewer.getParameter("propertyDataField");
                int n2 = bl ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberField");
                int n3 = this.viewer.getAtomCount();
                int[] nArray = null;
                BitSet bitSet2 = new BitSet(n3);
                if (n2 > 0) {
                    int n4;
                    nArray = new int[n3 + 1];
                    for (n4 = 0; n4 < n3; ++n4) {
                        nArray[n4] = -1;
                    }
                    for (n4 = 0; n4 < n3; ++n4) {
                        int n5;
                        if (!bitSet.get(n4) || bitSet2.get(n5 = this.viewer.getAtomNumber(n4)) || n5 > n3 + 1 || n5 < 0) continue;
                        bitSet2.set(n5);
                        nArray[n5] = n4;
                    }
                    this.data[2] = nArray;
                } else {
                    this.data[2] = bitSet;
                }
                Viewer.setData(string3, this.data, n3, n2, n);
            } else {
                Viewer.setData(string3, this.data, 0, 0, 0);
            }
        }
        if ((bl2 || bl3) && (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck)) {
            char c = this.viewer.getInlineChar();
            if (string.length() > 0 && string.charAt(0) != c) {
                c = '\u0000';
            }
            this.viewer.loadInline(string, c, bl3);
        }
        if (string3.equalsIgnoreCase("coord")) {
            this.viewer.loadCoordinates(string);
        }
    }

    void define() throws ScriptException {
        boolean bl;
        String string = (String)this.getToken((int)1).value;
        BitSet bitSet = this.expression(2);
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl2 = bl = string.indexOf("dynamic_") == 0;
        if (bl) {
            Token[] tokenArray = new Token[this.statementLength];
            int n = this.statementLength;
            while (--n >= 0) {
                tokenArray[n] = this.statement[n];
            }
            this.variables.put("!" + string.substring(8), tokenArray);
            this.viewer.addStateScript(this.thisCommand);
        } else {
            this.assignBitsetVariable(string, bitSet);
        }
    }

    void echo(int n) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(n);
        if (this.viewer.getEchoStateActive()) {
            this.setShapeProperty(21, "text", string);
        }
        if (this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(string));
        }
    }

    void message() throws ScriptException {
        String string = this.parameterAsString(1);
        if (this.isSyntaxCheck) {
            return;
        }
        String string2 = this.viewer.formatText(string);
        if (this.outputBuffer == null) {
            Logger.warn((String)string2);
        }
        if (!string2.startsWith("_")) {
            this.scriptStatus(string2);
        }
    }

    void scriptStatus(String string) {
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string);
            return;
        }
        this.viewer.scriptStatus(string);
    }

    void pause() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        this.pauseExecution();
        String string = this.optParameterAsString(1);
        string = string.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(string);
        this.viewer.scriptStatus("script execution paused" + string);
    }

    void label(int n) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterAsString(n);
        if (string.equalsIgnoreCase("on")) {
            string = this.viewer.getStandardLabelFormat();
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.loadShape(4);
        this.viewer.setLabel(string);
    }

    void hover() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.loadShape(22);
        this.setShapeProperty(22, "label", string);
    }

    void load() throws ScriptException {
        Object object;
        Object object2;
        boolean bl = false;
        int n = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        boolean bl2 = this.viewer.getAppendNew();
        StringBuffer stringBuffer = new StringBuffer("load");
        Object object3 = new int[4];
        int n2 = 1;
        Point3f point3f = this.viewer.getDefaultLattice();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.viewer.getApplySymmetryToBonds()) {
            hashtable.put("applySymmetryToBonds", Boolean.TRUE);
        }
        hashtable.put("params", object3);
        object3[1] = (int)point3f.x;
        object3[2] = (int)point3f.y;
        object3[3] = (int)point3f.z;
        int n3 = 1;
        String string = "fileset";
        if (this.statementLength == 1) {
            n3 = 0;
        } else {
            if (this.getToken((int)1).tok == 334) {
                object3[0] = -1;
                n3 = 2;
            } else if (this.theTok == 1 || this.parameterAsString(1).equals("fileset")) {
                string = this.parameterAsString(1);
                stringBuffer.append(" " + string);
                if (string.equals("fileset")) {
                    string = this.parameterAsString(2);
                }
                bl = string.equalsIgnoreCase("append");
                n3 = 2;
            }
            if (this.getToken((int)n3).tok != 4) {
                this.filenameExpected();
            }
        }
        if (this.statementLength == n3 + 1) {
            if (n3 == 0 || (string = this.parameterAsString(n3)).length() == 0) {
                string = this.viewer.getFullPathName();
            }
            if (string == null) {
                this.zap();
                return;
            }
            if (string.length() > 0 && string.charAt(0) == '=') {
                string = this.fixFileName(string);
            }
            stringBuffer.append(" ").append(Escape.escape((String)string)).append(";");
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFile(string, hashtable, stringBuffer.toString(), bl);
            }
        } else if (this.getToken((int)(n3 + 1)).tok == 65539 || this.theTok == 2) {
            int n4;
            if ((string = this.parameterAsString(n3++)).length() == 0) {
                string = this.viewer.getFullPathName();
            }
            if (string.length() > 0 && string.charAt(0) == '=') {
                string = this.fixFileName(string);
            }
            stringBuffer.append(" ").append(Escape.escape((String)string));
            if (this.getToken((int)n3).tok == 2) {
                object3[0] = this.intParameter(n3++);
                stringBuffer.append(" ").append(object3[0]);
            }
            if ((n4 = this.tokAt(n3)) == 65539 || n4 == 7) {
                int n5;
                point3f = this.getPoint3f(n3, false);
                n3 = this.iToken + 1;
                object3[1] = (int)point3f.x;
                object3[2] = (int)point3f.y;
                object3[3] = (int)point3f.z;
                stringBuffer.append(" ").append(Escape.escape((Tuple3f)point3f));
                int n6 = -1;
                if (this.tokAt(n3) == 32771) {
                    int n7 = ++n3;
                    ++n3;
                    object2 = TextFormat.simpleReplace((String)this.parameterAsString(n7), (String)"''", (String)"\"");
                    stringBuffer.append(" ").append(Escape.escape((String)object2));
                    if (((String)object2).equalsIgnoreCase("ignoreOperators")) {
                        n6 = -999;
                    } else {
                        if (((String)object2).indexOf(",") >= 0 && point3f.x < 9.0f && point3f.y < 9.0f && point3f.z == 0.0f) {
                            object2 = (String)object2 + "#doNormalize=0";
                        }
                        if ((n6 = this.viewer.getSpaceGroupIndexFromName((String)object2)) == -1) {
                            this.evalError(GT._((String)"space group {0} was not found.", (String)object2));
                        }
                    }
                    object = new int[5];
                    for (n5 = 0; n5 < 4; ++n5) {
                        object[n5] = object3[n5];
                    }
                    object[4] = n6;
                    object3 = object;
                    hashtable.put("params", object3);
                }
                if (this.tokAt(n3) == 205170) {
                    ++n3;
                    object = new int[11];
                    for (int i = 0; i < ((int[])object3).length; ++i) {
                        object[i] = object3[i];
                    }
                    object[4] = n6;
                    object2 = new float[6];
                    n3 = this.floatParameterSet(n3, (float[])object2);
                    stringBuffer.append(" {");
                    for (n5 = 0; n5 < 6; ++n5) {
                        object[5 + n5] = (int)(object2[n5] * 10000.0f);
                        stringBuffer.append(n5 == 0 ? "" : " ").append((int)object[5 + n5]);
                    }
                    stringBuffer.append("}");
                    object3 = object;
                    hashtable.put("params", object3);
                }
            }
            stringBuffer.append(";");
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFile(string, hashtable, stringBuffer.toString(), bl);
            }
        } else {
            String string2;
            if (n3 == 2) {
                string2 = string;
            } else {
                string2 = this.parameterAsString(n3++);
                stringBuffer.append(" ").append(Escape.escape((String)string2));
            }
            String[] stringArray = new String[this.statementLength - n3];
            while (n3 < this.statementLength) {
                string2 = this.parameterAsString(n3);
                if (string2.length() > 0 && string2.charAt(0) == '=') {
                    string2 = this.fixFileName(string2);
                }
                stringArray[stringArray.length - this.statementLength + n3] = string2;
                stringBuffer.append(" ").append(Escape.escape((String)string2));
                ++n3;
            }
            n2 = stringArray.length;
            stringBuffer.append(";");
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFiles(string2, stringArray, stringBuffer.toString(), bl);
            }
        }
        if (!(!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck)) {
            return;
        }
        String string3 = this.viewer.getOpenFileError(bl);
        if (string3 != null && !this.isScriptCheck) {
            this.evalError(string3);
        }
        if (bl && (bl2 || n2 > 1)) {
            this.viewer.setAnimationRange(-1, -1, false);
            this.viewer.setCurrentModelIndex(n);
        }
        if (this.logMessages) {
            this.scriptStatus("Successfully loaded:" + string);
        }
        String string4 = this.viewer.getDefaultLoadScript();
        object = "";
        if (string4.length() > 0) {
            object = (String)object + "\nUsing defaultLoadScript: " + string4;
        }
        if ((object2 = this.viewer.getModelSetProperty("jmolscript")) != null && this.viewer.getAllowEmbeddedScripts()) {
            object = (String)object + "\nAdding embedded #jmolscript: " + (String)object2;
            string4 = string4 + ";" + (String)object2;
            string4 = "allowEmbeddedScripts = false;" + string4 + ";allowEmbeddedScripts = true;";
        }
        if (((String)object).length() > 0) {
            Logger.info((String)object);
        }
        if (string4.length() > 0 && !this.isScriptCheck) {
            this.runScript(string4);
        }
    }

    String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck ? this.viewer.getFullPathName() : "test.xyz";
        if (string == null) {
            this.invalidArgument();
        }
        return string;
    }

    String fixFileName(String string) {
        String string2 = TextFormat.formatString((String)this.viewer.getLoadFormat(), (String)"FILE", (String)string.substring(1));
        this.showString("Loading " + string2);
        return string2;
    }

    void monitor() throws ScriptException {
        int[] nArray = new int[5];
        float[] fArray = new float[2];
        if (this.statementLength == 1) {
            this.viewer.hideMeasurements(false);
            return;
        }
        switch (this.statementLength) {
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 32769: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(false);
                        }
                        return;
                    }
                    case 32768: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(true);
                        }
                        return;
                    }
                    case 32810: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.clearAllMeasurements();
                        }
                        return;
                    }
                    case 4: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.setMeasurementFormats(this.stringParameter(1));
                        }
                        return;
                    }
                }
                this.keywordExpected("ON, OFF, DELETE");
            }
            case 3: {
                if (this.getToken((int)1).tok != 32810) break;
                if (this.getToken((int)2).tok == 65551) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.clearAllMeasurements();
                    }
                } else {
                    int n = this.intParameter(2) - 1;
                    if (!this.isSyntaxCheck) {
                        this.viewer.deleteMeasurement(n);
                    }
                }
                return;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        fArray[0] = Float.MAX_VALUE;
        fArray[1] = Float.MAX_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        String string = null;
        Vector<BitSet> vector = new Vector<BitSet>();
        BitSet bitSet = new BitSet();
        block22: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 32769: {
                    if (bl6 || bl7 || bl4) {
                        this.invalidArgument();
                    }
                    bl6 = true;
                    continue block22;
                }
                case 32768: {
                    if (bl6 || bl7 || bl4) {
                        this.invalidArgument();
                    }
                    bl7 = true;
                    continue block22;
                }
                case 32810: {
                    if (bl6 || bl7 || bl4) {
                        this.invalidArgument();
                    }
                    bl4 = true;
                    continue block22;
                }
                case 32830: {
                    bl5 = true;
                    n3 = -1;
                    bl = true;
                    continue block22;
                }
                case 1: {
                    if (this.parameterAsString(i).equalsIgnoreCase("ALLCONNECTED")) {
                        bl2 = true;
                    } else {
                        this.keywordExpected("ALL, ALLCONNECTED, DELETE");
                    }
                }
                case 65551: {
                    n3 = -1;
                    bl = true;
                    continue block22;
                }
                case 4: {
                    string = this.stringParameter(i);
                    continue block22;
                }
                case 3: {
                    bl = true;
                    bl5 = true;
                    n5 = (n5 + 1) % 2;
                    fArray[n5] = this.floatParameter(i);
                    continue block22;
                }
                case 2: {
                    bl5 = true;
                    n4 = this.intParameter(i);
                    n3 = this.viewer.getAtomIndexFromAtomNumber(n4);
                    n5 = (n5 + 1) % 2;
                    fArray[n5] = n4;
                    break;
                }
                case 32839: 
                case 65636: {
                    bl3 = true;
                    bitSet = this.expression(i);
                    i = this.iToken;
                    n3 = BitSetUtil.firstSetBit((BitSet)bitSet);
                    break;
                }
                default: {
                    this.expressionOrIntegerExpected();
                }
            }
            if ((n3 == -1 || bl && (bitSet == null || bitSet.size() == 0)) && !this.isSyntaxCheck) {
                if (bl3) {
                    return;
                }
                this.evalError(GT._((String)"bad atom number"));
            }
            if (bl) {
                if (++n2 > 4) {
                    this.badArgumentCount();
                }
                vector.addElement(bitSet);
                n = n2;
                continue;
            }
            if (++n > 4) {
                this.badArgumentCount();
            }
            nArray[n] = n3;
        }
        nArray[0] = n;
        if (string != null && string.indexOf(n + ":") != 0) {
            string = n + ":" + string;
        }
        if (bl) {
            if (!bl3) {
                this.expressionExpected();
            }
            if (bl5 && fArray[1] < fArray[0]) {
                fArray[1] = fArray[0];
                float f = fArray[0] = fArray[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
            }
            if (!this.isSyntaxCheck) {
                this.viewer.defineMeasurement(vector, fArray, bl4, bl2, bl6 || bl7, bl7, string);
            }
            return;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl4) {
            this.viewer.deleteMeasurement(nArray);
        } else if (bl6) {
            this.viewer.showMeasurement(nArray, true);
        } else if (bl7) {
            this.viewer.showMeasurement(nArray, false);
        } else {
            this.viewer.toggleMeasurement(nArray, string);
        }
    }

    void refresh() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    void reset() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.statementLength == 1) {
            this.viewer.reset();
            return;
        }
        String string = this.parameterAsString(1);
        if (string.charAt(0) == '_') {
            this.invalidArgument();
        }
        this.viewer.unsetProperty(string);
    }

    void initialize() {
        this.viewer.initialize();
    }

    void restrict() throws ScriptException {
        this.select();
        if (this.isSyntaxCheck) {
            return;
        }
        BitSet bitSet = BitSetUtil.copy((BitSet)this.viewer.getSelectionSet());
        this.viewer.invertSelection();
        if (this.bsSubset != null) {
            BitSet bitSet2 = BitSetUtil.copy((BitSet)this.viewer.getSelectionSet());
            bitSet2.and(this.bsSubset);
            this.viewer.setSelectionSet(bitSet2);
        }
        boolean bl = this.viewer.getBondSelectionModeOr();
        this.setBooleanProperty("bondModeOr", true);
        this.setShapeSize(1, 0);
        int n = 18;
        while (--n >= 0) {
            if (n == 6) continue;
            this.setShapeSize(n, 0);
        }
        this.setShapeProperty(23, "delete", null);
        this.viewer.setLabel(null);
        this.setBooleanProperty("bondModeOr", bl);
        this.viewer.setSelectionSet(bitSet);
    }

    void rotate(boolean bl, boolean bl2) throws ScriptException {
        int n;
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 32769: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 32768: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        float f = Float.MIN_VALUE;
        int n2 = 0;
        float f2 = Float.MAX_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        Point3f[] point3fArray = new Point3f[3];
        Point3f point3f = null;
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        int n3 = 1;
        boolean bl5 = this.viewer.getAxesOrientationRasmol();
        for (n = 0; n < 3; ++n) {
            point3fArray[n] = new Point3f(0.0f, 0.0f, 0.0f);
        }
        for (n = 1; n < this.statementLength; ++n) {
            switch (this.getToken((int)n).tok) {
                case 13632: {
                    bl = true;
                    break;
                }
                case 0x110030: {
                    n3 = -1;
                    break;
                }
                case 32774: {
                    bl3 = true;
                    break;
                }
                case 1: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("x")) {
                        vector3f.set((float)n3, 0.0f, 0.0f);
                        break;
                    }
                    if (string.equalsIgnoreCase("y")) {
                        if (bl5) {
                            n3 = -n3;
                        }
                        vector3f.set(0.0f, (float)n3, 0.0f);
                        break;
                    }
                    if (string.equalsIgnoreCase("z")) {
                        vector3f.set(0.0f, 0.0f, (float)n3);
                        break;
                    }
                    if (string.equalsIgnoreCase("internal") || string.equalsIgnoreCase("molecular")) {
                        bl4 = true;
                        break;
                    }
                    this.invalidArgument();
                }
                case 7: 
                case 65539: {
                    Point3f point3f2 = this.getPoint3f(n, true);
                    n = this.iToken;
                    if (bl3) {
                        if (bl5) {
                            point3f2.y = -point3f2.y;
                        }
                        vector3f.set((Tuple3f)point3f2);
                        bl3 = false;
                        break;
                    }
                    point3fArray[n2++].set((Tuple3f)point3f2);
                    break;
                }
                case 65541: {
                    BitSet bitSet;
                    if (this.tokAt(n + 2) == 0x110008) {
                        bitSet = this.centerParameter(n);
                        n = this.iToken;
                        if (bl3) {
                            if (bl5) {
                                ((Tuple3f)bitSet).y = -((Tuple3f)bitSet).y;
                            }
                            vector3f.set((Tuple3f)bitSet);
                            bl3 = false;
                            break;
                        }
                        point3fArray[n2++].set((Tuple3f)bitSet);
                        break;
                    }
                    bl4 = true;
                    String string = this.objectNameParameter(++n);
                    if (this.isSyntaxCheck) {
                        point3f = new Point3f();
                        vector3f = new Vector3f();
                    } else {
                        point3f = this.getDrawObjectCenter(string);
                        vector3f = this.getDrawObjectAxis(string);
                        if (point3f == null) {
                            this.drawObjectNotDefined(string);
                        }
                    }
                    point3fArray[n2++].set((Tuple3f)point3f);
                    break;
                }
                case 65547: {
                    break;
                }
                case 2: 
                case 3: {
                    if (f == Float.MIN_VALUE) {
                        f = this.floatParameter(n);
                        break;
                    }
                    f2 = f;
                    f = this.floatParameter(n);
                    bl = true;
                    break;
                }
                case 32839: 
                case 65636: {
                    BitSet bitSet = this.expression(n);
                    n = this.iToken;
                    point3f = this.viewer.getAtomSetCenter(bitSet);
                    point3fArray[n2++].set((Tuple3f)point3f);
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            if (n2 < 3) continue;
            this.evalError(GT._((String)"too many rotation points were specified"));
        }
        if (n2 < 2 && !bl4) {
            if (n2 == 1) {
                point3f = new Point3f(point3fArray[0]);
            }
            if (f == Float.MIN_VALUE) {
                f = 10.0f;
            }
            if (this.isSyntaxCheck) {
                return;
            }
            this.viewer.rotateAxisAngleAtCenter(point3f, vector3f, f, f2, bl, bl2);
            return;
        }
        if (n2 < 2 && !this.isSyntaxCheck) {
            point3fArray[1].set((Tuple3f)point3fArray[0]);
            point3fArray[1].sub((Tuple3f)vector3f);
        }
        if (!this.isSyntaxCheck && point3fArray[0].distance(point3fArray[1]) == 0.0f) {
            this.evalError(GT._((String)"rotation points cannot be identical"));
        }
        if (f == Float.MIN_VALUE) {
            f = 10.0f;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.rotateAboutPointsInternal(point3fArray[0], point3fArray[1], f, f2, bl, bl2);
    }

    Point3f getDrawObjectCenter(String string) {
        return (Point3f)this.viewer.getShapeProperty(28, "getSpinCenter:" + string);
    }

    int getDrawObjectType(String string) {
        return (Integer)this.viewer.getShapeProperty(28, "getType:" + string);
    }

    Vector3f getDrawObjectAxis(String string) {
        return (Vector3f)this.viewer.getShapeProperty(28, "getSpinAxis:" + string);
    }

    void script(boolean bl) throws ScriptException {
        if (bl) {
            if (!this.isSyntaxCheck) {
                this.viewer.eval(this.parameterAsString(1));
            }
            return;
        }
        if (this.getToken((int)1).tok != 4) {
            this.filenameExpected();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        String string = this.parameterAsString(1);
        String string2 = string.equalsIgnoreCase("inline") ? this.parameterAsString(n5++) : null;
        boolean bl2 = true;
        boolean bl3 = false;
        String string3 = this.optParameterAsString(n5);
        if (string3.equalsIgnoreCase("check")) {
            bl3 = true;
            string3 = this.optParameterAsString(++n5);
        }
        if (string3.equalsIgnoreCase("noload")) {
            bl2 = false;
            string3 = this.optParameterAsString(++n5);
        }
        if (string3.equalsIgnoreCase("line") || string3.equalsIgnoreCase("lines")) {
            int n6 = ++n5;
            n3 = n = Math.max(this.intParameter(n6), 0);
            if (this.checkToken(++n5)) {
                if (this.getToken((int)n5++).tok == 0x110030) {
                    n3 = this.checkToken(n5) ? this.intParameter(n5++) : 0;
                } else {
                    this.invalidArgument();
                }
            }
        } else if (string3.equalsIgnoreCase("command") || string3.equalsIgnoreCase("commands")) {
            int n7 = ++n5;
            n2 = Math.max(this.intParameter(n7) - 1, 0);
            n4 = n2 + 1;
            if (this.checkToken(++n5)) {
                if (this.getToken((int)n5++).tok == 0x110030) {
                    n4 = this.checkToken(n5) ? this.intParameter(n5++) : 0;
                } else {
                    this.invalidArgument();
                }
            }
        }
        this.checkStatementLength(n5);
        if (this.isSyntaxCheck && !this.isScriptCheck) {
            return;
        }
        if (this.isScriptCheck) {
            bl3 = true;
        }
        boolean bl4 = this.isSyntaxCheck;
        boolean bl5 = this.isScriptCheck;
        if (bl3) {
            this.isScriptCheck = true;
            this.isSyntaxCheck = true;
        }
        this.pushContext();
        boolean bl6 = string2 != null ? this.loadScript(null, string2) : this.loadScriptFileInternal(string);
        if (bl6) {
            this.pcEnd = n4;
            this.lineEnd = n3;
            while (n2 < this.linenumbers.length && this.linenumbers[n2] < n) {
                ++n2;
            }
            this.pc = n2;
            boolean bl7 = this.fileOpenCheck;
            this.fileOpenCheck = this.fileOpenCheck && bl2;
            this.instructionDispatchLoop(bl3);
            this.fileOpenCheck = bl7;
            this.popContext();
        } else {
            Logger.error((String)(GT._((String)"script ERROR: ") + this.errorMessage));
            this.popContext();
            if (bl5) {
                this.error = false;
                this.errorMessage = null;
            } else {
                this.evalError(null);
            }
        }
        this.isSyntaxCheck = bl4;
        this.isScriptCheck = bl5;
    }

    void history(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            this.checkLength3();
            int n2 = this.intParameter(2);
            if (n2 < 0) {
                this.invalidArgument();
            }
            if (!this.isSyntaxCheck) {
                this.viewer.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        this.checkLength2();
        switch (this.getToken((int)1).tok) {
            case 32769: 
            case 32776: {
                if (!this.isSyntaxCheck) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 32768: {
                if (this.isSyntaxCheck) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.keywordExpected("ON, OFF, CLEAR");
            }
        }
    }

    void hide() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.hide(null, this.tQuiet);
            return;
        }
        BitSet bitSet = this.expression(1);
        if (!this.isSyntaxCheck) {
            this.viewer.hide(bitSet, this.tQuiet);
        }
    }

    void display() throws ScriptException {
        int n = this.viewer.getAtomCount();
        if (this.statementLength == 1) {
            this.viewer.display(BitSetUtil.setAll((int)n), null, this.tQuiet);
            return;
        }
        BitSet bitSet = this.expression(1);
        if (!this.isSyntaxCheck) {
            this.viewer.display(BitSetUtil.setAll((int)n), bitSet, this.tQuiet);
        }
    }

    void select() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.select(null, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        if (this.tokAt(2) == 32839 && this.getToken((int)2).value instanceof Bond.BondSet || this.getToken((int)2).tok == 860162 && this.getToken((int)3).tok == 32839) {
            if (this.statementLength == this.iToken + 2) {
                if (!this.isSyntaxCheck) {
                    this.viewer.selectBonds((BitSet)this.theToken.value);
                }
                return;
            }
            this.invalidArgument();
        }
        if (this.getToken((int)2).tok == 75026) {
            if (this.statementLength == 5 && this.getToken((int)3).tok == 32839) {
                if (!this.isSyntaxCheck) {
                    this.setShapeProperty(6, "select", this.theToken.value);
                }
                return;
            }
            this.invalidArgument();
        }
        BitSet bitSet = this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds(bitSet);
        } else {
            this.viewer.select(bitSet, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    void subset() throws ScriptException {
        BitSet bitSet = this.bsSubset = this.statementLength == 1 ? null : this.expression(-1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setSelectionSubset(this.bsSubset);
    }

    void invertSelected() throws ScriptException {
        Point3f point3f = null;
        Point4f point4f = null;
        if (this.statementLength == 1) {
            if (this.isSyntaxCheck) {
                return;
            }
            BitSet bitSet = this.viewer.getSelectedAtoms();
            point3f = this.viewer.getAtomSetCenter(bitSet);
            this.viewer.invertSelected(point3f, bitSet);
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("point")) {
            point3f = this.centerParameter(2);
        } else if (string.equalsIgnoreCase("plane")) {
            point4f = this.planeParameter(2);
        } else if (string.equalsIgnoreCase("hkl")) {
            point4f = this.hklParameter(2);
        }
        this.checkStatementLength(this.iToken + 1);
        if (point4f == null && point3f == null) {
            this.invalidArgument();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.invertSelected(point3f, point4f);
    }

    void translateSelected() throws ScriptException {
        Point3f point3f = this.getPoint3f(1, true);
        if (!this.isSyntaxCheck) {
            this.viewer.setAtomCoordRelative(point3f);
        }
    }

    void translate() throws ScriptException {
        float f = this.floatParameter(2);
        if (f > 100.0f || f < -100.0f) {
            this.numberOutOfRange(-100, 100);
        }
        if (this.getToken((int)1).tok == 1) {
            String string = this.parameterAsString(1);
            if (string.equalsIgnoreCase("x")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToXPercent(f);
                }
                return;
            }
            if (string.equalsIgnoreCase("y")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToYPercent(f);
                }
                return;
            }
            if (string.equalsIgnoreCase("z")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToZPercent(f);
                }
                return;
            }
        }
        this.axisExpected();
    }

    void zap() {
        this.viewer.zap(true);
        this.refresh();
    }

    void zoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.statementLength > 1 ? this.getToken((int)1).tok : 32769;
            switch (n) {
                case 32768: 
                case 32769: {
                    if (this.statementLength > 2) {
                        this.badArgumentCount();
                    }
                    if (!this.isSyntaxCheck) {
                        this.setBooleanProperty("zoomEnabled", n == 32769);
                    }
                    return;
                }
            }
        }
        float f2 = this.viewer.getZoomPercentFloat();
        float f3 = this.viewer.getRotationRadius();
        Point3f point3f = null;
        Point3f point3f2 = this.viewer.getRotationCenter();
        int n = 1;
        float f4 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f) : (f = 0.0f);
        if (f < 0.0f) {
            this.invalidArgument();
        }
        int n2 = 0;
        if (this.isCenterParameter(n)) {
            n2 = n;
            point3f = this.centerParameter(n);
            n = this.iToken + 1;
        }
        boolean bl2 = point3f != null && (double)point3f2.distance(point3f) < 0.1;
        float f5 = this.getZoomFactor(n, n2, f3, f2);
        if (f5 < 0.0f) {
            f5 = -f5;
            if (bl) {
                if (this.statementLength == 1 || bl2) {
                    f5 *= 2.0f;
                } else if (point3f == null) {
                    f5 /= 2.0f;
                }
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = this.viewer.getMaxZoomPercent();
        if (f5 < 5.0f || f5 > f8) {
            this.numberOutOfRange(5.0f, f8);
        }
        if (!this.viewer.isWindowCentered()) {
            if (point3f != null) {
                BitSet bitSet = this.expression(n2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCenterBitSet(bitSet, false);
                }
            }
            point3f = this.viewer.getRotationCenter();
            f6 = this.viewer.getTranslationXPercent();
            f7 = this.viewer.getTranslationYPercent();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl2 && Math.abs(f2 - f5) < 1.0f) {
            f = 0.0f;
        }
        this.viewer.moveTo(f, point3f, new Point3f(0.0f, 0.0f, 0.0f), Float.NaN, f5, f6, f7, f3, null, Float.NaN, Float.NaN, Float.NaN);
    }

    float getZoomFactor(int n, int n2, float f, float f2) throws ScriptException {
        float f3;
        float f4 = f3 = this.isFloatParameter(n) ? this.floatParameter(n) : Float.NaN;
        if (f3 == 0.0f) {
            BitSet bitSet = null;
            switch (this.statement[n2].tok) {
                case 32839: 
                case 65636: {
                    bitSet = this.expression(this.statement, n2, true, false, false);
                }
            }
            if (bitSet == null) {
                this.invalidArgument();
            }
            float f5 = this.viewer.calcRotationRadius(bitSet);
            f2 = f / f5 * 100.0f;
            f3 = Float.NaN;
            ++n;
        }
        if (f3 < 0.0f) {
            f3 += f2;
        } else if (Float.isNaN(f3)) {
            f3 = f2;
            if (this.isFloatParameter(n + 1)) {
                float f6 = this.floatParameter(n + 1);
                switch (this.getToken((int)n++).tok) {
                    case 1114168: {
                        f3 /= f6;
                        break;
                    }
                    case 1114169: {
                        f3 *= f6;
                        break;
                    }
                    case 0x110031: {
                        f3 += f6;
                        break;
                    }
                    default: {
                        this.invalidArgument();
                        break;
                    }
                }
            } else {
                f3 = -f3;
                --n;
            }
        }
        this.iToken = n;
        return f3;
    }

    void gotocmd() throws ScriptException {
        String string = null;
        string = this.parameterAsString(1);
        int n = -1;
        for (int i = 0; i < this.aatoken.length; ++i) {
            Token[] tokenArray = this.aatoken[i];
            if (tokenArray[0].tok != 2405 || !tokenArray[1].value.toString().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            this.invalidArgument();
        }
        if (!this.isSyntaxCheck) {
            this.pc = n - 1;
        }
    }

    void delay() throws ScriptException {
        long l = 0L;
        switch (this.getToken((int)1).tok) {
            case 32769: {
                l = 1L;
                break;
            }
            case 2: {
                l = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                l = (long)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        if (!this.isSyntaxCheck) {
            this.delay(l);
        }
    }

    private void delay(long l) {
        long l2 = System.currentTimeMillis();
        this.refresh();
        int n = (int)(l -= System.currentTimeMillis() - l2) / 1000;
        if ((l -= (long)(n * 1000)) <= 0L) {
            l = 1L;
        }
        while (n >= 0 && l > 0L && !this.interruptExecution.booleanValue() && this.currentThread == Thread.currentThread()) {
            this.viewer.popHoldRepaint();
            try {
                Thread.sleep(n-- > 0 ? 1000L : l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint();
        }
    }

    void slab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        Point4f point4f = null;
        switch (this.getToken((int)1).tok) {
            case 2: {
                this.checkLength2();
                int n = this.intParameter(1);
                if (!this.isSyntaxCheck) {
                    if (bl) {
                        this.viewer.depthToPercent(n);
                    } else {
                        this.viewer.slabToPercent(n);
                    }
                }
                return;
            }
            case 32769: {
                this.checkLength2();
                bl2 = true;
            }
            case 32768: {
                this.checkLength2();
                this.setBooleanProperty("slabEnabled", bl2);
                return;
            }
            case 280: {
                this.checkLength2();
                if (this.isSyntaxCheck) {
                    return;
                }
                this.viewer.slabReset();
                this.setBooleanProperty("slabEnabled", true);
                return;
            }
            case 21791: {
                this.checkLength2();
                if (this.isSyntaxCheck) {
                    return;
                }
                this.viewer.setSlabDepthInternal(bl);
                this.setBooleanProperty("slabEnabled", true);
                return;
            }
            case 1: {
                if (this.parameterAsString(1).equalsIgnoreCase("plane")) {
                    switch (this.getToken((int)2).tok) {
                        case 65549: {
                            break;
                        }
                        default: {
                            point4f = this.planeParameter(2);
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.slabInternal(point4f, bl);
                    }
                    return;
                }
                if (this.parameterAsString(1).equalsIgnoreCase("hkl")) {
                    Point4f point4f2 = point4f = this.getToken((int)2).tok == 65549 ? null : this.hklParameter(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.slabInternal(point4f, bl);
                    }
                    return;
                }
                if (!this.parameterAsString(1).equalsIgnoreCase("reference")) break;
                Point3f point3f = this.centerParameter(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.slabInternalReference(point3f);
                }
                return;
            }
        }
        this.invalidArgument();
    }

    int diameterToken() throws ScriptException {
        if (this.statementLength == 1) {
            return 32769;
        }
        int n = this.getToken((int)1).tok;
        switch (this.statementLength) {
            case 2: {
                break;
            }
            case 3: {
                if (n == 2 && this.getToken((int)2).tok == 1114170 || n == 0x110031 && this.isFloatParameter(2)) break;
                this.invalidArgument();
            }
        }
        return n;
    }

    void star() throws ScriptException {
        int n = 0;
        switch (this.diameterToken()) {
            case 32769: 
            case 327702: {
                n = -100;
                break;
            }
            case 32768: {
                break;
            }
            case 2: {
                int n2 = this.intParameter(1);
                if (this.statementLength == 2) {
                    if (n2 >= 750 || n2 < -100) {
                        this.numberOutOfRange(-100, 749);
                    }
                    n = (short)n2;
                    if (n2 <= 0) break;
                    n = (short)(n * 8);
                    break;
                }
                if (n2 < 0 || n2 > 100) {
                    this.numberOutOfRange(0, 100);
                }
                n = (short)(-n2);
                break;
            }
            case 3: {
                float f = this.floatParameter(1);
                if (f < 0.0f || f > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                n = (short)(f * 1000.0f * 2.0f);
                break;
            }
            case 327722: {
                n = -1000;
                break;
            }
            case 32823: {
                n = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(16, n);
    }

    void structure() throws ScriptException {
        String string = this.parameterAsString(1).toLowerCase();
        byte by = 0;
        BitSet bitSet = null;
        if (string.equals("helix")) {
            by = 3;
        } else if (string.equals("sheet")) {
            by = 2;
        } else if (string.equals("turn")) {
            by = 1;
        } else if (string.equals("none")) {
            by = 0;
        } else {
            this.invalidArgument();
        }
        switch (this.tokAt(2)) {
            case 32839: 
            case 65636: {
                bitSet = this.expression(2);
                this.checkStatementLength(this.iToken + 1);
                break;
            }
            default: {
                this.checkLength2();
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.clearPredefined(JmolConstants.predefinedVariable);
        this.viewer.setProteinType(by, bitSet);
    }

    void halo() throws ScriptException {
        int n = 0;
        switch (this.diameterToken()) {
            case 32769: {
                n = -20;
                break;
            }
            case 327702: {
                n = -100;
                break;
            }
            case 32768: {
                break;
            }
            case 2: {
                int n2 = this.intParameter(1);
                if (this.statementLength == 2) {
                    if (n2 >= 750 || n2 < -100) {
                        this.numberOutOfRange(-100, 749);
                    }
                    n = (short)n2;
                    if (n2 <= 0) break;
                    n = (short)(n * 8);
                    break;
                }
                if (n2 < 0 || n2 > 100) {
                    this.numberOutOfRange(0, 100);
                }
                n = (short)(-n2);
                break;
            }
            case 3: {
                float f = this.floatParameter(1);
                if (f < 0.0f || f > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                n = (short)(f * 1000.0f * 2.0f);
                break;
            }
            case 327722: {
                n = -1000;
                break;
            }
            case 32823: {
                n = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(17, n);
    }

    void spacefill() throws ScriptException {
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        switch (this.diameterToken()) {
            case 32769: 
            case 327702: {
                n = -100;
                break;
            }
            case 32768: {
                break;
            }
            case 0x110031: {
                bl = true;
                ++n2;
            }
            case 3: {
                float f = this.floatParameter(n2);
                if (f < 0.0f || f > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                n = (short)(f * 1000.0f * 2.0f);
                if (!bl) break;
                n = (short)(n + 10000);
                break;
            }
            case 2: {
                int n3 = this.intParameter(1);
                if (this.statementLength == 2) {
                    if (n3 >= 750 || n3 < -200) {
                        this.numberOutOfRange(-200, 749);
                    }
                    n = (short)n3;
                    if (n3 <= 0) break;
                    n = (short)(n * 8);
                    break;
                }
                if (n3 < 0 || n3 > 200) {
                    this.numberOutOfRange(0, 200);
                }
                n = (short)(-n3);
                break;
            }
            case 327722: {
                n = -1000;
                break;
            }
            case 32823: {
                n = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(0, n);
    }

    void wireframe() throws ScriptException {
        short s = this.getMadParameter();
        if (this.isSyntaxCheck) {
            return;
        }
        this.setShapeProperty(1, "type", new Integer(7));
        this.viewer.setShapeSize(1, s, this.viewer.getSelectedAtoms());
    }

    void ssbond() throws ScriptException {
        this.setShapeProperty(1, "type", new Integer(64));
        this.setShapeSize(1, this.getMadParameter());
        this.setShapeProperty(1, "type", new Integer(7));
    }

    void hbond(boolean bl) throws ScriptException {
        if (this.statementLength == 2 && this.getToken((int)1).tok == 359) {
            if (this.isSyntaxCheck) {
                return;
            }
            int n = this.viewer.autoHbond(null);
            this.scriptStatus(GT._((String)"{0} hydrogen bonds", (int)n));
            return;
        }
        this.setShapeProperty(1, "type", new Integer(1920));
        this.setShapeSize(1, this.getMadParameter());
        this.setShapeProperty(1, "type", new Integer(7));
    }

    void configuration() throws ScriptException {
        int n;
        BitSet bitSet;
        if (!this.isSyntaxCheck && this.viewer.getDisplayModelIndex() <= -2) {
            this.evalError(GT._((String)"{0} not allowed with background model displayed", (String)"\"CONFIGURATION\""));
        }
        if (this.statementLength == 1) {
            bitSet = this.viewer.setConformation();
            this.viewer.addStateScript("select " + Escape.escape((BitSet)this.viewer.getSelectionSet()));
            this.viewer.addStateScript("configuration;");
        } else {
            this.checkLength2();
            if (this.isSyntaxCheck) {
                return;
            }
            n = this.intParameter(1);
            bitSet = this.viewer.setConformation(n - 1);
            this.viewer.addStateScript("configuration " + n + ";");
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = this.viewer.hbondsAreVisible() ? 1 : 0;
        this.setShapeProperty(1, "type", new Integer(1920));
        this.viewer.setShapeSize(1, 0, bitSet);
        if (n != 0) {
            this.viewer.autoHbond(bitSet, bitSet, null);
        }
        this.viewer.select(bitSet, this.tQuiet);
    }

    void vector() throws ScriptException {
        int n = 1;
        this.iToken = this.statementLength;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 32769: {
                        break block0;
                    }
                    case 32768: {
                        n = 0;
                        break block0;
                    }
                    case 2: {
                        int n2 = this.intParameter(1);
                        if (n2 < 0 || n2 >= 20) {
                            this.numberOutOfRange(0, 19);
                        }
                        n = (short)n2;
                        break block0;
                    }
                    case 3: {
                        float f = this.floatParameter(1);
                        if (f > 3.0f) {
                            this.numberOutOfRange(0.0f, 3.0f);
                        }
                        n = (short)(f * 1000.0f * 2.0f);
                        break block0;
                    }
                }
                this.booleanOrNumberExpected();
                break;
            }
            case 3: {
                if (this.parameterAsString(1).equalsIgnoreCase("scale")) {
                    float f = this.floatParameter(2);
                    if (f < -10.0f || f > 10.0f) {
                        this.numberOutOfRange(-10.0f, 10.0f);
                    }
                    this.setFloatProperty("vectorScale", f);
                    return;
                }
                this.invalidArgument();
            }
        }
        this.setShapeSize(5, n);
    }

    void dipole() throws ScriptException {
        String string = null;
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.viewer.loadShape(24);
        if (this.tokAt(1) == 6 && this.listIsosurface(24)) {
            return;
        }
        this.setShapeProperty(24, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(24, "thisID", null);
            return;
        }
        block12: for (int i = 1; i < this.statementLength; ++i) {
            string = null;
            object = null;
            switch (this.getToken((int)i).tok) {
                case 32769: {
                    string = "on";
                    break;
                }
                case 32768: {
                    string = "off";
                    break;
                }
                case 32810: {
                    string = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string = "dipoleValue";
                    object = new Float(this.floatParameter(i));
                    break;
                }
                case 32839: {
                    string = "atomBitset";
                }
                case 65636: {
                    if (string == null) {
                        string = bl || bl2 ? "endSet" : "startSet";
                    }
                    object = this.expression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 7: 
                case 65539: {
                    Point3f point3f = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = bl || bl2 ? "endCoord" : "startCoord";
                    object = point3f;
                    bl2 = true;
                    break;
                }
                case 860162: {
                    string = "bonds";
                    break;
                }
                case 359: {
                    continue block12;
                }
                case 1: {
                    String string2 = this.parameterAsString(i);
                    if (string2.equalsIgnoreCase("cross")) {
                        string = "cross";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("noCross")) {
                        string = "cross";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("offset")) {
                        float f = this.floatParameter(++i);
                        if (this.theTok == 2) {
                            string = "dipoleOffsetPercent";
                            object = new Integer((int)f);
                            break;
                        }
                        string = "dipoleOffset";
                        object = new Float(f);
                        break;
                    }
                    if (string2.equalsIgnoreCase("value")) {
                        string = "dipoleValue";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("offsetSide")) {
                        string = "offsetSide";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("width")) {
                        string = "dipoleWidth";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (bl3) {
                        this.invalidArgument();
                    }
                    string = "thisID";
                    object = string2.toLowerCase();
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            boolean bl4 = bl3 = this.theTok != 32810;
            if (string == null) continue;
            this.setShapeProperty(24, string, object);
        }
        if (bl2 || bl) {
            this.setShapeProperty(24, "set", null);
        }
    }

    void animationMode() throws ScriptException {
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.statementLength > 5) {
            this.badArgumentCount();
        }
        int n = 0;
        switch (this.getToken((int)2).tok) {
            case 317: {
                n = 1;
                break;
            }
            case 1: {
                String string = this.parameterAsString(2);
                if (string.equalsIgnoreCase("once")) {
                    f2 = 0.0f;
                    f = 0.0f;
                    break;
                }
                if (string.equalsIgnoreCase("palindrome")) {
                    n = 2;
                    break;
                }
                this.invalidArgument();
            }
        }
        if (this.statementLength >= 4) {
            f = f2 = this.floatParameter(3);
            if (this.statementLength == 5) {
                f2 = this.floatParameter(4);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationReplayMode(n, f, f2);
        }
    }

    void vibration() throws ScriptException {
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 32769: {
                this.checkLength2();
                f = this.viewer.getVibrationPeriod();
                break;
            }
            case 32768: {
                this.checkLength2();
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength2();
                f = this.floatParameter(1);
                break;
            }
            case 1: {
                String string = this.optParameterAsString(1);
                if (string.equalsIgnoreCase("scale")) {
                    float f2 = this.floatParameter(2);
                    if (f2 < -10.0f || f2 > 10.0f) {
                        this.numberOutOfRange(-10.0f, 10.0f);
                    }
                    this.setFloatProperty("vibrationScale", f2);
                    return;
                }
                if (string.equalsIgnoreCase("period")) {
                    f = this.floatParameter(2);
                    this.setFloatProperty("vibrationPeriod", f);
                    return;
                }
                this.invalidArgument();
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.invalidArgument();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (f == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-f);
    }

    void animationDirection() throws ScriptException {
        this.checkStatementLength(4);
        boolean bl = false;
        this.getToken(2);
        if (this.theTok == 0x110030) {
            bl = true;
        } else if (this.theTok != 0x110031) {
            this.invalidArgument();
        }
        int n = this.intParameter(3);
        if (n != 1) {
            this.numberMustBe(-1, 1);
        }
        if (bl) {
            n = -n;
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationDirection(n);
        }
    }

    void calculate() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.iToken >= 2) {
            this.clearPredefined(JmolConstants.predefinedVariable);
            switch (this.getToken((int)1).tok) {
                case 196620: {
                    this.viewer.calculateSurface(null, null, -1.0f);
                    if (!this.isSyntaxCheck) {
                        this.viewer.addStateScript(this.thisCommand);
                    }
                    return;
                }
                case 73997: {
                    this.checkLength2();
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.autoHbond(null);
                    return;
                }
                case 328980: {
                    this.checkLength2();
                    if (!this.isSyntaxCheck) {
                        this.viewer.calculateStructures();
                    }
                    return;
                }
            }
        }
        this.evalError(GT._((String)"Calculate what?") + "hbonds?  surface? structure?");
    }

    void dots(int n, int n2) throws ScriptException {
        if (!this.isSyntaxCheck) {
            this.viewer.loadShape(n2);
        }
        this.setShapeProperty(n2, "init", null);
        if (this.statementLength == n) {
            this.setShapeSize(n2, 1);
            return;
        }
        int n3 = 0;
        switch (this.getToken((int)n).tok) {
            case 32769: 
            case 327702: {
                n3 = 1;
                break;
            }
            case 32823: {
                n3 = -1;
                break;
            }
            case 32768: {
                break;
            }
            case 0x110031: {
                float f = this.floatParameter(++n);
                if (f < 0.0f || f > 10.0f) {
                    this.numberOutOfRange(0.0f, 2.0f);
                }
                n3 = (short)(f == 0.0f ? 0.0f : f * 1000.0f + 11002.0f);
                break;
            }
            case 3: {
                float f = this.floatParameter(n);
                if (f < 0.0f || f > 10.0f) {
                    this.numberOutOfRange(0.0f, 10.0f);
                }
                n3 = (short)(f == 0.0f ? 0.0f : f * 1000.0f + 1002.0f);
                break;
            }
            case 2: {
                int n4 = this.intParameter(n);
                if (this.statementLength > n + 1 && this.statement[n + 1].tok == 335889) {
                    this.setShapeProperty(n2, "atom", new Integer(n4));
                    ++n;
                    this.setShapeProperty(n2, "radius", new Float(this.floatParameter(++n)));
                    if (this.statementLength > n + 1 && this.statement[++n].tok == 881923) {
                        this.setShapeProperty(n2, "colorRGB", new Integer(this.getArgbParam(++n)));
                    }
                    if (this.getToken((int)n).tok != 32839) {
                        this.invalidArgument();
                    }
                    this.setShapeProperty(n2, "dots", this.statement[n].value);
                    return;
                }
                if (n4 < 0 || n4 > 1000) {
                    this.numberOutOfRange(0, 1000);
                }
                n3 = (short)(n4 == 0 ? 0 : n4 + 1);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(n2, n3);
    }

    void proteinShape(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 32769: {
                n2 = -1;
                break;
            }
            case 32768: {
                break;
            }
            case 328980: {
                n2 = -2;
                break;
            }
            case 32802: 
            case 327722: {
                n2 = -4;
                break;
            }
            case 2: {
                int n3 = this.intParameter(1);
                if (n3 >= 500) {
                    this.numberOutOfRange(0, 499);
                }
                n2 = (short)(n3 * 4 * 2);
                break;
            }
            case 3: {
                float f = this.floatParameter(1);
                if (f > 4.0f) {
                    this.numberOutOfRange(0.0f, 4.0f);
                }
                n2 = (short)(f * 1000.0f * 2.0f);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(n, n2);
    }

    void animation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 32769: {
                bl = true;
            }
            case 32768: {
                if (this.isSyntaxCheck) break;
                this.viewer.setAnimationOn(bl);
                break;
            }
            case 334: {
                this.frame(2, true);
                break;
            }
            case 324: {
                this.frame(2, false);
                break;
            }
            case 32799: {
                this.animationMode();
                break;
            }
            case 32800: {
                this.animationDirection();
                break;
            }
            case 1: {
                String string = this.parameterAsString(1);
                if (string.equalsIgnoreCase("fps")) {
                    this.checkLength3();
                    this.setIntProperty("animationFps", this.intParameter(2));
                    break;
                }
            }
            default: {
                this.frameControl(1, true);
            }
        }
    }

    void file() throws ScriptException {
        int n = this.intParameter(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int n2 = this.viewer.getModelNumberIndex(n * 1000000 + 1, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.viewer.getModelNumberIndex((n + 1) * 1000000 + 1, false);
            if (n3 < 0) {
                n3 = this.viewer.getModelCount();
            }
            --n3;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(n2, n3, false);
        this.viewer.setCurrentModelIndex(-1);
    }

    void frame(int n, boolean bl) throws ScriptException {
        int n2;
        int n3;
        boolean bl2 = true;
        if (this.getToken((int)n).tok == 0x110030) {
            this.checkStatementLength(++n + 1);
            if (this.getToken((int)n).tok != 2 || this.intParameter(n) != 1) {
                this.invalidArgument();
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setAnimationPrevious();
            }
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int[] nArray = new int[]{-1, -1};
        int n4 = 0;
        block9: for (n3 = n; n3 < this.statementLength; ++n3) {
            switch (this.getToken((int)n3).tok) {
                case 65551: 
                case 1114169: {
                    this.checkStatementLength(n + (bl4 ? 2 : 1));
                    bl5 = true;
                    continue block9;
                }
                case 0x110030: {
                    if (n4 != 1) {
                        this.invalidArgument();
                    }
                    bl6 = true;
                    continue block9;
                }
                case 65549: {
                    this.checkStatementLength(n + 1);
                    continue block9;
                }
                case 3: {
                    bl2 = false;
                    if (this.floatParameter(n3) < 0.0f) {
                        bl6 = true;
                    }
                }
                case 2: {
                    if (n4 == 2) {
                        this.invalidArgument();
                    }
                    if ((n2 = this.statement[n3].intValue) >= 1000 && n2 < 1000000 && this.viewer.haveFileSet()) {
                        n2 = n2 / 1000 * 1000000 + n2 % 1000;
                    }
                    if (!bl2 && n2 == 0) {
                        bl5 = true;
                    }
                    if (n2 >= 1000000) {
                        bl2 = false;
                    }
                    nArray[n4++] = n2;
                    continue block9;
                }
                case 32825: {
                    bl3 = true;
                    continue block9;
                }
                case 32830: {
                    bl4 = true;
                    continue block9;
                }
                default: {
                    this.checkStatementLength(n + 1);
                    this.frameControl(n3, false);
                    return;
                }
            }
        }
        n3 = this.viewer.haveFileSet() ? 1 : 0;
        if (bl4 && n4 == 0) {
            bl5 = true;
        }
        if ((n3 != 0 || !bl2 || bl5) && bl) {
            this.evalError(GT._((String)"trajectory not applicable in this context"));
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl5) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1, false);
            if (!bl4) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n4 == 2 && !bl4) {
            bl6 = true;
        }
        if (n3 != 0) {
            bl2 = false;
        } else if (bl2) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (nArray[n2] < 0) continue;
                int n5 = n2;
                nArray[n5] = nArray[n5] % 1000000;
            }
        }
        n2 = bl ? nArray[0] - 1 : this.viewer.getModelNumberIndex(nArray[0], bl2);
        int n6 = -1;
        if (n3 != 0 && n4 == 1 && n2 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n2 = this.viewer.getModelNumberIndex(nArray[0], false);
                if (n2 >= 0) {
                    n6 = this.viewer.getModelNumberIndex(nArray[0] + 1000000, false);
                    if (n6 < 0) {
                        n6 = this.viewer.getModelCount();
                    }
                    --n6;
                    if (bl4) {
                        n4 = 2;
                    } else if (!bl6 && n6 != n2) {
                        bl6 = true;
                    }
                    boolean bl7 = bl4 = bl4 || n2 == n6;
                }
            }
        }
        if (!bl3 && !bl4 || n2 >= 0) {
            if (bl) {
                this.viewer.setTrajectory(n2);
            } else {
                this.viewer.setCurrentModelIndex(n2);
            }
        }
        if (bl3 && n4 == 2 || bl4 || bl6) {
            if (n6 < 0) {
                n6 = bl ? nArray[1] - 1 : this.viewer.getModelNumberIndex(nArray[1], bl2);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(n2, n6, bl);
            if (bl) {
                this.viewer.setTrajectory(n2);
            } else {
                this.viewer.setCurrentModelIndex(bl6 && !bl4 ? -1 : (n2 >= 0 ? n2 : 0));
            }
        }
        if (bl3) {
            this.viewer.resumeAnimation();
        }
    }

    BitSet bitSetForModelNumberSet(int[] nArray, int n) {
        BitSet bitSet = new BitSet();
        if (this.isSyntaxCheck) {
            return bitSet;
        }
        int n2 = this.viewer.getModelCount();
        boolean bl = this.viewer.haveFileSet();
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = nArray[i];
            if (n4 < 1000000 && bl) {
                n4 *= 1000000;
            }
            if ((n3 = n4 % 1000000) == 0) {
                int n5;
                int n6 = this.viewer.getModelNumberIndex(n4 + 1, false);
                int n7 = n5 = n4 == 0 ? n2 : this.viewer.getModelNumberIndex(n4 + 1000001, false);
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n5 < 0) {
                    n5 = n2;
                }
                for (int j = n6; j < n5; ++j) {
                    bitSet.or(this.viewer.getModelAtomBitSet(j));
                }
                continue;
            }
            bitSet.or(this.viewer.getModelAtomBitSet(this.viewer.getModelNumberIndex(n4, false)));
        }
        return bitSet;
    }

    void frameControl(int n, boolean bl) throws ScriptException {
        this.checkStatementLength(n + 1);
        int n2 = this.getToken((int)n).tok;
        if (this.isSyntaxCheck) {
            switch (n2) {
                case 32824: 
                case 32825: 
                case 32826: 
                case 32827: 
                case 32828: 
                case 32829: 
                case 32841: 
                case 35091: {
                    return;
                }
            }
        } else {
            switch (n2) {
                case 32829: {
                    this.viewer.reverseAnimation();
                }
                case 32824: 
                case 32825: {
                    this.viewer.resumeAnimation();
                    return;
                }
                case 35091: {
                    this.viewer.pauseAnimation();
                    return;
                }
                case 32826: {
                    this.viewer.setAnimationNext();
                    return;
                }
                case 32827: {
                    this.viewer.setAnimationPrevious();
                    return;
                }
                case 32828: {
                    this.viewer.rewindAnimation();
                    return;
                }
                case 32841: {
                    this.viewer.setAnimationLast();
                    return;
                }
            }
        }
        this.evalError(GT._((String)"invalid {0} control keyword", (String)"frame"));
    }

    int getShapeType(int n) throws ScriptException {
        int n2 = JmolConstants.shapeTokenIndex(n);
        if (n2 < 0) {
            this.unrecognizedObject();
        }
        return n2;
    }

    void font() throws ScriptException {
        int n = 0;
        int n2 = 0;
        String string = "SansSerif";
        String string2 = "Plain";
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                if (this.getToken((int)4).tok != 1) {
                    this.invalidArgument();
                }
                string2 = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 1) {
                    this.invalidArgument();
                }
                string = this.parameterAsString(3);
            }
            case 3: {
                if (this.getToken((int)2).tok != 2) {
                    this.integerExpected();
                }
                n2 = this.intParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            default: {
                this.badArgumentCount();
            }
        }
        Font3D font3D = this.viewer.getFont3D(string, string2, n2);
        this.viewer.loadShape(n);
        this.setShapeProperty(n, "font", font3D);
    }

    void set() throws ScriptException {
        boolean bl;
        if (this.statementLength == 1) {
            this.showString(this.viewer.getAllSettings(60));
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 8560: {
                this.setAxes(2);
                return;
            }
            case 24833: {
                this.background(2);
                return;
            }
            case 8193: {
                this.setBondmode();
                return;
            }
            case 2959625: {
                this.label(2);
                return;
            }
            case 8561: {
                this.setBoundbox(2);
                return;
            }
            case 8204: 
            case 881923: {
                this.setDefaultColors();
                return;
            }
            case 8553: 
            case 9067: {
                this.setSelectionHalo(2);
                return;
            }
            case 10507: {
                this.setEcho();
                return;
            }
            case 8194: {
                this.setFontsize();
                return;
            }
            case 73997: {
                this.setHbond();
                return;
            }
            case 8554: {
                this.history(2);
                return;
            }
            case 75026: {
                this.setMonitor(2);
                return;
            }
            case 860169: {
                string = this.parameterAsString(1).toLowerCase();
                if (string.startsWith("property_")) break;
                this.setProperty();
                return;
            }
            case 8221: {
                this.setScale3d();
                return;
            }
            case 13632: {
                this.checkLength4();
                this.setSpin(this.parameterAsString(2), (int)this.floatParameter(3));
                return;
            }
            case 8563: {
                this.setFrank(2);
                return;
            }
            case 8484: {
                this.setSsbond();
                return;
            }
            case 205170: {
                this.setUnitcell(2);
                return;
            }
            case 8196: {
                this.setPicking();
                return;
            }
            case 8225: {
                this.setPickingStyle();
                return;
            }
            case 335881: {
                n2 = this.intParameter(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setFormalCharges(n2);
                }
                return;
            }
            case 8199: {
                if (this.statementLength == 2 || this.statement[2].tok != 2) {
                    string = "specular";
                    break;
                }
            }
            case 8200: {
                string = "specularPercent";
            }
            case 8192: {
                if (string == null) {
                    string = "ambientPercent";
                }
            }
            case 8223: {
                if (string == null) {
                    string = "diffusePercent";
                }
                if ((n = this.intParameter(2)) <= 100 && n >= 0) break;
                this.numberOutOfRange(0, 100);
                break;
            }
            case 8201: {
                n = this.intParameter(2);
                if (n > 100) {
                    this.numberOutOfRange(0, 100);
                }
                if (n >= 0) {
                    string = "specularPower";
                    break;
                }
                if (n < -10 || n > -1) {
                    this.numberOutOfRange(-10, -1);
                }
                n = -n;
                string = "specularExponent";
                break;
            }
            case 8202: {
                n = this.intParameter(2);
                if (n > 10 || n < 1) {
                    this.numberOutOfRange(1, 10);
                }
                string = "specularExponent";
                break;
            }
            case 860162: {
                string = "showMultipleBonds";
                break;
            }
            case 8487: {
                this.checkLength3();
                int n3 = this.intParameter(2);
                if (n3 < 0 || n3 > 20) {
                    this.numberOutOfRange(0, 20);
                }
                string = "strandCount";
                break;
            }
            case 204801: {
                string = "selectHetero";
                break;
            }
            case 204802: {
                string = "selectHydrogen";
                break;
            }
            case 335889: {
                string = "solventProbeRadius";
                break;
            }
            case 204804: {
                string = "solventProbe";
                break;
            }
            default: {
                string = this.parameterAsString(1);
                if (string.charAt(0) == '_') {
                    this.invalidArgument();
                }
                if (string.toLowerCase().indexOf("label") == 0 && this.setLabel(string.substring(5))) {
                    return;
                }
                if (string.equalsIgnoreCase("defaultColorScheme")) {
                    this.setDefaultColors();
                    return;
                }
                if (string.equalsIgnoreCase("measurementNumbers") || string.equalsIgnoreCase("measurementLabels")) {
                    this.setMonitor(2);
                    return;
                }
                if (string.equalsIgnoreCase("defaultLattice")) {
                    Point3f point3f;
                    if (this.getToken((int)2).tok == 2) {
                        int n4 = this.intParameter(2);
                        point3f = new Point3f((float)n4, (float)n4, (float)n4);
                    } else {
                        point3f = (Point3f)this.getPointOrPlane(2, false, false, false, false, 3, 3);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.setDefaultLattice(point3f);
                    }
                    return;
                }
                if (string.equalsIgnoreCase("toggleLabel")) {
                    BitSet bitSet = this.expression(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.togglePickingLabel(bitSet);
                    }
                    return;
                }
                if (string.equalsIgnoreCase("logLevel")) {
                    this.checkLength3();
                    int n5 = this.intParameter(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    Logger.setLogLevel((int)n5);
                    Logger.info((String)("logging level set to " + n5));
                    return;
                }
                if (string.equalsIgnoreCase("backgroundModel")) {
                    this.checkLength3();
                    if (!this.isSyntaxCheck) {
                        this.viewer.setBackgroundModel(this.statement[2].intValue);
                    }
                    return;
                }
                if (string.equalsIgnoreCase("language")) {
                    this.checkLength3();
                    this.setStringProperty(string, this.parameterAsString(2));
                    return;
                }
                if (Parser.isOneOf((String)string.toLowerCase(), (String)"spinx;spiny;spinz;spinfps")) {
                    this.checkLength3();
                    this.setSpin(string.substring(4), (int)this.floatParameter(2));
                    return;
                }
                if (!string.equalsIgnoreCase("showSelections")) break;
                string = "selectionHalos";
            }
        }
        String string2 = "";
        boolean bl2 = bl = !this.isSyntaxCheck && this.scriptLevel <= this.scriptReportingLevel;
        if (string != null && this.setParameter(string, n)) {
            if (this.isSyntaxCheck) {
                return;
            }
        } else {
            Object object = this.parameterExpression(this.getToken((int)2).tok == 5308460 ? 3 : 2, string);
            if (this.isSyntaxCheck) {
                return;
            }
            if (string.startsWith("property_")) {
                n2 = this.viewer.getAtomCount();
                Viewer.setData(string, new Object[]{string, "" + object, this.viewer.getSelectedAtoms()}, n2, 0, Integer.MIN_VALUE);
                return;
            }
            if (object instanceof Boolean) {
                this.setBooleanProperty(string, (Boolean)object);
            } else if (object instanceof Integer) {
                this.setIntProperty(string, (Integer)object);
            } else if (object instanceof Float) {
                this.setFloatProperty(string, ((Float)object).floatValue());
            } else if (object instanceof String) {
                this.setStringProperty(string, (String)object);
            } else if (object instanceof Bond.BondSet) {
                this.setIntProperty(string, BitSetUtil.cardinalityOf((BitSet)((BitSet)object)));
                this.setStringProperty(string + "_set", Escape.escape((BitSet)((BitSet)object), (boolean)false));
                if (bl) {
                    this.viewer.showParameter(string + "_set", true, 80);
                }
            } else if (object instanceof BitSet) {
                this.setIntProperty(string, BitSetUtil.cardinalityOf((BitSet)((BitSet)object)));
                this.setStringProperty(string + "_set", Escape.escape((BitSet)((BitSet)object)));
                if (bl) {
                    this.viewer.showParameter(string + "_set", true, 80);
                }
            } else if (object instanceof Point3f) {
                string2 = Escape.escape((Tuple3f)((Point3f)object));
                this.setStringProperty(string, string2);
            } else if (object instanceof Point4f) {
                string2 = Escape.escape((Point4f)((Point4f)object));
                this.setStringProperty(string, string2);
            }
        }
        if (bl) {
            this.viewer.showParameter(string, true, 80);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean setParameter(String string, int n) throws ScriptException {
        if (string.equalsIgnoreCase("scriptReportingLevel")) {
            this.checkLength3();
            int n2 = this.intParameter(2);
            if (this.isSyntaxCheck) return true;
            this.scriptReportingLevel = n2;
            this.setIntProperty(string, n2);
            return true;
        } else if (string.equalsIgnoreCase("defaults")) {
            this.checkLength3();
            String string2 = this.parameterAsString(2).toLowerCase();
            if (!string2.equals("jmol") && !string2.equals("rasmol")) {
                this.invalidArgument();
            }
            this.setStringProperty("defaults", string2);
            return true;
        } else if (string.equalsIgnoreCase("historyLevel")) {
            this.checkLength3();
            int n3 = this.intParameter(2);
            if (this.isSyntaxCheck) return true;
            this.commandHistoryLevelMax = n3;
            this.setIntProperty(string, n3);
            return true;
        } else if (string.equalsIgnoreCase("dipoleScale")) {
            this.checkLength3();
            float f = this.floatParameter(2);
            if (f < -10.0f || f > 10.0f) {
                this.numberOutOfRange(-10.0f, 10.0f);
            }
            this.setFloatProperty("dipoleScale", f);
            return true;
        } else if (this.statementLength == 2) {
            if (this.isSyntaxCheck) return true;
            this.setBooleanProperty(string, true);
            return true;
        } else {
            if (this.statementLength != 3) return false;
            if (n != Integer.MAX_VALUE) {
                this.setIntProperty(string, n);
                return true;
            }
            this.getToken(2);
            if (this.theTok == 65549) {
                if (this.isSyntaxCheck) return true;
                this.viewer.unsetProperty(string);
                return true;
            } else {
                if (this.theTok != 32769 && this.theTok != 32768) return false;
                if (this.isSyntaxCheck) return true;
                this.setBooleanProperty(string, this.theTok == 32769);
            }
        }
        return true;
    }

    Object parameterExpression(int n, String string) throws ScriptException {
        Rpn rpn = new Rpn(16);
        for (int i = n; i < this.statementLength; ++i) {
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 32768: 
                case 32769: 
                case 32839: {
                    rpn.addX(this.theToken);
                    break;
                }
                case 2: 
                case 65562: {
                    rpn.addX(new Token(2, this.theToken.intValue));
                    break;
                }
                case 65541: {
                    rpn.addX(new Token(7, this.centerParameter(i)));
                    i = this.iToken;
                    break;
                }
                case 65539: {
                    object = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    i = this.iToken;
                    break;
                }
                case 65636: {
                    object = this.expression(this.statement, i, true, true, false);
                    i = this.iToken;
                    break;
                }
                case 65540: {
                    this.invalidArgument();
                }
                case 65547: {
                    break;
                }
                case 65537: {
                    Token token = this.getBitsetPropertySelector(i);
                    if (this.tokAt(this.iToken + 1) == 65537) {
                        if (this.tokAt(this.iToken + 2) == 65551) {
                            token.intValue |= 0xC0;
                            this.getToken(this.iToken + 2);
                        }
                        if (Compiler.tokAttrOr(this.tokAt(this.iToken + 2), 64, 128)) {
                            token.intValue |= this.getToken((int)(this.iToken + 2)).tok;
                        }
                    }
                    if (!rpn.addOp(token)) {
                        this.invalidArgument();
                    }
                    i = this.iToken;
                    break;
                }
                default: {
                    if (Compiler.tokAttr(this.theTok, 0x110000) || Compiler.tokAttr(this.theTok, 0x210000)) {
                        if (rpn.addOp(this.theToken)) break;
                        --this.iToken;
                        this.invalidArgument();
                        break;
                    }
                    String string2 = this.parameterAsString(i);
                    if (this.isSyntaxCheck) {
                        object = string2;
                        break;
                    }
                    object = this.viewer.getParameter(string2);
                    if (!(object instanceof String)) break;
                    object = this.getStringObjectAsToken((String)object);
                }
            }
            if (object == null) continue;
            if (object instanceof Boolean) {
                rpn.addX((Boolean)object != false ? Token.tokenOn : Token.tokenOff);
                continue;
            }
            if (object instanceof Integer) {
                rpn.addX(new Token(2, (Integer)object));
                continue;
            }
            if (object instanceof Float) {
                rpn.addX(new Token(3, object));
                continue;
            }
            if (object instanceof String) {
                rpn.addX(new Token(4, object));
                continue;
            }
            if (object instanceof Point3f) {
                rpn.addX(new Token(7, object));
                continue;
            }
            if (object instanceof Point4f) {
                rpn.addX(new Token(8, object));
                continue;
            }
            if (object instanceof BitSet) {
                rpn.addX(new Token(32839, object));
                continue;
            }
            if (object instanceof Token) {
                rpn.addX((Token)object);
                continue;
            }
            this.invalidArgument();
        }
        Token token = rpn.getResult(false);
        if (token == null) {
            if (!this.isSyntaxCheck) {
                rpn.dumpStacks();
            }
            this.endOfStatementUnexpected();
        }
        if (string == null) {
            return Token.bValue(token);
        }
        switch (token.tok) {
            case 32768: 
            case 32769: {
                return token == Token.tokenOn;
            }
            case 2: {
                return new Integer(token.intValue);
            }
        }
        return token.value;
    }

    void assignBitsetVariable(String string, BitSet bitSet) {
        this.variables.put(string, bitSet);
        this.setStringProperty("@" + string, Escape.escape((BitSet)bitSet));
    }

    int[] getAtomIndices(BitSet bitSet) {
        int n = bitSet.size();
        int n2 = 0;
        int n3 = this.viewer.getModelSet().getAtomCount();
        int[] nArray = new int[n3];
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[i] = ++n2;
        }
        return nArray;
    }

    BitSet getAtomBitsetFromBonds(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n = this.viewer.getBondCount();
        Bond[] bondArray = this.viewer.getModelSet().getBonds();
        int n2 = n;
        while (--n2 >= 0) {
            if (!bitSet.get(n2)) continue;
            bitSet2.set(bondArray[n2].getAtomIndex1());
            bitSet2.set(bondArray[n2].getAtomIndex2());
        }
        return bitSet2;
    }

    String getBitsetIdent(BitSet bitSet, String string, Object object, boolean bl) {
        String string2;
        int n;
        int[] nArray;
        int n2;
        boolean bl2;
        boolean bl3 = bl2 = !(object instanceof Bond.BondSet);
        if (bl2 && string == null) {
            string = this.viewer.getStandardLabelFormat();
        }
        int n3 = n2 = string == null ? -1 : string.indexOf("%");
        if (bitSet == null || this.isSyntaxCheck || n2 < 0) {
            return string == null ? "" : string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = bitSet.size();
        ModelSet modelSet = this.viewer.getModelSet();
        int n5 = 0;
        int[] nArray2 = nArray = bl2 || !bl ? null : ((Bond.BondSet)object).getAssociatedAtoms();
        if (nArray == null && string != null && string.indexOf("%D") > 0) {
            nArray = this.getAtomIndices(bitSet);
        }
        int n6 = 0;
        String[] stringArray = null;
        Object object2 = null;
        while (n2 >= 0 && (n2 = string.indexOf("{", n2 + 1)) > 0) {
            n = string.indexOf("}", n2);
            if (n > 0) {
                float[] fArray;
                if (n6 == 0) {
                    for (int i = n2; i < string.length(); ++i) {
                        if (string.charAt(i) != '{') continue;
                        ++n6;
                    }
                    stringArray = new String[n6];
                    object2 = new float[n6][];
                    n6 = 0;
                }
                if ((fArray = Viewer.getDataFloat(string2 = string.substring(n2 + 1, n))) != null) {
                    object2[n6] = fArray;
                    stringArray[n6++] = '{' + string2 + '}';
                }
            }
            n2 = n;
        }
        for (n = 0; n < n4; ++n) {
            if (!bitSet.get(n)) continue;
            string2 = string;
            if (bl2) {
                if (string2 == null) {
                    string2 = modelSet.getAtomAt(n).getIdentity();
                } else {
                    string2 = modelSet.getAtomAt(n).formatLabel(string2, '\u0000', nArray);
                    for (int i = 0; i < n6; ++i) {
                        if (n >= object2[i].length) continue;
                        string2 = TextFormat.formatString((String)string2, (String)stringArray[i], (float)object2[i][n]);
                    }
                }
            } else {
                Bond bond = modelSet.getBondAt(n);
                if (string2 == null) {
                    string2 = bond.getIdentity();
                } else {
                    int n7;
                    string2 = bond.formatLabel(string2, nArray);
                    int n8 = bond.getAtomIndex1();
                    int n9 = bond.getAtomIndex2();
                    for (n7 = 0; n7 < n6; ++n7) {
                        if (n8 >= object2[n7].length) continue;
                        string2 = TextFormat.formatString((String)string2, (String)(stringArray[n7] + "1"), (float)object2[n7][n8]);
                    }
                    for (n7 = 0; n7 < n6; ++n7) {
                        if (n9 >= object2[n7].length) continue;
                        string2 = TextFormat.formatString((String)string2, (String)(stringArray[n7] + "2"), (float)object2[n7][n9]);
                    }
                }
            }
            string2 = TextFormat.formatString((String)string2, (String)"#", (int)(++n5));
            if (n5 > 1) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    Token getBitsetPropertySelector(int n) throws ScriptException {
        int n2 = this.getToken((int)(++n)).tok;
        String string = this.parameterAsString(n).toLowerCase();
        switch (n2) {
            default: {
                if (Compiler.tokAttrOr(n2, 327680, 851968)) break;
                this.invalidArgument();
            }
            case 1: {
                if (string.equals("x")) {
                    n2 = 327712;
                    break;
                }
                if (string.equals("y")) {
                    n2 = 327713;
                    break;
                }
                if (string.equals("z")) {
                    n2 = 327714;
                    break;
                }
                this.invalidArgument();
            }
        }
        return new Token(1114185, n2, string);
    }

    Object getBitsetProperty(BitSet bitSet, int n, Point3f point3f, Point4f point4f, Object object, Object object2, boolean bl) throws ScriptException {
        Object object3;
        int n2;
        boolean bl2 = !(object instanceof Bond.BondSet);
        boolean bl3 = Compiler.tokAttr(n, 64);
        boolean bl4 = Compiler.tokAttr(n, 128);
        boolean bl5 = Compiler.tokAttr(n, 192);
        if (bl5) {
            bl4 = false;
            bl3 = false;
        }
        float[] fArray = null;
        BitSet bitSet2 = null;
        if ((n &= 0xFFFFFF3F) == 851969) {
            BitSet bitSet3 = bitSet2 = !bl2 && !this.isSyntaxCheck ? this.getAtomBitsetFromBonds(bitSet) : bitSet;
        }
        if (n == 860162) {
            BitSet bitSet4 = bitSet2 = bl2 && !this.isSyntaxCheck ? this.viewer.getBondsForSelectedAtoms(bitSet) : bitSet;
        }
        if (bitSet2 != null) {
            if (!bl4 && !bl3 || this.isSyntaxCheck) {
                return bitSet2;
            }
            int n3 = bitSet2.size();
            int n4 = 0;
            if (bl3) {
                n4 = -1;
                while (++n4 < n3 && !bitSet2.get(n4)) {
                }
            } else if (bl4) {
                n4 = n3;
                while (--n4 >= 0 && !bitSet2.get(n4)) {
                }
            }
            bitSet2.clear();
            if (n4 >= 0 && n4 < n3) {
                bitSet2.set(n4);
            }
            return bitSet2;
        }
        if (n == 851972) {
            return bl3 || bl4 ? "" : this.getBitsetIdent(bitSet, null, object, bl);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MAX_VALUE;
        float f = 0.0f;
        float f2 = -3.4028235E38f;
        float f3 = Float.MAX_VALUE;
        Point3f point3f2 = new Point3f();
        if (n == 2949137 && point3f == null && point4f == null) {
            return point3f2;
        }
        boolean bl6 = true;
        Point3f point3f3 = n == 881923 ? new Point3f() : null;
        ModelSet modelSet = this.viewer.getModelSet();
        float[] fArray2 = n == 860169 ? Viewer.getDataFloat((String)object2) : null;
        int n9 = 0;
        if (bl2) {
            int n10 = n9 = this.isSyntaxCheck ? 0 : this.viewer.getAtomCount();
            if (bl5) {
                fArray = new float[n9];
            }
            for (n2 = 0; n2 < n9; ++n2) {
                if (bitSet != null && !bitSet.get(n2)) continue;
                ++n5;
                object3 = modelSet.getAtomAt(n2);
                if (bl6) {
                    int n11 = 0;
                    switch (n) {
                        case 327681: {
                            n11 = ((Atom)((Object)object3)).getAtomNumber();
                            break;
                        }
                        case 327684: {
                            n11 = n2;
                            break;
                        }
                        case 327687: {
                            n11 = ((Atom)((Object)object3)).getElementNumber();
                            break;
                        }
                        case 327686: {
                            n11 = ((Atom)((Object)object3)).getAtomicAndIsotopeNumber();
                            break;
                        }
                        case 335881: {
                            n11 = ((Atom)((Object)object3)).getFormalCharge();
                            break;
                        }
                        case 327699: {
                            n11 = ((Atom)((Object)object3)).getAtomSite();
                            break;
                        }
                        case 327701: {
                            BitSet bitSet5 = ((Atom)((Object)object3)).getAtomSymmetry();
                            int n12 = bitSet5.size();
                            int n13 = 0;
                            int n14 = Integer.MAX_VALUE;
                            int n15 = Integer.MIN_VALUE;
                            for (int i = 0; i < n12; ++i) {
                                if (!bitSet5.get(i)) continue;
                                n11 += i + 1;
                                n14 = Math.min(n14, i + 1);
                                n15 = Math.max(n15, i + 1);
                                ++n13;
                            }
                            if (bl3) {
                                n11 = n14;
                            } else if (bl4) {
                                n11 = n15;
                            }
                            n5 += n13 - 1;
                            break;
                        }
                        case 327694: {
                            n11 = ((Atom)((Object)object3)).getMoleculeNumber();
                            break;
                        }
                        case 327695: {
                            n11 = ((Atom)((Object)object3)).getOccupancy();
                            break;
                        }
                        case 327696: {
                            n11 = ((Atom)((Object)object3)).getPolymerLength();
                            break;
                        }
                        case 327698: {
                            n11 = ((Atom)((Object)object3)).getResno();
                            break;
                        }
                        case 327690: {
                            n11 = ((Atom)((Object)object3)).getGroupID();
                            break;
                        }
                        case 327682: {
                            n11 = ((Atom)((Object)object3)).getSpecialAtomID();
                            break;
                        }
                        case 328980: {
                            n11 = ((Atom)((Object)object3)).getProteinStructureType();
                            break;
                        }
                        case 327683: {
                            n11 = ((Atom)((Object)object3)).getCovalentBondCount();
                            break;
                        }
                        case 327944: {
                            n11 = ((Atom)((Object)object3)).getModelFileIndex() + 1;
                            break;
                        }
                        case 327949: {
                            n11 = ((Atom)((Object)object3)).getModelNumber() % 1000000;
                            break;
                        }
                        default: {
                            bl6 = false;
                        }
                    }
                    if (bl6) {
                        if (bl5) {
                            fArray[n2] = n11;
                            continue;
                        }
                        if (bl3) {
                            n8 = Math.min(n8, n11);
                            continue;
                        }
                        if (bl4) {
                            n7 = Math.max(n7, n11);
                            continue;
                        }
                        n6 += n11;
                        continue;
                    }
                }
                float f4 = Float.MAX_VALUE;
                switch (n) {
                    case 860169: {
                        f4 = fArray2 == null ? 0.0f : fArray2[n2];
                        break;
                    }
                    case 327712: {
                        f4 = ((Tuple3f)object3).x;
                        break;
                    }
                    case 327713: {
                        f4 = ((Tuple3f)object3).y;
                        break;
                    }
                    case 327714: {
                        f4 = ((Tuple3f)object3).z;
                        break;
                    }
                    case 327715: {
                        f4 = ((Atom)((Object)object3)).getFractionalCoord('X');
                        break;
                    }
                    case 327716: {
                        f4 = ((Atom)((Object)object3)).getFractionalCoord('Y');
                        break;
                    }
                    case 327717: {
                        f4 = ((Atom)((Object)object3)).getFractionalCoord('Z');
                        break;
                    }
                    case 2949137: {
                        if (point4f != null) {
                            f4 = Graphics3D.distanceToPlane((Point4f)point4f, (Point3f)object3);
                            break;
                        }
                        f4 = object3.distance(point3f);
                        break;
                    }
                    case 335889: {
                        f4 = ((Atom)((Object)object3)).getRadius();
                        break;
                    }
                    case 327702: {
                        f4 = ((Atom)((Object)object3)).getVanderwaalsRadiusFloat();
                        break;
                    }
                    case 327718: {
                        f4 = ((Atom)((Object)object3)).getPartialCharge();
                        break;
                    }
                    case 327719: {
                        f4 = ((Atom)((Object)object3)).getGroupPhi();
                        break;
                    }
                    case 327720: {
                        f4 = ((Atom)((Object)object3)).getGroupPsi();
                        break;
                    }
                    case 327721: {
                        modelSet.getSurfaceDistanceMax();
                        f4 = (float)((Atom)((Object)object3)).getSurfaceDistance100() / 100.0f;
                        break;
                    }
                    case 327722: {
                        f4 = (float)((Atom)((Object)object3)).getBfactor100() / 100.0f;
                        break;
                    }
                    case 851976: {
                        point3f2.add((Tuple3f)object3);
                        break;
                    }
                    case 881923: {
                        point3f2.add((Tuple3f)Graphics3D.colorPointFromInt((int)this.viewer.getColixArgb(((Atom)((Object)object3)).getColix()), (Point3f)point3f3));
                        break;
                    }
                    default: {
                        this.unrecognizedAtomProperty(Token.nameOf(n));
                    }
                }
                if (f4 == Float.MAX_VALUE) continue;
                if (bl5) {
                    fArray[n2] = f4;
                    continue;
                }
                if (bl3) {
                    f3 = Math.min(f3, f4);
                    continue;
                }
                if (bl4) {
                    f2 = Math.max(f2, f4);
                    continue;
                }
                f += f4;
            }
        } else {
            n9 = this.viewer.getBondCount();
            if (bl5) {
                fArray = new float[n9];
            }
            for (n2 = 0; n2 < n9; ++n2) {
                if (bitSet != null && !bitSet.get(n2)) continue;
                ++n5;
                object3 = modelSet.getBondAt(n2);
                switch (n) {
                    case 851973: {
                        float f5 = ((Bond)object3).getAtom1().distance((Point3f)((Bond)object3).getAtom2());
                        f3 = Math.min(f3, f5);
                        f2 = Math.max(f2, f5);
                        f += f5;
                        if (!bl5) break;
                        fArray[n2] = f5;
                        break;
                    }
                    case 851976: {
                        point3f2.add((Tuple3f)((Bond)object3).getAtom1());
                        point3f2.add((Tuple3f)((Bond)object3).getAtom2());
                        ++n5;
                        break;
                    }
                    case 881923: {
                        point3f2.add((Tuple3f)Graphics3D.colorPointFromInt((int)this.viewer.getColixArgb(((Bond)object3).getColix()), (Point3f)point3f3));
                        break;
                    }
                    default: {
                        this.unrecognizedBondProperty(Token.nameOf(n));
                    }
                }
                bl6 = false;
            }
        }
        if (n == 851976 || n == 881923) {
            return n5 == 0 ? point3f2 : new Point3f(point3f2.x / (float)n5, point3f2.y / (float)n5, point3f2.z / (float)n5);
        }
        if (n5 == 0) {
            return new Float(Float.NaN);
        }
        if (bl3) {
            n5 = 1;
            n6 = n8;
            f = f3;
        } else if (bl4) {
            n5 = 1;
            n6 = n7;
            f = f2;
        } else if (bl5) {
            float[] fArray3 = new float[n5];
            int n16 = 0;
            for (int i = 0; i < n9; ++i) {
                if (bitSet != null && !bitSet.get(i)) continue;
                fArray3[n16++] = fArray[i];
            }
            if (object2 == null) {
                return fArray3;
            }
            return Escape.escape((float[])fArray3);
        }
        if (bl6 && n6 / n5 * n5 == n6) {
            return new Integer(n6 / n5);
        }
        return new Float((bl6 ? (float)n6 * 1.0f : f) / (float)n5);
    }

    void setAxes(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.setShapeSize(18, 1);
            return;
        }
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.statementLength == n + 1 && Parser.isOneOf((String)string, (String)"window;unitcell;molecular")) {
            this.viewer.setAxesMode("axes" + string, true);
            return;
        }
        if (this.statementLength == n + 2 && string.equals("scale")) {
            this.setFloatProperty("axesScale", this.floatParameter(++n));
            return;
        }
        short s = this.getSetAxesTypeMad(n);
        if (!this.isSyntaxCheck) {
            this.viewer.setObjectMad(18, "axes", s);
        }
    }

    void setBoundbox(int n) throws ScriptException {
        short s = this.getSetAxesTypeMad(n);
        if (!this.isSyntaxCheck) {
            this.viewer.setObjectMad(19, "boundbox", s);
        }
    }

    void setUnitcell(int n) throws ScriptException {
        if (this.statementLength == 1) {
            if (!this.isSyntaxCheck) {
                this.viewer.setObjectMad(20, "unitcell", (short)1);
            }
            return;
        }
        if (this.statementLength == n + 1) {
            if (this.getToken((int)n).tok == 2 && this.intParameter(n) >= 111) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setCurrentUnitCellOffset(this.intParameter(n));
                }
            } else {
                short s = this.getSetAxesTypeMad(n);
                if (!this.isSyntaxCheck) {
                    this.viewer.setObjectMad(20, "unitCell", s);
                }
            }
            return;
        }
        Point3f point3f = (Point3f)this.getPointOrPlane(2, false, true, false, true, 3, 3);
        if (!this.isSyntaxCheck) {
            this.viewer.setCurrentUnitCellOffset(point3f);
        }
    }

    void setFrank(int n) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(n));
    }

    void setDefaultColors() throws ScriptException {
        this.checkLength3();
        String string = this.parameterAsString(2);
        if (!string.equalsIgnoreCase("rasmol") && !string.equalsIgnoreCase("jmol")) {
            this.invalidArgument();
        }
        this.setStringProperty("defaultColorScheme", string);
    }

    void setBondmode() throws ScriptException {
        this.checkLength3();
        boolean bl = false;
        switch (this.getToken((int)2).tok) {
            case 0x110018: {
                break;
            }
            case 0x110010: {
                bl = true;
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.setBooleanProperty("bondModeOr", bl);
    }

    void setSelectionHalo(int n) throws ScriptException {
        if (n == this.statementLength) {
            this.setBooleanProperty("selectionHalos", true);
            return;
        }
        if (n + 1 < this.statementLength) {
            this.checkLength3();
        }
        boolean bl = false;
        switch (this.getToken((int)n).tok) {
            case 32769: 
            case 196611: {
                bl = true;
            }
            case 32768: 
            case 32772: 
            case 65549: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    void setEcho() throws ScriptException {
        String string = "target";
        Object object = null;
        boolean bl = true;
        switch (this.getToken((int)2).tok) {
            case 32768: {
                this.checkLength3();
                bl = false;
                string = "allOff";
                break;
            }
            case 65549: {
                bl = false;
            }
            case 65551: {
                this.checkLength3();
            }
            case 1: 
            case 772: 
            case 32833: 
            case 32834: 
            case 32837: 
            case 32838: {
                object = this.parameterAsString(2);
                break;
            }
            case 4: {
                this.echo(2);
                return;
            }
            default: {
                this.invalidArgument();
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setEchoStateActive(bl);
            this.viewer.loadShape(21);
            this.setShapeProperty(21, string, object);
        }
        if (this.statementLength == 3) {
            return;
        }
        string = "align";
        if (this.statementLength == 4) {
            if (this.isCenterParameter(3)) {
                this.setShapeProperty(21, "xyz", this.centerParameter(3));
                return;
            }
            switch (this.getToken((int)3).tok) {
                case 32768: {
                    string = "off";
                    break;
                }
                case 1: 
                case 772: 
                case 32833: 
                case 32834: 
                case 32837: 
                case 32838: {
                    object = this.parameterAsString(3);
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.setShapeProperty(21, string, object);
            return;
        }
        if (this.statementLength == 5 && this.getToken((int)3).tok == 2162957) {
            string = "script";
            object = this.parameterAsString(4);
            this.setShapeProperty(21, string, object);
            return;
        }
        this.getToken(4);
        int n = 3;
        if (this.isCenterParameter(n)) {
            this.setShapeProperty(21, "xyz", this.centerParameter(n));
            return;
        }
        int n2 = this.intParameter(n++);
        object = new Integer(n2);
        String string2 = this.tokAt(n) == 1114170 ? "%xpos" : "xpos";
        this.setShapeProperty(21, string2, object);
        int n3 = ++n;
        n2 = this.intParameter(n3);
        object = new Integer(n2);
        if (this.tokAt(++n) == 1114170) {
            string2 = "%ypos";
            ++n;
        } else {
            string2 = "ypos";
        }
        this.setShapeProperty(21, string2, object);
    }

    void setFontsize() throws ScriptException {
        int n = 8;
        if (this.statementLength == 3) {
            n = this.intParameter(2);
            if ((n += 5) < 6 || n > 63) {
                this.numberOutOfRange(6, 6);
            }
        }
        this.viewer.loadShape(4);
        this.setShapeProperty(4, "fontsize", new Integer(n));
    }

    boolean setLabel(String string) throws ScriptException {
        boolean bl;
        this.viewer.loadShape(4);
        if (string.equals("offset")) {
            this.checkLength4();
            int n = this.intParameter(2);
            int n2 = this.intParameter(3);
            if (n > 100 || n2 > 100 || n < -100 || n2 < -100) {
                this.numberOutOfRange(-100, 100);
            }
            int n3 = (n & 0xFF) << 8 | n2 & 0xFF;
            this.setShapeProperty(4, "offset", new Integer(n3));
            return true;
        }
        if (string.equals("alignment")) {
            this.checkLength3();
            switch (this.statement[2].tok) {
                case 772: 
                case 32833: 
                case 32834: {
                    this.setShapeProperty(4, "align", this.statement[2].value);
                    return true;
                }
            }
            this.invalidArgument();
        }
        if (string.equals("pointer")) {
            this.checkLength3();
            int n = 0;
            switch (this.statement[2].tok) {
                case 32768: 
                case 65549: {
                    break;
                }
                case 24833: {
                    n |= 2;
                }
                case 32769: {
                    n |= 1;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.setShapeProperty(4, "pointer", new Integer(n));
            return true;
        }
        this.checkLength23();
        boolean bl2 = bl = this.statementLength == 2 || this.tokAt(2) == 32769;
        if (string.equals("front") || string.equals("group")) {
            if (!bl && this.tokAt(2) != 32768) {
                this.invalidArgument();
            }
            if (!bl) {
                string = "atom";
                bl = true;
            } else {
                this.setShapeProperty(4, string, Boolean.TRUE);
                return true;
            }
        }
        if (string.equals("atom")) {
            if (!bl && this.tokAt(2) != 32768) {
                this.invalidArgument();
            }
            this.setShapeProperty(4, "front", bl ? Boolean.FALSE : Boolean.TRUE);
            return true;
        }
        return false;
    }

    void setMonitor(int n) throws ScriptException {
        boolean bl = false;
        this.checkLength3();
        switch (this.tokAt(n)) {
            case 32769: {
                bl = true;
            }
            case 32768: {
                this.setShapeProperty(6, "showMeasurementNumbers", bl ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 1: {
                String string = this.parameterAsString(n);
                if (!StateManager.isMeasurementUnit(string)) {
                    this.unrecognizedParameter("MEASURE ", string);
                }
                if (!this.isSyntaxCheck) {
                    this.viewer.setMeasureDistanceUnits(string);
                }
                return;
            }
        }
        this.setShapeSize(6, this.getSetAxesTypeMad(n));
    }

    void setProperty() throws ScriptException {
        this.checkLength4();
        if (this.getToken((int)2).tok != 1) {
            this.propertyNameExpected();
        }
        String string = this.parameterAsString(2);
        switch (this.getToken((int)3).tok) {
            case 32769: {
                this.setBooleanProperty(string, true);
                break;
            }
            case 32768: {
                this.setBooleanProperty(string, false);
                break;
            }
            case 2: {
                this.setIntProperty(string, this.intParameter(3));
                break;
            }
            case 3: {
                this.setFloatProperty(string, this.floatParameter(3));
                break;
            }
            case 4: {
                this.setStringProperty(string, this.stringParameter(3));
                break;
            }
            default: {
                this.unrecognizedParameter("SET " + string.toUpperCase(), this.parameterAsString(3));
            }
        }
    }

    void setSpin(String string, int n) throws ScriptException {
        if (Parser.isOneOf((String)(string = string.toLowerCase()), (String)"x;y;z;fps")) {
            if (this.isSyntaxCheck) {
                return;
            }
            switch ("x;y;z".indexOf(string)) {
                case 0: {
                    this.viewer.setSpinX(n);
                    return;
                }
                case 2: {
                    this.viewer.setSpinY(n);
                    return;
                }
                case 4: {
                    this.viewer.setSpinZ(n);
                    return;
                }
            }
            this.viewer.setSpinFps(n);
            return;
        }
        this.unrecognizedParameter("SPIN =", this.parameterAsString(2));
    }

    void setSsbond() throws ScriptException {
        this.checkLength3();
        boolean bl = false;
        switch (this.statement[2].tok) {
            case 196864: {
                bl = true;
                break;
            }
            case 196613: {
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.setBooleanProperty("ssbondsBackbone", bl);
    }

    void setHbond() throws ScriptException {
        this.checkLength3();
        boolean bl = false;
        switch (this.statement[2].tok) {
            case 196864: {
                bl = true;
            }
            case 196613: {
                this.setBooleanProperty("hbondsBackbone", bl);
                break;
            }
            case 32813: {
                bl = true;
            }
            case 32798: {
                this.setBooleanProperty("hbondsSolid", bl);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    void setScale3d() throws ScriptException {
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        this.setFloatProperty("scaleAngstromsPerInch", this.floatParameter(2));
    }

    void setPicking() throws ScriptException {
        if (this.statementLength == 2) {
            this.setStringProperty("picking", "ident");
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 798: 
            case 13632: 
            case 75026: {
                this.checkLength34();
                if (this.statementLength != 4) break;
                string = this.parameterAsString(2).toUpperCase();
                if (string.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                n = 3;
                break;
            }
            default: {
                this.checkLength3();
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 32769: 
            case 32772: {
                string2 = "ident";
                break;
            }
            case 65549: {
                string2 = "off";
                break;
            }
            case 798: {
                string2 = "atom";
                break;
            }
            case 860162: {
                string2 = "bond";
            }
        }
        if (JmolConstants.getPickingMode(string2) < 0) {
            this.unrecognizedParameter("SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    void setPickingStyle() throws ScriptException {
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 75026: {
                bl = true;
                string = "MEASURE";
            }
            case 798: {
                this.checkLength34();
                if (this.statementLength != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength3();
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 32768: 
            case 65549: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 32769: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (JmolConstants.getPickingStyle(string2) < 0) {
            this.unrecognizedParameter("SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    void save() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            switch (this.statement[1].tok) {
                case 32847: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 860162: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveBonds(string);
                    }
                    return;
                }
                case 32848: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveState(string);
                    }
                    return;
                }
                case 328980: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveStructure(string);
                    }
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("selection")) break;
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveSelection(string);
                    }
                    return;
                }
            }
        }
        this.evalError(GT._((String)"save what?") + " bonds? orientation? selection? state? structure?");
    }

    void restore() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            if (this.getToken((int)1).tok != 32847) {
                this.checkLength23();
            }
            switch (this.getToken((int)1).tok) {
                case 32847: {
                    float f;
                    float f2 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.invalidArgument();
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreOrientation(string, f);
                    }
                    return;
                }
                case 860162: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreBonds(string);
                    }
                    return;
                }
                case 32848: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string2 = this.viewer.getSavedState(string);
                    if (string2 == null) {
                        this.invalidArgument();
                    }
                    this.runScript(string2);
                    return;
                }
                case 328980: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string3 = this.viewer.getSavedStructure(string);
                    if (string3 == null) {
                        this.invalidArgument();
                    }
                    this.runScript(string3);
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("selection")) break;
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreSelection(string);
                    }
                    return;
                }
            }
        }
        this.evalError(GT._((String)"restore what?") + " bonds? orientation? selection? state? structure?");
    }

    void write() throws ScriptException {
        boolean bl;
        boolean bl2 = this.viewer.isApplet();
        int n = this.statementLength == 1 ? 32770 : this.statement[1].tok;
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        String string = "SPT";
        String string2 = "";
        boolean bl3 = false;
        switch (n) {
            case 65548: 
            case 0x210112: {
                string = "data";
                bl3 = true;
                ++n2;
                break;
            }
            case 32848: 
            case 2162957: {
                ++n2;
                break;
            }
            case 20835: {
                string = "MO";
                ++n2;
                break;
            }
            case 21854: {
                string = "ISO";
                ++n2;
                break;
            }
            case 8554: {
                string = "HIS";
                ++n2;
                break;
            }
            case 1: {
                string = this.parameterAsString(1).toLowerCase();
                if (string.equals("image")) {
                    if (this.tokAt(++n2) != 2) break;
                    n4 = this.intParameter(n2++);
                    n5 = this.intParameter(n2++);
                    break;
                }
                if (string.equals("var")) {
                    n2 += 2;
                    string = "VAR";
                    break;
                }
                string = "image";
            }
        }
        if (n2 >= this.statementLength) {
            this.badArgumentCount();
        }
        n = this.statement[n2].tok;
        String string3 = this.parameterAsString(n2);
        if (string3.equalsIgnoreCase("clipboard")) {
            if (this.isSyntaxCheck) {
                return;
            }
            if (bl2) {
                this.evalError(GT._((String)"The {0} command is not available for the applet.", (String)"WRITE CLIPBOARD"));
            }
        }
        if (n2 + 2 == this.statementLength && (string2 = this.parameterAsString(++n2)).charAt(0) != '.') {
            string = string3.toUpperCase();
        }
        if (n2 + 1 != this.statementLength) {
            this.badArgumentCount();
        }
        String string4 = null;
        switch (this.getToken((int)n2).tok) {
            case 1: 
            case 4: {
                string4 = this.parameterAsString(n2);
                if (string4.charAt(0) == '.' && (n2 == 2 || n2 == 3)) {
                    string4 = this.parameterAsString(n2 - 1) + string4;
                    if (string != "VAR" && n2 == 2) {
                        string = "image";
                    }
                }
                if (!string4.equalsIgnoreCase("clipboard")) break;
                string4 = null;
                break;
            }
            case 32770: {
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        if (string.equals("image")) {
            string = string4 != null && string4.indexOf(".") >= 0 ? string4.substring(string4.lastIndexOf(".") + 1).toUpperCase() : "JPG";
        }
        if (string.equals("data")) {
            string = string4 != null && string4.indexOf(".") >= 0 ? string4.substring(string4.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
        }
        if (!(bl = Parser.isOneOf((String)string, (String)"JPEG;JPG64;JPG;PPM;PNG")) && !Parser.isOneOf((String)string, (String)"SPT;HIS;MO;ISO;VAR;XYZ;MOL;PDB")) {
            this.evalError(GT._((String)"write what? {0} or {1} \"filename\"", (Object[])new Object[]{"COORDS|HISTORY|IMAGE|ISOSURFACE|MO|STATE|VAR x  CLIPBOARD", "JPG|JPG64|PNG|PPM|SPT|JVXL|XYZ|MOL|PDB"}));
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl && bl2) {
            this.evalError(GT._((String)"The {0} command is not available for the applet.", (String)"WRITE image"));
        }
        int n6 = Integer.MIN_VALUE;
        string2 = string.intern();
        if (string2 == "PDB" || string2 == "XYZ" || string2 == "MOL") {
            string2 = this.viewer.getData("selected", string2);
        } else if (string2 == "VAR") {
            string2 = "" + this.viewer.getParameter(this.parameterAsString(2));
        } else if (string2 == "SPT") {
            if (bl3) {
                BitSet bitSet = this.viewer.getTaintedAtoms();
                this.viewer.setAtomCoordRelative(new Point3f(0.0f, 0.0f, 0.0f));
                string2 = (String)this.viewer.getProperty("string", "stateInfo", null);
                this.viewer.setTaintedAtoms(bitSet);
            } else {
                string2 = (String)this.viewer.getProperty("string", "stateInfo", null);
            }
        } else if (string2 == "HIS") {
            string2 = this.viewer.getSetHistory(Integer.MAX_VALUE);
        } else if (string2 == "MO") {
            string2 = this.getMoJvxl(Integer.MAX_VALUE);
        } else if (string2 == "ISO") {
            string2 = this.getIsosurfaceJvxl();
            if (string2 == null) {
                this.evalError(GT._((String)"No data available"));
            }
        } else {
            n3 = -1;
            n6 = 75;
        }
        if (n3 == 0) {
            n3 = string2.length();
        }
        if (bl) {
            if (n4 < 0) {
                n4 = this.viewer.getScreenWidth();
            }
            if (n5 < 0) {
                n5 = this.viewer.getScreenHeight();
            }
        }
        this.viewer.createImage(string4, string2, n6, n4, n5);
        this.scriptStatus("type=" + string + "; file=" + (string4 == null ? "CLIPBOARD" : string4) + (n3 >= 0 ? "; length=" + n3 : "") + (bl ? "; width=" + n4 + "; height=" + n5 : ""));
    }

    void show() throws ScriptException {
        String string = null;
        String string2 = this.parameterAsString(1);
        String string3 = null;
        int n = 2;
        block0 : switch (this.getToken((int)1).tok) {
            case 21791: {
                this.checkLength2();
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getAllSettings(60));
                }
                return;
            }
            case 32845: {
                n = this.statementLength;
                if (n == 2) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.showUrl(this.getFullPathName());
                    }
                    return;
                }
                String string4 = this.parameterAsString(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.showUrl(string4);
                }
                return;
            }
            case 8204: {
                string2 = "defaultColorScheme";
                break;
            }
            case 8221: {
                string2 = "scaleAngstromsPerInch";
                break;
            }
            case 1: {
                if (string2.equalsIgnoreCase("historyLevel")) {
                    string = "" + this.commandHistoryLevelMax;
                    break;
                }
                if (string2.equalsIgnoreCase("defaultLattice")) {
                    string = Escape.escape((Tuple3f)this.viewer.getDefaultLattice());
                    break;
                }
                if (string2.equalsIgnoreCase("logLevel")) {
                    string = "" + Viewer.getLogLevel();
                    break;
                }
                if (string2.equalsIgnoreCase("fileHeader")) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getPDBHeader();
                    break;
                }
                if (!string2.equalsIgnoreCase("debugScript")) break;
                string = "" + this.viewer.getDebugScript();
                break;
            }
            case 8560: {
                switch (this.viewer.getAxesMode()) {
                    case 2: {
                        string3 = "set axesUnitcell";
                        break block0;
                    }
                    case 0: {
                        string3 = "set axesWindow";
                        break block0;
                    }
                }
                string3 = "set axesMolecular";
                break;
            }
            case 8193: {
                string3 = "set bondMode " + (this.viewer.getBondSelectionModeOr() ? "OR" : "AND");
                break;
            }
            case 8487: {
                this.viewer.loadShape(12);
                string3 = "set strands " + this.viewer.getShapeProperty(12, "strandCount");
                break;
            }
            case 73997: {
                string3 = "hbondsBackbone = " + this.viewer.getHbondsBackbone() + ";hbondsSolid = " + this.viewer.getHbondsSolid();
                break;
            }
            case 13632: {
                string3 = this.viewer.getSpinState();
                break;
            }
            case 8484: {
                string3 = "ssbondsBackbone = " + this.viewer.getSsbondsBackbone();
                break;
            }
            case 8553: 
            case 9067: {
                string3 = "selectionHalos = " + this.viewer.getSelectionHaloEnabled();
                break;
            }
            case 204801: {
                string3 = "defaultSelectHetero = " + this.viewer.getRasmolHeteroSetting();
                break;
            }
            case 204802: {
                string3 = "defaultSelectHydrogens = " + this.viewer.getRasmolHydrogenSetting();
                break;
            }
            case 8192: 
            case 8199: 
            case 8201: 
            case 8202: 
            case 8223: {
                string3 = this.viewer.getSpecularState();
                break;
            }
            case 284: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.listSavedStates();
                break;
            }
            case 205170: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getUnitCellInfoText();
                break;
            }
            case 32848: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getStateInfo();
                    break;
                }
                String string5 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedState(string5);
                break;
            }
            case 328980: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getStructureState();
                    break;
                }
                String string6 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedStructure(string6);
                break;
            }
            case 0x210112: {
                Object[] objectArray;
                String string7;
                n = this.statementLength;
                String string8 = string7 = n == 3 ? this.parameterAsString(2) : null;
                if (this.isSyntaxCheck) break;
                Object[] objectArray2 = objectArray = string7 == null ? this.data : Viewer.getData(string7);
                string3 = objectArray == null ? "no data" : "data \"" + objectArray[0] + "\"\n" + (objectArray[1] instanceof float[] ? Escape.escape((float[])((float[])objectArray[1])) : "" + objectArray[1]);
                break;
            }
            case 32771: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getSpaceGroupInfoText(null);
                    break;
                }
                String string9 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpaceGroupInfoText(TextFormat.simpleReplace((String)string9, (String)"''", (String)"\""));
                break;
            }
            case 65541: {
                n = 3;
                int n2 = this.setShapeByNameParameter(2);
                if (this.isSyntaxCheck) break;
                if (n2 == 26) {
                    string3 = this.getIsosurfaceJvxl();
                    break;
                }
                string3 = (String)this.viewer.getShapeProperty(n2, "command");
                break;
            }
            case 8561: {
                if (this.isSyntaxCheck) break;
                string3 = "boundbox " + this.viewer.getBoundBoxCenter() + " " + this.viewer.getBoundBoxCornerVector();
                break;
            }
            case 772: {
                if (this.isSyntaxCheck) break;
                string3 = "center " + Escape.escape((Tuple3f)this.viewer.getRotationCenter());
                break;
            }
            case 21855: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.viewer.getShapeProperty(28, "command");
                break;
            }
            case 327944: {
                if (this.statementLength == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getCurrentFileAsString();
                    break;
                }
                this.checkLength3();
                string = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getFileAsString(string);
                break;
            }
            case 8554: {
                int n3;
                n = this.statementLength;
                int n4 = n3 = n == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n3 < 1) {
                    this.invalidArgument();
                }
                if (this.isSyntaxCheck) break;
                this.viewer.removeCommand();
                string3 = this.viewer.getSetHistory(n3);
                break;
            }
            case 21854: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.viewer.getShapeProperty(26, "jvxlFileData");
                break;
            }
            case 20835: {
                int n5;
                n = this.statementLength;
                int n6 = n5 = n == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (this.isSyntaxCheck) break;
                string3 = this.getMoJvxl(n5);
                break;
            }
            case 327949: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getModelInfoAsString();
                break;
            }
            case 75026: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMeasurementInfoAsString();
                break;
            }
            case 32847: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getOrientationText();
                break;
            }
            case 32849: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getPDBHeader();
                break;
            }
            case 196630: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSymmetryInfoAsString();
                break;
            }
            case 32846: {
                if (this.isSyntaxCheck) break;
                string3 = "transform:\n" + this.viewer.getTransformText();
                break;
            }
            case 5423: {
                string3 = "zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomPercentFloat() : "off");
                break;
            }
            case 32842: 
            case 32843: {
                this.unrecognizedShowParameter("show ORIENTATION");
            }
            case 32844: 
            case 65544: 
            case 65545: 
            case 65546: {
                this.unrecognizedShowParameter("getProperty CHAININFO (atom expression)");
            }
            case 196611: {
                this.unrecognizedShowParameter("getProperty ATOMINFO (selected)");
            }
            case 851969: {
                this.unrecognizedShowParameter("getProperty ATOMINFO (atom expression)");
            }
            case 2318: 
            case 8194: 
            case 8563: 
            case 10507: 
            case 204804: 
            case 335889: 
            case 860162: 
            case 860169: {
                string = "?";
            }
        }
        this.checkStatementLength(n);
        if (this.isSyntaxCheck) {
            return;
        }
        if (string3 != null) {
            this.showString(string3);
        } else if (string != null) {
            this.showString(string2 + " = " + string);
        } else if (string2 != null) {
            this.showString(string2 + " = " + this.viewer.getParameterEscaped(string2));
        }
    }

    void showString(String string) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string);
        } else {
            this.viewer.showString(string);
        }
    }

    String getIsosurfaceJvxl() {
        if (this.isSyntaxCheck) {
            return "";
        }
        return (String)this.viewer.getShapeProperty(26, "jvxlFileData");
    }

    String getMoJvxl(int n) throws ScriptException {
        Hashtable hashtable;
        this.viewer.loadShape(25);
        int n2 = this.viewer.getDisplayModelIndex();
        if (n2 < 0) {
            this.multipleModelsNotOK();
        }
        if ((hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n2, "moData")) == null) {
            this.evalError(GT._((String)"no MO basis/coefficient data available for this frame"));
        }
        this.setShapeProperty(25, "moData", hashtable);
        return (String)this.viewer.getShapeProperty(25, "showMO", n);
    }

    /*
     * Unable to fully structure code
     */
    void pmesh() throws ScriptException {
        this.viewer.loadShape(29);
        if (this.tokAt(1) == 6 && this.listIsosurface(29)) {
            return;
        }
        var2_1 = false;
        this.initIsosurface(29);
        for (var3_2 = this.iToken; var3_2 < this.statementLength; ++var3_2) {
            var4_4 = null;
            var5_5 = null;
            switch (this.getToken((int)var3_2).tok) {
                case 1: {
                    var5_5 = this.theToken.value;
                    var6_6 = (String)var5_5;
                    if (var6_6.equalsIgnoreCase("FIXED")) {
                        var4_4 = "fixed";
                        var5_5 = Boolean.TRUE;
                        break;
                    }
                    if (var6_6.equalsIgnoreCase("MODELBASED")) {
                        var4_4 = "fixed";
                        var5_5 = Boolean.FALSE;
                        break;
                    }
                    if (var2_1) {
                        this.invalidArgument();
                    }
                    var4_4 = "thisID";
                    break;
                }
                case 327949: {
                    var7_7 = this.modelNumberParameter(++var3_2);
                    if (var7_7 < 0) {
                        var4_4 = "fixed";
                        var5_5 = Boolean.TRUE;
                        break;
                    }
                    var4_4 = "modelIndex";
                    var5_5 = new Integer(var7_7);
                    break;
                }
                case 4: {
                    var8_8 = this.stringParameter(var3_2);
                    var4_4 = "bufferedReader";
                    if (!var8_8.equalsIgnoreCase("inline")) ** GOTO lbl54
                    if (var3_2 + 1 < this.statementLength && this.statement[var3_2 + 1].tok == 4) {
                        var9_9 = (String)this.statement[++var3_2].value;
                        if (var9_9.indexOf("|") < 0 && var9_9.indexOf("\n") < 0) {
                            var9_9 = TextFormat.simpleReplace((String)var9_9, (String)" ", (String)"\n");
                            var4_4 = "bufferedReaderOnePerLine";
                        }
                        var9_9 = TextFormat.simpleReplace((String)var9_9, (String)"{", (String)" ");
                        var9_9 = TextFormat.simpleReplace((String)var9_9, (String)",", (String)" ");
                        var9_9 = TextFormat.simpleReplace((String)var9_9, (String)"}", (String)" ");
                        var9_9 = TextFormat.simpleReplace((String)var9_9, (String)"|", (String)"\n");
                        var9_9 = TextFormat.simpleReplace((String)var9_9, (String)"\n\n", (String)"\n");
                        if (this.logMessages) {
                            Logger.debug((String)("pmesh inline data:\n" + var9_9));
                        }
                        var1_3 = this.viewer.getBufferedReaderForString(var9_9);
                    } else {
                        this.stringOrIdentifierExpected();
                        break;
lbl54:
                        // 1 sources

                        if (this.isSyntaxCheck) {
                            return;
                        }
                        var1_3 = this.viewer.getUnzippedBufferedReaderOrErrorMessageFromName(var8_8);
                        if (var1_3 instanceof String) {
                            this.fileNotFoundException(var8_8 + ":" + var1_3);
                        }
                    }
                    var5_5 = var1_3;
                    break;
                }
                default: {
                    if (!this.setMeshDisplayProperty(29, var3_2, this.theTok)) {
                        this.invalidArgument();
                    }
                    var3_2 = this.iToken;
                }
            }
            v0 = var2_1 = this.theTok != 32810;
            if (var4_4 == null) continue;
            this.setShapeProperty(29, var4_4, var5_5);
        }
    }

    void draw() throws ScriptException {
        this.viewer.loadShape(28);
        if (this.tokAt(1) == 6 && this.listIsosurface(28)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float f = Float.MAX_VALUE;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        boolean bl5 = false;
        this.initIsosurface(28);
        block16: for (int i = this.iToken; i < this.statementLength; ++i) {
            String string = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 4: {
                    object = this.stringParameter(i);
                    string = "title";
                    break;
                }
                case 851973: {
                    object = new Float(this.floatParameter(++i));
                    string = "length";
                    break;
                }
                case 3: {
                    object = new Float(this.floatParameter(i));
                    string = "length";
                    break;
                }
                case 2: {
                    if (bl3) {
                        string = "modelIndex";
                        object = new Integer(this.intParameter(i));
                        break;
                    }
                    n2 = this.intParameter(i);
                    break;
                }
                case 0x110008: 
                case 0x110009: {
                    bl3 = !bl3;
                    if (bl3 != (this.theTok == 0x110009)) break;
                    this.invalidArgument();
                    break;
                }
                case 1: {
                    Point3f point3f;
                    object = this.theToken.value;
                    String string2 = (String)object;
                    if (string2.equalsIgnoreCase("FIXED")) {
                        string = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("MODELBASED")) {
                        string = "fixed";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("PLANE")) {
                        string = "plane";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CROSSED")) {
                        string = "crossed";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CURVE")) {
                        string = "curve";
                        break;
                    }
                    if (string2.equalsIgnoreCase("ARROW")) {
                        string = "arrow";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CIRCLE")) {
                        string = "circle";
                        break;
                    }
                    if (string2.equalsIgnoreCase("VERTICES")) {
                        string = "vertices";
                        break;
                    }
                    if (string2.equalsIgnoreCase("REVERSE")) {
                        string = "reverse";
                        break;
                    }
                    if (string2.equalsIgnoreCase("ROTATE45")) {
                        string = "rotate45";
                        break;
                    }
                    if (string2.equalsIgnoreCase("PERP") || string2.equalsIgnoreCase("PERPENDICULAR")) {
                        string = "perp";
                        break;
                    }
                    if (string2.equalsIgnoreCase("OFFSET")) {
                        point3f = this.getPoint3f(++i, true);
                        i = this.iToken;
                        string = "offset";
                        object = point3f;
                        break;
                    }
                    if (string2.equalsIgnoreCase("SCALE")) {
                        if (++i >= this.statementLength) {
                            this.numberExpected();
                        }
                        switch (this.getToken((int)i).tok) {
                            case 2: {
                                n2 = this.intParameter(i);
                                continue block16;
                            }
                            case 3: {
                                n2 = (int)(this.floatParameter(i) * 100.0f);
                                continue block16;
                            }
                            default: {
                                this.numberExpected();
                            }
                        }
                    }
                    if (string2.equalsIgnoreCase("DIAMETER")) {
                        object = new Float(this.floatParameter(++i));
                        string = "diameter";
                        break;
                    }
                    if (bl5) {
                        this.invalidArgument();
                    }
                    string = "thisID";
                    break;
                }
                case 65541: {
                    Point3f point3f;
                    if (this.tokAt(i + 2) == 0x110008) {
                        point3f = this.centerParameter(i);
                        i = this.iToken;
                        string = "coord";
                        object = point3f;
                        bl = true;
                        break;
                    }
                    object = this.objectNameParameter(++i);
                    string = "identifier";
                    bl = true;
                    break;
                }
                case 881923: {
                    bl4 = false;
                    if (this.tokAt(++i) == 32809) {
                        bl4 = true;
                        if (this.isFloatParameter(++i)) {
                            f = this.floatParameter(i++);
                        }
                    }
                    if (this.isColorParam(i)) {
                        n = this.getArgbParam(i);
                        i = this.iToken;
                        this.setShapeProperty(28, "colorRGB", new Integer(n));
                        continue block16;
                    }
                    if (bl4) continue block16;
                    this.invalidArgument();
                }
                case 7: 
                case 65539: {
                    Point3f point3f = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = "coord";
                    object = point3f;
                    bl = true;
                    break;
                }
                case 32839: 
                case 65636: {
                    string = "atomSet";
                    object = this.expression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                default: {
                    if (!this.setMeshDisplayProperty(28, i, this.theTok)) {
                        this.invalidArgument();
                    }
                    i = this.iToken;
                }
            }
            boolean bl6 = bl5 = this.theTok != 32810;
            if (bl && !bl2) {
                this.setShapeProperty(28, "points", new Integer(n2));
                bl2 = true;
                n2 = 0;
            }
            if (string == null) continue;
            this.setShapeProperty(28, string, object);
        }
        if (bl) {
            this.setShapeProperty(28, "set", null);
        }
        if (n != 0) {
            this.setShapeProperty(28, "colorRGB", new Integer(n));
        }
        if (bl4) {
            this.setShapeTranslucency(28, "", "translucent", f);
        }
        if (n2 != 0) {
            this.setShapeProperty(28, "scale", new Integer(n2));
        }
    }

    void drawPoint(String string, Point3f point3f, boolean bl) throws ScriptException {
        this.viewer.loadShape(28);
        this.setShapeProperty(28, "init", null);
        this.setShapeProperty(28, "thisID", string);
        this.setShapeProperty(28, "points", new Integer(0));
        this.setShapeProperty(28, "coord", point3f);
        this.setShapeProperty(28, "set", null);
        if (!bl) {
            this.setMeshDisplayProperty(28, -1, 32768);
        }
    }

    void drawPlane(String string, Point4f point4f, boolean bl) throws ScriptException {
        this.viewer.loadShape(26);
        this.setShapeProperty(26, "init", null);
        this.setShapeProperty(26, "thisID", string);
        this.setShapeProperty(26, "plane", point4f);
        this.setShapeProperty(26, "nomap", new Float(0.0f));
        if (!bl) {
            this.setMeshDisplayProperty(26, -1, 32768);
        }
    }

    void polyhedra() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        this.viewer.loadShape(23);
        this.setShapeProperty(23, "init", null);
        String string = "centers";
        String string2 = "radius_";
        String string3 = null;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        block12: for (int i = 1; i < this.statementLength; ++i) {
            String string4 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 65547: 
                case 5308460: {
                    continue block12;
                }
                case 860162: {
                    if (n > 0) {
                        this.invalidParameterOrder();
                    }
                    bl = true;
                    string4 = "bonds";
                    break;
                }
                case 335889: {
                    string2 = "radius";
                    continue block12;
                }
                case 32808: 
                case 32809: {
                    string3 = this.parameterAsString(i);
                    continue block12;
                }
                case 49172: 
                case 0x110008: {
                    n2 = this.getArgbParam(i);
                    i = this.iToken;
                    continue block12;
                }
                case 1: {
                    String string5 = this.parameterAsString(i);
                    if ("collapsed".equalsIgnoreCase(string5)) {
                        string4 = "collapsed";
                        object = Boolean.TRUE;
                        if (bl3) {
                            this.incompatibleArguments();
                        }
                        bl3 = true;
                        break;
                    }
                    if ("flat".equalsIgnoreCase(string5)) {
                        string4 = "collapsed";
                        object = Boolean.FALSE;
                        if (bl3) {
                            this.incompatibleArguments();
                        }
                        bl3 = true;
                        break;
                    }
                    if ("edges".equalsIgnoreCase(string5) || "noedges".equalsIgnoreCase(string5) || "frontedges".equalsIgnoreCase(string5)) {
                        if (bl4) {
                            this.incompatibleArguments();
                        }
                        string4 = string5;
                        bl4 = true;
                        break;
                    }
                    if (!bl) {
                        this.insufficientArguments();
                    }
                    if ("to".equalsIgnoreCase(string5)) {
                        if (n > 1) {
                            this.invalidParameterOrder();
                        }
                        if (this.getToken((int)(i + 1)).tok == 32839) {
                            string4 = "toBitSet";
                            object = this.getToken((int)(++i)).value;
                            bl = true;
                            break;
                        }
                        string = "to";
                        continue block12;
                    }
                    if ("faceCenterOffset".equalsIgnoreCase(string5)) {
                        string2 = "faceCenterOffset";
                        bl5 = true;
                        continue block12;
                    }
                    if ("distanceFactor".equalsIgnoreCase(string5)) {
                        string2 = "distanceFactor";
                        bl5 = true;
                        continue block12;
                    }
                    this.invalidArgument();
                }
                case 2: {
                    if (n > 0 && !bl5) {
                        this.invalidParameterOrder();
                    }
                    if (string2 == "radius_") {
                        string4 = "nVertices";
                        object = new Integer(this.intParameter(i));
                        bl = true;
                        break;
                    }
                }
                case 3: {
                    if (n > 0 && !bl5) {
                        this.invalidParameterOrder();
                    }
                    string4 = string2 == "radius_" ? "radius" : string2;
                    object = new Float(this.floatParameter(i));
                    string2 = "radius_";
                    bl5 = false;
                    bl = true;
                    break;
                }
                case 32768: 
                case 32769: 
                case 32810: {
                    if (i + 1 != this.statementLength || bl || n > 1 || n == 0 && string == "to") {
                        this.incompatibleArguments();
                    }
                    string4 = this.parameterAsString(i);
                    bl2 = true;
                    break;
                }
                case 32839: 
                case 65636: {
                    if (bl3) {
                        this.invalidParameterOrder();
                    }
                    if (++n > 2) {
                        this.badArgumentCount();
                    }
                    if (string == "to") {
                        bl = true;
                    }
                    string4 = string;
                    string = "to";
                    object = this.expression(i);
                    i = this.iToken;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.setShapeProperty(23, string4, object);
            if (!bl2) continue;
            return;
        }
        if (!(bl || bl3 || bl4)) {
            this.insufficientArguments();
        }
        if (bl) {
            this.setShapeProperty(23, "generate", null);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(23, "colorThis", new Integer(n2));
        }
        if (string3 != null) {
            this.setShapeTranslucency(23, "", string3, f);
        }
    }

    /*
     * Unable to fully structure code
     */
    void lcaoCartoon() throws ScriptException {
        this.viewer.loadShape(27);
        if (this.tokAt(1) == 6 && this.listIsosurface(27)) {
            return;
        }
        this.setShapeProperty(27, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(27, "lcaoID", null);
            return;
        }
        block14: for (var1_1 = 1; var1_1 < this.statementLength; ++var1_1) {
            var2_2 = null;
            var3_3 = null;
            switch (this.getToken((int)var1_1).tok) {
                case 772: {
                    this.isosurface(27);
                    return;
                }
                case 32769: {
                    var2_2 = "on";
                    ** GOTO lbl81
                }
                case 32768: {
                    var2_2 = "off";
                    ** GOTO lbl81
                }
                case 32810: {
                    var2_2 = "delete";
                    ** GOTO lbl81
                }
                case 2: 
                case 3: {
                    var2_2 = "scale";
                    var3_3 = new Float(this.floatParameter(++var1_1));
                    ** GOTO lbl81
                }
                case 32839: 
                case 65636: {
                    var2_2 = "select";
                    var3_3 = this.expression(var1_1);
                    var1_1 = this.iToken;
                    ** GOTO lbl81
                }
                case 881923: {
                    if (this.isColorParam(++var1_1)) {
                        this.setShapeProperty(27, "colorRGB", new Integer(this.getArgbParam(var1_1)));
                        var1_1 = this.iToken;
                        this.setShapeProperty(27, "colorRGB", new Integer(this.getArgbParam(this.isColorParam(var1_1 + 1) != false ? var1_1 + 1 : var1_1)));
                        var1_1 = this.iToken;
                        continue block14;
                    }
                    this.invalidArgument();
                }
                case 32808: 
                case 32809: {
                    this.setMeshDisplayProperty(27, var1_1, this.theTok);
                    var1_1 = this.iToken;
                    continue block14;
                }
                case 4: {
                    var3_3 = this.stringParameter(var1_1);
                    var2_2 = "create";
                    if (this.optParameterAsString(var1_1 + 1).equalsIgnoreCase("molecular")) {
                        ++var1_1;
                        var2_2 = "molecular";
                    }
                    ** GOTO lbl81
                }
                case 798: {
                    if (this.tokAt(var1_1 + 1) == 32839 || this.tokAt(var1_1 + 1) == 65636) {
                        var2_2 = "select";
                        var3_3 = this.expression(var1_1 + 1);
                        var1_1 = this.iToken;
                    } else {
                        var2_2 = "selectType";
                        var3_3 = this.parameterAsString(++var1_1);
                    }
                    ** GOTO lbl81
                }
                case 1: {
                    var4_4 = this.parameterAsString(var1_1);
                    if (!var4_4.equalsIgnoreCase("SCALE")) ** GOTO lbl68
                    var2_2 = "scale";
                    var3_3 = new Float(this.floatParameter(++var1_1));
                    ** GOTO lbl81
lbl68:
                    // 1 sources

                    if (!var4_4.equalsIgnoreCase("MOLECULAR")) ** GOTO lbl71
                    var2_2 = "molecular";
                    ** GOTO lbl81
lbl71:
                    // 1 sources

                    if (!var4_4.equalsIgnoreCase("CREATE")) ** GOTO lbl78
                    var3_3 = this.parameterAsString(++var1_1);
                    var2_2 = "create";
                    if (this.optParameterAsString(var1_1 + 1).equalsIgnoreCase("molecular")) {
                        ++var1_1;
                        var2_2 = "molecular";
                    }
                    ** GOTO lbl81
lbl78:
                    // 1 sources

                    var3_3 = var4_4;
                }
                case 65551: {
                    var2_2 = "lcaoID";
                }
lbl81:
                // 13 sources

                default: {
                    if (var2_2 == null) {
                        this.invalidArgument();
                    }
                    this.setShapeProperty(27, var2_2, var3_3);
                }
            }
        }
        this.setShapeProperty(27, "clear", null);
    }

    boolean mo(boolean bl) throws ScriptException {
        int n = this.viewer.getDisplayModelIndex();
        int n2 = Integer.MAX_VALUE;
        if (!this.isSyntaxCheck && n < 0) {
            this.multipleModelsNotOK();
        }
        this.viewer.loadShape(25);
        if (this.tokAt(1) == 6 && this.listIsosurface(25)) {
            return true;
        }
        this.setShapeProperty(25, "init", new Integer(n));
        String string = null;
        int n3 = (Integer)this.viewer.getShapeProperty(25, "moNumber");
        if (bl) {
            return n3 != 0;
        }
        if (n3 == 0 && !this.isSyntaxCheck) {
            this.lastMoNumber = 0;
            n3 = Integer.MAX_VALUE;
        }
        String string2 = null;
        Object object = null;
        switch (this.getToken((int)1).tok) {
            case 2: {
                n3 = this.intParameter(1);
                break;
            }
            case 32826: {
                n3 = this.lastMoNumber + 1;
                break;
            }
            case 32827: {
                n3 = this.lastMoNumber - 1;
                break;
            }
            case 881923: {
                if (this.tokAt(2) == 49172 || this.tokAt(2) == 0x110008) {
                    this.setShapeProperty(25, "colorRGB", new Integer(this.getArgbParam(2)));
                    if (this.tokAt(++this.iToken) != 49172 && this.tokAt(this.iToken) != 0x110008) break;
                    this.setShapeProperty(25, "colorRGB", new Integer(this.getArgbParam(this.iToken)));
                    break;
                }
                this.invalidArgument();
            }
            case 1: {
                String string3 = this.parameterAsString(1);
                n2 = this.moOffset(1);
                if (n2 != Integer.MAX_VALUE) {
                    n3 = 0;
                    break;
                }
                if (string3.equalsIgnoreCase("CUTOFF")) {
                    if (this.tokAt(2) == 0x110031) {
                        string2 = "cutoffPositive";
                        object = new Float(this.floatParameter(3));
                        break;
                    }
                    string2 = "cutoff";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("RESOLUTION")) {
                    string2 = "resolution";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("SCALE")) {
                    string2 = "scale";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("TITLEFORMAT")) {
                    if (2 >= this.statementLength || this.statement[2].tok != 4) break;
                    string2 = "titleFormat";
                    object = this.parameterAsString(2);
                    break;
                }
                if (string3.equalsIgnoreCase("DEBUG")) {
                    string2 = "debug";
                    break;
                }
                if (string3.equalsIgnoreCase("plane")) {
                    string2 = "plane";
                    object = this.planeParameter(2);
                    break;
                }
                if (string3.equalsIgnoreCase("noplane")) {
                    string2 = "plane";
                    object = null;
                    break;
                }
                this.invalidArgument();
            }
            default: {
                if (!this.setMeshDisplayProperty(25, 1, this.theTok)) {
                    this.invalidArgument();
                }
                return true;
            }
        }
        if (string2 != null) {
            this.setShapeProperty(25, string2, object);
        }
        if (n3 != Integer.MAX_VALUE) {
            if (this.tokAt(2) == 4) {
                string = this.parameterAsString(2);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setCursor(4);
            }
            this.setMoData(25, n3, n2, n, string);
        }
        return true;
    }

    int moOffset(int n) throws ScriptException {
        String string = this.parameterAsString(n++);
        boolean bl = false;
        int n2 = Integer.MAX_VALUE;
        bl = string.equalsIgnoreCase("HOMO");
        if (bl || string.equalsIgnoreCase("LUMO")) {
            int n3 = n2 = bl ? 0 : 1;
            if (this.tokAt(n) == 2 && this.intParameter(n) < 0) {
                n2 += this.intParameter(n);
            } else if (this.tokAt(n) == 0x110031) {
                n2 += this.intParameter(n + 1);
            } else if (this.tokAt(n) == 0x110030) {
                n2 -= this.intParameter(n + 1);
            }
        }
        return n2;
    }

    void setMoData(int n, int n2, int n3, int n4, String string) throws ScriptException {
        Hashtable hashtable;
        if (this.isSyntaxCheck) {
            return;
        }
        if (n4 == 0) {
            n4 = this.viewer.getDisplayModelIndex();
        }
        if (n4 < 0) {
            this.multipleModelsNotOK();
        }
        if ((hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n4, "jmolSurfaceInfo")) == null || !((String)hashtable.get("surfaceDataType")).equals("mo")) {
            Vector vector;
            int n5;
            hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n4, "moData");
            if (hashtable == null) {
                this.evalError(GT._((String)"no MO basis/coefficient data available for this frame"));
            }
            int n6 = n5 = (vector = (Vector)hashtable.get("mos")) == null ? 0 : vector.size();
            if (n5 == 0) {
                this.evalError(GT._((String)"no MO coefficient data available"));
            }
            if (n5 == 1 && n2 > 1) {
                this.evalError(GT._((String)"Only one molecular orbital is available in this file"));
            }
            if (n3 != Integer.MAX_VALUE) {
                if (hashtable.containsKey("HOMO")) {
                    this.lastMoNumber = n2 = (Integer)hashtable.get("HOMO") + n3;
                } else {
                    for (int i = 0; i < n5; ++i) {
                        Hashtable hashtable2 = (Hashtable)vector.get(i);
                        if (!hashtable2.containsKey("occupancy")) {
                            this.evalError(GT._((String)"no MO occupancy data available"));
                        }
                        if ((Integer)hashtable2.get("occupancy") != 0) continue;
                        this.lastMoNumber = n2 = i + n3;
                        break;
                    }
                }
                Logger.info((String)("MO " + n2));
            }
            if (n2 < 1 || n2 > n5) {
                this.evalError(GT._((String)"An MO index from 1 to {0} is required", (int)n5));
            }
        }
        this.lastMoNumber = n2;
        this.setShapeProperty(n, "moData", hashtable);
        if (string != null) {
            this.setShapeProperty(n, "title", string);
        }
        this.setShapeProperty(n, "molecularOrbital", new Integer(n2));
        this.setShapeProperty(n, "clear", null);
    }

    private void initIsosurface(int n) throws ScriptException {
        this.setShapeProperty(n, "init", this.thisCommand);
        this.iToken = 0;
        if (this.tokAt(1) == 32810 || this.tokAt(2) == 32810 && this.tokAt(++this.iToken) == 65551) {
            this.setShapeProperty(n, "delete", null);
            this.iToken += 2;
            if (this.statementLength > this.iToken) {
                this.setShapeProperty(n, "init", this.thisCommand);
                this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            }
            return;
        }
        this.iToken = 1;
        if (!this.setMeshDisplayProperty(n, 0, this.tokAt(1))) {
            this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            if (n != 28) {
                this.setShapeProperty(n, "title", new String[]{this.thisCommand});
            }
        }
    }

    private boolean listIsosurface(int n) throws ScriptException {
        this.checkLength2();
        if (!this.isSyntaxCheck) {
            this.showString((String)this.viewer.getShapeProperty(n, "list"));
        }
        return true;
    }

    void isosurface(int n) throws ScriptException {
        Object object;
        int n2;
        this.viewer.loadShape(n);
        if (this.tokAt(1) == 6 && this.listIsosurface(n)) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl = n == 26;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float[] fArray = new float[5];
        float[] fArray2 = null;
        int n5 = n2 = this.isSyntaxCheck ? 0 : this.viewer.getDisplayModelIndex();
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(4);
        }
        boolean bl5 = false;
        this.initIsosurface(n);
        block30: for (int i = this.iToken; i < this.statementLength; ++i) {
            object = null;
            Object object2 = null;
            block1 : switch (this.getToken((int)i).tok) {
                case 2162729: {
                    float f = this.floatParameter(++i);
                    object2 = this.centerParameter(++i);
                    i = this.iToken;
                    object = "withinPoint";
                    this.setShapeProperty(n, "withinDistance", new Float(f));
                    break;
                }
                case 860169: {
                    Vector<Object> vector;
                    object = "property";
                    String string = this.parameterAsString(i);
                    if (!bl4 && string.toLowerCase().indexOf("property_") == 0) {
                        fArray2 = new float[this.viewer.getAtomCount()];
                        if (this.isSyntaxCheck) continue block30;
                        fArray2 = Viewer.getDataFloat(string);
                        if (fArray2 == null) {
                            this.invalidArgument();
                        }
                        object2 = fArray2;
                        break;
                    }
                    int n6 = this.viewer.getAtomCount();
                    int n7 = this.getToken((int)(++i)).tok;
                    float[] fArray3 = fArray2 = bl4 ? new float[]{} : new float[n6];
                    if (bl4) {
                        this.invalidArgument();
                    }
                    if (!this.isSyntaxCheck && !bl4) {
                        vector = this.viewer.getModelSet();
                        Atom[] atomArray = ((ModelSet)((Object)vector)).atoms;
                        if (n7 == 327721) {
                            this.viewer.getModelSet().getSurfaceDistanceMax();
                        }
                        int n8 = n6;
                        while (--n8 >= 0) {
                            fArray2[n8] = this.atomProperty((ModelSet)((Object)vector), atomArray[n8], n7, false);
                        }
                    }
                    object2 = fArray2;
                    break;
                }
                case 327949: {
                    if (bl2) {
                        this.invalidArgument();
                    }
                    if ((n2 = this.modelNumberParameter(++i)) < 0) {
                        object = "fixed";
                        object2 = Boolean.TRUE;
                        break;
                    }
                    object = "modelIndex";
                    object2 = new Integer(n2);
                    break;
                }
                case 798: {
                    object = "select";
                    object2 = this.expression(++i);
                    i = this.iToken;
                    break;
                }
                case 772: {
                    object = "center";
                    object2 = this.centerParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 881923: {
                    n3 = 0;
                    switch (this.getToken((int)(i + 1)).tok) {
                        case 32815: {
                            ++i;
                            n3 = 1;
                            break;
                        }
                        case 49172: 
                        case 0x110008: {
                            n4 = i + 1;
                            break;
                        }
                    }
                    continue block30;
                }
                case 327944: {
                    continue block30;
                }
                case 0x110031: {
                    if (n3 != 0) break;
                    object = "cutoffPositive";
                    object2 = new Float(this.floatParameter(++i));
                    break;
                }
                case 2: 
                case 3: {
                    object = n3 == 1 ? "red" : (n3 == 2 ? "blue" : "cutoff");
                    object2 = new Float(this.floatParameter(i));
                    if (n3 <= 0) break;
                    ++n3;
                    break;
                }
                case 49172: 
                case 0x110008: {
                    if (i != n4) {
                        this.invalidParameterOrder();
                    }
                    object = "colorRGB";
                    object2 = new Integer(this.getArgbParam(i));
                    i = this.iToken;
                    n4 = i + 1;
                    break;
                }
                case 32823: {
                    object = "ionicRadius";
                    object2 = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.iToken;
                    break;
                }
                case 327702: {
                    object = "vdwRadius";
                    object2 = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.iToken;
                    break;
                }
                case 1: {
                    Vector<Object> vector;
                    String string = this.parameterAsString(i);
                    if (string.equalsIgnoreCase("REMAPPABLE")) {
                        object = "remappable";
                        break;
                    }
                    if (string.equalsIgnoreCase("IGNORE")) {
                        object = "ignore";
                        object2 = this.expression(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string.equalsIgnoreCase("CUTOFF")) {
                        if (++i < this.statementLength && this.getToken((int)i).tok == 0x110031) {
                            object = "cutoffPositive";
                            object2 = new Float(this.floatParameter(++i));
                            break;
                        }
                        object = "cutoff";
                        object2 = new Float(this.floatParameter(i));
                        break;
                    }
                    if (string.equalsIgnoreCase("CAVITY")) {
                        float f;
                        if (!bl) {
                            this.invalidArgument();
                        }
                        bl4 = true;
                        if (this.isSyntaxCheck) continue block30;
                        float f2 = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 1.2f;
                        float f3 = f = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 10.0f;
                        if (f > 10.0f) {
                            this.numberOutOfRange(0, 10);
                        }
                        this.setShapeProperty(n, "envelopeRadius", new Float(f));
                        this.setShapeProperty(n, "cavityRadius", new Float(f2));
                        object = "cavity";
                        break;
                    }
                    if (string.equalsIgnoreCase("POCKET")) {
                        object = "pocket";
                        object2 = Boolean.TRUE;
                        break;
                    }
                    if (string.equalsIgnoreCase("INTERIOR")) {
                        object = "pocket";
                        object2 = Boolean.FALSE;
                        break;
                    }
                    if (string.equalsIgnoreCase("SCALE")) {
                        object = "scale";
                        object2 = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string.equalsIgnoreCase("MINSET")) {
                        object = "minset";
                        object2 = new Integer(this.intParameter(++i));
                        break;
                    }
                    if (string.equalsIgnoreCase("ANGSTROMS")) {
                        object = "angstroms";
                        break;
                    }
                    if (string.equalsIgnoreCase("RESOLUTION")) {
                        object = "resolution";
                        object2 = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string.equalsIgnoreCase("ANISOTROPY")) {
                        object = "anisotropy";
                        object2 = this.getPoint3f(++i, false);
                        i = this.iToken;
                        break;
                    }
                    if (string.equalsIgnoreCase("ECCENTRICITY")) {
                        object = "eccentricity";
                        object2 = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string.equalsIgnoreCase("FIXED")) {
                        object = "fixed";
                        object2 = Boolean.TRUE;
                        break;
                    }
                    if (string.equalsIgnoreCase("BLOCKDATA")) {
                        object = "blockData";
                        object2 = Boolean.TRUE;
                        break;
                    }
                    if (string.equalsIgnoreCase("MODELBASED")) {
                        object = "fixed";
                        object2 = Boolean.FALSE;
                        break;
                    }
                    if (string.equalsIgnoreCase("SIGN")) {
                        n4 = i + 1;
                        object = "sign";
                        object2 = Boolean.TRUE;
                        n3 = 1;
                        break;
                    }
                    if (string.equalsIgnoreCase("REVERSECOLOR")) {
                        object = "reverseColor";
                        object2 = Boolean.TRUE;
                        break;
                    }
                    if (string.equalsIgnoreCase("ADDHYDROGENS")) {
                        object = "addHydrogens";
                        object2 = Boolean.TRUE;
                        break;
                    }
                    if (string.equalsIgnoreCase("COLORSCHEME")) {
                        object = "setColorScheme";
                        object2 = this.parameterAsString(++i);
                        break;
                    }
                    if (string.equalsIgnoreCase("DEBUG") || string.equalsIgnoreCase("NODEBUG")) {
                        object = "debug";
                        object2 = string.equalsIgnoreCase("DEBUG") ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    if (string.equalsIgnoreCase("GRIDPOINTS")) {
                        object = "gridPoints";
                        break;
                    }
                    if (string.equalsIgnoreCase("CONTOUR")) {
                        object = "contour";
                        object2 = new Integer(this.tokAt(i + 1) == 2 ? this.intParameter(++i) : 0);
                        break;
                    }
                    if (string.equalsIgnoreCase("PHASE")) {
                        object = "phase";
                        object2 = this.tokAt(i + 1) == 4 ? this.stringParameter(++i) : "_orb";
                        break;
                    }
                    if (string.equalsIgnoreCase("MAP")) {
                        bl2 = !bl4;
                        object = "map";
                        break;
                    }
                    if (string.equalsIgnoreCase("plane")) {
                        bl3 = true;
                        object = "plane";
                        object2 = this.planeParameter(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string.equalsIgnoreCase("hkl")) {
                        bl3 = true;
                        object = "plane";
                        object2 = this.hklParameter(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string.equalsIgnoreCase("sphere")) {
                        bl2 = true;
                        object = "sphere";
                        object2 = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string.equalsIgnoreCase("ellipsoid")) {
                        bl2 = true;
                        object = "ellipsoid";
                        object2 = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string.equalsIgnoreCase("lobe")) {
                        bl2 = true;
                        object = "lobe";
                        object2 = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string.equalsIgnoreCase("AtomicOrbital") || string.equalsIgnoreCase("orbital")) {
                        bl2 = true;
                        fArray[0] = this.intParameter(++i);
                        fArray[1] = this.intParameter(++i);
                        fArray[2] = this.intParameter(++i);
                        fArray[3] = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 6.0f;
                        object = "hydrogenOrbital";
                        object2 = fArray;
                        break;
                    }
                    if (string.equalsIgnoreCase("functionXY")) {
                        bl2 = true;
                        vector = new Vector<Object>();
                        if (this.getToken((int)(++i)).tok != 4) {
                            this.invalidArgument();
                        }
                        String string2 = this.parameterAsString(i++);
                        vector.addElement(string2);
                        vector.addElement(this.getPoint3f(i, false));
                        Point4f point4f = this.getPoint4f(++this.iToken);
                        vector.addElement(point4f);
                        int n9 = (int)point4f.x;
                        point4f = this.getPoint4f(++this.iToken);
                        vector.addElement(point4f);
                        int n10 = (int)point4f.x;
                        vector.addElement(this.getPoint4f(++this.iToken));
                        if (n9 == 0 || n10 == 0) {
                            this.invalidArgument();
                        }
                        if (!this.isSyntaxCheck) {
                            vector.addElement(this.viewer.functionXY(string2, n9, n10));
                        }
                        i = this.iToken;
                        object = "functionXY";
                        object2 = vector;
                        break;
                    }
                    if (string.equalsIgnoreCase("molecular")) {
                        bl2 = true;
                        object = "molecular";
                        object2 = new Float(1.4);
                        break;
                    }
                    if (string.equalsIgnoreCase("VARIABLE")) {
                        object = "property";
                        fArray2 = new float[this.viewer.getAtomCount()];
                        if (!this.isSyntaxCheck) {
                            Parser.parseFloatArray((String)("" + this.viewer.getParameter(this.parameterAsString(++i))), null, (float[])fArray2);
                        }
                        object2 = fArray2;
                        break;
                    }
                    object2 = this.theToken.value;
                }
                case 65551: {
                    if (bl5) {
                        this.invalidArgument();
                    }
                    object = "thisID";
                    break;
                }
                case 17764: {
                    bl2 = true;
                    Vector<Object> vector = this.parameterAsString(++i);
                    this.setShapeProperty(n, "lcaoType", vector);
                    switch (this.getToken((int)(++i)).tok) {
                        case 32839: 
                        case 65636: {
                            Point3f point3f;
                            object = "lcaoCartoon";
                            BitSet bitSet = this.expression(i);
                            i = this.iToken;
                            int n11 = BitSetUtil.firstSetBit((BitSet)bitSet);
                            n2 = 0;
                            if (n11 < 0) {
                                if (!this.isSyntaxCheck) {
                                    this.expressionExpected();
                                }
                                point3f = new Point3f();
                            } else {
                                n2 = this.viewer.getAtomModelIndex(n11);
                                point3f = this.viewer.getAtomPoint3f(n11);
                            }
                            this.setShapeProperty(n, "modelIndex", new Integer(n2));
                            Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f((Tuple3f)point3f)};
                            if (!this.isSyntaxCheck) {
                                this.viewer.getHybridizationAndAxes(n11, vector3fArray[0], vector3fArray[1], (String)((Object)vector), false);
                            }
                            object2 = vector3fArray;
                            break block1;
                        }
                    }
                    this.expressionExpected();
                    break;
                }
                case 20835: {
                    if (++i == this.statementLength) {
                        this.badArgumentCount();
                    }
                    int n12 = Integer.MAX_VALUE;
                    int n13 = Integer.MAX_VALUE;
                    if (this.tokAt(i) == 2) {
                        n12 = this.intParameter(i);
                    } else {
                        n13 = this.moOffset(i);
                        if (n13 != Integer.MAX_VALUE) {
                            n12 = 0;
                            i = this.iToken;
                        }
                    }
                    this.setMoData(n, n12, n13, n2, null);
                    bl2 = true;
                    continue block30;
                }
                case 32777: {
                    float[] fArray4 = null;
                    try {
                        fArray4 = this.viewer.getPartialCharges();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.isSyntaxCheck && fArray4 == null) {
                        this.evalError(GT._((String)"No partial charges were read from the file; Jmol needs these to render the MEP data."));
                    }
                    bl2 = true;
                    object = "mep";
                    object2 = fArray4;
                    break;
                }
                case 32832: 
                case 204804: {
                    bl2 = true;
                    this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
                    object = this.theTok == 32832 ? "sasurface" : "solvent";
                    float f = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : this.viewer.getSolventProbeRadius();
                    object2 = new Float(f);
                    break;
                }
                case 4: {
                    Object object3;
                    object = bl2 || bl3 ? "mapColor" : "readFile";
                    String string = (String)this.theToken.value;
                    if (string.length() == 0) {
                        if (bl2 || bl3) {
                            object2 = this.viewer.getModelAuxiliaryInfo(n2, "jmolMappedDataInfo");
                        }
                        if (object2 == null) {
                            object2 = this.viewer.getModelAuxiliaryInfo(n2, "jmolSurfaceInfo");
                        }
                        bl2 = true;
                        if (object2 != null) break;
                        string = this.getFullPathName();
                    }
                    bl2 = true;
                    if (this.tokAt(i + 1) == 2) {
                        this.setShapeProperty(n, "fileIndex", new Integer(this.intParameter(++i)));
                    }
                    Object object4 = object3 = this.isSyntaxCheck ? null : this.viewer.getUnzippedBufferedReaderOrErrorMessageFromName(string);
                    if (object3 instanceof String) {
                        this.fileNotFoundException(string + ":" + object3);
                    }
                    if (!this.isSyntaxCheck) {
                        Logger.info((String)("reading isosurface data from " + string));
                    }
                    object2 = object3;
                    break;
                }
                default: {
                    if (bl3 && !bl2) {
                        this.setShapeProperty(n, "nomap", new Float(0.0f));
                        bl2 = true;
                    }
                    if (!this.setMeshDisplayProperty(n, i, this.theTok)) {
                        this.invalidArgument();
                    }
                    i = this.iToken;
                }
            }
            boolean bl6 = bl5 = this.theTok != 32810;
            if (object == "property" && !bl2) {
                bl2 = true;
                this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
                this.setShapeProperty(n, "sasurface", new Float(0.0f));
            }
            if (object == null) continue;
            this.setShapeProperty(n, (String)object, object2);
        }
        if (bl4 && !bl2) {
            bl2 = true;
            this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
            this.setShapeProperty(n, "sasurface", new Float(0.0f));
        }
        if (bl3 && !bl2) {
            this.setShapeProperty(n, "nomap", new Float(0.0f));
            bl2 = true;
        }
        if (bl2 && bl && !this.isSyntaxCheck) {
            String string = (String)this.viewer.getShapeProperty(n, "ID");
            object = (Integer)this.viewer.getShapeProperty(n, "count");
            if (string != null) {
                this.showString(string + " created; number of isosurfaces = " + object);
            }
        }
        this.setShapeProperty(n, "clear", null);
    }

    boolean setMeshDisplayProperty(int n, int n2, int n3) throws ScriptException {
        String string = null;
        Comparable<Boolean> comparable = null;
        boolean bl = n2 == 0;
        switch (n3) {
            case 32769: {
                string = "on";
                break;
            }
            case 32768: {
                string = "off";
                break;
            }
            case 32810: {
                string = "delete";
                break;
            }
            case 1290: {
                comparable = Boolean.TRUE;
            }
            case 32817: {
                string = "dots";
                break;
            }
            case 32818: {
                comparable = Boolean.TRUE;
            }
            case 32819: {
                string = "mesh";
                break;
            }
            case 32820: {
                comparable = Boolean.TRUE;
            }
            case 32821: {
                string = "fill";
                break;
            }
            case 32850: {
                comparable = Boolean.TRUE;
            }
            case 32851: {
                string = "triangles";
                break;
            }
            case 32852: {
                comparable = Boolean.TRUE;
            }
            case 32853: {
                string = "frontOnly";
                break;
            }
            case 32854: {
                string = "lighting";
                comparable = new Integer(0);
                break;
            }
            case 32855: {
                string = "lighting";
                comparable = new Integer(1);
                break;
            }
            case 32856: {
                string = "lighting";
                comparable = new Integer(2);
                break;
            }
            case 32808: 
            case 32809: {
                if (bl) {
                    return true;
                }
                this.colorShape(n, this.iToken, false);
                return true;
            }
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        this.setShapeProperty(n, string, comparable);
        n3 = this.tokAt(this.iToken + 1);
        if (n3 != 0 && !this.setMeshDisplayProperty(n, ++this.iToken, n3)) {
            --this.iToken;
        }
        return true;
    }

    void evalError(String string) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.isSyntaxCheck) {
            String string2 = this.viewer.removeCommand();
            this.viewer.addCommand(string2 + "#??");
            this.viewer.setCursor(0);
        }
        throw new ScriptException(string);
    }

    private void multipleModelsNotOK() throws ScriptException {
        this.evalError(GT._((String)"MO isosurfaces require that only one model be displayed"));
    }

    private void unrecognizedCommand() throws ScriptException {
        this.evalError(GT._((String)"unrecognized command") + ": " + this.statement[0].value);
    }

    private void unrecognizedAtomProperty(String string) throws ScriptException {
        this.evalError(GT._((String)"unrecognized atom property") + ": " + string);
    }

    private void unrecognizedBondProperty(String string) throws ScriptException {
        this.evalError(GT._((String)"unrecognized bond property") + ": " + string);
    }

    private void filenameExpected() throws ScriptException {
        this.evalError(GT._((String)"filename expected"));
    }

    private void booleanExpected() throws ScriptException {
        this.evalError(GT._((String)"boolean expected"));
    }

    private void booleanOrNumberExpected() throws ScriptException {
        this.evalError(GT._((String)"boolean or number expected"));
    }

    private void booleanOrNumberExpected(String string) throws ScriptException {
        this.evalError(GT._((String)"boolean, number, or {0} expected", (String)("\"" + string + "\"")));
    }

    private void expressionOrIntegerExpected() throws ScriptException {
        this.evalError(GT._((String)"(atom expression) or integer expected"));
    }

    private void expressionExpected() throws ScriptException {
        this.evalError(GT._((String)"valid (atom expression) expected"));
    }

    private void badRGBColor() throws ScriptException {
        this.evalError(GT._((String)"bad [R,G,B] color"));
    }

    private int integerExpected() throws ScriptException {
        this.evalError(GT._((String)"integer expected"));
        return 0;
    }

    private float numberExpected() throws ScriptException {
        this.evalError(GT._((String)"number expected"));
        return 0.0f;
    }

    private String stringExpected() throws ScriptException {
        this.evalError(GT._((String)"quoted string expected"));
        return "";
    }

    private void stringOrIdentifierExpected() throws ScriptException {
        this.evalError(GT._((String)"quoted string or identifier expected"));
    }

    private void propertyNameExpected() throws ScriptException {
        this.evalError(GT._((String)"property name expected"));
    }

    private void axisExpected() throws ScriptException {
        this.evalError(GT._((String)"x y z axis expected"));
    }

    private void colorExpected() throws ScriptException {
        this.evalError(GT._((String)"color expected"));
    }

    private void unrecognizedObject() throws ScriptException {
        this.evalError(GT._((String)"unrecognized object"));
    }

    private void unrecognizedExpression() throws ScriptException {
        this.evalError(GT._((String)"runtime unrecognized expression"));
    }

    void endOfStatementUnexpected() throws ScriptException {
        this.evalError(GT._((String)"unexpected end of script command"));
    }

    private void badArgumentCount() throws ScriptException {
        this.evalError(GT._((String)"bad argument count"));
    }

    void invalidArgument() throws ScriptException {
        this.evalError(GT._((String)"invalid argument"));
    }

    void unrecognizedParameter(String string, String string2) throws ScriptException {
        this.evalError(GT._((String)"unrecognized {0} parameter", (String)string) + ": " + string2);
    }

    private void unrecognizedShowParameter(String string) throws ScriptException {
        this.evalError(GT._((String)"unrecognized SHOW parameter --  use {0}", (String)string));
    }

    private void numberOutOfRange(int n, int n2) throws ScriptException {
        this.evalError(GT._((String)"integer out of range ({0} - {1})", (Object[])new Object[]{new Integer(n), new Integer(n2)}));
    }

    private void numberOutOfRange(float f, float f2) throws ScriptException {
        this.evalError(GT._((String)"decimal number out of range ({0} - {1})", (Object[])new Object[]{new Float(f), new Float(f2)}));
    }

    private void numberMustBe(int n, int n2) throws ScriptException {
        this.evalError(GT._((String)"number must be ({0} or {1})", (Object[])new Object[]{new Integer(n), new Integer(n2)}));
    }

    private void fileNotFoundException(String string) throws ScriptException {
        this.evalError(GT._((String)"file not found") + ": " + string);
    }

    private void drawObjectNotDefined(String string) throws ScriptException {
        this.evalError(GT._((String)"draw object not defined") + ": " + string);
    }

    String objectNameExpected() throws ScriptException {
        this.evalError(GT._((String)"object name expected after '$'"));
        return "";
    }

    private void coordinateOrNameOrExpressionRequired() throws ScriptException {
        this.evalError(GT._((String)" {x y z} or $name or (atom expression) required"));
    }

    private void keywordExpected(String string) throws ScriptException {
        this.evalError(GT._((String)"keyword expected") + ": " + string);
    }

    private void invalidParameterOrder() throws ScriptException {
        this.evalError(GT._((String)"invalid parameter order"));
    }

    private void incompatibleArguments() throws ScriptException {
        this.evalError(GT._((String)"incompatible arguments"));
    }

    private void insufficientArguments() throws ScriptException {
        this.evalError(GT._((String)"insufficient arguments"));
    }

    String statementAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.statement[0].tok;
        boolean bl = Compiler.tokAttr(n, 1024);
        boolean bl2 = n == 5484 || n == 21791;
        boolean bl3 = false;
        block25: for (int i = 0; i < this.statementLength; ++i) {
            if (this.iToken == i - 1) {
                stringBuffer.append(" <<");
            }
            if (i != 0) {
                stringBuffer.append(' ');
            }
            Token token = this.statement[i];
            if (this.iToken == i && token.tok != 65637) {
                stringBuffer.append(">> ");
            }
            switch (token.tok) {
                case 65636: {
                    if (bl2) {
                        stringBuffer.append("{");
                        continue block25;
                    }
                    if (!bl) continue block25;
                    stringBuffer.append("(");
                    continue block25;
                }
                case 65637: {
                    if (bl2) {
                        stringBuffer.append("}");
                        continue block25;
                    }
                    if (!bl) continue block25;
                    stringBuffer.append(")");
                    continue block25;
                }
                case 0x110008: 
                case 0x110009: {
                    break;
                }
                case 65539: 
                case 65540: {
                    bl3 = token.tok == 65539;
                    break;
                }
                case 74505: {
                    if (i <= 0) break;
                    stringBuffer.append("@");
                    break;
                }
                case 32769: {
                    stringBuffer.append("true");
                    continue block25;
                }
                case 32768: {
                    stringBuffer.append("false");
                    break;
                }
                case 798: {
                    break;
                }
                case 2: {
                    stringBuffer.append(token.intValue);
                    continue block25;
                }
                case 7: 
                case 8: 
                case 32839: {
                    stringBuffer.append(Token.sValue(token));
                    continue block25;
                }
                case 65563: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                    } else {
                        stringBuffer.append(Group.getSeqcodeString(Eval.getSeqCode(token)));
                    }
                    token = this.statement[++i];
                    stringBuffer.append(' ');
                    stringBuffer.append(bl3 ? "-" : "- ");
                }
                case 65562: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                        continue block25;
                    }
                    stringBuffer.append(Group.getSeqcodeString(Eval.getSeqCode(token)));
                    continue block25;
                }
                case 65564: {
                    stringBuffer.append("*:");
                    stringBuffer.append((char)token.intValue);
                    continue block25;
                }
                case 65565: {
                    stringBuffer.append("*%");
                    if (token.value == null) continue block25;
                    stringBuffer.append(token.value.toString());
                    continue block25;
                }
                case 65566: {
                    stringBuffer.append("*/");
                }
                case 3: 
                case 65567: {
                    if (token.intValue < Integer.MAX_VALUE) {
                        int n2 = token.intValue;
                        stringBuffer.append("" + n2 / 1000000);
                        stringBuffer.append(".");
                        stringBuffer.append("" + n2 % 1000000);
                        continue block25;
                    }
                    stringBuffer.append("" + token.value);
                    continue block25;
                }
                case 65560: {
                    stringBuffer.append('[');
                    stringBuffer.append(Group.getGroup3((short)token.intValue));
                    stringBuffer.append(']');
                    continue block25;
                }
                case 65561: {
                    stringBuffer.append('[');
                    stringBuffer.append(token.value);
                    stringBuffer.append(']');
                    continue block25;
                }
                case 65568: {
                    stringBuffer.append("*.");
                    break;
                }
                case 327685: {
                    if (!(token.value instanceof Point3f)) break;
                    Point3f point3f = (Point3f)token.value;
                    stringBuffer.append("cell={").append(point3f.x).append(" ").append(point3f.y).append(" ").append(point3f.z).append("}");
                    continue block25;
                }
                case 4: {
                    stringBuffer.append("\"").append(token.value).append("\"");
                    continue block25;
                }
                case 5308456: 
                case 5308457: 
                case 5308458: 
                case 5308459: 
                case 5308460: 
                case 5308461: {
                    if (token.intValue == 860169) {
                        stringBuffer.append((String)this.statement[++i].value).append(" ");
                        break;
                    }
                    if (token.intValue == Integer.MAX_VALUE) break;
                    stringBuffer.append(Token.nameOf(token.intValue)).append(" ");
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (!this.logMessages) break;
                    stringBuffer.append(token.toString());
                    continue block25;
                }
            }
            stringBuffer.append(token.value.toString());
        }
        if (this.iToken >= this.statementLength - 1) {
            stringBuffer.append(" <<");
        }
        return stringBuffer.toString();
    }

    String contextTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            stringBuffer.append(Eval.setErrorLineMessage(this.filename, this.getLinenumber(), this.pc, this.statementAsString()));
            if (this.scriptLevel <= 0) break;
            this.popContext();
        }
        return stringBuffer.toString();
    }

    static String setErrorLineMessage(String string, int n, int n2, String string2) {
        String string3 = "\n----";
        if (string != null) {
            string3 = string3 + "line " + n + " command " + (n2 + 1) + " of file " + string + ":";
        }
        string3 = string3 + "\n         " + string2;
        return string3;
    }

    class Rpn {
        Token[] oStack;
        Token[] xStack;
        int oPt = -1;
        int xPt = -1;
        int maxLevel;
        int parenCount;
        int squareCount;
        int braceCount;
        boolean wasX = false;

        Rpn(int n) {
            this.maxLevel = n;
            this.oStack = new Token[n];
            this.xStack = new Token[n];
            if (Eval.this.logMessages) {
                Logger.info((String)("initialize RPN on " + Eval.this.script));
            }
        }

        Token getResult(boolean bl) throws ScriptException {
            boolean bl2 = true;
            while (bl2 && this.oPt >= 0) {
                bl2 = this.operate(0);
            }
            if (bl2 && this.xPt == 0) {
                Token token = this.xStack[0];
                if (token.tok == 32839 || token.tok == 6 || token.tok == 4) {
                    token = this.xStack[0] = Token.selectItem(token, Integer.MIN_VALUE);
                }
                if (token.tok == 6) {
                    token = new Token(4, Token.sValue(token));
                }
                return token;
            }
            if (!(bl || this.xPt < 0 && this.oPt < 0)) {
                --Eval.this.iToken;
                Eval.this.invalidArgument();
            }
            return null;
        }

        boolean addX(Token token) throws ScriptException {
            if (this.xPt + 1 == this.maxLevel) {
                this.stackOverflow();
            }
            if (this.wasX && token.tok == 2 && token.intValue < 0) {
                this.addOp(Token.tokenMinus);
                this.xStack[++this.xPt] = new Token(2, -token.intValue);
            } else if (this.wasX && token.tok == 3 && ((Float)token.value).floatValue() < 0.0f) {
                this.addOp(Token.tokenMinus);
                this.xStack[++this.xPt] = new Token(3, new Float(-Token.fValue(token)));
            } else {
                this.xStack[++this.xPt] = token;
            }
            if (Eval.this.logMessages) {
                Logger.info((String)("addX token " + token));
            }
            this.wasX = true;
            return true;
        }

        boolean addX(Object object) throws ScriptException {
            if (object instanceof Integer) {
                return this.addX((Integer)object);
            }
            if (object instanceof Float) {
                return this.addX(((Float)object).floatValue());
            }
            if (object instanceof String) {
                return this.addX((String)object);
            }
            if (object instanceof Point3f) {
                return this.addX((Point3f)object);
            }
            if (object instanceof BitSet) {
                return this.addX((BitSet)object);
            }
            if (object instanceof Token) {
                return this.addX((Token)object);
            }
            return false;
        }

        boolean addX(boolean bl) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = bl ? Token.tokenOn : Token.tokenOff;
            return true;
        }

        boolean addX(int n) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(2, n, new Integer(n));
            this.wasX = true;
            return true;
        }

        boolean addX(float f) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(3, new Float(f));
            this.wasX = true;
            return true;
        }

        boolean addX(String string) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(4, string);
            this.wasX = true;
            return true;
        }

        boolean addX(String[] stringArray) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(6, stringArray);
            this.wasX = true;
            return true;
        }

        boolean addX(Point3f point3f) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(7, point3f);
            this.wasX = true;
            return true;
        }

        boolean addX(BitSet bitSet) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(32839, bitSet);
            this.wasX = true;
            return true;
        }

        boolean isOpFunc(Token token) {
            return Compiler.tokAttr(token.tok, 0x210000) || token.tok == 1114185 && Compiler.tokAttr(token.intValue, 0x210000);
        }

        boolean addOp(Token token) throws ScriptException {
            if (Eval.this.logMessages) {
                Logger.info((String)("\naddOp: " + token));
                this.dumpStacks();
            }
            Token token2 = null;
            boolean bl = false;
            boolean bl2 = token.tok == 1114185;
            boolean bl3 = this.isOpFunc(token);
            if (bl2 && !this.wasX) {
                return false;
            }
            switch (token.tok) {
                case 65547: {
                    if (!this.wasX) {
                        return false;
                    }
                    this.wasX = false;
                    return true;
                }
                case 64: 
                case 128: 
                case 192: {
                    int n;
                    int n2 = n = this.oPt < 0 ? 0 : this.oStack[this.oPt].tok;
                    if (!this.wasX || n != 1114185 && n != 860162 && n != 851969) {
                        return false;
                    }
                    this.oStack[this.oPt].intValue |= token.tok;
                    return true;
                }
                case 0x110008: {
                    boolean bl4 = bl = !this.wasX;
                    if (!bl) break;
                    token = token2 = new Token(0x110008, 0);
                    break;
                }
                case 0x110030: {
                    if (this.wasX) break;
                    this.addX(0);
                    token = new Token(0x110040, "-");
                    break;
                }
                case 0x110001: {
                    if (this.wasX || this.oPt < 1 || this.oStack[this.oPt].tok != 0x110000 || this.isOpFunc(this.oStack[this.oPt - 1])) break;
                    return false;
                }
                case 0x110000: 
                case 0x110020: {
                    bl = true;
                }
                default: {
                    if (bl3) {
                        if (!bl2 && this.wasX) {
                            return false;
                        }
                        token2 = token;
                        bl = true;
                        break;
                    }
                    if (this.wasX != bl) break;
                    return false;
                }
            }
            while (this.oPt >= 0 && (!bl && token.tok != 0x110008 || (token.tok == 1114185 || token.tok == 0x110008) && this.oStack[this.oPt].tok == 1114185) && Token.prec(this.oStack[this.oPt]) >= Token.prec(token)) {
                if (Eval.this.logMessages) {
                    this.dumpStacks();
                    Logger.info((String)("\noperating, oPt=" + this.oPt + " isLeftOp=" + bl + " oStack[oPt]=" + Token.nameOf(this.oStack[this.oPt].tok) + "/" + Token.prec(this.oStack[this.oPt]) + " op=" + Token.nameOf(token.tok) + "/" + Token.prec(token)));
                }
                if (token.tok == 0x110001 && this.oStack[this.oPt].tok == 0x110000) break;
                if (token.tok == 0x110009 && this.oStack[this.oPt].tok == 0x110008) {
                    if (!(this.oStack[this.oPt].intValue == 0 ? this.xPt >= 0 && this.xStack[this.xPt].tok == 4 && !this.concatList() : !this.doBitsetSelect())) break;
                    return false;
                }
                if (this.operate(token.tok)) continue;
                return false;
            }
            if (token2 != null) {
                this.addX(token2);
            }
            switch (token.tok) {
                case 0x110000: {
                    ++this.parenCount;
                    this.wasX = false;
                    break;
                }
                case 0x110008: {
                    ++this.squareCount;
                    this.wasX = false;
                    break;
                }
                case 0x110001: {
                    this.wasX = true;
                    --this.oPt;
                    if (this.parenCount-- <= 0) {
                        return false;
                    }
                    if (this.oPt < 0) {
                        return true;
                    }
                    return this.isOpFunc(this.oStack[this.oPt]) ? this.evaluateFunction() : true;
                }
                case 0x110009: {
                    this.wasX = true;
                    --this.oPt;
                    return this.squareCount-- > 0;
                }
                case 1114185: {
                    this.wasX = !Compiler.tokAttr(token.intValue, 0x210000);
                    break;
                }
                case 65539: {
                    ++this.braceCount;
                    this.wasX = false;
                    break;
                }
                case 65540: {
                    if (this.braceCount-- <= 0) {
                        return false;
                    }
                }
                default: {
                    this.wasX = false;
                }
            }
            if (++this.oPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.oStack[this.oPt] = token;
            return true;
        }

        private boolean concatList() throws ScriptException {
            int n = 0;
            int n2 = this.xPt;
            while (this.xStack[n2--].tok != 0x110008) {
                ++n;
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = Token.sValue(this.xStack[n2 + i + 2]);
            }
            this.xPt = n2;
            this.addX(stringArray);
            return true;
        }

        private boolean doBitsetSelect() {
            if (this.xPt < 1) {
                return false;
            }
            int n = Token.iValue(this.xStack[this.xPt--]);
            Token token = this.xStack[this.xPt];
            switch (token.tok) {
                default: {
                    token = new Token(4, Token.sValue(token));
                }
                case 4: 
                case 6: 
                case 32839: 
            }
            this.xStack[this.xPt] = Token.selectItem(token, n);
            return true;
        }

        void dumpStacks() {
            int n;
            Logger.info((String)("RPN stacks: for " + Eval.this.script));
            for (n = 0; n <= this.xPt; ++n) {
                Logger.info((String)("x[" + n + "]: " + this.xStack[n]));
            }
            for (n = 0; n <= this.oPt; ++n) {
                Logger.info((String)("o[" + n + "]: " + this.oStack[n] + " prec=" + Token.prec(this.oStack[n])));
            }
        }

        Token getX() throws ScriptException {
            if (this.xPt < 0) {
                Eval.this.endOfStatementUnexpected();
            }
            return this.xStack[this.xPt--];
        }

        boolean evaluateFunction() throws ScriptException {
            Token token = this.oStack[this.oPt--];
            int n = token.tok == 1114185 ? token.intValue : token.tok;
            int n2 = Token.prec(token);
            int n3 = 0;
            int n4 = this.xPt;
            while (this.xStack[n4--] != token) {
                ++n3;
            }
            if (n3 > n2) {
                return false;
            }
            Token[] tokenArray = new Token[n3];
            int n5 = n3;
            while (--n5 >= 0) {
                tokenArray[n5] = this.getX();
            }
            --this.xPt;
            switch (n) {
                case 2949130: {
                    return this.evaluateFind(tokenArray);
                }
                case 2949139: {
                    return this.evaluateReplace(tokenArray);
                }
                case 2949121: 
                case 0x2D0002: 
                case 2949123: {
                    return this.evaluateString(token.intValue, tokenArray);
                }
                case 2949124: 
                case 2949125: 
                case 2949126: 
                case 2949127: {
                    return this.evaluateList(token.intValue, tokenArray);
                }
                case 2959625: {
                    return this.evaluateLabel(tokenArray);
                }
                case 0x210112: {
                    return this.evaluateData(tokenArray);
                }
                case 2167051: {
                    return this.evaluateLoad(tokenArray);
                }
                case 2162957: 
                case 2165006: {
                    return this.evaluateScript(tokenArray, n == 2165006);
                }
                case 2162729: {
                    return this.evaluateWithin(tokenArray);
                }
                case 2949137: {
                    if (token.tok == 1114185) {
                        return this.evaluateDistance(tokenArray);
                    }
                }
                case 0x210021: {
                    return this.evaluateMeasure(tokenArray, token.tok == 0x210021);
                }
                case 2162730: {
                    return this.evaluateConnected(tokenArray);
                }
                case 2162700: {
                    return this.evaluateSubstructure(tokenArray);
                }
            }
            return false;
        }

        boolean evaluateDistance(Token[] tokenArray) throws ScriptException {
            Token token = this.getX();
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1.0f);
            }
            Token token2 = tokenArray[0];
            Point3f point3f = this.ptValue(token2);
            Point4f point4f = this.planeValue(token2);
            if (token.tok == 32839) {
                return this.addX(Eval.this.getBitsetProperty(Token.bsSelect(token), 2949137, point3f, point4f, token.value, null, false));
            }
            if (token.tok == 7) {
                return this.addX(point4f == null ? point3f.distance(this.ptValue(token)) : Graphics3D.distanceToPlane((Point4f)point4f, (Point3f)this.ptValue(token)));
            }
            return false;
        }

        boolean evaluateMeasure(Token[] tokenArray, boolean bl) throws ScriptException {
            int n = tokenArray.length;
            if (n < (bl ? 3 : 2) || n > (bl ? 4 : 2)) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1.0f);
            }
            Point3f[] point3fArray = new Point3f[n];
            for (int i = 0; i < n; ++i) {
                point3fArray[i] = this.ptValue(tokenArray[i]);
            }
            switch (n) {
                case 2: {
                    return this.addX(point3fArray[0].distance(point3fArray[1]));
                }
                case 3: {
                    return this.addX(Measure.computeAngle((Point3f)point3fArray[0], (Point3f)point3fArray[1], (Point3f)point3fArray[2], (boolean)true));
                }
                case 4: {
                    return this.addX(Measure.computeTorsion((Point3f)point3fArray[0], (Point3f)point3fArray[1], (Point3f)point3fArray[2], (Point3f)point3fArray[3], (boolean)true));
                }
            }
            return false;
        }

        boolean evaluateFind(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1);
            }
            Token token = this.getX();
            String string = Token.sValue(tokenArray[0]);
            switch (token.tok) {
                default: {
                    return this.addX(Token.sValue(token).indexOf(string) + 1);
                }
                case 6: 
            }
            int n = 0;
            String[] stringArray = (String[])token.value;
            int n2 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(string) < 0) continue;
                ++n;
                n2 = i;
            }
            if (n == 1) {
                return this.addX(stringArray[n2]);
            }
            String[] stringArray2 = new String[n];
            if (n > 0) {
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    if (stringArray[n3].indexOf(string) < 0) continue;
                    stringArray2[--n] = stringArray[n3];
                }
            }
            return this.addX(stringArray2);
        }

        boolean evaluateReplace(Token[] tokenArray) throws ScriptException {
            String string;
            if (tokenArray.length != 2) {
                return false;
            }
            Token token = this.getX();
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string2 = Token.sValue(tokenArray[0]);
            String string3 = Token.sValue(tokenArray[1]);
            String string4 = string = token.tok == 6 ? null : Token.sValue(token);
            if (string != null) {
                return this.addX(TextFormat.simpleReplace((String)string, (String)string2, (String)string3));
            }
            String[] stringArray = (String[])token.value;
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = TextFormat.simpleReplace((String)stringArray[n], (String)string2, (String)string3);
            }
            return this.addX(stringArray);
        }

        boolean evaluateString(int n, Token[] tokenArray) throws ScriptException {
            String string;
            if (tokenArray.length > 1) {
                return false;
            }
            Token token = this.getX();
            String string2 = string = n == 2949123 && token.tok == 6 ? null : Token.sValue(token);
            if (Eval.this.isSyntaxCheck) {
                return this.addX(string);
            }
            String string3 = tokenArray.length == 1 ? Token.sValue(tokenArray[0]) : (n == 2949123 ? "" : "\n");
            switch (n) {
                case 2949121: {
                    return this.addX(TextFormat.split((String)string, (String)string3));
                }
                case 0x2D0002: {
                    if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                        string = string.substring(0, string.length() - 1);
                    }
                    return this.addX(TextFormat.simpleReplace((String)string, (String)"\n", (String)string3));
                }
                case 2949123: {
                    if (string != null) {
                        return this.addX(TextFormat.trim((String)string, (String)string3));
                    }
                    String[] stringArray = (String[])token.value;
                    int n2 = stringArray.length;
                    while (--n2 >= 0) {
                        stringArray[n2] = TextFormat.trim((String)stringArray[n2], (String)string3);
                    }
                    return this.addX(stringArray);
                }
            }
            return this.addX("");
        }

        boolean evaluateList(int n, Token[] tokenArray) throws ScriptException {
            int n2;
            if (tokenArray.length != 1) {
                return false;
            }
            Token token = this.getX();
            Token token2 = tokenArray[0];
            if (token.tok != 6 && token.tok != 4) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            boolean bl = token2.tok != 6 && Token.sValue(token2).indexOf("\n") < 0;
            float f = bl ? Token.fValue(token2) : 0.0f;
            String[] stringArray = token.value instanceof String ? TextFormat.split((String)((String)token.value), (String)"\n") : (String[])token.value;
            float[] fArray = new float[stringArray.length];
            Parser.parseFloatArray((String[])stringArray, (float[])fArray);
            String[] stringArray2 = bl ? null : (token2.value instanceof String ? TextFormat.split((String)((String)token2.value), (String)"\n") : (String[])token2.value);
            float[] fArray2 = new float[bl ? stringArray.length : stringArray2.length];
            int n3 = Math.min(fArray.length, fArray2.length);
            if (bl) {
                n2 = n3;
                while (--n2 >= 0) {
                    fArray2[n2] = f;
                }
            } else {
                Parser.parseFloatArray((String[])stringArray2, (float[])fArray2);
            }
            switch (n) {
                case 2949124: {
                    n2 = n3;
                    while (--n2 >= 0) {
                        int n4 = n2;
                        fArray[n4] = fArray[n4] + fArray2[n2];
                    }
                    break;
                }
                case 2949125: {
                    n2 = n3;
                    while (--n2 >= 0) {
                        int n5 = n2;
                        fArray[n5] = fArray[n5] - fArray2[n2];
                    }
                    break;
                }
                case 2949126: {
                    n2 = n3;
                    while (--n2 >= 0) {
                        int n6 = n2;
                        fArray[n6] = fArray[n6] * fArray2[n2];
                    }
                    break;
                }
                case 2949127: {
                    n2 = n3;
                    while (--n2 >= 0) {
                        if (fArray2[n2] == 0.0f) {
                            fArray[n2] = Float.NaN;
                            continue;
                        }
                        int n7 = n2;
                        fArray[n7] = fArray[n7] / fArray2[n2];
                    }
                    break;
                }
            }
            n2 = n3;
            while (--n2 >= 0) {
                stringArray[n2] = "" + fArray[n2];
            }
            return this.addX(stringArray);
        }

        boolean evaluateLoad(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            return this.addX(Eval.this.viewer.getFileAsString(Token.sValue(tokenArray[0])));
        }

        boolean evaluateScript(Token[] tokenArray, boolean bl) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string = Token.sValue(tokenArray[0]);
            if (bl) {
                return this.addX(Eval.this.viewer.eval(string));
            }
            StringBuffer stringBuffer = new StringBuffer();
            Eval.this.runScript(string, stringBuffer);
            return this.addX(stringBuffer.toString());
        }

        boolean evaluateData(Token[] tokenArray) throws ScriptException {
            String string;
            if (tokenArray.length == 0 || tokenArray.length > 2) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string2 = Token.sValue(tokenArray[0]);
            String string3 = string = tokenArray.length == 2 ? Token.sValue(tokenArray[1]) : "";
            if (string2.indexOf("property_") == 0) {
                float[] fArray;
                float[] fArray2 = Viewer.getDataFloat(string2);
                if (fArray2 == null) {
                    return this.addX("");
                }
                float[] fArray3 = fArray = string.indexOf("property_") == 0 ? Viewer.getDataFloat(string) : null;
                if (fArray != null) {
                    int n = Math.min(fArray2.length, fArray.length);
                    while (--n >= 0) {
                        int n2 = n;
                        fArray2[n2] = fArray2[n2] + fArray[n];
                    }
                }
                return this.addX(Escape.escape((float[])fArray2));
            }
            if (tokenArray.length == 1) {
                Object[] objectArray = Viewer.getData(string2);
                return this.addX(objectArray == null ? "" : "" + objectArray[1]);
            }
            return this.addX(Eval.this.viewer.getData(string2, string));
        }

        boolean evaluateLabel(Token[] tokenArray) throws ScriptException {
            Token token = this.getX();
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            Token token2 = tokenArray[0];
            if (token.tok != 32839 || token2.tok != 4) {
                return false;
            }
            return this.addX(Eval.this.getBitsetIdent(Token.bsSelect(token), Token.sValue(token2), token.value, true));
        }

        boolean evaluateWithin(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length < 1) {
                return false;
            }
            Object object = tokenArray[0].value;
            String string = "" + object;
            BitSet bitSet = new BitSet();
            float f = 0.0f;
            boolean bl = false;
            if (object instanceof String) {
                bl = !Parser.isOneOf((String)string, (String)"element;site;group;chain;molecule;model");
            } else if (object instanceof Float) {
                f = Token.fValue(tokenArray[0]);
            } else {
                return false;
            }
            if (tokenArray.length == 3 && !Parser.isOneOf((String)(string = Token.sValue(tokenArray[1])), (String)"plane;hkl;coord")) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            Point3f point3f = null;
            Point4f point4f = null;
            int n = tokenArray.length - 1;
            if (tokenArray[n].value instanceof Point4f) {
                point4f = (Point4f)tokenArray[n].value;
            }
            if (tokenArray[n].value instanceof Point3f) {
                point3f = (Point3f)tokenArray[n].value;
            }
            if (point4f == null && point3f == null && !(tokenArray[n].value instanceof BitSet)) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            if (point4f != null) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, point4f));
            }
            if (point3f != null) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, point3f));
            }
            bitSet = Token.bsSelect(tokenArray[n]);
            if (object instanceof Float) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, bitSet));
            }
            if (bl) {
                return this.addX(Eval.this.viewer.getAtomsWithin("sequence", string, bitSet));
            }
            return this.addX(Eval.this.viewer.getAtomsWithin(string, bitSet));
        }

        boolean evaluateConnected(Token[] tokenArray) throws ScriptException {
            float f = -2.1474836E9f;
            float f2 = 2.1474836E9f;
            float f3 = 0.0f;
            float f4 = Float.MAX_VALUE;
            short s = -2;
            BitSet bitSet = null;
            BitSet bitSet2 = null;
            boolean bl = false;
            boolean bl2 = false;
            block5: for (int i = 0; i < tokenArray.length; ++i) {
                Token token = tokenArray[i];
                switch (token.tok) {
                    case 32839: {
                        bl2 = token.value instanceof Bond.BondSet;
                        if (bl2 && bitSet != null) {
                            return false;
                        }
                        if (bitSet == null) {
                            bitSet = Token.bsSelect(token);
                            continue block5;
                        }
                        if (bitSet2 == null) {
                            bitSet2 = Token.bsSelect(token);
                            continue block5;
                        }
                        return false;
                    }
                    case 4: {
                        s = JmolConstants.getBondOrderFromString(Token.sValue(token));
                        if (s != -1) continue block5;
                        return false;
                    }
                    case 3: {
                        bl = true;
                    }
                    default: {
                        int n = Token.iValue(token);
                        float f5 = Token.fValue(token);
                        if (f2 != 2.1474836E9f) {
                            return false;
                        }
                        if (f == -2.1474836E9f) {
                            f = Math.max(n, 1);
                            f3 = f5;
                            continue block5;
                        }
                        f2 = n;
                        f4 = f5;
                    }
                }
            }
            if (f == -2.1474836E9f) {
                f = 1.0f;
                f2 = 100.0f;
                f3 = 0.1f;
                f4 = 1.0E8f;
            } else if (f2 == 2.1474836E9f) {
                f2 = f;
                f4 = f3;
                f3 = 0.1f;
            }
            if (bitSet == null) {
                bitSet = BitSetUtil.setAll((int)Eval.this.viewer.getAtomCount());
            }
            if (bl && bitSet2 == null) {
                bitSet2 = bitSet;
            }
            if (bitSet2 != null) {
                BitSet bitSet3 = new BitSet();
                if (Eval.this.isSyntaxCheck) {
                    return this.addX(new Token(32839, new Bond.BondSet(bitSet3)));
                }
                Eval.this.viewer.makeConnections(f3, f4, s, 5, bitSet, bitSet2, bitSet3, bl2);
                return this.addX(new Token(32839, new Bond.BondSet(bitSet3, Eval.this.getAtomIndices(Eval.this.getAtomBitsetFromBonds(bitSet3)))));
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            return this.addX(Eval.this.viewer.getAtomsConnected(f, f2, s, bitSet));
        }

        boolean evaluateSubstructure(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            BitSet bitSet = new BitSet();
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            String string = Token.sValue(tokenArray[0]);
            if (string.length() == 0) {
                return false;
            }
            try {
                SmilesMatcherInterface smilesMatcherInterface = (SmilesMatcherInterface)Class.forName("org.jmol.smiles.PatternMatcher").newInstance();
                smilesMatcherInterface.setViewer(Eval.this.viewer);
                bitSet = smilesMatcherInterface.getSubstructureSet(string);
            }
            catch (Exception exception) {
                Eval.this.evalError(exception.getMessage());
            }
            return this.addX(bitSet);
        }

        boolean operate(int n) throws ScriptException {
            Token token = this.oStack[this.oPt--];
            Token token2 = this.getX();
            if (token.tok == 0x110020) {
                return token2.tok == 32839 ? this.addX(BitSetUtil.invertInPlace((BitSet)Token.bsSelect(token2), (int)Eval.this.viewer.getAtomCount())) : this.addX(!Token.bValue(token2));
            }
            int n2 = token.intValue & 0xFFFFFF3F;
            if (token.tok == 1114185) {
                if (n2 == 851975) {
                    return this.addX(Token.sizeOf(token2));
                }
                if (n2 == 851974) {
                    if (token2.tok != 4) {
                        return false;
                    }
                    String string = (String)token2.value;
                    string = TextFormat.simpleReplace((String)string, (String)"\n\r", (String)"\n");
                    string = TextFormat.simpleReplace((String)string, (String)"\r", (String)"\n");
                    return this.addX(TextFormat.split((String)string, (char)'\n'));
                }
                if (n2 == 881923 && token2.tok == 4) {
                    Point3f point3f = new Point3f();
                    return this.addX(Graphics3D.colorPointFromString((String)Token.sValue(token2), (Point3f)point3f));
                }
                if (token2.tok == 7) {
                    switch (token.intValue) {
                        case 327712: {
                            return this.addX(((Point3f)token2.value).x);
                        }
                        case 327713: {
                            return this.addX(((Point3f)token2.value).y);
                        }
                        case 327714: {
                            return this.addX(((Point3f)token2.value).z);
                        }
                        case 327715: 
                        case 327716: 
                        case 327717: {
                            Point3f point3f = new Point3f((Point3f)token2.value);
                            Eval.this.viewer.toFractional(point3f);
                            return this.addX(token.intValue == 327715 ? point3f.x : (token.intValue == 327716 ? point3f.y : point3f.z));
                        }
                    }
                }
                if (token2.tok != 32839) {
                    return false;
                }
                if (token.intValue == 860162 && token2.value instanceof Bond.BondSet) {
                    return this.addX(token2);
                }
                Object object = Eval.this.getBitsetProperty(Token.bsSelect(token2), token.intValue, null, null, token2.value, token.value, false);
                if (token.intValue == 860162) {
                    return this.addX(new Token(32839, new Bond.BondSet((BitSet)object, Eval.this.getAtomIndices(Token.bsSelect(token2)))));
                }
                return this.addX(object);
            }
            Token token3 = this.getX();
            switch (token.tok) {
                case 0x110018: {
                    if (token3.tok == 32839 && token2.tok == 32839) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.and(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    return this.addX(Token.bValue(token3) && Token.bValue(token2));
                }
                case 0x110010: {
                    if (token3.tok == 32839 && token2.tok == 32839) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.or(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    return this.addX(Token.bValue(token3) || Token.bValue(token2));
                }
                case 0x110011: {
                    if (token3.tok == 32839 && token2.tok == 32839) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.xor(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    return this.addX(Token.bValue(token3) || Token.bValue(token2));
                }
                case 0x110012: {
                    if (token3.tok != 32839 || token2.tok != 32839) {
                        return false;
                    }
                    return this.addX(BitSetUtil.toggleInPlace((BitSet)Token.bsSelect(token3), (BitSet)Token.bsSelect(token2), (int)Eval.this.viewer.getAtomCount()));
                }
                case 5308458: {
                    return this.addX(Token.fValue(token3) <= Token.fValue(token2));
                }
                case 5308457: {
                    return this.addX(Token.fValue(token3) >= Token.fValue(token2));
                }
                case 5308456: {
                    return this.addX(Token.fValue(token3) > Token.fValue(token2));
                }
                case 5308459: {
                    return this.addX(Token.fValue(token3) < Token.fValue(token2));
                }
                case 5308460: {
                    if (token3.tok == 4 && token2.tok == 4) {
                        return this.addX(Token.sValue(token3).equalsIgnoreCase(Token.sValue(token2)));
                    }
                    return this.addX(Token.fValue(token3) == Token.fValue(token2));
                }
                case 5308461: {
                    if (token3.tok == 4 && token2.tok == 4) {
                        return this.addX(!Token.sValue(token3).equalsIgnoreCase(Token.sValue(token2)));
                    }
                    return this.addX(Token.fValue(token3) != Token.fValue(token2));
                }
                case 0x110031: {
                    if (token3.tok == 6 && (token2.tok == 6 || token2.tok == 4)) {
                        return this.addX(Token.concatList(token3, token2, true, token2.tok == 6));
                    }
                    if (token3.tok == 4 || token3.tok == 6) {
                        if (token2.tok == 6) {
                            return this.addX(Token.concatList(token3, token2, false, true));
                        }
                        return this.addX(Token.sValue(token3) + Token.sValue(token2));
                    }
                    if (token3.tok == 2 && token2.tok != 3) {
                        return this.addX(token3.intValue + Token.iValue(token2));
                    }
                    if (token3.tok == 7) {
                        Point3f point3f = new Point3f((Point3f)token3.value);
                        switch (token2.tok) {
                            case 7: {
                                point3f.add((Tuple3f)((Point3f)token2.value));
                                return this.addX(point3f);
                            }
                        }
                        float f = Token.fValue(token2);
                        return this.addX(new Point3f(point3f.x + f, point3f.y + f, point3f.z + f));
                    }
                    return this.addX(Token.fValue(token3) + Token.fValue(token2));
                }
                case 0x110030: {
                    if (token3.tok == 2) {
                        return this.addX(token3.intValue - Token.iValue(token2));
                    }
                }
                case 0x110040: {
                    if (token3.tok == 2 && token2.tok == 2) {
                        return this.addX(token3.intValue - Token.iValue(token2));
                    }
                    if (token3.tok == 7) {
                        Point3f point3f = new Point3f((Point3f)token3.value);
                        switch (token2.tok) {
                            case 7: {
                                point3f.sub((Tuple3f)((Point3f)token2.value));
                                return this.addX(point3f);
                            }
                        }
                        float f = Token.fValue(token2);
                        return this.addX(new Point3f(point3f.x - f, point3f.y - f, point3f.z - f));
                    }
                    return this.addX(Token.fValue(token3) - Token.fValue(token2));
                }
                case 1114169: {
                    if (token3.tok == 2 && token2.tok != 3) {
                        return this.addX(token3.intValue * Token.iValue(token2));
                    }
                    if (token3.tok == 7) {
                        Point3f point3f = new Point3f((Point3f)token3.value);
                        switch (token2.tok) {
                            case 7: {
                                Point3f point3f2 = (Point3f)token2.value;
                                return this.addX(point3f.x * point3f2.x + point3f.y * point3f2.y + point3f.z * point3f2.z);
                            }
                        }
                        float f = Token.fValue(token2);
                        return this.addX(new Point3f(point3f.x * f, point3f.y * f, point3f.z * f));
                    }
                    return this.addX(Token.fValue(token3) * Token.fValue(token2));
                }
                case 1114170: {
                    String string = null;
                    int n3 = Token.iValue(token2);
                    switch (token3.tok) {
                        case 2: 
                        case 32768: 
                        case 32769: {
                            if (n3 == 0) {
                                return this.addX(0);
                            }
                            return this.addX(Token.iValue(token3) % n3);
                        }
                        case 3: {
                            float f = Token.fValue(token3);
                            if (n3 == 0) {
                                return this.addX((int)(f + 0.5f * (float)(f < 0.0f ? -1 : 1)));
                            }
                            string = TextFormat.formatDecimal((float)f, (int)n3);
                            return this.addX(string);
                        }
                        case 4: {
                            string = (String)token3.value;
                            if (n3 == 0) {
                                return this.addX(TextFormat.trim((String)string, (String)"\n\t "));
                            }
                            if (n3 > 0) {
                                return this.addX(TextFormat.format((String)string, (int)n3, (int)n3, (boolean)true, (boolean)false));
                            }
                            return this.addX(TextFormat.format((String)string, (int)(-n3), (int)n3, (boolean)false, (boolean)false));
                        }
                        case 6: {
                            String[] stringArray = (String[])token3.value;
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray[i] = n3 == 0 ? stringArray[i].trim() : (n3 > 0 ? TextFormat.format((String)stringArray[i], (int)n3, (int)n3, (boolean)true, (boolean)false) : TextFormat.format((String)string, (int)(-n3), (int)n3, (boolean)false, (boolean)false));
                            }
                            return this.addX(stringArray);
                        }
                        case 7: {
                            Point3f point3f = new Point3f((Point3f)token3.value);
                            Eval.this.viewer.toUnitCell(point3f, new Point3f((float)n3, (float)n3, (float)n3));
                            return this.addX(point3f);
                        }
                        case 32839: {
                            return this.addX(Token.bsSelect(token3, n3));
                        }
                    }
                }
                case 1114168: {
                    if (token3.tok == 2 && token2.tok == 2 && token2.intValue != 0) {
                        return this.addX(token3.intValue / token2.intValue);
                    }
                    if (token3.tok == 7) {
                        Point3f point3f = new Point3f((Point3f)token3.value);
                        float f = Token.fValue(token2);
                        if (f == 0.0f) {
                            return this.addX(new Point3f(Float.NaN, Float.NaN, Float.NaN));
                        }
                        return this.addX(new Point3f(point3f.x / f, point3f.y / f, point3f.z / f));
                    }
                    float f = Token.fValue(token3);
                    float f2 = Token.fValue(token2);
                    if (f2 == 0.0f) {
                        return this.addX(f == 0.0f ? 0.0f : (f < 0.0f ? Float.POSITIVE_INFINITY : Float.POSITIVE_INFINITY));
                    }
                    return this.addX(f / f2);
                }
            }
            return true;
        }

        Point3f ptValue(Token token) throws ScriptException {
            if (Eval.this.isSyntaxCheck) {
                return new Point3f();
            }
            switch (token.tok) {
                case 7: {
                    return (Point3f)token.value;
                }
                case 32839: {
                    return (Point3f)Eval.this.getBitsetProperty(Token.bsSelect(token), 851976, null, null, token.value, null, false);
                }
            }
            float f = Token.fValue(token);
            return new Point3f(f, f, f);
        }

        Point4f planeValue(Token token) {
            if (Eval.this.isSyntaxCheck) {
                return new Point4f();
            }
            switch (token.tok) {
                case 8: {
                    return (Point4f)token.value;
                }
            }
            return null;
        }

        void stackOverflow() throws ScriptException {
            Eval.this.evalError(GT._((String)"too many parentheses"));
        }
    }

    class ScriptException
    extends Exception {
        String message;

        ScriptException(String string) {
            this.message = (string == null ? "" : string) + Eval.this.contextTrace();
            if (!Eval.this.isSyntaxCheck) {
                Logger.error((String)("eval ERROR: " + this.toString()));
            }
        }

        public String toString() {
            return this.message;
        }
    }

    static class Context {
        String filename;
        String script;
        short[] linenumbers;
        int[] lineIndices;
        Token[][] aatoken;
        Token[] statement;
        int statementLength;
        int pc;
        int pcEnd = Integer.MAX_VALUE;
        int lineEnd = Integer.MAX_VALUE;
        int iToken;
        int[] ifs;
        StringBuffer outputBuffer;

        Context() {
        }
    }
}

