# The LearningOnline Network
# Preferences
#
# $Id: lonpreferences.pm,v 1.125 2008/07/18 12:36:11 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# This package uses the "londes.js" javascript code. 
#
# TODOs that have to be completed:
#    interface with lonnet to change the password
 
package Apache::lonpreferences;

use strict;
use LONCAPA;
use Apache::Constants qw(:common);
use Apache::File;
use Crypt::DES;
use DynaLoader; # for Crypt::DES version
use Apache::loncommon();
use Apache::lonhtmlcommon();
use Apache::lonlocal;
use Apache::lonnet;
use LONCAPA();

#
# Write lonnet::passwd to do the call below.
# Use:
#   my $answer=reply("encrypt:passwd:$udom:$uname:$upass",$tryserver);
#
##################################################
#          password associated functions         #
##################################################
sub des_keys {
    # Make a new key for DES encryption.
    # Each key has two parts which are returned separately.
    # Please note:  Each key must be passed through the &hex function
    # before it is output to the web browser.  The hex versions cannot
    # be used to decrypt.
    my @hexstr=('0','1','2','3','4','5','6','7',
                '8','9','a','b','c','d','e','f');
    my $lkey='';
    for (0..7) {
        $lkey.=$hexstr[rand(15)];
    }
    my $ukey='';
    for (0..7) {
        $ukey.=$hexstr[rand(15)];
    }
    return ($lkey,$ukey);
}

sub des_decrypt {
    my ($key,$cyphertext) = @_;
    my $keybin=pack("H16",$key);
    my $cypher;
    if ($Crypt::DES::VERSION>=2.03) {
        $cypher=new Crypt::DES $keybin;
    } else {
        $cypher=new DES $keybin;
    }
    my $plaintext=
	$cypher->decrypt(unpack("a8",pack("H16",substr($cyphertext,0,16))));
    $plaintext.=
	$cypher->decrypt(unpack("a8",pack("H16",substr($cyphertext,16,16))));
    $plaintext=substr($plaintext,1,ord(substr($plaintext,0,1)) );
    return $plaintext;
}

################################################################
#                       Handler subroutines                    #
################################################################

################################################################
#         Language Change Subroutines                          #
################################################################

sub wysiwygchanger {
    my $r = shift;
    my %userenv = &Apache::lonnet::get
        ('environment',['wysiwygeditor']);
    my $onselect='checked="checked"';
    my $offselect='';
    if ($userenv{'wysiwygeditor'} eq 'on') {
	$onselect='';
	$offselect='checked="checked"';
    }
    my $switchoff=&mt('Disable WYSIWYG editor');
    my $switchon=&mt('Enable WYSIWYG editor');
    my $warning='';
    if ($env{'user.adv'}) {
       $warning.="<p>".&mt("The WYSIWYG editor only supports simple HTML and is in many cases unsuited for advanced authoring. In a number of cases, it may destroy advanced authoring involving LaTeX and script function calls.")."</p>";
    }
    $r->print(<<ENDLSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="set_wysiwyg" />
$warning
<br />
<label><input type="radio" name="wysiwyg" value="off" $onselect /> $switchoff</label><br />
<label><input type="radio" name="wysiwyg" value="on" $offselect /> $switchon</label>
ENDLSCREEN
    $r->print('<br /><input type="submit" value="'.&mt('Change').'" />');
}


sub verify_and_change_wysiwyg {
    my $r = shift;
    my $newsetting=$env{'form.wysiwyg'};
    &Apache::lonnet::put('environment',{'wysiwygeditor' => $newsetting});
    &Apache::lonnet::appenv({'environment.wysiwygeditor' => $newsetting});
    $r->print('<p>'.&mt('Setting WYSIWYG editor to:').' '.&mt($newsetting).'</p>');
}

################################################################
#         Language Change Subroutines                          #
################################################################
sub languagechanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['languages']);
    my $language=$userenv{'languages'};

    my $pref=&mt('Preferred language');
    my %langchoices=('' => 'No language preference');
    foreach (&Apache::loncommon::languageids()) {
	if (&Apache::loncommon::supportedlanguagecode($_)) {
	    $langchoices{&Apache::loncommon::supportedlanguagecode($_)}
	               = &Apache::loncommon::plainlanguagedescription($_);
	}
    }
    my $selectionbox=&Apache::loncommon::select_form($language,'language',
						     %langchoices);
    $r->print(<<ENDLSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_languages" />
<br />$pref: $selectionbox
ENDLSCREEN
    $r->print('<br /><input type="submit" value="'.&mt('Change').'" />');
}


sub verify_and_change_languages {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
# Screenname
    my $newlanguage  = $env{'form.language'};
    $newlanguage=~s/[^\-\w]//g;
    my $message='';
    if ($newlanguage) {
        &Apache::lonnet::put('environment',{'languages' => $newlanguage});
        &Apache::lonnet::appenv({'environment.languages' => $newlanguage});
        $message=&mt('Set new preferred languages to ').'<tt>"'.$newlanguage.'"</tt>.';
    } else {
        &Apache::lonnet::del('environment',['languages']);
        &Apache::lonnet::delenv('environment\.languages');
        $message=&mt('Reset preferred language.');
    }
    $r->print(<<ENDVCSCREEN);
$message
ENDVCSCREEN
}

################################################################
#         Tex Engine Change Subroutines                        #
################################################################
sub texenginechanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get('environment',['texengine']);
    my $texengine=$userenv{'texengine'};

    my %mathchoices=('' => 'Default',
		     'tth' => 'tth (TeX to HTML)',
		     #'ttm' => 'TeX to MathML',
		     'jsMath' => 'jsMath',
		     'mimetex' => 'mimetex (Convert to Images)'
                     );
    my $selectionbox=&Apache::loncommon::select_form($texengine,'texengine',
						     %mathchoices);
    my $jsMath_start=&Apache::lontexconvert::jsMath_header();
    my %lt=&Apache::lonlocal::texthash(
      'headline' => 'Change Math Preferences',
      'preftxt'  => 'Preferred method to display Math',
      'change'   => 'Change',
      'exmpl'    => 'Examples',
      'jsmath'   => 'jsMath:',
      'tth'      => 'tth (TeX to HTML):',
      'mimetex'  => 'mimetex (Convert to Images):',
    );

    $r->print(<<ENDLSCREEN);
<h2>$lt{'headline'}</h2>
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_texengine" />
<p>
$lt{'preftxt'}:<br />
$selectionbox <input type="submit" value="$lt{'change'}" />
</p>
</form>
<br />
<hr />
$lt{'exmpl'}

<h3>$lt{'jsmath'}</h3> 
<p>
$jsMath_start
<script type="text/javascript">
if (jsMath.nofonts == 1) {
    document.writeln
        ('<div style="padding: 10; border-style: solid; border-width:3;'
	 +' border-color: #DD0000; background-color: #FFF8F8; width: 75%; text-align: left">'
	 +'<small><font color="#AA0000"><b>Warning:</b> '
	 +'It looks like you don\\\'t have the TeX math fonts installed. '
	 +'The jsMath example on this page may not look right without them. '
	 +'The <a href="http://www.math.union.edu/locate/jsMath/" target="_blank"> '
	 +'jsMath Home Page</a> has information on how to download the '
	 +'needed fonts.  In the meantime, jsMath will do the best it can '
	 +'with the fonts you have, but it may not be pretty and some equations '
	 +'may not be rendered correctly. '
	 +'</font></small></div>');
}
</script>
<iframe src="/res/adm/pages/math_example.tex?inhibitmenu=yes&texengine=jsMath" width="400" height="120"></iframe>
</p>

<h3>$lt{'mimetex'}</h3>
<p>
<iframe src="/res/adm/pages/math_example.tex?inhibitmenu=yes&texengine=mimetex" width="400" height="100"></iframe>
</p>

<h3>$lt{'tth'}</h3>
<p>
<iframe src="/res/adm/pages/math_example.tex?inhibitmenu=yes&texengine=tth" width="400" height="200"></iframe>
</p>
ENDLSCREEN
    if ($env{'environment.texengine'} ne 'jsMath') {
	$r->print('<script type="text/javascript">jsMath.Process()</script>');
    }
}


sub verify_and_change_texengine {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
# Screenname
    my $newtexengine  = $env{'form.texengine'};
    $newtexengine=~s/[^\-\w]//g;
    if ($newtexengine eq 'ttm') {
	&Apache::lonnet::appenv({'browser.mathml' => 1});
    } else {
	if ($env{'environment.texengine'} eq 'ttm') {
	    &Apache::lonnet::appenv({'browser.mathml' => 0});
	}
    }
    my $message='';
    if ($newtexengine) {
        &Apache::lonnet::put('environment',{'texengine' => $newtexengine});
        &Apache::lonnet::appenv({'environment.texengine' => $newtexengine});
        $message=&mt('Set new preferred math display to ').'<tt>"'.$newtexengine.'"</tt>.';
    } else {
        &Apache::lonnet::del('environment',['texengine']);
        &Apache::lonnet::delenv('environment\.texengine');
        $message=&mt('Reset preferred math display.');
    }


    $r->print(<<ENDVCSCREEN);
$message
ENDVCSCREEN
}

################################################################
#         Roles Page Preference Change Subroutines         #
################################################################
sub rolesprefchanger {
    my $r = shift;
    my $role    = ($env{'user.adv'} ? 'Role' : 'Course');
    my $lc_role = ($env{'user.adv'} ? 'role' : 'course');
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['recentroles','recentrolesn']);
    my $hotlist_flag=$userenv{'recentroles'};
    my $hotlist_n=$userenv{'recentrolesn'};
    my $checked;
    if ($hotlist_flag) {
	$checked = 'checked="checked"';
    }
    
    if (!$hotlist_n) { $hotlist_n=3; }
    my $options;
    for (my $i=1; $i<10; $i++) {
	my $select;
	if ($hotlist_n == $i) { $select = 'selected="selected"'; }
	$options .= "<option $select>$i</option>\n";
    }

# Get list of recent roles and display with checkbox in front
    my $roles_check_list = '';
    my $role_key='';
    if ($env{'environment.recentroles'}) {
        my %recent_roles =
               &Apache::lonhtmlcommon::get_recent('roles',$env{'environment.recentrolesn'});
        my %frozen_roles =
               &Apache::lonhtmlcommon::get_recent_frozen('roles',$env{'environment.recentrolesn'});
        
        my %role_text = &rolespref_get_role_text([keys(%recent_roles)]);
        my @sorted_roles = sort {$role_text{$a} cmp $role_text{$b}} keys(%role_text);

        $roles_check_list .=
	    &Apache::loncommon::start_data_table().
	    &Apache::loncommon::start_data_table_header_row().
	    "<th>".&mt('Freeze '.$role)."</th>".
	    "<th>".&mt($role)."</td>".
	    &Apache::loncommon::end_data_table_header_row().
	    "\n";
	my $count;
        foreach $role_key (@sorted_roles) {
            my $checked = "";
            my $value = $recent_roles{$role_key};
            if ($frozen_roles{$role_key}) {
                $checked = "checked=\"checked\"";
            }
	    $count++;
            $roles_check_list .=
		&Apache::loncommon::start_data_table_row().
		'<td class="LC_table_cell_checkbox">'.
		"<input type=\"checkbox\" $checked name=\"freezeroles\"".
		" id=\"freezeroles$count\" value=\"$role_key\" /></td>".
		"<td><label for=\"freezeroles$count\">".
		"$role_text{$role_key}</label></td>".
		&Apache::loncommon::end_data_table_row(). "\n";
        }
        $roles_check_list .= "</table>\n";
    }

    $r->print('
<p>'.&mt('Some LON-CAPA users have a long list of '.$lc_role.'s. The Recent '.$role.'s Hotlist feature keeps track of the last N '.$lc_role.'s which have been visited and places a table of these at the top of the '.$lc_role.'s page. People with very few '.$lc_role.'s should leave this feature disabled.').'
</p>
<form name="prefs" action="/adm/preferences" method="POST">
<input type="hidden" name="action" value="verify_and_change_rolespref" />
<br /><label>'.&mt('Enable Recent '.$role.'s Hotlist:').'
<input type="checkbox" '.$checked.' name="recentroles" value="true" /></label>
<br />'.&mt('Number of '.$role.'s in Hotlist:').'
<select name="recentrolesn" size="1">
'.$options.'
</select>
<p>'.&mt('This list below can be used to <q>freeze</q> '.$lc_role.'s on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.').'
</p>
'.$roles_check_list.'
<br />
<input type="submit" value="'.&mt('Change').'" />
</form>');
}

sub rolespref_get_role_text {
# Get a line of text for each role
    my ($roles) = @_;
    my %roletext = ();

    foreach my $item (@$roles) {
# get course information
        my ($role,$rest) = split(/\./, $item);
        my $trole = "";
        $trole = &Apache::lonnet::plaintext($role);
        my ($tdomain,$other,$tsection)= split(/\//,Apache::lonnet::declutter($rest));
        my $tother = '-';
        if ($role =~ /^(cc|st|in|ta|ep|cr)/ ) {
            my %newhash=&Apache::lonnet::coursedescription($tdomain."_".$other);
            $tother = " - ".$newhash{'description'};
        } elsif ($role =~ /dc/) {
            $tother = "";
        } else {
            $tother = " - $other";
        }
 
        my $section="";
        if ($tsection) {
            $section = " - Section/Group: $tsection";
        }
        $roletext{$item} = $tdomain." - ".$trole.$tother.$section;
    }
    return %roletext;
}

sub verify_and_change_rolespref {
    my $r = shift;
    my $role = ($env{'user.adv'} ? 'Role' : 'Course');
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
# Recent Roles Hotlist Flag
    my $hotlist_flag  = $env{'form.recentroles'};
    my $hotlist_n  = $env{'form.recentrolesn'};
    my $message='<hr />';
    if ($hotlist_flag) {
        &Apache::lonnet::put('environment',{'recentroles' => $hotlist_flag});
        &Apache::lonnet::appenv({'environment.recentroles' => $hotlist_flag});
        $message=&mt('Recent '.$role.'s Hotlist is Enabled');
    } else {
        &Apache::lonnet::del('environment',['recentroles']);
        &Apache::lonnet::delenv('environment\.recentroles');
        $message=&mt('Recent '.$role.'s Hotlist is Disabled');
    }
    if ($hotlist_n) {
        &Apache::lonnet::put('environment',{'recentrolesn' => $hotlist_n});
        &Apache::lonnet::appenv({'environment.recentrolesn' => $hotlist_n});
        if ($hotlist_flag) {
            $message.="<br />".
		&mt('Display [_1] Most Recent '.$role.'s',$hotlist_n)."\n";
        }
    }

# Get list of froze roles and list of recent roles
    my @freeze_list = &Apache::loncommon::get_env_multiple('form.freezeroles');
    my %freeze = ();
    my %roletext = ();

    foreach my $key (@freeze_list) {
        $freeze{$key}='1';
    }

    my %recent_roles =
        &Apache::lonhtmlcommon::get_recent('roles',$env{'environment.recentrolesn'});
    my %frozen_roles =
        &Apache::lonhtmlcommon::get_recent_frozen('roles',$env{'environment.recentrolesn'});
    my %role_text = &rolespref_get_role_text([keys(%recent_roles)]);

# Unset any roles that were previously frozen but aren't in list
    foreach my $role_key (sort(keys(%recent_roles))) {
        if (($frozen_roles{$role_key}) && (!exists($freeze{$role_key}))) {
	    $message .= "<br />".&mt('Unfreezing '.$role.': [_1]',$role_text{$role_key})."\n";
	    &Apache::lonhtmlcommon::store_recent('roles',$role_key,' ',0);
        }
    }

# Freeze selected roles
    foreach my $role_key (@freeze_list) {
        if (!$frozen_roles{$role_key}) {
             $message .= "<br />".&mt('Freezing '.$role.': [_1]',$role_text{$role_key})."\n";
             &Apache::lonhtmlcommon::store_recent('roles',
                                          $role_key,' ',1);
        }
    }
    $message .= "<hr /><br />\n";

    $r->print(<<ENDRPSCREEN);
$message
ENDRPSCREEN
}



################################################################
#         Anonymous Discussion Name Change Subroutines         #
################################################################
sub screennamechanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['screenname','nickname']);
    my $screenname=$userenv{'screenname'};
    my $nickname=$userenv{'nickname'};
    my %lt = &Apache::lonlocal::texthash(
                                          text_screenname  => 'New screenname (shown if you post anonymously):',
                                          text_nickname  => 'New nickname (shown if you post non-anonymously):',
                                          text_submit => 'Change',
                                        );
    $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_screenname" />
<br />$lt{'text_screenname'}
<input type="text" size="20" value="$screenname" name="screenname" />
<br />$lt{'text_nickname'}
<input type="text" size="20" value="$nickname" name="nickname" />
<br />
<input type="submit" value="$lt{'text_submit'}" />
</form>
ENDSCREEN
}

sub verify_and_change_screenname {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
# Screenname
    my $newscreen  = $env{'form.screenname'};
    $newscreen=~s/[^ \w]//g;
    my $message='';
    if ($newscreen) {
        &Apache::lonnet::put('environment',{'screenname' => $newscreen});
        &Apache::lonnet::appenv({'environment.screenname' => $newscreen});
        $message=&mt('Set new screenname to ').'<tt>"'.$newscreen.'."</tt>.';
    } else {
        &Apache::lonnet::del('environment',['screenname']);
        &Apache::lonnet::delenv('environment\.screenname');
        $message=&mt('Reset screenname.');
    }
# Nickname
    $message.='<br />';
    $newscreen  = $env{'form.nickname'};
    $newscreen=~s/[^ \w]//g;
    if ($newscreen) {
        &Apache::lonnet::put('environment',{'nickname' => $newscreen});
        &Apache::lonnet::appenv({'environment.nickname' => $newscreen});
        $message.=&mt('Set new nickname to ').'<tt>"'.$newscreen.'"</tt>.';
    } else {
        &Apache::lonnet::del('environment',['nickname']);
        &Apache::lonnet::delenv('environment\.nickname');
        $message.=&mt('Reset nickname.');
    }
    &Apache::lonnet::devalidate_cache_new('namescache',$user.':'.$domain);
    $r->print(<<ENDVCSCREEN);
$message
ENDVCSCREEN
}

################################################################
#                     Icon Subroutines                         #
################################################################
sub iconchanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['icons']);
    my $iconic='checked="checked"';
    my $classic='';
    my $onlyicon='';
    if ($userenv{'icons'} eq 'classic') {
       $classic='checked="checked"';
       $iconic='';
    }
    if ($userenv{'icons'} eq 'iconsonly') {
       $onlyicon='checked="checked"';
       $iconic='';
    }
    my $useicons=&mt('Use icons and text');
    my $usebuttons=&mt('Use buttons and text');
    my $useicononly=&mt('Use icons only');
    my $change=&mt('Change');
    $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_icons" />
<label><input type="radio" name="menumode" value="iconic" $iconic /> $useicons</label><br />
<label><input type="radio" name="menumode" value="classic" $classic /> $usebuttons</label><br />
<label><input type="radio" name="menumode" value="iconsonly" $onlyicon /> $useicononly</label><br />
<input type="submit" value="$change" />
</form>
ENDSCREEN
}

sub verify_and_change_icons {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my $newicons  = $env{'form.menumode'};

    &Apache::lonnet::put('environment',{'icons' => $newicons});
    &Apache::lonnet::appenv({'environment.icons' => $newicons});
    $r->print(&mt('Set menu mode to [_1].',$newicons));
}

################################################################
#                     Clicker Subroutines                      #
################################################################

sub clickerchanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['clickers']);
    my $clickers=$userenv{'clickers'};
    $clickers=~s/\,/\n/gs;
    my $text=&mt('Enter response device ("clicker") numbers');
    my $change=&mt('Register');
    my $helplink=&Apache::loncommon::help_open_topic('Clicker_Registration',&mt('Locating your clicker ID'));
    $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_clicker" />
<label>$text $helplink<br />
<textarea name="clickers" rows="5" cols="20">$clickers</textarea>
</label>
<input type="submit" value="$change" />
</form>
ENDSCREEN
}

sub verify_and_change_clicker {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my $newclickers  = $env{'form.clickers'};
    $newclickers=~s/[^\w\:\-]+/\,/gs;
    $newclickers=~tr/a-z/A-Z/;
    $newclickers=~s/[\:\-]+/\-/g;
    $newclickers=~s/\,+/\,/g;
    $newclickers=~s/^\,//;
    $newclickers=~s/\,$//;
    &Apache::lonnet::put('environment',{'clickers' => $newclickers});
    &Apache::lonnet::appenv({'environment.clickers' => $newclickers});
    $r->print(&mt('Registering clickers: [_1]',$newclickers));
}

################################################################
#               Domcoord Access Subroutines                    #
################################################################

sub domcoordchanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['domcoord.author']);
    my $constchecked='';
    if ($userenv{'domcoord.author'} eq 'blocked') {
       $constchecked='checked="checked"';
    }
    my $text=&mt('By default, the Domain Coordinator can enter your construction space.');
    my $construction=&mt('Block access to construction space');
    my $change=&mt('Change');
    $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_domcoord" />
$text<br />
<label><input type="checkbox" name="construction" $constchecked />$construction</label><br />
<input type="submit" value="$change" />
</form>
ENDSCREEN
}

sub verify_and_change_domcoord {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %domcoord=('domcoord.author' => '');
    if ($env{'form.construction'}) { $domcoord{'domcoord.author'}='blocked'; }
    &Apache::lonnet::put('environment',\%domcoord);
    &Apache::lonnet::appenv({'environment.domcoord.author' => $domcoord{'domcoord.author'}});
    $r->print(&mt('Registering Domain Coordinator access restrictions.'));
}

#################################################################
##                      Lock Subroutines                        #
#################################################################

sub lockwarning {
    my $r = shift;
    my $title=&mt('Action locked');
    my $texttop=&mt('LON-CAPA is currently performing the following actions:');
    my $textbottom=&mt('Changing roles or logging out may result in data corruption.');
    my ($num,%which)=&Apache::lonnet::get_locks();
    my $which='';
    foreach my $id (keys %which) {
       $which.='<li>'.$which{$id}.'</li>';
    }
    my $change=&mt('Override');
    $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_locks" />
<h1>$title</h1>
$texttop
<ul>
$which
</ul>
$textbottom
<input type="submit" value="$change" />
</form>
ENDSCREEN
}

sub verify_and_change_lockwarning {
    my $r = shift;
    &Apache::lonnet::remove_all_locks();
    $r->print(&mt('Cleared locks.'));
}


################################################################
#         Message Forward                                      #
################################################################

sub msgforwardchanger {
    my ($r,$message) = @_;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get('environment',['msgforward','notification','critnotification','notifywithhtml']);
    my $msgforward=$userenv{'msgforward'};
    my %lt = &Apache::lonlocal::texthash(
                                          all   => 'All',
                                          crit  => 'Critical only',
                                          reg   => 'Non-critical only',
                                          foad  => 'Forwarding Address(es)',
                                          noti  => 'Notification E-mail Address(es)', 
                                          foad_exmpl => 'e.g. <tt>userA:domain1,userB:domain2,...</tt>',
                                          mnot  => 'Email Address(es) which should be notified about new LON-CAPA messages', # old: 'Message Notification Email Address(es)',
                                          mnot_exmpl => 'e.g. <tt>joe@doe.com</tt>',
                                          chg   => 'Change',
                                          email => 'The e-mail address entered in row ',
                                          notv => 'is not a valid e-mail address',
                                          toen => "To enter multiple addresses, enter one address at a time, click 'Change' and then add the next one", 
                                          prme => 'Back to preferences menu',
                                        );
    my $forwardingHelp = &Apache::loncommon::help_open_topic("Prefs_Forwarding");
    my $notificationHelp = &Apache::loncommon::help_open_topic("Prefs_Notification");
    my $criticalMessageHelp = &Apache::loncommon::help_open_topic("Course_Critical_Message");
    my @allow_html = split(/,/,$userenv{'notifywithhtml'});
    my %allnot = &get_notifications(\%userenv);
    my $validatescript = &Apache::lonhtmlcommon::javascript_valid_email();
    my $jscript = qq|
<script type="text/javascript">
function validate() {
    for (var i=0; i<document.prefs.numnotify.value; i++) {
        var checkaddress = 0;
        var addr = document.prefs.elements['address_'+i].value;
        var rownum = i+1;
        if (i < document.prefs.numnotify.value-1) {
            if (document.prefs.elements['modify_notify_'+i].checked) {
                checkaddress = 1;
            }
        } else {
            if (document.prefs.elements['add_notify_'+i].checked == true) { 
                checkaddress = 1;
            }
        }
        if (checkaddress == 1)  {
            var addr = document.prefs.elements['address_'+i].value;
            if (validmail(document.prefs.elements['address_'+i]) == false) {
                var multimsg = '';
                if (addr.indexOf(",") >= 0) {
                    multimsg = "\\n($lt{'toen'}).";
                }
                alert("$lt{'email'} "+rownum+" ('"+addr+"') $lt{'notv'}."+multimsg);
                return;
            }
        }
    }
    document.prefs.submit();
}

function address_changes (adnum) {
     if (!document.prefs.elements['del_notify_'+adnum].checked) { 
         document.prefs.elements['modify_notify_'+adnum].checked = true;
     }   
}

function new_address(adnum) {
     document.prefs.elements['add_notify_'+adnum].checked = true;
}

function delete_address(adnum) {
     if (document.prefs.elements['del_notify_'+adnum].checked) {
          document.prefs.elements['modify_notify_'+adnum].checked = false;
     }
}

function modify_address(adnum) {
    if (document.prefs.elements['modify_notify_'+adnum].checked) {
        document.prefs.elements['del_notify_'+adnum].checked = false;
    }
} 

$validatescript
</script>
|;
    $r->print(<<ENDMSG);
$jscript
$message
<h3>$lt{'foad'} $forwardingHelp</h3>
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_msgforward" />
$lt{'foad'} ($lt{'foad_exmpl'}):
<input type="text" size="40" value="$msgforward" name="msgforward" /><br />
<h3>$lt{'noti'} $notificationHelp</h3>
$lt{'mnot'} ($lt{'mnot_exmpl'}):<br />
ENDMSG
    my @sortforwards = sort (keys(%allnot));
    my $output = &Apache::loncommon::start_data_table().
                 &Apache::loncommon::start_data_table_header_row().
                 '<th>&nbsp;</th>'.
                 '<th>'.&mt('Action').'</th>'.
                 '<th>'.&mt('Notification address').'</th><th>'.
                 &mt('Types of message for which notification is sent').
                 $criticalMessageHelp.'</th><th>'.
                 &mt('Excerpt retains HTML tags in message').'</th>'.
                 &Apache::loncommon::end_data_table_header_row();
    my $num = 0;
    my $counter = 1;
    foreach my $item (@sortforwards) {
        $output .= &Apache::loncommon::start_data_table_row().
                   '<td><b>'.$counter.'</b></td>'.
                   '<td><span class="LC_nobreak"><label>'.
                   '<input type="checkbox" name="modify_notify_'.
                   $num.'" onclick="javscript:modify_address('."'$num'".')" />'.
                   &mt('Modify').'</label></span>&nbsp;&nbsp; '.
                   '<span class="LC_nobreak"><label>'.
                   '<input type="checkbox" name="del_notify_'.$num.
                   '" onclick="javscript:delete_address('."'$num'".')" />'.
                   &mt('Delete').'</label></span></td>'.
                   '<td><input type="text" value="'.$item.'" name="address_'.
                   $num.'" onFocus="javascript:address_changes('."'$num'".
                   ')" /></td><td>';
        my %chk;
        if (defined($allnot{$item}{'crit'})) {
            if (defined($allnot{$item}{'reg'})) {
                $chk{'all'} = 'checked="checked" ';
            } else {
                $chk{'crit'} = 'checked="checked" ';
            }
        } else {
            $chk{'reg'} = 'checked="checked" ';
        }
        foreach my $type ('all','crit','reg') {
            $output .= '<span class="LC_nobreak"><label>'.
                       '<input type="radio" name="notify_type_'.$num. 
                       '" value="'.$type.'" '.$chk{$type}.
                       ' onchange="javascript:address_changes('."'$num'".')" />'.
                       $lt{$type}.'</label></span>&nbsp;';
        }
        my $htmlon = '';
        my $htmloff = '';
        if (grep/^\Q$item\E/,@allow_html) {
            $htmlon = 'checked="checked" '; 
        } else {
            $htmloff = 'checked="checked" ';
        }
        $output .= '</td><td><label><input type="radio" name="html_'.$num.
                   '" value="1" '.$htmlon.
                   ' onchange="javascript:address_changes('."'$num'".')" />'.
                   &mt('Yes').'</label>&nbsp;'.
                   '<label><input type="radio" name="html_'.$num.'" value="0" '.
                   $htmloff. ' onchange="javascript:address_changes('."'$num'".
')" />'.
                   &mt('No').'</label></td>'.
                   &Apache::loncommon::end_data_table_row();
        $num ++;
        $counter ++;
    }
    my %defchk = (
                   all => 'checked="checked" ',
                   crit => '',
                   reg => '',
                 );
    $output .= &Apache::loncommon::start_data_table_row().
               '<td><b>'.$counter.'</b></td>'.
               '<td><span class="LC_nobreak"><label>'.
               '<input type="checkbox" name="add_notify_'.$num.
               '" value="1" />'.&mt('Add new address').'</label></span></td>'.
               '<td><input type="text" value="" name="address_'.$num.
               '" onFocus="javascript:new_address('."'$num'".')" /></td><td>';
    foreach my $type ('all','crit','reg') {
        $output .= '<span class="LC_nobreak"><label>'.
                   '<input type="radio" name="notify_type_'.$num.
                   '" value="'.$type.'" '.$defchk{$type}.'/>'.
                   $lt{$type}.'</label></span>&nbsp;';
    }
    $output .= '</td><td><label><input type="radio" name="html_'.$num.
               '" value="1" />'.&mt('Yes').'</label>&nbsp;'.
               '<label><input type="radio" name="html_'.$num.'" value="0" '.
               ' checked="checked" />'.
               &mt('No').'</label></td>'.
               &Apache::loncommon::end_data_table_row().
               &Apache::loncommon::end_data_table();
    $num ++;
    $r->print($output);
    $r->print(qq|
<br /><hr />
<input type="hidden" name="numnotify" value="$num" />
<input type="button" value="$lt{'chg'}" onclick="javascript:validate()" />
<input type="button" value="$lt{'prme'}" onclick="location.href='/adm/preferences'" />
</form>
|);

}

sub get_notifications {
    my ($userenv) = @_;
    my %allnot;
    my @critnot = split(/,/,$userenv->{'critnotification'});
    my @regnot = split(/,/,$userenv->{'notification'});
    foreach my $item (@critnot) {
        $allnot{$item}{crit} = 1;
    }
    foreach my $item (@regnot) {
        $allnot{$item}{reg} = 1;
    }
    return %allnot;
}

sub verify_and_change_msgforward {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my $newscreen  = '';
    my $message='';
    foreach (split(/\,/,$env{'form.msgforward'})) {
	my ($msuser,$msdomain)=split(/[\@\:]/,$_);
        $msuser = &LONCAPA::clean_username($msuser);
        $msdomain = &LONCAPA::clean_domain($msdomain);
        if (($msuser) && ($msdomain)) {
	    if (&Apache::lonnet::homeserver($msuser,$msdomain) ne 'no_host') {
               $newscreen.=$msuser.':'.$msdomain.',';
	   } else {
               $message.= &mt('No such user: ').'<tt>'.$msuser.':'.$msdomain.'</tt><br>';
           }
        }
    }
    $newscreen=~s/\,$//;
    if ($newscreen) {
        &Apache::lonnet::put('environment',{'msgforward' => $newscreen});
        &Apache::lonnet::appenv({'environment.msgforward' => $newscreen});
        $message .= &mt('Set message forwarding to ').'<tt>"'.$newscreen.'"</tt>.'
                    .'<br />';
    } else {
        &Apache::lonnet::del('environment',['msgforward']);
        &Apache::lonnet::delenv('environment\.msgforward');
        $message.= &mt("Set message forwarding to 'off'.").'<br />';
    }
    my $critnotification;
    my $notification;
    my $notify_with_html;
    my $lastnotify = $env{'form.numnotify'}-1;
    my $totaladdresses = 0;
    for (my $i=0; $i<$env{'form.numnotify'}; $i++) {
        if ((!defined($env{'form.del_notify_'.$i})) &&  
           ((($i==$lastnotify) && ($env{'form.add_notify_'.$lastnotify} == 1)) ||
            ($i<$lastnotify))) {
            if (defined($env{'form.address_'.$i})) {
                if ($env{'form.notify_type_'.$i} eq 'all') {
                    $critnotification .= $env{'form.address_'.$i}.',';
                    $notification .= $env{'form.address_'.$i}.',';
                } elsif ($env{'form.notify_type_'.$i} eq 'crit') {
                    $critnotification .= $env{'form.address_'.$i}.',';
                } elsif ($env{'form.notify_type_'.$i} eq 'reg') {
                    $notification .= $env{'form.address_'.$i}.','; 
                }
                if ($env{'form.html_'.$i} eq '1') {
		    $notify_with_html .= $env{'form.address_'.$i}.',';       	
                }
                $totaladdresses ++;
            }
        }
    }
    $critnotification =~ s/,$//;
    $critnotification=~s/\s//gs;
    $notification =~ s/,$//;
    $notification=~s/\s//gs;
    $notify_with_html =~ s/,$//;
    $notify_with_html =~ s/\s//gs;
    if ($notification) {
        &Apache::lonnet::put('environment',{'notification' => $notification});
        &Apache::lonnet::appenv({'environment.notification' => $notification});
        $message.=&mt('Set non-critical message notification address(es) to ').'<tt>"'.$notification.'"</tt>.<br />';
    } else {
        &Apache::lonnet::del('environment',['notification']);
        &Apache::lonnet::delenv('environment\.notification');
        $message.=&mt("Set non-critical message notification to 'off'.").'<br />';
    }
    if ($critnotification) {
        &Apache::lonnet::put('environment',{'critnotification' => $critnotification});
        &Apache::lonnet::appenv({'environment.critnotification' => $critnotification});
        $message.=&mt('Set critical message notification address(es) to ').'<tt>"'.$critnotification.'"</tt>.<br />';
    } else {
        &Apache::lonnet::del('environment',['critnotification']);
        &Apache::lonnet::delenv('environment\.critnotification');
        $message.=&mt("Set critical message notification to 'off'.").'<br />';
    }
    if ($critnotification || $notification) {
        if ($notify_with_html) {
            &Apache::lonnet::put('environment',{'notifywithhtml' => $notify_with_html});
            &Apache::lonnet::appenv({'environment.notifywithhtml' => $notify_with_html});
            $message.=&mt('Set address(es) to receive excerpts with html retained ').'<tt>"'.$notify_with_html.'"</tt>.';
        } else {
            &Apache::lonnet::del('environment',['notifywithhtml']);
            &Apache::lonnet::delenv('environment\.notifywithhtml');
            if ($totaladdresses == 1) {
                $message.=&mt("Set notification address to receive excerpts with html stripped.");
            } else {
                $message.=&mt("Set all notification addresses to receive excerpts with html stripped.");
            }
        }
    } else {
        &Apache::lonnet::del('environment',['notifywithhtml']);
        &Apache::lonnet::delenv('environment\.notifywithhtml');
    }
    if ($message) {
        $message .= '<br /><hr />';
    }
    &Apache::loncommon::flush_email_cache($user,$domain);
    &msgforwardchanger($r,$message);
}

################################################################
#         Colors                                               #
################################################################

sub colorschanger {
    my $r = shift;
# figure out colors
    my $function=&Apache::loncommon::get_users_function();
    my $domain=&Apache::loncommon::determinedomain();
    my %colortypes=('pgbg'  => 'Page Background',
                    'tabbg' => 'Header Background',
                    'sidebg'=> 'Header Border',
                    'font'  => 'Font',
                    'link'  => 'Un-Visited Link',
                    'vlink' => 'Visited Link',
                    'alink' => 'Active Link');
    my $start_data_table = &Apache::loncommon::start_data_table();
    my $chtable='';
    foreach my $item (sort(keys(%colortypes))) {
       my $curcol=&Apache::loncommon::designparm($function.'.'.$item,$domain);
       $chtable.=&Apache::loncommon::start_data_table_row().
	   '<td>'.$colortypes{$item}.'</td><td style="background: '.$curcol.
        '">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td><input name="'.$item.
        '" size="10" value="'.$curcol.
'" /></td><td><a href="javascript:pjump('."'color_custom','".$colortypes{$item}.
"','".$curcol."','"
	    .$item."','parmform.pres','psub'".');">Select</a></td>'.
	    &Apache::loncommon::end_data_table_row()."\n";
    }
    my $end_data_table = &Apache::loncommon::end_data_table();
    my $pjump_def = &Apache::lonhtmlcommon::pjump_javascript_definition();
    $r->print(<<ENDCOL);
<script type="text/javascript">

    function pclose() {
        parmwin=window.open("/adm/rat/empty.html","LONCAPAparms",
                 "height=350,width=350,scrollbars=no,menubar=no");
        parmwin.close();
    }

    $pjump_def

    function psub() {
        pclose();
        if (document.parmform.pres_marker.value!='') {
            if (document.parmform.pres_type.value!='') {
                eval('document.prefs.'+
                     document.parmform.pres_marker.value+
		     '.value=document.parmform.pres_value.value;');
	    }
        } else {
            document.parmform.pres_value.value='';
            document.parmform.pres_marker.value='';
        }
    }


</script>
<form name="parmform">
<input type="hidden" name="pres_marker" />
<input type="hidden" name="pres_type" />
<input type="hidden" name="pres_value" />
</form>
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_colors" />
$start_data_table
$chtable
$end_data_table
</table>
<input type="submit" value="Change Custom Colors" />
<input type="submit" name="resetall" value="Reset All Colors to Default" />
</form>
ENDCOL
}

sub verify_and_change_colors {
    my $r = shift;
# figure out colors
    my $function=&Apache::loncommon::get_users_function();
    my $domain=&Apache::loncommon::determinedomain();
    my %colortypes=('pgbg'  => 'Page Background',
                    'tabbg' => 'Header Background',
                    'sidebg'=> 'Header Border',
                    'font'  => 'Font',
                    'link'  => 'Un-Visited Link',
                    'vlink' => 'Visited Link',
                    'alink' => 'Active Link');

    my $message='';
    foreach my $item (keys %colortypes) {
        my $color=$env{'form.'.$item};
        my $entry='color.'.$function.'.'.$item;
	if (($color=~/^\#[0-9A-Fa-f]{6}$/) && (!$env{'form.resetall'})) {
	    &Apache::lonnet::put('environment',{$entry => $color});
	    &Apache::lonnet::appenv({'environment.'.$entry => $color});
	    $message.=&mt('Set '.$colortypes{$item}.' to ').'<tt>"'.$color.'"</tt>.<br />';
	} else {
	    &Apache::lonnet::del('environment',[$entry]);
	    &Apache::lonnet::delenv('environment\.'.$entry);
	    $message.=&mt('Reset '.$colortypes{$item}.'.').'<br />';
	}
    }
    my $now = time;
    &Apache::lonnet::put('environment',{'color.timestamp' => $now});
    &Apache::lonnet::appenv({'environment.color.timestamp' => $now});

    $r->print(<<ENDVCCOL);
$message
<form name="client" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="changecolors" />
</form>
ENDVCCOL
}

######################################################
#            password handler subroutines            #
######################################################
sub passwordchanger {
    my ($r,$errormessage,$caller,$mailtoken) = @_;
    # This function is a bit of a mess....
    # Passwords are encrypted using londes.js (DES encryption)
    $errormessage = ($errormessage || '');
    my ($user,$domain,$currentpass,$defdom);
    if ((!defined($caller)) || ($caller eq 'preferences')) {
        $user = $env{'user.name'};
        $domain = $env{'user.domain'};
        if (!defined($caller)) {
            $caller = 'preferences';
        }
    } elsif ($caller eq 'reset_by_email') {
            $defdom = $r->dir_config('lonDefDomain');
            my %data = &Apache::lonnet::tmpget($mailtoken);
            if (keys(%data) == 0) {
                $r->print(&mt('Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a <a href="/adm/resetpw">new request</a> for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.'));
                return;
            }
            if (defined($data{time})) {
                if (time - $data{'time'} < 7200) {
                    $user = $data{'username'};
                    $domain = $data{'domain'};
                    $currentpass = $data{'temppasswd'};
                } else {
                    $r->print(&mt('Sorry, the token generated when you requested a password reset has expired.').'<br />');
                    return;
                }
            } else {
                $r->print(&mt('Sorry, the URL generated when you requested reset of your password contained incomplete information.').'<br />');
                return;
            }
   } else {
        $r->print(&mt('Page requested in unexpected context').'<br />');
        return;
    }
    my $currentauth=&Apache::lonnet::queryauthenticate($user,$domain);
    # Check for authentication types that allow changing of the password.
    return if ($currentauth !~ /^(unix|internal):/);
    #
    # Generate keys
    my ($lkey_cpass ,$ukey_cpass ) = &des_keys();
    my ($lkey_npass1,$ukey_npass1) = &des_keys();
    my ($lkey_npass2,$ukey_npass2) = &des_keys();
    # Store the keys in the log files
    my $lonhost = $r->dir_config('lonHostID');
    my $logtoken=Apache::lonnet::reply('tmpput:'
				       .$ukey_cpass  . $lkey_cpass .'&'
				       .$ukey_npass1 . $lkey_npass1.'&'
				       .$ukey_npass2 . $lkey_npass2,
				       $lonhost);
    # Hexify the keys for output as javascript variables
    my %hexkey;
    $hexkey{'ukey_cpass'}  = hex($ukey_cpass);
    $hexkey{'lkey_cpass'}  = hex($lkey_cpass);
    $hexkey{'ukey_npass1'} = hex($ukey_npass1);
    $hexkey{'lkey_npass1'} = hex($lkey_npass1);
    $hexkey{'ukey_npass2'} = hex($ukey_npass2);
    $hexkey{'lkey_npass2'} = hex($lkey_npass2);
    # Output javascript to deal with passwords
    # Output DES javascript
    {
	my $include = $r->dir_config('lonIncludes');
	my $jsh=Apache::File->new($include."/londes.js");
	$r->print(<$jsh>);
    }
    $r->print(&jscript_send($caller));
    $r->print(<<ENDFORM);
$errormessage

<p>
<!-- We separate the forms into 'server' and 'client' in order to
     ensure that unencrypted passwords will not be sent out by a
     crappy browser -->
ENDFORM
    $r->print(&server_form($logtoken,$caller,$mailtoken));
    $r->print(&client_form($caller,\%hexkey,$currentpass,$defdom));

    #
    return;
}

sub jscript_send {
    my ($caller) = @_;
    my $output = qq|
<script language="JavaScript">

    function send() {
        uextkey=this.document.client.elements.ukey_cpass.value;
        lextkey=this.document.client.elements.lkey_cpass.value;
        initkeys();

        this.document.pserver.elements.currentpass.value
            =crypted(this.document.client.elements.currentpass.value);

        uextkey=this.document.client.elements.ukey_npass1.value;
        lextkey=this.document.client.elements.lkey_npass1.value;
        initkeys();
        this.document.pserver.elements.newpass_1.value
            =crypted(this.document.client.elements.newpass_1.value);

        uextkey=this.document.client.elements.ukey_npass2.value;
        lextkey=this.document.client.elements.lkey_npass2.value;
        initkeys();
        this.document.pserver.elements.newpass_2.value
            =crypted(this.document.client.elements.newpass_2.value);
|;
    if ($caller eq 'reset_by_email') {
        $output .= qq|
        this.document.pserver.elements.uname.value =
                   this.document.client.elements.uname.value;
        this.document.pserver.elements.udom.value =
                   this.document.client.elements.udom.options[this.document.client.elements.udom.selectedIndex].value;
|;
    }
    $ output .= qq|
        this.document.pserver.submit();
    }
</script>
|;
}

sub client_form {
    my ($caller,$hexkey,$currentpass,$defdom) = @_;
    my %lt=&Apache::lonlocal::texthash(
                'email' => 'E-mail Address',
                'username' => 'Username',
                'domain' => 'Domain',
                'currentpass' => 'Current Password',
                'newpass' => 'New Password',
                'confirmpass' => 'Confirm Password',
                'changepass' => 'Change Password');

    my $output = qq|
<form name="client" >
<table>
|;
    if ($caller eq 'reset_by_email') {
        $output .= qq|
<tr><td class="LC_preferences_labeltext"><label for="email">$lt{'email'}</label>:</td>
    <td><input type="text" name="email" size="30" /> </td></tr>
<tr><td class="LC_preferences_labeltext"><label for="uname">$lt{'username'}</label>:</td>
    <td>
     <input type="text" name="uname" size="15" />
     <input type="hidden" name="currentpass" value="$currentpass" />
    </td></tr>
<tr><td class="LC_preferences_labeltext"><label for="udom">$lt{'domain'}</label>:</td>
    <td>
|;
        $output .= &Apache::loncommon::select_dom_form($defdom,'udom').'
   </td>
</tr>
';
    } else {
        $output .= qq|
<tr><td class="LC_preferences_labeltext"><label for="currentpass">$lt{'currentpass'}</label></td>
    <td><input type="password" name="currentpass" size="10"/> </td></tr>
|;
    }
    $output .= <<"ENDFORM";
<tr><td class="LC_preferences_labeltext"><label for="newpass_1">$lt{'newpass'}</label></td>
    <td><input type="password" name="newpass_1" size="10"  /> </td></tr>
<tr><td class="LC_preferences_labeltext"><label for="newpass_2">$lt{'confirmpass'}</label></td>
    <td><input type="password" name="newpass_2" size="10"  /> </td></tr>
<tr><td colspan="2" align="center">
    <input type="button" value="$lt{'changepass'}" onClick="send();">
</table>
<input type="hidden" name="ukey_cpass"  value="$hexkey->{'ukey_cpass'}" />
<input type="hidden" name="lkey_cpass"  value="$hexkey->{'lkey_cpass'}" />
<input type="hidden" name="ukey_npass1" value="$hexkey->{'ukey_npass1'}" />
<input type="hidden" name="lkey_npass1" value="$hexkey->{'lkey_npass1'}" />
<input type="hidden" name="ukey_npass2" value="$hexkey->{'ukey_npass2'}" />
<input type="hidden" name="lkey_npass2" value="$hexkey->{'lkey_npass2'}" />
</form>
</p>
ENDFORM
    return $output;
}

sub server_form {
    my ($logtoken,$caller,$mailtoken) = @_;
    my $action = '/adm/preferences';
    if ($caller eq 'reset_by_email') {
        $action = '/adm/resetpw';
    }
    my $output = qq|
<form name="pserver" action="$action" method="post">
<input type="hidden" name="logtoken"    value="$logtoken" />
<input type="hidden" name="currentpass" value="" />
<input type="hidden" name="newpass_1"   value="" />
<input type="hidden" name="newpass_2"   value="" />
    |;
    if ($caller eq 'reset_by_email') {
        $output .=  qq|
<input type="hidden" name="token"   value="$mailtoken" />
<input type="hidden" name="uname"   value="" />
<input type="hidden" name="udom"   value="" />

|;
    }
    $output .= qq|
<input type="hidden" name="action" value="verify_and_change_pass" />
</form>
|;
    return $output;
}

sub verify_and_change_password {
    my ($r,$caller,$mailtoken) = @_;
    my ($user,$domain,$homeserver);
    if ($caller eq 'reset_by_email') {
        $user       = $env{'form.uname'};
        $domain     = $env{'form.udom'};
        if ($user ne '' && $domain ne '') {
            $homeserver = &Apache::lonnet::homeserver($user,$domain);
            if ($homeserver eq 'no_host') {
        &passwordchanger($r,"<p>\n<span class='LC_error'>".
                         &mt("Invalid username and/or domain")."</span>\n</p>",
                         $caller,$mailtoken);
                return 1;
            }
        } else {
            &passwordchanger($r,"<p>\n<span class='LC_error'>".
                             &mt("Username and domain were blank")."</span>\n</p>",
                             $caller,$mailtoken);
            return 1;
        }
    } else {
        $user       = $env{'user.name'};
        $domain     = $env{'user.domain'};
        $homeserver = $env{'user.home'};
    }
    my $currentauth=&Apache::lonnet::queryauthenticate($user,$domain);
    # Check for authentication types that allow changing of the password.
    if ($currentauth !~ /^(unix|internal):/) {
        if ($caller eq 'reset_by_email') {
            &passwordchanger($r,"<p>\n<span class='LC_error'>".
                             &mt("Authentication type for this user can not be changed by this mechanism").
                             "</span>\n</p>",
                              $caller,$mailtoken);
            return 1;
        } else {
            return;
        }
    }
    #
    my $currentpass = $env{'form.currentpass'}; 
    my $newpass1    = $env{'form.newpass_1'}; 
    my $newpass2    = $env{'form.newpass_2'};
    my $logtoken    = $env{'form.logtoken'};
    # Check for empty data 
    unless (defined($currentpass) && 
	    defined($newpass1)    && 
	    defined($newpass2)    ){
	&passwordchanger($r,"<p>\n<span class='LC_error'>".
			 &mt("One or more password fields were blank").
                         "</span>\n</p>",$caller,$mailtoken);
	return;
    }
    # Get the keys
    my $lonhost = $r->dir_config('lonHostID');
    my $tmpinfo = Apache::lonnet::reply('tmpget:'.$logtoken,$lonhost);
    if (($tmpinfo=~/^error/) || ($tmpinfo eq 'con_lost')) {
        # I do not a have a better idea about how to handle this
        my $tryagain_text = &mt('Please log out and try again.');
        if ($caller eq 'reset_by_email') {
            $tryagain_text = &mt('Please try again later.');
        }
        my $unable=&mt("Unable to retrieve saved token for password decryption");
	$r->print(<<ENDERROR);
<p>
<span class="LC_error">$unable.  $tryagain_text</span>
</p>
ENDERROR
        # Probably should log an error here
        return 1;
    }
    my ($ckey,$n1key,$n2key)=split(/&/,$tmpinfo);
    # 
    $currentpass = &des_decrypt($ckey ,$currentpass);
    $newpass1    = &des_decrypt($n1key,$newpass1);
    $newpass2    = &des_decrypt($n2key,$newpass2);
    #
    if ($caller eq 'reset_by_email') {
        my %data = &Apache::lonnet::tmpget($mailtoken);
        if (keys(%data) == 0) {
            &passwordchanger($r,
                         '<span class="LC_error">'.
                         &mt('Could not verify current authentication.').'  '.
                         &mt('Please try again.').'</span>',$caller,$mailtoken);
            return 1;
        }
        if ($currentpass ne $data{'temppasswd'}) {
            &passwordchanger($r,
                         '<span class="LC_error">'.
                         &mt('Could not verify current authentication.').'  '.
                         &mt('Please try again.').'</span>',$caller,$mailtoken);
            return 1;
        }
    } 
    if ($newpass1 ne $newpass2) {
	&passwordchanger($r,
			 '<span class="LC_error">'.
			 &mt('The new passwords you entered do not match.').'  '.
			 &mt('Please try again.').'</span>',$caller,$mailtoken);
	return 1;
    }
    if (length($newpass1) < 7) {
	&passwordchanger($r,
			 '<span class="LC_error">'.
			 &mt('Passwords must be a minimum of 7 characters long.').'  '.
			 &mt('Please try again.').'</span>',$caller,$mailtoken);
	return 1;
    }
    #
    # Check for bad characters
    my $badpassword = 0;
    foreach (split(//,$newpass1)) {
	$badpassword = 1 if ((ord($_)<32)||(ord($_)>126));
    }
    if ($badpassword) {
	# I can't figure out how to enter bad characters on my browser.
	my $errormessage ='<span class="LC_error">'.
           &mt('The password you entered contained illegal characters.').'<br />'.
           &mt('Valid characters are').(<<"ENDERROR");
: space and <br />
<pre>
!&quot;\#$%&amp;\'()*+,-./0123456789:;&lt;=&gt;?\@
ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_\`abcdefghijklmnopqrstuvwxyz{|}~
</pre></span>
ENDERROR
        &passwordchanger($r,$errormessage,$caller,$mailtoken);
        return 1;
    }
    # 
    # Change the password (finally)
    my $result = &Apache::lonnet::changepass
	($user,$domain,$currentpass,$newpass1,$homeserver,$caller);
    # Inform the user the password has (not?) been changed
    if ($result =~ /^ok$/) {
	$r->print("<h3>".&mt('The password for [_1] was successfully changed',$user)."</h3>");
    } else {
	# error error: run in circles, scream and shout
        $r->print("<h3><span class='LC_error'>".&mt("The password for [_1] was not changed",$user)."</span></h3>".
                  &mt('Please make sure your old password was entered correctly.'));
        return 1;
    }
    return;
}

################################################################
#            discussion display subroutines 
################################################################
sub discussionchanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['discdisplay','discmarkread']);
    my $discdisp = 'allposts';
    my $discmark = 'onmark';

    if (defined($userenv{'discdisplay'})) {
        unless ($userenv{'discdisplay'} eq '') { 
            $discdisp = $userenv{'discdisplay'};
        }
    }
    if (defined($userenv{'discmarkread'})) {
        unless ($userenv{'discdisplay'} eq '') { 
            $discmark = $userenv{'discmarkread'};
        }
    }

    my $newdisp = 'unread';
    my $newmark = 'ondisp';

    my $function = &Apache::loncommon::get_users_function();
    my $color = &Apache::loncommon::designparm($function.'.tabbg',
                                                    $env{'user.domain'});
    my %lt = &Apache::lonlocal::texthash(
        'pref' => 'Display Preference',
        'curr' => 'Current setting ',
        'actn' => 'Action',
        'sdpf' => 'Set display preferences for discussion posts for both bulletin boards and individual resources in all your courses.',
        'prca' => 'Preferences can be set that determine',
        'whpo' => 'Which posts are displayed when you display a bulletin board or resource, and',
        'unwh' => 'Under what circumstances posts are identfied as "New"',
        'allposts' => 'All posts',
        'unread' => 'New posts only',
        'ondisp' => 'Once displayed',
        'onmark' => 'Once marked as read',
        'disa' => 'Posts displayed?',
        'npmr' => 'New posts cease to be identified as "New"?',
        'thde'  => 'The preferences you set here can be overridden within each individual discussion.',
        'chgt' => 'Change to '
    );
    my $dispchange = $lt{'unread'};
    my $markchange = $lt{'ondisp'};
    my $currdisp = $lt{'allposts'};
    my $currmark = $lt{'onmark'};

    if ($discdisp eq 'unread') {
        $dispchange = $lt{'allposts'};
        $currdisp = $lt{'unread'};
        $newdisp = 'allposts';
    }

    if ($discmark eq 'ondisp') {
        $markchange = $lt{'onmark'};
        $currmark = $lt{'ondisp'};
        $newmark = 'onmark';
    }
    
    $r->print(<<"END");
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_discussion" />
<br />
$lt{'sdpf'}<br /> $lt{'prca'}  <ol><li>$lt{'whpo'}</li><li>$lt{'unwh'}</li></ol> 
<br />
<br />
END
    $r->print(&Apache::loncommon::start_data_table());
    $r->print(<<"END");
       <tr>
        <th>$lt{'pref'}</th>
        <th>$lt{'curr'}</th>
        <th>$lt{'actn'}?</th>
       </tr>
END
    $r->print(&Apache::loncommon::start_data_table_row());
    $r->print(<<"END");
       <td>$lt{'disa'}</td>
       <td>$lt{$discdisp}</td>
       <td><label><input type="checkbox" name="discdisp" /><input type="hidden" name="newdisp" value="$newdisp" />&nbsp;$lt{'chgt'} "$dispchange"</label></td>
END
    $r->print(&Apache::loncommon::end_data_table_row().
	      &Apache::loncommon::start_data_table_row());
    $r->print(<<"END");
       <td>$lt{'npmr'}</td>
       <td>$lt{$discmark}</td>
       <td><label><input type="checkbox" name="discmark" /><input type="hidden" name="newmark" value="$newmark" />&nbsp;$lt{'chgt'} "$markchange"</label></td>
      </tr>
END
    $r->print(&Apache::loncommon::end_data_table_row().
	      &Apache::loncommon::end_data_table());
    $r->print(<<"END");
<br />
<br />
<input type="submit" name="sub" value="Save Changes" />
<br />
<br />
Note: $lt{'thde'}
</form>
END
}
                                                                                                                
sub verify_and_change_discussion {
    my $r = shift;
    my $user     = $env{'user.name'};
    my $domain   = $env{'user.domain'};
    my $message='';
    if (defined($env{'form.discdisp'}) ) {
        my $newdisp  = $env{'form.newdisp'};
        if ($newdisp eq 'unread') {
            $message .=&mt('In discussions: only new posts will be displayed.').'<br />';
            &Apache::lonnet::put('environment',{'discdisplay' => $newdisp});
            &Apache::lonnet::appenv({'environment.discdisplay' => $newdisp});
        } else {
            $message .= &mt('In discussions: all posts will be displayed.').'<br />';
            &Apache::lonnet::del('environment',['discdisplay']);
            &Apache::lonnet::delenv('environment\.discdisplay');
        }
    }
    if (defined($env{'form.discmark'}) ) {
        my $newmark = $env{'form.newmark'};
        if ($newmark eq 'ondisp') {
           $message.=&mt('In discussions: new posts will be cease to be identified as "NEW" after display.').'<br />';
            &Apache::lonnet::put('environment',{'discmarkread' => $newmark});
            &Apache::lonnet::appenv({'environment.discmarkread' => $newmark});
        } else {
            $message.=&mt('In discussions: posts will be identified as "NEW" until marked as read by the reader.').'<br />';
            &Apache::lonnet::del('environment',['discmarkread']);
            &Apache::lonnet::delenv('environment\.discmarkread');
        }
    }
    $r->print(<<ENDVCSCREEN);
$message
ENDVCSCREEN
}

################################################################
# Subroutines for page display on course access (Course Coordinators)
################################################################
sub coursedisplaychanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get('environment',['course_init_display']);
    my $currvalue = 'whatsnew';
    my $firstselect = '';
    my $whatsnewselect = 'checked="checked"';
    if (exists($userenv{'course_init_display'})) {
        if ($userenv{'course_init_display'} eq 'firstres') {
            $currvalue = 'firstres';
            $firstselect = 'checked="checked"';
	    $whatsnewselect = '';
        }
    }
    my %pagenames = (
                       firstres => 'First resource',
                       whatsnew => "What's new page",
                    );
    my $whatsnew_off=&mt('Display the [_1] in the course.','<b>first resource</b>');
    my $whatsnew_on=&mt('Display the "[_1]" page - a summary of items in the course which require attention.',"<b>What's New</b>");

    $r->print('<br /><b>'.&mt('Set the default page to be displayed when you select a course role').'</b>&nbsp;'.&mt('(Currently: [_1])',$pagenames{$currvalue}).'<br />'.&mt('The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the "[_1]" page in the course',"<i>What's New</i>").'<br /><br />');
    $r->print(<<ENDLSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_coursepage" />
<br />
<label><input type="radio" name="newdisp" value="firstres" $firstselect /> $whatsnew_off</label><br />
<label><input type="radio" name="newdisp" value="whatsnew" $whatsnewselect /> $whatsnew_on</label><input type="hidden" name="refpage" value="$env{'form.refpage'}" />
ENDLSCREEN
    $r->print('<br /><br /><input type="submit" value="'.&mt('Change').'" />
</form>');
}

sub verify_and_change_coursepage {
    my $r = shift;
    my $message='';
    my %lt = &Apache::lonlocal::texthash(
        'defs' => 'Default now set',
        'when' => 'when you select a course role from the roles screen',
        'ywbt' => 'you will be taken to the start of the course.',
        'apwb' => 'a page will be displayed that lists items in the course that may require action from you.',
        'gtts' => 'Go to the start of the course',
        'dasp' => "Display the What's New page listing course action items", 
    );
    my $newdisp  = $env{'form.newdisp'};
    $message = '<b>'.$lt{'defs'}.'</b>: '.$lt{'when'}.', ';
    if ($newdisp eq 'firstres') {
        $message .= $lt{'ywbt'}.'<br />';
        &Apache::lonnet::put('environment',{'course_init_display' => $newdisp});
        &Apache::lonnet::appenv({'environment.course_init_display' => $newdisp});
    } else {
        $message .= $lt{'apwb'}.'<br />';
        &Apache::lonnet::del('environment',['course_init_display']);
        &Apache::lonnet::delenv('environment\.course_init_display');
    }
    my $refpage = $env{'form.refpage'};
    if (($env{'request.course.fn'}) && ($env{'request.course.id'})) {
        if ($newdisp eq 'firstres') {
            my $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
            my $cnum = $env{'course.'.$env{'request.course.id'}.'.num'}; 
            my ($furl,$ferr)=
                &Apache::lonuserstate::readmap($cdom.'/'.$cnum);
            $message .= '<br /><font size="+1"><a href="'.$furl.'">'.$lt{'gtts'}.' <i>'.&mt('now').'</i></a></font>';
        } else {
            $message .= '<br /><font size="+1"><a href="/adm/whatsnew?refpage='.
                        $refpage.'">'.$lt{'dasp'}.'</a></font>';
        }
    }
    $r->print(<<ENDVCSCREEN);
$message
<br /><br />
ENDVCSCREEN
}


######################################################
#            other handler subroutines               #
######################################################

################################################################
#                          Main handler                        #
################################################################
sub handler {
    my $r = shift;
    my $user = $env{'user.name'};
    my $domain = $env{'user.domain'};
    &Apache::loncommon::content_type($r,'text/html');
    # Some pages contain DES keys and should not be cached.
    &Apache::loncommon::no_cache($r);
    $r->send_http_header;
    return OK if $r->header_only;
    #
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                   ['action','wysiwyg','returnurl','refpage']);
    #
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href => '/adm/preferences',
          text => 'Set User Preferences'});

    my @Options;
    # Determine current authentication method
    my $currentauth=&Apache::lonnet::queryauthenticate($user,$domain);
    if ($currentauth =~ /^(unix|internal):/) {
        push (@Options,({ action   => 'changepass',
                          linktext => 'Change Password',
                          href     => '/adm/preferences',
                          help     => 'Change_Password',
                          subroutine => \&passwordchanger,
                          breadcrumb => 
                              { href => '/adm/preferences?action=changepass',
                                text => 'Change Password'},
                          },
                        { action => 'verify_and_change_pass',
                          subroutine => \&verify_and_change_password,
                          breadcrumb => 
                              { href =>'/adm/preferences?action=changepass',
                                text => 'Change Password'},
                          printmenu => 'not_on_error',
                          }));
    }
    push (@Options,({ action   => 'changescreenname',
                      linktext => 'Change Screen Name',
                      href     => '/adm/preferences',
                      help     => 'Prefs_Screen_Name_Nickname',
                      subroutine => \&screennamechanger,
                      breadcrumb => 
                          { href => '/adm/preferences?action=changescreenname',
                            text => 'Change Screen Name'},
                      },
                    { action   => 'verify_and_change_screenname',
                      subroutine => \&verify_and_change_screenname,
                      breadcrumb => 
                          { href => '/adm/preferences?action=changescreenname',
                            text => 'Change Screen Name'},
                      printmenu => 'yes',
                      }));

    push (@Options,({ action   => 'changemsgforward',
                      linktext => 'Change Message Forwarding and Notification Email Addresses',
                      href     => '/adm/preferences',
                      help     => 'Prefs_Messages',
                      breadcrumb => 
                          { href => '/adm/preferences?action=changemsgforward',
                            text => 'Change Message Forwarding/Notification'},
                      subroutine => \&msgforwardchanger,
                      },
                    { action => 'verify_and_change_msgforward',
                      help   => 'Prefs_Messages',
                      breadcrumb => 
                          { href => '/adm/preferences?action=changemsgforward',
                            text => 'Change Message Forwarding/Notification'},
                      printmenu => 'no',
                      subroutine => \&verify_and_change_msgforward }));
    my $aboutmeaction=
        '/adm/'.$env{'user.domain'}.'/'.$env{'user.name'}.'/aboutme';
    push (@Options,{ action => 'none', 
                     linktext =>
                         q{Edit the 'About Me' Personal Information Screen},
		     help => 'Prefs_About_Me',
                     href => $aboutmeaction});
    push (@Options,({ action => 'changecolors',
                      linktext => 'Change Color Scheme',
                      href => '/adm/preferences',
                      help => 'Change_Colors',
                      breadcrumb => 
                          { href => '/adm/preferences?action=changecolors',
                            text => 'Change Colors'},
                      subroutine => \&colorschanger,
                  },
                    { action => 'verify_and_change_colors',
                      breadcrumb => 
                          { href => '/adm/preferences?action=changecolors',
                            text => 'Change Colors'},
                      printmenu => 'yes',
                      subroutine => \&verify_and_change_colors,
                      }));
    push (@Options,({ action => 'changelanguages',
                      linktext => 'Change Language Preferences',
                      href => '/adm/preferences',
		      help => 'Prefs_Language',
                      breadcrumb=>
                          { href => '/adm/preferences?action=changelanguages',
                            text => 'Change Language'},
                      subroutine =>  \&languagechanger,
                  },
                    { action => 'verify_and_change_languages',
                      breadcrumb=>
                          {href => '/adm/preferences?action=changelanguages',
                           text => 'Change Language'},
                      printmenu => 'yes',
                      subroutine=>\&verify_and_change_languages, }
                    ));
    push (@Options,({ action => 'changewysiwyg',
                      linktext => 'Change WYSIWYG Editor Preferences',
                      href => '/adm/preferences',
                      breadcrumb => 
                            { href => '/adm/preferences?action=changewysiwyg',
                              text => 'Change WYSIWYG Preferences'},
                      subroutine => \&wysiwygchanger,
                  },
                    { action => 'set_wysiwyg',
                      breadcrumb =>
                          { href => '/adm/preferences?action=changewysiwyg',
                            text => 'Change WYSIWYG Preferences'},
                      printmenu => 'yes',
                      subroutine => \&verify_and_change_wysiwyg, }
                    ));
    push (@Options,({ action => 'changediscussions',
                      linktext => 'Change Discussion Display Preferences',
                      href => '/adm/preferences',
                      help => 'Change_Discussion_Display',
                      breadcrumb => 
                            { href => '/adm/preferences?action=changediscussions',
                              text => 'Change Discussion Preferences'},
                      subroutine => \&discussionchanger,
                  },
                    { action => 'verify_and_change_discussion',
                      breadcrumb =>
                          { href => '/adm/preferences?action=changediscussions',
                            text => 'Change Discussion Preferences'},
                      printmenu => 'yes',
                      subroutine => \&verify_and_change_discussion, }
                    ));

    my $role = ($env{'user.adv'} ? 'Roles' : 'Course');
    push (@Options,({ action   => 'changerolespref',
                      linktext => 'Change '.$role.' Page Preferences',
                      href     => '/adm/preferences',
                      subroutine => \&rolesprefchanger,
                      breadcrumb =>
                          { href => '/adm/preferences?action=changerolespref',
                            text => 'Change '.$role.' Page Pref'},
                      },
                    { action   => 'verify_and_change_rolespref',
                      subroutine => \&verify_and_change_rolespref,
                      breadcrumb =>
                          { href => '/adm/preferences?action=changerolespref',
                            text => 'Change '.$role.' Page Preferences'},
                      printmenu => 'yes',
                      }));

    push (@Options,({ action   => 'changetexenginepref',
                      linktext => 'Change How Math Equations Are Displayed',
                      href     => '/adm/preferences',
                      subroutine => \&texenginechanger,
                      breadcrumb =>
                          { href => '/adm/preferences?action=changetexenginepref',
                            text => 'Change Math Pref'},
                      },
                    { action   => 'verify_and_change_texengine',
                      subroutine => \&verify_and_change_texengine,
                      breadcrumb =>
                          { href => '/adm/preferences?action=changetexenginepref',
                            text => 'Change Math Preferences'},
                      printmenu => 'yes',
                      }));

    if ($env{'environment.remote'} eq 'off') {
	push (@Options,({ action => 'launch',
			  linktext => 'Launch Remote Control',
			  href => '/adm/remote?url=/adm/preferences',
		      }));
    } else {
	push (@Options,({ action => 'collapse',
			  linktext => 'Collapse Remote Control',
			  href => '/adm/remote?url=/adm/preferences',
		      }));
    }

    push (@Options,({ action   => 'changeicons',
                      linktext => 'Change How Menus are Displayed',
                      href     => '/adm/preferences',
                      subroutine => \&iconchanger,
                      breadcrumb =>
                          { href => '/adm/preferences?action=changeicons',
                            text => 'Change Main Menu'},
                      },
                    { action   => 'verify_and_change_icons',
                      subroutine => \&verify_and_change_icons,
                      breadcrumb =>
                          { href => '/adm/preferences?action=changeicons',
                            text => 'Change Main Menu'},
                      printmenu => 'yes',
                      }));

    push (@Options,({ action   => 'changeclicker',
                      linktext => 'Register Response Devices ("Clickers")',
                      href     => '/adm/preferences',
                      subroutine => \&clickerchanger,
                      breadcrumb =>
                          { href => '/adm/preferences?action=changeclicker',
                            text => 'Register Clicker'},
                      },
                    { action   => 'verify_and_change_clicker',
                      subroutine => \&verify_and_change_clicker,
                      breadcrumb =>
                          { href => '/adm/preferences?action=changeclicker',
                            text => 'Register Clicker'},
                      printmenu => 'yes',
                      }));
    my %author_roles = &Apache::lonnet::get_my_roles($user,$domain,'userroles','',['au']);
    if (keys(%author_roles) > 0) {
      push (@Options,({ action   => 'changedomcoord',
                        linktext => 'Restrict Domain Coordinator Access',
                        href     => '/adm/preferences',
                        subroutine => \&domcoordchanger,
                        breadcrumb =>
                            { href => '/adm/preferences?action=changedomcoord',
                              text => 'Restrict Domain Coordinator Access'},
                      },
                      { action   => 'verify_and_change_domcoord',
                        subroutine => \&verify_and_change_domcoord,
                        breadcrumb =>
                            { href => '/adm/preferences?action=changedomcoord',
                              text => 'Restrict Domain Coordinator Access'},
                        printmenu => 'yes',
                      }));
    }

    push (@Options,({ action   => 'lockwarning',
                      subroutine => \&lockwarning,
                      breadcrumb =>
                          { href => '/adm/preferences?action=lockwarning',
                            text => 'Lock Warnings'},
                      },
                    { action   => 'verify_and_change_locks',
                      subroutine => \&verify_and_change_lockwarning,
                      breadcrumb =>
                          { href => '/adm/preferences?action=lockwarning',
                            text => 'Lockwarnings'},
                      printmenu => 'yes',
                      }));


    if (&Apache::lonnet::allowed('whn',$env{'request.course.id'})
	|| &Apache::lonnet::allowed('whn',$env{'request.course.id'}.'/'
				    .$env{'request.course.sec'})) {
        push (@Options,({ action => 'changecourseinit',
                          linktext => 'Change Course Initialization Preference',
                          href => '/adm/preferences',
                          subroutine => \&coursedisplaychanger,
                          breadcrumb =>
                              { href => '/adm/preferences?action=changecourseinit',
                                text => 'Change Course Init. Pref.'},
                          },
                        { action => 'verify_and_change_coursepage',
                          breadcrumb =>
                          { href => '/adm/preferences?action=changecourseinit',                               text => 'Change Course Initialization Preference'},
                        printmenu => 'yes',
                        subroutine => \&verify_and_change_coursepage,
                       }));
    }

    if ($env{'user.name'} =~ /^(albertel|fox|foxr|kortemey|korte|raeburn)$/) {
        push (@Options,({ action => 'debugtoggle',
                          printmenu => 'yes',
                          subroutine => \&toggle_debug,
                          }));
    }

    $r->print(&Apache::loncommon::start_page('Change Preferences'));

    my $call = undef;
    my $help = undef;
    my $printmenu = 'yes';
    foreach my $option (@Options) {
        if ($option->{'action'} eq $env{'form.action'}) {
            $call = $option->{'subroutine'};
            $printmenu = $option->{'printmenu'};
            if (exists($option->{'breadcrumb'})) {
                &Apache::lonhtmlcommon::add_breadcrumb
                    ($option->{'breadcrumb'});
            }
	    $help=$option->{'help'};
        }
    }
    $r->print(&Apache::lonhtmlcommon::breadcrumbs('Change Preferences',$help));
    my $error;
    if (defined($call)) {
        $error = $call->($r);
    }
    if ( ( ($printmenu eq 'yes')
	   || ($printmenu eq 'not_on_error' && !$error) )
	 && (!$env{'form.returnurl'})) {
        my $optionlist = '<table cellpadding="5">';
        if ($env{'user.name'} =~ 
                         /^(albertel|kortemey|fox|foxr|korte|hallmat3|turtle|raeburn)$/
            ) {
            push (@Options,({ action => 'debugtoggle',
                              linktext => 'Toggle Debug Messages',
                              text => 'Current Debug status is -'.
                                  $env{'user.debug'}.'-.',
                              href => '/adm/preferences',
                              printmenu => 'yes',
                              subroutine => \&toggle_debug,
                              }));
        }
        foreach my $option(@Options) {
            my $optiontext = '';
            if (exists($option->{'href'})) {
		$option->{'href_args'}{'action'}=$option->{'action'};
		$optiontext .= 
                    '<a href="'.&add_get_param($option->{'href'},
					       $option->{'href_args'}).'">'.
                    &mt($option->{'linktext'}).'</a>';
            }
            if (exists($option->{'text'})) {
                $optiontext .= ' '.&mt($option->{'text'});
            }
            if ($optiontext ne '') {
                $optiontext = '<font size="+1">'.$optiontext.'</font>'; 
                my $helplink = '&nbsp;';
                if (exists($option->{'help'})) {
                    $helplink = &Apache::loncommon::help_open_topic
                                                    ($option->{'help'});
                }
                $optionlist .= '<tr>'.
                    '<td>'.$helplink.'</td>'.
                    '<td>'.$optiontext.'</td>'.
                    '</tr>';
            }
        }
        $optionlist .= '</table>';
        $r->print($optionlist);
    } elsif ($env{'form.returnurl'}) {
	$r->print('<br /><a href="'.$env{'form.returnurl'}.'"><font size="+1">'.
		  &mt('Return').'</font></a>');
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub toggle_debug {
    if ($env{'user.debug'}) {
        &Apache::lonnet::delenv('user\.debug');
    } else {
        &Apache::lonnet::appenv({'user.debug' => 1});
    }
}

1;
__END__
