# The LearningOnline Network
# URL translation for User Files
#
# $Id: lontrans.pm,v 1.13 2006/12/06 22:22:36 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lontrans;

use strict;
use Apache::Constants qw(:common :remotehost);
use Apache::lonnet();
use Apache::File();
use LONCAPA;


sub handler {
    my $r = shift;
    # FIXME line remove when mod_perl fixes BUG#4948 
    $r->notes->set('error-notes' => '');
    if ($r->uri=~m|^(/raw)?/uploaded/|) {
        my $fn = $r->uri();
        $fn=~s/^\/raw//;
        my (undef,undef,$udom,$uname,@ufile)=split(/\//,$fn);
	if (@ufile) { $ufile[-1]=~s/^[\~\.]+//; }
        my $chome=&Apache::lonnet::homeserver($uname,$udom);
	my $allowed=0;
	my @ids=&Apache::lonnet::current_machine_ids();
	foreach my $id (@ids) { if ($id eq $chome) { $allowed=1; } }
	if ($allowed) {
	    $r->filename(&propath($udom,$uname).
			 '/userfiles/'.(join('/',@ufile)));
        }
    } elsif ($r->uri=~m|^/~|) {	
	#internal authentication, needs fixup.
	my $fn = $r->uri(); # non users do not get the full path request
	                 # through SCRIPT_FILENAME
	$fn=~s|^/~($LONCAPA::username_re)|/home/$1/public_html|;
	$r->filename($fn);
    } else { return DECLINED; }
    return OK;
}

1;
__END__







