/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

public class Bond {
    Atom atom1;
    Atom atom2;
    short order;
    short mad;
    short colix;
    int index = -1;
    int shapeVisibilityFlags;
    static final int myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(1);

    public short getMad() {
        return this.mad;
    }

    public short getColix() {
        return this.colix;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    Bond(Atom atom, Atom atom2, short s, short s2, short s3) {
        if (atom == null) {
            throw new NullPointerException();
        }
        if (atom2 == null) {
            throw new NullPointerException();
        }
        this.atom1 = atom;
        this.atom2 = atom2;
        if (atom.getElementNumber() == 16 && atom2.getElementNumber() == 16) {
            s = (short)(s | 0x40);
        }
        if (s == 8) {
            s = (short)9;
        }
        this.order = s;
        this.colix = s3;
        this.setMad(s2);
    }

    public String getIdentity() {
        return this.index + 1 + " " + this.order + " " + this.atom1.getIdentity() + " -- " + this.atom2.getIdentity();
    }

    public String formatLabel(String string, int[] nArray) {
        if (string == null || string.length() == 0) {
            return this.getIdentity();
        }
        String string2 = string;
        string2 = TextFormat.formatString((String)string2, (String)"=", (int)(this.index + 1));
        string2 = TextFormat.formatString((String)string2, (String)"ORDER", (String)this.getOrderNumber());
        string2 = TextFormat.formatString((String)string2, (String)"TYPE", (String)this.getOrderName());
        string2 = TextFormat.formatString((String)string2, (String)"LENGTH", (float)this.atom1.distance((Point3f)this.atom2));
        string2 = this.atom1.formatLabel(string2, '1', nArray);
        string2 = this.atom2.formatLabel(string2, '2', nArray);
        return string2;
    }

    boolean isCovalent() {
        return (this.order & 7) != 0;
    }

    boolean isHydrogen() {
        return (this.order & 0x780) != 0;
    }

    boolean isStereo() {
        return (this.order & 0x30) != 0;
    }

    boolean isAromatic() {
        return (this.order & 8) != 0;
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    public void setMad(short s) {
        boolean bl;
        boolean bl2 = this.mad != 0;
        boolean bl3 = bl = s != 0;
        if (bl2 != bl) {
            this.atom1.addDisplayedBond(myVisibilityFlag, bl);
            this.atom2.addDisplayedBond(myVisibilityFlag, bl);
        }
        this.mad = s;
        this.setShapeVisibility(myVisibilityFlag, bl);
    }

    final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = Graphics3D.getColixTranslucent((short)this.colix, (boolean)bl, (float)f);
    }

    boolean isTranslucent() {
        return Graphics3D.isColixTranslucent((short)this.colix);
    }

    public void setOrder(short s) {
        this.order = s;
    }

    public Atom getAtom1() {
        return this.atom1;
    }

    public Atom getAtom2() {
        return this.atom2;
    }

    public int getAtomIndex1() {
        return this.atom1.atomIndex;
    }

    public int getAtomIndex2() {
        return this.atom2.atomIndex;
    }

    float getRadius() {
        return (float)this.mad / 2000.0f;
    }

    public short getOrder() {
        return this.order;
    }

    String getOrderName() {
        return JmolConstants.getBondOrderNameFromOrder(this.order);
    }

    String getOrderNumber() {
        return JmolConstants.getBondOrderNumberFromOrder(this.order);
    }

    short getColix1() {
        return Graphics3D.getColixInherited((short)this.colix, (short)this.atom1.colixAtom);
    }

    int getArgb1() {
        return this.atom1.group.chain.modelSet.viewer.getColixArgb(this.getColix1());
    }

    short getColix2() {
        return Graphics3D.getColixInherited((short)this.colix, (short)this.atom2.colixAtom);
    }

    int getArgb2() {
        return this.atom1.group.chain.modelSet.viewer.getColixArgb(this.getColix2());
    }

    Atom getOtherAtom(Atom atom) {
        return this.atom1 == atom ? this.atom2 : (this.atom2 == atom ? this.atom1 : null);
    }

    Hashtable getPublicProperties() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("atomIndexA", new Integer(this.atom1.atomIndex));
        hashtable.put("atomIndexB", new Integer(this.atom2.atomIndex));
        hashtable.put("argbA", new Integer(this.getArgb1()));
        hashtable.put("argbB", new Integer(this.getArgb2()));
        hashtable.put("order", this.getOrderName());
        hashtable.put("radius", new Double(this.getRadius()));
        hashtable.put("modelIndex", new Integer(this.atom1.modelIndex));
        hashtable.put("xA", new Double(((Tuple3f)this.atom1).x));
        hashtable.put("yA", new Double(((Tuple3f)this.atom1).y));
        hashtable.put("zA", new Double(((Tuple3f)this.atom1).z));
        hashtable.put("xB", new Double(((Tuple3f)this.atom2).x));
        hashtable.put("yB", new Double(((Tuple3f)this.atom2).y));
        hashtable.put("zB", new Double(((Tuple3f)this.atom2).z));
        return hashtable;
    }

    public void setShapeVisibilityFlags(int n) {
        this.shapeVisibilityFlags = n;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public static class BondSet
    extends BitSet {
        private int[] associatedAtoms;

        public int[] getAssociatedAtoms() {
            return this.associatedAtoms;
        }

        public BondSet(BitSet bitSet) {
            int n = bitSet.size();
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                this.set(n);
            }
        }

        public BondSet(BitSet bitSet, int[] nArray) {
            this(bitSet);
            this.associatedAtoms = nArray;
        }
    }
}

