/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Logger;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.Viewer;

class RepaintManager {
    Viewer viewer;
    FrameRenderer frameRenderer;
    int currentModelIndex = 0;
    int currentTrajectory = -1;
    boolean isTrajectory;
    int backgroundModelIndex = -1;
    private BitSet bsVisibleFrames = new BitSet();
    AnimationThread animationThread;
    boolean inMotion = false;
    int holdRepaint = 0;
    boolean repaintPending;
    int firstModelIndex;
    int lastModelIndex;
    int frameStep;
    int animationDirection = 1;
    int currentDirection = 1;
    int animationFps = 10;
    static final int ANIMATION_ONCE = 0;
    static final int ANIMATION_LOOP = 1;
    static final int ANIMATION_PALINDROME = 2;
    int animationReplayMode = 0;
    float firstFrameDelay;
    float lastFrameDelay;
    int firstFrameDelayMs;
    int lastFrameDelayMs;
    boolean animationOn = false;
    boolean animationPaused = false;
    int intAnimThread = 0;

    RepaintManager(Viewer viewer) {
        this.viewer = viewer;
        this.frameRenderer = new FrameRenderer(viewer);
    }

    void setTrajectory(int n) {
        this.isTrajectory = n >= 0;
        this.currentTrajectory = n;
    }

    void setCurrentModelIndex(int n) {
        ModelSet modelSet = this.viewer.getModelSet();
        if (n != 0 && this.isTrajectory) {
            this.viewer.setTrajectory(-1);
        }
        this.currentModelIndex = modelSet == null || n < 0 || n >= modelSet.getModelCount() ? -1 : n;
        if (this.currentModelIndex == -1) {
            this.setBackgroundModelIndex(-1);
        }
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
        if (modelSet != null) {
            this.setStatusFrameChanged();
        }
    }

    private void setStatusFrameChanged() {
        int n = this.isTrajectory ? this.currentTrajectory : this.currentModelIndex;
        this.viewer.setStatusFrameChanged(this.animationOn ? -2 - n : n);
    }

    void setBackgroundModelIndex(int n) {
        ModelSet modelSet = this.viewer.getModelSet();
        if (modelSet == null || n < 0 || n >= modelSet.getModelCount() || this.currentModelIndex == -1) {
            n = -1;
        }
        this.backgroundModelIndex = n;
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
    }

    BitSet getVisibleFramesBitSet() {
        return this.bsVisibleFrames;
    }

    private void setFrameRangeVisible() {
        this.bsVisibleFrames.clear();
        if (this.currentModelIndex >= 0) {
            this.bsVisibleFrames.set(this.currentModelIndex);
            if (this.backgroundModelIndex >= 0) {
                this.bsVisibleFrames.set(this.backgroundModelIndex);
            }
            return;
        }
        if (this.frameStep == 0 || this.isTrajectory) {
            return;
        }
        for (int i = this.firstModelIndex; i != this.lastModelIndex; i += this.frameStep) {
            this.bsVisibleFrames.set(i);
        }
        this.bsVisibleFrames.set(this.lastModelIndex);
    }

    void setInMotion(boolean bl) {
        this.inMotion = bl;
    }

    void pushHoldRepaint() {
        ++this.holdRepaint;
    }

    void popHoldRepaint() {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            this.repaintPending = true;
            this.viewer.repaint();
        }
    }

    boolean refresh() {
        if (this.repaintPending) {
            return false;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.viewer.repaint();
        }
        return true;
    }

    synchronized void requestRepaintAndWait() {
        this.viewer.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    void render(Graphics3D graphics3D, ModelSet modelSet) {
        this.frameRenderer.render(graphics3D, modelSet);
        Rectangle rectangle = this.viewer.getRubberBandSelection();
        if (rectangle != null && graphics3D.setColix(this.viewer.getColixRubberband())) {
            graphics3D.drawRect(rectangle.x, rectangle.y, 0, 0, rectangle.width, rectangle.height);
        }
    }

    void initializePointers(int n) {
        this.firstModelIndex = 0;
        this.lastModelIndex = this.viewer.getTrajectoryCount();
        boolean bl = this.isTrajectory = this.lastModelIndex > 1;
        this.lastModelIndex = (n == 0 ? 0 : (this.isTrajectory ? this.lastModelIndex : this.viewer.getModelCount())) - 1;
        this.frameStep = n;
    }

    void clear() {
        this.clearAnimation();
        this.frameRenderer.clear();
    }

    void clearAnimation() {
        this.setAnimationOn(false);
        this.setCurrentModelIndex(0);
        this.setTrajectory(-1);
        this.setAnimationDirection(1);
        this.setAnimationFps(10);
        this.setAnimationReplayMode(0, 0.0f, 0.0f);
        this.initializePointers(0);
    }

    Hashtable getAnimationInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("firstModelIndex", new Integer(this.firstModelIndex));
        hashtable.put("lastModelIndex", new Integer(this.lastModelIndex));
        hashtable.put("animationDirection", new Integer(this.animationDirection));
        hashtable.put("currentDirection", new Integer(this.currentDirection));
        hashtable.put("currentTrajectory", new Integer(this.currentTrajectory));
        hashtable.put("displayModelIndex", new Integer(this.currentModelIndex));
        hashtable.put("displayModelNumber", new Integer(this.currentModelIndex >= 0 ? this.viewer.getModelNumberDotted(this.currentModelIndex) : "0"));
        hashtable.put("displayModelName", this.currentModelIndex >= 0 ? this.viewer.getModelName(this.currentModelIndex) : "");
        hashtable.put("animationFps", new Integer(this.animationFps));
        hashtable.put("animationReplayMode", this.getAnimationModeName());
        hashtable.put("firstFrameDelay", new Float(this.firstFrameDelay));
        hashtable.put("lastFrameDelay", new Float(this.lastFrameDelay));
        hashtable.put("animationOn", this.animationOn);
        hashtable.put("animationPaused", this.animationPaused);
        return hashtable;
    }

    String getState() {
        int n = this.viewer.getModelCount();
        if (n < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("# frame state;\n# modelCount ").append(n).append(";\n# first ").append(this.viewer.getModelNumberDotted(0)).append(";\n# last ").append(this.viewer.getModelNumberDotted(n - 1)).append(";\n");
        if (this.backgroundModelIndex >= 0) {
            stringBuffer.append("set backgroundModel ").append(this.viewer.getModelNumberDotted(this.backgroundModelIndex)).append(";\n");
        }
        stringBuffer.append("frame RANGE " + this.viewer.getModelNumberDotted(this.firstModelIndex) + " " + this.viewer.getModelNumberDotted(this.lastModelIndex)).append(";\n");
        stringBuffer.append("animation DIRECTION " + (this.animationDirection == 1 ? "+1" : "-1")).append(";\n");
        stringBuffer.append("animation MODE " + this.getAnimationModeName()).append(" ").append(this.firstFrameDelay).append(" ").append(this.lastFrameDelay).append(";\n");
        stringBuffer.append("frame " + this.viewer.getModelNumberDotted(this.currentModelIndex) + ";\n");
        if (this.currentTrajectory > -1) {
            stringBuffer.append("trajectory " + this.currentTrajectory + ";\n");
        }
        stringBuffer.append("animation " + (!this.animationOn ? "OFF" : (this.currentDirection == 1 ? "PLAY" : "PLAYREV"))).append(";\n");
        if (this.animationOn && this.animationPaused) {
            stringBuffer.append("animation PAUSE;\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    void setAnimationDirection(int n) {
        this.animationDirection = n;
    }

    void setAnimationFps(int n) {
        if (n >= 1 && n <= 50) {
            this.animationFps = n;
        } else {
            Logger.error("invalid animationFps:" + n);
        }
    }

    void setAnimationReplayMode(int n, float f, float f2) {
        this.firstFrameDelay = f > 0.0f ? f : 0.0f;
        this.firstFrameDelayMs = (int)(this.firstFrameDelay * 1000.0f);
        this.lastFrameDelay = f2 > 0.0f ? f2 : 0.0f;
        this.lastFrameDelayMs = (int)(this.lastFrameDelay * 1000.0f);
        if (n >= 0 && n <= 2) {
            this.animationReplayMode = n;
        } else {
            Logger.error("invalid animationReplayMode:" + n);
        }
    }

    void setAnimationRange(int n, int n2, boolean bl) {
        int n3;
        int n4 = n3 = bl ? this.viewer.getTrajectoryCount() : this.viewer.getModelCount();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = n3;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
        }
        this.firstModelIndex = n;
        this.lastModelIndex = n2;
        this.frameStep = n2 < n ? -1 : 1;
        this.rewindAnimation();
    }

    private void animationOn(boolean bl) {
        this.animationOn = bl;
        this.viewer.setBooleanProperty("_animating", bl);
    }

    void setAnimationOn(boolean bl) {
        if (!bl || !this.viewer.haveModelSet()) {
            this.setAnimationOff(false);
            return;
        }
        this.viewer.refresh(0, "Viewer:setAnimationOn");
        this.setAnimationRange(-1, -1, this.isTrajectory);
        this.resumeAnimation();
    }

    void setAnimationOff(boolean bl) {
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
        this.animationPaused = bl;
        this.viewer.refresh(0, "Viewer:setAnimationOff");
        this.animationOn(false);
        this.setStatusFrameChanged();
    }

    void pauseAnimation() {
        this.setAnimationOff(true);
    }

    void reverseAnimation() {
        this.currentDirection = -this.currentDirection;
        if (!this.animationOn) {
            this.resumeAnimation();
        }
    }

    void resumeAnimation() {
        int n;
        if (this.currentModelIndex < 0) {
            this.setAnimationRange(this.firstModelIndex, this.lastModelIndex, this.isTrajectory);
        }
        int n2 = n = this.isTrajectory ? this.viewer.getTrajectoryCount() : this.viewer.getModelCount();
        if (n <= 1) {
            this.animationOn(false);
            return;
        }
        this.animationOn(true);
        this.animationPaused = false;
        if (this.animationThread == null) {
            ++this.intAnimThread;
            this.animationThread = new AnimationThread(this.firstModelIndex, this.lastModelIndex, this.intAnimThread);
            this.animationThread.start();
        }
    }

    boolean setAnimationNext() {
        return this.setAnimationRelative(this.animationDirection);
    }

    void setAnimationLast() {
        int n;
        int n2 = n = this.animationDirection > 0 ? this.lastModelIndex : this.firstModelIndex;
        if (this.isTrajectory) {
            this.viewer.setTrajectory(n);
        } else {
            this.setCurrentModelIndex(n);
        }
    }

    void rewindAnimation() {
        int n;
        int n2 = n = this.animationDirection > 0 ? this.firstModelIndex : this.lastModelIndex;
        if (this.isTrajectory) {
            this.viewer.setTrajectory(n);
        } else {
            this.setCurrentModelIndex(n);
        }
        this.currentDirection = 1;
    }

    boolean setAnimationPrevious() {
        return this.setAnimationRelative(-this.animationDirection);
    }

    boolean setAnimationRelative(int n) {
        int n2;
        boolean bl;
        int n3 = this.frameStep * n * this.currentDirection;
        int n4 = (this.isTrajectory ? this.currentTrajectory : this.currentModelIndex) + n3;
        boolean bl2 = bl = n4 > this.firstModelIndex && n4 > this.lastModelIndex || n4 < this.firstModelIndex && n4 < this.lastModelIndex;
        if (bl) {
            switch (this.animationReplayMode) {
                case 0: {
                    return false;
                }
                case 1: {
                    n4 = this.animationDirection == this.currentDirection ? this.firstModelIndex : this.lastModelIndex;
                    break;
                }
                case 2: {
                    this.currentDirection = -this.currentDirection;
                    n4 -= 2 * n3;
                }
            }
        }
        int n5 = n2 = this.isTrajectory ? this.viewer.getTrajectoryCount() : this.viewer.getModelCount();
        if (n4 < 0 || n4 >= n2) {
            return false;
        }
        if (this.isTrajectory) {
            this.viewer.setTrajectory(n4);
            this.viewer.setTainted(true);
        } else {
            this.setCurrentModelIndex(n4);
        }
        return true;
    }

    String getAnimationModeName() {
        switch (this.animationReplayMode) {
            case 1: {
                return "LOOP";
            }
            case 2: {
                return "PALINDROME";
            }
        }
        return "ONCE";
    }

    class AnimationThread
    extends Thread
    implements Runnable {
        final int framePointer;
        final int framePointer2;
        int intThread;

        AnimationThread(int n, int n2, int n3) {
            this.framePointer = n;
            this.framePointer2 = n2;
            this.intThread = n3;
        }

        public void run() {
            long l = System.currentTimeMillis();
            int n = 0;
            Logger.debug("animation thread " + this.intThread + " running");
            if (Logger.isActiveLevel(0)) {
                Logger.debug("animation thread " + this.intThread + " running");
            }
            RepaintManager.this.requestRepaintAndWait();
            try {
                int n2 = n - (int)(System.currentTimeMillis() - l);
                if (n2 > 0) {
                    Thread.sleep(n2);
                }
                boolean bl = true;
                while (!this.isInterrupted() && RepaintManager.this.animationOn) {
                    int n3;
                    int n4 = n3 = RepaintManager.this.isTrajectory ? RepaintManager.this.currentTrajectory : RepaintManager.this.currentModelIndex;
                    if (n3 == this.framePointer && (n2 = (n += RepaintManager.this.firstFrameDelayMs) - (int)(System.currentTimeMillis() - l)) > 0) {
                        Thread.sleep(n2);
                    }
                    if (n3 == this.framePointer2 && (n2 = (n += RepaintManager.this.lastFrameDelayMs) - (int)(System.currentTimeMillis() - l)) > 0) {
                        Thread.sleep(n2);
                    }
                    if (!(bl || RepaintManager.this.repaintPending || RepaintManager.this.setAnimationNext())) {
                        Logger.debug("animation thread " + this.intThread + " exiting");
                        RepaintManager.this.setAnimationOff(false);
                        return;
                    }
                    bl = false;
                    n2 = (n += 1000 / RepaintManager.this.animationFps) - (int)(System.currentTimeMillis() - l);
                    RepaintManager.this.refresh();
                    n2 = n - (int)(System.currentTimeMillis() - l);
                    if (n2 <= 0) continue;
                    Thread.sleep(n2);
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.debug("animation thread interrupted!");
                RepaintManager.this.setAnimationOn(false);
            }
        }
    }
}

