# The LearningOnline Network with CAPA
# German Localization Lexicon
#
# $Id: de.pm,v 1.141 2008/08/27 16:52:45 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::de;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,
          
'char_encoding'=> 'UTF-8',
'language_code'=> 'de',
'lang_locale' => 'de_DE.utf8',
'date_locale'  => 
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds Uhr',
'date_months'  => 'Jan.,Feb.,März,April,Mai,Juni,Juli,Aug.,Sep.,Okt.,Nov.,Dez.',
'date_days'    => 'So.,Mo.,Di.,Mi.,Do.,Fr.,Sa.',
'date_am' => 'vormittags',
'date_pm' => 'nachmittags',
'htmlarea_lang' => 'de',
'spellcheck_lang' => 'de',

   'Domain'
=> 'Domäne',

   'Domain:'
=> 'Domäne:',

   'Server'
=> 'Server',

   'Load'
=> 'Serverlast',

   'User Load'
=> 'Nutzerlast',

   'Help'
=> 'Hilfe',

   'Log in'
=> 'Anmelden',

   'Log-in to LON-CAPA'
=> 'In LON-CAPA anmelden',

   'Username'
=> 'Benutzername',

   'Password'
=> 'Passwort',

   'choose'
=> 'wähle',

   'enter'
=> 'eingeben',

   'view'
=> 'sehe',

   'calendar'
=> 'Kalender',

   'prefer-'
=> 'Präfe-',

   'ences'
=> 'renzen',

   'role'
=> 'Rolle',

   'course'
=> 'Kurs',

   'Course'
=> 'Kurs',

   'Section/Group'
=> 'Sektion/Gruppe',

   'today'
=> 'heute',

   'last week'
=> 'letzte Woche',

   'last month'
=> 'letzten Monat',

   'last three months'
=> 'letzte drei Monate',

   'last six months'
=> 'letzte sechs Monate',

   'last year'
=> 'letztes Jahr',

   'Submit'
=> 'Abschicken',

   'Rename'
=> 'Umbenennen',

   'Save'
=> 'Speichern',

   'Done'
=> 'Fertig',

   'Select User'
=> 'Benutzer auswählen',

   'Select Course'
=> 'Kurs auswählen',

   'Changes will become active for your current session after'
=> 'Änderungen werden für Ihre derzeitige Sitzung aktiv, nachdem Sie',

   're-initializing course'
=> 'Kurs neu initialisieren',

   ', or the next time you log in.'
=> 'haben, oder wenn Sie sich das nächste Mal anmelden.',

   'Uploaded Document'
=> 'Hochgeladenes Dokument',

   'No content modifications yet.'
=> 'Noch keine Inhaltsänderungen.',

   'Part is not open to be viewed. It'
=> 'Aufgabenteil nicht verfügbar. Er',

'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Aufgrund von Netzwerkproblemen kann nicht festgestellt werden, ob diese Ressource verfügbar ist. Bitte versuchen Sie es später noch einmal.',

'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Beachten Sie, dass es bis zu 10 Minuten dauern kann, bis Änderungen für alle Benutzer aktiv werden.',

   'Language'
=> 'Sprache',

   'Notes'
=> 'Notizen',

   'Abstract'
=> 'Kurzbeschreibung',
 
   'Create a user or modify the roles and privileges of a user'
# => 'Benutzeraccounts erstellen oder Benutzerrollen und -priviligien ändern',
=> 'Benutzeraccounts und Rechte verwalten',

   'View course assessment statistics'
=> 'Aufgabenstatistiken', #??? [SB 20.10.2006]

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Setzen von Deadlines und anderen Parametern zur Beurteilung sowie Ändern der Kursumgebung',

   'New Folder'
=> 'Neues Verzeichnis',

   'Simple Page'
=> 'Einfache Seite',

   'Simple Problem'
=> 'Einfache Aufgabe',

   'Upload Document'
=> 'Dokument hochladen',

   'Search'
=> 'Suchen',

   'Import'
=> 'Importieren',

   'Main Course Documents'
=> 'Haupt-Kursdokumente',

   'Supplemental Course Documents'
=> 'Zusätzliche Kursdokumente',

   'Bulletin Board'
=> 'Schwarzes Brett',

   'Special Documents'
=> 'Spezielle Dokumente',

   'create'
=> 'erstelle',

   'grades'
=> 'Bewertungen',

   'commu-'
=> 'Kommu-',

   'nication'
=> 'nikation',

   'enroll'
=> 'Kurs belegen',

   'navigate'
=> 'Inhalts-',

   'contents'
=> 'verzeich',

   'Navigate Contents'
=> 'Inhaltsverzeichnis',

   'Announcements and Calendar'
=> 'Bekanntmachungen und Kalender',

   'Author'
=> 'Autor',

   'Change Your Preferences'
=> 'Ändern Ihrer Benutzerpräferenzen',

   'Choose the user role'
=> 'Benutzerrolle wechseln',

   'Co-Author'
=> 'Co-Autor',

   'Communication and Messages'
=> 'Kommunikation und Nachrichten',

   'Course Coordinator'
=> 'Kurs-Koordinator',

   'Course Statistics and Charts'
=> 'Kursstatistiken und Notenübersicht',

   'Course announcements and my calendar'
# => 'Kursbekanntmachungen und mein Kalender',
=> 'Bekanntmachungen und Kalender',

   'Create Users, Change User Privileges'
# => 'Erstellen neuer Benutzeraccounts, ändern von Benutzerprivilegien',
  => 'Benutzeraccounts und Rechte verwalten',

   'Domain Coordinator'
=> 'Domänen-Koordinator',

   'Enrollment Manager'
=> 'Kursbelegungs-Verwaltung',

   'Enter grades from check-out assessment resources'
=> 'Eingeben von Bewertungen für Beurteilungs-Ressourcen', #??? [SB 20.10.2006]

   'Exam Proctor'
=> 'Klausuraufsichtspersonal',

   'Exit LON-CAPA'
=> 'Abmelden',

   'Grades Spreadsheet'
=> 'Beurteilungsbogen mit Bewertungen',

   'Grading'
=> 'Bewertung',

   'Instructor'
=> 'Dozent',

   'Launch Remote Control'
=> 'Fernbedienung aktivieren',

   'Main Menu'
=> 'Hauptmenü',

   'Navigate Course Contents'
=> 'Inhaltsverzeichnis',

   'No Role, Cumulative Privileges'
=> 'Keine Rolle, kumulative Privilegien',

   'Return to Last Location'
=> 'Zurück zum zuletzt verwendeten Kursdokument',

   'Send and receive messages'
# => 'Verschicken und Empfangen von Nachrichten',
# => 'Interne Nachrichten verwalten',
=> 'Kommunikation und Nachrichten',

   'Set my user preferences'
=> 'Benutzereinstellungen',

   'Student'
=> 'Studierender',

   'Student: '
=> 'Studierender: ',

   'Switch to another user role'
# => 'Andere Benutzerrolle wählen',
=> 'Benutzerrolle wechseln',

   'Teaching Assistant'
=> 'Tutor',

   'Use or edit my bookmark collection'
# => 'Meine Lesezeichen-Sammlung verwenden oder editieren',
=> 'Lesezeichen-Sammlung',

   'User Roles'
=> 'Benutzerrollen',

   'Calculate course grades (Spreadsheet)'
=> 'Bewertungen berechnen (Beurteilungsbogen)',

   'Enter the chatroom for the course'
=> 'Kurs-Chatroom',

   'Navigate the table of contents for this course'
=> 'Inhaltsverzeichnis des Kurses',

   'Syllabus'
=> 'Kursüberblick',

   'Course syllabus'
=> 'Kursüberblick',

   'View the course assessment progress chart'
=> 'Aufgabenfortschritt des Kurses',

   'Class Hours'
=> 'Vorlesungstermine',

   'Course Description'
=> 'Kurstitel',

   'Coursepack'
=> 'Kurspaket',

   'Current Month'
=> 'Dieser Monat',

   'Deadlines'
=> 'Fälligkeitsdaten',

   'Fri'
=> 'Fr',

   'Grading Information'
=> 'Informationen zur Bewertung',

   'Helproom Hours'
=> 'Hilfe',

   'Instructor Information'
=> 'Information über den Dozenten',

   'Mon'
=> 'Mo',

   'Next Month'
=> 'Nächster Monat',

   'Office Hours'
=> 'Sprechstunden',

   'Prerequisites'
=> 'Voraussetzungen',

   'Previous Month'
=> 'Letzter Monat',

   'Readings'
=> 'Material',

   'Sat'
=> 'Sa',

   'January'
=> 'Januar',

   'February'
=> 'Februar',

   'March'
=> 'März',

   'April'
=> 'April',

   'May'
=> 'Mai',

   'June'
=> 'Juni',

   'August'
=> 'August',

   'September'
=> 'September',

   'October'
=> 'Oktober',

   'November'
=> 'November',

   'December'
=> 'Dezember',

   'Sun'
=> 'So',

   'Textbook'
=> 'Bücherliste',

   'Thu'
=> 'Do',

   'Tue'
=> 'Di',

   'Web Links'
=> 'Weblinks',

   'Wed'
=> 'Mi',

   'Drop/Add students in this course'
=> 'Kursbelegungen verwalten',

   'A score has been assigned.'
=> 'Eine Note ist vergeben worden.',

   'Some parts were not submitted.'
=> 'Einige Aufgabenteile sind nicht bearbeitet worden.',

   'Due'
=> 'Fällig',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'Die Endung der von Ihnen eingereichten Datei ist nicht erlaubt.',

   'Units incorrect.'
=> 'Einheit inkorrekt.',

   'Only a number required.'
=> 'Als Eingabe ist nur eine Zahl zulässig.',

   'Units required'
=> 'Einheiten erwartet',

   'Answer Submitted'
=> 'Antwort übermittelt',

   'Tries'
=> 'Versuche',

   'Submit Answer'
=> 'Antwort einreichen',

   'Prepare a printable document'
=> 'Drucken', # long version: 'Druckbares Dokument erstellen',

   'Go To My First Homework Problem'
=> 'Gehe zur ersten Übungsaufgabe',

   'Cancel'
=> 'Abbrechen',

   'Discussions'
=> 'Diskussionen',

   'New discussion since'
=> 'Neue Diskussion seit',

   'New message (click to open)'
=> 'Neue Nachricht (zum Anzeigen klicken)',

   'Close all folders'
=> 'Alle Verzeichnisse schließen',

   'Open all folders'
=> 'Alle Verzeichnisse öffnen',

   'Goodbye'
=> 'Auf Wiedersehen',

   'Select'
=> 'Auswählen',

   'Re-Initialize'
=> 'Neu initialisieren',

   'Currently selected.'
=> 'Derzeit ausgewählt.',

   'Switch Server'
=> 'Server wechseln',

   'system wide'
=> 'netzwerkweit', # 'systemweit'

   'Currently not available'
=> 'Derzeit nicht verfügbar',

   'No role specified'
=> 'Keine bestimmte Rolle',

   'Remark'
=> 'Bemerkung',

   'Extent'
=> 'Bereich',

   'User Role'
=> 'Benutzerrolle',

   'Start'
=> 'Anfang',

   'End'
=> 'Ende',

   'System'
=> 'System',

   'Display'
=> 'Anzeigen',

   'Display:'
=> 'Anzeigen:',

   'Do not display'
=> 'Nicht anzeigen',

   "an unknown date"
=> ': unbekannter Zeitpunkt', # !

   "an indeterminate date"
=> 'unbestimmter Zeitpunkt',

   "will open on"
=> "wird verfügbar sein am",

   "is due at"
=> "ist fällig am",

   "was due on"
=> "war fällig am",

   'is closed but you are allowed to view it'
=> "ist geschlossen, kann aber von Ihnen betrachtet werden",

   "Undid changes, Switched [_1] and [_2]"
=> "Änderungen rückgängig gemacht. [_1] und [_2] wurden ausgetauscht.",

   "Unable to undo, unable to switch [_1] and [_2]"
=> "Änderungen konnten nicht rückgängig gemacht werden. [_1] und [_2] konnten nicht ausgetauscht werden.",

   "Unable to make backup [_1]"
=> "Konnte keine Sicherheitsdatei in [_1] erstellen!",

   "Saving Modifications to [_1]"
=> "Speichere Änderungen in [_1]",

   "Unable to write to [_1]"
=> "Konnte Änderungen nicht in [_1] speichern!",

   "Analyzing a problem"
=> "Analysiere Aufgabe",

   "EditXML"
=> "XML-Editor",

   'Discard Edits and View'
=> 'Änderungen verwerfen und betrachten',

   'Submit Changes'
=> 'Speichern und weiterbearbeiten', # 'Änderungen speichern',

   'Submit Changes and View'
=> 'Speichern und betrachten',

   'Edit'
=> 'Editor',

   ', select a template from the pull-down menu below'
=> 'wählen Sie eine Vorlage aus dem unterstehenden Auswahlmenü',

   'undo'
=> 'Rückgängig machen',

   'Answer'
=> 'Antwort',

   'Frequency'
=> 'Häufigkeit',

   'You did not select a template.'
=> 'Sie haben keine Vorlage ausgewählt.',

   'Analyze Progress'
=> 'Fortschritt analysieren',

   'Getting Problem Variants'
=> 'Berechne Aufgabenvariationen',

   'last problem'
=> 'letzte Aufgabe',

   "may open later."
=> 'könnte zu einem späteren Zeitpunkt verfügbar werden.',

   ', and answers will be available on'
=> ', Antworten werden verfügbar sein am',

   "Select a"
=> "Wählen Sie",

   'Unable to find'
=> 'Konnte nicht gefunden werden',

   'Part'
=> 'Aufgabenteil',

   "Then"
=> 'Dann',

   'is in under construction'
=> 'ist in Arbeit',

   'List of possible answers'
=> 'Liste von möglichen Antworten',

'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Keine analysierbaren Aufgabenteile gefunden.  Derzeit werden nur numerische Ausdrücke, Formeln und Strings als Antworttypen unterstützt.',

   'is not analyzable at this time'
=> 'ist derzeit nicht analysierbar',

   'Title'
=> 'Titel',

   'Path'
=> 'Pfad',

   'New Search'
=> 'Neue Suche',

   'Go Back'
=> 'Zurück',

   'Go back'
=> 'Zurück',

   'File'
=> 'Datei',

   'Date'
=> 'Datum',

   'You have no unread messages'
=> 'Sie haben keine ungelesenen Nachrichten',

   'New Messages'
=> 'Neue Nachrichten',

   'View All Messages'
=> 'Alle Nachrichten',

   'Map'
=> 'Inhaltszusammenstellung',

   'Page'
=> 'Seite',

   'Sequence'
=> 'Sequenz',

   'Map contents are not shown in order.'
=> 'Inhaltszusammenstellungs-Inhalte werden nicht sortiert angezeigt.',

   'Empty'
=> 'Leer',

   'could not be copied.'
=> 'konnte nicht kopiert werden.',

   'Back to Directory'
=> 'Zurück zum Verzeichnis',

   'No upload file specified.'
=> 'Keine Datei zum Hochladen angegeben.',

   'The target is an existing directory.'
=> 'Die Zieldatei ist ein existierendes Verzeichnis.',

   'Please use browser "Back" button and pick a filename'
=> 'Bitte benutzen Sie "Zurück" in Ihrem Webbrowser und geben Sie einen Dateinamen an',

   "You do not have authoring privileges for this resource"
=> "Sie haben für diese Ressource keine Schreibberechtigung!",

   'Copying file'
=> 'Kopiere Datei',

   'No write permission to user directory, FAIL'
=> 'Keine Schreibberechtigung für dieses Verzeichnis. Abbruch',

   'Actions'
=> 'Aktionen',

   'Name'
=> 'Name',

   'Status'
=> 'Status',

   'Last Modified'
=> 'Letzte Änderung',

   'Yes'
=> 'Ja',

   'Construction Space Directory'
=> 'Konstruktionsbereich-Verzeichnis',

   'Contact [_1] for access.'
=> 'Kontaktieren Sie [_1], um Zugriff zu erhalten.',

   'Please log into [_1] to edit.'
=> 'Bitte melden Sie sich in der Domäne [_1] an, um Zugriff zu erhalten.',

   'Save uploaded file as '
=> 'Speichere hochgeladene Datei unter ',

   'Searching'
=> 'Suche',

   'Searching ...'
=> 'Suche...',

   'Owner:Domain'
=> 'Eigentümer:Domäne',

   'Owner/Co-owner(s)'
=> '(Co-)Eigentümer',

   'Select the Construction Space'
=> 'Wählen Sie den Konstruktionsbereich',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Es wird grundsätzlich empfohlen, einen aktuellen Virenscanner zu benutzen, bevor Sie diese Datei verwenden.',

   'not displayed'
=> 'nicht angezeigt',

   "Open, no due date"
=> "Verfügbar, kein Fälligkeitsdatum",

   "Uncompleted Homework"
=> "Unerledigte Übungsaufgaben",

   "Show Only Uncompleted Homework"
=> "Zeige nur unerledigte Übungsaufgaben",

   "All homework is currently completed."
=> "Derzeit sind alle Übungsaufgaben erledigt.",

   'This course is empty.'
=> 'Dieser Kurs ist leer.',

   'Coursemap undefined.'
=> 'Inhaltszusammenstellung des Kurses ist nicht definiert.',

   "Was due"
=> "War fällig am",

   "Answer available"
=> "Antwort verfügbar",

   "Excused by instructor"
=> "Vom Dozenten erlassen",

   "Answer submitted, not yet graded"
=> "Antwort eingereicht, noch nicht bewertet",

   "No due date"
=> "Kein Fälligkeitsdatum",

   'never'
=> 'niemals',

   'Answer submitted'
=> 'Antwort eingereicht',

   'Processing'
=> 'Wird verarbeitet',

   'Access and Usage Statistics'
=> 'Zugriffs- und Nutzungsstatistiken',

   'Evaluation Comments'
=> 'Evaluierungskommentare',

   'Evaluation Data'
=> 'Evaluierungsdaten',

   'July'
=> 'Juli',

   'Server Administration'
=> 'Serververwaltung',

   'System Administration'
=> 'Systemverwaltung',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'Users with Roles Assigned by'
=> 'Benutzer, deren Rollen vergeben wurden von',

   'Name starting with'
=> 'Name beginnt mit',

   'This resource has been marked obsolete by the author(s)'
=> 'Dieses Ressource wurde vom Autor bzw. von den Autoren als überholt gekennzeichnet',

   'Uploaded'
=> 'Hochgeladen',

   'Dynamic Metadata'
=> 'Dynamische Metadaten',

   'View file'
=> 'Datei betrachten',

   'could not be copied.'
=> 'konnte nicht kopiert werden.',

   'Illegal filename.'
=> 'Ungültiger Dateiname.',

   'Rule'
=> 'Regel',

   'Back to Source Directory'
=> 'Zurück zum Quellverzeichnis',

   'Back to Source'
=> 'Zurück zur Quelldatei',

   'File copied.'
=> 'Datei kopiert.',

   'FAIL'
=> 'Abbruch',

   'Back to'
=> 'Zurück zu',

   'untitled'
=> 'kein Titel',

   ', is reserved internally by LON-CAPA.'
=> ', ist intern reserviert für LON-CAPA.',

   'Became this version on ...'
=> 'Wurde diese Version am ...',

   'Browse published resources'
# => 'Veröffentlichte Dokumente betrachten',
=> 'Veröffentlichte Ressourcen',

   'Choose the course to work on'
=> 'Wählen Sie den Kurs, in dem Sie arbeiten wollen',

   'Create a new course'
=> 'Kurse erstellen',

   'Customized right of use ...	'
=> 'Spezielle Nutzungsrechte...',

   'Delete messages from bulletin boards'
=> 'Lösche Nachrichten vom Schwarzen Brett',

   'Domain only - use limited to courses in the domain'
=> 'Beschränkt auf Domäne - Nutzung begrenzt auf Kurse innerhalb dieser Domäne',

   'Edit and view documents included in this course'
=> 'Kursinhalt einrichten', # old: 'Kurs-Ressourcen bearbeiten'

   'Edit/Modify DOCS'
=> 'Kursinhalt einrichten',

   'Enter my construction space'
# => 'Konstruktionsbereich aufrufen',
=> 'Mein Konstruktionsbereich',

   'Failed to copy source'
=> 'Konnte Quelldatei nicht kopieren',

   'Failed to write metadata copy'
=> 'Konnte Metadaten nicht kopieren',

   'Finalize Publication'
=> 'Veröffentlichung abschließen',

   'Grant/revoke role of Co-Author'
=> 'Vergebe/entziehe Co-Autorenrollen',

   'Grant/revoke role of Domain Coordinator'
=> 'Vergebe/entziehe Domänen-Koordinator-Rolle',

   'Grant/revoke role of Exam Proctor'
=> 'Vergebe/entziehe Rolle des Klausuraufsichtspersonals',

   'Grant/revoke role of Instructor'
=> 'Vergebe/entziehe Rolle des Dozenten',

   'Grant/revoke role of Student'
=> 'Vergebe/entziehe Rolle von Studierenden',

   'Grant/revoke role of Superuser'
=> 'Vergebe/entziehe Rolle des Superusers',

   'No previous versions published.'
=> 'Keine vorhergehenden Versionen veröffentlicht.',

   'No write permission to'
=> 'Keine Schreibberechtigung für', 

   'Please pick a version to retrieve'
=> 'Bitte wählen Sie eine Version aus, die Sie wiederherstellen möchten.',

   'Private - visible to author only for testing purposes'
=> 'Privat - für den Autor nur zu Testzwecken sichtbar',

#   'Private Publication - did not synchronize database'
#=> 'Private Veröffentlichung - nicht mit Datenbank synchronisiert',

   'Public - no authentication or authorization required for use'
=> 'Öffentlich - keine LON-CAPA-Anmeldung zur Nutzung notwendig',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'Der Abruf einer alten Version überschreibt die derzeit im Konstruktionsbereich vorhandene Datei!',

   'Retrieve previous versions of'
=> 'Wiederherstellen vorheriger Versionen von',

   'Retrieve version'
=> 'Ausgewählte Version wiederherstellen',

   'Search the contents of this course'
=> 'Kursinhalts-Suche',

   'Search the database of published resources and accessible portfolio files'
=> 'Datenbank veröffentlichter Ressourcen und Portfolio-Dateien',

   'Send broadcast and receipt-required email'
=> 'Sende Broadcast-E-Mail mit Empfangsbestätigung',

   'Show Problem Completeness'
=> 'Zeige Aufgabenvollständigkeit',

   'Switch to another course'
=> 'Zu einem anderen Kurs wechseln',

   'System wide - can be used for any courses system wide'
# => 'Systemweit - kann für alle Kurse systemweit verwendet werden',
=> 'Netzwerkweit - kann für alle Kurse im gesamten LON-CAPA-Netzwerk verwendet werden',

   'The extension on this file'
=> 'Die Endung dieser Datei',

   'Unsupported character combination [_1] in filename, FAIL.'
=> 'Ungültige Zeichenkombination [_1] im Dateinamen. Abbruch!',

   'No valid extension found in filename, FAIL'
=> 'Ungültige Dateinamen-Erweiterung. Abbruch!',

   'Cannot publish versioned resource, FAIL'
=> 'Versionierte Ressource kann nicht veröffentlicht werden. Abbruch!', # ???

   'No valid custom distribution rights file specified, FAIL'
=> 'Keine gültige Rechtedatei für spezille Nutzungsrechte angegeben. Abbruch!',

   'Could not write metadata, FAIL'
=> 'Metadaten konnten nicht geschrieben werden. Abbruch!',

   'View documents included in this course'
=> 'Zusätzliche Kursdokumente',

   'Additional Keywords'
=> 'Zusätzliche Schlüsselwörter',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Zusätzliche Metadaten (nicht standardisiert, Parameter, Exporte)',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Autoren- und Co-Autoren-Rollen könnten auf anderen Servern als Ihrem Heimatserver nicht verfügbar sein.',

   'Author(s)'
=> 'Autor(en)',

   'Average number of tries till solved'
=> 'Durchschnittliche Anzahl an Versuchen bis zur erfolgreichen Lösung',

   'Browse Resources'
=> 'Ressourcen durchsehen',

   'Catalog Information'
=> 'Katalogisierungsdaten',

   'Collapse Remote Control'
=> 'Fernbedienung deaktivieren',

   'Construction Space'
=> 'Konstruktionsbereich',

   'Copied metadata'
=> 'Metadaten kopiert',

   'Copied source file'
=> 'Quelldatei wurde kopiert',

   'Copyright/Distribution'
=> 'Copyright/Zugriffsrechte',

   'Copyright/Distribution:'
=> 'Copyright/Zugriffsrechte:',

   'Course Documents'
=> 'Kursdokumente',

   'Creation Date'
=> 'Ersterstellungsdatum',

   'Custom Distribution File'
=> 'Datei zum Maßschneidern der Zugriffsrechte',

   'Degree of difficulty'
=> 'Schwierigkeitsgrad',

   'Dump Course DOCS to Construction Space'
=> 'Ablage in Konstruktionsbereich',

   'Entering course ...'
=> 'An Kurs teilnehmen ...',

   'Exam Information'
=> 'Prüfungsinformationen',

   'External Resource'
=> 'Externe Ressource',

   'Generate new role ...'
=> 'Erzeuge neue Rolle ...',

   'Go to the next resource in the course sequence'
=> 'Weiter', # long version: 'Gehe zur nächsten Ressource in der Kurssequenz',

   'Go to the previous resource in the course sequence'
=> 'Zurück', # long version: 'Gehe zur vorhergehenden Ressource in der Kurssequenz',

   'Import a published document'
=> 'Importieren einer veröffentlichten Ressource',

   'Keyword(s)'
=> 'Schlüsselwörter',

   'Logged Out'
=> 'Abgemeldet',

   'MIME Type'
=> 'MIME-Typ',

   'Make notes and annotations about this resource'
=> 'Notizen', # long version: 'Notizen zu dieser Ressource erstellen',

   'The material is covered with sufficient depth'
=> 'Das Thema wird in ausreichender Tiefe behandelt',

   'Metadata Information'
=> 'Metadaten-Information',

   'My Personal Info'
=> 'Meine Über-mich-Seite',

   'Network-wide number of accesses (hits)'
=> 'Netzwerkweite Anzahl von Zugriffen ("Hits")',

   'Network-wide number of courses using resource'
=> 'Netzwerkweite Anzahl von Kursen, die diese Ressource verwenden',

   'Number of resources that follow this resource in maps'
=> 'Anzahl der Ressourcen, die in Inhaltszusammenstellungen Nachfolger zu dieser Ressource sind',

   'Number of resources that lead up to this resource in maps'
=> 'Anzahl der Ressourcen, die in Inhaltszusammenstellung Vorgänger zu dieser Ressource sind',

   'Number of resources using or importing resource'
=> 'Anzahl der Ressourcen, die diese Ressource verwenden oder importieren',

   'Obsolete'
=> 'Überholt',

   'Parent Directory'
=> 'Übergeordnetes Verzeichnis',

   'Project Information'
=> 'Projektinformation',

   'Publisher/Owner'
=> 'Herausgeber/Besitzer',

   'Publishing'
=> 'Veröffentlichung:',

   'Publishing [_1]'
=> 'Veröffentlichung: [_1]',

   'Resource Details'
=> 'Details über Ressource',

   'Link to Resource'
=> 'Link zur Ressource',

   'Searching for your resource will be based on the following metadata. Please provide as much data as possible.'
=> 'Suche nach Ihrer Ressource wird auf den folgenden Metadaten beruhen. Bitte machen Sie so viele Angaben wie möglich.',

   'Resource Publication'
=> 'Veröffentlichung von Ressourcen',

   'Resource is technically correct'
=> 'Die Ressource ist technisch in Ordnung',

   'Score Upload Form'
=> 'Formular zum Hochladen von Noten',

   'Select Map'
=> 'Inhaltszusammenstellung wählen',

   'Load Map'
=> 'Hochladen', # 'Lade Inhaltszusammenstellung',

   'Set a bookmark for this resource'
=> 'Lesezeichen setzen', # long version: 'Lesezeichen auf diese Ressource setzen',

   'Show all roles'
=> 'Alle Rollen anzeigen',

   'Special documents'
=> 'Spezielle Dokumente',

   'Subject'
=> 'Thema',

   'Successful Login'
=> 'Erfolgreich angemeldet',

   'Suggested Replacement for Obsolete File'
=> 'Vorgeschlagener Ersatz für überholte Datei',

   'Switching Role'
=> 'Benutzerrolle wechseln',

   'Target'
=> 'Ziel',

   'This syllabus can be publicly viewed at'
=> 'Dieser Kursüberblick kann öffentlich abgerufen werden unter',

   'Total number of students who have worked on this problem'
=> 'Gesamtzahl von Studierenden, die diese Aufgabe bearbeitet haben',

   'URLs To Include in Syllabus'
=> 'URLs, die in den Kursüberblick eingefügt werden sollen',

   'Upload a new main course document'
=> 'Externe Dokumente',

   'Upload a new supplemental course document'
=> 'Zusätzliche Kursdokumente',

   'User'
=> 'Benutzer',

   'Wrote Metadata'
=> 'Metadaten wurden geschrieben',

   'Your home server is '
=> 'Ihr Heimatserver ist ',

   'anno-'
=> 'Bemerk-',

   'announce'
=> 'ankündigen',

   'backward'
=> 'backward',

   'bookmark'
=> 'Lesezeichen',

   'chart'
=> 'Chart',

   'chat'
=> 'Chat',

   'close this window'
=> 'dieses Fenster schließen',

   'con-'
=> 'con-',

   'docs'
=> 'Dokus',

   'edit crs'
=> 'Bearbeite crs',

   'exit'
=> 'abmelden',

   'fas'
=> 'fas',

   'forward'
=> 'forward',

   'library'
=> 'Bibliothek',

   'log in again'
=> 'erneut anmelden',

   'my'
=> 'mein',

   'or'
=> 'oder',

   'Or'
=> 'oder',

   'parms'
=> 'parms',

   'prepare'
=> 'Vorbereiten',

   'printout'
=> 'Ausdruck',

   'resource'
=> 'Ressource',

   'roles'
=> 'Rollen',

   'search'
=> 'suche',

   'set'
=> 'setze',

   'space'
=> 'Bereich',

   'stats'
=> 'Statistiken',

   'struct'
=> 'Struktur',

   'switch'
=> 'wechsle',

   'tations'
=> 'ungen',

   'updated periodically'
=> 'regelmäßig aktualisiert',

   'user'
=> 'Benutzer',

   'visible to author and co-authors only'
=> 'nur für Autoren und Co-Autoren sichtbar',

   'All versions'
=> 'Alle Versionen',

   'Default Cataloging Information for Directory [_1]'
=> 'Voreingestellte Katalogisierungsdaten für das Verzeichnis [_1]',

   'Error Messages'
=> 'Fehlermeldungen',

   'Save Catalog Information'
=> 'Katalogisierungsdaten speichern',

   'Update Display'
=> 'Neu anzeigen',

   'Content changed'
=> 'Inhalt geändert',

   'Differences'
=> 'Unterschiede',

   'Last Week'
=> 'letzte Woche',

   'Modification Date'
=> 'Änderungsdatum',

   'Since Start of Course'
=> 'seit Anfang des Kurses',

   'Since Yesterday'
=> 'seit gestern',

   'Verify Course Documents'
=> 'Überprüfe Kursdokumente',

   'Version'
=> 'Version',

   'access denied'
=> 'Zugriff verweigert',

   'connection down'
=> 'Verbindung unterbrochen',

   'during the last'
=> 'während der letzten',

   'not found'
=> 'nicht gefunden',

   'warning(s)'
=> 'Warnung(en)',



#SYNC Mon Sep 29 11:02:04 2003

   'Advanced Catalog Search'
=> 'Erweiterte Katalog-Suche',

   'Advanced Search'
=> 'Erweiterte Suche',

   'Any Language'
=> 'Beliebige Sprache',

   'Any category'
=> 'Beliebige Kategorie',

   'Any copyright/distribution'
=> 'Beliebiges Copyright/Zugriffsrecht',

   'Broadcast Message to Course'
=> 'Broadcast-Nachricht senden', # 'Broadcast-Nachricht an gesamten Kurs senden',

   "Click to download or use your browser's Save Link function"
=> "Zum Speichern hier klicken oder 'Ziel speichern unter'-Funktion des Webbrowsers verwenden",

   'Close'
=> 'Schließen',

   'Compact View'
=> 'Kompaktansicht',

   'Detailed Citation View'
=> 'Detailierte Zitatansicht',

   'Distribute Messages from Uploaded File to Course'
=> 'Aus Datei Nachrichten erzeugen', # 'Verteile Nachrichten der hochgeladenen Datei an den Kurs',

   'Edit Catalog Information'
=> 'Bearbeite Katalogisierungsdaten',

   'Edit Content of a Map'
=> 'Bearbeite Inhalt der Inhaltszusammenstellung',

   'Edit Directory Catalog Information'
=> 'Bearbeite Verzeichnis der Katalogisierungsdaten',

   'Evaluate Resource'
=> 'Ressource evaluieren',

   'Failed Access to Construction Space'
=> 'Zugriff auf Konstruktionsbereich fehlgeschlagen',

   'Fielded Format'
=> 'In Felder aufgeteiltes Format',

   'File Category'
=> 'Dateikategorie',

   'Force publication of unmodified files'
=> 'veröffentliche auch ungeänderte Dateien',

   'Keywords'
=> 'Schlüsselwörter',

   'Last access'
=> 'Letzter Zugriff',

   'Last modified'
=> 'Letzte Änderungen',

   'Limit by copyright/distribution'
=> 'Durch Copyright/Zugriffsrechte einschränken',

   'Limit by language'
=> 'Durch Sprache einschränken',

   'Open'
=> 'Öffnen',

   'Per Page'
=> 'Pro Seite',

   'Printing Helper'
=> 'Hilfsprogramm zum Drucken',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Feedback, Kursdiskussion', # long version: 'Feedback geben oder an der Kursdiskussion zu dieser Ressource teilnehmen',

   'Provide my evaluation of this resource'
=> 'Ressource evaluieren', # long version: 'Diese Ressource evaluieren',

   'Publish'
=> 'Veröffentlichen',

   'Publish Directory'
=> 'Verzeichnis veröffentlichen',

   'Publish Directory and Sub Directories'
=> 'Veröffentliche Verzeichnis und Unterverzeichnisse',

   'Related'
=> 'Verwandte',

   'Resource Feedback and Discussion'
=> 'Feedback und Diskussion zu dieser Ressource',

   'Search Complete'
=> 'Suche beendet',

   'Send Message to User(s)'
=> 'Nachricht senden', # 'Nachricht an einzelne(n) Benutzer senden',

   'Show catalog information'
=> 'Katalogisierungsdaten', # long version: 'Katalogisierungsdaten anzeigen',

   'Show resource'
=> 'Zeige Ressource an',

   'Statistics'
=> 'Statistiken',

   'Summary View'
=> 'Zusammenfassung',

   'There are currently no results'
=> 'Derzeit noch keine Ergebnisse',

   'Search: '
=> 'Suche: ',

   'URL'
=> 'URL',

   'Unpublished'
=> 'unveröffentlicht',

   'Up'
=> 'Hoch',

   'View'
=> 'Betrachten',

   'View Critical Messages'
=> 'Wichtige Nachrichten ansehen',

   'Words'
=> 'Wörter',

   'XML/SGML'
=> 'XML/SGML',

   'abstract'
=> 'Kurzbeschreibung',

   'audio'
=> 'Audio',

   'author'
=> 'Autor',

   'catalog'
=> 'katalog',

   'copyright'
=> 'Copyright',

   'customdistributionfile'
=> 'customdistributionfile',

   'directory'
=> 'Verzeichnis',

   'discuss'
=> 'Diskutiere',

   'evaluate'
=> 'Auswerten',

   'feedback'
=> 'Feedback',

   'info'
=> 'Info',

   'keywords'
=> 'Schlüsselwörter',

   'language'
=> 'Sprache',

   'movies'
=> 'Filme',

   'notes'
=> 'Notizen',

   'obsolete'
=> 'überholt',

   'obsoletereplacement'
=> 'obsoletereplacement',

   'pages'
=> 'Seiten',

   'pictures'
=> 'Bilder',

   'problem'
=> 'Aufgabe',

   'resources'
=> 'Ressourcen',

   'sequence'
=> 'Sequenz',

   'subject'
=> 'Thema',

   'this'
=> 'Diese',

   'title'
=> 'Titel',


#SYNC Sat Oct  4 20:36:34 2003
   'About Me'
=> 'Über mich',

   'Bulletin Board/Discussion'
=> 'Schwarzes Brett / Diskussionsforum',

   'Clear All'
=> 'Lösche alle',

   'Close All Folders'
=> 'Schließe alle Verzeichnisse',

   'Construction Space File Operation'
=> 'Dateioperation im Konstruktionsbereich',

   'Contact Information'
=> 'Kontaktdaten',

   'Copied old metadata'
=> 'Alte Metadaten kopiert',

   'Failed to write old metadata copy'
=> 'Kopie der alten Metadaten konnte nicht geschrieben werden',

   'Copied old target file'
=> 'Alte Zieldatei kopiert',

   'Failed to copy old target'
=> 'Alte Zieldatei konnte nicht kopiert werden.',

   'Created directory'
=> 'Verzeichnis wurde angelegt',

   'Copyright'
=> 'Copyright',

   'Could Not Process Request'
=> 'Befehl konnte nicht ausgeführt werden',

   'Default'
=> 'Voreinstellung',

   'Discard Selected'
=> 'Verwerfe ausgewählte',

   'EMail and Messages'
=> 'E-Mail und Nachrichten',

   'Edit this resource'
=> 'Bearbeiten', # long version: 'Bearbeite diese Ressource',

   'Enter construction space as co-author'
=> 'Konstruktionsbereich (als Co-Autor)',

   'Enter construction space as a co-author'
=> 'Konstruktionsbereich (als Co-Autor)',

   'Enter construction space as assistant co-author'
=> 'Konstruktionsbereich (als Co-Autor-Assistent)',

   'Host'
=> 'Rechner',

   'Last updated'
=> 'Zuletzt aktualisiert',

   'Mime type'
=> 'MIME Typ',

   'Modified'
=> 'geändert',

   'Modify deadlines, etc, for this assessment resource'
=> 'Bearbeite Fälligkeitsdaten, etc. für diese Beurteilungs-Ressource',

   'Modify user grades for this assessment resource'
=> 'Manuelle Bewertung', # 'Bearbeite die Noten des Benutzers für diese Beurteilungs-Ressource',

   'Move Down'
=> 'Nach unten',

   'Move Up'
=> 'Nach oben',

   'New Title'
=> 'Neuer Titel',

   'Open All Folders'
=> 'Öffne alle Verzeichnisse',

   'Owner/Publisher'
=> 'Besitzer/Herausgeber',

   'Personal Information'
=> 'Persönliche Informationen',

   'Privacy Note'
=> 'Hinweis zur Privatssphäre',

   'Published'
=> 'veröffentlicht',

   'Reading results from'
=> 'Lese Ergebnisse von',

   'Retrieve'
=> 'Wiederherstellen',

   'Revert to Last Saved'
=> 'Gehe zur letzten gespeicherten Version',

   'Revision Date'
=> 'Änderungsdatum',

   'Shared by course faculty and staff'
=> 'Gemeinsam für Kursverwaltung und Personal',

   'Save'
=> 'Speichern',

   'Synchronized SQL metadata database'
=> 'SQL Metadaten-Datenbank synchronisiert',

   'Task'
=> 'Aufgabe',

   'Temporary Assembly Workspace'
=> 'Temporärer Gruppenarbeitsbereich',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'Die Daten, die Sie hier bereitstellen, können von jeder Person, die in LON-CAPA angemeldet ist, eingesehen werden. Geben Sie daher keine Daten an, die Sie hier nicht öffentlich machen wollen.',

   'Topic'
=> 'Thema',

   'Upload a Photo'
=> 'Foto hochladen',

   'User Notes, Face-to-Face, Critical Messages, Broadcast Messages, Archived Messages'
=> 'Benutzeranmerkungen, persönliche Diskussionsbeiträge, wichtige Nachrichten, Broadcast-Nachrichten, Archivierte Nachrichten',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'Benutzeranmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen und wichtige Nachrichten',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'Benutzeranmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen und wichtige Nachrichten für den Kurs',

   'User Notes, Records of Face-To-Face Discussions, Critical Messages, Broadcast Messages and Archived Messages in Course'
=> 'Benutzeranmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen, wichtige Nachrichten, Broadcast-Nachrichten und archivierte Nachrichten für den Kurs',

   'No notes, face-to-face discussion records, critical messages, or broadcast messages in this [_1].'
=> 'Für diesen [_1] existieren keine Benutzer-Anmerkungen, Aufzeichnungen von Face-to-face-Diskussionsbeiträgen, wichtige Nachrichten oder Broadcast-Nachrichten.',

   'No notes, face-to-face discussion records, critical messages or broadcast messages in this [_1].'
=> 'Für diesen [_1] existieren keine Benutzer-Anmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen, wichtige Nachrichten oder Broadcast-Nachrichten.',

   'Version Number'
=> 'Versionsnummer',

   'View Published Version'
=> 'Veröffentlichte Version betrachten',

   'View user submissions for this assessment resource'
=> 'Betrachte Benutzer-Einreichungen für diese Beurteilungs-Ressource',

   'Web References'
=> 'Webreferenzen',

   'co con-'
=> 'Co-Kon-',

   'co res'
=> 'co-res',

   'contacting'
=> 'kontaktiere',

   'edit'
=> 'Bearbeite',

   'interface available'
=> 'Oberflächensprache verfügbar',

   'missions'
=> 'Aufgaben',

   'view sub-'
=> 'Betrachte Unter-',

   'waiting on'
=> 'warte auf',


#SYNC Wed Oct  8 14:13:34 2003
   '#Stdnts'
=> 'Anzahl Stud.',

   '#YES'
=> 'Anzahl Ja',

   '%Wrng'
=> '%Wrng',

   'Brief view of each students performance in course.'
=> 'Kurze Übersicht der Leistungen eines jeden Studenten im Kurs.',

   'Clear Caches'
=> 'Cache löschen',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Kurs-Statistiken und -Diagramme können solange nicht empfangen werden, bis die Datenbank neu gestartet wurde. Ihre Daten sind vorhanden, können aber zu diesem Zeitpunkt nicht angezeigt werden.',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Ausführliche Statistiken und Graphen der studentischen Leistung hinsichtlich der Aufgaben',

   'DoDiff'
=> 'Verwende diff',

   'Enrollment Status'
=> 'Kursbelegungs-Status',

   'Generate Statistics'
=> 'Erzeuge Statistiken',

   'Max Tries'
=> 'Max. Anz. an Vers.',

   'Mean Tries'
=> 'Mittl. Anz. Vers.',

   'Output'
=> 'Ausgabe',

   'Overall Problem Statistics'
=> 'Insgesamte Aufgabenstatistik',

   'Please notify the server administrator '
=> 'Benachrichtigen Sie bitte den Server-Administrator ',

   'Please select a report to generate.'
=> 'Wählen Sie bitte einen Bericht, den Sie erstellen möchten.',

   'Preparing Excel Spreadsheet'
=> 'Erstelle Excel-Tabelle',

   'Problem Status Chart'
=> 'Aufgabenstatus-Diagramm',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Es traten Probleme beim Erstellen der neuen Excel-Datei auf. Dieser Fehler wurde mitgeloggt. Bitte benachrichtigen Sie Ihren LON-CAPA-Administrator.',

   'S.D. tries'
=> 'S.D. Versuche',

   'Sections'
=> 'Sektionen',

   'Sequence or Folder'
=> 'Sequenz oder Verzeichnis',

   'Sequences and Folders'
=> 'Sequenzen und Verzeichnisse',

   'Skew Tries'
=> 'Schiefe d. Vers.',

   'Statistics and Problem Analysis'
=> 'Statistiken und Aufgabenanalysen',

   'Student performance statistics on all problems.'
=> 'Statistik studentischer Leistungen hinsichtlich aller Aufgaben',

   'Unable to connect to database!'
=> 'Verbindungsaufbau zur Datenbank nicht möglich!',

   'Your Excel Spreadsheet'
=> 'Ihre Excel-Tabelle',

   'part'
=> 'Aufgabenteil',

   'part - '
=> 'Teil ',

   'problem statistics grouped by sequence'
=> 'Aufgabenstatistiken, gruppiert nach Sequenz',

   'problem statistics ungrouped'
=> 'Aufgabenstatistiken, nicht gruppiert',

   'problem statistics, Excel'
=> 'Aufgabenstatistiken, Excel',

#SYNC Wed Oct  8 14:49:53 2003
   'Significant figures are incorrect, submission was not graded.'
=> 'Die Anzahl der signifikanten Stellen ist inkorrekt. Dieser Versuch wurde nicht gezählt.',



#SYNC Fri Oct 10 11:36:26 2003
   '. . . for a particular section'
=> '. . . für eine bestimmte Sektion',

   '. . . for all students in the course'
=> '. . . für alle Studenten im Kurs',

   '. . . for an individual student'
=> '. . . für einen bestimmten Studenten',

   '1 am'
=> '1',

   '1 pm'
=> '13',

   '10 am'
=> '10',

   '10 pm'
=> '22',

   '11 am'
=> '11',

   '11 pm'
=> '23',

   '12 am'
=> '00',

   '12 noon'
=> '12',

   '2 am'
=> '2',

   '2 pm'
=> '14',

   '3 am'
=> '3',

   '3 pm'
=> '15',

   '4 am'
=> '4',

   '4 pm'
=> '16',

   '5 am'
=> '5',

   '5 pm'
=> '17',

   '6 am'
=> '6',

   '6 pm'
=> '18',

   '7 am'
=> '7',

   '7 pm'
=> '19',

   '8 am'
=> '8',

   '8 pm'
=> '20',

   '9 am'
=> '9',

   '9 pm'
=> '21',

   '<- Previous'
=> '<- Zurück',

   'ALL'
=> 'ALLE',

   'All Maps or Folders'
=> 'Alle Inhaltszusammenstellungen oder Verzeichnisse',

   'Any User'
=> 'Jeder Benutzer',

   'Assessment URL and Title'
=> 'Beurteilungs-URL und -Titel',

   'Assigned User Roles'
=> 'Zugewiesene Benutzerrollen',

   'Browse resources'
=> 'Durchsuche Ressourcen',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Es kann bis zu 10 Minuten dauern, bis diese Änderungen für alle Studierenden aktiviert worden sind.',

   'Course Assessment Parameter - Helper Mode'
=> 'Parameter zur Kursbeurteilung - Hilfsmodus',

   'Course Assessment Parameters - Overview Mode'
=> 'Parameter zur Kursbeurteilung - Übersichtsmodus',

   'Course Assessments Parameters - Table Mode'
=> 'Parameter zur Kursbeurteilung - Tabellenmodus',

   'Course Environment Parameters'
=> 'Kursumgebungsparameter',

   'Course Parameter Helper'
=> 'Kursparameter-Hilfsprogramm',

   'Create New Environment Variable'
=> 'Neue Umgebungsvariable erstellen',

   'Current Session Value'
=> 'Wert für diese Sitzung',

   'Default Value'
=> 'Voreingestellter Wert',

   'Delete a role'
=> 'Rolle löschen',

   'Disable all communication among students'
=> 'Unterbinden jeglicher Kommunikation zwischen Studenten',

   'Enclosing Map or Folder'
=> 'Eingeschlossene(s) Inhaltszusammenstellung oder Verzeichnis',

   'Every problem in a particular folder'
=> 'Jede Aufgabe in einem bestimmten Verzeichnis',

   'Every problem in the course'
=> 'Jede Aufgabe im Kurs',

   'Folder'
=> 'Verzeichnis',

   'For User'
=> 'Für Benutzer',

   'Grant/revoke Course Custom Role'
=> 'Vergebe/entziehe benutzerdefinierte Kursrolle',

   'Grant/revoke role of Administrator'
=> 'Vergebe/entziehe Rolle des Administrators',

   'Grant/revoke role of Author'
=> 'Vergebe/entziehe Rolle des Autors',

   'Grant/revoke role of Course Coordinator'
=> 'Vergebe/entziehe Rolle des Kurs-Koordinators',

   'Grant/revoke role of Domain Guest'
=> 'Vergebe/entziehe Rolle des Domänengasts',

   'Grant/revoke role of Librarian'
=> 'Vergebe/entziehe Rolle des Bibliothekars',

   'Grant/revoke role of Teaching Assistant'
=> 'Vergebe/entziehe Rolle des Tutors',

   'Internally authenticated'
=> 'Intern authentifiziert',

   'Kerberos authenticated'
=> 'Kerberos-authentifiziert',

   'LON-CAPA Helper:'
=> 'LON-CAPA-Hilfsprogramm:',

   'Lock and unlock assessments'
=> 'Sperren und Entsperren von Beurteilungen',

   'Manage Access Keys'
=> 'Zugriffsschlüssel verwalten',

   'Manage access keys'
=> 'Zugriffsschlüssel verwalten',

   'Max Possible To Date'
=> 'Bis jetzt maximal erreichbar', 

   'Modify Course Assessment Parameters'
=> 'Bearbeite Parameter für die Kursbeurteilung',

   'Modify authentication mechanism and data for a user'
=> 'Bearbeite Authentifizierungs-Methode und Daten für einen Benutzer',

   'Modify grades'
=> 'Bewertungen ändern',

   'Next ->'
=> 'Weiter ->',

   'One particular problem'
=> 'Eine bestimmte Aufgabe',

   'Parameter Name'
=> 'Parametername',

   'Parameter Type'
=> 'Parametertyp',

   'Parameter in Effect'
=> 'Effektiver Parameter',

   'Please select a problem to analyze'
=> 'Wählen Sie die zu analysierende Aufgabe',

   'Post anonymously'
=> 'Anonym absenden',

   'Post discussion on course resources'
=> 'Diskussion zu den Ressourcen des Kurses absenden',

   'Post system frontpage announcements'
=> 'Sende Ankündigungen auf der Hauptseite des Systems',

   'Post to live chatrooms'
=> 'In die Live-Chatrooms senden',

   'Problems Not Contained In A Folder'
=> 'Aufgaben, die sich nicht in einem Verzeichnis befinden',

   'Quick Completed Problems Display'
=> 'Schnelle Ansicht der abgeschlossenen Aufgaben', #??? [SB 18.10.2006]

   'Section'
=> 'Sektion',

   'Select Date'
=> 'Datum auswählen',

   'Select Enclosing Map or Folder'
=> 'Eingeschlossene(s) Inhaltszusammenstellung oder Verzeichnis',

   'Select Parameter Level'
=> 'Parameter-Ebene',

   'Send internal email'
=> 'Verschicke interne Nachrichten',

   'Set Course Environment Parameters'
=> 'Setze Kursumgebungs-Parameter',

   'Set Date'
=> 'Setze Datum',

   'Set Defaults for All Resources in'
=> 'Setze voreingestellte Werte für alle Ressourcen im',

   'Set a due date'
=> 'Setze Fälligkeitsdatum',

   'Set an answer open date'
=> 'Setze Antwort-Verfügbarkeits-Datum',

   'Set an open date'
=> 'Setze eine Bearbeitungsbeginn-Datum',

   'Set opening datefor all problems in the course for. . .'
=> 'Setze Öffnungsdatum für alle Aufgaben im Kurs auf. . .',

   'Set the number of tries'
=> 'Setze Anzahl von Versuchen',

   'Set the problem weight'
=> 'Setze Aufgabengewicht',

   'Set/Modify Course Assessment Parameter'
=> 'Setze/Ändere Parameter zur Kursbeurteilung',

   'Set/Modify Course Assessment Parameters'
=> 'Setze/Ändere Parameter zur Kursbeurteilung',

   'Set/Modify Course Parameters'
=> 'Setze/Ändere Kursparameter',

   'Show More Options'
=> 'Zeige mehr Optionen',

   'Students Affected'
=> 'Betroffene Studierende',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'Dieses Hilfsprogramm wird Ihnen dabei helfen, das Datum für den Bearbeitungsbeginn, die Fälligkeit und die Antwort-Verfügbarkeit für Aufgaben zu setzen und die Anzahl der Versuche für Aufgaben festzulegen. Sie werden gefragt, für welche Aufgaben Sie die Parameter zu setzen wünschen, dann, welche Parameter Sie setzen möchten. Schließlich wählen Sie aus, wen diese Einstellungen betreffen. Nach Abschluss dieser Hilfeunterstützung wird Ihnen gezeigt, wo Sie in dem erweiterten Interface die Parameter setzen können, die Sie ausgewählt haben, damit Sie dies in Zukunft direkt erledigen können. Klicken Sie auf Weiter -&gt; um zu beginnen oder wählen Sie &lt;- Zurück, um zur vorherigen Seite zurückzukehren.',

   'Total'
=> 'Gesamt',

   'Total Parts In Course'
=> 'Gesamtanzahl an Aufgabenteilen in dem Kurs',

   'Type'
=> 'Typ',

   'UNIX authenticated'
=> 'UNIX authentifiziert',

   'USERS'
=> 'BENUTZER',

   'Unknown ID'
=> 'Unbekannte ID',

   'Unknown user'
=> 'Unbekannter Benutzer',

   'Update Course Assessment Parameter Display'
=> 'Aktualisiere die Anzeige der Parameter zur Kursbeurteilung',

   'Update Section or Specific User'
=> 'Aktualisiere Sektion oder bestimmten Benutzer',

   'Verify Selection'
=> 'Überprüfe Auswahl',

   'Welcome to the Assignment Parameter Helper'
=> 'Willkommen zum Hilfsprogramm für Übungs-Parameter',

   'What parameter do you want to set for all problems in the course?'
=> 'Welche Parameter möchten Sie für alle Aufgaben in dem Kurs setzen?',

   'What should the opening date be set to?'
=> 'Auf wann soll das Öffnungsdatum gesetzt werden?',

   'Which Problem or Problems?'
=> 'Welche Aufgabe oder Aufgaben?',

   'Which problems do you wish to set a parameter for?'
=> 'Für welche Aufgaben möchten Sie die Parameter setzen?',

   'You need to choose another user role or enter a specific course for this function'
=> 'Für die angeforderte Seite müssen Sie eine andere Benutzerrolle wählen oder einen bestimmten Kurs betreten.',

   'a.m.'
=> 'vorm.',

   'acc keys'
=> 'Zugr.-Schlüssel',

   'according to course preferences'
=> 'nach den Kurseinstellungen',

   'according to resource settings'
=> 'nach den Ressourceneinstellungen',

   'according to user session state'
=> 'nach dem Status der Benutzersitzung',

   'all'
=> 'alle',

   'at'
=> 'in',

   'at Domain'
=> 'in Domäne',

   'at domain'
=> 'in Domäne',

   'default'
=> 'voreingestellt',

   'for Enclosing Map or Folder'
=> 'für eingeschlossene(s) Inhaltszusammenstellung oder Verzeichnis', #??? [SB 18.10.2006]

   'for Resource'
=> 'für Ressource',

   'from Enclosing Map or Folder'
=> 'aus eingeschlossener/m Inhaltszusammenstellung oder Verzeichnis', #??? [SB 18.10.2006]

   'general'
=> 'generell',

   'in Course'
=> 'in Kurs',

   'in Section/Group'
=> 'in Sektion/Gruppe',

   'manage'
=> 'verwalte',

   'midnight'
=> 'Mitternacht',

   'noon'
=> 'Mittag',

   'num_override'
=> 'num_override',

   'of'
=> 'von',

   'or ID'
=> 'oder ID',

   'p.m.'
=> 'nachm.',

   'percent'
=> 'Prozent',

   'unless locked'
=> 'falls nicht gesperrt',

   'users in'
=> 'Benutzer in',


#SYNC Tue Oct 14 14:28:20 2003

   'Access Key Management'
=> 'Zugriffsschlüssel-Verwaltung',

   'Assessment'
=> 'Beurteilung',

   'Calculations'
=> 'Berechnungen',

   'Comma Separated Values'
=> 'CSV (kommaseparierte Liste)',

   'Course ID'
=> 'Kurs-ID',

   'Course level sheet'   
=> 'Kurs-Level-Bogen', # ??? [SB 2007-07-02]

   'Detailed Problem Analysis'
=> 'Detaillierte Aufgabenanalyse',

   'End Helper'
=> 'Hilfsprogramm beenden',

   'Excel'
=> 'Excel',

   'Finish Course Initialization'
=> 'Beende Kursinitialisierung',

   'Generate Spreadsheet'
=> 'Erzeuge Beurteilungsbogen',

   'Grant/revoke role of Scantron Operator'
=> 'Vergebe/entziehe Rolle des Scantron-Operators',

   'HTML'
=> 'HTML',

   'Invalid date entry'
=> 'Ungültiger Datumseintrag',

   'Load:'
=> 'Lade:',

   'No changes were made to the current settings.'
=> 'An den derzeitigen Einstellungen wurden keine Veränderungen vorgenommen.',

   'Output Format'
=> 'Ausgabeformat',

   'Processing course structure'
=> 'Kursstruktur verarbeiten',

   'Processing first student'
=> 'Für ersten Studierenden berechnen',

   'Row'
=> 'Reihe',

   'Save as'
=> 'Speichere unter',

   'Save as & Make This Sheet the Default'
=> 'Speichern unter und diesen Beurteilungsbogen als Voreinstellung verwenden',

   'Scantron Operator'
=> 'Scantron-Operator',

   'Select All'
=> 'Alle auswählen',

   'Select All Students'
=> 'Wähle alle Studierenden',

   'Select Spreadsheet File'
=> 'Beurteilungsbogen-Datei auswählen',

   'Send Scantron data to a course'
=> 'Scantron-Daten an einen Kurs senden',

   'Spreadsheet Computation'
=> 'Beurteilungsbogen berechnen',

   'Spreadsheet Computation Status'
=> 'Status der Beurteilungsbogen-Berechnungen',

   'Student level sheet'
=> 'Studierdenden-Level-Bogen',

   'Summary'
=> 'Zusammenfassung',

   'Template'
=> 'Vorlage',

   'Unselect All'
=> 'Auswahl komplett aufheben', # 'Alle deselektieren',

   'Unselect All Students'
=> 'Alle Studenten deselektieren',

   'Upload Scantron data'
=> 'Scantron-Daten hochladen',

   'You must choose at least one student to continue.'
=> 'Zum Fortfahren müssen Sie mindestens einen Studierenden auswählen.',

   'You must choose one or more choices to continue.'
=> 'Zum Fortfahren müssen Sie mindestens eine oder mehrere Auswahlen treffen.',

   'last student'
=> 'letzten Studierenden',

   'may be open from a different computer.'
=> 'könnte von einem anderen Computer aus geöffnet sein.',

   'minutes'
=> 'Minuten',

   'remaining'
=> 'übrig',

   'second'
=> 'Sekunde',

   'seconds'
=> 'Sekunden',

   'seconds for'
=> 'Sekunden für',

#SYNC Wed Oct 15 20:34:21 2003
   'Additional Recipients'
=> 'Weitere Empfänger',

   'Analyze Over '
=> 'Analyse über ',

   'Analyze Problem'
=> 'Analysiere Aufgabe',

   'Analyze Problem Again'
=> 'Aufgabe erneut analysieren',

   'Analyze as '
=> 'Analysiere als ',

   'Browsing resource, all submissions are temporary.'
=> 'Eingereichte Antworten werden nicht gespeichert.',

   'By'
=> 'Von',

   'Check All'
=> 'Alle auswählen',

   'Check for All'
=> 'Überprüfe für alle',

   'Check for None'
=> 'Überprüfe für nichts',

   'Check for Section/Group'
=> 'Überprüfe für Sektion/Gruppe',

   'Choose a different resource'
=> 'Eine andere Ressource auswählen',

   'Concepts'
=> 'Konzepte',

   'Critical Messages'
=> 'Wichtige Nachrichten',

   'Delete'
=> 'Löschen',

   'Delete Checked'
=> 'Ausgewählte löschen',

   'Display All Messages'
=> 'Alle Nachrichten anzeigen',

   'Display all Messages'
=> 'Alle Nachrichten anzeigen',

   'Foils'
=> 'Auswahlmöglichkeiten',

   'Forward'
=> 'Weiterleiten',

   'Forwarded message from'
=> 'Weitergeleitete Nachricht von',

   'Forwarding'
=> 'Weiterleitung',

   'From'
=> 'Von',

   'Functions'
=> 'Funktionen',

   'Mail'
=> 'Nachricht',

   'Mark Unread'
=> 'Als ungelesen kennzeichnen',

   'New Problem Variation'
=> 'Neue Aufgabenvariation',

   'New Randomization'
=> 'Neue Variation',

   'Next'
=> 'Weiter',

   'Number of Plots:'
=> 'Anzahl an Graphen:',

   'Option Response Problem Analysis'
=> 'Analyse von option response-Aufgabe',

   'Previous'
=> 'Vorherig',

   'Re'
=> 'Antw',

   'Record'
=> 'Eintrag',

   'Reply'
=> 'Antworten',

   'Reset Submissions'
=> 'Einreichungen zurücksetzen',

   'Select a course'
=> 'Kurs auswählen',

   'Selecting a User'
=> 'Benutzer auswählen',

   'Send New'
=> 'Sende neue',

   'Send Reply'
=> 'Sende Antwort',

   'Send as critical message'
=> 'Sende als wichtige Nachricht',

   'Simple Problem Editor'
=> 'Einfacher Aufgabeneditor',

   'Starting'
=> 'Starte',

   'Student Data Compilation Progress'
=> 'Kompilierungsfortschritt der studentischen Daten',

   'Student Data Compilation Status'
=> 'Kompilierungsstatus der studentischen Daten',

   'There is no student data for this problem.'
=> 'Für diese Aufgabe existieren keine studentischen Daten.',

   'Time'
=> 'Zeit',

   'To'
=> 'An',

   'Uncheck All'
=> 'Gesamte Auswahl aufheben',

   'Unsuccessful Login'
=> 'Login fehlgeschlagen',

   'Update Student Data'
=> 'Aktualisiere Studentendaten',

   'You have no critical messages.'
=> 'Sie haben keine wichtigen Nachrichten.',

   'and return receipt'
=> 'mit Empfangsbestätigung',

   'can not be accessed from your location.'
=> 'kann von Ihrer Position aus nicht aufgerufen werden.',


#SYNC Fri Nov  7 16:59:44 2003

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Kursbelegung nicht möglich für [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Kursbelegung nicht möglich. Kein Passwort angegeben.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Unzulässiger Benutzername für den Benutzer [_2] [_3] [_4] [_5]',

   'All Documents in Course'
=> 'Alle Ressourcen im Kurs',

   'All Resources (possibly large output)'
=> 'Alle Ressourcen (möglicherweise lange Ausgabe)',

   'Anonymous'
=> 'Anonym',

   'Anonymous contribution to course discussion of resource'
=> 'Anonyme Teilnahme an der Kursdiskussion über diese Ressource',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'Generell sollten nur Autoren und Co-Autoren über das Dateisystem authentifiziert sein (erlaubt Zugriff auf das Server-Dateisystem).',

   'Associate columns with student attributes.'
=> 'Verknüpfung der Spalten aus der Datei mit den studentischen Eigenschaftsfeldern',

   'Attribute'
=> 'Eigenschaft',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (komma-separierte Liste, Tabelle)',

   'Check Course Document Versions'
=> 'Überprüfe Versionen der Kursdokumente',

   'Check/Set Resource Versions'
=> 'Versionen einstellen',

   'Chronological View'
=> 'Chronologische Sicht',

   'Column'
=> 'Spalte',

   'Column&nbsp;[_1]'
=> 'Spalte&nbsp;[_1]',

   'Column [_1]'
=> 'Spalte [_1]',

   'Continue enrollment?'
=> 'Trotzdem mit der Kursbelegung fortfahren?',

   'Contribution to course discussion of resource'
=> 'Normale Teilnahme an der Kursdiskussion über die Ressource',

   'Diffs'
=> 'Unterschiede',

#   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
#=> 'Deaktiviere ID-/Matrikelnummer-Safeguard und erzwinge Änderung von in Konflikt stehenden IDs (Machen Sie dies nur, wenn Sie wirklich wissen, was Sie tun).',


   'Disable Student/Employee ID Safeguard and force change of conflicting IDs'
=> 'Deaktiviere Studenten-/Mitarbeiter-ID-Safeguard und erzwinge Änderung von in Konflikt stehenden IDs.',

   '(only do if you know what you are doing.)'
=> '(Machen Sie dies nur, wenn Sie wirklich wissen, was Sie tun.)',

   'Discussion Contributions'
=> 'Diskussionsbeiträge',

   'Drop Students'
=> 'Studenten ausschließen',

   'Dropped [_1]'
=> '[_1] ausgeschlossen',

   'Dropped [_1] student(s).'
=> '[_1] Student(en) ausgeschlossen.',

   'Dropping Students'
=> 'Schließe Studenten aus',

   'Dump Course DOCS'
=> 'Kursdokumente ablegen', # n.t.

   'EMail Address'
=> 'E-Mail-Adresse',

   'Enroll a single student'
=> 'Einen einzelnen Studenten eintragen',

   'Enrolling Students'
=> 'Studenten werden in den Kurs aufgenommen',

   'Error'
=> 'Fehler',

   'Error: '
=> 'Fehler: ',

   'Error: [_1]'
=> 'Fehler: [_1]',

   'Error dropping [_1]:[_2]'
=> 'Fehler beim Ausschließen von [_1]:[_2]',

   'Field'
=> 'Feld',

   'Filenames in Construction Space'
=> 'Dateinamen im Konstruktionsbereich',

   'First Name'
=> 'Vorname',

   'Folder in Construction Space'
=> 'Verzeichnis im Konstruktionsbereich',

   'Full Update'
=> 'Vollständige Aktualisierung',

   'Full update (also print list of users not enrolled anymore)'
=> 'Vollständige Aktualisierung (auch Liste von Benutzern ausgeben, die den Kurs nicht mehr belegt haben)',

   'Generation'
=> 'Generation',

   'Group/Section'
=> 'Gruppe/Sektion',

   'HTML/XML'
=> 'HTML/XML',

   'Hide'
=> 'Verbergen',

   'Student/Employee ID'
=> 'Studenten-/Mitarbeiter-ID',

   'Identify fields'
=> 'Identifiziere Felder',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'Falls aktiv, dann wird die neue Rolle verfügbar sein, wenn sich die Studenten das nächste Mal in LON-CAPA anmelden.',

   'Ignore First Line'
=> 'Erste Zeile nicht berücksichtigen',

   'Initial Password'
=> 'Anfangspasswort',

   'Internal Filename'
=> 'Interner Dateiname',

   'Invalid home server specified'
=> 'Ungültiger Heimatserver angegeben',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Alle Ressourcen immer mit den neuesten Versionen aktuell halten (voreingestellt)',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA-Domäne für Studierende',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA-Kursbelegungs-Verwaltung',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA-Domäne: [_1]',

   'Last Name'
=> 'Nachname',

   'Last Name, First Names'
=> 'Nachname, Vornamen',

   'Login Type'
=> 'Login-Typ',

   'Middle Names/Initials'
=> 'Zweiter Vorname/Initialen',

   'Modify Parameters'
=> 'Parameter ändern',

   'Modify student data'
=> 'Bearbeite Studentendaten',

   'Most recently published Version'
=> 'Zuletzt veröffentlichte Version',

   'No Kerberos domain was specified.'
=> 'Es wurde keine Kerberos-Domäne angegeben.',

   'None Found'
=> 'Kein gefunden',

   'Note: for large courses, this operation may be time consuming'
=> 'Anmerkung: Für große Kurse kann die Ausführung lange dauern.',

   'Note: this will not take effect if the user already exists'
=> 'Anmerkung: Diese Einstellung bleibt ohne Wirkung, falls der Benutzer bereits existiert.',

   'Processed [_1] student(s).'
=> '[_1] Studierende bearbeitet.',

   'Re-enrollment will re-activate data.'
=> 'Eine erneute Kursbelegung würde die Daten reaktivieren.',

   'Registering'
=> 'Registriere',

   'Samples'
=> 'Beispiele',

   'Save as ...'
=> 'Speichern unter...',

   'Set Version to be used in Course'
=> 'Setze Version als die im Kurs genutzte',

   'Set Versions to be used in Course according to Selections below'
=> 'Versionen gemäß der unten getroffenen Auswahlen einstellen',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Alle Ressourcen auf die derzeitige Version festsetzen',

   'Show Preview'
=> 'Zeige Vorschau',

   'Space separated'
=> 'Durch Leerzeichen getrennt',

   'Starting and Ending Dates'
=> 'Anfangs- und Endezeitpunkte',

   'Student Number'
=> 'Matrikelnummer',

   'Tabulator separated'
=> 'Durch Tabulatoren getrennt',

   'The optional email address field was not specified.'
=> 'Das optionale E-Mail-Adress-Feld wurde nicht ausgefüllt.',

   'The optional name field was not specified.'
=> 'Das optionale Namensfeld wurde nicht ausgefüllt.',

   'The optional ID number field was not specified.'
=> 'Das optionale Matrikelnummer-Feld wurde nicht ausgefüllt.',

   'The optional section or group field was not specified.'
=> 'Das optionale Sektions- oder Gruppenfeld wurde nicht ausgefüllt.',

   'The optional student number field was not specified.'
=> 'Das optionale Matrikelnummer-Feld wurde nicht ausgefüllt.',

   'The optional section field was not specified.'
=> 'Das optionale Sektionsfeld wurde nicht ausgefüllt.',

   'The optional role field was not specified.'
=> 'Das optionale Rollenfeld wurde nicht ausgefüllt.',

   'The optional domain field was not specified.'
=> 'Das optionale Domänenfeld wurde nicht ausgefüllt.',

   'There are no students currently enrolled.'
=> 'Derzeit haben keine Studierenden den Kurs belegt.',

   'Continue adding users?'
=> 'Mit dem Hinzufügen von Benutzern fortfahren?',

   'Threaded View'
=> 'Thread-Ansicht',

   'Total number of records found in file: [_1].'
=> 'Gesamtanzahl an Datensätzen, die in der Datei gefunden wurden: [_1].',

   'Total number of records found in file: <b>[_1]</b>.'
=> 'Gesamtanzahl an Datensätzen, die in der Datei gefunden wurden: <b>[_1]</b>.',

   'Unable to enroll students'
=> 'Konnte Studenten nicht eintragen.',

   'Updating discussion time'
=> 'Aktualisiere Diskussionszeit',

   'Upload a class list'
=> 'Kursteilnehmerliste hochladen',

   'Uploading Class List'
=> 'Lade Kursteilnehmerliste hoch',

   'Verify Content'
=> 'Inhalte prüfen',

   'Version used in Course'
=> 'Version, die im Kurs verwendet wird',

   'View Class List'
=> 'Zeige Kursteilnehmerliste',

   'View Class list'
=> 'Kursteilnehmerliste anzeigen',

   'Welcome'
=> 'Willkommen',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up.'
=> 'Willkommen zu LON-CAPA. Bitte warten Sie, während Ihre Sitzung vorbereitet wird.',

   'You must choose an authentication type.'
=> 'Sie müssen einen Authentifizierungstyp auswählen.',

   'You need to specify the Kerberos domain.'
=> 'Sie müssen eine Kerberos-Domäne auswählen.',

   'You need to specify the initial password.'
=> 'Sie müssen ein initiales Passwort auswählen.',

   'You need to specify the username field.'
=> 'Sie müssen das Benutzernamen-Feld ausfüllen.',

   'Your Version Settings have been Saved'
=> 'Ihre Versionseinstellungen wurden gespeichert',

   '[_1] Do not change login data'
=> '[_1] Login-Daten nicht ändern',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5 [_5]'
=> '[_1] Kerberos-authentifiziert mit Domäne [_2] [_3] Version 4 [_4] Version 5 [_5]',

   'Currently Kerberos authenticated with domain [_1] Version [_2].'
=> 'Derzeit Kerberos-authentifiziert mit Domäne [_1] Version [_2].',

   'Currently Kerberos authenticated, Version [_1].'
=> 'Derzeit Kerberos-authentifiziert, Version [_1].',

   'most recent'
=> 'neuester',

   'name only visible to course faculty'
=> 'Name nur für Kursverwaltung sichtbar',



#SYNC Fri Nov  7 22:00:17 2003
   'Calculate answers'
=> 'Berechne Antworten',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Zeige&nbsp;alle&nbsp;Auswahlmöglichkeiten',

   '1 out of N multiple choice (radio button)'
=> '1-aus-N-Auswahl (radio button)',

   'Add new option'
=> 'Neue Option einfügen',

   'Administrator'
=> 'Administrator',

   'Answer:'
=> 'Antwort:',

   'Attachment'
=> 'Anhang',

   'Change'
=> 'Ändern',

   'Change Random Seed To:'
=> 'Zufallszahlen-Basis:',

   'Change Your Language Preferences'
=> 'Ändere Spracheinstellungen',

   'Concept:'
=> 'Konzept:',

   'Correct Option:'
=> 'Korrekte Auswahl:',

   'Create a New Course'
# => 'Erzeuge einen neuen Kurs',
=> 'Kurse erstellen',

   'Create a New Course or Group Space'
=> 'Einen neuen Kurs oder neuen Gruppenbereich erstellen',

   'Current'
=> 'Derzeitig',

   'Delete an option'
=> 'Eine Option löschen',

   'Delete:'
=> 'Löschen:',

   'Diffs with Current Version'
=> 'Unterschiede zur derzeitigen Version',

   'Diffs with Version'
=> 'Unterscheidet sich von Version',

   'Diffs with current Version'
=> 'Unterschiede zur derzeitigen Version',

   'Display and analysis of submission times on assessments.'
=> 'Anzeige und Analyse der Einreichungszeiten in Beurteilungen',

   'Display foils in order given'
=> 'Auswahlmöglichkeiten in gegebener Sortierung anzeigen',

   'Display foils in random order'
=> 'Auswahlmöglichkeiten in zufälliger Reihenfolge anzeigen',

   'Domain Guest'
=> 'Domänengast',

   'Essay, open end'
=> 'Essay, keine Zeitbegrenzung',

   'False'
=> 'Falsch',

   'Foil'
=> 'Auswahlmöglichkeit',

   'Format:'
=> 'Format:',

   'Height(pixel):'
=> 'Höhe (Pixel):',

   'Hint Text'
=> 'Lösungshinweis',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'Wenn diese Ressource in Benutzung ist, ist es möglich, dass auf Leistungsdaten der Studenten von vorhergehenden Versionen nicht mehr zugegriffen werden kann.',

   'Image:'
=> 'Bild:',

   'Incorrect Answers:'
=> 'Falsche Antworten:',

   'Last accessed'
=> 'Letzter Zugriff',

   'Librarian'
=> 'Bibliothekar',

   'Making Backup to [_1]'
=> 'Erstelle Sicherungsdatei in [_1]',

   'Max Number Of Shown Foils:'
=> 'Maximale Anzahl anzuzeigender Auswahlmöglichkeiten:',

   'Max number of foils displayed'
=> 'Maximale Anzahl gezeigter Auswahlmöglichkeiten',

   'Metadata'
=> 'Metadaten',

   'metadata'
=> 'Metadaten',

   'Metadata Version'
=> 'Metadaten-Version',

   'Metadata current version'
=> 'Derzeitige Version der Metadaten',

   'Name:'
=> 'Name:',

   'New parameters or saved values'
=> 'Neue Parameter oder gespeicherte Werte',

   'No language preference'
=> 'Keine Sprachpräferenz',

   'Not shown, not used'
=> 'Nicht gezeigt, nicht benutzt',

   'Obsolete parameters or saved values'
=> 'Veraltete Parameter oder gespeicherte Werte',

   'Option response'
=> 'Option Antwort',

   'Please do not reply to this address.'
=> 'Bitte antworten Sie nicht an diese Adresse.',

   'Please select a report to generate'
=> 'Bitte wählen Sie einen Bericht zum Erstellen aus',

   'Position'
=> 'Position',

   'Preferred language'
=> 'Bevorzugte Sprache',

   'Problems'
=> 'Probleme',

   'Produce Excel Output'
=> 'Erstelle Excel-Ausgabe',

   'Question Text'
=> 'Fragetext',

   'Question Type'
=> 'Aufgabentyp',

   'Random position'
=> 'Zufällige Position',

   'Retrieve Published Resources'
=> 'Veröffentlichte Ressourcen wiederherstellen',

   'Short string response'
=> 'Kurze Textantwort',

   'Show always at bottom position'
=> 'Immer am Ende anzeigen',

   'Show always at top position'
=> 'Immer am Anfang anzeigen',

   'Size:'
=> 'Größe:',

   'Save Changes'
=> 'Änderungen speichern',

   'Submission Time Analysis'
=> 'Analyse der Einreichzeit',

   'Submit Changes and Edit'
=> 'Speichern und weiterbearbeiten',

   'TeXWidth(mm):'
=> 'TeX-Breite (mm):',

   'Text'
=> 'Text',

   'Text Block'
=> 'Textblock',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'Dies ist eine durch LON-CAPA automatisch erstellte Nachricht.',

   'True'
=> 'Wahr',

   'Type-in value'
=> 'eingebbarer Wert',

   'Unit:'
=> 'Einheit:',

   'Value'
=> 'Wert',

   'Warning!'
=> 'Achtung!',

   'Width(pixel):'
=> 'Breite (Pixel):',

   'anonymous'
=> 'anonym',

   'bytes'
=> 'Bytes',

   'loginproblems.html'
=> 'loginproblems.html',

   'versions of this problem'
=> 'Versionen von dieser Aufgabe',


# Begin remote control (mydesk.tab)
# 2x8 chars, only lower case
# Same order as in mydesk.tab!

   'choose[_1]'
=> 'wähle[_1]',
   'course[_1]'
=> 'kurs[_1]',

   'switch[_1]'
=> 'wechsle[_1]',
   'course[_2]'
=> 'kurs[_2]',

   'switch[_2]'
=> 'wechsle[_2]',
   'role[_1]'
=> 'rolle[_1]',

   'choose[_2]'
=> 'wähle[_2]',
   'role[_2]'
=> 'rolle[_2]',

   'course[_3]'
=> 'kurs-[_3]',
   'docs[_1]'
=> 'inhalt[_1]',

   'edit crs[_1]'
=> 'bearb[_1]',
   'docs[_2]'
=> 'kursdok[_2]',

   'navigate[_1]'
=> 'inhalts-[_1]',
   'contents[_1]'
=> 'verz[_1]',

   'my[_1]'
=> 'meine[_1]',
   'grades[_1]'
=> 'bewert[_1]',

   'course[_4]'
=> 'kurs[_4]',
   'grades[_2]'
=> 'bewert[_2]',

   'course[_5]'
=> 'kurs-[_5]',
   'chart[_1]'
=> 'fortschr[_1]',

   'course[_6]'
=> 'kurs-[_6]',
   'stats[_1]'
=> 'stat[_1]',

   'manage[_1]'
=> 'verwalte[_1]',
   'acc keys[_1]'
=> 'z-schl[_1]',

   'course[_12]'
=> 'kursteil[_12]',
   'roster[_1]'
=> 'nehmer[_1]',

   'user[_1]'
=> 'benutzer[_1]',
   'roles[_1]'
=> 'rollen[_1]',

   'create[_1]'
=> 'kurs[_1]',
   'course[_8]'
=> 'erstel[_8]',

   'course[_9]'
=> 'kurs-[_9]',
   'parms[_1]'
=> 'param[_1]',

   'con-[_1]'
=> 'konstr-[_1]',
   'struct[_1]'
=> 'bereich[_1]',

   'domain[_1]'
=> 'domänen-[_1]',
   'config[_1]'
=> 'konfig[_1]',

   'resource[_1]'
=> 'res-[_1]',
   'space[_1]'
=> 'bereich[_1]',

   'co res[_1]'
=> 'co-res-[_1]',
   'space[_2]'
=> 'bereich[_2]',

   'what is[_1]'
=> 'wasgibts[_1]',
   'new[_1]'
=> 'neues[_1]',

   'enter[_1]'
=> 'eingeben[_1]',
   'grades[_3]'
=> 'bewert[_3]',

   'send[_1]'
=> 'sende[_1]',
   'scantron[_1]'
=> 'scantron[_1]',

   'course[_13]'
=> 'kurs-[_13]',
   'catalog[_1]'
=> 'übersi[_1]',

   'view[_1]'
=> 'lese-[_1]',
   'bookmark[_1]'
=> 'zeichen[_1]',

   'calendar[_1]'
=> 'kalend-[_1]',
   'announce[_1]'
=> 'ankünd[_1]',

   'commu-[_1]'
=> 'kommu-[_1]',
   'nication[_1]'
=> 'nikation[_1]',

   'course[_10]'
=> 'kurs-[_10]',
   'chat[_1]'
=> 'chatroom[_1]',

   'course[_14]'
=> 'kurs-[_14]',
   'groups[_1]'
=> 'gruppen[_1]',

   'port-[_1]'
=> 'port-[_1]',
   'folio[_1]'
=> 'folio[_1]',

   'edit[_1]'
=> 'blogs[_1]',
   'blogs[_1]'
=> 'verwalt[_1]',

   'search[_3]'
=> 'suche in[_3]',
   'prtfolio[_1]'
=> 'prtfolio[_1]',

   'search[_1]'
=> 'im kurs[_1]',
   'course[_11]'
=> 'suchen[_11]',

   'search[_2]'
=> 'suche in[_2]',
   'library[_1]'
=> 'res[_1]',

   'prefer-[_1]'
=> 'benutz-[_1]',
   'ences[_1]'
=> 'einst[_1]',

   'exit[_1]'
=> 'beenden[_1]',
   ' [_1]'
=> ' [_1]',

#=====================
#???:

   'course[_7]'
=> 'Kurs[_7]',

   'enroll[_1]'
=> 'Kursbelegung durchführen für[_1]',

   'user[_1]'
=> 'Benutzer[_1]',

   'roles[_1]'
=> 'Rollen[_1]',

   'user[_1]'
=> 'Benutzer[_1]',

   'roles[_1]'
=> 'Rollen[_1]',

   'co con-[_1]'
=> 'Co-Kon-[_1]',

   'struct[_2]'
=> 'strukt[_2]',

   'resource[_1]'
=> 'ressource[_1]',

   'space[_1]'
=> 'bereich[_1]',

   'anno-[_1]'
=> 'anno-[_1]',

   'backward[_1]'
=> 'backward[_1]',

   'bookmark[_2]'
=> 'lesezeichen[_2]',

   'evaluate[_1]'
=> 'auswerten[_1]',

   'feedback[_1]'
=> 'feedback[_1]',

   'forward[_1]'
=> 'forward[_1]',

   'discuss[_1]'
=> 'diskutiere[_1]',

# End remote control


#SYNC Sat Apr 17 10:04:35 2004

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Geben Sie maximal [_1] Mitarbeiternamen ein, in der Form Benutzername oder Benutzername@Domäne, z.B. mustermann oder mustermann@[_2].)',

   '(Hand in a file you have prepared on your computer)'
=> '(Reichen Sie eine Datei ein, die Sie auf Ihrem Computer vorbereitet haben)',

   ', select a template from the pull-down menu below.'
=> ', wählen Sie eine Vorlage aus dem folgenden Auswahlmenü aus.',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>-Tags sind zugleich innerhalb und außerhalb eines <part>-Tags. Dies ist keine gültige Aufgabe. Beim Bewerten können Fehler auftreten.',

   'ABSTRACT'
=> 'ÜBERBLICK',

   'Access Control'
=> 'Zugangskontrolle',

   'Activate'
=> 'Aktivieren',

   'Add Roles'
=> 'Rollen hinzufügen',

   "Add one empty page/column after each student's assignment"
=> "Füge eine leere Seite/Spalte nach jeder studentischen Übung ein",

   "Add three empty pages/column after each student's assignment"
=> "Füge drei leere Seiten/Spalten nach jeder studentischen Übung ein",

   "Add two empty pages/column after each student's assignment"
=> "Füge zwei leere Seiten/Spalten nach jeder studentischen Übung ein",

   'Additional settings, if specified below, will override cloned settings'
=> 'Weitere Einstellungen, falls unten angegeben, werden erzeugte Einstellungen überschreiben',

   'Advanced Edit'
=> 'Erweiterter Editor',

   'All Resources'
=> 'Alle Ressourcen',

   'All Students'
=> 'Alle Studierenden',

   'Allowed filetypes: <b>[_1]</b>'
=> 'Akzeptierte Dateitypen: <b>[_1]</b>',

   'An error occured during the attempt to change the section for this student.'
=> 'Beim Ändern der Sektion für diesen Studenten trat ein Fehler auf.',

   'An error occurred during the attempt to change the role information for this student.'
=> 'Beim Ändern der Rolleninformationen für diesen Studenten trat ein Fehler auf.',

   'Analyzing Results'
=> 'Ergebnisse der Analyse',

   'Answerable'
=> 'Beantwortbar',

   'Assessment Parameters'
=> 'Parameter zur Beurteilung',

   'Automated Enrollment Manager'
=> 'Verwaltung der automatischen Kursbelegung',

   'Automated adds'
=> 'Automatische Hinzufügungen',

   'Automated drops'
=> 'Automatische Ausschließungen',

   'Automated enrollment settings'
=> 'Einstellungen für automatische Kursbelegung',

   'Bad Filename'
=> 'Ungültiger Dateiname',

   'Begin Enrollment'
=> 'Kursbelegung beginnen',

   'Binary File'
=> 'Binärdatei',

   'Blank'
=> 'Leer',

   'Browse'
=> 'Durchblättern',

   'CSV format'
=> 'CSV Format',

   'Cannot publish directory'
=> 'Kann Verzeichnis nicht veröffentlichen',

   'Cannot retrieve directory'
=> 'Kann Verzeichnis nicht wiederherstellen',

   'Catalog Search'
=> 'Katalog-Suche',

   'Change User Privileges'
=> 'Benutzerrechte ändern',

   'Changed discussion view mode'
=> 'Ansichtsmodus der Diskussion geändert',

   'Click here for FAQ'
=> 'Häufig gestellte Fragen',

   'Click here for help'
=> 'Hilfe',

   'Click here to report bugs'
=> 'Hier zum Melden von Fehlern klicken',

   'Click-On Texts (comma sep):'
=> 'Antwortvorgabetexte zum Anklicken (durch Kommata getrennt):',

   'Clone an existing course'
=> 'Einen bestehenden Kurs clonen',

   'Close This Window'
=> 'Dieses Fenster schließen',

   'Closed'
=> 'Geschlossen',

   'Communication'
=> 'Kommunikation',

   'Compare versions of'
=> 'Vergleiche Versionen von',

   'Completely new course'
=> 'Komplett neuer Kurs',

   'Construction Space Version'
=> 'Version des Konstruktionsbreichs',

   'Continue'
=> 'Weiter',

   'Copy current file to'
=> 'Kopiere derzeitige Datei nach',

   'Copy selected'
=> 'Kopiere ausgewählte',

   'Course Code'
=> 'Kurscode',

   'Course Content'
=> 'Kursinhalt',

   'Course Data'
=> 'Kursdaten',

   'Course Home Server'
=> 'Heimatserver des Kurses',

   'Course ID/Number'
=> 'Kurs-ID/Nummer',

   'Course Information'
=> 'Kursinformationen',

   'Resource Level'
=> 'Ressource', # 'Ressourcen-Ebene',

   'Map/Folder Level'
=> 'Inhaltszus./Verzeichnis', # 'Inhaltszus.-/Verzeichnis-Ebene',

   'Course Level'
=> 'Kurs', # 'Kurs-Ebene',

   'Course Search'
=> 'Suche im Kurs',

   'Course Title'
=> 'Kurstitel',

   'Create New User'
=> 'Neuen Benutzer erstellen',

   'Create User'
=> 'Benutzer erstellen',

   'Crosslisted courses'
=> 'Fachbereichsübergreifene Kurse',

   'Current Class List'
=> 'Aktuelle Kursteilnehmerliste',

   'Current Ending Date: [_1]'
=> 'Derzeitiges Endedatum: [_1]',

   'Current Ending Date: not set'
=> 'Derzeitiges Endedatum: nicht gesetzt',

   'Current Resource'
=> 'Derzeitige Ressource',

   'Current Starting Date: [_1]'
=> 'Derzeitiges Anfangsdatum: [_1]',

   'Current Starting Date: not set'
=> 'Derzeitiges Anfangsdatum: nicht gesetzt',

   'Current Version'
=> 'Derzeitige Version',

   'Currently no active roles or courses'
=> 'Derzeit keine aktiven Rollen oder Kurse',

   'Currently no additional roles or courses'
=> 'Derzeit keine weiteren Rollen oder Kurse',

   'The following [quant,_1,role,roles] will become active in the future:'
=> 'Die [quant,_1,folgende Rolle wird,folgenden Rollen werden] zukünftig aktiv:',

   'Currently submitted: <tt>[_1]</tt>'
=> 'Derzeit eingereicht: <tt>[_1]</tt>',

   'Custom Role Editor'
=> 'Editor für benutzerdefinierte Rollen',

   'Cut selected'
=> 'Auswahl ausschneiden',

   'Decompress'
=> 'Dekomprimieren',

   'Default Assessment Spreadsheet'
=> 'Standard-Beurteilungsbogen',

   'Default Course Spreadsheet'
=> 'Standard-Kurs-Beurteilungsbogen',

   'Default Student Spreadsheet'
=> 'Standard-Studenten-Beurteilungsbogen',

   'Default XML Style File'
=> 'Standard-XML-Style-Datei',

   'Default for new courses is'
=> 'Standard für neue Kurse ist',

   'Default:'
=> 'Voreingestellt:',

   'Define Role'
=> 'Rolle erstellen',

   'Dependencies'
=> 'Abhängigkeiten',

   'Description:'
=> 'Beschreibung:',

   'Disable student resource discussion'
=> 'Ressourcendiskussion für Studenten deaktivieren',

   'Disable student use of chatrooms'
=> 'Chatroom-Nutzungsmöglichkeit für Studenten deaktivieren',

   'Display file attributes'
=> 'Zeige Dateiattribute',

   'Do NOT generate as standard course'
=> 'NICHT als Standard-Kurs erstellen',

   'Domain Level'
=> 'Domänenebene',

   "Don't Show Feedback"
=> "Kein Feedback anzeigen",

   'Duration of automated classlist updates'
=> 'Dauer der automatischen Aktualisierung der Kursteilnehmerlisten',

   'Dynamic Metadata (updated periodically)'
=> 'Dynamische Metadaten (regelmäßig aktualisiert)',

   'ERROR'
=> 'FEHLER',

   'Edit Custom Role Privileges'
=> 'Bearbeite benutzerdefinierte Rollenprivilegien',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Fehler - diese Fehler müssen das Ausführen der Aufgabe nicht beeinflussen, aber sie werden wahrscheinlich Probleme mit der weiteren Benutzung des Editormodus verursachen. Bearbeiten Sie bitte die Aufgabe im XML-Modus, um diese Fehler zu beheben.',

   'End Time'
=> 'Endezeit',

   'Ending Date'
=> 'Endedatum',

   'Ending date'
=> 'Endedatum',

   'Enroll One Student'
=> 'Einen einzelnen Studenten den Kurs belegen lassen',

   'Enroll as student'
=> 'Student den Kurs belegen lassen',

   'Enrolling'
=> 'Belege',

   'Enrolling Student'
=> 'Student wird in den Kurs aufgenommen',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Füllen Sie so viele Felder wie möglich aus. Das System wird Sie informieren und zu dieser Seite zurückbringen, falls die Daten nicht ausreichen, Studierende in Ihren Kurs einzuschreiben.',

   'Enter as many fields as you can.<br /> The system will inform you and bring you back to this page, <br /> if the data selected are insufficient to add users.'
=> 'Füllen Sie so viele Felder wie möglich aus.<br /> Das System wird Sie informieren und zu dieser Seite zurückbringen,<br /> falls die Daten nicht ausreichen, Benutzer in Ihren Kurs einzuschreiben.',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Geben Sie Suchbegriffe oder -Sätze ein. Sie können AND, OR und NOT als Such-Operatoren verwenden. Klicken Sie anschließend unten auf SUCHEN.',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Geben Sie Suchbegriffe oder -Sätze ein. Sie können als Such-Operatoren AND, OR und NOT verwenden.',

   'Entering Construction Space'
=> 'Betrete Konstruktionsbereich...',

   'Error: Directory Non Empty'
=> 'Fehler: Verzeichnis nicht leer',

   'Error: destination for operation is an existing directory.'
=> 'Fehler: Das Ziel der Operation ist ein existierendes Verzeichnis.',

   'Evaluation Error '
=> 'Auswertungsfehler',

   'Exam Problem'
=> 'Prüfungsaufgabe',

   'Excel format'
=> 'Excel-Format',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback-Adressen für Kommentare zu Kursinhalten',

   'Feedback Addresses for Course Policy'
=> 'Feedback-Adressen für Kursrichtlinien',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback-Adressen für Fragen zum Inhalt der Ressourcen',

   'First'
=> 'Erste',

   'First Resource'
=> 'Erste Ressource',

   'Foil name [_1] appears more than once. Foil names need to be unique.'
=> 'Die Auswahlmöglichkeits-Bezeichnung [_1] tritt mehr als einmal auf. Bezeichnungen für Auswahlmöglichkeiten müssen jedoch eindeutig sein.',

   'Folder/Map'
=> 'Verzeichnis/Inhaltszusammenstellung',

   'For one or more students'
=> 'Für einen oder mehrere Studierende',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Es wurde ein <*response>-Tag außerhalb eines <part>-Bereichs einer Aufgabe gefunden, die aber Aufgabenteile (parts) verwendet.',

   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Keine analysierbaren korrekten Antworten in dieser Aufgabe gefunden. Derzeit werden nur numerische Ausdrücke, Formeln und Strings als Antworttypen unterstützt.',

   'Generate messages from a file'
=> 'Erstelle Nachrichten aus Datei',

   'Arabic - UTF'
=> 'Arabisch - UTF',

   'German - UTF'
=> 'Deutsch - UTF',

   'English - ISO'
=> 'Englisch - ISO',

   'English - UTF'
=> 'Englisch - UTF',

   'Spanish (Castellan) - ISO'
=> 'Spanisch (Kastellanisch) - ISO',

   'Spanish (Castellan) - UTF'
=> 'Spanisch (Kastellanisch) - UTF',

   'Persian - UTF'
=> 'Persisch - UTF',

   'French - ISO'
=> 'Französisch - ISO',

   'French - UTF'
=> 'Französisch - UTF',

   'Hebrew - ISO'
=> 'Hebräisch - ISO',

   'Hebrew - UTF'
=> 'Hebräisch - UTF',

   'Japanese - UTF'
=> 'Japanisch - UTF',

   'Portuguese - ISO'
=> 'Portugiesisch - ISO',

   'Portuguese - UTF'
=> 'Portugiesisch - UTF',

   'Russian - UTF'
=> 'Russisch - UTF',

   'Turkish - ISO'
=> 'Türkisch - ISO',

   'Turkish - UTF'
=> 'Türkisch - UTF',

   'Swedish Chef - ISO'
=> 'Dänischer Koch - ISO',

   'Undetermined - ISO'
=> 'Unbestimmt - ISO',

   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',

   'Go'
=> 'Go',

   'go'
=> 'Go',

   'Go to ...'
=> 'Gehe nach ...', # n.t.

   'Help on Creating Courses'
=> 'Hilfe bei der Kurserstellung',

   'Home Server'
=> 'Heimatserver',

   'Homework problem'
=> 'Übungsaufgabe',

   'How do I create a CSV file from a spreadsheet'
=> 'Wie erstelle ich aus einer Excel-Tabelle eine CSV-Datei?',

   'How do I create a class list from a spreadsheet'
=> 'Wie erstelle ich eine Kursteilnehmerliste von einem Beurteilungsbogen?',

   'How should the results be printed?'
=> 'Wie sollten die Resultate ausgedruckt werden?',

   'Immediately expire own role as Course Coordinator'
=> 'Eigene Rolle als Kurs-Koordinator mit sofortiger Wirkung verfallen lassen',

   'Import and Paste Area'
=> 'Feld zum Importieren und Einfügen',

   'Include retrieval of student photographs?'
=> 'Abrufen der Studentenfotos einbinden?',

   'Institutional Information'
=> 'Institutionelle Information',

   'Invalid Significant figures detected'
=> 'Unpassende signifikante Stellen entdeckt',

   'Invalid characters in requested name have been removed.'
=> 'Aus dem gewünschten Dateinamen wurden ungültige Zeichen entfernt.',

   'Invalid login mode or password.'
=> 'Falscher Login-Modus oder Passwort.',

   'Invalid username or domain'
=> 'Ungültiger Benutzername oder Domäne',

   'KEYWORDS'
=> 'SCHLÜSSELWÖRTER',

   'LaTeX batchmode'
=> 'LaTeX-Batchmodus',

   'LaTeX mode'
=> 'LaTeX-Modus',

   'Languages used'
=> 'Verwendete Sprachen',

   'Last'
=> 'Letzte',

   'Leave blank on scoring form'
=> 'Im Bewertungsformular leer lassen',

   'List Directory'
=> 'Verzeichnisinhalt auflisten',

   'Location'
=> 'Ort',

   'Login Data'
=> 'Login-Daten',

   'Logout'
=> 'Abmelden',

   'Make new directory'
=> 'Neues Verzeichnis erstellen',

   'Make new file'
=> 'Neue Datei erstellen',

   'Manual Grading'
=> 'Manuelle Bewertung',

   'Map has branchings. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Verzweigungen. Verwenden Sie den erweiterten Editor.',

   'Map has conditions. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Bedingungen. Verwenden Sie den erweiterten Editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Ressourcen-Parameter. Verwenden Sie den erweiterten Editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat unverknüpfte Ressourcen. Verwenden Sie den erweiterten Editor.',

   'Maximum Number of Collaborators'
=> 'Maximale Anzahl an Mitarbeitern',

   'Messaging'
=> 'Versenden von Nachrichten',

   'first'
=> 'Vorname', # !

   'last'
=> 'Nachname', # !

   'middle'
=> '2. Vorname', # !

   'Middle Name'
=> '2. Vorname',

   'Missing Kerberos domain information.'
=> 'Fehlende Kerberos-Domänen-Informationen.',

   'Modification may make assessment data inaccessible!'
=> 'Eine Veränderung könnte die Beurteilungsdaten unzugänglich machen!',

   'Modify Enrollment for'
=> 'Bearbeite Kursbelegung für',

   'Modify User'
=> 'Benutzerdaten ändern',

   'Modify another students data'
=> 'Daten eines anderen Studenten bearbeiten',

   'Modify deadlines, etc, for this resource'
=> 'Deadlines, etc, für diese Ressource bearbeiten',

   'Modifying data for user'
=> 'Bearbeitung der Daten für Benutzer',

   'Modifying this will make problems have different numbers and answers!'
=> 'Eine Veränderung wird bewirken, dass Aufgaben unterschiedliche Zahlen und Antworten haben werden!',

   'Move current file to'
=> 'Derzeitige Datei verschieben nach',

   'Must create new subdirectory inside a directory'
=> 'Müssen ein neues Unterverzeichnis in dem Verzeichnis erstellen',

   'Name of Role'
=> 'Bezeichnung der Rolle',

   'Navigate'
=> 'Navigiere',

   'New Directory'
=> 'Neues Verzeichnis',

   'New HTML file'
=> 'Neue HTML-Datei',

   'New Resource'
=> 'Neue Ressource',

   'New Role'
=> 'Neue Rolle',

   'New User'
=> 'Neuer Benutzer',

   'New Value'
=> 'Neuer Wert',

   'New assembled page'
=> 'Neue zusammengesetzte Seite',

   'New assembled sequence'
=> 'Neue zusammengesetzte Sequenz',

   'New custom rights file'
=> 'Neue Datei zur Zugriffkontrolle',

   'New file'
=> 'Neue Datei',

   'New problem'
=> 'Neue Aufgabe',

   'New style file'
=> 'Neue Style-Datei',

   'New subdirectory'
=> 'Neues Unterverzeichnis',

   'Next    '
=> 'Weiter    ',

   'No'
=> 'Nein',

   'No Access or Usages Statistics are available for this resource.'
=> 'Für diese Ressource sind keine Zugriffs- oder Nutzungsstatistiken verfügbar.',

   'No Assessment Statistical Data is available for this resource'
=> 'Für diese Ressource sind keine statistischen Beurteilungsdaten verfügbar.',

   'No Evaluation Data is available for this resource.'
=> 'Für diese Ressource sind keine Evaluierungsdaten verfügbar.',

   'No new filename specified.'
=> 'Kein neuer Dateiname angegeben.',

   'No such file'
=> 'Datei nicht gefunden',

   'Not Allowed'
=> 'Nicht zulässig',

   'Not applicable -'
=> 'Nicht anwendbar -',

   'Not open to be viewed'
=> 'Ressource darf nicht betrachtet werden',

   'Not set -'
=> 'Nicht gesetzt -',

   'Notification of enrollment changes'
=> 'Benachrichtigung über Änderungen der Kursbelegung',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Soll LON-CAPA den <b>Kurs-Koordinator</b> benachrichtigen, wenn während der automatischen Aktualisierung Änderungen an der Kursbelegung auftreten?',

   'Number of columns'
=> 'Anzahl an Spalten',

   'Old Value'
=> 'Alter Wert',

   'One particular problem (overrides folder and course defaults)'
=> 'Eine bestimmte Aufgabe (überschreibt Verzeichnis- und Kurs-Defaultwerte)',

   'Online Help'
=> 'Online-Hilfe',

   'Only Answers'
=> 'Nur Antworten',

   'Only domain coordinators can change a users password.'
=> 'Nur Domänen-Koordinatoren können das Passwort eines Benutzers ändern.',

   'Open Course'
=> 'Kurs anlegen',

   'Open all assessments'
=> 'Alle Beurteilungen zugänglich machen',

   'Open and correct'
=> 'Öffnen und korrigieren',

   'Open with full tries'
=> 'Öffnen mit allen Versuchen',

   'Output Format: [_1]'
=> 'Ausgabeformat: [_1]',

   'Page layout'
=> 'Seitenlayout',

   'Paper type'
=> 'Papiertyp',

   'Parameter'
=> 'Parameter',

   'Paste after selected'
=> 'In Auswahl einfügen',

   'Personal Data'
=> 'Persönliche Daten',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Wählen Sie hier die voreingestellte Authentifizierungs-Methode aus, die bei neuen Benutzern in dieser LON-CAPA-Domäne verwendet werden soll, die durch den automatischen Kursbelegungs-Prozess hinzugefügt wurden',

   'No such user [_1] at domain [_2].' # 1: user, 2: domain
=> 'In der Domäne [_2] existiert der Benutzer [_1] nicht.',

   'Please click Back on your browser and select another user, or [_1]Create User[_2]'
=> 'Bitte klicken Sie in Ihrem Webbrowser auf Zurück und wählen Sie einen anderen Benutzer aus oder wählen Sie [_1]Benutzer erstellen[_2]',

   'Invalid home server for course: [_1]'
=> 'Ungültiger Heimatserver für Kurs [_1]',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Bitte kontaktieren Sie zu dieser Angelegenheit Ihren LON-CAPA-Administrator.',

   'Please select an authentication mechanism'
=> 'Wählen Sie bitte eine Authentifizierungs-Methode aus',

   'Please select the authentication mechanism'
=> 'Auswahl der Authentifizierungs-Methode',

   'Please stand by.'
=> 'Bitte warten.',

   "Please use browser 'Back' button and pick a filename"
=> "Benutzen Sie bitte den Zurück-Button des Webbrowsers und wählen Sie einen Dateinamen aus",

   'Preparing Printout'
=> 'Bereite Ausdruck vor',

   'Print'
=> 'Drucken',

   'Print Index'
=> 'Index drucken',

   'Print Table of Contents'
=> 'Inhaltsverzeichnis drucken',

   'Print:'
=> 'Drucke:',

   'Problems from entire course'
=> 'Aufgaben des gesamten Kurses',

   'Processed file: [_1]'
=> 'Verarbeitete Datei: [_1]',

   'Publish this Resource'
=> 'Diese Ressource veröffentlichen',

   'Randomization algorithm used'
=> 'Verwendeter Randomisierungs-Algorithmus',

   'Recent'
=> 'zuletzt',

   'Rename current file to'
=> 'Derzeitige Datei umbenennen in',

   'Report a Bug'
=> 'Einen Fehler melden',

   'Resource'
=> 'Ressource',

   'Resource Differences'
=> 'Ressourcen-Unterschiede',

   'Resources from selected sequence in course'
=> 'Ressourcen von ausgewählten Sequenzen im Kurs',

   'Response'
=> 'Antwort',

   'Retrieve Old Version'
=> 'Alte Version wiederherstellen',

   'Retrieving current (most recent) version'
=> 'Rufe aktuelleste Version ab',

   'Return to DOCS'
=> 'Zurück zum Kursinhalt',

   'Reverse Association'
=> 'Umgekehrte Assoziierung', # n.t.

   'Revoke'
=> 'Entziehen',

   'Revoke Existing Roles'
=> 'Bestehende Rollen entziehen',

   'Role'
=> 'Rolle',

   'Role:'
=> 'Rolle:',

   'Role Information'
=> 'Information zur Rolle',

   'Sample Points:'
=> 'Abtastpunkte:',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Die untenstehenden Eintragungen als Entwurf speichern (aber noch nicht endgültig einreichen)',

   'Select Action'
=> 'Aktion auswählen',

   'Select All Resources'
=> 'Alle Ressourcen auswählen',

   'Select Printing Options:'
=> 'Druckoptionen auswählen:',

   'Select Problem(s) to print'
=> 'Aufgaben zum Ausdrucken wählen',

   'Select Resource(s) to print'
=> 'Ressource(n) zum Ausdrucken wählen',

   'Select Resources To Print'
=> 'Ressourcen zum Ausdrucken wählen',

   'Select Section'
=> 'Sektion auswählen',

   'Select Sequence To Print From'
=> 'Sequenz, von der gedruckt werden soll, auswählen',

   'Select Students and Resources'
=> 'Studierenden und Ressourcen auswählen',

   'Select Style File'
=> 'Styledatei auswählen',

   "Select a user name to modify the student's information"
=> "Klicken Sie auf den Benutzernamen, um die Daten des Studierenden zu ändern.",

   'Select a user name to view the users personal page.'
=> 'Wählen Sie einen Benutzernamen, von welchem Sie die persönliche Seite ansehen möchten.',

   'Select resources for the assignment'
=> 'Wählen Sie Ressourcen für die Übung aus',

   'Set'
=> 'Setze',

   'Set?'
=> 'Setzen?',

   'Set Course Environment'
=> 'Kursumgebung',

   'Set End Date'
=> 'Endedatum festlegen',

   'Set Individual User Roles'
=> 'Benutzerrollen und -rechte einrichten',

   'Set Start Date'
=> 'Anfangsdatum festlegen',

   'Set content feedback to Course Coordinator'
=> 'Inhaltsbezogenes Feedback soll Kurs-Koordinator erhalten',

   'Set course policy feedback to Course Coordinator'
=> 'Feedback zu Kursrichtlinien soll Kurs-Koordinator erhalten',

   'Set opening date for all problems in the course for. . .'
=> 'Setze Öffnungstermin für alle Aufgaben in dem Kurs auf. . .',

   'Set to ...'
=> 'Setze auf ...',

   'Show Answer'
=> 'Zeige Antwort',

   'Show Feedback'
=> 'Zeige Feedback',

   'Simple Edit'
=> 'Einfacher Editor',

   'Start Time'
=> 'Startzeit',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Beginne jede studentische Übung auf einer neuen Seite/Spalte (füge einen Seitenvorschub nach jeder Übung ein)",

   'Starting Date'
=> 'Anfangsdatum',

   'Starting date'
=> 'Anfangsdatum',

   'Student ID'
=> 'Matrikelnummer',

   'Student Information'
=> 'Studenten-Informationen',

   'Student Sheet Links'
=> 'Tabellenlinks des Studierenden',

   'Student Status'
=> 'Studierendenstatus',

   'Student Status: [_1]'
=> 'Studierendenstatus: [_1]',

   'Student information updated successfully.'
=> 'Studenten-Informationen erfolgreich aktualisiert.',

   'Students need access key to enter course'
=> 'Die Studierenden benötigen zum Betreten des Kurses einen Zugangsschlüssel',

   'Students with expired roles'
=> 'Studierende mit abgelaufenen Rollen',

   'Subject:'
=> 'Thema:',

   'Submissions'
=> 'Einreichungen',

   'Submit Modifications'
=> 'Veränderungen einreichen',

   'Submit entries below as answer to receive credit'
=> 'Die untenstehenden Eintragungen einreichen',

   'Survey Question'
=> 'Frage einer Umfrage',

   'Survey question'
=> 'Frage einer Umfrage',

   'System Level'
=> 'Systemebene',

   'Target Edit Map'
=> 'Ziel Editor Inhaltszusammenstellung', #??? [SB 18.10.2006]

   'TeX unconverted due to errors'
=> 'TeX wegen Fehlern nicht konvertiert',

   'TeX unconverted due to previous errors'
=> 'TeX aufgrund vorheriger Fehler nicht konvertiert',

   'The error reported was'
=> 'Der genannte Fehler war',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'Die folgenden Einträge werden benutzt, um den Kurs gemäß des Namensschemas Ihrer Institution zu identifizieren. Ihre Auswahl wird benutzt werden, um eine interne LON-CAPA-Kurs-ID mit der/den zugehörigen Kurs-Sektion-ID(s) zu verbinden. Diese ID(s) werden von der Einrichtung verwendet, die für das zur Verfügungstellen der offiziellen Kurslisten an Ihrer Institution zuständig ist (z.B. Prüfungsamt). Diese Zuordnung is notwendig, wenn Sie die automatische Ergänzung von Kurslisten wählen.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "Die folgenden Einstellungen kontrollieren die automatische Kursbelegung von Studierenden in diesen Kurs anhand der verfügbaren Informationen für diesen Kurs von der offiziellen Kursteilnehmerliste Ihrer Institution.",

   'The requested file'
=> 'Die angeforderte Datei',

   'The student must log out and log in again to see these changes.'
=> 'Der Studierende muss sich ausloggen und neu einloggen, um diese Änderungen zu sehen.',

   'There are currently no Error Messages for this resource.'
=> 'Momentan liegen keine Fehlermeldungen zu dieser Ressource vor.',

   'There are no Evaluation Comments on this resource.'
=> 'Zu dieser Ressource liegen keine Evaluierungskommentare vor.',

   'There was an error determining the environment values for'
=> 'Es trat ein Fehler auf bei der Bestimmung der Umgebungswerte für',

   'Top Level Map'
=> 'Hauptebenen-Inhaltszusammenstellung',

   'Type Name Here'
=> 'Hier Name eingeben',

   'Type in value'
=> 'Wert eingeben',

   'Type:'
=> 'Typ:',

   'UNDISPLAYABLE'
=> 'NICHT DARSTELLBAR',

   'Unable to enroll'
=> 'Kursbelegung nicht möglich',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Die Datei kann nicht veröffentlicht werden, da Sie doppelte IDs enthält. IDs müssen jedoch eindeutig sein. Die doppelten IDs sind',

   'Unable to retrieve environment data for'
=> 'Konnte die Umgebungsdaten nicht wiederherstellen für',

   'Unable to set default dates for course'
=> 'Konnte die Defaulttermine des Kurses nicht setzen für',

   'Unavailable course'
=> 'Nicht verfügbarer Kurs',

   'Unknown Action'
=> 'Unbekannte Aktion',

   'Upload class list'
=> 'Lade Kursteilnehmerliste hoch',

   'Upload file'
=> 'Datei hochladen',

   'Upload file to Construction Space'
=> 'Datei in den Konstruktionsbereich hochladen',

   'VIEW'
=> 'ANSICHT',

   'View the FAQ'
=> 'Zeige die FAQ',

   'Visibly Separate Items on Pages'
=> 'Sichtbar unterschiedliche Einzelteile auf Seiten',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'ACHTUNG: Die Metadaten-Tabelle existiert nicht in der LON-CAPA-Datenbank.',

   'Warning: change of MIME type!'
=> 'Achtung: Änderung des MIME-Typs!',

   'Warning: target file exists!'
=> 'Achtung: Zieldatei existiert bereits!',

   'Warning: target file exists, and has been published!'
=> 'Achtung: Zieldatei existiert und wurde bereits veröffentlicht!',

   'Width'
=> 'Breite',

   'With Answers'
=> 'Mit Antworten',

   'Without Answers'
=> 'Ohne Antworten',

   'You are working with an unsaved version of your map.'
=> 'Sie arbeiten momentan an einer nicht gespeicherten Version Ihrer Inhaltszusammenstellung.',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'Sie haben die ID/Matrikelnummer geändert, aber nicht den ID-/Matrikelnummer-Safeguard deaktiviert. Die ID/Matrikelnummer wird daher nicht geändert.',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Ihre Versuch zur Änderung der Rolleninformationen für diesen Studenten wurde abgelehnt. Sie haben offensichtlich nicht genügend Rechte zum Ändern der Studenten-Daten.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (was Sie gerade auf dem Bildschirm sahen)',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] Lokale Authentifizierung mit Argument [_2]',

   'Currently using local (institutional) authentication.'
=> 'Derzeit lokal (institutionell) authentifiziert.',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) sectionID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2'
=> 'Eine komma-separierte Liste von Kurs-Sektionen zusammen mit dem derzeitigen Kurs, wobei jeder Eintrag den institutionellen Kurssektionsnamen beinhaltet, gefolgt von einem Doppelpunkt und dann der (optionalen) Sektions-ID zur Verwendung in LON-CAPA, z.B. fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'Eine komma-separierte Liste institutioneller Sektionsnummern, jeweils getrennt durch einen Doppelpunkt von der in LON-CAPA verwendeten entsprechenden (optionalen) Sektions-ID, z.B. 001:1,002:2',

   'after selected'
=> 'nach erfolgter Auswahl',

   'and'
=> 'und',

   'anno.gif'
=> 'anno.gif',

   'anot.gif'
=> 'anot.gif',

   'bchat.gif'
=> 'bchat.gif',

   'between'
=> 'zwischen',

   'button'
=> 'Button',

   'by'
=> 'durch',

   'catalog.gif'
=> 'catalog.gif',

   'ccrs.gif'
=> 'ccrs.gif',

   'check all'
=> 'Alle auswählen',

   'chmod error'
=> 'Fehler beim Auführen von chmod',

   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'klicken Sie bitte auf',

   'com.gif'
=> 'com.gif',

   'copy Error'
=> 'Kopierfehler',

   'courses.gif'
=> 'courses.gif',

   'cprv.gif'
=> 'cprv.gif',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'existiert z.Z. nicht',

   'custom'
=> "benutzerdefiniert", # 'anpassbar', # individuell ???

   'custom distribution file'
=> 'benutzerdefinierte Datei', # ???

   'docs.gif'
=> 'docs.gif',

   'domain'
=> 'Domäne',

   'egrd.gif'
=> 'egrd.gif',

   'enrl.gif'
=> 'enrl.gif',

   'eval.gif'
=> 'eval.gif',

   'expired or revoked'
=> 'abgelaufen oder entzogen',

   'extension'
=> 'Endung',

   'external'
=> 'extern',

   'fdbk.gif'
=> 'fdbk.gif',

   'file<br />extension'
=> 'Datei-<br />Endung',

   'first name'
=> 'Vorname',

   'generation'
=> 'Generation',

   'grds.gif'
=> 'grds.gif',

   'in domain'
=> 'in Domäne',

   'internal'
=> 'intern',

   'is in this state by royal decree.'
=> 'hat die Erlaubnis aufgrund eines königlichen Erlasses.',

   'is ready for download'
=> 'steht zum Download bereit',

   'keys.gif'
=> 'keys.gif',

   'last name'
=> 'Nachname',

   'logout.gif'
=> 'logout.gif',

   'make these dates the default for future enrollment'
=> 'Diese Datumswerte als voreingestellte Werte für zukünftige Kursbelegungen verwenden',

   'middle name'
=> 'zweiter Vorname',

   'name'
=> 'Name',

   'nav.gif'
=> 'nav.gif',

   'no ending date'
=> 'kein Endedatum',

   'number'
=> 'Nummer',

   'obsolete replacement'
=> 'veraltete Ersetzung',

   'only check if you know what you are doing'
=> 'nur auswählen, wenn Sie wissen, was Sie tun',

   '[_1] only search domain [_2]'
=> '[_1] suche nur in Domäne [_2]',

   'optional'
=> 'optional',

   'or any other value'
=> 'oder jeder andere Wert',

   'parm.gif'
=> 'parm.gif',

   'pref.gif'
=> 'pref.gif',

   'private'
=> 'privat',

   'prt.gif'
=> 'prt.gif',

   'public'
=> 'öffentlich',

   'publisher<br />owner'
=> 'Herausgeber<br />Besitzer',

   'res.gif'
=> 'res.gif',

   'roles.gif'
=> 'roles.gif',

   'sbkm.gif'
=> 'sbkm.gif',

   'section'
=> 'Sektion',

   'set[_1]'
=> 'Set[_1]',

   'spacer.gif'
=> 'spacer.gif',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'standard'
=> 'Standard',

   'standard LaTeX mode'
=> 'Standard-LaTeX-Modus',

   'standard courses only'
=> 'Nur Standardkurse',

   'stat.gif'
=> 'stat.gif',

   'student name'
=> 'Name des Studenten',

   'template'
=> 'Vorlage',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'Zur Kopplung mit institutionellen Daten, z.B. <tt>ss08inf345</tt> für <i>Sommersemester 2008 Informatik 345</i>',

   'unable to enroll'
=> 'Belegung nicht möglich',

   'uncheck all'
=> 'Gesamte Auswahl aufheben',

   'use related words'
=> 'Verwende ähnliche Wörter',

   '[_1] use related words'
=> '[_1] verwende ähnliche Wörter',

   'username'
=> 'Benutzername',

   'vbkm.gif'
=> 'vbkm.gif',

   'versus'
=> 'gegen',

   'with server'
=> 'mit Server',

   'yes'
=> 'ja',

   'Swedish Chef'
=> 'Schwedischer Koch',


#SYNC Tue Aug 15 14:23:05 2006
   '[_1] for default hiding'
=> '[_1] für voreingestelltes Verbergen',

   '[_1] for visible separation.'
=> '[_1] für sichtbare Trennung.',

   'Changes will not show until next login.'
=> 'Änderungen werden beim nächsten Login aktiv.',

   '[_1] if allowed, anything else if not'
=> '[_1], um zu erlauben. Alles andere, um nicht zu erlauben.',

   '"[_1]" to disable, anything else if not'
=> '"[_1]", um zu deaktivieren. Alles andere, um zu aktivieren.',

   '[_1] to suppress, anything else to not suppress'
=> '[_1], um zu unterdrücken. Alles andere, um nicht zu unterdrücken.',

   'Set value to [_1] to allow all roles.'
=> '[_1], um für alle Rollen zu erlauben.',


   '# Do not translate this line.  [_1] is a check box'
=> '# Diese Zeile nicht übersetzen .  [_1] ist ein Ankreuzfeld',

   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Diese Zeile nicht übersetzen.  [_1] ist ein Ankreuzfeld, [_2] ist ein Texteingabefeld',

   '# Do not translate this line.  [_1] is a column index.'
=> '# Diese Zeile nicht übersetzen.  [_1] ist ein Spaltenindex.',

   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Diese Zeile nicht übersetzen.  [_1] ist ein Feld, um Domänen auszuwählen.',

   '# Do not translate this line.  [_1] is a username'
=> '# Diese Zeile nicht übersetzen.  [_1] ist ein Benutzername',

   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Diese Zeile nicht übersetzen.  [_1] ist die Anzahl der bearbeiteten Studierdendatensätze',

   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Diese Zeile nicht übersetzen.  [_1] ist Benutzername, [_2] - [_5] sind Vorname, 2. Vorname, Nachname und Generation.',

   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Diese Zeile nicht übersetzen.  [_1] ist Benutzername, [_2] ist Fehlermeldung',

  '# Do not translate this line.  [_1] is username@domain'
=> '# Diese Zeile nicht übersetzen.  [_1] ist benutzername@domäne',

   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Diese Zeile nicht übersetzen.  [_1] ist benutzername@domäne [_2] ist die Fehlermeldung.',

   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Diese Zeile nicht übersetzen.  [_1], [_3], und [_4] sind Auswahlfelder',

   '# Do not translate this line.  [_2] is a text entry element'
=> '# Diese Zeile nicht übersetzen.  [_2] ist ein Texteingabefeld',

   '# [_1] is a drop-down selection box'
=> '# [_1] ist ein Drop-Down-Auswahlmenü',

   '# [_1] is a number [_2] is the current domain'
=> '# [_1] ist eine Nummer [_2] ist der derzeitige Bereich',

   '# [_1] is an html link to the current file '
=> '# [_1] ist eine html-Verknüpfung zur derzeitigen Datei ',

   '# _1 is a selection dialog'
=> '# _1 ist ein Auswahldialog',

   '# _1 is a server name'
=> '# _1 ist ein Servername',

   '# _1 is search string'
=> '# _1 ist ein Suchbegriff',

   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, und _5 sind Verknüpfungsanker, _2,_4, und _6 sind '</a>'",

   '#[_1] is the foil name'
=> '#[_1] ist die Bezeichnung der Auswahlmöglichkeit',

   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 ist die Bezeichnung der Auswahlmöglichkeit, _2 ist der aktuelle Wert der Auswahlmöglichkeit',

   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; ist keine zulässige Anzahl von Versuchen. Die Anzahl muss eine positive, ganze Zahl (ohne Dezimalkurs) sein.',

   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; ist keine zulässige Gewichtung. Die Gewichtung muss eine positive Zahl sein.',

   '1 minute'
=> '1 Minute',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML zugelassen</b>: Diskussionsteilnehmer können in ihren Beiträgen eingeschränkten HTML-Befehlssatz verwenden.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML verboten</b>: HTML wird in Diskussionen nicht zugelassen.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Dozent</b> - Dozenten werden nicht an den Diskussionen teilnehmen können.',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Dozent</b> - Dozenten werden den Chatroom weder betreten noch die Inhalte einsehen können',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Studierende</b> - Studenten werden nicht an Diskussionen teilnehmen können',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Studierende</b> - Studenten werden den Chatroom weder betreten noch die Inhalte einsehen können',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Tutor</b> - Tutoren werden nicht an den Diskussionen teilnehmen können',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Tutor</b> - Tutoren werden den Chatroom weder betreten noch die Inhalte einsehen können',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Ihre derzeitige LON-CAPA-Domäne ist &quot;<b>[_1]</b>&quot;.</p>',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Fortgeschritten: Sie können Feedback von unterschiedlichen Sektionen aus an unterschiedliche Personen senden. Hierzu ist jeder Eintrag mit einem Komma zu trennen. Um Feedback an eine bestimmte Adresse für unterschiedliche Sektionen zu senden, hängen Sie die die Sektionsbezeichnung(en) (getrennt durch Semicola) in einer Klammerliste nach benutzer:domäne an. Beispiel: john102:msu(001;002;003), bob293:msu(004;005;006), irgendwer:irgendwo(007;008;009) würde Feedback an &quot; john102&quot; für Sektionen 1, 2 und 3, an &quot;bob293&quot; für Sektionen 4, 5 und 6 und an &quot;irgendwer:irgendwo&quot; für Sektionen 7, 8 und 9 senden. Beachten Sie, dass es nicht erforderlich ist, dass die Adressen in einer bestimmten Domäne liegen.',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'Alle Einstellungen, die mit diesem Hilfsprogramm änderbar sind, können auch über die Kurs- und Ressourcen-Parameter im Unterpunkt "Kursumgebung" geändert werden. Wenn Sie noch keine Erfahrung mit der Koordination von LON-CAPA-Kursen haben oder wenn Sie dieses Hilfsprogramm bevorzugen, klicken Sie bitte jetzt auf <tt>Weiter -&gt;</tt>.',

   'Allow limited HTML in discussion posts'
=> 'Beschränkte Verwendung von HTML in den Diskussionsbeiträgen zulassen',

   'Allow problems to be split over pages'
=> 'Erlauben, dass sich Aufgaben auf mehrere Seiten aufteilen dürfen',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Dateiendungen für hochgeladene Dateien erlauben (uploadedfiletypes)',

   'Answer Date (answerdate)'
=> 'Antwort-Verfügbarkeits-Datum (answerdate)',

   'Chat Participation'
=> 'Teilnahme am Chat',

   'Click here to return to the chart.'
=> 'Klicken Sie hier, um zum Chart zurückzukehren.',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Namen-Zugriffssteuerung (acc)',

   'Completed'
=> 'Ausgeführt',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Bestätigen Sie, dass diese Informationen richtig sind. Klicken Sie dann auf &quot;Beende Hilfsprogramm&quot;, um das Einstellen der Parameter abzuschließen.',

   'Course ID or number'
=> 'Kurs-ID oder -Nummer',

   'Course Initialization Helper'
=> 'Hilfsprogramm zur Kurs-Einrichtung',

   'Course default for all problems'
=> 'Default-Einstellungen des Kurses für alle Aufgaben',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Kursmitglieder können Feedback zum Kurs geben. Sie können hier auswählen, wer das Feedback empfangen soll, wie z.B. ein anderer Dozent oder Tutor. Bitte geben Sie deren LON-CAPA-Benutzer unten in der Form benutzer:domäne ein, wobei &quot;benutzer&quot; und &quot;domäne&quot; LON-CAPA-Benutzername und LON-CAPA-Domäne sind. Verwenden Sie keine E-Mail-Adresse!',

   'Courses'
=> 'Kurse',

   'Default beginning date when enrolling students'
=> 'Voreingestelltes Anfangsdatum für die studentische Kursbelegung',

   'Default ending date when enrolling students'
=> 'Voreingestelltes Endedatum für die studentische Kursbelegung',


   'Default set of options to pass to tth/m when converting tex'
=> 'Voreingestellte Optionen für tth/m für die Konvertierung von TeX',

   'Disable display of problem receipts'
=> 'Anzeige von Aufgaben-Nachweisnummern deaktivieren',

   'Disallow Resource Discussion for Roles'
=> 'Diskussion über Ressource für folgende Rollen nicht gestatten:',

   'Disallow Resource Discussion for Users'
=> 'Diskussion über Ressource für folgende Benutzer nicht gestatten:',

   'Disallow live chatroom use for Roles'
=> 'Nutzungsmöglichkeit des Live-Chatrooms für folgende Rollen nicht gestatten:',

   'Disallow live chatroom use for Users'
=> 'Besuchen des Live-Chatrooms für folgende Benutzer nicht gestatten:',

   'Discussion Participation'
=> 'Diskussionsteilnahme',

   'Do not show plain URL (encrypturl)'
=> 'Blanke URL nicht anzeigen  (encrypturl)',

   'Due Date (contentclose)'
=> 'Fälligkeitsdatum (contentclose)',

   'Due Date (duedate)'
=> 'Fälligkeitsdatum (duedate)',

   'Every problem in a particular folder (overrides course default)'
=> 'Jede Aufgabe in einen bestimmten Verzeichnis ablegen (Überschreibt Default-Einstellungen des Kurses)',

   'Exit'
=> 'Beenden',

   'Feedback Addresses for Course Content'
=> 'Feedback-Adressen für Kursinhalt',

   'Finish Helper'
=> 'Beende Hilfsprogramm',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML kann innerhalb von Kursdiskussionen erlaubt oder verboten werden.',

   'HTML in Discussions'
=> 'HTML in Diskussionen',

   'Hand Graded (handgrade)'
=> 'Manuell bewertet (handgrade)',

   'Hide Empty Rows in Spreadsheets'
=> 'Leere Zeilen in den Beurteilungsbögen verbergen',

   'How many tries should be set for all problems in the course?'
=> 'Wieviele Versuche sollten für alle Aufgaben im Kurs gesetzt werden?',

   'How many tries should be set for the selected folder?'
=> 'Wieviele Versuche sollten für alle gewählten Verzeichnisse gesetzt werden?',

   'How many tries should be set for the selected problem?'
=> 'Wieviele Versuche sollten für die ausgewählte Aufgabe gesetzt werden?',

   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA bietet eine Live-Chat-Funktion an. Dieser Kurs wird seinen eigenen Chatroom erhalten. Sie können Studenten, Tutoren oder Dozenten das Recht verweigern, den Chatroom zu nutzen.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA bietet für alle Ressourcen des Kurses eine Diskussionsmöglichkeit an. In der Grundeinstellung dürfen allen Benutzer an diesen Diskussionen teilnehmen. Wenn Sie nicht wollen, dass bestimmte Arten von Benutzern an den Diskussionen teilnehmen sollen dürfen, wählen Sie diese unten aus. Beachten Sie, dass Ihr Kurs nicht jede Art von Benutzerrollen haben könnte. Sie können problemlos Rollen ignorieren, die Sie nicht verwenden wollen (Beispiel: Klausuraufsichtspersonal ist üblicherweise nur für sehr große Kurse hilfreich.) Benutzergruppen, die nicht an der Diskussion teilnehmen dürfen, können dennoch jede Diskussion der anderen Benutzer mitlesen.',

   'List of hidden parts (hiddenparts)'
=> 'Liste der versteckten Aufgabenteile (hiddenparts)',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximale Anzahl an Mitarbeitern (maxcollaborators)',

   'Maximum Number of Tries (maxtries)'
=> 'Maximale Anzahl an Versuchen (maxtries)',

   'No section assigned'
=> 'Keiner Sektion zugewiesen',

   'Number of Tries before hints appear (hinttries)'
=> 'Anzahl der Versuche, bevor Hinweise erscheinen (hinttries)',

   'Number of assignments printed at the same time:'
=> 'Anzahl von Übungen, die gleichzeitig gedruckt werden sollen:',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Anzahl der Ankreuzfelder im Prüfungmodus (numbubbles)',

   'Numerical Tolerance (tol)'
=> 'Numerische Toleranz (tol)',

   'Opening Date (contentopen)'
=> 'Bearbeitungsbeginn-Datum (contentopen)',

   'Opening Date (opendate)'
=> 'Bearbeitungsbeginn-Datum (opendate)',

   'Part Description (display)'
=> 'Aufgabenteil-Beschreibung (display)',

   'Please adjust significant figures.'
=> 'Bitte passen Sie die signifikanten Stellen an.',
 
   'Please select the section you wish to set the answer open date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie das Antwort-Verfügbarkeits-Datum festlegen wollen:',

   'Please select the section you wish to set the due date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie das Fälligkeitsdatum festlegen wollen:',

   'Please select the section you wish to set the number of tries for:'
=> 'Bitte wählen Sie die Sektion, für die Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the section you wish to set the opening date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the section you wish to set the problem weight for:'
=> 'Bitte wählen Sie die Sektion, für die Sie die Aufgabengewichtung festlegen wollen:',

   'Please select the student you wish to set the answer open date for:'
=> 'Bitte wählen Sie den Studenten, für den Sie das Antwort-Verfügbarkeits-Datum festlegen wollen:',

   'Please select the student you wish to set the due date for:'
=> 'Bitte wählen Sie den Studenten, für den Sie das Fälligkeitsdatum festlegen wollen:',

   'Please select the student you wish to set the number of tries for:'
=> 'Bitte wählen Sie den Studenten, für den Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the student you wish to set the opening date for:'
=> 'Bitte wählen Sie den Studenten, für den Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the student you wish to set the problem weight for:'
=> 'Bitte wählen Sie den Studenten, für den Sie die Aufgabengewichtung festlegen wollen:',

   'Privileged users that should not be hidden on staff listings'
=> 'Privilegierte Nutzer, die auf Personallisten nicht verborgen werden sollen',

   'Question Type (type)'
=> 'Fragetyp (type)',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Zufallszahlen-Basis für zufällige Wahl der Ressourcen-Anzahl (optional. Setzen Sie dies nur, wenn Sie die Funktionalität verstehen) (randompickseed)',

   'Randomly pick number of resources (randompick)'
=> 'Ressourcenanzahl zufällig wählen (randompick)',

   'Reading results from [_1]'
=> 'Lese Ergebnisse von [_1]',

   'Receipt algorithm used'
=> 'Verwendetes Verfahren für Empfangsquittungen',

   'Receiving results from [_1]'
=> 'Erhalte Ergebnisse von [_1]',

   'Resource Hidden from Students (hiddenresource)'
=> 'Ressource vor Studierenden verborgen (hiddenresource)',

   'Resource alias name for conditions (mapalias)'
=> 'Ressourcen-Aliasname für Bedingungen (mapalias)',

   'Resources'
=> 'Ressourcen',

   'Search Complete [_1]'
=> ' Suche vollständige(n) [_1]',

   'Search: [_1]'
=> 'Suche: [_1]',

   'Select All Files'
=> 'Alle Dateien auswählen',

   'Select All Published'
=> 'Alle veröffentlichten Ressourcen auswählen',

   'Select Folder'
=> 'Verzeichnis auswählen',

   'Select Only Current Students'
=> 'Nur aktuelle Studenten auswählen',

   'Select Problem'
=> 'Aufgabe auswählen',

   'Select Student'
=> 'Studenten auswählen',

   'Select for Section/Group'
=> 'Auswahl für Sektion/Gruppe',

   'Select the folder you wish to set the parameter for:'
=> 'Wählen Sie das Verzeichnis, für den sie den Parameter einstellen wollen:',

   'Select the problem you wish to set the parameter for:'
=> 'Wählen Sie die Aufgabe, für die Sie den Parameter einstellen wollen:',

   'Set Problem Tries'
=> 'Aufgaben-Versuche einstellen',

   'Set Problem Weight'
=> 'Aufgaben-Gewichtung einstellen',

   'Set answer open date for all problems in the course for ...'
=> 'Setze Antwort-Verfügbarkeits-Datum aller Aufgaben des Kurses für...',

   'Set answer open date for the selected folder for ...'
=> 'Setze Antwort-Verfügbarkeits-Datum des ausgewählten Verzeichnisses für...',

   'Set answer open date for the selected problem for...'
=> 'Setze Antwort-Verfügbarkeits-Datum der ausgewählten Aufgabe für...',

   'Set due date for all problems in the course for ...'
=> 'Setze Fälligkeitsdatum aller Aufgaben des Kurses für...',

   'Set due date for the selected folder for ...'
=> 'Setze Fälligkeitsdatum des ausgewählten Verzeichnisses für...',

   'Set due date for the selected problem for ...'
=> 'Setze Fälligkeitsdatum der ausgewählten Aufgabe für ...',

   'Set number of tries for all problems in the course for ...'
=> 'Setze Anzahl der Versuche aller Aufgaben des Kurses für...',

   'Set number of tries for the selected folder for ...'
=> 'Setze Anzahl der Versuche des ausgewählten Verzeichnisses für...',

   'Set number of tries for the selected problem for ...'
=> 'Setze Anzahl der Versuche der ausgewählten Aufgabe für...',

   'Set opening date for all problems in the course for ...'
=> 'Setze Bearbeitungsbeginn-Datum aller Aufgaben des Kurses für...',

   'Set opening date for the selected folder for ...'
=> 'Setzte Bearbeitsbeginn-Datum des ausgewählten Verzeichnisses für...',

   'Set opening date for the selected problem for ...'
=> 'Setze Bearbeitungsbeginn-Datum der ausgewählten Aufgabe für...',

   'Set problem weight for all problems in the course for ...'
=> 'Setze Aufgabengewichtung aller Aufgaben des Kurses für...',

   'Set problem weight for the selected folder for ...'
=> 'Setze Aufgabengewichtung des ausgewählten Verzeichnisses...',

   'Set problem weight for the selected problem for ...'
=> 'Setze Aufgabengewichtung der ausgewählten Aufgabe für...',

   'Set value to [_1] to allow.'
=> '[_1], um zu erlauben.',

   'Setting the [_1]'
=> 'Einstellung auf [_1] setzen',   

   'Setting the [_1] to [_2]'
=> 'Einstellung ändern von [_1] auf [_2]',

   'Show Problem Status (problemstatus)'
=> 'Aufgabenstatus anzeigen (problemstatus)',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Zeige Einheiten - Eintrag sperren (turnoffunit)',

   'Significant Digits (sig)'
=> 'Signifikante Stellen (sig)',

   'Student Name'
=> 'Name des Studenten',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'Die &quot; Kursbezeichnung&quot; ist der Name des Kurses, der von den Kursteilnehmern gesehen wird. Sie können diese Bezeichnung nun ändern und mit &quot;Weiter -&gt;&quot; fortfahren',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'Die Antwort auf diese Frage kann niemals richtig werden. Die folgenden Auswahlmöglichkeiten im &lt;optionresponse&gt;-Tag beinhalten unzulässige richtige Optionen',

   'There are no currently enrolled students in the course.'
=> 'Derzeit gibt es keine Kursteilnehmer im Kurs.',

   'There are no currently enrolled students in the selected sections.'
=> 'Es gibt keine derzeit eingeschriebenen Kursteilnehmer in der ausgewählen Sektion.',

   'There are no previously enrolled students in the course.'
=> 'Es gibt keine in der Vergangenheit eingeschriebenen Kursteilnehmer im Kurs.',

   'There are no previously enrolled students in the selected sections.'
=> 'Es gibt keine in der Vergangenheit eingeschriebenen Kursteilnehmer in den ausgewählten Sektionen.',

   'There are no students in the course.'
=> 'Es gibt keine Kursteilnehmer im Kurs.',

   'There are no students in the selected sections.'
=> 'Es gibt keine Kursteilnehmer in den ausgewählten Sektionen.',

   'This controls how receipt numbers are generated.'
=> 'Steuert die Erzeugung der Nachweisnummern.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'Dieses Hilfsprogramm unterstützt Sie dabei, Ihren LON-CAPA-Kurs einzurichten und zu wählen, welche Einstellungen aktiv sein werden.',

   'Unselect All Files'
=> 'Auswahl für alle Dateien aufheben',

   'Unselect All Published'
=> 'Auswahl für alle veröffentlichten Dokumente aufheben',

   'Unselect All Resources'
=> 'Auswahl für alle Ressourcen aufheben',

   'Unselect for Section/Group'
=> 'Auswahl für Sektion/Gruppe aufheben',

   'Weight (weight)'
=> 'Gewichtung (weight)',

   'Welcome to Your New LON-CAPA Course'
=> 'Willkommen in Ihrem neuen LON-CAPA-Kurs',

   'What parameter do you want to set for the selected folder?'
=> 'Welchen Parameter möchten Sie für das ausgewählte Verzeichnis setzen?',

   'What parameter do you want to set for the selected problem?'
=> 'Welchen Parameter möchten Sie für die ausgewählte Aufgabe setzen?',

   'What should the answer open date be set to?'
=> 'Auf welchen Wert soll das Antwort-Verfügbarkeits-Datum gesetzt werden?',

   'What should the due date be set to?'
=> 'Auf welchen Wert soll das Fälligkeitsdatum gesetzt werden?',

   'What weight should be set for all problems in the course?'
=> 'Auf welchen Wert soll die Gewichtung für alle Aufgaben im Kurs gesetzt werden?',

   'What weight should be set for the selected folder?'
=> 'Auf welchen Wert soll die Gewichtung für das ausgewählte Verzeichnis gesetzt werden?',

   'What weight should be set for the selected problem?'
=> 'Auf welchen Wert soll die Gewichtung der ausgewählten Aufgabe gesetzt werden?',

   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Ihr Kurs ist nun eingerichtet. Bitte klicken Sie auf "Abschließen", um den Kurs mit den vorgenommenen Einstellungen neu zu initialisieren. All diese Einstellungen können im Menüpunkt "Kurs- und Ressourcen-Parameter", Unterpunkt "Kursumgebung einstellen" geändert werden.',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Authentifizierung über Dateisystem (mit Anfangspasswort [_2])',

   'Currently Filesystem Authenticated.'
=> 'Derzeit dateisystem-authentifiziert.',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] LON-CAPA-interne Authentifizierung (mit Anfangspasswort [_2])',

   'Currently internally authenticated.'
=> 'Derzeit LON-CAPA-intern authentifiziert.',

   '[_1] Records per Page'
=> '[_1] Suchergebnisse je Seite',

   '[_1] minutes'
=> '[_1] Minuten',

   '[_1] minutes, [_2] seconds'
=> '[_1] Minuten, [_2] Sekunden',

   '[_1] with value [_2]'
=> '[_1] mit dem Wert [_2]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]zurück[_2] &nbsp; [_3]neu laden[_4] &nbsp; [_5]weiter[_6]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]zurück[_2] &nbsp; [_3]neu laden[_4] &nbsp; weiter',

   '[_2] seconds'
=> '[_2] seconds',

   'all resources in the course'
=> 'alle Ressourcen des Kurses',

   'all students in course'
=> 'alle Teilnehmer des Kurses',

   'anonymous students'
=> 'Anonyme Studenten',

   'answer date'
=> 'Antwortdatum',

   'contacting [_1]'
=> 'kontaktiere [_1]',

   'due date'
=> 'Fälligkeitsdatum',

   'for'
=> 'für',

   'for <b>all resources in the course</b>'
=> 'für <b>alle Ressourcen des Kurses</b>',

   'for <b>all students in course</b>'
=> 'für <b>alle Teilnehmer des Kurses</b>',

   'for [_1]'
=> 'für [_1]',

   'for section [_1]'
=> 'für den Sektion [_1]',

   'for the map named [_1]'
=> 'für die Inhaltszusammenstellung mit der Bezeichnung [_1]',

   'for the resource named [_1]'
=> 'für die Ressource mit der Bezeichnung [_1]',

   'from'
=> 'von',

   'from current subdirectory'
=> 'von derzeitigem Unterverzeichnis',

   'helper'
=> 'Hilfsprogramm',

   'in'
=> 'in ',

   'instructor'
=> 'Dozent',

   'number of tries'
=> 'Anzahl der Versuche',

   'opening date'
=> 'Startdatum',

   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'zurück &nbsp; [_3]neu laden[_4] &nbsp; [_5]weiter[_6]',

   'problem weight'
=> 'Gewichtung der Aufgabe',

   'role,role,...'
=> 'Rolle,Rolle,...',

   'selected students'
=> 'ausgewählte Studierende',

   'student'
=> 'Student',

   'textual_remote_display'
=> 'textual_remote_display',

   'to'
=> 'auf',

   'to [_1] ([_2])'
=> 'auf [_1] ([_2])',

   'waiting on [_1]'
=> 'warte auf [_1]',

   'what you just saw on the screen'
=> 'was Sie gerade auf dem Bildschirm gesehen haben',

#SYNC Tue Aug 15 14:43:20 2006
   'Enter my portfolio space'
=> 'Portfolio-Bereich',

   'No syllabus information provided.'
=> 'Kein Kursüberblick vorhanden.', # n.t.

   'Sorry ...'
=> 'Schade...',

   'This resource might be part of another course.'
=> 'Diese Ressource ist wahrscheinlich Bestandteil eines anderen Kurses.',

#SYNC Tue Aug 15 16:12:09 2006
   'Agree'
=> 'Trifft eher zu',

   'Any comments?'
=> 'Kommentare:',

   'Copy this column'
=> 'Kopiere diese Spalte',

   'Disagree'
=> 'Trifft eher nicht zu',

   'General Intro'
=> 'Allgemeine Einführung',

   'Greek Symbols'
=> 'Griechische Buchstaben',

   'HTML character entities'
=> 'HTML-Zeichencode',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'Wenn Sie sich diesen Text online ansehen, kopieren Sie den Eintrag in der rechten Spalte und fügen sie ihn in den Texteingabebereich ein, um das entsprechende Symbol auf der linken Seite zu erhalten.',

   'LON-CAPA Help'
=> 'LON-CAPA-Hilfe',

   'Landscape'
=> 'Querformat',

   'Launch navigation window'
=> 'Navigationsfenster starten',

   'Grade Levels'
=> 'Kursniveau',

   'Lowest Grade Level'
=> 'Niedrigstes Kursniveau',

   'Lowest Grade Level:'
=> 'Niedrigstes Kursniveau:',

   'Highest Grade Level'
=> 'Höchstes Kursniveau',

   'Highest Grade Level:'
=> 'Höchstes Kursniveau:',

   'Mark all posts read'
=> 'Alle Diskussionsbeiträge als gelesen kennzeichnen',

   'My question/comment/feedback:'
=> 'Meine Frage/Anmerkung/Feedback:',

   'Not set -'
=> 'Nicht gesetzt -',

   'Other Symbols'
=> 'Weitere Symbole',

   'Please check at least one of the following feedback types:'
=> 'Bitte wählen Sie eine der angebotenen Optionen:',

   'Please rank the following criteria:'
=> 'Bitte evaluieren Sie die folgenden Kriterien:',

   'Portrait'
=> 'Hochformat',

   'Question about resource content'
=> 'Frage zum Inhalt der Ressource',

   'Question/Comment/Feedback about course policy'
=> 'Frage/Anmerkung/Feedback zu Regeln des Kurses ',

   'Select a Course to Enter'
=> 'Wählen Sie den gewünschten Kurs aus',

   'Sending Messages'
=> 'Sende Nachricht',

   'Show Me My First Homework Problem'
=> 'Zeige erste Übungsaufgabe',

   'Standards'
=> 'Standards',

   'Strongly Agree'
=> 'Trifft völlig zu',

   'Strongly Disagree'
=> 'Trifft überhaupt nicht zu',

   'Symbol'
=> 'Symbol',

   'The material appears to be correct'
=> 'Das Material scheint korrekt zu sein',

   'The material is helpful'
=> 'Das Material ist hilfreich',

   'The material is presented in a clear way'
=> 'Das Material wird in einer verständlichen Art dargestellt',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc)'
=> 'Die Ressource ist technisch einwandfrei (lädt ausreichend schnell, erzeugt keine Fehlermeldungen, verlinkte Seiten sind erreichbar, etc.)',


#SYNC Fri Aug 18 20:46:54 2006
   'HTML character enties'
=> 'HTML-Zeichen-Entitys',



#SYNC Sat Aug 19 09:31:18 2006
   '"Waiting for Remote Control window to load: "+[_1]'
=> '"Warte auf das Laden der Fernbedienung: "+[_1]',

   '<a href="[_1]">Continue</a> on in Inline Menu mode'
=> '<a href="[_1]">Weiter</a> im Kopfzeilenmenü-Modus',

   'All posts'
=> 'Alle Diskussionsbeiträge',

   'Change Color Scheme'
=> 'Farben',

   'Change Colors'
=> 'Farben',

   'Change Discussion Display Preferences'
=> 'Darstellung der Diskussionsbeiträge',

   'Change How Math Equations Are Displayed'
=> 'Darstellung wissenschaftlicher Formeln',

   'Change Language'
=> 'Sprache',

   'Change Language Preferences'
=> 'Sprache',

   'Change Message Forwarding and Notification Email Addresses'
=> 'Nachrichtenweiterleitung und Benachrichtigung',

   'Change Password'
=> 'Passwort ändern',

   'Change Preferences'
=> 'Benutzereinstellungen', # 'Präferenzen ändern'

   'Change Roles Page Preferences'
=> 'Schnellzugriffsliste für Benutzerrollen',

   'Change Screen Name'
=> 'Nicknamen',

   'Change Screenname'
=> 'Nicknamen ändern',

   'Change WYSIWYG Editor Preferences'
=> 'WYSIWYG-Editor',

   'Contact Helpdesk'
=> 'Helpdesk kontaktieren',

   'Current discussion settings'
=> 'Einstellung für diesen Diskussionsbeitrag',

   'Duedate'
=> 'Fälligkeitsdatum',

   'Each post can be toggled read/unread'
=> 'Jeder Diskussionsbeitrag kann zwischen als gelesen und als ungelesen umgeschaltet werden',

   "Edit the 'About Me' Personal Information Screen"
=> "Über-mich-Seite", # "Persönliche-Informationen-Seite ('Über mich')",

   'Enable WYSIWYG Editor'
=> 'WYSIWYG-Editor verwenden',

   'End of Sequence'
=> 'Ende der Sequenz',

   'Entering Course'
=> 'Betrete Kurs',

   'Get help'
=> 'Hilfe abrufen',

   'Go to main menu'
=> 'Zum Hauptmenü wechseln',

   'Has New Discussion'
=> 'Neue Diskussionsbeiträge',

   'Launching of the Remote Control menu will fail if pop-up window filters are active. To use the Remote Control, disable the filter for this site.'
=> 'Das Starten der Fernbedienung wird scheitern, wenn ein Filter gegen Pop-Up-Fenster aktiviert ist. Um die Fernbedienung zu verwenden, deaktivieren Sie diesen Filter für diese Webseite.',

   'Navigate Course Content'
=> 'Inhaltsverzeichnis',

   'New posts only'
=> 'Nur neue Diskussionsbeiträge',

   'No Resource'
=> 'Keine Ressource',

   'No syllabus available'
=> 'Kein Kursüberblick verfügbar',

   'Not currently assigned.'
=> 'Derzeit nicht als Aufgabe gestellt.',

   'Not new'
=> 'Nicht neu',

   'Off'
=> 'Aus',

   'On'
=> 'An',

   'Once displayed'
=> 'sobald angezeigt',

   'Once marked not NEW'
=> 'sobald als nicht NEU markiert',

   'Please click on the the resource you intend to access'
=> 'Bitte klicken Sie auf die Ressource, auf die Sie zugreifen wollen',

   'Posts cease to be marked "NEW"'
=> 'Beiträge nicht mehr als "NEU" kennzeichnen',

   'Posts to be displayed'
=> 'Diskussionsbeiträge, die angezeigt werden sollen',

   'Role selected. Please stand by.'
=> 'Rolle ausgewählt. Bitte warten.',

   'Send'
=> 'Senden',

   'Set User Preferences'
=> 'Benutzereinstellungen',

   'Show Preview and Check Spelling'
=> 'Zeige Vorschau und prüfe Rechtschreibung',

   'Sort by:'
=> 'Sortieren nach:',

   'The external menu (Remote Control) has been disabled, and you will be working with the smaller inline menu. You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser. To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> 'Die Fernbedienung wurde deaktiviert und durch das Kopfzeilenmenu ersetzt. Sie haben entweder das Fernbedienungsfenster geschlossen oder es wurde durch einen Filter für Pop-Up-Fenster von Ihrem Webbrowser geblockt. Um die Fernbedienung in solch einem Fall dennoch zu verwenden, deaktivieren Sie den Filter für diese Webseite und aktivieren Sie die Fernbedienung aus dem Kopfzeilenmenü erneut.', # n.t.

   'There are several possibilities of where to go next'
=> 'Es gibt mehrere Möglichkeite, wohin Sie als nächstes gehen können',

   'To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> 'Um die Fernbedienung zu verwenden, deaktivieren Sie den Filter gegen Pop-Up-Fenster für diese Webseite und starten die Fernbedienung aus dem Kopfzeilenmenü erneut.',

   'Toggle read/unread'
=> 'Umschalten zwischen gelesen/ungelesen',

   'Unread only'
=> 'Nur ungelesene',

   "View this user's personal page"
=> "Persönliche Über-mich-Seite dieses Nutzers betrachten",

   'You have reached the end of the sequence of materials.'
=> 'Sie haben das Ende der Sequenz von Lehrmaterialien erreicht.',

   'You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser.'
=> 'Sie haben entweder das Fernbedienungsfenster geschlossen oder es wurde vom Filter gegen Pop-Up-Fenster Ihres Webbrowsers blockiert.',

   'attachments'
=> 'Anhänge',

   'info[_1]'
=> 'info[_1]',

   'prepare[_1]'
=> 'prepare[_1]',

   'printout[_1]'
=> 'printout[_1]',

   'tations[_1]'
=> 'tations[_1]',

   'this[_1]'
=> 'this[_1]',


#SYNC Sat Aug 19 11:48:11 2006
   'About User'
=> 'Über-mich-Seite',

   'All documents out of a published map into this folder'
=> 'Alle Dokumente aus einer veröffentlichten Inhaltszusammenstellung in dieses Verzeichnis',

   'Change Math Pref'
=> 'Darstellung wissenschaftl. Formeln',

   'Change Math Preferences'
=> 'Darstellung wissenschaftlicher Formeln',

   'Comment'
=> 'Kommentar',

   'Communication/Messages'
=> 'Kommunikation und Nachrichten',

   'Configure blocking of student communication during exams'
=> 'Blockieren von studentischer Kommunikation während Prüfungen konfigurieren',

   'Convert to Images'
=> 'In Grafik konvertieren',

   'Course and Catalog Search'
=> 'Kurs- und Katalog-Suche',

   'Create Subdirectory'
=> 'Erzeuge Unterverzeichnis',

   'Create subdirectory in current directory:'
=> 'Erzeuge neues Unterverzeichnis im aktuellen Verzeichnis:',

   'Critical'
=> 'Wichtig',

   'Currently no documents.'
=> 'Zurzeit keine Dokumente.',

   'Enter terms or phrases, then press "Search" below'
=> 'Geben Sie Suchbegriffe oder -Sätze ein und klicken Sie dann unten auf "Suchen"',

   'INBOX'
=> 'POSTEINGANG',

   'If HTML file, upload embedded images/multimedia files'
=> 'Bei HTML-Dateien:<br />Eingebettete Bilder und Multimedia-Dateien mit hochladen', # 'Wenn HTML-Datei, eingebettete Bilder-/Multimedia-Dateien hochladen',

   'Import IMS package'
=> 'Importiere IMS-Paket',

   'Import a document'
=> 'LON-CAPA-interne Dokumente',

   'Make New Folder'
=> 'Neues Verzeichnis erstellen',

   'New Composite Page'
=> 'Neue zusammengesetzte Seite',

   'New Messages Only'
=> 'Nur neue Nachrichten',

   'Portfolio Manager'
=> 'Portfolio-Verwaltung',

   'Preferred method to display Math'
=> 'Bevorzugte Methode, um wissenschaftliche Formeln darzustellen',

   'Published documents'
=> 'Veröffentlichte Dokumente',

   'Recover Deleted Resources'
=> 'Entfernte Ressourcen wiederherstellen',

   'Send a Message'
=> 'Nachricht versenden',

   'Sent Messages'
=> 'Gesendet',

   'Show'
=> 'Zeige',

   'TRASH'
=> 'Gelöscht',

   'TeX to HTML'
=> 'TeX nach HTML',

   'Upload'
=> 'Hochladen',

   'Upload file to current directory:'
=> 'Datei in aktuelles Verzeichnis laden:',

   'View Folder'
=> 'Verzeichnis betrachten',

   'fulltext search (time consuming)'
=> 'Volltextsuche (zeitaufwändig)',

   'search discussion postings (resources and bulletin boards)'
=> 'Suche in Diskussionsbeiträgen (Ressourcen und Bulletin-Boards)',


#SYNC Sat Aug 19 11:49:40 2006
   'Roles'
=> 'Rollen',


#SYNC Sat Aug 19 12:35:56 2006
   'Select style file'
=> 'Stil-Datei auswählen',

   '(mark them then click "next" button)'
=> '(markieren und dann auf "Weiter" klicken)',

   '100 Level'
=> '1. Studienjahr',

   '200 Level'
=> '2. Studienjahr',

   '300 Level'
=> '3. Studienjahr',

   '400 Level'
=> '4. Studienjahr',

   'Action'
=> 'Aktion',

   'Actions for current directory'
=> 'Aktionen für dieses Verzeichnis',

   'Change Discussion Preferences'
=> 'Ändere Präferenzen für Diskussionen',

   'Change Message Forwarding/Notification'
=> 'Nachrichtenweiterleitung und Benachrichtigung',

   'Change WYSIWYG Preferences'
=> 'WYSIWYG-Editor',

   'Change to '
=> 'Ändern in ',

   'Clean Up'
=> 'Aufräumen',

   'Closed - XML source is closed to everyone'
=> 'Gesperrt - XML-Quellcode ist für alle gesperrt',

   'Copy'
=> 'Kopieren',

   'Create a new directory or LON-CAPA document'
=> 'Neue Ressource oder neues Verzeichnis erstellen',

   'Current setting '
=> 'Derzeitige Eintellung ',

   'Delete Directory'
=> 'Verzeichnis löschen',

   'Delete directory'
=> 'Verzeichnis löschen',

   'Delete this resource'
=> 'Ressource löschen', # long version: 'Lösche diese Ressource',

   'Disable WYSIWYG editor'
=> 'WYSIWYG-Editor nicht verwenden',

   'Display Preference'
=> 'Darstellungs-Präferenz',

   'Edit catalog information'
=> 'Katalogisierungsdaten editieren',

   'Enable WYSIWYG editor'
=> 'WYSIWYG-Editor verwenden',

   'Grade 1'
=> '1. Klasse',

   'Grade 10'
=> '10. Klasse',

   'Grade 11'
=> '11. Klasse',

   'Grade 12'
=> '12. Klasse',

   'Grade 13'
=> '13. Klasse',

   'Grade 2'
=> '2. Klasse',

   'Grade 3'
=> '3. Klasse',

   'Grade 4'
=> '4. Klasse',

   'Grade 5'
=> '5. Klasse',

   'Grade 6'
=> '6. Klasse',

   'Grade 7'
=> '7. Klasse',

   'Grade 8'
=> '8. Klasse',

   'Grade 9'
=> '9. Klasse',

   'Graduate Level'
=> 'Graduierten-Niveau',

   'List current directory'
=> 'Verzeichnis', # long version: 'Aktuelles Verzeichnis anzeigen',

   'Mark obsolete'
=> 'Als überholt markieren',

   'Move'
=> 'Verschiebe',

   'New library file'
=> 'Neue Programmbibliotheks-Datei',

   'No file: [_1]'
=> 'Datei nicht vorhanden: [_1]',

   'No personal information provided'
=> 'Keine Informationen zur Person zur Verfügung gestellt',

   'Not specified'
=> 'Nicht spezifiziert',

   'Once marked as read'
=> 'Sobald als gelesen markiert',

   'Open - XML source is open to people who want to use it'
=> 'Lesbar - XML-Quellcode ist für interessierte Autoren lesbar',

   'Points Display'
=> 'Bewertungs-Informationen',

   'Points Scored'
=> 'Erreichte Punkte',

   'Posts displayed?'
=> 'Welche Beiträge sollen angezeigt werden?',

   'Preferences can be set that determine'
=> 'Präferenzen können eingestellt werden, die festlegen...',

   'Print contents of directory'
=> 'Inhalte diese Verzeichnis drucken',

   'Print directory'
=> 'Verzeichnis drucken',

   'Problem Document'
=> 'Aufgaben-Dokument',

   'Publish this Directory'
=> 'Dieses Verzeichnis veröffentlichen',

   'Publish this resource'
=> 'Veröffentlichen', # long version: 'Diese Ressource veröffentlichen',

   'Re-publish'
=> 'Neu veröffentlichen',

   'Retrieve old version'
=> 'Alte Version wiederherstellen',

   'Select action'
=> 'Aktion auswählen',

   'Send message'
=> 'Nachricht versenden',

   'Set display preferences for discussion posts for both bulletin boards and individual resources in all your courses.'
=> 'Hier können Sie festlegen, wie Diskussionsbeiträge, Nachrichten an Schwarzen Brettern und einzelne Ressourcen in allen Ihren Kursen angezeigt werden sollen.',

   'Show all foils'
=> 'Alle Auswahlmöglichkeiten anzeigen',

   'Source Distribution'
=> 'Zugriffsrechte auf Quellcode',

   'The preferences you set here can be overridden within each individual discussion.'
=> 'Die Einstellungen, die Sie hier vornehmen, können bei jedem Diskussionsbeitrag individuell geändert werden.',

   'Under what circumstances posts are identfied as "New"'
=> 'unter welchen Bedingungen Beiträge als "NEU" identifiziert werden',

   'Upload a new document'
=> 'Externes Dokument hochladen',

   'Use random seed'
=> 'Zufallszahlen-Basis',

   'Use style file'
=> 'Verwende Stil-Datei',

   'Which posts are displayed when you display a bulletin board or resource, and'
=> 'welche Nachrichten angezeigt werden, wenn Sie ein Schwarzes Brett bzw. eine Ressource anzeigen',

   'closed'
=> 'Quellcode gesperrt', # !

   'del.gif'
=> 'del.gif',

   'delete[_1]'
=> 'lösche[_1]',

   'dir[_1]'
=> 'dir[_1]',

   'list.gif'
=> 'list.gif',

   'list[_1]'
=> 'Liste[_1]',

   'open'
=> 'Quellcode öffentlich', # !

   'pub.gif'
=> 'pub.gif',

   'publish[_1]'
=> 'veröffentliche [_1]',

   'resource[_2]'
=> 'Ressource[_2]',

   'retrieve[_1]'
=> 'wiederherstellen[_1]',

   'rtrv.gif'
=> 'rtrv.gif',

   'version[_1]'
=> 'Version[_1]',


#SYNC Fri Sep  1 16:36:19 2006
   '(mark desired resources then click "next" button)'
=> '(markieren Sie gewünschte Ressourcen und klicken Sie dann auf "Weiter")',

#   '<b>Change</b> for just <a href="/adm/whatsnew?command=courseinit&amp;refpage=[_1]">this course</a>'
#=> '<b>Änderen:</b> nur für <a href="/adm/whatsnew?command=courseinit&amp;refpage=[_1]">diesen Kurs</a>',

#   'or for all <a href="/adm/preferences?action=changecourseinit&amp;refpage=[_1]">your courses</a>.'
#=> 'oder für alle <a href="/adm/preferences?action=changecourseinit&amp;refpage=[_1]">Ihre Kurse</a>',

   '<b>Change</b> for just [_1]this course[_2] or for all [_3]your courses[_2].'
=> '<b>Ändern:</b> nur für [_1]diesen Kurs[_2] oder für alle [_3]Ihre Kurse[_2].',

   "Page displayed after role selection in course now set by <b>user's global preferences</b>."
=> "Seite, die nach Betreten des Kurses angezeigt werden soll, wird nun durch Ihre <b>allgemeinen Benutzereinstellungen</b> gesteuert.",

   "Page displayed after role selection in this course set to <b>[_2]</b>"
=> "Seite, die nach Betreten des Kurses angezeigt werden soll, wurde auf <b>[_2]</b> gesetzt.",

   'Add or Edit Blog Entries'
=> 'Blog-Einträge hinzufügen oder bearbeiten',

   'Add to my public course blog'
=> 'Zu meinem öffentlichen Kurs-Blog hinzufügen',

   'Annotator'
=> 'Annotator',

   'Av. Attempts'
=> 'Mittlere Anzahl an Versuchen',

   'Available RSS Feeds and Blogs'
=> 'Verfügbare RSS-Feeds und Blogs',

   'Average number of attempts'
=> 'Durchschnittliche Anzahl an Versuchen',

   'Bookmarks'
=> 'Lesezeichen',

   'Change interval?'
=> 'Intervall ändern',

   'Change options?'
=> 'Optionen ändern',

   'Change thresholds?'
=> 'Schwellenwerte ändern',

   'Clean up'
=> 'Aufräumen',

   'Close Folder'
=> 'Verzeichnis schließen',

   'Configure Blocking of Student Communication during Exams'
=> 'Kommunikationssperre einrichten', # 'Blockieren studentischer Kommunikation während Prüfungen konfigurieren',

   'Course Action Items'
=> 'Kurs-Aktionselemente',

   'Creating PDF'
=> 'Erstellung PDF-Datei',

   'Currently: [_1].'
=> 'Zurzeit: [_1].',

   'Deg. Diff'
=> 'Schwierigkeitsgrad',

   'Description'
=> 'Beschreibung',

   'Display Action Items'
=> 'Aktionselemente anzeigen',

   'Enter my groups in the course'
=> 'Meine Kursgruppen',

   'Entering [_1]'
=> 'Betrete [_1]',

   'Entering [_1] ...'
=> 'Betrete [_1]...',

   'First resource'
=> 'Erste Ressource',

   'Generated [_1] ([_2] bytes)'
=> 'Erzeugt am [_1] ([_2] Bytes)',

   'Go to first resource'
=> 'Gehe zur ersten Ressource',

   'Group Documents'
=> 'Gruppen-Dokumente',

   'Groups'
=> 'Gruppen',

   'Help Menu'
=> 'Hilfemenü',

   'Hide all'
=> 'Alle verbergen',

   'Hide this Feed'
=> 'Diesen Feed verbergen',

   'LON-CAPA Feed "[_1]" for [_2]'
=> 'LON-CAPA-Feed "[_1]" für [_2]',

   'Last Reset'
=> 'Letzte Zurücksetzung',

   'Last revised'
=> 'Letzte Änderung',

   'Link'
=> 'Link',

   'Log In'
=> 'Anmelden',

   'Move Checked to Folder'
=> 'Verschiebe Auswahl in Verzeichnis',

   'Name for New Feed'
=> 'Name des neuen Feed',

   'Name of this Feed'
=> 'Name dieses Feeds',

   'New course messages'
=> 'Neue Kursnachrichten',

   'New critical messages in course'
=> 'Neue wichtige Kursnachrichten',

   'New in course'
=> 'Neu im Kurs',

   'New version'
=> 'Neue Version',

   'No messages sent.'
=> 'Keine Nachrichten verschickt.',

   'No new course messages'
=> 'Keine neuen Kursnachrichten',

   'No personal information provided'
=> 'Keine persönlichen Informationen zur Verfügung gestellt',

   'No problems require handgrading'
=> 'Keine Aufgaben müssen manuell bewertet werden',

   'No problems satisfy threshold criteria'
=> 'Keine Aufgaben erfüllen die Schwellenkriterien',

   'No problems with errors'
=> 'Keine Aufgaben mit Fehlern',

   'No unread critical messages in course'
=> 'Kein ungelesenen wichtigen Kursnachrichten',

   'No unread posts in course discussions'
=> 'Kein ungelesenen Beiträge in Kursdiskussionsforen',

   'No updated versions'
=> 'Keine aktualisierten Versionen',

   'Num. students'
=> 'Studierendenanzahl',

   'Number of errors'
=> 'Fehleranzahl',

   'Number of new posts'
=> 'Anzahl neuer Diskussionsbeiträge',

   'Number ungraded'
=> 'Anzahl nicht bewerteter',

   'Open Folder'
=> 'Verzeichnis öffnen',

   'Open all folders'
=> 'Alle Verzeichnisse öffnen',

   'Page set to be displayed after you have selected a role in this course'
=> 'Seite, die angezeigt werden soll, nachdem Sie eine Rolle in diesem Kurs ausgewählt haben',

   'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role'
=> 'Bitte wählen Sie den Typ der LON-CAPA-Entität - Kurs oder Gruppe - für den Sie die Benutzerrolle hinzufügen/ändern wollen.',

   'Please stand by while processing your print request, this may take some time ...'
=> 'Ihr Druckauftrag wird bearbeitet. Dies kann einige Zeit dauern. Bitte warten Sie...',

   'Print contents of directory'
=> 'Inhalte des Verzeichnisses drucken',

   'Print directory'
=> 'Verzeichnis drucken',

   'Problem'
=> 'Aufgabe',

   'Problem Document'
=> 'Aufgabe',

   'Problem Name'
=> 'Aufgabenbezeichnung',

   'Problem is not open to be viewed. It'
=> 'Aufgabe nicht zur Betrachtung freigegeben. Es',

   'Problems requiring handgrading'
=> 'Aufgaben, die manuell bewertet werden müssen',

   '(Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2]) [_3] and total number of students with submissions &ge; [_4]'
=> '(Aufgaben mit durchschnittlicher Anzahl an Versuchen &ge; [_1] oder Schwierigkeitsgrad &ge; [_2]) [_3] und insgesamte Anzahl an Studierenden, die etwas eingereicht haben &ge; [_4]',

   'Problems with errors'
=> 'Aufgaben mit Fehlern',

   'Re-publish'
=> 'Neu veröffentlichen',

   'Recently generated printouts'
=> 'Zuletzt erzeugte Ausdrucke',

   'Reset Count?'
=> 'Zähler zurücksetzen?',

   'Reset counters to 0'
=> 'Zähler auf 0 zurücksetzen',

   'Select [_1]'
=> 'Wähle [_1]',

   'Select the sequence to print resources from:'
=> 'Wählen Sie die Sequenz, aus der Ressourcen gedruckt werden sollen:',

   'Selected <b>Problems</b> in folder <b><i>[_1]</i></b>'
=> 'Bestimmte <b>Aufgaben</b> im Verzeichnis <b><i>[_1]</i></b>',

   'Selected <b>Resources</b> in folder <b><i>[_1]</i></b>'
=> 'Bestimmte <b>Ressourcen</b> im Verzeichnis <b><i>[_1]</i></b>',

   'Send Message'
=> 'Nachricht versenden',

   'Show all'
=> 'Alle anzeigen',

   'Show my first due problem'
=> 'Zeige meine erste zu bearbeitende Aufgabe',

   'Show only uncompleted problems'
=> 'Zeige nur nicht erledigte Aufgaben',

   'Show everything'
=> 'Alles anzeigen',

   'Uncompleted Problems'
=> 'Nicht erledigte Aufgaben',

   'All homework assignments have been completed.'
=> 'Alle Übungsaufgaben sind erledigt.',

   'Speller Suggestions'
=> 'Speller Suggestions',

   'Start a New Feed'
=> 'Neuen Feed starten',

   'Save Marked Changes'
=> 'Markierte Änderungen speichern',

   'Save changes'
=> 'Änderungen speichern',

   'The preferences you set here can be overridden within each individual discussion.'
=> 'Die hier einstellbaren Präferenzen können innerhalb jedes Diskussionsbeitrages geändert werden.',

   'This action is currently not authorized.'
=> 'Diese Aktion ist zurzeit nicht erlaubt.',

   'Time of last post'
=> 'Uhrzeit des letzten Beitrags', #??? [SB 20.10.2006]

   'Title of document goes here'
=> 'Dokumententitel hier eintragen',

   'Body of document goes here'
=> 'Hauptinhalt des Dokuments kommt hier hin',

   'Total number of students with submissions'
=> 'Gesamtzahl an Studierenden, die etwas eingereicht haben',

   'Unread course discussion posts'
=> 'Ungelesene Kursdiskussionsbeiträge',

   'Version used'
=> 'verwendete Version',

   'Version[_1]'
=> 'Version[_1]',

   'View current problem status and grading information'
=> 'Bewertungs-Informationen',

   "What's New?"
=> "Was gibt's Neues?",

   "What's New? page"
=> "Was-gibt's-Neues-Seite",

   'You are accessing an invalid course'
=> 'Sie versuchen auf einen ungültigen Kurs zuzugreifen.',

   'course only'
=> 'nur Kurs',

   'delete'
=> 'Löschen',

   'first resource in the course'
=> 'erste Kursressource',

   'grps.gif'
=> 'grps.gif',

   'hidden'
=> 'verborgen',

   'list[_1]'
=> 'list[_1]',

   'new feed'
=> 'new feed',

   'since last month'
=> 'seit letztem Monat',

   'since last week'
=> 'seit letzter Woche',

   'since start of course'
=> 'seit Kursbeginn',

   'since yesterday'
=> 'seit gestern',

   'specific setting for this course'
=> 'spezifische Einstellung für diesen Kurs',

   'test.problem'
=> 'test.problem',

   'user preference'
=> 'Benutzerpräferenz',

   'version[_1]'
=> 'Version[_1]',

   "what's new? page"
=> "Was-gibt's-Neues-Seite",

   'your general user preferences'
=> 'Ihre allgemeinen Benutzerpräferenzen',


#SYNC Fri Sep  1 17:10:10 2006
   'Submitting as Comment'
=> 'Kommentar wird gesendet',

   'Submitting as Policy Feedback'
=> 'Feedback zu Kursrichtlinien wird gesendet',

   'Submitting as Question'
=> 'Frage wird gesendet',

   'Total Points In Course'
=> 'Gesamtpunkte im Kurs',

   'You are accessing an invalid course'
=> 'Sie versuchen auf einen ungültigen Kurs zuzugreifen',

   'the resource you just saw on the screen'
=> 'die zuletzt betrachtete Ressource',


#SYNC Fri Sep  1 22:23:03 2006
   'Annotations'
=> 'Notizen',

   'Close (no save)'
=> 'Schließen (ohne Speichern)',

   'Save and Update'
=> 'Speichern und aktualisieren',


#SYNC Fri Sep  1 22:39:12 2006
   'Bookmark Tree Viewer/Editor'
=> 'Lesezeichenbaum-Anzeige/Editor',

   'Chat'
=> 'Chat',

   'Chat room'
=> 'Chatroom',

   'Download your Calendar as iCalendar File'
=> 'Kalender-Download im iCalendar-Format',

   'Drop Box'
=> 'Drop Box',

   'Import Bookmarks'
=> 'Lesezeichen importieren',

   'The LearningOnline Network with CAPA'
=> 'The LearningOnline Network with CAPA',

   'This LON-CAPA server is temporarily not available for login.'
=> 'Dieser LON-CAPA-Server ist derzeit zum Anmelden nicht verfügbar.',

   'Please attempt to login to one of the following servers:'
=> 'Bitte versuchen Sie sich an einem der folgenden Server anzumelden:',


#SYNC Fri Sep  1 23:07:39 2006
   'Although your current role has privileges to view any existing groups in thiscourse, you do not have privilegesto create new groups.'
=> 'Obwohl Sie in Ihrer derzeitigen Rolle über das Recht verfügen alle Gruppen in diesem Kurs anzusehen, haben Sie nicht das Recht neue Gruppen zu erzeugen.',

   'Collaborative Tools'
=> 'Kollaborative Werkzeuge',

   'Course content'
=> 'Kursinhalt',

   'Create a new group'
=> 'Neue Gruppe erstellen',

   'Created'
=> 'Erstellt',

   'Creator'
=> 'Ersteller',

   'Discussion Boards'
=> 'Diskussionsforen',

   'Disk Use (%)'
=> 'Speicherplatzverbrauch (%)',

   'Enable Recent Roles Hotlist:'
=> 'Verwende Schnellzugriff für zuletzt verwendete Rollen:',

   'Erster Kurs'
=> 'Erster Kurs',

   'Files'
=> 'Dateien',

   'Group Name'
=> 'Gruppenname',

   'Group Title'
=> 'Gruppentitel',

   'Members'
=> 'Mitglieder',

   'Modify'
=> 'Verändern',

   'No groups exist.'
=> 'Es existieren keine Gruppen.',

   'Number of roles in Hotlist:'
=> 'Anzahl der Rollen in Schnellzugriffsliste:',

   'Quota (Mb)'
=> 'Speicherplatz (MB)',

   'Remote Control'
=> 'Fernbedienung',

   'Some LON-CAPA users have a long list of roles. The Recent Roles Hotlist feature keeps track of the last N roles which have been visited and places a table of these at the top of the roles page. People with very few roles should leave this feature disabled.'
=> 'Einige LON-CAPA-Benutzer haben sehr viele Rollen. Der Schnellzugriff auf zuletzt verwendete Rollen speichert die letzten n Rollen, die Sie verwendet haben und bietet Ihnen eine Liste mit diesen Rollen am Anfang Ihrer Rollenauswahlseite. Benutzer mit nur wenigen Rollen sollten diese Schnellzugriffsliste deaktiviert lassen.',

   'Some LON-CAPA users have a long list of courses. The Recent Courses Hotlist feature keeps track of the last N courses which have been visited and places a table of these at the top of the courses page. People with very few courses should leave this feature disabled.'
=> 'Einige LON-CAPA-Benutzer haben sehr viele Kurse belegt. Der Schnellzugriff auf zuletzt verwendete Kurse speichert die letzten n Kurse, die Sie verwendet haben und bietet Ihnen eine Liste mit diesen Kursen am Anfang Ihrer Kursauswahlseite. Benutzer mit nur wenigen Kursen sollten diese Schnellzugriffsliste deaktiviert lassen.',

   'Switch to Inline Menu Mode'
=> 'Zum Modus mit Kopfzeilenmenü wechseln',

   'This list below can be used to <q>freeze</q> roles on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.'
=> 'Die nachfolgende Liste kann verwendet werden, um Rollen <q>einzufrieren</q>. Rollen, die als eingefroren markiert wurden, werden nicht aus der Liste beseitigt werden, selbst wenn sie in letzter Zeit nicht verwendet wurden.',

   'View Status'
=> 'Status anzeigen',

   'View/Change Status'
=> 'Status anzeigen/ändern',

   'You are not currently a member of any active [_1]s in this [_2]'
=> 'Sie sind zurzeit nicht Mitglied einer aktiven [_1] in diesem [_2]',

   'with related words'
=> 'mit ähnlichen Wörtern',

   'with no related words'
=> 'ohne ähnliche Wörter',


#SYNC Fri Sep  1 23:29:38 2006
   'Change Roles Preferences'
=> 'Rollenpräferenzen ändern',

   'Display [_1] Most Recent Roles'
=> 'Zeige [_1] der zuletzt verwendeten Rollen',

   'Freeze Role'
=> 'Rolle einfrieren',

   'Recent Roles Hotlist is Disabled'
=> 'Schnellzugriffsliste für zuletzt verwendete Rollen wird nicht verwendet',

   'Recent Roles Hotlist is Enabled'
=> 'Schnellzugriffsliste für zuletzt verwendete Rollen wird verwendet',


#SYNC Sat Sep  2 00:00:45 2006
   'Author Space'
=> 'Autorenbereich',

   'Degree of discrimination'
=> 'Grad der Abgrenzung',

   'Disable WYSIWYG Editor'
=> 'WYSIWYG-Editor deaktivieren',

   'Hypertext Document'
=> 'HTML-Dokument',

   'Last Modifying User'
=> 'Benutzer, der zuletzt geändert hat',

   'Last Revision Date'
=> 'Datum der letzten Überarbeitung',

   'Linked/Related Resources'
=> 'Verknüpfte/Verwandte Ressourcen',

   'Network-wide courses using resource'
=> 'Netzwerkweite Kurse, die diese Ressource verwenden',

   'Never'
=> 'Niemals',

   'Preview'
=> 'Vorschau',

   'Resources that follow this resource in maps'
=> 'Ressourcen, die in einer Inhaltszusammenstellung Nachfolger dieser Ressource sind',

   'Resources that lead up to this resource in maps'
=> 'Ressourcen, die in einer Inhaltszusammenstellung Vorläufer dieser Ressource sind',

   'Resources used by this resource'
=> 'Ressourcen, die von dieser Ressource verwendet werden',

   'Resources using or importing resource'
=> 'Ressourcen, die diese Ressource benutzen', #??? [SB 18.10.2006]

   'Return'
=> 'Zurück',

   'Selected <b>Problems</b> from current subdirectory <b><i>[_1]</i></b>'
=> 'Ausgewählte <b>Aufgaben</b> aus aktuellem Unterverzeichnis <b><i>[_1]</i></b>',

   'Setting WYSIWYG editor to:'
=> 'Setze WYSIWYG-Editor auf:',

   'Source Available'
=> 'Quellcode verfügbar',

   'Source Custom Distribution File'
=> 'Datei zum Maßschneidern der Zugriffsrechte für Quellcode',

   'Start new page<br />before selected'
=> 'Start new page<br />before selected',

   'on'
=> 'an',


#SYNC Sat Sep  2 20:43:30 2006
   '(re-initialize course to access)'
=> '(Kurs neu initialisieren, um Zugriff zu erhalten)',

   'All Parts'
=> 'Alle Teile',

   'Changes will become active for your current session after [_1], or the next time you log in.'
# => 'Um die Änderungen für die aktuelle Sitzung zu übernehmen, klicken Sie [_1] oder melden Sie sich neu an.',
# => '[_1] Hier klicken, um die letzten Änderungen sofort zu übernehmen.'
=> 'Klicken Sie auf [_1], um die letzten Änderungen sofort zu übernehmen.',

   'Cut'
=> 'Ausschneiden',

   'Due and Answer Available'
=> 'Fällig, Antwort verfügbar',

   'Dump [_1] DOCS'
=> 'Dump [_1] DOCS',

   'Edit any group in the course'
=> 'Kursgruppen verwalten',

   'Editing the Table of Contents for your Course'
=> 'Wie bearbeite ich den Inhalt des Kurses',

   'Enter any group in the course'
=> 'Einer beliebigen Gruppe des Kurses beitreten',

   'Existing Parameter Settings for Your Resources'
=> 'Bestehende Parameter-Einstellungen für Ihre Ressourcen',

   'Export Course to IMS'
=> 'IMS-Export',

   'Group'
=> 'Gruppe',

   'Hidden'
=> 'Verborgen',

   'List Symbs'
=> 'Interne Bezeichner',

   'Symb List'
=> 'Liste interner Bezeichner',

   'Manage Course Slots'
=> 'Kurs-Slots verwalten',

   'Manage student enrollment '
=> 'Studentische Kursbelegungen verwalten ',

   'Modify Resource Parameters - Overview Mode'
=> 'Ändern von Ressourcen-Parametern - Übersichtsmodus',

   'Modify parameter settings (due dates, etc) for resources and the course'
=> 'Kurs- und Ressourcen-Parameter',

   'Modify parameter settings for this resource'
=> 'Parametereinstellungen', # long version: 'Parametereinstellungen für diese Ressource ändern',

   'New and Existing Parameter Settings for Your Resources'
=> 'Neue und bestehende Parameter-Einstellungen für die Ressourcen',

   'Parameter Change Log and Course Blog Posting/User Notification'
=> 'Parameteränderungs-Protokoll und Kurs-Blog-Einträge/Benutzer-Benachrichtigung',

   'Parameter Manager'
=> 'Kurs- und Ressourcen-Parameter',

   'Randomly Pick: '
=> 'Wähle zufällig: ',

   'Remove'
=> 'Entfernen',

   'Rendering'
=> 'Rendern',

   'Select Parameters to View'
=> 'Auswahl der Parameter, die angezeigt werden sollen',

   'Select Parts to View'
=> 'Auswahl der anzuzeigenden Aufgabenteile',

   'Set Parameter Setting Default Actions'
=> 'Setze Parameter-Einstellungen für Default-Aktionen',

   'Set Portfolio Metadata'
=> 'Portfolio-Metadaten',

   'Set/Modify Resource Parameters - Helper Mode'
=> 'Ressourcen-Parameter - Hilfsmodus',

   'Set/Modify Resource Parameters - Overview Mode'
=> 'Ressourcen-Parameter - Übersichtsmodus',

   'Set/Modify Resource Parameters - Table Mode'
=> 'Ressourcen-Parameter - Tabellenmodus',

   'Settings for Your Course'
=> 'Kurs-Einstellungen',

   'Table Mode'
=> 'Tabellenmodus',

   'Table Mode Parameter Setting'
=> 'Tabellenmodus-Parameter-Einstellungen',

   'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".'
=> 'Die Ressourcen in "[_1]" können nur zeitlich begrenzt bearbeitet werden. Sobald Sie auf "[_2]" klicken, haben Sie [_3], um alle Ressourcen in "[_1]" zu bearbeiten.',

   'URL hidden'
=> 'URL verborgen',

   'Update Parameter Display'
=> 'Parameteranzeige aktualisieren',

   'View calculated grades (Spreadsheet)'
=> 'Berechnete Bewertungen (Beurteilungsbogen)',

   "What's new?"
=> "Was gibt's Neues?",

   '[quant,_1,day]'
=> '[quant,_1,Tag,Tage]',

   'grades[_3]'
=> 'Bewertungen[_3]',

   'new.gif'
=> 'new.gif',

   'parms[_2]'
=> 'parms[_2]',

   'pgrd.gif'
=> 'pgrd.gif',

   'pparm.gif'
=> 'pparm.gif',

   'problem[_1]'
=> 'problem[_1]',

   'problem[_2]'
=> 'problem[_2]',

   're-initializing Course'
=> 'Kurs neu initialisieren',

   'Show Resource'
=> 'Zeige Ressource',

   'Feedback to resource author'
=> 'Feedback an den Autor der Ressource',


#

   'Click to add/remove attachments',
=> 'Hier klicken, um Anhänge anzufügen/zu entfernen',

   'New attachments'
=> 'Neue Anhänge',

   'Retained attachments'
=> 'Zurückbehaltene Anhänge',

   'Add a new attachment to this post.'
=> 'Neuen Anhang für diese Nachricht erstellen:',

   'Discussion Post Attachments'
=> 'Anhänge für Diskussionsbeiträge',


#

   'Modify course settings'
=> 'Kurseinstellungen',

   'Send and display broadcast e-mail'
=> 'Broadcast-Nachrichten',

   'Awarded Total Points'
=> 'Erreichte Gesamtpunktzahl',

   'Total Parts Done'
=> 'Gesamtanzahl erledigter Aufgabenteile',

   'Create a single course'
=> 'Einen neuen, einzelnen Kurs erstellen',

   'Create a new course by completing an online form.'
=> 'Einen neuen Kurs durch Ausfüllen eines Formulars erstellen.',

   'Create a single collaborative group space'
=> 'Einzelnen, kollaborativen Gruppenbereich erstellen',

   'Create a new group space for non-course use by completing an online form.'
=> 'Einen einen Gruppenbereich für die Verwendung außerhalb von Kursen durch Ausfüllen eines Formulars erstellen.',

   'Create courses/groups by uploading an attributes file'
=> 'Kurse/Gruppen durch Hochladen einer Attributedatei erstellen',

   'Upload an attributes file containing specifications for one or more courses or groups in XML format.'
=> 'Hochladen einer Attributedatei, die Spezifikationen für einen oder mehrere Kurse oder Gruppen im XML-Format enthält.',

   'current'
=> 'aktuell',


#
   'Update Class List'
=> 'Kursteilnehmerliste aktualisieren', # n.t.

   'Version changes'
=> 'Versionsänderungen',

   'Change interval'
=> 'Intervall ändern',

   'Student Submission Reports'
=> 'Berichte studentischer Einreichungen',

   'Prepare reports of student submissions.'
=> 'Berichte zu den studentischen Einreichungen erstellen',

   'Survey Reports'
=> 'Umfrage-Berichte',

   'Prepare reports on survey results.'
=> 'Berichte zu Umfrage-Ergebnissen erstellen',

   'Correct Problems Plot'
=> 'Richtige-Antworten-Diagramme',

   'Display a histogram of student performance in the course.'
=> 'Histogramm studentischer Kursleistungen anzeigen',

   'Access Status'
=> 'Zugriffsstatus',

   'Limit by time'
=> 'Zeitliche Begrenzung', # n.t.

   'Submission Time Plots'
=> 'Einreichungszeit-Diagramme',

   'Currently Has Access'
=> 'Aktueller Zugriff',

   'Will Have Future Access'
=> 'Zukünftiger Zugriff',

   'Previously Had Access'
=> 'In der Vergangenheit liegender Zugriff',

   'Any Access Status'
=> 'Beliebiger Zugriffsstatus',

   'Previous Problem'
=> 'Vorherige Aufgabe',

   'Next Problem'
=> 'Nächste Aufgabe',

   'Choose a different Problem'
=> 'Eine andere Aufgabe auswählen',

   'Update Caches'
=> 'Cache aktualisieren',

   'Begin'
=> 'Beginn',

   'There are no students in the sections selected'
=> 'In den gewählten Sektionen sind keine Studenten.',

   'Graph Problem Submission Times'
=> 'Graph Aufgaben-Einreichungszeiten',


#
   'Return to Directory'
=> 'Zurück zum Verzeichnis',

   'Return to directory'
=> 'Zurück zum Verzeichnis',


# 2007-06-15

   'My Roles'
=> 'Meine Rollen',

   'My Space'
=> 'Mein Bereich',

   'Edit blogs, RSS feeds, and podcasts'
=> 'Blogs, RSS-Feeds und Podcasts',

   'Content Library'
=> 'Inhalte',

   'Search the contents of this course or accessible portfolio files'
=> 'Kurs- und Portfolio-Suche',

   'Grading and Statistics'
=> 'Bewertungen und Statistiken',

   'Other'
=> 'Sonstiges',

   'group'
=> 'Gruppe',

   'Actions'
=> 'Aktionen',

   'Size'
=> 'Größe',

   'Current Access Status'
=> 'Aktueller Zugriffsstatus',

   'Delete Checked Files'
=> 'Markierte Dateien löschen',

   'Using the portfolio file list'
=> 'Verwendung der Portfolio-Dateiliste',

   'Help on the portfolio'
=> 'Hilfe zum Portfolio-Bereich', # n.t.

   'Rename'
=> 'Umbenennen',

   'Private'
=> 'privat',

   'Change How Menus are Displayed'
=> 'Darstellung der Menüs',

   'Use icons and text'
=> 'Icons mit Text',

   'Use buttons and text'
=> 'Buttons mit Text',

   'Use icons only'
=> 'Nur Icons',

   'Previous Tries'
=> 'Bisherige Antworten',

   'Change Main Menu'
=> 'Darstellung der Menüs',

   'New screenname (shown if you post anonymously):'
=> 'Nickname für anonyme Beiträge:',

   'New nickname (shown if you post non-anonymously):'
=> 'Nickname für normale (nicht anonyme) Beiträge:',

   'Choose the time window to use to display roles for which access to the course expired.'
=> 'Auswahl des Zeitfensters zur Anzeige von Rollen, die in diesem Kurs abgelaufen sind',

   'Choose the time window to use to display roles for which access to the course became available.'
=> 'Auswahl des Zeitfensters zur Anzeige von Rollen, die diesem Kurs zugeteilt sind',

   'Choose the time window to use to display resources in the course with version changes.'
=> 'Auswahl des Zeitfensters zur Anzeige von Kurs-Ressourcen mit Versionsänderungen',

   'User Management'
=> 'Benutzerverwaltung',

   'Manage student enrollment'
=> 'Studentische Kursbelegungen',

   'Modify an existing group'
=> 'Bestehende Gruppe ändern',

   'Delete an existing group'
=> 'Bestehende Gruppe löschen',

   'Re-enable a deleted group'
=> 'Gelöschte Gruppe wiederherstellen',

   'Enter an existing group'
=> 'Einer bestehenden Gruppe beitreten',

   'Course Management'
=> 'Kurs-Verwaltung',

   'Reset Student Access Times'
=> 'Studentische Zugriffszeiten zurücksetzen',

   'Submission #'
=> 'Antwort-Nr.',

   'Try'
=> 'Versuch',

   'Try [_1]'
=> '[_1]. Versuch',

   'Submitted Answer'
=> 'Eingereichte Antwort',

   'Close Window'
=> 'Fenster schließen',

   'Close window'
=> 'Fenster schließen',

   'Portfolio Search'
=> 'Portfolio-Suche',

   'Enter words and quoted phrases'
=> 'Eingabe von Wörtern und in Anführungszeichen gesetzten Ausdrücken',

   'Portfolio and Course Search'
=> 'Kurs- und Portfolio-Suche',

   'Message Status'
=> 'Nachrichtenstatus',

   'Any'
=> 'Beliebig',

   'Unread'
=> 'Ungelesen',

   'Read'
=> 'Gelesen',

   'Replied to'
=> 'Beantwortet',

   'Forwarded'
=> 'Weitergeleitet',

   'Rename Folder'
=> 'Verzeichnis umbenennen',

   'Delete Folder'
=> 'Verzeichnis löschen',

   'Recent Roles'
=> 'Zuletzt verwendete Rollen',

   'Close navigation window'
=> 'Navigationsfenster beenden',

   'Post Anonymous'
=> 'Anonym absenden',

   'Post'
=> 'Absenden',

   'Back to preferences menu'
=> 'Zurück',

   'Forwarding Address(es)'
=> 'LON-CAPA-Weiterleitungsadresse(n)',

   'e.g. <tt>userA:domain1,userB:domain2,...</tt>'
=> 'z.B. <tt>BenutzerA:Domäne1,BenutzerB:Domäne2,...</tt>',

   'Notification E-mail Address(es)'
=> 'Benachrichtigungs-E-Mail-Adressen',

   'Email Address(es) which should be notified about new LON-CAPA messages' 
=> 'E-Mail-Adresse(n) zur Benachrichtigung über neue LON-CAPA-Nachrichten',

   'e.g. <tt>joe@doe.com</tt>'
=> 'z.B. <tt>hans@wurst.de</tt>',

   'Notification address'
=> 'Benachrichtigungsadresse',

   'Types of message for which notification is sent'
=> 'Art der Nachrichten, für die Benachrichtigung stattfinden soll',

   'Excerpt retains HTML tags in message'
=> 'Im Nachrichtenauszug HTML beibehalten',

   'All'
=> 'alle',

   'Critical only'
=> 'nur wichtige',

   'Non-critical only'
=> 'nur nicht-wichtige',

   'Add new address'
=> 'Neue Adresse hinzufügen',

   'What are forwarding and notification addresses?'
=> 'Was sind Weiterleitungs- und Benachrichtigungs-Adressen?',

   'What are critical messages?'
=> 'Was sind wichtige Nachrichten?',

   'Change Roles Page Pref'
=> 'Schnellzugriffsliste für Benutzerrollen',

   'Number of Roles in Hotlist:'
=> 'Anzahl Rollen in Schnellzugriffsliste:',

   'Current Password'
=> 'Derzeitiges Passwort',

   'New Password'
=> 'Neues Passwort',

   'Confirm Password'
=> 'Bestätigung neues Passwort',

   'Passwords must be a minimum of 7 characters long. Please try again.'
=> 'Das Passwort muss mindestens 7 Zeichen lang sein. Bitte versuchen Sie es noch einmal.',

   'The new passwords you entered do not match. Please try again.'
=> 'Die Bestätigung des neuen Passworts stimmt nicht mit dem neuen Passwort überein. Bitte versuchen Sie es noch einmal.',

   'Please make sure your old password was entered correctly.'
=> 'Stellen Sie sicher, dass das alte Passwort korrekt eingegeben wurde.',

   'Send me a message'
=> 'Diesem Benutzer eine Nachricht schicken',

   'Show Public View'
=> 'Öffentliche Sicht zeigen',

   'Delete Photo'
=> 'Foto löschen',

   'Help with filling in text boxes'
=> 'Hilfe zur Eingabe in Textfeldern',

   'Examples'
=> 'Beispiele',

   'off'
=> 'aus',

   'Summary Preview'
=> 'Zusammenfassungsvorschau',

   'Send copy to permanent email address (if known)'
=> 'Sende Kopie an externe E-Mail-Adresse (falls hinterlegt)',

   'Include in course RSS newsfeed'
=> 'In kursinterne RSS-Feeds einbinden',

   'Allow replies:'
=> 'Antworten zulassen:',

   'Reply to:'
=> 'Antwort an:',

   'Domain Management'
=> 'Domänen-Verwaltung',

   'Course ID of Key Authority:'
=> 'Kurs-ID des Schlüsselmeisters:',

   'Set domain configuration'
=> 'Domänen-Konfiguration',

   'Domain Configuration'
=> 'Domänen-Konfiguration',

   'View/Modify Domain Settings'
=> 'Domänen-Konfiguration',

   'Menu'
=> 'Menü',

   'Domain Settings'
=> 'Domänen-Konfiguration',

   'Course Environment'
=> 'Kursumgebung',

   'Edit Course Environment'
=> 'Kursumgebung',

   'Users allowed to clone course'
=> 'Benutzer, die berechtigt sein sollen, diesen Kurs zu klonen',

   'Users with active Course Coordinator role in this course are permitted to clone and need not be included.'
=> 'Benutzer mit aktiver Kurs-Koordinatoren-Rolle zu diesem Kurs haben automatisch das Recht zum Klonen und brauchen daher hier nicht eingetragen werden.',

   'Use [_1] to allow course to be cloned by anyone in the specified domain.'
=> '[_1] gestattet jedem in der angegebenen Domäne diesen Kurs zu klonen.',

   'Use [_1] to allow unrestricted cloning in all domains.'
=> '[_1] gestattet jedem aller Domänen diesen Kurs zu klonen.',

   'URL of Syllabus (not using internal handler)'
=> 'Externer Kursüberblick (URL)',

   'Custom Text for Resource Content Question Option in Feedback'
=> 'Eigener Text für Ressourcen-Inhaltsfragen-Option beim Feedback',

   'Custom Text for Course Content Option in Feedback'
=> 'Eigener Text für Kursinhalts-Option beim Feedback',

   'Custom Text for Course Policy Option in Feedback'
=> 'Eigener Text für Kursrichtlinien-Option beim Feedback',

   'Allow students to view classlist.'
=> 'Studenten erlauben, die Kursteilnehmerliste einzusehen',

   'Allow users with specified roles to edit/delete their own discussion posts'
=> 'Erlaube Benutzern mit folgenden Rollen, ihre eigenen Diskussionsbeiträge zu editieren/löschen',

   'Suppress number of tries in printing'
=> 'Beim Druck Angabe der Anzahl der Versuche auslassen',

   'Default paper type'
=> 'Standard-Papierformat',

   'Default beginning date for student access.'
=> 'Voreingestelltes Anfangsdatum für studentischen Zugriff',

   'Default ending date for student access.'
=> 'Voreingestelltes Endedatum für studentischen Zugriff',

   'Disable checking of Significant Figures'
=> 'Überprüfung signifikanter Stellen deaktivieren',

   'Disable automatically printing point values onto exams.'
=> 'Automatisches Drucken von Punkten auf Prüfungen deaktivieren',

   'Send message to student when clicking Done on Tasks'
=> 'Nachricht an Studenten versenden, wenn diese auf "Erledigt" in ihren Übungen klicken', # ???

   'Restrict Metadata'
=> 'Portfolio-Metadaten',

   'Show to student'
=> 'dem Studenten zeigen',

   'Provide text area for students to type catalog information'
=> 'dem Studenten Textfeld anbieten, um Katalogisierungsdaten eingeben zu können',

   'Provide choices for students to select from'
=> 'dem Studenten Auswahl anbieten, um wählen zu können aus',

   'Student may select multiple choices from list'
=> 'Mehrfachauswahl aus Liste erlauben',

   'Student may select only one choice from list'
=> 'Nur eine Auswahl aus der Liste erlauben',

   'Add a Metadata Field'
=> 'Ein Metadatenfeld hinzufügen',

   'Order Metadata Fields'
=> 'Order Metadata Fields',

   'Continue Import'
=> 'Import fortsetzen',

   'Continue Search'
=> 'Suche fortsetzen',

   'Finish Import'
=> 'Import abschließen',

   'Include'
=> 'Einbinden',

   'CLOSE'
=> 'Schließen', # n.t.

   'LON-CAPA Catalog Search'
=> 'LON-CAPA-Katalog-Suche',

   '[_1] include external resources'
=> '[_1] externe Ressourcen mit einbeziehen',

   'Change Course Initialization Preference'
=> 'Kurs-Initialisierung',

   'Change Course Init. Pref.'
=> 'Kurs-Initialisierung',

   'Reset Access Times'
=> 'Studentische Zugriffszeiten zurücksetzen',

   'Select Scope'
=> 'Bereich wählen',

   'Reset times on one or more folders/maps for a single student.'
=> 'Zeiten in einem/r oder mehreren Verzeichnissen/Inhaltszusammenstellungen für einen einzelnen Studenten zurücksetzen',

   'Reset times on a single folder/map for a section or whole clase.'
=> 'Zeiten für ein(e) einzelne(s) Verzeichnis/Inhaltszusammenstellung für eine Sektion oder einen gesamten Kurs zurücksetzen',

   'Choose a student:'
=> 'Student auswählen:',

   'Select Currently Enrolled Students and Active Course Personnel'
=> 'Wahl derzeit eingeschriebener Studenten oder aktiven Kurspersonals',

   'This is a list of folders/maps and times they were accessed, plese select those you want deleted.'
=> 'Hier ist eine Liste der Verzeichnisse/Inhaltszusammenstellungen und Zeiten, an denen Zugriff auf diese bestand. Bitte wählen Sie die aus, die gelöscht werden sollen.',

   'Select:'
=> 'Auswahl:',

   'All Course Personnel'
=> 'Gesamtes Kurspersonal',

   'No Section'
=> 'Keine Sektion',

   'Unselect'
=> 'Auswahl aufheben',

   'Select a folder/map'
=> 'Verzeichnis/Inhaltszusammenstellung wählen',

   'Will remove access times for'
=> 'Werde Zugriffszeiten entfernen für',

   'from users'
=> 'von Benutzern',

   'No Access times found for student'
=> 'Keine Zugriffszeit gefunden für Student',

   'Finish'
=> 'Abschließen',

   'Name of New Folder'
=> 'Name des neuen Verzeichnisses:',

   'Name of New Page'
=> 'Name der neuen zusammengesetzten Seite',

   'New Page'
=> 'Neue zusammengesetzte Seite',

   'WARNING: Removing a resource makes associated grades and scores inaccessible!'
=> 'Achtung: Das Entfernen der Ressource macht die damit verknüpften Bewertungen und Punkte unerreichbar!',

   'Remove[_99]'
=> 'Soll[_99]',

   '?[_99]'
=> 'wirklich entfernt werden?',

   'WARNING: Cutting a resource makes associated grades and scores inaccessible!'
=> 'Achtung: Das Ausschneiden der Ressource macht die damit verknüpften Bewertungen und Punkte unerreichbar!',

   'Grades remain inaccessible if resource is pasted into another folder.'
=> 'Die Bewertungen bleiben unerreichbar, auch wenn die Ressource in einem anderen Verzeichnis eingefügt wird.',

   'Cut[_98]'
=> 'Soll[_98]',

   '?[_98]'
=> 'wirklich ausgeschnitten werden?[_98]',

   'Paste'
=> 'Einfügen',

   'This may take a few moments to display.'
=> 'Die Berechnung könnte einen Moment dauern.', # n.t.

   'Detailed Citation Preview'
=> 'Detailierte Zitatsvorschau',

   'related words'
=> 'ähnliche Wörter',

   'Any domain'
=> 'Beliebige Domäne',

   'Reset'
=> 'Zurücksetzen',

   'MIME Type Category'
=> 'MIME-Typ-Kategorie',

   'Domains'
=> 'Domänen',

   'Custom Metadata fields'
=> 'Eigene Metadaten-Felder',

   'Field Name'
=> 'Feldbezeichnung',

   'Field Value(s)'
=> 'Feldinhalt(e)',

   'Another custom field/value pair?'
=> 'Ein weiteres eigenes Metadaten-Feld?',

   'Creation and Modification dates'
=> 'Erstellungs- und Änderungszeiten',

   'Created between'
=> 'Erstellung zwischen',

   'Last modified between'
=> 'Letzte Änderung zwischen',

   'Standard Portfolio Metadata'
=> 'Standard-Portfolio-Metadaten',

   'Advanced Portfolio Search'
=> 'Erweiterte Portfolio-Suche',

   'Standard Catalog Metadata'
=> 'Standard-Katalog-Metadaten',

   'Problem Statistics'
=> 'Aufgaben-Statistiken',

   'Statistics calculated for number of students'
=> 'Statistiken berechnet für folgende Anzahl an Studenten',

   'Portfolio and Catalog Search'
=> 'Datenbank veröffentlichter Ressourcen und Portfolio-Dateien',

# 2007-06-22
   'Search the database of accessible portfolio files'
=> 'Datenbank der Portfolio-Dateien',

   'Construction Space:'
=> 'Konstruktionsbereich:',

   'Problem Status:'
=> 'Aufgabenstatus:',

   'Problem Type:'
=> 'Aufgabentyp:',

   'Feedback Mode:'
=> 'Feedback-Modus:',

   'Answer for Part: [_1]'
=> 'Antwort für Teil [_1]',

   'Script Vars'
=> 'Skript-Variablen',

   'Regular file'
=> 'Reguläre Datei',

   'Testbank file'
=> 'Testbank-Datei',

   'IMS package'
=> 'IMS-Paket',

   'There are unsaved changes'
=> 'Es liegen ungespeicherte Änderungen vor!',

   'Found no analyzable responses in this problem, currently only Numerical,
Formula and String response styles are supported.'
=> 'Keine analysierbaren Antwortblöcke in der Aufgabe gefunden. Derzeit werden
nur numericalresponse, formularesponse und stringresponse unterstützt.',

   'Active Link'
=> 'Aktive Links',

   'Font'
=> 'Zeichen',

   'Un-Visited Link'
=> 'Unbesuchte Links',

   'Page Background'
=> 'Seitenhintergrund',

   'Header Border'
=> 'Seitenkopf-Rahmen',

   'Header Background'
=> 'Seitenkopf-Hintergrund',

   'Visited Link'
=> 'Besuchte Links',

   'Change Custom Colors'
=> 'Farbeinstellungen übernehmen',

   'Reset All Colors to Default'
=> 'Alle Farben auf Voreinstellung zurücksetzen',

   'Directory Contents:'
=> 'Inhaltsverzeichnis:', # n.t.

   'Save and Edit'
=> 'Speichern und weiterbearbeiten',

   'Save and View'
=> 'Speichern und betrachten',

   'Check Spelling'
=> 'Rechtschreibprüfung',

   'Selecting a Course'
=> 'Kurs auswählen',

   'Course Activity:'
=> 'Letzte Kursaktivität:',

   'Course Domain:'
=> 'Kurs-Domäne:',

   'Course Institutional Code:'
=> 'Kurs-Instituts-Code:',

   "Course Owner's Username:"
=> 'Benutzername des Kurs-Eigentümers:',

   "Course Owner's Domain:"
=> 'Domäne des Kurs-Eigentümers:',

   'LON-CAPA course ID:'
=> 'LON-CAPA-Kurs-ID:',

   'Course Description:'
=> 'Kurstitel:',

   'Resource Space Home'
=> 'Ressourcenbereich-Hauptverzeichnis',

   'Default start and end dates for student access'
=> 'Voreingestelltes Anfangs- und Endedatum für studentischen Zugriff',

   'Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Soll LON-CAPA den <b>Domänen-Koordinator</b> benachrichtigen, wenn während der automatischen Aktualisierung Änderungen an der Kursbelegung auftreten?',

   'Course Group Settings'
=> 'Kursgruppen-Einstellungen',

   'Set a quota for the total disk space available for storage of course group
portfolio files.'
=> 'Verfügbarer Gesamtspeicherplatz für Portfolio-Dateien für alle Kursgruppen dieses Kurses:',

   'Creation Options'
=> 'Erstellungsoptionen',

   ' Creation Settings'
=> ' Erstellungs-Einstellungen',

   'Creation Outcome'
=> 'Ergebnis der Erstellung',

   'New LON-CAPA course ID:'
=> 'Neue LON-CAPA-Kurs-ID:',

   'Created on'
=> 'Erstellt in Domäne',

   'Cloning course from'
=> 'Kurs geclont aus Domäne',

   'Setting environment'
=> 'Einstellung der Kursumgebung',

   'Opening all assignments'
=> 'Start aller Übungen',

   'Setting first resource'
=> 'Einstellung der ersten Ressource',

#   'Assigning role of Course Coordinator to'
#=> 'Zuweisung der Rolle Kurs-Koordinator an',

   'Assigning role of [_1] Coordinator to [_2] at [_3]: '
=> 'Zuweisung der Rolle des [_1]-Koordinators an [_2] in [_3]: ',

   'Roles will be active at next login'
=> 'Rollen werden ab dem nächsten Login aktiv sein',

   'Active at next login.'
=> 'Beim nächsten Login aktiv. ',

   'Expired after logout.'
=> 'Nach dem Abmelden abgelaufen.',

   'No new course created.'
=> 'Der Kurs wurd nicht erstellt.',

   'A new course could not be cloned from the specified original - [_1] - because it is a non-existent course.'
=> 'Ein neuer Kurs kann nicht von dem angebenen Originalkurs ([_1]) geklont werden, da dieser Kurs nicht existiert.',

   'The new course could not be cloned from the existing course because the new course owner ([_1]) does not have cloning rights in the existing course ([_2]).'
=> 'Der neue Kurs kann nicht von dem angebenenen Kurs geklont werden, da der neue Kurseigentümer ([_1]) nicht die Berechtigung erteilt bekommen hat, den existierenden Kurs ([_2]) zu klonen.',

   'Create Another [_1]'
=> 'Einen weiteren [_1] anlegen',

   'from domain'
=> 'aus der Domäne',

   'Submit Evaluation'
=> 'Evaluierung absenden',

   'Standard Problem'
=> 'Standard-Aufgabe',

   'Practice'
=> 'Übung',

   'Exam'
=> 'Prüfung',

   'Survey'
=> 'Umfrage',

   'Library'
=> 'Bibliothek',

   'Value:'
=> 'Wert:',

   'String Value'
=> 'Text-Wert',

   'Specifically for'
=> 'Im Speziellen für', # n.t.

   'practice'
=> 'Übung',

   'Loading Domain Coordinator Menu'
=> 'Lade Domänen-Koordinator-Menü...',

   "Disk space allocated to user's portfolio files"
=> "Speicherplatz für Portfolio-Dateien des Benutzers",

   'Current quota'
=> 'Derzeitiger Speicherplatz',

   'For this user, the default quota is [_1] Mb.'
=> 'Für diesen Benutzer ist der voreingestellte Speicherplatz [_1] MB.',

   'Change quota'
=> 'Speicherplatz ändern',

   'Custom quota'
=> 'Selbsteingestellter Speicherplatz',

   'Existing sections'
=> 'Bestehende Sektionen',

   'Define new section'
=> 'Neue Sektion erstellen',

   'Create/Modify Another User'
=> 'Andere Benutzeraccounts erstellen oder ändern',

   'Set Privileges for New User'
=> 'Einstellungen für neuen Benutzer',

   'Generating user'
=> 'Erstelle Benutzer',

   'Generating user: [_1]'
=> 'Erstelle Benutzer: [_1]',

   'Home server'
=> 'Heimatserver',

   'Home server: [_1]'
=> 'Heimatserver: [_1]',

   'Modifying Roles'
=> 'Anpassung der Benutzerrollen',

   'No roles to modify'
=> 'Es erfolgte keine Änderung der Benutzerrollen.',

   'starting'
=> 'Start am',

   'Add to classlist:'
=> 'Hinzufügen zur Kursteilnehmerliste:',

   'Change Current Login Data'
=> 'Derzeitige Login-Einstellung ändern',

   'Enter New Login Data'
=> 'Neue Login-Einstellungen',

   'will override current values'
=> 'überschreibt derzeitigen Wert',

   'Set a quota for the total disk space available for storage of course group portfolio files.'
=> 'Verfügbarer Gesamtspeicherplatz für Portfolio-Dateien für alle Kursgruppen dieses Kurses:',

   'Section Numbers and corresponding LON-CAPA section IDs'
=> 'Sektionsnummern and korrespondierende LON-CAPA-Sektions-IDs',

   'Overall Assessment Statistical Data'
=> 'Übergreifende statistische Beurteilungsdaten',

   'No new dynamic data found.'
=> 'Keine neuen dynamischen Daten gefunden.',

   'Selected <b>Resources</b> from <b>selected folder</b> in course'
=> 'Ausgewählte <b>Ressourcen</b> im </b>ausgewählten Verzeichnis</b> im Kurs',

   'Current value is'
=> 'Aktuelle Einstellung ist',

   'Interval set to version changes [_1]'
=> 'Intervall auf Versionsänderungen [_1] gesetzt',

   'Creating a new problem resource.'
=> 'Neue Aufgabe erstellen',

   'Creating a new library resource.'
=> 'Neue Bibliothiek erstellen',

   'Creating a new survey resource.'
=> 'Neue Umfrage erstellen',

   'Creating a new task resource.'
=> 'Neue "bridgetask"-Datei erstellen',

   'The requested file [_1] currently does not exist.'
=> 'Die angeforderte Datei [_1] existiert momentan nicht.',

   'To create a new problem, select a template from the list below. Then click on the "Create problem" button.'
=> 'Um eine neue Aufgabe zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Aufgabe erstellen"-Button.',

   'To create a new library, select a template from the list below. Then click on the "Create library" button.'
=> 'Um eine neue Bibliothek zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Bibliothek erstellen"-Button.',

   'To create a new survey, select a template from the list below. Then click on the "Create survey" button.'
=> 'Um eine neue Umfrage zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Umfrage erstellen"-Button.',

   'To create a new task, select a template from the list below. Then click on the "Create task" button.'
=> 'Um eine neue "bridgetask"-Datei zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "bridgetask-Datei erstellen"-Button.',

   'Accessibility Options'
=> 'Alternativ-Login',

   'About LON-CAPA'
=> 'Über LON-CAPA',

   'Course Catalog'
=> 'Kursübersicht',

   'If you were expecting to see an active role listed for a particular course in the [_1] domain, it may be missing for one of the following reasons:'
=> 'Falls Sie eine aktive Rolle für einen bestimmten Kurs in der Domäne "[_1]" erwartet haben, könnte es sein, dass diese aus einem der folgenden Gründe fehlt:',

   'The course has yet to be created.'
=> 'Der Kurs wurde noch nicht erstellt.',

   'Automatic enrollment of registered students has not been enabled for the course.'
=> 'Die automatische Kursbelegung registrierter Studenten wurde für diesen Kurs nicht aktiviert.',

   'You are in a section of course for which automatic enrollment in the corresponding LON-CAPA course is not active.'
=> 'Sie sind in einer Sektion des Kurses, für die die automatische Kursbelegung im zugehörigen LON-CAPA-Kurs nicht aktiviert ist.',

   'You registered for the course recently and there is a time lag between the time you register, and the time this information becomes available for the update of LON-CAPA course rosters.'
=> 'Sie haben sich kürzlich für den Kurs registriert und es gibt eine Zeitverzögerung zwischen der Zeit Ihrer Registrierung und dem Erscheinen dieser Information in der LON-CAPA-Kursteilnehmerliste.',

   'If you were expecting to see an active role listed for a particular course, that course may not have been created yet.'
=> 'Falls Sie eine aktive Rolle für einen bestimmten Kurs erwartet haben, könnte es sein, dass diese noch nicht erstellt wurde.',

   'The [_1]Course Catalog[_2] provides information about all [_3] classes for which LON-CAPA courses have been created.' # [_3]: domain
=> 'Die [_1]Kursübersicht[_2] enthält Informationen über alle Kurse der Domäne [_3], für die LON-CAPA-Kurse eingerichtet wurden.',

   'You can search the course catalog for courses which permit self-enrollment, if you would like to enroll in a course.'
=> 'Falls Sie einen Kurs belegen möchten, können Sie die Kursübersicht nach Kursen durchsuchen, die eine Selbsteintragung zulassen.',

   'User Authentication'
=> 'Benutzer-Authentifizierung',

   'Log-in Help'
=> 'Login-Hilfe',

   'Forgot password?'
=> 'Passwort vergessen?',

   'New User?'
=> 'Neuer Benutzer?',

   'Crosslisted'
=> 'querverwiesen',

   'Owner'
=> 'Eigentümer',

   'Code'
=> 'Kurscode',

   'Course listing'
=> 'Kursübersicht',

   'Course Listing'
=> 'Kursübersicht',

   'Display information about official [_1] classes for which LON-CAPA courses have been created:'
=> 'Informationen zu offiziellen Kursen der [_1], für die LON-CAPA-Kurse eingerichtet wurden',

   'help/support'
=> 'Hilfe und Support',

   'Log-in help'
=> 'Login-Hilfe',

   'Ask helpdesk'
=> 'Anfrage an Helpdesk abschicken',

   'Back to last location'
=> 'Zurück zum letzten Ort',

   'Note'
=> 'Anmerkung',

   'Student questions about course content should be directed to the course instructor'
=> 'Studentische Fragen zum Kursinhalt richten Sie bitte direkt an den Dozenten des Kurses',

   'Submit Request'
=> 'Anfrage abschicken',

   'E-mail address'
=> 'E-Mail-Adresse',

   'Enter the username you use to log-in to LON-CAPA, and your domain.'
=> 'Geben Sie Ihren LON-CAPA-Benutzernamen ein und wählen Sie Ihre Domäne.',

   'URL of page'
=> 'URL der Seite',

   'Phone'
=> 'Telefon-Nr.',

   'Course Details'
=> 'Kursdetails',

   'Enter institutional course code'
=> 'Kurs-Instituts-Code',

   'Enter course title'
=> 'Kurstitel',

   'Section Number'
=> 'Sektionsnummer',

   'Detailed Description'
=> 'Detailierte Beschreibung',

   'Clear Form'
=> 'Formular zurücksetzen',

   'Material presented in clear way'
=> 'Das Material wird in einer verständlichen Art dargestellt',

   'Material covered with sufficient depth'
=> 'Das Thema wird in ausreichender Tiefe behandelt',

   'Material is helpful'
=> 'Das Material ist hilfreich',

   'Material appears to be correct'
=> 'Das Material scheint korrekt zu sein',

   'This will only retrieve the resource, if you want to retrieve the metadata you will need to do that separately.'
=> 'Die Aktion wird lediglich die Ressource selbst wiederherstellen. Möchten Sie auch eine alte Version der Metadaten zu dieser Ressource wiederherstellen, müssen Sie dies extra tun.',

   'is in this state due to author settings.'
=> 'befindet sich aufgrund von Einstellungen des Autors temporär in diesem Zustand.',

   'User Data for'
=> 'Benutzerdaten von',

   'Email Address'
=> 'E-Mail-Adresse',

   'Enroll Student'
=> 'Studenten Kurs belegen lassen',

   'If active, the new role will be available when the student next logs in to LON-CAPA.'
=> 'Falls bereits aktiv, wird die Rolle ab dem nächsten Login für den Studenten verfügbar sein.',

   'Enroll another student'
=> 'Einen weiteren Studenten den Kurs belegen lassen',

   'Enroll Another Student'
=> 'Einen weiteren Studenten den Kurs belegen lassen',

   'start date'
=> 'Anfangsdatum',

   'end date'
=> 'Endedatum',

   'active groups'
=> 'Aktive Gruppen',

   'active group(s)'
=> 'Aktive Gruppen',

   "Select a user name to view the user's personal page."
=> "Klicken Sie auf den Benutzernamen, um die persönliche Informationsseite dieses Benutzers anzuschauen.",

   'View recent activity by this student'
=> 'Zuletzt stattgefundene Aktivitäten dieser Person', # n.t.

   'Recent activity of [_1]:[_2]'
=> 'Zuletzt stattgefundene Aktivtäten von [_1]:[_2]',

   'Compiling student activity data can take a long time.
Your request continues to be processed while results are displayed.
' # 2xCR!
=> 'Das Zusammenstellen der Aktivitätsdaten kann eine Weile dauern.
Ihre Anfrage wird weiter verarbeitet, während die schon vorhandenen Ergebnisse bereits angezeigt werden.
',

   'Composing Query'
=> 'Stelle Anfrage zusammen',

   'Student Activity'
=> 'Studentische Aktivitäten',

   'Waiting up to [_1] seconds for results'
=> 'Warte noch maximal [_1] Sekunden auf Ergebnisse',

   'Activity data compiled up to [_1]'
=> 'Aktivitätsdaten zusammengestellt bis [_1]',

   'While data is processed, periodically reload this page for more recent activity'
=> 'Während die Daten verarbeitet werden, können Sie gelegentlich die Seite aktualisieren, um aktuellere Aktivitätsdaten zu erhalten.',

   'Data'
=> 'Daten',

   'Resubmit last request to check for newer data'
=> 'Letzte Anfrage erneut abschicken, um auf aktuellere Daten zu prüfen', # n.t.

   'View Classlist'
=> 'Kursteilnehmerliste anschauen',

   'Count'
=> 'Zähler', # n.t.

   'Modifying authentication:'
=> 'Ändere Authentifizierung:',

   'Home server: [_1]'
=> 'Heimatserver: [_1]',

   'Modify User Privileges'
=> 'Benutzerrechte anpassen',

   'Insert:'
=> 'Einfügen:', # n.t.

   'Randomize Foil Order'
=> 'Reihenfolge der Auswahlmöglichkeiten randomisieren', # n.t.

   'Display Direction'
=> 'Anzeige-Richtung:',

   'vertical'
=> 'vertikal',

   'horizontal'
=> 'horizontal',

   'Script'
=> 'Skript-Block', # n.t.

   'Problem Editing Help'
=> 'Hilfe zur Aufgabenerstellung', # n.t.

   'Problem Editing'
=> 'Aufgabenerstellung',

   'Hint'
=> 'Hinweis', # n.t.

   'Show hint even if problem Correct:'
=> 'Hinweis auch zeigen, wenn Aufgabe richtig beantwortet wurde:', # n.t.

   'Single Line Text Entry Area'
=> 'Zeile mit Texteingabefeld', # n.t.

   'Parameters for a response'
=> 'Parameter für Antworttyp', # n.t.

   'Problem Part'
=> 'Aufgabenteil', # n.t.

   'Part ID:'
=> 'Aufgabenteil-ID:',

   'Displayed Part Description:'
=> 'Anzuzeigende Aufgabenteil-Beschreibung:',

   'Readonly:'
=> 'Nur lesbar:', # n.t.

   'Response: Numerical'
=> 'Antwortblock: numerisch', # n.t.

   'random'
=> 'zufällig',

   'top'
=> 'am Anfang',

   'bottom'
=> 'am Ende',

   'Add new Option:'
=> 'Option hinzufügen:',

   'Delete an Option:'
=> 'Option löschen:', # n.t.

   'Print options:'
=> 'Ausgabe der Optionen:',

   "Don't show option list"
=> "Optionsliste nicht anzeigen", # n.t.

   'Display of options when printed'
=> 'Anzeigeart der Optionen beim Druck',

   'Normal list'
=> 'Normale Liste',

   'Listed in vertical column'
=> 'In senkrechter Spalte aufgelistet',

   'Multiple Option Response Question'
=> 'Antworttyp: Optionsauswahl', # n.t.

   'Select Options'
=> 'Wählbare Optionen', # n.t.

   'Image'
=> 'Bild', # n.t.

   'Image Url:'
=> 'URL des Bildes:',

   'width (pixel):'
=> 'Breite (Pixel):',

   'height (pixel):'
=> 'Höhe (Pixel):',

   'Alignment:'
=> 'Ausrichtung:', # n.t.

   'Encrypt URL:'
=> 'URL verschlüsseln:', # n.t.

   'no'
=> 'nein',

   'Location:'
=> 'Stelle:', # n.t.

   'Randomly labeled image'
=> 'Dynamisch beschriftetes Bild', # n.t.

   'Response: Click on Image'
=> 'Antworttyp: Klick-ins-Bild', # n.t.

   'Collection of Imageresponse foils'
=> 'Sammlung von Bildantwort-Auswahlmöglichkeiten', # n.t.

   'Image response foil'
=> 'Bildantwort-Auswahlmöglichkeit', # n.t.

   'Enter Coordinates' # n.t.
=> 'Koordinaten festlegen',

   'Rectangle'
=> 'Rechteck', # n.t.

   'Coordinate Pairs'
=> 'Koordinatenpaar',

   'Polygon'
=> 'Polygon',

   'Coordinate list'
=> 'Koordinatenliste', # n.t.

   'Create Polygon Data'
=> 'Polygon-Daten festlegen', # n.t.

   'Task Description'
=> 'Beschreibung der Aufgabe', # n.t.

   'Clickable Image'
=> 'Klickbares Bild', # n.t.

   'Image Source File'
=> 'Pfad und Name der Bilddatei', # n.t.

   'Enter Coordinate or click finish to close Polygon'
=> 'Klicken Sie in das Bild, um die Koordinaten für das Polygon festzulegen.',

   'Select First Coordinate on Image'
=> 'Klicken Sie an die Stelle der ersten Koordinate.',

   'Select Second Coordinate on Image'
=> 'Klicken Sie an die Stelle der zweiten Koordinate.',

   'Select Finish to save selection.'
=> 'Klicken Sie Beenden zum Beenden oder Abbruch zum Abbrechen.',

   'New Name'
=> 'Neuer Dateiname',

   'Make Obsolete'
=> 'Als überholt markieren',

   'Set Margins'
=> 'Seitenränder festlegen',

   'How should each column be formatted?'
=> 'Wie soll jede Spalte formatiert werden?', # n.t.

   'Width:'
=> 'Breite:', # n.t.

   'Height:'
=> 'Höhe:', # n.t.

   'Left Margin:'
=> 'Linker Rand:', # n.t.

   'Username and/or password could not be authenticated.'
=> 'Benutzername und/oder Passwort konnten nicht erfolgreich authentifiziert werden.',

   'Please check the username and password.'
=> 'Bitte überprüfen Sie Ihren Benutzernamen und Ihr Passwort.',

   'Try again'
=> 'Nochmal versuchen',

   'Information needed to verify your login information is missing, inaccessible or expired.'
=> 'Die Daten, um Ihre Anmeldung zu überprüfen, fehlen, können nicht gelesen werden oder sind abgelaufen.',

   'Sending'
=> 'Sende',

   'Completed.'
=> 'Ausgeführt.',

   'Messages being sent.'
=> 'Nachrichten wurden gesendet',

   'showing messages'
=> 'zeige Nachrichten',

   'Assigning'
=> 'Zuweisung der Rolle',

   'ending'
=> 'Ende am',

   'Assistant Co-Author'
=> 'Co-Autor-Assistent',

   'Catalog Information for [_1]'
=> 'Katalogisierungsdaten für [_1]',

   'There are [_1] matches to your query.'
=> 'Ihre Suche hat [_1] Treffer ergeben.',

   'Revise search'
=> 'Suche ändern',

   'in LON-CAPA domain'
=> 'in LON-CAPA-Domäne', # n.t.

   'Sort by [_1] [_2]'
=> 'Sortiert nach [_1] [_2]',

   'Number of accesses'
=> 'Anzahl der Zugriffe',

   'Ascending'
=> 'aufsteigend',

   'Descending'
=> 'absteigend',

   'Students Attempting'
=> 'Studentische Versuche', # ??? [SB 2007-07-03]

   'Average Number of Tries'
=> 'Durchschnittliche Anzahl an Versuchen',

   'Mean Degree of Difficulty'
=> 'Durchschnittlicher Schwierigkeitsgrad',

   'Mean Degree of Discrimination'
=> 'Durchschnittlicher Grad der Abgrenzung',

   'Evaluation: Clear'
=> 'Evaluierung: Klar',

   'Evaluation: Technically Correct'
=> 'Evaluierung: Technisch korrekt',

   'Evaluation: Material is Correct'
=> 'Evaluierung: Material ist korrekt',

   'Evaluation: Material is Helpful'
=> 'Evaluierung: Material ist hilfreich',

   'Evaluation: Material has Depth'
=> 'Evaluierung: Tiefe des Themas',

   'Prev'
=> 'Zurück',

   'Reload'
=> 'Aktualisieren',

   'Results [_1] to [_2] out of [_3]'
=> 'Treffer [_1] bis [_2] von insgesamt [_3]',

   'Unactionable Search Queary'
=> 'Suchanfrage zurückgewiesen',

   'You did not fill in enough information for the search to be started. You need to fill in relevant fields on the search page in order for a query to be processed.'
=> 'Sie haben nicht genügend Informationen eingetragen, damit die Suche gestartet werden kann. Füllen Sie relevante Felder aus, damit die Suche ausgeführt werden kann.', # n.t.

   'Revise Search Request'
=> 'Suchanfrage ändern',

   'LON-CAPA Access Control'
=> 'LON-CAPA-Zugriffskontrolle',

   'Access  : '
=> 'Zugriff  : ',

   'Resource: '
=> 'Ressource: ',

   'Action  : '
=> 'Aktion   : ',

   'You have modified your course recently, [_1] may fix this access problem.'
=> 'Sie haben den Kurs kürzlich verändert. [_1] könnte das Zugriffsproblem beheben.',

   'Published on ...'
=> 'Veröffentlicht am...',

   'Currently published version'
=> 'Derzeit veröffentlichte Version',

   'Edit Metadata'
=> 'Metadaten ändern',

   'Cleanup XML Document'
=> 'XML-Code aufräumen',

   'Select actions to attempt:'
=> 'Auswahl der gewünschten Aktionen:',

   'Linefeeds, formfeeds, and carriage returns'
=> 'Zeilenumbrüche (LF), Seitenvorschübe und "Wagenrückläufe" (CR)',

   'Empty tags'
=> 'Leere Tags',

   'Lower casing'
=> 'Kleinschreibung',

   'Symbol font'
=> 'Symbolischer Zeichensatz', # ??? [SB 2007-07-03]

   'Cleanup'
=> 'Aufräumen',

   'Back to Source File'
=> 'Zurück zur Quelldatei',

   'Hypertext Cascading Style Sheet'
=> 'Stylesheet-Datei',

   'Online Survey'
=> 'Umfrage',

   'Unable to find [_1]'
=> 'Die Datei [_1] konnte nicht gefunden werden.',

   'Check machines:'
=> 'Server auswählen:', # n.t.

   'Post Server Announcements'
=> 'Server-Bekanntmachungen', # n.t.

   'Post announcements to the system login and roles screen'
=> 'Server-Bekanntmachungen für die Login-Seite und die Rollenauswahl', # n.t.

   '(leave blank to delete announcement)'
=> '(leer lassen, um Bekanntmachung zu entfernen)',

   'Posting [_1]'
=> 'Sende an [_1]',

   'This is LON-CAPA [_1]'
=> 'Hier läuft LON-CAPA [_1]',

   'Attachment (128 KB max size)'
=> 'Anhang (maximal 128 KB)',

   'Edit Answer'
=> 'Antwort editieren',

   'Date/Time'
=> 'Datum, Uhrzeit',

   'Threshold Name'
=> 'Schwellenwert-Name',

   'Current value'
=> 'Aktueller Wert',

   'Change?'
=> 'Ändern',

   'Make changes'
=> 'Speichern',

   'Change thresholds'
=> 'Schwellenwerte ändern',

   'Picture Conversion Status'
=> 'Bildkonvertierungs-Status',

   'Class Print Status'
=> 'Druckstatus',

   'Removing error messages:'
=> 'Entfernen von Fehlermeldungen:',

   'Initial version'
=> 'Urversion',

   'Press "Generate Statistics" when you are ready.'
=> 'Klicken Sie auf "Erzeuge Statistiken", wenn Sie die gewünschten Einstellungen vorgenommen haben.',

   'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.'
=> 'Es kann einige Zeit dauern, um die studentischen Daten für die erste Analyse zu aktualisieren. Zukünftige Analysen werden nicht diese Verzögerung verursachen.', # n.t.

   'Show problem'
=> 'Aufgabe anzeigen', # n.t.

   'Analyze Over'
=> 'Analyse über', # n.t.

   'Number of Plots'
=> 'Anzahl Plots', #???

   'none'
=> 'nichts',

   'Output as'
=> 'Ausgabetyp', # n.t.

   'Prepare Report'
=> 'Bericht erstellen',

   'Show correct answers'
=> 'Korrekte Antworten anzeigen', # n.t.

   'Show all submissions'
=> 'Alle Einreichungen anzeigen', # n.t.

   'Show problem grading'
=> 'Aufgabenbewertung anzeigen', # n.t.

   'Computing correct answers greatly increasese the amount of time required to prepare a report.'
=> 'Die Berechnung korrekter Antworten erhöht die benötigte Zeit erheblich, um den Bericht zu erstellen.',

   'please select problems and use the <b>Prepare Report</b> button to continue.'
=> 'Wählen Sie die zu berücksichtigenden Aufgaben aus und klicken Sie anschließend auf den <b>Bericht erstellen</b>-Button.',

   'Please select a Survey to analyze'
=> 'Wählen Sie eine Umfrage, die analysiert werden soll:',

   'There are no survey problems in this course'
=> 'In diesem Kurs sind keine Umfragen enthalten.',

   'Generate Survey Report'
=> 'Umfragebericht generieren',

   'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin'
=> 'Wählen Sie eine Sequenz aus der "Sequenzen und Verzeichnisse"-Liste und klicken Sie auf "Diagramm erzeugen", um zu starten.',

   'Create Plot'
=> 'Diagramm erzeugen',

   'Start Time:'
=> 'Startzeit:',

   'End Time:'
=> 'Endezeit:',

   'Sender'
=> 'Absender',

   'Number'
=> 'Nummer',

   'Upload Classlist'
=> 'Kursteilnehmerliste hochladen',

   'Semicolon separated values'
=> 'Durch Semikolons getrennt',

   ' with home server '
=> ' mit Heimatserver ', # n.t.

   'Show Log'
=> 'Veränderungs-Protokoll',

   'Course Document Change Log'
=> 'Kursressourcen-Veränderungs-Protokoll',

   'Records'
=> 'Datensätze',

   'Before'
=> 'Vorher',

   'After'
=> 'Nachher',

   'Current folder/page'
=> 'Aktuelles Verzeichnis/Seite',

   'Containing phrase'
=> 'Enthält Text:',

   'None'
=> 'nichts',

   'Users'
=> 'Benutzer',

   'Include parameter types'
=> 'Parametertypen zeigen',

   'Parameter Change Log'
=> 'Parameteränderungs-Protokoll',

   'Announce'
=> 'Bekanntmachen',

   'Not active anymore'
=> 'nicht mehr aktiv',

   'Add to Course Announcements'
=> 'Den Kursbekanntmachungen hinzufügen',

   'Username : Domain'
=> 'Benutzername:Domäne',

   'Active'
=> 'aktiv',

   'Sort by realm first, then student (group/section)'
=> 'Sortierung nach Bereich, dann nach Student (Gruppe/Sektion)',

   'Sort by student (group/section) first, then realm'
=> 'Sortierung nach Student (Gruppe/Sektion), dann nach Bereich',

   'Shift all dates based on this date'
=> 'Alle Datumseinträge anhand dieses Datums verschieben',

   'Overview Mode'
=> 'Übersichtsmodus',

   'Overview'
=> 'Übersicht',

   'Set Parameters'
=> 'Parameter einstellen',

   'Parts'
=> 'Aufgabenteile',

   'Section(s)'
=> 'Sektion(en)',

   'Group(s)'
=> 'Gruppe(n)',

   'Select Common Only'
=> 'Übliche wählen',

   'Add Problem Dates'
=> 'Auswahl: Aufgabendatumsfelder',

   'Add Content Dates'
=> 'Auswahl: Inhaltsdatumsfelder',

   'Add Discussion Settings'
=> 'Auswahl: Diskussions-Einstellungen',

   'Add Visibilities'
=> 'Auswahl: Sichtbarkeit',

   'Add Part Parameters'
=> 'Auswahl: Aufgabenteil-Parameter',

   'Group Files'
=> 'Gruppendateien',

   "Enter user:domain for User's 'About Me' Page"
=> "Geben Sie Benutzername:Domäne für die Über-mich-Seite des gewünschten Benutzers ein:",

   'No map selected.'
=> 'Keine Inhaltszusammenstellung gewählt!',

   'Most Recent:'
=> 'Aktuellste:', # n.t.

   'In Course:'
=> 'Im Kurs:', # n.t.

   'Use:'
=> 'Verwende:', # n.t.

   'Search LON-CAPA help'
=> 'Suche in der LON-CAPA-Hilfe',

   'Before course enrollment start!'
=> 'Liegt VOR Kursbelegungs-Start!',

   'After course enrollment end!'
=> 'Liegt NACH Kursbelegungs-Ende!',

   'Choose'
=> 'Übernehmen',

   'Title:'
=> 'Titel:',

   'URL:'
=> 'URL:',

   'Course, Portfolio and Catalog Search'
=> 'Katalog-Suche, Portfolio-Suche und Suche im Kurs',

   'ERROR:'
=> 'FEHLER:',

   'occured while running'
=> 'trat auf während der Ausführung von', # n.t.

   '(click for example)'
=> '(Klicken für Beispiel)',

   'click for example'
=> 'Klicken für Beispiel',

   'Re-Enable'
=> 'wieder aktivieren',

   'Script Functions'
=> 'Funktionen in Skripten', # n.t.

   'Image Options'
=> 'Bildoptionen', # n.t.

   'left'
=> 'links',

   'right'
=> 'rechts',

   'TeXwidth (mm):'
=> 'TeX-Breite (mm):',

   'TeXheight (mm):'
=> 'TeX-Höhe (mm):',

   'TeXwrap:'
=> 'TeX-Umbruch', # n.t., ??? [SB 2007-07-11]

   'Sorry!'
=> 'Schade...', # n.t.

   'Resource not available.'
=> 'Ressource nicht erreichbar.', # n.t.

   'Choose file type:'
=> 'Dateityp:',

   'Output of decompress:'
=> 'Ausgabe der Dekomprimierung:',

   'Decompress complete.'
=> 'Dekomprimierung abgeschlossen.',

   'Archive:'
=> 'Archiv:',

   'inflating:'
=> 'entpacke:',

   'Incorrect:'
=> 'Inkorrekt:',

   'Correct:'
=> 'Korrekt:',

   'Correct'
=> 'Korrekt',

   'Click to select a Coordinate or click Finish to save current selection.'
=> 'Klicken Sie in das Bild, um Koordinaten festzulegen.',

   'Pick course first'
=> 'Erst Kurs auswählen',

   'User Information Changed'
=> 'Geänderte Benutzerdaten',

   'Changed To'
=> 'Geändert in',

   'disk space allocated to portfolio files'
=> 'Speicherplatz für Portfolio-Dateien',

   'You have new messages'
=> 'Sie haben neue Nachrichten',

   'Destination folder'
=> 'Zielverzeichnis',

   'Mark Read'
=> 'Als gelesen kennzeichnen',

   'Move to Folder ->'
=> 'Verschiebe in Verzeichnis',

   'Register Response Devices ("Clickers")'
=> 'Antwortgeräte ("Clicker") registrieren',

   'Enter response device ("clicker") numbers'
=> 'Geben Sie die Nummern der Antwortgeräte ("Clicker") ein',

   'Locating your clicker ID'
=> 'Die Clicker-ID ausfindig machen',

   'Register Clicker'
=> 'Clicker registrieren',

   'Register'
=> 'Registrieren',

   'New Link'
=> 'Neues Lesezeichen', # n.t.

   'Refresh'
=> 'Aktualisieren', # n.t.

   'Custom metadata [_1]: '
=> 'Eigene Metadaten [_1]: ',

   'Question/Comment/Feedback about course content'
=> 'Frage/Anmerkung/Feedback zum Kursinhalt',

   'User modify/custom role edit'
=> 'Benutzeraccounts und Rechte verwalten',

   'User Search'
=> 'Benutzersuche',

   'to add/modify roles'
=> ', um Rollen hinzuzufügen oder zu ändern',

   'is'
=> 'ist',

   'contains'
=> 'enthält',

   'in this domain'
=> 'in dieser Domäne',

   'in institutional directory'
=> 'im Institutsverzeichnis',

   'Domain/institution to search'
=> 'LON-CAPA-Domäne, in der gesucht werden soll',

   'Directory search has not been configured for domain: [_1]'
=> 'Die Verzeichnissuche wurde noch nicht für die Domäne [_1] konfiguriert!',

   'permanent e-mail'
=> 'Permanente E-Mail-Adresse',

   'Set user role'
=> 'Benutzerrolle einrichten',

   'No exact match found for this username ([_1]) in this domain.'
=> 'Kein exakter Treffer für den Benutzer [_1] in dieser Domäne.',

   'No match found for this username ([_1]) in this domain.'
=> 'Kein Treffer für den Benutzer [_1] in dieser Domäne.',

   'Make new user "[_1]"'
=> 'Neuen Benutzer "[_1]" anlegen',

   'Edit Course'
=> 'Kursinhalt einrichten',

   'Choose which items you wish to export from your Course.'
=> 'Wählen Sie, welche Elemente aus dem Kurs exportiert werden sollen.',

   'Content items'
=> 'Inhaltselemente',

   'Discussion posts'
=> 'Diskussionsbeiträge',

   'Export Course DOCS'
=> 'Exportieren',

   'Download the zip file from'
=> 'Download ZIP-Datei:',

   'IMS course archive'
=> 'IMS-Kursarchiv',

   'Export course to IMS content package'
=> 'Kurselemente nach IMS-Inhaltspaket exportieren',

   'last name, first name'
=> 'Nachname, Vorname',

   'Select a Template'
=> 'Auswahl einer Vorlage',

   'Edit custom role'
=> 'Benutzerdefinierte Benutzerrolle einrichten',

   'Privilege'
=> 'Berechtigung',

   'Showing users with a name starting with [_1]'
=> 'Anzeige von Benutzern, deren Name beginnt mit [_1]',

   'Permanent e-mail address'
=> 'Permanente E-Mail-Adresse',

   'Permanent e-mail'
=> 'Permanente E-Mail-Adresse',

   'User [_1] in domain [_2]'
=> 'Benutzer [_1] in Domäne [_2]',

   'Result'
=> 'Ergebnis',

   'Directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Die Institussuche in der Domäne [_1] ist für den angeforderten Suchtyp "[_2]" nicht verfügbar.',

   "No match found for this username ([_1]) in your institution's directory."
=> "Kein Treffer im Institutsverzeichnis für den Benutzer [_1].",

   'Setting'
=> 'Einstellung',

   'Directory search available?'
=> 'Verzeichnissuche verfügbar machen?',

   'Back to actions menu'
=> 'Zurück zur Domänen-Konfiguration', # n.t.

   'Edit action'
=> 'Aktion',

   'Effect'
=> 'Effekt',

   'Course / User'
=> 'Kurs / Benutzer',

   'deny'
=> 'verweigern',

   'allow'
=> 'zulassen',

   'Delete this rule'
=> 'Diese Regel löschen',

   'Insert rule above'
=> 'Regel oberhalb einfügen',

   'Insert rule below'
=> 'Regel unterhalb einfügen',

   'Move rule down'
=> 'Regel nach unten verschieben',

   'Move rule up'
=> 'Regel nach oben verschieben',

   'Warning: It can take up to 1 hour for rights changes to fully propagate.'
=> 'Achtung: Es kann bis zu einer Stunde dauern, bis alle Rechte-Änderungen vollständig wirken.',

   'email address'
=> 'E-Mail-Adresse',

   'Updated'
=> 'Geändert',

   'The error occurred on host  [_1]'
=> 'Der Fehler trat auf dem Host [_1] auf.',

   'This error occurred on machine [_1]'
=> 'Dieser Fehler trat auf Machine [_1] auf.', # n.t.

   'Clear all Messages in Subdirectory'
=> 'Alle Nachrichten im Unterverzeichnis entfernen',

   'Task information'
=> 'Information',

   'Automated adds/drops'
=> 'Automatische Hinzufügungen/Ausschließungen',

   'Change enrollment dates'
=> 'Kursbelegungsdaten ändern',

   'Change access dates'
=> 'Zugriffszeiten ändern',

   'Notification of changes'
=> 'Benachrichtigung über Änderungen',

   'Change crosslistings'
=> 'Querverweise ändern',

   'Section settings'
=> 'Sektions-Einstellungen',

   'Student photo settings'
=> 'Einstellungen studentischer Fotos',

   'Update roster now'
=> 'Kursteilnehmerliste jetzt aktualisieren',

   'Update student photos'
=> 'Studentische Fotos aktualisieren',

   'View students and change type'
=> 'Studenten betrachten und Typ ändern',

   'Changes to nightly automated enrollments'
=> 'Die nächtlichen, automatischen Kursbelegungen ändern',

   'Currently: Nightly adds: [_1], Nightly drops: [_2]'
=> 'Derzeit: Nächtliche Hinzufügungen: [_1], nächtliche Ausschließungen: [_2]',

   'OFF'
=> 'AUS',

   'ON'
=> 'AN',

   'Additions based on classlist changes:'
=> 'Hinzufügungen aufgrund von Änderungen an der Kursteilnehmerliste:',

   'Removals based on classlist changes:'
=> 'Ausschließungen aufgrund von Änderungen an der Kursteilnehmerliste:',

   'Enable'
=> 'Aktivieren	',

   'Disable'
=> 'Deaktivieren',

   'Note: Any students added manually by course coordinators using the Enrollment Manager will be unaffected by the nightly removal process if you choose to enable it.'
=> 'Hinweis: Alle Studenten, die manuell durch den Kurs-Koordinator über die Kursbelegungs-Verwaltung hinzugefügt wurden, werden beim nächtlichen Ausschließungsprozess NICHT berücksichtigt, auch wenn die Ausschließungs-Option aktiviert ist.',

   'Changes to first and/or last automated enrollment dates'
=> 'Änderungen von Anfangs- und/oder Endedatum der automatischen Kursbelegung',

   'Currently: First enrollment: [_1], Last enrollment: [_2]'
=> 'Derzeit: Start der automatischen Kursbelegung: [_1], Ende der automatischen Kursbelegung: [_2]',

   'Set date of first automated enrollment for registered students'
=> 'Setzen des Anfangsdatums der automatischen Kursbelegung für registrierte Studenten',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, once the first enrollment date has been reached. Prior to this date, the class roster will only contain students you have added directly using the standard LON-CAPA enrollment tools'
=> 'Falls das automatische Hinzufügen und Ausschließen aktiviert ist, wird ab dem Anfangsdatum nächtlich die Kursteilnehmerliste automatisch aktualisiert. Vor diesem Zeitpunkt wird die Kursteilnehmerliste nur Studenten enthalten, die über die manuelle Kursbelegung in LON-CAPA eingetragen wurden.',

   'Set date of last automated enrollment for registered students'
=> 'Setzen des Endedatums der automatischen Kursbelegung für registrierte Studenten',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, until the last enrollment date has been reached.'
=> 'Falls das automatische Hinzufügen und Ausschließen aktiviert ist, wird bis zum Erreichen des Endedatums nächtlich die Kursteilnehmerliste automatisch aktualisiert.',

   'Changes to default start and/or end dates for student access'
=> 'Änderungen an dem voreingestellten Anfangs- und/oder Endedatum für studentischen Zugriff',

   'Currently: default first access:'
=> 'Derzeit: voreingesteller erste Zugriff:',

   ', default last access:'
=> ', voreingestellter letzter Zugriff:',

   'Set date of first access for registered students added via automated enrollment'
=> 'Einstellen des Datums für den ersten studentischen Zugriff registrierter Studierender, die über die automatische Kursbelegung hinzugefügt werden',

   'Set date of last access for registered students added via automated enrollment'
=> 'Einstellen des Datums für den letzten studentischen Zugriff registrierter Studierender, die über die automatische Kursbelegung hinzugefügt werden',

   'Changes to section settings'
=> 'Sektionseinstellungen',

   'Currently no sections of'
=> 'Derzeit ist für keine Sektionen des Kurses',

   'are contributing enrollment to the LON-CAPA class roster.'
=> 'eine Teilnahme an der Kursbelegung eingerichtet.',

   'Add enrollment from additional sections.'
=> 'Kursbelegung für weitere Sektionen hinzufügen',

   'Number of new sections to add:'
=> 'Anzahl hinzuzufügender Sektionen:',

   'Students enrolling in the sections listed below will be automatically added to the class roster for LON-CAPA course'
=> 'Studierende, die in die unten aufgelisteten Sektionen eingeschrieben werden, werden automatisch in die Kursteilnehmerliste des Kurses',

   'if you have chosen to enable a nightly automated enrollment update.'
=> 'aufgenommen, falls die nächtliche, automatische Kursbelegung aktiviert ist.',

   'Nightly additions based on classlist changes now'
=> 'Nächtliche Hinzufügungen aufgrund von Kursteilnehmerlisten-Änderungen sind jetzt',

   'Nightly additions based on classlist changes still'
=> 'Nächtliche Hinzufügungen aufgrund von Kursteilnehmerlisten-Änderungen bleiben weiterhin',

   'Nightly removals based on classlist changes now'
=> 'Nächtliche Ausschließungen aufgrund von Kursteilnehmerlisten-Änderungen sind jetzt',

   'Nightly removals based on classlist changes still'
=> 'Nächtliche Ausschließungen aufgrund von Kursteilnehmerlisten-Änderungen bleiben weiterhin',

   'enabled'
=> 'aktiviert',

   'disabled'
=> 'deaktiviert',

   'The first date for automated enrollment has been changed'
=> 'Das Anfangsdatum der automatischen Kursbelegung wurde geändert auf',

   'The last date for automated enrollment has been changed'
=> 'Das Endedatum der automatischen Kursbelegung wurde geändert auf',

   'The first date for automated enrollment has been left unchanged as'
=> 'Das Anfangsdatum der automatischen Kursbelegung bleibt weiterhin',

   'The last date for automated enrollment has been left unchanged as'
=> 'Das Endedatum der automatischen Kursbelegung bleibt weiterhin',

   'Currently: Notification:'
=> 'Derzeit: Benachrichtigung:',

   'Notification of LON-CAPA course roster changes resulting from nightly automated enrollment process?'
=> 'Benachrichtigung über Änderungen an der Kursteilnehmerliste durch die nächtliche, automatische Kursbelegung aktivieren?',

   'The table below contains a list of Kurs-Koordinators in this course.'
=> 'Liste der Kurs-Koordinatoren in diesem Kurs',

   'username:domain'
=> 'Benutzername:Domäne',

   'Course Access'
=> 'Kurs-Zugriff',

   'Current notification status'
=> 'Derzeitiger Benachrichtigungsstatus',

   'Notification active'
=> 'Benachrichtigung aktiv',

   'Notification inactive'
=> 'Benachrichtigung inaktiv',

   'Notification?'
=> 'Benachrichtigen?',

   "The table below contains a list of Domänen-Koordinators from this course's domain who are not also Kurs-Koordinators."
=> "Liste der Domänen-Koordinatoren, die in der Kurs-Domäne liegen, aber nicht zusätzlich Kurs-Koordinatoren sind",

   'Notification of enrollment changes now'
=> 'Benachtrichtigung über Kursbelegungsänderungen ist jetzt',

   'Notification of enrollment changes still'
=> 'Benachtrichtigung über Kursbelegungsänderungen bleibt weiterhin',

   'The following will receive notification if there are any changes in enrollment in LON-CAPA course:'
=> 'Die folgenden Benutzer erhalten eine Benachrichtigung im Falle von Änderungen der Kursteilnehmerliste durch die automatische Kursbelegung des Kurses',

   'as a result of the nightly enrollment check:'
=> 'aufgrund des nächtlichen Kursbelegungsabgleichs:',

   'View/Modify Course Settings'
=> 'Kurseinstellungen betrachten/ändern',

   'Course search'
=> 'Kurs-Suche',

   'View/Modify Courses'
=> 'Kurse betrachten/ändern',

   'Course details'
=> 'Kursdetails',

   'Detailed course information:'
=> 'Detailierte Kursinformationen:',

   'Default Access Dates for Students'
=> 'Voreingestellte Zugriffsdaten für Studierende',

   'Student Counts'
=> 'Anzahl Studierende',

   'Auto-enrollment of <br />registered students'
=> 'Automatische Kursbelegung<br/ >registrierter Studenten',

   'Not enabled'
=> 'Nicht aktiviert',

   'section:'
=> 'Sektion:', # n.t.

   'Current access:'
=> 'Aktueller Zugriff:', # n.t.

   'Future access:'
=> 'Zukünftiger Zugriff:', # n.t.

   'Ended:'
=> 'Ende:', # n.t.

   'Back to course listing'
=> 'Zurück zur Kursübersicht',

   'Immediate course roster update'
=> 'Sofortige Aktualisierung der Kursteilnehmerliste',

   'There were no new students to add to the course.'
=> 'Es exisitieren keine Studenten, die neu am Kurs teilnehmen sollen.',

   'Back to options page'
=> 'Zurück zum Funktionsauswahlmenü',

   'View/Modify settings for: '
=> 'Betrachten/Ändern der Einstellungen für ',

   'Modify quota for group portfolio files'
=> 'Ändern des Speicherplatzes für Gruppen-Portfolio-Dateien',

   'Display current settings for automated enrollment'
=> 'Anzeige der derzeitigen Einstellungen der automatischen Kursbelegung',

   'Modify institutional code, course owner and/or default authentication'
=> 'Ändern des Institutscodes, des Kurs-Eigentümers und/oder der voreingestellten Authentifizierung',

   'Modify course catalog settings for course'
=> 'Ändern der Kursübersicht-Einstellungen für diesen Kurs',

   'Catalog settings'
=> 'Katalog-Einstellungen',

   'Catalog Settings for Course'
=> 'Katalog-Einstellungen für den Kurs',

   'Visibility in Course Catalog'
=> 'Sichtbarkeit in der Kursübersicht',

   "Unless excluded, a course is listed in this domain's publicly accessible course catalog, if at least of one the following applies:"
=> "Unless excluded, a course is listed in this domain's publicly accessible course catalog, if at least of one the following applies:",

   'Auto-cataloging is enabled and the course is assigned an institutional code'
=> 'Automatische Katalogisierung ist aktiviert und dem Kurs wurde ein institutioneller Code zugewiesen',

   'The course has been categorized into at least one of the course categories defined for the domain.'
=> 'Der Kurs wurde in mindestens eine der Kurskategorien, die für diese Domäne angelegt wurden, eingeordnet.',

   'Exclude from course catalog'
=> 'Kurs aus Kursübersicht ausschließen',

   'Categorize Course'
=> 'Kurs kategorisieren',

   'No categories defined for this domain'
=> 'In dieser Domäne wurden bisher keine Kategorien angelegt.',

   'Assign one or more categories to this course.'
=> 'Diesem Kurs eine oder mehrere Kategorien zuweisen:',

   'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).'
=> 'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).',

   'Category settings'
=> 'Kategorie-Einstellungen',

   'Show/Hide a course in the catalog'
=> 'Anzeigen/Verbergen von Kursen im Kursüberblick',

   'Assign a category to a course'
=> 'Einem Kurs eine Kategorie zuweisen',

   'Set in "Modify Course" (Domain)'
=> 'Einstellung in "Kurs einstellen" (Domäne)',

   'Set in "Modify Parameters" (Course)'
=> 'Einstellung in "Parameter ändern" (Kurs)',

   'Categories'
=> 'Kategorien',

   'Add category'
=> 'Kategorie hinzufügen',

   'Add category:'
=> 'Kategorie hinzufügen:',

   'Add subcategory:'
=> 'Unterkategorie hinzufügen:',

   'New:'
=> 'Neu:',

   'Choose a course'
=> 'Kurs auswählen',

   'Pick action'
=> 'Aktion auswählen',

   'Display settings'
=> 'Einstellungen anzeigen',

   'Course settings that control automated enrollment in this LON-CAPA course are currently:'
=> 'Derzeitige Einstellungen der automatischen Kursbelegung dieses Kurses:',

   'Course setting'
=> 'Kurseinstellung',

   'Modifiable by DC only'
=> 'Nur durch Dom.-Koord. änderbar',

   'Default authentication parameter'
=> 'Voreingestellter Authentifizierungsparamater',

   'Default authentication method'
=> 'Voreingestellte Authentifizierungsmetode',

   'Date of last automated enrollment'
=> 'Endedatum der automatischen Kursbelegung',

   'Date of first automated enrollment'
=> 'Anfangsdatum der automatischen Kursbelegung',

   'Official course code'
=> 'Offizieller Kurscode',

   'Username:domain of course owner'
=> 'Benutzername:Domäne des Kurs-Eigentümers',

   'Date of last student access'
=> 'Endedatum des studentischen Zugriffs',

   'Date of first student access'
=> 'Anfangsdatum des studentischen Zugriffs',

   'Course section number(:LON-CAPA section)'
=> 'Kurssektionsnummer(:LON-CAPA-Sektionsnummer)',

   'Show more details'
=> 'Mehr Details',

   'Public RSS/podcast (subscribe to):'
=> 'Öffentliches RSS-Feed/Podcast (Einschreibe-Link):',

   'Course Owner:'
=> 'Kurs-Eigentümer:',

   'Default Authentication method'
=> 'Voreingestellte Authentifizierungsmethode',

   'Modify settings'
=> 'Einstellungen speichern',

   'Automated Enrollment'
=> 'Automatische Kursbelegung',

   'Use the menu on the left to choose an enrollment management task.'
=> 'Wählen Sie im Menü links die gewünschte Aktion zur automatischen Kursbelegung.',

   'Result of Changes to Automated Enrollment Settings.'
=> 'Ergebnis der Änderungen an den Einstellungen zur automatischen Kursbelegung',

   'The following automated enrollment parameters have been changed:'
=> 'Die folgenden Parameter der automatischen Kursbelegung wurden geändert:', # n.t.

   'now set to'
=> 'ist jetzt', # n.t.

   'still set to'
=> 'bleibt weiterhin', # n.t.

   'The following automated enrollment parameters remain unchanged:'
=> 'Die folgenden Parameter der automatischen Kursbelegung bleiben unverändert:', # n.t.

   'Change settings'
=> 'Einstellungen ändern',

   "Student's agreement needed for listing in student-viewable roster"
=> "Studentisches Einverständnis notwendig, um in der von Studenten einsehbaren Kursteilnehmerliste aufgelistet zu werden",

   'Include link to accessible portfolio files'
=> 'Link für erreichbare Portfolio-Dateien einbinden',

   'Print header format'
=> 'Kopfbereich beim Druck',

   'Substitutions:<br />[_1]: student name, [_2]: course id, [_3]: assignment note. Numbers after the <tt>%</tt> limit the field size.'
=> 'Platzhalter:<br />[_1]: Name des Studenten, [_2]: Kurs-ID, [_3]: Beurteilungsanmerkung. Eine Zahl hinter dem <tt>%</tt>-Zeichen begrenzt die Feldgröße.',

   'Force all students in the course to use a specific math rendering engine.'
=> 'Vorgabe für alle Studenten im Kurs, wie wissenschaftliche Formeln dargestellt werden sollen',

   '[_1], [_2] (Convert to Images), [_3] (Tex to HTML), or blank for student\'s preference'
=> '[_1], [_2] (in Grafik konvertieren), [_3] (Tex-nach-HTML) oder leer lassen für studentische Voreinstellung',

   'Bridge Task Grading'
=> 'Bewertung von "Bridge Tasks"',

   'Classlist Manager'
=> 'Automatische Kursbelegung', # !?!

   'Note for students:'
=> 'Hinweis für Studenten:',

   'If you are officially enrolled in a course but the course is not listed in your LON-CAPA courses, click the "Show more details" link for the specific course and check the default access dates and/or automated enrollment settings.'
=> 'Falls Sie einen Kurs Ihrer Einrichtung regulär belegt haben, dieser aber nicht in Ihrer persönlichen LON-CAPA-Kursauswahl (Benutzerrollen) aufgelistet wird, klicken Sie in der unten stehenden Kursübersicht bei dem entsprechenden Kurs auf "Mehr Details". Überprüfen Sie dort die Angaben zum Kursstart und -ende und die Einstellungen der automatischen Kursbelegung.',

   'Please [_1]log in again[_2].'
=> 'Bitte [_1]erneut anmelden[_2].',

   'Switching Server ...'
=> 'Serverwechsel...',

   'Already logged in'
=> 'Bereits angemeldet',

   'Apply style file: '
=> 'Styledatei anwenden: ',

   'The problem '
=> 'Die Aufgabe ',

   'Search criteria'
=> 'Suchkriterien',

   'begins with'
=> 'beginnt mit',

   'in selected LON-CAPA domain'
=> 'in ausgewählter LON-CAPA-Domäne',

   'in institutional directory for selected domain'
=> 'im Institutsverzeichnis der ausgewählten Domäne',

   'No exact match found for the username ([_1]) in LON-CAPA domain: [_2]'
=> 'Kein exakter Treffer für den Benutzer "[_1]" in der LON-CAPA-Domäne [_2]', # n.t.

   'Creating new account.'
=> 'Erzeuge neuen Benutzeraccount...',

   'Report a documentation bug'
=> 'Fehler in der Dokumentation melden (Englisch)',

   'You must specify a valid username. Only the following are allowed: letters numbers - . @'
=> 'Geben Sie einen gültigen Benutzernamen ein. Nur folgende Zeichen sind erlaubt: Buchstaben, Ziffern, "-", "." und "@"',

   'The following need to be corrected before the search can be run:'
=> 'Folgendes muss korrigiert werden, bevor die Suche gestartet werden kann:',

   'You must include some text to search for.'
=> 'Sie müssen Text eingeben, nach dem gesucht werden soll.',

   "The text you are searching for must contain at least two characters when using a 'begins' type search."
=> "Der Text, nach dem gesucht werden soll, muss mindestens zwei Zeichen lang sein, wenn die 'beginnt mit'-Option verwendet wird.",

   "The text you are searching for must contain at least three characters when using a 'contains' type search."
=> "Der Text, nach dem gesucht werden soll, muss mindestens drei Zeichen lang sein, wenn die 'enthält'-Option verwendet wird.",

   'You must choose a domain when using an institutional directory search.'
=> 'Bei der Suche im Institutsverzeichnis muss eine Domäne ausgewählt sein.',

   'You must choose a domain when using a domain search.'
=> 'Bei der zu durchsuchenden Domäne muss eine Domäne ausgewählt sein.',

   "When using searching by last,first you must include a comma as separator between last name and first name."
=> "Bei der Suche mit der Option 'Nachname, Vorname' muss zwischen Vor- und Nachname als Trennzeichen ein Komma stehen.",

   "When searching by last,first you must include at least one character in the first name."
=> "Bei der Suche mit der Option 'Nachname, Vorname' muss der Vorname mindestens ein Zeichen enthalten.",

   'Revoking [_1] in [_2]: [_3]'
=> 'Entziehe Rolle [_1] für [_2]: [_3]',

   'Revoking custom role:'
=> 'Entziehe benutzerdefinierte Rolle:',

   'Deleting [_1] in [_2]: [_3]'
=> 'Entferne Rolle [_1] für [_2]: [_3]',

   'Deleting custom role [_1] by [_2]:[_3] in [_4]'
=> 'Entferne benutzerdefinierte Rolle [_1] von [_2]:[_3] für [_4]',

   'Add to classlist'
=> 'Hinzufügen zur Kursteilnehmerliste',

   'Re-enabling [_1] in [_2]: <b>[_3]</b>'
=> 'Reaktivierung der Rolle [_1] für [_2]: <b>[_3]</b>',

   'Re-enabling custom role [_1] by [_2]@[_3] in [_4] : <b>[_5]</b>'
=> 'Reaktivierung der benutzerdefinierten Rolle [_1] von [_2]@[_3] für [_4] : <b>[_5]</b>',

   'Unknown command'
=> 'Unbekannter Befehl',

   '[_1] may not be used as the name for a section, as it is a reserved word.'
=> '[_1] ist nicht als Sektionsname zulässig, da es sich um ein systemintern-reserviertes Wort handelt.',

   '[_1] may not be used as the name for a section, as it is the name of a course group.'
=> '[_1] ist nicht als Sektionsname zulässig, da er bereits als Name einer bestehenden Kursgruppe verwendet wird.',

   'Please <a href="javascript:history.go(-1)">go back</a> and choose a different section name.'
=> 'Bitte gehen Sie <a href="javascript:history.go(-1)">zurück</a> und wählen Sie einen anderen Sektionsnamen.',

   'Drop from classlist: [_1]'
=> 'Aus Kursteilnehmerliste ausschließen: [_1]',

   'Existing Role'
=> 'Bestehende Rolle',

   'Exisiting Roles'
=> 'Bestehende Rollen',

   'Assigning Role to Self'
=> 'Assigning Role to Self', # ???

   'Invalid search.'
=> 'Ungültige Suche.',

   'You must enter a search term.'
=> 'Sie müssen einen Suchbegriff eingeben.',

   'You must specify a valid domain when searching in a domain or institutional directory.'
=> 'Bei der Domänen- oder Institusverzeichnis-Suche müssen Sie eine gültige Domäne angeben.',

   'You may want to search in the LON-CAPA domain instead of the institutional directory.'
=> 'Anstatt im Institutsverzeichnis könnten Sie alternativ in den LON-CAPA-Domänen suchen.',

   'New users can only be created in the domain to which your current role belongs - [_1].'
=> 'Neue Benutzer können nur in der Domäne angelegt werden, in der auch Ihre derzeitige Rolle liegt - [_1].',

   'Institutional directory search is not available in domain: [_1]'
=> 'Eine Suche im Institutsverzeichnis ist in der Domäne [_1] nicht verfügbar.',

   'Institutional directory search in domain: [_1] is only allowed for users with a current role in the domain.'
=> 'Eine Suche im Institutsverzeichnis in der Domäne [_1] ist nur für Benutzer erlaubt, die eine aktive Rolle in dieser Domäne haben.',

   'Institutional directory search in domain: [_1] is not available to your user type: '
=> 'Eine Suche im Institutsverzeichnis in der Domäne [_1] ist nicht für Ihren Benutzertyp verfügbar: ',

   'Institutional directory search has not been configured for domain: [_1]'
=> 'Die Suchfunktion im Institutsverzeichnis in der Domäne [_1] ist nicht konfiguriert.',

   'Institutional directory search in domain: [_1] is not available for searching by "[_2]"'
=> 'Eine Suche im Institutsverzeichnis in der Domäne [_1] ist nicht verfügbar für eine Suche nach "[_2]"',

   'Institutional directory search in domain: [_1] is not available.'
=> 'Eine Suche im Institutsverzeichnis ist in der Domäne [_1] nicht verfügbar.',

   'Institutional directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Eine Suche im Institutsverzeichnis ist in der Domäne [_1] für den gewünschten Suchtyp "[_2]" nicht verfügbar.',

   'You may want to broaden your search to a search of the institutional directory for the domain.'
=> 'Sie können Ihre Suche auf eine Suche im Institutsverzeichnis der Domäne erweitern.',

   'You may want to broaden your search to the selected LON-CAPA domain.'
=> 'Sie können Ihre Suche auf eine Suche in der gewählten LON-CAPA-Domäne erweitern.',

   'Pick group first'
=> 'Erst Gruppe auswählen',

   'No login name specified'
=> 'Kein Loginname angegeben',

   'Invalid login name'
=> 'Ungültiger Loginname',

   'Only letters, numbers, periods, dashes, @, and underscores are valid'
=> 'Es sind nur erlaubt: Buchstaben, Ziffern, ".", "@", ,"-", "_"',

   'For this user, the default quota would be [_1] Mb.'
=> 'Für diesen Benutzer würde der voreingestellte Speicherplatz [_1] MB betragen.',

   "For this user, the default quota would be [_1] Mb, as determined by the user's institutional affiliation ([_2])."
=> "Für diesen Benutzer würde der voreingestellte Speicherplatz [_1] MB betragen, beschränkt durch die institutionelle Angliederung ([_2]).",

   'For this user, the default quota is [_1] Mb.'
=> 'Für diesen Benutzer ist der voreingestellte Speicherplatz [_1] MB.',

   "For this user, the default quota of [_1] Mb, is determined by the user's institutional affiliation ([_2])."
=> "Für diesen Benutzer beträgt der voreingestellte Speicherplatz [_1] MB, beschränkt durch die institutionelle Angliederung ([_2]).",

   'in all LON-CAPA domains.'
=> 'in allen LON-CAPA-Domänen.',

   'in LON-CAPA domains:'
=> 'in den LON-CAPA-Domänen:',

   'in LON-CAPA domain '
=> 'in LON-CAPA-Domäne ',

   'Course settings modifiable by [_1] only.'
=> 'Kurs-Einstellungen, die nur durch einen [_1] änderbar sind',

   'Course Owner'
=> 'Kurs-Eigentümer',

   'Username:Domain'
=> 'Benutzername:Domäne',

   'Course Activity'
=> 'Letzte Kursaktivität',

   'Course Description'
=> 'Kursbeschreibung',

   'Course Domain'
=> 'Kurs-Domäne',

   'Course Institutional Code'
=> 'Kurs-Instituts-Code',

   "Course Owner's Username"
=> "Benutzername des Kurs-Eigentümers",

   "Course Owner's Domain"
=> "Domäne des Kurs-Eigentümers",

   'Course Type'
=> 'Kurstyp',

   'LON-CAPA course ID'
=> 'LON-CAPA-Kurs-ID',

   'None found'
=> 'Keine Treffer',

   'Course settings which only a [_1] may modify.'
=> 'Kurs-Einstellungen, die nur ein [_1] ändern kann.',

   "Click a 'Select' button to view or modify settings for a [_1] which may only be modified by a [_2] in this domain."
=> "Klicken Sie auf den Auswahl-Button eines [_1], um die Einstellungen für diesen [_1] zu betrachten oder zu ändern, die nur durch einen [_2] in dieser Domäne geändert werden können.",

   'Single user search'
=> 'Suche einzelner Student',

   'Set enrollment'
=> 'Kursbelegung einstellen',

   'Please review the information in "Log-in help" and the "Getting started" guide if you are unable to log-in.'
=> 'Bitte schauen Sie zunächst in die "Login-Hilfe" und in die "Kurzeinleitung für Studierende", falls Sie sich nicht anmelden können.',

   'Please review the information in "Log-in help" if you are unable to log-in.'
=> 'Bitte schauen Sie zunächst in die "Login-Hilfe", falls Sie sich nicht anmelden können.',

   'If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.'
=> 'Wenn sich damit die Probleme nicht lösen lassen, dann können Sie das Formular auf dieser Seite ausfüllen und eine Anfrage an das Helpdesk schicken.',

   'Getting started guide'
=> 'Kurzeinleitung für Studierende',

   '[_1] [_2] [_3] [_4] [_5]m [_6]s ' # "mm dd yyyy hh mi ss" (1:month, 2:day, 3:year, 4:hour, 5:minute, 6:second)
=> '[_2]. [_1] [_3], [_4]:[_5]:[_6] ', # "dd. mm yyyy, hh:mi:ss"

   '[_1]Select Date[_2]'
=> '[_1]Datum auswählen[_2]',

   '[_1]: students can view all sections. [_2]: students can only view their own section. blank or [_3] prevents student view.'
=> '[_1]: Studenten können alle Sektionen sehen. [_2]: Studenten können nur ihre eigene Sektion sehen. Leer lassen oder [_3]: keine Einsicht für Studenten.',

   '[_1] to require students to opt-in to listing in the roster (on the roster page).'
=> '[_1], um Notwendigkeit des studentischen Einverständnisses zu aktivieren.',

   '[_1] for link to each a listing of each student\'s files.'
=> '[_1] zum Einbinden von Links zu jeder Liste mit den Dateien eines jeden Studenten.',

   '[_1]: student, [_2]: TA, [_3]: instructor'
=> '[_1]: Student, [_2]: Tutor, [_3]: Dozent',

   'role:section,role:section,...'
=> 'Rolle:Sektion,Rolle:Sektion,...',

'Example: "<tt>st:001,st:002,in,cc</tt>" would permit students in sections 001 and 002 and instructors in any section, and course coordinators to edit their own posts.'
=> 'Beispiel: "<tt>st:001,st:002,in,cc</tt>" würde Studenten in den Sektionen 001 und 002, Dozenten und Kurs-Koordinatoren in beliebigen Sektionen erlauben, ihre Beiträge zu editieren.',

   'supported types'
=> 'Unterstützte Formate',

   '[_1] to send a message only to student, [_2] to send message to student and add record to user information page for instructors. Leave blank to disable.'
=> '[_1], um Nachricht nur an Studenten zu schicken. [_2], um Nachricht an Studenten zu schicken und Eintrag in die Seite der studentischen Benutzerdaten für Dozenten einzutragen. Leer lassen, um zu deaktivieren.',

   'Instructors and TAs in sections, when grading bridge tasks, should be allowed to grade other sections.'
=> 'Wenn Dozenten und Tutoren bestimmter Sektionen "Bridge tasks" bewerten, auch die Bewertung anderer Sektionen erlauben.',

   '[_1]: they are allowed (this is the default). [_2]: no, they can only grade their own section.'
=> '[_1]: erlauben (voreingestellt). [_2]: nur eigene Sektion.',

   'Calendar Announcement for '
=> 'Kalender-Ankündigung für den Kurs ',

   'Opening'
=> 'Start',

   'Closing'
=> 'Ende',

   "<b>To add a new user</b> (you can only create new users in your current role's domain - <span class=\"LC_cusr_emph\">[_1]</span>):"
=> "<b>Um einen neuen Benutzer hinzuzufügen...</b> (Neue Benutzer können nur in der Domäne Ihrer Benutzerrolle erzeugt werden - <span class=\"LC_cusr_emph\">[_1]</span>):",

   "Set 'Domain/institution to search' to: <span class=\"LC_cusr_emph\">[_1]</span>"
=> "Setzen Sie die Domäne, in der gesucht werden soll, auf <span class=\"LC_cusr_emph\">[_1]</span>",

   "Set 'Search criteria' to: <span class=\"LC_cusr_emph\">'username is ...... in selected LON-CAPA domain'"
=> "Setzen Sie 'Suchkriterien' auf <span class=\"LC_cusr_emph\">'Benutzername ist ... in ausgewählter LON-CAPA-Domäne'",

   'Provide the proposed username'
=> 'Geben Sie den gewünschten Benutzernamen ein',

   'Select a user to add/modify roles'
=> 'Wählen Sie einen Benutzer, für den Sie Rollen oder Berechtigungen ändern bzw. hinzufügen möchten',

   'User Search to add/modify roles'
=> 'Benutzersuche zum Hinzufügen/Ändern von Rollen oder Berechtigungen',


# Feedback messages:

   'You have entered that answer before'
=> 'Sie hatten diese Antwort bereits eingegeben',

   "Computer's answer now shown above."
=> "Die als richtig hinterlegte Antwort wird oben angezeigt.",

   'You are correct.'
=> 'Korrekt!',

   'You are partially correct.'
=> 'Teilweise korrekt.',

   'Incorrect'
=> 'Inkorrekt',

   'A score has been assigned.'
=> 'Bewertung wurde zugewiesen', # ???

   'Your receipt is [_1]'
=> 'Ihr Nachweis ist [_1]',

   'You are excused from the problem.'
=> 'Die Aufgabe ist Ihnen erlassen worden.',

   'Some extra items were submitted.'
=> 'Es wurden zuviele Antwortelemente angegeben.',

   'Some items were not submitted.'
=> 'Die Fragen wurden nicht vollständig beantwortet.',

   'An error occured while grading your answer.'
=> 'Während der Bewertung Ihrer Antwort ist ein Fehler aufgetreten.',

   'The submitted answer was too long.'
=> 'Ihre Antwort ist zu lang.',

   'This question expects a numeric answer.'
=> 'Eine numerische Antwort ist gefragt.',

   'You have provided an invalid ranking.'
=> 'Die eingebene Rangordnung ist ungültig.',

   'Please refer to [_1]'
=> 'Hilfe erhalten Sie unter [_1]',

   'help on ranking problems'
=> 'Hilfe zu Rangordnungs-Aufgaben',

   'Submission won\'t be graded. The type of file submitted is not allowed.'
=> 'Ihre Antwort wurde nicht gewertet. Der Dateityp ist nicht erlaubt.',

   'Submission not graded.  Use fewer digits.'
=> 'Ihre Antwort wurde nicht gewertet. Verwenden Sie weniger Dezimalstellen.',

   'Submission not graded.  Use more digits.'
=> 'Ihre Antwort wurde nicht gewertet. Verwenden Sie mehr Dezimalstellen.',

   'Error in instructor specifed unit. This error has been reported to the instructor.'
=> 'Es liegt ein Fehler in der vom Dozenten vorgegebenen Einheit vor. Der Fehler wurde an den Dozenten gemeldet.',

   'Unable to interpret units. Computer reads units as "[_1]".'
=> 'Einheiten können nicht ausgewertet werden. Computer versteht Einheiten als "[_1]".',

   'Incompatible units. No conversion found between "[_1]" and the required units.'
=> 'Inkompatible Einheiten. Keine Umrechnungsmöglichkeit zwischen "[_1]" und der benötigten Einheit gefunden.',

   'Only a number required. Computer reads units of "[_1]".'
=> 'Als Eingabe ist nur eine Zahl zulässig. Der Computer interpretiert Ihre Eingabe so, als wollten Sie die Einheit "[_1]" verwenden.',

   'Proper comma separation is required'
=> 'Eine ordentliche Trennung durch Kommata ist erforderlich.',

   'Unable to understand formula'
=> 'Der eingegebene Ausdruck kann nicht ausgewertet werden',

   'Your submission has been recorded.'
=> 'Ihre Antwort wurde gespeichert.',

   'A draft copy has been saved.'
=> 'Ihr Entwurf wurde gespeichert.',

   'Nothing submitted.'
=> 'Es wurde nichts eingereicht.',

   'Unknown message'
=> 'Unbekannte Meldung',

   'Returned file(s): [_1]'
=> 'Zurückgelieferte Datei(en): [_1]',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Antwort eingereicht. Die Daten werden nach dem Fälligkeitsdatum ausgewertet.',

# --/


   ' The last submission was after the Due Date '
=> ' Die letzte Einreichung erfolgte nach dem Fälligkeitsdatum ',

   'Submit a file: (only one file can be uploaded)'
=> 'Datei einreichen: (Es kann nur eine Datei hochgeladen werden)',

   'OR:'
=> 'ODER:',

   'Select Portfolio Files'
=> 'Auswahl Portfolio-Dateien',

   'Portfolio files previously selected: [_1]'
=> 'Zuvor ausgewählte Portfolio-Dateien: [_1]',

   '<span class="LC_error">These file(s) don\'t exist:</span> [_1]'
=> '<span class="LC_error">Diese Datei(en) existiert nicht:</span> [_1]',

   '<i>From:</i> '
=> '<i>Start:</i> ',

   '<i>To:</i> '
=> '<i>Ende:</i> ',

   'Previously published version'
=> 'Zuvor veröffentlichte Version',

   'You do not have privileges to modify the authentication configuration for this user.'
=> 'Sie haben nicht die Berechtigung, die Authentifizierungs-Konfiguration dieses Benutzers zu ändern.',

   'You do not have privileges to modify the portfolio quota for this user.'
=> 'Sie haben nicht die Berechtigung, den Portfolio-Speicherplatz dieses Benutzers zu ändern.',

   'If a change is required, contact a domain coordinator for the domain'
=> 'Falls notwendig, kontaktieren Sie einen Domänen-Koordinator der Domäne',

   'with submissions'
=> 'mit Antworten',

   'in grading queue'
=> 'in Bewertungs-Warteschlange',

   'with ungraded submissions'
=> 'mit unbewerteten Antworten',

   'with incorrect submissions'
=> 'mit inkorrekten Antworten',

   'with any status'
=> 'mit beliebigem Status',

   'Default value or none'
=> 'Voreingestellt oder nichts',

   'Floating Point between 1 and 0'
=> 'Gleitkommazahl zwischen 0 und 1',

   'Floating point number between zero and one'
=> 'Gleitkommazahl zwischen Null und Eins',

   'Positive Floating Point'
=> 'Positive Gleitkommazahl',

   'Positive floating point number or zero'
=> 'Positive Gleitkommazahl oder Null',

   'Floating Point'
=> 'Gleitkommazahl',

   'Floating point number'
=> 'Gleitkommazahl',

   'Auto-enrollment settings'
=> 'Einstellungen für automatische Kursbelegungen',

   'Configuration setting'
=> 'Konfigurations-Einstellung', # n.t.

   'Value(s)'
=> 'Wert(e)', # n.t.

   'Auto-enrollment active?'
=> 'Automatische Kursbelegung aktivieren?',

   'Access to other pages will be prevented until you have moved the message to your inbox.'
=> 'Zugriff auf andere Seiten wird erst ermöglicht, wenn Sie diese Nachricht in Ihren Posteingang verschoben haben.',

   'Access to other pages will be prevented until you have moved all critical messages to your inbox.'
=> 'Zugriff auf andere Seiten wird erst ermöglicht, wenn Sie alle wichtigen Nachrichen in Ihren Posteingang verschoben haben.',

   'Move to Inbox'
=> 'In Posteingang verschieben',

   'Move to Inbox/Compose reply'
=> 'In Posteingang verschieben und antworten',

   'Confirm Receipt'
=> 'Empfang bestätigen',

   'Confirm Receipt and Reply'
=> 'Empfang bestätigen und antworten',

   'Displaying Critical Messages'
=> 'Anzeige wichtiger Nachrichten',

   'Confirming Receipt'
=> 'Empfang bestätigen',

   'Confirmed Receipt'
=> 'Empfang bestätigt',

   'Communicate'
=> 'Kommunikation',

   'Replying to a Critical Message'
=> 'Antwort auf wichtige Nachricht',

   'Answer Available'
=> 'Antwort verfügbar',

   ' to '
=> ' bis ', # ???

   'Event from [_1] to [_2]'
=> 'Veranstaltung von [_1] bis [_2]',

   '[_1]: [_2] from domain [_3]'
=> '[_1]: Aus der Domäne [_3] [_2]',

   'The following problems occurred:'
=> 'Die folgenden Probleme traten auf:',

   'Could not initialize [_1] at this time.'
=> 'Initialisierung von [_1] war nicht möglich.',

   'Please try again.'
=> 'Bitte versuchen Sie es noch einmal.',

   'Enrolling [_1] : [_2]'
=> '[_1]:[_2] wird in den Kurs aufgenommen',

   'in this course'
=> 'in diesem Kurs',

   'Remove Checked Entries'
=> 'Ausgewählte Einträge entfernen',

   'Modify Student Data'
=> 'Studentische Daten ändern',

   'First name'
=> 'Vorname',

   'Middle name'
=> 'Zweiter Vorname',

   'Last name'
=> 'Nachname',

   'ID'
=> 'ID/Matrikelnummer',

   'Sending critical message'
=> 'Sende wichtige Nachricht an',

   'Replying to'
=> 'Antwort an',

   '<b>[_1] messages</b>: showing messages [_2] through [_3] of [_4].'
=> '<b>Nachrichten ([_1])</b>: Anzeige der Nachrichten [_2] bis [_3] von insgesamt [_4]',

   'Broadcast Message'
=> 'Broadcast-Nachricht',

   'contents hidden'
=> 'Inhalte verborgen',

   'Resources in course with version changes since yesterday'
=> 'Ressourcen im Kurs mit Versionsänderungen seit gestern',

   'Resources in course with version changes since last week'
=> 'Ressourcen im Kurs mit Versionsänderungen seit letzter Woche',

   'Resources in course with version changes since last month'
=> 'Ressourcen im Kurs mit Versionsänderungen seit letztem Monat',

   'Resources in course with version changes seit start of course'
=> 'Ressourcen im Kurs mit Versionsänderungen seit Kursbeginn',

   'No version changes since yesterday'
=> 'Keine Versionsänderungen seit gestern',

   'No version changes since last week'
=> 'Keine Versionsänderungen seit letzter Woche',

   'No version changes since last month'
=> 'Keine Versionsänderungen seit letztem Monat',

   'No version changes since start of course'
=> 'Keine Versionsänderungen seit Kursbeginn',

   'version changes since yesterday'
=> 'Versionsänderungen seit gestern',

   'version changes since last week'
=> 'Versionsänderungen seit letzter Woche',

   'version changes since last month'
=> 'Versionsänderungen seit letztem Monat',

   'version changes seit start of course'
=> 'Versionsänderungen seit Kursbeginn',

   'Roles for which access to course has expired since yesterday'
=> 'Seit gestern in diesem Kurs abgelaufene Rollen',

   'Roles for which access to course has expired since last week'
=> 'Seit letzter Woche in diesem Kurs abgelaufene Rollen',

   'Roles for which access to course has expired since last month'
=> 'Seit letztem Monat in diesem Kurs abgelaufene Rollen',

   'Roles for which access to course has expired since start of course'
=> 'Seit Beginn des Kurses in diesem Kurs abgelaufene Rollen',

   'There are no roles which expired since yesterday'
=> 'Keine Rollen, die in diesem Kurs seit gestern abgelaufen sind',

   'There are no roles which expired since last week'
=> 'Keine Rollen, die in diesem Kurs seit letzter Woche abgelaufen sind',

   'There are no roles which expired since last month'
=> 'Keine Rollen, die in diesem Kurs seit letztem Monat abgelaufen sind',

   'There are no roles which expired since start of course'
=> 'Keine Rollen, die in diesem Kurs seit Kursbeginn abgelaufen sind',

   'roles which expired since yesterday'
=> 'seit gestern in diesem Kurs abgelaufene Rollen',

   'roles which expired since last week'
=> 'seit letzter Woche in diesem Kurs abgelaufene Rollen',

   'roles which expired since last month'
=> 'seit letztem Monat in diesem Kurs abgelaufene Rollen',

   'roles which expired since start of course'
=> 'seit Beginn des Kurses in diesem Kurs abgelaufene Rollen',

   'Roles for which access to course has become available since yesterday'
=> 'Seit gestern diesem Kurs zugeteilte Rollen',

   'Roles for which access to course has become available since last week'
=> 'Seit letzter Woche diesem Kurs zugeteilte Rollen',

   'Roles for which access to course has become available since last month'
=> 'Seit letztem Monat diesem Kurs zugeteilte Rollen',

   'Roles for which access to course has become available since start of course'
=> 'Seit Beginn des Kurses diesem Kurs zugeteilte Rollen',

   'There are no roles which have become active since yesterday'
=> 'Keine Rollen, die seit gestern diesem Kurs zugeteilt sind',

   'There are no roles which have become active since last week'
=> 'Keine Rollen, die seit letzter Woche diesem Kurs zugeteilt sind',

   'There are no roles which have become active since last month'
=> 'Keine Rollen, die seit letztem Monat diesem Kurs zugeteilt sind',

   'There are no roles which have become active since start of course'
=> 'Keine Rollen, die seit Kursbeginn diesem Kurs zugeteilt sind',

   'roles which have become active since yesterday'
=> 'seit gestern diesem Kurs zugeteilte Rollen',

   'roles which have become active since last week'
=> 'seit letzter Woche diesem Kurs zugeteilte Rollen',

   'roles which have become active since last month'
=> 'seit letztem Monat diesem Kurs zugeteilte Rollen',

   'roles which have become active since start of course'
=> 'seit Beginn des Kurses diesem Kurs zugeteilte Rollen',

   'Show all posts'
=> 'Alle Beiträge anzeigen',

   'to display'
=> 'to display', # ???

   'posts previously marked read'
=> 'Beiträge, die zuvor als gelesen gekennzeichnet wurden',

   'previously viewed posts'
=> 'Beiträge, die zuvor angezeigt wurden',

   'NEW'
=> 'NEU',

   'Preferences on what is marked as NEW'
=> 'Präferenzen, was als NEU markiert werden soll',

   'Mark NEW posts no longer new'
=> 'Mit NEU gekennzeichnete Nachrichten nicht länger als neu markieren',

   'Sorting/Filtering options'
=> 'Sortierungs-/Filter-Optionen',

   'Export'
=> 'Exportieren',

   'Attachments'
=> 'Anhänge',

   'Download the zip file from [_1]Discussion Posting Archive'
=> 'Download ZIP-Datei vom [_1]Diskussionsbeitrags-Archiv',

   'The following errors occurred during export'
=> 'Die folgenden Fehler sind beim Export aufgetreten',

   'Unfortunately you will not be able to retrieve an archive of the discussion posts at this time, because there was a problem creating a manifest file.'
=> 'Leider können Sie derzeit kein Archiv von Diskussionsbeiträgen erhalten, da es Probleme mit der Erstellung einer Manifest-Datei gab.',

   'Make Visible'
=> 'Anzeigen',

   'Reply'
=> 'Antwort',

   'Mark unread'
=> 'Als ungelesen kennzeichnen',

   'Mark read'
=> 'Als gelesen kennzeichnen',

   'This post has been edited by the author.'
=> 'Dieser Beitrag wurde vom Autor überarbeitet.',

   'Display all versions'
=> 'Alle Versionen anzeigen',

   'Earlier version(s) were posted on: '
=> 'Frühere Versionen wurden gesendet am: ',

   'You do not have privileges to view all versions of posts.'
=> 'Sie sind nicht berechtigt, alle Versionen von Beiträgen anzuschauen.',

   'Please select a different role.'
=> 'Bitte wählen Sie eine andere Benutzerrolle.',

   'Error copying file attachment - [_1] to IMS package'
=> 'Fehler beim Kopieren des Datei-Anhangs - [_1] ins IMS-Paket',

   'Error copying file attachment - [_1] to IMS package: '
=> 'Fehler beim Kopieren des Datei-Anhangs - [_1] ins IMS-Paket: ',

   'Re: '
=> 'Re: ',

   'Please select a feedback type.'
=> 'Bitte wählen Sie einen Feedback-Typ aus.',

   'Sorry, no feedback possible on this resource  ...'
=> 'Sorry, für diese Ressource kann kein Feedback gesendet werden.',

   'Error sending message to [_1], no user specified.'
=> 'Fehler beim Senden der Nachricht an [_1]. Es wurde kein Benutzer angegeben.',

   'Error sending message to [_1], no domain specified.'
=> 'Fehler beim Senden der Nachricht an [_1]. Es wurde keine Domäne angegeben.',

   'Error sending message to'
=> 'Fehler beim Sender der Nachricht an',

   'Not registered'
=> 'Nicht registriert', # ???

   'Editing not permitted'
=> 'Überarbeiten nicht erlaubt',

   'Marked postings read/unread'
=> 'Neue Beiträge als gelesen/ungelesen kennzeichnen',

   'Changed sort/filter'
=> 'Sortierung/Filter geändert',

   'Changed display status'
=> 'Anzeigestatus geändert',

   'Deletion not permitted'
=> 'Löschen nicht erlaubt',

   'Changed discussion status'
=> 'Diskussionsstatus geändert',

   'Changed discussion view mode'
=> 'Diskussionsanzeige-Modus geändert',

   'Added to my course blog'
=> 'Zum eigenen Kurs-Blog hinzugefügt',

   'Back to previous page'
=> 'Zurück zur vorherigen Seite',

   'Go to previous page'
=> 'Zurück',

   'Return to previous page'
=> 'Zurück zur vorherigen Seite',

   'Untitled resource'
=> 'Ressource ohne Titel',

   'Discussion display options'
=> 'Diskussions-Anzeige-Optionen',

   'Preferences can be set for this discussion that determine ....'
=> 'Für diese Diskussion können Präferenzen eingestellt werden, die festlegen...',

   'Which posts are displayed when you display this bulletin board or resource, and'
=> 'welche Beiträge angezeigt werden, wenn Sie dieses Schwarze Brett bzw. diese Ressource anzeigen',

   'Under what circumstances posts are identified as "NEW", and'
=> 'unter welchen Bedingungen Beiträge als "NEU" identifiziert werden',

   'Whether individual posts can be marked as read/unread'
=> 'ob individuelle Beiträge als gelesen/ungelesen gekennzeichnet werden dürfen',

   'Posts not marked read'
=> 'Beiträge, die nicht als gelesen gekennzeichnet wurden',

   'New posts cease to be identified as "New"?'
=> 'Wann sollen neue Diskussionsbeiträge nicht mehr als "NEU" identifiziert werden?',

   'New posts cease to be identified as "NEW"?'
=> 'Wann sollen neue Diskussionsbeiträge nicht mehr als "NEU" identifiziert werden?',

   'Option to mark each post as read/unread?'
=> 'Option anbieten, Beiträge als gelesen/ungelesen zu kennzeichnen?',

   'Shown'
=> 'anzeigen',

   'Not shown'
=> 'nicht anzeigen',

   'Discussion options'
=> 'Diskussionsforen-Optionen',

   'Set options that control the sort order of posts, and/or which posts are displayed.'
=> 'Einstellungen der Sortierungsreihenfolge von Beiträgen und welche Beiträge angezeigt werden',

   'Sort order'
=> 'Sortierungsreihenfolge',

   'Date order - oldest first'
=> 'nach Datum - ältester Beitrag zuerst',

   'Date order - newest first'
=> 'nach Datum - neuester Beitrag zuerst',

   'Threaded'
=> 'nach Beiträgen', # ???

   'By subject'
=> 'nach Thema',

   'By domain and username'
=> 'nach Domäne und Benutzername',

   'By last name, first name'
=> 'nach Nachname, Vorname',

   'Specific role status'
=> 'Rollenstatus',

   'Roles of any status'
=> 'beliebig',

   'Only active roles'
=> 'nur aktive',

   'Only past roles'
=> 'nur inaktive',

   'Only future roles'
=> 'nur zukünftige',

   'Specific user roles'
=> 'Benutzerrollen',

   'All roles'
=> 'Alle Rollen',

   'Students'
=> 'Studenten',

   'Course Coordinators'
=> 'Kurs-Koordinatoren',

   'Instructors'
=> 'Dozenten',

   'TAs'
=> 'Tutoren',

   'Exam proctors'
=> 'Klausuraufsichtspersonal',

   'Custom role'
=> 'Benutzerdefinierte Rolle',

   'Custom roles'
=> 'Benutzerdefinierte Rollen',

   'Specific sections'
=> 'Sektionen',

   'Specific groups'
=> 'Gruppen',

   'Pick specific users (by name)'
=> 'Benutzer auswählen (Name)',

   'Show a list of current posters'
=> 'Liste aktueller Beitragssender anzeigen',

   'So far, no data has been returned for your request'
=> 'Bis jetzt hat Ihre Anfrage keine Daten zurückgeliefert.',

   'Select a user'
=> 'Benutzerauswahl',

   'An error occured while processing this resource. The course personnel ([_1]) and the author have been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Das Kurspersonal ([_1]) und der Autor wurden informiert.',

   'photo'
=> 'Foto',

   'Critical Message'
=> 'Wichtige Nachricht',

   'Display a Message'
=> 'Nachricht anzeigen',

   'Back to Folder Display'
=> 'Zurück zur Verzeichnisliste',

   'Currently available actions (will open extra window):'
=> 'Verfügbare Aktionen (öffnet neues Fenster):',

   'There are no ungelesen messages in this folder.' # !
=> 'In diesem Verzeichnis befinden sich keine ungelesenen Nachrichten.',

   'There are no gelesen messages in this folder' # !
=> 'In diesem Verzeichnis befinden sich keine gelesenen Nachrichten.',

   'There are no weitergeleitet messages in this folder.' # !
=> 'In diesem Verzeichnis befinden sich keine weitergeleiteten Nachrichten.',

   'You have not replied to any messages in this folder.'
=> 'In diesem Verzeichnis befinden sich keine Nachrichten, auf die Sie geantwortet haben.',

   'Empty Folder'
=> 'Leeres Verzeichnis',

   'Cc:'
=> 'CC:',

   'Bcc:'
=> 'BCC:',

   'Retrieve discussion and message records'
=> 'Aufzeichungen von Diskussionen und Nachrichten abrufen',

   'New Record (record is visible to course faculty and staff)'
=> 'Neue Aufzeichnung (nur für Kursverwaltung und Personal sichtbar):',

   'Post this Record'
=> 'Speichern',

   'Revise your search criteria for this domain'
=> 'Suchkriterien für die Suche in dieser Domäne ändern',

   'You can specify an external URL as Syllabus in the [_1].'
=> 'Sie können in den [_1] eine externe URL für den Kursüberblick angeben.',

   'Course Parameters'
=> 'Kurs-Parametern',

   'Metadata Modified'
=> 'Geänderte Metadaten',

   'Use of LON-CAPA requires Javascript to be enabled in your web browser.'
=> 'Zur Verwendung von LON-CAPA ist es notwendig, dass Sie Javascript in Ihrem Webbrowser aktiviert haben.',

   'As this is not the case, most functionality in the system will be unavailable.'
=> 'Da dies momentan nicht der Fall ist, werden die meisten Funktionen des Systems nicht zur Verfügung stehen.',

   'You have requested to create file in directory [_1] which doesn\'t exist. The requested directory path has been removed from the requested file name.'
=> 'Schreiben in das Verzeichnis [_1] ist nicht möglich, da es nicht existiert. Der entsprechende Verzeichnispfad wurde daher entfernt.',

   'Directory'
=> 'Verzeichnis',

   'Only empty directories may be deleted.'
=> 'Es können nur leere Verzeichnisse gelöscht werden.',

   'You must delete the contents of the directory first.'
=> 'Sie müssen zunächst die Inhalte aus dem Verzeichnis entfernen.',

   'Cannot delete non-obsolete published file'
=> 'Veröffentlichte, aber nicht als überholt gekennzeichnete Dateien können nicht gelöscht werden.',

   'Must not include'
=> 'Darf nicht enthalten:',

   'Name of new file is the same as name of old file'
=> 'Name der neuen Datei ist der gleiche wie der der alten Datei',

   'no action taken'
=> 'keine Aktion ausgeführt',

   'copy metadata error'
=> 'Fehler beim Metadaten-Kopieren',

   'No New filename specified'
=> 'Kein neuer Dateiname angegeben',

   'Warning: a published problem of this name exists.'
=> 'Achtung: eine veröffentlichte Aufgabe mit diesem Namen existiert bereits.',

   'Warning: a published library of this name exists.'
=> 'Achtung: eine veröffentlichte Bibliothek mit diesem Namen existiert bereits.',

   'Bad filename [_1].<br /> <tt>(name).(number).(extension)</tt> not allowed. <br /> Removing the <tt>.number.</tt> from requested filename.'
=> 'Ungültiger Dateiname [_1].<br /> <tt>(Name).(Zahl).(Erweiterung)</tt> ist nicht zulässig. <br /> Entferne <tt>.Zahl.</tt> vom gewünschten Dateinamen.',

   'Cannot change MIME type of a directory'
=> 'Der MIME-Typ eines Verzeichnisses kann nicht geändert werden',

   'Cannot rename or move non-obsolete published file'
=> 'Veröffentlichte, aber nicht als überholt gekennzeichnete Dateien können nicht umbenannt oder verschoben werden',

   'Change discussion display'
=> 'Anzeige von Diskussionen ändern',

'Choose whether or not to display a count of the number of new posts for each resource or bulletin board which has unread posts.'
=> 'Wahl, ob Anzahl neuer Beiträge in einzelnen Ressourcen oder Anzahl ungelesener Beiträge in Schwarzen Brettern angezeigt werden sollen.',

   "This can increase the time taken to gather data for the '<i>What's New?</i>' page by a few seconds."
=> "Dies kann die Dauer des Zusammenstellens der Daten für die '<i>Was-gibt's-Neues-Seite</i>' um ein paar Sekunden erhöhen.",

   'Currently set to <b>on</b>.'
=> 'Derzeit eingestellt auf <b>an<b>.',

   'Currently set to <b>off</b>.'
=> 'Derzeit eingestellt auf <b>aus<b>.',

   'Change to [_1]'
=> 'Auf [_1] umstellen',

   'No change'
=> 'Keine Änderung',

   'Count unread posts in discussions display set to [_1]'
=> 'Zähler für ungelesene Beiträge in Diskussionen auf [_1] gestellt.',

   'Groups Manager'
=> 'Gruppenverwaltung',

   'None available'
=> 'keine verfügbar',

   'There are no active, future or previous group members to modify.'
=> 'Es existieren weder aktive, zukünftige noch in der Vergangenheit liegende Gruppen-Mitgliedschaften, die geändert werden könnten.',

   'Files: '
=> 'Dateien: ',

   'Folders: '
=> 'Verzeichnisse: ',

   'Choose Task'
=> 'Aktion wählen',

   'Modify default group settings'
=> 'Voreingestellte Gruppeneinstellungen',

   'Modify access, tools and/or privileges for previous, future, or current members'
=> 'Zugriff, Werkzeuge und Berechtigungen für Gruppenmitglieder',

   'Add member(s) to the group'
=> 'Gruppenmitglieder hinzufügen',

   'Group Settings'
=> 'Gruppeneinsstellungen',

   'Group name, title and available collaborative tools'
=> 'Gruppenname, Titel und verfügbare kollaborative Werkzeuge',

   'Letters, numbers and underscore only'
=> 'nur Buchstaben, Ziffern und Unterstrich',

   'Discussion boards'
=> 'Diskussionsforen',

   'E-mail'
=> 'E-Mail',

   'File repository'
=> 'Dateisammlung',

   'Group home page'
=> 'Gruppen-Homepage',

   'Membership roster'
=> 'Mitglieder-Teilnehmerliste',

   'Granularity:'
=> 'Granularität:',

   'Different subsets of the chosen collaborative tools for different group members?'
=> 'Unterschiedliche Teilbereiche der gewählten kollaborativen Werkzeuge für unterschiedliche Gruppenmitglieder?',

   'Disk quota: '
=> 'Speicherplatz: ',

   'If you enable the file repository for the [_1], allocate a disk quota.'
=> 'Falls Sie die Dateisammlung für die [_1] aktivieren, Speicherplatz zuweisen:',

   'A total of [_1] Mb can be divided amongst all [_2]s in the [_3], and [_4] Mb are currently unallocated.'
=> 'Insgesamt können [_1] MB auf alle [_2]s im [_3] aufgeteilt werden. [_4] MB sind derzeit nicht zugewiesen.',

   'Default start and end dates for group access'
=> 'Voreingestelltes Anfangs- und Endedatum für Gruppenzugriff',

   'Start:'
=> 'Start:',

   'End:'
=> 'Ende:',

   'Build a list of users for selection of group members'
=> 'Zusammenstellen einer Benutzerliste zur Auswahl von Gruppenmitgliedern',

   'Group membership selection list criteria:'
=> 'Auswahlkriterien für Gruppen-Mitgliedschaft:',

   'Pick the criteria to use to build a list of course users from which you will select '
=> 'Wählen Sie die Kriterien, die verwendet werden sollen, um die Liste der Kursbenutzer zu erstellen, anhand der Sie ',

   'members of the new group.'
=> 'die neuen Gruppenmitglieder wählen werden.',

   'If you do not wish to add members when you first create the group, there is no need to pick any criteria.'
=> 'Falls Sie beim Erstellen der Gruppe nicht sofort auch Mitglieder hinzufügen wollen, brauchen Sie hier keine Kriterien auswählen.',

   'A subsequent step will also allow you to specify automatic adding/dropping of group members triggered by specified user role and section <i>changes</i> in the course.'
=> 'Ein weiterer Teilschritt wird Ihnen ermöglichen, automatisches Hinzfügen und Entfernen von Gruppenmitgliedern anzugeben. Dies wird durch angegebene Benutzerrollen und Sektions<i>änderungen</i> im Kurs ausgelöst.',

   'Access types'
=> 'Zugriffstypen',

   'Currently has access'
=> 'Aktueller Zugriff',

   'Will have future access'
=> 'Zukünftiger Zugriff',

   'Previously had access'
=> 'In der Vergangenheit liegender Zugriff',

   'Course roles'
=> 'Benutzerrollen', # 'Benutzerrollen im Kurs',

   'Course sections'
=> 'Sektionen', # 'Sektionen im Kurs',

   'all sections'
=> 'Alle Sektionen',

   'no section'
=> 'Keine Sektion',

   'Go to next step'
=> 'Weiter',

   'Invalid group name'
=> 'Ungültiger Gruppenname',

   'The group name entered '
=> 'Der eingegebene Name ',

   'is not a valid name.'
=> 'ist kein gültiger Name.',

   'can not be used as it is the name of '
=> 'kann nicht verwendet werden, da sich um den Namen ',

   'an existing [_1]',
=> 'einer bereits bestehenden [_1] handelt',

   ' in this Course'
=> ' in diesem Kurs',

   'Group names and section names used in a Course must be unique.'
=> 'Gruppen- und Sektionsnamen müssen in einem Kurs eindeutig sein.',

   'Group names may only contain letters, numbers or underscores.'
=> 'Gruppennamen dürfen nur aus Buchstaben, Zahlen und Unterstrichen bestehen.',

   'Go to previous step'
=> 'Zurück',

   'Select Members'
=> 'Mitgliederauswahl',

   'Your group selections - '
=> 'Gruppenauswahl',

   'The following settings will apply to the group:'
=> 'Die folgenden Einstellungen werden auf Ihre Gruppe wirken:',

   'Granularity'
=> 'Granularität',

   'File quota'
=> 'Speicherplatz für Dateien',

   'Default access dates'
=> 'Voreingestellte Zugriffsdaten',

   'Different collaborative tools<br />for different members:'
=> 'Unterschiedliche kollaborative Werkzeuge<br />für unterschiedliche Mitglieder:',

   'Start date'
=> 'Anfangsdatum',

   'End date'
=> 'Endedatum',

   'End date:'
=> 'Endedatum:',

   '<b>Available for assignment to members:</b>'
=> '<b>Zugriff für Mitglieder möglich:</b>',

   '<b>Unavailable for assignment:</b>'
=> '<b>Kein Zugriff möglich:</b>',

   'User privileges for collaborative tools'
=> 'Benutzerrechte für kollaborative Werkzeuge',

   'As you have chosen not to include any collaborative tools in the group, no default optional privileges need to be set.'
=> 'Da Sie keinerlei kollaborativen Werkzeuge für die Gruppe gewählt haben, die eingebunden werden sollen, brauchen keine voreingestellten optionalen Berechtigungen eingestellt werden.',

   'Group membership'
=> 'Gruppen-Mitgliedschaft',

   'Add members'
=> 'Mitglieder hinzufügen',

   'Add Members'
=> 'Mitglieder hinzufügen',

   'Add?'
=> 'Hinzufügen?',

   'You have indicated that the file repository should be enabled, but you have set the respository quota to 0 Mb.\nThis will prevent any upload of files.\nPlease set a value or disable the repository feature.'
=> 'Sie haben angegeben, dass die Dateisammlung aktiviert werden soll, jedoch einen Speicherplatz von 0 MB angegeben.\nDies verhindert jegliches Hochladen von Dateien.\nBitte geben Sie einen Wert größer 0 ein oder deaktivieren Sie die Dateisammlung.',

   '[_1] [_2] was created.<br />'
=> '[_1] [_2] wurde angelegt.<br />',

   '[_1] membership list updated.'
=> 'Liste der [_1]-Mitgliedschaften wurde aktualisiert.',

   'Any currently logged in course users affected by the changes you made to group membership or privileges for the [_1] group will need to log out and log back in for their LON-CAPA sessions to reflect these changes.'
=> 'Sie haben Gruppen-Mitgliedschaften und/oder -berechtigungen für die Gruppe [_1] eingestellt bzw. geändert. Alle derzeit angemeldeten Benutzer, für die diese Einstellungen wirken, müssen sich aus- und wieder einloggen, damit für sie die Änderungen wirksam werden.',

   'Choose Privileges'
=> 'Auswahl der Berechtigungen',

   'Creation Complete'
=> 'Erstellung abgeschlossen',

   'Additions Complete'
=> 'Hinzufügungen abgeschlossen',

   'discussion'
=> 'Diskussion',

   'email files'
=> 'E-Mail-Dateien',

   'homepage'
=> 'Homepage',

   'roster'
=> 'Teilnehmerliste',

   'Edit Group Homepage'
=> 'Gruppen-Homepage ändern',

   'Edit Group Settings'
=> 'Gruppeneinstellungen ändern',

   'Available Group Tools'
=> 'Verfügbare Gruppenwerkzeuge',

   'Group chat'
=> 'Chat',

   'Group e-mail'
=> 'E-Mail',

   'Group page - [_1]'
=> 'Gruppenseite - [_1]',

   '[_1] discussion boards - [_2]'
=> '[_1]-Diskussionsforen - [_2]',

   'New Discussion Board'
=> 'Neues Diskussionsforum anlegen',

   'There are currently no discussion boards in this [_1].'
=> 'In dieser [_1] sind derzeit keine Diskussionsforen.',

   'Discussion Board Title'
=> 'Titel des Diskussionsforums',

   'The new discussion board was added successfully.<br />'
=> 'Das neue Diskussionsforum wurde erfolgreich angelegt.<br />',

   'Edit [_1] board'
=> 'Diskussionsforum [_1] ändern',

   'View all group discussion boards'
=> 'Alle Gruppen-Diskussionsforen anschauen',

   'Show Student View'
=> 'Studentische Sicht zeigen',

   'Note: in anonymous discussion, your name is visible only to course faculty'
=> 'Hinweis: Bei anonymer Diskussionsteilnahme ist Ihr Name nur für die Kursverwaltung sichtbar.',

   'Send a Message in a Group'
=> 'Nachricht innerhalb einer Gruppe verschicken',

   'As this group has no members, there are no recipients to select.'
=> 'Da diese Gruppe keine Mitglieder hat, können Sie keine Empfänger auswählen.',

   'Allow replies'
=> 'Antworten zulassen',

   'Reply to'
=> 'Antwort an',

   'Group Portfolio'
=> 'Gruppen-Dateisammlung',

   '[_1] portfolio files - [_2]'
=> '[_1]-Portfolio-Dateien - [_2]',

   'There are no membership data to display for this [_1]'
=> 'Für diesen [_1] existieren keine anzeigbaren Mitgliedsdaten.',

   'Group Membership'
=> 'Gruppen-Mitgliedschaften',

   '[_1] membership status - [_2]'
=> '[_1]-Mitgliedschaftsstatus - [_2]',

   'Group Email'
=> 'Gruppen-E-Mail',

   'Course Discussion Boards'
=> 'Kurs-Diskussionsforen',

   'Post Discussion'
=> 'Diskussionsbeitrag abschicken',

   'Post Anonymous Discussion'
=> 'Diskussionsbeitrag anonym abschicken',

   'Content'
=> 'Inhalt',

   'You do not currently have rights to view this group.'
=> 'Sie haben derzeit keine Berechtigung diese Gruppe zu sehen.',

   '<p>No page information provided.</p>'
=> '<p>Keine Seiteninformationen angegeben.</p>',

   'Available functions'
=> 'Verfügbare Funktionen',

   'No group functionality.'
=> 'Keine Gruppenfunktionen.',

   'No group functionality (e.g., e-mail, discussion, chat or file upload) is currently available to you in this group: <b>[_1]</b>.'
=> 'Derzeit ist in der Gruppe <b>[_1]</b> keine Gruppenfunktion (z.B. E-Mail, Diskussion, Chat oder Dateien-Hochladen) verfügbar.',

   'Group Page'
=> 'Gruppenseite',

   'Currently set to "[_1]"'
=> 'Derzeit eingestellt auf "[_1]"',

   'Quota allocated to file repository:'
=> 'Speicherplatz für Dateiensammlung',

   'The quota is currently [_1] Mb'
=> 'Der Speicherplatz ist derzeit auf [_1] MB eingestellt',

   'The quota can be increased to [_1] Mb, by adding all unallocated space for [_2]s in the [_3].'
=> 'Der Speicherplatz kann bis auf [_1] MB erhöht werden, indem der gesamte nicht zugewiesene Speicherplatz für [_2]s im [_3] hinzugefügt wird.',

   'Each collaborative tool includes core privileges assigned to all members with access to the tool. Some tools may also feature additional privileges which can be set for specific members.'
=> 'Jedes kollaborative Werkzeug bietet allen Benutzern, die Zugriff auf das Werkzeug haben, grundlegende Berechtigungen. Einige Werkzeuge bieten weitere Möglichkeiten, die für ausgewählte Gruppenmitglieder eingestellt werden können.',

   'All group members will receive the same privileges for any tool assigned to them, including the default set of optional privileges.'
=> 'Alle Gruppenmitglieder erhalten die gleichen Berechtigungen für alle Werkzeuge, die ihnen zugewiesen wurden - die voreingestellten optionalen Berechtigungen eingeschlossen.',

   'Different group members may receive different privileges from others for the tools they have been assigned.'
=> 'Unterschiedliche Gruppenmitglieder können unterschiedliche Berechtigungen für Werkzeuge von anderen erhalten, die diese zugewiesen bekommen haben.',

   'Indicate which <b>optional</b> privileges members will receive by default for a specific tool.'
=> 'Angabe, welche <i>optionalen</i> Berechtigungen für ein bestimmtes Werkzeug voreingestellt zugewiesen werden sollen.',

   'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the course '
=> 'Es handelt sich um die Berechtigungen, die Gruppenmitglieder durch das automatische Belegen von Gruppen zukünftig erhalten. Dies betrifft Benutzer, die bestimmte Sektionen/Rollen im Kurs erhalten ',

   'if enabled below'
=> 'falls im Folgenden aktiviert',

   'Additional privileges'
=> 'Zusätzliche Berechtigungen',

   'Fixed privileges'
=> 'Festgesetzte Berechtigungen',

   'Optional privileges'
=> 'Optionale Berechtigungen',

   'Collaborative Tool'
=> 'Kollaboratives Werkzeug',

   'Currently the group is configured '
=> 'Derzeit ist die Gruppe so konfiguriert, dass ',

   'so different members can receive different optional privileges for a particular tool.'
=> 'unterschiedliche Gruppenmitglieder unterschiedliche optionale Berechtigungen für jedes einzelne Werkzeug erhalten können.',

   'so all members will receive the same optional privileges for a particular tool.'
=> 'alle Gruppenmitglieder die gleichen optionalen Berechtigungen für jedes einzelne Werkzeug erhalten.',

   'Enable/disable automatic group enrollment for users in specified roles and sections'
=> 'Aktivierung/Deaktivierung der automatischen Belegung von Gruppen für Benutzer mit bestimmten Rollen und in bestimmten Sektionen',

   'Group membership mapping to specific sections/roles'
=> 'Verweis von Gruppen-Mitgliedschaften auf bestimmte Sektionen/Rollen',

   'If automatic group enrollment is enabled, when a user is newly assigned a course-wide or section-specific role, he/she will automatically be added as a member of the group, with start and end access dates defined by the default dates set for the group, unless he/she is already a group member, with access dates that permit either current or future group access.'
=> 'Falls die automatische Gruppenbelegung aktiviert ist: Wenn ein Benutzer eine kursweite oder sektionsspezifische Rolle neu zugewiesen bekommen hat, wird er automatisch als Mitglied der Gruppe hinzugefügt. Das Anfangs- und Endedatum für den Zugriff wird durch die Datumswerte vorgegeben, die für die Gruppe voreingestellt sind. Das allerdings nur, wenn der Benutzer nicht bereits Gruppenmitglied mit Zugriffsdaten ist, die aktuellen oder zukünftigen Gruppenzugriff verbieten.',

   "If automatic group disenrollment is enabled, when a user's role is expired, access to the group will be terminated unless the user continues to have other course-wide or section-specific active or future roles which receive automatic membership in the group."
=> "Falls das automatische Ausschließen aus Gruppen aktiviert ist: Wenn eine Benutzerrolle ausläuft, wird der Zugriff auf die Gruppe entzogen, sofern der Benutzer nicht andere kursweite oder sektionsspezifische aktive oder zukünftige Rollen hat, die automatischen Gruppenzugriff ermöglichen.",

   'Automatically enable group membership when roles are added?'
=> 'Automatisches Belegen von Gruppen, wenn Rollen hinzugefügt werden?',

   'Automatically expire group membership when roles are removed?'
=> 'Automatisches Ausschließen aus Gruppen, wenn Rollen entfernt werden?',

   'Currently set to'
=> 'Derzeit eingestellt auf',

   'Mapping of roles and sections affected by automatic group enrollment/disenrollment follows scheme chosen below.'
=> 'Das Verweisen von Rollen und Sektionen durch das automatische Belegen von/Ausschließen aus Gruppen folgt dem folgenden Schema.',

   'Pick roles and sections for automatic group enrollment'
=> 'Auswahl von Rollen und Sektionen für das automatische Belegen von Gruppen',

   'Active?'
=> 'Aktiv?',

   'Send group mail'
=> 'Gruppen-E-Mail senden', # .n.t.

   'Create boards'
=> 'Erstellen von Foren', # n.t.

   'Edit own posts'
=> 'Eigene Beiträge bearbeiten', # .n.t.

   'Hide/Delete any post'
=> 'Anzeigen/Löschen beliebiger Beiträge', # .n.t.

   'View boards'
=> 'Foren anschauen', # .n.t.

   'Control Access'
=> 'Zugriffskontrolle', # .n.t.

   'Basic Display'
=> 'Einfache Anzeige', # .n.t.

   'Detailed Display'
=> 'Detailierte Anzeige', # .n.t.

   'View page'
=> 'Seite betrachten', # .n.t.

   'Modify page'
=> 'Seite ändern', # .n.t.

   'Foils without names exist. This can cause problems to malfunction.'
=> 'Es existieren Auswahlmöglichkeiten ohne Namen. Das könnte eine fehlerhafte Funktionalität verursachen.',

   'Unknown area style [_1]'
=> 'Unbekannter Bereichstyp: [_1]',

   "The message itself will begin with a first line: <i>'Forwarded message from'</i> followed by the original sender's name."
=> "Die Nachricht wird in der ersten Zeile mit <i>Weitergeleitete Nachricht von'</i> starten, gefolgt vom Originalnamen des Absenders.",

   'Forwarded message from '
=> 'Weitergeleitete Nachricht von ',

   'You received a critical message from [_1] in LON-CAPA.'
=> 'Sie haben eine wichtige Nachricht von [_1] in LON-CAPA erhalten.',

   'You received a message from [_1] in LON-CAPA.'
=> 'Sie haben eine Nachricht von [_1] in LON-CAPA erhalten.',

   "'New'  critical message from "
=> "Neue wichtige Nachricht von ",

   "'New'  message from "
=> "Neue Nachricht von ",

   'Refers to'
=> 'Bezieht sich auf',

   'Previous attempts of student (if applicable)'
=> 'Bisherige Versuche des Studenten (falls verfügbar)',

   'Original screen output (if applicable)'
=> 'Original-Bildschirmausgabe (falls verfügbar)',

   'Correct Answer(s) (if applicable)'
=> 'Korrekte Antwort(en) (falls verfügbar)',

   'LON-CAPA messages sent to you between [_1] and [_2] will be inaccessible until the end of this time period, because you are a student in a course with an active communications block.'
=> 'Sie haben auf Ihnen zugesandte LON-CAPA-Nachrichten zwischen [_1] und [_2] bis zum Ende dieses Zeitbereichs keinen Zugriff, da Sie Student in einem Kurs mit aktiver Kommunikationssperre sind.',

   'The subject is 

 [_1]

'
=> 'Der Betreff lautet 

 [_1]

',

   'Excerpt'
=> 'Auszug',

   'Use 

 [_1]

to access the full message.'
=> 'Ueber 

 [_1]

erhalten Sie auf die gesamte Nachricht Zugriff.',

   'You can reply to this message'
=> 'Sie koennen auf diese E-Mail antworten.',

   'Please do not reply to this address.'
=> 'Bitte antworten Sie nicht an die Absender-E-Mail-Adresse.',

   'A reply will not be received by the recipient!'
=> 'Eine Antwort wuerde nicht beim vorgesehenen Empfaenger ankommen!',

   "Include in course's 'User records' for recipient(s)"
=> "In Kurs-Benutzeraufzeichnungen des Empfängers einbinden",

   'No replies to sender'
=> 'Keine Antwort an Absender möglich',

   'View recent activity'
=> 'Zuletzt stattgefundene Aktivitäten',

   'Display Message'
=> 'Nachricht anzeigen',

   'Replying to a Message'
=> 'Nachricht beantworten',

   'Forwarding a Message'
=> 'Nachricht weiterleiten',

   'Forwarding Multiple Messages'
=> 'Mehrere Nachrichten weiterleiten',

   'At end of file some tags were still left unclosed, '
=> 'Am Ende der Datei sind noch nicht geschlossene Tags übrig: ',

   'Upload and Send'
=> 'Hochladen und Absenden',

   'Select courses'
=> 'Kursauswahl',

   '<b>Choose which course(s) to list.</b><br />'
=> '<b>Auswahl der Kurse, die angezeigt werden sollen</b><br />',

   'Display courses'
=> 'Kurse anzeigen',

   'Public'
=> 'Öffentlich',

   ' Answer [_1]'
=> ' Antwort [_1]',

   'EditXML [_1]'
=> 'XML-Editor [_1]',

   'Not authorized'
=> 'Nicht berechtigt',

   'An error occured while processing this resource. The author has been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Der Autor wurde informiert.',

   'Code ran too long. It ran for more than'
=> 'Die Ausführung hat zu lange gedauert. Sie dauerte länger als',

   'seconds occured while running &lt;while&gt; on line'
=> 'Sekunden, während &lt;while&gt; ausgeführt wurde in Zeile',

   'Student View'
=> 'Studentische Sicht',

   'Correct answer'
=> 'Korrekte Antwort',

   'Could not identify problem.'
=> 'Aufgabe konnte nicht identifiziert werden', # ???

   'Your Excel spreadsheet'
=> 'Ihre Excel-Tabelle',

   'Your CSV file'
=> 'Ihre CSV-Datei',

   'Chart'
=> 'Chart',

   'Student Data</b>'
=> 'Studentische Daten</b>', # !

   'HTML, with links'
=> 'HTML, mit Links',

   'HTML, with all links'
=> 'HTML, mit allen Links',

   'HTML, without links'
=> 'HTML, ohne Links',

   'Output Data'
=> 'Ausgabedaten',

   'Scores Summary'
=> 'Punktesumme',

   'Scores Per Problem'
=> 'Punkte je Aufgabe',

   'Parts Correct'
=> 'Richtige Teile',

   'fullname'
=> 'Vollständiger Name',

   'id'
=> 'ID/Matr.-Nr',

   'Generate Chart'
=> 'Chart generieren',

   'Select One Student'
=> 'Einzelnen Studenten wählen',

   'All sections'
=> 'Alle Sektionen',

   'All groups'
=> 'Alle Gruppen',

   ' [_1] access status.'
=> ' [_1] Zugriffsstatus.',

   'Show links in new window:'
=> 'Links in neuem Fenster öffnen:', # n.t.

   'Summary Tables'
=> 'Zusammenfassende Tabellen',

   'Average'
=> 'Durchschnitt',

   'Maximum'
=> 'Maximum',

   'Click here to return to the chart'
=> 'Zurück zum Chart',

   'Click on a students name or username to view their chart'
=> 'Klick ', # n.t.

   'status'
=> 'Status',

   'groups'
=> 'Gruppen',

   'Click on a students name or username to view their chart'
=> 'Klick auf Name/Benutzername zeigt zugehöriges Chart',

   'Essay will be hand graded.'
=> 'Essay wird manuell bewertet.',

   'Text you want to appear by default:'
=> 'Text, der voreingestellt angezeigt werden soll:',


   'Check as many as you wish in response to the problem.'
=> 'Wählen Sie alle Dateien aus, die als Antwort eingereicht werden sollen:',

   'Select portfolio files'
=> 'Auswahl Portfolio-Dateien',

   'Select checked files, and continue selecting.'
=> 'Auswahl übernehmen und weiter auswählen',

   'Select checked files, and close window'
=> 'Auswahl übernehmen und Fenster schließen',

   'Copy of'
=> 'Kopie von',

   'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.'
=> 'Die von Ihnen eingegebene E-Mail-Adresse stimmt nicht mit der im LON-CAPA-System hinterlegten Adresse des angegebenen Benutzers überein.',

   'Overall result: [_1]'
=> 'Gesamtergebnis: [_1]',

   'Dimension: [_1], status [_2] '
=> 'Dimension: [_1], Status [_2] ',

   'Queue Status'
=> 'Warteschlangen-Status',

   'Check Mark'
=> 'Markierung auswählen',

   'Return commented version of [_1] to student.'
=> 'Rückgabe kommentierter Version von [_1] an Studenten.',

   'Download All Submitted Documents'
=> 'Alle eingereichten Dokumente herunterladen',

   'Essay is [_1]% similar to an essay by [_2] ([_3]:[_4]) in course [_5] (course id [_6]:[_7])'
=> 'Das Essay stimmt zu [_1]% mit dem Essay von [_2] ([_3]:[_4]) im Kurs [_5] (Kurs-ID [_6]:[_7]) überein',

   'Compose message to student'
=> 'Nachricht an Studenten erstellen',

   'incl. grades'
=> 'Bewertung einbinden',

   'Message will be sent when you click on Save & Next below.'
=> 'NAchricht wird gesendet sobald Sie auf Speichern und weiter klicken.',

   'Set/Change parameters'
=> 'Parameter setzen/ändern',

   'Grading Feedback'
=> 'Bewertungs-Feedback',

   'Sending message to [_1]:[_2]'
=> 'Sende Nachricht an [_1]:[_2]',

   'Not allowed to modify grades for [_1]'
=> 'Keine Berechtigung zur Änderung der Bewertungen für [_1].',

   'You need to specify the username or ID'
=> 'Sie müssen einen Benutzernamen oder eine ID/Matrikelnummer angeben',

   'You need to specify at least one grading field'
=> 'Sie müssen mindestens ein Bewertungsfeld ausfüllen',

   'Specify a file containing the class scores for current resource'
=> 'Angabe einer Datei, die Kursbewertungen für diese Ressource enthält',

   'Upload Scores'
=> 'Bewertungen hochladen',

   'Some point values were assigned for problems with a weight of zero. These values were ignored.'
=> 'In einigen Aufgaben wurden Punkte vergeben, in denen die Gewichtung Null ist. Daher wurden diese Werte ignoriert.',

   'Use CODE:'
=> 'verwende CODE:',

   'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.'
=> 'Einige Ressourcen in der Sequenz sind derzeit nicht auf Examen-Modus gestellt. Eine Bewertung dieser Ressourcen könnte derzeit nicht korrekt funktionieren.',

   'scores from file' # Upload scores from file
=> 'von Bewertungen aus Datei',

   'Process'
=> 'Verarbeite',

   'clicker file' # Process clicker file
=> 'Clicker-Datei',

   'Grade'
=> 'Bewerte',

   'scantron forms' # Grade scantron forms
=> 'Scantron-Formulare',

   'Verify'
=> 'Überprüfen',

   'receipt'
=> 'Nachweis-Nr.',

   'Manage'
=> 'Verwalten',

   'access times' # Manage access times
=> 'der Zugriffszeiten', # n.t.

   'saved CODEs' # View saved CODEs
=> 'gespeicherte CODEs', # n.t.

   'Specify a file containing the clicker information for this resource'
=> 'Angabe einer Datei, die Clicker-Informationen für diese Ressource enthält',

   'Upload File'
=> 'Datei hochladen',

   'Award points just for participation'
=> 'Erreichte Punkte, lediglich für Teilnahme',

   'Correctness determined from response by course personnel'
=> 'Korrektheit, bestimmt durch Antwort durch Kurspersonal',

   'Correctness determined from response with clicker ID(s)'
=> 'Korrektheit, bestimmt durch Antwort mit Clicker-ID(s)',

   'Percentage points for correct solution'
=> 'Prozentuale Punkte für korrekte Lösung',

   'Percentage points for incorrect solution'
=> 'Przentuale Punkte für inkorrekte Lösung',

   'You need to specify a clicker ID for the correct answer'
=> 'Sie müssen für die korrekte Antwort eine Clicker-ID angeben',

   'Score based on attendance only'
=> 'Punkte, die lediglich auf Anwesenheit beruhen',

   'Correctness determined by the following IDs'
=> 'Korrektheit, bestimmt durch folgende IDs',

   'specified'
=> 'angegeben',

   'No IDs found to determine correct answer'
=> 'Keine IDs gefunden, um korrekte Antwort bestimmen zu können',

   '[_1] Error: [_2] The file you attempted to upload, [_3] contained no information. Please check that you entered the correct filename.'
=> '[_1] Fehler: [_2] Die Datei, die Sie versucht haben hochzuladen, [_3] enthält keine Informationen. Bitte überprüfen Sie, ob Sie den richtigen Dateinamen angegeben haben.',

   'Scanning clicker file'
=> 'Scanne Clicker-Datei',

   'Found [_1] question(s)'
=> '[_1] Frage(n) gefunden',

   'Awarding [_1] percent for correct and [_2] percent for incorrect responses'
=> '[_1] Prozent für korrekte und [_2] Prozent für inkorrekte Antworten erhalten',

   'Clicker registered more than once'
=> 'Clicker ist mehr als einmal registriert',

   'Unregistered Clicker'
=> 'Nicht registrierter Clicker',

   'Found [_1] registered and [_2] unregistered clickers.'
=> '[_1] registrierte und [_2] nicht registrierte Clicker gefunden.',

   'Found no correct answers answers for grading!'
=> 'Keine korrekten Antworten zur Bewertung gefunden!',

   'Found [_1] entries for grading!'
=> '[_1] Einträge zur Bewertung gefunden!',

   'Found no questions.'
=> 'Keine Fragen gefunden.',

   'Finalize Grading'
=> 'Bewertung abschließen',

   'Question [_1]'
=> 'Frage [_1]',

   'Assigning grades based on clicker file'
=> 'Weise Bewertungen zu, die auf der Clicker-Datei basieren',

   'More than one correct result given for question "[_1]": [_2] versus [_3].'
=> 'Mehr als eine korrektes Ergebnis gegeben für Frage "[_1]": [_2] gegen [_3].',

   'No correct result given for question "[_1]"!'
=> 'Kein korrektes Ergebnis für Frage "[_1]" gegeben!',

   'Correct answer: [_1]'
=> 'Korrekte Antwort: [_1]',

   'Successfully stored grades for [_1] student(s).'
=> 'Erfolgreiche Speicherung der Bewertungen für [_1] Studenten.',

   'Grading Menu'
=> 'Bewertungsmenü',

   'Missing tags, unable to properly run file.'
=> 'Fehlende Tags. Die Datei kann nicht ordnungsgemäß ausgeführt werden.',

   'Using tag [_1] on line [_2] as end tag to [_3]'
=> 'Using tag [_1] on line [_2] as end tag to [_3]', # ??? lonxml.pm [SB 2008-08-07]

   'Found tag [_1] on line [_2] when looking for [_3] in file.'
=> 'In der Datei wurde in Zeile [_2] das Tag [_1] gefunden, wo [_3] erwartet wurde.',

   'ID &quot;[_1]&quot; contains invalid characters, IDs are only allowed to contain letters, numbers, spaces and -'
=> 'ID &quot;[_1]&quot; enthält ungültige Zeichen. Gültige Zeichen für IDs sind nur Buchstaben, Ziffern, Zahlen, Leerzeichen und -',

   'File not found'
=> 'Datei nicht gefunden',

   'This file appears to be a rendering of a LON-CAPA resource. If this is correct, this resource will act very oddly and incorrectly.'
=> 'Diese Datei scheint eine Umwandlung einer LON-CAPA-Ressource zu sein. Falls dies zutrifft, wird sich diese Ressource sehr unpassend und inkorrekt verhalten.', # ??? [SB 2007-11-27]

   'An error occured while processing this resource. The instructor has been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Der Dozent wurde informiert.',

   'CourseID'
=> 'Kurs-ID',

   'DocID'
=> 'Dokumenten-ID',

   'Username, password and domain need to be specified.'
=> 'Benutzername, Passwort und Domäne müssen angegeben werden!',

   'Untitled Resource'
=> 'Unbenannte Ressource',

   'Not Available'
=> 'Nicht verfügbar',

   'Clear'
=> 'Leeren',

   'There are no parameters.'
=> 'Derzeit existieren keine Parametereinstellungen.',

   'enroll type/action'
=> 'Belegungstyp/Aktion',

   '<br />Map not loaded: The file <tt>[_1]</tt> does not exist.'
=> '<br />Inhaltszusammenstellung nicht geladen: Die Datei <tt>[_1]</tt> existiert nicht.',

   'Saved.'
=> 'Gespeichert.',

   'An error occured while saving.'
=> 'Beim Speichern ist ein Fehler aufgetreten.',

   'Reverted.'
=> 'Reverted.', # ??? 2007-12-06

   'Title in map'
=> 'Titel in Inhaltszusammenstellung',

   'Filename of resource'
=> 'Dateiname der Ressource',

   'Link to published resource'
=> 'Link auf veröffentlichte Ressource',

   'Link to resource in Construction Space'
=> 'Link auf Ressource im Konstruktionsbereich',

   'Resource space'
=> 'Ressourcenbereich',

   'Construction space'
=> 'Konstruktionsbereich',

   'discard'
=> 'verwerfen',

   'Change Order'
=> 'Reihenfolge ändern',

   'Sort Imported Resources'
=> 'Importierte Ressourcen sortieren',

   'Finalize order of resources'
=> 'Reihenfolge der Ressourcen',

   'Recover Deleted'
=> 'Gelöschtes wiederherstellen',

   'Recover Removed Resources'
=> 'Gelöschte Ressourcen wiederherstellen',

   'Recover Checked'
=> 'Ausgewählte wiederherstellen',

   'Recent Detailed Assessment Statistical Data'
=> 'Aktuelle detailierte statistische Beurteilungsdaten',

   'No information available'
=> 'Keine Information verfügbar',

   'Creating new file [_1]'
=> 'Erzeuge neue Datei [_1]',

   'If you would like to associate this resource ([_1]) with a current or previous course, please select one from the list below, otherwise select, \'None\''
=> 'Falls Sie diese Ressource ([_1]) mit einem aktuellen oder alten Kurs verknüpfen wollen, wählen Sie bitten einen Kurs aus der unten angebotenen Liste. Ansonsten wählen Sie \'nichts\'.',

   'Associate Resource With Selected Course'
=> 'Verknüpfte Ressource mit ausgewähltem Kurs',

   'This resource is currently associated with a course ([_1]) which includes added metadata fields specific to the course.'
=> 'Diese Ressource ist derzeit mit einem Kurs ([_1]) verknüpft, der zusätzliche kursspezifische Metadaten-Felder enthält.',

   'You can choose to transfer data from the added fields to the "Notes" field if you are planning to change the course association.'
=> 'Sie können die Daten der zusätzlichen Felder in das "Bemerkungen"-Feld transferieren lassen, falls Sie vorhaben, die Kursverknüpfung zu ändern.',

   'not available'
=> 'nicht verfügbar',

   'most recent version'
=> 'neueste Version',

   'information not available'
=> 'Information nicht verfügbar',

   'Num Student'
=> 'Anz. Studenten',

   'Degree of Difficulty'
=> 'Schwierigkeitsgrad',

   'Degree of Discrimination'
=> 'Grad der Abgrenzung',

   'Time of computation'
=> 'Zeit der Erstellung',

   'Messages deleted.'
=> 'Nachrichten gelöscht.',

   'Error deleting messages'
=> 'Fehler beim Löschen der Nachrichten',

   'Messages cleared.'
=> 'Nachrichten entfernt.',

   'Error clearing messages'
=> 'Fehler beim Entfernen der Nachrichten',

   'Delete Messages for this Resource'
=> 'Nachrichten für diese Ressource löschen',

   'Back To Directory'
=> 'Zurück zum Verzeichnis',

   'Associated with course [_1]'
=> 'Verknüpft mit Kurs [_1]',

   'This resource is not associated with a course.'
=> 'Diese Ressource ist mit keinem Kurs verknüpft.',

   'Discard Edits and Return to Portfolio'
=> 'Änderungen verwerfen und zurück zum Portfolio-Bereich',

   'Could not transfer data in added fields to notes'
=> 'Die Daten der zusätzlichen Felder konnten nicht in das "Bemerkungen"-Feld transferiert werden',

   'Transferred data in added fields to notes'
=> 'Die Daten der zusätzlichen Felder wurden in das "Bemerkungen"-Feld transferiert',

   'Home'
=> 'Heimatverzeichnis',

   'Usage Statistics'
=> 'Nutzungsstatistiken',

   'Courses/Network Hits'
=> 'Kursweite/Netzwerkweite Anzahl an Zugriffen ("Hits")',

   'Already in this course:<br />[_1] in folder/map [_2].<br />'
=> 'Bereits in diesem Kurs:<br />[_1] im Verzeichnis/Inhaltszusammenstellung [_2].<br />',

   'External Resource, preview not enabled'
=> 'Externe Ressource, Vorschau nicht aktiviert',

   'Somewhere something went wrong'
=> 'Irgendwo ist irgendwas schief gelaufen',

   'Please help us to find out what.'
=> 'Bitte helfen Sie uns herauszufinden, was passiert ist!',

   'Please take a moment to fill out the form below.'
=> 'Bitte nehmen Sie sich einen Moment Zeit, um das folgende Formular auszufüllen.',

   'Your information, together with internal debugging information, will be emailed to the system and server administrators.'
=> 'Ihre Informationen, zusammen mit internen Debugging-Daten, werden an die System- und Server-Administratoren per E-Mail weitergeleitet.',

   'Send Information'
=> 'Fehlerbericht abschicken',

   'Please describe what you did just before this screen came up'
=> 'Bitte beschreiben Sie, was Sie unmittelbar bevor dieser Bildschirm erschien getan haben.',

   'Is this problem reproducible?'
=> 'Ist das Problem reproduzierbar?',

   'Yes!'
=> 'Ja!',

   'Do you have any guesses why this might have happened?'
=> 'Haben Sie eine Vermutung, warum das passiert sein könnte?',

   'Thank you for your help!'
=> 'Vielen Dank für Ihre Unterstützung!',

   'Internal info:'
=> 'Interne Daten:',

   'Report submitted'
=> 'Bericht gesendet',

   'Sending Error Report'
=> 'Fehlerbericht senden',

   'Thank you!'
=> 'Danke!',

   'Warning: Report not submitted'
=> 'Achtung, der Fehlerbericht wurde nicht abgeschickt.',

   'The administrators of the domain [_1] have not set any e-mail addresses for receipt of your error report.'
=> 'Die Administratoren der Domäne [_1] haben keine E-Mail-Adresse hinterlegt, an die Ihr Fehlerbericht gesendet werden könnte.',

   'The document contains errors and cannot be published.'
=> 'Die Ressource enthält Fehler und kann daher nicht veröffentlicht werden.',

   'error(s)'
=> 'Fehler',

   'Please fill out all fields below'
=> 'Bitte füllen Sie alle Felder aus!',

   'Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.'
=> 'Achtung, dieses Verzeichnis ist so eingestellt, dass zufällig eine Teilmenge der Ressourcen gewählt wird. Hinzufügen oder Entfernen von Ressourcen zu/aus diesem Verzeichnis wird die Auswahl ändern, die die Studenten sehen. Dies kann falsche oder fehlende Bewertungen für abgeschlossene Aufgaben zur Folge haben, was nicht beschränkt auf die Ressourcen ist, die Sie ändern. Ändern Sie daher die Inhalte dieses Verzeichnisses nicht, wenn es in aktueller studentischer Verwendung ist.',

   'Parameters'
=> 'Parameter',


   'Total Score and Maximum Possible for each Sequence or Folder'
=> 'Gesamtpunkte und maximal mögliche für jede Sequenz oder jedes Verzeichnis',

   'Score on each Problem Part'
=> 'Punkte je Aufgabenteil',

   'Number of Tries before success on each Problem Part'
=> 'Anzahl notwendiger Versuche je Aufgabenteil',

   'Number of Problem Parts completed successfully.'
=> 'Anzahl erfolgreich bearbeiteter Aufgabenteile',

   'Unable to retrieve course information.'
=> 'Kursdaten konnten nicht abgerufen werden.',

   'Please select an action to perform using the new filename'
=> 'Bitte wählen Sie zuerst eine Aktion aus, was mit der neuen Datei geschehen soll!',

   'View or modify a course'
=> 'Kurseinstellungen', # long version: 'Kurseinstellungen betrachten oder ändern',

   'Enter the course with the role of [_1]'
=> 'Den Kurs mit der Rolle [_1] betreten.',

   'Enter the course with the role of [_1].'
=> 'Den Kurs mit der Rolle [_1] betreten.',

   'View or modify course settings which only a [_1] may modify.'
=> 'Betrachten oder Ändern der Kurseinstellungen, die nur ein [_1] ändern darf.',

   'Manage course users'
=> 'Kursteilnehmer verwalten',

   'Upload a File of Course Users'
=> 'Datei mit Kursteilnehmern hochladen',

   'Add/Modify a Single Course User'
=> 'Einzelnen Teilnehmer hinzufügen/ändern',

   'Display Class Lists and Manage Multiple Users'
=> 'Kursteilnehmerliste / Verwaltung mehrerer Teilnehmer',

   'Edit Custom Roles'
=> 'Benutzerdefinierte Benutzerrollen',

   'Enroll a Single Student'
=> 'Einzelnen Studenten Kurs belegen lassen',

   'Automated Enrollment Manager'
=> 'Verwaltung der automatischen Kursbelegung',

   'Manage Course Groups'
=> 'Kursgruppen',

   'This error occurred while processing response [_1] in part [_2]'
=> 'Dieser Fehler trat während der Verarbeitung von Antwortbereich [_1] in Aufgabenteil [_2] auf.',

   'This error occurred while processing part [_1]'
=> 'Dieser Fehler trat während der Verarbeitung von Aufgabenteil [_1] auf.',

   'Unable to find section for this student'
=> 'Konnte für diesen Studenten keine Sektion finden.',

   'Classlist update for "[_1]" in "[_2]".'
=> 'Kursteilnehmerlisten-Aktualisierung für "[_1]" in "[_2]".',

   'Error: "[_1]" during classlist update for "[_2]" in "[_3]".'
=> 'Fehler: "[_1]" während Kursteilnehmerlisten-Aktualisierung für "[_2]" in "[_3]".',

   'Role: '
=> 'Rolle: ',

   'Identify fields in uploaded list'
=> 'Angabe der Felder in der hochgeladenen Liste',

   'Enter as many fields as you can.<br /> The system will inform you and bring you back to this page, <br /> if the data selected are insufficient to add users.'
=> 'Füllen Sie so viele Felder wie möglich aus.<br /> Das System wird Sie informieren und zu dieser Seite zurückbringen,<br /> falls die Daten nicht ausreichen, Benutzer in Ihren Kurs einzuschreiben.',

   'Default domain'
=> 'Voreingestellte Domäne',

   'Change authentication for existing users to these settings?'
=> 'In diesen Einstellungen die Authentifizierung für existierende Benutzer ändern?',

   'LON-CAPA Home Server for New Users'
=> 'LON-CAPA-Heimatserver für neue Benutzer',

   'LON-CAPA domain: [_1] with home server: [_2]'
=> 'LON-CAPA-Domäne: [_1] mit Heimatserver: [_2]',

   'Settings for assigning roles:'
=> 'Einstellungen für Rollenzuweisungen:', # ???

   'Pick the action to take on roles for these users:'
=> 'Wählen Sie die Aktion aus, dei bei neuen Rollen für diesen Benutzer ausgeführt werden soll:',

   'No role changes'
=> 'Keine Rollenänderungen',

   'Add a domain role'
=> 'Eine Domänenrolle hinzufügen',

   'Add a course role'
=> 'Eine Kursrolle hinzufügen',

   'Default role'
=> 'Voreingesstellte Rolle',

   'Choose the role to assign to users without a value specified in the uploaded file'
=> 'Wählen Sie die Rolle, die Benutzern zugewiesen werden sollen, für die kein Wert in der hochgeladenen Datei angegeben wurde',

   'Default role and section'
=> 'Voreingestellte Rolle und Sektion',

   'Choose the role and/or section(s) to assign to users without values specified in the uploaded file'
=> 'Wählen Sie die Rolle und/oder Sektion(en), die Benutzern zugewiesen werden sollen, für die keine Werte in der hochgeladenen Datei angegeben wurden',

   'Default role and/or section(s)'
=> 'Voreingestellte Rolle und/oder Sektion(en)',

   'Role and/or section(s) for users without values specified in the uploaded file.'
=> 'Rolle und/oder Sektion(en) für Benutzer, für die keine Werte in der hochgeladenen Datei angegeben wurde',

   'Display students with current/future access who are not in the uploaded file.'
=> 'Anzeige von Studenten mit aktuellem/zukünftigem Zugriff, die nicht in der hochgeladenen Datei sind.',

   'Students selected from this list can be dropped.'
=> 'Studenten, die von dieser Liste gewählt wurden, können aus dem Kurs ausgeschlossen werden.',

   'Update Student/Employee ID in courses in which user is active/future student,[_1](if forcing change).'
=> 'Aktualisierung der ID/Matrikelnummer in Kursen, in denen der Benutzer aktueller/zukünftiger Student ist<br />(falls Änderung erzwungen wird). ',

   'make these dates the default access dates for future student enrollment'
=> 'Diese Datumswerte als voreingestellte Zugriffszeiten für zukünftige studentische Kursbelegungen verwenden',

   'Set default start and end access dates for course.'
=> 'Setze voreingestellte Anfangs- und Endezeitpunkte für Kurs',

   'Unable to set default access dates for course.'
=> 'Konnte nicht die voreingestellten Zugriffszeitpunkte für den Kurs setzen!',

   'Please select'
=> 'Bitte wählen',

   'User Status: [_1]'
=> 'Benutzerstatus: [_1]',

   'Role Type: [_1]'
=> 'Art der Rolle: [_1]',

   'Any role'
=> 'Beliebige Rolle',

   'Role: [_1]'
=> 'Rolle: [_1]',

   'Select Course(s)'
=> 'Kurs(e) auswählen',

   'Warning: data retrieval for multiple courses can take considerable time, as this operation is not currently optimized.'
=> 'Achtung: Das Abrufen von Daten für mehrere Kurse kann einige Zeit in Anspruch nehmen, da diese Aktion derzeit noch nicht optimiert ist.',

   'There are no co-authors to display.'
=> 'Es gibt keine Co-Autoren, die angezeigt werden können.',

   'There are no users with domain roles to display.'
=> 'Es gibt keine Benutzer mit Domänenrollen, die angezeigt werden können.',

   'There are no authors or co-authors to display.'
=> 'Es gibt keine Autoren oder Co-Autoren, die angezeigt werden können.',

   'There are no course users to display'
=> 'Es gibt keine Kursteilnehmer, die angezeigt werden können.',

   'There are no course users to display.'
=> 'Es gibt keine Kursteilnehmer, die angezeigt werden können.',

   'There are no users matching the search criteria.'
=> 'Es gibt keine Benutzer, auf die die Suchkriterien zutreffen.',

   "You must select at least one user by checking a user's 'Select' checkbox"
=> "Sie müssen mindestens einen Benutzer auswählen, indem Sie die Checkboxen in der Spalte 'Auswählen' anklicken.",

   'You need to select an action to take for the user(s) you have selected'
=> 'Sie müssen eine Aktion auswählen, die für die ausgewählten Benutzer ausgeführt soll.',

   ' for a single user?'
=> '? (betrifft einen einzelnen Benutzer)',

   ' for multiple users?'
=> '? (betrifft mehrere Benutzer)',

   'Proceed'
=> 'Weiter',

   'Action to take for selected users'
=> 'Aktion für ausgewählte Benutzer',

   'Behavior of clickable username link for each user'
=> 'Verhalten der Benutzernamen-Links', # long version: 'Verhalten der anklickbaren Benutzernamen-Links eines jeden Benutzers',

   "Display a user's personal page"
=> "Über-mich-Seite anzeigen",

   "Modify a user's information"
=> "Benutzerdaten ändern",

   'Course(s): description, section(s), status'
=> 'Kurs(e): Beschreibung, Sektion(en), Status',

   "Click on a username to view the user's personal page."
=> "Klicken Sie auf einen Benutzernamen, um dessen persönliche 'Über-mich-Seite' anzuschauen.",

   'auto'
=> 'automatisch',

   'manual'
=> 'manuell',

   'Unlock'
=> 'Entsperren',

   'Lock'
=> 'Sperren',

   'Domain Roles'
=> 'Domänen-Rollen',

   'Co-Author Roles'
=> 'Co-Autoren-Rollen',

   'Course Roles'
=> 'Kurs-Rollen',

   'Date and Section selector'
=> 'Datums- und Sektions-Selektor',

   'Date selector'
=> 'Datums-Selektor',

   "Check the boxes for any users for whom roles are to be revoked, and click 'Proceed'"
=> "Wählen Sie all die Benutzer, für die Rollen entzogen werden sollen und klicken Sie dann auf 'Weiter'",

   "Check the boxes for any users for whom roles are to be deleted, and click 'Proceed'"
=> "Wählen Sie all die Benutzer, für die Rollen gelöscht werden sollen und klicken Sie dann auf 'Weiter'",

   'Choose an action to take for selected users'
=> 'Wählen Sie eine Aktion, die mit den ausgewählten Benutzern ausgeführt werden soll',

   'New section to assign'
=> 'Neue Sektion, die zugewiesen werden soll',

   'Use "Save" to update the main window with your selections.'
=> "Verwenden Sie 'Speichern', um im Hauptfenster Ihre Auswahl zu aktualisieren.",

   'New section'
=> 'Neue Sektion',

   'Course - '
=> 'Kurs - ',

   'Users in course with expired [_1] roles'
=> 'Benutzer im Kurs mit abgelaufener Rolle "[_1]"',

   'Users in course with future [_1] roles'
=> 'Benutzer im Kurs mit zukünftiger Rolle "[_1]"',

   'Users in course with active [_1] roles'
=> 'Benutzer im Kurs mit aktiver Rolle "[_1]"',

   'All users in course'
=> 'Alle Benutzer im Kurs',

   'All users in course with [_1] roles'
=> 'Alle Benutzer im Kurs mit Rolle "[_1]"',

   'only users in section "[_1]"'
=> 'nur Benutzer in Sektion "[_1]"',

   'only users affiliated with no section or section "[_1]"'
=> 'nur Benutzer, die in keiner Sektion oder in der Sektion "[_1]" sind',

   ' and not in any group'
=> ' und in keiner Gruppe',

   ' and members of group: "[_1]"'
=> ' und Mitglieder der Gruppe "[_1]"',

   'only users affiliated with no section'
=> 'nur Benutzer, die in keiner Sektion sind',

   'only users affiliated with section "[_1]"'
=> 'nur Benutzer, die in der Sektion "[_1]" sind',

   'only users not in any group'
=> 'nur Benutzer, die in keiner Gruppe sind',

   ' and also not in any group'
=> ' und auch nicht in einer Gruppe sind',

   'only members of group: "[_1]"'
=> 'nur Mitglieder der Gruppe "[_1]"',

   ' and also members of group: "[_1]"'
=> ' und auch Mitglieder der Gruppe "[_1] sind',

   'Author space for <span class="LC_cusr_emph">[_1]</span>'
=> 'Autorenbereich für <span class="LC_cusr_emph">[_1]</span>',

   'Co-authors with expired [_1] roles'
=> 'Co-Autoren mit abgelaufender Rolle "[_1]"',

   'Co-authors with future [_1] roles'
=> 'Co-Autoren mit zukünftiger Rolle "[_1]"',

   'Co-authors with active [_1] roles'
=> 'Co-Autoren mit aktiver Rolle "[_1]"',

   'All co-authors'
=> 'Alle Co-Autoren',

   'All co-authors with [_1] roles'
=> 'Alle Co-Autoren mit Rolle "[_1]"',

   'Domain - '
=> 'Domäne - ',

   'Users in domain with expired [_1] roles'
=> 'Benutzer in Domäne mit abgelaufener Rolle "[_1]"',

   'Users in domain with future [_1] roles'
=> 'Benutzer in Domäne mit zukünftiger Rolle "[_1]"',

   'Users in domain with active [_1] roles'
=> 'Benutzer in Domäne mit aktiver Rolle "[_1]"',

   'All users in domain'
=> 'Alle Benutzer in der Domäne',

   'All users in domain with [_1] roles'
=> 'Alle Benutzer in der Domäne mit Rolle "[_1]"',

   'Co-authors in domain with expired [_1] roles'
=> 'Co-Autoren in der Domäne mit abgelaufener Rolle "[_1]"',

   'Co-authors in domain with future [_1] roles'
=> 'Co-Autoren in der Domäne mit zukünftiger Rolle "[_1]"',

   'Co-authors in domain with active [_1] roles'
=> 'Co-Autoren in der Domäne mit aktiver Rolle "[_1]"',

   'All users with co-author roles in domain'
=> 'Alle Benutzer mit Co-Autoren-Rolle in der Domäne',

   'All co-authors in domain  with [_1] roles'
=> 'Alle Co-Autoren in der Domäne mit Rolle "[_1]"',

   'All courses in domain'
=> 'alle Kurse in der Domäne',

   'Courses in domain with institutional code: [_1]'
=> 'Kurse in der Domäne mit Institutscode "[_1]"',

   'Selected courses in domain'
=> 'Ausgewählte Kurse in der Domäne',

   'All courses in domain'
=> 'Alle Kurse in der Domäne',

   'users with expired [_1] roles'
=> 'Benutzer mit abgelaufener Rolle "[_1]"',

   'users with future [_1] roles'
=> 'Benutzer mit zukünftiger Rolle "[_1]"',

   'users with active [_1] roles'
=> 'Benutzer mit aktiver Rolle "[_1]"',

   'all users'
=> 'alle Benutzer',

   'users with [_1] roles'
=> 'Benutzer mit Rolle "[_1]"',

   'There are no students to drop.'
=> 'Es gibt keine Studenten, die ausgeschlossen werden könnten.',

   'Upload a file containing information about users'
=> 'Hochladen einer Datei mit Benutzerinformationen',

   'Upload file of users'
=> 'Hochladen einer Datei mit Benutzern',

   'How do I create a users list from a spreadsheet'
=> 'Wie erstelle ich aus einer Excel-Datei eine Benutzerliste',

   'How do I create a CSV file from a spreadsheet'
=> 'Wie erstelle ich aus einer Excel-Datei eine CSV-Datei',

   'Unable to enroll users'
=> 'Konnte Studenten nicht den Kurs belegen lassen!',

   'No Kerberos domain was specified.'
=> 'Es wurde keine Kerberos-Domäne angegeben!',

   'Enrolling Users'
=> 'Benutzer werden aufgenommen',

   'Updating Co-authors'
=> 'Aktualisiere Co-Autoren',

   'Adding/Modifying Users'
=> 'Füge Benutzer hinzu/Ändere',

   'Default section name [_1] could not be used as it is a reserved word.'
=> 'Der voreingestellte Sektionsname "[_1]" ist nicht zulässig, da es sich um ein intern reserviertes Wort handelt.',

   'Default section name "[_1]" is the name of a course group. Section names and group names must be distinct.'
=> 'Der voreingestellte Sektionsname "[_1]" ist eine Name einer Kursgruppe. Sektionsnamen and Gruppennamen müssen sich jedoch unterscheiden.',

   '<b>[_1]</b>: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a reserved word.'
=> '<b>[_1]</b>: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich - es handelt sich um ein intern reserviertes Wort.',

   '<b>[_1]</b>: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a course group.'
=> '<b>[_1]</b>: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich - es handelt sich um eine Kursgruppe.',

   'Section names and group names must be distinct.'
=> 'Sektionsnamen und Gruppennamen müssen sich unterscheiden.',

   '<b>[_1]</b>: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]".'
=> '<b>[_1]</b>: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich.',

   'This user already has an active/future student role in the course, unaffiliated to any section.'
=> 'Dieser Benutzer hat bereits eine aktive oder zukünftige Rolle in diesem Kurs, die nicht mit einer Sektion verbunden ist.',

   'This user already has an active/future role in section "[_1]" of the course.'
=> 'Dieser Benutzer hat in dem Kurs bereits eine aktive oder zukünftige Rolle in der Sektion "[_1]".',

   'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments in other sections.'
=> 'Auch wenn Ihre derzeitige Rolle das Hinzufügen von Studenten in die Sektion "[_1]" zulässt, haben Sie nicht die Berechtigung, bestehende Kursbelegungen in anderen Sektionen zu ändern.',

   '<b>[_1]</b>: You do not have permission to add the requested role [_2] for the user.'
=> '<b>[_1]</b>: Sie haben nicht die Berechtigung, dem Benutzer die gewünschte Rolle "[_2]" zuzuweisen.',

   'Allowable role(s) is/are: [_1].'
=> 'Zulässige Rollen: [_1]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Kursbelegung nicht möglich. Kein Passwort angegeben!',

   '<b>[_1]</b>: Unable to add co-author.  No password specified.'
=> '<b>[_1]</b>: Hinzufügen des Co-Autors nicht möglich. Kein Passwort angegeben!',

   '<b>[_1]</b>: Unable to add user.  No password specified.'
=> '<b>[_1]</b>: Hinzufügen des Benutzers nicht möglich. Kein Passwort angegeben!',

   'Processed [quant,_1,user].'
=> '[quant,_1,Benutzer,Benutzer] verarbeitet.',

   'Roles added for [quant,_1,user].'
=> 'Rollen für [quant,_1,Benutzer,Benutzer] hinzugefügt.',

   'If a user is currently logged-in to LON-CAPA, any new roles which are active will be available when the user next logs in.'
=> 'Beim nächsten Anmelden des Benutzers werden alle neuen aktiven Rollen verfügbar sein.',

   'No roles added'
=> 'Keine Rollen hinzugefügt',

   'Authentication changed for [_1] existing users.'
=> 'Die Authentifizierungsmethode hat sich für [_1] existente(n) Benutzer geändert.',

   'Students to Drop'
=> 'Auszuschließende Studenten',

   'There are no students with current/future access to the course.'
=> 'Es exisitieren keine Studenten mit aktuellem oder zukünftigem Zugriff auf den Kurs.',

   '<b>[_1]</b>:  Unable to add/modify: [_2]'
=> '<b>[_1]</b>:  Hinzufügen/Ändern nicht möglich: [_2]',

   '<b>[_1]</b>:  Unable to modify authentication: [_2]'
=> '<b>[_1]</b>:  Ändern der Authentifizierungsmethode nicht möglich: [_2]',

   '<b>[_1]</b>:  Unable to add role: [_2]'
=> '<b>[_1]</b>:  Hinzufügen der Rolle nicht möglich: [_2]',

   'No change in section assignment (none)'
=> 'Keine Änderung in Sektionsbelegung (none)',

   "Revoked role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' entzogen in [_2] für [_3]",

   "Deleted role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' gelöscht in [_2] für [_3]",

   "Re-enabled role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' reaktiviert in [_2] für [_3]",

   "Activated role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' aktiviert in [_2] für [_3]",

   "Changed Access Dates for role of '[_1]' in [_2] for [_3]"
=> "Geänderte Zugriffszeiten für Rolle '[_1]' in [_2] für [_3]",

   "Changed section for role of '[_1]' in [_2] for [_3]"
=> "Geänderte Sektion für Rolle '[_1]' in [_2] für [_3]",

   "Dropped role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' entzogen in [_2] für [_3]",

   'Error revoking [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Entziehen für [_1] in [_2] für [_3]: [_4].',

   'Error deleting [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Löschen für [_1] in [_2] für [_3]: [_4].',

   'Error re-enabling [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Reaktivieren für [_1] in [_2] für [_3]: [_4].',

   'Error activating [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Aktivieren für [_1] in [_2] für [_3]: [_4].',

   'Error changing access dates for [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Ändern der Zugriffszeiten für [_1] in [_2] für [_3]: [_4].',

   'Error changing section for [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Ändern der Sektion für [_1] in [_2] für [_3]: [_4].',

   'Error dropping [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Entziehen für [_1] in [_2] für [_3]: [_4].',

   'Revoked role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] entzogen.',

   'Deleted role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] gelöscht.',

   'Re-enabled role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] reaktiviert.',

   'Activated role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] aktiviert.',

   'Changed Access Dates for role(s) for [quant,_1,user,users,no users].'
=> 'Zugriffszeiten für Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] geändert.',

   'Changed section for role(s) for [quant,_1,user,users,no users].'
=> 'Sektionen für Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] geändert.',

   'Dropped role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] entzogen.',

   'Re-enabling will re-activate data for the role.'
=> 'Reaktivierung wird die Daten der Rolle reaktivieren.',

   'Display User Lists'
=> 'Teilnehmerliste anzeigen',

   'Display current class roster'
=> 'Aktuelle Kursteilnehmerliste anzeigen',

   'No section'
=> 'Keine Sektion',

   'List Users'
=> 'Benutzer anzeigen',

   'Pick custom role'
=> 'Benutzerdefinierte Rolle wählen',

   'Advanced Role'
=> 'Erweiterte Rolle',

   "Create User Notes, Display all User's Notes, Face-to-Face, Critical Messages, Broadcast Messages"
=> "Erstellen von Benutzeranmerkungen, Anzeige aller Benutzeranmerkungen, persönlicher Diskussionsbeiträge, wichtiger Nachrichten, Broadcast-Nachrichten",

   'Evade communication blocking'
=> 'Umgehen der Kommunikationssperre',

   'Generate anonymous statistics'
=> 'Anonyme Statistiken erzeugen',

   'Modify grade queue'
=> 'Ändern der Bewertungs-Warteschlange',

   'Grade items in grading queue'
=> 'Bewerten von Elementen in der Bewertungs-Warteschlange',

   'Set assessment parameters'
=> 'Beurteilungs-Parameter setzen', # Ressourcenparameter setzen/ändern (???)

   'Advanced printing options (with answers, discussions, all foils, ...)'
=> 'Erweiterte Druckoptionen (mit Antworten, Diskussionen, allen Auswahlmöglichkeiten, ...)',

   'Print for other users and entire course'
=> 'Für andere Benutzer und für gesamten Kurs drucken',

   'Get identity behind anonymous postings'
=> 'Identität hinter anonymen Beiträgen erhalten können',

   'View grades'
=> 'Beurteilungen anzeigen',

   "Access to What's New page"
=> "Zugriff auf Was-gibt's-Neues-Seite",

   'Upload Users List'
=> 'Datei mit Benutzern hochladen',

   'Update Users'
=> 'Benutzer aktualisieren',

   'Create/modify a user'
=> 'Einzelnen Benutzer hinzufügen/ändern',

   'Search for a user and modify/add user information or roles'
=> 'Suche nach einem Benutzer und ändern/hinzufügen von Benutzerdaten oder -rollen',

   'Add/modify a single user'
=> 'Einzelnen Benutzer hinzufügen/ändern',

   'Create users or modify the roles and privileges of users'
=> 'Benutzer, -rechte und -rollen erstellen/ändern',

   'Upload a File of Users'
=> 'Hochladen einer Datei mit Benutzern',

   'Add/Modify a Single User'
=> 'Einzelnen Benutzer hinzufügen/ändern',

   'create new user if required'
=> 'falls notwendig, neuen Benutzer erstellen',

   'Manage Multiple Users'
=> 'Verwaltung mehrerer Benutzer',

   'Create/Modify user'
=> 'Benutzer erstellen/ändern',

   'Visible input'
=> 'Sichtbare Eingabe',

   'Currently in use'
=> 'Derzeit in Verwendung',

   'Modify this user: [_1]'
=> 'Weitere Änderungen für Benutzer [_1]',

   'Blank Problem'
=> 'Leere Aufgabe',

   'Chemical Reaction Response'
=> 'Chemische Reaktion',

   'Click-On-Image Problem'
=> 'Klick-ins-Bild',

   'Curve Plot with Numerical Response'
=> 'Dynamischer Graph mit numerischer Antwort',

   'Custom Response'
=> 'Customresponse',

   'Data Plot with Numerical Response'
=> 'Datenplot mit numerischer Antwort',

   'Drop Box'
=> 'Dropbox',

   'Essay Response'
=> 'Essay',

   'Exam Upload Resource'
=> 'Examen-Hochlade-Ressource',

   'Formula Response using Computer Algebra System'
=> 'Formel mit Computer-Algebra-System',

   'Formula Response using Computer Algebra System and Hints'
=> 'Formel mit Computer-Algebra-System und Hinweisen',

   'Formula Response with Samples'
=> 'Formel mit Abtastpunkten',

   'Unordered Multi-Answer Formula Response Problem'
=> 'Formel - mehrere Antworten, ungeordnet',

   'Math Response using Computer Algebra System'
=> 'Mathematische Antwort mit Computer-Algebra-System (mathresponse)',

   'Math Response using Computer Algebra System and Hints'
=> 'Mathematische Antwort mit Computer-Algebra-System und Hinweisen (mathresponse)',

   'Numerical Response'
=> 'Numerisch',

   'One of Multiple Answers Numerical Problem'
=> 'Numerisch - eine aus mehreren Antworten',

   'Option Response - Matching'
=> 'Zuordnung mit Optionen (Option Response - Matching)',

   'Option Response - Concept Groups'
=> 'Zuordnung mit Optionen - Konzeptgruppen (Option Response - Concept Groups)', # 'Optionsauswahl mit Konzeptgruppen',

   'Matching Response'
=> 'Zuordnung mit Optionen - indirekt (Matching Response)',

   'Option Response - True/False'
=> 'Zuordnung mit Optionen - wahr/falsch (Option Response - True/False)', # 'Optionen - wahr/falsch',

   'Organic Material Response'
=> 'Organisches Material',

   'Radio Button Response'
=> '1-aus-n (radiobutton)',

   'Randomly Labelled Image with Option Response'
=> 'Dynamische Bildbeschriftung mit Optionsauswahl (Randomly Labelled Image)',

   'Rank Response'
=> 'Rangordnung (Rank Response)',

   'String Response'
=> 'Texteingabe (String Response)',

   'Display catalog of courses'
=> 'Kursübersicht', # long version: Kursübersicht anzeigen

   'Manage co-authors'
=> 'Co-Autoren verwalten',

   'Upload a File of Co-authors'
=> 'Datei mit Co-Autoren hochladen',

   'Add/Modify a Single Co-author'
=> 'Einzelnen Co-Autor hinzufügen/ändern',

   'Display Co-authors and Manage Multiple Users'
=> 'Co-Autoren anzeigen/Verwaltung mehrerer Benutzer',

   'No courses match the criteria you selected.'
=> 'Es exisitieren keine Kurse, die der getroffenen Auswahl entsprechen.',

   'Key authority (<tt>id@domain</tt>) if other than course'
=> 'Schlüsselmeister (<tt>id@domäne</tt>), falls anderer als der des Kurses',

   'New bridgetask file'
=> 'Neue "bridgetask"-Datei',

   'Create problem'
=> 'Aufgabe erstellen',

   'Create library'
=> 'Bibliothek erstellen',

   'Create survey'
=> 'Umfrage erstellen',

   'Create task'
=> '"Bridgetask" erstellen',

   'Problem Testing'
=> 'Testen von Aufgaben',

   "Don't Show Incorect/Correct Feedback"
=> "Korrekt/Inkorrekt-Hinweis nicht anzeigen",

   "Don't Show Any Feedback"
=> "Keinerlei Hinweis anzeigen",

   'Change View'
=> 'Anzeigeart wechseln',

   'Show Default View'
=> 'Standard-Anzeigeart',

   '[_1] for [_2] versions.'
=> '[_1] für [_2] Versionen.',

   'Set new preferred languages to '
=> 'Bevorzugte Sprache gesetzt auf ',

   'Reset preferred language.'
=> 'Bevorzugte Sprache zurückgesetzt.',

   'Set new preferred math display to '
=> 'Bevorzugte Methode, um wissenschaftliche Formeln darzustellen, gesetzt auf ',

   'Reset preferred math display.'
=> 'Bevorzugte Methode, um wissenschaftliche Formeln darzustellen, zurückgesetzt.',

   'Set new screenname to '
=> 'Nickname für anonyme Beiträge gesetzt auf ',

   'Reset screenname.'
=> 'Nickname für anonyme Beiträge zurückgesetzt.',

   'Set new nickname to '
=> 'Nickname gesetzt auf ',

   'Reset nickname.'
=> 'Nickname zurückgesetzt.',

   'Set menu mode to [_1].'
=> 'Menümodus auf [_1] gesetzt.',

   'Reset '
=> ' zurückgesetzt',

   'Set message forwarding to '
=> 'Nachrichtenweiterleitung gesetzt auf ',

   "Set message forwarding to 'off'."
=> "Nachrichtenweiterleitung auf 'aus' gesetzt.",

   'Set non-critical message notification address(es) to '
=> 'Benachrichtigungsadresse(n) für nicht-wichtige Nachrichten gesetzt auf ',

   "Set non-critical message notification to 'off'."
=> "Benachrichtigung für nicht-wichtige Nachrichten auf 'aus' gesetzt.",

   'Set critical message notification address(es) to '
=> 'Benachrichtigungsadresse(n) für wichtige Nachrichten gesetzt auf ',

   "Set critical message notification to 'off'."
=> "Benachrichtigung für wichtige Nachrichten auf 'aus' gesetzt.",

   'Set address(es) to receive excerpts with html retained '
=> 'Adresse(n) zum Empfang von Nachrichtenauszügen mit Beibehaltung von HTML gesetzt auf ',

   'Set notification address to receive excerpts with html stripped.'
=> 'Adresse zum Empfang von Nachrichtenauszügen gesetzt auf ohne Beibehaltung von HTML.',

   'Set all notification addresses to receive excerpts with html stripped.'
=> 'Alle Beachrichtigungsadressen zum Empfang von Nachrichtenauszügen gesetzt auf ohne Beibehaltung von HTML.',

   'Set Page Background to '
=> 'Seitenhintergrundfarbe gesetzt auf ',

   'Set Header Background to '
=> 'Kopfbereich-Hintergrundfarbe gesetzt auf ',

   'Set Header Border to '
=> 'Kopfbereich-Rahmenfarbe gesetzt auf ',

   'Set Font to '
=> 'Schriftfarbe gesetzt auf ',

   'Set Un-Visited Link to '
=> 'Farbe für nicht besuchte Links gesetzt auf ',

   'Set Visited Link to '
=> 'Farbe für besuchte Links gesetzt auf ',

   'Set Active Link to '
=> 'Farbe für aktive Links gesetzt auf ',

   'Reset Page Background'
=> 'Seitenhintergrundfarbe zurückgesetzt',

   'Reset Header Background'
=> 'Kopfbereich-Hintergrundfarbe zurückgesetzt',

   'Reset Header Border'
=> 'Kopfbereich-Rahmenfarbe zurückgesetzt',

   'Reset Font.'
=> 'Schriftfarbe zurückgesetzt.',

   'Reset Un-Visited Link.'
=> 'Farbe für nicht besuchte Links zurückgesetzt.',

   'Reset Visited Link.'
=> 'Farbe für besuchte Links zurückgesetzt.',

   'Reset Active Link.'
=> 'Farbe für aktive Links zurückgesetzt.',

   'Freezing Role: [_1]'
=> 'Einfrieren der Rolle [_1]',

   'Unfreezing Role: [_1]'
=> 'Einfrieren der Rolle [_1] aufgehoben',

   'No such user: '
=> 'Dieser Benutzer existiert nicht: ',

   'Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a <a href="/adm/resetpw">new request</a> for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.'
=> 'Tut mir leid, aber die von Ihnen angegebene URL zum Beenden des Zurücksetzens Ihres Passworts ist ungültig. Entweder wurde das in der URL eingebundene Merkzeichen gelöscht oder die von Ihnen angegebene URL ist nicht gültig. Bitte schicken Sie eine <a href="/adm/resetpw">neue Anfrage</a> zum Zurücksetzen des Passworts und folgen dem Link der neuen URL, die in der Ihnen zugesandten E-Mail angegeben is, damit Sie ein neues Passwort eingeben dürfen.',

   'Sorry, the token generated when you requested a password reset has expired.'
=> 'Tut mir leid, das erzeugte Merkzeichen zum Zurücksetzen Ihres Passworts ist bereits abgelaufen und daher nicht mehr gültig.',

   'Sorry, the URL generated when you requested reset of your password contained incomplete information.'
=> 'Tut mir leid, die URL, die erzeugt wurde, als Sie das Zurücksetzen Ihres Passworts angefordert haben, enthält unvollständige Daten und ist daher ungültig.',

   'Page requested in unexpected context'
=> 'Die Seite wurde in unerwartetem Kontext aufgerufen',

   'Invalid username and/or domain'
=> 'Ungültiger Benutzername und/oder Domäne',

   'Username and domain were blank'
=> 'Benutzername und Domäne waren leer',

   'Authentication type for this user can not be changed by this mechanism'
=> 'Die Authentifizierungsmethode kann für diesen Benutzer nicht auf die gewünschte Methode umgestellt werden',

   'One or more password fields were blank'
=> 'Ein oder mehrere Passwort-Felder waren leer',

   'Please log out and try again.'
=> 'Bitte loggen Sie sich aus und versuchen Sie es erneut.',

   'Please try again later.'
=> 'Bitte versuchen Sie es später nocheinmal.',

   'Unable to retrieve saved token for password decryption'
=> 'Es ist nicht möglich, das gespeicherte Merkzeichen für die Passwortverschlüsselung abzurufen',

   'Could not verify current authentication.'
=> 'Die aktuelle Authentifizierung konnte nicht bestätigt werden',

   'The new passwords you entered do not match.'
=> 'Die Bestätigung des neuen Passworts stimmt nicht mit dem neuen Passwort überein.',

   'Passwords must be a minimum of 7 characters long.'
=> 'Das Passwort muss mindestens 7 Zeichen lang sein.',

   'The password you entered contained illegal characters.'
=> 'Das von Ihnen eingegebene Passwort enthält ungültige Zeichen.',

   'Valid characters are'
=> 'Gültige Zeichen sind',

   'The password for [_1] was successfully changed'
=> 'Das Passwort für [_1] wurde erfolgreich geändert',

   'The password for [_1] was not changed'
=> 'Das Passwort für [_1] wurde nicht geändert',

   'Please make sure your old password was entered correctly.'
=> 'Bitte stellen Sie sicher, dass das alte Passwort korrekt eingegeben wurde.',

   'In discussions: only new posts will be displayed.'
=> 'In Diskussionen: Es werden nur neue Beiträge angezeigt.',

   'In discussions: all posts will be displayed.'
=> 'In Dikussionen: Es werden alle Beiträge angezeigt.',

   'In discussions: new posts will be cease to be identified as "NEW" after display.'
=> 'In Diskussionen: Es werden nach dem Anzeigen nicht mehr als "NEU" angezeigt.',

   'In discussions: posts will be identified as "NEW" until marked as read by the reader.'
=> 'In Diskussionen: Es werden Beiträge solange als "NEU" interpretiert, bis sie durch den Leser als gelesen markiert werden.',

   'The e-mail address entered in row '
=> 'Die E-Mail-Adresse, die Sie in der Zeile ',

   'The e-mail address you entered'
=> 'Die von Ihnen eingegebene E-Mail-Adresse',

   'is not a valid e-mail address'
=> 'ist keine gültige E-Mail-Adresse',

   'Title for the Uploaded Score'
=> 'Titel für Formular zum Hochladen von Noten',

   'Title for the Page'
=> 'Titel der Seite',

   'Title for the Problem'
=> 'Titel der Aufgabe',

   'Title for the Drop Box'
=> 'Titel der Dropbox',

   'Title for the Bulletin Board'
=> 'Titel des Schwarzen Bretts',

   'Not a valid user:domain'
=> 'Benutzer:Domäne ungültig',

   'Please enter both user and domain in the format user:domain'
=> 'Bitte geben Sie Benutzer und Domäne im Format Benutzer:Domäne ein!',

   'About [_99]'
=> 'Über-mich-Seite von [_99]',

   'No info'
=> 'Keine Information vorhanden',

   'No user information available'
=> 'Keine Benutzerdaten verfügbar',

   'The new directory name was changed from [_1] to [_2].'
=> 'Der Name des neuen Verzeichnisses wurde von [_1] in [_2] geändert.',

   'Unable to create a directory named'
=> 'Es war nicht möglich ein Verzeichnis anzulegen mit dem Namen',

   'A file or directory by that name already exists.'
=> 'Es exisitert bereits eine Datei oder ein Verzeichnis mit diesem Namen.',

   'Allowing others to retrieve file: [_1]'
=> 'Für andere Zugriff erlauben auf die Datei: [_1]',

   'Access to this file by others can be set to be one or more of the following types: public, passphrase-protected or conditional.'
=> 'Zugriff durch andere auf diese Datei kann auf folgende drei Typen eingestellt werden: öffentlich, passwortgeschützt oder bedingungsabhängig',

   'Public files are available to anyone without the need for login.'
=> 'Öffentliche Dateien sind für alle verfügbar, auch ohne Login.',

   'Passphrase-protected files do not require log-in, but will require the viewer to enter the passphrase you set.'
=> 'Passwortgeschützte Dateien erfordern keinen Login, aber es ist für den Zugriff notwendig, dass das von Ihnen hinterlegte Passwort eingegeben wird.',

   'A listing of files viewable without log-in is available at: '
=> 'Eine Liste von Dateien, die ohne Login verfügbar sind, gibt es unter: ',

   "For logged in users a 'Display file listing' link will also appear (when there are viewable files) on your personal information page:"
=> "Für eingeloggte Benutzer wird es auf Ihrer persönlichen Über-mich-Seite zusätzlich einen Link 'Anzeige Dateiliste' geben (falls anzeigbare Dateien vorhanden sind): ",

   "Users with privileges to edit course contents may add a course information page to a course using the 'Course Info' button in DOCS"
=> "Benutzer mit Berechtigung zum Ändern von Kursinhalten können dem Kurs eine Kursinformations-Seite hinzufügen. dies geschieht durch Verwendung des 'Kursinformationen'-Buttons im Bereich 'Kursinhalt einrichten'",

   'Conditional access controls for file: [_1]'
=> 'Bedingte Zugriffskontrolle für Datei: [_1]',

   'Help on setting up share access'
=> 'Hilfe zum Einstellen für gemeinsamen Zugriff',

   'Help on changing settings'
=> 'Hilfe zum Ändern der Einstellungen',

   'Help on removing share access'
=> 'Hilfe zum Entfernen des gemeinsamen Zugriffs',

   'Public access: [_1]'
=> 'Öffentlicher Zugriff: [_1]',

   'Dates available'
=> 'Verfügbare Datumseinstellungen',

   'Passphrase-protected access: [_1]'
=> 'Passwortgeschützter Zugriff: [_1]',

   'Passphrase'
=> 'Passwort',

   'Conditional access: [_1]'
=> 'Bedingungsabhängiger Zugriff: [_1]',

   'You have previously set [_1] conditional access controls.'
=> 'Zuvor haben Sie [_1] bedingungsabhängige Zugriffskontrollen eingerichtet.',

   'Change Conditions'
=> 'Bedingungen ändern',

   'Add conditional access'
=> 'Bedingungsabhängigen Zugriff hinzufügen',

   'based on domain, username, or course affiliation.'
=> 'basierend auf Domäne, Benutzername oder Kurszugehörigkeit',

   '[_1]-based conditional access: '
=> '[_1]-basierter bedingungsabhängiger Zugriff: ',

   'conditions'
=> 'Bedingungen',

   'condition'
=> 'Bedingung',

   'Action?'
=> 'Aktion?',

   'Allowed [_1] member affiliations'
=> 'Zugelassene [_1] Mitgliedszugehörigkeiten', # ???

   'No [_1]-based conditions defined.'
=> 'Keine [_1]-basierten Bedingungen definiert.',

   'Type of change'
=> 'Änderungsart',

   'Access control'
=> 'Zugriffskontrolle',

   'Additional information'
=> 'Zusätzliche Informationen',

   'A problem occurred deleting access controls: [_1]'
=> 'Beim Löschen der Zugriffkontrollen trat ein ein Problem auf: [_1]',

   'A problem occurred saving access control settings: [_1]'
=> 'Beim Speichern der Zugriffskontroll-Einstellungen trat ein Problem auf: [_1]',

   'opened folder'
=> 'geöffnetes Verzeichnis',

   'closed folder'
=> 'geschlossenes Verzeichnis',

   'Passphrase-protected'
=> 'Passwortgeschützt',

   'Conditional'
=> 'Bedingungsabhängig',

   'An error occurred ([_1]) while trying to delete [_2].'
=> 'Beim Versuch [_2] zu löschen ist ein Fehler aufgetreten: [_1]',

   'File: [_1] deleted.'
=> 'Die Datei [_1] wurde gelöscht.',

   'An error occurred ([_1]) while trying to delete access controls for the file.'
=> 'Beim Versuch Zugriffkontrollen für die Datei zu löschen, ist ein Fehler aufgetreten: [_1]',

   'Access controls also deleted for the file.'
=> 'Auch die Zugriffskontrollen wurden für diese Datei gelöscht.',

   'Error: no valid filename was provided to rename to.'
=> 'Fehler: Das Umbenennen ist nicht möglich, da für den neuen Dateinamen kein gültiger Dateiname angegeben wurde.',

   'An error occurred ([_1]) while trying to rename [_2] to [_3]'
=> 'Beim Versuch [_2] nach [_3] umzubenennen ist ein Fehler aufgetreten: [_1]',

   'The new file name was changed from:<br />[_1] to [_2]'
=> 'Der neue Dateiname wurde geändert von:<br />[_1] nach [_2]',

   'An error occurred ([_1]) while trying to delete access control records for the old name.'
=> 'Beim Versuch Zugriffskontroll-Datensätze für den alten Namen zu löschen ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to upload [_2].'
=> 'Beim Versuch [_2] hochzuladen ist ein Fehler aufgetreten: [_1]',

   'An error occurred (dir) ([_1]) while trying to delete [_2].'
=> 'Beim Versuch das Verzeichnis [_2] zu löschen ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to upload [_2] for embedded element [_3].'
=> 'Beim Versuch [_2] für das eingebettete Element [_3] hochzuladen ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to create a new directory [_2].'
=> 'Beim Versuch das Verzeichnis [_2] anzulegen, ist ein Fehler aufgetreten: [_1]',

   'Access controls updated to reflect the name change.'
=> 'Die Zugriffskontrolle wurde aufgrund der Namensänderung aktualisiert.',

   'Conditional files are accessible to logged-in users with accounts in the LON-CAPA network, who satisfy the conditions you set.'
=> 'Auf bedingungsabhängige Dateien können eingeloggte Benutzer zugreifen, die im LON-CAPA-Netzwerk einen Benutzeraccount haben und die die von Ihnen eingestellten Bedingungen erfüllen.',

   'The conditions can include affiliation with a particular course, or a user account in a specific domain.'
=> 'Die Bedingungen können eine Verbindung mit einem bestimmten Kurs oder Benutzeraccount in einer bestimmten Domäne beinhalten.',

   'Alternatively access can be granted to people with specific LON-CAPA usernames and domains.'
=> 'Alternativ kann Zugriff für Leute gewährt werden, die bestimmte LON-CAPA-Benutezrnamen oder -Domänen haben.',

   'Current access controls defined for this file:'
=> 'Derzeit eingestellte Zugriffskontrolle für diese Datei:',

   'No access control settings currently exist for this file.'
=> 'Für diese Datei existieren derzeit keine Zugriffskontroll-Einstellungen.',

   'Deleted'
=> 'Gelöscht',

   'No end date'
=> 'Kein Endedatum',

   'Start: '
=> 'Start: ',

   'End: '
=> 'Ende: ',

   'Domains: '
=> 'Domänen: ',

   'Users: '
=> 'Benutzer: ',

   'New control(s) added'
=> 'Neue Zugriffskontrolle(n) hinzugefügt',

   'Existing control(s) deleted'
=> 'Bestehende Zugriffskontrolle(n) gelöscht',

   'Existing control(s) modified'
=> 'Bestehende Zugriffskontrolle(n) geändert',

   'Add new <b>[_1]-based</b> access control for portfolio file: <b>[_2]</b>'
=> 'Neue <b>[_1]-basierte</b> Zugriffskontrolle für Portfolio-Dateien hinzufügen: <b>[_2]</b>',

   'Display all access settings for this file'
=> 'Alle Einstellungen für diese Datei anzeigen',

   'Add a roles-based condition'
=> 'Rollen-basierte Bedingung hinzufügen',

   'New role-based condition'
=> 'Neue rollen-basierte Bedingung',

   "Format for users' username:domain information:"
=> "Format für Informationen des Benutzers username:domäne: ", # ??? -> portfolio.pm

   'Add new [_1] condition(s)?'
=> 'Neue [_1]-Bedingung(en) hinzufügen?',

   'Number to add: '
=> 'Anzahl: ', # 'Anzahl neu Hinzuzufügender: ',

   'Select roles, course status, section(s) and group(s) for users who will be able to access the portfolio file.'
=> 'Wählen Sie Rollen, Kurs-Status, Sektion(en) und Gruppe(n) für die Benutzer, die Zugriff auf die Portfolio-Dateien erhalten sollen.',

   '[_1] status'
=> '[_1] status', # ???

   'Files selected from other directories:'
=> 'Dateien, die aus anderen Verzeichnissen ausgewählt wurden:',

   'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded.'
=> '[_1] konnte nicht hochgeladen werden (Größe: [_2] KB). Der verfügbare Speicherplatz wurde überschritten.',

   'Unable to upload [_1]. A locked file by that name was found in [_2].'
=> '[_1] konnte nicht hochgeladen werden. Eine gesperrte Datei mit diesem Namen wurde in [_2] gefunden.',

   'You will be able to rename or delete existing [_1] after a grade has been assigned.'
=> 'Sie können die Datei [_1] umbenennen oder löschen, nachdem eine Bewertung zugewiesen wurde.',

   'Unable to upload [_1]. A file by that name was found in [_2].'
=> '[_1] konnte nicht hochgeladen werden. Eine Datei mit diesem Namen wurde in [_2] gefunden.',

   'To upload, rename or delete existing [_1] in [_2].'
=> 'Um eine existierende Datei [_1] in [_2] hochzuladen, umzubenennen oder zu löschen.', # ???

   'Rename [_1] to [_2]?'
=> '[_1] in [_2] umbenennen?',

   'Reference Warning'
=> 'Verweiswarnung',

   'Completed upload of the file. This file contained references to other files. You must upload the referenced files or else the uploaded file may not work properly.'
=> 'Hochladen der Datei abgeschlossen. Diese Datei enthält Verweise auf andere Dateien. Sie müssen die Dateien, auf die verwiesen wird, auch hochladen oder die hochgeladene Datei wird nicht korrekt funktionieren.',

   'Please select the locations from which the referenced files are to be uploaded.'
=> 'Bitte wählen Sie die Orte aus, von denen die Dateien, auf die verwiesen wird, hochgeladen werden sollen.',

   'Delete [_1]?'
=> '[_1] löschen?',

   'Edit Portfolio File Catalog Information'
=> 'Katalogisierungsdaten der Portfoliodateien',

   'Edit Group Portfolio File Catalog Information'
=> 'Katalogisierungsdaten der Gruppen-Portfoliodateien',

   'Update'
=> 'Aktualisieren',

   'domains'
=> 'domänen',

   'users'
=> 'benutzer',

   'Access'
=> 'Zugriff',

   'Conditional: domain-based'
=> 'Bedingungsabhängig: domänen-basiert',

   'Conditional: user-based'
=> 'Bedingungsabhängig: benutzer-basiert',

   'Conditional: course-based'
=> 'Bedingungsabhängig: kurs-basiert',

   '[_1] was submitted in response to problem: [_2]'
=> '[_1] wurde als Antwort auf die Aufgabe [_2] eingereicht.',

   '[_1] was handed back in response to problem: [_2]'
=> '[_1] wurde als antwort auf die Aufgabe [_2] zurückgegeben.',

   'In the course:'
=> 'Im Kurs',

   'Back'
=> 'Zurück',

   'Error: no directory name was provided.'
=> 'Fehler: Es wurde kein Verzeichnisname angegeben.',

   'Unable to create a directory named [_1].'
=> 'Konnte das Verzeichnis [_1] nicht anlegen.',

   'Action disallowed'
=> 'Aktion nicht erlaubt',

   'You do not have sufficient privileges to [_1]'
=> 'Sie haben nicht genügend Berechtigungen, um [_1]',

   'upload files'
=> 'Datei hochzuladen',

   'delete files'
=> 'Dateien zu löschen',

   'rename files'
=> 'Dateien umzubennen',

   'set access controls for files'
=> 'Zugriffskontrollen für Dateien zu setzen',

   "in the group's file repository."
=> "in der Dateisammlung der Gruppe.",

   'in this portfolio.'
=> 'in diesem Portfolio-Bereich.',

   'You do not have the privileges required to access the shared files space for this group.'
=> 'Sie haben nicht die Berechtigung, um auf den Bereich für gemeinsam genutzte Dateien in dieser Gruppe zugreifen zu können.',

   'Not a valid group for this course'
=> 'Keine gültige Gruppe für diesen Kurs',

   'Group files for [_1]'
=> 'Gruppendateien für [_1]',

   'Invalid group'
=> 'Ungültige Gruppe',

   'No file was selected to upload.'
=> 'Es wurde keine Datei ausgewählt, die hochgeladen werden soll.',

   'To upload a file, click <strong>Browse...</strong> and select a file, then click <strong>Upload</strong>.'
=> 'Um eine Datei hochzuladen, klicken Sie auf <strong>Durchsuchen...</strong> und wählen Sie eine Datei, dann klicken Sie auf <strong>Hochladen</strong>.',

   'Edit the meta data'
=> 'Metadaten ändern',

   'Pick functionality'
=> 'Funktion auswählen',

   'Functionality to display/modify'
=> 'Funktionen, die angezeigt oder geändert werden sollen',

   'You must select at least one functionality type to display.'
=> 'Sie müssen mindestens einen Funktionstyp auswählen, der angezeigt werden soll.',

   'Default color schemes'
=> 'Voreingestellte Farbeinstellungen',

   'Log-in page options'
=> 'Optionen für Login-Seite',

   'Default authentication/language/timezone'
=> 'Voreingestellte Authentifizierung/Sprache/Zeitzone',

   'Default quotas for user portfolios'
=> 'Voreingestellter Speicherplatz für Portfoliobereiche der Benutzer',

   'Auto-enrollment settings'
=> 'Einstellungen für automatische Kursbelegung',

   'Auto-update settings'
=> 'Einstellungen für automatische Aktualisierungen',

   'Institutional directory searches'
=> 'Institutionelle Verzeichnissuche',

   'Contact Information'
=> 'Kontaktdaten',

   'User creation'
=> 'Benutzer-Erstellung',

   'User modification'
=> 'Benutzer-Einstellungen',

   'Scantron format file'
=> 'Scantron-Format-Datei',

   'Cataloging of courses'
=> 'Katalogisierung von Kursen',

   'Display options'
=> 'Anzeigeoptionen',

   'Display using: '
=> 'Anzeige verwendet: ',

   'one column'
=> 'eine Spalte',

   'two columns'
=> 'zwei Spalten',

   'Changes made:'
=> 'Vorgenommene Änderungen:',

   'Back to configuration display'
=> 'Zurück zur Konfiguration',

   'No changes made to log-in page settings'
=> 'An den Optionen für die Login-Seite wurden keine Änderungen vorgenommen.',

   'Post Server Announcements'
=> 'Server-Bekanntmachung',

   'Post announcements to the system login and roles screen'
=> 'Bekanntmachung auf System-Login-Seite und Benutzerrollen-Seite',

   '(leave blank to delete announcement)'
=> '(leer lassen, um Bekanntmachung zu löschen)',

   'Check machines:'
=> 'Server auswählen:', # n.t.

   'Support Request'
=> 'Anfrage an Helpdesk',

   'Do <b>not</b> use this form to ask questions about course content.'
=> 'Verwenden Sie dieses Formular <b>nicht</b> für Fragen über Kursinhalte.',

   'Contact your instructor instead.'
=> 'Kontaktieren Sie dazu Ihren Dozenten.',

   'Cc'
=> 'Kopie an (CC)',

   'Your e-mail address'
=> 'Ihre E-Mail-Adresse',

   'Search and Enroll'
=> 'Suche und Kursbelegung',

   'Search or Add New User'
=> 'Suche oder neuen Benutzer hinzufügen',

   'No username and/or domain provided.'
=> 'Kein Benutzername und/oder Domäne angegeben.',

   'No match was found for the username ([_1]) in LON-CAPA domain: [_2]'
=> 'Für den Benutzernamen [_1] in der LON-CAPA-Domäne [_2] wurde kein Treffer gefunden.',

   'Contact the <a[_1]>helpdesk</a> for assistance.'
=> 'Kontaktieren Sie das <a[_1]>Helpdesk</a> für Unterstützung.',

   'Submit a request to the LON-CAPA [_1]helpdesk[_2] for [_3] if you require assistance.'
=> 'Kontaktieren Sie das [_1]LON-CAPA-Helpdesk[_2] ([_3]), falls Sie Unterstützung benötigen.',

   'Unable to create new Excel file. This error has been logged. Please alert your LON-CAPA administrator.'
=> 'Die Excel-Datei konnte nicht angelegt werden. Dieser Fehler wurde protokolliert. Bitte informieren Sie Ihren LON-CAPA-Administrator.',

   'Records [_1]'
=> 'Datensätze [_1]', # ???

   'Filter [_1]'
=> 'Filter [_1]',

   'Under you current role you are not permitted to change login settings for this user'
=> 'Mit Ihrer derzeitigen Benutzerrolle sind Sie nicht berechtigt, die Login-Daten für diesen Benutzer zu ändern.',

   'History'
=> 'Historie',

   'Part '
=> 'Teil ',

   'Transaction [_1]'
=> 'Transaktion [_1]', # ???

   'Nothing submitted - no attempts.'
=> 'Nichts eingereicht - keine Versuche.',

   'No data.'
=> 'Keine Daten vorhanden.',

   '[_1] will be inaccessible between [_2] and [_3] because communication is being blocked.'
=> 'Auf [_1] kann zwischen [_2] und [_3] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Open in a new window'
=> 'In neuem Fenster öffnen',

   'Revoke user roles'
=> 'Benutzerrollen entziehen',

   'Delete user roles'
=> 'Benutzerrollen löschen',

   'Re-enable expired user roles'
=> 'Abgelaufene Benutzerrollen reaktivieren',

   'Make future user roles active now'
=> 'Zukünftige Benutzterrollen für jetzt aktivieren',

   'Change starting/ending dates'
=> 'Anfangs-/Endezeiten ändern',

   'Change section associated with user roles'
=> 'Mit Benutzerrollen verknüpfte Sektionen ändern',

   'Modify existing user: '
=> 'Existierenden Benutzer ändern: ',

   'Enroll one student: '
=> 'Einzelnen Studenten eintragen: ',

   'Existing Roles'
=> 'Bestehende Rollen',

   'Text-based Interface Login'
=> 'Anmeldung für textbasierte Oberfläche',

   'Select Accessibility Options'
=> 'Auswahl der Anmeldeoptionen',

   'Suppress rendering of images'
=> 'Anzeige von Bildern unterbinden',

   'Suppress Java applets'
=> 'Java-Applets unterbinden',

   'Suppress rendering of embedded multimedia'
=> 'Eingebettete Multimedia-Objekte unterbinden',

   'Increase font size'
=> 'Zeichengröße erhöhen',

   'Switch to black and white mode'
=> 'Schwarz-Weiß-Modus',

   'Remember these settings for next login'
=> 'Diese Einstellungen für das nächste Anmelden merken',

   'You are already logged in!'
=> 'Sie sind bereits angemeldet!',

   'You are already logged in'
=> 'Sie sind bereits angemeldet!',

   'Please either [_1]continue the current session[_2] or [_3]logout[_4].'
=> 'Ihre Möglichkeiten: [_1]aktuelle Sitzung fortsetzen[_2] oder [_3]abmelden[_4].',

   'Login problems?'
=> 'Schwierigkeiten beim Anmelden?',

   'Reset password'
=> 'Passwort zurücksetzen',

   'Reset forgotten LON-CAPA password'
=> 'Vergessenes LON-CAPA-Passwort zurücksetzen',

   'If you use the same account for other campus services besides LON-CAPA, (e.g., e-mail, course registration, etc.), a separate centrally managed mechanism likely exists to reset a password.  However, if your account is used for just LON-CAPA access you will probably be able to reset a password from this page.'
=> 'Falls Sie den gleichen Account für mehrere Campusdienste neben LON-CAPA verwenden (z.B. E-Mail, Kurseinschreibung, etc.), existiert überlicherweise ein zentrale Einrichtung, über die Sie Ihr Passwort zurücksetzen können. Falls Ihr Account nur für LON-CAPA eingesetzt wird, können Sie Ihr Passwort gegebenenfalls über diese Seite zurücksetzen.',

   'Three conditions must be met:'
=> 'Drei Bedingungen müssen zutreffen:',

   'An e-mail address must have previously been associated with your LON-CAPA username.'
=> 'Es muss eine E-Mail-Adresse mit Ihrem LON-CAPA-Benutzernamen verknüpft sein.',

   'You must be able to access e-mail sent to that address.'
=> 'Sie müssen E-Mails, die an diesen E-Mail-Account geschickt werden, lesen können.',

   'Your LON-CAPA account must be of a type for which LON-CAPA can reset a password.'
=> 'Ihr LON-CAPA-Account muss von dem Typ sein, für den LON-CAPA Passwörter zurücksetzen kann.',

   'Email address in LON-CAPA'
=> 'E-Mail-Adresse in LON-CAPA',

   'The username you provided was not verified as a valid username in the LON-CAPA system for the [_1] domain.'
=> 'Der von Ihnen angegebene Benutzername konnte nicht als gültiger LON-CAPA-Benutzername der Domäne [_1] bestätigt werden.',

   'Please [_1]go back[_2] and try again.'
=> 'Bitte gehen Sie [_1]einen Schritt zurück[_2] und versuchen Sie es erneut.',

   'The e-mail address you provided does not appear to be a valid address.'
=> 'Die von Ihnen angegebene E-Mail-Adresse scheint keine gültige E-Mail-Adresse zu sein.',

   'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.'
=> 'Die von Ihnen angegebene E-Mail-Adresse stimmt nicht mit der in LON-CAPA hinterlegten E-Mail-Adresse des von Ihnen angegebenen Benutzers/Domäne überein.',

   'A valid e-mail address was not located in the LON-CAPA system for the username and domain you provided.'
=> 'In LON-CAPA konnte zu Ihrem Benutzer und Domäne keine gültige E-Mail-Adresse gefunden werden.',

   'The username you provided uses an authentication type which can not be reset directly via LON-CAPA.'
=> 'Das Authentifizierungsverfahren, das bei dem von Ihnen angegebenen Benutzer verwendet wird, erlaubt kein Zurücksetzen des Passworts über LON-CAPA.',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3].'
=> 'Sie können das [_1]LON-CAPA-Helpdesk[_2] der Einrichtung [_3] kontaktieren.',

   'You may wish to send an e-mail to the server administrator: [_1] for [_2].' # 1: e-mail, 2: domain
=> 'Sie können an den Server-Administrator [_1] der Einrichtung [_2] eine E-Mail schicken.',

   'Assigning yourself a co-author or assistant co-author role in your own author area in Construction Space is not permitted'
=> 'Es ist nicht möglich, sich selbst für den eigenen Autorenbereich/Konstruktionsbereich Co-Autoren- oder Co-Autor-Assistenten-Rechte zu vergeben.',

   'Owner(s)'
=> 'Eigentümer',

   'Practice Problem'
=> 'Übungsaufgabe',

   'Submissions are not permanently recorded'
=> 'Die Antworten werden nicht permanent gespeichert.',

   'Submissions to practice problems are not permanently recorded.'
=> 'Antworten von Übungsaufgaben werden nicht permanent gespeichert.',

   'not graded'
=> 'keine Punktewertung',

   'Course initialization preference'
=> 'Kurs-Initialisierungs-Präferenz',

   'Choose which page will be displayed when you enter this course after selecting a role.'
=> 'Festlegung, welche Seite beim Betreten dieses Kurses angezeigt werden soll.',

   'Current value is determined by'
=> 'Derzeitiger Wert ist bestimmt durch',

   'and is set to display'
=> 'und ist so eingestellt das folgende Seite gezeigt wird:',

   'Page display controlled by'
=> 'Seitenanzeige wird bestimmt durch',

   'If'
=> 'Falls',

   'Choose course entry'
=> 'Auswahl des Kurs-Eintrags',

   'Modify course entry'
=> 'Kurs-Eintrag ändern',

   'No members to add at this time, as there are no users matching the specified type(s), role(s) and section(s).'
=> 'Derzeit gibt es keine Mitglieder, die hinzuzufügen wären, da es keine Benutzer gibt, auf die die Typen, Rollen und Sektionen zutreffen.',

   'There are no users to add as new members, as all users matching the specified type(s), role(s), and section(s) are already affiliated with this group.'
=> 'Derzeit gibt es keine Benutzer, die als neue Mitglieder hinzuzufügen wären, da alle Benutzer, auf die die Typen, Rollen und Sektionen zutreffen, bereits mit der Gruppe verknüpft sind.',

   'Setting optional privileges for specific group members'
=> 'Einrichten von optionalen Berechtigungen für bestimmte Gruppenmitglieder',

   'As no group tools will be made available to users, there are no specific user privileges to set.'
=> 'Da keine Gruppenwerkzeuge für Benutzer zugänglich gemacht werden, können auch keine Berechtigungen für bestimmte Benutzer eingerichtet werden.',

   'Create group'
=> 'Gruppe erstellen',

   'E-mail Address'
=> 'E-Mail-Adresse',

   'Closes '
=> 'Schließt am ',

   'The resources in "[_1]" are open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete all resources "[_1]".'
=> 'Die Ressourcen in "[_1]" sind nur für eine begrenzte Zeit verfügbar. Sobald Sie auf "Zeige Ressource" klicken, haben Sie [_2] Zeit, um alle Ressourcen in "[_1]" zu bearbeiten.',

   'This resource "[_1]" is open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete this resource "[_1]".'
=> 'Diese Ressource "[_1]" ist nur für eine begrenzte Zeit verfügbar. Sobald Sie auf "Zeige Ressource" klicken, haben Sie [_2] Zeit, um diese Ressource zu bearbeiten.',

   '[quant,_1,day]'
=> '[quant,_1,Tag,Tage]',

   '[quant,_1,hour]'
=> '[quant,_1,Stunde,Stunden]',

   '[quant,_1,minute]'
=> '[quant,_1,Minute,Minuten]',

   '[quant,_1,second]'
=> '[quant,_1,Sekunde,Sekunden]',

   'Start Timer?'
=> 'Timer starten?',

   'Sign up for time to work.'
=> 'Für Zeiten zur Bearbeitung eintragen',

   'Requesting Another Worktime'
=> 'Anforderung von Zeiten zur Bearbeitung',

   'No available times.'
=> 'Keine Zeiten verfügbar.',

   'Return to last resource'
=> 'Zur letzten Ressource zurückkehren',

   'My Courses'
=> 'Meine Kurse',

   '[_1] parts'
=> '[_1] Teile',

   'Part: [_1]'
=> 'Teil [_1]',

   'New Discussion'
=> 'Neuer Diskussionsbeitrag',

   'New Email'
=> 'Neue Nachricht',

   'New Error'
=> 'Neuer Fehler',

   '(randomly select [_1])'
=> '(zufällig ausgewählt [_1])',

   '(randomly ordered)'
=> '(in zufälliger Reihenfolge)',

   'No course selected'
=> 'Kein Kurs gewählt',

   'Open '
=> 'Öffnet am ',

   'Having technical difficulties; please check status later'
=> 'Technische Probleme - bitte später nochmal probieren',

   'Answer open'
=> 'Antwort verfügbar am',

   'Yes, and show correct answer if they exceed the maximum number of tries.'
=> 'Ja, und korrekte Antwort anzeigen, nachdem alle Versuche aufgebraucht sind.',

   "No, don't show correct/incorrect feedback."
=> "Nein, kein Korrekt-/Inkorrekt-Feedback anzeigen",

   'No, show no feedback at all.'
=> 'Nein, keinerlei Feedback anzeigen.',

   'single part'
=> 'einteilig',

   'Course Page'
=> 'Kurs-Seite',

   'Unable to set "number unread posts display" to [_1] due to [_2].'
=> '"Anzeige der Anzahl ungelesener Beiträge" konnte nicht auf [_1] gesetzt werden. Ursache: [_2]',

   'Current value is [_1].'
=> 'Derzeitiger Wert ist [_1].',

   'Unable to set interval to [_1] due to [_2].'
=> 'Intervall konnte nicht auf [_1] gesetzt werden. Ursache: [_2]',

   'Changes to threshold(s) for problem tracking:'
=> 'Vorgenommene Änderungen der Schwellenwerte:',

   'Set threshold for [_1] to [_2]'
=> 'Schwellenwert für [_1] auf [_2] gesetzt',

   'Set the default page to be displayed when you select a course role'
=> 'Einstellen der voreingestellten Seite, die nach Betreten des Kurses angezeigt werden soll',

   '(Currently: [_1])'
=> '(Derzeit: [_1])',

   'The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the "[_1]" page in the course' # [_1]: "<i>What's New</i>"
=> 'Die hier vorgenommenen allgemeinen Benutzereinstellungen können in einzelnen Kursen überschrieben werden, indem spezielle Kurseinstellungen auf der "<i>Was-gibt\'s-Neues-Seite</i>" im jeweiligen Kurs vorgenommen werden.',

   'Display the [_1] in the course.' # [_1]: '<b>first resource</b>'
=> 'Anzeige der <b>ersten Ressource</b> im Kurs.',

   'Display the "[_1]" page - a summary of items in the course which require attention.' # [_1]: "<b>What's New</b>"
=> 'Anzeige der "<b>Was-gibt\'s-Neues-Seite</b> - Übersicht von Elementen, auf die geachtet werden sollte.',

   'Default now set'
=> 'Voreinstellung ist ab sofort',

   'when you select a course role from the roles screen'
=> 'Wenn Sie einen Kurs von der Benutzerrollen-Seite wählen',

   'you will be taken to the start of the course.'
=> 'werden Sie zum Anfang des Kurses geleitet.',

   'a page will be displayed that lists items in the course that may require action from you.'
=> 'wird eine Seite angezeigt, die Elemente auflistet, die von Ihnen beachtet werden sollten.',

   "Display the What's New page listing course action items"
=> "Anzeige der Was-gibt's-Neues-Seite, die die Kurs-Aktionselemente auflistet",

   'Go to the start of the course'
=> 'Zum Anfang des Kurses gehen, und zwar ',

   'now'
=> 'jetzt',

   'No official courses to display for [_1].'
=> 'Es existieren keine offiziellen Kurse für [_1], die angezeigt werden könnten.',

   '(Month - Day - Year)'
=> '(Monat - Tag - Jahr)',

   'Month[_1]Day[_2]Year'
=> 'Monat[_1]Tag[_2]Jahr',

   'Copyright/distribution option "Private" is no longer supported. Select another option from below. Consider "Custom Rights" for maximum control over the usage of your resource.'
=> 'Copyright/Zugriffsrechte unterstützt ab sofort nicht mehr die Option "Private Veröffentlichung". Deshalb wählen Sie bitte unten eine andere Option aus. Sie können "Spezielle Nutzungsrechte" wählen, um maximale Kontrolle über den Zugriff auf Ihre Ressource zu erhalten.',

   'Skipping'
=> 'Ausgelassen:',

   'Notifying host'
=> 'Benachrichtigung des Hosts', # ???

   'Back to Catalog Information'
=> 'Zurück zu den Katalogisierungsdaten',

   ' at '
=> ' in ',

   'Computer\'s answer is incorrect ("[_1]").'
=> 'Die hinterlegte Antwort ist falsch ("[_1]").',

   'Computer\'s answer is incorrect ("[_1]"). It is likely that the tolerance range [_2] or significant figures [_3] need to be adjusted.'
=> 'Die hinterlegte Antwort ist falsch ("[_1]"). Es scheint, als dass der Toleranzbereich [_2] oder die signifikanten Stellen [_3] angepasst werden müssten.',

   'Computer\'s answer is incorrect ("[_1]"). It is likely that the tolerance range [_2] needs to be adjusted.'
=> 'Die hinterlegte Antwort ist falsch ("[_1]"). Es scheint, als dass der Toleranzbereich [_2] angepasst werden müsste.',

   'Submission Record'
=> 'Einreichungs-Aufzeichnungen',

   'Set/Change grades'
=> 'Bewertungen eingeben/ändern',

   'View of the problem'
=> 'Anzeige der Aufgabe',

   'Assign Grades'
=> 'Bewertungen zuweisen',

   'Save &amp; Next'
=> 'Speichern und weiter',

   '[_1]student(s)'
=> '[_1]Student(en)',

   '(Next and Previous (student) do not save the scores.)'
=> '("Vorherige" und "Weiter" speichert nicht die Bewertungsdaten dieser Seite)',

   'LON-CAPA User Message'
=> 'LON-CAPA-Benutzernachricht',

   '<b>Message: </b> No more students for this section or class.'
=> '<b>Nachricht:</b> Keine weiteren Studenten für diese Sektion oder diesen Kurs.',

   'Click on the button below to return to the grading menu.'
=> 'Klicken Sie auf den Button, um zum Bewertungsmenü zurückzugelangen.',

   'Group files'
=> 'Gruppendateien',

   'One group portfolio file is available.'
=> 'Eine Gruppen-Portfolio-Datei ist verfügbar.',

   'One portfolio file owned by [_1] is available.'
=> 'Eine Gruppen-Portfolio-Datei von [_1] ist verfügbar.',

   'A total of [_1] group portfolio files are available.'
=> 'Insgesamt sind [_1] Gruppen-Portfolio-Dateien verfügbar.',

   'A total of [_1] portfolio files owned by [_2] are available'
=> 'Insgesamt sind [_1] Gruppen-Portfolio-Dateien von [_2] verfügbar.',

   '[quant,_1,file is,files are] publicly accessible.'
=> 'Auf [quant,_1,Datei,Dateien] kann öffentlich zugegriffen werden.',

   '[quant,_1,file requires,files require] a passphrase for access.'
=> '[quant,_1,Datei benötigt,Dateien benötigen] für den Zugriff ein Passwort.',

   'Group Portfolio files'
=> 'Gruppen-Portfolio-Dateien',

   'Viewable portfolio files.'
=> 'Einsehbare Portfolio-Dateien',

   'Viewable portfolio files'
=> 'Einsehbare Portfolio-Dateien',

   'Viewable group portfolio files'
=> 'Einsehbare Gruppen-Portfolio-Dateien',

   'Display file listing'
=> 'Dateienliste anzeigen',

   'Portfolio files for [_1]'
=> 'Portfolio-Dateien von [_1]',

   'File access type: '
=> 'Dateizugriffs-Typ: ',

   'Update display'
=> 'Anzeige aktualisieren',

   'Course Information page'
=> 'Kursinformations-Seite',

   'Information about [_1]'
=> 'Über-mich-Seite von [_1]',

   'There are no available files of the specified access type: [_1]'
=> 'Es sind keine Dateien des angegebenen Zugriffstyps [_1] verfügbar.',

   'File Type Displayed: [_1]'
=> 'Anzuzeigende Dateitypen: [_1]',

   'All file types'
=> 'Alle Dateitypen',

   'The resource depends on another resource with variable filename, i.e., [_1].'
=> 'Die Ressource hängt von einer anderen Ressource ab, die einen variablen Dateinamen hat, z.B. [_1].', 

   'You likely need to explicitly allow access to all possible dependencies using the [_1]-tag.'
=> 'Sie müssen explizit Zugriff auf alle möglichen Abhängigkeiten erlauben, indem Sie das [_1]-Tag verwenden.',


   'Select&nbsp;All'
=> 'Alle&nbsp;auswählen',

   'Select&nbsp;Common&nbsp;Only'
=> 'Nur&nbsp;Gebräuchliche&nbsp;auswählen',

   'Add Selection for:'
=> 'Auswahl hinzufügen für:',

   'Problem&nbsp;Dates'
=> 'Aufgaben-Zeitfenster',

   'Content&nbsp;Dates'
=> 'Inhalts-Zeitfenster',

   'Discussion&nbsp;Settings'
=> 'Diskussionen',

   'Visibilities'
=> 'Sichtbarkeit',

   'Part&nbsp;Parameters'
=> 'Aufgabenteile',

   'Unselect&nbsp;All'
=> 'Auswahl&nbsp;komplett&nbsp;aufheben',

   'Problem Opening Date'
=> 'Aufgaben-Startzeit',

   'Problem Due Date'
=> 'Aufgaben-Fälligkeitszeit',

   'Problem Answer Date'
=> 'Aufgaben-Antwortverfügbarkeitszeit',

   'Show Problem Status'
=> 'Aufgabenstatus anzeigen',

   'Weight'
=> 'Aufgaben-Gewichtung',

   'Maximum Number of Tries'
=> 'Maximale Anzahl an Versuchen',

   'Resource hidden from students'
=> 'Ressource für Studenten verborgen',

   'Time-Limit'
=> 'Zeitlimit',

   'New LON-CAPA [_1] ID: [_2]'
=> 'Neue LON-CAPA-[_1]-ID: [_2]',

   'Not available'
=> 'Nicht verfügbar',

   'Post Announcement'
=> 'Bekanntmachung absenden',

   'The folder name: "[_1]" is already in use for an existing folder.'
=> 'Der Verzeichnisname "[_1]" ist bereits in einem bestehendem Verzeichnis in Verwendung.',

   'The folder name: "[_1]" is already used for one of the folders automatically generated by the system.'
=> 'Der Verzeichnisname "[_1]" ist bereits in einem systemgenerierten Verzeichnis in Verwendung.',

   'Error - could not obtain lock on email folders record.'
=> 'Fehler: Sperrung des Nachrichtenverzeichnis-Datensatzes war nicht möglich.',

   'The folder "[_1]" may not be deleted'
=> 'Das Verzeichnis "[_1]" kann nicht gelöscht werden',

   'The folder "[_1]" does not exist so deletion is not required.'
=> 'Das Verzeichnis "[_1]" existiert nicht und braucht daher nicht gelöscht zu werden.',

   'The folder "[_1]" contains messages so it may not be deleted.'
=> 'Das Verzeichnis "[_1]" enthält Nachrichten und kann daher nicht gelöscht werden.',

   'Delete or move the messages to a different folder first.'
=> 'Löschen oder verschieben Sie die Nachrichten zunächst in ein anderes Verzeichnis.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is an invalid name.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name ungültig ist.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is reserved for folders provided automatically by the system.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name für Verzeichnisse reserviert ist, die automatisch vom System angeboten werden.',

   'The folder "[_1]" may not be renamed to "[_2]" because the new name you requested is already being used for an existing folder.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name bereits für ein bestehendes Verzeichnis verwendet wird.',

   'The folder "[_1]" could not be renamed to "[_2]" because the folder does not exist.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da das Verzeichnis "[_1]" nicht existiert.',

   'Warning: failed to release lock for counter'
=> 'Warnung: Die Sperre für den Zähler konnte nicht freigegeben werden.',

   'Message not moved, Attempted to move message to the same folder as it already is in.'
=> 'Die Nachricht wurde nicht verschoben, da sie in das gleiche Verzeichnis verschoben werden sollte, in dem sie sich bereits befindet.',

   'Message not moved, A network error occurred.'
=> 'Die Nachricht wurde nicht verschoben, da ein Netzwerkfehler aufgetreten ist.',

   'Message not moved as the message is no longer in the source folder.'
=> 'Die Nachricht wurde nicht verschoben, da sie sich nicht mehr im Quellverzeichnis befindet.',

   'Message copied to new folder but status was not, A network error occurred.'
=> 'Die Nachricht wurde in das neue Verzeichnis kopiert, deren Status allerdings nicht, da ein Netzwerkproblem aufgetreten ist.',

   'Message copied, but unable to delete the original from the source folder.'
=> 'Die Nachricht wurde kopiert, allerdings konnte das Original im Quellverzeichnis nicht entfernt werden.',

   'Message copied, but unable to delete the original status from the source folder.'
=> 'Die Nachricht wurde kopiert, allerdings konnte der Originalstatus im Quellverzeichnis nicht entfernt werden.',

   'Error: you must have a course role selected to be able to send a broadcast message to a group in the course.'
=> 'Fehler: Sie müssen zunächst eine Kursrolle auswählen, um Broadcast-Nachrichten an eine Kursgruppe senden zu können.',

   'Error: could not determine domain or number of course'
=> 'Fehler: Weder die Domäne noch die Nummer des Kurses konnte ermittelt werden',

   'Select message recipients from the group members listed below.'
=> 'Wählen Sie Nachrichtenempfänger von der unten angegebenen Gruppenmitgliederliste.',

   'Send another group email'
=> 'Eine weitere Gruppen-Nachricht schicken',

   'Return to group page'
=> 'Zurück zur Gruppenseite',

   'You have to confirm that you have received this message before you can view other pages. After confirmation, this message will be moved to your regular inbox'
=> 'Sie müssen bestätigen, dass Sie diese Nachricht empfangen haben, bevor Sie Zugriff auf andere Seiten erhalten. Nach der Bestätigung wird diese Nachricht in Ihren Posteingang verschoben.',

   '[quant,_1,message is, messages are] not viewable because display of LON-CAPA messages sent to you by other students between [_2] and [_3] is currently being blocked because of online exams.'
=> '[quant,_1,Nachricht ist, Nachrichten sind] nicht sichtbar, da die Anzeige von an Sie von anderen Studenten gesendeten LON-CAPA-Nachrichten zwischen [_2] und [_3] derzeit aufgrund von Online-Prüfungen gesperrt ist.',

   'Each of the <b>[quant,_1,message]</b> you checked will be forwarded to the recipient(s) you select below.'
=> 'Jede der <b>[quant,_1,Nachricht,Nachrichten]</b>, die Sie ausgewählt haben, wird an die Empfänger weitergeleitet, die Sie unten auswählen.',

   'The message you checked will be forwarded to the recipient(s) you select below.'
=> 'Die Nachricht, die Sie ausgewählt haben, wird an die Empfänger weitergeleitet, die Sie unten auswählen.',

   'Send Reply to'
=> 'Antworten senden an',

   'Save message for re-use'
=> 'Nachricht zur Wiederverwendung speichern',

   'Show re-usable messages'
=> 'Wiederverwendbare Nachrichten anzeigen',

   'This message was designated by the sender not to allow replies.'
=> 'Der Absender dieser Nachricht hat festgelegt, dass auf diese Nachricht nicht geantwortet werden kann.',

   'The sender did not designate a reply to address for this message.'
=> 'Der Absender hat keine Antwortadresse für diese Nachricht festgelegt.',

   'Reply to other recipients'
=> 'Antwort an weitere Empfänger',

   'Unless you choose otherwise:'
=> 'Sofern Sie nichts anderes auswählen, werden folgende Einstellungen verwendet:',

   "The subject in each forwarded message will be <i>'Forwarding:'</i> followed by the original subject."
=> "Der Betreff in jeder weitergeleiteten Nachricht wird <i>'Weiterleitung:'</i> sein, gefolgt vom ursprünglichen Betreff.",

   'original subject'
=> 'ursprünglicher Betreff',

   "sender's name"
=> "Name des Absenders",

   'Message begins with:'
=> 'Nachricht beginnt mit:',

   'Any new text to display before the text of the original messages:'
=> 'Beliebiger neuer Text, der vor dem Text der Originalnachricht angezeigt werden soll:',

   'username1:domain1: text'
=> 'Benutzername1:Domäne1: Text',

   'username2:domain2: text'
=> 'Benutzername2:Domäne2: Text',

   'username3:domain3: text'
=> 'Benutzername3:Domäne3: Text',

   "The messages will be assembled from all lines with the respective\n<tt>username:domain</tt>, and appended to the general message text."
=> "Die Nachrichten werden aus allen Zeilen des jeweiligen Benutzers <tt>Benuterzname:Domäne</tt> zusammengestellt\nund zum allgemeinen Nachrichtentext hinzugefügt.", # ???

   'Not allowed'
=> 'Nicht zulässig',

   'Archived Message'
=> 'Archivierte Nachrichten',

   '[quant,_1,communication blocking period was,communication blocking periods were] removed.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] entfernt.',

   '[quant,_1,communication blocking period was,communication blocking periods were] modified.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] geändert.',

   '[quant,_1,communication blocking period was,communication blocking periods were] added.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] hinzugefügt.',

   'You attempted to display a message that is currently blocked because you are enrolled in one or more courses for which there is an ongoing online exam.'
=> 'Sie haben versucht eine Nachricht anzuzeigen, die momentan gesperrt ist, da Sie einen oder mehre Kurse belegen, in denen eine Online-Prüfung stattfindet.',

   'Reply To'
=> 'Antwort an',

   'Current attempts of student (if applicable)'
=> 'Derzeitige Versuche des Studenten (falls verfügbar)',

   'Current screen output (if applicable)'
=> 'Derzeitige Bildschirmausgabe (falls verfügbar)',

   'No saved comments yet.'
=> 'Bisher keine gespeicherten Kommentare.',

   'No saved comments yet for this resource.'
=> 'Bisher keine gespeicherten Kommentare für diese Ressource.',

   'Could not deliver message'
=> 'Nachricht konnte nicht zugestellt werden.',

   'Please use the browser "Back" button and correct the recipient addresses ([_1]).'
=> 'Bitte verwenden Sie den Zurück-Button des Webbrowsers und korrigieren Sie die Empfängeradressen ([_1]).',

   'Failed to delete the message.'
=> 'Löschen der Nachricht ist fehlgeschlagen.',

   'Marked [_1] message(s) read'
=> '[_1] Nachricht(en) als gelesen markiert',

   'Marked [_1] message(s) Unread'
=> '[_1] Nachricht(en) als ungelesen markiert',

   'Destination folder [_1] is not a valid folder'
=> 'Bei dem Zielverzeichnis [_1] handelt es sich um kein gültiges Verzeichnis.',

   'Failed to move [_1] message(s)'
=> '[_1] Nachricht(en) konnte(n) nicht verschoben werden.',

   'Moved [_1] message(s)'
=> '[_1] Nachricht(en) wurde(n) verschoben.',

   'Failed to delete [_1] message(s)'
=> '[_1] Nachricht(en) konnte(n) nicht gelöscht werden.',

   'Deleted [_1] message(s)'
=> '[_1] Nachricht(en) wurde(n) gelöscht.',

   '[quant,_1,message] forwarded.'
=> '[quant,_1,Nachricht,Nachrichten] weitergeleitet.',

   'Could not forward [quant,_1,message].'
=> '[quant,_1,Nachricht,Nachrichten] konnte nicht nicht weitergeleitet werden.',

   'Could not deliver forwarded message.'
=> 'Weitergeleitetet Nachricht konnte nicht zugestellt werden.',

   'The recipient addresses may need to be corrected'
=> 'Die Empfängeradressesn mussen korrigiert werden',

   'Mail folder "[_1]" created.'
=> 'Das Nachrichtenverzeichnis "[_1]" wurde angelegt.',

   'Creation failed.'
=> 'Anlegen fehlgeschlagen.',

   'Mail folder "[_1]" deleted.'
=> 'Das Nachrichtenverzeichnis "[_1]" wurde gelöscht.',

   'Deletion failed.'
=> 'Löschen fehlgeschlagen.',

   'Mail folder "[_1]" renamed "[_2]".'
=> 'Das Nachrichtenverzeichnis "[_1]" wurde umbenannt in "[_2]".',

   'Renaming failed.'
=> 'Umbenennen fehlgeschlagen.',

   'Messages'
=> 'Nachrichten',

   'Distribute from Uploaded File'
=> 'Hochgeladene Datei verteilen', # ???

   'Communication Blocking'
=> 'Kommunikationssperre',

   'Communication blocking during scheduled exams'
=> 'Kommunikationssperre während zeitgebundener Prüfungen',

   'You can use communication blocking to prevent students enrolled in this course from displaying LON-CAPA messages sent by other students during an online exam. As blocking of communication could potentially interrupt legitimate communication between students who are also both enrolled in a different LON-CAPA course, please be careful that you select the correct start and end times for your scheduled exam when setting or modifying these parameters.'
=> 'Sie können Kommunikationssperren verwenden, um Studenten dieses Kurses die Anzeige von LON-CAPA-Nachrichten von anderen Studenten zu verwehren, während eine Online-Prüfung stattfindet. Da eine Kommunikationssperre auch mögliche zulässige Kommunikation zwischen Studenten verhindert, die auch andere LON-CAPA-Kurse belegen, seien Sie bitte entsprechend vorsichtig. Achten Sie auf die richtigen Start- und Endezeiten für Ihre zeitgebundenen Prüfungen, wenn Sie diese Parameter einstellen oder ändern.',

   'Modify existing communication blocking periods'
=> 'Bestehende Kommunikationssperren ändern',

   'No communication blocks currently saved'
=> 'Derzeit sind keine Sperren eingerichtet.',

   'Duration'
=> 'Dauer',

   'Event'
=> 'Veranstaltung',

   'Blocked?'
=> 'Gesperrt wird...',

   'Add block'
=> 'Sperre hinzufügen',

   'e.g., Exam 1'
=> '(z.B. Eingangstest)',

   'Discussion'
=> 'Diskussionsforen',

   'The following changes were made'
=> 'Folgende Änderungen wurden vorgenommen:',

   'Add new communication blocking periods'
=> 'Neue Kommunikationssperre hinzufügen',

   'Set by'
=> 'Ersteller',

   'Deleted Message'
=> 'Gelöschte Nachrichten',

   'Marked Messages Read'
=> 'Nachrichten als gelesen gekennzeichnet',

   'Marked Messages Unread'
=> 'Nachrichten als ungelesen gekennzeichnet',

   'Moved Messages'
=> 'Nachrichten verschoben',

   'Deleted Messages'
=> 'Nachrichten gelöscht',

   'Marked Message as Unread'
=> 'Nachrichten als ungelesen gekennzeichnet',

   'Deleted Folder'
=> 'Verzeichnis gelöscht',

   'Renamed Folder'
=> 'Verzeichnis umbenannt',

   'username:domain,username:domain,...'
=> 'Benutzername:Domäne,Benutzername:Domäne,...',

   'All courses'
=> 'Alle Kurse',

   'Pick specific course(s):'
=> 'Bestimmte(n) Kurs(e) verwenden:',

   'Search for a course in the [_1] domain'
=> 'Kurs-Suche in der Domäne der [_1]',

   'Actions available after searching for a course:'
=> 'Verfügbare Aktionen nach der Suche eines Kurses:',

   'Although almost all course settings can be modified by a [_1], a number of settings exist which only a [_2] may change:'
=> 'Der [_1] kann beinahe alle Kurs-Einstellungen vornehmen. Einige Einstellungen darf jedoch nur ein [_2] ändern:',

   "Certain settings which control auto-enrollment of students from your institution's student information system."
=> "Bestimmte Einstellungen, die die automatische Kursbelegung für Studierende steuern",

   'The total disk space allocated for storage of portfolio files in all groups in a course.'
=> 'Der Gesamtspeicherplatz für die Portfolio-Dateien aller Gruppen im Kurs',

   'No existing sections'
=> '(Keine Sektionen vorhanden)', # n.t.

   'Broadcast e-mail to users'
=> 'Broadcast-Nachricht an Benutzer',

   'Broadcast E-mail'
=> 'Broadcast-Nachricht',

   'Broadcast e-mail to Domain'
=> 'Broadcast-Nachricht an Domäne',

   'Send a new e-mail message to selected users from this domain'
=> 'Senden einer neuen Nachricht an ausgewählte Benutzer dieser Domäne',

   'Display e-mail sent by Domain Coordinators in this domain'
=> 'Anzeige von Domänen-Koordinatoren gesendeter Nachrichten in dieser Domäne',

   'Select Audience'
=> 'Empfängerkreis auswählen',

   'Choose e-mail audience'
=> 'Empfängerkreis auswählen',

   'Roles:'
=> 'Rollen:',

   'Courses:'
=> 'Kurse:',

   '[_1] selected.' # n.t.
=> '[_1] ausgewählt',

   'Access status:'
=> 'Zugriffsstatus:',

   'Username -> Email conversion:'
=> 'Benutzername -> E-Mail-Konvertierung:',

   'Building valid e-mail address from username, if missing from preferences:'
=> 'Erstellung einer gültigen E-Mail-Adresse aus dem Benutzernamen, falls Voreinstellungen fehlen:',

   'Kerberos: enter default for each realm used in the domain, with comma separation of entries'
=> 'Kerberos: Geben Sie die Voreinstellung für jeden Bereich in der Domäne ein, getrennt durch Kommata',

   '(e.g., MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).'
=> '(z.B. MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).',

   'Internal, Filesystem and Local authentication: enter single default.'
=> 'LON-CAPA-interne, Dateisystem- oder lokale Authentifizierung: Geben Sie eine einzelne Voreinstellung ein.',

   'Authentication Method'
=> 'Authentifizierungsmethode',

   'Username -> e-mail conversion'
=> 'Benutzername -> E-Mail-Konvertierung',

   'Internal (LON-CAPA)'
=> 'LON-CAPA-intern',

   'username@'
=> 'Benutzername@',

   'Local/Customized'
=> 'Lokal/benutzerdefiniert',

   'Filesystem (UNIX)'
=> 'Dateisystem (UNIX)',

   'Compose Message'
=> 'Nachricht erstellen',

   'No recipients identified'
=> 'Keine Empfänger gefunden',

   'Broadcast e-mail display options'
=> 'Anzeigeoptionen für Broadcast-Nachricht',

   'Date range:'
=> 'Zeitraum:',

   'Earliest to display:'
=> 'Frühester Zeitpunkt:',

   'Latest to display:'
=> 'Spätester Zeitpunkt:',

   'Choose sender(s):'
=> 'Auswahl des/der Sender:',

   'Display e-mail'
=> 'Nachrichten anzeigen',

   'E-mail display'
=> 'Nachrichten-Anzeige',

   'Display Broadcast e-mail'
=> 'Anzeige Broadcast-Nachrichten',

   'No mail sent matching supplied criteria'
=> 'Es wurde keine Nachricht gesendet, auf die die Suchkriterien zutreffen.',

   'Customrole'
=> 'Benutzerdefinierte Rolle',

   'Defined by [_1] at [_2].'
=> 'Festgelegt durch [_1] in [_2].',

   'No students found.'
=> 'Keine Studenten gefunden.',

   'Expired'
=> 'Abgelaufen',

   'Spreadsheet'
=> 'Beurteilungsbogen',

   'Spreadsheet Help'
=> 'Hilfe zu Beurteilungsbögen',

   'Editing Help'
=> 'Eingabehilfe',

   'Help on printing'
=> 'Hilfe zum Drucken',

   'Metadata Diffs'
=> 'Metadaten-Unterschiede',

   'Retrieve Metadata'
=> 'Alte Metadaten abrufen',

   'Enter course'
=> 'Kurs betreten',

   'Enter Course'
=> 'Kurs betreten',

   'Enter Access Key to Unlock this Course'
=> 'Eingabe des Zugriffsschlüssels zum Entsperren des Kurses',

   'Verifying Access Key to Unlock this Course'
=> 'Überprüfung des Zugriffsschlüssels, um Kurs zu entsperren',

   'Successfully registered key'
=> 'Schlüssel erfolgreich registriert',

   'Re-Enter Key'
=> 'Schlüssel erneut eingeben',

   'Assigned from [_1] at [_2] for [_3]'
=> 'Zugewiesen am [_2] von [_1] an [_3]',

   'Total Matches'
=> 'Gesamtanzahl Treffer',

   'Time Remaining'
=> 'Verbleibende Zeit',

   'IMPORT'
=> 'Importieren',

   'Help on slots'
=> 'Hilfe zu Slots',

   'New user accounts in [_1]'
=> 'Neue Benutzeraccounts in [_1]',

   'Student enrollment changes in [_1]'
=> 'Änderungen der studentischen Kursbelegung in [_1]',

   'The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:'
=> 'Die [quant,_1,folgende Änderung trat,folgenden Änderungen traten] im Kurs [_2] - [_3] auf. Auslöser war der automatische Prozess zur Aktualisierung von Kursteilnehmerlisten.',

   'No institutional classlist data could be retrieved for [_1]'
=> 'Für [_1] konnte keine institutionelle Kursteilnehmerliste abgerufen werden.',

   'Not within time window for auto-enrollment in [_1]'
=> '[_1] befindet sich nicht innerhalb des Zeitfensters der automatischen Kursbelegung.',

   'Auto-enrollment not currently enabled for [_1]'
=> 'Für [_1] ist die automatische Kursbelegung derzeit nicht aktiviert.',

   'The courseID provided does not match a course in this domain.'
=> 'Die gewählte Kurs-ID gehört zu keinem Kurs in dieser Domäne.',

   'Not Open'
=> 'Derzeit kein Zugriff',

   "This resource currently isn't open. It will be available at [_1]."
=> "Auf diese Ressource darf momentan nicht zugegriffen werden. Sie wird ab [_1] verfügbar sein.",

   'Could not handle ambiguous resource reference'
=> 'Doppeldeutige Ressourcenreferenz',

   'The nature of the problem is unclear'
=> 'Die Fehlerursache ist unklar.',

   'Course Roster'
=> 'Kursteilnehmerliste',

   'Classlist'
=> 'Kursteilnehmerliste',

   'Display of a student-viewable course roster is not currently enabled.'
=> 'Die Anzeige der studenteneinsehbaren Kursteilnehmerliste ist derzeit deaktiviert.',

   'Student-viewable course roster'
=> 'Studenteneinsehbare Kursteilnehmerliste',

   'Students with no section'
=> 'Studenten in keiner Sektion',

   'Students in section "[_1]"'
=> 'Studenten in Sektion "[_1]"',

   'Students in any section'
=> 'Studenten in beliebiger Sektion',

   'Only students who have opted to be listed in the roster ([_1] out of [_2] students) are shown.'
=> 'Es werden nur Studenten angezeigt, die der Auflistung in der Kursteilnehmerliste zugestimmt haben (derzeit [_1] von insgesamt [_2]).',

   'The single student without a section[_1] has opted not to be listed in the roster.'
=> 'Der einzelne Student ohne Sektionszugehörigkeit[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'The single student in the section[_1] has opted not to be listed in the roster.'
=> 'Der einzelne Student in der Sektion[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'The single student in the course[_1] has opted not to be listed in the roster.'
=> 'Der einzelne Student im Kurs[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'None of the [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studenten ohne Sektionszugehörigkeit[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'None of the [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studenten in der Sektion[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'None of the [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studenten im Kurs[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studenten ohne Sektionszugehörigkeit[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studenten in der Sektion[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studenten im Kurs[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student without a section[_1] has opted to be listed in the roster.'
=> 'Der einzelne Student ohne Sektionszugehörigkeit[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student in the section[_1] has opted to be listed in the roster.'
=> 'Der einzelne Student in der Sektion[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student in the course[_1] has opted to be listed in the roster.'
=> 'Der einzelne Student im Kurs[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students without a section[_2] are listed in the roster.'
=> 'Alle [_1] Studenten ohne Sektionszugehörigkeit[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'All [_1] students in the section[_2] are listed in the roster.'
=> 'Alle [_1] Studenten in der Sektion[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'All [_1] students in the course[_2] are listed in the roster.'
=> 'Alle [_1] Studenten im Kurs[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'There is only a single student without a section[_1]'
=> 'Es gibt nur einen einzelnen Studenten ohne Sektionszugehörigkeit[_1].',

   'There is only a single student in the section[_1]'
=> 'Es gibt nur einen einzelnen Studenten in der Sektion[_1].',

   'There is only a single student in the course[_1]'
=> 'Es gibt nur einen einzelnen Studenten im Kurs[_1].',

   'There are currently no students to display.'
=> 'Derzeit gibt es keine Studenten, die angezeigt werden könnten.',

   'Available Portfolio files'
=> 'Verfügbare Portfolio-Dateien',

   'Name not given'
=> 'Name nicht vorhanden',

   '[quant,_1,file,files,No files]'
=> '[quant,_1,Datei,Dateien,Keine Dateien]',

   'Error retrieving file information.'
=> 'Fehler beim Abrufen der Dateiinformationen',

   'Your roster setting'
=> 'Ihre Kursteilnehmerlisten-Einstellung',

   'You are currently listed in the student-viewable roster.'
=> 'Sie werden derzeit in der studenteneinsehbaren Kursteilnehmerliste aufgelistet.',

   'You are currently <b>not</b> listed in the student-viewable roster.'
=> 'Sie werden derzeit <b>nicht</b> in der studenteneinsehbaren Kursteilnehmerliste aufgelistet.',

   'Include yourself in the roster?'
=> 'Möchten Sie in der Kursteilnehmerliste aufgelistet werden?',

   'Display of your name in the student-viewable roster set to <b>[_1]</b>.'
=> 'Anzeige Ihres Namens in der studenteneinsehbaren Kursteilnehmerliste auf <b>[_1]</b> gesetzt.',

   'Error occurred saving display setting.'
=> 'Es ist ein Fehler beim Speichern der Anzeige-Einstellungen aufgetreten.',

   'Display of your name in the student-viewable roster unchanged (set to <b>[_1]</b>).'
=> 'Anzeige Ihres Namens in der studenteneinsehbaren Kursteilnehmerliste bleibt unverändert (auf <b>[_1]</b> gesetzt).',

   'View course roster'
=> 'Kursteilnehmerliste',

   'Change Course Page Preferences'
=> 'Schnellzugriffsliste für Kurse',

   'Change Course Page Pref'
=> 'Schnellzugriffsliste für Kurse',

   'No context.'
=> 'Kein Kontext.',

   'unable to verify variable URL'
=> 'variable URL konnte nicht überprüft werden',

   'Receipt'
=> 'Empfangsbestätigung',

   'Problems during Course Initialization'
=> 'Probleme während der Kursinitialisierung',

   'Try Selecting Again'
=> 'Auswählen erneut versuchen',

   '<br />Invalid map: <tt>[_1]</tt>'
=> '<br />Ungültige Inhaltszusammenstellung: <tt>[_1]</tt>',

   'Please either [_1]close this window[_2] or [_3]log in again[_4].'
=> 'Bitte entweder [_1]dieses Fenster schließen[_2] oder [_3]erneut anmelden[_4].',

   'Thank you for using LON-CAPA.'
=> 'Vielen Dank, dass Sie LON-CAPA verwenden.',

   'You have been successfully logged out.'
=> 'Sie wurden erfolgreich abgemeldet.',

   'You can [_1]close this window[_2] now.'
=> 'Sie können [_1]dieses Fenster jetzt schließen[_2].',

   '[_1]Log in again[_2]'
=> '[_1]Erneut anmelden[_2]',

   'You did not fill in enough information for the search to be started.  You need to fill in relevant fields on the search page in order for a query to be processed.'
=> 'Die Suche kann nicht durchgeführt werden, da Sie nicht genügend Daten angegeben haben. Sie müssen auf der Suchseite relevante Felder ausfüllen, damit Ihre Anfrage verarbeitet werden kann.',

   'conditionally hidden'
=> 'Bedingungsabhängig verborgen',

   'Problem Parameters'
=> 'Aufgabenparameter',

   'No group name provided.'
=> 'Es wurde kein Gruppenname angegeben.',

   'Invalid group name provided.'
=> 'Es wurde ein ungültiger Gruppenname angegeben.',

   'Invalid [_1]'
=> '[_1] ist ungültig', # ???

   '"[_1]" is not the name of a valid group in this [_2].'
=> '"[_1]" ist kein gültiger Name für ein Gruppe in dieser [_2].',

   'You do not have privileges to view the membership roster in this group.'
=> 'Sie haben für diese Gruppe nicht die Berechtigung, die Kursteilnehmerliste einzusehen.',

   'Group membership status - [_1]'
=> 'Gruppen-Mitgliedschaftsstatus: [_1]',

   'group membership status - [_1]'
=> 'Gruppen-Mitgliedschaftsstatus: [_1]',

   'There are no membership data to display for this group.'
=> 'Für diese Gruppe existieren keine anzeigbaren Mitgliedsdaten.',

   'Membership status: '
=> 'Mitgliedschaftsstatus: ',

   'There are no groups to display in this [_1].'
=> 'Es gibt keine Gruppen, die in diesem [_1] angezeigt werden können.', # ??? -> grouproster.pm

   'Start Date'
=> 'Anfangsdatum',

   'End Date'
=> 'Endedatum',

   'Functionality'
=> 'Funktionalität',

   'Privileges'
=> 'Berechtigungen',

   'Any Membership status'
=> 'Beliebiger Mitgliedsstatus',

   'Active Member'
=> 'Aktives Mitglied',

   'Former Member'
=> 'Ehemaliges Mitglied',

   'Future Member'
=> 'Zukünftiges Mitglied',

   'Group Folder - [_1]'
=> 'Gruppenverzeichnis für [_1]',

   'Group homepage - [_1]'
=> 'Gruppen-Homepage für [_1]',

   'A support request has been sent to'
=> 'Eine Support-Anfrage wurde gesendet an',

   'Your support request contained the following information'
=> 'Ihre Support-Anfrage enthält folgende Daten',

   'The following Cc e-mail address is invalid: '
=> 'Die folgende CC-E-Mail-Adresse is ungültig: ',

   'The following Cc e-mail addresses are invalid: '
=> 'Die folgende CC-E-Mail-Adressen sind ungültig: ',

   'As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has <b>not</b> been sent to the LON-CAPA support staff or administrator at your institution.'
=> 'Da die für diesen LON-CAPA-Server angegebene E-Mail-Adresse ([_1]) anscheinend ungültig ist, wurde Ihre Support-Anfrage <b>nicht</b> an das LON-CAPA-Supportteam Ihrer Institution und auch nicht an den Adminstrator geschickt.',

   'Instead a copy has been sent to the LON-CAPA support team at Michigan State University.'
=> 'Stattdessen wurde eine Kopie an das LON-CAPA-Supportteam der Michigan State University gesendet.',

   'The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.'
=> 'Die hochgeladene Screenshot-Datei Ihrer Anfrage hat die maximale Größe von 128 KB überschritten ([_1] Bytes) und wurde daher nicht verworfen.',

   'An uploaded screenshot file \'[_1]\' ([_2] bytes) was included in the request sent by [_3].'
=> 'Eine hochgeladene Screenshot-Datei \'[_1]\' ([_2] Bytes) wurde der Anfrage beigefügt, die von [_3] gesendet wurde.',

   'File does not have [_1] or [_2] starting tag'
=> 'Die Datei hat weder ein [_1]- noch ein [_2]-Start-Tag',

   'File does not have [_1] or [_2] ending tag'
=> 'Die Datei hat weder ein [_1]- noch ein [_2]-Ende-Tag',

   'Example'
=> 'Beispiel',

   'Algebraic Response Problems'
=> 'Algebraische Aufgaben',

   'Chemistry Problems'
=> 'Chemische Aufgaben',

   'Free Form Problems'
=> 'Aufgaben mit freier Gestaltung',

   'Handgraded Problems'
=> 'Manuell bewertete Aufgaben',

   'Miscellaneous'
=> 'Verschiedenes',

   'Multiple Choice Problems'
=> 'Auswahl-Aufgaben',

   'Numerical Problems'
=> 'Numerische Aufgaben',

   'Language:'
=> 'Sprache:',

   'Math Rendering:'
=> 'Formeldarstellung:',

   'Restrict Domain Coordinator Access'
=> 'Zugriff durch Domänen-Koordinator',

   'By default, the Domain Coordinator can enter your construction space.'
=> 'Die Voreinstellung erlaubt dem Domänen-Koordinator, Ihren Konstruktionsbereich betreten zu können.',

   'Block access to construction space'
=> 'Zugriff auf Konstruktionsbereich verwehren',

   'jsMath'
=> 'jsMath',

   'tth (TeX to HTML)'
=> 'tth (TeX nach HTML)',

   'mimetex (Convert to Images)'
=> 'mimetex (In Grafik konvertieren)',

   'jsMath:'
=> 'jsMath:',

   'tth (TeX to HTML):'
=> 'tth (TeX nach HTML):',

   'mimetex (Convert to Images):'
=> 'mimetex (In Grafik konvertieren):',

   '[_1], [_2], or [_3]'
=> '[_1], [_2] oder [_3]',

   'internal, optional'
=> 'intern, optional',

   'user:domain,user:domain,...'
=> 'Benutzer:Domäne,Benutzer:Domäne,...',

   'user:domain,user:domain(section;section;...;*;...),...'
=> 'Benutzer:Domäne,Benutzer:Domäne(Sektion;Sektion;...;*;...),...',

   'user:domain,user:domain,*:domain'
=> 'Benutzer:Domäne,Benutzer:Domäne,*:Domäne',

   'Course members with current access'
=> 'Kursteilnehmer mit aktuellem Zugriff',

   'Course members with expired access'
=> 'Kursteilnehmer mit abgelaufenen Zugriff',

   'Course members with future access'
=> 'Kursteilnehmer mit zukünftigem Zugriff',

   'Other Roles'
=> 'Weitere Rollen',

   'Select Author'
=> 'Autor auswählen',

   'Non-standard Course'
=> 'Nicht-Standard-Kurs',

   'Switch course role to...'
=> 'Kursrolle wechseln...',

   'Message'
=> 'Nachricht',

   'Time of change'
=> 'Änderungszeit',

   'active'
=> 'aktiv',

   'previous'
=> 'in der Vergangenheit liegend',

   'Access dates to apply for selected users'
=> 'Zugriffszeiten für die ausgewählten Benutzer ändern',

   'Changes in section affiliation to apply to selected users'
=> 'Sektionszugehörigkeiten für die ausgewählten Benutzer ändern',

   'For student roles changing the section, will result in a section switch as students may only be in one section of a course at a time.'
=> 'Ein Sektionswechsel bei studentischen Rollen verursacht einen Austausch der Sektion, da Studierende nur in einer einzigen Sektion eines Kurses zur gleichen Zeit sein können.',

   'For a role in a course that is not a student role, a user may have roles in more than one section of a course at a time.'
=> 'Benutzer mit einer Kursrolle, die keine studentische Rolle ist, können in mehr als einer Sektion in einem Kurs zur gleichen Zeit sein.',

   "Retain each user's current section affiliations?"
=> "Retain each user's current section affiliations?", # ???

   '(Does not apply to student roles).'
=> '(Betrifft nicht Studentenrollen).',

   '[_1]Show[_2] clicker id'
=> 'Clicker-ID [_1]anzeigen[_2]',

   '[_1]Hide[_2] clicker id'
=> 'Clicker-ID [_1]verbergen[_2]',

   'Catalog:'
=> 'Katalog:',

   'Main Categories'
=> 'Hauptkategorien',

   'Official courses (with institutional codes)'
=> 'Offizielle Kurse (mit institutionellen Codes)',

   'Official courses'
=> 'Offizielle Kurse',

   'with institutional codes'
=> 'mit institutionellen Codes',

   'Self-enroll (if permitted)'
=> 'Selbsteintragung (falls zugelassen)',

   'Self-enrollers:'
=> 'Selbsteintragungen:',

   'Choices:'
=> 'Auswahlmöglichkeiten:',

   'Configure User Self-enrollment'
=> 'Selbsteintragung konfigurieren',

   'View Change Logs'
=> 'Änderungsprotokoll', # long version: Änderungsprotokoll betrachten

   'View Log-in History'
=> 'Anmeldehistorie', # longversion: Anmeldehistorie betrachten

   'Configure Self-enrollment'
=> 'Selbsteintragung konfigurieren',

   'Self-enrollment with a student role'
=> 'Selbsteintragungen mit studentischer Rolle',

   'Users allowed to self-enroll in this course'
=> 'Zugelassene Benutzer, die sich in den Kurs selbst eintragen dürfen',

   'Any user in any domain:'
=> 'Beliebige Nutzer in beliebiger Domäne',

   'User types:'
=> 'Benutzertypen',

   'any'
=> 'beliebig',

   'Any Users'
=> 'Beliebige Benutzer',

   'Any users'
=> 'Beliebige Benutzer',

   'Others'
=> 'Andere',

   'Additional domain:'
=> 'Zusätzliche Domäne:',

   'Users in additional domain:'
=> 'Benutzer in zusätzlicher Domäne:',

   'Specific domain:'
=> 'Bestimmte Domäne:',

   'Users in specific domain:'
=> 'Benutzer in bestimmter Domäne:',

   'Other domain:'
=> 'Andere Domäne:',

   'Users in other domain:'
=> 'Benutzer in anderer Domäne:',

   'Restrict self-enrollment to students officially registered for the course'
=> 'Selbsteintragung auf für diesen Kurs offiziell registrierte Studenten beschränken',

   'Dates self-enrollment available'
=> 'Zeitraum für Selbsteintragung',

   'Starts'
=> 'Startet',

   'Ends'
=> 'Endet',

   'Course access dates assigned to self-enrolling users'
=> 'Kurszugriffszeiten für selbsteintragende Benutzer',

   'Section assigned to self-enrolling users'
=> 'Den selbsteintragenen Benutzern zuzuweisende Sektion',

   'The following changes were made to self-enrollment settings:'
=> 'Folgende Änderungen wurden an den Einstellungen zur Selbsteintragung vorgenommen:',

   '[_1]: "[_2]" set to "[_3]".'
=> '[_1]: "[_2]" geändert. Neuer Wert: "[_3]".',

   '"[_1]" set to "[_2]".'
=> '"[_1]" geändert. Neuer Wert: "[_2]".',

   'No changes were made to the existing self-enrollment settings in this course.'
=> 'An den Einstellungen zur Selbsteintragung für diesen Kurs wurden keine Änderungen vorgenommen.',

   'Self-enrollment result'
=> 'Ergebnis Selbsteintragung',

   'Enroll in course'
=> 'Diesen Kurs belegen',

   'Self-enroll in course'
=> 'Kurse selbst belegen',

   'Self-enroll in a LON-CAPA course'
=> 'Selbsteintragung in einen LON-CAPA-Kurs',

   'Self-enroll'
=> 'Selbsteintragung',

   'Self-enroll in [_1]'
=> 'Selbsteintragung in [_1]',

   'Self-enrollment error'
=> 'Fehler bei der Selbsteintragung',

   'Invalid domain or course number'
=> 'Ungültige Domäne oder Kursnummer',

   'Self-enrollment unavailable'
=> 'Selbsteintragung nicht verfügbar',

   'Self-enrollment is restricted to students officially registered for this course.'
=> 'Die Selbsteintragung ist auf Studenten begrenzt, die offiziell für diesen Kurs registriert sind.',

   'Self-enrollment is not currently available for this course.'
=> 'Die Selbsteintragung ist für diesen Kurs derzeit nicht verfügbar.',

   'Self-enrollment is not currently available in this course'
=> 'Die Selbsteintragung ist für diesen Kurs derzeit nicht verfügbar.',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users.'
=> 'Die Selbsteintragung wird am [_1] für alle LON-CAPA-Nutzer verfügbar werden.',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users at your institution ([_2]).'
=> 'Die Selbsteintragung wird am [_1] für alle LON-CAPA-Nutzer Ihrer Einrichtung ([_2]) verfügbar werden.',

   'Self-enrollment will become available starting [_1]; please enroll at that time.'
=> 'Die Selbsteintragung wird am [_1] verfügbar werden. Bitte tragen Sie sich ab dann selbst ein.',

   'Although self-enrollment will become available starting [_1], you are ineligible for enrollment.'
=> 'Die  Selbsteintragung wird zwar am [_1] verfügbar werden, Ihnen ist es allerdings nicht gestattet sich selbst einzutragen.',

   'Self-enrollment will become available starting [_1].'
=> 'Die Selbsteintragung wird am [_1] verfügbar werden.',

   'The link to the requested page could not be followed.'
=> 'Die Verknüpfung zu der angeforderten Seite konnte nicht aufgerufen werden.',

   'The placeholder for the courseID is absent.'
=> 'Der Platzhalter für die Kurs-ID ist fehlt.',

   'LON-CAPA account required'
=> 'LON-CAPA-Account notwendig',

   'You need to be logged into LON-CAPA to self-enroll in a course.'
=> 'Sie müssen in LON-CAPA angemeldet sein, um sich in diesen Kurs selbst eintragen zu können.',

   'If you have an account in LON-CAPA, [_1]log-in[_2].'
=> 'Falls Sie einen LON-CAPA-Account haben, [_1]melden Sie sich bitte an[_2].',

   'Otherwise:'
=> 'Ansonsten:',

   "if you have an institutional log-in, use your institution's [_1]single sign on page[_2] to log-in, then create an account"
=> "Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, verwenden Sie Ihre institutionelle [_1]Single-Sign-On-Seite[_2], um sich anzumelden. Erzeugen Sie dann einen Account",

   'if you have an institutional login, [_1]create an account[_2]'
=> 'Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, [_1]erstellen Sie einen Account[_2]',

   'you can use an e-mail address to [_1]create an account[_2]'
=> 'Sie können eine E-Mail-Adresse verwenden, um [_1]einen Account zu erstellen[_2]',

   'Otherwise, if you have an institutional login, [_1]create an account[_2].'
=> 'Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, [_1]erstellen Sie einen LON-CAPA-Account[_2].',

   'Otherwise, you will use an e-mail address to [_1]create an account[_2].'
=> 'Ansonsten verwenden Sie eine E-Mail-Adresse, um [_1]einen Account zu erstellen[_2].',

   "Otherwise, use your institution's [_1]single sign on page[_2] to log-in, then create an account."
=> "Ansonsten verwenden Sie Ihre institutionelle [_1]Single_Sign_On-Seite[_2], um sich anzumelden und erstellen Sie dann einen Account.",

   'You will be able to self enroll in this course once the account has been created.'
=> 'Sie haben die Möglichkeit sich selbst in den Kurs einzutragen, nachdem der Account erzeugt wurde.',

   'You will be able to self-enroll in the course you selected ([_1]) after you have successfully logged in.'
=> 'Sie haben die Möglichkeit sich selbst in den gewählten Kurs ([_1]) einzutragen, nachdem Sie sich erfolgreich angemeldet haben.',

   'You must [_1]log-in[_2] to LON-CAPA with an existing account to be able to enroll in this course, as account creation at this institution ([_3]) is not permitted when self-enrolling.'
=> 'Sie müssen sich in LON-CAPA mit einem bestehenden Account [_1]anmelden[_2], um sich in diesen Kurs eintragen zu können. Das Erstellen von Benutzeraccounts an dieser Einrichtung ([_3]) ist im Zuge der Selbsteintragung nicht gestattet.',

   'You already have an active student role (section: "[_1]") in this course.'
=> 'Sie haben in diesem Kurs bereits eine aktive studentische Rolle (Sektion "[_1]").',

   'You have a student role (section: "[_1]") in this course which will become active [_2].'
=> 'Sie haben in diesem Kurs (Sektion "[_1]") eine studentische Rolle, die am [_2] aktiv wird.',

   'Self-enrollment is restricted to officially registered students.'
=> 'Selbsteintragung ist auf offiziell registrierte Studenten beschränkt.',

   'As you are not currently registered for this course, self-enrollment is unavailable.'
=> 'Da Sie derzeit für diesen Kurs nicht registriert sind, ist die Selbsteintragung nicht verfügbar.',

   'The end date for access to this course for users who self-enroll has passed.'
=> 'Das Endedatum für den Zugriff auf diesen Kurs ist für Benutzer, die sich selbst eintragen können, abgelaufen.',

   'Consequently, although a new role was created for you in the course, it is an inactive role which does not provide access to the course.'
=> 'Das hat zur Folge, dass Ihre Benutzerrolle eine inaktive Rolle ist, die keinen Zugriff auf den Kurs gewährt, obwohl die Rolle für Sie in dem Kurs neu erstellt wurde.',

   'Self-enrollment in this course was successful.'
=> 'Die Selbsteintragung für diesem Kurs war erfolgreich.',

   'The start date for access to this course for users who self-enroll has yet to be reached.'
=> 'Das Anfangsdatum für den Zugriff auf diesen Kurs ist für Benutzer, die sich selbst eintragen können, noch nicht erreicht.',

   'Consequently, although a new role was created for you in the course, you will not be able to select this role until [_1].'
=> 'Das hat zur Folge, dass Sie diese Rolle nicht bis zum [_1] auswählen können, obwohl eine neue Rolle in diesem Kurs für Sie erstellt wurde.',

   'Your new role is available immediately, and will provide access to the course until [_1].'
=> 'Ihre neue Rolle is ab sofort verfügbar und erlaubt Ihnen bis [_1] Zugriff auf den Kurs.',

   'Enrollment process complete'
=> 'Kursbelegung abgeschlossen',

   'Enrollment incomplete'
=> 'Kursbelegung unvollständig',

   'Self-enrollment in this course failed.'
=> 'Die Selbsteintragung in diesen Kurs ist fehlgeschlagen.',

   'You are not permitted to enroll yourself in this course.'
=> 'Es ist Ihnen nicht gestattet, sich in diesen Kurs selbst einzutragen.',

   'Enter course now'
=> 'Kurs jetzt betreten',

   'other'
=> 'andere',

   'Self-enrollment in this course is available to any user affiliated with [_1].'
=> 'Die Selbsteintragung in diesen Kurs ist für beliebige Benutzer der Einrichtung "[_1]" verfügbar.',

   'Self-enrollment in this course is only available to users in affiliated with [_1] who have the following status: "[_2]".'
=> 'Die Selbsteintragung in diesen Kurs ist nur für Benutzer der Einrichtung "[_1]" verfügbar, die folgenden Status haben: "[_2]".',

   'Self-enrollment is not currently available for this course for users affiliated with [_1].'
=> 'Die Selbsteintragung in diesen Kurs ist derzeit für Benutzer der Einrichtung "[_1]" nicht zulässig.',

   'Self-enrollment in this course is only available to users affiliated with the following institutions, and who have the required status:'
=> 'Die Selbsteintragung in diesen Kurs ist nur für Benutzer der folgenden Einrichtungen verfügbar, die den erforderlichen Status haben:',

   'Your registration status could not be verified.'
=> 'Ihr Registrierungsstatus konnte nicht überprüft werden.',

   'Your registration status could not determined, because a problem occurred retrieving data.'
=> 'Ihr Registrierungsstatus konnte nicht überprüft werden, da während des Datenabrufs ein Problem aufgetreten ist.',

   'As no institutional course sections are currently associated with this course, your registration status is undetermined.'
=> 'Da mit diesem Kurs keine institutionellen Kurssektionen verknüpft sind, ist Ihr Registrierungsstatus unbestimmt.',

   '[_1]Ad hoc[_2] roles in domain [_3] --'
=> '[_1]Ad-hoc[_2]-Rollen in der Domäne [_3] --',

   'Assemble resources'
=> 'Kursinhalt einrichten',

   'Create, edit, modify and publish resources'
=> 'Erstellen, Ändern und Veröffentlichen von Ressourcen',

   'Create, modify and delete course groups'
=> 'Erstellen, Ändern und Löschen von Kursgruppen',

   'View course groups'
=> 'Kursgruppen anzeigen',

   'View student activity'
=> 'Studentische Aktivitätsdaten anzeigen',

   'Show full details for each course ([_1] only)'
=> 'Alle Details für jeden Kurs zeigen (nur mit Benutzerrolle [_1] verfügbar)',

   'Include courses set to be hidden from catalog ([_1] only)'
=> 'Auch Kurse anzeigen, die im Kursüberblick als verborgen eingestellt sind (nur mit Benutzerrolle [_1] verfügbar)',

   'Include subcategories within "[_1]"'
=> 'Auch Unterkategorien von "[_1]" anzeigen',

   'Only show courses which allow self-enrollment'
=> 'Nur Kurse anzeigen, die Selbsteintragung zulassen',

   'include subdirectories'
=> 'Unterverzeichnisse mit einbinden',

   'force republication of previously published files'
=> 'Erneute Veröffentlichung bereits zuvor veröffentlichter Ressourcen erzwingen',

   'make file(s) obsolete'
=> 'Ressourcen als überholt markieren',

   'force directory level catalog information over existing'
=> 'Kataloginformationen des Verzeichnisses sollen bestehende Kataloginformationen überschreiben',

   'Session could not be opened.'
=> 'Die Sitzung konnte nicht gestartet werden.',

   'Student Settings'
=> 'Studentische Einstellungen',

   'Coordinator Settings'
=> 'Koordinatoren-Einstellungen',

   'Author Settings'
=> 'Autoren-Einstellungen',

   'Administrator Settings'
=> 'Administratoren-Einstellungen',

   'Item'
=> 'Element',

   'Found [_1] without responses. This resource cannot be published.'
=> 'Ressource vom Typ [_1] gefunden, die keinen Antwortblock enthält. Diese Ressource kann nicht veröffentlicht werden.',

   'LON-CAPA helpdesk'
=> 'LON-CAPA-Helpdesk',

   'Create a user account in LON-CAPA'
=> 'Neuen Benutzeraccount in LON-CAPA erstellen',

   'Account creation unavailable'
=> 'Account-Erstellung nicht möglich',

   'Error creating token.'
=> 'Fehler beim Erstellen eines Merkzeichens.',

   'Account creation'
=> 'Account-Erstellung',

   'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution: ([_1]).'
=> 'Das Erstellen eines Benutzeraccounts mit einer E-Mail-Adresse oder einem Benutzeraccount Ihrer Einrichtung als Benutzername ist an der Einrichtung [_1] nicht gestattet.',

   'Creation of a new LON-CAPA user account using an e-mail address or an institutional log-in ID as your username is not permitted at [_1].'
=> 'Das Erstellen eines LON-CAPA-Benutzeraccounts mit einer E-Mail-Adresse oder einem Benutzeraccount Ihrer Einrichtung als Benutzername ist an der Einrichtung [_1] nicht gestattet.',

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account in this domain."
=> "sie wurden zwar mit Ihrem Benutzernamen und Passwort durch das institutionelle Single-Sign-On-System korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Domäne.",

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution, and you are not permitted to create one."
=> "Sie wurden zwar mit Ihrem Benutzernamen und Passwort durch das institutionelle Single-Sign-On-System korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account an dieser Einrichtung und Sie sind nicht berechtigt, einen zu erstellen.",

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution."
=> "Sie wurden zwar mit Ihrem Benutzernamen und Passwort korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Einrichtung.",

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one."
=> "Sie wurden zwar mit Ihrem Benutzernamen und Passwort korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Domäne und Sie sind nicht berechtigt, einen zu erstellen.",

   'A LON-CAPA account may not be created with the username you use.'
=> 'Mit dem von Ihnen verwendeten Benutzernamen kann kein LON-CAPA-Account erzeugt werden.',

   'User Information'
=> 'Benutzerdaten',

   'Review user information'
=> 'Benutzerdaten bestätigen',

   'To create one, use the table below to provide information about yourself (if appropriate), then click the "Create LON-CAPA account" button.'
=> 'Um einen zu erstellen, verwenden Sie die untenstehende Tabelle, um Ihre persönliche Daten in die nicht ausgefüllten Felder einzutragen. Klicken Sie anschließend auf "LON-CAPA-Account erstellen".',

   'A user account will be created with information displayed in the table below, when you click the [_1]Create LON-CAPA account[_2] button.'
=> 'Durch Klicken auf [_1]LON-CAPA-Account erstellen[_2] wird mit den unten angezeigten Daten ein Benutzeraccount erzeugt.',

   'Confirmation'
=> 'Bestätigung',

   'Confirm that you wish to create an account.'
=> 'Bitte bestätigen Sie, dass Sie einen Account erzeugen möchten.',

   'New username'
=> 'Neuer Benutzername',

   'Create account'
=> 'Account anlegen',

   'You must enter a password'
=> 'Sie müssen ein Passwort angeben.',

   'The passwords you entered did not match.'
=> 'Die eingegebenen Passwörter stimmen nicht überein.',

   'Please try again.'
=> 'Bitte versuchen Sie es erneut.',

   'Create account with a username provided by this institution'
=> 'Erstellen eines LON-CAPA-Accounts mit einem Benutzeraccount dieser Einrichtung',

   'If you already have a log-in ID at this institution,[_1] you may be able to use it for LON-CAPA.'
=> 'Falls Sie bereits einen Benutzeraccount dieser Einrichtung haben,[_1] können Sie diesen gegebenenfalls für LON-CAPA verwenden.',

   'Type in your log-in ID and password to find out.'
=> 'Geben Sie Ihren Benutzeraccount Ihrer Einrichtung und Ihr Passwort ein, um dies herauszufinden.',

   'Log-in ID'
=> 'Benutzeraccount Ihrer Einrichtung',

   'Create account with an e-mail address as your username'
=> 'Erstellen eines Benutzeraccounts mit einer E-Mail-Adresse als Benutzername',

   'Provide your e-mail address to request a LON-CAPA account,[_1] if you do not have a log-in ID at your institution.'
=> 'Geben Sie Ihre E-Mail-Adresse an, um einen LON-CAPA-Account zu beantragen,[_1] falls Sie keinen Benutzeraccount Ihrer Einrichtung haben.',

   'Request LON-CAPA account'
=> 'LON-CAPA-Account anfordern',

   'Validation'
=> 'Gültigkeitsprüfung',

   'Thank you for your request to create a new LON-CAPA account.'
=> 'Vielen Dank für Ihren Antrag zur Erstellung eines neuen LON-CAPA-Accounts.',

   'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution:[_2].'
=> 'Ein Antrag zur Erstellung eines LON-CAPA-Accounts wurde am [_1] für die Einrichtung [_2] abgeschickt.',

   'To complete this process please open a web browser and enter the following URL in the address/location box: [_1]'
=> 'Um den Vorgang abzuschließen, öffnen Sie bitte einen Webbrowser und geben Sie folgende URL in die Adresszeile ein: [_1]',

   'A message has been sent to the e-mail address you provided.'
=> 'An die von Ihnen angegebene E-Mail-Adresse wurde eine Nachricht geschickt.',

   'The message includes the web address for the link you will use to complete the account creation process.'
=> 'Die Nachricht enthält einen Link, mit dem Sie den Erstellungsvorgang Ihres Accounts abschließen können.',

   'The link included in the message will be valid for the next [_1]two[_2] hours.'
=> 'Der in die Nachricht eingebundene Link ist für die nächsten [_1]zwei Stunden gültig[_2].',

   'An error occurred when sending a message to the e-mail address you provided.'
=> 'Beim Verschicken Ihrer Nachricht an die von Ihnen angegebene E-Mail-Adresse ist ein Fehler aufgetreten.',

   'An error occurred creating a token required for the account creation process.'
=> 'Beim Erstellen eines Merkzeichens, das für den Erstellungsvorgang des Accounts notwendig ist, ist ein Fehler aufgetreten.',

   'Please contact the [_1] ([_2]) for assistance.'
=> 'Nehmen Sie zur Klärung bitte mit [_1] ([_2]) Kontakt auf.',

   'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid.'
=> 'Die von Ihnen angegebene URL, um den Erstellungsvorgang eines neuen LON-CAPA-Accounts abzuschließen, ist ungültig. Entweder wurde das in der URL enthaltene Merkzeichen gelöscht oder die von Ihnen angegebene URL ist ungültig.',

   'Sorry, the token generated when you requested creation of an account has expired.'
=> 'Das Merkzeichen, das bei Ihrem Antrag zur Erstellung des Accounts generiert wurde, ist nicht mehr gültig.',

   'Sorry, the URL generated when you requested creation of an account contained incomplete information.'
=> 'Die URL, die bei Ihrem Antrag zur Erstellung des Accounts generiert wurde, enthält unvollständige Daten.',

   'Please submit a [_1]new request[_2] for account creation and follow the new link included in the e-mail that will be sent to you.'
=> 'Bitte stellen Sie einen [_1]erneuten Antrag[_2] zur Erstellung eines Accounts und folgen Sie dem neuen Link, der Ihnen per E-Mail zugesandt werden wird.',

   'A LON-CAPA account for the institution: [_1] has been created [_2] from IP address: [_3].  If you did not perform this action or authorize it, please contact the [_4] ([_5]).'
=> 'Am [_2] wurde für die Einrichtung [_1] von der IP-Adresse [_3] ein LON-CAPA-Account erzeugt. Falls Sie diese Anforderung nicht ausgeführt oder beauftragt hatten, nehmen Sie bitte mit [_4] ([_5]) Kontakt auf.',

   'A LON-CAPA account already exists for username [_1] at this institution ([_2]).'
=> 'Für den Benutzer [_1] exisitiert bereits ein LON-CAPA-Account an der Einrichtung [_2].',

   'The password entered was also correct so you have been logged in.'
=> 'Das von Ihnen eingegebene Passwort war korrekt, so dass Sie angemeldet wurden.',

   'Authentication failed'
=> 'Authentifizierung fehlgeschlagen',

   'An e-mail confirming creation of your new LON-CAPA account has been sent to [_1].'
=> 'Eine E-Mail zur Bestätigung der Erstellung Ihres neuen LON-CAPA-Accounts wurde an [_1] gesendet.',

   'An error occurred when sending e-mail to [_1] confirming creation of your LON-CAPA account.'
=> 'Beim Versenden der E-Mail zur Bestätigung der Erstellung Ihres neuen LON-CAPA-Accounts ist ein Fehler aufgetreten.',

   'A problem occurred when attempting to create your new LON-CAPA account.'
=> 'Beim Erstellen Ihres neuen LON-CAPA-Accounts ist ein Fehler aufgetreten.',

   'Please provide user information and a password for your new account.'
=> 'Bitte geben Sie Ihre Benutzerdaten und ein Passwort für Ihren neuen Account ein.',

   'Your password, which must contain at least seven characters, will be sent to the LON-CAPA server in an encrypted form.'
=> 'Ihr Passwort, das aus mindestens sieben Zeichen bestehen muss, wird in verschlüsselter Form an den LON-CAPA-Server geschickt.',

   'Create LON-CAPA account'
=> 'LON-CAPA-Account erstellen',

   'Could not load javascript file [_1]'
=> 'Konnte die Javascriptdatei [_1] nicht laden.',

   'Invalid ID format'
=> 'Ungültiges ID-Format',

   'An error occurred when storing a token'
=> 'Beim Speichern eines Merkzeichens ist ein Fehler aufgetreten.',

   'You will not be able to proceed to the next stage of account creation'
=> 'Sie werden den nächsten Schritt zum Erstellen eines Accounts nicht ausführen können.',

   'A LON-CAPA account has been created for username: [_1] in domain: [_2].'
=> 'Für den Benutzer [_1] in der Domäne [_2] wurde ein LON-CAPA-Account erstellt.',

   'Account creation failed for username: [_1] in domain: [_2].'
=> 'Das Erstellen eines LON-CAPA-Accounts für den Benutzer [_1] in der Domäne [_2] ist fehlgeschlafen.',

   'User account creation is not available for the current default authentication type.'
=> 'Für die momentan voreingestellte Authentifizierungsmethode ist das Erstellen von Benutzeraccounts nicht verfügbar.',

   'The e-mail address you provided is already in use as a username at this institution.'
=> 'Die von Ihnen angegebene E-Mail-Adresse wird in dieser LON-CAPA-Domäne als Benutzername bereits verwendet.',

   'Username rules at this institution do not allow the e-mail address you provided to be used as a username.'
=> 'Die für diese Einrichtung eingestellten Regeln für Benutzernamen gestatten es nicht, die von Ihnen angegebene E-Mail-Adresse als Benutzername zu verwenden.',

   'The e-mail address you provided may not be used as a username at this LON-CAPA institution.'
=> 'Die von Ihnen angegebene E-Mail-Adresse kann in dieser Einrichtung nicht als Benutzername verwendet werden.',

   'Validation of the code your entered failed.'
=> 'Die Gültigskeitsprüfung des von Ihnen eingegebenen Codes ist fehlgeschlagen.',

   'Creation of a new user account using an e-mail address as username is not permitted at this LON-CAPA institution.'
=> 'Das Erstellen von neuen Benutzeraccounts mit einer E-Mail-Adresse als Benutzername ist für diese Einrichtung nicht gestattet.',

   'Type in the letters/numbers shown below'
=> 'Geben Sie die unten angezeigten Buchstaben/Zahlen ein',

   'You may need to reload the previous page to obtain a new token.'
=> 'Sie können die vorherige Seite neu laden, um ein neues Merkzeichen zu erhalten.',

   'Unable to retrieve your log-in information - unexpected context'
=> 'Die Anmeldedaten konnten nicht erfolgreich abgerufen werden - unerwarteter Kontext',

   "Your e-mail address uses the same internet domain as your institution's LON-CAPA service."
=> "Ihre E-Mail-Adresse verwendet die gleiche Internetdomäne wie die Domäne des LON-CAPA-Systems Ihrer Institution.",

   'Creation of a LON-CAPA account with this type of e-mail address as username is not permitted.'
=> 'Das Erstellen eines LON-CAPA-Accounts mit dieser Art von E-Mail-Adressen als Benutzername ist nicht zulässig.',

   'You should request creation of a LON-CAPA account for a log-in ID of "[_1]" at your institution instead.'
=> 'Stattdessen sollten Sie die Erstellung eines LON-CAPA-Accounts für Ihren Benutzeraccount "[_1]" an Ihrer Einrichtung beantragen.',

   'Changes/page:'
=> 'Zeilen pro Seite:',

   'Window during which changes occurred:'
=> 'Zeitspanne, in der Änderungen aufgetreten sind:',

   'This page is either empty or it only contains resources that are currently hidden'
=> 'Diese Seite ist entweder leer oder enthält derzeit nur verborgene Ressourcen',

   'Please use the LON-CAPA navigation arrows to move to another item in the course'
=> 'Bitte verwenden Sie die LON-CAPA-Navigationspfeile, um zu anderen Ressourcen zu gelangen.',

   'Unable to modify requested student ([_1])'
=> 'Die Daten des angeforderten Studenten ([_1]) konnten nicht geändert werden.',

   'Unable to grade requested sequence ([_1]).'
=> 'Die angeforderte Sequenz ([_1]) konnte nicht bewertet werden.',

   'No score was changed or updated.'
=> 'An den Punkten wurde keine Änderung vorgenommen.',

   'The scores were changed for [quant,_1,problem].'
=> 'Für [quant,_1,Aufgabe wurde,Aufgaben wurden] die Punkte geändert.',

   '[_1]Visit the [_2]Course Catalog[_3] to view all [_4] LON-CAPA courses.' # _1: <b>, _2: <a>, _3: </a> </b>, _4: domain
=> '[_1]Besuchen Sie die [_2]Kursübersicht[_3], um alle  LON-CAPA-Kurse der Domäne [_4] zu betrachten.',

   'If a course is [_1]not[_2] in your list of current courses below, you may be able to enroll if self-enrollment is permitted.'
=> 'Falls ein Kurs in der folgenden Liste [_1]nicht[_2] angezeigt wird, können Sie sich in diesen Kurs selbst eintragen, sofern die Selbsteintragung für diesen Kurs aktiviert ist.',

#SD begin 2008-07-02
   'When'
=> 'Wann',

   'Who made the change'
=> 'Wer führte die Änderung durch',

   'Changed User'
=> 'Geänderter Benutzer',

   'Context'
=> 'Kontext',

   'Context:'
=> 'Kontext:',

   'After:'
=> 'Nach:',

   'Before:'
=> 'Vor:',

   'User Changes'
=> 'Teilnehmer-Änderungen',

   'For this user, the default quota would be [_1]'
=> 'Das Standardkontingent für diesen Benutzer beträgt [_1]',

   'Search for a user and enroll as a student'
=> 'Benutzer suchen und als Studierenden den Kurs belegen lassen',

   'username is known'
=> 'Benutzername ist bekannt',

   'Create a new user'
=> 'Neuen Benutzer erstellen',

   'Enroll'
=> 'eintragen',

   'User Search to enroll student'
=> 'Benutzersuche, um Studierende einzutragen',

   'Select a user to enroll as a student'
=> 'Wählen Sie einen Benutzer zum Eintragen als Studierenden aus',

   'modify' #Kontext? breadcrumb_text
=> 'modifizieren',

#   'userpicked' #Kontext?
#=> '',

   'as a student'
=> 'als einen Studierenden',

   'Set section/dates'
=> 'Sektion/Daten festlegen',

   'Unknown'
=> 'unbekannt',

   'You do not have privileges to assign co-author roles.'
=> 'Sie haben keine Berechtigung, um Co-Autor Rollen zuzuweisen',

   'This user has an unrecognized authentication scheme'
=> 'Dieser Benutzer hat ein unbekanntes Authentifizierungsschema',

   'Please alert a domain coordinator of this situation'
=> 'Bitte benachrichtigen Sie einen Domänen-Koordinator über diese Situation',

   'Please specify login data below'
=> 'Bitte spezifizieren Sie Login-Daten',

   'No domain specified'
=> 'Keine Domäne spezifiziert',

   'Invalid domain name'
=> 'Ungültiger Domänenname',

   'Only letters, numbers, periods, dashes, and underscores are valid'
=> 'Es sind nur erlaubt: Buchstaben, Ziffern, ".", "-", "_"',

   'You do not have the authority to modify this users authentification information'
=> 'Sie haben nicht die Berechtigung, um die Authentifizierungsinformationen dieses Benutzers zu modifizieren',

   'New student/employee ID does not match existing ID for this user.'
=> 'Die neue Studenten-/Mitarbeiter-ID stimmt nicht mit der bestehenden ID dieses Benutzers überein.',

   "Change is not permitted without checking the 'Force ID change' checkbox on the previous page."
=> "Ohne Auswahl der 'Erzwinge-ID-Änderung'-Checkbox auf der vorherigen Seite ist eine Änderung nicht erlaubt.",

   'Unable to successfully change environment for'
=> 'Es ist nicht möglich, die Umgebung zu ändern für',

   'No roles'
=> 'Keine Rollen',

   'The following fields were not updated: '
=> 'Die folgenden Felder wurden nicht aktualisiert: ',

   "You do not have the authority to change this field given the user's current set of active/future [_1] roles:"
=> 'Sie haben nicht die Berechtigung, um dieses Feld angesichts der aktuellen aktiven/zukünftigen [_1] Rollen des Benutzer zu ändern:',

   "You do not have the authority to change these fields given the user's current set of active/future [_1] roles:"
=> 'Sie haben nicht die Berechtigung, um diese Felder angesichts der aktuellen aktiven/zukünftigen [_1] Rollen des Benutzers zu ändern:',

   'Contact your <a href="[_1]">helpdesk</a> for more information.'
=> 'Kontaktieren Sie das <a href="[_1]">Helpdesk</a> für weitere Informationen.',

   '<b>[_1]</b> enrolled'
=> '<b>[_1]</b> eingetragen',

   'in section [_1]'
=> 'in Sektion [_1]',

   'Access starts immediately'
=> 'Zugriff beginnt sofort',

   'Access starts: '
=> 'Zugriff beginnt: ',

   'ends: no ending date'
=> 'endet: kein Enddatum',

   'ends: '
=> 'endet: ',

   'If the student is currently logged-in to LON-CAPA, the new role will be available when the student next logs in.'
=> 'Falls der Studierende gerade an LON-CAPA angemeldet ist, wird die Rolle nach dem nächsten Anmelden des Studierenden verfügbar sein.  ',

   '(default)'
=> '(Standard)',

   '(default for [_1])'
=> '(Standard für [_1])',

   'You are not authorized to make bulk changes to user roles'
=> 'Sie sind nicht authorisiert Massenänderungen an Benutzerrollen durchzuführen',

   'You do not have permission to modify dates or sections for users'
=> 'Sie haben keine Berechtigung, um Daten oder Sektionen für Benutzer zu modifizieren',

   'deleted'
=> 'gelöscht',

   'No start date'
=> 'Kein Anfangsdatum',

   'Previous [_1] changes'
=> 'Vorherige [_1] Änderungen',

   'Next [_1] changes'
=> 'Nächste [_1] Änderungen',

   'There are no records to display'
=> 'Keine Datensätze zum Anzeigen',

   'Automated enrollment'
=> 'Automatisierte Kursbelegung',

   'Roster Update'
=> 'Teilnehmeraktualisierung',

   'Course Creation'
=> 'Kurserstellung',

   'User Management in course'
=> 'Benutzerverwaltung im Kurs',

   'User Management in domain'
=> 'Benutzerverwaltung in der Domäne',

   'Self-enrolled'
=> 'Selbst eingetragen',

   'Your search term must contain more than just spaces.'
=> 'Ihre Suchanfrage muss mehr als nur Leerzeichen enthalten.',

   'this course'
=> 'dieser Kurs',

   'LON-CAPA domain: '
=> 'LON-CAPA-Domäne',

   'the institutional directory for domain: '
=> 'das institutionelle Verzeichnis für die Domäne: ',

   'Contact the <a[_1]>helpdesk</a> if you need to create a new user.'
=> 'Kontaktieren Sie den <a[_1]>Helpdesk</a> falls Sie einen neuen Benutzer erstellen möchten.',

   'Section for self-enrolled users unchanged as the proposed section is a group'
=> 'Sektion für selbst eingetragene Benutzer nicht geändert, da die vorgeschlagene Sektion eine Gruppe ist',

   'Group names and section names must be distinct'
=> 'Gruppen- und Sektionsnamen müssen eindeutig sein',

   "Section for self-enrolled users unchanged, as 'all' is a reserved section name."
=> 'Sektion für selbst eingetragene Benutzer nicht geändert, da \'Alle\' ein geschützter Sektionsname ist.',

   'An error occurred when saving changes to self-enrollment settings in this course.'
=> 'Ein Fehler trat während des Speicherns der Änderungen an den Selbsteintragungs-Einstellungen in diesem Kurs auf.',

#SD end 2008-07-02

   '[_1] at [_2]'
=> '[_1] in [_2]',

   '[_1]: [_2]'
=> '[_1]: [_2]',

   'Server Switch Required'
=> 'Serverwechsel erforderlich',

   'Construction Space access is only available from the home server of the corresponding Author.'
=> 'Der Konstruktionsbereich ist nur vom Heimatserver des zugehörigen Autors verfügbar.',

   "Click the 'Switch Server' link to go there."
=> "Klicken Sie auf 'Server wechseln', um dort hinzugelangen.",

   'Default in use:'
=> 'Voreinstellung in Verwendung:',

   'Self-creation of account by users with status: [_1]  '
=> 'Selbsterstellung eines Accounts durch Benutzer mit Status [_1]  ',

   'modifiable fields (if institutional data blank): '
=> 'änderbare Felder (falls Daten der Einrichtung leer sind): ',

# domainprefs.pm
#   'Formats disallowed for $text{$type}: '
#=> 'Formats disallowed for $text{$type}: ',
#
#   'Format rules to check for $text{$type}: '
#=> 'Format rules to check for $text{$type}: ',

# loncommon.pm
#   "You must either choose $text{'action'} with a different format --  $text{'one'} that will not conflict with 'official' institutional $text{'items'}, or leave the ID field blank."
# => "You must either choose $text{'action'} with a different format --  $text{'one'} that will not conflict with 'official' institutional $text{'items'}, or leave the ID field blank."

   'Source Code'
=> 'Quellcode',

   'Copy Problem Source Code to Construction Space'
=> 'Aufgaben-Quellcode in Konstruktionsbereich kopieren',

   'Please enter the directory that you would like the source code to go into.'
=> 'Bitte geben Sie das Verzeichnis ein, in das der Quellcode kopiert werden soll.',

   'Note: the path is in reference to the root of your construction space, and new directories will be automatically created.'
=> 'Beachten Sie, dass sich der Pfad auf das Heimatverzeichnis Ihres Konstruktionsbereichs bezieht. Noch nicht existierende Verzeichnisse werden automatisch angelegt.',

   'shared_source'
=> 'gemeinsame_Dokumente',

   'Copy to Construction Space'
=> 'In Konstruktionsbereich kopieren',

   '[_1]W[_2]ARNING' # Highlight first char
=> '[_1]W[_2]ARNUNG',

   'At end of file some tags were still left unclosed:'
=> 'Am Ende der Datei sind manche Tags noch nicht geschlossen:',

   'Unable to save file [_1]'
=> 'Die folgende Datei konnte nicht gespeichert werden: [_1]',

   'Warnings and Errors'
=> 'Warnungen und Fehler',

   '[quant,_1,error]'
=> '[quant,_1,Fehler]',

   '[quant,_1,warning]'
=> '[quant,_1,Warnung,Warnungen]',

   'Edit Math'
=> 'Formeleditor',

   'DragMath Latex Equation Editor'
=> 'DragMath-LaTeX-Formel-Editor', # n.t.

   '[_1]Return[_2] to editing resource.'
=> '[_1]Zurück[_2] zur Ressource',

   'Counting pages for student: [_1]'
=> 'Zähle Seiten für Student [_1]',

   'Class Print Status'
=> 'Druckstatus',

   'LaTeX could not successfully parse your tex file.'
=> 'LaTeX konnte Ihre TeX-Datei nicht erfolgreich parsen.',

   'It probably has errors in it.'
=> 'Sie enthält vermutlich Fehler.',

   'With very high probability this error occured in [_1].'
=> 'Dieser Fehler trat höchstwahrscheinlich in [_1] auf.',

   'Here are the error messages in the LaTeX log file:'
=> 'Die Fehlermeldungen der LaTeX-Logdatei:',

   'There are errors in [_1].'
=> 'Es sind Fehler aufgetreten. Ort: [_1]',

   'There are errors.'
=> 'Es sind Fehler aufgetreten.',

   'These errors prevent this resource from printing correctly.'
=> 'Diese Fehler verhindern, dass diese Ressource korrekt gedruckt werden kann.',

   'A message has been sent to the instructor describing this failure.'
=> 'Dem Dozenten wurde eine Nachricht gesendet, die eine Beschreibung des Fehlverhaltens enthält.',

   'You are running LaTeX in [_1]batch mode[_2].'
=> 'Sie verwenden LaTeX im [_1]Stapelverarbeitungsbetrieb[_2] (batch mode).',

   'It has found an error in [_1][_2]and corrected it.'
=> 'Es wurde ein Fehler in [_1] gefunden[_2]und korrigiert.',

   'Usually this correction is valid but you probably need to check the indicated resource one more time and implement neccessary corrections by yourself.'
=> 'Üblicherweise ist diese Korrektur gültig, allerdings sollten Sie dennoch die angezeigte Ressource überprüfen ',

   'The link to [_1]Your log file[_2]'
=> 'Link zur [_1]Logdatei[_2]',

   'The link to [_1]Your original LaTeX file[_2]'
=> 'Link zur [_1]Original-LaTeX-Datei[_2]',

   'bomb'
=> 'Bombe',

   'Output Tags'
=> 'Tags zur Ausgabe',

   'WARNING: Cannot connect to database!'
=> 'WARNUNG: Datenbankverbindung kann nicht aufgebaut werden!',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNUNG: Die Metadaten-Tabelle existiert nicht in der LON-CAPA-Datenbank!',

   'Error occurred saving new values in metadata table in LON-CAPA database!'
=> 'Speichern neuer Werte in der Metadaten-Tabelle der LON-CAPA-Datenbank ist fehlgeschlagen!',

   'Your course currently appears in the Course Catalog for this domain.'
=> 'Ihr Kurs wird momentan in der Kursübersicht aufgelistet.',

   'Courses can be both self-cataloging, based on an institutional code (e.g., fs08phy231), or can be assigned categories from a hierarchy defined for the domain.'
=> 'Kurse können selbst-katalogisiert sein, auf institutionellen Codes basieren (z.B. fbi_ws20082009_linalg) oder können eine Kategorie einer Hierarchie zugeordnet sein, die durch die Domäne definiert ist.',

   'Your course does not currently appear in the Course Catalog for this domain.'
=> 'Ihr Kurs wird derzeit nicht in der Kursübersicht dieser Domäne aufgelistet.',

   'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding your course.'
=> 'Sie sollten dies ändern, falls Sie Selbsteintragung für diesen Kurs anbieten möchten, da Studenten sonst Schwierigkeiten haben werden, Ihren Kurs zu finden.',

   'Courses can be absent from the Catalog, because they do not have an institutional code, have no assigned category, or have been specifically excluded.'
=> 'Gründe für das Fehlen der Auflistung von Kursen in der Kursübersicht können sein, dass die Kurse keinen institutionellen Code haben, ihnen keine Kategorie zugewiesen wurde oder mit Absicht aus der Auflistung ausgeschlossen wurden.',

   'Make any changes to self-enrollment settings below, click "Save changes", then take action to include the course in the Catalog:'
=> 'Nehmen Sie unten Änderungen an der Selbsteintragung vor, klicken Sie auf "Änderungen speichern" und sorgen Sie anschließend dafür, dass der Kurs in die Kursübersicht aufgenommen wird:',

   'Take the following action to ensure the course appears in the Catalog:'
=> 'Führen Sie folgende Schritte aus, damit der Kurs in der Kursübersicht aufgelistet wird:',

   'Ask a domain coordinator to change the "Exclude from course catalog" setting.'
=> 'Bitten Sie einen Domänen-Koordinator, die Einstellung "Kurs aus Kursübersicht ausschließen" zu ändern.',

   'Ask a domain coordinator to enable display the catalog of "Official courses (with institutional codes)".'
=> 'Bitten Sie einen Domänen-Koordinator, die Anzeige der Kursübersicht "Offizielle Kurse (mit institutionellen Codes)" zu aktivieren.',

   'Ask a domain coordinator to assign an institutional code (if this is an official course).'
=> 'Bitten Sie einen Domänen-Koordinator, einen institutionellen Code zuzuweisen (falls es sich um einen offiziellen Kurs handelt).',

   'Ask a domain coordinator to enable or create at least one course category in the domain.'
=> 'Bitten Sie einen Domänen-Koordinator, in der Domäne mindestens eine Kurskategorie anzulegen.',

   'Ask a domain coordinator to create a hierarchy of categories and sub categories for courses in the domain.'
=> 'Bitten Sie einen Domänen-Koordinator, für Kurse in der Domäne eine Hierarchie von Kategorien und Unterkategorien anzulegen.',

   'Ask a domain coordinator to change the category assigned to the course, as the one currently assigned is no longer used in the domain'
=> 'Bitten Sie einen Domänen-Koordinator, die diesem Kurs zugewiesene Kategorie zu abzuändern, da die derzeit zugewiesene in der Domäne nicht mehr verwendet wird.',

   'Ask a domain coordinator to assign a category to the course.'
=> 'Bitten Sie einen Domänen-Koordinator, dem Kurs eine Kategorie zuzuweisen.',

   'Use [_1]Set course environment[_2] to change the "Exclude from course catalog" setting.'
=> 'Gehen Sie zum Menüpunkt [_1]Kursumgebung[_2], um die Einstellung "Kurs aus Kursübersicht ausschließen" zu ändern.',

   'Use [_1]Set course environment[_2] to change the category assigned to the course, as the one currently assigned is no longer used in the domain.'
=> 'Gehen Sie zum Menüpunkt [_1]Kursumgebung[_2], um die diesem Kurs zugewiesene Kategorie zu abzuändern, da die derzeit zugewiesene in der Domäne nicht mehr verwendet wird.',

   'Use [_1]Set course environment[_2] to assign a category to the course.'
=> 'Gehen Sie zum Menüpunkt [_1]Kursumgebung[_2], um dem Kurs eine Kategorie zuzuweisen.',

   'You are able to both assign a course category and choose to exclude this course from the catalog.'
=> 'Sie können dem Kurs eine Kurskategorie zuweisen und den Kurs aus der Kursübersicht ausschließen.',

   'You are able to choose to exclude this course from the catalog, but only a Domain Coordinator may assign a course category.'
=> 'Sie können den Kurs aus der Kursübersicht ausschließen, aber nur ein Domänen-Koordinator darf dem Kurs eine Kurskategorie zuweisen.',

   'You may assign a course category, but only a Domain Coordinator may choose to exclude this course from the catalog.'
=> 'Sie können dem Kurs eine Kurskategorie zuweisen, aber nur ein Domänen-Koordinator darf den Kurs aus der Kursübersicht ausschließen.',

   'Only a Domain Coordinator may assign a course category or choose to exclude this course from the catalog.'
=> 'Nur ein Domänen-Koordinator darf dem Kurs eine Kurskategorie zuweisen und den Kurs aus der Kursübersicht ausschließen.',

   "Please use the 'Select Course' link to open a separate pick course window where you may select the course you wish to enter"
=> "Bitte verwenden Sie den 'Kurs auswählen'-Link, um ein extra Fenster zu öffnen, das Ihnen die Möglichkeit bietet, einen Kurs auszuwählen, den Sie betreten möchten.",

   'You can only use this screen to select courses in the current domain.'
=> 'Sie können diesen Bildschirm nur verwenden, um Kurse der derzeitigen Domäne auszuwählen.',

   ''
=> '',


#SYNCMARKER
);
1;
