/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Eval;
import org.jmol.viewer.Viewer;

class PropertyManager {
    Viewer viewer;
    static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "", "", "fileContents", "<pathname>", "", "animationInfo", "", "", "modelInfo", "", "", "X -vibrationInfo", "", "", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "atomList", "<atom selection>", "(visible)", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "", "", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "", "", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "", "", "evaluate", "<expression>", ""};
    static final int PROP_APPLET_INFO = 0;
    static final int PROP_FILENAME = 1;
    static final int PROP_FILEHEADER = 2;
    static final int PROP_FILECONTENTS = 3;
    static final int PROP_FILECONTENTS_PATH = 4;
    static final int PROP_ANIMATION_INFO = 5;
    static final int PROP_MODEL_INFO = 6;
    static final int PROP_VIBRATION_INFO = 7;
    static final int PROP_SHAPE_INFO = 8;
    static final int PROP_MEASUREMENT_INFO = 9;
    static final int PROP_CENTER_INFO = 10;
    static final int PROP_ORIENTATION_INFO = 11;
    static final int PROP_TRANSFORM_INFO = 12;
    static final int PROP_ATOM_LIST = 13;
    static final int PROP_ATOM_INFO = 14;
    static final int PROP_BOND_INFO = 15;
    static final int PROP_CHAIN_INFO = 16;
    static final int PROP_POLYMER_INFO = 17;
    static final int PROP_MOLECULE_INFO = 18;
    static final int PROP_STATE_INFO = 19;
    static final int PROP_EXTRACT_MODEL = 20;
    static final int PROP_JMOL_STATUS = 21;
    static final int PROP_JMOL_VIEWER = 22;
    static final int PROP_MESSAGE_QUEUE = 23;
    static final int PROP_AUXILIARY_INFO = 24;
    static final int PROP_BOUNDBOX_INFO = 25;
    static final int PROP_DATA_INFO = 26;
    static final int PROP_IMAGE = 27;
    static final int PROP_EVALUATE = 28;
    static final int PROP_COUNT = 29;
    static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image"};
    boolean requestedReadable = false;

    PropertyManager(Viewer viewer) {
        this.viewer = viewer;
    }

    static int getPropertyNumber(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 29; ++i) {
            if (!string.equalsIgnoreCase(PropertyManager.getPropertyName(i))) continue;
            return i;
        }
        return -1;
    }

    static String getPropertyName(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3];
    }

    static String getParamType(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3 + 1];
    }

    static String getDefaultParam(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3 + 2];
    }

    boolean isReadableAsString(String string) {
        int n = readableTypes.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(readableTypes[n])) continue;
            return true;
        }
        return false;
    }

    synchronized Object getProperty(String string, String string2, Object object) {
        if (propertyTypes.length != 87) {
            Logger.warn((String)("propertyTypes is not the right length: " + propertyTypes.length + " != " + 87));
        }
        Object object2 = this.getPropertyAsObject(string2, object);
        if (string == null) {
            return object2;
        }
        this.requestedReadable = string.equalsIgnoreCase("readable");
        if (this.requestedReadable) {
            String string3 = string = this.isReadableAsString(string2) ? "String" : "JSON";
        }
        if (string.equalsIgnoreCase("String")) {
            return object2.toString();
        }
        if (this.requestedReadable) {
            return this.toReadable(string2, object2);
        }
        if (string.equalsIgnoreCase("JSON")) {
            return "{" + this.toJSON(string2, object2) + "}";
        }
        return object2;
    }

    private synchronized Object getPropertyAsObject(String string, Object object) {
        int n = PropertyManager.getPropertyNumber(string);
        boolean bl = object != null && object.toString().length() > 0;
        Object object2 = bl ? object : PropertyManager.getDefaultParam(n);
        switch (n) {
            case 0: {
                return this.viewer.getAppletInfo();
            }
            case 5: {
                return this.viewer.getAnimationInfo();
            }
            case 13: {
                return this.viewer.getAtomBitSetVector(object2);
            }
            case 14: {
                return this.viewer.getAllAtomInfo(object2);
            }
            case 24: {
                return this.viewer.getAuxiliaryInfo();
            }
            case 15: {
                return this.viewer.getAllBondInfo(object2);
            }
            case 25: {
                return this.viewer.getBoundBoxInfo();
            }
            case 10: {
                return this.viewer.getRotationCenter();
            }
            case 16: {
                return this.viewer.getAllChainInfo(object2);
            }
            case 20: {
                return this.viewer.getModelExtract(object2);
            }
            case 1: {
                return this.viewer.getFullPathName();
            }
            case 2: {
                return this.viewer.getFileHeader();
            }
            case 3: 
            case 4: {
                if (bl) {
                    return this.viewer.getFileAsString(object2.toString());
                }
                return this.viewer.getCurrentFileAsString();
            }
            case 21: {
                return this.viewer.getStatusChanged(object2.toString());
            }
            case 22: {
                return this.viewer.getViewer();
            }
            case 9: {
                return this.viewer.getMeasurementInfo();
            }
            case 23: {
                return this.viewer.getMessageQueue();
            }
            case 6: {
                return this.viewer.getModelInfo();
            }
            case 18: {
                return this.viewer.getMoleculeInfo(object2);
            }
            case 11: {
                return this.viewer.getOrientationInfo();
            }
            case 17: {
                return this.viewer.getAllPolymerInfo(object2);
            }
            case 8: {
                return this.viewer.getShapeInfo();
            }
            case 19: {
                return this.viewer.getStateInfo();
            }
            case 12: {
                return this.viewer.getMatrixRotate();
            }
            case 26: {
                return Viewer.getData(object2.toString());
            }
            case 28: {
                return Eval.evaluateExpression(this.viewer, object2.toString());
            }
            case 27: {
                return this.viewer.getJpegBase64(100);
            }
        }
        String string2 = "getProperty ERROR\n" + string + "?\nOptions include:\n";
        for (int i = 0; i < 29; ++i) {
            String string3 = PropertyManager.getParamType(i);
            String string4 = PropertyManager.getDefaultParam(i);
            String string5 = PropertyManager.getPropertyName(i);
            if (string5.charAt(0) == 'X') continue;
            string2 = string2 + "\n getProperty " + string5 + (string3 != "" ? " " + string3 + (string4 != "" ? " #default: " + string4 : "") : "");
        }
        return string2;
    }

    String packageJSON(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return "\"" + string + "\": " + string2;
    }

    String packageReadable(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return "\n" + string + "\t" + string2;
    }

    String fixString(String string) {
        if (string == null || string.indexOf("{\"") == 0) {
            return string;
        }
        string = TextFormat.simpleReplace((String)string, (String)"\"", (String)"''");
        string = TextFormat.simpleReplace((String)string, (String)"\n", (String)" | ");
        return "\"" + string + "\"";
    }

    String toJSON(String string, Object object) {
        String string2 = "";
        String string3 = "";
        if (object == null) {
            return this.packageJSON(string, null);
        }
        if (object instanceof String) {
            return this.packageJSON(string, this.fixString((String)object));
        }
        if (object instanceof String[]) {
            string2 = "[";
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + this.fixString(((String[])object)[i]);
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof int[]) {
            string2 = "[";
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + ((int[])object)[i];
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof float[]) {
            string2 = "[";
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + ((float[])object)[i];
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof int[][]) {
            string2 = "[";
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + this.toJSON(null, ((int[][])object)[i]);
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof float[][]) {
            string2 = "[";
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + this.toJSON(null, ((float[][])object)[i]);
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof Vector) {
            string2 = "[";
            int n = ((Vector)object).size();
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + this.toJSON(null, ((Vector)object).get(i));
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof Matrix3f) {
            string2 = "[";
            string2 = string2 + "[" + ((Matrix3f)object).m00 + "," + ((Matrix3f)object).m01 + "," + ((Matrix3f)object).m02 + "]";
            string2 = string2 + ",[" + ((Matrix3f)object).m10 + "," + ((Matrix3f)object).m11 + "," + ((Matrix3f)object).m12 + "]";
            string2 = string2 + ",[" + ((Matrix3f)object).m20 + "," + ((Matrix3f)object).m21 + "," + ((Matrix3f)object).m22 + "]";
            string2 = string2 + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof Point3f) {
            string2 = string2 + "[" + ((Point3f)object).x + "," + ((Point3f)object).y + "," + ((Point3f)object).z + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof Vector3f) {
            string2 = string2 + "[" + ((Vector3f)object).x + "," + ((Vector3f)object).y + "," + ((Vector3f)object).z + "]";
            return this.packageJSON(string, string2);
        }
        if (object instanceof Hashtable) {
            string2 = "{";
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                string2 = string2 + string3 + this.packageJSON(string4, this.toJSON(null, ((Hashtable)object).get(string4)));
                string3 = ",";
            }
            string2 = string2 + "}";
            return this.packageJSON(string, string2);
        }
        return this.packageJSON(string, object.toString());
    }

    String toReadable(String string, Object object) {
        String string2 = "";
        String string3 = "";
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return this.packageReadable(string, this.fixString((String)object));
        }
        if (object instanceof String[]) {
            string2 = "[";
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + this.fixString(((String[])object)[i]);
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageReadable(string, string2);
        }
        if (object instanceof int[]) {
            string2 = "[";
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + ((int[])object)[i];
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageReadable(string, string2);
        }
        if (object instanceof float[]) {
            string2 = "";
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + ((float[])object)[i];
                string3 = ",";
            }
            string2 = string2 + "";
            return this.packageReadable(string, string2);
        }
        if (object instanceof int[][]) {
            string2 = "[";
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + this.toReadable(null, ((int[][])object)[i]);
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageReadable(string, string2);
        }
        if (object instanceof float[][]) {
            string2 = "[";
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + this.toReadable(null, ((float[][])object)[i]);
                string3 = ",";
            }
            string2 = string2 + "]";
            return this.packageReadable(string, string2);
        }
        if (object instanceof Vector) {
            string2 = "";
            int n = ((Vector)object).size();
            for (int i = 0; i < n; ++i) {
                string2 = string2 + string3 + this.toReadable(null, ((Vector)object).get(i));
                string3 = ",";
            }
            return this.packageReadable(string, string2);
        }
        if (object instanceof Matrix3f) {
            string2 = "[";
            string2 = string2 + "[" + ((Matrix3f)object).m00 + "," + ((Matrix3f)object).m01 + "," + ((Matrix3f)object).m02 + "]";
            string2 = string2 + ",[" + ((Matrix3f)object).m10 + "," + ((Matrix3f)object).m11 + "," + ((Matrix3f)object).m12 + "]";
            string2 = string2 + ",[" + ((Matrix3f)object).m20 + "," + ((Matrix3f)object).m21 + "," + ((Matrix3f)object).m22 + "]";
            string2 = string2 + "]";
            return this.packageReadable(string, string2);
        }
        if (object instanceof Point3f) {
            string2 = string2 + "[" + ((Point3f)object).x + "," + ((Point3f)object).y + "," + ((Point3f)object).z + "]";
            return this.packageReadable(string, string2);
        }
        if (object instanceof Vector3f) {
            string2 = string2 + "[" + ((Vector3f)object).x + "," + ((Vector3f)object).y + "," + ((Vector3f)object).z + "]";
            return this.packageReadable(string, string2);
        }
        if (object instanceof Hashtable) {
            string2 = "";
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                string2 = string2 + string3 + this.packageReadable(string4, this.toReadable(null, ((Hashtable)object).get(string4)));
                string3 = "";
            }
            string2 = string2 + "\n";
            return this.packageReadable(string, string2);
        }
        return this.packageReadable(string, object.toString());
    }
}

