/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.MeshRenderer;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Isosurface;
import org.jmol.shapespecial.IsosurfaceMesh;
import org.jmol.util.Logger;

public class IsosurfaceRenderer
extends MeshRenderer {
    private boolean iShowNormals;
    private boolean iHideBackground;
    private boolean isPlane;
    private boolean isBicolorMap;
    private short backgroundColix;
    private boolean isTranslucent;
    private int nError = 0;
    private float[] vertexValues;
    IsosurfaceMesh imesh;
    private final Point3f ptTemp = new Point3f();
    private final Point3i ptTempi = new Point3i();

    protected void render() {
        this.iShowNormals = ((ShapeRenderer)this).viewer.getTestFlag4();
        Isosurface isosurface = (Isosurface)((ShapeRenderer)this).shape;
        int n = ((MeshCollection)isosurface).meshCount;
        while (--n >= 0) {
            this.imesh = (IsosurfaceMesh)((MeshCollection)isosurface).meshes[n];
            this.render1(this.imesh);
        }
    }

    protected void transform() {
        this.vertexValues = this.imesh.vertexValues;
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.vertexValues != null && Float.isNaN(this.vertexValues[n]) && !this.imesh.hasGridPoints) continue;
            ((ShapeRenderer)this).viewer.transformPoint(this.vertices[n], this.screens[n]);
        }
    }

    protected void render2() {
        this.isTranslucent = Graphics3D.isColixTranslucent((short)this.imesh.colix);
        boolean bl = this.iHideBackground = this.isPlane && this.imesh.hideBackground;
        if (this.iHideBackground) {
            this.backgroundColix = Graphics3D.getColix((int)((ShapeRenderer)this).viewer.getBackgroundArgb());
        }
        this.isPlane = this.imesh.jvxlData.jvxlPlane != null;
        this.isBicolorMap = this.imesh.jvxlData.isBicolorMap;
        super.render2();
    }

    protected void renderPoints() {
        int n;
        int n2 = this.imesh.vertexIncrement;
        int n3 = n = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
        while (n < this.vertexCount) {
            if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[n]) || this.frontOnly && this.transformedVectors[this.normixes[n]].z < 0.0f)) {
                if (this.imesh.vertexColixes != null) {
                    ((ShapeRenderer)this).g3d.setColix(this.imesh.vertexColixes[n]);
                }
                ((ShapeRenderer)this).g3d.fillSphereCentered(4, this.screens[n]);
            }
            n += n2;
        }
        if (n2 != 3) {
            return;
        }
        ((ShapeRenderer)this).g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)12, (boolean)true, (float)0.5f) : (short)12);
        for (n = 1; n < this.vertexCount; n += 3) {
            ((ShapeRenderer)this).g3d.fillCylinder((byte)3, 1, this.screens[n], this.screens[n + 1]);
        }
        ((ShapeRenderer)this).g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)21, (boolean)true, (float)0.5f) : (short)21);
        for (n = 1; n < this.vertexCount; n += 3) {
            ((ShapeRenderer)this).g3d.fillSphereCentered(4, this.screens[n]);
        }
        ((ShapeRenderer)this).g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)7, (boolean)true, (float)0.5f) : (short)7);
        for (n = 2; n < this.vertexCount; n += 3) {
            ((ShapeRenderer)this).g3d.fillSphereCentered(4, this.screens[n]);
        }
    }

    protected void renderTriangles(boolean bl, boolean bl2) {
        int[][] nArray = this.imesh.polygonIndexes;
        short s = this.imesh.colix;
        short[] sArray = this.imesh.vertexColixes;
        short s2 = 0;
        try {
            s2 = sArray[this.imesh.polygonIndexes[0][0]];
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ShapeRenderer)this).g3d.setColix(this.imesh.colix);
        int n = this.imesh.polygonCount;
        while (--n >= 0) {
            short s3;
            short s4;
            short s5;
            int[] nArray2 = nArray[n];
            if (nArray2 == null) continue;
            int n2 = nArray2[0];
            int n3 = nArray2[1];
            int n4 = nArray2[2];
            short s6 = this.normixes[n2];
            short s7 = this.normixes[n3];
            short s8 = this.normixes[n4];
            if (this.frontOnly && this.transformedVectors[s6].z < 0.0f && this.transformedVectors[s7].z < 0.0f && this.transformedVectors[s8].z < 0.0f) continue;
            if (sArray != null) {
                s5 = sArray[n2];
                s4 = sArray[n3];
                s3 = sArray[n4];
                if (this.isBicolorMap && (s5 != s4 || s4 != s3)) {
                    continue;
                }
            } else {
                s4 = s3 = s;
                s5 = s3;
            }
            if (this.iHideBackground) {
                if (s5 == s2 && s4 == s2 && s3 == s2) continue;
                if (s5 == s2) {
                    s5 = this.backgroundColix;
                }
                if (s4 == s2) {
                    s4 = this.backgroundColix;
                }
                if (s3 == s2) {
                    s3 = this.backgroundColix;
                }
            }
            if (bl) {
                block16: {
                    if (bl2) {
                        ((ShapeRenderer)this).g3d.fillTriangle(this.screens[n2], s5, s6, this.screens[n3], s4, s7, this.screens[n4], s3, s8, 0.1f);
                    } else {
                        try {
                            ((ShapeRenderer)this).g3d.fillTriangle(this.screens[n2], s5, s6, this.screens[n3], s4, s7, this.screens[n4], s3, s8);
                        }
                        catch (Exception exception) {
                            if (this.nError++ >= 1) break block16;
                            Logger.warn((String)"IsosurfaceRenderer -- competing thread bug?\n", (Throwable)exception);
                        }
                    }
                }
                if (!this.iShowNormals) continue;
                this.renderNormals();
                continue;
            }
            int n5 = nArray2[3];
            if (n5 == 0) continue;
            if (sArray == null) {
                ((ShapeRenderer)this).g3d.drawTriangle(this.screens[n2], this.screens[n3], this.screens[n4], n5);
                continue;
            }
            ((ShapeRenderer)this).g3d.drawTriangle(this.screens[n2], s5, this.screens[n3], s4, this.screens[n4], s3, n5);
        }
    }

    private void renderNormals() {
        if (!((ShapeRenderer)this).g3d.setColix((short)8)) {
            return;
        }
        int n = this.vertexCount;
        while (--n >= 0) {
            if (n % 3 != 0) continue;
            this.ptTemp.set((Tuple3f)this.mesh.vertices[n]);
            short s = this.mesh.normixes[n];
            if (s <= 0) continue;
            this.ptTemp.add((Tuple3f)((ShapeRenderer)this).g3d.getNormixVector(s));
            ((ShapeRenderer)this).viewer.transformPoint(this.ptTemp, this.ptTempi);
            ((ShapeRenderer)this).g3d.fillCylinder((byte)3, 1, this.screens[n], this.ptTempi);
        }
    }
}

