/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class JmolDataReader
extends AtomSetCollectionReader {
    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("JmolData");
        try {
            String string = "";
            while (this.readLine() != null && this.line.indexOf("Jmol Coordinate Data") < 0) {
                string = this.line;
            }
            int n = this.parseInt(string);
            this.readAtoms(n);
            this.discardLinesUntilContains("# orientation");
            while (this.readLine() != null && this.line.indexOf("#") < 0) {
                this.checkLineForScript("#jmolscript:" + this.line);
            }
            this.checkLineForScript("#jmolscript:set refreshing true");
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtoms(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            atom.elementSymbol = stringArray[1];
            atom.x = this.parseFloat(stringArray[3]);
            atom.y = this.parseFloat(stringArray[4]);
            atom.z = this.parseFloat(stringArray[5]);
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("line cannot be read for JmolData: " + this.line);
                atom.x = 0.0f;
                atom.y = 0.0f;
                atom.z = 0.0f;
            }
            this.setAtomCoord(atom);
        }
    }
}

