/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

public class AtomSetCollection {
    String fileTypeName;
    String collectionName;
    Properties atomSetCollectionProperties = new Properties();
    Hashtable atomSetCollectionAuxiliaryInfo = new Hashtable();
    static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "isPDB"};
    static final int GLOBAL_FRACTCOORD = 0;
    static final int GLOBAL_SYMMETRY = 1;
    static final int GLOBAL_latticeCells = 2;
    public static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    static final String[] dictRefUnitcellTags = new String[]{"cif:_cell_length_a", "cif:_cell_length_b", "cif:cell_length_c", "cif:_cell_length_alpha", "cif:_cell_length_beta", "cif:_cell_length_gamma"};
    private static final String[] quantumShellTags = new String[]{"S", "P", "SP", "L", "D"};
    int atomCount;
    Atom[] atoms = new Atom[256];
    int bondCount;
    Bond[] bonds = new Bond[256];
    int structureCount;
    Structure[] structures = new Structure[16];
    int atomSetCount;
    int currentAtomSetIndex = -1;
    int[] atomSetNumbers = new int[16];
    String[] atomSetNames = new String[16];
    int[] atomSetAtomCounts = new int[16];
    Properties[] atomSetProperties = new Properties[16];
    Hashtable[] atomSetAuxiliaryInfo = new Hashtable[16];
    int[] latticeCells;
    public String errorMessage;
    boolean coordinatesAreFractional;
    boolean isTrajectory;
    float[] notionalUnitCell = new float[6];
    SpaceGroup spaceGroup;
    UnitCell unitCell;
    Vector trajectories;
    boolean doNormalize = true;
    boolean isLatticeRange = false;
    Point3f[] cartesians;
    int bondCount0;
    int bondIndex0;
    boolean applySymmetryToBonds = false;
    Hashtable atomSymbolicMap = new Hashtable();
    int nTrajectories = 0;
    Point3f[] trajectory;

    public static final int getQuantumShellTagID(String string) {
        for (int i = 0; i < quantumShellTags.length; ++i) {
            if (!string.equals(quantumShellTags[i])) continue;
            return i >= 3 ? --i : i;
        }
        return -1;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtom(int n) {
        return this.atoms[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBond(int n) {
        return this.bonds[n];
    }

    public int getAtomSetCount() {
        return this.atomSetCount;
    }

    public int getCurrentAtomSetIndex() {
        return this.currentAtomSetIndex;
    }

    public AtomSetCollection(String string) {
        this.fileTypeName = string;
        ((Hashtable)this.atomSetCollectionProperties).put("PATH_KEY", ".PATH");
        ((Hashtable)this.atomSetCollectionProperties).put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
    }

    public AtomSetCollection(AtomSetCollection[] atomSetCollectionArray) {
        this("Array");
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        for (int i = 0; i < atomSetCollectionArray.length; ++i) {
            this.appendAtomSetCollection(i, atomSetCollectionArray[i]);
        }
    }

    public void setFileTypeName(String string) {
        this.fileTypeName = string;
    }

    boolean setTrajectory() {
        if (!this.isTrajectory) {
            this.trajectories = new Vector();
        }
        this.isTrajectory = true;
        return true;
    }

    protected void appendAtomSetCollection(int n, AtomSetCollection atomSetCollection) {
        Object object;
        int n2;
        int n3 = this.atomCount;
        int n4 = 0;
        for (n2 = 0; n2 < atomSetCollection.atomSetCount; ++n2) {
            int n5;
            this.newAtomSet();
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = atomSetCollection.atomSetAuxiliaryInfo[n2];
            this.setAtomSetAuxiliaryInfo("title", atomSetCollection.collectionName, this.currentAtomSetIndex);
            this.setAtomSetName(atomSetCollection.getAtomSetName(n2));
            object = atomSetCollection.getAtomSetProperties(n2);
            if (object != null) {
                Enumeration enumeration = ((Hashtable)object).keys();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.setAtomSetProperty(string, ((Properties)object).getProperty(string));
                }
            }
            for (n5 = 0; n5 < atomSetCollection.atomSetAtomCounts[n2]; ++n5) {
                try {
                    this.newCloneAtom(atomSetCollection.atoms[n4]);
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
                ++n4;
            }
            n5 = (Integer)this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].get("modelFileNumber");
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].put("modelFileNumber", new Integer(n5 += (n + 1) * 1000000));
            for (int i = 0; i < atomSetCollection.structureCount; ++i) {
                if (atomSetCollection.structures[i].modelIndex != n2 && atomSetCollection.structures[i].modelIndex != -1) continue;
                this.addStructure(atomSetCollection.structures[i]);
            }
            this.atomSetNames[this.currentAtomSetIndex] = atomSetCollection.atomSetNames[n2];
            this.atomSetNumbers[this.currentAtomSetIndex] = (n + 1) * 1000000 + atomSetCollection.atomSetNumbers[n2];
        }
        for (n2 = 0; n2 < atomSetCollection.bondCount; ++n2) {
            object = atomSetCollection.bonds[n2];
            this.addNewBond(((Bond)object).atomIndex1 + n3, ((Bond)object).atomIndex2 + n3, ((Bond)object).order);
        }
        n2 = globalBooleans.length;
        while (--n2 >= 0) {
            if (!Boolean.TRUE.equals(atomSetCollection.getAtomSetCollectionAuxiliaryInfo(globalBooleans[n2]))) continue;
            this.setGlobalBoolean(n2);
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void finish() {
        this.atoms = null;
        this.bonds = null;
        this.notionalUnitCell = null;
        this.spaceGroup = null;
        this.structures = new Structure[16];
        this.atomSetNumbers = new int[16];
        this.atomSetNames = new String[16];
        this.atomSetAtomCounts = new int[16];
        this.atomSetProperties = new Properties[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.structureCount = 0;
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
    }

    void freeze() {
        if (this.isTrajectory) {
            this.finalizeTrajectories();
        }
        this.getAltLocLists();
        this.getInsertionLists();
    }

    public void discardPreviousAtoms() {
        int n = this.atomCount;
        while (--n >= 0) {
            this.atoms[n] = null;
        }
        this.atomCount = 0;
        this.atomSymbolicMap.clear();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        n = this.atomSetNumbers.length;
        while (--n >= 0) {
            this.atomSetAtomCounts[n] = 0;
            this.atomSetNumbers[n] = 0;
            this.atomSetNames[n] = null;
        }
    }

    public void removeAtomSet() {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        --this.currentAtomSetIndex;
        --this.atomSetCount;
    }

    Atom newCloneAtom(Atom atom) throws Exception {
        Atom atom2 = atom.cloneAtom();
        this.addAtom(atom2);
        return atom2;
    }

    public void cloneFirstAtomSet() throws Exception {
        this.newAtomSet();
        int n = this.atomSetAtomCounts[0];
        for (int i = 0; i < n; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    public void cloneFirstAtomSetWithBonds(int n) throws Exception {
        this.cloneFirstAtomSet();
        int n2 = this.atomSetAtomCounts[0];
        for (int i = 0; i < n; ++i) {
            Bond bond = this.bonds[this.bondCount - n];
            this.addNewBond(bond.atomIndex1 + n2, bond.atomIndex2 + n2, bond.order);
        }
    }

    public void cloneLastAtomSet() throws Exception {
        int n = this.getLastAtomSetAtomCount();
        int n2 = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        while (--n >= 0) {
            this.newCloneAtom(this.atoms[n2]);
            ++n2;
        }
    }

    public int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    public void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])ArrayUtil.doubleLength(this.atoms);
        }
        atom.atomIndex = this.atomCount;
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
    }

    public void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    public Bond addNewBond(int n, int n2) {
        return this.addNewBond(n, n2, 1);
    }

    Bond addNewBond(String string, String string2) {
        return this.addNewBond(string, string2, 1);
    }

    public Bond addNewBond(int n, int n2, int n3) {
        if (n < 0 || n >= this.atomCount || n2 < 0 || n2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(n, n2, n3);
        this.addBond(bond);
        return bond;
    }

    public Bond addNewBond(String string, String string2, int n) {
        return this.addNewBond(this.getAtomNameIndex(string), this.getAtomNameIndex(string2), n);
    }

    public Bond addNewBondWithMappedSerialNumbers(int n, int n2, int n3) {
        return this.addNewBond(this.getAtomSerialNumberIndex(n), this.getAtomSerialNumberIndex(n2), n3);
    }

    public void addBond(Bond bond) {
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0) {
            if (Logger.isActiveLevel(0)) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + ":" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 32);
        }
        structure.modelIndex = this.currentAtomSetIndex < 0 ? 0 : this.currentAtomSetIndex;
        this.structures[this.structureCount++] = structure;
    }

    void setAtomSetSpaceGroupName(String string) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", string + "");
    }

    void setCoordinatesAreFractional(boolean bl) {
        this.coordinatesAreFractional = bl;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", bl);
        if (bl) {
            this.setGlobalBoolean(0);
        }
    }

    void setLatticeCells(int[] nArray, boolean bl) {
        this.latticeCells = nArray;
        this.isLatticeRange = (nArray[2] == 0 || nArray[2] == 1) && nArray[0] <= 555 && nArray[1] >= 555;
        this.doNormalize = !this.isLatticeRange || nArray[2] == 1;
        this.setApplySymmetryToBonds(bl);
    }

    boolean setNotionalUnitCell(float[] fArray) {
        this.notionalUnitCell = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.setGlobalBoolean(2);
        this.unitCell = new UnitCell(this.notionalUnitCell);
        return true;
    }

    void setGlobalBoolean(int n) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[n], Boolean.TRUE);
    }

    boolean addSymmetry(String string) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(this.doNormalize);
        }
        return this.spaceGroup.addSymmetry(string);
    }

    public void setLatticeParameter(int n) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(this.doNormalize);
        }
        this.spaceGroup.setLattice(n);
    }

    void applySymmetry() throws Exception {
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], this.latticeCells[2]);
    }

    void applySymmetry(SpaceGroup spaceGroup) throws Exception {
        this.spaceGroup = spaceGroup;
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], this.latticeCells[2]);
    }

    void applySymmetry(int n, int n2, int n3) throws Exception {
        if (this.coordinatesAreFractional && this.spaceGroup != null) {
            this.applyAllSymmetry(n, n2, n3);
        }
    }

    private void applyAllSymmetry(int n, int n2, int n3) throws Exception {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.getLastAtomSetAtomCount();
        int n9 = this.getLastAtomSetAtomIndex();
        this.bondCount0 = this.bondCount;
        SymmetryOperation[] symmetryOperationArray = this.spaceGroup.getFinalOperations(this.atoms, n9, n8, this.doNormalize);
        int n10 = symmetryOperationArray.length;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (this.isLatticeRange) {
            n11 = n / 100 - 5;
            n12 = n % 100 / 10 - 5;
            n13 = n % 10 - 5;
            n = n2 / 100 - 4;
            n3 = n2 % 10 - 4;
            n2 = n2 % 100 / 10 - 4;
        }
        int n14 = (n - n11) * (n2 - n12) * (n3 - n13);
        this.cartesians = new Point3f[n8 * n10 * n14];
        for (n7 = 0; n7 < n8; ++n7) {
            this.atoms[n7 + n9].bsSymmetry = new BitSet(n10 * (n14 + 1));
        }
        n7 = 0;
        int[] nArray = new int[n14];
        int n15 = 0;
        for (n6 = n11; n6 < n; ++n6) {
            for (n5 = n12; n5 < n2; ++n5) {
                for (n4 = n13; n4 < n3; ++n4) {
                    nArray[n15++] = 555 + n6 * 100 + n5 * 10 + n4;
                    if (n6 != 0 || n5 != 0 || n4 != 0 || this.cartesians.length <= 0) continue;
                    for (n7 = 0; n7 < n8; ++n7) {
                        Atom atom = this.atoms[n9 + n7];
                        this.cartesians[n7] = new Point3f(atom);
                        symmetryOperationArray[0].transform(this.cartesians[n7]);
                        this.unitCell.toCartesian(this.cartesians[n7]);
                        atom.bsSymmetry.set(n15 * n10);
                        atom.bsSymmetry.set(0);
                    }
                    n7 = this.symmetryAddAtoms(symmetryOperationArray, n9, n8, 0, 0, 0, n7, n15 * n10);
                }
            }
        }
        n15 = 0;
        for (n6 = n11; n6 < n; ++n6) {
            for (n5 = n12; n5 < n2; ++n5) {
                for (n4 = n13; n4 < n3; ++n4) {
                    ++n15;
                    if (n6 == 0 && n5 == 0 && n4 == 0) continue;
                    n7 = this.symmetryAddAtoms(symmetryOperationArray, n9, n8, n6, n5, n4, n7, n15 * n10);
                }
            }
        }
        if (n10 > 0) {
            String[] stringArray = new String[n10];
            for (n5 = 0; n5 < n10; ++n5) {
                stringArray[n5] = "" + (this.doNormalize ? symmetryOperationArray[n5].getXyz() : symmetryOperationArray[n5].getXyzOriginal());
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", stringArray);
        }
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", new Integer(n9));
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", new Integer(n8));
        this.setAtomSetAuxiliaryInfo("symmetryCount", new Integer(n10));
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.spaceGroup.getLatticeDesignation());
        this.setAtomSetAuxiliaryInfo("unitCellRange", nArray);
        this.spaceGroup = null;
        this.notionalUnitCell = new float[6];
        this.coordinatesAreFractional = false;
        this.setGlobalBoolean(1);
    }

    void setApplySymmetryToBonds(boolean bl) {
        this.applySymmetryToBonds = bl;
    }

    private int symmetryAddAtoms(SymmetryOperation[] symmetryOperationArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws Exception {
        boolean bl = n3 == 0 && n4 == 0 && n5 == 0;
        int n8 = symmetryOperationArray.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < n8; ++i) {
            Object object;
            int n9;
            if (bl && symmetryOperationArray[i].getXyz().equals("x,y,z")) continue;
            int n10 = n6;
            int n11 = n;
            int n12 = n11 + n2;
            for (n9 = n11; n9 < n12; ++n9) {
                object = new Atom();
                symmetryOperationArray[i].newPoint(this.atoms[n9], (Point3f)object, n3, n4, n5);
                Point3f point3f = new Point3f((Point3f)object);
                this.unitCell.toCartesian(point3f);
                Atom atom = null;
                int n13 = n10;
                while (--n13 >= 0) {
                    if (!((double)point3f.distance(this.cartesians[n13]) < 0.01)) continue;
                    atom = this.atoms[n + n13];
                    break;
                }
                if (atom != null) {
                    nArray[this.atoms[n9].atomSite] = atom.atomIndex;
                    atom.bsSymmetry.set(n7 + i);
                    atom.bsSymmetry.set(i);
                    continue;
                }
                nArray[this.atoms[n9].atomSite] = this.atomCount;
                Atom atom2 = this.newCloneAtom(this.atoms[n9]);
                atom2.x = ((Tuple3f)object).x;
                atom2.y = ((Tuple3f)object).y;
                atom2.z = ((Tuple3f)object).z;
                atom2.atomSite = this.atoms[n9].atomSite;
                atom2.bsSymmetry = new BitSet();
                atom2.bsSymmetry.set(n7 + i);
                atom2.bsSymmetry.set(i);
                this.cartesians[n6++] = point3f;
            }
            if (this.bondCount0 <= this.bondIndex0 || !this.applySymmetryToBonds) continue;
            for (n9 = this.bondIndex0; n9 < this.bondCount0; ++n9) {
                object = this.bonds[n9];
                int n14 = nArray[this.atoms[((Bond)object).atomIndex1].atomSite];
                int n15 = nArray[this.atoms[((Bond)object).atomIndex2].atomSite];
                if (n14 < n12 && n15 < n12) continue;
                this.addNewBond(n14, n15, ((Bond)object).order);
            }
        }
        return n6;
    }

    public void setCollectionName(String string) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                return;
            }
            this.collectionName = string;
        }
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int n = this.atomCount - 1;
            String string = this.atoms[n].atomName;
            if (string != null) {
                this.atomSymbolicMap.put(string, new Integer(n));
            }
        }
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount > 0) {
            int n = this.atomCount - 1;
            int n2 = this.atoms[n].atomSerial;
            if (n2 != Integer.MIN_VALUE) {
                this.atomSymbolicMap.put(new Integer(n2), new Integer(n));
            }
        }
    }

    void mapAtomName(String string, int n) {
        this.atomSymbolicMap.put(string, new Integer(n));
    }

    public int getAtomNameIndex(String string) {
        int n = -1;
        Object v = this.atomSymbolicMap.get(string);
        if (v != null) {
            n = (Integer)v;
        }
        return n;
    }

    int getAtomSerialNumberIndex(int n) {
        int n2 = -1;
        Object v = this.atomSymbolicMap.get(new Integer(n));
        if (v != null) {
            n2 = (Integer)v;
        }
        return n2;
    }

    public void setAtomSetCollectionProperty(String string, String string2) {
        ((Hashtable)this.atomSetCollectionProperties).put(string, string2);
    }

    String getAtomSetCollectionProperty(String string) {
        return (String)((Hashtable)this.atomSetCollectionProperties).get(string);
    }

    public void setAtomSetCollectionAuxiliaryInfo(String string, Object object) {
        this.atomSetCollectionAuxiliaryInfo.put(string, object);
    }

    public boolean setAtomSetCollectionPartialCharges(String string) {
        if (!this.atomSetCollectionAuxiliaryInfo.containsKey(string)) {
            return false;
        }
        Vector vector = (Vector)this.atomSetCollectionAuxiliaryInfo.get(string);
        int n = vector.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)vector.get(n)).floatValue();
        }
        return true;
    }

    public void mapPartialCharge(String string, float f) {
        this.atoms[this.getAtomNameIndex((String)string)].partialCharge = f;
    }

    public Object getAtomSetCollectionAuxiliaryInfo(String string) {
        return this.atomSetCollectionAuxiliaryInfo.get(string);
    }

    void addTrajectory() {
        if (this.trajectory.length == 0) {
            this.trajectory = new Point3f[this.atomCount];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            this.trajectory[i] = new Point3f(this.atoms[i]);
        }
        this.trajectories.addElement(this.trajectory);
        ++this.nTrajectories;
    }

    void finalizeTrajectories() {
        if (this.trajectory == null || this.trajectory.length == 0 || this.nTrajectories == 0) {
            return;
        }
        this.addTrajectory();
        Point3f[] point3fArray = (Point3f[])this.trajectories.get(0);
        for (int i = 0; i < this.atomCount; ++i) {
            this.atoms[i].set(point3fArray[i]);
        }
        this.setAtomSetCollectionAuxiliaryInfo("trajectories", this.trajectories);
    }

    public void newAtomSet() {
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            if (this.trajectory == null && this.atomCount > 0) {
                this.trajectory = new Point3f[0];
            }
            if (this.trajectory != null) {
                this.addTrajectory();
            }
            this.trajectory = new Point3f[this.atomCount];
            this.discardPreviousAtoms();
        }
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = ArrayUtil.doubleLength(this.atomSetNumbers);
            this.atomSetNames = ArrayUtil.doubleLength(this.atomSetNames);
            this.atomSetAtomCounts = ArrayUtil.doubleLength(this.atomSetAtomCounts);
            this.atomSetProperties = (Properties[])ArrayUtil.doubleLength(this.atomSetProperties);
            this.atomSetAuxiliaryInfo = (Hashtable[])ArrayUtil.doubleLength(this.atomSetAuxiliaryInfo);
        }
        this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        this.atomSymbolicMap.clear();
        this.setAtomSetAuxiliaryInfo("modelFileNumber", new Integer(this.currentAtomSetIndex + 1));
        this.setAtomSetAuxiliaryInfo("title", this.collectionName);
    }

    public void setAtomSetName(String string) {
        this.setAtomSetName(string, this.currentAtomSetIndex);
    }

    public void setAtomSetName(String string, int n) {
        this.atomSetNames[n] = string;
    }

    public void setAtomSetNames(String string, int n) {
        int n2 = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetName(string, n2);
            --n2;
        }
    }

    public void setAtomSetNumber(int n) {
        this.atomSetNumbers[this.currentAtomSetIndex] = n;
    }

    public void setAtomSetProperty(String string, String string2) {
        this.setAtomSetProperty(string, string2, this.currentAtomSetIndex);
    }

    public void setAtomSetAuxiliaryInfo(String string, Object object) {
        this.setAtomSetAuxiliaryInfo(string, object, this.currentAtomSetIndex);
    }

    boolean setAtomSetPartialCharges(String string) {
        if (!this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].containsKey(string)) {
            return false;
        }
        Vector vector = (Vector)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, string);
        int n = vector.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)vector.get(n)).floatValue();
        }
        return true;
    }

    Object getAtomSetAuxiliaryInfo(int n, String string) {
        return this.atomSetAuxiliaryInfo[n].get(string);
    }

    public void setAtomSetProperty(String string, String string2, int n) {
        if (this.atomSetProperties[n] == null) {
            this.atomSetProperties[n] = new Properties();
        }
        ((Hashtable)this.atomSetProperties[n]).put(string, string2);
    }

    void setAtomSetAuxiliaryInfo(String string, Object object, int n) {
        if (this.atomSetAuxiliaryInfo[n] == null) {
            this.atomSetAuxiliaryInfo[n] = new Hashtable();
        }
        if (object == null) {
            return;
        }
        this.atomSetAuxiliaryInfo[n].put(string, object);
    }

    public void setAtomSetProperties(String string, String string2, int n) {
        int n2 = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetProperty(string, string2, n2);
            --n2;
        }
    }

    public void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int n) {
        this.atomSetProperties[this.currentAtomSetIndex] = (Properties)((Hashtable)this.atomSetProperties[n]).clone();
    }

    int getAtomSetNumber(int n) {
        return this.atomSetNumbers[n];
    }

    String getAtomSetName(int n) {
        return this.atomSetNames[n];
    }

    Properties getAtomSetProperties(int n) {
        return this.atomSetProperties[n];
    }

    Hashtable getAtomSetAuxiliaryInfo(int n) {
        return this.atomSetAuxiliaryInfo[n];
    }

    boolean hasAlternateLocations() {
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.atoms[n].alternateLocationID == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getAltLocLists() {
        int n;
        if (!this.hasAlternateLocations()) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            char c = this.atoms[n].alternateLocationID;
            if (c == '\u0000' || stringArray[this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n2 = this.atoms[n].atomSetIndex;
            stringArray[n2] = stringArray[n2] + c;
        }
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("altLocs", stringArray[n], n);
        }
    }

    boolean hasInsertions() {
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.atoms[n].insertionCode == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getInsertionLists() {
        int n;
        if (!this.hasInsertions()) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            char c = this.atoms[n].insertionCode;
            if (c == '\u0000' || stringArray[this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n2 = this.atoms[n].atomSetIndex;
            stringArray[n2] = stringArray[n2] + c;
        }
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("insertionCodes", stringArray[n], n);
        }
    }
}

