/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import org.jmol.bspt.Bspt;
import org.jmol.bspt.SphereIterator;
import org.jmol.bspt.Tuple;

public final class Bspf {
    int dimMax;
    Bspt[] bspts;
    SphereIterator[] sphereIterators;

    public Bspf(int n) {
        this.dimMax = n;
        this.bspts = new Bspt[0];
        this.sphereIterators = new SphereIterator[0];
    }

    public int getBsptCount() {
        return this.bspts.length;
    }

    public void addTuple(int n, Tuple tuple) {
        Object object;
        if (n >= this.bspts.length) {
            object = new Bspt[n + 1];
            System.arraycopy(this.bspts, 0, object, 0, this.bspts.length);
            this.bspts = object;
        }
        if ((object = this.bspts[n]) == null) {
            this.bspts[n] = new Bspt(this.dimMax);
            object = this.bspts[n];
        }
        ((Bspt)object).addTuple(tuple);
    }

    public void stats() {
        for (int i = 0; i < this.bspts.length; ++i) {
            if (this.bspts[i] == null) continue;
            this.bspts[i].stats();
        }
    }

    public SphereIterator getSphereIterator(int n) {
        if (n >= this.sphereIterators.length) {
            SphereIterator[] sphereIteratorArray = new SphereIterator[n + 1];
            System.arraycopy(this.sphereIterators, 0, sphereIteratorArray, 0, this.sphereIterators.length);
            this.sphereIterators = sphereIteratorArray;
        }
        if (this.sphereIterators[n] == null && this.bspts[n] != null) {
            this.sphereIterators[n] = this.bspts[n].allocateSphereIterator();
        }
        return this.sphereIterators[n];
    }
}

