# The LearningOnline Network
# Passphrase Entry and Validation for Portfolio files 
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::restrictedaccess;

use strict;
use lib '/home/httpd/lib/perl/';
use Apache::Constants qw(:common :http REDIRECT);
use CGI::Cookie();
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonauth();
use Apache::lonlocal;
use Apache::lonacc;
use Fcntl qw(:flock);
use LONCAPA;

sub handler {
    my $r = shift;

    my $origurl = &unescape($env{'form.origurl'});
    if (!defined($origurl)) {
	$origurl = $r->uri;
    }
    my $msg='';
    if (exists($env{'form.pass1'})) {
        my ($result,$end) = &check_pass($r,$origurl);
        if ($result eq 'ok') {
	    &Apache::lonnet::allowuploaded('/adm/restrictedaccess',
					   $origurl);
	    $env{'request.state'} = "published";
	    $env{'request.filename'} = $origurl;
	    $r->header_out(Location => 'http://'.$ENV{'HTTP_HOST'}.$origurl);
	    return REDIRECT;
        } else {
	    $msg = 'Invalid passphrase';
	}
    }

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    $r->print(&Apache::loncommon::start_page('Passphrase protected file'));
    &print_entryform($r,$origurl,$msg);

    return OK;
}

sub setup_handler {
    my ($r) = @_;
    $r->set_handlers('PerlHandler'=> 
		     [\&Apache::restrictedaccess::handler]);
    $r->handler('perl-script');		    
}

sub print_entryform {
    my ($r,$origurl,$msg) = @_;

    $r->print('<script type="text/javascript">
function verify() {
    if (document.passform.pass1.value == "") {
        alert("You must enter a passphrase");
        return;
    }
    document.passform.submit();
} 
</script>');
    if ($msg ne '') {
	$r->print('<span class="LC_error">'.$msg.'</span>');
    }
    $r->print('<div align="center"><form name="passform" method="post" '.
              'action="/adm/restrictedaccess">');
    $r->print('<br /><br /><br />');
    $r->print(&Apache::loncommon::start_data_table());
    $r->print(&Apache::loncommon::start_data_table_row());     
    $r->print('<td><nobr>'.&mt('Passphrase: ').'</nobr></td>'.
              '<td><input type="password" size="20" name="pass1" /></td>');
    $r->print(&Apache::loncommon::end_data_table_row());
    $r->print(&Apache::loncommon::start_data_table_row());
    $r->print('<td align="center" colspan="2"><br />'.
              '<input type="button" name="sendpass" value="'.
              &mt('Submit passphrase').'" onClick="verify()" /></td>');
    $r->print(&Apache::loncommon::end_data_table_row());
    $r->print(&Apache::loncommon::end_data_table());
    $r->print('<input type="hidden" name="origurl" value="'.
              &escape($origurl).'" /></form></div>');
    $r->print(&Apache::loncommon::end_page());
}

sub check_pass {
    my ($r,$origurl) = @_;
    my (undef,$udom,$unum,$file_name,$group) = 
	&Apache::lonnet::parse_portfolio_url($origurl);

    my $curr_perms = &Apache::lonnet::get_portfile_permissions($udom,$unum);
    my %acc_controls = &Apache::lonnet::get_access_controls($curr_perms,
                                                            $group,$file_name);
    my $access_hash = $acc_controls{$file_name};

    my ($result,$end);
    foreach my $key (sort(keys(%{$access_hash}))) {
        if ($key =~ /^[^:]+:guest_(\d+)/) {
            $end = $1;
            if ($env{'form.pass1'} eq $access_hash->{$key}{'password'}) {
                $result = 'ok';
            } else {
                $result = 'fail';
            }
            last;
        }
    }
    return ($result,$end);
}

1;
