/*****************************************************************************
 * 
 *  jsMath: Mathematics on the Web
 *  
 *  This jsMath package makes it possible to display mathematics in HTML pages
 *  that are viewable by a wide range of browsers on both the Mac and the IBM PC,
 *  including browsers that don't process MathML.  See
 *  
 *            http://www.math.union.edu/locate/jsMath
 *
 *  for the latest version, and for documentation on how to use jsMath.
 *
 *  Copyright 2004-2007 by Davide P. Cervone
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *****************************************************************************/

if (!window.jsMath) {jsMath = {}}
if (!jsMath.Script) {jsMath.Script = {}}

jsMath.Script.Uncompress = function (data) {
  for (var k = 0; k <  data.length; k++) {
    var d = data[k]; var n = d.length;
    for (var i = 0; i < n; i++) {if (typeof(d[i]) == 'number') {d[i] = d[d[i]]}}
    data[k] = d.join('');
  }
  eval(data.join(''));
}

//start = new Date().getTime();
jsMath.Script.Uncompress([
  ['if(!','window','.jsMath','||!',1,'.','jsMath.','loaded','){var ','jsMath_old','=',1,2,';',0,'document.','getElementById','||!',15,'childNodes||!',15,'createElement','){','alert("','The',' mathematics ','on this page requires W3C DOM support in its JavaScript. "+"Unfortunately, your ','browser',' doesn\'t seem to have this.")}','else{',1,2,'={version:"3.4e",document:document,',1,':',1,',','platform',':(','navigator.',37,'.match(/','Mac/)?"mac":',39,37,41,'Win/)?"pc":"unix"),','sizes',':[50,60,70,85,100,120,144,173,207,249],','styles',':{".math','":"font-family:serif; font-style:normal; font-weight:normal','",".typeset',51,'; ','line-height:normal','","div.','typeset','":"text-align',':center; margin:1em 0px;","span.',57,58,':left',52,' span',58,62,'; border:','0px; margin:0px; ','padding:0px','",".typeset .','normal',51,70,'size0','":"font-size:','50','%",".typeset .','size1',75,'60',77,'size2',75,'70',77,'size3',75,'85',77,'size4',75,'100',77,'size5',75,'120',77,'size6',75,'144',77,'size7',75,'173',77,'size8',75,'207',77,'size9',75,'249',77,'cmr10','":"font-family:jsMath-',114,', serif',70,'cmbx10',115,119,', ','jsMath-cmr10',70,'cmti10',115,125,', ',123,70,'cmmi10',115,131,70,'cmsy10',115,135,70,'cmex10',115,139,70,'textit','":"font-family',':serif; ','font-style:italic',70,'textbf',144,':serif; font-weight:bold',70,'link":"','text-decoration:none',70,'error',75,'10pt; ',146,'; "+"','background-color',':#FFFFCC; padding:1px',159,'border:','1px solid',' #CC0000',70,'blank":"','display:inline-block','; ','overflow:hidden',67,'0px none; width:0px','; height:','0px;",".','typeset .','spacer','":"',168,'","#jsMath_hiddenSpan":"','visibility',':','hidden','; ','position:absolute','; top:0px',';left:0px',159,55,'; text-indent:0px","#','jsMath_message','":"','position:fixed','; bottom:1px; ','left:2px; ',160,':#E6E6E6','; "+"border:solid 1px #959595; margin:0px; padding:','1px 8px','; "+"z-index:102; color',': black','; font-size:','small; ','width:auto',';","#','jsMath_panel','":"',192,'; bottom:1.5em; right:1.5em','; padding:.8em 1.6em',159,160,':#DDDDDD',67,'outset 2px',159,'z-index:103; ',203,'; color:black',201,'10pt; font-style:normal","#',205,' .disabled":"color:#888888","#',205,' .infoLink',75,'85%","#',205,' *":"','font-size:inherit; font-style:inherit; font-family:inherit','; ',55,'","#',205,' div":"',160,':inherit; color:inherit;","#',205,' span":"',160,236,205,' td','":"border:0px; padding:0px; margin:0px; background-color:inherit; color:inherit;","#',205,' tr',243,205,' table',243,'jsMath_button','":"',192,193,'right:2px; ',160,':white',197,'0px 3px 1px 3px',199,':black; ',153,201,'x-small',159,203,'; cursor:hand;","#',250,228,69,67,68,55,159,229,'","#jsMath_global":"',146,';","#jsMath_float','":"',184,185,'; left:0px; max-width:80%; "+"z-index:101; ',203,'; height:auto',277,' .drag":"',160,':#DDDDDD',67,'outset 1px',173,'12px',201,'1px',277,' .close":"',160,196,67,'inset 1px; width:8px',173,'8px; margin:1px 2px',277,' .source":"',160,':#E2E2E2',67,289,159,203,283,'; padding:8px 15px',159,'font-family:courier, fixed',201,'90%","#jsMath_noFont .message',58,': center',209,67,'3px solid #DD0000',159,160,':#FFF8F8; color: #AA0000',201,202,203,204,'jsMath_noFont .link','":"',69,' 5px 2px 5px',67,'2px outset; ',160,':#E8E8E8',159,'color:black',201,'80%; ',203,266,'jsMath_PrintWarning',' .message',58,':center',209,67,'3px solid #DD0000',159,160,': #FFF8F8; color: #AA0000',201,'x-',202,203,';","@media print":"#',250,' {display:none','}\\n"+"#jsMath_Warning',358,'}","@media screen":"#',342,358,'}"},Element',':function(','A){return ',6,15,16,'("jsMath_"+A)},','BBoxFor',365,'A','){this.','hidden.innerHTML','="<nobr><','span class=\\"',57,'\\"><',377,'scale\\">"+A+"</span></span></nobr>";var B={w:this.',182,'.offsetWidth',',h:this.',182,'.offsetHeight','};this.',375,'="";return B},EmBoxFor',365,'B){var A=',6,'Global.cache.R;if(!A[this.em]){A[this.em]={}}if(!A[this.em][B]){var C=this.BBoxFor(B);','A[this.em][B]={w:C.w/this.em,h:C.h/this.em}}return A[this.em][B]},','EmBoxForItalics',365,391,6,393,'if(B.match(/<i>|class=\\"(icm|italic|igreek|iaccent)/i)){C.w=C.Mw','=this.BBoxFor','(B+',6,'Browser.','italicString',').w-',6,404,'italicCorrection','}',394,'Init',':function(){','if(',6,'Setup.inited','!=1){',0,6,416,'){',6,'Setup.','Body()}if(',6,416,'!=1){if(',6,416,'==-100','){return }',23,'It looks like jsMath failed to set up properly (error code "+',6,416,'+").  "+"I will try to keep going, but it could get ugly.");',6,416,'=1}}this.em',401,'("<span style=\\""+',6,404,'block+";','width:13em;height:1em','\\"></span','>").w/13;','if(this.','em==0',374,'em',401,'("<img src=\\""+',6,'blank+"\\" style=\\"',445,'\\"/>").w/13}','var A=',6,'Global.cache','.B;',0,'A[this.em]){A[this.em]={};','A[this.em].','bb',401,'("x");','var C=',464,'bb.h;',464,'d',401,'("x"+',6,'HTML.Rule(1,','C/',6,'em)).h-C;if(',6,404,405,'){',464,'ic=',6,371,'(',6,404,405,').w}}',6,404,409,'=',464,'ic;var F=',464,'bb;var D=F.h;var E=',464,'d;this.h=(D-E)/this.em;this.d=E/this.em;this.hd=this.h+this.d;this.xWidth=F.w;this.',423,'TeXfonts','();var B=this.EmBoxFor("<',377,114,'\\">M</span>").w/2;this.TeX.M_height=B*(26/14);this.TeX.h=this.h;this.TeX.d=this.d;this.TeX.hd=this.hd;this.Img.Scale();',0,'this.initialized',374,423,'Sizes','();this.','Img.UpdateFonts()}this.p_height=(','this.TeX.cmex10[0].','h+',516,'d)/0.85;',510,'=1},ReInit',413,'var A',401,'("x").w;if(A!=this.xWidth',374,'Init()}},Loaded',413,'if(',9,8,'B=["Process","ProcessBeforeShowing","ConvertTeX","ConvertTeX2","ConvertLaTeX","ConvertCustom","CustomSearch","Synchronize","Macro","document"];','for(var A=0;A<','B','.length;A++){','if(',9,'[B[A]]){','delete ',9,'[B[A]]}}}if(',9,'){this.Insert(','jsMath,',9,')}',9,'=null;',6,7,'=1},Add',365,'C,A){for(var B in A){','C[B]=A[B]}},Insert',365,553,'if(C[B]&&typeof (A[B])=="object"&&(','typeof (C[B])=="','object"||',558,'function")){this.Insert(C[B],A[B])}',29,'C[B]=A[B]}}},Package',365,'B,A',543,'B.prototype,A)}};',6,'Global={isLocal:1,cache:{','T:{},D:{},R:{},B',':{}},ClearCache',413,6,460,'={',570,':{}}},GoGlobal',365,391,'String(',6,1,'.','location);var C','=(',6,'isCHMmode','?"#":"?");if(B){A=A.replace(/\\?.*/,"")+"?"+B}',6,'Controls.','Reload(',6,'root+"jsMath-','global.html"+C+escape(A))},Init',413,'if(',6,'Controls.cookie.','global=="always"&&!',6,'noGoGlobal','){','if(navigator.','accentColorName',431,0,6,1,'){',6,1,'=',1,'}',6,590,7,'=1;',6,590,'defaults.hiddenGlobal',548,'this.GoGlobal(',6,590,'SetCookie(2))}},Register',413,458,6,1,'.parent;',0,6,'isCHMode){',6,587,'=(',6,1,'.','location.','protocol=="mk:")}try{',0,6,587,374,'Domain()}if(A',2,'&&A.',6,'isGlobal){A.',6,'Register(',6,1,')}}catch(B){',6,601,'=1}},Domain',413,603,'appName=="Microsoft Internet Explorer"&&',6,37,'=="mac"&&',39,'userProfile','!=null',431,'if(',1,'==parent',431,'var B=',6,15,'domain;try{while(true){try{if(parent.',15,'title',668,'){return }}','catch(A){}',0,15,'domain.match(/\\..*\\./)){break}',6,15,'domain=',6,15,'domain.replace(/^[^.]*\\./,"")}}',682,6,15,688,'B}};',6,'Script={request:null,Init',413,'if(!(',6,598,'asynch&&',6,598,'progress',')){if(',1,'.XMLHttpRequest','&&!(',6,15,'URL&&',6,15,'URL.match(/^file:\\/\\/.*\\\\/))){try{','this.request','=new XMLHttpRequest}catch(C){}}',0,717,'&&',1,'.','ActiveXObject',8,'A=["MSXML2.XMLHTTP.5','.0","MSXML2.XMLHTTP','.4',727,'.3',727,'","Microsoft.XMLHTTP"];','for(var B=0;B<','A.length&&!',717,';B++){try{',717,'=new ',724,'(A[B])}catch(C){}}}}',0,717,'||',6,423,'domainChanged',374,'Load=this.delayedLoad;this.needsBody=1}},Load',365,'B,A){','if(A){',6,'Message.Set("Loading "+','B);',6,'Script.','Delay(1);',6,'Script.Push(','this,"xmlRequest",B',');',6,759,6,'Message',',"Clear")}',29,6,759,760,')}},xmlRequest',365,'url){','this.blocking','=1;try{',717,'.open("GET",url,false);',717,'.send(null)}catch(err){',774,'=0;if(',6,'Translate.','restart&&',6,'Translate.asynchronous){return""}throw"jsMath can\'t load the file \'"+url+"\'\\n"+"',765,': "+err.message}if(',717,'.status','&&',717,790,'>=400){',774,781,6,783,'restart&&',6,786,'Error status: "+',717,790,'}',0,'url','.match(/\\.js$/)){','return(',717,'.responseText',')}var tmpQueue','=this.queue;this.queue','=[];',6,1,'.eval(',717,811,');',774,'=0;','this.queue=this.queue.concat(','tmpQueue);this.Process();return""},cancelTimeout:30*1000,iframe:null,blocking:0,cancelTimer:null,needsBody:0,queue:[],Synchronize',365,'A,B){','if(typeof (','A)!="string"){',6,759,'null,A,B)}',29,6,759,6,1,',"eval",A)}},Push',365,'A,C,B){','this.queue','[',840,'.length]=[A,C,B];if(!(',774,'||(this.needsBody&&!',6,15,'body))){this.Process()}},Process',413,'while(',840,'.length&&!',774,8,'C=',840,'[0];',840,'=',840,'.slice(1);',458,'this.SaveQueue();var B=C[0];var E=C[1];var D=C[2];if(B){B[E](D)}',29,'if(E){E(D)}}this.','RestoreQueue','(A)}},SaveQueue',413,'var A',813,'=[];return A},',866,365,'A){',823,'A)},delayedLoad',365,'A',374,'Push(this,"startLoad",A)},startLoad',365,'A){','this.iframe','=',6,15,21,'("iframe");','this.iframe.style.',180,'="',182,'";',889,'position="absolute";',889,'width="0px";',889,'height="0px','";if(',6,15,'body.firstChild','){',6,15,'body.insertBefore(',883,',',6,15,903,')}',29,6,15,'body','.appendChild(',883,')}',774,'=1;this.','url=A;',0,'A',808,883,'.src=A}',29,883,'.src=',6,593,'loader.html"}if(A.substr(0,',6,'root.length',')==',6,'root){A=A.substr(',6,936,')}',6,753,'A);','this.cancelTimer','=setTimeout("',6,756,'cancelLoad','()",this.cancelTimeout)},endLoad',365,'A){if(',946,'){clearTimeout(',946,');',946,'=null}',6,765,'.Clear();if(A!="cancel"){',774,'=0;this.Process','()}},Start',413,'this.tmpQueue',813,'=[]},End',413,823,967,');',539,967,'},',950,413,946,548,6,765,'.Set("Can\'t load file");this.endLoad("cancel")},Delay',365,'A){',774,'=1;setTimeout("',6,756,'endDelay','()",A)},',990,413,774,964,'()},','imageCount',':0,WaitForImage',365,'B){',774,922,997,'++;',448,'img==null',374,'img=[]}',458,'new Image',514,'img[this.img.length]=A;A.onload=function(){if(--',6,756,997,'==0){',6,756,990,'()}};A.onerror=A.onload;A.onabort=A.onload;A.src=B},Uncompress',365,'data){for(var k=0;k<data.length;k++){var d=data[k];var n=d.length;for(var i=0;i<n;i++){',827,'d[i])=="number"){d[i]=d[d[i]]}}data[k]=d.join("")}',1,817,'data.join(""))}};',6,765,'={blank:null,message:null,text:null,clear:null,Init',413,0,6,15,'body||!',6,598,706,431,'if(',6,423,'stylesReady){','this.message','=',6,'Setup.DIV("message",{visibility:"hidden','"})}',29,1044,'=',6,1047,'",position:"absolute",','bottom:"1px",left:"2px",','backgroundColor',':"#E6E6E6",border:"solid 1px #959595",margin:"0px",padding:"1px 8px",zIndex:102,color:"black",fontSize:"small",width:"auto"})}','this.text','=',6,15,'createTextNode','("");',1044,918,1058,');',1044,'.onmousedown=',6,783,'Cancel},Set',365,750,'if(this.clear){clearTimeout(this.clear',');this.clear=null}if(',6,598,706,'){',0,1058,374,'Init();',0,1058,681,'if(',6,404,'textNodeBug','){',1044,'.innerHTML','=B}',29,1058,'.nodeValue','=B}','this.message.style.',180,'="visible";',751,1100,'cursor="pointer";',0,1100,'cursor){',1100,'cursor="hand"}',1044,'.title=" Cancel Processing of Math "}',29,1100,'cursor="";',1044,'.title=""}}',29,'if(B.substr(0,8)!="Loading "){',6,1,790,'=B}}},Clear',413,1075,')}this.clear=setTimeout("',6,765,'.doClear()",1000)},doClear',413,448,'clear',374,'clear',548,6,1,790,'="";if(',1058,'){',1058,1098,'=""}if(',1044,'){',1100,180,'="',182,'"}}},Blank',413,'if(','this.blank','||!',6,15,'body',431,1154,'=',6,423,'DIV("blank",{position:(',6,404,'msiePositionFixedBug','?"absolute":"fixed"),top:"0px",left:"0px",bottom:"0px",right:"0px",zIndex:101,',1056,':"white"});if(',6,404,'msieBlankBug){',1154,1094,'="&nbsp;";',1154,'.style.width="110%";',1154,'.style.height="110%"}},UnBlank',413,'if(',1154,'){',6,15,'body.removeChild(',1154,')}',1154,'=null}};',6,'Setup={',7,':[],DIV',365,'D,B',8,'C=',6,15,21,'("div");C.id="jsMath_"+D;','for(var A in ','B){C.style[A]=B[A]}',0,6,15,'body.hasChildNodes){',6,15,'body',918,'C)}',29,6,15,907,'C,',6,15,903,')}return C},Script',365,750,448,7,'[B]){return }',29,'this.',7,'[B]=1}',0,'B.match("^([a-zA-Z]+:/?)?/")){B=',6,'root+B}',6,756,'Load(B,A)},Hidden',413,6,182,'=this.DIV("Hidden",{',180,':"',182,1054,'top:0,left:0,border:0,padding:0,margin:0});',6,'hiddenTop=',6,182,';return },Source',413,'if(',6,'Autoload','&&',6,1257,'.root){',6,'root=',6,1257,'.','root}',29,6,'root="";',458,6,15,'getElementsByTagName("','script");',751,733,'A.','length;B++){','var D=A[B].src;if(D&&D.match("(^|/|\\\\\\\\)',6,'js$")){',6,1263,'D.','replace(/',6,'js$/,"");break}}}}if(',6,'root.charAt(','0)=="\\\\"){',6,1263,6,'root.replace','(/\\\\/g,"/")}if(',6,1290,'0)=="/"){if(',6,1290,'1)!="/"){if(',6,15,641,'port){',6,'root=":"+',6,15,641,'port+',6,1267,6,'root="//"+',6,15,641,'host+',6,1267,6,1263,6,15,641,'protocol+',6,1267,29,0,6,'root.match','(/^[a-z]+:/i)){var D=','new String(',6,15,584,'=new RegExp("/[^/]*/\\\\.\\\\./");',6,1263,'D.replace(new RegExp("[^/]*$"),"")+',6,'root;while(',6,1334,'(C)){',6,1263,6,1295,'(C,"/")}}}',6,'Img.',1263,6,'root+"fonts/";',6,'blank=',6,'root+"blank.gif";this.Domain()},Domain',413,'try{',6,15,'domain}catch(D',431,'var C="";',458,6,15,'domain;if(',6,1334,'("://([^/]*)/")){C=RegExp.$1}C=C.replace(/:\\d+$/,"");if(C==""||C==A',431,603,'appName=="Microsoft Internet Explorer"&&',6,37,'=="mac"&&',39,'onLine&&',39,667,'&&',6,15,'all',431,'C=C.split(/\\./);A=A.split(/\\./);if(C.length<2||A.length<2||','C[C.length-','1',']!=A[A.length-','1]||',1393,'2',1395,'2]){this.','DomainWarning','();return }var E=',1393,'2]+"."+',1393,'1];for(var B=3;B<=C.length&&B<=A.',1279,'if(',1393,'B',1395,'B]){break}E=',1393,'B]+"."+E}',6,15,688,'E;this.',746,'=1},',1401,413,23,'In order for jsMath to be able to load the additional "+"components that it may need, the ',6,'js file must be "+"',7,' from a server in the same domain as the page that "+"contains it.  Because that is not the case for this page, "+"the',25,'displayed here may not appear correctly.")},','EncodeFont',365,'C',8,'B=',6,'TeX[C];if(B','[0].c',668,431,533,'128;A++){var D=B[A];B[A]=D[3];if(B[A]==null){B[A]={}}B[A].w=D[0];B[A].h=D[1];if(D[2]!=null){B[A].d=D[2]}B[A].c=',6,'TeX.encoding[A]}},Fonts',413,733,6,'TeX.fam.length;','B++){',458,6,'TeX.fam[','B];if(A',374,1431,'(A)}}},TeXfont',365,'C',8,'B=',6,1437,'==null',431,458,6,'EmBoxFor("<span class=\\""+C+"\\">"+B[65].c','+"</span>");B.hd=A.h;B.dh=0.05;B.d=',6,1467,'+',6,476,'B.hd)+"</span>").h-B.hd;B.h=B.hd-B.d;','if(C=="',131,'"){B.skewchar=','127}',29,1475,135,1477,'48}}},',504,413,533,6,1448,'A++){if(',6,1452,'A]){this.TeXfont(',6,1452,'A])}}},Sizes',413,6,'TeXparams','=[];var B;var A;for(A=0;A<',6,47,535,6,1498,'[A]={}}for(B in ',6,'TeX){',827,6,'TeX[B])!="object"){for(A=0;A<',6,47,535,6,1498,'[A][B]=',6,47,'[A]*',6,'TeX[B]/100}}}},Styles',365,'A){',0,'A){A=',6,49,';A[".',175,'scale"]="font-size:"+',6,598,'scale+"%";this.stylesReady=1}',6,759,'this,"','AddStyleSheet','",A);if(',6,404,'styleChangeDelay','){',6,759,6,'Script,"Delay",1)}},',1537,365,'D',8,'B=',6,15,1274,'head")[0];var A="";for(var E in D){A+=E+" {"+D[E]+"}\\n"}if(',6,15,'createStyleSheet){B.insertAdjacentHTML("beforeEnd","<','span style=\\"','display:none\\">x</span>"+"<style type=\\"text/css\\">"+A+"</style>")}',29,468,6,15,21,'("style");C.type="text/css";C',918,6,15,1062,'(A));B',918,'C)}},Body',413,448,'inited',431,'this.inited=-','1;',6,423,'Hidden();',1578,'2;',6,404,1084,1578,'3;if(',6,598,'blank){',6,765,'.Blank()}',1578,'4;',6,423,'Styles();',1578,'5;',6,590,1084,1578,'6;',6,759,6,'Setup,"User","pre-font");',1578,'7;',6,759,6,'Font,"Check");if(',6,'Font.register.length){',6,759,6,'Font,"LoadRegistered")}this.inited=1},User',365,953,6,'Setup.UserEvent[A',']){(',6,1627,'])()}},UserEvent:{"pre-font":null,"onload":null}};',6,'Update={',504,365,'D){',1204,'D){for(var B in D[A]){for(var C in D[A][B]){',6,'TeX[A][B][C]=D[A][B][C]}}}},TeXfontCodes',365,'C){',1204,'C){',733,'C[A].',1279,6,'TeX[A][B].c=C[A][B]}}}};',6,'Browser={allowAbsolute:1,allowAbsoluteDelim:0,separateSkips:0,valignBug:0,operaHiddenFix:"",','msieCenterBugFix',':"",','msieInlineBlockFix',':"",','msieSpaceFix',':"",imgScale:1,renameOK:1,',1541,':0,delay:1,version:0,','TestSpanHeight',413,6,375,'="<span','><','span style=\\""+this.block+";','height:2em;width:','1px',446,'></span>";var B=',6,'hidden.firstChild;',458,'B.firstChild;','this.spanHeightVaries','=(B',386,'>=A',386,'&&B',386,'>0);','this.spanHeightTooBig','=(B',386,'>A',386,');',6,375,'=""},','TestInlineBlock',413,'this.block','="display:-moz-inline-box";','this.hasInlineBlock','=',6,'BBoxFor("<span style=\\""+this.block+";','width:10px;height:5px\\"></span>").w>0;if','(',1696,'){',6,'styles[".typeset .','blank"]=',6,1705,'blank','"].replace(/',168,'/,',1694,');',6,1705,176,'"]=',6,1705,176,1710,168,'/,"")}',29,1694,'="',168,'";',1696,'=',6,1699,1700,'(!',1696,681,1694,'+=";',170,'";',458,6,371,'("x").h;this.mozInlineBlockBug=',6,1699,'height:"+A+"px;width:1px',446,'>x"+"<',1666,1748,';vertical-align:-"+A+"px',446,'>").h>2*A;this.widthAddsBorder=',6,1699,170,';height:1px;width:10px',';border-left:','10px solid',446,'>").w>10;','this.msieBorderBug','=',6,1699,1748,446,'>x").h!=',6,1699,1748,1760,164,446,'>x").h;this.blankWidthBug=',1764,'||',6,1699,1667,'0px',446,'>").h==0},','TestRenameOK',413,6,375,1664,'></span>";',458,6,1672,'A.setAttribute("name","','jsMath_test','");this.renameOK=(',6,15,'getElementsByName("',1796,'").length>0);',6,375,1691,'TestStyleChange',413,6,375,1664,' ID=\\"',1796,'\\">x</span>";var B=',6,1672,458,'B',383,';',6,423,1537,'({"#',1796,75,'200%"});this.',1541,'=(B',383,'==A);',6,375,1691,'VersionAtLeast',365,391,1336,'this.version',').split(".");','B=',1336,'B',1839,'if(B[1]==null){B[1]="0"}return A[0]>B[0]||(A[0]==B[0]&&A[1]>=B[1])},Init',413,6,27,'="unknown";this.',1692,514,1660,514,1786,514,1806,514,'MSIE',514,'Mozilla',514,'Opera',514,'OmniWeb',514,'Safari',514,'Konqueror','();if(','this.allowAbsoluteDelim','){',6,'Box.DelimExtend=',6,'Box.DelimExtendAbsolute;',6,'Box.Layout=',6,'Box.LayoutAbsolute}',29,6,'Box.DelimExtend=',6,'Box.DelimExtendRelative;',6,'Box.Layout=',6,'Box.LayoutRelative}if(','this.separateSkips','){',6,'HTML.Place=',6,'HTML.','PlaceSeparateSkips',';',6,'Typeset.prototype.','Place=',6,1897,1894,'}},MSIE',413,'if(',1675,'&&!',1683,'){',6,27,'="MSIE',900,6,37,'=="pc"){this.','IE7=(',1,709,668,');this.quirks=(',6,15,'compatMode=="BackCompat");this.msieStandard6=!this.quirks&&!','this.IE7',';',1869,'=1;',1888,'=1',';this.buttonCheck=1;this.','msieBlankBug=1;this.','msieAccentBug',922,'msieRelativeClipBug','=1;this.msieDivWidthBug=1;this.',1167,922,'msieIntegralBug',922,'waitForImages',922,'msieAlphaBug=!',1924,';this.','alphaPrintBug','=!',1924,';this.',1652,'="position:relative; ";this.',1654,'=" ',168,';";this.msieTeXfontBaselineBug=!',6,404,'quirks;',0,1924,374,1656,'="<',1559,168,446,'>"}',6,'Macro("joinrel","\\\\mathrel{\\\\kern-5mu}"),',6,'Parser.prototype.mathchardef.','mapstocharOrig','=',6,1970,'mapstochar;',539,6,1970,1975,6,'Macro("mapstochar","\\\\rlap{\\\\',1971,'\\\\,}\\\\kern1mu"),',6,1705,'arial"]="font-family: \'Arial unicode MS\'";',0,1924,'||this.quirks){',6,'styles["#',190,'"]=',6,1991,190,1710,192,'/,"',184,'").',1286,203,'/,"");',6,1991,205,'"]=',6,1991,205,1710,192,'/,"',184,'").',1286,203,'/,"");',6,1991,250,'"]="width:','1px; "+',6,1991,250,1710,192,'/,"',184,'").',1286,203,'/,"");',6,1,'.attachEvent("','onscroll",',6,590,'MoveButton',');',448,'IE7){',6,1,2038,'onresize",',6,590,2042,')}this.msieMoveButtonHack=',1924,'}',6,1991,328,'"]+=" ','display: inline-block',';";',6,1705,176,'"]=',6,1705,176,1710,168,'/,"");',6,49,'[".tex2math_div"]=',6,49,'["div.',57,'"]+"; width: 100%; ',2060,900,'screen.deviceXDPI','&&','screen.logicalXDPI','&&',2082,'!=',2084,374,'imgScale*=',2084,'/',2082,';',6,598,'alpha=0}this.',405,'="<i>x</i>";',6,'EmBoxFor=',6,395,'}',29,'if(',6,37,'=="mac"){this.msieAbsoluteBug',922,'msieButtonBug',1935,1931,'quirks=1;',6,423,'Script("jsMath-msie-mac.js");',6,'Parser.prototype.macros.angle=["Replace","ord","<font face=\\"Symbol\\">&#x8B;</font>","normal"];',6,1991,205,2023,'42em; "+',6,1991,205,1710,203,'/,"");',6,598,'printwarn=0}}',6,'Macro("not","\\\\mathrel{\\\\rlap{\\\\kern3mu','/}}")}},',1859,413,'if(',6,182,'.ATTRIBUTE_NODE){',6,27,'="',1859,900,6,37,1915,1945,'=1}',1869,'=1;',6,1991,250,'"]=',6,1991,250,1710,'cursor:hand','/,"cursor:pointer");',6,1991,328,'"]=',6,1991,328,1710,2163,'/,"cursor:pointer");',6,2135,'/}}");',603,'vendor=="Firefox"){',1838,'=',39,'vendorSub}',29,603,'userAgent.match','(" Firefox/([0-9.]+)( |$)")){',1838,'=RegExp.$1}}}},',1863,413,603,'accentColorName){',6,27,'="',1863,'";','this.allowAbsolute','=',1696,';',1869,'=',2199,';this.valignBug=!',2199,1930,1091,'=1;',6,'noChangeGlobal=1;',0,1696,'){',6,'Setup.Script("jsMath-old-browsers.js','")}}},Opera',413,'if(',1683,'){',6,27,'="Opera";',458,39,2186,'("Opera 7");',2199,'=0;this.delay=10;this.operaHiddenFix="[Processing]";',751,6,2217,'")}}},Safari',413,603,'appVersion',41,'Safari\\//)){',6,27,'="Safari";',458,39,2186,'("Safari/([0-9]+)");A=(A)?A[1]:400;',733,6,1448,'B++){if(',6,1452,'B]&&',6,'TeX[',6,1452,'B]]){',6,'TeX[',6,1452,'B]].dh=0.1}}',6,'TeX.axis_height+=0.05;',6,'TeX.default_rule_thickness+=0.025;',1869,'=A>=125;this.safariIFRAMEbug=A>=312&&A<412;this.safariButtonBug=A<412;this.safariImgBug',922,1091,'=1',1930,1541,'=1}},',1867,413,603,'product&&',39,'product.match("',1867,'")){',6,27,'="',1867,'";',2199,'=0;',1869,'=0;',603,2186,'(/',1867,'\\/(\\d+)\\.(\\d+)/)){if(RegExp.$1<3||(RegExp.$1==3&&RegExp.$2<3)){',1888,922,'valignBug=1;',6,2217,'")}}',6,'Add(',6,49,',{".',175,114,144,': ',123,', jsMath ',114,', serif',70,119,144,': jsMath-',119,2315,119,''],
  [', ','jsMath','-','cmr10',', ',1,' ',3,'",".typeset .','cmti10":"','font-family: ',1,'-cmti10, ',1,' cmti10, ',1,'-',3,', ',1,' ',3,8,'cmmi10','":"',10,1,'-',23,', ',1,' ',23,8,'cmsy10','":"',10,1,'-',34,', ',1,' ',34,8,'cmex10','":"',10,1,'-','cmex10, ',1,' cmex10','"});',1,'.Font.testFont','="',1,'-',50,1,52,'"}}};',1,'.Font={testFont:"',1,'-',45,'",fallback:"symbol",register:[],message:"<b>No ',1,' TeX fonts ','found</b> -- using',' image fonts instead','.<br/>\\n"+"','These may be slow and might not print well',73,'Use the ',1,' control panel to get additional information.",','extra_message',':"Extra',70,'not found: <b><span id=\\"jsMath_ExtraFonts\\"></span></b><br/>"+"Using',72,'.  This may be slow and might not print well',73,'Use the ',1,78,'print_message',':"To print higher-resolution math symbols, click the<br/>\\n"+"<b>Hi-Res Fonts for Printing</b> button on the ',1,' control panel.<br/>\\n",','alpha_message',':"If the math symbols print as black boxes, turn off <b>image alpha channels</b><br/>\\n"+"using the <B>Options</B> pane of the ',1,92,'Test1',':function(','C',',F,D,E){if(F==null){F=124}if(D==null){D=2}if(E==null){E=""}var B=jsMath.BBoxFor("<span style=\\"font-family: "+E+C+", serif\\">"+jsMath.TeX[C][F].c+"</span>");var A=jsMath.BBoxFor("<span style=\\"font-family: serif\\">"+jsMath.TeX[C][F].c+"</span>");return','(B.w>D*A.w&&B.h!=0)},Test2',98,'C',100,'(A.w>D*B.w&&B.h!=0)},CheckTeX',':function(){var A=',1,'.BBoxFor("<','span style=\\"','font-family: "+',1,55,'+", serif\\">"+',1,'.TeX.',45,'[1','].c+"</span>");',1,'.nofonts=((A.w*3>A.h||A.h==0)&&!this.Test1("cmr10','",null,null,"',1,'-"));if(',1,'.nofonts','&&(',1,'.platform','!="mac"||',1,'.browser!="Mozilla"||!',1,'.Browser.','VersionAtLeast(1.5))){A=',1,'.BBoxFor("<',109,10,50,'serif\\">"+',1,115,45,'[1',118,1,120,'"));if(!',1,125,'){',1,'.Setup.','Script','("',1,'-BaKoMa-fonts.js")}}},Check',106,1,'.Controls','.cookie',';this.CheckTeX();if(',1,125,'){if(A.autofont||A','.font=="tex"){','A.font=this.fallback;if(A.warn){',1,'.nofontMessage=1;A.warn=0;',1,160,'.SetCookie(0);if','(',1,'.window.NoFontMessage','){',1,175,'()}else{','this.Message(this.','message)}}}}else{if(A.autofont){A.font="tex"}if(A',166,'return }}if(',1,'.noImgFonts){','A.font="unicode"}if(A','.font=="unicode','"){',1,153,154,'("',1,'-fallback','-"+',1,128,'+".js");',1,'.Box.TeXnonfallback=',1,'.Box.TeX',';',1,202,'=',1,'.Box.TeXfallback;return }','if(!A.print&&A.printwarn){this.','PrintMessage','((',1,133,'alphaPrintBug&&',1,160,161,'.alpha)?this.',89,'+this.',93,':this.',89,')}if(',1,133,'waitForImages){',1,'.Script.','Push(',1,'.',154,',"WaitForImage",',1,'.blank)}if(A.font=="symbol"){',1,153,154,'("',1,194,'-symbols.js");',1,'.Box.TeXnonfallback=',1,202,';',1,202,'=',1,208,1,'.Img.SetFont','({',3,':["all"],',23,258,34,258,45,258,'cmbx10',258,'cmti10:["all"]});',1,'.Img.LoadFont','("cm-fonts")},Message',98,'A){if(',1,'.Element("','Warning")){','return }var ','B=',1,153,'DIV("Warning','",{});B.innerHTML="<center><table><tr><td>"+"<div ','id=\\"jsMath_noFont\\"><div ','class=\\"message\\">"+A','+"<div style=\\"text-align:left\\"><',109,'float:left; ','margin: 8px ','0px 0px 20px\\">"+"<span onclick=\\"',1,160,'.Panel()\\" ','title=\\" Open ','the ',1,' Control Panel',' \\" class=\\"link\\">',1,295,'</span>"+"</span','><',109,287,'20px 0px 0px; float:right\\">"+"<span onclick=\\"',1,'.Font.','HideMessage','()\\" title=\\" Remove this font warning message',296,'Hide this Message',299,'></div><div style=\\"height:6px\\"></div><br clear=\\"all\\"/></div></','div>"+"<div style=\\"width:22em; height:1px\\"></div>"+"</td></tr></table></center><hr/>"},',306,106,1,274,'Warning");if(A','){A.style.display="none"}},',210,98,272,1,274,'PrintWarning','")){',276,'B=',1,153,'DIV("',324,281,283,'+"</',312,'Register',98,'H,B){if(typeof (H)=="string"){H={name:H}}if(!',1,153,'inited&&!B){','this.register','[',342,'.length]=H;',276,'I=H.name;var A=I.replace(/10$/,"");var F=',1,115,'fam.length;if(H.prefix==null){H.prefix=""}if(!H.style){H.style="',110,'H.prefix+I+", serif"}if(!H.styles){H.styles={}}if(!H.macros){H.macros={}}',1,115,'fam[F]=I;',1,115,'famName[I]=F;H.macros[A]=["HandleFont",F];',1,'.Add(',1,'.Parser.prototype.macros,H.macros);H.styles[".typeset ."+I]=H.style;',1,153,'Styles(H.styles);if(',1,'.initialized){',1,229,'Push(',1,'.Setup,"TeXfont",I)}var C=',1,160,161,';var E=!',1,125,'&&H.test(I,H.testChar,H.testFactor,H.prefix);if(E&&C',166,'if(H.tex){H.tex(I,F,H)}return }if(!E&&C.warn&&C.font=="tex"&&!',1,125,'){if(!C.fonts.match("/"+I+"/")){C.fonts+=I+"/";',1,160,172,'(!',1,274,275,180,79,')}var G=',1,274,'ExtraFonts");if(G){if(G','.innerHTML','!=""){G',398,'+=","}G',398,'+=" "+H.prefix+I}}}if(C',187,'"||',1,185,'if(H.fallback){H.fallback(I,F,H)}',276,'D={};D[I]=["all"];',1,255,'(D);',1,269,'(I);if(',1,'.initialized){',1,229,'Push(',1,'.Img,"Scale");',1,229,'Push(',1,'.Img,"UpdateFonts")}},LoadRegistered',106,'0;while(A<',342,'.length){this.Register(',342,'[A++],1)}',342,'=[]},Load',98,'A){',1,153,154,'(this.URL(A))},URL',98,'A){','return ',1,'.Img.root+A+"/def.js"}};',1,160,'={cookie:{scale:100,font:"tex",autofont:1,scaleImg:0,alpha:1,warn:1,fonts:"/",printwarn:1,stayhires:0,button:1,progress:1,asynch:0,blank:0,print:0,keep:"0D",global:"auto",hiddenGlobal:1},cookiePath:"/",','noCookiePattern',':/^(file|mk):$/,Init',':function(){','this.panel=',1,153,'DIV("panel",{display:"none"});if(!',1,133,'msieButtonBug){this.Button',179,'setTimeout("',1,160,'.Button()",500)}},Panel',453,1,'.Translate.Cancel();if(this.loaded){this.Main',179,1,229,'delayedLoad(',1,'.root+"',1,'-controls.html")}},Button',106,1,153,'DIV("button",{});A.title=" Open ',1,295,' ";A',398,'="<span onclick=\\"',1,160,'.Panel()\\">',1,'</span>";if(!',1,'.Global.','isLocal&&!',1,'.noShowGlobal){A',398,'+="<span id=\\"jsMath_global\\" ',292,1,' Global Panel \\" "+"onclick=\\"',1,492,'Show(1)\\">Global&nbsp;</span>"}if(A.offsetWidth<30){A.style.width="auto"}if(!','this.cookie','.button',318,'MoveButton',453,'var C=',1,160,';if(!C.button){C.button=',1,274,'button")}if(C.button','){C.MoveElement(C.','button,3,2)}var B=20;var A=20;if(C.button){A=C.button.offsetHeight+6;B=A+5}if(C.panel',516,'panel,B,A)}},MoveElement',98,'D,C,B){if(',1,133,'IE7){var A=document.body;D.style.right','="auto";D.style.','bottom',525,'left=A.clientWidth+A.scrollLeft-D.offsetWidth-C+"px";D.style.top=A.clientHeight+A.scrollTop-D.offsetHeight-B+"px"}else{','D.style.visibility="','hidden";',529,'visible"}},GetCookie',453,'if(','this.defaults','==null){',535,'={}}',1,360,535,',',504,');this.userSet={};var C=',1,'.document.cookie',';if(',1,'.window.location','.protocol.match(this.',451,')){C=this.','localGetCookie','();','this.isLocalCookie','=1}if(C.match(/',1,'=([^;]+)/)){var D=unescape(RegExp.$1).split(/,/);for(var B=0;B<D.length;B++){var A=D[B].match(/(.*):(.*)/);if(A[2].match(/^\\d+$/)){A[2]=1*A[2]}',504,'[A[1]]=A[2];this.userSet[A[1]]=1}}},',553,453,445,1,549,'.search.substr(1)},SetCookie',98,'F){var B=[];for(var E in ',504,'){if(',535,'[E]==null||',504,'[E]!=',535,'[E]){B[B.length]=E+":"+',504,'[E]}}B=B.join(",");if(',555,'){if(F==2){return"',1,'="+escape(B)}','this.','localSetCookie','(B,F)}else{B=escape(B);if(B==""){F=0}if(','this.cookiePath','){B+="; path="+',586,'}if(','this.cookieDomain','){B+="; domain="+',590,'}if(',504,'.keep!="0D"){var A={D',':1000*60*60*24',',W',596,'*7,M',596,'*30,Y',596,'*365};var D=new Date;D.setTime(D.getTime()+',504,'.keep.substr(','0,1)*A[',504,605,'1,1)]);B+="; expires="+D.toGMTString()}if(B!=""){',1,546,'="',1,'="+B;var C=',1,546,';if(F&&!C.match(/',1,'=/)){alert("Cookies must be enabled in order to save ',1,' options")}}}',445,'null},',584,98,'B,C){if(!C){',276,'A=String(',1,549,').replace(/\\?.*/,"");if(B!=""){A+="?',1,582,'if(A!=',1,549,'.href){this.Reload(A)}},Reload',98,'A){if(!this.loaded){return }this.loaded=0;',1,153,'inited=-100;',1,492,'ClearCache();if(A){',1,549,'.replace(A)}else{',1,549,'.reload()}}};',1,'.Click={CheckClick',98,'A){if(!A){A=',1,'.window.event}if','(A.altKey){',1,160,'.Panel()}},CheckDblClick',98,'B){if(!B){B=',1,657,'(!',1,'.Click.DblClick){',1,'.Extension.Require("double-click",1);var A=B;B={};for(var C in A){B[C]=A[C]}}',1,229,'Push(',1,'.Click,"DblClick",[B,this.alt])}};',1,'.TeX={thinmuskip:3/18,medmuskip:4/18,thickmuskip:5/18,x_height:0.430554,quad:1,num1:0.676508,num2:0.393732,num3:0.44373,denom1:0.685951,denom2:0.344841,sup1:0.412892,sup2:0.362892,sup3:0.288888,sub1:0.15,sub2:0.247217,sup_drop:0.386108,sub_drop:0.05,delim1:2.39,delim2:1,axis_height:0.25,default_rule_thickness:0.06,big_op_spacing1:0.111111,big_op_spacing2:0.166666,big_op_spacing3:0.2,big_op_spacing4:0.6,big_op_spacing5:0.1,integer:6553.6,scriptspace:0.05,nulldelimiterspace:0.12,delimiterfactor:901,delimitershortfall:0.5,scale:1,atom:["ord","op","bin","rel","open","close","punct","ord"],fam:["',3,'","',23,'","',34,'","',45,'","cmti10","","cmbx10",""],famName:{',3,':0,',23,':1,',34,':2,',45,':3,cmti10:4,cmbx10:6},encoding:["&#xC0;","&#xC1;","&#xC2;","&#xC3;","&#xC4;","&#xC5;","&#xC6;","&#xC7;","&#xC8;","&#xC9;","&#xCA;","&#xCB;","&#xCC;","&#xCD;","&#xCE;","&#xCF;","&#xB0;","&#xD1;","&#xD2;","&#xD3;","&#xD4;","&#xD5;","&#xD6;","&#xB7;","&#xD8;","&#xD9;","&#xDA;","&#xDB;","&#xDC;","&#xB5;","&#xB6;","&#xDF;","&#xEF;","!","&#x22;","#","$","%","&#x26;","&#x27;","(",")","*","+",",","-",".","/","0","1","2","3","4","5","6","7","8","9",":",";","&#x3C;","=","&#x3E;","?","@","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","[","&#x5C;","]","^","_","`","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","{","|","}","&#x7E;","&#xFF;"],',3,':[[0.625',',0.683],[0.','833',696,'778',696,'694',696,'667',696,'75',696,'722',696,'778',696,'722',696,'778',696,'722',696,'583',',0.694,0,{ic:0.0778,krn:{"39":0.0778,"63":0.0778,"33":0.0778,"41":0.0778,"93":0.0778},lig:{"105":','14,"108":15}}],[0.556',',0.694],[0.','556',720,'833',720,'833',720,'278',',0.431],[0.','306',',0.431,0.194],[0.','5',720,'5',720,'5,0.628],[0.5',720,'5,0.568],[0.75',720,'444,0,0.17],[0.5',720,'722',728,'778',728,'5,0.528,0.0972],[0.903,0.683],[1.01',696,'778,0.732,0.0486],[0.278',',0.431,0,{','krn:{"108":-0.278,"76":-0.319}}],[0.278',',0.694,0,{','lig:{"96":','60}}],[0.5',720,'833',',0.694,0.194],[','0.5',',0.75,0.0556],[0.','833',757,'778',720,'278',750,'krn:{"63":0.111,"33":0.111},lig:{"39":34}}],[0.389',',0.75,0.25],[0.','389',765,'5,0.75],[','0.778,0.583,0.0833],[','0.278,0.106',',0.194],[0.','333',748,'lig:{"45":','123}}],[',770,'],[0.5',765,'5,0.644','],[0.5,0.644],[0.5,0.','644',780,'644',780,'644',780,'644],[0.5,0.644],[0.278',728,'278',730,'278,0.5',771,'778',',0.367,-0.133],[','0.472,0.5',771,'472',750,751,'62}}],[0.778',720,'75',',0.683,0,{krn:{"','116','":-0.0278,"','67',805,'79',805,'71',805,'85',805,'81',805,'84":-0.0833,"89":-0.0833,"86":-0.111,"87":-0.111}}],[0.','708',696,'722',696,'764',803,'88',805,'87',805,'65',805,'86',805,'89":-','0.0278}}],[0.','681',696,'653',',0.683,0,{','krn:{"111":-0.0833,"101":-0.0833,"117":-0.0833,"114":-0.0833,"97":-0.0833,"65":-0.111,"79":-0.0278,"67":-0.0278,"71":-0.0278,"81":-0.0278}}],[','0.785',696,'75',696,'361',803,'73":',832,'514',696,'778',803,'79',805,'67',805,'71',805,'81":-',832,'625',803,816,'917',696,'75',696,'778',803,'88',805,'87',805,'65',805,'86',805,'89":-',832,'681',803,'65','":-0.0833,"','111',805,'101',805,'97',805,'46',880,'44":-0.','0833}}],[0.','778,0.683',771,'736',803,'116',805,'67',805,'79',805,'71',805,'85',805,'81',805,816,'556',696,'722',803,'121',805,'101',880,'111',880,'114',880,'97',880,'65',880,'117":-0.',890,'75',696,'75',',0.683,0,{ic:0.','0139,',837,'1.03',929,'0139,',837,'0.75',803,'79',805,'67',805,'71',805,'81":-',832,'75',929,'025,krn:{"101',880,'111',880,'114',880,'97',880,'65',880,924,890,'611',696,'278',765,'5',720,'278',765,'5',720,'278,0.668],[0.','278',750,751,'92}}],[0.5',748,'krn:{"118',805,'106":0.0556,"121',805,'119":-',832,'556,0.','694,0',',{krn:{"101":0.0278,"111":0.0278,"120":-0.0278,"100":0.0278,"99":0.0278,"113":0.0278,"118":-0.0278,"106":0.0556,"121":-0.0278,"119":-0.0278}}],[0.','444',748,'krn:{"104',805,'107":-',832,'556',720,'444',728,'306',718,'12,"102":11,"108":13}}],[0.5',',0.431,0.194,{','ic:0.','0139,krn:{"','106":',832,'556',750,'krn:{"116',805,'117',805,'98',805,'121',805,'118',805,'119":-',832,970,'306,0.668',771,'528',750,'krn:{"97','":-0.0556,"','101',805,'97',805,'111',805,'99":-',832,'278',720,'833',748,'krn:{"116',805,'117',805,'98',805,'121',805,'118',805,'119":-',832,'556',748,'krn:{"116',805,'117',805,'98',805,'121',805,'118',805,'119":-',832,'5,0.431,0',984,982,'431,0.194',984,'528',730,'392',728,'394',728,'389,0.615,0,{krn:{"121',805,'119":-',832,'556',748,'krn:{"119":-',832,'528',',0.431,0,{ic:0.',1000,'97',1023,'101',805,'97',805,'111',805,'99":-',832,'722',1082,1000,'101',805,'97',805,'111',805,'99":-',832,'528',728,'528',998,'ic:0.',1000,'111',805,'101',805,'97',805,'46',880,'44":-0.',890,'444',728,'5',1082,'0278,',774,'124}}],[1',1082,'0278}],[0.','5',720,'5,0.668],[0.5,0.668]],',23,':[[0.615',929,'139',',krn:{"61":-0.0556,"59":-0.111,"58":-0.111,"127":0.',890,'833',803,'127":0.167}}],[0.','763',929,1125,'krn:{"127":0.0833}}],[0.','694',803,1141,'742',929,'0757,',1145,'831',929,'0812,krn:{"61',1023,'59":-0.0556,"58":-0.0556,"127":0.','0556}}],[0.','78',929,'0576,',1145,'583',929,'139',1137,1158,'667',836,1145,'612',929,'11,krn:{"61',1023,1157,1158,'772',929,'0502,',1145,'64',1082,'0037,','krn:{"127":',832,'566',',0.694,0.194,{ic:0.','0528,',1145,'518',998,'ic:0.0556','}],[0.444',750,'ic:0.0378,krn:{"',1157,1158,'406',748,'krn:{"127":0.0556}}],[0.','438',1187,'0738,',1145,'497',998,'ic:0.0359',',',1200,'469',750,'ic:0.',1125,1145,'354',748,1200,'576',728,'583',720,'603',998,1184,832,'494',1082,'0637,krn:{"',1157,'0278}}],[0.','438',1187,'046,',1184,'0.111}}],[0.','57',1082,'0359}],[0.','517',998,1145,'571',1082,'0359,krn:{"59',1023,'58":-0.',1158,'437',1082,'113,krn:{"',1157,1230,'54',1082,'0359,',1184,832,'596,0.694,0.194,{',1145,'626',998,1200,'651',1187,'0359,',1184,1235,'622',1082,1238,'466',748,1145,'591',750,1145,'828',1082,1129,'517',998,1145,'363,0.431,0.0972,{ic:0.0799,',1145,'654',998,1184,'0.0833}}],[1',794,'1',794,'1',794,'1',794,'0.278',',0.464,-0.0363],[','0.278',1297,'0.5,0.465,-0.0347],[',1300,'0.5',728,'5',728,'5',728,'5',730,'5',730,'5,0.',1065,780,1065,780,'431',771,'278,0.106],[',770,771,'778',',0.539,0.0391],[','0.5,0.75,0.25,{krn:{"1',1023,'65',1023,'77',1023,'78',1023,'89":0.0556,"90":-0.',1158,'778',1323,1300,'0.531',750,1192,',',1145,'75',803,'127":','0.','139}}],[0.','759',929,'0502,',1145,'715',929,'0715,krn:{"61',805,1157,890,'828',929,1125,1200,'738',929,'0576,',1145,'643',929,'139',1137,890,'786',836,1145,'831',929,'0812,krn:{"61',1023,1157,1158,'44',929,'0785,',1184,1235,'555',929,'0962',1137,'167}}],[0.','849',929,'0715,krn:{"61',1023,1157,1158,'681',803,1344,832,'97',929,'109,krn:{"','61',1023,1157,890,'803',929,1401,'61',880,'61',805,1157,890,'763',929,1125,1145,'642',929,'139',1137,890,'791,0.683,0.194,{',1145,'759',929,'00773,',1145,'613',929,'0576,krn:{"61',1023,1157,890,'584',929,'139,krn:{"61',805,1157,890,'683',929,1401,'59":-0.111,"',1246,'111,"61',1023,1344,832,'583',929,'222',',krn:{"59":-0.167,"58":-0.167,"61":-0.111}}],[0.','944',929,'139',1454,'828',929,'0785,krn:{"61',880,'61',805,1157,890,'581',929,'222',1454,'683',929,'0715,krn:{"61',1023,1157,890,'389,0.75],[0.389',755,'0.389',755,'1,0.358,-0.142],[',1481,'0.417',750,1184,1235,'529',728,'429',720,'433',748,1200,'52',750,'krn:{"89":0.0556,"90',1023,'106":-0.111,"102":-0.167,"',1141,'466',748,1200,'49',1187,'108,krn:{"',1157,1388,'477',998,1207,',',1184,832,'576',750,'krn:{"127":-',832,'345,0.66],[0.412,0.66,0.194,{ic:0.0572,krn:{"59',1023,1246,1158,'521',750,'ic:0.0315}],[0.298',750,'ic:0.0197,',1145,'878',728,'6',728,'485',748,1200,'503',998,1145,'446',998,1207,',',1145,'451',1082,1125,'krn:{"',1157,1158,'469',748,1200,'361,0.615,0,{',1145,'572',748,1184,832,'485',1082,'0359,',1184,832,'716',1082,'0269,',1145,'572',748,1184,832,'49',998,1207,',',1200,'465',1082,'044,',1200,'322',748,1184,832,'384',998,1145,'636',998,1184,1235,'5,0.714,0,{ic:0.154}],[0.278',750,'ic:0.399}]],',34,':[[',769,'0.278,0.444,-0.0556],[',769,1300,769,'0.5,0.444,-0.0556],[',769,769,769,769,769,769,769,'1',755,1601,1601,'0.778',1297,'0.778,0.464,-0.0363','],[0.778,0.636,0.136',1616,1616,1616,1616,1616,'],[0.778',794,'0.778,0.483,-0.0169],[0.778',1323,'0.778',1323,'1',1323,'1',1323,'0.778',1323,'0.778',1323,'1',794,'1',794,'0.5',755,'0.5',755,'1',794,'1',755,'1',755,'0.778',1297,'1',794,'1',794,'0.611',755,'0.611',755,'1',794,'1',755,'1',755,'0.778',728,'275,0.556],[1',728,'667',1323,'0.667',1323,'0.889',755,'0.889',755,'0',755,'0',794,'0.556',720,'556',720,'667',728,'5',757,'722',720,'722',720,'778',720,'778',720,'611',720,'798',803,'48":0.','194}}],[0.657',929,'0304',',krn:{"48":0.',1346,'527',929,'0583',1706,1346,'771',929,'0278',1706,890,'528',929,'0894',1706,'111}}],[0.','719',929,'0993',1706,1722,'595',',0.683,0.0972,{ic:0.','0593',1706,1722,'845',929,'00965',1706,1722,'545',929,'0738,krn:{"48":',832,'678',1729,'185',1706,1388,'762',929,'0144',1706,1158,'69',803,1702,'139}}],[1.2',803,1702,1346,'82',929,'147',1706,890,'796',929,1715,1706,1722,'696',929,'0822',1706,890,'817,0.683,0.0972,{krn:{"48":',1235,'848',803,1702,890,'606',929,'075',1706,1346,'545',929,'254,krn:{"48":',832,'626',929,'0993',1706,890,'613',929,'0822,krn:{"48":',832,'988',929,'0822',1706,890,'713',929,'146',1706,1346,'668',1729,'0822',1706,890,'725',929,'0794',1706,1346,'667,0.556],[0.',1818,1818,1818,1818,'611',720,'611',720,'444',765,'444',765,'444',765,'444',765,'5',765,'5',765,'389',765,'389',765,'278',765,'5',765,'5',765,'611',765,'5',765,'278',755,'0.833,0.04,0.96],[0.75',696,'833',696,'417',1187,'111}],[0.',1818,'667,0.556',1616,1616,'],[0.444',755,'0.444',755,'0.444',755,'0.611',755,'0.778,0.694,0.13','],[',1874,'],[',1874,'],[',1874,']],',45,':[[0.458',',0.04,1.16,{n:','16}],[0.458',1884,'17}],[0.417',1884,'104}],[0.417',1884,'105','}],[0.472,0.04,1.16,{n:','106',1892,'107',1892,'108',1892,'109}],[0.583',1884,'110}],[0.583',1884,'111',1892,'68',1892,'69}],[0.333',',0,0.6,{delim:{','rep:12}}],[0.556',1908,'rep:13}}],[0.578',1884,'46}],[0.578',1884,'47}],[0.597',',0.04,1.76,{n:','18}],[0.597',1916,'19}],[0.736',',0.04,2.36,{n:','32}],[0.736',1920,'33}],[0.528',1920,'34}],[0.528',1920,'35}],[0.583',1920,'36}],[0.583',1920,'37}],[0.583',1920,'38}],[0.583',1920,'39}],[0.75',1920,'40}],[0.75',1920,'41}],[0.75',1920,'42}],[0.75',1920,'43}],[1.04',1920,'44}],[1.04',1920,'45}],[0.792',',0.04,2.96,{n:','48}],[0.792',1948,'49}],[0.583',1948,'50}],[0.583',1948,'51}],[0.639',1948,'52}],[0.639',1948,'53}],[0.639',1948,'54}],[0.639',1948,'55}],[0.806',1948,'56}],[0.806',1948,'57}],[0.806',',0.04,2.96],[','0.806',1968,'1.28',1968,'1.28',1968,'0.811',1916,'30}],[0.811',1916,'31}],[0.875',',0.04,1.76,{delim:{top:','48,bot:64,rep:66}}],[0.875',1980,'49,bot:65,','rep:67}}],[0.','667',1980,'50,bot:52,rep:54}}],[0.667',1980,'51,bot:53,rep:55','}}],[0.667,0.04,1.76,{delim:{bot:','52,rep:54',1990,'53,rep:55}}],[0.667',1908,'top:50,rep:54}}],[0.667',1908,'top:51,rep:55','}}],[0.889,0,0.9,{delim:{top:','56,mid:60,bot:58,rep:62',1998,'57,mid:61,bot:59,rep:62',1998,'56,bot:58,rep:62',1998,'57,bot:59,rep:62','}}],[0.889,0,1.8,{delim:{rep:','63',2006,'119}}],[0.889,0,0.3,{delim:{','rep:62}}],[0.','667',1908,'top:120,bot:121,rep:63}}],[0.875',1980,'56,bot:59,',2010,'875',1980,'57,bot:58,',2010,'875',1908,'rep:66}}],[0.875',1908,1984,'611',1916,'28}],[0.611',1916,'29','}],[0.833,0,1,{n:','71}],[1.11',',0.1,1.5],[','0.472,0,1.11,{ic:0.194,n:','73}],[','0.556,0,2.22,{ic:0.444}],[1.11,0',',1,{n:75}],[1.51,0','.1,1.5],[1.11,0',',1,{n:77}],[1.51,0',2038,',1,{n:79}],[1.51',2033,'1.06,0,1,{n:88}],[0.944,0,1,{n:89}],[',2034,'90',2031,'91',2031,'92',2031,'93',2031,'94',2031,'95}],[1.44',2033,'1.28',2033,2036,2038,2038,2038,2038,'.1,1.5],[0.944,0,1,{n:97}],[1.28',2033,'0.556,0.722,0,{n:','99','}],[1,0.75,0,{n:','100}],[1.44,0.75],[',2066,'102',2068,'103}],[1.44,0.75],[0.472',1916,'20}],[0.472',1916,'21}],[0.528',1916,'22}],[0.528',1916,'23}],[0.528',1916,'24}],[0.528',1916,'25}],[0.667',1916,'26}],[0.667',1916,'27}],[1',1884,'113}],[1',1916,'114}],[1',1920,'115}],[1',1948,'116}],[1.06,0,1.8,{delim:{top:118,bot:116,rep:117}}],[1.06,0,0.6],[1.06,0.04,0.56],[0.778',1908,'top:126,bot:127,rep:119}}],'],
  ['[0.667',',0,0.6,{delim:{','top:120,rep:63','}}],[0.','667',1,'bot:121,rep:63',3,'45,0.12],[0.',8,8,8,'778',1,'top:126,rep:119',3,'778',1,'bot:127,rep:119}}]],cmti10:[[0.627',',0.683,0,{ic:0.','133}],[0.818,0.683],[0.767',19,'094}],[0.','692,0.683],[0.664',19,'153}],[0.743',19,'164}],[0.','716',19,'12}],[0.','767',19,'111}],[0.716',19,'0599}],[0.767',19,'111}],[0.716',19,'103}],[0.','613',',0.694',',0.194,{ic:0.','212,krn:{"39":0.104,"63":0.104,"33":0.104,"41":0.104,"93":0.104},lig:{"105":','14,"108":15',3,'562',41,42,39,'588',41,42,39,'882',41,42,39,'894',41,42,39,'307',',0.431,0,{ic:0.','0767}],[0.','332,0.431',42,'0374}],[0.511',',0.694],[0.','511',',0.694,0,{ic:0.','0969','}],[0.511,0.','628',',0,{ic:0.','083}],[0.511',70,'108',72,'562',74,39,'831',68,'46,0,0.17],[0.537',41,42,'105}],[0.','716',63,'0751','}],[0.716',63,90,72,'528,0.0972,{ic:0.0919}],[0.883',19,30,'985',19,30,'767,0.732,0.0486,{ic:0.',22,'256,0.431,0,{krn:{"108":-0.256,"76":-0.321',3,'307',70,'124,lig:{"96":','60',3,'514',70,'0696}],[0.818',41,42,'0662}],[0.769',68,'818',',0.75,0.0556',',{ic:0.136}],[0.','767',70,'0969}],[0.307',70,'124',',krn:{"','63":0.102,"33":0.102},lig:{"39":34',3,'409',',0.75,0.25,{ic:0.','162}],[0.409',129,'0369',72,'75',74,'149}],[0.767,0.562,0.0567,{ic:0.0369','}],[0.307,0.','106',',0.194],[0.','358',63,'0283,lig:{"45":123',3,'307,0.106],[0.511',129,'162',72,'644,0',',{ic:0.136}],[0.511,0.644,0',149,149,149,'.194',149,149,149,153,149,149,119,'307',63,'0582',137,'431',42,'0582',137,'5',42,'0756}],[0.767,0.367,-0.133,{ic:0.0662',72,'5',139,'511',70,'122,lig:{"96":62',3,'767',70,'096}],[0.743,0.683,0,{','krn:{"110":-0.0256,"108":-0.0256,"114":-0.0256,"117":-0.0256,"109":-0.0256,"116":-0.0256,"105":-0.0256,"67":-0.0256,"79":-0.0256,"71":-0.0256,"104":-0.0256,"98":-0.0256,"85":-0.0256,"107":-0.0256,"118":-0.0256,"119":-0.0256,"81":-','0.0256,"84','":-0.0767,"','89',184,'86','":-0.102,"','87',188,'101":-0.0511,"97":-0.0511,"111":-0.0511,"100":-0.0511,"99":-0.0511,"103":-0.0511,"113":-0.0511}}],[0.','704',19,39,'716',19,'145}],[0.','755',19,'094',125,'88','":-0.0256,"','87',203,'65',203,'86',203,'89','":-0.0256',3,'678',19,30,'653',19,'133',125,'111',184,'101',184,'117','":-0.0767,"114":-0.0767,"97":-0.0767,"','65',188,'79":-0.0256,"67":-0.0256,"71":-0.0256,"81":-0.0256}}],[0.','774',19,'0872}],[0.743',19,27,'386',19,'158}],[0.525',19,'14}],[0.769',19,'145',125,228,'627,0.683,0,{krn:{"84',184,'89',184,'86',188,'87',188,191,'897',19,27,'743',19,27,'767',19,'094',125,'88',203,'87',203,'65',203,'86',203,'89',211,3,'678',19,'103',125,'65":-0.0767}}],[0.','767,0.683',42,22,'729',19,'0387,',182,'0.0256,"84',184,'89',184,'86',188,'87',188,191,'562',19,30,'716',19,'133',125,'121',184,'101',184,'111',225,'117',184,277,'743',19,27,'743',19,'184',125,'111',184,'101',184,'117',225,'65',188,228,'999',19,'184',125,277,'743',19,'158',125,228,'743',19,'194',125,'101',184,'111',225,'117',184,277,'613',19,197,'307',129,'188}],[0.514',70,'169}],[0.307',129,87,'511',70,'0665',137,'668',74,'118}],[0.307',70,107,'92',3,'511',63,64,'46',70,'0631',125,191,'46',63,'0565',125,191,'511',70,'103',',krn:{"108":0.0511}}],[0.','46',63,90,125,191,'307',41,42,43,'12,"102":11,"108":13}}],[0.','46,0.431',42,'0885}],[0.','511',70,64,'307,0.655',74,'102',137,'655',42,197,'46',70,'108}],[0.','256',70,'103',384,'818',63,64,'562',63,'0767',125,'39":-0.102',3,'511',63,'0631',125,191,'511,0.431',42,'0631',125,191,'46,0.431',42,397,'422',63,'108',125,191,'409',63,'0821}],[0.332,0.615',74,'0949}],[0.537',63,64,'46',63,410,'664',63,'108',384,'464',63,30,'486,0.431',42,397,'409',63,'123}],[0.511',63,'0921',',lig:{"45":124}}],[1.','02',63,'0921}],[0.511',70,'122',72,'668',74,'116',72,'668',74,'105}]],cmbx10:[[0.692',',0.686],[0.','958',481,'894',481,'806',481,'767',481,'9',481,'831',481,'894',481,'831',481,'894',481,'831',481,'671',70,'109,krn:{"39":0.109,"63":0.109,"33":0.109,"41":0.109,"93":0.109},lig:{"105":','14,"108":15',3,'639',68,'639',68,'958',68,'958',68,'319',',0.444],[0.','351,0.444',139,'575',68,'575',68,'575,0.','632],[0.575',68,523,'596],[0.869',68,'511,0,0.17],[0.597',68,'831',516,'894',516,523,'542,0.0972],[1.04,0.686],[1.17',481,'894,0.735,0.0486],[0.319',',0.444,0,{krn:{"','108":-0.319,"76":-0.378',3,'35',',0.694,0,{lig:{"96":','60',3,'603',68,'958',41,139,'575',118,'],[0.958',118,'],[0.894',68,'319',',0.694,0,{krn:{"','63":0.128,"33":0.128},lig:{"39":34',3,'447',',0.75,0.25],[0.','447',562,523,'75],[0.894,0.633,0.133],[0.','319,0.156',139,'383,0.444,0,{lig:{"45":123',3,567,'],[0.575',562,523,'644],[','0.575,0.644],[0.575,0.644],[',576,576,576,'0.',523,'644],[0.319',516,'319,0.444',139,'35,0.5',139,'894,0.391,-0.109],[0.543,0.5',139,'543',543,'62',3,'894',68,'869',',0.686,0,{krn:{"','116','":-0.0319,"','67',599,'79',599,'71',599,'85',599,'81',599,'84":-0.0958,"89":-0.0958,"86":-0.128,"87":-0.128}}],[','0.818',481,'831',481,'882',597,'88',599,'87',599,'65',599,'86',599,'89','":-0.0319}}],[0.','756',481,'724,0.686,0,{','krn:{"111":-0.0958,"101":-0.0958,"117":-0.0958,"114":-0.0958,"97":-0.0958,"65":-0.128,"79":-0.0319,"67":-0.0319,"71":-0.0319,"81":-0.0319}}],[','0.904',481,'9',481,'436',597,'73":0.0319',3,'594',481,'901',597,'79',599,'67',599,'71',599,'81',626,'692',597,610,'1.09',481,'9',481,'864',597,'88',599,'87',599,'65',599,'86',599,'89',626,'786',597,'65":-0.0958,"111',599,'101',599,'97',599,'46":-0.0958,"44":-0.0958}}],[0.','864,0.686',139,'862',597,'116',599,'67',599,'79',599,'71',599,'85',599,'81',599,610,'0.639',481,'8',597,'121',599,'101":-0.0958,"111":-0.0958,"114":-0.0958,"97":-0.0958,"65":-0.0958,"117":-0.0958}}],[0.','885',481,'869,0.686',74,'016,',630,'1.19,0.686',74,'016,',630,'0.869',597,'79',599,'67',599,'71',599,'81',626,'869,0.686',74,'0287',125,702,'703',481,'319',562,'603',68,'319',562,'575',68,'319',68,'319',543,'92',3,'559',539,'118',599,'106":0.0639,"121',599,'119',626,'639',41,',0',',{krn:{"101":0.0319,"111":0.0319,"120":-0.0319,"100":0.0319,"99":0.0319,"113":0.0319,"118":-0.0319,"106":0.0639,"121":-0.0319,"119":-0.0319}}],[0.','511',539,'104',599,'107',626,'639',68,'527',516,'351',70,504,394,523,'444',42,'016',125,'106":0.0319',3,'639',558,'116',599,'117',599,'98',599,'121',599,'118',599,'119',626,'319',68,'351',41,139,'607',558,'97":-0.0639,"101',599,'97',599,'111',599,'99',626,'319',68,'958',539,'116',599,'117',599,'98',599,'121',599,'118',599,'119',626,'639',539,'116',599,'117',599,'98',599,'121',599,'118',599,'119',626,523,'444,0',755,'639,0.444,0',153,755,'607,0.444',139,'474',516,'454',516,'447,0.635,0,{krn:{"121',599,'119',626,'639',539,'119',626,842,74,'016',125,'97":-0.0639,"101',599,'97',599,'111',599,'99',626,'831,0.444',74,'016',125,'101',599,'97',599,'111',599,'99',626,'607',516,842,42,'016',125,'111',599,'101',599,'97',599,678,'511',516,523,'444',74,'0319',467,'15,0.444',74,'0319}],[0.575',68,'575',68,'575',41,']]};','jsMath.Img','={fonts:[50,60,70,85,100,120,144,173,207,249,298,358,430],w:{"50":6.9,"60":8.3,"70":9.7,"85":11.8,"100":13.9,"120":16.7,"144":20,"173":24,"207":28.8,"249":34.6,"298":41.4,"358":49.8,"430":59.8},best:4,update:{},factor:1,loaded:0,SetFont',':function(','B){for(var A in B){if(!','this.update[A',']){',913,']=[]}',913,']=',913,'].concat(B[A])}},AddFont',911,'A,B){if(!',909,'[A]){',909,'[A]={}}jsMath.Add(',909,'[A],B)},UpdateFonts',':function(){','var D=this.update;','if(!this.loaded){','return }for(var A in D){for(var B=0;B<D[A].length;B++){var C=D[A][B];if(C=="all"){for(C in ','jsMath.TeX[','A]){',933,'A][C].img','={}}}else{',933,936,'={}}}}this.update={}},BestSize',929,'var B=jsMath.em*this.factor;var A=','this.w[this.fonts[','0]];for(var C=1;C<this.fonts.length;C++){if(B<(',943,'C]]+2*A)/3){return C-1}A=',943,'C]]}return C-1},Scale',929,931,'return }this.best=this.BestSize();this.em=',909,'.w[this.fonts[this.best]];','this.scale','=(jsMath.em/this.em);','if(Math.abs(',954,'-1)<0.12){',954,'=1}},URL',911,'A,B,E){var D=(','jsMath.Controls.cookie.','alpha)?"/alpha/":"/plain/";','if(E==null','){E="def.js"}else{E="char"+E+".png"}if(B!=""){B+="/"}','return this.','root+A+D+B+E},LoadFont',911,'A){',931,'this.Init()}jsMath.Setup.Script(this.URL(A,""))},Init',929,'if(',963,'print||',963,'stayhires','){',963,'print=',963,978,';this.factor*=3;if(!','jsMath.Controls.','isLocalCookie||!jsMath.Global.isLocal){',985,'SetCookie(0)}if(','jsMath.Browser.','alphaPrintBug){',963,'alpha=0}}var B="0123456789ABCDEF";this.HexCode=[];for(var C=0;C<128;C++){var D=Math.floor(C/16);var A=C-16*D;this.HexCode[C]=B.charAt(D)+B.charAt(A)}this.loaded=1}};jsMath.HTML={Em',911,'A){var C=','5;if(A<0){C++}',956,'A)<0.000001){A=0}var B=String(A);B=B.replace(/(\\.\\d\\d\\d).+/,"$1");return B+"em"},Spacer',911,'A){if(A==0){return""}return ',989,'msieSpaceFix+"<','span class=\\"spacer\\" style=\\"margin-','left:"+this.Em(','A)+"\\"></span>"},Blank',911,'B,E,G,F){var A="";var D="";if(F){D+="border-',1003,'B)+" solid;";if(',989,'widthAddsBorder){B=0}}if(B==0){if(',989,'blankWidthBug){D+="width:1px;";A="<',1002,'right:-1px\\"></span>"}}else{D+="width',':"+this.Em','(B)+";"}if(G==null){G=0}if(E){var C=this.Em(E+G);if(F&&E*jsMath.em<1.5){C="1px";E=1/jsMath.em}D+="height:"+C+";"}if(',989,'mozInlineBlockBug){G=-E}if(',989,'msieBorderBug&&!F){G-=jsMath.d}if(G){D+="vertical-align',1015,'(-G)}return A+"<span class=\\"blank\\" ','style=\\""+','D+"\\"></span>"},Rule',911,'A,B){if(B==null){B','=jsMath.TeX.default_rule_thickness}',967,'Blank(A,B,0,1)},Class',911,'A,B){return"<span class=\\""+A+"\\">"+B+"</span>"},Place',911,'B,A,D){',956,'A',')<0.0001){','A=0}',956,'D',1036,'D=0}if(A||D){var C','="<span style=\\"position',': relative;";if(A){C+=" margin-',1003,'A)+";"}if(D){C+=" top',1015,'(-D)+";"}B=C+"\\">"+B','+"</span>"}return ','B},PlaceSeparateSkips',911,'E,G,F,I,A,H){',956,'G',1036,'G=0}',956,'F',1036,'F=0}if(F){var D=0;var C=0;var B="";if(I!=null){C=A-H;D=I;B=" width',1015,'(A-I)+";"}E=','this.Spacer','(D-C)+"<span style=\\"position: relative; "+"top',1015,'(-F)+";"+"',1003,'C)+";"+B+"\\">"+',1062,'(-D)+E+',1062,'(C)+"</span>"}if(G){E=',1062,'(G)+E}return E},PlaceAbsolute',911,'E,B,H,G,D,C){',956,'B',1036,'B=0}',956,'H',1036,'H=0}var F="";var A="";if(',989,'msieRelativeClipBug&&G!=null){F=',1062,'(-G);B+=G;A=',1062,'(D-C)}E',1042,':absolute','; ',1003,'B)+"; "+"top',1015,'(H)+";\\">"+F+E+A','+"&nbsp;"+"</span','>";return E},','Absolute',911,'C,A,D,E,F,B){if(F!="none"){',956,'F',1036,'F=0}C',1042,1091,'; "+"top:"+','jsMath.HTML.','Em(F)+"; left:0em;\\">"+C',1097,'>"}if(E=="none"){E=0}C+=this.Blank(A,D-E,E);if(',989,'msieAbsoluteBug){C',1042,':relative',';\\">"+C+"</span>"}if(',989,'spanHeightVaries){','C',1042,1116,';"+" width:"+',1109,'Em(A)+";"+" height:"+',1109,'Em(B)+";"+',989,'msieInlineBlockFix+"\\">"+C+"</span>"}else{C',1042,1116,'\\">"+C',1048,'C}};','jsMath.Box','=function(C,E,A,B,D){if(D==null){D=jsMath.d}this.type="typeset";this.w=A;this.h=B;this.d=D;this.bh=B;this.bd=D;this.x=0;this.y=0;this.mw=0;this.Mw=A;this.html=E;this.format=C};jsMath.Add(',1135,',{defaultH:0,Null',929,'return new ',1135,'("null","",0,0,0)},Text',911,'J,I,A,K,H,G){var E=','jsMath.Typeset.AddClass(','I,J);E=','jsMath.Typeset.','AddStyle(','A,K,E);var B','=jsMath.EmBoxFor(','E);var C=',1147,'TeX(A,K);var F=((I=="cmsy10"||I=="cmex10")?B.h-C.h:C.d*B.h/C.hd);var D=new ',1135,'("text",J,B.w,B.h-F,F);D.style=A;D.size=K;D.tclass=I;if(G!=null){D.d=G*C.scale}else{D.d=0}if(H==null||H==1){D.h=0.9*C.M_height}else{D.h=1.1*C.x_height+C.scale*H}return D},TeX',911,'H,A,E,B){var I=',933,'A][H];','if(I.d==null){I.d=0}','if(I.h==null){I.h=','0}if(I.img!=null&&I.c!=""){this.TeXIMG(A,H,',1147,'StyleSize(E,B))}var G=',1147,'TeX(E,B).scale;var D=I.h+',933,'A].dh;var F=new ',1135,'("text",I.c,I.w*G,D*G,I.d*G);F.style=E;F.size=B;if(I.tclass){F.tclass=I.tclass;if(I.img){F.bh=I.img.bh;F.bd=I.img.bd}else{F.bh=G*jsMath.h;F.bd=G*jsMath.d}}else{F.tclass=A;F.bh=G*',933,'A].h;F.bd=G*',933,'A].d;if(',989,'msieFontBug&&','F','.html.match(/&#/)){','F','.html+="<span style=\\"display:none\\">x</span','>"}}return F},TeXfallback',911,'A,D,B,L){var J=',933,'D][A];if(!J.tclass){J.tclass=D}if(J.img!=null){',967,'TeXnonfallback(A,D,B,L)}if(J.h!=null&&J.a==null){J.a=J.h-1.1*jsMath.TeX.x_height}var K=J.a;var I=J.d;var H=this.Text(J.c,J.tclass,B,L,K,I);var E=',1147,'TeX(B,L).scale;if(J.bh!=null){H.bh=J.bh*E;H.bd=J.bd*E}else{var G=H.bd+H.bh;var F=',1145,'H.tclass,H.html);F=',1147,1148,'B,L,F);H.bd',1150,'F+',1109,'Blank(1,G)).h-G;H.bh=G-H.bd;if(E==1){J.bh=H.bh;J.bd=H.bd}}if(jsMath.',1176,'H',1178,'H',1180,'>"}return H},TeXIMG',911,'E,A,R){var M=',933,'E][A];if(M.img.size!=null&&M.img.size==R&&M.img.best!=null&&M.img.best==','jsMath.Img.best','){return }var F=(',909,'.scale!=1);var B=',1209,'+R-4;if(B<0){B=0;F=1','}else{if(','B>=','jsMath.Img.fonts','.length){','B=',1217,'.length-1',';F=1}}var Q=',909,'[',1217,'[B]];var I=Q[E][A];var G=1/',909,'.w[',1217,'[B]];if(B!=',1209,'+R-4){if(M.w!=null){G=M.w/I[0]}else{G*=',1217,'[R]/',1217,'[4]*',1217,'[',1209,']/',1217,'[B]}}var N=I[0]*G;var J=I[1]*G;var L=-I[2]*G;var O;var H=(M.w==null||Math.abs(M.w-N)<0.01)?"":" margin-right:"+',1109,'Em(M.w-N)+";";var D="";A=',909,'.HexCode[A];if(!F&&!',963,'scaleImg){if(2*N<J||(',989,'msieAlphaBug&&',963,'alpha)){D="height',':"+(I[1]*',989,'imgScale',')+"px;"}D+=" width:"+(I[0]*',989,1255,')+"px;";O=-I[2]+"px"}else{if(2*N<J||(',989,'msieAlphaBug&&',963,1252,':"+',1109,'Em(J*',989,1255,')+";"}D+=" width:"+',1109,'Em(N*',989,1255,')+";";O=',1109,'Em(L)}var P=(Math.abs(L)<0.01&&!',989,'valignBug)?"":" vertical-align:"+O+";";var K=',909,'.URL(E,',1217,'[B],A);if(',989,'msieAlphaBug&&',963,'alpha){','M.c="<img src=\\""+','jsMath.blank+"\\" "+"',1023,989,'msieCenterBugFix+D+P+H','+" filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="+"\'"+K+"\', sizingMethod=\'scale\'"+");\\" />"}else{',1287,'K+"\\" ',1023,989,1291,'+"\\" />"}M.tclass="normal";M.img.bh=J+L;M.img.bd=-L;M.img.size=R;M.img.best=',1209,'},Space',911,'A){return ','new jsMath.Box("html",',1109,'Spacer(A),A,0,0)},Rule',911,'A,C){if(C','==null){C',1027,'var B=',1109,'Rule(A,C);return ',1303,'B,A,C,0)},GetChar',911,'B,',994,933,'A][B];','if(C.img!=null){this.TeXIMG(A,B',',4)}if(C.tclass',1308,'.tclass=A}if(!C.computedW){C.w',1150,1145,'C.tclass,C.c)).w',';if(C.h',1308,'.h=',1135,'.defaultH}if(C.d',1308,'.d=0}C.computedW=1}return C},DelimBestFit',911,'E,J,D,G){if(J==0&&D==0){return null}var I;var F;D','=jsMath.TeX.fam[','D];var A=(G.charAt(1)=="S");var B=(G.charAt(0)=="S");while(J!=null){I=',933,'D][J];',1161,1135,'.defaultH}',1160,'F=I.h+I.d;if(I.delim){return[J,D,"",E]}if(A&&0.5*F>=E','){return[J,D,"','SS",0.5*F]}if(B&&0.7*F>=E',1345,'S",0.7*F]}if(F>=E||I.n==null',1345,'T",F]}J=I.n}return null},DelimExtendRelative',911,'I,T,O,V,D){var P=',933,'O][T];var N','=this.GetChar(','P.delim.','top?P','.delim.top:','P.delim.rep,O);var ','A',1355,1359,'M',1355,1356,'bot?P','.delim.bot:',1359,'E=',1145,'A.tclass,A.c);','var J=A.w;var S=A.h+A.d;var F;var B;var K;var L;var R;var Q;if(',1356,'mid){var U',1355,1356,'mid,O);Q','=Math.ceil((I-(','N.h+N.d)-(','U.h+U.d)-(M.h+M.d','))/(2*(A.h+A.d',')));I=2*','Q*(A.h+A.d)+(N.h+N.d)+(','U.h+U.d)+(M.h+M.d);if(D){F=0}else{F=I/2+V}B=F;K=',1109,'Place(',1145,'N.tclass,N.c),0,F-N.h',')+',1109,1386,1145,'M.tclass,M.c),-(','N.w+M.w)/2,F-(I-M.d))+',1109,1386,1145,'U.tclass,U.c),-(M.w+U.w)/2,F-(I+U.h-U.d)/2);L=(J-U','.w)/2;if(Math.abs(L)<0.0001){L=0}if(L){K+=jsMath.HTML.Spacer(L)}F-=N.h+N.d+A.h;for(R=0;R<Q;R++){K+=jsMath.HTML.Place(E,-J,F-R*S)}','F-=I/2-A.h/2;for(R=0;R<Q;R++){K+=',1109,1386,'E,-J,F-R*S)}}else{Q',1378,1379,'M.h+M.d))/(A.h+A.d));if(N.h+N.d<0.9*(A.h+A.d)){Q=Math.max(1,Q)}I=',1383,'M.h+M.d);if(D){F=0}else{F=I/2+V}B=F;K=',1109,1386,1145,1388,');L=(J-N',1399,'K+=',1109,1386,1145,1393,'J+M.w)/2,B-(I-M.d))}if(D){S=N.h}else{S=I/2+V}var G=',1303,'K,A.w,S,I-S);G.bh=',933,'O].h;G.bd=',933,'O].d;return G},DelimExtendAbsolute',911,'I,S,M,U,B){var R=',933,'M];var N=R[S];var J;var L',1355,'N.delim.top?N',1358,'N.delim.rep,M);var ','A',1355,1434,'K',1355,'N.delim.bot?N',1367,1434,'O;var Q;var E;var D;var P;if(N.delim.mid){var T',1355,'N.delim.mid,M);O',1378,'L.h+L.d)-(','T.h+T.d-0.05',')-(','K.h+K.d-0.05',1381,'-0.05',1382,'O*(A.h+A.d-0.05)+(L.h+L.d)+(',1448,')+(',1450,');J=','jsMath.HTML.PlaceAbsolute(',1145,'L.tclass,L.c),0,0);Q=A.h+A.d-0.05;E=L.d-0.05+A.h;D=',1145,'M,A.c);for(P=0;P<O;P++){J+=',1459,'D,0,E+P*Q)}J+=',1459,1145,'T.tclass,T.c),0,E+O*Q-A.h+T.h);E+=O*Q+',1448,';for(P=0;P<O;P++){J+=',1459,'D,0,E+P*Q)}J+=',1459,1145,'K.tclass,K.c),0,E+O*Q-A.h+K.h)}','else{O',1378,1447,1450,'))/(A.h+A.d-0.05));I=',1454,1450,');J=',1459,1145,'L.tclass,L.c),0,0);Q=A.h+A.d-0.05;E=L.d-0.05+A.h;D=',1145,1371,'for(P=0;P<O;P++){J+=',1459,'D,0,E+P*Q)}J+=',1459,1145,1475,'var G=L.w;if(B){Q=L.h;E=0}else{Q=I/2+U;E=Q-L.h}J=',1109,1099,'(J,G,R.h,"none",-E,jsMath.h);var F=',1303,'J,A.w,Q,I-Q);F.bh=',933,'M].h;F.bd=',933,'M].d;return F},Delimiter',911,'B,I,C,G){var A=4;var F=',1147,'TeX(C,A);if(!I','){return this.Space(F.nulldelimiterspace)}','var ','E=this.DelimBestFit(B,I[','2],I[1],C);',965,'||E[3]<B){',1511,'4],I[3],C)}',965,1509,'if(E[2]==""){',967,'DelimExtend(B,E[0],E[1],F.axis_height,G)}var D=',1135,'.TeX(E[0],E[1],E[2],A).Styled();if(G){D.y=-',933,'E[1]].dh*F.scale}else{D.y=-((D.h+D.d)/2-D.d-F.axis_height)}',956,'D.y',1036,'D.y=0}if(D.y){D=',1135,'.SetList([D],E[2],A)}return D},GetCharCode',911,'B){var A',1336,'B[0]];var D=',933,'A];var C=D[B[1]];',1320,'[1],4)}if(C.w',1308,'.w',1150,1145,1326,'}if(C.font',1308,'.font=A}return C},AddClass',911,'B,C,A){if(B==null){B=A}return ',1145,'B,C)},LayoutRelative',911,'V,f,Y,I,J,N,c,X){if(Y==null){Y=[]}if(I==null){I=[]}if(J==null){J=[]}if(c==null){c=1}','if(X==null){X=1}','var k=jsMath.sizes[V]/100;var G=[];var T=[];var U=[];var E=-1000;var F=E;var K=E;var a;var Z;var M',';for(a=0;a<f.length;a++){','if(J[a]==null){J[a]=0}M=f[a];T[a]=c*jsMath.h*k;U[a]=c*jsMath.d*k;for(Z=0;Z<M.length;Z++){M[Z]=M[Z','].Remeasured();if(','M[Z].h>T[a]){T[a]=M[Z].h}if(M[Z].d>U[a]){U[a]=M[Z].d}if(Z>=G',1218,'G[Z]=M[Z].w',1215,'M[Z].w>G[Z]){',1561,'}}if(M[Z].bh>F){F=M[Z].bh}if(M[Z].bd>K){K=M[Z].bd}}}if(J[f','.length]==null){','J[f.length]=0}if(F==E){F=0}if(K==E){K=0}var A=c','*(jsMath.hd-0.01)*','k;var S=(N||1)*k/6;var R="";var L=0;var e=0;var Q;var b;var O;var P;var C;var B;for(Z=0;Z<G.length;Z++){C=[];O=-T[0]-J[0];L=0',1556,'B=f[a][Z','];if(B&&B.format!="null"){if(','Y[Z]=="l"){Q=0',1215,'Y[Z]=="r"){Q=G[Z]-B.w}else{Q=(G[Z]-B.w)/2}}B.x=Q-L;L=B.w+Q;B.y=O;C[C.length]=B}if(a+1<f',1218,'O-=Math.max(A,U[a]+T[a+1])+S+J[a+1]}}if(I[Z]==null){I[Z]=k}if(C.length>0){P=',1135,'.SetList(C,"T",V);R+=',1109,1386,'P.html,e,0);e=G[Z]-P.w+I[Z]}else{e+=I[Z]}}Q=-I[G',1221,'];O=(T',1221,')*S+J[0];for(a=0;a<G.length;a++){Q+=G[a]+I[a]}for(a=0;a<T.length;a++){O','+=Math.max(A,','T[a]+U[a])+J[a+1]}b=O','/2+jsMath.TeX.axis_height;var ','g=O-b;R+=',1109,'Spacer(e-I[G',1221,']+X*k/6);R=',1109,1386,'R,X*k/6,b);P=',1303,'R,Q+X*k/3,b,g);P.bh=F;P.bd=K;return P},LayoutAbsolute',911,'R,Z,U,E,F,I,X,S){if(U==null){U=[]}',965,'){E=[]}if(F==null){F=[]}',1554,'if(S==null){S=1}var b=jsMath.sizes[R]/100;var A=X',1568,'b;var N=(I||1)*b/6;var C=[];var O=[];var Q=[];var P=0;var Y;var L;var J;var V;var T;var G;','for(V=0;V<Z.length;V++){','if(F[V]==null){F[V]=0}G=Z[V];O[V]=X*jsMath.h*b;Q[V]=X*jsMath.d*b;for(T=0;T<G.length;T++){G[T]=G[T',1558,'G[T].h>O[V]){O[V]=G[T].h}if(G[T].d>Q[V]){Q[V]=G[T].d}if(T>=C',1218,'C[T]=G[T].w',1215,'G[T].w>C[T]){',1613,'}}}}if(F[Z',1566,'F[Z.length]=0}J=(O',1221,')*N+F[0];for(V=0;V<O.length;V++){J',1587,'O[V]+Q[V])+F[V+1]}Y=J',1589,'a=J-Y;var M="";var B;P=S*b/6;for(T=0;T<C.length;T++){J=O[0]-Y+F[0];',1608,'B=Z[V][T',1572,'U[T]&&U[T]=="','l"){L=0',1215,1629,'r"){L=C[T]-B.w}else{L=(C[T]-B.w)/2}}M+=',1459,'B.html,P+L,J-Math.max(0,B.bh-jsMath.h*b),B.mw,B.Mw,B.w)}if(V+1<Z',1218,'J',1587,'Q[V]+O[V+1])+N+F[V+1]}}if(E[T]==null){E[T]=b}P+=C[T]+E[T]}P=-E[C',1221,']+S*b/3;for(V=0;V<C.length;V++){P+=C[V]+E[V]}M=',1109,'Spacer(S*b/6',')+M+',1109,1643,');if(',989,1119,'J=Y-jsMath.h}else{J=0}M=',1109,1099,'(M,P,Y+a,a,J,Y);var K=',1303,'M,P+S*b/3,Y,a);return K},InternalMath',911,'G,E){G=G.replace(/@\\(([^)]*)\\)/g,"<$1>");if(!G.match(/\\$|\\\\\\(/)){',967,'Text(G,"normal","T",E).Styled()}var D=0;var B=0;var H;var C="";var A=[];var F;while(D<G',1218,'H=G.charAt(D++);if(H','=="$"){if(C=="$"){','F=jsMath.Parse(G.slice(B,D-','1','),null,E);if(F.error){A[A.length]=this.Text(F.error,"error","T",E,1,0.2)}else{F.Atomize();A[A.length]=F.mlist.Typeset("T",E).Styled()}C="";B=D','}else{','A[A.length]=this.Text(G.slice(B',',D-1','),"normal","T",E,1,0.2);','C="$";B=D}}else{if(H=="\\\\"){',1661,'=="("&&C==""){',1667,',D-2',1669,'C=")";B=D',1215,'H==")"&&C==")"){',1663,'2',1665,'}}}}}',1667,1669,967,'SetList(A,"T",E)},Set',911,'C,B,A,D){if(C&&C.type){if(C.type=="typeset"){return C}if(C.type=="mlist"){C.mlist.Atomize(B,A);return C.mlist.Typeset(B,A)}if(C.type=="text"){C=this.Text(C.text,C.tclass,B,A,C.ascend||null,C.descend||null',');if(D!=0){C.Styled()}return C}','C=this.TeX(C.c,C.font,B,A',1689,'return jsMath'],
  ['.Box.Null()},SetList',':function(','D,F,C){var A=[];var G;','for(var B=0;B<','D.length',';B++){','G=D[B];if(G','.type=="','typeset"){G=','jsMath.mItem','.','Typeset','(G)}A[A','.length]=','G}','var E=','new ','jsMath.Typeset','(A);','return ','E.',11,'(F,C)}});','jsMath.','Package(','jsMath.Box',',{Styled',':function(){','if(this.','format=="text"){','this.html','=',17,'.AddClass(','this.tclass',',',30,');',30,'=',17,'.AddStyle(','this.style',',this.size,',30,');delete ',34,';delete ',42,';this.format="html"}',19,'this},','Remeasured',27,28,'w>0){this.w=',23,'EmBoxFor(',30,').w}',19,'this}});',9,'=function(A',',B','){this.type','=A;',23,'Add(','this,B)};',23,68,9,',{Atom',1,'B,A){',19,'new ',9,'(B,{','atom:1,nuc:A})},','TextAtom',1,'C,F,B,A,E){var D=new ',9,'(C',',{atom:1,nuc:{type:"','text",text:F,tclass:B}});if(A','!=null){D.nuc.','ascend=A}if(E',88,'descend=E}',19,'D},TeXAtom',1,'B,','C,A){',19,'new ',9,'(B',86,'TeX",c:C,font:A}})},Fraction',1,'B,A,F,D,E,C){',19,'new ',9,'("fraction",{from:B,num:A,den:F,','thickness',':D,left:E,right:C})},Space',1,'A){',19,'new ',9,'("space",{w:A})},',11,1,'A){',19,'new ',9,'("ord",{',80,'HTML',1,'A){',19,'new ',9,'("html",{html:A})}});',23,'mList','=function(D,A,B,C){','if(D){','this.mlist','=D}else{',136,'=[]}','if(C==null){C','="T"}if(B==null){B=4}','this.data','={openI:null,overI:null,overF:null,font:A,','size:B,style:C','};this.init={',144,'}};',23,'Package(',23,133,',{Add',1,'A){return(',136,'[','this.mlist.length',']=A)},Get',1,'A){',19,136,'[A]},Length',27,19,157,'},Last',27,'if(',157,'==0){',19,'null}',19,136,'[',157,'-1]},Range',1,75,'if(A==null){A=',157,'}',19,'new ',23,133,'(',136,'.slice(B,A+1))},Delete',1,'D,C){',140,'=D}if(',136,'.splice){',136,'.splice(D,C-D+1)}else{var A=[];',3,157,5,'if(B<D||B>C){A[A',13,136,'[B]}}',136,'=A}},Open',1,'D){var C=','this.Add(','new ',9,'("boundary",{','data:',142,'}));','var A=',142,';',142,'={};for(var B in A){',142,'[B]=A[B]}delete ',142,'.overI',47,142,'.overF;',142,'.openI','=',157,'-1;if(D!=null){C.left=D}',19,'C},Close',1,'C){if(C!=null){C=new ',9,213,'right:C})}var E;','var B=',142,230,';var F=',142,'.overI;','var G=',142,228,142,'=',136,'[B].data;if(F){E=',9,'.Fraction(','G.name,{','type:"mlist",mlist:this.Range(','B+1,F-1)},{',257,'F)},G.',109,',G.left,G.right);if(C){',217,'new ',23,133,'([',136,'[B],E,C]);E=',9,'.Atom("inner",{type:"mlist",mlist:A})}}else{var D=B+1;if(C){',210,'C);D--}E=',9,'.Atom((C)?"inner":"ord",{',257,'D)})}this.Delete(B,this.Length());',19,210,'E)},Over',27,241,142,246,'var C=',142,228,217,9,255,'C.name,{',257,'open+1,B-1)},{',257,'B)},C.',109,',C.left,C.right);',136,'=[A]},Atomize',1,192,'var A;var E="";',42,'=D;this.size=C;',3,157,5,'A=',136,'[B];A.delta=0;if(A',7,'choice"){',136,'=this.Atomize.choice(',42,',A,B,',136,');B--}else{',28,'Atomize[A.type',']){var F=this.',320,'];F(',42,43,'A,E,this,B)}}E=A}if(A&&A',7,'bin"){A','.type="ord"}','if(',157,'>=2&&A',7,'boundary"&&',136,'[0].type=="boundary"){this.','AddDelimiters','(D,C)}},',337,1,'A,N){var M=-10000;',15,'M;',247,'M;for(var D=0;D<',157,';D++){var F=',136,'[D];if(F.atom||F',7,'box"){E','=Math.max(','E,F.nuc.h+F.nuc.y);G',352,'G,F.nuc.d-F.nuc.y)}}var C=',23,'TeX;var I=',17,'.TeX(A,N).','axis_height',';var L',352,'E-I,G+I);var K',352,'Math.floor(C.integer*L/500)*C.delimiterfactor,C.integer*(2*L-C.delimitershortfall))/C.integer;',241,136,'[0];var J=',136,'[',157,'-1];B.nuc=',25,'.Delimiter(','K,B.left,A);J.nuc=',25,374,'K,J.right,A);B.type="open";B.atom=1',47,'B.left;J.type="close";J.atom=1',47,'J.right},',11,1,96,241,'new ',17,'(',136,');',19,'B.',11,'(C,A)}});',23,68,23,133,'.prototype.Atomize,{style',1,'D,C,A,E,B){B.','style=A.style},size',1,402,'size=A.size},phantom',1,'C,B,A){var D=','A.nuc=',25,'.Set(','A.phantom',',C,B);if(A.h){D.',52,'();D.html=','jsMath.HTML.Spacer','(D.w)}else{D.html="",D.w=D.Mw=D.mw=0}if(!A.v){','D.h=D.d=0','}D.bd=D.bh=0',47,412,';A.type="box"},','smash',1,408,409,25,'.Set(A.smash,C,B',').Remeasured();',418,47,'A.smash',422,'raise',1,'C,B,A){',409,25,'.Set(A.nuc,','C,B);var D=A.raise;','A.nuc.html','=',23,'HTML.Place(',441,',0,D,A.nuc.mw,A.nuc.Mw,A.nuc.w);A.nuc.h+=D;A.nuc.d-=D;A','.type="ord";','A.atom=1},lap',1,'D,',96,15,25,439,'D,C',429,'var B=[E];if(A.lap=="llap"){E.x=-E.w}','else{if(A.lap=="','rlap"){B[1]=',9,'.Space(-E.w)}',458,'ulap"){E.y=E.d;E.h=E.d=0}',458,'dlap"){E.y=-E.h;E.h=E.d=0}}}}A','.nuc=jsMath.Box.SetList','(B,D,C);if(A.lap=="ulap"||A.lap=="dlap"){A.nuc.h=A.nuc.d=0}A.type="box";delete A.atom},bin',1,'D,B,A,E){if(E&&E.type){var C=E.type;if(C=="bin"||C=="op"||C=="rel"||C=="open"||C=="punct"||C==""||(C=="',334,'E.left!="")){A.type="ord"}}else{A',329,'jsMath.mList.prototype.Atomize.SupSub(','D,B,A)},rel',1,'C,B,A,D){if(D.type&&D',7,'bin"){D',329,473,'C,B,A)},','close',1,'C,B,A,D){if(D.type&&D',7,'bin"){D',329,473,481,'punct',1,'C,B,A,D){if(D.type&&D',7,'bin"){D',329,473,481,'open',1,436,473,481,'inner',1,436,473,481,'vcenter',1,408,25,439,'C,B);',15,17,'.TeX(C,B);D.y=E.',360,'-(D.h-D.d)/2;',409,'D;A',447,473,481,'overline',1,'D,',96,247,17,'.TeX(D,','C);',15,25,439,17,'.PrimeStyle(','D),C',429,241,'G','.default_rule_thickness',244,25,'.Rule(E.w,B);F.x=-F.w;F.y','=E.h+3*B;A',466,'([E,F],D,C);A.nuc.','h+=B;A',447,473,'D,C,A)},','underline',1,'D,',96,247,17,530,'C);',15,25,439,17,536,'D),C',429,241,'G',541,244,25,544,'=-E.d-3*B-B;A',466,547,'d+=B;A',447,473,551,'radical',1,'B,M,G){var D=',17,'.TeX(B,M);var K=',17,536,'B);var F=',25,'.Set(G.nuc,K,M',429,'var L=D',541,';var C=L;if(B=="D"||B=="D\'"){C=D.x_height}',217,'L+C/4;',15,25,374,'F.h+F.d+A+L,[0,2,112,3,112],B,1);if(E.d>F.h+F.d+A){A=(A+E.d-F.h-F.d)/2}E.y=F.h+A;var J=',25,'.Rule(F.w,L);J.y=E.y-L/2;J.h+=3*L/2;F.x=-F.w;var I=',17,'.UpStyle(',17,603,'B));var H=',25,'.Set(G.root||null,I,M',429,'if(G.root){H.y=0.55*(F.h+F.d+3*L+A)-F.d;E.x',352,'H.w-(11/18)*E.w,0);J.x=(7/18)*E.w;H.x=-(H.w+J.x)}G',466,'([E,H,J,F],B,M);G',447,473,'B,M,G)},accent',1,'B,P,I){',15,17,'.TeX(B,P);var L=',17,536,'B);var H=',25,'.Set(I.nuc,L,P);var N=H.w;var O;var J;var C=0;if(I.nuc',7,'TeX"){','J=',23,'TeX[I.nuc.font];if(J[I.nuc.c].krn&&J.skewchar){O=J[I.nuc.c].krn[J.skewchar]}C=J[I.nuc.c].ic;',140,'=0}}if(O==null){O=0}var K=I.accent[2];var D=',23,'TeX.fam[I.accent[1]];J=',23,'TeX[D];while(J[K].n&&J[J[K].n].w<=N){K=J[K].n}var M=Math.min(H.h,E.x_height);if(I.nuc',7,629,247,9,'.Atom("ord",I.nuc);G.sup=I.sup;G.sub=I.sub;G.delta=0;',473,'B,P,G);M+=(G.nuc.h-H.h);H=I.nuc=G.nuc',47,'I.sup',47,'I.sub}var F=',25,'.TeX(K,D,B,P);F.y=H.h-M;F.x=-H.w+O+(N-F.w)/2;if(',23,'Browser.msieAccentBug){F.html+=',416,'(0.1);F.w+=0.1;F.Mw+=0.1}if(J[K].ic||C){F.x+=(C-(J[K].ic||0))*E.scale}I',466,'([H,F],B,P);if(I.nuc.w!=H.w){',217,9,'.Space(','H.w-I.nuc.w);I',466,'([I.nuc,A],B,P)}I',447,473,'B,P,I)},op',1,'D,O,J){',247,17,530,'O);var I;J.delta=0;var N=(D','.charAt(0)=="','D");if(J.limits==null&&N){J.limits=1}if(J.nuc',7,629,241,23,'TeX[J.nuc.font][','J.nuc.c];if(N&&B.n){J.nuc.c=B.n;B=',23,679,'B.n]}I=J.nuc=',25,'.Set(J.nuc,D,O',');if(B.ic){J.delta=B.ic*G.scale;if(J.limits||!J.sub||',23,'Browser.msieIntegralBug','){I=J',466,'([I,',9,660,'J.delta)],D,O)}}I.y=-((I.h+I.d)/2-I.d-G.',360,');if(Math.abs(I.y)<0.0001){I.y=0}}if(!I){I=J.nuc=',25,685,').',52,'()}if(J.limits){var F=I.w;var L=I.w;var E=[I];var K=0;var M=0;if(J.sup){var H=',25,'.Set(J.sup,',17,603,'D),O',429,'H.x=((I.w-H.w)/2+J.delta/2)-L;K=G.big_op_spacing5;F',352,'F,H.w);L+=H.x+H.w;H.y=I.h+H.d+I.y+Math.max(G.big_op_spacing1,G.big_op_spacing3-H.d);E[E',13,'H',47,'J.sup}if(J.sub){',217,25,'.Set(J.sub,',17,'.DownStyle(','D),O',429,'A.x=((I.w-A.w)/2-J.delta/2)-L;M=G.big_op_spacing5;F',352,'F,A.w);L+=A.x+A.w;A.y=-I.d-A.h+I.y-Math.max(G.big_op_spacing2,G.big_op_spacing4-A.h);E[E',13,'A',47,'J.sub}if(F>I.w){I.x=(F-I.w)/2;L+=I.x}if(L<F){E[E',13,9,660,'F-L)}J',466,'(E,D,O);J.nuc.h+=K;J.nuc.d+=M','}else{if(',23,688,'&&J.sub&&B&&B.ic){J',466,'([I,',25,'.Space(-B.ic*G.scale)],D,O)}else{if(I.y){J',466,'([I],D,O)}}',473,'D,O,J)}},ord',1,'A,I,G,B,F,E){if(G.nuc',7,'TeX"&&!G.sup&&!G.sub){var D=F.mlist[E+1];if(D&&D.atom&&D.type&&(D',7,'ord"||D',7,'op"||D',7,'bin"||D',7,'rel"||D',7,'open"||D',7,'close"||D',7,'punct")){if(D.nuc',7,'TeX"&&D.nuc.font==G.nuc.font){G.textsymbol=1;var H=',23,'TeX[G.nuc.font][G.nuc.c].krn;H*=',17,'.TeX(A,I).scale;if(H&&H[D.nuc.c]){for(var C=F.mlist.length-1;C>E;C--){F.mlist[C+1]=F.mlist[C]}F.mlist[E+1]=',9,660,'H[D.nuc.c])}}}}',473,'A,I,G)},fraction',1,'R,N,B){var U=',17,'.TeX(R,N);var L=0;if(B.',109,'!=null){L=B.',109,735,'B.from.match(/over/)){L=U',541,'}}var Q=(R',673,'D");var F=(R=="D")?"T":(R=="D\'")?"T\'":',17,603,'R);var P=(Q)?"T\'":',17,719,'R);',15,25,'.Set(B.num,F,N',429,'var D=',25,'.Set(B.den,P,N',429,'var K;var J;var I;var O;var M;var G=(Q)?U.delim1:U.delim2;var A=[',25,374,'G,B.left,R)];var S=',25,374,'G,B.right,R);if(E.w<D.w){E.x=(D.w-E.w)/2;D.x=-(E.w+E.x);I=D.w;A[1]=E;A[2]=D}else{D.x=(E.w-D.w)/2;E.x=-(D.w+D.x);I=E.w;A[1]=D;A[2]=E}if(Q){K=U.num1;J=U.denom1}else{K=(L!=0)?U.num2:U.num3;J=U.denom2}if(L==0){O=(Q)?7*U',541,':3*U',541,';M=(K-E.d',')-(D.h-J);if(M<O){','K+=(O-M)/2;J+=(O-M)/2}}else{O=(Q)?3*L:L;var T=U.',360,';M=(K-E.d)-(T+L/2);if(M<O){K+=O-M}M=(T-L/2',814,'J+=O-M}var C=',25,'.Rule(I,L);C.x=-I;C.y=T-L/2;A[A',13,'C}E.y=K;D.y=-J;A[A',13,'S;B',466,'(A,R,N);B',447,'B.atom=1',47,'B.num',47,'B.den;',473,'R,N,B)},SupSub',1,'F,R,L){var H=',17,'.TeX(F,R);var P=L.nuc;var K=L.nuc=',25,'.Set(L.','nuc,F,R,0);if(K.format=="null"){K=L.nuc=',25,'.Text("","normal",F,R)}if(P',7,629,'if(!L.textsymbol){',15,23,'TeX[P.font][P.c];if(E.ic){L.delta=E.ic*H.scale;if(!L.sub){K=L',466,'([K,',25,660,'L.delta)],F,R);L.delta=0}}}else{L.delta=0}}if(!L.sup&&!L.sub){return }L.nuc.Styled();var I=',17,719,'F);var M=',17,603,'F);var D=',17,'.TeX(M,R).','sup_drop;',241,17,'.TeX(I,R).','sub_drop;var O=0;var N=0;var G;if(P.type&&P.type!="text"&&P.type!="TeX"&&P.type!="null"){O=K.h-D;N=K.d+B}if(L.sub){',217,25,841,'sub,I,R);A=',25,'.SetList([','A,',9,'.Space(H.scriptspace)],F,R',')}if(!L.sup){A.y=-Math.max(N,H.sub1,A.h-(4/5)*',17,867,'x_height);L',466,'([K,A],F,R).Styled();delete L.sub;return }var J=',25,841,'sup,M,R);J=',25,874,'J,',9,877,');if(F=="D"){G=H.sup1',735,'F','.charAt(','F','.length-1)=="\'"){','G=H.sup3}else{G=H.sup2}}O',352,'O,G,J.d+',17,863,'x_height/4);if(!L.sub){J.y=O;L',466,'([K,J],F,R',45,'L.sup;return }N',352,'N,',17,867,'sub2);var Q=H',541,';if((O-J.d)-(A.h-N)<4*Q){N=4*Q+A.h-(O-J.d);G=(4/5)*H.x_height-(O-J.d);if(G>0){O+=G;N-=G}}J.',52,'();A.',52,'();J.y=O;A.y=-N;J.x=L.delta;if(J.w+J.x>A.w){J.x-=A.w;L',466,'([K,A,J],F,R)}else{A.x-=(J.w+J.x);L',466,'([K,J,A],F,R)}delete L.sup',47,'L.sub}});',17,63,65,'="typeset";',136,'=A};',23,68,17,',{upStyle:{D:"S",T:"S","','D\'":"S\'","T\'":"S\'",S:"SS','",SS:"SS","','S\'":"SS\'","SS\'":"SS\'"},','downStyle:{D:"S\'",T:"S\'","',935,'\'",SS:"SS\'","',937,'UpStyle',1,'A){',19,'this.upStyle[A]},DownStyle',1,'A){',19,'this.downStyle[A]},PrimeStyle',1,'A){if(A',895,'A',897,19,'A}',19,'A+"\'"},StyleValue',1,75,'if(B=="S"||B=="S\'"){',19,'0.7*A}if(B=="SS"||B=="SS\'"){',19,'0.5*A}',19,'A},StyleSize',1,'B,A){if(B=="S"||B=="S\'"){A=Math.max(0,A-2)}else{if(B=="SS"||B=="SS\'"){A=Math.max(0,A-4)}}return ','A},TeX',1,970,23,'TeXparams[A]},AddStyle',1,436,'if(C=="S"||C=="S\'"){B',352,'0,B-2)}else{if(C=="SS"||C=="SS\'"){B',352,'0,B-4)}}if(B!=4){A="<span class=\\"size"+B+"\\">"+A+"</span>"}',19,'A},AddClass',1,'A,B){if(A!=""&&A!="normal"){B=',23,'HTML.Class(A,B)}',19,'B}});',23,'Package(',17,',{DTsep:{ord',':{op:1,bin:2,rel:3,inner:1},','op',':{ord:1,op:1',',rel:3,inner:1},bin:{ord:2,op:2,open:2,inner:2},rel:{ord:3,op:3,open:3,inner:3},open:{},close',995,'punct',997,',rel:1,open:1,close',':1,punct:1,inner:1','},inner',997,',bin:2,rel:3,open',1003,'}},SSsep:{ord:{op:1},op',997,'},bin:{},rel:{},open:{},close:{op:1},punct:{},inner:{op:1}},sepW:["","thinmuskip","medmuskip","thickmuskip"],','GetSeparation',1,'A,D,B){if(A&&A.atom&&D.atom){var C=this.DTsep;if(B',673,'S"){C=this.SSsep}',15,'C[A.type];if(E&&E[D.type]!=null){',19,23,'TeX[this.sepW[E[D.type]]]}}',19,'0},',11,1,192,42,304,'var G=-10000;this.w=0;this.mw=0;this.Mw=0;this.h=G;this.d=G;this.bh=this.h;this.bd=this.d;this.tbuf="";this.tx=0;',34,'="";','this.cbuf','="";this.hbuf="";this.hx=0;',217,'null;var F;this.x=0;this.dx=0;',3,157,5,'F=A;A=',136,'[B];switch(A.type){case"size":','this.FlushClassed();','this.size=A.size;','A=F;break;case"','style":',1041,'if(',42,895,42,897,42,'=A.style+"\'"}else{',42,'=A.style}',1043,'space":if(typeof (A.w)=="object"){if(',42,895,'1)=="S"){A.w=0.5*A.w[0]/18',735,42,673,'S"){A.w=0.7*A.w[0]/18}else{A.w=A.w[0]/18}}}this.dx+=A.w-0;',1043,'html":',1041,'if(this.hbuf==""){this.hx=this.','x}','this.hbuf+=','A.html;A=F;break;default:if(!A.atom&&A.type!="box"){break}A.nuc.x+=this.dx+this.',1011,'(F,A,',42,');','if(A.nuc.x||A.nuc.y){','A.nuc.Styled()}this.dx=0;this.x=this.x+this.w;',28,'x','+A.nuc.x+A.nuc.','mw','<this.mw){this.mw=this.','x',1079,'mw}',28,'w',1079,'Mw','>this.Mw){this.Mw=this.w',1079,'Mw}this.w+=A.nuc.w+A.nuc.x;if(A.nuc.',29,'if(',34,'!=A.nuc.tclass&&',34,'!=""){','this.FlushText','()}',28,'tbuf==""&&',1031,'==""){this.tx=this.x}this.tbuf+=',441,';',34,'=A.nuc.tclass}else{',1041,1075,'this.Place(A.nuc)}',1067,'x}',1069,441,'}this.h',352,'this.h,A.nuc.h+A.nuc.y);this.bh',352,'this.bh,A.nuc.bh);this.d',352,'this.d,A.nuc.d-A.nuc.y);this.bd',352,'this.bd,A.nuc.bd);break}}',1041,28,'dx){',1069,416,'(this.dx);this.w+=this.dx;',28,'w',1089,'}',28,'w',1081,'w}}',28,'hbuf==""){',19,25,'.Null()}',28,'h==G){this.h=0}',28,'d==G){this.d=0}',15,'new ',25,'("html",this.hbuf,this.w,this.h,this.d);E.bh=this.bh;E.bd=this.bd;E.mw=this.mw;E.Mw=this.Mw;',19,'E},FlushText',27,28,'tbuf','==""){return }',1031,'+=',17,'.AddClass(',34,',this.tbuf);this.tbuf="";',34,'=""},FlushClassed',27,1098,'();',28,'cbuf',1156,1067,'tx}',1069,17,'.AddStyle(',42,43,1031,');',1031,'=""},Place',1,'B){var A="<','span style=\\"position: relative',';";if(B.x){A+=" margin-left:"+',23,'HTML.Em','(B.x)+";"}if(B.y){A+=" top:"+',23,1187,'(-B.y)+";"}B.html=A+"\\">"+B.html+"</span>";','B.h+=B.y;B.d-=B.y;B.x=0;B.y=0','},PlaceSeparateSkips',1,'B){if(B.y){var D=B.Mw-B.w;var C=B.mw;',217,'B.Mw-B.mw;B.html=',416,'(C-D)+"<',1184,'; "+"top:"+',23,1187,'(-B.y)+";"+"left:"+',23,1187,'(D)+"; width:"+',23,1187,'(A)+";\\">"+',416,'(-C)+B.html+',416,'(D)+"</span>"}if(B.x){B.html=',416,'(B.x)+B.html}',1192,'}});',23,'Parse',134,15,'new ',23,'Parser','(D,A,B,C);E.Parse();',19,'E};',23,1225,134,'this.string=D;this.i=0;',136,'=new ',23,133,'(null,A,B,C)};',23,'Package(',23,1225,',{cmd:"\\\\",open:"{",close:"}",letter:/[a-z]/i,number:/[0-9]/,scriptargs:/^((math|text)..|mathcal|[hm]box)$/,mathchar:{"!":[5,0,33],"(":[4,0,40],")":[5,0,41],"*":[2,2,3],"+":[2,0,43],",":[6,1,59],"-":[2,2,0],".":[0,1,58],"/":[0,1,61],":":[3,0,58],";":[6,0,59],"<":[3,1,60],"=":[3,0,61],">":[3,1,62],"?":[5,0,63],"[":[4,0,91],"]":[5,0,93],"|":[0,2,106]},special:{"~":"Tilde","^":"HandleSuperscript","_":"HandleSubscript"," ":"Space","\\x01','":"Space","\\','t',1243,'r',1243,'n":"Space","\'":"Prime","%":"HandleComment","&":"HandleEntry","#":"Hash"},mathchardef:{braceld:[0,3,122],bracerd:[0,3,123],bracelu:[0,3,124],braceru:[0,3,125],alpha:[0,1,11],beta:[0,1,12],gamma:[0,1,13],delta:[0,1,14],epsilon:[0,1,15],zeta:[0,1,16],eta:[0,1,17],theta:[0,1,18],iota:[0,1,19],kappa:[0,1,20],lambda:[0,1,21],mu:[0,1,22],nu:[0,1,23],xi:[0,1,24],pi:[0,1,25],rho:[0,1,26],sigma:[0,1,27],tau:[0,1,28],upsilon:[0,1,29],phi:[0,1,30],chi:[0,1,31],psi:[0,1,32],omega:[0,1,33],varepsilon:[0,1,34],vartheta:[0,1,35],varpi:[0,1,36],varrho:[0,1,37],varsigma:[0,1,38],varphi:[0,1,39],Gamma:[7,0,0],Delta:[7,0,1],Theta:[7,0,2],Lambda:[7,0,3],Xi:[7,0,4],Pi:[7,0,5],Sigma:[7,0,6],Upsilon:[7,0,7],Phi:[7,0,8],Psi:[7,0,9],Omega:[7,0,10],aleph:[0,2,64],imath:[0,1,123],jmath:[0,1,124],ell:[0,1,96],wp:[0,1,125],Re:[0,2,60],Im:[0,2,61],partial:[0,1,64],infty:[0,2,49],prime:[0,2,48],emptyset:[0,2,59],nabla:[0,2,114],surd:[1,2,112],top:[0,2,62],bot:[0,2,63],triangle:[0,2,52],forall:[0,2,56],exists:[0,2,57],neg:[0,2,58],lnot:[0,2,58],flat:[0,1,91],natural:[0,1,92],sharp:[0,1,93],clubsuit:[0,2,124],diamondsuit:[0,2,125],heartsuit:[0,2,126],spadesuit:[0,2,127],coprod:[1,3,96],bigvee:[1,3,87],bigwedge:[1,3,86],biguplus:[1,3,85],bigcap:[1,3,84],bigcup:[1,3,83],intop:[1,3,82],prod:[1,3,81],sum:[1,3,80],bigotimes:[1,3,78],bigoplus:[1,3,76],bigodot:[1,3,74],ointop:[1,3,72],bigsqcup:[1,3,70],smallint:[1,2,115],triangleleft:[2,1,47],triangleright:[2,1,46],bigtriangleup:[2,2,52],bigtriangledown:[2,2,53],wedge:[2,2,94],land:[2,2,94],vee:[2,2,95],lor:[2,2,95],cap:[2,2,92],cup:[2,2,91],ddagger:[2,2,122],dagger:[2,2,121],sqcap:[2,2,117],sqcup:[2,2,116],uplus:[2,2,93],amalg:[2,2,113],diamond:[2,2,5],bullet:[2,2,15],wr:[2,2,111],div:[2,2,4],odot:[2,2,12],oslash:[2,2,11],otimes:[2,2,10],ominus:[2,2,9],oplus:[2,2,8],mp:[2,2,7],pm:[2,2,6],circ:[2,2,14],bigcirc:[2,2,13],setminus:[2,2,110],cdot:[2,2,1],ast:[2,2,3],times:[2,2,2],star:[2,1,63],propto:[3,2,47],sqsubseteq:[3,2,118],sqsupseteq:[3,2,119],parallel:[3,2,107],mid:[3,2,106],dashv:[3,2,97],vdash:[3,2,96],leq:[3,2,20],le:[3,2,20],geq:[3,2,21],ge:[3,2,21],lt:[3,1,60],gt:[3,1,62],succ:[3,2,31],prec:[3,2,30],approx:[3,2,25],succeq:[3,2,23],preceq:[3,2,22],supset:[3,2,27],subset:[3,2,26],supseteq:[3,2,19],subseteq:[3,2,18],"in":[3,2,50],ni:[3,2,51],owns:[3,2,51],gg:[3,2,29],ll:[3,2,28],not:[3,2,54],sim:[3,2,24],simeq:[3,2,39],perp:[3,2,63],equiv:[3,2,17],asymp:[3,2,16],smile:[3,1,94],frown:[3,1,95],Leftrightarrow:[3,2,44],Leftarrow:[3,2,40],Rightarrow:[3,2,41],leftrightarrow:[3,2,36],','leftarrow',':[3,2,32],gets:[3,2,32],rightarrow:[3,2,33],to:[3,2,33],','mapstochar',':[3,2,55],leftharpoonup:[3,1,40],','leftharpoondown',':[3,1,41],rightharpoonup:[3,1,42],rightharpoondown:[3,1,43],nearrow:[3,2,37],searrow:[3,2,38],nwarrow:[3,2,45],swarrow:[3,2,46],minuschar:[3,2,0],hbarchar:[0,0,22],lhook:[3,1,44],rhook:[3,1,45],ldotp:[6,1,58],cdotp:[6,2,1],colon:[6,0,58],"#":[7,0,35],"$":[7,0,36],"%":[7,0,37],"&":[7,0,38]},delimiter:{"(":[0,0,40,3,0],")":[0,0,41,3,1],"[":[0,0,91,3,2],"]":[0,0,93,3,3],"<":[0,2,104,3,10],">":[0',',2,105,3,11],"\\\\','lt":[0',',2,104,3,10],"\\\\','gt":[0,2,105,3,11],"/":[0,0,47,3,14],"|":[0,2,106,3,12],".":[0,0,0,0,0],"\\\\":[','0,2,110,3,15],"\\\\','lmoustache":[4,3,122,3,64],"\\\\rmoustache":[5,3,123,3,65],"\\\\lgroup":[4,6,40,3,58],"\\\\rgroup":[5,6,41,3,59],"\\\\arrowvert','":[0,2,106,3,','60],"\\\\Arrowvert":[0,2,107,3,61],"\\\\bracevert',1261,'62],"\\\\Vert":[0,2,107,3,13],"\\\\|":[0,2,107,3,13],"\\\\vert',1261,'12],"\\\\uparrow":[3,2,34,3,120],"\\\\downarrow":[3,2,35,3,121],"\\\\updownarrow":[3,2,108,3,63],"\\\\Uparrow":[3,2,42,3,126],"\\\\Downarrow":[3,2,43,3,127],"\\\\Updownarrow":[3,2,109,3,119],"\\\\backslash":[',1259,'rangle":[5',1255,'langle":[4',1257,'rbrace":[5,2,103,3,9],"\\\\lbrace":[4,2,102,3,8],"\\\\}":[5,2,103,3,9],"\\\\{":[4,2,102,3,8],"\\\\rceil":[5,2,101,3,7],"\\\\lceil":[4,2,100,3,6],"\\\\rfloor":[5,2,99,3,5],"\\\\lfloor":[4,2,98,3,4],"\\\\lbrack":[0,0,91,3,2],"\\\\rbrack":[0,0,93,3,3]},macros:{displaystyle',':["HandleStyle","','D"],textstyle',1273,'T"],scriptstyle',1273,'S"],scriptscriptstyle',1273,'SS"],rm',':["HandleFont",','0],mit',1281,'1],oldstyle',1281,'1],cal',1281,'2],it',1281,'4],bf',1281,'6],font',':["Extension","','font"],left:"HandleLeft",right:"HandleRight",arcsin',':["NamedOp",0],','arccos',1295,'arctan',1295,'arg',1295,'cos',1295,'cosh',1295,'cot',1295,'coth',1295,'csc',1295,'deg',1295,'det',':"NamedOp",','dim',1295,'exp',1295,'gcd',1315,'hom',1295,'inf',1315,'ker',1295,'lg',1295,'lim',1315,'liminf',':["NamedOp",null,"lim<span style=\\"margin-left: "+1/6+"em\\"></span>','inf"],limsup',1333,'sup"],ln',1295,'log',1295,'max',1315,'min',1315,'Pr',1315,'sec',1295,'sin',1295,'sinh',1295,'sup',1315,'tan',1295,'tanh',1295,508,':["HandleAtom","',508,'"],',524,1359,524,'"],',552,1359,552,'"],over',':"HandleOver",','overwithdelims',1370,'atop',1370,'atopwithdelims',1370,'above',1370,'abovewithdelims',1370,'brace',':["HandleOver','","\\\\{","\\\\}"],brack',1382,'","[","]"],choose',1382,'","(",")"],overbrace',':["Extension","leaders"],','underbrace',1388,'overrightarrow',1388,'underrightarrow',1388,'overleftarrow',1388,'underleftarrow',1388,'overleftrightarrow',1388,'underleftrightarrow',1388,'overset',':["Extension","underset-overset"],','underset',1404,'llap',':"HandleLap",','rlap',1408,'ulap',1408,'dlap',1408,'raise:"RaiseLower",lower:"RaiseLower",moveleft',':"MoveLeftRight",','moveright',1416,'frac:"Frac",root:"Root",sqrt:"Sqrt",hbar',':["Macro","\\\\','hbarchar\\\\kern-.5em h"],ne',1420,'not="],neq',1420,'not="],notin',1420,'mathrel{\\\\','rlap{\\\\kern2mu/}}\\\\in"],cong',1420,1427,'lower2mu{\\\\mathrel{{\\\\rlap{=}\\\\raise6mu\\\\sim}}}}"],bmod',1420,'mathbin{\\\\rm mod}"],pmod',1420,'kern 18mu ({\\\\rm mod}\\\\,\\\\,#1)",1],"int":["Macro","\\\\intop\\\\nolimits"],oint',1420,'ointop\\\\nolimits"],doteq',1420,'buildrel\\\\textstyle.\\\\over="],ldots',1420,'mathinner{\\\\','ldotp\\\\ldotp\\\\ldotp}"],cdots',1420,1441,'cdotp\\\\cdotp\\\\cdotp}"],vdots',1420,1441,'rlap{\\\\raise8pt{.\\\\rule 0pt 6pt 0pt}}\\\\rlap{\\\\raise4pt{.}}.}"],ddots',1420,1441,'kern1mu\\\\raise7pt{\\\\rule 0pt 7pt 0pt .}\\\\kern2mu\\\\raise4pt{.}\\\\kern2mu\\\\raise1pt{.}\\\\kern1mu}"],joinrel',1420,1427,'kern-4mu}"],relbar',1420,1427,'smash-}"],Relbar',1420,'mathrel="],bowtie',1420,'mathrel\\\\triangleright\\\\joinrel\\\\mathrel\\\\triangleleft"],models',1420,'mathrel|\\\\joinrel="],mapsto',1420,1427,1251,'\\\\rightarrow}"],rightleftharpoons',1420,508,'{\\\\',1427,'rlap{\\\\raise3mu{\\\\rightharpoonup}}}\\\\',1253,'}"],hookrightarrow',1420,'lhook','\\\\joinrel\\\\rightarrow','"],hookleftarrow',1420,'leftarrow\\\\joinrel\\\\','rhook"],Longrightarrow',1420,'Relbar\\\\joinrel\\\\','Rightarrow"],','longrightarrow',1420,'relbar',1477,'"],longleftarrow',1420,1480,'relbar"],Longleftarrow',1420,'Leftarrow\\\\joinrel\\\\','Relbar"],longmapsto',1420,1427,1251,'\\\\minuschar',1477,'}"],longleftrightarrow',1420,1249,1477,'"],','Longleftrightarrow',1420,1494,1484,'iff:["Macro","\\\\;\\\\',1506,'\\\\;"],mathcal',':["Macro","{\\\\','cal #1}",1],mathrm',1513,'rm #1}",1],mathbf',1513,'bf #1}",1],','mathbb',1513,1518,'mathit',1513,'it #1}",1],textrm',1420,'mathord{\\\\hbox{#1}}",1],textit',1420,'mathord{\\\\class{','textit','}{\\\\hbox{#1}}}",1],','textbf',1420,1528,1531,1530,'pmb',1420,'rlap{#1}\\\\kern1px{#1}",1],TeX:["Macro","T\\\\kern-.1667em\\\\lower.5ex{E}\\\\kern-.125em X"],limits:["Limits",1],nolimits:["Limits",0],",":["Spacer",1/6],":":["Spacer",1/6],">":["Spacer",2/9],";":["Spacer",5/18],"!":["Spacer",-1/6],enspace:["Spacer",1/2],quad:["Spacer",1],qquad:["Spacer",2],thinspace:["Spacer",1/6],negthinspace:["Spacer",-1/6],hskip:"Hskip",kern:"Hskip",rule:["Rule","colored"],space:["Rule","blank"],big',':["MakeBig","','ord",0.85],Big',1539,'ord",1.15],bigg',1539,'ord",1.45],Bigg',1539,'ord",1.75],bigl',1539,'open",0.85],Bigl',1539,'open",1.','15],biggl',1539,1550,'45],Biggl',1539,1550,'75],bigr',1539,'close",0.85],Bigr',1539,'close",1.','15],biggr',1539,1561,'45],Biggr',1539,1561,'75],bigm',1539,'rel",0.85],Bigm',1539,'rel",1.15],biggm',1539,'rel",1.45],Biggm',1539,'rel",1.75],mathord',1359,'ord"],mathop',1359,'op"],mathopen',1359,'open"],mathclose',1359,'close"],mathbin',1359,'bin"],mathrel',1359,'rel"],mathpunct',1359,'punct"],mathinner',1359,'inner"],','mathchoice',1293,1593,'"],buildrel:"BuildRel",hbox:"HBox",text:"HBox",mbox:"HBox",fbox',1293,'fbox"],strut:"Strut",mathstrut',1420,'vphantom{(}"],phantom:["Phantom",1,1],vphantom:["Phantom",1,0],hphantom:["Phantom",0,1],smash:"Smash",acute',':["MathAccent",[7,0,','19]],grave',1601,'18]],ddot',1601,'127]],tilde:["'],
  ['MathAccent','",[','7,0,','126]],bar',':["MathAccent",[',2,'22]],breve',4,2,'21]],check',4,2,'20]],hat',4,2,'94]],vec',4,'0,1,126]],dot',4,2,'95]],widetilde',4,'0,3,101]],widehat',4,'0,3,98]],"_":["','Replace","ord','","_","normal",-0.4,0.1]," ":["Replace","','ord","&nbsp;","normal','"],angle:["',25,'","&#x2220;","normal"],matrix:"Matrix",array:"Matrix",pmatrix:["Matrix','","(",")","c"],','cases:["Matrix","\\\\{",".",["l","l"],null,2],eqalign',':["Matrix",null,null,["','r","l"],[','5/18],3,"D"],','displaylines',33,'c"],null,3,"D"],cr:"','HandleRow','","\\\\":"',39,'",newline:"',39,'",noalign:"','HandleNoAlign','",eqalignno',33,'r","l","r"],[5/8,3],3,"D"],','leqalignno',33,48,'begin:"Begin",end:"End",tiny',':["HandleSize",','0],Tiny',53,'1],scriptsize',53,'2],small',53,'3],normalsize',53,'4],large',53,'5],Large',53,'6],LARGE',53,'7],huge',53,'8],Huge',53,'9],dots:["Macro","\\\\ldots"],newcommand',':["Extension","','newcommand"],','newenvironment',73,74,'def',73,74,'color',73,'HTML"],','href',73,'HTML"],"class":["','Extension','","',83,'style',73,83,'cssId',73,83,'unicode',73,83,'bbox',73,'bbox"],require:"Require","char":"Char"},','environments',':{array:"Array",matrix',':["Array",null,null,"','c"],pmatrix',':["Array',31,'bmatrix',106,'","[","]","c"],Bmatrix',106,'","\\\\{","\\\\}","c"],vmatrix',106,'","\\\\vert","\\\\vert","c"],Vmatrix',106,'","\\\\Vert","\\\\Vert","c"],cases',106,'","\\\\{",".","ll",null,2],eqnarray',104,'rcl",[5/18,',35,'align',73,'AMSmath"],"',122,'*":["Extension","AMSmath','"],','multline',73,124,128,126,'"],split',73,'AMSmath"],','gather',73,124,136,126,'"]},AddSpecial',':function(','A){for(var B in A){','jsMath.Parser.prototype','.special[',144,'[B]]=A[B]}},Error',142,'A){this.i=','this.string.length',';if(A','.error){','this.error','=A.error}else{if(!this',152,153,'=A}}},nextIsSpace',':function(){','return ','this.string.charAt(this.i',')==" "},trimSpaces',142,'A){','if(typeof (','A)!="string"){',159,'A}',159,'A.replace(/^\\s+|\\s','+/g,"")},','Process',142,'A){var ','C=','this.mlist.','data;','A','=jsMath.Parse(','A,C.font,C.size,C.style',');if(A',152,'this.Error(','A);','return null','}if(A.mlist.Length()==','0){',184,185,'1','){var B=','A.mlist.','Last();if(','B.atom&&B.type=="ord"&&B.nuc&&!B.sub&&!B.sup&&(B.nuc.type=="text"||B.nuc.type=="TeX")){',159,'B.nuc}}return{type:"mlist",mlist:A.mlist}},GetCommand',':function(){var ','A=/^([a-z]+|.) ?/i;var B=A.exec(','this.string.slice(','this.i));','if(B){this.i+=B[1].','length;',159,'B[1]}this.i++;return" "},GetArgument',142,'B,C){while','(this.nextIsSpace()){this.i','++}','if(this.','i>=',150,'){','if(!C){','this.Error("','Missing',' argument for "+B)}',184,'}if(',160,')==this.close){',212,213,'Extra close brace','")}',184,'}if(',160,')==','this.cmd','){this.i++;',159,'this.cmd+','this.GetCommand','()}if(',160,')!=','this.open){',159,160,'++)}var A=++','this.i;var ','D=1;var E="";','while(this.i<this.string.length){','E=',160,'++);if(','E','==this.cmd){this.i++}else{if(','E==',236,'D++}else{if(E','==this.close){','if(D==0){',213,222,'");',184,'}if(--D==0){',159,198,'A,this.i-1)}}}}}',213,'Missing close brace','");',184,'},','ProcessArg',142,'B){var ','A=','this.GetArgument(','B);','if(this.error){return',' null}','return this.Process(A)},','ProcessScriptArg',142,'C){var A=',270,'C);',272,273,'if(A.charAt(0)==',228,190,'A.substr(1);if(B=="frac"){A+="{"+',270,'B)+"}";',272,273,'A+="{"+',270,'B)+"}";',272,' null}}else{if(B','=="sqrt"){A+="["+','this.GetBrackets(','B)+"]";',272,273,'A+="{"+',270,'B)+"}";',272,294,'.match(this.scriptargs)){A+="{"+',270,'B)+"}";',272,' null}}}}}',274,'GetDelimiter',142,'A){while',206,'++}var B=',160,');',208,'i<',150,229,'if(B==',228,'){B="\\\\"+',232,'(A);',272,' null}}','if(','this.delimiter[','B]!=null){',159,330,'B]}}',213,214,' or unrecognized delimiter for "+A);',184,'},GetDimen',142,'A,D){var ','B;var C=0;if',206,'++}if(',160,')=="{"){B=',270,'A)}else{B=',198,'this.i);C=1}',159,'this.ParseDimen(','B,A,C,D)},ParseDimen',142,'C,B,D,E){var A=C.match(/^\\s*([-+]?(\\.\\d+|\\d+(\\.\\d*)?))(pt|em|ex|mu|px)/);if(!A){',213,214,' dimension or its units for "+B);',184,'}if(D){this.i+=A[0].',201,'if',206,'++}}var F=A[1]-0;if(A[4]=="px"){F/=jsMath.em','}else{if(A[4]=="','pt"){F/=10',365,'ex"){F*=','jsMath.TeX','.x_height',365,'mu"){if(E){F=F/18}else{F=[F,"mu"]}}}}}',159,'F},GetNext',158,'while',206,'++}',159,160,')},GetBrackets',142,173,'D','=this.GetNext();if(','D!="["){return""}var C=++',240,'B=0;',242,'D=',160,245,'D=="{"){B++}else{if(D=="}"){','if(B==0){',213,222,' while looking for',' \']\'");',184,'}B--}else{if(D',247,'D=="]"){',394,159,198,'C,this.i-1)}}}}}}',213,'Couldn\'t find',' closing \']\' for argument to "+',231,'A);',184,'},GetUpto',142,'B,C){while',206,'++}var F=',240,'D=0;',242,'var E=',160,245,'E=="{"){',250,'=="}"){',252,213,222,397,' "+',231,'C);',184,'}D--}else{if(E==',228,'){if(',198,'this.i,this.i+','5)=="begin"){D++;this.i+=4}else{if(',198,439,'3)=="end"){if(D>0){D--;this.i+=2}}}',252,'if(',198,439,'C.length)==C){E=',160,'+C.length);if(E.match(/[^a-z]/i)||!C.match(/[a-z]/i)){var A=',198,'F,this.i-1);this.i+=C.',201,159,'A}}}this.i++}}}}',213,408,' "+',231,'C+" for "+B);',184,'},','ProcessUpto',142,'B,C){var ','A=this.GetUpto(B,C);',272,273,274,'GetEnd',142,'C){var A="";var B="";while(B!=C){A+=this.GetUpto("begin{"+C+"}","end");',272,273,'B=','this.GetArgument(this.cmd','+"end");',272,328,159,'A},Space',':function(){},','Prime',142,'C',190,175,192,'B==null||(!B.atom&&B','.type!="box"&&','B','.type!="frac")){','B=','this.mlist.Add(jsMath.mItem.','Atom("ord",{type:null}))}','if(B.sup){',213,'Prime causes double exponent',': use braces to clarify");return',' }var A','="";while(C=="\'"){A+=',228,'+"prime";C',385,'C=="\'"){this.i++}}B','.sup=this.',171,'(A);B.sup.isPrime=1},RaiseLower',142,173,'B','=this.GetDimen(this.cmd+','A,1);',272,' }var C=this.',275,'(',231,'A);',272,' }if(A=="lower"){B=-B}',175,'Add(new jsMath.mItem("','raise",{nuc:C,raise:B}))},MoveLeftRight',142,268,'A',512,'B,1);',272,' }var ','C','=this.ProcessArg(this.cmd+','B);',272,' }if(B=="moveleft"){A=-A}',494,'Space(A','));',494,'Atom("ord",C));',494,'Space(-A))},Require',142,173,'B=',476,'+A);',272,' }B=','jsMath.Extension','.URL(B);if(','jsMath.Setup.','loaded[B]){','return }','this.Extension(null,[','B])},',87,142,'A,B){','jsMath.Translate','.restart=1;if(A','!=null){','delete ',144,'[B[1]||"macros"][A]}',551,'.Require(B[0],',561,'.asynchronous',');throw"restart"},Frac',142,268,'A',533,'B);',272,531,'C',533,'B);',272,' }',494,'Fraction("over",A,C))},Sqrt',142,268,'D=',296,231,'B);',272,500,533,'B);',272,' }var C=jsMath.mItem.Atom("','radical",A);','if(D!=""){C.root=this.',171,'(D);',272,' }}',175,'Add(C)},','Root',142,268,'D=this.',463,'(',231,'B,"of");',272,500,533,'B);',272,597,598,'C.root=D;',175,605,'BuildRel',142,173,'B=this.',463,'(',231,'A,"over");',272,531,'D',533,'A);',272,597,'op",D);C.limits=1;C.sup=B;',175,605,'MakeBig',142,341,'C=D[0];var B=D[1]*jsMath.p_height;var E','=this.GetDelimiter(this.cmd+','A);',272,' }',494,'Atom(C,','jsMath.Box.Delimiter(','B,E,"T")))},Char',142,268,'A=',476,'+B);',272,531,'C=',476,'+B);',272,' }if(!',369,'[A]){',369,'[A]=[];',556,'jsMath.Font.URL(A',')])}else{',494,'Typeset(','jsMath.Box.TeX(C-0,A,"T",',175,'data.size',')))}},Matrix',142,'B,H){var E=',175,'data;var A=',476,'+B);',272,531,'G=','new jsMath.','Parser(A+',228,'+"\\\\",null,','E.size,H[5]||"T");G.matrix=B;G.row=[];G.table=[];G.rspacing=[];G.Parse();if(G',152,182,'G);',555,'G.',39,'(',529,'var D','=jsMath.Box.','Layout(E.size,G.table,H[2]||null,H[3]||null,G.rspacing,H[4]||null);if(H[0]&&H[1]){var F=',652,'D.h+D','.d-jsMath.hd/4,this.delimiter[','H[0]],"T");var C=',652,'D.h+D',706,'H[1]],"T");D',702,'SetList([','F,D,C],E.style,E.size)}',494,'Atom((H','[0]?"inner":"ord"),','D))},HandleEntry',142,'B){','if(!this.','matrix){',182,'B','+" can only appear in a matrix or array");return }if(',175,'data.openI',563,'var A=',175,'Get(',175,727,180,'.left){',213,214,' "+this.cmd+"right','")}else{',213,262,'")}}if(',175,'data.overI',563,175,'Over()}var D=',175,176,175,'Atomize(','D.style,D.size);','var C=',175,674,752,'C.entry=D.entry;delete D.entry;if(!C.entry){C.entry={}}this.row[','this.row.length',']=C;this.mlist=',688,'mList(null,null,D.size,D.style)},',39,142,'A,C){var B;',721,'matrix){',182,231,'A',725,'A=="\\\\"){B=',296,231,'A);',272,' }if(B){B=',352,'B,',231,'A,0,1)}}this.HandleEntry(A);if(!C||',758,'>1||this.row[0].format!="null"){this.table[this.table.length]=this.row}if(B){','this.rspacing[this.table.length',']=B}this.row=[]},',45,142,268,'A=',476,'+B);',272,531,'C=A.replace(/^.*(vskip|vspace)([^a-z])/i,"$2");if(C.length==A','.length){',555,'var D=',352,'C,',231,'RegExp.$1,0,1);',272,' }',783,']=(',783,']||0)+D},Array',142,465,'E=C[2];var I=C[3];if(!E){E=',476,'+"begin{"+B+"}");',272,' }}E=E.replace(/[^clr]/g,"");E=E.split("");var G=',175,682,'C[5]||"T";var K=this.GetEnd(B);',272,531,'F=',688,'Parser(K+',228,691,'G.size,A);F.matrix=B;F.row=[];F.table=[];F.rspacing=[];F.Parse();if(F',152,182,'F);',555,'F.',39,'(',529,'var H',702,'Layout(G.size,F.table,E,I,F.rspacing,C[4],C[6],C[7]);if(C[0]&&C[1]){var D=',652,'H.h+H',706,'C[0]],"T");var J=',652,'H.h+H',706,'C[1]],"T");H',702,713,'D,H,J],G.style,G.size)}',494,'Atom((C',717,'H))},Begin',142,173,'B=',476,548,272,' }if(B.match(/[^a-z*]/i)){',213,'Invalid environment name \\""+B+"\\"");',555,721,102,'[B]){',213,'Unknown environment \\""+B+"\\"");return',515,102,'[B];',164,'C',')=="string"){','C=[C]}this[C[0]](B,C.slice(1))},End',142,173,'B=',476,548,272,' }',182,231,'A+"{"+B+"} without matching "+',228,'+"begin")},Spacer',142,'B,A){',494,538,'-0))},Hskip',142,268,'A',512,'B);',272,' }',494,538,'))},HBox',142,173,'C=',476,548,272,531,'B',702,'InternalMath(C,',175,677,');',494,674,'B))},Rule',142,'B,E){var A',512,529,272,531,'D',512,529,272,531,'F',512,529,272,' }D+=F;var C;if(D!=0){D=Math.max(1.05/jsMath.em,D)}if(D==0||A==0||E=="blank"){C=','jsMath.HTML.','Blank(A,D)}else{C=',932,'Rule(A,D)}if(F){C="<span style=\\"','vertical-align:"+',932,'Em(-F)+"\\">"+C','+"</span>"}',494,674,688,'Box("html",C,A,D-F,F)))},Strut',196,'A=',175,677,';var B',702,'Text("","normal","T",A).Styled();B.bh=B.bd=0;B.h=0.8;B.d=0.3;B.w=B.Mw=0;',494,674,'B))},Phantom',142,465,'A',533,'B);',272,' }',175,523,'phantom",{phantom:A,v:C[0],h:C[1]}))},Smash',142,465,'A',533,'B);',272,' }',175,523,'smash",{smash:A}))},',0,142,'B,',173,'D',533,'B);',272,597,'accent",D);C.accent=A[0];',175,605,'NamedOp',142,'B,D){var ','A=(B.match(/[^acegm-su-z]/))?1:0;var E=(B.match(/[gjpqy]/))?0.2:0;if(D[1]){B=D[1]}var C=jsMath.mItem.','TextAtom("','op",B,"cmr10",A,E);if(D[0]!=null){C.limits=D[0]}',175,605,'Limits',142,'A,C',190,175,'Last();if(!B||B.type!="op"){',182,231,'A+" is allowed only on operators");',555,'B.limits=C[0]},Macro',142,988,'E=D[0];if(D[1]){var A=[];for(var C=0;C<D[1];C++){A[A.length]=',476,'+B);',272,' }}E=this.','SubstituteArgs','(A,E)}this.string=','this.AddArgs(','E,',198,199,'this.i=0},',1012,142,'B,',173,'E="";var D="";var F;var C=0;while(C<A',794,'F=A.charAt(C++);if(F','==',228,'){E+=F+A.charAt(C++)}else{if(F=="#"){',1025,'=="#"){E+=F}else{if(!F.match(/[1-9]/)||F>B',794,213,'Illegal ','macro parameter ','reference");',184,'}D=',1014,1014,'D,E),B[F-1]);E=""}}else{E+=F}}}',159,1014,'D,E)},AddArgs',142,'B,A){if(','A.match(/^[a-z]/i)&&B.match(/(^|[^\\\\])(\\\\\\\\)*\\\\[a-z]+$/i)){B+=" "}',159,'B+A},Replace',142,560,494,'TextAtom(','B[0],B[1],B[2','],B[3]))},Hash',142,'A){',213,'You can\'t use \'',1034,'character #\' in math mode")},Tilde',142,'A){',494,990,27,'"))},HandleLap',142,173,627,266,'();',272,550,175,523,'lap",{nuc:B,lap:A}))},HandleAtom',142,465,'A',533,'B);',272,' }',494,'Atom(C[0],A))},HandleMathCode',142,'A,B','){this.HandleTeXchar(',1053,'])},HandleTeXchar',142,'B,A,C){if(B==7&&',175,'data.font',563,'A=',175,1094,'}A=',369,'.fam[A];if(!',369,'[A]){',369,'[A]=[];',556,671,')])}else{',494,'TeXAtom(',369,'.atom[B],C,A))}},','HandleVariable',142,'A',1088,'7,1,','A.charCodeAt(0))},','HandleNumber',142,'A',1088,2,1118,'HandleOther',142,'A){',494,990,'ord",A,"normal"))},HandleComment',196,'A;',242,'A=',160,245,'A=="\\r"||A=="\\n"){return }}},HandleStyle',142,560,175,'data.style=B[0];',175,523,'style",{style:B[0]}))},HandleSize',142,560,175,677,'=B[0];',175,523,'size",{size:B[0]}))},HandleFont',142,886,175,1094,'=A[0]},HandleCS',196,'B=',232,'();',272,' }',208,'macros[B]){var A=this','.macros','[B];',164,'A',871,'A=[A]}this[A[0]](B,A.slice(1));',555,208,'mathchardef','[','B]){this.HandleMathCode(B,this.',1174,'[B]);',555,'if(',330,231,1176,'delimiter[',231,'B].slice(0,3));',555,213,'Unknown control sequence \'"+',231,'B+"\'")},HandleOpen',158,175,'Open()},HandleClose',158,'if(',175,727,'==null){',213,222,'");return',500,'=',175,'Get(',175,727,');if(!A||A.left',1199,175,'Close()}else{',213,222,' or missing',738,1202,' }},HandleLeft',142,173,'B',646,'A);',272,' }',175,'Open(B)},HandleRight',142,268,'C',646,'B);',272,500,'=',175,'Get(',175,727,180,'&&A.left',563,175,'Close(C)}else{',213,'Extra open brace or missing "+',228,'+"left")}},HandleOver',142,560,'if(',175,744,563,213,'Ambiguous use of "+',231,'A);',555,175,744,'=',175,'Length();',175,'data.overF={name:A};if(B.length>0){',175,'data.overF.','left=',330,'B[0]];',175,1268,'right=',330,'B[1]]}else{if(A.match(/withdelims$/)){',175,1268,'left',646,'A);',272,' }',175,1268,'right',646,'A);',272,' }}else{',175,1268,'left=null;',175,1268,1274,'null}}if(A.match(/^above/)){',175,1268,'thickness',512,'A,1);',272,' }}else{',175,1268,'thickness=null}},HandleSuperscript',196,'A=',175,192,175,744,'==',175,'Length()){A=null}if(A==null||(!A.atom&&A',490,'A',492,'A=',494,495,'if(A.sup){if(A.sup.isPrime){A=',494,495,'else{',213,'Double exponent',499,' }}A',506,275,'("superscript");',272,' }},HandleSubscript',196,'A=',175,192,175,744,'==',175,'Length()){A=null}if(A==null||(!A.atom&&A',490,'A',492,'A=',494,495,'if(A.sub){',213,'Double subscripts',499,' }A.sub=this.',275,'("subscript");',272,' }},Parse',196,'B;',242,'B=',160,'++);',208,'mathchar[',1176,'mathchar[B])}else{',208,'special[B]){this[this',145,'B]](B)}else{',208,'letter','.test(B)){this.',1113,'(B)}else{',208,'number',1376,1119,1378,'this.',1125,'(B)}}}}}if(',175,727,563,'var A=',175,'Get(',175,727,180,'.left){',213,214,738,739,213,262,'")}}if(',175,744,563,175,'Over()}},Atomize',196,'A=',175,'init;if(!this',152,175,751,'A.style,A.size)}},Typeset',196,'F=',175,'init;var D=this.typeset=',175,674,'F.style,F.size);',272,'"<','span class=\\"','error\\">"+',153,939,'if(D.format=="null"){return""}D.Styled().Remeasured();var E=0;var C=0;if(D.bh>D.h&&','D.bh>jsMath.h+0.001){','E=1}if(D.bd>D.d&&D.bd>jsMath.d+0.001){E=1}if(D.h>jsMath.h||D.d>jsMath.d){C=1}var B=D.html;if(E){if(','jsMath.Browser.','allowAbsolute){var G=0;if(',1431,'G=jsMath.h-D.bh}if(',1433,'msieTeXfontBaselineBug&&','jsMath.Controls.cookie.','font=="','tex"){G-=jsMath.d}B=',932,'Absolute(B,D.w,jsMath.h,0,G,jsMath.h)}else{if(',1433,'valignBug){','B="<span style=\\"line-height:"+jsMath.HTML.Em(jsMath.d',')+";\\">"+B',939,'else{var A=',932,'Em(Math.max(0,D.bd-jsMath.hd)/3);',1446,')+";"+" position:relative; top:"+A+"; ',936,'A+"\\">"+B+"</span>"}}C=1}if(C){B+=',932,'Blank(0,D.h+0.05,D.d+0.05)}return"<nobr><',1426,'scale\\">"+B+"</span></nobr>"}});',144,'.AddSpecial({cmd:"HandleCS",open:"HandleOpen",close:"HandleClose"});','jsMath.Add(jsMath,{','Macro',142,173,'C=',144,1166,';C[A]=["Macro"];for(var B=1;B<arguments.',201,'B++){C[A][C[A].length]=arguments[B]}}});',551,'={safeRequire:1,Macro',142,'A,',268,'C=',144,1166,';if(B',1199,'B=A}C[A]=["',87,'",B]},LaTeX',142,'B,',173,'C=',144,'.',102,';C[B]=["Extension",','A,"',102,'"]},Font',142,1045,'A',1199,'A=B+"10"}var C=',144,1166,1492,671,')]},MathChar',142,'C,',173,'D=',369,'.famName[C','];if(D',1199,'D=',369,'.fam.',201,369,'.fam[D]=C;',369,1511,']=D}var B=',144,'.',1174,';for(var E in A){B[E]=[A[E][0],D,A[E][1]]}},Require',142,1045,'this.safeRequire&&(B.match(/\\.\\.\\/|[^-a-z0-9.\\/:_+=%~]/i)||(B.match(/:/)&&B.substr(0,jsMath.root.length)!=jsMath.root))){',553,'loaded[B]=1;',555,553,'Script(this.URL(B),A)},URL',142,'A){A=',169,'+$/g,"");if(!A.match(/^([a-z]+:|\\/|fonts|extensions\\/)/i)){A="extensions/"+A}if(!A.match(/\\.js$/)){A+=".js"}',159,'A}};',1462,171,142,'A){',553,'Body();','jsMath.Script.','Push(',561,',"','Asynchronous','",A)},','ProcessBeforeShowing',142,'A){',553,1546,'var B=(',1439,'asynch?"',1551,'":"','Synchronous','");',1547,1548,561,',B,A)}});',561,'={element:[],cancel:0,Parse',142,'D,C,',173,'B=','jsMath.Global.','cache[D];if(!','B[jsMath.em',']){',1577,']={}}var F=',1577,'][C];if(!F||',173,'E',178,'C,null,null,D);E.Atomize();F=E.Typeset();if(!A){',1577,'][C]=F}}',159,'F},TextMode',142,'B,A){this.Parse("','T",B,A)},DisplayMode',142,1592,'D",B,A)},GetElementText',142,173,627,'recursiveElementText','(A);A.alt=B;if(B.search("&")>=0){','B=B.replace(/&','lt;/g,"<");',1602,'gt;/g,">");',1602,'quot;/g,"\\"");',1602,'amp;/g,"&")}',159,'B},',1600,142,'B){if(','B.nodeValue',563,159,1615,'}if(','B.childNodes.length','==0){return" "}var C="";for(var A=0;A<',1620,';A++){C+=this.',1600,'(B.childNodes[A])}',159,'C},ResetHidden',142,'A){A.innerHTML="<',1426,'jsMath_hiddenSpan\\" style=\\"position:absolute\\"></span>"+',1433,'operaHiddenFix;A.className="";','jsMath.hidden','=A.firstChild;if(!jsMath.BBoxFor("x").w){','jsMath.hidden=jsMath.hiddenTop','}jsMath.ReInit()},','ConvertText',142,'B,A){var C=this.GetElementText(B);this.ResetHidden(B);if(C.match(/^\\s*\\\\nocache([^a-zA-Z])/)){A=true;C=C.replace(/\\s*\\\\nocache/,"")}C=this.Parse("','T','",C,A);B.className="typeset";B.innerHTML=C},','ConvertDisplay',142,1640,'D',1642,'ProcessElement',142,'C){this.restart=0;if(!','C.className','.match(/(^| )math( |$)/)){return',500,'=(',1651,'.toLowerCase().match(/(^| )nocache( |$)/)!=null);try','{if(C.tagName.toLowerCase()=="','div"){this.',1643,'(C,A);C.onclick=jsMath.Click.CheckClick;C.ondblclick=jsMath.Click.CheckDblClick','}else',1657,'span"){this.',1638,1660,'}}}catch(D){if(C.alt',190,'C.alt;B=B.replace(/&/g,"&amp',';");B=B.replace','(/</g,"&lt',1669,'(/>/g,"&gt;");C.innerHTML=B;',1651,'="math";if(A){',1651,'+=" nocache"}}',1636,'}},','ProcessElements',142,'B){',1547,'blocking=','1;if(B>=','this.element.length','||this.cancel){this.','ProcessComplete','();',208,'cancel){','jsMath.Message.','Set("',171,' Math: Canceled");',1691,'Clear()}',1547,1683,'0;',1547,171,'()}else{var A=',1547,'SaveQueue();','this.ProcessElement(this.element[','B]);',1547,'RestoreQueue(A);',208,'restart){',1547,1548,'this,"',1679,'",B);',1547,1683,'0;setTimeout("',1547,171,'()",',1433,'delay)}else{B++;var C=Math.floor(100*B/',1685,');','jsMath.Message.Set("Processing Math',': "+C+"%");setTimeout("',561,'.',1679,'("+B+")",',1433,'delay)}}},',1551,142,'A','){if(!jsMath.initialized){jsMath.Init()}this.element=this.GetMathElements(','A);',1547,1683,'1;this.cancel=0;this',570,'=1;',1726,': 0%",1);setTimeout("',561,'.',1679,'(0)",',1433,'delay)},',1563,142,1045,'A==null',1737,'B);A=0}this',570,'=0;while(A<',1685,'){',1705,'A]);',208,'restart){','jsMath.Synchronize','("',561,'.',1563,'(null,"+A+")");',1547,171,'();',555,'A++}this.',1687,'(1)},GetMathElements',142,'D){var B=[];var A;if(!D){D=','jsMath.document','}',164,'D',871,'D=',1781,'.getElementById(D)}if(!','D.getElementsByTagName','){',184,'}var C=',1789,'("div','");for(A=0;A<C.length;A++){if(C[A].className&&C[A].className.match(/(^| )math( |$)/)){if(jsMath.Browser.renameOK&&D.getElementsByName){C[A].setAttribute("name","_jsMath_")}else{B[B.length]=C[A]}}}','C=',1789,'("span',1795,'if(',1433,'renameOK','&&D','.getElementsByName','){B=D',1804,'("_jsMath_',739,'if(',1634,'.sourceIndex','){B.sort(function(F,E){',159,'F',1811,'-E',1811,'})}}',159,'B},',1687,142,'C){if(',1433,1802,190,1781,1804,1807,'");for(var A=B.length-1;A>=0;A--){B[A].removeAttribute("name")}}',1636,';this.element=[];this.restart=null;',212,1726,': Done");',1691,'Clear()}',1691,'UnBlank();if(',1433,'safariImgBug&&(',1439,1440,'symbol"||',1439,1440,'image")){',208,'timeout){clearTimeout(this.timeout)}this.timeout=setTimeout("','jsMath.window.resizeBy','(-1,0); "+"',1850,'(1,0); "+"',561,'.timeout = null",2000)}},Cancel',158,561,'.cancel=1;if(',1547,'cancelTimer){',1547,'cancelLoad()}}};',1462,'ConvertTeX',142,'A){',1547,'Push(jsMath.tex2math,"',1864,1552,'ConvertTeX2',142,'A){',1547,1868,1871,1552,'ConvertLaTeX',142,'A){',1547,1868,1878,1552,'ConvertCustom',142,'A){',1547,1868,1885,1552,'CustomSearch',142,'C,B,A,D){',1547,1548,'null,function(){jsMath.tex2math.',1892,'(C,B,A,D)})},tex2math:{',1864,482,1871,482,1878,482,1885,482,1892,':function(){}}});',1766,'=',1547,'Synchronize;try{if(','window.parent','!=window&&window.jsMathAutoload){',1914,'.jsMath=jsMath;',1781,'=',1914,'.document;jsMath.window=',1914,'}}catch(err){}',1575,'Register();jsMath.Loaded();jsMath.Controls.GetCookie();',553,'Source();',1575,'Init();',1547,'Init();',553,'Fonts();if(',1781,'.body){',553,'Body()}',553,'User("onload")}}']

]);
//end = new Date().getTime();
//alert(end-start);
