# The LearningOnline Network with CAPA
# <script> definiton
#
# $Id: scripttag.pm,v 1.148 2008/09/10 19:45:23 droeschl Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::scripttag;

use strict;
use Apache::lonnet;
use Apache::lonlocal;
use Apache::style();

#Globals
# this used to pass around the standard callsub arguments to a tag func
# so xmlparse can reenter the inner_xmlparse loop.

@Apache::scripttag::parser_env = ();
BEGIN {
  &Apache::lonxml::register('Apache::scripttag',
			    ('script','scriptlib','parserlib','import',
			     'window','display','storetc','physnet',
			     'standalone','comment','num','parse','algebra',
			     'LONCAPA_INTERNAL_TURN_STYLE_ON',
			     'LONCAPA_INTERNAL_TURN_STYLE_OFF',
			     'LONCAPA_INTERNAL_LONHTTPD_PORT'));
}

sub start_LONCAPA_INTERNAL_TURN_STYLE_ON {
    $Apache::lonxml::usestyle=1;
    $Apache::lonxml::style_values='';
    return ('','no');
}

sub end_LONCAPA_INTERNAL_TURN_STYLE_ON {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval)=@_;
    my $end=&Apache::lonxml::get_param('end',$parstack,$safeeval);
    if (defined($end)) {
	&Apache::lonxml::end_tag($tagstack,$parstack,$token);
    }
    return ('','no');
}

sub start_LONCAPA_INTERNAL_TURN_STYLE_OFF {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval)=@_;
    $Apache::lonxml::usestyle=0;
    my $end=&Apache::lonxml::get_param('end',$parstack,$safeeval);
    if (!$end) {
	$Apache::lonxml::style_values=$$parstack[-1];
	$Apache::lonxml::style_end_values=$$parstack[-1];
    } else {
	$Apache::lonxml::style_values=$Apache::lonxml::style_end_values;
	$Apache::lonxml::style_end_values='';
    }
    return ('','no');
}

sub end_LONCAPA_INTERNAL_TURN_STYLE_OFF {
    return ('','no');
}

=pod 

=item start_LONCAPA_INTERNAL_LONHTTPD_PORT

emits a pice of javascript that says a global js variable to the
current lonhttp port, currently used by the remote control to find out
where to load images from

=cut

sub start_LONCAPA_INTERNAL_LONHTTPD_PORT {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval)=@_;
    if ($target eq 'web' || $target eq 'webgrade') {
	return '<script type="text/javascript">var lonhttpdport=\''.
	    &Apache::loncommon::lonhttpd_port().'\';</script>';
    }
    return ('','no');
}

sub end_LONCAPA_INTERNAL_LONHTTPD_PORT {
    return ('','no');
}

sub start_script {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval)=@_;
  @Apache::scripttag::parser_env = @_;
  my $result='';
  my $type= &Apache::lonxml::get_param('type',$parstack,$safeeval);
  &Apache::lonxml::debug("found type of $type");
  if ($type eq "loncapa/perl") {
    if ( $target eq "modified" ) {
	$result=$token->[4].&Apache::edit::modifiedfield('/script',$parser);
    } elsif ( $target eq 'web' || $target eq 'tex' ||
	      $target eq 'grade' || $target eq 'webgrade' ||
	      $target eq 'answer' || $target eq 'analyze' ) {
	my $bodytext=&Apache::lonxml::get_all_text_unbalanced("/script",$parser);
	if (!$Apache::lonxml::default_homework_loaded) {
	    &Apache::lonxml::default_homework_load($safeeval);
	}
	&Apache::run::run($bodytext,$safeeval);
	if (($target eq 'answer') &&
	    ($env{'form.answer_output_mode'} ne 'tex') &&
	    ($Apache::lonhomework::viewgrades == 'F')) {
	    $Apache::lonxml::evaluate--;
	    my (undef,undef,$udom,$uname)=&Apache::lonnet::whichuser();
	    my $windowopen=&Apache::lonhtmlcommon::javascript_docopen();
	    my $start_page =
		&Apache::loncommon::start_page('Script Vars', undef,
					       {'only_body' => 1,
						'bgcolor'   => '#FFFFFF',
						'js_ready'  => 1,});
	    my $end_page =
		&Apache::loncommon::end_page({'js_ready' => 1,});

	    $uname =~s/\W//g;
	    $udom  =~s/\W//g;
	    my $function_name = 
		join('_','LONCAPA_scriptvars',$uname,$udom,
		     $env{'form.counter'},$Apache::lonxml::curdepth);
	    my $script_var ="<script type=\"text/javascript\">
// <![CDATA[
    function $function_name() {newWindow=open('','new_W','width=500,height=500,scrollbars=1,resizable=yes');newWindow.$windowopen;newWindow.document.writeln('$start_page<pre>";
	    my $listing=&Apache::run::dump($target,$safeeval);
	    $listing=~s/\\/\\\\/g;
	    $listing=~s/\'/\\\'/g;
	    $script_var.=$listing;
	    $script_var.= "<\\/pre>$end_page');newWindow.document.close();newWindow.focus()}
// ]]>
</script><a href=\"javascript:$function_name();void(0);\">".&mt('Script Vars')."</a><br />";
	    &Apache::lonxml::add_script_result($script_var);
	}
    } elsif ($target eq "edit" ) {
      #&Apache::run::run($bodytext,$safeeval);
      #$result="<br /> &lt;$token->[1]&gt; output: <br />$bodytext<br />Source:<br />";
	my $bodytext=&Apache::lonxml::get_all_text_unbalanced("/script",$parser);
	$result=&Apache::edit::tag_start($target,$token,'Script');
	$result.=&Apache::edit::editfield($token->[1],$bodytext,'',80,4);
    } elsif ($target eq 'meta') {
	my $bodytext=&Apache::lonxml::get_all_text_unbalanced("/script",$parser);
    }
  } else {
      my $bodytext=&Apache::lonxml::get_all_text_unbalanced("/script",$parser);
      if ($target ne "meta" && $target ne 'tex' && $target ne 'answer') {
	  $result = $token->[4];
	  $result.=$bodytext;
      }
  }
  return $result;
}

sub end_script {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval)=@_;
  if ( $target eq "meta" ) { return ''; } 
  my $type = &Apache::lonxml::get_param('type',$parstack,$safeeval);
  my $result='';
  #other script blocks need to survive
  if ($type ne "loncapa/perl" && $target ne 'tex') {
    return $token->[2];
  } elsif ($target eq 'edit' ) {
    return &Apache::edit::end_table();
  } elsif ($target eq 'answer') {
    $Apache::lonxml::evaluate++;
  }
  return '';
}

sub start_display {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval)=@_;
  @Apache::scripttag::parser_env = @_;
  my $result;

  if ( $target eq "modified" ) {
      $result=$token->[4].&Apache::edit::modifiedfield("/display",$parser);
  } elsif ( $target eq 'web' || $target eq 'tex' ||
	    $target eq 'grade' || $target eq 'webgrade' ||
	    $target eq 'answer' || $target eq 'analyze') {
      my $bodytext=&Apache::lonxml::get_all_text_unbalanced("/display",$parser);
      if (!$Apache::lonxml::default_homework_loaded) {
	  &Apache::lonxml::default_homework_load($safeeval);
      }
      $result=&Apache::run::run($bodytext,$safeeval);
      if ($target eq 'grade' || $target eq 'answer' ||
	  $target eq 'analyze') {
	  # grade/answer/analyxe should produce no output but if we
	  # are redirecting, the redirecter should know what to do
	  # with the output
	  if (!$Apache::lonxml::redirection) { $result=''; }
      }
      $Apache::lonxml::post_evaluate=0;
  } elsif ($target eq "edit" ) {
    my $bodytext=&Apache::lonxml::get_all_text_unbalanced("/display",$parser);
    #$result = 
    #  "<br /> &lt;$token->[1]&gt; output: <br />$bodytext<br />Source:<br />";
    #$result.=&Apache::edit::editfield($token->[1],$bodytext,'',40,1);
    $result=&Apache::edit::tag_start($target,$token,'Script With Display');
    $result.=&Apache::edit::editfield($token->[1],$bodytext,'',80,1)
  } elsif ($target eq 'meta') {
      my $bodytext=&Apache::lonxml::get_all_text_unbalanced("/display",$parser);
  }
  return $result;
}

sub end_display {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval)=@_;
  if ($target eq 'edit' ) { return &Apache::edit::end_table(); }
  return '';
}

sub start_scriptlib {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my $bodytext;
  my $result ='';
  my $error='';

  if ($target eq 'web' || $target eq 'tex' || $target eq 'grade' ||
      $target eq 'meta' || $target eq 'edit' || $target eq 'answer' ||
      $target eq 'analyze' || $target eq 'webgrade') {
    $bodytext=$$parser[$#$parser]->get_text("/scriptlib");
    $bodytext=&Apache::run::evaluate($bodytext,$safeeval,
				     $$parstack[$#$parstack]);
    my $location=&Apache::lonnet::filelocation($Apache::lonxml::pwd['-1'],
					       $bodytext);
    my $script=&Apache::lonnet::getfile($location);
    if ($script == -1) {
      if ($target eq 'edit') {
        $error='</tr><tr><td>'.&mt('Errors').'</td><td colspan="2"><b>'.&mt(' Unable to find [_1]','<span class="LC_filename">'.$location.'</span>').'</b></td>'."\n";
      } else {
	&Apache::lonxml::error("<b> Unable to find <i>$location</i> for scriptlib</b>");
	return "";
      }
    }
    &Apache::run::run($script,$safeeval);
    #&Apache::lonxml::debug("ran $bodytext:<br />".&Apache::lonnet::getfile($bodytext)."<br />");
  }
  if ($target eq "edit" ) {
    $result=
      &Apache::edit::tag_start($target,$token,'New Script Functions').
	&Apache::edit::editline($token->[1],$bodytext,'scriptlib',40).
            &Apache::edit::browse(undef,'textnode').
	  $error.'</td></tr>'.
	    &Apache::edit::end_table();
  }
  if ($target eq "modified" ) {
      $result=$token->[4].&Apache::edit::modifiedfield("/scriptlib",$parser);
  }
  return $result;
}

sub end_scriptlib {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my @result;
  if ($target eq "edit" ) { $result[1]='no'; }
  return @result;
}

sub start_parserlib {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my $bodytext;
  my $result ="";
  my $error='';
  if ($target eq 'web' || $target eq 'tex' || $target eq 'grade' ||
      $target eq 'meta' || $target eq 'edit' || $target eq 'answer' ||
      $target eq 'analyze' || $target eq 'webgrade') {
    $bodytext=$$parser[$#$parser]->get_text("/parserlib");
    $bodytext=&Apache::run::evaluate($bodytext,$safeeval,
				     $$parstack[$#$parstack]);
    my $location=&Apache::lonnet::filelocation($Apache::lonxml::pwd['-1'],
					       $bodytext);
    my $styletext=&Apache::lonnet::getfile($location);
    #&Apache::lonxml::debug("found :$bodytext: in :$location: with :$styletext:");
    if ($styletext == -1) {
      if ($target eq 'edit') {
	$error='</tr><tr><td>Errors</td><td colspan="2"><b> Unable to find <i>'.$location.'</i></b></td>'."\n";
      } else {
	&Apache::lonxml::error("<b> Unable to find <i>$location</i> for parserlib</b>");
	return "";
      }
    }
    %$style = ( %$style , &Apache::style::styleparser($target,$styletext));
  }
  if ($target eq "edit" ) {
    $result=
      &Apache::edit::tag_start($target,$token,'New Tag Definitions').
	&Apache::edit::editline($token->[1],$bodytext,'',40).
	  $error.'</td></tr>'.
	    &Apache::edit::end_table();
  }
  if ($target eq "modified" ) {
      $result=$token->[4].&Apache::edit::modifiedfield("/parserlib",$parser);
  }
  return $result;
}

sub end_parserlib {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my @result;
  if ($target eq "edit" ) { $result[1]='no'; }
  return @result;
}

sub start_window {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result = '';
    if ($target eq 'web' || $target eq 'webgrade') {
	&Apache::lonxml::startredirection;
    } elsif ($target eq 'tex') {
	$result = '\unskip\footnote{';
    } elsif ($target eq 'edit') {
	$result.=&Apache::edit::tag_start($target,$token);
	$result.=&Apache::edit::text_arg('Text of Link:','linktext',$token,70);
	$result.=&Apache::edit::text_arg('Height:','height',$token,5);
	$result.=&Apache::edit::text_arg('Width:','width',$token,5);
	$result.=&Apache::edit::text_arg('Mime Type:','mimetype',$token,5);
	$result .=&Apache::edit::end_row().&Apache::edit::start_spanning_row();
    } elsif ($target eq 'modified') {
	my $constructtag=&Apache::edit::get_new_args($token,$parstack,
						     $safeeval,'linktext',
						     'width','height',
						     'mimetype');
	if ($constructtag) { $result=&Apache::edit::rebuild_tag($token); }
    }
    return $result;  
}

sub end_window {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my $result;
  if ($target eq 'web' || $target eq 'webgrade') {
    my $output=&Apache::lonxml::endredirection;
    $output =~ s/[\n\r]/ /g;
#    $output = &HTML::Entities::encode($output,'<>&"\'');
    $output =~ s/\'/\\\'/g;
    my $linktext= &Apache::lonxml::get_param('linktext',$parstack,$safeeval);
    if (!$linktext) { $linktext='<sup>*</sup>'; }
    my $width= &Apache::lonxml::get_param('width',$parstack,$safeeval);
    if (!$width) { $width='500'; }
    my $height= &Apache::lonxml::get_param('height',$parstack,$safeeval);
    if (!$height) { $height='200'; }
    my $mimetype= &Apache::lonxml::get_param('mimetype',$parstack,$safeeval)
	          || 'text/html';

    my ($start_page,$end_page);
    if ($mimetype eq 'text/html') {
	$start_page =
	    &Apache::loncommon::start_page($linktext, undef,
					   {'only_body' => 1,
					    'bgcolor'   => '#FFFFFF',
					    'js_ready'  => 1,});
	$end_page =
	    &Apache::loncommon::end_page({'js_ready' => 1,});
    }
    $result = "<script type=\"text/javascript\">
//<!--
 function LONCAPA_newwindow_$Apache::lonxml::curdepth() {
newWindow=open(".&Apache::lonhtmlcommon::javascript_nothing().",'new_W');
newWindow.close();
newWindow=open(".&Apache::lonhtmlcommon::javascript_nothing().",'new_W','width=$width,height=$height,scrollbars=1');
newWindow.".&Apache::lonhtmlcommon::javascript_docopen($mimetype).";
newWindow.document.writeln('$start_page $output $end_page');
newWindow.document.close();}
//-->
</script><a href=\"javascript:LONCAPA_newwindow_$Apache::lonxml::curdepth();void(0);\">$linktext</a>";
  } elsif ($target eq 'tex') {
      $result = '}';
  } else {
      $result = '';
  }
  return $result; 
}

sub start_import {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my $bodytext=$$parser[$#$parser]->get_text("/import");
  my $result ="";

  $bodytext=Apache::run::evaluate($bodytext,$safeeval,$$parstack[$#$parstack]);

  if ($target eq 'web' ||  $target eq 'webgrade' || $target eq 'grade' 
      || $target eq 'answer' || $target eq 'tex' || $target eq 'analyze' ) {
    # FIXME this probably needs to be smart about construction vs.
    # non construction space.
    my $location=&Apache::lonnet::filelocation($Apache::lonxml::pwd['-1'],$bodytext);
    my $file=&Apache::lonnet::getfile($location);
    if ($file == -1) {
      &Apache::lonxml::error("<b> Unable to find <i>$bodytext as $location</i> for import</b>");
      return "";
    }

    my $dir=$location;
    $dir=~s:/[^/]*$::;
    #  &Apache::lonxml::debug("directory $dir $location file $file \n<b>END</b>\n");
    my $id= &Apache::lonxml::get_id($parstack,$safeeval);
    if (!$id) { $id=$Apache::lonxml::curdepth; }
    push(@Apache::inputtags::import,$id);
    push(@Apache::inputtags::importlist,$id);

    &Apache::lonxml::newparser($parser,\$file,$dir);

  } elsif ($target eq "edit" ) {
    $result.=&Apache::edit::tag_start($target,$token);
    $result.=&Apache::edit::editline($token->[1],$bodytext,'',40);
    $result.=&Apache::edit::browse(undef,'textnode');
    #FIXME this need to convert $bodytext to be a contruction space reference
    #my $location=&Apache::lonnet::filelocation($Apache::lonxml::pwd['-1'],$bodytext);
    #$result.="Click<a href=\"$location\">here</a> to edit<br />"
  } elsif ($target eq 'modified') {
      $result=$token->[4].&Apache::edit::modifiedfield("/import",$parser);
  } elsif ($target eq 'meta') {
    my $id= &Apache::lonxml::get_id($parstack,$safeeval);
    $result.='<import part="'.$Apache::inputtags::part;
    if ($id) {
      $result.='" id="'.$id;
    }
    $result.='">';
    $result.=$bodytext;
    $result.='</import>';
  }
  return $result;
}

sub end_import {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  pop(@Apache::inputtags::import);
  my $result;
  if ($target eq 'edit' ) { $result=&Apache::edit::end_row.
				&Apache::edit::end_table(); }
  return $result;
}

sub start_storetc {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my $result = '';
  &Apache::lonxml::startredirection;
  return $result; 
}

sub end_storetc {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    my $output=&Apache::lonxml::endredirection;
    $output =~ s/\"/\&quot\;/g;
    $result = '{\bf '.$output.'.}}\write\tcfile{\protect\tcpc{ '.$output.'.}{\the\value{relpage}}}';
    return $result;
}


sub start_physnet {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $bodytext = '/adm/includes/physnet.sty';
    my $location=&Apache::lonnet::filelocation($Apache::lonxml::pwd['-1'],$bodytext);
    my $cbistyletext=&Apache::lonnet::getfile($location);

    %$style = (%$style,&Apache::style::styleparser($target,$cbistyletext));
    $$parser['-1']->unget_token($token);
#    if ( defined($$style{'physnet'}) ) {
#        &Apache::lonxml::newparser($parser,\$$style{'physnet'});
#    }
    return "";
}

sub end_physnet {
  return '';
}

sub start_standalone {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my $result='';
  if ($target eq 'web' || $target eq 'webgrade') {
    if ( $env{'request.course.id'} ) {
      my $inside = &Apache::lonxml::get_all_text("/standalone",$parser,$style);
    } else {
      $result='<table bgcolor="#E1E1E1" border="2"><tr><td>';
    }
  }
  return $result;
}

sub end_standalone {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my $result='';
  if ($target eq 'web' || $target eq 'webgrade' ) {
    if ( $env{'request.course.id'} ) {
    } else {
      $result='</td></tr></table>';
    }
  }
  return $result;
}

sub start_comment {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
  my $result='';
  if ($target eq 'edit') {
    $result=&Apache::edit::tag_start($target,$token);
    my $bodytext=&Apache::lonxml::get_all_text("/comment",$parser,$style);
    $result.=&Apache::edit::editfield($token->[1],$bodytext,'',80,4)
  } elsif ( $target eq 'modified') {
    $result=$token->[4].&Apache::edit::modifiedfield("/comment",$parser);
  } elsif ( $target eq 'web'    || $target eq 'tex'  || $target eq 'grade'   ||
	    $target eq 'answer' || $target eq 'meta' || $target eq 'analyze' ||
	    $target eq 'webgrade') {
    #normally throw away comments
    my $bodytext=&Apache::lonxml::get_all_text("/comment",$parser,$style);
  }
  return $result;
}

sub end_comment {
  my ($target,$token,$tagstack,$parstack,$parser,$safeeval)=@_;
  if ($target eq 'edit' ) { return &Apache::edit::end_table(); }
  return '';
}


sub xmlparse {
  my ($string) = @_;
  &Apache::lonxml::debug("xmlparse recursion starting with $string");
  # Apache::run::evaluate does an 'eval' on the name of the subroutine
  # if it detects something that looks like a subroutine, this ends up calling
  # things without any arguments and since perl is nice enough to pass
  # along the default arguments when you don't explicitly say no arguments
  # if you call &xmlparse, it gets &xmlparse passed as it argument.
  # Same thing soccurs with &chemparse.
  if ($string eq '&xmlparse') { return '&xmlparse'; }
  if ($string eq '&chemparse') { return '&chemparse'; }
  my ($target,$token,$tagstack,$parstack,$oldparser,$safeeval,$style)=
    @Apache::scripttag::parser_env;
  my @parser;
  &Apache::lonxml::newparser(\@parser,\$string);
  &Apache::lonxml::startredirection();
  my $result=&Apache::lonxml::inner_xmlparse($target,$tagstack,
					     $parstack,\@parser,
					     $safeeval,$style);
  $result.=&Apache::lonxml::endredirection();
  &Apache::lonxml::debug("target is $target xmlparse recursion ending with $result");
  return $result;
}

sub start_num {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style) = @_;
    my $result = '';
    my $inside = &Apache::lonxml::get_all_text_unbalanced("/num",$parser);
    if ($target eq 'tex' || $target eq 'web' || $target eq 'webgrade') {
	$inside=&Apache::run::evaluate($inside,$safeeval,$$parstack[-1]);
	if (!$Apache::lonxml::default_homework_loaded) {
	    &Apache::lonxml::default_homework_load($safeeval);
	}
	@Apache::scripttag::parser_env = @_;
	my $format=&Apache::lonxml::get_param('format',$parstack,$safeeval);
	$result=&Apache::run::run("return &prettyprint(q\0$inside\0,q\0$format\0);",$safeeval);
    }    
    return $result;
}

sub end_num {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style) = @_;
    my $result = '';
    return $result;
}

sub start_parse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style) = @_;
    my $result = '';
    if ( $target eq 'web'    || $target eq 'tex'    ||
	 $target eq 'grade'  || $target eq 'answer' ||
	 $target eq 'analyze'|| $target eq 'webgrade') {
	my $inside = &Apache::lonxml::get_all_text_unbalanced("/parse",$parser);
	$inside=&Apache::run::evaluate($inside,$safeeval,$$parstack[-1]);
	if (!$Apache::lonxml::default_homework_loaded) {
	    &Apache::lonxml::default_homework_load($safeeval);
	}
	@Apache::scripttag::parser_env = @_;
	$result=&Apache::run::run("return &xmlparse(q\0$inside\0);",$safeeval);
	if ($target eq 'grade' || $target eq 'answer' ||
	    $target eq 'analyze') {
	    # grade/answer/analyxe should produce no output but if we
	    # are redirecting, the redirecter should know what to do
	    # with the output
	    if (!$Apache::lonxml::redirection) { $result=''; }
	}
    }
    return $result;
}

sub end_parse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style) = @_;
    my $result = '';
    return $result;
}

sub start_algebra {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style) = @_;
    my $result = '';
    if ( $target eq 'web'     || $target eq 'tex'    ||
	 $target eq 'grade'   || $target eq 'answer' ||
	 $target eq 'analyze' || $target eq 'webgrade') {
	my $inside = &Apache::lonxml::get_all_text_unbalanced("/algebra",$parser);
	$inside = &Apache::run::evaluate($inside,$safeeval,$$parstack[-1]);
	if ($target eq 'web' || $target eq 'tex' || $target eq 'analyze') {
	    my $style=&Apache::lonxml::get_param('style',$parstack,$safeeval);
	    $result=&Apache::lontexconvert::algebra($inside,$target,$style,$parstack,$safeeval);
	}
	$Apache::lonxml::post_evaluate=0;
    }
    return $result;
}

sub end_algebra {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style) = @_;
    my $result = '';
    return $result;
}

1;
__END__
