# The LearningOnline Network with CAPA
# Set parameters inside of the RAT
#
# $Id: lonratparms.pm,v 1.24 2006/04/04 15:32:12 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonratparms;

use strict;
use Apache::Constants qw(:common);
use Apache::lonhtmlcommon();
use Apache::lonlocal;
use Apache::lonnet;

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

# Get query string for limited number of parameters

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['url','parms','resid']);

# ------------------------------------------------------------------- Read file

  my $uri=$env{'form.url'}.'.meta';
  
  my %content;
  my %type;
  my %display;
  my %value;
  
# ---------------------------------------------------------- Current Parameters

  foreach (split(/\,/,&Apache::lonnet::metadata($uri,'keys'))) {
      if ($_=~/^parameter\_/) {
         $content{$_}=&Apache::lonnet::metadata($uri,$_);
         $type{$_}=&Apache::lonnet::metadata($uri,$_.'.type');
         $display{$_}=&Apache::lonnet::metadata($uri,$_.'.display');
      }
  }

  foreach (split(/\:/,$env{'form.parms'})) {
      my ($ptype,$pname,$pvalue)=split(/\_\_\_/,$_);
      unless ($pname) { next; }
      unless ($type{$pname}) { $type{$pname}=$ptype; }
      $value{$pname}=$pvalue;
      $content{$pname}=$pvalue;
      $type{$pname}=$ptype;
      $display{$pname}=&mt('Custom Parameter');
  } 
  
# --------------------------------------------------- Print input screen header
    my $pjump_def = &Apache::lonhtmlcommon::pjump_javascript_definition();

    my %lt=&Apache::lonlocal::texthash('pa' => 'Parameter',
			               'de' => 'Default',
				       'va' => 'Value',
				       'se' => 'Set');
    my $js = (<<ENDHEADER);
<script type="text/javascript">

    function pclose() {
        parmwin=window.open("/adm/rat/empty.html","LONCAPAparms",
                 "height=350,width=350,scrollbars=no,menubar=no");
        parmwin.close();
    }

    $pjump_def

    function stpr() {
        eval("document.parameters."+document.parameters.pres_marker.value+
            ".value=document.parameters.pres_value.value");
        pclose();
    }


function setparms() {
ENDHEADER
    $js .= 'var colon=""; opener.objparms['.$env{'form.resid'}.']="";';
    foreach my $key (keys(%content)) {
	$js .= "\nif (document.parameters.def_".$key.
       '.checked) { opener.objparms['.$env{'form.resid'}.
       ']+=colon+"'.$type{$key}.
       '___'.$key.'___"+document.parameters.'.$key.'.value; colon=":"; }'; 
    }
    $js .= '
    opener.save();
    window.close();
}
</script>
';
    my $start_page =
	&Apache::loncommon::start_page('Set Resource Parameters in Map',$js);

    $r->print(<<ENDDOCUMENT);
$start_page
<form action="javascript:setparms();" method="post" name="parameters">
<input type="hidden" value='' name="pres_value">
<input type="hidden" value='' name="pres_type">
<input type="hidden" value='' name="pres_marker">
<table border=2>
<tr><th>$lt{'pa'}</th><th>$lt{'de'}</th><th>$lt{'va'}</th><th>$lt{'se'}?</th></tr>
ENDDOCUMENT

###    %display=&Apache::lonlocal::texthash(%display);
    my $enter=&mt('Enter');
    foreach my $key (sort(keys(%content))) {
        my $cur=$content{$key};
        # Should if(defined($value{$key})) be if(exists($value{$key})) ?
        if (defined($value{$key})) { $cur=$value{$key}; };
        $r->print(<<"END");
<tr><td><b>$display{$key}</b><br><tt>$key</tt></td>
<td>&nbsp;$content{$key}</td>
<td><input type="text" size="10" name="$key" value="$cur">&nbsp;
<a href='javascript:pjump("$type{$key}","$display{$key}",document.parameters.$key.value,"$key","parameters.pres","stpr");'>$enter</a></td>
<td><input type="checkbox" name="def_$key" 
END
        if ($value{$key}) { $r->print(' checked'); }
        $r->print('></td></tr>');
    }
    $r->print('</table><br />
               <input type="submit" value="'.&mt('Set').'"></form>'.
	      &Apache::loncommon::end_page());
    return OK;
} 

1;
__END__

