/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.shape.FontLineShape;
import org.jmol.symmetry.UnitCell;

public class Axes
extends FontLineShape {
    private static final Point3f[] unitAxisPoints = new Point3f[]{new Point3f(1.0f, 0.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(-1.0f, 0.0f, 0.0f), new Point3f(0.0f, -1.0f, 0.0f), new Point3f(0.0f, 0.0f, -1.0f)};
    final Point3f originPoint = new Point3f();
    final Point3f[] axisPoints = new Point3f[6];
    private static final float MIN_AXIS_LEN = 1.5f;

    public Axes() {
        int n = 6;
        while (--n >= 0) {
            this.axisPoints[n] = new Point3f();
        }
    }

    public void initShape() {
        super.initShape();
        this.myType = "axes";
        this.font3d = this.g3d.getFont3D(14);
        int n = this.viewer.getAxesMode();
        if (n == 2 && this.modelSet.getCellInfos() != null) {
            UnitCell unitCell = this.viewer.getCurrentUnitCell();
            if (unitCell == null) {
                return;
            }
            Point3f[] point3fArray = unitCell.getVertices();
            Point3f point3f = unitCell.getCartesianOffset();
            this.originPoint.set((Tuple3f)point3f);
            this.axisPoints[0].add((Tuple3f)point3f, (Tuple3f)point3fArray[4]);
            this.axisPoints[1].add((Tuple3f)point3f, (Tuple3f)point3fArray[2]);
            this.axisPoints[2].add((Tuple3f)point3f, (Tuple3f)point3fArray[1]);
            return;
        }
        if (n == 1) {
            this.originPoint.set(0.0f, 0.0f, 0.0f);
        } else {
            this.originPoint.set((Tuple3f)this.viewer.getBoundBoxCenter());
        }
        this.setScale(this.viewer.getAxesScale());
    }

    void setScale(float f) {
        Vector3f vector3f = this.viewer.getBoundBoxCornerVector();
        int n = 6;
        while (--n >= 0) {
            Point3f point3f = this.axisPoints[n];
            point3f.set((Tuple3f)unitAxisPoints[n]);
            if (vector3f.x < 1.5f) {
                vector3f.x = 1.5f;
            }
            if (vector3f.y < 1.5f) {
                vector3f.y = 1.5f;
            }
            if (vector3f.z < 1.5f) {
                vector3f.z = 1.5f;
            }
            point3f.x *= vector3f.x * f;
            point3f.y *= vector3f.y * f;
            point3f.z *= vector3f.z * f;
            point3f.add((Tuple3f)this.originPoint);
        }
    }

    public String getShapeState() {
        return super.getShapeState() + "axisScale = " + this.viewer.getAxesScale() + ";\n";
    }
}

