/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.ModelSet;

class BondIteratorSelected
implements BondIterator {
    ModelSet modelSet;
    short bondType;
    int iBond;
    BitSet bsSelected;
    boolean bondSelectionModeOr;
    boolean isBondBitSet;

    BondIteratorSelected(ModelSet modelSet, short s, BitSet bitSet, boolean bl) {
        this.modelSet = modelSet;
        this.bondType = s;
        this.bsSelected = bitSet;
        this.bondSelectionModeOr = bl;
        this.isBondBitSet = false;
        this.iBond = 0;
    }

    BondIteratorSelected(ModelSet modelSet, BitSet bitSet) {
        this.modelSet = modelSet;
        this.bsSelected = bitSet;
        this.isBondBitSet = true;
        this.iBond = 0;
    }

    public boolean hasNext() {
        while (this.iBond < this.modelSet.bondCount) {
            Bond bond = this.modelSet.bonds[this.iBond];
            if (this.isBondBitSet) {
                if (this.bsSelected.get(this.iBond)) {
                    return true;
                }
            } else if (this.bondType == 8191 || (bond.order & this.bondType) != 0) {
                boolean bl = this.bsSelected.get(bond.atom1.atomIndex);
                boolean bl2 = this.bsSelected.get(bond.atom2.atomIndex);
                if (!this.bondSelectionModeOr && bl && bl2 || this.bondSelectionModeOr && (bl || bl2)) {
                    return true;
                }
            }
            ++this.iBond;
        }
        return false;
    }

    public int nextIndex() {
        return this.iBond;
    }

    public Bond next() {
        return this.modelSet.bonds[this.iBond++];
    }
}

