/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;

public class Backbone
extends BioShapeCollection {
    public void initShape() {
        super.initShape();
        this.madOn = 1;
        this.madHelixSheet = (short)1500;
        this.madTurnRandom = (short)500;
        this.madDnaRna = (short)2000;
        this.isActive = true;
    }

    public void setSize(int n, BitSet bitSet) {
        short s = (short)n;
        this.initialize();
        int n2 = this.bioShapes.length;
        while (--n2 >= 0) {
            boolean bl;
            BioShape bioShape = this.bioShapes[n2];
            if (bioShape.monomerCount == 0) continue;
            boolean bl2 = this.viewer.getBondSelectionModeOr();
            int[] nArray = bioShape.bioPolymer.getLeadAtomIndices();
            boolean bl3 = bl = s != 0;
            if (bioShape.bsSizeSet == null) {
                bioShape.bsSizeSet = new BitSet();
            }
            int n3 = bioShape.monomerCount - 1;
            while (--n3 >= 0) {
                boolean bl4;
                int n4 = nArray[n3];
                int n5 = nArray[n3 + 1];
                boolean bl5 = bitSet.get(n4);
                boolean bl6 = bitSet.get(n5);
                if ((!bl5 || !bl6) && (!bl2 || !bl5 && !bl6)) continue;
                bioShape.monomers[n3].setShapeVisibility(this.myVisibilityFlag, bl);
                Atom atom = this.modelSet.getAtomAt(n4);
                Atom atom2 = this.modelSet.getAtomAt(n5);
                boolean bl7 = bl4 = bioShape.mads[n3] != 0;
                if (bl4 != bl) {
                    atom.addDisplayedBackbone(this.myVisibilityFlag, bl);
                    atom2.addDisplayedBackbone(this.myVisibilityFlag, bl);
                }
                bioShape.mads[n3] = s;
                bioShape.bsSizeSet.set(n3, bl);
            }
        }
    }

    public void setModelClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int n = this.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = this.bioShapes[n];
            int[] nArray = bioShape.bioPolymer.getLeadAtomIndices();
            int n2 = bioShape.monomerCount;
            while (--n2 >= 0) {
                Atom atom = this.modelSet.getAtomAt(nArray[n2]);
                if (atom.getNBackbonesDisplayed() <= 0 || this.modelSet.isAtomHidden(n2)) continue;
                atom.setClickable(this.myVisibilityFlag);
            }
        }
    }
}

