/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Draw
extends MeshCollection {
    DrawMesh[] dmeshes = new DrawMesh[4];
    DrawMesh thisMesh;
    static final int MAX_POINTS = 256;
    Point3f[] ptList = new Point3f[256];
    int[] ptIdentifiers = new int[256];
    boolean[] reversePoints = new boolean[256];
    boolean[] useVertices = new boolean[256];
    BitSet[] ptBitSets = new BitSet[256];
    BitSet bsAllAtoms = new BitSet();
    Vector3f offset = new Vector3f();
    int nPoints;
    int nbitsets;
    int ncoord;
    int nidentifiers;
    int diameter;
    Integer rgb;
    float newScale;
    float length;
    boolean isCurve;
    boolean isArrow;
    boolean isCircle;
    boolean isVisible;
    boolean isPerpendicular;
    boolean isVertices;
    boolean isPlane;
    boolean isReversed;
    boolean isRotated45;
    boolean isCrossed;
    boolean isValid;
    int indicatedModelIndex = -1;
    Point3f[][] modelVertices;
    final Vector3f vAB = new Vector3f();
    final Vector3f vAC = new Vector3f();
    static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    DrawMesh pickedMesh = null;
    int pickedModel;
    int pickedVertex;
    final Point3i ptXY = new Point3i();

    public void allocMesh(String string) {
        this.dmeshes = (DrawMesh[])ArrayUtil.ensureLength((Object)this.dmeshes, (int)(this.meshCount + 1));
        this.meshes = this.dmeshes;
        DrawMesh drawMesh = new DrawMesh(string, ((Shape)this).g3d, this.colix);
        this.dmeshes[this.meshCount++] = drawMesh;
        this.thisMesh = drawMesh;
        this.currentMesh = drawMesh;
    }

    void setPropertySuper(String string, Object object, BitSet bitSet) {
        this.currentMesh = this.thisMesh;
        super.setProperty(string, object, bitSet);
        this.thisMesh = (DrawMesh)this.currentMesh;
    }

    public void initShape() {
        super.initShape();
        this.myType = "draw";
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)("draw " + string + " " + object));
        }
        if ("init" == string) {
            this.colix = (short)5;
            this.nPoints = -1;
            this.newScale = 0.0f;
            this.nidentifiers = 0;
            this.nbitsets = 0;
            this.ncoord = 0;
            this.isCrossed = false;
            this.isRotated45 = false;
            this.isReversed = false;
            this.isFixed = false;
            this.isPerpendicular = false;
            this.isVertices = false;
            this.isPlane = false;
            this.isArrow = false;
            this.isCurve = false;
            this.isValid = true;
            this.isVisible = true;
            this.length = Float.MAX_VALUE;
            this.diameter = 0;
            this.modelVertices = null;
            this.bsAllAtoms.clear();
            this.indicatedModelIndex = -1;
            this.rgb = null;
            this.offset = new Vector3f();
            if (this.colix == 0) {
                this.colix = (short)23;
            }
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
        }
        if ("colorRGB" == string) {
            this.rgb = (Integer)object;
            return;
        }
        if ("length" == string) {
            this.length = ((Float)object).floatValue();
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            return;
        }
        if ("modelIndex" == string) {
            this.indicatedModelIndex = (Integer)object;
            if (this.indicatedModelIndex < 0 || this.indicatedModelIndex > this.modelCount) {
                return;
            }
            if (this.ncoord > 0) {
                this.ptList = new Point3f[5];
            } else {
                this.modelVertices = new Point3f[this.modelCount][];
            }
            this.modelVertices[this.indicatedModelIndex] = this.ptList;
            this.ncoord = 0;
            return;
        }
        if ("perp" == string) {
            this.isPerpendicular = true;
            return;
        }
        if ("plane" == string) {
            this.isPlane = true;
            return;
        }
        if ("curve" == string) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == string) {
            this.isArrow = true;
            return;
        }
        if ("vertices" == string) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == string) {
            this.isReversed = true;
            return;
        }
        if ("rotate45" == string) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == string) {
            this.isCrossed = true;
            return;
        }
        if ("points" == string) {
            this.nPoints = 0;
            this.newScale = ((Integer)object).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == string) {
            this.newScale = ((Integer)object).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.thisMesh != null) {
                this.scaleDrawing(this.thisMesh, this.newScale);
                this.thisMesh.initialize(2);
            }
            return;
        }
        if ("diameter" == string) {
            this.diameter = ((Float)object).intValue();
            return;
        }
        if ("identifier" == string) {
            String string2 = (String)object;
            int n = this.getIndexFromName(string2);
            if (n >= 0) {
                this.reversePoints[this.nidentifiers] = this.isReversed;
                this.useVertices[this.nidentifiers] = this.isVertices;
                this.ptIdentifiers[this.nidentifiers] = n;
                ++this.nidentifiers;
                ++this.nPoints;
                this.isVertices = false;
                this.isReversed = false;
            } else {
                Logger.error((String)("draw identifier " + object + " not found"));
                this.isValid = false;
            }
            return;
        }
        if ("coord" == string) {
            if (this.ncoord == 256) {
                return;
            }
            this.ptList[this.ncoord++] = new Point3f((Point3f)object);
            ++this.nPoints;
            return;
        }
        if ("offset" == string) {
            this.offset = new Vector3f((Tuple3f)((Point3f)object));
            if (this.thisMesh != null) {
                this.thisMesh.offset(this.offset);
            }
            return;
        }
        if ("atomSet" == string) {
            if (BitSetUtil.cardinalityOf((BitSet)((BitSet)object)) == 0) {
                return;
            }
            this.ptBitSets[this.nbitsets++] = (BitSet)object;
            this.bsAllAtoms.or((BitSet)object);
            ++this.nPoints;
            return;
        }
        if ("set" == string) {
            if (this.thisMesh == null) {
                this.allocMesh(null);
                this.thisMesh.colix = this.colix;
            }
            boolean bl = this.thisMesh.isValid = this.isValid ? this.setDrawing() : false;
            if (this.thisMesh.isValid) {
                if (this.thisMesh.vertexCount > 2 && this.length != Float.MAX_VALUE && this.newScale == 1.0f) {
                    this.newScale = this.length;
                }
                this.scaleDrawing(this.thisMesh, this.newScale);
                this.thisMesh.initialize(2);
                this.setAxes(this.thisMesh);
                this.thisMesh.title = this.title;
                this.thisMesh.visible = this.isVisible;
            }
            this.nPoints = -1;
            return;
        }
        if ("off" == string) {
            this.isVisible = false;
        }
        this.setPropertySuper(string, object, bitSet);
    }

    public Object getProperty(String string, int n) {
        if (string == "command") {
            return this.getDrawCommand(this.thisMesh);
        }
        if (string == "vertices") {
            return this.getPath(this.thisMesh);
        }
        if (string.indexOf("getSpinCenter:") == 0) {
            return this.getSpinCenter(string.substring(14), n);
        }
        if (string.indexOf("getSpinAxis:") == 0) {
            return this.getSpinAxis(string.substring(12), n);
        }
        return super.getProperty(string, n);
    }

    Point3f getSpinCenter(String string, int n) {
        int n2 = this.getIndexFromName(string);
        return n2 < 0 ? null : this.getSpinCenter(n2, n);
    }

    Vector3f getSpinAxis(String string, int n) {
        int n2 = this.getIndexFromName(string);
        return n2 < 0 ? null : this.getSpinAxis(n2, n);
    }

    Object getPath(Mesh mesh) {
        if (mesh == null) {
            return null;
        }
        return mesh.vertices;
    }

    boolean setDrawing() {
        if (this.thisMesh == null) {
            this.allocMesh(null);
        }
        this.thisMesh.clear("draw");
        if (this.nPoints == 0) {
            return false;
        }
        int n = 0;
        if (this.modelVertices == null && (this.isFixed || this.isArrow || this.isCurve || this.modelCount == 1)) {
            this.thisMesh.isFixed = this.isFixed;
            this.thisMesh.modelIndex = ((Shape)this).viewer.getDisplayModelIndex();
            if (this.thisMesh.modelIndex < 0) {
                this.thisMesh.modelIndex = 0;
            }
            if (this.isFixed && !this.isArrow && !this.isCurve && this.modelCount > 1) {
                this.thisMesh.modelIndex = -1;
            }
            this.thisMesh.setPolygonCount(1);
            this.thisMesh.ptCenters = null;
            this.thisMesh.modelFlags = null;
            this.thisMesh.drawTypes = null;
            this.thisMesh.drawVertexCounts = null;
            this.thisMesh.diameter = this.diameter;
            if (this.rgb != null) {
                super.setProperty("color", (Object)this.rgb, null);
            }
            this.addModelPoints(-1);
            n = this.setPolygons(n);
        } else {
            int n2;
            int n3;
            BitSet bitSet = new BitSet();
            if (this.nbitsets > 0) {
                bitSet = ((Shape)this).viewer.getModelBitSet(this.bsAllAtoms);
            } else if (this.nidentifiers > 0) {
                for (n3 = 0; n3 < this.nidentifiers; ++n3) {
                    n2 = this.dmeshes[this.ptIdentifiers[n3]].polygonCount;
                    while (--n2 >= 0) {
                        bitSet.set(n2);
                    }
                }
            } else {
                bitSet = ((Shape)this).viewer.getVisibleFramesBitSet();
            }
            this.thisMesh.modelIndex = -1;
            this.thisMesh.setPolygonCount(this.modelCount);
            this.thisMesh.ptCenters = new Point3f[this.modelCount];
            this.thisMesh.modelFlags = new int[this.modelCount];
            this.thisMesh.drawTypes = new int[this.modelCount];
            this.thisMesh.drawVertexCounts = new int[this.modelCount];
            this.thisMesh.vertexCount = 0;
            if (this.indicatedModelIndex >= 0) {
                n3 = Math.max(this.ncoord, 3);
                for (n2 = 0; n2 < this.modelCount; ++n2) {
                    int n4;
                    int n5 = this.thisMesh.vertexCount;
                    Point3f[] point3fArray = this.modelVertices[n2];
                    if (point3fArray == null) continue;
                    this.thisMesh.polygonIndexes[n2] = new int[n3];
                    int[] nArray = this.thisMesh.polygonIndexes[n2];
                    for (n4 = 0; n4 < this.ncoord; ++n4) {
                        nArray[n4] = this.thisMesh.addVertexCopy(point3fArray[n4]);
                    }
                    for (n4 = this.ncoord; n4 < 3; ++n4) {
                        nArray[n4] = n5 + this.ncoord - 1;
                    }
                    this.thisMesh.drawTypes[n2] = this.thisMesh.drawVertexCounts[n2] = this.ncoord;
                }
                this.thisMesh.drawType = -1;
                this.thisMesh.drawVertexCount = -1;
                this.modelVertices = null;
            } else {
                for (n3 = 0; n3 < this.modelCount; ++n3) {
                    if (bitSet.get(n3)) {
                        this.addModelPoints(n3);
                        this.setPolygons(n);
                        this.thisMesh.setCenter(n3);
                        this.thisMesh.drawTypes[n3] = this.thisMesh.drawType;
                        this.thisMesh.drawVertexCounts[n3] = this.thisMesh.drawVertexCount;
                        this.thisMesh.drawType = -1;
                        this.thisMesh.drawVertexCount = -1;
                    } else {
                        this.thisMesh.drawTypes[n3] = 0;
                        this.thisMesh.polygonIndexes[n3] = new int[0];
                    }
                    ++n;
                }
            }
        }
        this.thisMesh.setCenter(-1);
        if (this.thisMesh.thisID == null) {
            this.thisMesh.thisID = this.thisMesh.getDrawType() + ++this.nUnnamed;
        }
        return true;
    }

    void addPoint(Point3f point3f) {
        this.ptList[this.nPoints] = new Point3f(point3f);
        if (this.offset != null) {
            this.ptList[this.nPoints].add((Tuple3f)this.offset);
        }
        if (++this.nPoints > 256) {
            this.nPoints = 256;
        }
    }

    private void addModelPoints(int n) {
        this.nPoints = this.ncoord;
        for (int i = 0; i < this.nidentifiers; ++i) {
            DrawMesh drawMesh = this.dmeshes[this.ptIdentifiers[i]];
            if (this.isPlane || this.isPerpendicular || this.useVertices[i]) {
                int n2;
                if (this.reversePoints[i]) {
                    if (n < 0 || n >= drawMesh.polygonCount) {
                        n2 = drawMesh.drawVertexCount;
                        while (--n2 >= 0) {
                            this.addPoint(drawMesh.vertices[n2]);
                        }
                        continue;
                    }
                    n2 = drawMesh.drawVertexCounts[n];
                    while (--n2 >= 0) {
                        this.addPoint(drawMesh.vertices[drawMesh.polygonIndexes[n][n2]]);
                    }
                    continue;
                }
                if (n < 0 || n >= drawMesh.polygonCount) {
                    for (n2 = 0; n2 < drawMesh.drawVertexCount; ++n2) {
                        this.addPoint(drawMesh.vertices[n2]);
                    }
                    continue;
                }
                n2 = drawMesh.drawVertexCounts[n];
                while (--n2 >= 0) {
                    this.addPoint(drawMesh.vertices[drawMesh.polygonIndexes[n][n2]]);
                }
                continue;
            }
            if (n < 0 || drawMesh.ptCenters == null || drawMesh.ptCenters[n] == null) {
                this.addPoint(drawMesh.ptCenter);
                continue;
            }
            this.addPoint(drawMesh.ptCenters[n]);
        }
        if (this.nbitsets == 0) {
            return;
        }
        BitSet bitSet = n < 0 ? null : ((Shape)this).viewer.getModelAtomBitSet(n);
        for (int i = 0; i < this.nbitsets; ++i) {
            BitSet bitSet2 = (BitSet)this.ptBitSets[i].clone();
            if (bitSet != null) {
                bitSet2.and(bitSet);
            }
            if (BitSetUtil.cardinalityOf((BitSet)bitSet2) <= 0) continue;
            this.addPoint(((Shape)this).viewer.getAtomSetCenter(bitSet2));
        }
    }

    private int setPolygons(int n) {
        if (this.nPoints == 4 && this.isCrossed) {
            Point3f point3f = new Point3f(this.ptList[1]);
            this.ptList[1].set((Tuple3f)this.ptList[2]);
            this.ptList[2].set((Tuple3f)point3f);
        }
        return this.setPolygon(this.thisMesh, this.nPoints, n);
    }

    private int setPolygon(DrawMesh drawMesh, int n, int n2) {
        int n3;
        int n4 = 1;
        if ((this.isCurve || this.isArrow || this.isCircle) && n >= 2) {
            int n5 = this.isCurve ? 17 : (n4 = this.isArrow ? 15 : 16);
        }
        if (n4 == 1) {
            float f;
            Point3f point3f;
            Point3f point3f2 = new Point3f();
            Vector3f vector3f = new Vector3f();
            if (n == 3 && this.isPlane && !this.isPerpendicular) {
                point3f = new Point3f(this.ptList[1]);
                point3f.sub((Tuple3f)this.ptList[0]);
                point3f.scale(0.5f);
                this.ptList[3] = new Point3f(this.ptList[2]);
                this.ptList[2].add((Tuple3f)point3f);
                this.ptList[3].sub((Tuple3f)point3f);
                n = 4;
            } else if (n >= 3 && !this.isPlane && this.isPerpendicular) {
                Graphics3D.calcNormalizedNormal((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)this.ptList[2], (Vector3f)vector3f, (Vector3f)this.vAB, (Vector3f)this.vAC);
                point3f2 = new Point3f();
                Graphics3D.calcAveragePointN((Point3f[])this.ptList, (int)n, (Point3f)point3f2);
                f = this.length == Float.MAX_VALUE ? this.ptList[0].distance(point3f2) : this.length;
                vector3f.scale(f);
                this.ptList[0].set((Tuple3f)point3f2);
                this.ptList[1].set((Tuple3f)point3f2);
                this.ptList[1].add((Tuple3f)vector3f);
                n = 2;
            } else if (n == 2 && this.isPerpendicular) {
                Graphics3D.calcAveragePoint((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)point3f2);
                float f2 = f = this.length == Float.MAX_VALUE ? this.ptList[0].distance(point3f2) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    f /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    f *= 1.4142f;
                }
                ((Shape)this).g3d.calcXYNormalToLine(this.ptList[0], this.ptList[1], vector3f);
                vector3f.scale(f);
                if (this.isPlane) {
                    this.ptList[2] = new Point3f(point3f2);
                    this.ptList[2].sub((Tuple3f)vector3f);
                    point3f = new Point3f(point3f2);
                    point3f.add((Tuple3f)vector3f);
                    Graphics3D.calcNormalizedNormal((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)this.ptList[2], (Vector3f)vector3f, (Vector3f)this.vAB, (Vector3f)this.vAC);
                    vector3f.scale(f);
                    this.ptList[3] = new Point3f(point3f2);
                    this.ptList[3].add((Tuple3f)vector3f);
                    this.ptList[1].set((Tuple3f)point3f2);
                    this.ptList[1].sub((Tuple3f)vector3f);
                    this.ptList[0].set((Tuple3f)point3f);
                    if (this.isRotated45) {
                        Graphics3D.calcAveragePoint((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)this.ptList[0]);
                        Graphics3D.calcAveragePoint((Point3f)this.ptList[1], (Point3f)this.ptList[2], (Point3f)this.ptList[1]);
                        Graphics3D.calcAveragePoint((Point3f)this.ptList[2], (Point3f)this.ptList[3], (Point3f)this.ptList[2]);
                        Graphics3D.calcAveragePoint((Point3f)this.ptList[3], (Point3f)point3f, (Point3f)this.ptList[3]);
                    }
                    n = 4;
                } else {
                    this.ptList[0].set((Tuple3f)point3f2);
                    this.ptList[1].set((Tuple3f)point3f2);
                    this.ptList[0].sub((Tuple3f)vector3f);
                    this.ptList[1].add((Tuple3f)vector3f);
                }
            } else if (n == 2 && this.length != Float.MAX_VALUE) {
                Graphics3D.calcAveragePoint((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)point3f2);
                vector3f.set((Tuple3f)this.ptList[1]);
                vector3f.sub((Tuple3f)point3f2);
                vector3f.scale(0.5f / vector3f.length() * this.length);
                this.ptList[0].set((Tuple3f)point3f2);
                this.ptList[1].set((Tuple3f)point3f2);
                this.ptList[0].sub((Tuple3f)vector3f);
                this.ptList[1].add((Tuple3f)vector3f);
            }
            if (n > 4) {
                n = 4;
            }
            switch (n) {
                case 1: {
                    break;
                }
                case 2: {
                    n4 = 2;
                    break;
                }
                default: {
                    n4 = 4;
                }
            }
        }
        drawMesh.drawType = n4;
        drawMesh.drawVertexCount = n;
        if (n == 0) {
            return n2;
        }
        int n6 = drawMesh.vertexCount;
        for (n3 = 0; n3 < n; ++n3) {
            drawMesh.addVertexCopy(this.ptList[n3]);
        }
        n3 = n < 3 ? 3 : n;
        drawMesh.setPolygonCount(n2 + 1);
        drawMesh.polygonIndexes[n2] = new int[n3];
        for (int i = 0; i < n3; ++i) {
            drawMesh.polygonIndexes[n2][i] = n6 + (i < n ? i : n - 1);
        }
        return n2 + 1;
    }

    private void scaleDrawing(DrawMesh drawMesh, float f) {
        if (f == 0.0f || drawMesh.vertexCount == 0 || drawMesh.scale == f) {
            return;
        }
        Vector3f vector3f = new Vector3f();
        float f2 = f / drawMesh.scale;
        drawMesh.scale = f;
        int n = -1;
        int n2 = 0;
        int n3 = drawMesh.polygonCount;
        while (--n3 >= 0) {
            Point3f point3f;
            Point3f point3f2 = point3f = drawMesh.ptCenters == null ? drawMesh.ptCenter : drawMesh.ptCenters[n3];
            if (point3f == null) {
                return;
            }
            n = -1;
            int n4 = drawMesh.polygonIndexes[n3].length;
            while (--n4 >= 0) {
                n2 = drawMesh.polygonIndexes[n3][n4];
                if (n2 == n) continue;
                n = n2;
                vector3f.sub((Tuple3f)drawMesh.vertices[n2], (Tuple3f)point3f);
                vector3f.scale(f2);
                vector3f.add((Tuple3f)point3f);
                drawMesh.vertices[n2].set((Tuple3f)vector3f);
            }
        }
    }

    final Point3f getSpinCenter(int n, int n2) {
        DrawMesh drawMesh = this.dmeshes[n];
        if (drawMesh.vertices == null) {
            return null;
        }
        Point3f point3f = drawMesh.ptCenters == null || n2 < 0 ? drawMesh.ptCenter : drawMesh.ptCenters[n2];
        point3f.add((Tuple3f)this.offset);
        return point3f;
    }

    final Vector3f getSpinAxis(int n, int n2) {
        DrawMesh drawMesh = this.dmeshes[n];
        if (drawMesh.vertices == null) {
            return null;
        }
        return drawMesh.ptCenters == null || n2 < 0 ? drawMesh.axis : drawMesh.axes[n2];
    }

    final void setAxes(DrawMesh drawMesh) {
        drawMesh.axis = new Vector3f(0.0f, 0.0f, 0.0f);
        drawMesh.axes = new Vector3f[drawMesh.polygonCount > 0 ? drawMesh.polygonCount : 1];
        if (drawMesh.vertices == null) {
            return;
        }
        int n = 0;
        int n2 = drawMesh.polygonCount;
        while (--n2 >= 0) {
            int[] nArray = drawMesh.polygonIndexes[n2];
            drawMesh.axes[n2] = new Vector3f();
            if (nArray.length != 0) {
                if (drawMesh.drawVertexCount == 2 || drawMesh.drawVertexCount < 0 && drawMesh.drawVertexCounts[n2] == 2) {
                    drawMesh.axes[n2].sub((Tuple3f)drawMesh.vertices[nArray[0]], (Tuple3f)drawMesh.vertices[nArray[1]]);
                    ++n;
                } else {
                    Graphics3D.calcNormalizedNormal((Point3f)drawMesh.vertices[nArray[0]], (Point3f)drawMesh.vertices[nArray[1]], (Point3f)drawMesh.vertices[nArray[2]], (Vector3f)drawMesh.axes[n2], (Vector3f)drawMesh.vAB, (Vector3f)drawMesh.vAC);
                    ++n;
                }
            }
            drawMesh.axis.add((Tuple3f)drawMesh.axes[n2]);
        }
        if (n == 0) {
            return;
        }
        drawMesh.axis.scale(1.0f / (float)n);
    }

    public void setVisibilityFlags(BitSet bitSet) {
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh drawMesh = this.dmeshes[i];
            int n = drawMesh.visibilityFlags = drawMesh.isValid && drawMesh.visible ? ((Shape)this).myVisibilityFlag : 0;
            if (drawMesh.modelIndex >= 0 && !bitSet.get(drawMesh.modelIndex)) {
                drawMesh.visibilityFlags = 0;
                continue;
            }
            if (drawMesh.modelFlags == null) continue;
            int n2 = this.modelCount;
            while (--n2 >= 0) {
                drawMesh.modelFlags[n2] = bitSet.get(n2) ? 1 : 0;
            }
        }
    }

    public boolean checkObjectClicked(int n, int n2, int n3) {
        if (((Shape)this).viewer.getPickingMode() == 4) {
            return false;
        }
        if (!this.findPickedObject(n, n2, false)) {
            return false;
        }
        if (this.pickedMesh.polygonIndexes[this.pickedModel][0] == this.pickedMesh.polygonIndexes[this.pickedModel][1]) {
            return false;
        }
        if (this.pickedVertex == 0) {
            ((Shape)this).viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], (n3 & 1) != 0);
        } else {
            ((Shape)this).viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], (n3 & 1) != 0);
        }
        return true;
    }

    public boolean checkObjectHovered(int n, int n2) {
        if (!this.findPickedObject(n, n2, false)) {
            return false;
        }
        ((Shape)this).viewer.hoverOn(n, n2, this.pickedMesh.title == null ? this.pickedMesh.thisID : this.pickedMesh.title[0]);
        return true;
    }

    public synchronized boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        if (((Shape)this).viewer.getPickingMode() != 4) {
            return false;
        }
        if (!this.findPickedObject(n, n2, true)) {
            return false;
        }
        boolean bl = false;
        switch (n5 & 0x1F) {
            case 17: {
                bl = true;
            }
            case 24: {
                this.move2D(this.pickedMesh, this.pickedMesh.polygonIndexes[this.pickedModel], this.pickedVertex, n + n3, n2 + n4, bl);
                this.thisMesh = this.pickedMesh;
                break;
            }
            case 25: {
                return false;
            }
        }
        return true;
    }

    void move2D(DrawMesh drawMesh, int[] nArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Vector3f vector3f = new Vector3f();
        point3f2.set((Tuple3f)drawMesh.vertices[nArray[n]]);
        ((Shape)this).viewer.transformPoint(point3f2, point3f);
        point3f.x = n2;
        point3f.y = n3;
        ((Shape)this).viewer.unTransformPoint(point3f, point3f3);
        vector3f.set((Tuple3f)point3f3);
        vector3f.sub((Tuple3f)point3f2);
        int n5 = -1;
        int n6 = n4 = bl ? 0 : n;
        while (n4 < nArray.length) {
            if (bl || n4 == n) {
                int n7 = nArray[n4];
                if (n7 == n5) break;
                drawMesh.vertices[n7].add((Tuple3f)vector3f);
                if (!bl) break;
                n5 = n7;
            }
            ++n4;
        }
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)this.getDrawCommand(drawMesh));
        }
        ((Shape)this).viewer.refresh(0, "draw");
    }

    boolean findPickedObject(int n, int n2, boolean bl) {
        int n3 = 100;
        this.pickedModel = 0;
        this.pickedVertex = 0;
        this.pickedMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n4;
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.visibilityFlags == 0) continue;
            int n5 = n4 = drawMesh.modelFlags == null ? 1 : this.modelCount;
            while (--n5 >= 0) {
                if (drawMesh.modelFlags != null && drawMesh.modelFlags[n5] == 0 || drawMesh.polygonIndexes == null) continue;
                int n6 = drawMesh.polygonIndexes[n5].length;
                while (--n6 >= 0) {
                    Point3f point3f = new Point3f();
                    point3f.set((Tuple3f)drawMesh.vertices[drawMesh.polygonIndexes[n5][n6]]);
                    int n7 = this.coordinateInRange(n, n2, point3f, n3);
                    if (n7 < 0) continue;
                    this.pickedMesh = drawMesh;
                    n3 = n7;
                    this.pickedModel = n5;
                    this.pickedVertex = n6;
                }
            }
        }
        return this.pickedMesh != null;
    }

    int coordinateInRange(int n, int n2, Point3f point3f, int n3) {
        int n4 = n3;
        ((Shape)this).viewer.transformPoint(point3f, this.ptXY);
        n4 = (n - this.ptXY.x) * (n - this.ptXY.x) + (n2 - this.ptXY.y) * (n2 - this.ptXY.y);
        return n4 < n3 ? n4 : -1;
    }

    private String getDrawCommand(DrawMesh drawMesh) {
        if (drawMesh == null) {
            return "no current draw object";
        }
        return this.getDrawCommand(drawMesh, drawMesh.modelIndex);
    }

    private String getDrawCommand(DrawMesh drawMesh, int n) {
        if (drawMesh.drawType == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!drawMesh.isFixed && n >= 0 && this.modelCount > 1) {
            stringBuffer.append("frame ").append(((Shape)this).viewer.getModelNumberDotted(n)).append(";\n");
        }
        stringBuffer.append("draw ").append(drawMesh.thisID);
        if (drawMesh.isFixed) {
            stringBuffer.append(" fixed");
        }
        if (n < 0) {
            n = 0;
        }
        if (drawMesh.diameter > 0) {
            stringBuffer.append(" diameter ").append(drawMesh.diameter);
        }
        int n2 = drawMesh.vertexCount;
        switch (drawMesh.drawTypes == null ? drawMesh.drawType : drawMesh.drawTypes[n]) {
            case 15: {
                stringBuffer.append(" ARROW");
                break;
            }
            case 16: {
                stringBuffer.append(" CIRCLE");
                break;
            }
            case 17: {
                stringBuffer.append(" CURVE");
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        if (drawMesh.modelIndex < 0 && !drawMesh.isFixed) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (drawMesh.polygonIndexes[i] == null) continue;
                stringBuffer.append(" [ " + i);
                stringBuffer.append(this.getVertexList(drawMesh, i, n2));
                stringBuffer.append(" ] ");
            }
        } else {
            stringBuffer.append(this.getVertexList(drawMesh, n, n2));
        }
        if (drawMesh.title != null) {
            stringBuffer.append(" " + Escape.escape((String)drawMesh.title[0]));
        }
        stringBuffer.append(";\n");
        Shape.appendCmd((StringBuffer)stringBuffer, (String)drawMesh.getState("draw"));
        Shape.appendCmd((StringBuffer)stringBuffer, (String)this.getColorCommand("draw", drawMesh.colix));
        return stringBuffer.toString();
    }

    private String getVertexList(Mesh mesh, int n, int n2) {
        String string = "";
        for (int i = 0; i < n2; ++i) {
            Point3f point3f = new Point3f();
            point3f.set((Tuple3f)mesh.vertices[mesh.polygonIndexes[n][i]]);
            string = string + " " + Escape.escape((Tuple3f)point3f);
        }
        return string;
    }

    public Vector getShapeDetail() {
        Vector vector = new Vector();
        if (this.nPoints == 0) {
            return vector;
        }
        for (int i = 0; i < this.meshCount; ++i) {
            int n;
            Vector vector2;
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.vertexCount == 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("fixed", drawMesh.ptCenters == null ? Boolean.TRUE : Boolean.FALSE);
            hashtable.put("ID", drawMesh.thisID == null ? "<noid>" : drawMesh.thisID);
            hashtable.put("drawType", drawMesh.getDrawType());
            if (drawMesh.diameter > 0) {
                hashtable.put("diameter", new Integer(drawMesh.diameter));
            }
            hashtable.put("scale", new Float(drawMesh.scale));
            if (drawMesh.drawType == -1) {
                vector2 = new Vector();
                for (n = 0; n < this.modelCount; ++n) {
                    if (drawMesh.ptCenters[n] == null) continue;
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                    hashtable2.put("modelIndex", new Integer(n));
                    hashtable2.put("command", this.getDrawCommand(drawMesh, n));
                    hashtable2.put("center", drawMesh.ptCenters[n]);
                    int n2 = drawMesh.drawVertexCounts[n];
                    hashtable2.put("vertexCount", new Integer(n2));
                    if (n2 > 1) {
                        hashtable2.put("axis", drawMesh.axes[n]);
                    }
                    Vector<Point3f> vector3 = new Vector<Point3f>();
                    for (int j = 0; j < n2; ++j) {
                        vector3.addElement(drawMesh.vertices[drawMesh.polygonIndexes[n][j]]);
                    }
                    hashtable2.put("vertices", vector3);
                    if (drawMesh.drawTypes[n] == 2) {
                        float f = drawMesh.vertices[drawMesh.polygonIndexes[n][0]].distance(drawMesh.vertices[drawMesh.polygonIndexes[n][1]]);
                        hashtable2.put("length_Ang", new Float(f));
                    }
                    vector2.addElement(hashtable2);
                }
                hashtable.put("models", vector2);
            } else {
                hashtable.put("command", this.getDrawCommand(drawMesh));
                hashtable.put("center", drawMesh.ptCenter);
                if (drawMesh.drawVertexCount > 1) {
                    hashtable.put("axis", drawMesh.axis);
                }
                vector2 = new Vector();
                for (n = 0; n < drawMesh.vertexCount; ++n) {
                    vector2.addElement(drawMesh.vertices[n]);
                }
                hashtable.put("vertices", vector2);
                if (drawMesh.drawType == 2) {
                    hashtable.put("length_Ang", new Float(drawMesh.vertices[0].distance(drawMesh.vertices[1])));
                }
            }
            vector.addElement(hashtable);
        }
        return vector;
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.nPoints == 0) {
            return "";
        }
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.vertexCount == 0) continue;
            stringBuffer.append(this.getDrawCommand(drawMesh, drawMesh.modelIndex));
            if (drawMesh.visible) continue;
            stringBuffer.append("draw off;\n");
        }
        return stringBuffer.toString();
    }
}

