# The LearningOnline Network
# User Authentication Module
#
# $Id: lonauth.pm,v 1.96 2008/10/02 13:37:52 www Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonauth;

use strict;
use LONCAPA;
use Apache::Constants qw(:common);
use CGI qw(:standard);
use DynaLoader; # for Crypt::DES version
use Crypt::DES;
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonmenu();
use Apache::createaccount;
use Fcntl qw(:flock);
use Apache::lonlocal;
 
# ------------------------------------------------------------ Successful login
sub success {
    my ($r, $username, $domain, $authhost, $lowerurl, $extra_env,
	$form) = @_;

# ------------------------------------------------------------ Get cookie ready
    my $cookie =
	&Apache::loncommon::init_user_environment($r, $username, $domain,
						  $authhost, $form,
						  {'extra_env' => $extra_env,});

    my $public=($username eq 'public' && $domain eq 'public');

    if ($public or $lowerurl eq 'noredirect') { return $cookie; }

# -------------------------------------------------------------------- Log this

    &Apache::lonnet::log($domain,$username,$authhost,
                         "Login $ENV{'REMOTE_ADDR'}");

# ------------------------------------------------- Check for critical messages

    my @what=&Apache::lonnet::dump('critical',$domain,$username);
    if ($what[0]) {
	if (($what[0] ne 'con_lost') && ($what[0]!~/^error\:/)) {
	    $lowerurl='/adm/email?critical=display';
        }
    }

# ------------------------------------------------------------ Get cookie ready
    $cookie="lonID=$cookie; path=/";
# -------------------------------------------------------- Menu script and info
    my $windowinfo=&Apache::lonmenu::open($env{'browser.os'});
    my $startupremote=&Apache::lonmenu::startupremote($lowerurl);
    my $remoteinfo=&Apache::lonmenu::load_remote_msg($lowerurl);
    my $setflags=&Apache::lonmenu::setflags();
    my $maincall=&Apache::lonmenu::maincall();
    my $start_page=&Apache::loncommon::start_page('Successful Login',
						  $startupremote,
						  {'no_inline_link' => 1,});
    my $end_page  =&Apache::loncommon::end_page();

    my $continuelink;
    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off')) {
	$continuelink="<a href=\"$lowerurl\">".&mt('Continue')."</a>";
    }
# ------------------------------------------------- Output for successful login

    &Apache::loncommon::content_type($r,'text/html');
    $r->header_out('Set-cookie' => $cookie);
    $r->send_http_header;

    my %lt=&Apache::lonlocal::texthash(
				       'wel' => 'Welcome',
				       'mes' => 'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up.',
				       'pro' => 'Login problems?',
				       'log' => 'loginproblems.html',
				       );
    $r->print(<<ENDSUCCESS);
$start_page
$setflags
$windowinfo
<h1>$lt{'wel'}</h1>
$lt{'mes'}<p>
<a href="/adm/$lt{'log'}">$lt{'pro'}</a></p>
$remoteinfo
$maincall
$continuelink
$end_page
ENDSUCCESS
}

# --------------------------------------------------------------- Failed login!

sub failed {
    my ($r,$message,$form) = @_;
    my $start_page = &Apache::loncommon::start_page('Unsuccessful Login',undef,
						    {'no_inline_link' => 1,});
    my $end_page   = &Apache::loncommon::end_page();
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    $r->print(
       $start_page
      .'<h1>'.&mt('Sorry ...').'</h1>'
      .'<p class="LC_warning">'.&mt($message).'</p>'
      .'<p>'.&mt('Please [_1]log in again[_2].'
                ,"<a href=\"/adm/login?username=$form->{'uname'}&domain=$form->{'udom'}\">",'</a>')
      .'</p>'
      .'<p><a href="/adm/loginproblems.html">'.&mt('Login problems?').'</a></p>'
      .$end_page
    );
 }

# ------------------------------------------------------------------ Rerouting!

sub reroute {
    my ($r) = @_;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    my $msg='<h1>'.&mt('Sorry ...').'</h1>'
           .&mt('Please [_1]log in again[_2].');
    &Apache::loncommon::simple_error_page($r,'Rerouting',$msg);
}

# ---------------------------------------------------------------- Main handler

sub handler {
    my $r = shift;
    my $form;
# Are we re-routing?
    if (-e '/home/httpd/html/lon-status/reroute.txt') {
	&reroute($r);
	return OK;
    }

    &Apache::lonlocal::get_language_handle($r);

# -------------------------------- Prevent users from attempting to login twice
    my $handle = &Apache::lonnet::check_for_valid_session($r);
    if ($handle ne '') {
# Indeed, a valid token is found
	&Apache::loncommon::content_type($r,'text/html');
	$r->send_http_header;
	my $start_page = 
	    &Apache::loncommon::start_page('Already logged in');
	my $end_page = 
	    &Apache::loncommon::end_page();
        $r->print(
           $start_page
          .'<h1>'.&mt('You are already logged in!').'</h1>'
          .'<p>'.&mt('Please either [_1]continue the current session[_2] or [_3]logout[_4].'
                    ,'<a href="/adm/roles">','</a>','<a href="/adm/logout">','</a>')
          .'</p>'
          .'<p><a href="/adm/loginproblems.html">'.&mt('Login problems?').'</a></p>'
          .$end_page
        );
        return OK;
    }

# ---------------------------------------------------- No valid token, continue


    my $buffer;
    if ($r->header_in('Content-length') > 0) {
	$r->read($buffer,$r->header_in('Content-length'),0);
    }
    my %form;
    foreach my $pair (split(/&/,$buffer)) {
       my ($name,$value) = split(/=/,$pair);
       $value =~ tr/+/ /;
       $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
       $form{$name}=$value;
    } 

    if ((!$form{'uname'}) || (!$form{'upass0'}) || (!$form{'udom'})) {
	&failed($r,'Username, password and domain need to be specified.',
		\%form);
        return OK;
    }

# split user logging in and "su"-user

    ($form{'uname'},$form{'suname'})=split(/\:/,$form{'uname'});
    $form{'uname'} = &LONCAPA::clean_username($form{'uname'});
    $form{'suname'}= &LONCAPA::clean_username($form{'suname'});
    $form{'udom'}  = &LONCAPA::clean_domain(  $form{'udom'});

    my $role   = $r->dir_config('lonRole');
    my $domain = $r->dir_config('lonDefDomain');
    my $prodir = $r->dir_config('lonUsersDir');
    my $contact_name = &mt('LON-CAPA helpdesk');

# ---------------------------------------- Get the information from login token

    my $tmpinfo=Apache::lonnet::reply('tmpget:'.$form{'logtoken'},
                                      $form{'serverid'});

    if (($tmpinfo=~/^error/) || ($tmpinfo eq 'con_lost')) {
	&failed($r,'Information needed to verify your login information is missing, inaccessible or expired.',\%form);
        return OK;
    } else {
	my $reply = &Apache::lonnet::reply('tmpdel:'.$form{'logtoken'},
					   $form{'serverid'});
        if ( $reply ne 'ok' ) {
            &failed($r,'Session could not be opened.',\%form);
	    &Apache::lonnet::logthis("ERROR got a reply of $reply when trying to contact ". $form{'serverid'}." to get login token");
	    return OK;
	}
    }
    if (!&Apache::lonnet::domain($form{'udom'})) {
        &failed($r,'The domain you provided is not a valid LON-CAPA domain.',\%form);
        return OK;
    }
    my ($key,$firsturl)=split(/&/,$tmpinfo);

    my $keybin=pack("H16",$key);

    my $cipher;
    if ($Crypt::DES::VERSION>=2.03) {
	$cipher=new Crypt::DES $keybin;
    }
    else {
	$cipher=new DES $keybin;
    }
    my $upass='';
    for (my $i=0;$i<=2;$i++) {
	my $chunk=
	    $cipher->decrypt(unpack("a8",pack("H16",substr($form{'upass'.$i},0,16))));

	$chunk.=
	    $cipher->decrypt(unpack("a8",pack("H16",substr($form{'upass'.$i},16,16))));

	$chunk=substr($chunk,1,ord(substr($chunk,0,1)));
	$upass.=$chunk;
    }

# ---------------------------------------------------------------- Authenticate
    my @cancreate;
    my %domconfig = &Apache::lonnet::get_dom('configuration',['usercreation'],$form{'udom'});
    if (ref($domconfig{'usercreation'}) eq 'HASH') {
        if (ref($domconfig{'usercreation'}{'cancreate'}) eq 'HASH') {
            if (ref($domconfig{'usercreation'}{'cancreate'}{'selfcreate'}) eq 'ARRAY') {
                @cancreate = @{$domconfig{'usercreation'}{'cancreate'}{'selfcreate'}};
            } elsif (($domconfig{'usercreation'}{'cancreate'}{'selfcreate'} ne 'none') && 
                     ($domconfig{'usercreation'}{'cancreate'}{'selfcreate'} ne '')) {
                @cancreate = ($domconfig{'usercreation'}{'cancreate'}{'selfcreate'});
            }
        }
    }
    my $defaultauth;
    if (grep(/^login$/,@cancreate)) {
        $defaultauth = 1;
    }
    my $authhost=Apache::lonnet::authenticate($form{'uname'},$upass,
                                              $form{'udom'},$defaultauth);
    
# --------------------------------------------------------------------- Failed?

    if ($authhost eq 'no_host') {
	&failed($r,'Username and/or password could not be authenticated.',
		\%form);
        return OK;
    } elsif ($authhost eq 'no_account_on_host') {
        my %domconfig = 
            &Apache::lonnet::get_dom('configuration',['usercreation'],$form{'udom'});
        if (grep(/^login$/,@cancreate)) {
            my $start_page = 
                &Apache::loncommon::start_page('Create a user account in LON-CAPA',
                                               '',{'no_inline_link'   => 1,});
            my $domdesc = &Apache::lonnet::domain($form{'udom'},'description');
            my $lonhost = $r->dir_config('lonHostID');
            my $origmail = $Apache::lonnet::perlvar{'lonSupportEMail'};
            my $contacts = 
                &Apache::loncommon::build_recipient_list(undef,'helpdeskmail',
                                                        $form{'udom'},$origmail);
            my ($contact_email) = split(',',$contacts); 
            my $output = &Apache::createaccount::username_check($form{'uname'}, 
                                                                $form{'udom'},$domdesc,'',
                                                                $lonhost,$contact_email,$contact_name);
            &Apache::loncommon::content_type($r,'text/html');
            $r->send_http_header;
            &Apache::createaccount::print_header($r,$start_page);
            $r->print('<h3>'.&mt('Account creation').'</h3>'.
                      &mt('Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution.').'<br />'.
                      $output.&Apache::loncommon::end_page());
            return OK;
        } else {
            &failed($r,'Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one.',\%form);
            return OK;
        }
    }

    if (($firsturl eq '') || 
	($firsturl=~/^\/adm\/(logout|remote)/)) {
	$firsturl='/adm/roles';
    }
# --------------------------------- Are we attempting to login as somebody else?
    if ($form{'suname'}) {
# ------------ see if the original user has enough privileges to pull this stunt
	if (&Apache::lonnet::privileged($form{'uname'},$form{'udom'})) {
# ---------------------------------------------------- see if the su-user exists
	    unless (&Apache::lonnet::homeserver($form{'suname'},$form{'udom'})
		eq 'no_host') {
		&Apache::lonnet::logthis(&Apache::lonnet::homeserver($form{'suname'},$form{'udom'}));
# ------------------------------ see if the su-user is not too highly privileged
		unless (&Apache::lonnet::privileged($form{'suname'},$form{'udom'})) {
# -------------------------------------------------------- actually switch users
		    &Apache::lonnet::logperm('User '.$form{'uname'}.' at '.$form{'udom'}.
			' logging in as '.$form{'suname'});
		    $form{'uname'}=$form{'suname'};
		} else {
		    &Apache::lonnet::logthis('Attempted switch user to privileged user');
		}
	    }
	} else {
	    &Apache::lonnet::logthis('Non-privileged user attempting switch user');
	}
    }

    if ($r->dir_config("lonBalancer") eq 'yes') {
	&success($r,$form{'uname'},$form{'udom'},$authhost,'noredirect',undef,
		 \%form);
	$r->internal_redirect('/adm/switchserver');
    } else {
	&success($r,$form{'uname'},$form{'udom'},$authhost,$firsturl,undef,
		 \%form);
    }
    return OK;
}

1;
__END__


