#!/usr/bin/perl
$|=1;
# Take machine offline, reroute traffic
#
# $Id: takeoffline.pl,v 1.4 2008/12/25 01:56:03 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;
use lib '/home/httpd/lib/perl/';
use Apache::lonlocal;
use LONCAPA::loncgi;
use LONCAPA::lonauthcgi;

print "Content-type: text/html\n\n";

&main();

sub main {
    if (!&LONCAPA::lonauthcgi::check_ipbased_access('takeoffline')) {
        if (!&LONCAPA::loncgi::check_cookie_and_load_env()) {
            &Apache::lonlocal::get_language_handle();
            print(&LONCAPA::loncgi::missing_cookie_msg());
            return;
        }

        if (!&LONCAPA::lonauthcgi::can_view('takeoffline')) {
            &Apache::lonlocal::get_language_handle();
            print(&LONCAPA::lonauthcgi::unauthorized_msg('takeoffline'));
            return;
        }
    }

    &Apache::lonlocal::get_language_handle();

    print '<html><body bgcolor="#FFFFFF"><h1>'.&Apache::lonlocal::mt('Take Offline').'</h1>';
    my $statusmsg;
    if ($ENV{'QUERY_STRING'}) {
        my ($otherserver,$domain)=split(/\&/,$ENV{'QUERY_STRING'});
        if (&reroute($otherserver,$domain)) {
            print &Apache::lonlocal::mt('Rerouting to [_1]',$otherserver);
            $statusmsg = "status=rerouting&server=$otherserver&domain=$domain&time=".time.
                         "by=$Apache::lonnet::env{'user.name'}:$Apache::lonnet::env{'user.domain'}";
        }
    } else {
        if (&dead()) {
            print &Apache::lonlocal::mt('No reroute server given, taking completely offline.');
            $statusmsg = 'status=offline&time='.time."by=$Apache::lonnet::env{'user.name'}:$Apache::lonnet::env{'user.domain'}"
        }
    }
    print "</body></html>";
    if ($statusmsg) {
        if (open (STATUS,'>/home/httpd/html/lon-status/reroute.txt')) {
            print STATUS "$statusmsg\n";
            close(STATUS);
        } else {
            print &Apache::lonlocal::mt('Logging of status change to [_1] failed.','reroute.txt'); 
        }
    }
}

sub dead {
    if (open (OUT,'>/home/httpd/html/index.html')) {
        print OUT &Apache::lonlocal::mt('This LON-CAPA server is currently offline.');
        close(OUT);
        return 'ok';
    }
    return;
}

sub reroute {
    my ($otherserver,$domain) = @_;
    if (open (OUT,'>/home/httpd/html/index.html')) {
        print OUT (<<ENDNEWINDEX);
<html>
 <head>
  <title>Welcome to the LearningOnline Network with CAPA</title>
  <meta HTTP-EQUIV="Refresh" CONTENT="0.5; url=http://$otherserver/adm/login?domain=$domain">
 </head>
 <body bgcolor="#004400" topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>
  <img src="/adm/lonIcons/header.gif" />
<p><font color="#FFFFFF">Connecting to
<a href="http://$otherserver/adm/login?domain=$domain"><font color="#FFFFFF">http://$otherserver/</font></a></font></p>
</body>
</html>
ENDNEWINDEX
       close(OUT);
       return 'ok';
    }
    return;
}
