# The LearningOnline Network
# Internal Server Error Handler
#
# $Id: lonerrorhandler.pm,v 1.21 2008/12/12 23:03:04 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#



package Apache::lonerrorhandler;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonmsg();
use Apache::lonacc();
use Apache::lonlocal;

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    &Apache::lonacc::get_posted_cgi($r);
    if (!$Apache::lonlocal::lh) {
        &Apache::lonlocal::get_language_handle($r);
    }
    my $title = $env{'form.sendinfo'} ? 'Sending Error Report'
                                      : 'Could Not Process Request';
    $r->print(&Apache::loncommon::start_page($title));

    if ($env{'form.sendinfo'}) {
	my $repro='no';
# ------------------------------------------------------------------ Mail stuff
	if ($env{'form.reproducible'}) {
	    $repro='yes';
	}
        my %lt = &Apache::lonlocal::texthash (
                     msg => 'LON-CAPA Error Message',
                     rep => 'Reproducible',
                     ver => 'Version',
                     syl => 'Syllabus',
                     pri => 'Prior Action',
                     gue => 'Guesses',
                     env => 'Environment',
                 );
	my $message=(<<ENDMESSAGE);
$lt{'msg'}
$lt{'rep'}: $repro
$lt{'ver'}: $env{'form.version'}
$lt{'syl'}:
$env{'form.syllabus'}

$lt{'pri'}:
$env{'form.prioraction'}

$lt{'gue'}:
$env{'form.guesses'}

$lt{'env'}:
$env{'form.environment'}
ENDMESSAGE
        my $sysmail = $r->dir_config('lonSysEMail');
        my $defdom = $r->dir_config('lonDefDomain');
        my $origmail = $r->dir_config('lonAdmEMail');
        my $recipients = &Apache::loncommon::build_recipient_list($sysmail,
                                             'errormail',$defdom,$origmail);
        if ($recipients ne '') {
            &Apache::lonmsg::sendemail($recipients,'ERROR REPORT',$message);
	    $r->print('<h2>'.&mt('Report submitted').'</h2>'.&mt('Thank you!'));
        } else {
            $r->print('<h2>'.&mt('Warning: Report not submitted').'</h2>'.
                      '<span class="LC_error">'
                     .&mt('The administrators of the domain [_1] have not set'
                         .' any e-mail addresses for receipt of your error report.'
                         ,'<tt>'.$defdom.'</tt>')
                     .'</span>');
        }
    } else {
# ------------------------------------------------------------- Get environment
	my $envkey;
	my $env='';
	my $syllabus='';

	foreach $envkey (sort(keys(%env))) {
	    $env.="$envkey: $env{$envkey}\n";
	}
	foreach $envkey (sort(keys(%ENV))) {
	    $env.="$envkey: $ENV{$envkey}\n";
	    if ($envkey=~/REDIRECT\_(REQUEST_URI|SCRIPT|ERROR)/) {
		$syllabus.="\n$1:\n$ENV{$envkey}";
	    }
	}

	$env=~s/\"/\'\'/g;

	my $version=$r->dir_config('lonVersion');

# ----------------------------------------------------------- Print error form
	$r->print('<h2 class="LC_error">'
.&mt('Somewhere something went wrong')
.'</h2>'
.'<p>'.&mt('Please help us to find out what.').'</p>'
.'<p>'.&mt('Please take a moment to fill out the form below.').' '
.&mt('Your information, together with internal debugging information, '
    .'will be emailed to the system and server administrators.')
.'</p>
<form action="/adm/errorhandler" method="post">
<h3>'.&mt('Please describe what you did just before this screen came up').'</h3>
<textarea name="prioraction" cols="50" rows="5">
</textarea>
<h3>'.&mt('Is this problem reproducible?').'</h3>
<label>
<input type="checkbox" name="reproducible" value="yes" /> '.&mt('Yes!').'
</label>
<h3>'.&mt('Do you have any guesses why this might have happened?').'</h3>
<textarea name="guesses" cols="50" rows="5">
</textarea>
<input type="hidden" name="version" value="'.$version.'" />
<input type="hidden" name="environment" value="'.$env.'" />
<input type="hidden" name="syllabus" value="'.$syllabus.'" />
<input type="hidden" name="sendinfo" value="1" />
<p>
<input type="submit" title="'.&mt('Send Information').'" value="'.&mt('Send').'" />
</p>
</form>
<h1>'.&mt('Thank you for your help!').'</h1>
<div><font size="-1">
'.&mt('Internal info:').
'<pre>'.
$syllabus.'
</pre>
</font></div>
');
# -------------------------- Better terminate this in case something was sticky

        $r->child_terminate();
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

1;
__END__


=pod

=head1 NAME

Apache::lonerrorhandler.pm

=head1 SYNOPSIS

Handles errors.

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 OVERVIEW

None

=cut
