/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    Viewer viewer;
    Graphics3D g3d;
    int[] argbsCpk;
    int[] altArgbsCpk;
    boolean isDefaultColorRasmol;
    short colixRubberband = (short)22;
    short colixBackgroundContrast;
    private float colorHi;
    private float colorLo;
    private float[] colorData;
    int palette = 0;

    ColorManager(Viewer viewer, Graphics3D graphics3D) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.argbsCpk = JmolConstants.argbsCpk;
        this.altArgbsCpk = new int[JmolConstants.altArgbsCpk.length];
        int n = JmolConstants.altArgbsCpk.length;
        while (--n >= 0) {
            this.altArgbsCpk[n] = JmolConstants.altArgbsCpk[n];
        }
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void resetElementColors() {
        this.setDefaultColors("Jmol");
    }

    void setDefaultColors(String string) {
        int n;
        if (string.equalsIgnoreCase("Jmol")) {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = JmolConstants.argbsCpk;
        } else if (string.equalsIgnoreCase("RasMol")) {
            this.isDefaultColorRasmol = true;
            this.copyArgbsCpk();
            n = JmolConstants.argbsCpkRasmol[0] | 0xFF000000;
            int n2 = this.argbsCpk.length;
            while (--n2 >= 0) {
                this.argbsCpk[n2] = n;
            }
            n2 = JmolConstants.argbsCpkRasmol.length;
            while (--n2 >= 0) {
                n = JmolConstants.argbsCpkRasmol[n2];
                int n3 = n >> 24;
                this.argbsCpk[n3] = n |= 0xFF000000;
            }
        } else {
            Logger.error((String)"unrecognized color scheme");
            return;
        }
        n = JmolConstants.argbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)n, this.argbsCpk[n]);
        }
        n = JmolConstants.altArgbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + n), this.altArgbsCpk[n]);
        }
    }

    void copyArgbsCpk() {
        this.argbsCpk = new int[JmolConstants.argbsCpk.length];
        int n = JmolConstants.argbsCpk.length;
        while (--n >= 0) {
            this.argbsCpk[n] = JmolConstants.argbsCpk[n];
        }
        this.altArgbsCpk = new int[JmolConstants.altArgbsCpk.length];
        n = JmolConstants.altArgbsCpk.length;
        while (--n >= 0) {
            this.altArgbsCpk[n] = JmolConstants.altArgbsCpk[n];
        }
    }

    void setRubberbandArgb(int n) {
        this.colixRubberband = n == 0 ? (short)0 : Graphics3D.getColix((int)n);
    }

    void setColixBackgroundContrast(int n) {
        this.colixBackgroundContrast = (short)((Graphics3D.calcGreyscaleRgbFromRgb((int)n) & 0xFF) < 128 ? 8 : 4);
    }

    short getColixBackgroundContrast() {
        return this.colixBackgroundContrast;
    }

    short getColixAtomPalette(Atom atom, byte by) {
        int n = 0;
        switch (by) {
            case 83: {
                return this.getPropertyColix(atom.getAtomIndex());
            }
            case 16: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = ColorManager.getJmolOrRasmolArgb(s, 32814);
                break;
            }
            case 17: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = ColorManager.getJmolOrRasmolArgb(s, 32773);
                break;
            }
            case 0: 
            case 1: {
                short s = atom.getAtomicAndIsotopeNumber();
                if (s < 256) {
                    return this.g3d.getChangeableColix(s, this.argbsCpk[s]);
                }
                s = (short)JmolConstants.altElementIndexFromNumber(s);
                return this.g3d.getChangeableColix((short)(JmolConstants.elementNumberMax + s), this.altArgbsCpk[s]);
            }
            case 2: {
                int n2 = ColorEncoder.quantize((float)atom.getPartialCharge(), (float)-1.0f, (float)1.0f, (int)31);
                return this.g3d.getChangeableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + n2), JmolConstants.argbsRwbScale[n2]);
            }
            case 3: {
                int n3 = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + n3), JmolConstants.argbsFormalCharge[n3]);
            }
            case 5: 
            case 68: {
                float f;
                float f2;
                if (by == 68) {
                    ModelSet modelSet = this.viewer.getModelSet();
                    f2 = modelSet.getBfactor100Lo();
                    f = modelSet.getBfactor100Hi();
                } else {
                    f2 = 0.0f;
                    f = 10000.0f;
                }
                int n4 = ColorEncoder.quantize((float)atom.getBfactor100(), (float)f2, (float)f, (int)JmolConstants.argbsRwbScale.length);
                n4 = JmolConstants.argbsRwbScale.length - 1 - n4;
                n = JmolConstants.argbsRwbScale[n4];
                break;
            }
            case 70: {
                float f = this.viewer.getModelSet().getSurfaceDistanceMax();
                int n5 = ColorEncoder.quantize((float)atom.getSurfaceDistance100(), (float)0.0f, (float)f, (int)JmolConstants.argbsRwbScale.length);
                n = JmolConstants.argbsRwbScale[n5];
                break;
            }
            case 7: {
                n = JmolConstants.argbsStructure[atom.getProteinStructureType()];
                break;
            }
            case 8: {
                short s = atom.getGroupID();
                if (s < 0 || s >= 23) {
                    s = 0;
                }
                n = JmolConstants.argbsAmino[s];
                break;
            }
            case 9: {
                short s = atom.getGroupID();
                if (s < 0 || s >= 36) {
                    s = 0;
                }
                n = JmolConstants.argbsShapely[s];
                break;
            }
            case 10: {
                int n6 = atom.getChainID() & 0x1F;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 >= JmolConstants.argbsChainAtom.length) {
                    n6 %= JmolConstants.argbsChainAtom.length;
                }
                n = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[n6];
                break;
            }
            case 75: {
                int n7 = ColorEncoder.quantize((float)atom.getSelectedGroupIndexWithinChain(), (float)0.0f, (float)(atom.getSelectedGroupCountWithinChain() - 1), (int)JmolConstants.argbsRoygbScale.length);
                n7 = JmolConstants.argbsRoygbScale.length - 1 - n7;
                n = JmolConstants.argbsRoygbScale[n7];
                break;
            }
            case 76: {
                int n8 = ColorEncoder.quantize((float)atom.getSelectedMonomerIndexWithinPolymer(), (float)0.0f, (float)(atom.getSelectedMonomerCountWithinPolymer() - 1), (int)JmolConstants.argbsRoygbScale.length);
                n8 = JmolConstants.argbsRoygbScale.length - 1 - n8;
                n = JmolConstants.argbsRoygbScale[n8];
                break;
            }
            case 77: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n9 = ColorEncoder.quantize((float)modelSet.getMoleculeIndex(atom.getAtomIndex()), (float)0.0f, (float)(modelSet.getMoleculeCountInModel(atom.getModelIndex()) - 1), (int)JmolConstants.argbsRoygbScale.length);
                n = JmolConstants.argbsRoygbScale[n9];
                break;
            }
            case 14: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n10 = atom.getModelIndex();
                int n11 = ColorEncoder.quantize((float)modelSet.getAltLocIndexInModel(n10, (char)atom.getAlternateLocationID()), (float)0.0f, (float)modelSet.getAltLocCountInModel(n10), (int)JmolConstants.argbsRoygbScale.length);
                n = JmolConstants.argbsRoygbScale[n11];
                break;
            }
            case 15: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n12 = atom.getModelIndex();
                int n13 = ColorEncoder.quantize((float)modelSet.getInsertionCodeIndexInModel(n12, atom.getInsertionCode()), (float)0.0f, (float)modelSet.getInsertionCountInModel(n12), (int)JmolConstants.argbsRoygbScale.length);
                n = JmolConstants.argbsRoygbScale[n13];
            }
        }
        return n == 0 ? (short)22 : (short)Graphics3D.getColix((int)n);
    }

    void setCurrentColorRange(float[] fArray, BitSet bitSet, String string) {
        this.colorData = fArray;
        this.setColorScheme(string);
        this.colorHi = Float.MIN_VALUE;
        this.colorLo = Float.MAX_VALUE;
        if (fArray == null) {
            return;
        }
        int n = fArray.length;
        while (--n >= 0) {
            float f;
            if (bitSet != null && !bitSet.get(n) || Float.isNaN(f = fArray[n])) continue;
            this.colorHi = Math.max(this.colorHi, f);
            this.colorLo = Math.min(this.colorLo, f);
        }
        this.setCurrentColorRange(this.colorLo, this.colorHi);
    }

    void setCurrentColorRange(float f, float f2) {
        this.colorHi = f2;
        this.colorLo = f;
        Logger.info((String)("Property color value range: " + this.colorLo + " to " + this.colorHi));
    }

    short getPropertyColix(int n) {
        if (this.colorData == null || n >= this.colorData.length) {
            return 12;
        }
        return this.getColixFromPalette(this.colorData[n], this.colorLo, this.colorHi);
    }

    int setColorScheme(String string) {
        this.palette = ColorEncoder.getColorScheme((String)string);
        return this.palette;
    }

    short getColixFromPalette(float f, float f2, float f3) {
        return ColorEncoder.getColorIndexFromPalette((float)f, (float)f2, (float)f3, (int)this.palette);
    }

    static short getColixHbondType(short s) {
        int n = (s & 0x780) >> 7;
        return Graphics3D.getColix((int)JmolConstants.argbsHbondType[n]);
    }

    private static void flushCaches() {
        Graphics3D.flushShadesAndSphereCaches();
    }

    static void setSpecular(boolean bl) {
        if (Graphics3D.getSpecular() == bl) {
            return;
        }
        Graphics3D.setSpecular((boolean)bl);
        ColorManager.flushCaches();
    }

    static boolean getSpecular() {
        return Graphics3D.getSpecular();
    }

    static void setSpecularPercent(int n) {
        if (Graphics3D.getSpecularPercent() == n) {
            return;
        }
        Graphics3D.setSpecularPercent((int)n);
        ColorManager.flushCaches();
    }

    static int getSpecularPercent() {
        return Graphics3D.getSpecularPercent();
    }

    static void setSpecularPower(int n) {
        if (n < 0) {
            if (Graphics3D.getSpecularExponent() == -n) {
                return;
            }
            Graphics3D.setSpecularExponent((int)(-n));
        } else {
            if (Graphics3D.getSpecularPower() == n) {
                return;
            }
            Graphics3D.setSpecularPower((int)n);
        }
        ColorManager.flushCaches();
    }

    static void setDiffusePercent(int n) {
        if (Graphics3D.getDiffusePercent() == n) {
            return;
        }
        Graphics3D.setDiffusePercent((int)n);
        ColorManager.flushCaches();
    }

    static int getDiffusePercent() {
        return Graphics3D.getDiffusePercent();
    }

    static void setAmbientPercent(int n) {
        if (Graphics3D.getAmbientPercent() == n) {
            return;
        }
        Graphics3D.setAmbientPercent((int)n);
        ColorManager.flushCaches();
    }

    static int getAmbientPercent() {
        return Graphics3D.getAmbientPercent();
    }

    static int getJmolOrRasmolArgb(int n, int n2) {
        if (n2 == 32814) {
            return n < 256 ? JmolConstants.argbsCpk[n] : JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(n)];
        }
        if (n2 == 32773) {
            if (n >= 256) {
                return JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(n)];
            }
            n2 = JmolConstants.argbsCpk[n];
            int n3 = JmolConstants.argbsCpkRasmol.length;
            while (--n3 >= 0) {
                int n4 = JmolConstants.argbsCpkRasmol[n3];
                int n5 = n4 >> 24;
                if (n5 != n) continue;
                n2 = n4 | 0xFF000000;
                break;
            }
            return n2;
        }
        return n2 | 0xFF000000;
    }

    void setElementArgb(int n, int n2) {
        if (n2 == 32814 && this.argbsCpk == JmolConstants.argbsCpk) {
            return;
        }
        n2 = ColorManager.getJmolOrRasmolArgb(n, n2);
        if (this.argbsCpk == JmolConstants.argbsCpk) {
            this.copyArgbsCpk();
        }
        if (n < 256) {
            this.argbsCpk[n] = n2;
            this.g3d.changeColixArgb((short)n, n2);
            return;
        }
        n = JmolConstants.altElementIndexFromNumber(n);
        this.altArgbsCpk[JmolConstants.altElementIndexFromNumber((int)n)] = n2;
        this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + n), n2);
    }
}

