/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;
import org.jmol.bspt.Node;
import org.jmol.bspt.Tuple;

public class SphereIterator {
    Bspt bspt;
    Element[] stack;
    int sp;
    int leafIndex;
    Leaf leaf;
    float radius;
    float[] centerValues;
    float radius2;
    float foundDistance2;
    boolean tHemisphere;

    SphereIterator(Bspt bspt) {
        this.bspt = bspt;
        this.centerValues = new float[bspt.dimMax];
        this.stack = new Element[bspt.treeDepth];
    }

    public void initialize(Tuple tuple, float f) {
        this.radius = f;
        this.radius2 = f * f;
        this.tHemisphere = false;
        int n = this.bspt.dimMax;
        while (--n >= 0) {
            this.centerValues[n] = tuple.getDimensionValue(n);
        }
        this.leaf = null;
        this.stack[0] = this.bspt.eleRoot;
        this.sp = 1;
        this.findLeftLeaf();
    }

    public void initializeHemisphere(Tuple tuple, float f) {
        this.initialize(tuple, f);
        this.tHemisphere = true;
    }

    public void release() {
        int n = this.bspt.treeDepth;
        while (--n >= 0) {
            this.stack[n] = null;
        }
    }

    public boolean hasMoreElements() {
        while (this.leaf != null) {
            while (this.leafIndex < this.leaf.count) {
                if (this.isWithinRadius(this.leaf.tuples[this.leafIndex])) {
                    return true;
                }
                ++this.leafIndex;
            }
            this.findLeftLeaf();
        }
        return false;
    }

    public Tuple nextElement() {
        return this.leaf.tuples[this.leafIndex++];
    }

    public float foundDistance2() {
        return this.foundDistance2;
    }

    private void findLeftLeaf() {
        this.leaf = null;
        if (this.sp == 0) {
            return;
        }
        Element element = this.stack[--this.sp];
        while (element instanceof Node) {
            Node node = (Node)element;
            float f = this.centerValues[node.dim];
            float f2 = f + this.radius;
            float f3 = f;
            if (!this.tHemisphere || node.dim != 0) {
                f3 -= this.radius;
            }
            if (f3 <= node.maxLeft && f2 >= node.minLeft) {
                if (f2 >= node.minRight && f3 <= node.maxRight) {
                    this.stack[this.sp++] = node.eleRight;
                }
                element = node.eleLeft;
                continue;
            }
            if (f2 >= node.minRight && f3 <= node.maxRight) {
                element = node.eleRight;
                continue;
            }
            if (this.sp == 0) {
                return;
            }
            element = this.stack[--this.sp];
        }
        this.leaf = (Leaf)element;
        this.leafIndex = 0;
    }

    private boolean isWithinRadius(Tuple tuple) {
        float f = tuple.getDimensionValue(0) - this.centerValues[0];
        if (this.tHemisphere && f < 0.0f) {
            return false;
        }
        float f2 = f * f;
        if (f2 > this.radius2) {
            return false;
        }
        int n = this.bspt.dimMax - 1;
        do {
            if (!((f2 += (f = tuple.getDimensionValue(n) - this.centerValues[n]) * f) > this.radius2)) continue;
            return false;
        } while (--n > 0);
        this.foundDistance2 = f2;
        return true;
    }
}

