/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.LimitedLineReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VoxelReader;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class VolumeFileReader
extends VoxelReader {
    protected BufferedReader br;
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int atomCount;
    private int nSurfaces;
    protected boolean isAngstroms;
    String line;
    int[] next = new int[1];

    VolumeFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator);
        this.br = bufferedReader;
    }

    static String determineFileType(BufferedReader bufferedReader) {
        LimitedLineReader limitedLineReader = new LimitedLineReader(bufferedReader, 10);
        limitedLineReader = new LimitedLineReader(bufferedReader, 16000);
        String string = limitedLineReader.info();
        if (string.indexOf("#JVXL+") == 0) {
            return "Jvxl+";
        }
        if (string.indexOf("#JVXL") == 0) {
            return "Jvxl";
        }
        string = limitedLineReader.readNonCommentLine();
        if (string.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        string = limitedLineReader.readNonCommentLine();
        string = limitedLineReader.readNonCommentLine();
        int n = Parser.parseInt(string);
        if (n == Integer.MIN_VALUE) {
            return string.indexOf("+") == 0 ? "Jvxl+" : "UNKNOWN";
        }
        if (n >= 0) {
            return "Cube";
        }
        n = -n;
        int n2 = 4 + n;
        while (--n2 >= 0) {
            string = limitedLineReader.readNonCommentLine();
            if (string != null) continue;
            return "UNKNOWN";
        }
        n2 = Parser.parseInt(string);
        if (n2 == Integer.MIN_VALUE) {
            return "UNKNOWN";
        }
        return n2 < 0 ? "Jvxl" : "Cube";
    }

    void discardTempData(boolean bl) {
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.discardTempData(bl);
    }

    void readVolumeParameters() {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces);
            this.params.fileIndex = this.nSurfaces;
        }
    }

    void readVolumeData(boolean bl) {
        this.gotoAndReadVoxelData(bl);
        Logger.info("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
    }

    protected int readVolumetricHeader() {
        try {
            this.readTitleLines();
            Logger.info(this.jvxlFileHeaderBuffer.toString());
            this.readAtomCountAndOrigin();
            Logger.info("voxel grid origin:" + this.volumetricOrigin);
            for (int i = 0; i < 3; ++i) {
                this.readVoxelVector(i);
                Logger.info("voxel grid vector:" + this.volumetricVectors[i]);
            }
            JvxlReader.jvxlReadAtoms(this.br, this.jvxlFileHeaderBuffer, this.atomCount, this.volumeData);
            return this.readExtraLine();
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            throw new NullPointerException();
        }
    }

    protected void readTitleLines() throws Exception {
    }

    protected int skipComments(boolean bl) throws Exception {
        int n = 1;
        while ((this.line = this.br.readLine()) != null && (!bl && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            if (bl) {
                this.jvxlFileHeaderBuffer.append(this.line).append('\n');
            }
            ++n;
        }
        return n;
    }

    protected void readAtomCountAndOrigin() throws Exception {
    }

    protected void adjustVoxelVectorLine(int n) {
    }

    protected void readVoxelVector(int n) throws Exception {
        this.line = this.br.readLine();
        this.adjustVoxelVectorLine(n);
        this.jvxlFileHeaderBuffer.append(this.line).append('\n');
        Vector3f vector3f = this.volumetricVectors[n];
        this.voxelCounts[n] = this.parseInt(this.line);
        if (this.voxelCounts[n] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        vector3f.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
        if (!this.isAngstroms) {
            vector3f.scale(0.5291772f);
        }
    }

    protected int readExtraLine() throws Exception {
        if (!this.negativeAtomCount) {
            return 1;
        }
        this.line = this.br.readLine();
        Logger.info("Reading extra CUBE information line: " + this.line);
        return this.parseInt(this.line);
    }

    protected void readVoxelData(boolean bl) throws Exception {
        boolean bl2;
        this.next[0] = 0;
        boolean bl3 = false;
        int n = 0;
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.voxelData = new float[this.nPointsX][][];
        this.nDataPoints = 0;
        this.line = "";
        StringBuffer stringBuffer = new StringBuffer();
        this.jvxlNSurfaceInts = 0;
        boolean bl4 = bl2 = !this.isJvxl && this.params.thePlane == null;
        if (bl || this.isJvxl && this.params.thePlane == null) {
            for (int i = 0; i < this.nPointsX; ++i) {
                float[][] fArrayArray = new float[this.nPointsY][];
                this.voxelData[i] = fArrayArray;
                for (int j = 0; j < this.nPointsY; ++j) {
                    float[] fArray = new float[this.nPointsZ];
                    fArrayArray[j] = fArray;
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        fArray[k] = this.getNextVoxelValue(stringBuffer);
                        ++this.nDataPoints;
                    }
                }
            }
        } else {
            float f = this.params.cutoff;
            boolean bl5 = this.params.isCutoffAbsolute;
            for (int i = 0; i < this.nPointsX; ++i) {
                float[][] fArrayArray = new float[this.nPointsY][];
                this.voxelData[i] = fArrayArray;
                for (int j = 0; j < this.nPointsY; ++j) {
                    float[] fArray = new float[this.nPointsZ];
                    fArrayArray[j] = fArray;
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        float f2;
                        fArray[k] = f2 = this.getNextVoxelValue(stringBuffer);
                        ++this.nDataPoints;
                        if (bl3 == VoxelReader.isInside(f2, f, bl5)) {
                            ++n;
                            continue;
                        }
                        if (bl2 && n != 0) {
                            stringBuffer.append(' ').append(n);
                            ++this.jvxlNSurfaceInts;
                        }
                        n = 1;
                        bl3 = !bl3;
                    }
                }
            }
        }
        if (bl2) {
            stringBuffer.append(' ').append(n).append('\n');
            ++this.jvxlNSurfaceInts;
        }
        if (!bl) {
            JvxlReader.setSurfaceInfo(this.jvxlData, this.params.thePlane, this.jvxlNSurfaceInts, stringBuffer);
        }
        this.volumeData.setVoxelData(this.voxelData);
    }

    protected float getNextVoxelValue(StringBuffer stringBuffer) throws Exception {
        float f = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int n;
            for (n = 1; n < this.params.fileIndex; ++n) {
                this.nextVoxel();
            }
            f = this.nextVoxel();
            for (n = this.params.fileIndex; n < this.nSurfaces; ++n) {
                this.nextVoxel();
            }
        } else {
            f = this.nextVoxel();
        }
        return f;
    }

    private float nextVoxel() throws Exception {
        float f = this.parseFloat();
        if (Float.isNaN(f)) {
            while ((this.line = this.br.readLine()) != null && Float.isNaN(f = this.parseFloat(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line);
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
            this.nBytes += this.line.length() + 1;
        }
        return f;
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(n2);
        }
    }

    private void skipData(int n) throws Exception {
        for (int i = 0; i < n; i += this.countData(this.line)) {
            this.line = this.br.readLine();
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c;
            while (n2 < n3 && ((c = string.charAt(n2)) == ' ' || c == '\t')) {
                ++n2;
            }
            if (n2 < n3) {
                ++n;
            }
            while (n2 < n3 && (c = string.charAt(n2)) != ' ' && c != '\t') {
                ++n2;
            }
        }
        return n;
    }

    String[] getTokens() {
        return Parser.getTokens(this.line, 0);
    }

    float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    float parseFloatNext(String string) {
        return Parser.parseFloat(string, this.next);
    }

    int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }

    int parseIntNext(String string) {
        return Parser.parseInt(string, this.next);
    }

    int parseInt(String string, int n) {
        this.next[0] = n;
        return Parser.parseInt(string, this.next);
    }
}

