# The LearningOnline Network with CAPA
# Arabic Localization Lexicon
#
# $Id: ar.pm,v 1.9 2008/09/11 16:04:47 bisitz Exp $
#
# Copyright i-Learning Limited Partnership Company
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::ar;
use base qw(Apache::localize);
%Lexicon=('_AUTO' => 1,
'language_code' => 'ar',
'char_encoding' => 'UTF-8',
'date_locale'  => 
      '$weekday, $day.$month.$year, $twentyfour:$minutes:$seconds',
'date_months'  => ' يناير,فبراير,مارس,أبريل,مايو,يونيو,يوليو,أغسطس,سبتمبر,أكتوبر,نوفمبر,ديسمبر',
'date_days'    => 'الأحد,الإثنين,الثلاثاء,الأربعاء,الخميس, الجمعة,السبت ',
'date_am' => 'صباحا',
'date_pm' => 'مساء',
'textual_remote_display' => 'on',

#يناير - كانون الثاني,فبراير - شباط,مارس - آذار,أبريل - نيسان, مايو - أيار,يونيو - حزيران,يوليو - تموز,أغسطس - آب,سبتمبر - أيلول,أكتوبر - تشرين الأول,نوفمبر - تشرين الثاني,ديسمبر - كانون الأول


   'Domain'
=> 'نطاق',

   'Server'
=> 'خادم الشبكة',

   'Load'
=> 'تحميل',

   'User Load'
=> 'تحميل المستخدم',

   'Help'
=> 'مساعد',

   'Log in'
=> 'اتصال',

   'Username'
=> 'اسم المستخدم',

   'Password'
=> 'كلمة مرور',

   'choose'
=> 'انتخاب',

   'enter'
=> 'إدخال',

   'view'
=> 'مشاهدة',

   'calendar'
=> 'تقويم',

   'prefer-'
=> 'تنظيمات',

   'ences'
=> ' تنظيمات',

  'role'
=> 'دور',

   'course'
=> 'دورة',

   'create'
=> 'إنشاء',

   'grades'
=> 'درجات',

   'commu-'
=> 'اتصالات',

   'nication'
=> 'اتصالات',

   'enroll'
=> 'تسجيل',

   'navigate'
=> 'تجوال',

   'contents'
=> 'المحتويات',

   'Announcements and Calendar'
=> 'الإعلانات و التقويم',

   'Author'
=> 'الكاتب',

   'Change Your Preferences'
=> 'تعديل التنظيمات',

   'Choose the user role'
=> 'انتخاب دور المستخدم',

   'Co-Author'
=> 'مساعد الكاتب',

   'Communication and Messages'
=> 'الاتصالات و الرسائل',

   'Course Coordinator'
=> 'منسق الدورة',

   'Course Statistics and Charts'
=> 'إحصائيات و جداول الدورة',

   'Course announcements and my calendar'
=> 'إعلانات الدورة و التقويم الخاص بي',

   'Create Users, Change User Privileges'
=> 'إنشاء مستخدمين و تغيير امتيازات المستخدم',

   'Domain Coordinator'
=> 'منسق النطاق',

   'Enrollment Manager'
=> 'مدير التسجيل',

   'Enter grades from check-out assessment resources'
=> 'أدخل الدرجات من فهرس موارد التقييم',

   'Exam Proctor'
=> 'المراقب في الامتحان',

   'Exit LON-CAPA'
=> 'LON-CAPA الخروج  من',

   'Grades Spreadsheet'
=> 'لوحة الدرجات الجدولية',

   'Grading'
=> 'يصحح الأوراق',

   'Instructor'
=> 'معلم',

   'Launch Remote Control'
=> 'البدء بعملية التحكم عن بعد',

   'Main Menu'
=> 'القائمة الرئيسية',

   'Navigate Course Contents'
=> 'تجوال في محتويات الدورة',

   'No Role, Cumulative Privileges'
=> 'بدون دور، مع تراكم الامتيازات',

   'Return to Last Location'
=> 'الرجوع إلى الموضع السابق',

   'Send and receive messages'
=> 'إرسال و استقبال الرسالة',

   'Set my user preferences'
=> 'تحديد امتيازاتي الاستخدامية',

   'Student'
=> 'طالب',

   'Switch to another user role'
=> 'الانتقال إلى دور مستخدم آخر',

   'Teaching Assistant'
=> 'مساعد الأستاذ',

   'Use or edit my bookmark collection'
=> 'استخدم أو حرر المجموعة التي انتخبتُها',

   'User Roles'
=> 'أدوار المستخدم',

   'Calculate course grades (Spreadsheet)'
=> 'حساب درجات الدورة',

   'Enter the chatroom for the course'
=> 'أُدخل غرفة المحادثة للدورة',

   'Navigate the table of contents for this course'
=> 'التجوال في فهرس محتويات هذه الدورة',

   'Syllabus'
=> 'برنامج دراسي',

   'View the course assessment progress chart'
=> 'مشاهدة جدول تقييم تطور الدورة',

   'Class Hours'
=> 'أوقات الدرس',

   'Course Description'
=> 'وصف الدورة',

   'Coursepack'
=> 'حقيبة الدورة',

   'Current Month'
=> 'الشهر الحالي',

   'Deadlines'
=> 'المواعيد الأخيرة',

   'Fri'
=> 'الجمعة',

   'Grading Information'
=> 'معلومات حول التصحيح',

   'Helproom Hours'
=> 'ساعات عمل غرفة الاستشارة',

   'Instructor Information'
=> 'معلومات المعلم',

   'Mon'
=> 'الإثنين',

   'Next Month'
=> 'الشهر المقبل',

   'Office Hours'
=> 'الساعات الإدارية',

   'Prerequisites'
=> 'المتطلبات',

   'Previous Month'
=> 'الشهر الماضي',

   'Readings'
=> 'مطالب للقراءة',

   'Sat'
=> 'السبت',

   'January'
=> 'يناير - كانون الثاني',

   'February'
=> 'فبراير - شباط',

   'March'
=> 'مارس - آذار',

   'April'
=> 'أبريل - نيسان',

   'May'
=> 'مايو - أيار',

   'June'
=> 'يونيو - حزيران',

   'August'
=> 'أغسطس - آب',

   'September'
=> 'سبتمبر - أيلول',

   'October'
=> 'أكتوبر - تشرين الأول',

   'November'
=> 'نوفمبر - تشرين الثاني',

   'December'
=> 'ديسمبر - كانون الأول',

   'Sun'
=> 'الأحد',

   'Textbook'
=> 'كتاب دراسي',

   'Thu'
=> 'الخميس',

   'Tue'
=> 'الثلاثاء',

   'Web Links'
=> 'اتصالات الشبكة',

   'Wed'
=> 'الأربعاء',

   'Drop/Add students in this course'
=> 'إخراج أو إضافة  طلاب إلى الدورة',

   'You have entered that answer before'
=> 'قد أَدرجتَ هذا الجواب فيما سبق',

   'A score has been assigned.'
=> 'تم تخصيص درجة',

   'You are correct.'
=> 'الحق معك',

   'Your receipt is'
=> 'استلامك',

   'You are excused from the problem.'
=> 'أنت معفي من الإجابة عن هذه المسألة',

   'Incorrect'
=> 'غير صحيح',

   'Some parts were not submitted.'
=> 'لم يتم تسليم بعض الحقول',

   'An error occurred while grading your answer.'
=> 'عَرَض اشتباه عند تصحيح جوابك',

   'The submitted answer was too long.'
=> 'الجواب المعروض طويل للغاية',

   'This question expects a numeric answer.'
=> 'يحتاج هذا السؤال إلى جواب بالأعداد',

   'You have provided an invalid ranking'
=> 'الرتبة التي حصلت عليها غير معتبرة',

   'please refer to'
=> 'يرجى الإشارة إلى',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'نوع امتداد الملف الذي حمّلته إلى الشبكة',

   'Please adjust significant figures.'
=> 'يرجى انتخاب أعداد هامة',

   'Units incorrect.'
=> 'الوحدات غير صحيحة',

   'Only a number required.'
=> 'المطلوب في هذا الحقل هو عدد واحد',

   'Units required'
=> 'الوحدات مطلوبة',

   'Unable to understand formula'
=> 'الصيغة غير واضحة',

   'Your submission has been recorded.'
=> 'تم تسجيل ما أرسلته',

   'Unknown message'
=> 'رسالة مجهولة',

   'Answer Submitted'
=> 'تم تسليم الجواب',

   'Tries'
=> 'اختبارات',

   'Submit Answer'
=> 'تسليم الجواب',

   'Prepare a printable document'
=> 'قدِّم سنداً صالحاً للطباعة',

   'Go To My First Homework Problem'
=> 'الانتقال إلى أول مسألة من واجباتي المنزلية',

   'Discussions'
=> 'بحوث',

   'New discussion since'
=> 'بحث جديد من',

   'Goodbye'
=> 'في أمان الله',

   ', and answers will be available on'
=> 'و الأجوبة ستكون متاحة في',

   ', or the next time you log in.'
=> ' أو حينما تتصل في المرة التالية',

   ', select a template from the pull-down menu below'
=> ',  انتخب نموذجاً من القائمة التالية المنفتحة للأسفل',

   'Abstract'
=> 'تلخيص',

   'Access and Usage Statistics'
=> 'إحصائيات المراجعة و الاستفادة',

   'Actions'
=> 'عمليات',

   'All homework is currently completed'
=> 'تم إنجاز جميع الواجبات في الوقت الحاضر',

   'Analyze Progress'
=> 'تحليل التطور',

   'Analyzing a problem'
=> 'تحليل مسألة',

   'Answer'
=> 'جواب',

   'Answer available'
=> 'الجواب متاح',

   'Answer submitted'
=> 'تم تسليم الجواب',

   'Answer submitted, not yet graded'
=> 'تم تسليم الجواب إلا أنه لم يُصحَّح بعد',

   'Back to Directory'
=> 'الرجوع إلى الدليل',

   'Bulletin Board'
=> 'لوحة الإعلانات',

   'Cancel'
=> 'انصراف',

   'Changes will become active for your current session after'
=> 'سيتم تفعيل التعديلات لجلستك الحالية بعد أن',

   'Construction Space Directory'
=> 'دليل مساحة الأطروحة',

   'Contact'
=> 'اتصال',

   'Copying file'
=> 'ينسخ الملف',

   'Course'
=> 'دورة',

   'Create'
=> 'إنشاء',

   'Create a user or modify the roles and privileges of a user'
=> 'إنشاء مستخدم أو تغيير أدواره و امتيازاته',

   'Currently not available'
=> 'لم يَعُد متوفراً في الوقت الحاضر',

   'Currently selected. '
=> 'تم انتخابه في الوقت الحاضر',

   'Date'
=> 'تاريخ',

   'Discard Edits and View'
=> 'حذف المحرر و المشاهدة',

   'Display'
=> 'عرض',

   'Done'
=> 'منجز',

   'Edit'
=> 'تحرير',

   'EditXML'
=> ' XML تحرير ',

   'Empty'
=> 'فارغ',

   'End'
=> 'نهاية',

   'Evaluation Comments'
=> 'ملاحظات التقييم',

   'Evaluation Data'
=> 'بيانات التقييم',

   'Excused by instructor'
=> 'تغاضى المعلم ',

   'Extent'
=> 'حد',

   'File'
=> 'ملف',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'لم يتم العثور على قسم صالح للتحليل لهذه المسألة و لا تسند في الوقت الحاضر إلا الأجوبة العددية و الصيغية و الفرعية',

   'Frequency'
=> 'تواتر',

   'Getting Problem Variants'
=> 'استلام أنواع المسألة',

   'Go Back'
=> 'رجوع',

   'Import'
=> 'استيراد',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'يرجى الإفادة من مضاد فيروس متطور قبل فتح هذا الملف',

   'July'
=> 'يوليو - تموز',

   'Language'
=> 'لغة',

   'Last Modified'
=> 'آخر تعديل لهذا الملف',

   'List of possible answers'
=> 'قائمة الأجوبة المحتملة',

   'Main Course Documents'
=> 'مستندات الدورة الرئيسية',

   'Map'
=> 'خارطة',

   'Map contents are not shown in order.'
=> 'لم يتم عرض محتويات الخارطة بالترتيب',

   'Name'
=> 'اسم',

   'Navigate Contents'
=> 'تجوال في المحتويات',

   'New Folder'
=> 'مجلد جديد',

   'New Messages'
=> 'رسائل جديدة',

   'New Search'
=> 'بحث جديد',

   'No content modifications yet.'
=> 'لم يتم إجراء أي تعديل في المحتويات حتى الآن',

   'No due date'
=> 'بدون تاريخ محدد',

   'No role specified'
=> 'لم يتم تحديد أي دور',

   'No upload file specified.'
=> 'لم يتم تحديد ملف لتحميله إلى الشبكة',

   'No write permission to user directory, FAIL'
=> 'لا يُسمح التلاعب في دليل المستخدم',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'ملاحظة: يستغرق إجراء التعديلات لكل المستخدمين عشر ثوانٍ',

   'Notes'
=> 'مذكرات',

   'Open, no due date'
=> 'مفتوح، بدون تاريخ محدد',

   'Page'
=> 'صفحة',

   'Part'
=> 'حقل',

   'Part is not open to be viewed. It'
=> 'الحقل مغلق و لا يمكن مشاهدته',

   'Path'
=> 'مسار',

   'Please use browser "Back" button and pick a filename'
=> 'يرجى استخدام مفتاح إرجاع المستعرض و انتخاب اسم أحد الملفات',

   'Processing'
=> 'يعالج',

   'Re-Initialize'
=> 'إعادة تمهيد',

   'Remark'
=> 'الإدلاء برأي',

   'Rename'
=> 'تبديل الاسم',

   'Save'
=> 'خزن',

   'Saving Modifications to'
=> 'خزن التعديلات في',

   'Search'
=> 'بحث',

   'Searching'
=> 'يبحث',

   'Section/Group'
=> 'حقل / مجموعة',

   'Select'
=> 'انتخب',

   'Select Course'
=> 'انتخب الدورة',

   'Select User'
=> 'انتخب المستخدم',

   'Select a'
=> 'انتخب',

   'Select the Construction Space'
=> 'انتخب مساحة الأطروحة',

   'Sequence'
=> 'توالي',

   'Server Administration'
=> 'إدارة الملقم',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'تحديد المواعيد الأخيرة و وسائط التقييم الأخرى و أيضاً تغيير مجال الدورة',

   'Show Only Uncompleted Homework'
=> 'اعرض الواجبات الناقصة فقط',

   'Simple Page'
=> 'صفحة بسيطة',

   'Simple Problem'
=> 'مسألة بسيطة',

   'Special Documents'
=> 'وثائق خاصة',

   'Start'
=> 'تشغيل',

   'Status'
=> 'حالة',

   'Store uploaded file as '
=> 'خزن الملف المحمَّل إلى الشبكة باسم',

   'Submit'
=> 'تسليم',

   'Submit Changes'
=> 'تسليم التغييرات',

   'Submit Changes and View'
=> 'تسليم التغييرات و المشاهدة',

   'Supplemental Course Documents'
=> 'مستندات الدورة التكميلية',

   'Switch Server'
=> 'تبديل الملقم',

   'System'
=> 'نظام',

   'System Administration'
=> 'إدارة النظام',

   'The target is an existing directory.'
=> 'المقصد هو الدليل الموجود',

   'Then'
=> 'ثم',

   'Title'
=> 'اسم',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'بسبب الإشكالات الموجودة في الشبكة لا يمكن أن يعرف أن هذا المورد مفتوح أم لا. حاول مرة أخرى رجاءً',

   'Unable to find'
=> 'غير متوفر',

   'Unable to make backup'
=> 'لا يمكن إعداد المساند',

   'Unable to undo, unable to switch'
=> 'لا يمكن إلغاء التعديلات أو تبديلها',

   'Unable to write to'
=> 'لا تتوافر إمكانية الكتابة إلى',

   'Uncompleted Homework'
=> 'واجبات ناقصة',

   'Undid changes, Switched'
=> 'أُلغيت التعديلات، تم تبديلها',

   'Upload Document'
=> 'تحميل السند إلى الشبكة',

   'Uploaded Document'
=> 'السند المحمَّل إلى الشبكة',

   'User Role'
=> 'دور المستخدم',

   'View All Messages'
=> 'مشاهدة جميع الرسائل',

   'View course assessment statistics'
=> 'مشاهدة إحصائيات تقييم الدورة',

   'Was due'
=> 'كان من المقرر',

   'Yes'
=> 'نعم',

   'You did not select a template.'
=> 'لم تنتخب نموذجاً',

   'You do not have authoring privileges for this resource'
=> 'لا تملك الصلاحيات تغيير محتويات هذا المورد',

   'You have no unread messages'
=> 'لا توجد لديك رسالة لم تُقرأ',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'an indeterminate date'
=> 'تاريخ غير محدد',

   'an unknown date'
=> 'تاريخ لا يمكن تشخيصه',

   'contents'
=> 'محتويات',

   'could not be copied.'
=> 'لم ينسخ',

   'is closed but you are allowed to view it'
=> 'يُغلق و لكن تستطيع أن تشاهده',

   'is due at'
=> 'المقرر في',

   'is in under construction'
=> 'في طور الإعداد',

   'is not analyzable at this time'
=> 'غير صالح للتحليل في الحال الحاضر',

   'last month'
=> 'الشهر الماضي',

   'last problem'
=> 'آخر مسألة',

   'last six months'
=> 'الأشهر الست الماضية',

   'last three months'
=> 'الأشهر الثلاث الماضية月',

   'last week'
=> 'الأسبوع الماضي',

   'last year'
=> 'السنة الماضية',

   'may open later.'
=> 'قد يُفتح فيما بعد',

   'never'
=> 'أبداً، مطلقاً',

   'not displayed'
=> 'لم يُعرض',

   're-initializing course'
=> 'إعادة الدورة',

   'system wide'
=> 'النظام واسع',

   'today'
=> 'اليوم',

   'undo'
=> 'إلغاء',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'was due on'
=> 'كان من المقرر في',

   'will open on'
=> 'سيُفتح في',

   ', is reserved internally by LON-CAPA.'
=> ',  LON-CAPA يتم خزنه داخلياً بواسطة ',

   'Back to'
=> 'الرجوع إلى',

   'Back to Source'
=> 'الرجوع إلى المورد',

   'Back to Source Directory'
=> 'الرجوع إلى دليل المورد',

   'Became this version on ...'
=> 'تم تبديل هذه النسخة ',

   'Browse published resources'
=> 'استعراض الموارد المنشورة',

   'Choose the course to work on'
=> 'انتخب دورة لتشتغل عليها',

   'Create a new course'
=> ' إنشاء دورة جديدة',

   'Customized right of use ...	'
=> ' ... حق طلب استخدام',

   'Delete messages from bulletin boards'
=> 'حذف الرسائل من لوحة الإعلانات',

   'Domain only - use limited to courses in the domain'
=> 'النطاق الوحيد - عملية تحديد الدورات',

   'Dynamic Metadata'
=> 'بيانات معيارية فاعلة',

   'Edit and view documents included in this course'
=> 'تحرير و مشاهدة المستندات المودعة في هذه الدورة',

   'Edit/Modify DOCS'
=> ' DOC تحرير أو تبديل الملفات بامتداد ',

   'Enter my resource construction space'
=> 'الدخول إلى مساحة أطروحة المورد المختص بي',

   'FAIL'
=> 'فشل',

   'Failed to copy source'
=> 'لم يتم نسخ المورد',

   'Failed to write metadata copy'
=> 'الفشل في كتابة نسخة البيانات المعيارية',

   'File copied.'
=> 'لم يتم نسخ الملف',

   'Finalize Publication'
=> 'إنهاء النشر',

   'Grant/revoke role of Co-Author'
=> 'منح أو إلغاء دور مساعد الكاتب',

   'Grant/revoke role of Domain Coordinator'
=> 'منح أو إلغاء دور منسق النطاق',

   'Grant/revoke role of Exam Proctor'
=> 'منح أو إلغاء دور المراقب في الامتحان',

   'Grant/revoke role of Instructor'
=> 'منح أو إلغاء دور المعلم',

   'Grant/revoke role of Student'
=> 'منح أو إلغاء دور الطالب',

   'Grant/revoke role of Superuser'
=> 'منح أو إلغاء دور المستخدم الفائق',

   'Illegal filename.'
=> 'اسم الملف غير معتبر',

   'Name starting with'
=> ' الاسم الذي يبدأ ب',

   'No previous versions published.'
=> 'لم يتم نشر أي نسخة من النسخ السابقة',

   'No write permission to'
=> ' لا يُسمح لك أن تكتب في',

   'Please pick a version to retrieve'
=> 'يرجى انتخاب نسخة ليتم استخراجها',

   'Private - visible to author only for testing purposes'
=> 'خاص - لا يمكن استخراج الملف إلا للكاتب و من أجل الاختبار',

   'Private Publication - did not synchronize database'
=> 'نشر خاص - لم تتم المواقتة مع قاعدة البيانات',

   'Public - no authentication or authorization required for use'
=> 'عام - لا حاجة للاستفادة إلى التوثيق أو الإذن',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'استخراج النسخة السابقة يستوجب الكتابة على الملف الموجود حالياً في مساحة الأطروحة',

   'Retrieve previous versions of'
=> 'استخراج النسخة السابقة',

   'Retrieve version'
=> 'استخراج نسخة',

   'Rule'
=> 'قانون',

   'Search the contents of this course'
=> 'البحث في محتويات هذه الدورة',

   'Search the database of published resources'
=> 'البحث في قاعدة بيانات الموارد المنشورة',

   'Send broadcast and receipt-required email'
=> 'إرسال إذاعي و استلام الرسالة الإلكترونية المحتاجة إلى الإشعار بالاستلام',

   'Show Problem Completeness'
=> 'عرض مسار إكمال المسألة',

   'Switch to another course'
=> 'الانتقال إلى دورة أخرى',

   'System wide - can be used for any courses system wide'
=> 'النظام واسع - يمكن استخدامه لجميع دورات النظام الواسع',

   'System wide - open source to all authors'
=> 'النظام واسع - فتح المورد لجميع المؤلفين',

   'The extension on this file'
=> 'الامتداد على هذا الملف',

   'This resource has been marked obsolete by the author(s)'
=> 'أفصح الكاتب أو الكتّاب عن قِدَم هذا المورد',

   'Unsupported character combination'
=> 'لا يتم إسناد هذا التركيب من الحروف',

   'Uploaded'
=> 'تم تحميله إلى الشبكة',

   'Users with Roles Assigned by'
=> 'المستخدمون عبر الأدوار التي أحيلت إليهم بواسطة',

   'View documents included in this course'
=> 'مشاهدة الملفات المودعة في هذه الدورة',

   'View file'
=> 'مشاهدة الملف',

   'untitled'
=> 'بدون اسم',

#SYNC Sun Sep 28 12:06:11 2003
   'Additional Keywords'
=> 'كلمات دليلية إضافية',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'بيانات معيارية إضافية -غير قياسي، وسائط، تصديرات',

   'All versions'
=> 'جميع النسخ',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'لا يتوفر دور الكاتب و لا مساعده على أي ملقم سوى ملقم المضيف',

   'Author(s)'
=> 'كاتب / كتّاب',

   'Average number of tries till solved'
=> 'معدَّل تكرار محاولات المستخدم لحل هذه المسألة',

   'Browse Resources'
=> 'استعراض الموارد',

   'Catalog Information'
=> 'معلومات القائمة',

   'Collapse Remote Control'
=> 'إخفاق (عملية) التحكم عن بعد',

   'Construction Space'
=> 'مساحة الأطروحة',

   'Content changed'
=> 'تبدَّلَ المحتوى',

   'Copied metadata'
=> 'تم نسخ البيانات المعيارية',

   'Copied source file'
=> 'تم نسخ ملف المورد',

   'Copyright/Distribution'
=> 'حقوق النشر و الطباعة/التوزيع',

   'Could not write metadata'
=> 'لم تتوافر إمكانية',

   'Course Documents'
=> 'مستندات الدورة',

   'Creation Date'
=> 'تاريخ الإنشاء',

   'Custom Distribution File'
=> 'ملف توزيع مطلوب',

   'Default Cataloging Information for Directory'
=> 'معلومات حول فهرسة الدليل الافتراضية',

   'Degree of difficulty'
=> 'درجة الصعوبة',

   'Differences'
=> 'فروق',

   'Dump Course DOCS to Construction Space'
=> 'طرح الملفات بامتداد DOC الموجودة في مساحة الأطروحة',

   'Entering course ...'
=> '...الدخول إلى الدورة',

   'Error Messages'
=> 'رسائل خطأ',

   'Exam Information'
=> 'معلومات حول الامتحان',

   'External Resource'
=> 'مورد خارجي',

   'Generate new role ...'
=> '...إنشاء دور جديد',

   'Go to the next resource in the course sequence'
=> 'الانتقال إلى المورد التالي في ترتيب الدورة',

   'Go to the previous resource in the course sequence'
=> 'الانتقال إلى المورد السابق في ترتيب الدورة',

   'Import a published document'
=> 'إدخال السند المنشور',

   'Keyword(s)'
=> 'كلمات دليلية',

   'Last Week'
=> 'الأسبوع الماضي',

   'Load Map'
=> 'تحميل الخارطة',

   'Logged Out'
=> 'انقطع الاتصال',

   'MIME Type'
=> 'MIME- نوع',

   'Make notes and annotations about this resource'
=> 'كتابة التعليقة و الشرح على هذا المورد',

   'Material appears to be correct'
=> 'المطالب التي تبدو صحيحة',

   'Material covered with sufficient depth'
=> 'مطالب عميقة',

   'Material is helpful'
=> 'مطالب مفيدة',

   'Material presented in clear way'
=> 'مطالب واضحة',

   'Metadata Information'
=> 'معلومات حول البيانات المعيارية',

   'Modification Date'
=> 'تاريخ التعديل',

   'My Personal Info'
=> 'معلوماتي الخاصة',

   'Network-wide number of accesses (hits)'
=> 'الشبكة الواسعة - عدد المراجعات',

   'Network-wide number of courses using resource'
=> 'الشبكة الواسعة - عدد الدورات المستفيدة من هذا المورد',

   'Number of resources that follow this resource in maps'
=> 'عدد الموارد التالية لهذا المورد في الخرائط',

   'Number of resources that lead up to this resource in maps'
=> 'عدد الموارد المنتهية إلى هذا المورد في الخرائط',

   'Number of resources using or importing resource'
=> 'عدد الموارد التي تستفيد من هذا المورد أو تدرجه',

   'Obsolete'
=> 'قديم',

   'Parent Directory'
=> 'الدليل الرئيسي',

   'Please either'
=> 'يرجى إما',

   'Project Information'
=> 'معلومات حول المشروع',

   'Publisher/Owner'
=> 'ناشر أو صاحب',

   'Publishing'
=> 'منشورات',

   'Resource Publication'
=> 'نشر المورد',

   'Resource is technically correct'
=> 'المورد صحيح من الجانب الفني',

   'Score Upload Form'
=> 'وضع درجة على الاستمارة المحمَّلة إلى الشبكة',

   'Select Map'
=> 'انتخاب الخارطة',

   'Set a bookmark for this resource'
=> 'وضع المؤشرة في هذا المورد',

   'Show all roles'
=> 'عرض جميع الأدوار',

   'Since Start of Course'
=> 'من حين بدء الدورة',

   'Since Yesterday'
=> 'من يوم أمس',

   'Special documents'
=> 'وثائق خاصة',

   'Store Catalog Information'
=> 'حفظ معلومات القائمة',

   'Subject'
=> 'موضوع',

   'Successful Login'
=> 'تم الاتصال بنجاح',

   'Suggested Replacement for Obsolete File'
=> 'البديل المقترح للملف القديم',

   'Switching Role'
=> 'تبديل الدور',

   'Target'
=> 'الهدف',

   'This syllabus can be publicly viewed at'
=> 'يستطيع الجميع أن يشاهدوا هذا البرنامج الدراسي',

   'Total number of students who have worked on this problem'
=> 'عدد جميع الطلاب الذين تناولوا هذه المسألة',

   'URLs To Include in Syllabus'
=> 'عناوين مجموعة من المواقع لإدراجها في هذا البرنامج الدراسي',

   'Update Display'
=> 'تحديث العرض',

   'Upload a new main course document'
=> 'تحميل سند الدورة الرئيسي الجديد إلى الشبكة',

   'Upload a new supplemental course document'
=> 'تحميل سند الدورة التكميلي الجديد إلى الشبكة',

   'User'
=> 'مستخدم',

   'Verify Course Documents'
=> 'التصديق على صحة مستندات الدورة',

   'Version'
=> 'نسخة',

   'Wrote Metadata'
=> 'كُتبت البيانات المعيارية',

   'Your home server is '
=> 'ملقمك المضيف',

   'access denied'
=> 'لم يتم الوصول', 'إعلان',

   'anno-'
=> 'إعلان',

   'announce'
=> 'إعلان',

   'backward'
=> 'إلى الوراء',

   'bookmark'
=> 'مؤشرة',

   'chart'
=> 'مخطط',

   'chat'
=> 'محادثة',

   'close this window'
=> 'إغلاق هذه النافذة',

   'con-'
=> 'con-',

   'connection down'
=> 'عدم الاتصال',

   'docs'
=> 'مستندات',

   'during the last'
=> 'خلال الماضي',

   'edit crs'
=> 'crs تحرير  ',

   'exit'
=> 'خروج',

   'fas'
=> 'fas',

   'forward'
=> 'إلى الأمام',

   'library'
=> 'مكتبة',

   'log in again'
=> 'اتصال من جديد',

   'my'
=> 'لي',

   'not found'
=> 'لم يُعثر عليه',

   'or'
=> 'أو',

   'parms'
=> 'parms',

   'prepare'
=> 'تهيئة',

   'printout'
=> 'نسخة مطبوعة',

   'resource'
=> 'مورد',

   'roles'
=> 'أدوار',

   'search'
=> 'بحث',

   'set'
=> 'تنظيم',

   'space'
=> 'فضاء',

   'stats'
=> 'إحصائيات',

   'struct'
=> 'تشكيلة',

   'switch'
=> 'تغيير',

   'tations'
=> '',

   'updated periodically'
=> 'يتم تحديثه بأسلوب دوري',

   'user'
=> 'مستخدم',

   'visible to author and co-authors only'
=> 'يمكن مشاهدته للكاتب و مساعده فقط',

   'warning(s)'
=> 'إنذار',

   "Click to download or use your browser's Save Link function"
=> " يتم التحميل إما من خلال نقرك على هذا المكان أو إفادتك من خيار  المودع في مستعرضك",

   '#Stdnts'
=> '#طلاب',

   '#YES'
=> '#صحیح',

   '%Wrng'
=> '%غير صحيح',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;عرض&nbsp;جميع&nbsp;أوجه التقابل',

   '. . . for a particular section'
=> '. . . لحقل خاص',

   '. . . for all students in the course'
=> '. . . لجميع طلاب الدورة',

   '. . . for an individual student'
=> '. . . لطالب واحد',

   '1 am'
=> '1 صباحاً',

   '1 out of N multiple choice (radio button)'
=> 'واحدة من  خيارات',

   '1 pm'
=> '1 مساءً',

   '10 am'
=> '10 صباحاً',

   '10 pm'
=> '10 مساءً',

   '11 am'
=> '11 صباحاً',

   '11 pm'
=> '11 مساءً',

   '12 am'
=> '12 قبل الظهرً',

   '12 noon'
=> '12 ظهراً',

   '2 am'
=> '2 مساءً',

   '2 pm'
=> '2 مساءً',

   '3 am'
=> '3 صباحاً',

   '3 pm'
=> '3 مساءً',

   '4 am'
=> '4 صباحاً',

   '4 pm'
=> '4 مساءً',

   '5 am'
=> '5 صباحاً',

   '5 pm'
=> '5 مساءً',

   '6 am'
=> '6 صباحاً',

   '6 pm'
=> '6 مساءً',

   '7 am'
=> '7 صباحاً',

   '7 pm'
=> '7 مساءً',

   '8 am'
=> '8 صباحاً',

   '8 pm'
=> '8 مساءً',

   '9 am'
=> '9 صباحاً',

   '9 pm'
=> '9 مساءً',

   '<- Previous'
=> '<- سابق',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  لا يمكن التسجيل l: [_2] (34)',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: لا يمكن التسجيل. لم تحدد كلمة المرور l.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>:  لا يُقبل الاسم الاستخدامي لهذا المستخدم l [_2] [_3] [_4] [_5] (36)',

   'ALL'
=> 'جميع',

   'About Me'
=> 'حولي',

   'Access Key Management'
=> 'الوصول إلى الإدارة الرئيسية',

   'Add new option'
=> 'إضافة خيار جديد',

   'Additional Recipients'
=> 'مستقبلون إضافيون',

   'Administrator'
=> 'مدير',

   'Advanced Catalog Search'
=> 'بحث متطور في القائمة',

   'Advanced Search'
=> 'بحث متطور',

   'All Documents in Course'
=> 'جميع المستندات في الدورة',

   'All Maps or Folders'
=> 'جميع الخرائط و المجلدات',

   'All Resources (possibly large output)'
=> 'جميع الموارد -المحتمل خرج واسع',

   'Analyze Over '
=> 'تحليل',

   'Analyze Problem'
=> 'تحليل المسألة',

   'Analyze Problem Again'
=> 'تحليل المسألة من جديد',

   'Analyze as '
=> 'تحليل باسم',

   'Anonymous'
=> 'مجهول',

   'Anonymous contribution to course discussion of resource'
=> 'مساعدة مجهولة بالنسبة إلى بحث الدورة من المورد',

   'Answer:'
=> 'جواب',

   'Any Language'
=> 'كل لغة',

   'Any User'
=> 'كل مستخدم',

   'Any category'
=> 'كل مقولة',

   'Any copyright/distribution'
=> 'كل نوع من أنواع حقوق النشر و الطباعة',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'في الأغلب لا يسمح الوصول إلى نظام الملفات الذي يوفر إمكانية الوصول إلى ظام ملفات الملقم إلا للكتّاب و مساعديهم',

   'Assessment'
=> 'تقييم',

   'Assessment URL and Title'
=> 'تقييم عنوان و اسم الموقع',

   'Assigned User Roles'
=> 'الأدوار الموكلة إلى المستخدمين',

   'Associate columns with student attributes.'
=> 'الربط بين الأعمدة و خصائص الطلاب',

   'Attachment'
=> 'ملحق',

   'Attribute'
=> 'خصائص',

   'Brief view of each students performance in course.'
=> 'دراسة موجزة لإنجازات كل واحد من الطلاب في هذه الدورة',

   'Broadcast Message to Course'
=> 'إرسال رسالة عبر الإذاعة إلى الدورة',

   'Browse resources'
=> 'استعراض الموارد',

   'Browsing resource, all submissions are temporary.'
=> 'يستعرض المورد، جميع الطلبات وقتية',

   'Bulletin Board/Discussion'
=> 'لوحة الإعلانات / مناقشة',

   'By'
=> 'بواسطة',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (الضوابط المتميزة بالفاصلة، اللوحة الجدولية)',

   'Calculate answers'
=> 'حساب الأجوبة',

   'Calculations'
=> 'حسابات',

   'Change'
=> 'تغيير',

   'Change Random Seed To:'
=> 'تبديل المقدار الأول المستفاد منه إلى',

   'Change Your Language Preferences'
=> 'تبديل تنظيمات لغتك',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'لابد من مضي 10 دقائق على الأكثر ليتم إجراء التغييرات لجميع الطلاب',

   'Check All'
=> 'دراسة جميع الموارد',

   'Check Course Document Versions'
=> 'دراسة نسخ مستندات الدورة',

   'Check for All'
=> 'دراسة جميع الموارد',

   'Check for None'
=> 'دراسة لا شي‏ء من الموارد',

   'Check for Section/Group'
=> 'دراسة الحقل/المجموعة',

   'Check/Set Resource Versions'
=> 'دراسة أو تنظيم نسخ المصدر',

   'Choose a different resource'
=> 'انتخاب مورد متفاوت',

   'Chronological View'
=> 'عرض قائم على أساس ترتيب زمني',

   'Clear All'
=> 'مسح جميع الموارد',

   'Clear Caches'
=> 'مسح الذاکرةالخفیة',

   'Close'
=> 'إغلاق',

   'Close All Folders'
=> 'إغلاق جميع المجلدات',

   'Column'
=> 'عمود',

   'Column&nbsp;[_1]'
=> 'عمود&nbsp;[_1]',

   'Comma Separated Values'
=> 'الضوابط التي تمايزت بالفاصلة',

   'Compact View'
=> 'دراسة مكثفة',

   'Concept:'
=> 'مفهوم',

   'Concepts'
=> 'مفاهيم',

   'Construction Space File Operation'
=> 'عمليات ملف أطروحة الفضاء',

   'Contact Information'
=> 'معلومات الاتصال',

   'Continue enrollment?'
=> 'هل يستمر التسجيل؟',

   'Contribution to course discussion of resource'
=> 'إسناد بحث موارد الدورة',

   'Copied old metadata'
=> 'بيانات معيارية قديمة منسوخة',

   'Copied old target file'
=> 'تم نسخ ملف المقصد القديم',

   'Copyright'
=> 'حقوق النشر و الطباعة',

   'Correct Option:'
=> 'الخيار الصحيح',

   'Could Not Process Request'
=> 'لم تتم معالجة الطلب',

   'Course Assessment Parameter - Helper Mode'
=> 'وسيط تقييم الدورة - حالة المساعد',

   'Course Assessment Parameters - Overview Mode'
=> 'وسيط تقييم الدورة - صيغة الخطوط العامة',

   'Course Assessments Parameters - Table Mode'
=> 'وسيط تقييم الدورة - الصيغة الجدولية',

   'Course Environment Parameters'
=> 'وسائط محيط الدورة',

   'Course ID'
=> 'هوية الدورة',

   'Course Parameter Helper'
=> 'مساعد وسيط الدورة',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'لا يمكن استخراج الإحصائيات و الجداول المختصة بالدورة إلا بعد استعادة تشغيل موقع المعلومات. معلوماتك كاملة و لكن لا يمكن عرضها في الحال الحاضر',

   'Course level sheet'
=> 'ورقة مستوى الدورة',

   'Create New Environment Variable'
=> 'إنشاء محيط متغير جديد',

   'Create a New Course'
=> 'إنشاء دورة جديدة',

   'Critical Messages'
=> 'رسائل مهمة',

   'Current'
=> 'حالي',

   'Current Session Value'
=> 'تقييم الجلسة الحالية',

   'Default'
=> 'افتراضي',

   'Default Value'
=> 'مقدار افتراضي',

   'Delete'
=> 'حذف',

   'Delete Checked'
=> 'حذف الموارد المدروسة',

   'Delete a role'
=> 'حذف دور',

   'Delete an option'
=> 'حذف خيار',

   'Delete:'
=> 'حذف',

   'Detailed Citation View'
=> 'تحليل استشهادي مفصل',

   'Detailed Problem Analysis'
=> 'تحليل مفصل للمسألة',

   'Detailed statistics and graphs of student performance on problems.'
=> 'إحصائيات و جداول مفصلة حول عمل الطلاب في حل المسائل',

   'Diffs'
=> 'اختلافات',

   'Diffs with Current Version'
=> 'اختلافات مع النسخة الحالية',

   'Diffs with Version'
=> 'اختلافات مع النسخة',

   'Diffs with current Version'
=> 'اختلافات مع النسخة الحالية',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'تعطيل هوية الطالب و تحميله لانتخاب رقم آخر',

   'Disable all communication among students'
=> 'تعطيل جميع الاتصالات بين الطلاب',

   'Discard Selected'
=> 'إهمال الموارد المنتخبة',

   'Discussion Contributions'
=> 'مساعدات دراسية',

   'Display All Messages'
=> 'عرض جميع الرسائل',

   'Display all Messages'
=> 'عرض جميع الرسائل',

   'Display and analysis of submission times on assessments.'
=> 'عرض و تحليل طلبات التقييم',

   'Display foils in order given'
=> 'عرض أوجه التقابل وفق ترتيب محدد',

   'Display foils in random order'
=> 'عرض أوجه التقابل بأسلوب عشوائي',

   'Distribute Messages from Uploaded File to Course'
=> 'توزيع الرسائل من الملف المحمَّل مرجَّعاً إلى الدورة',

   'DoDiff'
=> 'درجةالصعوبة',

   'Domain Guest'
=> 'ضيف النطاق',

   'Drop Students'
=> 'حذف الطلاب',

   'Dropped [_1]'
=> 'حُذِفَ [_1][_1 ',

   'Dropped [_1] student(s).'
=> 'طالب محذوف',

   'Dropping Students'
=> 'يحذف الطلاب',

   'Due'
=> 'مقرر',

   'Dump Course DOCS'
=> 'طرح مستندات الدورة',

   'EMail Address'
=> 'عنوان البريد الإلكتروني',

   'EMail and Messages'
=> 'عنوان البريد الإلكتروني و الرسائل',

   'Edit Catalog Information'
=> 'تحرير محتوى الخارطة',

   'Edit Content of a Map'
=> 'تحرير قائمة الدليل',

   'Edit Directory Catalog Information'
=> 'تحرير هذا المورد',

   'Edit this resource'
=> 'إضافة الخارطة أو المجلد',

   'Enclosing Map or Folder'
=> 'إضافة الخارطة أو المجلد',

   'End Helper'
=> 'إنهاء المساعدة',

   'English - ISO'
=> 'ISO - إنجليزي',

   'Enroll a single student'
=> 'تسجيل طالب واحد',

   'Enrolling Students'
=> 'يسجل الطلاب',

   'Enrollment Status'
=> 'وضع التسجيل',

   'Enter construction space as a co-author'
=> 'الدخول في مساحة الأطروحة كأستاذ مساعد',

   'Error'
=> 'خطأ',

   'Error dropping [_1]:[_2]'
=> 'إهمال الخطأ l [_1]:[_2]',

   'Essay, open end'
=> 'مقالة، مفتوح',

   'Evaluate Resource'
=> 'تقييم المورد',

   'Excel'
=> 'Excel',

   'Failed Access to Construction Space'
=> 'لم تتوفر إمكانية الوصول إلى مساحة الأطروحة',

   'False'
=> 'غير صحيح',

   'Field'
=> 'حقل/فرع',

   'Fielded Format'
=> 'فیلد مصمَّم',

   'File Category'
=> 'مقولة الملف',

   'Filenames in Construction Space'
=> 'اسم  الملف في مساحة الأطروحة',

   'Finish Course Initialization'
=> 'إتمام وضع القيمة النهائية للدورة',

   'First Name'
=> 'اسم',

   'Foil'
=> 'وجه التقابل',

   'Foils'
=> 'أوجه التقابل',

   'Folder'
=> 'مجلد',

   'Folder in Construction Space'
=> 'المجلد في مساحة الأطروحة',

   'For User'
=> 'للمستخدم',

   'Force publication of unmodified files'
=> 'لزوم نشر الملفات غير المعدَّلة',

   'Format:'
=> 'تهيئة',

   'Forward'
=> 'إرسال الرسالة الواصلة إلى مرسَل إليه آخر',

   'Forwarded message from'
=> 'تم إرسالها من قِبَل المرسَل إليه',

   'Forwarding'
=> 'يرسل الرسالة الواصلة إلى مرسَل إليه آخر',

   'From'
=> 'من',

   'Full Update'
=> 'تطوير كامل',

   'Full update (also print list of users not enrolled anymore)'
=> 'تطوير كامل و أيضاً طباعة قائمة المستخدمين الذين لم يسجِّلوا بعد',

   'Functions'
=> 'الإنجازات',

   'Generate Spreadsheet'
=> 'توليد اللوحة الجدولية',

   'Generate Statistics'
=> 'تهيئة الإحصائيات',

   'Generation'
=> 'إنتاج',

   'German - ISO'
=> 'ISO - ألماني',

   'Grant/revoke Course Custom Role'
=> 'منح أو إلغاء دور التوصية للدورة',

   'Grant/revoke role of Administrator'
=> 'منح أو إلغاء دور المدير',

   'Grant/revoke role of Author'
=> 'منح أو إلغاء دور الكاتب',

   'Grant/revoke role of Course Coordinator'
=> 'منح أو إلغاء دور مساعد الدورة',

   'Grant/revoke role of Domain Guest'
=> 'منح أو إلغاء دور ضيف النطاق',

   'Grant/revoke role of Librarian'
=> 'منح أو إلغاء دور أمين المكتبة',

   'Grant/revoke role of Scantron Operator'
=> 'Scantron منح أو إلغاء دور مشغِّل',

   'Grant/revoke role of Teaching Assistant'
=> 'منح أو إلغاء دور الأستاذ المساعد',

   'Group/Section'
=> 'مجموعة/حقل',

   'HTML'
=> 'HTML',

   'HTML/XML'
=> 'HTML/XML',

   'Height(pixel):'
=> 'ارتفاع  النقاط الضوئية - بكسل',

   'Hide'
=> 'إخفاء',

   'Hint Text'
=> 'نص بتوضيحات تلميحية',

   'Host'
=> 'مضيف',

   'ID/Student Number'
=> 'الهوية الشخصية/رقم الطالب',

   'Identify fields'
=> 'كشف المجالات',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'LON-CAPA إذا كان فاعلاً، سيتوافر الدور الجديد في المرة التالية التي يتصل الطلاب ب',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'قد لا تتوافر إنجازات الطالب من النسخة السابقة، إن كان هذا المورد يُستخدم بشكل فاعل',

   'Ignore First Line'
=> 'أهمل السطر الأول',

   'Image:'
=> 'صورة',

   'Incorrect Answers:'
=> 'أجوبة خاطئة',

   'Initial Password'
=> 'كلمة مرور بدائية',

   'Internal Filename'
=> 'اسم الملف الداخلي',

   'Internally authenticated'
=> 'تم تأييده من حيث المحتوى',

   'Invalid date entry'
=> 'تاريخ الدخول غير معتبر',

   'Invalid home server specified'
=> 'الملقم المضيف المحدَّد غير معتبر',

   'Japanese - UTF'
=> 'UTF - ياباني',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'تطوير حفظ جميع الموارد مع أحدث النسخ  حالة افتراضية',

   'Kerberos authenticated'
=> 'Kerberos تم تأييد ',

   'Keywords'
=> 'كلمات دليلية',

   'LON-CAPA Domain for Students'
=> 'نطاق لون کابا الخاص بالطلاب',

   'LON-CAPA Enrollment Manager'
=> 'مدير تسجيل  لون کابا',

   'LON-CAPA Helper:'
=> 'مساعد لون کابا',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPAنطاق  لون کابا l: [_1]',

   'Last Name'
=> 'اللقب',

   'Last Name, First Names'
=> 'اللقب، الأسم',

   'Last access'
=> 'آخر وصول',

   'Last accessed'
=> 'آخر مراجعة',

   'Last modified'
=> 'آخر تغيير لهذا الملف',

   'Last updated'
=> 'آخر تطوير لهذا الملف',

   'Librarian'
=> 'أمين المكتبة',

   'Limit by copyright/distribution'
=> 'تحديد على أساس حقوق النشر و الطباعة/التوزيع',

   'Limit by language'
=> 'تحديد على أساس اللغة',

   'Load:'
=> 'تحميل',

   'Lock and unlock assessments'
=> 'إقفال و إزالة إقفال التقييمات',

   'Login Type'
=> 'نوع الاتصال',

   'Mail'
=> 'رساله',

   'Making Backup to'
=> 'إنشاء مساند في',

   'Manage Access Keys'
=> 'إدارة مفاتيح الوصول',

   'Manage access keys'
=> 'إدارة مفاتيح الوصول',

   'Mark Unread'
=> 'وضع علامة على عنوان غير مقروء',

   'Max Number Of Shown Foils:'
=> 'الحد الأعلى لأوجه التقابل المعروضة',

   'Max Possible To Date'
=> 'الحد الأعلى للموارد الممكنة على أساس التاريخ',

   'Max Tries'
=> 'الحد الأعلى للاختبارات',

   'Max number of foils displayed'
=> 'الحد الأعلى لأوجه التقابل المعروضة',

   'Mean Tries'
=> 'معدَّل الاختبارات',

   'Metadata'
=> 'بيانات معيارية',

   'Metadata Version'
=> 'نسخة البيانات المعيارية',

   'Metadata current version'
=> 'النسخة الحالية للبيانات المعيارية',

   'Middle Names/Initials'
=> 'الأسماء المتوسطة/حروف الاسم الأولى',

   'Mime type'
=> 'Mime نوع',

   'Modified'
=> 'متغير',

   'Modify Course Assessment Parameters'
=> 'تغيير وسائط تقييم الدورة',

   'Modify Parameters'
=> 'تغيير الوسائط',

   'Modify authentication mechanism and data for a user'
=> 'تغيير الآلية و المعلومات المتعلقة بتوثيق المستخدم',

   'Modify deadlines, etc, for this assessment resource'
=> 'تبديل تاريخ المواعيد الأخيرة و المسائل الأخرى المتعلقة بهذا المورد للتقييم',

   'Modify grades'
=> 'تغيير الدرجات',

   'Modify student data'
=> 'تغيير المعلومات المختصة بالطالب',

   'Modify user grades for this assessment resource'
=> 'تغيير الدرجات المتعلقة بهذا المورد لتقييم المستخدم',

   'Most recently published Version'
=> 'آخر نسخة منشورة',

   'Move Down'
=> 'تحريك البيانات نحو الأسفل',

   'Move Up'
=> 'تحريك البيانات نحو الأعلى',

   'Name:'
=> 'اسم',

   'New Problem Variation'
=> 'نوع جديد للمسألة',

   'New Randomization'
=> 'عشوائية جديدة',

   'New Title'
=> 'اسم جديد',

   'New parameters or stored values'
=> 'الوسائط الجديدة أو الضوابط المخزونة',

   'Next'
=> 'التالي',

   'Next ->'
=> 'Next -> (274)',

   'No Kerberos domain was specified.'
=> 'Kerberos لم يتم تحديد أي نطاق لل',

   'No changes were made to the current settings.'
=> 'لم يتم أي تغيير في التنظيمات الحالية',

   'No language preference'
=> 'لا توجد أولوية في اللغات',

   'None Found'
=> 'لم يتم العثور على أي مورد',

   'Not shown, not used'
=> 'لم يُعرض، لم يُستخدم',

   'Note: for large courses, this operation may be time consuming'
=> 'ملاحظة: قد تستغرق هذه العمليات مدة طويلة في الدورات الكبيرة',

   'Note: this will not take effect if the user already exists'
=> 'ملاحظة: لا يؤثر هذا إن كان المستخدم موجوداً من قبل',

   'Number of Plots:'
=> 'عدد الرسوم البيانية',

   'Obsolete parameters or stored values'
=> 'الوسائط القديمة أو الضوابط المخزونة',

   'Open'
=> 'فتح',

   'Open All Folders'
=> 'فتح جميع المجلدات',

   'Option Response Problem Analysis'
=> 'تحليل إمكانية الإجابة على المسألة',

   'Option response'
=> 'جواب الانتخاب',

   'Output'
=> ' خروج',

   'Output Format'
=> 'هيئة الخروج',

   'Overall Problem Statistics'
=> 'إحصائيات عامة للمسألة',

   'Owner/Publisher'
=> 'صاحب/ناشر',

   'Parameter Name'
=> 'اسم الوسيط',

   'Parameter Type'
=> 'نوع الوسيط',

   'Parameter in Effect'
=> 'الوسيط في الحالة الواقعية',

   'Per Page'
=> 'في كل صفحة',

   'Personal Information'
=> 'معلومات خاصة',

   'Please do not reply to this address.'
=> 'يرجى عدم إرسال الجواب على هذا العنوان',

   'Please notify the server administrator '
=> 'يرجى إخبار مدير الملقم',

   'Please select a problem to analyze'
=> 'يرجى انتخاب مسألة للدراسة و التحليل',

   'Please select a report to generate'
=> 'يرجى انتخاب تقرير لإنشاء',

   'Please select a report to generate.'
=> 'يرجى انتخاب تقرير لإنشاء',

   'Portuguese - ISO'
=> 'ISO - اللغة البرتغالية',

   'Position'
=> 'موقع',

   'Post anonymously'
=> 'إرسال بدون اسم الكاتب',

   'Post discussion on course resources'
=> 'إرسال بحث حول موارد الدورة',

   'Post system frontpage announcements'
=> 'إرسال إعلانات نظام الصفحة الأمامية',

   'Post to live chatrooms'
=> 'إرسال إلى غرف المحادثة',

   'Preferred language'
=> 'لغة مفضَّلة',

   'Preparing Excel Spreadsheet'
=> 'Excel إعداد اللوحة الجدولية ل',

   'Previous'
=> 'سابق',

   'Printing Helper'
=> 'مساعد الطباعة',

   'Privacy Note'
=> 'مفكرة خاصة',

   'Problem Status Chart'
=> 'رسم بياني لحالة المسألة',

   'Problems'
=> 'مسائل',

   'Problems Not Contained In A Folder'
=> 'لم تدرج المسائل في مجلد واحد',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'المسائل الموجِدة لملف اکسل الجديد. تم ضبط هذا الخطأ. يرجى إخبار مدير لون کابا',

   'Processed [_1] student(s).'
=> 'معالَج l [_1] الطلاب',

   'Processing course structure'
=> 'يعالج تشكيلة الدورة',

   'Processing first student'
=> 'يعالج أول طالب',

   'Produce Excel Output'
=> 'Excel إنتاج خرج',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'تهيئة رسائل التغذية العكسية أو التعاون في بحث الدورة حول هذا المورد',

   'Provide my evaluation of this resource'
=> 'بيِّن تقييمك حول هذا المورد',

   'Publish'
=> 'نشر',

   'Publish Directory'
=> 'نشر الدليل',

   'Publish Directory and Sub Directories'
=> 'نشر الدليل و عناوينه الفرعية',

   'Published'
=> 'منشور',

   'Question Text'
=> 'نص السؤال',

   'Question Type'
=> 'نوع السؤال',

   'Quick Completed Problems Display'
=> 'عرض سريع للمسائل التامة',

   'Random position'
=> 'موقع عشوائي',

   'Re'
=> 'من جديد',

   'Re-enrollment will re-activate data.'
=> 'التسجيل ثانية يؤدي إلى تفعيل المعلومات من جديد',

   'Reading results from'
=> 'قراءة النتائج من',

   'Record'
=> 'تقرير',

   'Registering'
=> 'يسجل',

   'Related'
=> 'متعلق',

   'Reply'
=> 'إجابة',

   'Reset Submissions'
=> 'تنظيم الطلبات من جديد',

   'Resource Feedback and Discussion'
=> 'التغذية العكسية و البحث المختص بالمورد',

   'Resource Level'
=> 'مستوى المورد',

   'Retrieve'
=> 'استخراج',

   'Retrieve Published Resources'
=> 'استخراج الموارد المنشورة',

   'Revert to Last Saved'
=> 'الرجوع إلى آخر مورد  مخزون',

   'Revision Date'
=> 'تاريخ التعديل',

   'Row'
=> 'صف',

   'Russian - KOI'
=> 'KOI - اللغة الروسية',

   'S.D. tries'
=> 'S.D. اختبارات',

   'Samples'
=> 'نماذج',

   'Save as'
=> 'حفظ باسم',

   'Save as & Make This Sheet the Default'
=> 'حفظ باسم و انتخاب مسبق لهذه الصفحة',

   'Save as ...'
=> 'حفظ باسم',

   'Scantron Operator'
=> 'Scantron مشغِّل',

   'Search Complete'
=> 'البحث كامل',

   'Section'
=> 'حقل',

   'Sections'
=> 'حقول',

   'Select All'
=> 'انتخاب جميع  الموارد',

   'Select All Students'
=> 'انتخاب جميع الطلاب',

   'Select Date'
=> 'انتخاب التاريخ',

   'Select Enclosing Map or Folder'
=> 'انتخاب الخارطة أو المجلد الملحق',

   'Select Parameter Level'
=> 'انتخاب مستوى الوسيط',

   'Select Spreadsheet File'
=> 'انتخاب ملف اللوحة الجدولية',

   'Select a course'
=> 'انتخب دورة درسیة',

   'Selecting a User'
=> 'ينتخب مستخدما',

   'Send Message to User(s)'
=> 'إرسال رسالة إلى المستخدم',

   'Send New'
=> 'إرسال رسالة جديدة',

   'Send Reply'
=> 'إرسال جواب',

   'Send Scantron data to a course'
=> 'إرسال بيانات اسکنترون إلى دورة',

   'Send as critical message'
=> 'إرسال رسالة مهمة',

   'Send internal email'
=> 'إرسال رسالة إلكترونية داخلية',

   'Sequence or Folder'
=> 'تسلسل أو مجلد',

   'Sequences and Folders'
=> 'تسلسلات و مجلدات',

   'Set Course Environment Parameters'
=> 'تنظيم وسائط محيط الدورة',

   'Set Date'
=> 'تنظيم التاريخ',

   'Set Defaults for All Resources in Course'
=> 'تنظيم الافتراضيات لجميع الموارد في الدورة',

   'Set Version to be used in Course'
=> 'تنظيم نسخة للإفادة منها في الدورة',

   'Set Versions to be used in Course according to Selections below'
=> 'تنظيم نسخة للإفادة منها في الدورة وفق الانتخابات التالية',

   'Set a due date'
=> 'تحديد موعد مناسب',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'تنظيم جميع نسخ المورد وفق النسخة الحالية تحديد النسخ',

   'Set an answer open date'
=> 'تنظيم جواب في تاريخ مفتوح',

   'Set an open date'
=> 'تعيين موعد مفتوح',

   'Set opening datefor all problems in the course for. . .'
=> 'تحديد موعد لشروع جميع المسائل في الدورة',

   'Set the number of tries'
=> 'تحديد عدد الاختبارات',

   'Set the problem weight'
=> 'تحديد أهمية المسألة',

   'Set/Modify Course Assessment Parameter'
=> 'تحديد/تغيير وسيط تقييم الدورة',

   'Set/Modify Course Assessment Parameters'
=> 'تحديد/تغيير وسائط تقييم الدورة',

   'Set/Modify Course Parameters'
=> 'تحديد/تغيير وسائط الدورة',

   'Shared by course faculty and staff'
=> 'مشترك بين أعضاء الهيئة العلمية و الموظفين',

   'Short string response'
=> 'جواب صغير منضَّد',

   'Show More Options'
=> 'عرض خيارات أكثر',

   'Show Preview'
=> 'معاينة قبل الطباعة',

   'Show always at bottom position'
=> 'اعرض دوماً في الحقل السفلي',

   'Show always at top position'
=> 'اعرض دوماً في الحقل العلوي',

   'Show catalog information'
=> 'عرض معلومات القائمة',

   'Show resource'
=> 'عرض المورد',

   'Significant figures are incorrect, submission was not graded.'
=> 'الأعداد الكثيرة غير صحيحة، لم يتم تصحيح الطلب',

   'Simple Problem Editor'
=> 'محرر المسألة البسيط',

   'Size'
=> 'حجم',

   'Size:'
=> 'حجم',

   'Skew Tries'
=> 'تحريف الاختبارات',

   'Space separated'
=> 'تم فصل المساحة',

   'Spreadsheet Computation'
=> 'حساب اللوحة الجدولية',

   'Spreadsheet Computation Status'
=> 'حالة حساب اللوحة الجدولية',

   'Starting'
=> 'يبدأ',

   'Starting and Ending Dates'
=> 'تاريخ البدء و الختم',

   'Statistics'
=> 'إحصائيات',

   'Statistics and Problem Analysis'
=> 'إحصائيات و دراسة المسألة',

   'Store'
=> 'تخزين',

   'Store Changes'
=> 'حفظ التعديلات',

   'Student Data Compilation Progress'
=> 'تطوير جمع معلومات الطالب',

   'Student Data Compilation Status'
=> 'حالة تطوير جمع معلومات الطالب',

   'Student Number'
=> 'رقم الطالب',

   'Student level sheet'
=> 'ورقة مستوى الطالب',

   'Student performance statistics on all problems.'
=> 'إحصائيات عمل الطالب حول جميع المسائل',

   'Students Affected'
=> 'طلاب متأثرون',

   'Submission Time Analysis'
=> 'تحليل زمن الطلب',

   'Submit Changes and Edit'
=> 'تسليم التغييرات و التحرير',

   'Summary'
=> 'مختصر',

   'Summary View'
=> 'رأي مختصر',

   'Synchronized SQL metadata database'
=> 'المعيارية SQL قاعدة البيانات التزامنية لبيانات',

   'Tabulator separated'
=> 'تم فصل المجدولة',

   'Task'
=> 'مهمة',

   'TeXWidth(mm):'
=> 'الاتساع -بالميلي متر',

   'Template'
=> 'أسوة',

   'Temporary Assembly Workspace'
=> 'مساحة العمل الموقتة للتجميع',

   'Text'
=> 'نص',

   'Text Block'
=> 'كتلة النص',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'يستطيع أن يطلع على المعلومات التي ترسلها كل من اتصل ب لون کابا فإن لم تكن راغباً في ذلك، لا ترسل هذه المعلومات',

   'The optional email address field was not specified.'
=> 'لم يتم تحديد حقل عنوان البريد الإلكتروني الاختياري',

   'The optional name field was not specified.'
=> 'لم يتم تحديد حقل الاسم الاختياري',

   'The optional section or group field was not specified.'
=> 'لم يتم تحديد حقل القسم أو المجموعة الاختياري',

   'The optional student number field was not specified.'
=> 'لم يتم تحديد حقل رقم الطلاب الاختياري',

   'There are currently no results'
=> 'لا توجد في الوقت الحاضر أي نتيجة',

   'There are no students currently enrolled.'
=> 'لم يسجل في الوقت الحاضر أي طالب',

   'There is no student data for this problem.'
=> 'لا يوجد لهذه المسألة أي بيان طلابي',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'يعينك هذا المساعد على تعيين المواعيد المفتوحة و المناسبة لهذه المسائل أو على عدد تكرار اختبار هذه المسائل. و سوف تُسأل عن المسائل التي تريد أن تنتخب لها وسيطاً و الوسائط التي تعنى بها. ثم ستنتخب الأشخاص الذين تؤثر عليهم هذه التنظيمات. و يمكنك مشاهدة المواضع التي استعرضتها بعد انتهاء عمل المساعد لتتوافر لك إمكانية إنهاء هذه المرحلة مباشرةً بالضغط على مفتاح التالي سيتم البدء بالعمل و بالضغط على مفتاح السابق سيتم الرجوع إلى الصفحة السابقة',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'LON-CAPA هذه رسالة تلقائية أُنشئت بواسطة نظام لون کابا',

   'Threaded View'
=> 'Threaded View',

   'Time'
=> 'زمن',

   'To'
=> 'إلى',

   'Topic'
=> 'موضوع',

   'Total'
=> 'مجموع',

   'Total Parts In Course'
=> 'الأقسام العامة في الدورة',

   'Total number of records found in file: [_1].'
=> 'لم يتم العثور على مجموع هذه التقارير في الملف',

   'True'
=> 'صحيح',

   'Turkish - ISO'
=> 'ISO تركي',

   'Type'
=> 'نوع',

   'Type-in value'
=> 'نوع المقدار الوارد',

   'UNIX authenticated'
=> 'UNIX تم تأييد',

   'URL'
=> 'عنوان إنترنتي',

   'USERS'
=> 'مستخدمون',

   'Unable to connect to database!'
=> 'لم تتوافر إمكانية الاتصال بقاعدة البيانات',

   'Unable to enroll students'
=> 'لم تتوافر إمكانية تسجيل الطلاب',

   'Uncheck All'
=> 'تسجيل',

   'Unit:'
=> 'وحدة',

   'Unknown ID'
=> 'هوية مجهولة',

   'Unknown user'
=> 'مستخدم مجهول',

   'Unpublished'
=> 'لم يُنشر',

   'Unselect All'
=> 'إلغاء انتخاب الجميع',

   'Unselect All Students'
=> 'إلغاء انتخاب جميع الطلاب',

   'Unsuccessful Login'
=> 'لم يتم الاتصال بنجاح',

   'Up'
=> 'فوق',

   'Update Course Assessment Parameter Display'
=> 'تطوير عرض وسيط تقييم الدورة',

   'Update Section or Specific User'
=> 'تطوير مستخدم القسم أو المستخدم الخاص',

   'Update Student Data'
=> 'تطوير بيانات الطالب',

   'Updating discussion time'
=> 'يطور زمن البحث',

   'Upload Scantron data'
=> 'تحميل بيانات اسکنترون إلى الشبكة',

   'Upload a Photo'
=> 'تحميل صورة إلى الشبكة',

   'Upload a class list'
=> 'تحميل قائمة صف إلى الشبكة',

   'Uploading Class List'
=> 'تحميل قائمة صف إلى الشبكة',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'مذكرات المستخدم، تقارير حول بحوث شفهية و رسائل نقدية في الدورة',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'مذكرات المستخدم، تقارير حول بحوث شفهية و رسائل نقدية',

   'Value'
=> 'مقدار',

   'Verify Content'
=> ' توثيق المحتوى',

   'Verify Selection'
=> 'تأييد الانتخاب',

   'Version Number'
=> 'رقم النسخة',

   'Version changes since Yesterday'
=> 'تغييرات النسخة من يوم أمس  حتى الآن',

   'Version changes since last Month'
=> 'تغييرات النسخة من الشهر الماضي  حتى الآن',

   'Version changes since last Week'
=> 'تغييرات النسخة من الأسبوع الماضي  حتى الآن',

   'Version changes since start of Course'
=> 'تغييرات النسخة من بداية الدورة  حتى الآن',

   'Version used in Course'
=> 'النسخة المستفاد منها في الدورة',

   'View'
=> 'مشاهدة',

   'View Class List'
=> 'مشاهدة قائمة الصف',

   'View Critical Messages'
=> 'مشاهدة الرسائل النقدية',

   'View Published Version'
=> 'مشاهدة النسخة المنشورة',

   'View user submissions for this assessment resource'
=> 'مشاهدة طلبات المستخدم لهذا المورد للتقييم',

   'Warning!'
=> 'إنذار',

   'Web References'
=> 'موارد الوب',

   'Welcome'
=> '!أهلاً و سهلاً',

   'Welcome to the Assignment Parameter Helper'
=> 'نرحب بك في مساعد تسليم الوسيط',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'نرحب بك في شبكة تحميل التعليم بواسطة لون کابا انتظر رجاءً ليتم تنظيم جلستك',

   'What parameter do you want to set for all problems in the course?'
=> 'أي وسيط تريده لتطبيق كل مسائل الدورة؟',

   'What should the opening date be set to?'
=> 'على أي أساس يتم تنظيم تاريخ الافتتاح؟',

   'Which Problem or Problems?'
=> 'أي مسألة أو مسائل؟',

   'Which problems do you wish to set a parameter for?'
=> 'لأي المسائل تريد أن تعين وسيطاً؟',

   'Width(pixel):'
=> 'اتساع النقاط الضوئية - بكسل',

   'Words'
=> 'مفردات',

   'XML/SGML'
=> 'XML/SGML',

   'You have no critical messages.'
=> 'لا توجد لديك أي رسالة نقدية',

   'You must choose an authentication type.'
=> 'عليك أن تنتخب نوعاً من التوثيق',

   'You must choose at least one student to continue.'
=> 'لابد للاستمرار من انتخاب طالب واحد على الأقل',

   'You must choose one or more choices to continue.'
=> 'لابد للاستمرار من انتخاب خيار واحد أو أكثر',

   'You need to choose another user role or enter a specific course for this function'
=> 'لابد من انتخاب دور مستخدم آخر أو إدراج دورة معينة لهذا العمل',

   'You need to specify the Kerberos domain.'
=> 'Kerberos لابد من تحديد نطاق',

   'You need to specify the initial password.'
=> 'لابد من تحديد كلمة المرور البدائية',

   'You need to specify the username field.'
=> 'لابد من تحديد خلفية اسم المستخدم',

   'Your Excel Spreadsheet'
=> 'لوحة اکسیل الجدولية الخاصة بك',

   'Your Version Settings have been Stored'
=> 'تم تخزين تنظيمات نسختك',

   '[_1] Do not change login data'
=> '[_1] لا تبدل بيانات إيجاد الاتصال',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] تم توثيق نظام الملفات بكلمة المرور البدائية',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] تم توثيقه من حيث المحتوى بكلمة المرور البدائية',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] تم توثيق  Kerberos  [_2] [_3] مع النطاق l [_4] الإصدار  l',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1]  argument [توثيق  [_2',

   'a.m.'
=> 'قبل الظهر',

   'abstract'
=> 'تلخيص',

   'acc keys'
=> 'acc مفاتيح',

   'according to course preferences'
=> 'وفق أولويات الدورة',

   'according to resource settings'
=> 'وفق تنظيمات المورد',

   'according to user session state'
=> 'وفق حالة جلسة المستخدم',

   'all'
=> 'جميع',

   'and return receipt'
=> 'و أرجع الوصل',

   'anonymous'
=> 'مجهول',

   'at'
=> 'في',

   'at Domain'
=> 'في النطاق',

   'at domain'
=> 'في النطاق',

   'audio'
=> 'صوتي',

   'author'
=> 'كاتب',

   'bytes'
=> 'بايت',

   'can not be accessed from your location.'
=> 'لا يمكن الوصول إليه من موقعك',

   'catalog'
=> 'قائمة',

   'co con-'
=> 'co con- (530)',

   'co res'
=> 'co res (531)',

   'contacting'
=> 'يتصل',

   'copyright'
=> 'حقوق النشر و الطباعة',

   'customdistributionfile'
=> 'ملف توزيع مطلوب',

   'default'
=> 'افتراضي',

   'directory'
=> 'دليل',

   'discuss'
=> 'مباحثة',

   'edit'
=> 'تحرير',

   'evaluate'
=> 'تقييم',

   'feedback'
=> 'التغذية العكسية',

   'for Enclosing Map or Folder'
=> 'للخارطة أو المجلد الملحق',

   'for Resource'
=> 'للمورد',

   'from Enclosing Map or Folder'
=> 'من الخارطة أو المجلد الملحق',

   'general'
=> 'عام',

   'in Course'
=> 'في الدورة',

   'in Section/Group'
=> 'في الحقل/المجموعة',

   'info'
=> 'معلومات',

   'interface available'
=> 'واجهة المستخدم متاحة',

   'keywords'
=> 'مفاتيح دليلية',

   'language'
=> 'لغة',

   'last student'
=> 'آخر طالب',

   'loginproblems.html'
=> 'loginproblems.html',

   'manage'
=> 'إدارة',

   'midnight'
=> 'نصف الليل',

   'minutes'
=> 'دقائق',

   'missions'
=> 'مهمات',

   'most recent'
=> 'أحدث',

   'movies'
=> 'أفلام',

   'name only visible to course faculty'
=> 'لا يمكن مشاهدة الاسم إلا للهيئة العلمية في الدورة',

   'noon'
=> 'الظهر',

   'notes'
=> 'مذكرات',

   'num_override'
=> 'num_override',

   'obsolete'
=> 'قديم',

   'obsoletereplacement'
=> 'تبديل القديم',

   'of'
=> 'من',

   'or ID'
=> 'أو الهوية الشخصية',

   'p.m.'
=> 'بعد الظهر',

   'pages'
=> 'صفحات',

   'part'
=> 'حقل',

   'percent'
=> 'نسبة مئوية',

   'pictures'
=> 'صور',

   'problem'
=> 'مسألة',

   'problem statistics grouped by sequence'
=> 'تم تبويب إحصائيات المسألة وفق التوالي',

   'problem statistics ungrouped'
=> 'لم يتم تبويب إحصائيات المسألة',

   'problem statistics, Excel'
=> 'إحصائيات المسألة -اکسیل',

   'remaining'
=> 'الباقي',

   'resources'
=> 'الموارد',

   'second'
=> 'ثانية',

   'seconds'
=> 'ثوان',

   'seconds for'
=> 'ثوان',

   'sequence'
=> 'توالي',

   'subject'
=> 'موضوع',

   'this'
=> 'هذا',

   'title'
=> 'اسم',

   'unless locked'
=> 'إلا إذا كان مُقفلاً',

   'users in'
=> 'المستخدمون في',

   'versions of this problem'
=> 'نُسخ هذه المسألة',

   'view sub-'
=> 'ملاحظة فرعية',

   'waiting on'
=> 'إسداء الخدمة إلى',


#SYNC Tue Aug 15 14:23:05 2006
   ' [_1]'
=> ' [_1]',

   '"[_1]" for default hiding'
=> '"[_1]" for default hiding',

   '"[_1]" for visible separation'
=> '"[_1]" for visible separation',

   '"[_1]" if allowed, anything else if not'
=> '"[_1]" if allowed, anything else if not',

   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',

   '# Do not translate this line.  [_1] is a check box'
=> '# Do not translate this line.  [_1] is a check box',

   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field',

   '# Do not translate this line.  [_1] is a column index.'
=> '# Do not translate this line.  [_1] is a column index.',

   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Do not translate this line.  [_1] is a drop-down box listing domains.',

   '# Do not translate this line.  [_1] is a username'
=> '# Do not translate this line.  [_1] is a username',

   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Do not translate this line.  [_1] is the number of students processed',

   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.',

   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Do not translate this line.  [_1] is username, [_2] is error message',

   '# Do not translate this line.  [_1] is username@domain'
=> '# Do not translate this line.  [_1] is username@domain',

   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Do not translate this line.  [_1] is username@domain [_2] is the error message.',

   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Do not translate this line.  [_1], [_3], and [_4] are check boxes',

   '# Do not translate this line.  [_2] is a text entry element'
=> '# Do not translate this line.  [_2] is a text entry element',

   '# [_1] is a drop-down selection box'
=> '# [_1] is a drop-down selection box',

   '# [_1] is a number [_2] is the current domain'
=> '# [_1] is a number [_2] is the current domain',

   '# [_1] is an html link to the current file '
=> '# [_1] is an html link to the current file ',

   '# _1 is a selection dialog'
=> '# _1 is a selection dialog',

   '# _1 is a server name'
=> '# _1 is a server name',

   '# _1 is search string'
=> '# _1 is search string',

   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'",

   '#Stdnts'
=> '#Stdnts',

   '#YES'
=> '#YES',

   '#[_1] is the foil name'
=> '#[_1] is the foil name',

   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 is the foil name, _2 is the current value of the foil',

   '%Wrng'
=> '%Wrng',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Show&nbsp;All&nbsp;Foils',

   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.',

   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.',

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',

   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',

   ', and answers will be available on'
=> ', and answers will be available on',

   ', is reserved internally by LON-CAPA.'
=> ', is reserved internally by LON-CAPA.',

   ', or the next time you log in.'
=> ', or the next time you log in.',

   ', select a template from the pull-down menu below'
=> ', select a template from the pull-down menu below',

   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',

   '. . . for a particular section'
=> '. . . for a particular section',

   '. . . for all students in the course'
=> '. . . for all students in the course',

   '. . . for an individual student'
=> '. . . for an individual student',

   '1 am'
=> '1 am',

   '1 minute'
=> '1 minute',

   '1 out of N multiple choice (radio button)'
=> '1 out of N multiple choice (radio button)',

   '1 pm'
=> '1 pm',

   '10 am'
=> '10 am',

   '10 pm'
=> '10 pm',

   '11 am'
=> '11 am',

   '11 pm'
=> '11 pm',

   '12 am'
=> '12 am',

   '12 noon'
=> '12 noon',

   '2 am'
=> '2 am',

   '2 pm'
=> '2 pm',

   '3 am'
=> '3 am',

   '3 pm'
=> '3 pm',

   '4 am'
=> '4 am',

   '4 pm'
=> '4 pm',

   '5 am'
=> '5 am',

   '5 pm'
=> '5 pm',

   '6 am'
=> '6 am',

   '6 pm'
=> '6 pm',

   '7 am'
=> '7 am',

   '7 pm'
=> '7 pm',

   '8 am'
=> '8 am',

   '8 pm'
=> '8 pm',

   '9 am'
=> '9 am',

   '9 pm'
=> '9 pm',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',

   '<- Previous'
=> '<- Previous',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Unable to enroll: [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Unable to enroll.  No password specified.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>',

   'A score has been assigned.'
=> 'A score has been assigned.',

   'ABSTRACT'
=> 'ABSTRACT',

   'ALL'
=> 'ALL',

   'About Me'
=> 'About Me',

   'Abstract'
=> 'Abstract',

   'Access Control'
=> 'Access Control',

   'Access Key Management'
=> 'Access Key Management',

   'Access and Usage Statistics'
=> 'Access and Usage Statistics',

   'Actions'
=> 'Actions',

   'Activate'
=> 'Activate',

   'Add Roles'
=> 'Add Roles',

   'Add new option'
=> 'Add new option',

   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",

   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",

   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",

   'Additional Keywords'
=> 'Additional Keywords',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Additional Metadata (non-standard, parameters, exports)',

   'Additional Recipients'
=> 'Additional Recipients',

   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',

   'Administrator'
=> 'Administrator',

   'Advanced Catalog Search'
=> 'Advanced Catalog Search',

   'Advanced Edit'
=> 'Advanced Edit',

   'Advanced Search'
=> 'Advanced Search',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',

   'All Documents in Course'
=> 'All Documents in Course',

   'All Maps or Folders'
=> 'All Maps or Folders',

   'All Resources'
=> 'All Resources',

   'All Resources (possibly large output)'
=> 'All Resources (possibly large output)',

   'All Students'
=> 'All Students',

   'All homework is currently completed'
=> 'All homework is currently completed',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.',

   'All versions'
=> 'All versions',

   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',

   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',

   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',

   'Analyze Over '
=> 'Analyze Over ',

   'Analyze Problem'
=> 'Analyze Problem',

   'Analyze Problem Again'
=> 'Analyze Problem Again',

   'Analyze Progress'
=> 'Analyze Progress',

   'Analyze as '
=> 'Analyze as ',

   'Analyzing Results'
=> 'Analyzing Results',

   'Analyzing a problem'
=> 'Analyzing a problem',

   'Announcements and Calendar'
=> 'Announcements and Calendar',

   'Anonymous'
=> 'Anonymous',

   'Anonymous contribution to course discussion of resource'
=> 'Anonymous contribution to course discussion of resource',

   'Answer'
=> 'Answer',

   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',

   'Answer Submitted'
=> 'Answer Submitted',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',

   'Answer available'
=> 'Answer available',

   'Answer submitted'
=> 'Answer submitted',

   'Answer submitted, not yet graded'
=> 'Answer submitted, not yet graded',

   'Answer:'
=> 'Answer:',

   'Answerable'
=> 'Answerable',

   'Any Language'
=> 'Any Language',

   'Any User'
=> 'Any User',

   'Any category'
=> 'Any category',

   'Any copyright/distribution'
=> 'Any copyright/distribution',

   'April'
=> 'April',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).',

   'Assessment'
=> 'Assessment',

   'Assessment Parameters'
=> 'Assessment Parameters',

   'Assessment URL and Title'
=> 'Assessment URL and Title',

   'Assigned User Roles'
=> 'Assigned User Roles',

   'Associate columns with student attributes.'
=> 'Associate columns with student attributes.',

   'Attachment'
=> 'Attachment',

   'Attribute'
=> 'Attribute',

   'August'
=> 'August',

   'Author'
=> 'Author',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Author and Co-Author roles may not be available on servers other than your home server.',

   'Author(s)'
=> 'Author(s)',

   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',

   'Automated adds'
=> 'Automated adds',

   'Automated drops'
=> 'Automated drops',

   'Automated enrollment settings'
=> 'Automated enrollment settings',

   'Average number of tries till solved'
=> 'Average number of tries till solved',

   'Back to'
=> 'Back to',

   'Back to Directory'
=> 'Back to Directory',

   'Back to Source'
=> 'Back to Source',

   'Back to Source Directory'
=> 'Back to Source Directory',

   'Bad Filename'
=> 'Bad Filename',

   'Became this version on ...'
=> 'Became this version on ...',

   'Begin Enrollment'
=> 'Begin Enrollment',

   'Binary File'
=> 'Binary File',

   'Blank'
=> 'Blank',

   'Brief view of each students performance in course.'
=> 'Brief view of each students performance in course.',

   'Broadcast Message to Course'
=> 'Broadcast Message to Course',

   'Browse'
=> 'Browse',

   'Browse Resources'
=> 'Browse Resources',

   'Browse published resources'
=> 'Browse published resources',

   'Browse resources'
=> 'Browse resources',

   'Browsing resource, all submissions are temporary.'
=> 'Browsing resource, all submissions are temporary.',

   'Bulletin Board'
=> 'Bulletin Board',

   'Bulletin Board/Discussion'
=> 'Bulletin Board/Discussion',

   'By'
=> 'By',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (comma separated values, spreadsheet)',

   'CSV format'
=> 'CSV format',

   'Calculate answers'
=> 'Calculate answers',

   'Calculate course grades (Spreadsheet)'
=> 'Calculate course grades (Spreadsheet)',

   'Calculations'
=> 'Calculations',

   'Cancel'
=> 'Cancel',

   'Cannot publish directory'
=> 'Cannot publish directory',

   'Cannot retrieve directory'
=> 'Cannot retrieve directory',

   'Catalog Information'
=> 'Catalog Information',

   'Catalog Search'
=> 'Catalog Search',

   'Change'
=> 'Change',

   'Change Random Seed To:'
=> 'Change Random Seed To:',

   'Change User Privileges'
=> 'Change User Privileges',

   'Change Your Language Preferences'
=> 'Change Your Language Preferences',

   'Change Your Preferences'
=> 'Change Your Preferences',

   'Changed discussion view mode'
=> 'Changed discussion view mode',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Changes can take up to 10 minutes before being active for all students.',

   'Changes will become active for your current session after'
=> 'Changes will become active for your current session after',

   'Chat Participation'
=> 'Chat Participation',

   'Check All'
=> 'Check All',

   'Check Course Document Versions'
=> 'Check Course Document Versions',

   'Check for All'
=> 'Check for All',

   'Check for None'
=> 'Check for None',

   'Check for Section/Group'
=> 'Check for Section/Group',

   'Check/Set Resource Versions'
=> 'Check/Set Resource Versions',

   'Choose a different resource'
=> 'Choose a different resource',

   'Choose the course to work on'
=> 'Choose the course to work on',

   'Choose the user role'
=> 'Choose the user role',

   'Chronological View'
=> 'Chronological View',

   'Class Hours'
=> 'Class Hours',

   'Clear All'
=> 'Clear All',

   'Clear Caches'
=> 'Clear Caches',

   'Click here for FAQ'
=> 'Click here for FAQ',

   'Click here for help'
=> 'Click here for help',

   'Click here to report bugs'
=> 'Click here to report bugs',

   'Click here to return to the chart.'
=> 'Click here to return to the chart.',

   "Click to download or use your browser's Save Link function"
=> "Click to download or use your browser's Save Link function",

   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',

   'Clone an existing course'
=> 'Clone an existing course',

   'Close'
=> 'Close',

   'Close All Folders'
=> 'Close All Folders',

   'Close This Window'
=> 'Close This Window',

   'Closed'
=> 'Closed',

   'Co-Author'
=> 'Co-Author',

   'Collapse Remote Control'
=> 'Collapse Remote Control',

   'Column'
=> 'Column',

   'Column&nbsp;[_1]'
=> 'Column&nbsp;[_1]',

   'Comma Separated Values'
=> 'Comma Separated Values',

   'Communication'
=> 'Communication',

   'Communication and Messages'
=> 'Communication and Messages',

   'Compact View'
=> 'Compact View',

   'Compare versions of'
=> 'Compare versions of',

   'Completed'
=> 'Completed',

   'Completely new course'
=> 'Completely new course',

   'Concept:'
=> 'Concept:',

   'Concepts'
=> 'Concepts',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.',

   'Construction Space'
=> 'Construction Space',

   'Construction Space Directory'
=> 'Construction Space Directory',

   'Construction Space File Operation'
=> 'Construction Space File Operation',

   'Construction Space Version'
=> 'Construction Space Version',

   'Contact'
=> 'Contact',

   'Contact Information'
=> 'Contact Information',

   'Content changed'
=> 'Content changed',

   'Continue'
=> 'Continue',

   'Continue enrollment?'
=> 'Continue enrollment?',

   'Contribution to course discussion of resource'
=> 'Contribution to course discussion of resource',

   'Copied metadata'
=> 'Copied metadata',

   'Copied old metadata'
=> 'Copied old metadata',

   'Copied old target file'
=> 'Copied old target file',

   'Copied source file'
=> 'Copied source file',

   'Copy current file to'
=> 'Copy current file to',

   'Copy selected'
=> 'Copy selected',

   'Copying file'
=> 'Copying file',

   'Copyright'
=> 'Copyright',

   'Copyright/Distribution'
=> 'Copyright/Distribution',

   'Correct Option:'
=> 'Correct Option:',

   'Could Not Process Request'
=> 'Could Not Process Request',

   'Could not write metadata'
=> 'Could not write metadata',

   'Course'
=> 'Course',

   'Course Assessment Parameter - Helper Mode'
=> 'Course Assessment Parameter - Helper Mode',

   'Course Assessment Parameters - Overview Mode'
=> 'Course Assessment Parameters - Overview Mode',

   'Course Assessments Parameters - Table Mode'
=> 'Course Assessments Parameters - Table Mode',

   'Course Code'
=> 'Course Code',

   'Course Content'
=> 'Course Content',

   'Course Coordinator'
=> 'Course Coordinator',

   'Course Data'
=> 'Course Data',

   'Course Description'
=> 'Course Description',

   'Course Documents'
=> 'Course Documents',

   'Course Environment Parameters'
=> 'Course Environment Parameters',

   'Course Home Server'
=> 'Course Home Server',

   'Course ID'
=> 'Course ID',

   'Course ID or number'
=> 'Course ID or number',

   'Course ID/Number'
=> 'Course ID/Number',

   'Course Information'
=> 'Course Information',

   'Course Initialization Helper'
=> 'Course Initialization Helper',

   'Course Level'
=> 'Course Level',

   'Course Parameter Helper'
=> 'Course Parameter Helper',

   'Course Search'
=> 'Course Search',

   'Course Statistics and Charts'
=> 'Course Statistics and Charts',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.',

   'Course Title'
=> 'Course Title',

   'Course announcements and my calendar'
=> 'Course announcements and my calendar',

   'Course default for all problems'
=> 'Course default for all problems',

   'Course level sheet'
=> 'Course level sheet',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',

   'Coursepack'
=> 'Coursepack',

   'Courses'
=> 'Courses',

   'Create'
=> 'Create',

   'Create New Environment Variable'
=> 'Create New Environment Variable',

   'Create New User'
=> 'Create New User',

   'Create User'
=> 'Create User',

   'Create Users, Change User Privileges'
=> 'Create Users, Change User Privileges',

   'Create a New Course'
=> 'Create a New Course',

   'Create a new course'
=> 'Create a new course',

   'Create a user or modify the roles and privileges of a user'
=> 'Create a user or modify the roles and privileges of a user',

   'Creating a new'
=> 'Creating a new',

   'Creation Date'
=> 'Creation Date',

   'Critical Messages'
=> 'Critical Messages',

   'Crosslisted courses'
=> 'Crosslisted courses',

   'Current'
=> 'Current',

   'Current Class List'
=> 'Current Class List',

   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',

   'Current Ending Date: not set'
=> 'Current Ending Date: not set',

   'Current Month'
=> 'Current Month',

   'Current Resource'
=> 'Current Resource',

   'Current Session Value'
=> 'Current Session Value',

   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',

   'Current Starting Date: not set'
=> 'Current Starting Date: not set',

   'Current Version'
=> 'Current Version',

   'Currently no active roles or courses'
=> 'Currently no active roles or courses',

   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',

   'Currently not available'
=> 'Currently not available',

   'Currently selected. '
=> 'Currently selected. ',

   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',

   'Custom Distribution File'
=> 'Custom Distribution File',

   'Custom Role Editor'
=> 'Custom Role Editor',

   'Customized right of use ...	'
=> 'Customized right of use ...	',

   'Cut selected'
=> 'Cut selected',

   'Date'
=> 'Date',

   'Deadlines'
=> 'Deadlines',

   'December'
=> 'December',

   'Decompress'
=> 'Decompress',

   'Default'
=> 'Default',

   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',

   'Default Cataloging Information for Directory'
=> 'Default Cataloging Information for Directory',

   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',

   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',

   'Default Value'
=> 'Default Value',

   'Default XML Style File'
=> 'Default XML Style File',

   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',

   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',

   'Default for new courses is'
=> 'Default for new courses is',

   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',

   'Default:'
=> 'Default:',

   'Define Role'
=> 'Define Role',

   'Degree of difficulty'
=> 'Degree of difficulty',

   'Delete'
=> 'Delete',

   'Delete Checked'
=> 'Delete Checked',

   'Delete a role'
=> 'Delete a role',

   'Delete an option'
=> 'Delete an option',

   'Delete messages from bulletin boards'
=> 'Delete messages from bulletin boards',

   'Delete:'
=> 'Delete:',

   'Dependencies'
=> 'Dependencies',

   'Description:'
=> 'Description:',

   'Detailed Citation View'
=> 'Detailed Citation View',

   'Detailed Problem Analysis'
=> 'Detailed Problem Analysis',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Detailed statistics and graphs of student performance on problems.',

   'Differences'
=> 'Differences',

   'Diffs'
=> 'Diffs',

   'Diffs with Current Version'
=> 'Diffs with Current Version',

   'Diffs with Version'
=> 'Diffs with Version',

   'Diffs with current Version'
=> 'Diffs with current Version',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)',

   'Disable all communication among students'
=> 'Disable all communication among students',

   'Disable display of problem receipts'
=> 'Disable display of problem receipts',

   'Disable student resource discussion'
=> 'Disable student resource discussion',

   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',

   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',

   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',

   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',

   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',

   'Discard Edits and View'
=> 'Discard Edits and View',

   'Discard Selected'
=> 'Discard Selected',

   'Discussion Contributions'
=> 'Discussion Contributions',

   'Discussion Participation'
=> 'Discussion Participation',

   'Discussions'
=> 'Discussions',

   'Display'
=> 'Display',

   'Display All Messages'
=> 'Display All Messages',

   'Display all Messages'
=> 'Display all Messages',

   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments.',

   'Display file attributes'
=> 'Display file attributes',

   'Display foils in order given'
=> 'Display foils in order given',

   'Display foils in random order'
=> 'Display foils in random order',

   'Distribute Messages from Uploaded File to Course'
=> 'Distribute Messages from Uploaded File to Course',

   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',

   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',

   'DoDiff'
=> 'DoDiff',

   'Domain'
=> 'Domain',

   'Domain Coordinator'
=> 'Domain Coordinator',

   'Domain Guest'
=> 'Domain Guest',

   'Domain Level'
=> 'Domain Level',

   'Domain only - use limited to courses in the domain'
=> 'Domain only - use limited to courses in the domain',

   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Done'
=> 'Done',

   'Drop Students'
=> 'Drop Students',

   'Drop/Add students in this course'
=> 'Drop/Add students in this course',

   'Dropped [_1]'
=> 'Dropped [_1]',

   'Dropped [_1] student(s).'
=> 'Dropped [_1] student(s).',

   'Dropping Students'
=> 'Dropping Students',

   'Due'
=> 'Due',

   'Due Date (contentclose)'
=> 'Due Date (contentclose)',

   'Due Date (duedate)'
=> 'Due Date (duedate)',

   'Dump Course DOCS'
=> 'Dump Course DOCS',

   'Dump Course DOCS to Construction Space'
=> 'Dump Course DOCS to Construction Space',

   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',

   'Dynamic Metadata'
=> 'Dynamic Metadata',

   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',

   'EMail Address'
=> 'EMail Address',

   'EMail and Messages'
=> 'EMail and Messages',

   'ERROR'
=> 'ERROR',

   'Edit'
=> 'Edit',

   'Edit Catalog Information'
=> 'Edit Catalog Information',

   'Edit Content of a Map'
=> 'Edit Content of a Map',

   'Edit Custom Role Privileges'
=> 'Edit Custom Role Privileges',

   'Edit Directory Catalog Information'
=> 'Edit Directory Catalog Information',

   'Edit and view documents included in this course'
=> 'Edit and view documents included in this course',

   'Edit this resource'
=> 'Edit this resource',

   'Edit/Modify DOCS'
=> 'Edit/Modify DOCS',

   'EditXML'
=> 'EditXML',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.',

   'Empty'
=> 'Empty',

   'Enclosing Map or Folder'
=> 'Enclosing Map or Folder',

   'End'
=> 'End',

   'End Helper'
=> 'End Helper',

   'End Time'
=> 'End Time',

   'Ending Date'
=> 'Ending Date',

   'English - ISO'
=> 'English - ISO',

   'Enroll One Student'
=> 'Enroll One Student',

   'Enroll a single student'
=> 'Enroll a single student',

   'Enroll as student'
=> 'Enroll as student',

   'Enrolling'
=> 'Enrolling',

   'Enrolling Student'
=> 'Enrolling Student',

   'Enrolling Students'
=> 'Enrolling Students',

   'Enrollment Manager'
=> 'Enrollment Manager',

   'Enrollment Status'
=> 'Enrollment Status',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',

   'Enter construction space as a co-author'
=> 'Enter construction space as a co-author',

   'Enter grades from check-out assessment resources'
=> 'Enter grades from check-out assessment resources',

   'Enter my resource construction space'
=> 'Enter my resource construction space',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Enter terms or phrases separated by search operators such as AND, OR, or NOT',

   'Enter the chatroom for the course'
=> 'Enter the chatroom for the course',

   'Entering Construction Space'
=> 'Entering Construction Space',

   'Entering course ...'
=> 'Entering course ...',

   'Error'
=> 'Error',

   'Error Messages'
=> 'Error Messages',

   'Error dropping [_1]:[_2]'
=> 'Error dropping [_1]:[_2]',

   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',

   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',

   'Essay, open end'
=> 'Essay, open end',

   'Evaluate Resource'
=> 'Evaluate Resource',

   'Evaluation Comments'
=> 'Evaluation Comments',

   'Evaluation Data'
=> 'Evaluation Data',

   'Evaluation Error '
=> 'Evaluation Error ',

   'Every problem in a particular folder'
=> 'Every problem in a particular folder',

   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',

   'Every problem in the course'
=> 'Every problem in the course',

   'Exam Information'
=> 'Exam Information',

   'Exam Problem'
=> 'Exam Problem',

   'Exam Proctor'
=> 'Exam Proctor',

   'Excel'
=> 'Excel',

   'Excel format'
=> 'Excel format',

   'Excused by instructor'
=> 'Excused by instructor',

   'Exit'
=> 'Exit',

   'Exit LON-CAPA'
=> 'Exit LON-CAPA',

   'Extent'
=> 'Extent',

   'External Resource'
=> 'External Resource',

   'FAIL'
=> 'FAIL',

   'Failed Access to Construction Space'
=> 'Failed Access to Construction Space',

   'Failed to copy source'
=> 'Failed to copy source',

   'Failed to write metadata copy'
=> 'Failed to write metadata copy',

   'False'
=> 'False',

   'February'
=> 'February',

   'Feedback Addresses for Course Content'
=> 'Feedback Addresses for Course Content',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',

   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',

   'Field'
=> 'Field',

   'Fielded Format'
=> 'Fielded Format',

   'File'
=> 'File',

   'File Category'
=> 'File Category',

   'File copied.'
=> 'File copied.',

   'Filenames in Construction Space'
=> 'Filenames in Construction Space',

   'Finalize Publication'
=> 'Finalize Publication',

   'Finish Course Initialization'
=> 'Finish Course Initialization',

   'Finish Helper'
=> 'Finish Helper',

   'First'
=> 'First',

   'First Name'
=> 'First Name',

   'First Resource'
=> 'First Resource',

   'Foil'
=> 'Foil',

   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',

   'Foils'
=> 'Foils',

   'Folder'
=> 'Folder',

   'Folder in Construction Space'
=> 'Folder in Construction Space',

   'Folder/Map'
=> 'Folder/Map',

   'For User'
=> 'For User',

   'For one or more students'
=> 'For one or more students',

   'Force publication of unmodified files'
=> 'Force publication of unmodified files',

   'Format:'
=> 'Format:',

   'Forward'
=> 'Forward',

   'Forwarded message from'
=> 'Forwarded message from',

   'Forwarding'
=> 'Forwarding',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.',

   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',

   'Frequency'
=> 'Frequency',

   'Fri'
=> 'Fri',

   'From'
=> 'From',

   'Full Update'
=> 'Full Update',

   'Full update (also print list of users not enrolled anymore)'
=> 'Full update (also print list of users not enrolled anymore)',

   'Functions'
=> 'Functions',

   'Generate Spreadsheet'
=> 'Generate Spreadsheet',

   'Generate Statistics'
=> 'Generate Statistics',

   'Generate messages from a file'
=> 'Generate messages from a file',

   'Generate new role ...'
=> 'Generate new role ...',

   'Generation'
=> 'Generation',

   'German - ISO'
=> 'German - ISO',

   'Getting Problem Variants'
=> 'Getting Problem Variants',

   'Go'
=> 'Go',

   'Go Back'
=> 'Go Back',

   'Go To My First Homework Problem'
=> 'Go To My First Homework Problem',

   'Go to ...'
=> 'Go to ...',

   'Go to the next resource in the course sequence'
=> 'Go to the next resource in the course sequence',

   'Go to the previous resource in the course sequence'
=> 'Go to the previous resource in the course sequence',

   'Goodbye'
=> 'Goodbye',

   'Grades Spreadsheet'
=> 'Grades Spreadsheet',

   'Grading'
=> 'Grading',

   'Grading Information'
=> 'Grading Information',

   'Grant/revoke Course Custom Role'
=> 'Grant/revoke Course Custom Role',

   'Grant/revoke role of Administrator'
=> 'Grant/revoke role of Administrator',

   'Grant/revoke role of Author'
=> 'Grant/revoke role of Author',

   'Grant/revoke role of Co-Author'
=> 'Grant/revoke role of Co-Author',

   'Grant/revoke role of Course Coordinator'
=> 'Grant/revoke role of Course Coordinator',

   'Grant/revoke role of Domain Coordinator'
=> 'Grant/revoke role of Domain Coordinator',

   'Grant/revoke role of Domain Guest'
=> 'Grant/revoke role of Domain Guest',

   'Grant/revoke role of Exam Proctor'
=> 'Grant/revoke role of Exam Proctor',

   'Grant/revoke role of Instructor'
=> 'Grant/revoke role of Instructor',

   'Grant/revoke role of Librarian'
=> 'Grant/revoke role of Librarian',

   'Grant/revoke role of Scantron Operator'
=> 'Grant/revoke role of Scantron Operator',

   'Grant/revoke role of Student'
=> 'Grant/revoke role of Student',

   'Grant/revoke role of Superuser'
=> 'Grant/revoke role of Superuser',

   'Grant/revoke role of Teaching Assistant'
=> 'Grant/revoke role of Teaching Assistant',

   'Group/Section'
=> 'Group/Section',

   'HTML'
=> 'HTML',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',

   'HTML in Discussions'
=> 'HTML in Discussions',

   'HTML/XML'
=> 'HTML/XML',

   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Height(pixel):'
=> 'Height(pixel):',

   'Help'
=> 'Help',

   'Help on Creating Courses'
=> 'Help on Creating Courses',

   'Helproom Hours'
=> 'Helproom Hours',

   'Hide'
=> 'Hide',

   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',

   'Hint Text'
=> 'Hint Text',

   'Home Server'
=> 'Home Server',

   'Homework problem'
=> 'Homework problem',

   'Host'
=> 'Host',

   'How do I create a CSV file from a spreadsheet'
=> 'How do I create a CSV file from a spreadsheet',

   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',

   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',

   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',

   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',

   'How should the results be printed?'
=> 'How should the results be printed?',

   'ID/Student Number'
=> 'ID/Student Number',

   'Identify fields'
=> 'Identify fields',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA.',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible.',

   'Ignore First Line'
=> 'Ignore First Line',

   'Illegal filename.'
=> 'Illegal filename.',

   'Image:'
=> 'Image:',

   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',

   'Import'
=> 'Import',

   'Import a published document'
=> 'Import a published document',

   'Import and Paste Area'
=> 'Import and Paste Area',

   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',

   'Incorrect'
=> 'Incorrect',

   'Incorrect Answers:'
=> 'Incorrect Answers:',

   'Initial Password'
=> 'Initial Password',

   'Institutional Information'
=> 'Institutional Information',

   'Instructor'
=> 'Instructor',

   'Instructor Information'
=> 'Instructor Information',

   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',

   'Internal Filename'
=> 'Internal Filename',

   'Internally authenticated'
=> 'Internally authenticated',

   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',

   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',

   'Invalid date entry'
=> 'Invalid date entry',

   'Invalid home server specified'
=> 'Invalid home server specified',

   'Invalid login mode or password.'
=> 'Invalid login mode or password.',

   'Invalid username or domain'
=> 'Invalid username or domain',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'It is recommended that you use an up-to-date virus scanner before handling this file.',

   'January'
=> 'January',

   'Japanese - UTF'
=> 'Japanese - UTF',

   'July'
=> 'July',

   'June'
=> 'June',

   'KEYWORDS'
=> 'KEYWORDS',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default)',

   'Kerberos authenticated'
=> 'Kerberos authenticated',

   'Keyword(s)'
=> 'Keyword(s)',

   'Keywords'
=> 'Keywords',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA Domain for Students',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager',

   'LON-CAPA Helper:'
=> 'LON-CAPA Helper:',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA domain: [_1]',

   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',

   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'LaTeX mode:'
=> 'LaTeX mode:',

   'Language'
=> 'Language',

   'Languages used'
=> 'Languages used',

   'Last'
=> 'Last',

   'Last Modified'
=> 'Last Modified',

   'Last Name'
=> 'Last Name',

   'Last Name, First Names'
=> 'Last Name, First Names',

   'Last Week'
=> 'Last Week',

   'Last access'
=> 'Last access',

   'Last accessed'
=> 'Last accessed',

   'Last modified'
=> 'Last modified',

   'Last updated'
=> 'Last updated',

   'Launch Remote Control'
=> 'Launch Remote Control',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',

   'Librarian'
=> 'Librarian',

   'Limit by copyright/distribution'
=> 'Limit by copyright/distribution',

   'Limit by language'
=> 'Limit by language',

   'List Directory'
=> 'List Directory',

   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',

   'List of possible answers'
=> 'List of possible answers',

   'Load'
=> 'Load',

   'Load Map'
=> 'Load Map',

   'Load:'
=> 'Load:',

   'Location'
=> 'Location',

   'Lock and unlock assessments'
=> 'Lock and unlock assessments',

   'Log in'
=> 'Log in',

   'Logged Out'
=> 'Logged Out',

   'Login Data'
=> 'Login Data',

   'Login Type'
=> 'Login Type',

   'Logout'
=> 'Logout',

   'MIME Type'
=> 'MIME Type',

   'Mail'
=> 'Mail',

   'Main Course Documents'
=> 'Main Course Documents',

   'Main Menu'
=> 'Main Menu',

   'Make new directory'
=> 'Make new directory',

   'Make new file'
=> 'Make new file',

   'Make notes and annotations about this resource'
=> 'Make notes and annotations about this resource',

   'Making Backup to'
=> 'Making Backup to',

   'Manage Access Keys'
=> 'Manage Access Keys',

   'Manage access keys'
=> 'Manage access keys',

   'Manual Grading'
=> 'Manual Grading',

   'Map'
=> 'Map',

   'Map contents are not shown in order.'
=> 'Map contents are not shown in order.',

   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',

   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',

   'March'
=> 'March',

   'Mark Unread'
=> 'Mark Unread',

   'Material appears to be correct'
=> 'Material appears to be correct',

   'Material covered with sufficient depth'
=> 'Material covered with sufficient depth',

   'Material is helpful'
=> 'Material is helpful',

   'Material presented in clear way'
=> 'Material presented in clear way',

   'Max Number Of Shown Foils:'
=> 'Max Number Of Shown Foils:',

   'Max Possible To Date'
=> 'Max Possible To Date',

   'Max Tries'
=> 'Max Tries',

   'Max number of foils displayed'
=> 'Max number of foils displayed',

   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',

   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',

   'May'
=> 'May',

   'Mean Tries'
=> 'Mean Tries',

   'Messaging'
=> 'Messaging',

   'Metadata'
=> 'Metadata',

   'Metadata Information'
=> 'Metadata Information',

   'Metadata Version'
=> 'Metadata Version',

   'Metadata current version'
=> 'Metadata current version',

   'Middle'
=> 'Middle',

   'Middle Name'
=> 'Middle Name',

   'Middle Names/Initials'
=> 'Middle Names/Initials',

   'Mime type'
=> 'Mime type',

   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',

   'Modification Date'
=> 'Modification Date',

   'Modification may make assessment data inaccessible'
=> 'Modification may make assessment data inaccessible',

   'Modified'
=> 'Modified',

   'Modify Course Assessment Parameters'
=> 'Modify Course Assessment Parameters',

   'Modify Enrollment for'
=> 'Modify Enrollment for',

   'Modify Parameters'
=> 'Modify Parameters',

   'Modify User'
=> 'Modify User',

   'Modify another students data'
=> 'Modify another students data',

   'Modify authentication mechanism and data for a user'
=> 'Modify authentication mechanism and data for a user',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modify deadlines, etc, for this assessment resource',

   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',

   'Modify grades'
=> 'Modify grades',

   'Modify student data'
=> 'Modify student data',

   'Modify user grades for this assessment resource'
=> 'Modify user grades for this assessment resource',

   'Modifying data for user'
=> 'Modifying data for user',

   'Modifying this will make problems'
=> 'Modifying this will make problems',

   'Mon'
=> 'Mon',

   'Most recently published Version'
=> 'Most recently published Version',

   'Move Down'
=> 'Move Down',

   'Move Up'
=> 'Move Up',

   'Move current file to'
=> 'Move current file to',

   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',

   'My Personal Info'
=> 'My Personal Info',

   'Name'
=> 'Name',

   'Name of Role'
=> 'Name of Role',

   'Name starting with'
=> 'Name starting with',

   'Name:'
=> 'Name:',

   'Navigate'
=> 'Navigate',

   'Navigate Contents'
=> 'Navigate Contents',

   'Navigate Course Contents'
=> 'Navigate Course Contents',

   'Navigate the table of contents for this course'
=> 'Navigate the table of contents for this course',

   'Network-wide number of accesses (hits)'
=> 'Network-wide number of accesses (hits)',

   'Network-wide number of courses using resource'
=> 'Network-wide number of courses using resource',

   'New Directory'
=> 'New Directory',

   'New Folder'
=> 'New Folder',

   'New HTML file'
=> 'New HTML file',

   'New Messages'
=> 'New Messages',

   'New Problem Variation'
=> 'New Problem Variation',

   'New Randomization'
=> 'New Randomization',

   'New Resource'
=> 'New Resource',

   'New Role'
=> 'New Role',

   'New Search'
=> 'New Search',

   'New Title'
=> 'New Title',

   'New User'
=> 'New User',

   'New Value'
=> 'New Value',

   'New assembled page'
=> 'New assembled page',

   'New assembled sequence'
=> 'New assembled sequence',

   'New custom rights file'
=> 'New custom rights file',

   'New discussion since'
=> 'New discussion since',

   'New file'
=> 'New file',

   'New parameters or stored values'
=> 'New parameters or stored values',

   'New problem'
=> 'New problem',

   'New style file'
=> 'New style file',

   'New subdirectory'
=> 'New subdirectory',

   'Next'
=> 'Next',

   'Next    '
=> 'Next    ',

   'Next ->'
=> 'Next ->',

   'Next Month'
=> 'Next Month',

   'No'
=> 'No',

   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',

   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',

   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',

   'No Kerberos domain was specified.'
=> 'No Kerberos domain was specified.',

   'No Role, Cumulative Privileges'
=> 'No Role, Cumulative Privileges',

   'No changes were made to the current settings.'
=> 'No changes were made to the current settings.',

   'No content modifications yet.'
=> 'No content modifications yet.',

   'No due date'
=> 'No due date',

   'No language preference'
=> 'No language preference',

   'No new filename specified.'
=> 'No new filename specified.',

   'No previous versions published.'
=> 'No previous versions published.',

   'No role specified'
=> 'No role specified',

   'No section assigned'
=> 'No section assigned',

   'No such file'
=> 'No such file',

   'No upload file specified.'
=> 'No upload file specified.',

   'No write permission to'
=> 'No write permission to',

   'No write permission to user directory, FAIL'
=> 'No write permission to user directory, FAIL',

   'None Found'
=> 'None Found',

   'Not Allowed'
=> 'Not Allowed',

   'Not applicable - '
=> 'Not applicable - ',

   'Not open to be viewed'
=> 'Not open to be viewed',

   'Not set - '
=> 'Not set - ',

   'Not shown, not used'
=> 'Not shown, not used',

   'Note: for large courses, this operation may be time consuming'
=> 'Note: for large courses, this operation may be time consuming',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Note: it can take up to 10 minutes for changes to take effect for all users.',

   'Note: this will not take effect if the user already exists'
=> 'Note: this will not take effect if the user already exists',

   'Notes'
=> 'Notes',

   'Notification of enrollment changes'
=> 'Notification of enrollment changes',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'November'
=> 'November',

   'Number of Plots:'
=> 'Number of Plots:',

   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',

   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Number of bubbles in exam mode (numbubbles)',

   'Number of columns'
=> 'Number of columns',

   'Number of resources that follow this resource in maps'
=> 'Number of resources that follow this resource in maps',

   'Number of resources that lead up to this resource in maps'
=> 'Number of resources that lead up to this resource in maps',

   'Number of resources using or importing resource'
=> 'Number of resources using or importing resource',

   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',

   'Obsolete'
=> 'Obsolete',

   'Obsolete parameters or stored values'
=> 'Obsolete parameters or stored values',

   'October'
=> 'October',

   'Office Hours'
=> 'Office Hours',

   'Old Value'
=> 'Old Value',

   'One particular problem'
=> 'One particular problem',

   'One particular problem (overrides folder and course defaults)'
=> 'One particular problem (overrides folder and course defaults)',

   'Online Help'
=> 'Online Help',

   'Only Answers'
=> 'Only Answers',

   'Only a number required.'
=> 'Only a number required.',

   'Only domain coordinators can change a users password.'
=> 'Only domain coordinators can change a users password.',

   'Open'
=> 'Open',

   'Open All Folders'
=> 'Open All Folders',

   'Open Course'
=> 'Open Course',

   'Open all assessments'
=> 'Open all assessments',

   'Open and correct'
=> 'Open and correct',

   'Open with full tries'
=> 'Open with full tries',

   'Open, no due date'
=> 'Open, no due date',

   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',

   'Opening Date (opendate)'
=> 'Opening Date (opendate)',

   'Option Response Problem Analysis'
=> 'Option Response Problem Analysis',

   'Option response'
=> 'Option response',

   'Output'
=> 'Output',

   'Output Format'
=> 'Output Format',

   'Output Format: [_1]'
=> 'Output Format: [_1]',

   'Overall Problem Statistics'
=> 'Overall Problem Statistics',

   'Owner/Publisher'
=> 'Owner/Publisher',

   'Page'
=> 'Page',

   'Page layout'
=> 'Page layout',

   'Paper type'
=> 'Paper type',

   'Parameter'
=> 'Parameter',

   'Parameter Name'
=> 'Parameter Name',

   'Parameter Type'
=> 'Parameter Type',

   'Parameter in Effect'
=> 'Parameter in Effect',

   'Parent Directory'
=> 'Parent Directory',

   'Part'
=> 'Part',

   'Part Description (display)'
=> 'Part Description (display)',

   'Part is not open to be viewed. It'
=> 'Part is not open to be viewed. It',

   'Password'
=> 'Password',

   'Paste after selected'
=> 'Paste after selected',

   'Path'
=> 'Path',

   'Per Page'
=> 'Per Page',

   'Personal Data'
=> 'Personal Data',

   'Personal Information'
=> 'Personal Information',

   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',

   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',

   'Please do not reply to this address.'
=> 'Please do not reply to this address.',

   'Please either'
=> 'Please either',

   'Please notify the server administrator '
=> 'Please notify the server administrator ',

   'Please pick a version to retrieve'
=> 'Please pick a version to retrieve',

   'Please select a problem to analyze'
=> 'Please select a problem to analyze',

   'Please select a report to generate'
=> 'Please select a report to generate',

   'Please select a report to generate.'
=> 'Please select a report to generate.',

   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',

   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',

   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',

   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',

   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',

   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',

   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',

   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',

   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',

   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',

   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',

   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',

   'Please stand by.'
=> 'Please stand by.',

   'Please use browser "Back" button and pick a filename'
=> 'Please use browser "Back" button and pick a filename',

   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",

   'Portuguese - ISO'
=> 'Portuguese - ISO',

   'Position'
=> 'Position',

   'Post anonymously'
=> 'Post anonymously',

   'Post discussion on course resources'
=> 'Post discussion on course resources',

   'Post system frontpage announcements'
=> 'Post system frontpage announcements',

   'Post to live chatrooms'
=> 'Post to live chatrooms',

   'Preferred language'
=> 'Preferred language',

   'Prepare a printable document'
=> 'Prepare a printable document',

   'Preparing Excel Spreadsheet'
=> 'Preparing Excel Spreadsheet',

   'Preparing Printout'
=> 'Preparing Printout',

   'Prerequisites'
=> 'Prerequisites',

   'Previous'
=> 'Previous',

   'Previous Month'
=> 'Previous Month',

   'Print'
=> 'Print',

   'Print Index:'
=> 'Print Index:',

   'Print Table of Contents:'
=> 'Print Table of Contents:',

   'Print:'
=> 'Print:',

   'Printing Helper'
=> 'Printing Helper',

   'Privacy Note'
=> 'Privacy Note',

   'Private - visible to author only for testing purposes'
=> 'Private - visible to author only for testing purposes',

   'Private Publication - did not synchronize database'
=> 'Private Publication - did not synchronize database',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',

   'Problem Status Chart'
=> 'Problem Status Chart',

   'Problems'
=> 'Problems',

   'Problems Not Contained In A Folder'
=> 'Problems Not Contained In A Folder',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.',

   'Problems from entire course'
=> 'Problems from entire course',

   'Processed [_1] student(s).'
=> 'Processed [_1] student(s).',

   'Processed file'
=> 'Processed file',

   'Processing'
=> 'Processing',

   'Processing course structure'
=> 'Processing course structure',

   'Processing first student'
=> 'Processing first student',

   'Produce Excel Output'
=> 'Produce Excel Output',

   'Project Information'
=> 'Project Information',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Provide feedback messages or contribute to the course discussion about this resource',

   'Provide my evaluation of this resource'
=> 'Provide my evaluation of this resource',

   'Public - no authentication or authorization required for use'
=> 'Public - no authentication or authorization required for use',

   'Publish'
=> 'Publish',

   'Publish Directory'
=> 'Publish Directory',

   'Publish Directory and Sub Directories'
=> 'Publish Directory and Sub Directories',

   'Publish this Resource'
=> 'Publish this Resource',

   'Published'
=> 'Published',

   'Publisher/Owner'
=> 'Publisher/Owner',

   'Publishing'
=> 'Publishing',

   'Question Text'
=> 'Question Text',

   'Question Type'
=> 'Question Type',

   'Question Type (type)'
=> 'Question Type (type)',

   'Quick Completed Problems Display'
=> 'Quick Completed Problems Display',

   'Random position'
=> 'Random position',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',

   'Randomization algorithm used'
=> 'Randomization algorithm used',

   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',

   'Re'
=> 'Re',

   'Re-Initialize'
=> 'Re-Initialize',

   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data.',

   'Reading results from'
=> 'Reading results from',

   'Reading results from [_1]'
=> 'Reading results from [_1]',

   'Readings'
=> 'Readings',

   'Receipt algorithm used'
=> 'Receipt algorithm used',

   'Receiving results from [_1]'
=> 'Receiving results from [_1]',

   'Recent'
=> 'Recent',

   'Record'
=> 'Record',

   'Registering'
=> 'Registering',

   'Related'
=> 'Related',

   'Remark'
=> 'Remark',

   'Rename'
=> 'Rename',

   'Rename current file to'
=> 'Rename current file to',

   'Reply'
=> 'Reply',

   'Report a Bug'
=> 'Report a Bug',

   'Reset Submissions'
=> 'Reset Submissions',

   'Resource'
=> 'Resource',

   'Resource Differences'
=> 'Resource Differences',

   'Resource Feedback and Discussion'
=> 'Resource Feedback and Discussion',

   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',

   'Resource Level'
=> 'Resource Level',

   'Resource Publication'
=> 'Resource Publication',

   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',

   'Resource is technically correct'
=> 'Resource is technically correct',

   'Resources'
=> 'Resources',

   'Resources from selected sequence in course'
=> 'Resources from selected sequence in course',

   'Response'
=> 'Response',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'Retrieval of an old version will overwrite the file currently in construction space',

   'Retrieve'
=> 'Retrieve',

   'Retrieve Old Version'
=> 'Retrieve Old Version',

   'Retrieve Published Resources'
=> 'Retrieve Published Resources',

   'Retrieve previous versions of'
=> 'Retrieve previous versions of',

   'Retrieve version'
=> 'Retrieve version',

   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',

   'Return to DOCS'
=> 'Return to DOCS',

   'Return to Last Location'
=> 'Return to Last Location',

   'Reverse Association'
=> 'Reverse Association',

   'Revert to Last Saved'
=> 'Revert to Last Saved',

   'Revision Date'
=> 'Revision Date',

   'Revoke'
=> 'Revoke',

   'Revoke Existing Roles'
=> 'Revoke Existing Roles',

   'Role'
=> 'Role',

   'Role Information'
=> 'Role Information',

   'Row'
=> 'Row',

   'Rule'
=> 'Rule',

   'Russian - KOI'
=> 'Russian - KOI',

   'S.D. tries'
=> 'S.D. tries',

   'Sample Points:'
=> 'Sample Points:',

   'Samples'
=> 'Samples',

   'Sat'
=> 'Sat',

   'Save'
=> 'Save',

   'Save as'
=> 'Save as',

   'Save as & Make This Sheet the Default'
=> 'Save as & Make This Sheet the Default',

   'Save as ...'
=> 'Save as ...',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',

   'Saving Modifications to'
=> 'Saving Modifications to',

   'Scantron Operator'
=> 'Scantron Operator',

   'Score Upload Form'
=> 'Score Upload Form',

   'Search'
=> 'Search',

   'Search Complete'
=> 'Search Complete',

   'Search Complete [_1]'
=> 'Search Complete [_1]',

   'Search the contents of this course'
=> 'Search the contents of this course',

   'Search the database of published resources'
=> 'Search the database of published resources',

   'Search: [_1]'
=> 'Search: [_1]',

   'Searching'
=> 'Searching',

   'Section'
=> 'Section',

   'Section/Group'
=> 'Section/Group',

   'Sections'
=> 'Sections',

   'Select'
=> 'Select',

   'Select Action'
=> 'Select Action',

   'Select All'
=> 'Select All',

   'Select All Files'
=> 'Select All Files',

   'Select All Published'
=> 'Select All Published',

   'Select All Resources'
=> 'Select All Resources',

   'Select All Students'
=> 'Select All Students',

   'Select Course'
=> 'Select Course',

   'Select Date'
=> 'Select Date',

   'Select Enclosing Map or Folder'
=> 'Select Enclosing Map or Folder',

   'Select Folder'
=> 'Select Folder',

   'Select Map'
=> 'Select Map',

   'Select Only Current Students'
=> 'Select Only Current Students',

   'Select Parameter Level'
=> 'Select Parameter Level',

   'Select Printing Options:'
=> 'Select Printing Options:',

   'Select Problem'
=> 'Select Problem',

   'Select Problem(s) to print'
=> 'Select Problem(s) to print',

   'Select Resource(s) to print'
=> 'Select Resource(s) to print',

   'Select Resources To Print'
=> 'Select Resources To Print',

   'Select Section'
=> 'Select Section',

   'Select Sequence To Print From'
=> 'Select Sequence To Print From',

   'Select Spreadsheet File'
=> 'Select Spreadsheet File',

   'Select Student'
=> 'Select Student',

   'Select Students and Resources'
=> 'Select Students and Resources',

   'Select Style File'
=> 'Select Style File',

   'Select User'
=> 'Select User',

   'Select a'
=> 'Select a',

   'Select a course'
=> 'Select a course',

   'Select a user name to modify the students information'
=> 'Select a user name to modify the students information',

   'Select a user name to view the users personal page.'
=> 'Select a user name to view the users personal page.',

   'Select for Section/Group'
=> 'Select for Section/Group',

   'Select resources for the assignment'
=> 'Select resources for the assignment',

   'Select the Construction Space'
=> 'Select the Construction Space',

   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',

   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',

   'Selecting a User'
=> 'Selecting a User',

   'Send Message to User(s)'
=> 'Send Message to User(s)',

   'Send New'
=> 'Send New',

   'Send Reply'
=> 'Send Reply',

   'Send Scantron data to a course'
=> 'Send Scantron data to a course',

   'Send and receive messages'
=> 'Send and receive messages',

   'Send as critical message'
=> 'Send as critical message',

   'Send broadcast and receipt-required email'
=> 'Send broadcast and receipt-required email',

   'Send internal email'
=> 'Send internal email',

   'September'
=> 'September',

   'Sequence'
=> 'Sequence',

   'Sequence or Folder'
=> 'Sequence or Folder',

   'Sequences and Folders'
=> 'Sequences and Folders',

   'Server'
=> 'Server',

   'Server Administration'
=> 'Server Administration',

   'Set'
=> 'Set',

   'Set Course Environment'
=> 'Set Course Environment',

   'Set Course Environment Parameters'
=> 'Set Course Environment Parameters',

   'Set Date'
=> 'Set Date',

   'Set Defaults for All Resources in Course'
=> 'Set Defaults for All Resources in Course',

   'Set End Date'
=> 'Set End Date',

   'Set Individual User Roles'
=> 'Set Individual User Roles',

   'Set Problem Tries'
=> 'Set Problem Tries',

   'Set Problem Weight'
=> 'Set Problem Weight',

   'Set Start Date'
=> 'Set Start Date',

   'Set Version to be used in Course'
=> 'Set Version to be used in Course',

   'Set Versions to be used in Course according to Selections below'
=> 'Set Versions to be used in Course according to Selections below',

   'Set a bookmark for this resource'
=> 'Set a bookmark for this resource',

   'Set a due date'
=> 'Set a due date',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions)',

   'Set an answer open date'
=> 'Set an answer open date',

   'Set an open date'
=> 'Set an open date',

   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',

   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',

   'Set answer open date for the selected problem for ...'
=> 'Set answer open date for the selected problem for ...',

   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',

   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Set deadlines and other assessment parameters, as well as modify course environment',

   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',

   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',

   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',

   'Set my user preferences'
=> 'Set my user preferences',

   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',

   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',

   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',

   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',

   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',

   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',

   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',

   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . .',

   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',

   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',

   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',

   'Set the number of tries'
=> 'Set the number of tries',

   'Set the problem weight'
=> 'Set the problem weight',

   'Set to ...'
=> 'Set to ...',

   'Set value to "[_1]" to allow'
=> 'Set value to "[_1]" to allow',

   'Set/Modify Course Assessment Parameter'
=> 'Set/Modify Course Assessment Parameter',

   'Set/Modify Course Assessment Parameters'
=> 'Set/Modify Course Assessment Parameters',

   'Set/Modify Course Parameters'
=> 'Set/Modify Course Parameters',

   'Setting the [_1]'
=> 'Setting the [_1]',

   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',

   'Shared by course faculty and staff'
=> 'Shared by course faculty and staff',

   'Short string response'
=> 'Short string response',

   'Show Answer'
=> 'Show Answer',

   'Show Feedback'
=> 'Show Feedback',

   'Show More Options'
=> 'Show More Options',

   'Show Only Uncompleted Homework'
=> 'Show Only Uncompleted Homework',

   'Show Preview'
=> 'Show Preview',

   'Show Problem Completeness'
=> 'Show Problem Completeness',

   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',

   'Show all roles'
=> 'Show all roles',

   'Show all rles'
=> 'Show all rles',

   'Show always at bottom position'
=> 'Show always at bottom position',

   'Show always at top position'
=> 'Show always at top position',

   'Show catalog information'
=> 'Show catalog information',

   'Show resource'
=> 'Show resource',

   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Significant figures are incorrect, submission was not graded.'
=> 'Significant figures are incorrect, submission was not graded.',

   'Simple Edit'
=> 'Simple Edit',

   'Simple Page'
=> 'Simple Page',

   'Simple Problem'
=> 'Simple Problem',

   'Simple Problem Editor'
=> 'Simple Problem Editor',

   'Since Start of Course'
=> 'Since Start of Course',

   'Since Yesterday'
=> 'Since Yesterday',

   'Size'
=> 'Size',

   'Size:'
=> 'Size:',

   'Skew Tries'
=> 'Skew Tries',

   'Some items were not submitted'
=> 'Some items were not submitted',

   'Some parts were not submitted.'
=> 'Some parts were not submitted.',

   'Space separated'
=> 'Space separated',

   'Special Documents'
=> 'Special Documents',

   'Special documents'
=> 'Special documents',

   'Spreadsheet Computation'
=> 'Spreadsheet Computation',

   'Spreadsheet Computation Status'
=> 'Spreadsheet Computation Status',

   'Start'
=> 'Start',

   'Start Time'
=> 'Start Time',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",

   'Starting'
=> 'Starting',

   'Starting Date'
=> 'Starting Date',

   'Starting and Ending Dates'
=> 'Starting and Ending Dates',

   'Statistics'
=> 'Statistics',

   'Statistics and Problem Analysis'
=> 'Statistics and Problem Analysis',

   'Status'
=> 'Status',

   'Store'
=> 'Store',

   'Store Catalog Information'
=> 'Store Catalog Information',

   'Store Changes'
=> 'Store Changes',

   'Store uploaded file as '
=> 'Store uploaded file as ',

   'Student'
=> 'Student',

   'Student Data Compilation Progress'
=> 'Student Data Compilation Progress',

   'Student Data Compilation Status'
=> 'Student Data Compilation Status',

   'Student ID'
=> 'Student ID',

   'Student Information'
=> 'Student Information',

   'Student Name'
=> 'Student Name',

   'Student Number'
=> 'Student Number',

   'Student Sheet Links'
=> 'Student Sheet Links',

   'Student Status'
=> 'Student Status',

   'Student Status: [_1]'
=> 'Student Status: [_1]',

   'Student information updated successfully.'
=> 'Student information updated successfully.',

   'Student level sheet'
=> 'Student level sheet',

   'Student performance statistics on all problems.'
=> 'Student performance statistics on all problems.',

   'Students Affected'
=> 'Students Affected',

   'Students need access key to enter course'
=> 'Students need access key to enter course',

   'Students with expired roles'
=> 'Students with expired roles',

   'Subject'
=> 'Subject',

   'Subject:'
=> 'Subject:',

   'Submission Time Analysis'
=> 'Submission Time Analysis',

   'Submissions'
=> 'Submissions',

   'Submit'
=> 'Submit',

   'Submit Answer'
=> 'Submit Answer',

   'Submit Changes'
=> 'Submit Changes',

   'Submit Changes and Edit'
=> 'Submit Changes and Edit',

   'Submit Changes and View'
=> 'Submit Changes and View',

   'Submit Modifications'
=> 'Submit Modifications',

   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',

   'Successful Login'
=> 'Successful Login',

   'Suggested Replacement for Obsolete File'
=> 'Suggested Replacement for Obsolete File',

   'Summary'
=> 'Summary',

   'Summary View'
=> 'Summary View',

   'Sun'
=> 'Sun',

   'Supplemental Course Documents'
=> 'Supplemental Course Documents',

   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',

   'Switch Server'
=> 'Switch Server',

   'Switch to another course'
=> 'Switch to another course',

   'Switch to another user role'
=> 'Switch to another user role',

   'Switching Role'
=> 'Switching Role',

   'Syllabus'
=> 'Syllabus',

   'Synchronized SQL metadata database'
=> 'Synchronized SQL metadata database',

   'System'
=> 'System',

   'System Administration'
=> 'System Administration',

   'System Level'
=> 'System Level',

   'System wide - can be used for any courses system wide'
=> 'System wide - can be used for any courses system wide',

   'System wide - open source to all authors'
=> 'System wide - open source to all authors',

   'Tabulator separated'
=> 'Tabulator separated',

   'Target'
=> 'Target',

   'Target Edit Map'
=> 'Target Edit Map',

   'Task'
=> 'Task',

   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',

   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',

   'TeXWidth(mm):'
=> 'TeXWidth(mm):',

   'Teaching Assistant'
=> 'Teaching Assistant',

   'Template'
=> 'Template',

   'Temporary Assembly Workspace'
=> 'Temporary Assembly Workspace',

   'Text'
=> 'Text',

   'Text Block'
=> 'Text Block',

   'Textbook'
=> 'Textbook',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.',

   'The error reported was'
=> 'The error reported was',

   'The extension on this file'
=> 'The extension on this file',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'The filetype extension of the file you uploaded is not allowed.',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.',

   'The optional email address field was not specified.'
=> 'The optional email address field was not specified.',

   'The optional name field was not specified.'
=> 'The optional name field was not specified.',

   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified.',

   'The optional student number field was not specified.'
=> 'The optional student number field was not specified.',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',

   'The requested file'
=> 'The requested file',

   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',

   'The submitted answer was too long.'
=> 'The submitted answer was too long.',

   'The target is an existing directory.'
=> 'The target is an existing directory.',

   'Then'
=> 'Then',

   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',

   'There are currently no results'
=> 'There are currently no results',

   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',

   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',

   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',

   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',

   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',

   'There are no students currently enrolled.'
=> 'There are no students currently enrolled.',

   'There are no students in the course.'
=> 'There are no students in the course.',

   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',

   'There is no student data for this problem.'
=> 'There is no student data for this problem.',

   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',

   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'This is an automatic message generated by the LON-CAPA system.',

   'This question expects a numeric answer.'
=> 'This question expects a numeric answer.',

   'This resource has been marked obsolete by the author(s)'
=> 'This resource has been marked obsolete by the author(s)',

   'This syllabus can be publicly viewed at'
=> 'This syllabus can be publicly viewed at',

   'Threaded View'
=> 'Threaded View',

   'Thu'
=> 'Thu',

   'Time'
=> 'Time',

   'Title'
=> 'Title',

   'To'
=> 'To',

   'To create a new'
=> 'To create a new',

   'Top Level Map'
=> 'Top Level Map',

   'Topic'
=> 'Topic',

   'Total'
=> 'Total',

   'Total Parts In Course'
=> 'Total Parts In Course',

   'Total number of records found in file: [_1].'
=> 'Total number of records found in file: [_1].',

   'Total number of students who have worked on this problem'
=> 'Total number of students who have worked on this problem',

   'Tries'
=> 'Tries',

   'True'
=> 'True',

   'Tue'
=> 'Tue',

   'Turkish - ISO'
=> 'Turkish - ISO',

   'Type'
=> 'Type',

   'Type Name Here'
=> 'Type Name Here',

   'Type in value'
=> 'Type in value',

   'Type-in value'
=> 'Type-in value',

   'Type:'
=> 'Type:',

   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',

   'UNIX authenticated'
=> 'UNIX authenticated',

   'URL'
=> 'URL',

   'URLs To Include in Syllabus'
=> 'URLs To Include in Syllabus',

   'USERS'
=> 'USERS',

   'Unable to connect to database!'
=> 'Unable to connect to database!',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Unable to determine if this resource is open due to network problems. Please try again later.',

   'Unable to enroll'
=> 'Unable to enroll',

   'Unable to enroll students'
=> 'Unable to enroll students',

   'Unable to find'
=> 'Unable to find',

   'Unable to make backup'
=> 'Unable to make backup',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',

   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',

   'Unable to set default dates for course'
=> 'Unable to set default dates for course',

   'Unable to understand formula'
=> 'Unable to understand formula',

   'Unable to undo, unable to switch'
=> 'Unable to undo, unable to switch',

   'Unable to write to'
=> 'Unable to write to',

   'Unavailable course'
=> 'Unavailable course',

   'Uncheck All'
=> 'Uncheck All',

   'Uncompleted Homework'
=> 'Uncompleted Homework',

   'Undetermined - ISO'
=> 'Undetermined - ISO',

   'Undid changes, Switched'
=> 'Undid changes, Switched',

   'Unit:'
=> 'Unit:',

   'Units incorrect.'
=> 'Units incorrect.',

   'Units required'
=> 'Units required',

   'Unknown Action'
=> 'Unknown Action',

   'Unknown ID'
=> 'Unknown ID',

   'Unknown message'
=> 'Unknown message',

   'Unknown user'
=> 'Unknown user',

   'Unpublished'
=> 'Unpublished',

   'Unselect All'
=> 'Unselect All',

   'Unselect All Files'
=> 'Unselect All Files',

   'Unselect All Published'
=> 'Unselect All Published',

   'Unselect All Resources'
=> 'Unselect All Resources',

   'Unselect All Students'
=> 'Unselect All Students',

   'Unselect for Section/Group'
=> 'Unselect for Section/Group',

   'Unsuccessful Login'
=> 'Unsuccessful Login',

   'Unsupported character combination'
=> 'Unsupported character combination',

   'Up'
=> 'Up',

   'Update Course Assessment Parameter Display'
=> 'Update Course Assessment Parameter Display',

   'Update Display'
=> 'Update Display',

   'Update Section or Specific User'
=> 'Update Section or Specific User',

   'Update Student Data'
=> 'Update Student Data',

   'Updating discussion time'
=> 'Updating discussion time',

   'Upload Document'
=> 'Upload Document',

   'Upload Scantron data'
=> 'Upload Scantron data',

   'Upload a Photo'
=> 'Upload a Photo',

   'Upload a class list'
=> 'Upload a class list',

   'Upload a new main course document'
=> 'Upload a new main course document',

   'Upload a new supplemental course document'
=> 'Upload a new supplemental course document',

   'Upload class list'
=> 'Upload class list',

   'Upload file'
=> 'Upload file',

   'Upload file to Construction Space'
=> 'Upload file to Construction Space',

   'Uploaded'
=> 'Uploaded',

   'Uploaded Document'
=> 'Uploaded Document',

   'Uploading Class List'
=> 'Uploading Class List',

   'Use or edit my bookmark collection'
=> 'Use or edit my bookmark collection',

   'User'
=> 'User',

   'User Load'
=> 'User Load',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'User Notes, Records of Face-to-Face Discussions, and Critical Messages',

   'User Role'
=> 'User Role',

   'User Roles'
=> 'User Roles',

   'Username'
=> 'Username',

   'Users with Roles Assigned by'
=> 'Users with Roles Assigned by',

   'VIEW'
=> 'VIEW',

   'Value'
=> 'Value',

   'Verify Content'
=> 'Verify Content',

   'Verify Course Documents'
=> 'Verify Course Documents',

   'Verify Selection'
=> 'Verify Selection',

   'Version'
=> 'Version',

   'Version Number'
=> 'Version Number',

   'Version changes since Yesterday'
=> 'Version changes since Yesterday',

   'Version changes since last Month'
=> 'Version changes since last Month',

   'Version changes since last Week'
=> 'Version changes since last Week',

   'Version changes since start of Course'
=> 'Version changes since start of Course',

   'Version used in Course'
=> 'Version used in Course',

   'View'
=> 'View',

   'View All Messages'
=> 'View All Messages',

   'View Class List'
=> 'View Class List',

   'View Critical Messages'
=> 'View Critical Messages',

   'View Published Version'
=> 'View Published Version',

   'View course assessment statistics'
=> 'View course assessment statistics',

   'View documents included in this course'
=> 'View documents included in this course',

   'View file'
=> 'View file',

   'View the FAQ'
=> 'View the FAQ',

   'View the course assessment progress chart'
=> 'View the course assessment progress chart',

   'View user submissions for this assessment resource'
=> 'View user submissions for this assessment resource',

   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',

   'Warning!'
=> 'Warning!',

   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',

   'Warning: target file exists!'
=> 'Warning: target file exists!',

   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',

   'Was due'
=> 'Was due',

   'Web Links'
=> 'Web Links',

   'Web References'
=> 'Web References',

   'Wed'
=> 'Wed',

   'Weight (weight)'
=> 'Weight (weight)',

   'Welcome'
=> 'Welcome',

   'Welcome to Your New LON-CAPA Course'
=> 'Welcome to Your New LON-CAPA Course',

   'Welcome to the Assignment Parameter Helper'
=> 'Welcome to the Assignment Parameter Helper',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up',

   'What parameter do you want to set for all problems in the course?'
=> 'What parameter do you want to set for all problems in the course?',

   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',

   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',

   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',

   'What should the due date be set to?'
=> 'What should the due date be set to?',

   'What should the opening date be set to?'
=> 'What should the opening date be set to?',

   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',

   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',

   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',

   'Which Problem or Problems?'
=> 'Which Problem or Problems?',

   'Which problems do you wish to set a parameter for?'
=> 'Which problems do you wish to set a parameter for?',

   'Width'
=> 'Width',

   'Width(pixel):'
=> 'Width(pixel):',

   'With Answers'
=> 'With Answers',

   'Without Answers'
=> 'Without Answers',

   'Words'
=> 'Words',

   'Wrote Metadata'
=> 'Wrote Metadata',

   'XML/SGML'
=> 'XML/SGML',

   'Yes'
=> 'Yes',

   'You are correct.'
=> 'You are correct.',

   'You are excused from the problem.'
=> 'You are excused from the problem.',

   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',

   'You did not select a template.'
=> 'You did not select a template.',

   'You do not have authoring privileges for this resource'
=> 'You do not have authoring privileges for this resource',

   'You have entered that answer before'
=> 'You have entered that answer before',

   'You have no critical messages.'
=> 'You have no critical messages.',

   'You have no unread messages'
=> 'You have no unread messages',

   'You have provided an invalid ranking'
=> 'You have provided an invalid ranking',

   'You must choose an authentication type.'
=> 'You must choose an authentication type.',

   'You must choose at least one student to continue.'
=> 'You must choose at least one student to continue.',

   'You must choose one or more choices to continue.'
=> 'You must choose one or more choices to continue.',

   'You need to choose another user role or enter a specific course for this function'
=> 'You need to choose another user role or enter a specific course for this function',

   'You need to specify the Kerberos domain.'
=> 'You need to specify the Kerberos domain.',

   'You need to specify the initial password.'
=> 'You need to specify the initial password.',

   'You need to specify the username field.'
=> 'You need to specify the username field.',

   'Your Excel Spreadsheet'
=> 'Your Excel Spreadsheet',

   'Your Version Settings have been Stored'
=> 'Your Version Settings have been Stored',

   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.',

   'Your home server is '
=> 'Your home server is ',

   'Your receipt is'
=> 'Your receipt is',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',

   'Your submission has been recorded.'
=> 'Your submission has been recorded.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',

   '[_1] Do not change login data'
=> '[_1] Do not change login data',

   '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])'
=> '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2])',

   '[_1] Internally authenticated (mit Anfangspasswort [_2])'
=> '[_1] Internally authenticated (mit Anfangspasswort [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Internally authenticated (with initial password [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local Authentication with arguement [_2]',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',

   '[_1] Records per Page'
=> '[_1] Records per Page',

   '[_1] minutes'
=> '[_1] minutes',

   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',

   '[_1] with value [_2]'
=> '[_1] with value [_2]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',

   '[_2] seconds'
=> '[_2] seconds',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',

   'a.m.'
=> 'a.m.',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'abstract'
=> 'abstract',

   'acc keys'
=> 'acc keys',

   'acc keys[_1]'
=> 'acc keys[_1]',

   'access denied'
=> 'access denied',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'according to course preferences'
=> 'according to course preferences',

   'according to resource settings'
=> 'according to resource settings',

   'according to user session state'
=> 'according to user session state',

   'after selected'
=> 'after selected',

   'all'
=> 'all',

   'all resources in the course'
=> 'all resources in the course',

   'all students in course'
=> 'all students in course',

   'an indeterminate date'
=> 'an indeterminate date',

   'an unknown date'
=> 'an unknown date',

   'and'
=> 'and',

   'and return receipt'
=> 'and return receipt',

   'anno-'
=> 'anno-',

   'anno-[_1]'
=> 'anno-[_1]',

   'anno.gif'
=> 'anno.gif',

   'announce'
=> 'announce',

   'announce[_1]'
=> 'announce[_1]',

   'anonymous'
=> 'anonymous',

   'anonymous students'
=> 'anonymous students',

   'anot.gif'
=> 'anot.gif',

   'answer date'
=> 'answer date',

   'at'
=> 'at',

   'at Domain'
=> 'at Domain',

   'at domain'
=> 'at domain',

   'audio'
=> 'audio',

   'author'
=> 'author',

   'backward'
=> 'backward',

   'backward[_1]'
=> 'backward[_1]',

   'bchat.gif'
=> 'bchat.gif',

   'between'
=> 'between',

   'bookmark'
=> 'bookmark',

   'bookmark[_1]'
=> 'bookmark[_1]',

   'bookmark[_2]'
=> 'bookmark[_2]',

   'button'
=> 'button',

   'by'
=> 'by',

   'bytes'
=> 'bytes',

   'calendar'
=> 'calendar',

   'calendar[_1]'
=> 'calendar[_1]',

   'can not be accessed from your location.'
=> 'can not be accessed from your location.',

   'catalog'
=> 'catalog',

   'catalog.gif'
=> 'catalog.gif',

   'catalog[_1]'
=> 'catalog[_1]',

   'ccrs.gif'
=> 'ccrs.gif',

   'changes will not show until next login'
=> 'changes will not show until next login',

   'chart'
=> 'chart',

   'chart[_1]'
=> 'chart[_1]',

   'chat'
=> 'chat',

   'chat[_1]'
=> 'chat[_1]',

   'check all'
=> 'check all',

   'chmod error'
=> 'chmod error',

   'choose'
=> 'choose',

   'choose[_1]'
=> 'choose[_1]',

   'choose[_2]'
=> 'choose[_2]',

   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'click on the',

   'close this window'
=> 'close this window',

   'co con-'
=> 'co con-',

   'co con-[_1]'
=> 'co con-[_1]',

   'co res'
=> 'co res',

   'co res[_1]'
=> 'co res[_1]',

   'com.gif'
=> 'com.gif',

   'commu-'
=> 'commu-',

   'commu-[_1]'
=> 'commu-[_1]',

   'con-'
=> 'con-',

   'con-[_1]'
=> 'con-[_1]',

   'connection down'
=> 'connection down',

   'contacting'
=> 'contacting',

   'contacting [_1]'
=> 'contacting [_1]',

   'contents'
=> 'contents',

   'contents[_1]'
=> 'contents[_1]',

   'copy Error'
=> 'copy Error',

   'copyright'
=> 'copyright',

   'could not be copied.'
=> 'could not be copied.',

   'course'
=> 'course',

   'course[_10]'
=> 'course[_10]',

   'course[_11]'
=> 'course[_11]',

   'course[_1]'
=> 'course[_1]',

   'course[_2]'
=> 'course[_2]',

   'course[_3]'
=> 'course[_3]',

   'course[_4]'
=> 'course[_4]',

   'course[_5]'
=> 'course[_5]',

   'course[_6]'
=> 'course[_6]',

   'course[_7]'
=> 'course[_7]',

   'course[_8]'
=> 'course[_8]',

   'course[_9]'
=> 'course[_9]',

   'courses.gif'
=> 'courses.gif',

   'cprv.gif'
=> 'cprv.gif',

   'create'
=> 'create',

   'create[_1]'
=> 'create[_1]',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'currently does not exist',

   'custom'
=> 'custom',

   'custom distribution file'
=> 'custom distribution file',

   'customdistributionfile'
=> 'customdistributionfile',

   'date_am'
=> 'date_am',

   'date_days'
=> 'date_days',

   'date_locale'
=> 'date_locale',

   'date_months'
=> 'date_months',

   'date_pm'
=> 'date_pm',

   'default'
=> 'default',

   'directory'
=> 'directory',

   'discuss'
=> 'discuss',

   'discuss[_1]'
=> 'discuss[_1]',

   'docs'
=> 'docs',

   'docs.gif'
=> 'docs.gif',

   'docs[_1]'
=> 'docs[_1]',

   'docs[_2]'
=> 'docs[_2]',

   'domain'
=> 'domain',

   'due date'
=> 'due date',

   'during the last'
=> 'during the last',

   'edit'
=> 'edit',

   'edit crs'
=> 'edit crs',

   'edit crs[_1]'
=> 'edit crs[_1]',

   'egrd.gif'
=> 'egrd.gif',

   'ences'
=> 'ences',

   'ences[_1]'
=> 'ences[_1]',

   'enrl.gif'
=> 'enrl.gif',

   'enroll'
=> 'enroll',

   'enroll[_1]'
=> 'enroll[_1]',

   'enter'
=> 'enter',

   'enter[_1]'
=> 'enter[_1]',

   'eval.gif'
=> 'eval.gif',

   'evaluate'
=> 'evaluate',

   'evaluate[_1]'
=> 'evaluate[_1]',

   'exit'
=> 'exit',

   'exit[_1]'
=> 'exit[_1]',

   'expired or revoked'
=> 'expired or revoked',

   'extension'
=> 'extension',

   'external'
=> 'external',

   'fas'
=> 'fas',

   'fdbk.gif'
=> 'fdbk.gif',

   'feedback'
=> 'feedback',

   'feedback[_1]'
=> 'feedback[_1]',

   'file<br />extension'
=> 'file<br />extension',

   'first name'
=> 'first name',

   'for'
=> 'for',

   'for <b>all resources in the course</b>'
=> 'for <b>all resources in the course</b>',

   'for <b>all students in course</b>'
=> 'for <b>all students in course</b>',

   'for Enclosing Map or Folder'
=> 'for Enclosing Map or Folder',

   'for Resource'
=> 'for Resource',

   'for [_1]'
=> 'for [_1]',

   'for section [_1]'
=> 'for section [_1]',

   'for the map named [_1]'
=> 'for the map named [_1]',

   'for the resource named [_1]'
=> 'for the resource named [_1]',

   'for visible separation'
=> 'for visible separation',

   'forward'
=> 'forward',

   'forward[_1]'
=> 'forward[_1]',

   'from'
=> 'from',

   'from Enclosing Map or Folder'
=> 'from Enclosing Map or Folder',

   'from current subdirectory'
=> 'from current subdirectory',

   'general'
=> 'general',

   'generation'
=> 'generation',

   'grades'
=> 'grades',

   'grades[_1]'
=> 'grades[_1]',

   'grades[_2]'
=> 'grades[_2]',

   'grds.gif'
=> 'grds.gif',

   'have different numbers and answers'
=> 'have different numbers and answers',

   'helper'
=> 'helper',

   'htmlarea_lang'
=> 'htmlarea_lang',

   'in'
=> 'in',

   'in Course'
=> 'in Course',

   'in Section/Group'
=> 'in Section/Group',

   'in domain'
=> 'in domain',

   'info'
=> 'info',

   'instructor'
=> 'instructor',

   'interface available'
=> 'interface available',

   'internal'
=> 'internal',

   'is closed but you are allowed to view it'
=> 'is closed but you are allowed to view it',

   'is due at'
=> 'is due at',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',

   'is in under construction'
=> 'is in under construction',

   'is not analyzable at this time'
=> 'is not analyzable at this time',

   'is ready for download'
=> 'is ready for download',

   'keys.gif'
=> 'keys.gif',

   'keywords'
=> 'keywords',

   'language'
=> 'language',

   'last month'
=> 'last month',

   'last name'
=> 'last name',

   'last problem'
=> 'last problem',

   'last six months'
=> 'last six months',

   'last student'
=> 'last student',

   'last three months'
=> 'last three months',

   'last week'
=> 'last week',

   'last year'
=> 'last year',

   'library'
=> 'library',

   'library[_1]'
=> 'library[_1]',

   'log in again'
=> 'log in again',

   'loginproblems.html'
=> 'loginproblems.html',

   'logout.gif'
=> 'logout.gif',

   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',

   'manage'
=> 'manage',

   'manage[_1]'
=> 'manage[_1]',

   'may be open from a different computer.'
=> 'may be open from a different computer.',

   'may open later.'
=> 'may open later.',

   'middle name'
=> 'middle name',

   'midnight'
=> 'midnight',

   'minutes'
=> 'minutes',

   'missions'
=> 'missions',

   'most recent'
=> 'most recent',

   'movies'
=> 'movies',

   'my'
=> 'my',

   'my[_1]'
=> 'my[_1]',

   'name'
=> 'name',

   'name only visible to course faculty'
=> 'name only visible to course faculty',

   'nav.gif'
=> 'nav.gif',

   'navigate'
=> 'navigate',

   'navigate[_1]'
=> 'navigate[_1]',

   'never'
=> 'never',

   'nication'
=> 'nication',

   'nication[_1]'
=> 'nication[_1]',

   'no ending date'
=> 'no ending date',

   'noon'
=> 'noon',

   'not displayed'
=> 'not displayed',

   'not found'
=> 'not found',

   'notes'
=> 'notes',

   'num_override'
=> 'num_override',

   'number'
=> 'number',

   'number of tries'
=> 'number of tries',

   'obsolete'
=> 'obsolete',

   'obsolete replacement'
=> 'obsolete replacement',

   'obsoletereplacement'
=> 'obsoletereplacement',

   'of'
=> 'of',

   'only check if you know what you are doing'
=> 'only check if you know what you are doing',

   'only search domain'
=> 'only search domain',

   'opening date'
=> 'opening date',

   'optional'
=> 'optional',

   'or'
=> 'or',

   'or ID'
=> 'or ID',

   'or any other value'
=> 'or any other value',

   'p.m.'
=> 'p.m.',

   'pages'
=> 'pages',

   'parm.gif'
=> 'parm.gif',

   'parms'
=> 'parms',

   'parms[_1]'
=> 'parms[_1]',

   'part'
=> 'part',

   'percent'
=> 'percent',

   'pictures'
=> 'pictures',

   'please refer to'
=> 'please refer to',

   'pref.gif'
=> 'pref.gif',

   'prefer-'
=> 'prefer-',

   'prefer-[_1]'
=> 'prefer-[_1]',

   'prepare'
=> 'prepare',

   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',

   'printout'
=> 'printout',

   'private'
=> 'private',

   'problem'
=> 'problem',

   'problem statistics grouped by sequence'
=> 'problem statistics grouped by sequence',

   'problem statistics ungrouped'
=> 'problem statistics ungrouped',

   'problem statistics, Excel'
=> 'problem statistics, Excel',

   'problem weight'
=> 'problem weight',

   'prt.gif'
=> 'prt.gif',

   'public'
=> 'public',

   'publisher<br />owner'
=> 'publisher<br />owner',

   're-initializing course'
=> 're-initializing course',

   'remaining'
=> 'remaining',

   'res.gif'
=> 'res.gif',

   'resource'
=> 'resource',

   'resource[_1]'
=> 'resource[_1]',

   'resources'
=> 'resources',

   'role'
=> 'role',

   'role,role,...'
=> 'role,role,...',

   'role[_1]'
=> 'role[_1]',

   'role[_2]'
=> 'role[_2]',

   'roles'
=> 'roles',

   'roles.gif'
=> 'roles.gif',

   'roles[_1]'
=> 'roles[_1]',

   'sbkm.gif'
=> 'sbkm.gif',

   'scantron[_1]'
=> 'scantron[_1]',

   'search'
=> 'search',

   'search[_1]'
=> 'search[_1]',

   'search[_2]'
=> 'search[_2]',

   'second'
=> 'second',

   'seconds'
=> 'seconds',

   'seconds for'
=> 'seconds for',

   'section'
=> 'section',

   'selected students'
=> 'selected students',

   'send[_1]'
=> 'send[_1]',

   'sequence'
=> 'sequence',

   'set'
=> 'set',

   'set[_1]'
=> 'set[_1]',

   'space'
=> 'space',

   'space[_1]'
=> 'space[_1]',

   'space[_2]'
=> 'space[_2]',

   'spacer.gif'
=> 'spacer.gif',

   'spellcheck_lang'
=> 'spellcheck_lang',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'standard'
=> 'standard',

   'standard LaTeX mode'
=> 'standard LaTeX mode',

   'standard courses only'
=> 'standard courses only',

   'stat.gif'
=> 'stat.gif',

   'stats'
=> 'stats',

   'stats[_1]'
=> 'stats[_1]',

   'struct'
=> 'struct',

   'struct[_1]'
=> 'struct[_1]',

   'struct[_2]'
=> 'struct[_2]',

   'student'
=> 'student',

   'student name'
=> 'student name',

   'subject'
=> 'subject',

   'switch'
=> 'switch',

   'switch[_1]'
=> 'switch[_1]',

   'switch[_2]'
=> 'switch[_2]',

   'system wide'
=> 'system wide',

   'tations'
=> 'tations',

   'template'
=> 'template',

   'textual_remote_display'
=> 'textual_remote_display',

   'this'
=> 'this',

   'title'
=> 'title',

   'to'
=> 'to',

   'to [_1] ([_2])'
=> 'to [_1] ([_2])',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',

   'today'
=> 'today',

   'unable to enroll'
=> 'unable to enroll',

   'uncheck all'
=> 'uncheck all',

   'undo'
=> 'undo',

   'unless locked'
=> 'unless locked',

   'untitled'
=> 'untitled',

   'updated periodically'
=> 'updated periodically',

   'use related words'
=> 'use related words',

   'user'
=> 'user',

   'user[_1]'
=> 'user[_1]',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'username'
=> 'username',

   'users in'
=> 'users in',

   'vbkm.gif'
=> 'vbkm.gif',

   'versions of this problem'
=> 'versions of this problem',

   'versus'
=> 'versus',

   'view'
=> 'view',

   'view sub-'
=> 'view sub-',

   'view[_1]'
=> 'view[_1]',

   'visible to author and co-authors only'
=> 'visible to author and co-authors only',

   'waiting on'
=> 'waiting on',

   'waiting on [_1]'
=> 'waiting on [_1]',

   'warning(s)'
=> 'warning(s)',

   'was due on'
=> 'was due on',

   'what you just saw on the screen'
=> 'what you just saw on the screen',

   'will open on'
=> 'will open on',

   'with server'
=> 'with server',

   'yes'
=> 'yes',



#SYNC Tue Aug 15 14:43:20 2006
   ' [_1]'
=> ' [_1]',

   '"[_1]" for default hiding'
=> '"[_1]" for default hiding',

   '"[_1]" for visible separation'
=> '"[_1]" for visible separation',

   '"[_1]" if allowed, anything else if not'
=> '"[_1]" if allowed, anything else if not',

   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',

   '# 16 Aug 14:45'
=> '# 16 Aug 14:45',

   '# Do not translate this line.  [_1] is a check box'
=> '# Do not translate this line.  [_1] is a check box',

   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field',

   '# Do not translate this line.  [_1] is a column index.'
=> '# Do not translate this line.  [_1] is a column index.',

   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Do not translate this line.  [_1] is a drop-down box listing domains.',

   '# Do not translate this line.  [_1] is a username'
=> '# Do not translate this line.  [_1] is a username',

   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Do not translate this line.  [_1] is the number of students processed',

   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.',

   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Do not translate this line.  [_1] is username, [_2] is error message',

   '# Do not translate this line.  [_1] is username@domain'
=> '# Do not translate this line.  [_1] is username@domain',

   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Do not translate this line.  [_1] is username@domain [_2] is the error message.',

   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Do not translate this line.  [_1], [_3], and [_4] are check boxes',

   '# Do not translate this line.  [_2] is a text entry element'
=> '# Do not translate this line.  [_2] is a text entry element',

   '# [_1] is a drop-down selection box'
=> '# [_1] is a drop-down selection box',

   '# [_1] is a number [_2] is the current domain'
=> '# [_1] is a number [_2] is the current domain',

   '# [_1] is an html link to the current file '
=> '# [_1] is an html link to the current file ',

   '# _1 is a selection dialog'
=> '# _1 is a selection dialog',

   '# _1 is a server name'
=> '# _1 is a server name',

   '# _1 is search string'
=> '# _1 is search string',

   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'",

   '#Stdnts'
=> '#Stdnts',

   '#YES'
=> '#YES',

   '#[_1] is the foil name'
=> '#[_1] is the foil name',

   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 is the foil name, _2 is the current value of the foil',

   '%Wrng'
=> '%Wrng',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Show&nbsp;All&nbsp;Foils',

   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.',

   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.',

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',

   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',

   ', and answers will be available on'
=> ', and answers will be available on',

   ', is reserved internally by LON-CAPA.'
=> ', is reserved internally by LON-CAPA.',

   ', or the next time you log in.'
=> ', or the next time you log in.',

   ', select a template from the pull-down menu below'
=> ', select a template from the pull-down menu below',

   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',

   '. . . for a particular section'
=> '. . . for a particular section',

   '. . . for all students in the course'
=> '. . . for all students in the course',

   '. . . for an individual student'
=> '. . . for an individual student',

   '1 am'
=> '1 am',

   '1 minute'
=> '1 minute',

   '1 out of N multiple choice (radio button)'
=> '1 out of N multiple choice (radio button)',

   '1 pm'
=> '1 pm',

   '10 am'
=> '10 am',

   '10 pm'
=> '10 pm',

   '11 am'
=> '11 am',

   '11 pm'
=> '11 pm',

   '12 am'
=> '12 am',

   '12 noon'
=> '12 noon',

   '2 am'
=> '2 am',

   '2 pm'
=> '2 pm',

   '3 am'
=> '3 am',

   '3 pm'
=> '3 pm',

   '4 am'
=> '4 am',

   '4 pm'
=> '4 pm',

   '5 am'
=> '5 am',

   '5 pm'
=> '5 pm',

   '6 am'
=> '6 am',

   '6 pm'
=> '6 pm',

   '7 am'
=> '7 am',

   '7 pm'
=> '7 pm',

   '8 am'
=> '8 am',

   '8 pm'
=> '8 pm',

   '9 am'
=> '9 am',

   '9 pm'
=> '9 pm',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',

   '<- Previous'
=> '<- Previous',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Unable to enroll: [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Unable to enroll.  No password specified.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>',

   'A score has been assigned.'
=> 'A score has been assigned.',

   'ABSTRACT'
=> 'ABSTRACT',

   'ALL'
=> 'ALL',

   'About Me'
=> 'About Me',

   'Abstract'
=> 'Abstract',

   'Access Control'
=> 'Access Control',

   'Access Key Management'
=> 'Access Key Management',

   'Access and Usage Statistics'
=> 'Access and Usage Statistics',

   'Actions'
=> 'Actions',

   'Activate'
=> 'Activate',

   'Add Roles'
=> 'Add Roles',

   'Add new option'
=> 'Add new option',

   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",

   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",

   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",

   'Additional Keywords'
=> 'Additional Keywords',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Additional Metadata (non-standard, parameters, exports)',

   'Additional Recipients'
=> 'Additional Recipients',

   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',

   'Administrator'
=> 'Administrator',

   'Advanced Catalog Search'
=> 'Advanced Catalog Search',

   'Advanced Edit'
=> 'Advanced Edit',

   'Advanced Search'
=> 'Advanced Search',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',

   'All Documents in Course'
=> 'All Documents in Course',

   'All Maps or Folders'
=> 'All Maps or Folders',

   'All Resources'
=> 'All Resources',

   'All Resources (possibly large output)'
=> 'All Resources (possibly large output)',

   'All Students'
=> 'All Students',

   'All homework is currently completed'
=> 'All homework is currently completed',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.',

   'All versions'
=> 'All versions',

   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',

   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',

   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',

   'Analyze Over '
=> 'Analyze Over ',

   'Analyze Problem'
=> 'Analyze Problem',

   'Analyze Problem Again'
=> 'Analyze Problem Again',

   'Analyze Progress'
=> 'Analyze Progress',

   'Analyze as '
=> 'Analyze as ',

   'Analyzing Results'
=> 'Analyzing Results',

   'Analyzing a problem'
=> 'Analyzing a problem',

   'Announcements and Calendar'
=> 'Announcements and Calendar',

   'Anonymous'
=> 'Anonymous',

   'Anonymous contribution to course discussion of resource'
=> 'Anonymous contribution to course discussion of resource',

   'Answer'
=> 'Answer',

   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',

   'Answer Submitted'
=> 'Answer Submitted',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',

   'Answer available'
=> 'Answer available',

   'Answer submitted'
=> 'Answer submitted',

   'Answer submitted, not yet graded'
=> 'Answer submitted, not yet graded',

   'Answer:'
=> 'Answer:',

   'Answerable'
=> 'Answerable',

   'Any Language'
=> 'Any Language',

   'Any User'
=> 'Any User',

   'Any category'
=> 'Any category',

   'Any copyright/distribution'
=> 'Any copyright/distribution',

   'April'
=> 'April',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).',

   'Assessment'
=> 'Assessment',

   'Assessment Parameters'
=> 'Assessment Parameters',

   'Assessment URL and Title'
=> 'Assessment URL and Title',

   'Assigned User Roles'
=> 'Assigned User Roles',

   'Associate columns with student attributes.'
=> 'Associate columns with student attributes.',

   'Attachment'
=> 'Attachment',

   'Attribute'
=> 'Attribute',

   'August'
=> 'August',

   'Author'
=> 'Author',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Author and Co-Author roles may not be available on servers other than your home server.',

   'Author(s)'
=> 'Author(s)',

   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',

   'Automated adds'
=> 'Automated adds',

   'Automated drops'
=> 'Automated drops',

   'Automated enrollment settings'
=> 'Automated enrollment settings',

   'Average number of tries till solved'
=> 'Average number of tries till solved',

   'Back to'
=> 'Back to',

   'Back to Directory'
=> 'Back to Directory',

   'Back to Source'
=> 'Back to Source',

   'Back to Source Directory'
=> 'Back to Source Directory',

   'Bad Filename'
=> 'Bad Filename',

   'Became this version on ...'
=> 'Became this version on ...',

   'Begin Enrollment'
=> 'Begin Enrollment',

   'Binary File'
=> 'Binary File',

   'Blank'
=> 'Blank',

   'Brief view of each students performance in course.'
=> 'Brief view of each students performance in course.',

   'Broadcast Message to Course'
=> 'Broadcast Message to Course',

   'Browse'
=> 'Browse',

   'Browse Resources'
=> 'Browse Resources',

   'Browse published resources'
=> 'Browse published resources',

   'Browse resources'
=> 'Browse resources',

   'Browsing resource, all submissions are temporary.'
=> 'Browsing resource, all submissions are temporary.',

   'Bulletin Board'
=> 'Bulletin Board',

   'Bulletin Board/Discussion'
=> 'Bulletin Board/Discussion',

   'By'
=> 'By',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (comma separated values, spreadsheet)',

   'CSV format'
=> 'CSV format',

   'Calculate answers'
=> 'Calculate answers',

   'Calculate course grades (Spreadsheet)'
=> 'Calculate course grades (Spreadsheet)',

   'Calculations'
=> 'Calculations',

   'Cancel'
=> 'Cancel',

   'Cannot publish directory'
=> 'Cannot publish directory',

   'Cannot retrieve directory'
=> 'Cannot retrieve directory',

   'Catalog Information'
=> 'Catalog Information',

   'Catalog Search'
=> 'Catalog Search',

   'Change'
=> 'Change',

   'Change Random Seed To:'
=> 'Change Random Seed To:',

   'Change User Privileges'
=> 'Change User Privileges',

   'Change Your Language Preferences'
=> 'Change Your Language Preferences',

   'Change Your Preferences'
=> 'Change Your Preferences',

   'Changed discussion view mode'
=> 'Changed discussion view mode',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Changes can take up to 10 minutes before being active for all students.',

   'Changes will become active for your current session after'
=> 'Changes will become active for your current session after',

   'Chat Participation'
=> 'Chat Participation',

   'Check All'
=> 'Check All',

   'Check Course Document Versions'
=> 'Check Course Document Versions',

   'Check for All'
=> 'Check for All',

   'Check for None'
=> 'Check for None',

   'Check for Section/Group'
=> 'Check for Section/Group',

   'Check/Set Resource Versions'
=> 'Check/Set Resource Versions',

   'Choose a different resource'
=> 'Choose a different resource',

   'Choose the course to work on'
=> 'Choose the course to work on',

   'Choose the user role'
=> 'Choose the user role',

   'Chronological View'
=> 'Chronological View',

   'Class Hours'
=> 'Class Hours',

   'Clear All'
=> 'Clear All',

   'Clear Caches'
=> 'Clear Caches',

   'Click here for FAQ'
=> 'Click here for FAQ',

   'Click here for help'
=> 'Click here for help',

   'Click here to report bugs'
=> 'Click here to report bugs',

   'Click here to return to the chart.'
=> 'Click here to return to the chart.',

   "Click to download or use your browser's Save Link function"
=> "Click to download or use your browser's Save Link function",

   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',

   'Clone an existing course'
=> 'Clone an existing course',

   'Close'
=> 'Close',

   'Close All Folders'
=> 'Close All Folders',

   'Close This Window'
=> 'Close This Window',

   'Closed'
=> 'Closed',

   'Co-Author'
=> 'Co-Author',

   'Collapse Remote Control'
=> 'Collapse Remote Control',

   'Column'
=> 'Column',

   'Column&nbsp;[_1]'
=> 'Column&nbsp;[_1]',

   'Comma Separated Values'
=> 'Comma Separated Values',

   'Communication'
=> 'Communication',

   'Communication and Messages'
=> 'Communication and Messages',

   'Compact View'
=> 'Compact View',

   'Compare versions of'
=> 'Compare versions of',

   'Completed'
=> 'Completed',

   'Completely new course'
=> 'Completely new course',

   'Concept:'
=> 'Concept:',

   'Concepts'
=> 'Concepts',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.',

   'Construction Space'
=> 'Construction Space',

   'Construction Space Directory'
=> 'Construction Space Directory',

   'Construction Space File Operation'
=> 'Construction Space File Operation',

   'Construction Space Version'
=> 'Construction Space Version',

   'Contact'
=> 'Contact',

   'Contact Information'
=> 'Contact Information',

   'Content changed'
=> 'Content changed',

   'Continue'
=> 'Continue',

   'Continue enrollment?'
=> 'Continue enrollment?',

   'Contribution to course discussion of resource'
=> 'Contribution to course discussion of resource',

   'Copied metadata'
=> 'Copied metadata',

   'Copied old metadata'
=> 'Copied old metadata',

   'Copied old target file'
=> 'Copied old target file',

   'Copied source file'
=> 'Copied source file',

   'Copy current file to'
=> 'Copy current file to',

   'Copy selected'
=> 'Copy selected',

   'Copying file'
=> 'Copying file',

   'Copyright'
=> 'Copyright',

   'Copyright/Distribution'
=> 'Copyright/Distribution',

   'Correct Option:'
=> 'Correct Option:',

   'Could Not Process Request'
=> 'Could Not Process Request',

   'Could not write metadata'
=> 'Could not write metadata',

   'Course'
=> 'Course',

   'Course Assessment Parameter - Helper Mode'
=> 'Course Assessment Parameter - Helper Mode',

   'Course Assessment Parameters - Overview Mode'
=> 'Course Assessment Parameters - Overview Mode',

   'Course Assessments Parameters - Table Mode'
=> 'Course Assessments Parameters - Table Mode',

   'Course Code'
=> 'Course Code',

   'Course Content'
=> 'Course Content',

   'Course Coordinator'
=> 'Course Coordinator',

   'Course Data'
=> 'Course Data',

   'Course Description'
=> 'Course Description',

   'Course Documents'
=> 'Course Documents',

   'Course Environment Parameters'
=> 'Course Environment Parameters',

   'Course Home Server'
=> 'Course Home Server',

   'Course ID'
=> 'Course ID',

   'Course ID or number'
=> 'Course ID or number',

   'Course ID/Number'
=> 'Course ID/Number',

   'Course Information'
=> 'Course Information',

   'Course Initialization Helper'
=> 'Course Initialization Helper',

   'Course Level'
=> 'Course Level',

   'Course Parameter Helper'
=> 'Course Parameter Helper',

   'Course Search'
=> 'Course Search',

   'Course Statistics and Charts'
=> 'Course Statistics and Charts',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.',

   'Course Title'
=> 'Course Title',

   'Course announcements and my calendar'
=> 'Course announcements and my calendar',

   'Course default for all problems'
=> 'Course default for all problems',

   'Course level sheet'
=> 'Course level sheet',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',

   'Coursepack'
=> 'Coursepack',

   'Courses'
=> 'Courses',

   'Create'
=> 'Create',

   'Create New Environment Variable'
=> 'Create New Environment Variable',

   'Create New User'
=> 'Create New User',

   'Create User'
=> 'Create User',

   'Create Users, Change User Privileges'
=> 'Create Users, Change User Privileges',

   'Create a New Course'
=> 'Create a New Course',

   'Create a new course'
=> 'Create a new course',

   'Create a user or modify the roles and privileges of a user'
=> 'Create a user or modify the roles and privileges of a user',

   'Creating a new'
=> 'Creating a new',

   'Creation Date'
=> 'Creation Date',

   'Critical Messages'
=> 'Critical Messages',

   'Crosslisted courses'
=> 'Crosslisted courses',

   'Current'
=> 'Current',

   'Current Class List'
=> 'Current Class List',

   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',

   'Current Ending Date: not set'
=> 'Current Ending Date: not set',

   'Current Month'
=> 'Current Month',

   'Current Resource'
=> 'Current Resource',

   'Current Session Value'
=> 'Current Session Value',

   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',

   'Current Starting Date: not set'
=> 'Current Starting Date: not set',

   'Current Version'
=> 'Current Version',

   'Currently no active roles or courses'
=> 'Currently no active roles or courses',

   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',

   'Currently not available'
=> 'Currently not available',

   'Currently selected. '
=> 'Currently selected. ',

   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',

   'Custom Distribution File'
=> 'Custom Distribution File',

   'Custom Role Editor'
=> 'Custom Role Editor',

   'Customized right of use ...	'
=> 'Customized right of use ...	',

   'Cut selected'
=> 'Cut selected',

   'Date'
=> 'Date',

   'Deadlines'
=> 'Deadlines',

   'December'
=> 'December',

   'Decompress'
=> 'Decompress',

   'Default'
=> 'Default',

   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',

   'Default Cataloging Information for Directory'
=> 'Default Cataloging Information for Directory',

   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',

   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',

   'Default Value'
=> 'Default Value',

   'Default XML Style File'
=> 'Default XML Style File',

   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',

   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',

   'Default for new courses is'
=> 'Default for new courses is',

   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',

   'Default:'
=> 'Default:',

   'Define Role'
=> 'Define Role',

   'Degree of difficulty'
=> 'Degree of difficulty',

   'Delete'
=> 'Delete',

   'Delete Checked'
=> 'Delete Checked',

   'Delete a role'
=> 'Delete a role',

   'Delete an option'
=> 'Delete an option',

   'Delete messages from bulletin boards'
=> 'Delete messages from bulletin boards',

   'Delete:'
=> 'Delete:',

   'Dependencies'
=> 'Dependencies',

   'Description:'
=> 'Description:',

   'Detailed Citation View'
=> 'Detailed Citation View',

   'Detailed Problem Analysis'
=> 'Detailed Problem Analysis',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Detailed statistics and graphs of student performance on problems.',

   'Differences'
=> 'Differences',

   'Diffs'
=> 'Diffs',

   'Diffs with Current Version'
=> 'Diffs with Current Version',

   'Diffs with Version'
=> 'Diffs with Version',

   'Diffs with current Version'
=> 'Diffs with current Version',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)',

   'Disable all communication among students'
=> 'Disable all communication among students',

   'Disable display of problem receipts'
=> 'Disable display of problem receipts',

   'Disable student resource discussion'
=> 'Disable student resource discussion',

   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',

   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',

   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',

   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',

   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',

   'Discard Edits and View'
=> 'Discard Edits and View',

   'Discard Selected'
=> 'Discard Selected',

   'Discussion Contributions'
=> 'Discussion Contributions',

   'Discussion Participation'
=> 'Discussion Participation',

   'Discussions'
=> 'Discussions',

   'Display'
=> 'Display',

   'Display All Messages'
=> 'Display All Messages',

   'Display all Messages'
=> 'Display all Messages',

   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments.',

   'Display file attributes'
=> 'Display file attributes',

   'Display foils in order given'
=> 'Display foils in order given',

   'Display foils in random order'
=> 'Display foils in random order',

   'Distribute Messages from Uploaded File to Course'
=> 'Distribute Messages from Uploaded File to Course',

   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',

   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',

   'DoDiff'
=> 'DoDiff',

   'Domain'
=> 'Domain',

   'Domain Coordinator'
=> 'Domain Coordinator',

   'Domain Guest'
=> 'Domain Guest',

   'Domain Level'
=> 'Domain Level',

   'Domain only - use limited to courses in the domain'
=> 'Domain only - use limited to courses in the domain',

   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Done'
=> 'Done',

   'Drop Students'
=> 'Drop Students',

   'Drop/Add students in this course'
=> 'Drop/Add students in this course',

   'Dropped [_1]'
=> 'Dropped [_1]',

   'Dropped [_1] student(s).'
=> 'Dropped [_1] student(s).',

   'Dropping Students'
=> 'Dropping Students',

   'Due'
=> 'Due',

   'Due Date (contentclose)'
=> 'Due Date (contentclose)',

   'Due Date (duedate)'
=> 'Due Date (duedate)',

   'Dump Course DOCS'
=> 'Dump Course DOCS',

   'Dump Course DOCS to Construction Space'
=> 'Dump Course DOCS to Construction Space',

   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',

   'Dynamic Metadata'
=> 'Dynamic Metadata',

   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',

   'EMail Address'
=> 'EMail Address',

   'EMail and Messages'
=> 'EMail and Messages',

   'ERROR'
=> 'ERROR',

   'Edit'
=> 'Edit',

   'Edit Catalog Information'
=> 'Edit Catalog Information',

   'Edit Content of a Map'
=> 'Edit Content of a Map',

   'Edit Custom Role Privileges'
=> 'Edit Custom Role Privileges',

   'Edit Directory Catalog Information'
=> 'Edit Directory Catalog Information',

   'Edit and view documents included in this course'
=> 'Edit and view documents included in this course',

   'Edit this resource'
=> 'Edit this resource',

   'Edit/Modify DOCS'
=> 'Edit/Modify DOCS',

   'EditXML'
=> 'EditXML',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.',

   'Empty'
=> 'Empty',

   'Enclosing Map or Folder'
=> 'Enclosing Map or Folder',

   'End'
=> 'End',

   'End Helper'
=> 'End Helper',

   'End Time'
=> 'End Time',

   'Ending Date'
=> 'Ending Date',

   'English - ISO'
=> 'English - ISO',

   'Enroll One Student'
=> 'Enroll One Student',

   'Enroll a single student'
=> 'Enroll a single student',

   'Enroll as student'
=> 'Enroll as student',

   'Enrolling'
=> 'Enrolling',

   'Enrolling Student'
=> 'Enrolling Student',

   'Enrolling Students'
=> 'Enrolling Students',

   'Enrollment Manager'
=> 'Enrollment Manager',

   'Enrollment Status'
=> 'Enrollment Status',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',

   'Enter construction space as a co-author'
=> 'Enter construction space as a co-author',

   'Enter grades from check-out assessment resources'
=> 'Enter grades from check-out assessment resources',

   'Enter my portfolio space'
=> 'Enter my portfolio space',

   'Enter my resource construction space'
=> 'Enter my resource construction space',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Enter terms or phrases separated by search operators such as AND, OR, or NOT',

   'Enter the chatroom for the course'
=> 'Enter the chatroom for the course',

   'Entering Construction Space'
=> 'Entering Construction Space',

   'Entering course ...'
=> 'Entering course ...',

   'Error'
=> 'Error',

   'Error Messages'
=> 'Error Messages',

   'Error dropping [_1]:[_2]'
=> 'Error dropping [_1]:[_2]',

   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',

   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',

   'Essay, open end'
=> 'Essay, open end',

   'Evaluate Resource'
=> 'Evaluate Resource',

   'Evaluation Comments'
=> 'Evaluation Comments',

   'Evaluation Data'
=> 'Evaluation Data',

   'Evaluation Error '
=> 'Evaluation Error ',

   'Every problem in a particular folder'
=> 'Every problem in a particular folder',

   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',

   'Every problem in the course'
=> 'Every problem in the course',

   'Exam Information'
=> 'Exam Information',

   'Exam Problem'
=> 'Exam Problem',

   'Exam Proctor'
=> 'Exam Proctor',

   'Excel'
=> 'Excel',

   'Excel format'
=> 'Excel format',

   'Excused by instructor'
=> 'Excused by instructor',

   'Exit'
=> 'Exit',

   'Exit LON-CAPA'
=> 'Exit LON-CAPA',

   'Extent'
=> 'Extent',

   'External Resource'
=> 'External Resource',

   'FAIL'
=> 'FAIL',

   'Failed Access to Construction Space'
=> 'Failed Access to Construction Space',

   'Failed to copy source'
=> 'Failed to copy source',

   'Failed to write metadata copy'
=> 'Failed to write metadata copy',

   'False'
=> 'False',

   'February'
=> 'February',

   'Feedback Addresses for Course Content'
=> 'Feedback Addresses for Course Content',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',

   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',

   'Field'
=> 'Field',

   'Fielded Format'
=> 'Fielded Format',

   'File'
=> 'File',

   'File Category'
=> 'File Category',

   'File copied.'
=> 'File copied.',

   'Filenames in Construction Space'
=> 'Filenames in Construction Space',

   'Finalize Publication'
=> 'Finalize Publication',

   'Finish Course Initialization'
=> 'Finish Course Initialization',

   'Finish Helper'
=> 'Finish Helper',

   'First'
=> 'First',

   'First Name'
=> 'First Name',

   'First Resource'
=> 'First Resource',

   'Foil'
=> 'Foil',

   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',

   'Foils'
=> 'Foils',

   'Folder'
=> 'Folder',

   'Folder in Construction Space'
=> 'Folder in Construction Space',

   'Folder/Map'
=> 'Folder/Map',

   'For User'
=> 'For User',

   'For one or more students'
=> 'For one or more students',

   'Force publication of unmodified files'
=> 'Force publication of unmodified files',

   'Format:'
=> 'Format:',

   'Forward'
=> 'Forward',

   'Forwarded message from'
=> 'Forwarded message from',

   'Forwarding'
=> 'Forwarding',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.',

   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',

   'Frequency'
=> 'Frequency',

   'Fri'
=> 'Fri',

   'From'
=> 'From',

   'Full Update'
=> 'Full Update',

   'Full update (also print list of users not enrolled anymore)'
=> 'Full update (also print list of users not enrolled anymore)',

   'Functions'
=> 'Functions',

   'Generate Spreadsheet'
=> 'Generate Spreadsheet',

   'Generate Statistics'
=> 'Generate Statistics',

   'Generate messages from a file'
=> 'Generate messages from a file',

   'Generate new role ...'
=> 'Generate new role ...',

   'Generation'
=> 'Generation',

   'German - ISO'
=> 'German - ISO',

   'Getting Problem Variants'
=> 'Getting Problem Variants',

   'Go'
=> 'Go',

   'Go Back'
=> 'Go Back',

   'Go To My First Homework Problem'
=> 'Go To My First Homework Problem',

   'Go to ...'
=> 'Go to ...',

   'Go to the next resource in the course sequence'
=> 'Go to the next resource in the course sequence',

   'Go to the previous resource in the course sequence'
=> 'Go to the previous resource in the course sequence',

   'Goodbye'
=> 'Goodbye',

   'Grades Spreadsheet'
=> 'Grades Spreadsheet',

   'Grading'
=> 'Grading',

   'Grading Information'
=> 'Grading Information',

   'Grant/revoke Course Custom Role'
=> 'Grant/revoke Course Custom Role',

   'Grant/revoke role of Administrator'
=> 'Grant/revoke role of Administrator',

   'Grant/revoke role of Author'
=> 'Grant/revoke role of Author',

   'Grant/revoke role of Co-Author'
=> 'Grant/revoke role of Co-Author',

   'Grant/revoke role of Course Coordinator'
=> 'Grant/revoke role of Course Coordinator',

   'Grant/revoke role of Domain Coordinator'
=> 'Grant/revoke role of Domain Coordinator',

   'Grant/revoke role of Domain Guest'
=> 'Grant/revoke role of Domain Guest',

   'Grant/revoke role of Exam Proctor'
=> 'Grant/revoke role of Exam Proctor',

   'Grant/revoke role of Instructor'
=> 'Grant/revoke role of Instructor',

   'Grant/revoke role of Librarian'
=> 'Grant/revoke role of Librarian',

   'Grant/revoke role of Scantron Operator'
=> 'Grant/revoke role of Scantron Operator',

   'Grant/revoke role of Student'
=> 'Grant/revoke role of Student',

   'Grant/revoke role of Superuser'
=> 'Grant/revoke role of Superuser',

   'Grant/revoke role of Teaching Assistant'
=> 'Grant/revoke role of Teaching Assistant',

   'Group/Section'
=> 'Group/Section',

   'HTML'
=> 'HTML',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',

   'HTML in Discussions'
=> 'HTML in Discussions',

   'HTML/XML'
=> 'HTML/XML',

   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Height(pixel):'
=> 'Height(pixel):',

   'Help'
=> 'Help',

   'Help on Creating Courses'
=> 'Help on Creating Courses',

   'Helproom Hours'
=> 'Helproom Hours',

   'Hide'
=> 'Hide',

   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',

   'Hint Text'
=> 'Hint Text',

   'Home Server'
=> 'Home Server',

   'Homework problem'
=> 'Homework problem',

   'Host'
=> 'Host',

   'How do I create a CSV file from a spreadsheet'
=> 'How do I create a CSV file from a spreadsheet',

   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',

   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',

   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',

   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',

   'How should the results be printed?'
=> 'How should the results be printed?',

   'ID/Student Number'
=> 'ID/Student Number',

   'Identify fields'
=> 'Identify fields',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA.',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible.',

   'Ignore First Line'
=> 'Ignore First Line',

   'Illegal filename.'
=> 'Illegal filename.',

   'Image:'
=> 'Image:',

   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',

   'Import'
=> 'Import',

   'Import a published document'
=> 'Import a published document',

   'Import and Paste Area'
=> 'Import and Paste Area',

   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',

   'Incorrect'
=> 'Incorrect',

   'Incorrect Answers:'
=> 'Incorrect Answers:',

   'Initial Password'
=> 'Initial Password',

   'Institutional Information'
=> 'Institutional Information',

   'Instructor'
=> 'Instructor',

   'Instructor Information'
=> 'Instructor Information',

   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',

   'Internal Filename'
=> 'Internal Filename',

   'Internally authenticated'
=> 'Internally authenticated',

   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',

   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',

   'Invalid date entry'
=> 'Invalid date entry',

   'Invalid home server specified'
=> 'Invalid home server specified',

   'Invalid login mode or password.'
=> 'Invalid login mode or password.',

   'Invalid username or domain'
=> 'Invalid username or domain',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'It is recommended that you use an up-to-date virus scanner before handling this file.',

   'January'
=> 'January',

   'Japanese - UTF'
=> 'Japanese - UTF',

   'July'
=> 'July',

   'June'
=> 'June',

   'KEYWORDS'
=> 'KEYWORDS',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default)',

   'Kerberos authenticated'
=> 'Kerberos authenticated',

   'Keyword(s)'
=> 'Keyword(s)',

   'Keywords'
=> 'Keywords',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA Domain for Students',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager',

   'LON-CAPA Helper:'
=> 'LON-CAPA Helper:',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA domain: [_1]',

   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',

   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'LaTeX mode:'
=> 'LaTeX mode:',

   'Language'
=> 'Language',

   'Languages used'
=> 'Languages used',

   'Last'
=> 'Last',

   'Last Modified'
=> 'Last Modified',

   'Last Name'
=> 'Last Name',

   'Last Name, First Names'
=> 'Last Name, First Names',

   'Last Week'
=> 'Last Week',

   'Last access'
=> 'Last access',

   'Last accessed'
=> 'Last accessed',

   'Last modified'
=> 'Last modified',

   'Last updated'
=> 'Last updated',

   'Launch Remote Control'
=> 'Launch Remote Control',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',

   'Librarian'
=> 'Librarian',

   'Limit by copyright/distribution'
=> 'Limit by copyright/distribution',

   'Limit by language'
=> 'Limit by language',

   'List Directory'
=> 'List Directory',

   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',

   'List of possible answers'
=> 'List of possible answers',

   'Load'
=> 'Load',

   'Load Map'
=> 'Load Map',

   'Load:'
=> 'Load:',

   'Location'
=> 'Location',

   'Lock and unlock assessments'
=> 'Lock and unlock assessments',

   'Log in'
=> 'Log in',

   'Logged Out'
=> 'Logged Out',

   'Login Data'
=> 'Login Data',

   'Login Type'
=> 'Login Type',

   'Logout'
=> 'Logout',

   'MIME Type'
=> 'MIME Type',

   'Mail'
=> 'Mail',

   'Main Course Documents'
=> 'Main Course Documents',

   'Main Menu'
=> 'Main Menu',

   'Make new directory'
=> 'Make new directory',

   'Make new file'
=> 'Make new file',

   'Make notes and annotations about this resource'
=> 'Make notes and annotations about this resource',

   'Making Backup to'
=> 'Making Backup to',

   'Manage Access Keys'
=> 'Manage Access Keys',

   'Manage access keys'
=> 'Manage access keys',

   'Manual Grading'
=> 'Manual Grading',

   'Map'
=> 'Map',

   'Map contents are not shown in order.'
=> 'Map contents are not shown in order.',

   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',

   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',

   'March'
=> 'March',

   'Mark Unread'
=> 'Mark Unread',

   'Material appears to be correct'
=> 'Material appears to be correct',

   'Material covered with sufficient depth'
=> 'Material covered with sufficient depth',

   'Material is helpful'
=> 'Material is helpful',

   'Material presented in clear way'
=> 'Material presented in clear way',

   'Max Number Of Shown Foils:'
=> 'Max Number Of Shown Foils:',

   'Max Possible To Date'
=> 'Max Possible To Date',

   'Max Tries'
=> 'Max Tries',

   'Max number of foils displayed'
=> 'Max number of foils displayed',

   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',

   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',

   'May'
=> 'May',

   'Mean Tries'
=> 'Mean Tries',

   'Messaging'
=> 'Messaging',

   'Metadata'
=> 'Metadata',

   'Metadata Information'
=> 'Metadata Information',

   'Metadata Version'
=> 'Metadata Version',

   'Metadata current version'
=> 'Metadata current version',

   'Middle'
=> 'Middle',

   'Middle Name'
=> 'Middle Name',

   'Middle Names/Initials'
=> 'Middle Names/Initials',

   'Mime type'
=> 'Mime type',

   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',

   'Modification Date'
=> 'Modification Date',

   'Modification may make assessment data inaccessible'
=> 'Modification may make assessment data inaccessible',

   'Modified'
=> 'Modified',

   'Modify Course Assessment Parameters'
=> 'Modify Course Assessment Parameters',

   'Modify Enrollment for'
=> 'Modify Enrollment for',

   'Modify Parameters'
=> 'Modify Parameters',

   'Modify User'
=> 'Modify User',

   'Modify another students data'
=> 'Modify another students data',

   'Modify authentication mechanism and data for a user'
=> 'Modify authentication mechanism and data for a user',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modify deadlines, etc, for this assessment resource',

   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',

   'Modify grades'
=> 'Modify grades',

   'Modify student data'
=> 'Modify student data',

   'Modify user grades for this assessment resource'
=> 'Modify user grades for this assessment resource',

   'Modifying data for user'
=> 'Modifying data for user',

   'Modifying this will make problems'
=> 'Modifying this will make problems',

   'Mon'
=> 'Mon',

   'Most recently published Version'
=> 'Most recently published Version',

   'Move Down'
=> 'Move Down',

   'Move Up'
=> 'Move Up',

   'Move current file to'
=> 'Move current file to',

   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',

   'My Personal Info'
=> 'My Personal Info',

   'Name'
=> 'Name',

   'Name of Role'
=> 'Name of Role',

   'Name starting with'
=> 'Name starting with',

   'Name:'
=> 'Name:',

   'Navigate'
=> 'Navigate',

   'Navigate Contents'
=> 'Navigate Contents',

   'Navigate Course Contents'
=> 'Navigate Course Contents',

   'Navigate the table of contents for this course'
=> 'Navigate the table of contents for this course',

   'Network-wide number of accesses (hits)'
=> 'Network-wide number of accesses (hits)',

   'Network-wide number of courses using resource'
=> 'Network-wide number of courses using resource',

   'New Directory'
=> 'New Directory',

   'New Folder'
=> 'New Folder',

   'New HTML file'
=> 'New HTML file',

   'New Messages'
=> 'New Messages',

   'New Problem Variation'
=> 'New Problem Variation',

   'New Randomization'
=> 'New Randomization',

   'New Resource'
=> 'New Resource',

   'New Role'
=> 'New Role',

   'New Search'
=> 'New Search',

   'New Title'
=> 'New Title',

   'New User'
=> 'New User',

   'New Value'
=> 'New Value',

   'New assembled page'
=> 'New assembled page',

   'New assembled sequence'
=> 'New assembled sequence',

   'New custom rights file'
=> 'New custom rights file',

   'New discussion since'
=> 'New discussion since',

   'New file'
=> 'New file',

   'New parameters or stored values'
=> 'New parameters or stored values',

   'New problem'
=> 'New problem',

   'New style file'
=> 'New style file',

   'New subdirectory'
=> 'New subdirectory',

   'Next'
=> 'Next',

   'Next    '
=> 'Next    ',

   'Next ->'
=> 'Next ->',

   'Next Month'
=> 'Next Month',

   'No'
=> 'No',

   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',

   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',

   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',

   'No Kerberos domain was specified.'
=> 'No Kerberos domain was specified.',

   'No Role, Cumulative Privileges'
=> 'No Role, Cumulative Privileges',

   'No changes were made to the current settings.'
=> 'No changes were made to the current settings.',

   'No content modifications yet.'
=> 'No content modifications yet.',

   'No due date'
=> 'No due date',

   'No language preference'
=> 'No language preference',

   'No new filename specified.'
=> 'No new filename specified.',

   'No previous versions published.'
=> 'No previous versions published.',

   'No role specified'
=> 'No role specified',

   'No section assigned'
=> 'No section assigned',

   'No such file'
=> 'No such file',

   'No syllabus information provided.'
=> 'No syllabus information provided.',

   'No upload file specified.'
=> 'No upload file specified.',

   'No write permission to'
=> 'No write permission to',

   'No write permission to user directory, FAIL'
=> 'No write permission to user directory, FAIL',

   'None Found'
=> 'None Found',

   'Not Allowed'
=> 'Not Allowed',

   'Not applicable - '
=> 'Not applicable - ',

   'Not open to be viewed'
=> 'Not open to be viewed',

   'Not set - '
=> 'Not set - ',

   'Not shown, not used'
=> 'Not shown, not used',

   'Note: for large courses, this operation may be time consuming'
=> 'Note: for large courses, this operation may be time consuming',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Note: it can take up to 10 minutes for changes to take effect for all users.',

   'Note: this will not take effect if the user already exists'
=> 'Note: this will not take effect if the user already exists',

   'Notes'
=> 'Notes',

   'Notification of enrollment changes'
=> 'Notification of enrollment changes',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'November'
=> 'November',

   'Number of Plots:'
=> 'Number of Plots:',

   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',

   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Number of bubbles in exam mode (numbubbles)',

   'Number of columns'
=> 'Number of columns',

   'Number of resources that follow this resource in maps'
=> 'Number of resources that follow this resource in maps',

   'Number of resources that lead up to this resource in maps'
=> 'Number of resources that lead up to this resource in maps',

   'Number of resources using or importing resource'
=> 'Number of resources using or importing resource',

   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',

   'Obsolete'
=> 'Obsolete',

   'Obsolete parameters or stored values'
=> 'Obsolete parameters or stored values',

   'October'
=> 'October',

   'Office Hours'
=> 'Office Hours',

   'Old Value'
=> 'Old Value',

   'One particular problem'
=> 'One particular problem',

   'One particular problem (overrides folder and course defaults)'
=> 'One particular problem (overrides folder and course defaults)',

   'Online Help'
=> 'Online Help',

   'Only Answers'
=> 'Only Answers',

   'Only a number required.'
=> 'Only a number required.',

   'Only domain coordinators can change a users password.'
=> 'Only domain coordinators can change a users password.',

   'Open'
=> 'Open',

   'Open All Folders'
=> 'Open All Folders',

   'Open Course'
=> 'Open Course',

   'Open all assessments'
=> 'Open all assessments',

   'Open and correct'
=> 'Open and correct',

   'Open with full tries'
=> 'Open with full tries',

   'Open, no due date'
=> 'Open, no due date',

   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',

   'Opening Date (opendate)'
=> 'Opening Date (opendate)',

   'Option Response Problem Analysis'
=> 'Option Response Problem Analysis',

   'Option response'
=> 'Option response',

   'Output'
=> 'Output',

   'Output Format'
=> 'Output Format',

   'Output Format: [_1]'
=> 'Output Format: [_1]',

   'Overall Problem Statistics'
=> 'Overall Problem Statistics',

   'Owner/Publisher'
=> 'Owner/Publisher',

   'Page'
=> 'Page',

   'Page layout'
=> 'Page layout',

   'Paper type'
=> 'Paper type',

   'Parameter'
=> 'Parameter',

   'Parameter Name'
=> 'Parameter Name',

   'Parameter Type'
=> 'Parameter Type',

   'Parameter in Effect'
=> 'Parameter in Effect',

   'Parent Directory'
=> 'Parent Directory',

   'Part'
=> 'Part',

   'Part Description (display)'
=> 'Part Description (display)',

   'Part is not open to be viewed. It'
=> 'Part is not open to be viewed. It',

   'Password'
=> 'Password',

   'Paste after selected'
=> 'Paste after selected',

   'Path'
=> 'Path',

   'Per Page'
=> 'Per Page',

   'Personal Data'
=> 'Personal Data',

   'Personal Information'
=> 'Personal Information',

   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',

   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',

   'Please do not reply to this address.'
=> 'Please do not reply to this address.',

   'Please either'
=> 'Please either',

   'Please notify the server administrator '
=> 'Please notify the server administrator ',

   'Please pick a version to retrieve'
=> 'Please pick a version to retrieve',

   'Please select a problem to analyze'
=> 'Please select a problem to analyze',

   'Please select a report to generate'
=> 'Please select a report to generate',

   'Please select a report to generate.'
=> 'Please select a report to generate.',

   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',

   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',

   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',

   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',

   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',

   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',

   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',

   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',

   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',

   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',

   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',

   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',

   'Please stand by.'
=> 'Please stand by.',

   'Please use browser "Back" button and pick a filename'
=> 'Please use browser "Back" button and pick a filename',

   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",

   'Portuguese - ISO'
=> 'Portuguese - ISO',

   'Position'
=> 'Position',

   'Post Discussion'
=> 'Post Discussion',

   'Post anonymously'
=> 'Post anonymously',

   'Post discussion on course resources'
=> 'Post discussion on course resources',

   'Post system frontpage announcements'
=> 'Post system frontpage announcements',

   'Post to live chatrooms'
=> 'Post to live chatrooms',

   'Preferred language'
=> 'Preferred language',

   'Prepare a printable document'
=> 'Prepare a printable document',

   'Preparing Excel Spreadsheet'
=> 'Preparing Excel Spreadsheet',

   'Preparing Printout'
=> 'Preparing Printout',

   'Prerequisites'
=> 'Prerequisites',

   'Previous'
=> 'Previous',

   'Previous Month'
=> 'Previous Month',

   'Print'
=> 'Print',

   'Print Index:'
=> 'Print Index:',

   'Print Table of Contents:'
=> 'Print Table of Contents:',

   'Print:'
=> 'Print:',

   'Printing Helper'
=> 'Printing Helper',

   'Privacy Note'
=> 'Privacy Note',

   'Private - visible to author only for testing purposes'
=> 'Private - visible to author only for testing purposes',

   'Private Publication - did not synchronize database'
=> 'Private Publication - did not synchronize database',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',

   'Problem Status Chart'
=> 'Problem Status Chart',

   'Problems'
=> 'Problems',

   'Problems Not Contained In A Folder'
=> 'Problems Not Contained In A Folder',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.',

   'Problems from entire course'
=> 'Problems from entire course',

   'Processed [_1] student(s).'
=> 'Processed [_1] student(s).',

   'Processed file'
=> 'Processed file',

   'Processing'
=> 'Processing',

   'Processing course structure'
=> 'Processing course structure',

   'Processing first student'
=> 'Processing first student',

   'Produce Excel Output'
=> 'Produce Excel Output',

   'Project Information'
=> 'Project Information',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Provide feedback messages or contribute to the course discussion about this resource',

   'Provide my evaluation of this resource'
=> 'Provide my evaluation of this resource',

   'Public - no authentication or authorization required for use'
=> 'Public - no authentication or authorization required for use',

   'Publish'
=> 'Publish',

   'Publish Directory'
=> 'Publish Directory',

   'Publish Directory and Sub Directories'
=> 'Publish Directory and Sub Directories',

   'Publish this Resource'
=> 'Publish this Resource',

   'Published'
=> 'Published',

   'Publisher/Owner'
=> 'Publisher/Owner',

   'Publishing'
=> 'Publishing',

   'Question Text'
=> 'Question Text',

   'Question Type'
=> 'Question Type',

   'Question Type (type)'
=> 'Question Type (type)',

   'Quick Completed Problems Display'
=> 'Quick Completed Problems Display',

   'Random position'
=> 'Random position',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',

   'Randomization algorithm used'
=> 'Randomization algorithm used',

   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',

   'Re'
=> 'Re',

   'Re-Initialize'
=> 'Re-Initialize',

   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data.',

   'Reading results from'
=> 'Reading results from',

   'Reading results from [_1]'
=> 'Reading results from [_1]',

   'Readings'
=> 'Readings',

   'Receipt algorithm used'
=> 'Receipt algorithm used',

   'Receiving results from [_1]'
=> 'Receiving results from [_1]',

   'Recent'
=> 'Recent',

   'Record'
=> 'Record',

   'Registering'
=> 'Registering',

   'Related'
=> 'Related',

   'Remark'
=> 'Remark',

   'Rename'
=> 'Rename',

   'Rename current file to'
=> 'Rename current file to',

   'Reply'
=> 'Reply',

   'Report a Bug'
=> 'Report a Bug',

   'Reset Submissions'
=> 'Reset Submissions',

   'Resource'
=> 'Resource',

   'Resource Differences'
=> 'Resource Differences',

   'Resource Feedback and Discussion'
=> 'Resource Feedback and Discussion',

   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',

   'Resource Level'
=> 'Resource Level',

   'Resource Publication'
=> 'Resource Publication',

   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',

   'Resource is technically correct'
=> 'Resource is technically correct',

   'Resources'
=> 'Resources',

   'Resources from selected sequence in course'
=> 'Resources from selected sequence in course',

   'Response'
=> 'Response',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'Retrieval of an old version will overwrite the file currently in construction space',

   'Retrieve'
=> 'Retrieve',

   'Retrieve Old Version'
=> 'Retrieve Old Version',

   'Retrieve Published Resources'
=> 'Retrieve Published Resources',

   'Retrieve previous versions of'
=> 'Retrieve previous versions of',

   'Retrieve version'
=> 'Retrieve version',

   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',

   'Return to DOCS'
=> 'Return to DOCS',

   'Return to Last Location'
=> 'Return to Last Location',

   'Reverse Association'
=> 'Reverse Association',

   'Revert to Last Saved'
=> 'Revert to Last Saved',

   'Revision Date'
=> 'Revision Date',

   'Revoke'
=> 'Revoke',

   'Revoke Existing Roles'
=> 'Revoke Existing Roles',

   'Role'
=> 'Role',

   'Role Information'
=> 'Role Information',

   'Row'
=> 'Row',

   'Rule'
=> 'Rule',

   'Russian - KOI'
=> 'Russian - KOI',

   'S.D. tries'
=> 'S.D. tries',

   'Sample Points:'
=> 'Sample Points:',

   'Samples'
=> 'Samples',

   'Sat'
=> 'Sat',

   'Save'
=> 'Save',

   'Save as'
=> 'Save as',

   'Save as & Make This Sheet the Default'
=> 'Save as & Make This Sheet the Default',

   'Save as ...'
=> 'Save as ...',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',

   'Saving Modifications to'
=> 'Saving Modifications to',

   'Scantron Operator'
=> 'Scantron Operator',

   'Score Upload Form'
=> 'Score Upload Form',

   'Search'
=> 'Search',

   'Search Complete'
=> 'Search Complete',

   'Search Complete [_1]'
=> 'Search Complete [_1]',

   'Search the contents of this course'
=> 'Search the contents of this course',

   'Search the database of published resources'
=> 'Search the database of published resources',

   'Search: [_1]'
=> 'Search: [_1]',

   'Searching'
=> 'Searching',

   'Section'
=> 'Section',

   'Section/Group'
=> 'Section/Group',

   'Sections'
=> 'Sections',

   'Select'
=> 'Select',

   'Select Action'
=> 'Select Action',

   'Select All'
=> 'Select All',

   'Select All Files'
=> 'Select All Files',

   'Select All Published'
=> 'Select All Published',

   'Select All Resources'
=> 'Select All Resources',

   'Select All Students'
=> 'Select All Students',

   'Select Course'
=> 'Select Course',

   'Select Date'
=> 'Select Date',

   'Select Enclosing Map or Folder'
=> 'Select Enclosing Map or Folder',

   'Select Folder'
=> 'Select Folder',

   'Select Map'
=> 'Select Map',

   'Select Only Current Students'
=> 'Select Only Current Students',

   'Select Parameter Level'
=> 'Select Parameter Level',

   'Select Printing Options:'
=> 'Select Printing Options:',

   'Select Problem'
=> 'Select Problem',

   'Select Problem(s) to print'
=> 'Select Problem(s) to print',

   'Select Resource(s) to print'
=> 'Select Resource(s) to print',

   'Select Resources To Print'
=> 'Select Resources To Print',

   'Select Section'
=> 'Select Section',

   'Select Sequence To Print From'
=> 'Select Sequence To Print From',

   'Select Spreadsheet File'
=> 'Select Spreadsheet File',

   'Select Student'
=> 'Select Student',

   'Select Students and Resources'
=> 'Select Students and Resources',

   'Select Style File'
=> 'Select Style File',

   'Select User'
=> 'Select User',

   'Select a'
=> 'Select a',

   'Select a course'
=> 'Select a course',

   'Select a user name to modify the students information'
=> 'Select a user name to modify the students information',

   'Select a user name to view the users personal page.'
=> 'Select a user name to view the users personal page.',

   'Select for Section/Group'
=> 'Select for Section/Group',

   'Select resources for the assignment'
=> 'Select resources for the assignment',

   'Select the Construction Space'
=> 'Select the Construction Space',

   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',

   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',

   'Selecting a User'
=> 'Selecting a User',

   'Send Message to User(s)'
=> 'Send Message to User(s)',

   'Send New'
=> 'Send New',

   'Send Reply'
=> 'Send Reply',

   'Send Scantron data to a course'
=> 'Send Scantron data to a course',

   'Send and receive messages'
=> 'Send and receive messages',

   'Send as critical message'
=> 'Send as critical message',

   'Send broadcast and receipt-required email'
=> 'Send broadcast and receipt-required email',

   'Send internal email'
=> 'Send internal email',

   'September'
=> 'September',

   'Sequence'
=> 'Sequence',

   'Sequence or Folder'
=> 'Sequence or Folder',

   'Sequences and Folders'
=> 'Sequences and Folders',

   'Server'
=> 'Server',

   'Server Administration'
=> 'Server Administration',

   'Set'
=> 'Set',

   'Set Course Environment'
=> 'Set Course Environment',

   'Set Course Environment Parameters'
=> 'Set Course Environment Parameters',

   'Set Date'
=> 'Set Date',

   'Set Defaults for All Resources in Course'
=> 'Set Defaults for All Resources in Course',

   'Set End Date'
=> 'Set End Date',

   'Set Individual User Roles'
=> 'Set Individual User Roles',

   'Set Problem Tries'
=> 'Set Problem Tries',

   'Set Problem Weight'
=> 'Set Problem Weight',

   'Set Start Date'
=> 'Set Start Date',

   'Set Version to be used in Course'
=> 'Set Version to be used in Course',

   'Set Versions to be used in Course according to Selections below'
=> 'Set Versions to be used in Course according to Selections below',

   'Set a bookmark for this resource'
=> 'Set a bookmark for this resource',

   'Set a due date'
=> 'Set a due date',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions)',

   'Set an answer open date'
=> 'Set an answer open date',

   'Set an open date'
=> 'Set an open date',

   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',

   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',

   'Set answer open date for the selected problem for ...'
=> 'Set answer open date for the selected problem for ...',

   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',

   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Set deadlines and other assessment parameters, as well as modify course environment',

   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',

   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',

   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',

   'Set my user preferences'
=> 'Set my user preferences',

   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',

   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',

   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',

   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',

   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',

   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',

   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',

   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . .',

   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',

   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',

   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',

   'Set the number of tries'
=> 'Set the number of tries',

   'Set the problem weight'
=> 'Set the problem weight',

   'Set to ...'
=> 'Set to ...',

   'Set value to "[_1]" to allow'
=> 'Set value to "[_1]" to allow',

   'Set/Modify Course Assessment Parameter'
=> 'Set/Modify Course Assessment Parameter',

   'Set/Modify Course Assessment Parameters'
=> 'Set/Modify Course Assessment Parameters',

   'Set/Modify Course Parameters'
=> 'Set/Modify Course Parameters',

   'Setting the [_1]'
=> 'Setting the [_1]',

   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',

   'Shared by course faculty and staff'
=> 'Shared by course faculty and staff',

   'Short string response'
=> 'Short string response',

   'Show Answer'
=> 'Show Answer',

   'Show Feedback'
=> 'Show Feedback',

   'Show More Options'
=> 'Show More Options',

   'Show Only Uncompleted Homework'
=> 'Show Only Uncompleted Homework',

   'Show Preview'
=> 'Show Preview',

   'Show Problem Completeness'
=> 'Show Problem Completeness',

   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',

   'Show all roles'
=> 'Show all roles',

   'Show all rles'
=> 'Show all rles',

   'Show always at bottom position'
=> 'Show always at bottom position',

   'Show always at top position'
=> 'Show always at top position',

   'Show catalog information'
=> 'Show catalog information',

   'Show resource'
=> 'Show resource',

   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Significant figures are incorrect, submission was not graded.'
=> 'Significant figures are incorrect, submission was not graded.',

   'Simple Edit'
=> 'Simple Edit',

   'Simple Page'
=> 'Simple Page',

   'Simple Problem'
=> 'Simple Problem',

   'Simple Problem Editor'
=> 'Simple Problem Editor',

   'Since Start of Course'
=> 'Since Start of Course',

   'Since Yesterday'
=> 'Since Yesterday',

   'Size'
=> 'Size',

   'Size:'
=> 'Size:',

   'Skew Tries'
=> 'Skew Tries',

   'Some items were not submitted'
=> 'Some items were not submitted',

   'Some parts were not submitted.'
=> 'Some parts were not submitted.',

   'Sorry ...'
=> 'Sorry ...',

   'Space separated'
=> 'Space separated',

   'Special Documents'
=> 'Special Documents',

   'Special documents'
=> 'Special documents',

   'Spreadsheet Computation'
=> 'Spreadsheet Computation',

   'Spreadsheet Computation Status'
=> 'Spreadsheet Computation Status',

   'Start'
=> 'Start',

   'Start Time'
=> 'Start Time',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",

   'Starting'
=> 'Starting',

   'Starting Date'
=> 'Starting Date',

   'Starting and Ending Dates'
=> 'Starting and Ending Dates',

   'Statistics'
=> 'Statistics',

   'Statistics and Problem Analysis'
=> 'Statistics and Problem Analysis',

   'Status'
=> 'Status',

   'Store'
=> 'Store',

   'Store Catalog Information'
=> 'Store Catalog Information',

   'Store Changes'
=> 'Store Changes',

   'Store uploaded file as '
=> 'Store uploaded file as ',

   'Student'
=> 'Student',

   'Student Data Compilation Progress'
=> 'Student Data Compilation Progress',

   'Student Data Compilation Status'
=> 'Student Data Compilation Status',

   'Student ID'
=> 'Student ID',

   'Student Information'
=> 'Student Information',

   'Student Name'
=> 'Student Name',

   'Student Number'
=> 'Student Number',

   'Student Sheet Links'
=> 'Student Sheet Links',

   'Student Status'
=> 'Student Status',

   'Student Status: [_1]'
=> 'Student Status: [_1]',

   'Student information updated successfully.'
=> 'Student information updated successfully.',

   'Student level sheet'
=> 'Student level sheet',

   'Student performance statistics on all problems.'
=> 'Student performance statistics on all problems.',

   'Students Affected'
=> 'Students Affected',

   'Students need access key to enter course'
=> 'Students need access key to enter course',

   'Students with expired roles'
=> 'Students with expired roles',

   'Subject'
=> 'Subject',

   'Subject:'
=> 'Subject:',

   'Submission Time Analysis'
=> 'Submission Time Analysis',

   'Submissions'
=> 'Submissions',

   'Submit'
=> 'Submit',

   'Submit Answer'
=> 'Submit Answer',

   'Submit Changes'
=> 'Submit Changes',

   'Submit Changes and Edit'
=> 'Submit Changes and Edit',

   'Submit Changes and View'
=> 'Submit Changes and View',

   'Submit Modifications'
=> 'Submit Modifications',

   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',

   'Successful Login'
=> 'Successful Login',

   'Suggested Replacement for Obsolete File'
=> 'Suggested Replacement for Obsolete File',

   'Summary'
=> 'Summary',

   'Summary View'
=> 'Summary View',

   'Sun'
=> 'Sun',

   'Supplemental Course Documents'
=> 'Supplemental Course Documents',

   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',

   'Switch Server'
=> 'Switch Server',

   'Switch to another course'
=> 'Switch to another course',

   'Switch to another user role'
=> 'Switch to another user role',

   'Switching Role'
=> 'Switching Role',

   'Syllabus'
=> 'Syllabus',

   'Synchronized SQL metadata database'
=> 'Synchronized SQL metadata database',

   'System'
=> 'System',

   'System Administration'
=> 'System Administration',

   'System Level'
=> 'System Level',

   'System wide - can be used for any courses system wide'
=> 'System wide - can be used for any courses system wide',

   'System wide - open source to all authors'
=> 'System wide - open source to all authors',

   'Tabulator separated'
=> 'Tabulator separated',

   'Target'
=> 'Target',

   'Target Edit Map'
=> 'Target Edit Map',

   'Task'
=> 'Task',

   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',

   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',

   'TeXWidth(mm):'
=> 'TeXWidth(mm):',

   'Teaching Assistant'
=> 'Teaching Assistant',

   'Template'
=> 'Template',

   'Temporary Assembly Workspace'
=> 'Temporary Assembly Workspace',

   'Text'
=> 'Text',

   'Text Block'
=> 'Text Block',

   'Textbook'
=> 'Textbook',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.',

   'The error reported was'
=> 'The error reported was',

   'The extension on this file'
=> 'The extension on this file',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'The filetype extension of the file you uploaded is not allowed.',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.',

   'The optional email address field was not specified.'
=> 'The optional email address field was not specified.',

   'The optional name field was not specified.'
=> 'The optional name field was not specified.',

   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified.',

   'The optional student number field was not specified.'
=> 'The optional student number field was not specified.',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',

   'The requested file'
=> 'The requested file',

   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',

   'The submitted answer was too long.'
=> 'The submitted answer was too long.',

   'The target is an existing directory.'
=> 'The target is an existing directory.',

   'Then'
=> 'Then',

   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',

   'There are currently no results'
=> 'There are currently no results',

   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',

   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',

   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',

   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',

   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',

   'There are no students currently enrolled.'
=> 'There are no students currently enrolled.',

   'There are no students in the course.'
=> 'There are no students in the course.',

   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',

   'There is no student data for this problem.'
=> 'There is no student data for this problem.',

   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',

   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'This is an automatic message generated by the LON-CAPA system.',

   'This question expects a numeric answer.'
=> 'This question expects a numeric answer.',

   'This resource has been marked obsolete by the author(s)'
=> 'This resource has been marked obsolete by the author(s)',

   'This resource might be part of another course.'
=> 'This resource might be part of another course.',

   'This syllabus can be publicly viewed at'
=> 'This syllabus can be publicly viewed at',

   'Threaded View'
=> 'Threaded View',

   'Thu'
=> 'Thu',

   'Time'
=> 'Time',

   'Title'
=> 'Title',

   'To'
=> 'To',

   'To create a new'
=> 'To create a new',

   'Top Level Map'
=> 'Top Level Map',

   'Topic'
=> 'Topic',

   'Total'
=> 'Total',

   'Total Parts In Course'
=> 'Total Parts In Course',

   'Total number of records found in file: [_1].'
=> 'Total number of records found in file: [_1].',

   'Total number of students who have worked on this problem'
=> 'Total number of students who have worked on this problem',

   'Tries'
=> 'Tries',

   'True'
=> 'True',

   'Tue'
=> 'Tue',

   'Turkish - ISO'
=> 'Turkish - ISO',

   'Type'
=> 'Type',

   'Type Name Here'
=> 'Type Name Here',

   'Type in value'
=> 'Type in value',

   'Type-in value'
=> 'Type-in value',

   'Type:'
=> 'Type:',

   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',

   'UNIX authenticated'
=> 'UNIX authenticated',

   'URL'
=> 'URL',

   'URLs To Include in Syllabus'
=> 'URLs To Include in Syllabus',

   'USERS'
=> 'USERS',

   'Unable to connect to database!'
=> 'Unable to connect to database!',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Unable to determine if this resource is open due to network problems. Please try again later.',

   'Unable to enroll'
=> 'Unable to enroll',

   'Unable to enroll students'
=> 'Unable to enroll students',

   'Unable to find'
=> 'Unable to find',

   'Unable to make backup'
=> 'Unable to make backup',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',

   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',

   'Unable to set default dates for course'
=> 'Unable to set default dates for course',

   'Unable to understand formula'
=> 'Unable to understand formula',

   'Unable to undo, unable to switch'
=> 'Unable to undo, unable to switch',

   'Unable to write to'
=> 'Unable to write to',

   'Unavailable course'
=> 'Unavailable course',

   'Uncheck All'
=> 'Uncheck All',

   'Uncompleted Homework'
=> 'Uncompleted Homework',

   'Undetermined - ISO'
=> 'Undetermined - ISO',

   'Undid changes, Switched'
=> 'Undid changes, Switched',

   'Unit:'
=> 'Unit:',

   'Units incorrect.'
=> 'Units incorrect.',

   'Units required'
=> 'Units required',

   'Unknown Action'
=> 'Unknown Action',

   'Unknown ID'
=> 'Unknown ID',

   'Unknown message'
=> 'Unknown message',

   'Unknown user'
=> 'Unknown user',

   'Unpublished'
=> 'Unpublished',

   'Unselect All'
=> 'Unselect All',

   'Unselect All Files'
=> 'Unselect All Files',

   'Unselect All Published'
=> 'Unselect All Published',

   'Unselect All Resources'
=> 'Unselect All Resources',

   'Unselect All Students'
=> 'Unselect All Students',

   'Unselect for Section/Group'
=> 'Unselect for Section/Group',

   'Unsuccessful Login'
=> 'Unsuccessful Login',

   'Unsupported character combination'
=> 'Unsupported character combination',

   'Up'
=> 'Up',

   'Update Course Assessment Parameter Display'
=> 'Update Course Assessment Parameter Display',

   'Update Display'
=> 'Update Display',

   'Update Section or Specific User'
=> 'Update Section or Specific User',

   'Update Student Data'
=> 'Update Student Data',

   'Updating discussion time'
=> 'Updating discussion time',

   'Upload Document'
=> 'Upload Document',

   'Upload Scantron data'
=> 'Upload Scantron data',

   'Upload a Photo'
=> 'Upload a Photo',

   'Upload a class list'
=> 'Upload a class list',

   'Upload a new main course document'
=> 'Upload a new main course document',

   'Upload a new supplemental course document'
=> 'Upload a new supplemental course document',

   'Upload class list'
=> 'Upload class list',

   'Upload file'
=> 'Upload file',

   'Upload file to Construction Space'
=> 'Upload file to Construction Space',

   'Uploaded'
=> 'Uploaded',

   'Uploaded Document'
=> 'Uploaded Document',

   'Uploading Class List'
=> 'Uploading Class List',

   'Use or edit my bookmark collection'
=> 'Use or edit my bookmark collection',

   'User'
=> 'User',

   'User Load'
=> 'User Load',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'User Notes, Records of Face-to-Face Discussions, and Critical Messages',

   'User Role'
=> 'User Role',

   'User Roles'
=> 'User Roles',

   'Username'
=> 'Username',

   'Users with Roles Assigned by'
=> 'Users with Roles Assigned by',

   'VIEW'
=> 'VIEW',

   'Value'
=> 'Value',

   'Verify Content'
=> 'Verify Content',

   'Verify Course Documents'
=> 'Verify Course Documents',

   'Verify Selection'
=> 'Verify Selection',

   'Version'
=> 'Version',

   'Version Number'
=> 'Version Number',

   'Version changes since Yesterday'
=> 'Version changes since Yesterday',

   'Version changes since last Month'
=> 'Version changes since last Month',

   'Version changes since last Week'
=> 'Version changes since last Week',

   'Version changes since start of Course'
=> 'Version changes since start of Course',

   'Version used in Course'
=> 'Version used in Course',

   'View'
=> 'View',

   'View All Messages'
=> 'View All Messages',

   'View Class List'
=> 'View Class List',

   'View Critical Messages'
=> 'View Critical Messages',

   'View Published Version'
=> 'View Published Version',

   'View course assessment statistics'
=> 'View course assessment statistics',

   'View documents included in this course'
=> 'View documents included in this course',

   'View file'
=> 'View file',

   'View the FAQ'
=> 'View the FAQ',

   'View the course assessment progress chart'
=> 'View the course assessment progress chart',

   'View user submissions for this assessment resource'
=> 'View user submissions for this assessment resource',

   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',

   'Warning!'
=> 'Warning!',

   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',

   'Warning: target file exists!'
=> 'Warning: target file exists!',

   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',

   'Was due'
=> 'Was due',

   'Web Links'
=> 'Web Links',

   'Web References'
=> 'Web References',

   'Wed'
=> 'Wed',

   'Weight (weight)'
=> 'Weight (weight)',

   'Welcome'
=> 'Welcome',

   'Welcome to Your New LON-CAPA Course'
=> 'Welcome to Your New LON-CAPA Course',

   'Welcome to the Assignment Parameter Helper'
=> 'Welcome to the Assignment Parameter Helper',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up',

   'What parameter do you want to set for all problems in the course?'
=> 'What parameter do you want to set for all problems in the course?',

   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',

   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',

   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',

   'What should the due date be set to?'
=> 'What should the due date be set to?',

   'What should the opening date be set to?'
=> 'What should the opening date be set to?',

   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',

   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',

   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',

   'Which Problem or Problems?'
=> 'Which Problem or Problems?',

   'Which problems do you wish to set a parameter for?'
=> 'Which problems do you wish to set a parameter for?',

   'Width'
=> 'Width',

   'Width(pixel):'
=> 'Width(pixel):',

   'With Answers'
=> 'With Answers',

   'Without Answers'
=> 'Without Answers',

   'Words'
=> 'Words',

   'Wrote Metadata'
=> 'Wrote Metadata',

   'XML/SGML'
=> 'XML/SGML',

   'Yes'
=> 'Yes',

   'You are correct.'
=> 'You are correct.',

   'You are excused from the problem.'
=> 'You are excused from the problem.',

   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',

   'You did not select a template.'
=> 'You did not select a template.',

   'You do not have authoring privileges for this resource'
=> 'You do not have authoring privileges for this resource',

   'You have entered that answer before'
=> 'You have entered that answer before',

   'You have no critical messages.'
=> 'You have no critical messages.',

   'You have no unread messages'
=> 'You have no unread messages',

   'You have provided an invalid ranking'
=> 'You have provided an invalid ranking',

   'You must choose an authentication type.'
=> 'You must choose an authentication type.',

   'You must choose at least one student to continue.'
=> 'You must choose at least one student to continue.',

   'You must choose one or more choices to continue.'
=> 'You must choose one or more choices to continue.',

   'You need to choose another user role or enter a specific course for this function'
=> 'You need to choose another user role or enter a specific course for this function',

   'You need to specify the Kerberos domain.'
=> 'You need to specify the Kerberos domain.',

   'You need to specify the initial password.'
=> 'You need to specify the initial password.',

   'You need to specify the username field.'
=> 'You need to specify the username field.',

   'Your Excel Spreadsheet'
=> 'Your Excel Spreadsheet',

   'Your Version Settings have been Stored'
=> 'Your Version Settings have been Stored',

   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.',

   'Your home server is '
=> 'Your home server is ',

   'Your receipt is'
=> 'Your receipt is',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',

   'Your submission has been recorded.'
=> 'Your submission has been recorded.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',

   '[_1] Do not change login data'
=> '[_1] Do not change login data',

   '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])'
=> '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2])',

   '[_1] Internally authenticated (mit Anfangspasswort [_2])'
=> '[_1] Internally authenticated (mit Anfangspasswort [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Internally authenticated (with initial password [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local Authentication with arguement [_2]',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',

   '[_1] Records per Page'
=> '[_1] Records per Page',

   '[_1] minutes'
=> '[_1] minutes',

   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',

   '[_1] with value [_2]'
=> '[_1] with value [_2]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',

   '[_2] seconds'
=> '[_2] seconds',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',

   'a.m.'
=> 'a.m.',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'abstract'
=> 'abstract',

   'acc keys'
=> 'acc keys',

   'acc keys[_1]'
=> 'acc keys[_1]',

   'access denied'
=> 'access denied',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'according to course preferences'
=> 'according to course preferences',

   'according to resource settings'
=> 'according to resource settings',

   'according to user session state'
=> 'according to user session state',

   'after selected'
=> 'after selected',

   'all'
=> 'all',

   'all resources in the course'
=> 'all resources in the course',

   'all students in course'
=> 'all students in course',

   'an indeterminate date'
=> 'an indeterminate date',

   'an unknown date'
=> 'an unknown date',

   'and'
=> 'and',

   'and return receipt'
=> 'and return receipt',

   'anno-'
=> 'anno-',

   'anno-[_1]'
=> 'anno-[_1]',

   'anno.gif'
=> 'anno.gif',

   'announce'
=> 'announce',

   'announce[_1]'
=> 'announce[_1]',

   'anonymous'
=> 'anonymous',

   'anonymous students'
=> 'anonymous students',

   'anot.gif'
=> 'anot.gif',

   'answer date'
=> 'answer date',

   'at'
=> 'at',

   'at Domain'
=> 'at Domain',

   'at domain'
=> 'at domain',

   'audio'
=> 'audio',

   'author'
=> 'author',

   'backward'
=> 'backward',

   'backward[_1]'
=> 'backward[_1]',

   'bchat.gif'
=> 'bchat.gif',

   'between'
=> 'between',

   'bookmark'
=> 'bookmark',

   'bookmark[_1]'
=> 'bookmark[_1]',

   'bookmark[_2]'
=> 'bookmark[_2]',

   'button'
=> 'button',

   'by'
=> 'by',

   'bytes'
=> 'bytes',

   'calendar'
=> 'calendar',

   'calendar[_1]'
=> 'calendar[_1]',

   'can not be accessed from your location.'
=> 'can not be accessed from your location.',

   'catalog'
=> 'catalog',

   'catalog.gif'
=> 'catalog.gif',

   'catalog[_1]'
=> 'catalog[_1]',

   'ccrs.gif'
=> 'ccrs.gif',

   'changes will not show until next login'
=> 'changes will not show until next login',

   'chart'
=> 'chart',

   'chart[_1]'
=> 'chart[_1]',

   'chat'
=> 'chat',

   'chat[_1]'
=> 'chat[_1]',

   'check all'
=> 'check all',

   'chmod error'
=> 'chmod error',

   'choose'
=> 'choose',

   'choose[_1]'
=> 'choose[_1]',

   'choose[_2]'
=> 'choose[_2]',

   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'click on the',

   'close this window'
=> 'close this window',

   'co con-'
=> 'co con-',

   'co con-[_1]'
=> 'co con-[_1]',

   'co res'
=> 'co res',

   'co res[_1]'
=> 'co res[_1]',

   'com.gif'
=> 'com.gif',

   'commu-'
=> 'commu-',

   'commu-[_1]'
=> 'commu-[_1]',

   'con-'
=> 'con-',

   'con-[_1]'
=> 'con-[_1]',

   'connection down'
=> 'connection down',

   'contacting'
=> 'contacting',

   'contacting [_1]'
=> 'contacting [_1]',

   'contents'
=> 'contents',

   'contents[_1]'
=> 'contents[_1]',

   'copy Error'
=> 'copy Error',

   'copyright'
=> 'copyright',

   'could not be copied.'
=> 'could not be copied.',

   'course'
=> 'course',

   'course[_10]'
=> 'course[_10]',

   'course[_11]'
=> 'course[_11]',

   'course[_1]'
=> 'course[_1]',

   'course[_2]'
=> 'course[_2]',

   'course[_3]'
=> 'course[_3]',

   'course[_4]'
=> 'course[_4]',

   'course[_5]'
=> 'course[_5]',

   'course[_6]'
=> 'course[_6]',

   'course[_7]'
=> 'course[_7]',

   'course[_8]'
=> 'course[_8]',

   'course[_9]'
=> 'course[_9]',

   'courses.gif'
=> 'courses.gif',

   'cprv.gif'
=> 'cprv.gif',

   'create'
=> 'create',

   'create[_1]'
=> 'create[_1]',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'currently does not exist',

   'custom'
=> 'custom',

   'custom distribution file'
=> 'custom distribution file',

   'customdistributionfile'
=> 'customdistributionfile',

   'date_am'
=> 'date_am',

   'date_days'
=> 'date_days',

   'date_locale'
=> 'date_locale',

   'date_months'
=> 'date_months',

   'date_pm'
=> 'date_pm',

   'default'
=> 'default',

   'directory'
=> 'directory',

   'discuss'
=> 'discuss',

   'discuss[_1]'
=> 'discuss[_1]',

   'docs'
=> 'docs',

   'docs.gif'
=> 'docs.gif',

   'docs[_1]'
=> 'docs[_1]',

   'docs[_2]'
=> 'docs[_2]',

   'domain'
=> 'domain',

   'due date'
=> 'due date',

   'during the last'
=> 'during the last',

   'edit'
=> 'edit',

   'edit crs'
=> 'edit crs',

   'edit crs[_1]'
=> 'edit crs[_1]',

   'egrd.gif'
=> 'egrd.gif',

   'ences'
=> 'ences',

   'ences[_1]'
=> 'ences[_1]',

   'enrl.gif'
=> 'enrl.gif',

   'enroll'
=> 'enroll',

   'enroll[_1]'
=> 'enroll[_1]',

   'enter'
=> 'enter',

   'enter[_1]'
=> 'enter[_1]',

   'eval.gif'
=> 'eval.gif',

   'evaluate'
=> 'evaluate',

   'evaluate[_1]'
=> 'evaluate[_1]',

   'exit'
=> 'exit',

   'exit[_1]'
=> 'exit[_1]',

   'expired or revoked'
=> 'expired or revoked',

   'extension'
=> 'extension',

   'external'
=> 'external',

   'fas'
=> 'fas',

   'fdbk.gif'
=> 'fdbk.gif',

   'feedback'
=> 'feedback',

   'feedback[_1]'
=> 'feedback[_1]',

   'file<br />extension'
=> 'file<br />extension',

   'first name'
=> 'first name',

   'for'
=> 'for',

   'for <b>all resources in the course</b>'
=> 'for <b>all resources in the course</b>',

   'for <b>all students in course</b>'
=> 'for <b>all students in course</b>',

   'for Enclosing Map or Folder'
=> 'for Enclosing Map or Folder',

   'for Resource'
=> 'for Resource',

   'for [_1]'
=> 'for [_1]',

   'for section [_1]'
=> 'for section [_1]',

   'for the map named [_1]'
=> 'for the map named [_1]',

   'for the resource named [_1]'
=> 'for the resource named [_1]',

   'for visible separation'
=> 'for visible separation',

   'forward'
=> 'forward',

   'forward[_1]'
=> 'forward[_1]',

   'from'
=> 'from',

   'from Enclosing Map or Folder'
=> 'from Enclosing Map or Folder',

   'from current subdirectory'
=> 'from current subdirectory',

   'general'
=> 'general',

   'generation'
=> 'generation',

   'grades'
=> 'grades',

   'grades[_1]'
=> 'grades[_1]',

   'grades[_2]'
=> 'grades[_2]',

   'grds.gif'
=> 'grds.gif',

   'have different numbers and answers'
=> 'have different numbers and answers',

   'helper'
=> 'helper',

   'htmlarea_lang'
=> 'htmlarea_lang',

   'in'
=> 'in',

   'in Course'
=> 'in Course',

   'in Section/Group'
=> 'in Section/Group',

   'in domain'
=> 'in domain',

   'info'
=> 'info',

   'instructor'
=> 'instructor',

   'interface available'
=> 'interface available',

   'internal'
=> 'internal',

   'is closed but you are allowed to view it'
=> 'is closed but you are allowed to view it',

   'is due at'
=> 'is due at',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',

   'is in under construction'
=> 'is in under construction',

   'is not analyzable at this time'
=> 'is not analyzable at this time',

   'is ready for download'
=> 'is ready for download',

   'keys.gif'
=> 'keys.gif',

   'keywords'
=> 'keywords',

   'language'
=> 'language',

   'last month'
=> 'last month',

   'last name'
=> 'last name',

   'last problem'
=> 'last problem',

   'last six months'
=> 'last six months',

   'last student'
=> 'last student',

   'last three months'
=> 'last three months',

   'last week'
=> 'last week',

   'last year'
=> 'last year',

   'library'
=> 'library',

   'library[_1]'
=> 'library[_1]',

   'log in again'
=> 'log in again',

   'loginproblems.html'
=> 'loginproblems.html',

   'logout.gif'
=> 'logout.gif',

   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',

   'manage'
=> 'manage',

   'manage[_1]'
=> 'manage[_1]',

   'may be open from a different computer.'
=> 'may be open from a different computer.',

   'may open later.'
=> 'may open later.',

   'middle name'
=> 'middle name',

   'midnight'
=> 'midnight',

   'minutes'
=> 'minutes',

   'missions'
=> 'missions',

   'most recent'
=> 'most recent',

   'movies'
=> 'movies',

   'my'
=> 'my',

   'my[_1]'
=> 'my[_1]',

   'name'
=> 'name',

   'name only visible to course faculty'
=> 'name only visible to course faculty',

   'nav.gif'
=> 'nav.gif',

   'navigate'
=> 'navigate',

   'navigate[_1]'
=> 'navigate[_1]',

   'never'
=> 'never',

   'nication'
=> 'nication',

   'nication[_1]'
=> 'nication[_1]',

   'no ending date'
=> 'no ending date',

   'noon'
=> 'noon',

   'not displayed'
=> 'not displayed',

   'not found'
=> 'not found',

   'notes'
=> 'notes',

   'num_override'
=> 'num_override',

   'number'
=> 'number',

   'number of tries'
=> 'number of tries',

   'obsolete'
=> 'obsolete',

   'obsolete replacement'
=> 'obsolete replacement',

   'obsoletereplacement'
=> 'obsoletereplacement',

   'of'
=> 'of',

   'only check if you know what you are doing'
=> 'only check if you know what you are doing',

   'only search domain'
=> 'only search domain',

   'opening date'
=> 'opening date',

   'optional'
=> 'optional',

   'or'
=> 'or',

   'or ID'
=> 'or ID',

   'or any other value'
=> 'or any other value',

   'p.m.'
=> 'p.m.',

   'pages'
=> 'pages',

   'parm.gif'
=> 'parm.gif',

   'parms'
=> 'parms',

   'parms[_1]'
=> 'parms[_1]',

   'part'
=> 'part',

   'percent'
=> 'percent',

   'pictures'
=> 'pictures',

   'please refer to'
=> 'please refer to',

   'pref.gif'
=> 'pref.gif',

   'prefer-'
=> 'prefer-',

   'prefer-[_1]'
=> 'prefer-[_1]',

   'prepare'
=> 'prepare',

   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',

   'printout'
=> 'printout',

   'private'
=> 'private',

   'problem'
=> 'problem',

   'problem statistics grouped by sequence'
=> 'problem statistics grouped by sequence',

   'problem statistics ungrouped'
=> 'problem statistics ungrouped',

   'problem statistics, Excel'
=> 'problem statistics, Excel',

   'problem weight'
=> 'problem weight',

   'prt.gif'
=> 'prt.gif',

   'public'
=> 'public',

   'publisher<br />owner'
=> 'publisher<br />owner',

   're-initializing course'
=> 're-initializing course',

   'remaining'
=> 'remaining',

   'res.gif'
=> 'res.gif',

   'resource'
=> 'resource',

   'resource[_1]'
=> 'resource[_1]',

   'resources'
=> 'resources',

   'role'
=> 'role',

   'role,role,...'
=> 'role,role,...',

   'role[_1]'
=> 'role[_1]',

   'role[_2]'
=> 'role[_2]',

   'roles'
=> 'roles',

   'roles.gif'
=> 'roles.gif',

   'roles[_1]'
=> 'roles[_1]',

   'sbkm.gif'
=> 'sbkm.gif',

   'scantron[_1]'
=> 'scantron[_1]',

   'search'
=> 'search',

   'search[_1]'
=> 'search[_1]',

   'search[_2]'
=> 'search[_2]',

   'second'
=> 'second',

   'seconds'
=> 'seconds',

   'seconds for'
=> 'seconds for',

   'section'
=> 'section',

   'selected students'
=> 'selected students',

   'send[_1]'
=> 'send[_1]',

   'sequence'
=> 'sequence',

   'set'
=> 'set',

   'set[_1]'
=> 'set[_1]',

   'space'
=> 'space',

   'space[_1]'
=> 'space[_1]',

   'space[_2]'
=> 'space[_2]',

   'spacer.gif'
=> 'spacer.gif',

   'spellcheck_lang'
=> 'spellcheck_lang',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'standard'
=> 'standard',

   'standard LaTeX mode'
=> 'standard LaTeX mode',

   'standard courses only'
=> 'standard courses only',

   'stat.gif'
=> 'stat.gif',

   'stats'
=> 'stats',

   'stats[_1]'
=> 'stats[_1]',

   'struct'
=> 'struct',

   'struct[_1]'
=> 'struct[_1]',

   'struct[_2]'
=> 'struct[_2]',

   'student'
=> 'student',

   'student name'
=> 'student name',

   'subject'
=> 'subject',

   'switch'
=> 'switch',

   'switch[_1]'
=> 'switch[_1]',

   'switch[_2]'
=> 'switch[_2]',

   'system wide'
=> 'system wide',

   'tations'
=> 'tations',

   'template'
=> 'template',

   'textual_remote_display'
=> 'textual_remote_display',

   'this'
=> 'this',

   'title'
=> 'title',

   'to'
=> 'to',

   'to [_1] ([_2])'
=> 'to [_1] ([_2])',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',

   'today'
=> 'today',

   'unable to enroll'
=> 'unable to enroll',

   'uncheck all'
=> 'uncheck all',

   'undo'
=> 'undo',

   'unless locked'
=> 'unless locked',

   'untitled'
=> 'untitled',

   'updated periodically'
=> 'updated periodically',

   'use related words'
=> 'use related words',

   'user'
=> 'user',

   'user[_1]'
=> 'user[_1]',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'username'
=> 'username',

   'users in'
=> 'users in',

   'vbkm.gif'
=> 'vbkm.gif',

   'versions of this problem'
=> 'versions of this problem',

   'versus'
=> 'versus',

   'view'
=> 'view',

   'view sub-'
=> 'view sub-',

   'view[_1]'
=> 'view[_1]',

   'visible to author and co-authors only'
=> 'visible to author and co-authors only',

   'waiting on'
=> 'waiting on',

   'waiting on [_1]'
=> 'waiting on [_1]',

   'warning(s)'
=> 'warning(s)',

   'was due on'
=> 'was due on',

   'what you just saw on the screen'
=> 'what you just saw on the screen',

   'will open on'
=> 'will open on',

   'with server'
=> 'with server',

   'yes'
=> 'yes',



#SYNC Tue Aug 15 16:12:08 2006
   ' [_1]'
=> ' [_1]',

   '"[_1]" for default hiding'
=> '"[_1]" for default hiding',

   '"[_1]" for visible separation'
=> '"[_1]" for visible separation',

   '"[_1]" if allowed, anything else if not'
=> '"[_1]" if allowed, anything else if not',

   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',

   '# 16 Aug 14:45'
=> '# 16 Aug 14:45',

   '# Do not translate this line.  [_1] is a check box'
=> '# Do not translate this line.  [_1] is a check box',

   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field',

   '# Do not translate this line.  [_1] is a column index.'
=> '# Do not translate this line.  [_1] is a column index.',

   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Do not translate this line.  [_1] is a drop-down box listing domains.',

   '# Do not translate this line.  [_1] is a username'
=> '# Do not translate this line.  [_1] is a username',

   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Do not translate this line.  [_1] is the number of students processed',

   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.',

   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Do not translate this line.  [_1] is username, [_2] is error message',

   '# Do not translate this line.  [_1] is username@domain'
=> '# Do not translate this line.  [_1] is username@domain',

   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Do not translate this line.  [_1] is username@domain [_2] is the error message.',

   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Do not translate this line.  [_1], [_3], and [_4] are check boxes',

   '# Do not translate this line.  [_2] is a text entry element'
=> '# Do not translate this line.  [_2] is a text entry element',

   '# [_1] is a drop-down selection box'
=> '# [_1] is a drop-down selection box',

   '# [_1] is a number [_2] is the current domain'
=> '# [_1] is a number [_2] is the current domain',

   '# [_1] is an html link to the current file '
=> '# [_1] is an html link to the current file ',

   '# _1 is a selection dialog'
=> '# _1 is a selection dialog',

   '# _1 is a server name'
=> '# _1 is a server name',

   '# _1 is search string'
=> '# _1 is search string',

   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'",

   '# mt fehlt'
=> '# mt fehlt',

   '#Stdnts'
=> '#Stdnts',

   '#YES'
=> '#YES',

   '#[_1] is the foil name'
=> '#[_1] is the foil name',

   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 is the foil name, _2 is the current value of the foil',

   '%Wrng'
=> '%Wrng',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Show&nbsp;All&nbsp;Foils',

   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.',

   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.',

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',

   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',

   ', and answers will be available on'
=> ', and answers will be available on',

   ', is reserved internally by LON-CAPA.'
=> ', is reserved internally by LON-CAPA.',

   ', or the next time you log in.'
=> ', or the next time you log in.',

   ', select a template from the pull-down menu below'
=> ', select a template from the pull-down menu below',

   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',

   '. . . for a particular section'
=> '. . . for a particular section',

   '. . . for all students in the course'
=> '. . . for all students in the course',

   '. . . for an individual student'
=> '. . . for an individual student',

   '1 am'
=> '1 am',

   '1 minute'
=> '1 minute',

   '1 out of N multiple choice (radio button)'
=> '1 out of N multiple choice (radio button)',

   '1 pm'
=> '1 pm',

   '10 am'
=> '10 am',

   '10 pm'
=> '10 pm',

   '11 am'
=> '11 am',

   '11 pm'
=> '11 pm',

   '12 am'
=> '12 am',

   '12 noon'
=> '12 noon',

   '2 am'
=> '2 am',

   '2 pm'
=> '2 pm',

   '3 am'
=> '3 am',

   '3 pm'
=> '3 pm',

   '4 am'
=> '4 am',

   '4 pm'
=> '4 pm',

   '5 am'
=> '5 am',

   '5 pm'
=> '5 pm',

   '6 am'
=> '6 am',

   '6 pm'
=> '6 pm',

   '7 am'
=> '7 am',

   '7 pm'
=> '7 pm',

   '8 am'
=> '8 am',

   '8 pm'
=> '8 pm',

   '9 am'
=> '9 am',

   '9 pm'
=> '9 pm',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',

   '<- Previous'
=> '<- Previous',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Unable to enroll: [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Unable to enroll.  No password specified.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>',

   'A score has been assigned.'
=> 'A score has been assigned.',

   'ABSTRACT'
=> 'ABSTRACT',

   'ALL'
=> 'ALL',

   'About Me'
=> 'About Me',

   'Abstract'
=> 'Abstract',

   'Access Control'
=> 'Access Control',

   'Access Key Management'
=> 'Access Key Management',

   'Access and Usage Statistics'
=> 'Access and Usage Statistics',

   'Actions'
=> 'Actions',

   'Activate'
=> 'Activate',

   'Add Roles'
=> 'Add Roles',

   'Add new option'
=> 'Add new option',

   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",

   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",

   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",

   'Additional Keywords'
=> 'Additional Keywords',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Additional Metadata (non-standard, parameters, exports)',

   'Additional Recipients'
=> 'Additional Recipients',

   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',

   'Administrator'
=> 'Administrator',

   'Advanced Catalog Search'
=> 'Advanced Catalog Search',

   'Advanced Edit'
=> 'Advanced Edit',

   'Advanced Search'
=> 'Advanced Search',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',

   'Agree'
=> 'Agree',

   'All Documents in Course'
=> 'All Documents in Course',

   'All Maps or Folders'
=> 'All Maps or Folders',

   'All Resources'
=> 'All Resources',

   'All Resources (possibly large output)'
=> 'All Resources (possibly large output)',

   'All Students'
=> 'All Students',

   'All homework is currently completed'
=> 'All homework is currently completed',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.',

   'All versions'
=> 'All versions',

   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',

   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',

   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',

   'Analyze Over '
=> 'Analyze Over ',

   'Analyze Problem'
=> 'Analyze Problem',

   'Analyze Problem Again'
=> 'Analyze Problem Again',

   'Analyze Progress'
=> 'Analyze Progress',

   'Analyze as '
=> 'Analyze as ',

   'Analyzing Results'
=> 'Analyzing Results',

   'Analyzing a problem'
=> 'Analyzing a problem',

   'Announcements and Calendar'
=> 'Announcements and Calendar',

   'Anonymous'
=> 'Anonymous',

   'Anonymous contribution to course discussion of resource'
=> 'Anonymous contribution to course discussion of resource',

   'Answer'
=> 'Answer',

   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',

   'Answer Submitted'
=> 'Answer Submitted',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',

   'Answer available'
=> 'Answer available',

   'Answer submitted'
=> 'Answer submitted',

   'Answer submitted, not yet graded'
=> 'Answer submitted, not yet graded',

   'Answer:'
=> 'Answer:',

   'Answerable'
=> 'Answerable',

   'Any Language'
=> 'Any Language',

   'Any User'
=> 'Any User',

   'Any category'
=> 'Any category',

   'Any comments? '
=> 'Any comments? ',

   'Any copyright/distribution'
=> 'Any copyright/distribution',

   'April'
=> 'April',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).',

   'Assessment'
=> 'Assessment',

   'Assessment Parameters'
=> 'Assessment Parameters',

   'Assessment URL and Title'
=> 'Assessment URL and Title',

   'Assigned User Roles'
=> 'Assigned User Roles',

   'Associate columns with student attributes.'
=> 'Associate columns with student attributes.',

   'Attachment'
=> 'Attachment',

   'Attribute'
=> 'Attribute',

   'August'
=> 'August',

   'Author'
=> 'Author',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Author and Co-Author roles may not be available on servers other than your home server.',

   'Author(s)'
=> 'Author(s)',

   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',

   'Automated adds'
=> 'Automated adds',

   'Automated drops'
=> 'Automated drops',

   'Automated enrollment settings'
=> 'Automated enrollment settings',

   'Average number of tries till solved'
=> 'Average number of tries till solved',

   'Back to'
=> 'Back to',

   'Back to Directory'
=> 'Back to Directory',

   'Back to Source'
=> 'Back to Source',

   'Back to Source Directory'
=> 'Back to Source Directory',

   'Bad Filename'
=> 'Bad Filename',

   'Became this version on ...'
=> 'Became this version on ...',

   'Begin Enrollment'
=> 'Begin Enrollment',

   'Binary File'
=> 'Binary File',

   'Blank'
=> 'Blank',

   'Brief view of each students performance in course.'
=> 'Brief view of each students performance in course.',

   'Broadcast Message to Course'
=> 'Broadcast Message to Course',

   'Browse'
=> 'Browse',

   'Browse Resources'
=> 'Browse Resources',

   'Browse published resources'
=> 'Browse published resources',

   'Browse resources'
=> 'Browse resources',

   'Browsing resource, all submissions are temporary.'
=> 'Browsing resource, all submissions are temporary.',

   'Bulletin Board'
=> 'Bulletin Board',

   'Bulletin Board/Discussion'
=> 'Bulletin Board/Discussion',

   'By'
=> 'By',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (comma separated values, spreadsheet)',

   'CSV format'
=> 'CSV format',

   'Calculate answers'
=> 'Calculate answers',

   'Calculate course grades (Spreadsheet)'
=> 'Calculate course grades (Spreadsheet)',

   'Calculations'
=> 'Calculations',

   'Cancel'
=> 'Cancel',

   'Cannot publish directory'
=> 'Cannot publish directory',

   'Cannot retrieve directory'
=> 'Cannot retrieve directory',

   'Catalog Information'
=> 'Catalog Information',

   'Catalog Search'
=> 'Catalog Search',

   'Change'
=> 'Change',

   'Change Random Seed To:'
=> 'Change Random Seed To:',

   'Change User Privileges'
=> 'Change User Privileges',

   'Change Your Language Preferences'
=> 'Change Your Language Preferences',

   'Change Your Preferences'
=> 'Change Your Preferences',

   'Changed discussion view mode'
=> 'Changed discussion view mode',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Changes can take up to 10 minutes before being active for all students.',

   'Changes will become active for your current session after'
=> 'Changes will become active for your current session after',

   'Chat Participation'
=> 'Chat Participation',

   'Check All'
=> 'Check All',

   'Check Course Document Versions'
=> 'Check Course Document Versions',

   'Check for All'
=> 'Check for All',

   'Check for None'
=> 'Check for None',

   'Check for Section/Group'
=> 'Check for Section/Group',

   'Check/Set Resource Versions'
=> 'Check/Set Resource Versions',

   'Choose a different resource'
=> 'Choose a different resource',

   'Choose the course to work on'
=> 'Choose the course to work on',

   'Choose the user role'
=> 'Choose the user role',

   'Chronological View'
=> 'Chronological View',

   'Class Hours'
=> 'Class Hours',

   'Clear All'
=> 'Clear All',

   'Clear Caches'
=> 'Clear Caches',

   'Click here for FAQ'
=> 'Click here for FAQ',

   'Click here for help'
=> 'Click here for help',

   'Click here to report bugs'
=> 'Click here to report bugs',

   'Click here to return to the chart.'
=> 'Click here to return to the chart.',

   "Click to download or use your browser's Save Link function"
=> "Click to download or use your browser's Save Link function",

   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',

   'Clone an existing course'
=> 'Clone an existing course',

   'Close'
=> 'Close',

   'Close All Folders'
=> 'Close All Folders',

   'Close This Window'
=> 'Close This Window',

   'Closed'
=> 'Closed',

   'Co-Author'
=> 'Co-Author',

   'Collapse Remote Control'
=> 'Collapse Remote Control',

   'Column'
=> 'Column',

   'Column&nbsp;[_1]'
=> 'Column&nbsp;[_1]',

   'Comma Separated Values'
=> 'Comma Separated Values',

   'Communication'
=> 'Communication',

   'Communication and Messages'
=> 'Communication and Messages',

   'Compact View'
=> 'Compact View',

   'Compare versions of'
=> 'Compare versions of',

   'Completed'
=> 'Completed',

   'Completely new course'
=> 'Completely new course',

   'Concept:'
=> 'Concept:',

   'Concepts'
=> 'Concepts',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.',

   'Construction Space'
=> 'Construction Space',

   'Construction Space Directory'
=> 'Construction Space Directory',

   'Construction Space File Operation'
=> 'Construction Space File Operation',

   'Construction Space Version'
=> 'Construction Space Version',

   'Contact'
=> 'Contact',

   'Contact Information'
=> 'Contact Information',

   'Content changed'
=> 'Content changed',

   'Continue'
=> 'Continue',

   'Continue enrollment?'
=> 'Continue enrollment?',

   'Contribution to course discussion of resource'
=> 'Contribution to course discussion of resource',

   'Copied metadata'
=> 'Copied metadata',

   'Copied old metadata'
=> 'Copied old metadata',

   'Copied old target file'
=> 'Copied old target file',

   'Copied source file'
=> 'Copied source file',

   'Copy current file to'
=> 'Copy current file to',

   'Copy selected'
=> 'Copy selected',

   'Copy this column'
=> 'Copy this column',

   'Copying file'
=> 'Copying file',

   'Copyright'
=> 'Copyright',

   'Copyright/Distribution'
=> 'Copyright/Distribution',

   'Correct Option:'
=> 'Correct Option:',

   'Could Not Process Request'
=> 'Could Not Process Request',

   'Could not write metadata'
=> 'Could not write metadata',

   'Course'
=> 'Course',

   'Course Assessment Parameter - Helper Mode'
=> 'Course Assessment Parameter - Helper Mode',

   'Course Assessment Parameters - Overview Mode'
=> 'Course Assessment Parameters - Overview Mode',

   'Course Assessments Parameters - Table Mode'
=> 'Course Assessments Parameters - Table Mode',

   'Course Code'
=> 'Course Code',

   'Course Content'
=> 'Course Content',

   'Course Coordinator'
=> 'Course Coordinator',

   'Course Data'
=> 'Course Data',

   'Course Description'
=> 'Course Description',

   'Course Documents'
=> 'Course Documents',

   'Course Environment Parameters'
=> 'Course Environment Parameters',

   'Course Home Server'
=> 'Course Home Server',

   'Course ID'
=> 'Course ID',

   'Course ID or number'
=> 'Course ID or number',

   'Course ID/Number'
=> 'Course ID/Number',

   'Course Information'
=> 'Course Information',

   'Course Initialization Helper'
=> 'Course Initialization Helper',

   'Course Level'
=> 'Course Level',

   'Course Parameter Helper'
=> 'Course Parameter Helper',

   'Course Search'
=> 'Course Search',

   'Course Statistics and Charts'
=> 'Course Statistics and Charts',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.',

   'Course Title'
=> 'Course Title',

   'Course announcements and my calendar'
=> 'Course announcements and my calendar',

   'Course default for all problems'
=> 'Course default for all problems',

   'Course level sheet'
=> 'Course level sheet',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',

   'Coursepack'
=> 'Coursepack',

   'Courses'
=> 'Courses',

   'Create'
=> 'Create',

   'Create New Environment Variable'
=> 'Create New Environment Variable',

   'Create New User'
=> 'Create New User',

   'Create User'
=> 'Create User',

   'Create Users, Change User Privileges'
=> 'Create Users, Change User Privileges',

   'Create a New Course'
=> 'Create a New Course',

   'Create a new course'
=> 'Create a new course',

   'Create a user or modify the roles and privileges of a user'
=> 'Create a user or modify the roles and privileges of a user',

   'Creating a new'
=> 'Creating a new',

   'Creation Date'
=> 'Creation Date',

   'Critical Messages'
=> 'Critical Messages',

   'Crosslisted courses'
=> 'Crosslisted courses',

   'Current'
=> 'Current',

   'Current Class List'
=> 'Current Class List',

   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',

   'Current Ending Date: not set'
=> 'Current Ending Date: not set',

   'Current Month'
=> 'Current Month',

   'Current Resource'
=> 'Current Resource',

   'Current Session Value'
=> 'Current Session Value',

   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',

   'Current Starting Date: not set'
=> 'Current Starting Date: not set',

   'Current Version'
=> 'Current Version',

   'Currently no active roles or courses'
=> 'Currently no active roles or courses',

   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',

   'Currently not available'
=> 'Currently not available',

   'Currently selected. '
=> 'Currently selected. ',

   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',

   'Custom Distribution File'
=> 'Custom Distribution File',

   'Custom Role Editor'
=> 'Custom Role Editor',

   'Customized right of use ...	'
=> 'Customized right of use ...	',

   'Cut selected'
=> 'Cut selected',

   'Date'
=> 'Date',

   'Deadlines'
=> 'Deadlines',

   'December'
=> 'December',

   'Decompress'
=> 'Decompress',

   'Default'
=> 'Default',

   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',

   'Default Cataloging Information for Directory'
=> 'Default Cataloging Information for Directory',

   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',

   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',

   'Default Value'
=> 'Default Value',

   'Default XML Style File'
=> 'Default XML Style File',

   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',

   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',

   'Default for new courses is'
=> 'Default for new courses is',

   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',

   'Default:'
=> 'Default:',

   'Define Role'
=> 'Define Role',

   'Degree of difficulty'
=> 'Degree of difficulty',

   'Delete'
=> 'Delete',

   'Delete Checked'
=> 'Delete Checked',

   'Delete a role'
=> 'Delete a role',

   'Delete an option'
=> 'Delete an option',

   'Delete messages from bulletin boards'
=> 'Delete messages from bulletin boards',

   'Delete:'
=> 'Delete:',

   'Dependencies'
=> 'Dependencies',

   'Description:'
=> 'Description:',

   'Detailed Citation View'
=> 'Detailed Citation View',

   'Detailed Problem Analysis'
=> 'Detailed Problem Analysis',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Detailed statistics and graphs of student performance on problems.',

   'Differences'
=> 'Differences',

   'Diffs'
=> 'Diffs',

   'Diffs with Current Version'
=> 'Diffs with Current Version',

   'Diffs with Version'
=> 'Diffs with Version',

   'Diffs with current Version'
=> 'Diffs with current Version',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)',

   'Disable all communication among students'
=> 'Disable all communication among students',

   'Disable display of problem receipts'
=> 'Disable display of problem receipts',

   'Disable student resource discussion'
=> 'Disable student resource discussion',

   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',

   'Disagree'
=> 'Disagree',

   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',

   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',

   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',

   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',

   'Discard Edits and View'
=> 'Discard Edits and View',

   'Discard Selected'
=> 'Discard Selected',

   'Discussion Contributions'
=> 'Discussion Contributions',

   'Discussion Participation'
=> 'Discussion Participation',

   'Discussions'
=> 'Discussions',

   'Display'
=> 'Display',

   'Display All Messages'
=> 'Display All Messages',

   'Display all Messages'
=> 'Display all Messages',

   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments.',

   'Display file attributes'
=> 'Display file attributes',

   'Display foils in order given'
=> 'Display foils in order given',

   'Display foils in random order'
=> 'Display foils in random order',

   'Distribute Messages from Uploaded File to Course'
=> 'Distribute Messages from Uploaded File to Course',

   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',

   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',

   'DoDiff'
=> 'DoDiff',

   'Domain'
=> 'Domain',

   'Domain Coordinator'
=> 'Domain Coordinator',

   'Domain Guest'
=> 'Domain Guest',

   'Domain Level'
=> 'Domain Level',

   'Domain only - use limited to courses in the domain'
=> 'Domain only - use limited to courses in the domain',

   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Done'
=> 'Done',

   'Drop Students'
=> 'Drop Students',

   'Drop/Add students in this course'
=> 'Drop/Add students in this course',

   'Dropped [_1]'
=> 'Dropped [_1]',

   'Dropped [_1] student(s).'
=> 'Dropped [_1] student(s).',

   'Dropping Students'
=> 'Dropping Students',

   'Due'
=> 'Due',

   'Due Date (contentclose)'
=> 'Due Date (contentclose)',

   'Due Date (duedate)'
=> 'Due Date (duedate)',

   'Dump Course DOCS'
=> 'Dump Course DOCS',

   'Dump Course DOCS to Construction Space'
=> 'Dump Course DOCS to Construction Space',

   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',

   'Dynamic Metadata'
=> 'Dynamic Metadata',

   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',

   'EMail Address'
=> 'EMail Address',

   'EMail and Messages'
=> 'EMail and Messages',

   'ERROR'
=> 'ERROR',

   'Edit'
=> 'Edit',

   'Edit Catalog Information'
=> 'Edit Catalog Information',

   'Edit Content of a Map'
=> 'Edit Content of a Map',

   'Edit Custom Role Privileges'
=> 'Edit Custom Role Privileges',

   'Edit Directory Catalog Information'
=> 'Edit Directory Catalog Information',

   'Edit and view documents included in this course'
=> 'Edit and view documents included in this course',

   'Edit this resource'
=> 'Edit this resource',

   'Edit/Modify DOCS'
=> 'Edit/Modify DOCS',

   'EditXML'
=> 'EditXML',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.',

   'Empty'
=> 'Empty',

   'Enclosing Map or Folder'
=> 'Enclosing Map or Folder',

   'End'
=> 'End',

   'End Helper'
=> 'End Helper',

   'End Time'
=> 'End Time',

   'Ending Date'
=> 'Ending Date',

   'English - ISO'
=> 'English - ISO',

   'Enroll One Student'
=> 'Enroll One Student',

   'Enroll a single student'
=> 'Enroll a single student',

   'Enroll as student'
=> 'Enroll as student',

   'Enrolling'
=> 'Enrolling',

   'Enrolling Student'
=> 'Enrolling Student',

   'Enrolling Students'
=> 'Enrolling Students',

   'Enrollment Manager'
=> 'Enrollment Manager',

   'Enrollment Status'
=> 'Enrollment Status',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',

   'Enter construction space as a co-author'
=> 'Enter construction space as a co-author',

   'Enter grades from check-out assessment resources'
=> 'Enter grades from check-out assessment resources',

   'Enter my portfolio space'
=> 'Enter my portfolio space',

   'Enter my resource construction space'
=> 'Enter my resource construction space',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Enter terms or phrases separated by search operators such as AND, OR, or NOT',

   'Enter the chatroom for the course'
=> 'Enter the chatroom for the course',

   'Entering Construction Space'
=> 'Entering Construction Space',

   'Entering course ...'
=> 'Entering course ...',

   'Error'
=> 'Error',

   'Error Messages'
=> 'Error Messages',

   'Error dropping [_1]:[_2]'
=> 'Error dropping [_1]:[_2]',

   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',

   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',

   'Essay, open end'
=> 'Essay, open end',

   'Evaluate Resource'
=> 'Evaluate Resource',

   'Evaluation Comments'
=> 'Evaluation Comments',

   'Evaluation Data'
=> 'Evaluation Data',

   'Evaluation Error '
=> 'Evaluation Error ',

   'Every problem in a particular folder'
=> 'Every problem in a particular folder',

   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',

   'Every problem in the course'
=> 'Every problem in the course',

   'Exam Information'
=> 'Exam Information',

   'Exam Problem'
=> 'Exam Problem',

   'Exam Proctor'
=> 'Exam Proctor',

   'Excel'
=> 'Excel',

   'Excel format'
=> 'Excel format',

   'Excused by instructor'
=> 'Excused by instructor',

   'Exit'
=> 'Exit',

   'Exit LON-CAPA'
=> 'Exit LON-CAPA',

   'Extent'
=> 'Extent',

   'External Resource'
=> 'External Resource',

   'FAIL'
=> 'FAIL',

   'Failed Access to Construction Space'
=> 'Failed Access to Construction Space',

   'Failed to copy source'
=> 'Failed to copy source',

   'Failed to write metadata copy'
=> 'Failed to write metadata copy',

   'False'
=> 'False',

   'February'
=> 'February',

   'Feedback Addresses for Course Content'
=> 'Feedback Addresses for Course Content',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',

   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',

   'Field'
=> 'Field',

   'Fielded Format'
=> 'Fielded Format',

   'File'
=> 'File',

   'File Category'
=> 'File Category',

   'File copied.'
=> 'File copied.',

   'Filenames in Construction Space'
=> 'Filenames in Construction Space',

   'Finalize Publication'
=> 'Finalize Publication',

   'Finish Course Initialization'
=> 'Finish Course Initialization',

   'Finish Helper'
=> 'Finish Helper',

   'First'
=> 'First',

   'First Name'
=> 'First Name',

   'First Resource'
=> 'First Resource',

   'Foil'
=> 'Foil',

   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',

   'Foils'
=> 'Foils',

   'Folder'
=> 'Folder',

   'Folder in Construction Space'
=> 'Folder in Construction Space',

   'Folder/Map'
=> 'Folder/Map',

   'For User'
=> 'For User',

   'For one or more students'
=> 'For one or more students',

   'Force publication of unmodified files'
=> 'Force publication of unmodified files',

   'Format:'
=> 'Format:',

   'Forward'
=> 'Forward',

   'Forwarded message from'
=> 'Forwarded message from',

   'Forwarding'
=> 'Forwarding',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.',

   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',

   'Frequency'
=> 'Frequency',

   'Fri'
=> 'Fri',

   'From'
=> 'From',

   'Full Update'
=> 'Full Update',

   'Full update (also print list of users not enrolled anymore)'
=> 'Full update (also print list of users not enrolled anymore)',

   'Functions'
=> 'Functions',

   'General Intro'
=> 'General Intro',

   'Generate Spreadsheet'
=> 'Generate Spreadsheet',

   'Generate Statistics'
=> 'Generate Statistics',

   'Generate messages from a file'
=> 'Generate messages from a file',

   'Generate new role ...'
=> 'Generate new role ...',

   'Generation'
=> 'Generation',

   'German - ISO'
=> 'German - ISO',

   'Getting Problem Variants'
=> 'Getting Problem Variants',

   'Go'
=> 'Go',

   'Go Back'
=> 'Go Back',

   'Go To My First Homework Problem'
=> 'Go To My First Homework Problem',

   'Go to ...'
=> 'Go to ...',

   'Go to the next resource in the course sequence'
=> 'Go to the next resource in the course sequence',

   'Go to the previous resource in the course sequence'
=> 'Go to the previous resource in the course sequence',

   'Goodbye'
=> 'Goodbye',

   'Grades Spreadsheet'
=> 'Grades Spreadsheet',

   'Grading'
=> 'Grading',

   'Grading Information'
=> 'Grading Information',

   'Grant/revoke Course Custom Role'
=> 'Grant/revoke Course Custom Role',

   'Grant/revoke role of Administrator'
=> 'Grant/revoke role of Administrator',

   'Grant/revoke role of Author'
=> 'Grant/revoke role of Author',

   'Grant/revoke role of Co-Author'
=> 'Grant/revoke role of Co-Author',

   'Grant/revoke role of Course Coordinator'
=> 'Grant/revoke role of Course Coordinator',

   'Grant/revoke role of Domain Coordinator'
=> 'Grant/revoke role of Domain Coordinator',

   'Grant/revoke role of Domain Guest'
=> 'Grant/revoke role of Domain Guest',

   'Grant/revoke role of Exam Proctor'
=> 'Grant/revoke role of Exam Proctor',

   'Grant/revoke role of Instructor'
=> 'Grant/revoke role of Instructor',

   'Grant/revoke role of Librarian'
=> 'Grant/revoke role of Librarian',

   'Grant/revoke role of Scantron Operator'
=> 'Grant/revoke role of Scantron Operator',

   'Grant/revoke role of Student'
=> 'Grant/revoke role of Student',

   'Grant/revoke role of Superuser'
=> 'Grant/revoke role of Superuser',

   'Grant/revoke role of Teaching Assistant'
=> 'Grant/revoke role of Teaching Assistant',

   'Greek Symbols'
=> 'Greek Symbols',

   'Group/Section'
=> 'Group/Section',

   'HTML'
=> 'HTML',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',

   'HTML character enties'
=> 'HTML character enties',

   'HTML in Discussions'
=> 'HTML in Discussions',

   'HTML/XML'
=> 'HTML/XML',

   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Height(pixel):'
=> 'Height(pixel):',

   'Help'
=> 'Help',

   'Help on Creating Courses'
=> 'Help on Creating Courses',

   'Helproom Hours'
=> 'Helproom Hours',

   'Hide'
=> 'Hide',

   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',

   'Highest Grade Level'
=> 'Highest Grade Level',

   'Hint Text'
=> 'Hint Text',

   'Home Server'
=> 'Home Server',

   'Homework problem'
=> 'Homework problem',

   'Host'
=> 'Host',

   'How do I create a CSV file from a spreadsheet'
=> 'How do I create a CSV file from a spreadsheet',

   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',

   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',

   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',

   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',

   'How should the results be printed?'
=> 'How should the results be printed?',

   'ID/Student Number'
=> 'ID/Student Number',

   'Identify fields'
=> 'Identify fields',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA.',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible.',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',

   'Ignore First Line'
=> 'Ignore First Line',

   'Illegal filename.'
=> 'Illegal filename.',

   'Image:'
=> 'Image:',

   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',

   'Import'
=> 'Import',

   'Import a published document'
=> 'Import a published document',

   'Import and Paste Area'
=> 'Import and Paste Area',

   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',

   'Incorrect'
=> 'Incorrect',

   'Incorrect Answers:'
=> 'Incorrect Answers:',

   'Initial Password'
=> 'Initial Password',

   'Institutional Information'
=> 'Institutional Information',

   'Instructor'
=> 'Instructor',

   'Instructor Information'
=> 'Instructor Information',

   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',

   'Internal Filename'
=> 'Internal Filename',

   'Internally authenticated'
=> 'Internally authenticated',

   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',

   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',

   'Invalid date entry'
=> 'Invalid date entry',

   'Invalid home server specified'
=> 'Invalid home server specified',

   'Invalid login mode or password.'
=> 'Invalid login mode or password.',

   'Invalid username or domain'
=> 'Invalid username or domain',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'It is recommended that you use an up-to-date virus scanner before handling this file.',

   'January'
=> 'January',

   'Japanese - UTF'
=> 'Japanese - UTF',

   'July'
=> 'July',

   'June'
=> 'June',

   'KEYWORDS'
=> 'KEYWORDS',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default)',

   'Kerberos authenticated'
=> 'Kerberos authenticated',

   'Keyword(s)'
=> 'Keyword(s)',

   'Keywords'
=> 'Keywords',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA Domain for Students',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager',

   'LON-CAPA Help'
=> 'LON-CAPA Help',

   'LON-CAPA Helper:'
=> 'LON-CAPA Helper:',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA domain: [_1]',

   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',

   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'LaTeX mode:'
=> 'LaTeX mode:',

   'Landscape'
=> 'Landscape',

   'Language'
=> 'Language',

   'Languages used'
=> 'Languages used',

   'Last'
=> 'Last',

   'Last Modified'
=> 'Last Modified',

   'Last Name'
=> 'Last Name',

   'Last Name, First Names'
=> 'Last Name, First Names',

   'Last Week'
=> 'Last Week',

   'Last access'
=> 'Last access',

   'Last accessed'
=> 'Last accessed',

   'Last modified'
=> 'Last modified',

   'Last updated'
=> 'Last updated',

   'Launch Remote Control'
=> 'Launch Remote Control',

   'Launch navigation window'
=> 'Launch navigation window',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',

   'Librarian'
=> 'Librarian',

   'Limit by copyright/distribution'
=> 'Limit by copyright/distribution',

   'Limit by language'
=> 'Limit by language',

   'List Directory'
=> 'List Directory',

   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',

   'List of possible answers'
=> 'List of possible answers',

   'Load'
=> 'Load',

   'Load Map'
=> 'Load Map',

   'Load:'
=> 'Load:',

   'Location'
=> 'Location',

   'Lock and unlock assessments'
=> 'Lock and unlock assessments',

   'Log in'
=> 'Log in',

   'Logged Out'
=> 'Logged Out',

   'Login Data'
=> 'Login Data',

   'Login Type'
=> 'Login Type',

   'Logout'
=> 'Logout',

   'Lowest Grade Level'
=> 'Lowest Grade Level',

   'MIME Type'
=> 'MIME Type',

   'Mail'
=> 'Mail',

   'Main Course Documents'
=> 'Main Course Documents',

   'Main Menu'
=> 'Main Menu',

   'Make new directory'
=> 'Make new directory',

   'Make new file'
=> 'Make new file',

   'Make notes and annotations about this resource'
=> 'Make notes and annotations about this resource',

   'Making Backup to'
=> 'Making Backup to',

   'Manage Access Keys'
=> 'Manage Access Keys',

   'Manage access keys'
=> 'Manage access keys',

   'Manual Grading'
=> 'Manual Grading',

   'Map'
=> 'Map',

   'Map contents are not shown in order.'
=> 'Map contents are not shown in order.',

   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',

   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',

   'March'
=> 'March',

   'Mark Unread'
=> 'Mark Unread',

   'Mark all posts read'
=> 'Mark all posts read',

   'Material appears to be correct'
=> 'Material appears to be correct',

   'Material covered with sufficient depth'
=> 'Material covered with sufficient depth',

   'Material is helpful'
=> 'Material is helpful',

   'Material presented in clear way'
=> 'Material presented in clear way',

   'Max Number Of Shown Foils:'
=> 'Max Number Of Shown Foils:',

   'Max Possible To Date'
=> 'Max Possible To Date',

   'Max Tries'
=> 'Max Tries',

   'Max number of foils displayed'
=> 'Max number of foils displayed',

   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',

   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',

   'May'
=> 'May',

   'Mean Tries'
=> 'Mean Tries',

   'Messaging'
=> 'Messaging',

   'Metadata'
=> 'Metadata',

   'Metadata Information'
=> 'Metadata Information',

   'Metadata Version'
=> 'Metadata Version',

   'Metadata current version'
=> 'Metadata current version',

   'Middle'
=> 'Middle',

   'Middle Name'
=> 'Middle Name',

   'Middle Names/Initials'
=> 'Middle Names/Initials',

   'Mime type'
=> 'Mime type',

   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',

   'Modification Date'
=> 'Modification Date',

   'Modification may make assessment data inaccessible'
=> 'Modification may make assessment data inaccessible',

   'Modified'
=> 'Modified',

   'Modify Course Assessment Parameters'
=> 'Modify Course Assessment Parameters',

   'Modify Enrollment for'
=> 'Modify Enrollment for',

   'Modify Parameters'
=> 'Modify Parameters',

   'Modify User'
=> 'Modify User',

   'Modify another students data'
=> 'Modify another students data',

   'Modify authentication mechanism and data for a user'
=> 'Modify authentication mechanism and data for a user',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modify deadlines, etc, for this assessment resource',

   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',

   'Modify grades'
=> 'Modify grades',

   'Modify student data'
=> 'Modify student data',

   'Modify user grades for this assessment resource'
=> 'Modify user grades for this assessment resource',

   'Modifying data for user'
=> 'Modifying data for user',

   'Modifying this will make problems'
=> 'Modifying this will make problems',

   'Mon'
=> 'Mon',

   'Most recently published Version'
=> 'Most recently published Version',

   'Move Down'
=> 'Move Down',

   'Move Up'
=> 'Move Up',

   'Move current file to'
=> 'Move current file to',

   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',

   'My Personal Info'
=> 'My Personal Info',

   'My question/comment/feedback:'
=> 'My question/comment/feedback:',

   'Name'
=> 'Name',

   'Name of Role'
=> 'Name of Role',

   'Name starting with'
=> 'Name starting with',

   'Name:'
=> 'Name:',

   'Navigate'
=> 'Navigate',

   'Navigate Contents'
=> 'Navigate Contents',

   'Navigate Course Contents'
=> 'Navigate Course Contents',

   'Navigate the table of contents for this course'
=> 'Navigate the table of contents for this course',

   'Network-wide number of accesses (hits)'
=> 'Network-wide number of accesses (hits)',

   'Network-wide number of courses using resource'
=> 'Network-wide number of courses using resource',

   'New Directory'
=> 'New Directory',

   'New Folder'
=> 'New Folder',

   'New HTML file'
=> 'New HTML file',

   'New Messages'
=> 'New Messages',

   'New Problem Variation'
=> 'New Problem Variation',

   'New Randomization'
=> 'New Randomization',

   'New Resource'
=> 'New Resource',

   'New Role'
=> 'New Role',

   'New Search'
=> 'New Search',

   'New Title'
=> 'New Title',

   'New User'
=> 'New User',

   'New Value'
=> 'New Value',

   'New assembled page'
=> 'New assembled page',

   'New assembled sequence'
=> 'New assembled sequence',

   'New custom rights file'
=> 'New custom rights file',

   'New discussion since'
=> 'New discussion since',

   'New file'
=> 'New file',

   'New parameters or stored values'
=> 'New parameters or stored values',

   'New problem'
=> 'New problem',

   'New style file'
=> 'New style file',

   'New subdirectory'
=> 'New subdirectory',

   'Next'
=> 'Next',

   'Next    '
=> 'Next    ',

   'Next ->'
=> 'Next ->',

   'Next Month'
=> 'Next Month',

   'No'
=> 'No',

   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',

   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',

   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',

   'No Kerberos domain was specified.'
=> 'No Kerberos domain was specified.',

   'No Role, Cumulative Privileges'
=> 'No Role, Cumulative Privileges',

   'No changes were made to the current settings.'
=> 'No changes were made to the current settings.',

   'No content modifications yet.'
=> 'No content modifications yet.',

   'No due date'
=> 'No due date',

   'No language preference'
=> 'No language preference',

   'No new filename specified.'
=> 'No new filename specified.',

   'No previous versions published.'
=> 'No previous versions published.',

   'No role specified'
=> 'No role specified',

   'No section assigned'
=> 'No section assigned',

   'No such file'
=> 'No such file',

   'No syllabus information provided.'
=> 'No syllabus information provided.',

   'No upload file specified.'
=> 'No upload file specified.',

   'No write permission to'
=> 'No write permission to',

   'No write permission to user directory, FAIL'
=> 'No write permission to user directory, FAIL',

   'None Found'
=> 'None Found',

   'Not Allowed'
=> 'Not Allowed',

   'Not applicable - '
=> 'Not applicable - ',

   'Not open to be viewed'
=> 'Not open to be viewed',

   'Not set -'
=> 'Not set -',

   'Not set - '
=> 'Not set - ',

   'Not shown, not used'
=> 'Not shown, not used',

   'Note: for large courses, this operation may be time consuming'
=> 'Note: for large courses, this operation may be time consuming',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Note: it can take up to 10 minutes for changes to take effect for all users.',

   'Note: this will not take effect if the user already exists'
=> 'Note: this will not take effect if the user already exists',

   'Notes'
=> 'Notes',

   'Notification of enrollment changes'
=> 'Notification of enrollment changes',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'November'
=> 'November',

   'Number of Plots:'
=> 'Number of Plots:',

   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',

   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Number of bubbles in exam mode (numbubbles)',

   'Number of columns'
=> 'Number of columns',

   'Number of resources that follow this resource in maps'
=> 'Number of resources that follow this resource in maps',

   'Number of resources that lead up to this resource in maps'
=> 'Number of resources that lead up to this resource in maps',

   'Number of resources using or importing resource'
=> 'Number of resources using or importing resource',

   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',

   'Obsolete'
=> 'Obsolete',

   'Obsolete parameters or stored values'
=> 'Obsolete parameters or stored values',

   'October'
=> 'October',

   'Office Hours'
=> 'Office Hours',

   'Old Value'
=> 'Old Value',

   'One particular problem'
=> 'One particular problem',

   'One particular problem (overrides folder and course defaults)'
=> 'One particular problem (overrides folder and course defaults)',

   'Online Help'
=> 'Online Help',

   'Only Answers'
=> 'Only Answers',

   'Only a number required.'
=> 'Only a number required.',

   'Only domain coordinators can change a users password.'
=> 'Only domain coordinators can change a users password.',

   'Open'
=> 'Open',

   'Open All Folders'
=> 'Open All Folders',

   'Open Course'
=> 'Open Course',

   'Open all assessments'
=> 'Open all assessments',

   'Open and correct'
=> 'Open and correct',

   'Open with full tries'
=> 'Open with full tries',

   'Open, no due date'
=> 'Open, no due date',

   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',

   'Opening Date (opendate)'
=> 'Opening Date (opendate)',

   'Option Response Problem Analysis'
=> 'Option Response Problem Analysis',

   'Option response'
=> 'Option response',

   'Other Symbols'
=> 'Other Symbols',

   'Output'
=> 'Output',

   'Output Format'
=> 'Output Format',

   'Output Format: [_1]'
=> 'Output Format: [_1]',

   'Overall Problem Statistics'
=> 'Overall Problem Statistics',

   'Owner/Publisher'
=> 'Owner/Publisher',

   'Page'
=> 'Page',

   'Page layout'
=> 'Page layout',

   'Paper type'
=> 'Paper type',

   'Parameter'
=> 'Parameter',

   'Parameter Name'
=> 'Parameter Name',

   'Parameter Type'
=> 'Parameter Type',

   'Parameter in Effect'
=> 'Parameter in Effect',

   'Parent Directory'
=> 'Parent Directory',

   'Part'
=> 'Part',

   'Part Description (display)'
=> 'Part Description (display)',

   'Part is not open to be viewed. It'
=> 'Part is not open to be viewed. It',

   'Password'
=> 'Password',

   'Paste after selected'
=> 'Paste after selected',

   'Path'
=> 'Path',

   'Per Page'
=> 'Per Page',

   'Personal Data'
=> 'Personal Data',

   'Personal Information'
=> 'Personal Information',

   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please check at least one of the following feedback types:'
=> 'Please check at least one of the following feedback types:',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',

   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',

   'Please do not reply to this address.'
=> 'Please do not reply to this address.',

   'Please either'
=> 'Please either',

   'Please notify the server administrator '
=> 'Please notify the server administrator ',

   'Please pick a version to retrieve'
=> 'Please pick a version to retrieve',

   'Please rank the following criteria:'
=> 'Please rank the following criteria:',

   'Please select a problem to analyze'
=> 'Please select a problem to analyze',

   'Please select a report to generate'
=> 'Please select a report to generate',

   'Please select a report to generate.'
=> 'Please select a report to generate.',

   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',

   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',

   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',

   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',

   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',

   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',

   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',

   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',

   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',

   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',

   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',

   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',

   'Please stand by.'
=> 'Please stand by.',

   'Please use browser "Back" button and pick a filename'
=> 'Please use browser "Back" button and pick a filename',

   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",

   'Portrait'
=> 'Portrait',

   'Portuguese - ISO'
=> 'Portuguese - ISO',

   'Position'
=> 'Position',

   'Post Discussion'
=> 'Post Discussion',

   'Post anonymously'
=> 'Post anonymously',

   'Post discussion on course resources'
=> 'Post discussion on course resources',

   'Post system frontpage announcements'
=> 'Post system frontpage announcements',

   'Post to live chatrooms'
=> 'Post to live chatrooms',

   'Preferred language'
=> 'Preferred language',

   'Prepare a printable document'
=> 'Prepare a printable document',

   'Preparing Excel Spreadsheet'
=> 'Preparing Excel Spreadsheet',

   'Preparing Printout'
=> 'Preparing Printout',

   'Prerequisites'
=> 'Prerequisites',

   'Previous'
=> 'Previous',

   'Previous Month'
=> 'Previous Month',

   'Print'
=> 'Print',

   'Print Index:'
=> 'Print Index:',

   'Print Table of Contents:'
=> 'Print Table of Contents:',

   'Print:'
=> 'Print:',

   'Printing Helper'
=> 'Printing Helper',

   'Privacy Note'
=> 'Privacy Note',

   'Private - visible to author only for testing purposes'
=> 'Private - visible to author only for testing purposes',

   'Private Publication - did not synchronize database'
=> 'Private Publication - did not synchronize database',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',

   'Problem Status Chart'
=> 'Problem Status Chart',

   'Problems'
=> 'Problems',

   'Problems Not Contained In A Folder'
=> 'Problems Not Contained In A Folder',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.',

   'Problems from entire course'
=> 'Problems from entire course',

   'Processed [_1] student(s).'
=> 'Processed [_1] student(s).',

   'Processed file'
=> 'Processed file',

   'Processing'
=> 'Processing',

   'Processing course structure'
=> 'Processing course structure',

   'Processing first student'
=> 'Processing first student',

   'Produce Excel Output'
=> 'Produce Excel Output',

   'Project Information'
=> 'Project Information',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Provide feedback messages or contribute to the course discussion about this resource',

   'Provide my evaluation of this resource'
=> 'Provide my evaluation of this resource',

   'Public - no authentication or authorization required for use'
=> 'Public - no authentication or authorization required for use',

   'Publish'
=> 'Publish',

   'Publish Directory'
=> 'Publish Directory',

   'Publish Directory and Sub Directories'
=> 'Publish Directory and Sub Directories',

   'Publish this Resource'
=> 'Publish this Resource',

   'Published'
=> 'Published',

   'Publisher/Owner'
=> 'Publisher/Owner',

   'Publishing'
=> 'Publishing',

   'Question Text'
=> 'Question Text',

   'Question Type'
=> 'Question Type',

   'Question Type (type)'
=> 'Question Type (type)',

   'Question about resource content'
=> 'Question about resource content',

   'Question/Comment/Feedback about course policy'
=> 'Question/Comment/Feedback about course policy',

   'Quick Completed Problems Display'
=> 'Quick Completed Problems Display',

   'Random position'
=> 'Random position',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',

   'Randomization algorithm used'
=> 'Randomization algorithm used',

   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',

   'Re'
=> 'Re',

   'Re-Initialize'
=> 'Re-Initialize',

   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data.',

   'Reading results from'
=> 'Reading results from',

   'Reading results from [_1]'
=> 'Reading results from [_1]',

   'Readings'
=> 'Readings',

   'Receipt algorithm used'
=> 'Receipt algorithm used',

   'Receiving results from [_1]'
=> 'Receiving results from [_1]',

   'Recent'
=> 'Recent',

   'Record'
=> 'Record',

   'Registering'
=> 'Registering',

   'Related'
=> 'Related',

   'Remark'
=> 'Remark',

   'Rename'
=> 'Rename',

   'Rename current file to'
=> 'Rename current file to',

   'Reply'
=> 'Reply',

   'Report a Bug'
=> 'Report a Bug',

   'Reset Submissions'
=> 'Reset Submissions',

   'Resource'
=> 'Resource',

   'Resource Differences'
=> 'Resource Differences',

   'Resource Feedback and Discussion'
=> 'Resource Feedback and Discussion',

   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',

   'Resource Level'
=> 'Resource Level',

   'Resource Publication'
=> 'Resource Publication',

   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',

   'Resource is technically correct'
=> 'Resource is technically correct',

   'Resources'
=> 'Resources',

   'Resources from selected sequence in course'
=> 'Resources from selected sequence in course',

   'Response'
=> 'Response',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'Retrieval of an old version will overwrite the file currently in construction space',

   'Retrieve'
=> 'Retrieve',

   'Retrieve Old Version'
=> 'Retrieve Old Version',

   'Retrieve Published Resources'
=> 'Retrieve Published Resources',

   'Retrieve previous versions of'
=> 'Retrieve previous versions of',

   'Retrieve version'
=> 'Retrieve version',

   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',

   'Return to DOCS'
=> 'Return to DOCS',

   'Return to Last Location'
=> 'Return to Last Location',

   'Reverse Association'
=> 'Reverse Association',

   'Revert to Last Saved'
=> 'Revert to Last Saved',

   'Revision Date'
=> 'Revision Date',

   'Revoke'
=> 'Revoke',

   'Revoke Existing Roles'
=> 'Revoke Existing Roles',

   'Role'
=> 'Role',

   'Role Information'
=> 'Role Information',

   'Row'
=> 'Row',

   'Rule'
=> 'Rule',

   'Russian - KOI'
=> 'Russian - KOI',

   'S.D. tries'
=> 'S.D. tries',

   'Sample Points:'
=> 'Sample Points:',

   'Samples'
=> 'Samples',

   'Sat'
=> 'Sat',

   'Save'
=> 'Save',

   'Save as'
=> 'Save as',

   'Save as & Make This Sheet the Default'
=> 'Save as & Make This Sheet the Default',

   'Save as ...'
=> 'Save as ...',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',

   'Saving Modifications to'
=> 'Saving Modifications to',

   'Scantron Operator'
=> 'Scantron Operator',

   'Score Upload Form'
=> 'Score Upload Form',

   'Search'
=> 'Search',

   'Search Complete'
=> 'Search Complete',

   'Search Complete [_1]'
=> 'Search Complete [_1]',

   'Search the contents of this course'
=> 'Search the contents of this course',

   'Search the database of published resources'
=> 'Search the database of published resources',

   'Search: [_1]'
=> 'Search: [_1]',

   'Searching'
=> 'Searching',

   'Section'
=> 'Section',

   'Section/Group'
=> 'Section/Group',

   'Sections'
=> 'Sections',

   'Select'
=> 'Select',

   'Select Action'
=> 'Select Action',

   'Select All'
=> 'Select All',

   'Select All Files'
=> 'Select All Files',

   'Select All Published'
=> 'Select All Published',

   'Select All Resources'
=> 'Select All Resources',

   'Select All Students'
=> 'Select All Students',

   'Select Course'
=> 'Select Course',

   'Select Date'
=> 'Select Date',

   'Select Enclosing Map or Folder'
=> 'Select Enclosing Map or Folder',

   'Select Folder'
=> 'Select Folder',

   'Select Map'
=> 'Select Map',

   'Select Only Current Students'
=> 'Select Only Current Students',

   'Select Parameter Level'
=> 'Select Parameter Level',

   'Select Printing Options:'
=> 'Select Printing Options:',

   'Select Problem'
=> 'Select Problem',

   'Select Problem(s) to print'
=> 'Select Problem(s) to print',

   'Select Resource(s) to print'
=> 'Select Resource(s) to print',

   'Select Resources To Print'
=> 'Select Resources To Print',

   'Select Section'
=> 'Select Section',

   'Select Sequence To Print From'
=> 'Select Sequence To Print From',

   'Select Spreadsheet File'
=> 'Select Spreadsheet File',

   'Select Student'
=> 'Select Student',

   'Select Students and Resources'
=> 'Select Students and Resources',

   'Select Style File'
=> 'Select Style File',

   'Select User'
=> 'Select User',

   'Select a'
=> 'Select a',

   'Select a Course to Enter'
=> 'Select a Course to Enter',

   'Select a course'
=> 'Select a course',

   'Select a user name to modify the students information'
=> 'Select a user name to modify the students information',

   'Select a user name to view the users personal page.'
=> 'Select a user name to view the users personal page.',

   'Select for Section/Group'
=> 'Select for Section/Group',

   'Select resources for the assignment'
=> 'Select resources for the assignment',

   'Select the Construction Space'
=> 'Select the Construction Space',

   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',

   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',

   'Selecting a User'
=> 'Selecting a User',

   'Send Message to User(s)'
=> 'Send Message to User(s)',

   'Send New'
=> 'Send New',

   'Send Reply'
=> 'Send Reply',

   'Send Scantron data to a course'
=> 'Send Scantron data to a course',

   'Send and receive messages'
=> 'Send and receive messages',

   'Send as critical message'
=> 'Send as critical message',

   'Send broadcast and receipt-required email'
=> 'Send broadcast and receipt-required email',

   'Send internal email'
=> 'Send internal email',

   'Sending Messages'
=> 'Sending Messages',

   'September'
=> 'September',

   'Sequence'
=> 'Sequence',

   'Sequence or Folder'
=> 'Sequence or Folder',

   'Sequences and Folders'
=> 'Sequences and Folders',

   'Server'
=> 'Server',

   'Server Administration'
=> 'Server Administration',

   'Set'
=> 'Set',

   'Set Course Environment'
=> 'Set Course Environment',

   'Set Course Environment Parameters'
=> 'Set Course Environment Parameters',

   'Set Date'
=> 'Set Date',

   'Set Defaults for All Resources in Course'
=> 'Set Defaults for All Resources in Course',

   'Set End Date'
=> 'Set End Date',

   'Set Individual User Roles'
=> 'Set Individual User Roles',

   'Set Problem Tries'
=> 'Set Problem Tries',

   'Set Problem Weight'
=> 'Set Problem Weight',

   'Set Start Date'
=> 'Set Start Date',

   'Set Version to be used in Course'
=> 'Set Version to be used in Course',

   'Set Versions to be used in Course according to Selections below'
=> 'Set Versions to be used in Course according to Selections below',

   'Set a bookmark for this resource'
=> 'Set a bookmark for this resource',

   'Set a due date'
=> 'Set a due date',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions)',

   'Set an answer open date'
=> 'Set an answer open date',

   'Set an open date'
=> 'Set an open date',

   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',

   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',

   'Set answer open date for the selected problem for ...'
=> 'Set answer open date for the selected problem for ...',

   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',

   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Set deadlines and other assessment parameters, as well as modify course environment',

   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',

   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',

   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',

   'Set my user preferences'
=> 'Set my user preferences',

   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',

   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',

   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',

   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',

   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',

   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',

   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',

   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . .',

   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',

   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',

   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',

   'Set the number of tries'
=> 'Set the number of tries',

   'Set the problem weight'
=> 'Set the problem weight',

   'Set to ...'
=> 'Set to ...',

   'Set value to "[_1]" to allow'
=> 'Set value to "[_1]" to allow',

   'Set/Modify Course Assessment Parameter'
=> 'Set/Modify Course Assessment Parameter',

   'Set/Modify Course Assessment Parameters'
=> 'Set/Modify Course Assessment Parameters',

   'Set/Modify Course Parameters'
=> 'Set/Modify Course Parameters',

   'Setting the [_1]'
=> 'Setting the [_1]',

   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',

   'Shared by course faculty and staff'
=> 'Shared by course faculty and staff',

   'Short string response'
=> 'Short string response',

   'Show Answer'
=> 'Show Answer',

   'Show Feedback'
=> 'Show Feedback',

   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',

   'Show More Options'
=> 'Show More Options',

   'Show Only Uncompleted Homework'
=> 'Show Only Uncompleted Homework',

   'Show Preview'
=> 'Show Preview',

   'Show Problem Completeness'
=> 'Show Problem Completeness',

   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',

   'Show all roles'
=> 'Show all roles',

   'Show all rles'
=> 'Show all rles',

   'Show always at bottom position'
=> 'Show always at bottom position',

   'Show always at top position'
=> 'Show always at top position',

   'Show catalog information'
=> 'Show catalog information',

   'Show resource'
=> 'Show resource',

   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Significant figures are incorrect, submission was not graded.'
=> 'Significant figures are incorrect, submission was not graded.',

   'Simple Edit'
=> 'Simple Edit',

   'Simple Page'
=> 'Simple Page',

   'Simple Problem'
=> 'Simple Problem',

   'Simple Problem Editor'
=> 'Simple Problem Editor',

   'Since Start of Course'
=> 'Since Start of Course',

   'Since Yesterday'
=> 'Since Yesterday',

   'Size'
=> 'Size',

   'Size:'
=> 'Size:',

   'Skew Tries'
=> 'Skew Tries',

   'Some items were not submitted'
=> 'Some items were not submitted',

   'Some parts were not submitted.'
=> 'Some parts were not submitted.',

   'Sorry ...'
=> 'Sorry ...',

   'Space separated'
=> 'Space separated',

   'Special Documents'
=> 'Special Documents',

   'Special documents'
=> 'Special documents',

   'Spreadsheet Computation'
=> 'Spreadsheet Computation',

   'Spreadsheet Computation Status'
=> 'Spreadsheet Computation Status',

   'Standards'
=> 'Standards',

   'Start'
=> 'Start',

   'Start Time'
=> 'Start Time',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",

   'Starting'
=> 'Starting',

   'Starting Date'
=> 'Starting Date',

   'Starting and Ending Dates'
=> 'Starting and Ending Dates',

   'Statistics'
=> 'Statistics',

   'Statistics and Problem Analysis'
=> 'Statistics and Problem Analysis',

   'Status'
=> 'Status',

   'Store'
=> 'Store',

   'Store Catalog Information'
=> 'Store Catalog Information',

   'Store Changes'
=> 'Store Changes',

   'Store uploaded file as '
=> 'Store uploaded file as ',

   'Strongly Agree'
=> 'Strongly Agree',

   'Strongly Disagree'
=> 'Strongly Disagree',

   'Student'
=> 'Student',

   'Student Data Compilation Progress'
=> 'Student Data Compilation Progress',

   'Student Data Compilation Status'
=> 'Student Data Compilation Status',

   'Student ID'
=> 'Student ID',

   'Student Information'
=> 'Student Information',

   'Student Name'
=> 'Student Name',

   'Student Number'
=> 'Student Number',

   'Student Sheet Links'
=> 'Student Sheet Links',

   'Student Status'
=> 'Student Status',

   'Student Status: [_1]'
=> 'Student Status: [_1]',

   'Student information updated successfully.'
=> 'Student information updated successfully.',

   'Student level sheet'
=> 'Student level sheet',

   'Student performance statistics on all problems.'
=> 'Student performance statistics on all problems.',

   'Students Affected'
=> 'Students Affected',

   'Students need access key to enter course'
=> 'Students need access key to enter course',

   'Students with expired roles'
=> 'Students with expired roles',

   'Subject'
=> 'Subject',

   'Subject:'
=> 'Subject:',

   'Submission Time Analysis'
=> 'Submission Time Analysis',

   'Submissions'
=> 'Submissions',

   'Submit'
=> 'Submit',

   'Submit Answer'
=> 'Submit Answer',

   'Submit Changes'
=> 'Submit Changes',

   'Submit Changes and Edit'
=> 'Submit Changes and Edit',

   'Submit Changes and View'
=> 'Submit Changes and View',

   'Submit Modifications'
=> 'Submit Modifications',

   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',

   'Successful Login'
=> 'Successful Login',

   'Suggested Replacement for Obsolete File'
=> 'Suggested Replacement for Obsolete File',

   'Summary'
=> 'Summary',

   'Summary View'
=> 'Summary View',

   'Sun'
=> 'Sun',

   'Supplemental Course Documents'
=> 'Supplemental Course Documents',

   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',

   'Switch Server'
=> 'Switch Server',

   'Switch to another course'
=> 'Switch to another course',

   'Switch to another user role'
=> 'Switch to another user role',

   'Switching Role'
=> 'Switching Role',

   'Syllabus'
=> 'Syllabus',

   'Symbol'
=> 'Symbol',

   'Synchronized SQL metadata database'
=> 'Synchronized SQL metadata database',

   'System'
=> 'System',

   'System Administration'
=> 'System Administration',

   'System Level'
=> 'System Level',

   'System wide - can be used for any courses system wide'
=> 'System wide - can be used for any courses system wide',

   'System wide - open source to all authors'
=> 'System wide - open source to all authors',

   'Tabulator separated'
=> 'Tabulator separated',

   'Target'
=> 'Target',

   'Target Edit Map'
=> 'Target Edit Map',

   'Task'
=> 'Task',

   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',

   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',

   'TeXWidth(mm):'
=> 'TeXWidth(mm):',

   'Teaching Assistant'
=> 'Teaching Assistant',

   'Template'
=> 'Template',

   'Temporary Assembly Workspace'
=> 'Temporary Assembly Workspace',

   'Text'
=> 'Text',

   'Text Block'
=> 'Text Block',

   'Textbook'
=> 'Textbook',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.',

   'The error reported was'
=> 'The error reported was',

   'The extension on this file'
=> 'The extension on this file',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'The filetype extension of the file you uploaded is not allowed.',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.',

   'The material appears to be correct '
=> 'The material appears to be correct ',

   'The material is helpful '
=> 'The material is helpful ',

   'The material is presented in a clear way '
=> 'The material is presented in a clear way ',

   'The optional email address field was not specified.'
=> 'The optional email address field was not specified.',

   'The optional name field was not specified.'
=> 'The optional name field was not specified.',

   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified.',

   'The optional student number field was not specified.'
=> 'The optional student number field was not specified.',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',

   'The requested file'
=> 'The requested file',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) ',

   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',

   'The submitted answer was too long.'
=> 'The submitted answer was too long.',

   'The target is an existing directory.'
=> 'The target is an existing directory.',

   'Then'
=> 'Then',

   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',

   'There are currently no results'
=> 'There are currently no results',

   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',

   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',

   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',

   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',

   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',

   'There are no students currently enrolled.'
=> 'There are no students currently enrolled.',

   'There are no students in the course.'
=> 'There are no students in the course.',

   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',

   'There is no student data for this problem.'
=> 'There is no student data for this problem.',

   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',

   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'This is an automatic message generated by the LON-CAPA system.',

   'This question expects a numeric answer.'
=> 'This question expects a numeric answer.',

   'This resource has been marked obsolete by the author(s)'
=> 'This resource has been marked obsolete by the author(s)',

   'This resource might be part of another course.'
=> 'This resource might be part of another course.',

   'This syllabus can be publicly viewed at'
=> 'This syllabus can be publicly viewed at',

   'Threaded View'
=> 'Threaded View',

   'Thu'
=> 'Thu',

   'Time'
=> 'Time',

   'Title'
=> 'Title',

   'To'
=> 'To',

   'To create a new'
=> 'To create a new',

   'Top Level Map'
=> 'Top Level Map',

   'Topic'
=> 'Topic',

   'Total'
=> 'Total',

   'Total Parts In Course'
=> 'Total Parts In Course',

   'Total number of records found in file: [_1].'
=> 'Total number of records found in file: [_1].',

   'Total number of students who have worked on this problem'
=> 'Total number of students who have worked on this problem',

   'Tries'
=> 'Tries',

   'True'
=> 'True',

   'Tue'
=> 'Tue',

   'Turkish - ISO'
=> 'Turkish - ISO',

   'Type'
=> 'Type',

   'Type Name Here'
=> 'Type Name Here',

   'Type in value'
=> 'Type in value',

   'Type-in value'
=> 'Type-in value',

   'Type:'
=> 'Type:',

   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',

   'UNIX authenticated'
=> 'UNIX authenticated',

   'URL'
=> 'URL',

   'URLs To Include in Syllabus'
=> 'URLs To Include in Syllabus',

   'USERS'
=> 'USERS',

   'Unable to connect to database!'
=> 'Unable to connect to database!',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Unable to determine if this resource is open due to network problems. Please try again later.',

   'Unable to enroll'
=> 'Unable to enroll',

   'Unable to enroll students'
=> 'Unable to enroll students',

   'Unable to find'
=> 'Unable to find',

   'Unable to make backup'
=> 'Unable to make backup',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',

   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',

   'Unable to set default dates for course'
=> 'Unable to set default dates for course',

   'Unable to understand formula'
=> 'Unable to understand formula',

   'Unable to undo, unable to switch'
=> 'Unable to undo, unable to switch',

   'Unable to write to'
=> 'Unable to write to',

   'Unavailable course'
=> 'Unavailable course',

   'Uncheck All'
=> 'Uncheck All',

   'Uncompleted Homework'
=> 'Uncompleted Homework',

   'Undetermined - ISO'
=> 'Undetermined - ISO',

   'Undid changes, Switched'
=> 'Undid changes, Switched',

   'Unit:'
=> 'Unit:',

   'Units incorrect.'
=> 'Units incorrect.',

   'Units required'
=> 'Units required',

   'Unknown Action'
=> 'Unknown Action',

   'Unknown ID'
=> 'Unknown ID',

   'Unknown message'
=> 'Unknown message',

   'Unknown user'
=> 'Unknown user',

   'Unpublished'
=> 'Unpublished',

   'Unselect All'
=> 'Unselect All',

   'Unselect All Files'
=> 'Unselect All Files',

   'Unselect All Published'
=> 'Unselect All Published',

   'Unselect All Resources'
=> 'Unselect All Resources',

   'Unselect All Students'
=> 'Unselect All Students',

   'Unselect for Section/Group'
=> 'Unselect for Section/Group',

   'Unsuccessful Login'
=> 'Unsuccessful Login',

   'Unsupported character combination'
=> 'Unsupported character combination',

   'Up'
=> 'Up',

   'Update Course Assessment Parameter Display'
=> 'Update Course Assessment Parameter Display',

   'Update Display'
=> 'Update Display',

   'Update Section or Specific User'
=> 'Update Section or Specific User',

   'Update Student Data'
=> 'Update Student Data',

   'Updating discussion time'
=> 'Updating discussion time',

   'Upload Document'
=> 'Upload Document',

   'Upload Scantron data'
=> 'Upload Scantron data',

   'Upload a Photo'
=> 'Upload a Photo',

   'Upload a class list'
=> 'Upload a class list',

   'Upload a new main course document'
=> 'Upload a new main course document',

   'Upload a new supplemental course document'
=> 'Upload a new supplemental course document',

   'Upload class list'
=> 'Upload class list',

   'Upload file'
=> 'Upload file',

   'Upload file to Construction Space'
=> 'Upload file to Construction Space',

   'Uploaded'
=> 'Uploaded',

   'Uploaded Document'
=> 'Uploaded Document',

   'Uploading Class List'
=> 'Uploading Class List',

   'Use or edit my bookmark collection'
=> 'Use or edit my bookmark collection',

   'User'
=> 'User',

   'User Load'
=> 'User Load',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'User Notes, Records of Face-to-Face Discussions, and Critical Messages',

   'User Role'
=> 'User Role',

   'User Roles'
=> 'User Roles',

   'Username'
=> 'Username',

   'Users with Roles Assigned by'
=> 'Users with Roles Assigned by',

   'VIEW'
=> 'VIEW',

   'Value'
=> 'Value',

   'Verify Content'
=> 'Verify Content',

   'Verify Course Documents'
=> 'Verify Course Documents',

   'Verify Selection'
=> 'Verify Selection',

   'Version'
=> 'Version',

   'Version Number'
=> 'Version Number',

   'Version changes since Yesterday'
=> 'Version changes since Yesterday',

   'Version changes since last Month'
=> 'Version changes since last Month',

   'Version changes since last Week'
=> 'Version changes since last Week',

   'Version changes since start of Course'
=> 'Version changes since start of Course',

   'Version used in Course'
=> 'Version used in Course',

   'View'
=> 'View',

   'View All Messages'
=> 'View All Messages',

   'View Class List'
=> 'View Class List',

   'View Critical Messages'
=> 'View Critical Messages',

   'View Published Version'
=> 'View Published Version',

   'View course assessment statistics'
=> 'View course assessment statistics',

   'View documents included in this course'
=> 'View documents included in this course',

   'View file'
=> 'View file',

   'View the FAQ'
=> 'View the FAQ',

   'View the course assessment progress chart'
=> 'View the course assessment progress chart',

   'View user submissions for this assessment resource'
=> 'View user submissions for this assessment resource',

   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',

   'Warning!'
=> 'Warning!',

   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',

   'Warning: target file exists!'
=> 'Warning: target file exists!',

   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',

   'Was due'
=> 'Was due',

   'Web Links'
=> 'Web Links',

   'Web References'
=> 'Web References',

   'Wed'
=> 'Wed',

   'Weight (weight)'
=> 'Weight (weight)',

   'Welcome'
=> 'Welcome',

   'Welcome to Your New LON-CAPA Course'
=> 'Welcome to Your New LON-CAPA Course',

   'Welcome to the Assignment Parameter Helper'
=> 'Welcome to the Assignment Parameter Helper',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up',

   'What parameter do you want to set for all problems in the course?'
=> 'What parameter do you want to set for all problems in the course?',

   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',

   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',

   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',

   'What should the due date be set to?'
=> 'What should the due date be set to?',

   'What should the opening date be set to?'
=> 'What should the opening date be set to?',

   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',

   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',

   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',

   'Which Problem or Problems?'
=> 'Which Problem or Problems?',

   'Which problems do you wish to set a parameter for?'
=> 'Which problems do you wish to set a parameter for?',

   'Width'
=> 'Width',

   'Width(pixel):'
=> 'Width(pixel):',

   'With Answers'
=> 'With Answers',

   'Without Answers'
=> 'Without Answers',

   'Words'
=> 'Words',

   'Wrote Metadata'
=> 'Wrote Metadata',

   'XML/SGML'
=> 'XML/SGML',

   'Yes'
=> 'Yes',

   'You are correct.'
=> 'You are correct.',

   'You are excused from the problem.'
=> 'You are excused from the problem.',

   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',

   'You did not select a template.'
=> 'You did not select a template.',

   'You do not have authoring privileges for this resource'
=> 'You do not have authoring privileges for this resource',

   'You have entered that answer before'
=> 'You have entered that answer before',

   'You have no critical messages.'
=> 'You have no critical messages.',

   'You have no unread messages'
=> 'You have no unread messages',

   'You have provided an invalid ranking'
=> 'You have provided an invalid ranking',

   'You must choose an authentication type.'
=> 'You must choose an authentication type.',

   'You must choose at least one student to continue.'
=> 'You must choose at least one student to continue.',

   'You must choose one or more choices to continue.'
=> 'You must choose one or more choices to continue.',

   'You need to choose another user role or enter a specific course for this function'
=> 'You need to choose another user role or enter a specific course for this function',

   'You need to specify the Kerberos domain.'
=> 'You need to specify the Kerberos domain.',

   'You need to specify the initial password.'
=> 'You need to specify the initial password.',

   'You need to specify the username field.'
=> 'You need to specify the username field.',

   'Your Excel Spreadsheet'
=> 'Your Excel Spreadsheet',

   'Your Version Settings have been Stored'
=> 'Your Version Settings have been Stored',

   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.',

   'Your home server is '
=> 'Your home server is ',

   'Your receipt is'
=> 'Your receipt is',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',

   'Your submission has been recorded.'
=> 'Your submission has been recorded.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',

   '[_1] Do not change login data'
=> '[_1] Do not change login data',

   '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])'
=> '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2])',

   '[_1] Internally authenticated (mit Anfangspasswort [_2])'
=> '[_1] Internally authenticated (mit Anfangspasswort [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Internally authenticated (with initial password [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local Authentication with arguement [_2]',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',

   '[_1] Records per Page'
=> '[_1] Records per Page',

   '[_1] minutes'
=> '[_1] minutes',

   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',

   '[_1] with value [_2]'
=> '[_1] with value [_2]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',

   '[_2] seconds'
=> '[_2] seconds',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',

   'a.m.'
=> 'a.m.',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'abstract'
=> 'abstract',

   'acc keys'
=> 'acc keys',

   'acc keys[_1]'
=> 'acc keys[_1]',

   'access denied'
=> 'access denied',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'according to course preferences'
=> 'according to course preferences',

   'according to resource settings'
=> 'according to resource settings',

   'according to user session state'
=> 'according to user session state',

   'after selected'
=> 'after selected',

   'all'
=> 'all',

   'all resources in the course'
=> 'all resources in the course',

   'all students in course'
=> 'all students in course',

   'an indeterminate date'
=> 'an indeterminate date',

   'an unknown date'
=> 'an unknown date',

   'and'
=> 'and',

   'and return receipt'
=> 'and return receipt',

   'anno-'
=> 'anno-',

   'anno-[_1]'
=> 'anno-[_1]',

   'anno.gif'
=> 'anno.gif',

   'announce'
=> 'announce',

   'announce[_1]'
=> 'announce[_1]',

   'anonymous'
=> 'anonymous',

   'anonymous students'
=> 'anonymous students',

   'anot.gif'
=> 'anot.gif',

   'answer date'
=> 'answer date',

   'at'
=> 'at',

   'at Domain'
=> 'at Domain',

   'at domain'
=> 'at domain',

   'audio'
=> 'audio',

   'author'
=> 'author',

   'backward'
=> 'backward',

   'backward[_1]'
=> 'backward[_1]',

   'bchat.gif'
=> 'bchat.gif',

   'between'
=> 'between',

   'bookmark'
=> 'bookmark',

   'bookmark[_1]'
=> 'bookmark[_1]',

   'bookmark[_2]'
=> 'bookmark[_2]',

   'button'
=> 'button',

   'by'
=> 'by',

   'bytes'
=> 'bytes',

   'calendar'
=> 'calendar',

   'calendar[_1]'
=> 'calendar[_1]',

   'can not be accessed from your location.'
=> 'can not be accessed from your location.',

   'catalog'
=> 'catalog',

   'catalog.gif'
=> 'catalog.gif',

   'catalog[_1]'
=> 'catalog[_1]',

   'ccrs.gif'
=> 'ccrs.gif',

   'changes will not show until next login'
=> 'changes will not show until next login',

   'chart'
=> 'chart',

   'chart[_1]'
=> 'chart[_1]',

   'chat'
=> 'chat',

   'chat[_1]'
=> 'chat[_1]',

   'check all'
=> 'check all',

   'chmod error'
=> 'chmod error',

   'choose'
=> 'choose',

   'choose[_1]'
=> 'choose[_1]',

   'choose[_2]'
=> 'choose[_2]',

   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'click on the',

   'close this window'
=> 'close this window',

   'co con-'
=> 'co con-',

   'co con-[_1]'
=> 'co con-[_1]',

   'co res'
=> 'co res',

   'co res[_1]'
=> 'co res[_1]',

   'com.gif'
=> 'com.gif',

   'commu-'
=> 'commu-',

   'commu-[_1]'
=> 'commu-[_1]',

   'con-'
=> 'con-',

   'con-[_1]'
=> 'con-[_1]',

   'connection down'
=> 'connection down',

   'contacting'
=> 'contacting',

   'contacting [_1]'
=> 'contacting [_1]',

   'contents'
=> 'contents',

   'contents[_1]'
=> 'contents[_1]',

   'copy Error'
=> 'copy Error',

   'copyright'
=> 'copyright',

   'could not be copied.'
=> 'could not be copied.',

   'course'
=> 'course',

   'course[_10]'
=> 'course[_10]',

   'course[_11]'
=> 'course[_11]',

   'course[_1]'
=> 'course[_1]',

   'course[_2]'
=> 'course[_2]',

   'course[_3]'
=> 'course[_3]',

   'course[_4]'
=> 'course[_4]',

   'course[_5]'
=> 'course[_5]',

   'course[_6]'
=> 'course[_6]',

   'course[_7]'
=> 'course[_7]',

   'course[_8]'
=> 'course[_8]',

   'course[_9]'
=> 'course[_9]',

   'courses.gif'
=> 'courses.gif',

   'cprv.gif'
=> 'cprv.gif',

   'create'
=> 'create',

   'create[_1]'
=> 'create[_1]',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'currently does not exist',

   'custom'
=> 'custom',

   'custom distribution file'
=> 'custom distribution file',

   'customdistributionfile'
=> 'customdistributionfile',

   'date_am'
=> 'date_am',

   'date_days'
=> 'date_days',

   'date_locale'
=> 'date_locale',

   'date_months'
=> 'date_months',

   'date_pm'
=> 'date_pm',

   'default'
=> 'default',

   'directory'
=> 'directory',

   'discuss'
=> 'discuss',

   'discuss[_1]'
=> 'discuss[_1]',

   'docs'
=> 'docs',

   'docs.gif'
=> 'docs.gif',

   'docs[_1]'
=> 'docs[_1]',

   'docs[_2]'
=> 'docs[_2]',

   'domain'
=> 'domain',

   'due date'
=> 'due date',

   'during the last'
=> 'during the last',

   'edit'
=> 'edit',

   'edit crs'
=> 'edit crs',

   'edit crs[_1]'
=> 'edit crs[_1]',

   'egrd.gif'
=> 'egrd.gif',

   'ences'
=> 'ences',

   'ences[_1]'
=> 'ences[_1]',

   'enrl.gif'
=> 'enrl.gif',

   'enroll'
=> 'enroll',

   'enroll[_1]'
=> 'enroll[_1]',

   'enter'
=> 'enter',

   'enter[_1]'
=> 'enter[_1]',

   'eval.gif'
=> 'eval.gif',

   'evaluate'
=> 'evaluate',

   'evaluate[_1]'
=> 'evaluate[_1]',

   'exit'
=> 'exit',

   'exit[_1]'
=> 'exit[_1]',

   'expired or revoked'
=> 'expired or revoked',

   'extension'
=> 'extension',

   'external'
=> 'external',

   'fas'
=> 'fas',

   'fdbk.gif'
=> 'fdbk.gif',

   'feedback'
=> 'feedback',

   'feedback[_1]'
=> 'feedback[_1]',

   'file<br />extension'
=> 'file<br />extension',

   'first name'
=> 'first name',

   'for'
=> 'for',

   'for <b>all resources in the course</b>'
=> 'for <b>all resources in the course</b>',

   'for <b>all students in course</b>'
=> 'for <b>all students in course</b>',

   'for Enclosing Map or Folder'
=> 'for Enclosing Map or Folder',

   'for Resource'
=> 'for Resource',

   'for [_1]'
=> 'for [_1]',

   'for section [_1]'
=> 'for section [_1]',

   'for the map named [_1]'
=> 'for the map named [_1]',

   'for the resource named [_1]'
=> 'for the resource named [_1]',

   'for visible separation'
=> 'for visible separation',

   'forward'
=> 'forward',

   'forward[_1]'
=> 'forward[_1]',

   'from'
=> 'from',

   'from Enclosing Map or Folder'
=> 'from Enclosing Map or Folder',

   'from current subdirectory'
=> 'from current subdirectory',

   'general'
=> 'general',

   'generation'
=> 'generation',

   'grades'
=> 'grades',

   'grades[_1]'
=> 'grades[_1]',

   'grades[_2]'
=> 'grades[_2]',

   'grds.gif'
=> 'grds.gif',

   'have different numbers and answers'
=> 'have different numbers and answers',

   'helper'
=> 'helper',

   'htmlarea_lang'
=> 'htmlarea_lang',

   'in'
=> 'in',

   'in Course'
=> 'in Course',

   'in Section/Group'
=> 'in Section/Group',

   'in domain'
=> 'in domain',

   'info'
=> 'info',

   'instructor'
=> 'instructor',

   'interface available'
=> 'interface available',

   'internal'
=> 'internal',

   'is closed but you are allowed to view it'
=> 'is closed but you are allowed to view it',

   'is due at'
=> 'is due at',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',

   'is in under construction'
=> 'is in under construction',

   'is not analyzable at this time'
=> 'is not analyzable at this time',

   'is ready for download'
=> 'is ready for download',

   'keys.gif'
=> 'keys.gif',

   'keywords'
=> 'keywords',

   'language'
=> 'language',

   'last month'
=> 'last month',

   'last name'
=> 'last name',

   'last problem'
=> 'last problem',

   'last six months'
=> 'last six months',

   'last student'
=> 'last student',

   'last three months'
=> 'last three months',

   'last week'
=> 'last week',

   'last year'
=> 'last year',

   'library'
=> 'library',

   'library[_1]'
=> 'library[_1]',

   'log in again'
=> 'log in again',

   'loginproblems.html'
=> 'loginproblems.html',

   'logout.gif'
=> 'logout.gif',

   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',

   'manage'
=> 'manage',

   'manage[_1]'
=> 'manage[_1]',

   'may be open from a different computer.'
=> 'may be open from a different computer.',

   'may open later.'
=> 'may open later.',

   'middle name'
=> 'middle name',

   'midnight'
=> 'midnight',

   'minutes'
=> 'minutes',

   'missions'
=> 'missions',

   'most recent'
=> 'most recent',

   'movies'
=> 'movies',

   'my'
=> 'my',

   'my[_1]'
=> 'my[_1]',

   'name'
=> 'name',

   'name only visible to course faculty'
=> 'name only visible to course faculty',

   'nav.gif'
=> 'nav.gif',

   'navigate'
=> 'navigate',

   'navigate[_1]'
=> 'navigate[_1]',

   'never'
=> 'never',

   'nication'
=> 'nication',

   'nication[_1]'
=> 'nication[_1]',

   'no ending date'
=> 'no ending date',

   'noon'
=> 'noon',

   'not displayed'
=> 'not displayed',

   'not found'
=> 'not found',

   'notes'
=> 'notes',

   'num_override'
=> 'num_override',

   'number'
=> 'number',

   'number of tries'
=> 'number of tries',

   'obsolete'
=> 'obsolete',

   'obsolete replacement'
=> 'obsolete replacement',

   'obsoletereplacement'
=> 'obsoletereplacement',

   'of'
=> 'of',

   'only check if you know what you are doing'
=> 'only check if you know what you are doing',

   'only search domain'
=> 'only search domain',

   'opening date'
=> 'opening date',

   'optional'
=> 'optional',

   'or'
=> 'or',

   'or ID'
=> 'or ID',

   'or any other value'
=> 'or any other value',

   'p.m.'
=> 'p.m.',

   'pages'
=> 'pages',

   'parm.gif'
=> 'parm.gif',

   'parms'
=> 'parms',

   'parms[_1]'
=> 'parms[_1]',

   'part'
=> 'part',

   'percent'
=> 'percent',

   'pictures'
=> 'pictures',

   'please refer to'
=> 'please refer to',

   'pref.gif'
=> 'pref.gif',

   'prefer-'
=> 'prefer-',

   'prefer-[_1]'
=> 'prefer-[_1]',

   'prepare'
=> 'prepare',

   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',

   'printout'
=> 'printout',

   'private'
=> 'private',

   'problem'
=> 'problem',

   'problem statistics grouped by sequence'
=> 'problem statistics grouped by sequence',

   'problem statistics ungrouped'
=> 'problem statistics ungrouped',

   'problem statistics, Excel'
=> 'problem statistics, Excel',

   'problem weight'
=> 'problem weight',

   'prt.gif'
=> 'prt.gif',

   'public'
=> 'public',

   'publisher<br />owner'
=> 'publisher<br />owner',

   're-initializing course'
=> 're-initializing course',

   'remaining'
=> 'remaining',

   'res.gif'
=> 'res.gif',

   'resource'
=> 'resource',

   'resource[_1]'
=> 'resource[_1]',

   'resources'
=> 'resources',

   'role'
=> 'role',

   'role,role,...'
=> 'role,role,...',

   'role[_1]'
=> 'role[_1]',

   'role[_2]'
=> 'role[_2]',

   'roles'
=> 'roles',

   'roles.gif'
=> 'roles.gif',

   'roles[_1]'
=> 'roles[_1]',

   'sbkm.gif'
=> 'sbkm.gif',

   'scantron[_1]'
=> 'scantron[_1]',

   'search'
=> 'search',

   'search[_1]'
=> 'search[_1]',

   'search[_2]'
=> 'search[_2]',

   'second'
=> 'second',

   'seconds'
=> 'seconds',

   'seconds for'
=> 'seconds for',

   'section'
=> 'section',

   'selected students'
=> 'selected students',

   'send[_1]'
=> 'send[_1]',

   'sequence'
=> 'sequence',

   'set'
=> 'set',

   'set[_1]'
=> 'set[_1]',

   'space'
=> 'space',

   'space[_1]'
=> 'space[_1]',

   'space[_2]'
=> 'space[_2]',

   'spacer.gif'
=> 'spacer.gif',

   'spellcheck_lang'
=> 'spellcheck_lang',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'standard'
=> 'standard',

   'standard LaTeX mode'
=> 'standard LaTeX mode',

   'standard courses only'
=> 'standard courses only',

   'stat.gif'
=> 'stat.gif',

   'stats'
=> 'stats',

   'stats[_1]'
=> 'stats[_1]',

   'struct'
=> 'struct',

   'struct[_1]'
=> 'struct[_1]',

   'struct[_2]'
=> 'struct[_2]',

   'student'
=> 'student',

   'student name'
=> 'student name',

   'subject'
=> 'subject',

   'switch'
=> 'switch',

   'switch[_1]'
=> 'switch[_1]',

   'switch[_2]'
=> 'switch[_2]',

   'system wide'
=> 'system wide',

   'tations'
=> 'tations',

   'template'
=> 'template',

   'textual_remote_display'
=> 'textual_remote_display',

   'this'
=> 'this',

   'title'
=> 'title',

   'to'
=> 'to',

   'to [_1] ([_2])'
=> 'to [_1] ([_2])',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',

   'today'
=> 'today',

   'unable to enroll'
=> 'unable to enroll',

   'uncheck all'
=> 'uncheck all',

   'undo'
=> 'undo',

   'unless locked'
=> 'unless locked',

   'untitled'
=> 'untitled',

   'updated periodically'
=> 'updated periodically',

   'use related words'
=> 'use related words',

   'user'
=> 'user',

   'user[_1]'
=> 'user[_1]',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'username'
=> 'username',

   'users in'
=> 'users in',

   'vbkm.gif'
=> 'vbkm.gif',

   'versions of this problem'
=> 'versions of this problem',

   'versus'
=> 'versus',

   'view'
=> 'view',

   'view sub-'
=> 'view sub-',

   'view[_1]'
=> 'view[_1]',

   'visible to author and co-authors only'
=> 'visible to author and co-authors only',

   'waiting on'
=> 'waiting on',

   'waiting on [_1]'
=> 'waiting on [_1]',

   'warning(s)'
=> 'warning(s)',

   'was due on'
=> 'was due on',

   'what you just saw on the screen'
=> 'what you just saw on the screen',

   'will open on'
=> 'will open on',

   'with server'
=> 'with server',

   'yes'
=> 'yes',



#SYNC Tue Aug 15 18:55:41 2006
   ' [_1]'
=> ' [_1]',

   '"[_1]" for default hiding'
=> '"[_1]" for default hiding',

   '"[_1]" for visible separation'
=> '"[_1]" for visible separation',

   '"[_1]" if allowed, anything else if not'
=> '"[_1]" if allowed, anything else if not',

   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',

   '# 16 Aug 14:45'
=> '# 16 Aug 14:45',

   '# Do not translate this line.  [_1] is a check box'
=> '# Do not translate this line.  [_1] is a check box',

   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field',

   '# Do not translate this line.  [_1] is a column index.'
=> '# Do not translate this line.  [_1] is a column index.',

   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Do not translate this line.  [_1] is a drop-down box listing domains.',

   '# Do not translate this line.  [_1] is a username'
=> '# Do not translate this line.  [_1] is a username',

   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Do not translate this line.  [_1] is the number of students processed',

   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.',

   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Do not translate this line.  [_1] is username, [_2] is error message',

   '# Do not translate this line.  [_1] is username@domain'
=> '# Do not translate this line.  [_1] is username@domain',

   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Do not translate this line.  [_1] is username@domain [_2] is the error message.',

   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Do not translate this line.  [_1], [_3], and [_4] are check boxes',

   '# Do not translate this line.  [_2] is a text entry element'
=> '# Do not translate this line.  [_2] is a text entry element',

   '# [_1] is a drop-down selection box'
=> '# [_1] is a drop-down selection box',

   '# [_1] is a number [_2] is the current domain'
=> '# [_1] is a number [_2] is the current domain',

   '# [_1] is an html link to the current file '
=> '# [_1] is an html link to the current file ',

   '# _1 is a selection dialog'
=> '# _1 is a selection dialog',

   '# _1 is a server name'
=> '# _1 is a server name',

   '# _1 is search string'
=> '# _1 is search string',

   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'",

   '# mt fehlt'
=> '# mt fehlt',

   '#Stdnts'
=> '#Stdnts',

   '#YES'
=> '#YES',

   '#[_1] is the foil name'
=> '#[_1] is the foil name',

   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 is the foil name, _2 is the current value of the foil',

   '%Wrng'
=> '%Wrng',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Show&nbsp;All&nbsp;Foils',

   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.',

   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.',

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',

   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',

   ', and answers will be available on'
=> ', and answers will be available on',

   ', is reserved internally by LON-CAPA.'
=> ', is reserved internally by LON-CAPA.',

   ', or the next time you log in.'
=> ', or the next time you log in.',

   ', select a template from the pull-down menu below'
=> ', select a template from the pull-down menu below',

   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',

   '. . . for a particular section'
=> '. . . for a particular section',

   '. . . for all students in the course'
=> '. . . for all students in the course',

   '. . . for an individual student'
=> '. . . for an individual student',

   '1 am'
=> '1 am',

   '1 minute'
=> '1 minute',

   '1 out of N multiple choice (radio button)'
=> '1 out of N multiple choice (radio button)',

   '1 pm'
=> '1 pm',

   '10 am'
=> '10 am',

   '10 pm'
=> '10 pm',

   '11 am'
=> '11 am',

   '11 pm'
=> '11 pm',

   '12 am'
=> '12 am',

   '12 noon'
=> '12 noon',

   '2 am'
=> '2 am',

   '2 pm'
=> '2 pm',

   '3 am'
=> '3 am',

   '3 pm'
=> '3 pm',

   '4 am'
=> '4 am',

   '4 pm'
=> '4 pm',

   '5 am'
=> '5 am',

   '5 pm'
=> '5 pm',

   '6 am'
=> '6 am',

   '6 pm'
=> '6 pm',

   '7 am'
=> '7 am',

   '7 pm'
=> '7 pm',

   '8 am'
=> '8 am',

   '8 pm'
=> '8 pm',

   '9 am'
=> '9 am',

   '9 pm'
=> '9 pm',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',

   '<- Previous'
=> '<- Previous',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Unable to enroll: [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Unable to enroll.  No password specified.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>',

   'A score has been assigned.'
=> 'A score has been assigned.',

   'ABSTRACT'
=> 'ABSTRACT',

   'ALL'
=> 'ALL',

   'About Me'
=> 'About Me',

   'Abstract'
=> 'Abstract',

   'Access Control'
=> 'Access Control',

   'Access Key Management'
=> 'Access Key Management',

   'Access and Usage Statistics'
=> 'Access and Usage Statistics',

   'Actions'
=> 'Actions',

   'Activate'
=> 'Activate',

   'Add Roles'
=> 'Add Roles',

   'Add new option'
=> 'Add new option',

   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",

   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",

   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",

   'Additional Keywords'
=> 'Additional Keywords',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Additional Metadata (non-standard, parameters, exports)',

   'Additional Recipients'
=> 'Additional Recipients',

   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',

   'Administrator'
=> 'Administrator',

   'Advanced Catalog Search'
=> 'Advanced Catalog Search',

   'Advanced Edit'
=> 'Advanced Edit',

   'Advanced Search'
=> 'Advanced Search',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',

   'Agree'
=> 'Agree',

   'All Documents in Course'
=> 'All Documents in Course',

   'All Maps or Folders'
=> 'All Maps or Folders',

   'All Resources'
=> 'All Resources',

   'All Resources (possibly large output)'
=> 'All Resources (possibly large output)',

   'All Students'
=> 'All Students',

   'All homework is currently completed'
=> 'All homework is currently completed',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.',

   'All versions'
=> 'All versions',

   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',

   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',

   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',

   'An error occurred during the attempt to change the section for this student.'
=> 'An error occurred during the attempt to change the section for this student.',

   'An error occurred during the attempt to change the role information for this student.'
=> 'An error occurred during the attempt to change the role information for this student.',

   'Analyze Over '
=> 'Analyze Over ',

   'Analyze Problem'
=> 'Analyze Problem',

   'Analyze Problem Again'
=> 'Analyze Problem Again',

   'Analyze Progress'
=> 'Analyze Progress',

   'Analyze as '
=> 'Analyze as ',

   'Analyzing Results'
=> 'Analyzing Results',

   'Analyzing a problem'
=> 'Analyzing a problem',

   'Announcements and Calendar'
=> 'Announcements and Calendar',

   'Anonymous'
=> 'Anonymous',

   'Anonymous contribution to course discussion of resource'
=> 'Anonymous contribution to course discussion of resource',

   'Answer'
=> 'Answer',

   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',

   'Answer Submitted'
=> 'Answer Submitted',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',

   'Answer available'
=> 'Answer available',

   'Answer submitted'
=> 'Answer submitted',

   'Answer submitted, not yet graded'
=> 'Answer submitted, not yet graded',

   'Answer:'
=> 'Answer:',

   'Answerable'
=> 'Answerable',

   'Any Language'
=> 'Any Language',

   'Any User'
=> 'Any User',

   'Any category'
=> 'Any category',

   'Any comments? '
=> 'Any comments? ',

   'Any copyright/distribution'
=> 'Any copyright/distribution',

   'April'
=> 'April',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).',

   'Assessment'
=> 'Assessment',

   'Assessment Parameters'
=> 'Assessment Parameters',

   'Assessment URL and Title'
=> 'Assessment URL and Title',

   'Assigned User Roles'
=> 'Assigned User Roles',

   'Associate columns with student attributes.'
=> 'Associate columns with student attributes.',

   'Attachment'
=> 'Attachment',

   'Attribute'
=> 'Attribute',

   'August'
=> 'August',

   'Author'
=> 'Author',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Author and Co-Author roles may not be available on servers other than your home server.',

   'Author(s)'
=> 'Author(s)',

   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',

   'Automated adds'
=> 'Automated adds',

   'Automated drops'
=> 'Automated drops',

   'Automated enrollment settings'
=> 'Automated enrollment settings',

   'Average number of tries till solved'
=> 'Average number of tries till solved',

   'Back to'
=> 'Back to',

   'Back to Directory'
=> 'Back to Directory',

   'Back to Source'
=> 'Back to Source',

   'Back to Source Directory'
=> 'Back to Source Directory',

   'Bad Filename'
=> 'Bad Filename',

   'Became this version on ...'
=> 'Became this version on ...',

   'Begin Enrollment'
=> 'Begin Enrollment',

   'Binary File'
=> 'Binary File',

   'Blank'
=> 'Blank',

   'Brief view of each students performance in course.'
=> 'Brief view of each students performance in course.',

   'Broadcast Message to Course'
=> 'Broadcast Message to Course',

   'Browse'
=> 'Browse',

   'Browse Resources'
=> 'Browse Resources',

   'Browse published resources'
=> 'Browse published resources',

   'Browse resources'
=> 'Browse resources',

   'Browsing resource, all submissions are temporary.'
=> 'Browsing resource, all submissions are temporary.',

   'Bulletin Board'
=> 'Bulletin Board',

   'Bulletin Board/Discussion'
=> 'Bulletin Board/Discussion',

   'By'
=> 'By',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (comma separated values, spreadsheet)',

   'CSV format'
=> 'CSV format',

   'Calculate answers'
=> 'Calculate answers',

   'Calculate course grades (Spreadsheet)'
=> 'Calculate course grades (Spreadsheet)',

   'Calculations'
=> 'Calculations',

   'Cancel'
=> 'Cancel',

   'Cannot publish directory'
=> 'Cannot publish directory',

   'Cannot retrieve directory'
=> 'Cannot retrieve directory',

   'Catalog Information'
=> 'Catalog Information',

   'Catalog Search'
=> 'Catalog Search',

   'Change'
=> 'Change',

   'Change Random Seed To:'
=> 'Change Random Seed To:',

   'Change User Privileges'
=> 'Change User Privileges',

   'Change Your Language Preferences'
=> 'Change Your Language Preferences',

   'Change Your Preferences'
=> 'Change Your Preferences',

   'Changed discussion view mode'
=> 'Changed discussion view mode',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Changes can take up to 10 minutes before being active for all students.',

   'Changes will become active for your current session after'
=> 'Changes will become active for your current session after',

   'Chat Participation'
=> 'Chat Participation',

   'Check All'
=> 'Check All',

   'Check Course Document Versions'
=> 'Check Course Document Versions',

   'Check for All'
=> 'Check for All',

   'Check for None'
=> 'Check for None',

   'Check for Section/Group'
=> 'Check for Section/Group',

   'Check/Set Resource Versions'
=> 'Check/Set Resource Versions',

   'Choose a different resource'
=> 'Choose a different resource',

   'Choose the course to work on'
=> 'Choose the course to work on',

   'Choose the user role'
=> 'Choose the user role',

   'Chronological View'
=> 'Chronological View',

   'Class Hours'
=> 'Class Hours',

   'Clear All'
=> 'Clear All',

   'Clear Caches'
=> 'Clear Caches',

   'Click here for FAQ'
=> 'Click here for FAQ',

   'Click here for help'
=> 'Click here for help',

   'Click here to report bugs'
=> 'Click here to report bugs',

   'Click here to return to the chart.'
=> 'Click here to return to the chart.',

   "Click to download or use your browser's Save Link function"
=> "Click to download or use your browser's Save Link function",

   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',

   'Clone an existing course'
=> 'Clone an existing course',

   'Close'
=> 'Close',

   'Close All Folders'
=> 'Close All Folders',

   'Close This Window'
=> 'Close This Window',

   'Closed'
=> 'Closed',

   'Co-Author'
=> 'Co-Author',

   'Collapse Remote Control'
=> 'Collapse Remote Control',

   'Column'
=> 'Column',

   'Column&nbsp;[_1]'
=> 'Column&nbsp;[_1]',

   'Comma Separated Values'
=> 'Comma Separated Values',

   'Communication'
=> 'Communication',

   'Communication and Messages'
=> 'Communication and Messages',

   'Compact View'
=> 'Compact View',

   'Compare versions of'
=> 'Compare versions of',

   'Completed'
=> 'Completed',

   'Completely new course'
=> 'Completely new course',

   'Concept:'
=> 'Concept:',

   'Concepts'
=> 'Concepts',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.',

   'Construction Space'
=> 'Construction Space',

   'Construction Space Directory'
=> 'Construction Space Directory',

   'Construction Space File Operation'
=> 'Construction Space File Operation',

   'Construction Space Version'
=> 'Construction Space Version',

   'Contact'
=> 'Contact',

   'Contact Information'
=> 'Contact Information',

   'Content changed'
=> 'Content changed',

   'Continue'
=> 'Continue',

   'Continue enrollment?'
=> 'Continue enrollment?',

   'Contribution to course discussion of resource'
=> 'Contribution to course discussion of resource',

   'Copied metadata'
=> 'Copied metadata',

   'Copied old metadata'
=> 'Copied old metadata',

   'Copied old target file'
=> 'Copied old target file',

   'Copied source file'
=> 'Copied source file',

   'Copy current file to'
=> 'Copy current file to',

   'Copy selected'
=> 'Copy selected',

   'Copy this column'
=> 'Copy this column',

   'Copying file'
=> 'Copying file',

   'Copyright'
=> 'Copyright',

   'Copyright/Distribution'
=> 'Copyright/Distribution',

   'Correct Option:'
=> 'Correct Option:',

   'Could Not Process Request'
=> 'Could Not Process Request',

   'Could not write metadata'
=> 'Could not write metadata',

   'Course'
=> 'Course',

   'Course Assessment Parameter - Helper Mode'
=> 'Course Assessment Parameter - Helper Mode',

   'Course Assessment Parameters - Overview Mode'
=> 'Course Assessment Parameters - Overview Mode',

   'Course Assessments Parameters - Table Mode'
=> 'Course Assessments Parameters - Table Mode',

   'Course Code'
=> 'Course Code',

   'Course Content'
=> 'Course Content',

   'Course Coordinator'
=> 'Course Coordinator',

   'Course Data'
=> 'Course Data',

   'Course Description'
=> 'Course Description',

   'Course Documents'
=> 'Course Documents',

   'Course Environment Parameters'
=> 'Course Environment Parameters',

   'Course Home Server'
=> 'Course Home Server',

   'Course ID'
=> 'Course ID',

   'Course ID or number'
=> 'Course ID or number',

   'Course ID/Number'
=> 'Course ID/Number',

   'Course Information'
=> 'Course Information',

   'Course Initialization Helper'
=> 'Course Initialization Helper',

   'Course Level'
=> 'Course Level',

   'Course Parameter Helper'
=> 'Course Parameter Helper',

   'Course Search'
=> 'Course Search',

   'Course Statistics and Charts'
=> 'Course Statistics and Charts',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.',

   'Course Title'
=> 'Course Title',

   'Course announcements and my calendar'
=> 'Course announcements and my calendar',

   'Course default for all problems'
=> 'Course default for all problems',

   'Course level sheet'
=> 'Course level sheet',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',

   'Coursepack'
=> 'Coursepack',

   'Courses'
=> 'Courses',

   'Create'
=> 'Create',

   'Create New Environment Variable'
=> 'Create New Environment Variable',

   'Create New User'
=> 'Create New User',

   'Create User'
=> 'Create User',

   'Create Users, Change User Privileges'
=> 'Create Users, Change User Privileges',

   'Create a New Course'
=> 'Create a New Course',

   'Create a new course'
=> 'Create a new course',

   'Create a user or modify the roles and privileges of a user'
=> 'Create a user or modify the roles and privileges of a user',

   'Creating a new'
=> 'Creating a new',

   'Creation Date'
=> 'Creation Date',

   'Critical Messages'
=> 'Critical Messages',

   'Crosslisted courses'
=> 'Crosslisted courses',

   'Current'
=> 'Current',

   'Current Class List'
=> 'Current Class List',

   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',

   'Current Ending Date: not set'
=> 'Current Ending Date: not set',

   'Current Month'
=> 'Current Month',

   'Current Resource'
=> 'Current Resource',

   'Current Session Value'
=> 'Current Session Value',

   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',

   'Current Starting Date: not set'
=> 'Current Starting Date: not set',

   'Current Version'
=> 'Current Version',

   'Currently no active roles or courses'
=> 'Currently no active roles or courses',

   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',

   'Currently not available'
=> 'Currently not available',

   'Currently selected. '
=> 'Currently selected. ',

   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',

   'Custom Distribution File'
=> 'Custom Distribution File',

   'Custom Role Editor'
=> 'Custom Role Editor',

   'Customized right of use ...	'
=> 'Customized right of use ...	',

   'Cut selected'
=> 'Cut selected',

   'Date'
=> 'Date',

   'Deadlines'
=> 'Deadlines',

   'December'
=> 'December',

   'Decompress'
=> 'Decompress',

   'Default'
=> 'Default',

   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',

   'Default Cataloging Information for Directory'
=> 'Default Cataloging Information for Directory',

   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',

   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',

   'Default Value'
=> 'Default Value',

   'Default XML Style File'
=> 'Default XML Style File',

   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',

   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',

   'Default for new courses is'
=> 'Default for new courses is',

   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',

   'Default:'
=> 'Default:',

   'Define Role'
=> 'Define Role',

   'Degree of difficulty'
=> 'Degree of difficulty',

   'Delete'
=> 'Delete',

   'Delete Checked'
=> 'Delete Checked',

   'Delete a role'
=> 'Delete a role',

   'Delete an option'
=> 'Delete an option',

   'Delete messages from bulletin boards'
=> 'Delete messages from bulletin boards',

   'Delete:'
=> 'Delete:',

   'Dependencies'
=> 'Dependencies',

   'Description:'
=> 'Description:',

   'Detailed Citation View'
=> 'Detailed Citation View',

   'Detailed Problem Analysis'
=> 'Detailed Problem Analysis',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Detailed statistics and graphs of student performance on problems.',

   'Differences'
=> 'Differences',

   'Diffs'
=> 'Diffs',

   'Diffs with Current Version'
=> 'Diffs with Current Version',

   'Diffs with Version'
=> 'Diffs with Version',

   'Diffs with current Version'
=> 'Diffs with current Version',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)',

   'Disable all communication among students'
=> 'Disable all communication among students',

   'Disable display of problem receipts'
=> 'Disable display of problem receipts',

   'Disable student resource discussion'
=> 'Disable student resource discussion',

   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',

   'Disagree'
=> 'Disagree',

   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',

   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',

   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',

   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',

   'Discard Edits and View'
=> 'Discard Edits and View',

   'Discard Selected'
=> 'Discard Selected',

   'Discussion Contributions'
=> 'Discussion Contributions',

   'Discussion Participation'
=> 'Discussion Participation',

   'Discussions'
=> 'Discussions',

   'Display'
=> 'Display',

   'Display All Messages'
=> 'Display All Messages',

   'Display all Messages'
=> 'Display all Messages',

   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments.',

   'Display file attributes'
=> 'Display file attributes',

   'Display foils in order given'
=> 'Display foils in order given',

   'Display foils in random order'
=> 'Display foils in random order',

   'Distribute Messages from Uploaded File to Course'
=> 'Distribute Messages from Uploaded File to Course',

   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',

   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',

   'DoDiff'
=> 'DoDiff',

   'Domain'
=> 'Domain',

   'Domain Coordinator'
=> 'Domain Coordinator',

   'Domain Guest'
=> 'Domain Guest',

   'Domain Level'
=> 'Domain Level',

   'Domain only - use limited to courses in the domain'
=> 'Domain only - use limited to courses in the domain',

   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Done'
=> 'Done',

   'Drop Students'
=> 'Drop Students',

   'Drop/Add students in this course'
=> 'Drop/Add students in this course',

   'Dropped [_1]'
=> 'Dropped [_1]',

   'Dropped [_1] student(s).'
=> 'Dropped [_1] student(s).',

   'Dropping Students'
=> 'Dropping Students',

   'Due'
=> 'Due',

   'Due Date (contentclose)'
=> 'Due Date (contentclose)',

   'Due Date (duedate)'
=> 'Due Date (duedate)',

   'Dump Course DOCS'
=> 'Dump Course DOCS',

   'Dump Course DOCS to Construction Space'
=> 'Dump Course DOCS to Construction Space',

   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',

   'Dynamic Metadata'
=> 'Dynamic Metadata',

   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',

   'EMail Address'
=> 'EMail Address',

   'EMail and Messages'
=> 'EMail and Messages',

   'ERROR'
=> 'ERROR',

   'Edit'
=> 'Edit',

   'Edit Catalog Information'
=> 'Edit Catalog Information',

   'Edit Content of a Map'
=> 'Edit Content of a Map',

   'Edit Custom Role Privileges'
=> 'Edit Custom Role Privileges',

   'Edit Directory Catalog Information'
=> 'Edit Directory Catalog Information',

   'Edit and view documents included in this course'
=> 'Edit and view documents included in this course',

   'Edit this resource'
=> 'Edit this resource',

   'Edit/Modify DOCS'
=> 'Edit/Modify DOCS',

   'EditXML'
=> 'EditXML',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.',

   'Empty'
=> 'Empty',

   'Enclosing Map or Folder'
=> 'Enclosing Map or Folder',

   'End'
=> 'End',

   'End Helper'
=> 'End Helper',

   'End Time'
=> 'End Time',

   'Ending Date'
=> 'Ending Date',

   'English - ISO'
=> 'English - ISO',

   'Enroll One Student'
=> 'Enroll One Student',

   'Enroll a single student'
=> 'Enroll a single student',

   'Enroll as student'
=> 'Enroll as student',

   'Enrolling'
=> 'Enrolling',

   'Enrolling Student'
=> 'Enrolling Student',

   'Enrolling Students'
=> 'Enrolling Students',

   'Enrollment Manager'
=> 'Enrollment Manager',

   'Enrollment Status'
=> 'Enrollment Status',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',

   'Enter construction space as a co-author'
=> 'Enter construction space as a co-author',

   'Enter grades from check-out assessment resources'
=> 'Enter grades from check-out assessment resources',

   'Enter my portfolio space'
=> 'Enter my portfolio space',

   'Enter my resource construction space'
=> 'Enter my resource construction space',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Enter terms or phrases separated by search operators such as AND, OR, or NOT',

   'Enter the chatroom for the course'
=> 'Enter the chatroom for the course',

   'Entering Construction Space'
=> 'Entering Construction Space',

   'Entering course ...'
=> 'Entering course ...',

   'Error'
=> 'Error',

   'Error Messages'
=> 'Error Messages',

   'Error dropping [_1]:[_2]'
=> 'Error dropping [_1]:[_2]',

   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',

   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',

   'Essay, open end'
=> 'Essay, open end',

   'Evaluate Resource'
=> 'Evaluate Resource',

   'Evaluation Comments'
=> 'Evaluation Comments',

   'Evaluation Data'
=> 'Evaluation Data',

   'Evaluation Error '
=> 'Evaluation Error ',

   'Every problem in a particular folder'
=> 'Every problem in a particular folder',

   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',

   'Every problem in the course'
=> 'Every problem in the course',

   'Exam Information'
=> 'Exam Information',

   'Exam Problem'
=> 'Exam Problem',

   'Exam Proctor'
=> 'Exam Proctor',

   'Excel'
=> 'Excel',

   'Excel format'
=> 'Excel format',

   'Excused by instructor'
=> 'Excused by instructor',

   'Exit'
=> 'Exit',

   'Exit LON-CAPA'
=> 'Exit LON-CAPA',

   'Extent'
=> 'Extent',

   'External Resource'
=> 'External Resource',

   'FAIL'
=> 'FAIL',

   'Failed Access to Construction Space'
=> 'Failed Access to Construction Space',

   'Failed to copy source'
=> 'Failed to copy source',

   'Failed to write metadata copy'
=> 'Failed to write metadata copy',

   'False'
=> 'False',

   'February'
=> 'February',

   'Feedback Addresses for Course Content'
=> 'Feedback Addresses for Course Content',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',

   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',

   'Field'
=> 'Field',

   'Fielded Format'
=> 'Fielded Format',

   'File'
=> 'File',

   'File Category'
=> 'File Category',

   'File copied.'
=> 'File copied.',

   'Filenames in Construction Space'
=> 'Filenames in Construction Space',

   'Finalize Publication'
=> 'Finalize Publication',

   'Finish Course Initialization'
=> 'Finish Course Initialization',

   'Finish Helper'
=> 'Finish Helper',

   'First'
=> 'First',

   'First Name'
=> 'First Name',

   'First Resource'
=> 'First Resource',

   'Foil'
=> 'Foil',

   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',

   'Foils'
=> 'Foils',

   'Folder'
=> 'Folder',

   'Folder in Construction Space'
=> 'Folder in Construction Space',

   'Folder/Map'
=> 'Folder/Map',

   'For User'
=> 'For User',

   'For one or more students'
=> 'For one or more students',

   'Force publication of unmodified files'
=> 'Force publication of unmodified files',

   'Format:'
=> 'Format:',

   'Forward'
=> 'Forward',

   'Forwarded message from'
=> 'Forwarded message from',

   'Forwarding'
=> 'Forwarding',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.',

   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',

   'Frequency'
=> 'Frequency',

   'Fri'
=> 'Fri',

   'From'
=> 'From',

   'Full Update'
=> 'Full Update',

   'Full update (also print list of users not enrolled anymore)'
=> 'Full update (also print list of users not enrolled anymore)',

   'Functions'
=> 'Functions',

   'General Intro'
=> 'General Intro',

   'Generate Spreadsheet'
=> 'Generate Spreadsheet',

   'Generate Statistics'
=> 'Generate Statistics',

   'Generate messages from a file'
=> 'Generate messages from a file',

   'Generate new role ...'
=> 'Generate new role ...',

   'Generation'
=> 'Generation',

   'German - ISO'
=> 'German - ISO',

   'Getting Problem Variants'
=> 'Getting Problem Variants',

   'Go'
=> 'Go',

   'Go Back'
=> 'Go Back',

   'Go To My First Homework Problem'
=> 'Go To My First Homework Problem',

   'Go to ...'
=> 'Go to ...',

   'Go to the next resource in the course sequence'
=> 'Go to the next resource in the course sequence',

   'Go to the previous resource in the course sequence'
=> 'Go to the previous resource in the course sequence',

   'Goodbye'
=> 'Goodbye',

   'Grades Spreadsheet'
=> 'Grades Spreadsheet',

   'Grading'
=> 'Grading',

   'Grading Information'
=> 'Grading Information',

   'Grant/revoke Course Custom Role'
=> 'Grant/revoke Course Custom Role',

   'Grant/revoke role of Administrator'
=> 'Grant/revoke role of Administrator',

   'Grant/revoke role of Author'
=> 'Grant/revoke role of Author',

   'Grant/revoke role of Co-Author'
=> 'Grant/revoke role of Co-Author',

   'Grant/revoke role of Course Coordinator'
=> 'Grant/revoke role of Course Coordinator',

   'Grant/revoke role of Domain Coordinator'
=> 'Grant/revoke role of Domain Coordinator',

   'Grant/revoke role of Domain Guest'
=> 'Grant/revoke role of Domain Guest',

   'Grant/revoke role of Exam Proctor'
=> 'Grant/revoke role of Exam Proctor',

   'Grant/revoke role of Instructor'
=> 'Grant/revoke role of Instructor',

   'Grant/revoke role of Librarian'
=> 'Grant/revoke role of Librarian',

   'Grant/revoke role of Scantron Operator'
=> 'Grant/revoke role of Scantron Operator',

   'Grant/revoke role of Student'
=> 'Grant/revoke role of Student',

   'Grant/revoke role of Superuser'
=> 'Grant/revoke role of Superuser',

   'Grant/revoke role of Teaching Assistant'
=> 'Grant/revoke role of Teaching Assistant',

   'Greek Symbols'
=> 'Greek Symbols',

   'Group/Section'
=> 'Group/Section',

   'HTML'
=> 'HTML',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',

   'HTML character enties'
=> 'HTML character enties',

   'HTML in Discussions'
=> 'HTML in Discussions',

   'HTML/XML'
=> 'HTML/XML',

   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Height(pixel):'
=> 'Height(pixel):',

   'Help'
=> 'Help',

   'Help on Creating Courses'
=> 'Help on Creating Courses',

   'Helproom Hours'
=> 'Helproom Hours',

   'Hide'
=> 'Hide',

   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',

   'Highest Grade Level'
=> 'Highest Grade Level',

   'Hint Text'
=> 'Hint Text',

   'Home Server'
=> 'Home Server',

   'Homework problem'
=> 'Homework problem',

   'Host'
=> 'Host',

   'How do I create a CSV file from a spreadsheet'
=> 'How do I create a CSV file from a spreadsheet',

   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',

   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',

   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',

   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',

   'How should the results be printed?'
=> 'How should the results be printed?',

   'ID/Student Number'
=> 'ID/Student Number',

   'Identify fields'
=> 'Identify fields',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA.',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible.',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',

   'Ignore First Line'
=> 'Ignore First Line',

   'Illegal filename.'
=> 'Illegal filename.',

   'Image:'
=> 'Image:',

   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',

   'Import'
=> 'Import',

   'Import a published document'
=> 'Import a published document',

   'Import and Paste Area'
=> 'Import and Paste Area',

   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',

   'Incorrect'
=> 'Incorrect',

   'Incorrect Answers:'
=> 'Incorrect Answers:',

   'Initial Password'
=> 'Initial Password',

   'Institutional Information'
=> 'Institutional Information',

   'Instructor'
=> 'Instructor',

   'Instructor Information'
=> 'Instructor Information',

   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',

   'Internal Filename'
=> 'Internal Filename',

   'Internally authenticated'
=> 'Internally authenticated',

   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',

   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',

   'Invalid date entry'
=> 'Invalid date entry',

   'Invalid home server specified'
=> 'Invalid home server specified',

   'Invalid login mode or password.'
=> 'Invalid login mode or password.',

   'Invalid username or domain'
=> 'Invalid username or domain',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'It is recommended that you use an up-to-date virus scanner before handling this file.',

   'January'
=> 'January',

   'Japanese - UTF'
=> 'Japanese - UTF',

   'July'
=> 'July',

   'June'
=> 'June',

   'KEYWORDS'
=> 'KEYWORDS',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default)',

   'Kerberos authenticated'
=> 'Kerberos authenticated',

   'Keyword(s)'
=> 'Keyword(s)',

   'Keywords'
=> 'Keywords',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA Domain for Students',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager',

   'LON-CAPA Help'
=> 'LON-CAPA Help',

   'LON-CAPA Helper:'
=> 'LON-CAPA Helper:',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA domain: [_1]',

   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',

   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'LaTeX mode:'
=> 'LaTeX mode:',

   'Landscape'
=> 'Landscape',

   'Language'
=> 'Language',

   'Languages used'
=> 'Languages used',

   'Last'
=> 'Last',

   'Last Modified'
=> 'Last Modified',

   'Last Name'
=> 'Last Name',

   'Last Name, First Names'
=> 'Last Name, First Names',

   'Last Week'
=> 'Last Week',

   'Last access'
=> 'Last access',

   'Last accessed'
=> 'Last accessed',

   'Last modified'
=> 'Last modified',

   'Last updated'
=> 'Last updated',

   'Launch Remote Control'
=> 'Launch Remote Control',

   'Launch navigation window'
=> 'Launch navigation window',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',

   'Librarian'
=> 'Librarian',

   'Limit by copyright/distribution'
=> 'Limit by copyright/distribution',

   'Limit by language'
=> 'Limit by language',

   'List Directory'
=> 'List Directory',

   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',

   'List of possible answers'
=> 'List of possible answers',

   'Load'
=> 'Load',

   'Load Map'
=> 'Load Map',

   'Load:'
=> 'Load:',

   'Location'
=> 'Location',

   'Lock and unlock assessments'
=> 'Lock and unlock assessments',

   'Log in'
=> 'Log in',

   'Logged Out'
=> 'Logged Out',

   'Login Data'
=> 'Login Data',

   'Login Type'
=> 'Login Type',

   'Logout'
=> 'Logout',

   'Lowest Grade Level'
=> 'Lowest Grade Level',

   'MIME Type'
=> 'MIME Type',

   'Mail'
=> 'Mail',

   'Main Course Documents'
=> 'Main Course Documents',

   'Main Menu'
=> 'Main Menu',

   'Make new directory'
=> 'Make new directory',

   'Make new file'
=> 'Make new file',

   'Make notes and annotations about this resource'
=> 'Make notes and annotations about this resource',

   'Making Backup to'
=> 'Making Backup to',

   'Manage Access Keys'
=> 'Manage Access Keys',

   'Manage access keys'
=> 'Manage access keys',

   'Manual Grading'
=> 'Manual Grading',

   'Map'
=> 'Map',

   'Map contents are not shown in order.'
=> 'Map contents are not shown in order.',

   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',

   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',

   'March'
=> 'March',

   'Mark Unread'
=> 'Mark Unread',

   'Mark all posts read'
=> 'Mark all posts read',

   'Material appears to be correct'
=> 'Material appears to be correct',

   'Material covered with sufficient depth'
=> 'Material covered with sufficient depth',

   'Material is helpful'
=> 'Material is helpful',

   'Material presented in clear way'
=> 'Material presented in clear way',

   'Max Number Of Shown Foils:'
=> 'Max Number Of Shown Foils:',

   'Max Possible To Date'
=> 'Max Possible To Date',

   'Max Tries'
=> 'Max Tries',

   'Max number of foils displayed'
=> 'Max number of foils displayed',

   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',

   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',

   'May'
=> 'May',

   'Mean Tries'
=> 'Mean Tries',

   'Messaging'
=> 'Messaging',

   'Metadata'
=> 'Metadata',

   'Metadata Information'
=> 'Metadata Information',

   'Metadata Version'
=> 'Metadata Version',

   'Metadata current version'
=> 'Metadata current version',

   'Middle'
=> 'Middle',

   'Middle Name'
=> 'Middle Name',

   'Middle Names/Initials'
=> 'Middle Names/Initials',

   'Mime type'
=> 'Mime type',

   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',

   'Modification Date'
=> 'Modification Date',

   'Modification may make assessment data inaccessible'
=> 'Modification may make assessment data inaccessible',

   'Modified'
=> 'Modified',

   'Modify Course Assessment Parameters'
=> 'Modify Course Assessment Parameters',

   'Modify Enrollment for'
=> 'Modify Enrollment for',

   'Modify Parameters'
=> 'Modify Parameters',

   'Modify User'
=> 'Modify User',

   'Modify another students data'
=> 'Modify another students data',

   'Modify authentication mechanism and data for a user'
=> 'Modify authentication mechanism and data for a user',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modify deadlines, etc, for this assessment resource',

   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',

   'Modify grades'
=> 'Modify grades',

   'Modify student data'
=> 'Modify student data',

   'Modify user grades for this assessment resource'
=> 'Modify user grades for this assessment resource',

   'Modifying data for user'
=> 'Modifying data for user',

   'Modifying this will make problems'
=> 'Modifying this will make problems',

   'Mon'
=> 'Mon',

   'Most recently published Version'
=> 'Most recently published Version',

   'Move Down'
=> 'Move Down',

   'Move Up'
=> 'Move Up',

   'Move current file to'
=> 'Move current file to',

   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',

   'My Personal Info'
=> 'My Personal Info',

   'My question/comment/feedback:'
=> 'My question/comment/feedback:',

   'Name'
=> 'Name',

   'Name of Role'
=> 'Name of Role',

   'Name starting with'
=> 'Name starting with',

   'Name:'
=> 'Name:',

   'Navigate'
=> 'Navigate',

   'Navigate Contents'
=> 'Navigate Contents',

   'Navigate Course Contents'
=> 'Navigate Course Contents',

   'Navigate the table of contents for this course'
=> 'Navigate the table of contents for this course',

   'Network-wide number of accesses (hits)'
=> 'Network-wide number of accesses (hits)',

   'Network-wide number of courses using resource'
=> 'Network-wide number of courses using resource',

   'New Directory'
=> 'New Directory',

   'New Folder'
=> 'New Folder',

   'New HTML file'
=> 'New HTML file',

   'New Messages'
=> 'New Messages',

   'New Problem Variation'
=> 'New Problem Variation',

   'New Randomization'
=> 'New Randomization',

   'New Resource'
=> 'New Resource',

   'New Role'
=> 'New Role',

   'New Search'
=> 'New Search',

   'New Title'
=> 'New Title',

   'New User'
=> 'New User',

   'New Value'
=> 'New Value',

   'New assembled page'
=> 'New assembled page',

   'New assembled sequence'
=> 'New assembled sequence',

   'New custom rights file'
=> 'New custom rights file',

   'New discussion since'
=> 'New discussion since',

   'New file'
=> 'New file',

   'New parameters or stored values'
=> 'New parameters or stored values',

   'New problem'
=> 'New problem',

   'New style file'
=> 'New style file',

   'New subdirectory'
=> 'New subdirectory',

   'Next'
=> 'Next',

   'Next    '
=> 'Next    ',

   'Next ->'
=> 'Next ->',

   'Next Month'
=> 'Next Month',

   'No'
=> 'No',

   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',

   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',

   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',

   'No Kerberos domain was specified.'
=> 'No Kerberos domain was specified.',

   'No Role, Cumulative Privileges'
=> 'No Role, Cumulative Privileges',

   'No changes were made to the current settings.'
=> 'No changes were made to the current settings.',

   'No content modifications yet.'
=> 'No content modifications yet.',

   'No due date'
=> 'No due date',

   'No language preference'
=> 'No language preference',

   'No new filename specified.'
=> 'No new filename specified.',

   'No previous versions published.'
=> 'No previous versions published.',

   'No role specified'
=> 'No role specified',

   'No section assigned'
=> 'No section assigned',

   'No such file'
=> 'No such file',

   'No syllabus information provided.'
=> 'No syllabus information provided.',

   'No upload file specified.'
=> 'No upload file specified.',

   'No write permission to'
=> 'No write permission to',

   'No write permission to user directory, FAIL'
=> 'No write permission to user directory, FAIL',

   'None Found'
=> 'None Found',

   'Not Allowed'
=> 'Not Allowed',

   'Not applicable - '
=> 'Not applicable - ',

   'Not open to be viewed'
=> 'Not open to be viewed',

   'Not set -'
=> 'Not set -',

   'Not set - '
=> 'Not set - ',

   'Not shown, not used'
=> 'Not shown, not used',

   'Note: for large courses, this operation may be time consuming'
=> 'Note: for large courses, this operation may be time consuming',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Note: it can take up to 10 minutes for changes to take effect for all users.',

   'Note: this will not take effect if the user already exists'
=> 'Note: this will not take effect if the user already exists',

   'Notes'
=> 'Notes',

   'Notification of enrollment changes'
=> 'Notification of enrollment changes',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'November'
=> 'November',

   'Number of Plots:'
=> 'Number of Plots:',

   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',

   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Number of bubbles in exam mode (numbubbles)',

   'Number of columns'
=> 'Number of columns',

   'Number of resources that follow this resource in maps'
=> 'Number of resources that follow this resource in maps',

   'Number of resources that lead up to this resource in maps'
=> 'Number of resources that lead up to this resource in maps',

   'Number of resources using or importing resource'
=> 'Number of resources using or importing resource',

   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',

   'Obsolete'
=> 'Obsolete',

   'Obsolete parameters or stored values'
=> 'Obsolete parameters or stored values',

   'October'
=> 'October',

   'Office Hours'
=> 'Office Hours',

   'Old Value'
=> 'Old Value',

   'One particular problem'
=> 'One particular problem',

   'One particular problem (overrides folder and course defaults)'
=> 'One particular problem (overrides folder and course defaults)',

   'Online Help'
=> 'Online Help',

   'Only Answers'
=> 'Only Answers',

   'Only a number required.'
=> 'Only a number required.',

   'Only domain coordinators can change a users password.'
=> 'Only domain coordinators can change a users password.',

   'Open'
=> 'Open',

   'Open All Folders'
=> 'Open All Folders',

   'Open Course'
=> 'Open Course',

   'Open all assessments'
=> 'Open all assessments',

   'Open and correct'
=> 'Open and correct',

   'Open with full tries'
=> 'Open with full tries',

   'Open, no due date'
=> 'Open, no due date',

   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',

   'Opening Date (opendate)'
=> 'Opening Date (opendate)',

   'Option Response Problem Analysis'
=> 'Option Response Problem Analysis',

   'Option response'
=> 'Option response',

   'Other Symbols'
=> 'Other Symbols',

   'Output'
=> 'Output',

   'Output Format'
=> 'Output Format',

   'Output Format: [_1]'
=> 'Output Format: [_1]',

   'Overall Problem Statistics'
=> 'Overall Problem Statistics',

   'Owner/Publisher'
=> 'Owner/Publisher',

   'Page'
=> 'Page',

   'Page layout'
=> 'Page layout',

   'Paper type'
=> 'Paper type',

   'Parameter'
=> 'Parameter',

   'Parameter Name'
=> 'Parameter Name',

   'Parameter Type'
=> 'Parameter Type',

   'Parameter in Effect'
=> 'Parameter in Effect',

   'Parent Directory'
=> 'Parent Directory',

   'Part'
=> 'Part',

   'Part Description (display)'
=> 'Part Description (display)',

   'Part is not open to be viewed. It'
=> 'Part is not open to be viewed. It',

   'Password'
=> 'Password',

   'Paste after selected'
=> 'Paste after selected',

   'Path'
=> 'Path',

   'Per Page'
=> 'Per Page',

   'Personal Data'
=> 'Personal Data',

   'Personal Information'
=> 'Personal Information',

   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please check at least one of the following feedback types:'
=> 'Please check at least one of the following feedback types:',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',

   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',

   'Please do not reply to this address.'
=> 'Please do not reply to this address.',

   'Please either'
=> 'Please either',

   'Please notify the server administrator '
=> 'Please notify the server administrator ',

   'Please pick a version to retrieve'
=> 'Please pick a version to retrieve',

   'Please rank the following criteria:'
=> 'Please rank the following criteria:',

   'Please select a problem to analyze'
=> 'Please select a problem to analyze',

   'Please select a report to generate'
=> 'Please select a report to generate',

   'Please select a report to generate.'
=> 'Please select a report to generate.',

   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',

   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',

   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',

   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',

   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',

   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',

   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',

   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',

   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',

   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',

   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',

   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',

   'Please stand by.'
=> 'Please stand by.',

   'Please use browser "Back" button and pick a filename'
=> 'Please use browser "Back" button and pick a filename',

   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",

   'Portrait'
=> 'Portrait',

   'Portuguese - ISO'
=> 'Portuguese - ISO',

   'Position'
=> 'Position',

   'Post Discussion'
=> 'Post Discussion',

   'Post anonymously'
=> 'Post anonymously',

   'Post discussion on course resources'
=> 'Post discussion on course resources',

   'Post system frontpage announcements'
=> 'Post system frontpage announcements',

   'Post to live chatrooms'
=> 'Post to live chatrooms',

   'Preferred language'
=> 'Preferred language',

   'Prepare a printable document'
=> 'Prepare a printable document',

   'Preparing Excel Spreadsheet'
=> 'Preparing Excel Spreadsheet',

   'Preparing Printout'
=> 'Preparing Printout',

   'Prerequisites'
=> 'Prerequisites',

   'Previous'
=> 'Previous',

   'Previous Month'
=> 'Previous Month',

   'Print'
=> 'Print',

   'Print Index:'
=> 'Print Index:',

   'Print Table of Contents:'
=> 'Print Table of Contents:',

   'Print:'
=> 'Print:',

   'Printing Helper'
=> 'Printing Helper',

   'Privacy Note'
=> 'Privacy Note',

   'Private - visible to author only for testing purposes'
=> 'Private - visible to author only for testing purposes',

   'Private Publication - did not synchronize database'
=> 'Private Publication - did not synchronize database',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',

   'Problem Status Chart'
=> 'Problem Status Chart',

   'Problems'
=> 'Problems',

   'Problems Not Contained In A Folder'
=> 'Problems Not Contained In A Folder',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.',

   'Problems from entire course'
=> 'Problems from entire course',

   'Processed [_1] student(s).'
=> 'Processed [_1] student(s).',

   'Processed file'
=> 'Processed file',

   'Processing'
=> 'Processing',

   'Processing course structure'
=> 'Processing course structure',

   'Processing first student'
=> 'Processing first student',

   'Produce Excel Output'
=> 'Produce Excel Output',

   'Project Information'
=> 'Project Information',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Provide feedback messages or contribute to the course discussion about this resource',

   'Provide my evaluation of this resource'
=> 'Provide my evaluation of this resource',

   'Public - no authentication or authorization required for use'
=> 'Public - no authentication or authorization required for use',

   'Publish'
=> 'Publish',

   'Publish Directory'
=> 'Publish Directory',

   'Publish Directory and Sub Directories'
=> 'Publish Directory and Sub Directories',

   'Publish this Resource'
=> 'Publish this Resource',

   'Published'
=> 'Published',

   'Publisher/Owner'
=> 'Publisher/Owner',

   'Publishing'
=> 'Publishing',

   'Question Text'
=> 'Question Text',

   'Question Type'
=> 'Question Type',

   'Question Type (type)'
=> 'Question Type (type)',

   'Question about resource content'
=> 'Question about resource content',

   'Question/Comment/Feedback about course policy'
=> 'Question/Comment/Feedback about course policy',

   'Quick Completed Problems Display'
=> 'Quick Completed Problems Display',

   'Random position'
=> 'Random position',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',

   'Randomization algorithm used'
=> 'Randomization algorithm used',

   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',

   'Re'
=> 'Re',

   'Re-Initialize'
=> 'Re-Initialize',

   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data.',

   'Reading results from'
=> 'Reading results from',

   'Reading results from [_1]'
=> 'Reading results from [_1]',

   'Readings'
=> 'Readings',

   'Receipt algorithm used'
=> 'Receipt algorithm used',

   'Receiving results from [_1]'
=> 'Receiving results from [_1]',

   'Recent'
=> 'Recent',

   'Record'
=> 'Record',

   'Registering'
=> 'Registering',

   'Related'
=> 'Related',

   'Remark'
=> 'Remark',

   'Rename'
=> 'Rename',

   'Rename current file to'
=> 'Rename current file to',

   'Reply'
=> 'Reply',

   'Report a Bug'
=> 'Report a Bug',

   'Reset Submissions'
=> 'Reset Submissions',

   'Resource'
=> 'Resource',

   'Resource Differences'
=> 'Resource Differences',

   'Resource Feedback and Discussion'
=> 'Resource Feedback and Discussion',

   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',

   'Resource Level'
=> 'Resource Level',

   'Resource Publication'
=> 'Resource Publication',

   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',

   'Resource is technically correct'
=> 'Resource is technically correct',

   'Resources'
=> 'Resources',

   'Resources from selected sequence in course'
=> 'Resources from selected sequence in course',

   'Response'
=> 'Response',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'Retrieval of an old version will overwrite the file currently in construction space',

   'Retrieve'
=> 'Retrieve',

   'Retrieve Old Version'
=> 'Retrieve Old Version',

   'Retrieve Published Resources'
=> 'Retrieve Published Resources',

   'Retrieve previous versions of'
=> 'Retrieve previous versions of',

   'Retrieve version'
=> 'Retrieve version',

   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',

   'Return to DOCS'
=> 'Return to DOCS',

   'Return to Last Location'
=> 'Return to Last Location',

   'Reverse Association'
=> 'Reverse Association',

   'Revert to Last Saved'
=> 'Revert to Last Saved',

   'Revision Date'
=> 'Revision Date',

   'Revoke'
=> 'Revoke',

   'Revoke Existing Roles'
=> 'Revoke Existing Roles',

   'Role'
=> 'Role',

   'Role Information'
=> 'Role Information',

   'Row'
=> 'Row',

   'Rule'
=> 'Rule',

   'Russian - KOI'
=> 'Russian - KOI',

   'S.D. tries'
=> 'S.D. tries',

   'Sample Points:'
=> 'Sample Points:',

   'Samples'
=> 'Samples',

   'Sat'
=> 'Sat',

   'Save'
=> 'Save',

   'Save as'
=> 'Save as',

   'Save as & Make This Sheet the Default'
=> 'Save as & Make This Sheet the Default',

   'Save as ...'
=> 'Save as ...',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',

   'Saving Modifications to'
=> 'Saving Modifications to',

   'Scantron Operator'
=> 'Scantron Operator',

   'Score Upload Form'
=> 'Score Upload Form',

   'Search'
=> 'Search',

   'Search Complete'
=> 'Search Complete',

   'Search Complete [_1]'
=> 'Search Complete [_1]',

   'Search the contents of this course'
=> 'Search the contents of this course',

   'Search the database of published resources'
=> 'Search the database of published resources',

   'Search: [_1]'
=> 'Search: [_1]',

   'Searching'
=> 'Searching',

   'Section'
=> 'Section',

   'Section/Group'
=> 'Section/Group',

   'Sections'
=> 'Sections',

   'Select'
=> 'Select',

   'Select Action'
=> 'Select Action',

   'Select All'
=> 'Select All',

   'Select All Files'
=> 'Select All Files',

   'Select All Published'
=> 'Select All Published',

   'Select All Resources'
=> 'Select All Resources',

   'Select All Students'
=> 'Select All Students',

   'Select Course'
=> 'Select Course',

   'Select Date'
=> 'Select Date',

   'Select Enclosing Map or Folder'
=> 'Select Enclosing Map or Folder',

   'Select Folder'
=> 'Select Folder',

   'Select Map'
=> 'Select Map',

   'Select Only Current Students'
=> 'Select Only Current Students',

   'Select Parameter Level'
=> 'Select Parameter Level',

   'Select Printing Options:'
=> 'Select Printing Options:',

   'Select Problem'
=> 'Select Problem',

   'Select Problem(s) to print'
=> 'Select Problem(s) to print',

   'Select Resource(s) to print'
=> 'Select Resource(s) to print',

   'Select Resources To Print'
=> 'Select Resources To Print',

   'Select Section'
=> 'Select Section',

   'Select Sequence To Print From'
=> 'Select Sequence To Print From',

   'Select Spreadsheet File'
=> 'Select Spreadsheet File',

   'Select Student'
=> 'Select Student',

   'Select Students and Resources'
=> 'Select Students and Resources',

   'Select Style File'
=> 'Select Style File',

   'Select User'
=> 'Select User',

   'Select a'
=> 'Select a',

   'Select a Course to Enter'
=> 'Select a Course to Enter',

   'Select a course'
=> 'Select a course',

   'Select a user name to modify the students information'
=> 'Select a user name to modify the students information',

   'Select a user name to view the users personal page.'
=> 'Select a user name to view the users personal page.',

   'Select for Section/Group'
=> 'Select for Section/Group',

   'Select resources for the assignment'
=> 'Select resources for the assignment',

   'Select the Construction Space'
=> 'Select the Construction Space',

   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',

   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',

   'Selecting a User'
=> 'Selecting a User',

   'Send Message to User(s)'
=> 'Send Message to User(s)',

   'Send New'
=> 'Send New',

   'Send Reply'
=> 'Send Reply',

   'Send Scantron data to a course'
=> 'Send Scantron data to a course',

   'Send and receive messages'
=> 'Send and receive messages',

   'Send as critical message'
=> 'Send as critical message',

   'Send broadcast and receipt-required email'
=> 'Send broadcast and receipt-required email',

   'Send internal email'
=> 'Send internal email',

   'Sending Messages'
=> 'Sending Messages',

   'September'
=> 'September',

   'Sequence'
=> 'Sequence',

   'Sequence or Folder'
=> 'Sequence or Folder',

   'Sequences and Folders'
=> 'Sequences and Folders',

   'Server'
=> 'Server',

   'Server Administration'
=> 'Server Administration',

   'Set'
=> 'Set',

   'Set Course Environment'
=> 'Set Course Environment',

   'Set Course Environment Parameters'
=> 'Set Course Environment Parameters',

   'Set Date'
=> 'Set Date',

   'Set Defaults for All Resources in Course'
=> 'Set Defaults for All Resources in Course',

   'Set End Date'
=> 'Set End Date',

   'Set Individual User Roles'
=> 'Set Individual User Roles',

   'Set Problem Tries'
=> 'Set Problem Tries',

   'Set Problem Weight'
=> 'Set Problem Weight',

   'Set Start Date'
=> 'Set Start Date',

   'Set Version to be used in Course'
=> 'Set Version to be used in Course',

   'Set Versions to be used in Course according to Selections below'
=> 'Set Versions to be used in Course according to Selections below',

   'Set a bookmark for this resource'
=> 'Set a bookmark for this resource',

   'Set a due date'
=> 'Set a due date',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions)',

   'Set an answer open date'
=> 'Set an answer open date',

   'Set an open date'
=> 'Set an open date',

   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',

   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',

   'Set answer open date for the selected problem for ...'
=> 'Set answer open date for the selected problem for ...',

   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',

   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Set deadlines and other assessment parameters, as well as modify course environment',

   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',

   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',

   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',

   'Set my user preferences'
=> 'Set my user preferences',

   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',

   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',

   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',

   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',

   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',

   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',

   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',

   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . .',

   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',

   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',

   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',

   'Set the number of tries'
=> 'Set the number of tries',

   'Set the problem weight'
=> 'Set the problem weight',

   'Set to ...'
=> 'Set to ...',

   'Set value to "[_1]" to allow'
=> 'Set value to "[_1]" to allow',

   'Set/Modify Course Assessment Parameter'
=> 'Set/Modify Course Assessment Parameter',

   'Set/Modify Course Assessment Parameters'
=> 'Set/Modify Course Assessment Parameters',

   'Set/Modify Course Parameters'
=> 'Set/Modify Course Parameters',

   'Setting the [_1]'
=> 'Setting the [_1]',

   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',

   'Shared by course faculty and staff'
=> 'Shared by course faculty and staff',

   'Short string response'
=> 'Short string response',

   'Show Answer'
=> 'Show Answer',

   'Show Feedback'
=> 'Show Feedback',

   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',

   'Show More Options'
=> 'Show More Options',

   'Show Only Uncompleted Homework'
=> 'Show Only Uncompleted Homework',

   'Show Preview'
=> 'Show Preview',

   'Show Problem Completeness'
=> 'Show Problem Completeness',

   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',

   'Show all roles'
=> 'Show all roles',

   'Show all rles'
=> 'Show all rles',

   'Show always at bottom position'
=> 'Show always at bottom position',

   'Show always at top position'
=> 'Show always at top position',

   'Show catalog information'
=> 'Show catalog information',

   'Show resource'
=> 'Show resource',

   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Significant figures are incorrect, submission was not graded.'
=> 'Significant figures are incorrect, submission was not graded.',

   'Simple Edit'
=> 'Simple Edit',

   'Simple Page'
=> 'Simple Page',

   'Simple Problem'
=> 'Simple Problem',

   'Simple Problem Editor'
=> 'Simple Problem Editor',

   'Since Start of Course'
=> 'Since Start of Course',

   'Since Yesterday'
=> 'Since Yesterday',

   'Size'
=> 'Size',

   'Size:'
=> 'Size:',

   'Skew Tries'
=> 'Skew Tries',

   'Some items were not submitted'
=> 'Some items were not submitted',

   'Some parts were not submitted.'
=> 'Some parts were not submitted.',

   'Sorry ...'
=> 'Sorry ...',

   'Space separated'
=> 'Space separated',

   'Special Documents'
=> 'Special Documents',

   'Special documents'
=> 'Special documents',

   'Spreadsheet Computation'
=> 'Spreadsheet Computation',

   'Spreadsheet Computation Status'
=> 'Spreadsheet Computation Status',

   'Standards'
=> 'Standards',

   'Start'
=> 'Start',

   'Start Time'
=> 'Start Time',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",

   'Starting'
=> 'Starting',

   'Starting Date'
=> 'Starting Date',

   'Starting and Ending Dates'
=> 'Starting and Ending Dates',

   'Statistics'
=> 'Statistics',

   'Statistics and Problem Analysis'
=> 'Statistics and Problem Analysis',

   'Status'
=> 'Status',

   'Store'
=> 'Store',

   'Store Catalog Information'
=> 'Store Catalog Information',

   'Store Changes'
=> 'Store Changes',

   'Store uploaded file as '
=> 'Store uploaded file as ',

   'Strongly Agree'
=> 'Strongly Agree',

   'Strongly Disagree'
=> 'Strongly Disagree',

   'Student'
=> 'Student',

   'Student Data Compilation Progress'
=> 'Student Data Compilation Progress',

   'Student Data Compilation Status'
=> 'Student Data Compilation Status',

   'Student ID'
=> 'Student ID',

   'Student Information'
=> 'Student Information',

   'Student Name'
=> 'Student Name',

   'Student Number'
=> 'Student Number',

   'Student Sheet Links'
=> 'Student Sheet Links',

   'Student Status'
=> 'Student Status',

   'Student Status: [_1]'
=> 'Student Status: [_1]',

   'Student information updated successfully.'
=> 'Student information updated successfully.',

   'Student level sheet'
=> 'Student level sheet',

   'Student performance statistics on all problems.'
=> 'Student performance statistics on all problems.',

   'Students Affected'
=> 'Students Affected',

   'Students need access key to enter course'
=> 'Students need access key to enter course',

   'Students with expired roles'
=> 'Students with expired roles',

   'Subject'
=> 'Subject',

   'Subject:'
=> 'Subject:',

   'Submission Time Analysis'
=> 'Submission Time Analysis',

   'Submissions'
=> 'Submissions',

   'Submit'
=> 'Submit',

   'Submit Answer'
=> 'Submit Answer',

   'Submit Changes'
=> 'Submit Changes',

   'Submit Changes and Edit'
=> 'Submit Changes and Edit',

   'Submit Changes and View'
=> 'Submit Changes and View',

   'Submit Modifications'
=> 'Submit Modifications',

   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',

   'Successful Login'
=> 'Successful Login',

   'Suggested Replacement for Obsolete File'
=> 'Suggested Replacement for Obsolete File',

   'Summary'
=> 'Summary',

   'Summary View'
=> 'Summary View',

   'Sun'
=> 'Sun',

   'Supplemental Course Documents'
=> 'Supplemental Course Documents',

   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',

   'Switch Server'
=> 'Switch Server',

   'Switch to another course'
=> 'Switch to another course',

   'Switch to another user role'
=> 'Switch to another user role',

   'Switching Role'
=> 'Switching Role',

   'Syllabus'
=> 'Syllabus',

   'Symbol'
=> 'Symbol',

   'Synchronized SQL metadata database'
=> 'Synchronized SQL metadata database',

   'System'
=> 'System',

   'System Administration'
=> 'System Administration',

   'System Level'
=> 'System Level',

   'System wide - can be used for any courses system wide'
=> 'System wide - can be used for any courses system wide',

   'System wide - open source to all authors'
=> 'System wide - open source to all authors',

   'Tabulator separated'
=> 'Tabulator separated',

   'Target'
=> 'Target',

   'Target Edit Map'
=> 'Target Edit Map',

   'Task'
=> 'Task',

   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',

   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',

   'TeXWidth(mm):'
=> 'TeXWidth(mm):',

   'Teaching Assistant'
=> 'Teaching Assistant',

   'Template'
=> 'Template',

   'Temporary Assembly Workspace'
=> 'Temporary Assembly Workspace',

   'Text'
=> 'Text',

   'Text Block'
=> 'Text Block',

   'Textbook'
=> 'Textbook',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.',

   'The error reported was'
=> 'The error reported was',

   'The extension on this file'
=> 'The extension on this file',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'The filetype extension of the file you uploaded is not allowed.',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.',

   'The material appears to be correct '
=> 'The material appears to be correct ',

   'The material is helpful '
=> 'The material is helpful ',

   'The material is presented in a clear way '
=> 'The material is presented in a clear way ',

   'The optional email address field was not specified.'
=> 'The optional email address field was not specified.',

   'The optional name field was not specified.'
=> 'The optional name field was not specified.',

   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified.',

   'The optional student number field was not specified.'
=> 'The optional student number field was not specified.',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',

   'The requested file'
=> 'The requested file',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) ',

   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',

   'The submitted answer was too long.'
=> 'The submitted answer was too long.',

   'The target is an existing directory.'
=> 'The target is an existing directory.',

   'Then'
=> 'Then',

   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',

   'There are currently no results'
=> 'There are currently no results',

   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',

   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',

   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',

   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',

   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',

   'There are no students currently enrolled.'
=> 'There are no students currently enrolled.',

   'There are no students in the course.'
=> 'There are no students in the course.',

   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',

   'There is no student data for this problem.'
=> 'There is no student data for this problem.',

   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',

   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'This is an automatic message generated by the LON-CAPA system.',

   'This question expects a numeric answer.'
=> 'This question expects a numeric answer.',

   'This resource has been marked obsolete by the author(s)'
=> 'This resource has been marked obsolete by the author(s)',

   'This resource might be part of another course.'
=> 'This resource might be part of another course.',

   'This syllabus can be publicly viewed at'
=> 'This syllabus can be publicly viewed at',

   'Threaded View'
=> 'Threaded View',

   'Thu'
=> 'Thu',

   'Time'
=> 'Time',

   'Title'
=> 'Title',

   'To'
=> 'To',

   'To create a new'
=> 'To create a new',

   'Top Level Map'
=> 'Top Level Map',

   'Topic'
=> 'Topic',

   'Total'
=> 'Total',

   'Total Parts In Course'
=> 'Total Parts In Course',

   'Total number of records found in file: [_1].'
=> 'Total number of records found in file: [_1].',

   'Total number of students who have worked on this problem'
=> 'Total number of students who have worked on this problem',

   'Tries'
=> 'Tries',

   'True'
=> 'True',

   'Tue'
=> 'Tue',

   'Turkish - ISO'
=> 'Turkish - ISO',

   'Type'
=> 'Type',

   'Type Name Here'
=> 'Type Name Here',

   'Type in value'
=> 'Type in value',

   'Type-in value'
=> 'Type-in value',

   'Type:'
=> 'Type:',

   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',

   'UNIX authenticated'
=> 'UNIX authenticated',

   'URL'
=> 'URL',

   'URLs To Include in Syllabus'
=> 'URLs To Include in Syllabus',

   'USERS'
=> 'USERS',

   'Unable to connect to database!'
=> 'Unable to connect to database!',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Unable to determine if this resource is open due to network problems. Please try again later.',

   'Unable to enroll'
=> 'Unable to enroll',

   'Unable to enroll students'
=> 'Unable to enroll students',

   'Unable to find'
=> 'Unable to find',

   'Unable to make backup'
=> 'Unable to make backup',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',

   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',

   'Unable to set default dates for course'
=> 'Unable to set default dates for course',

   'Unable to understand formula'
=> 'Unable to understand formula',

   'Unable to undo, unable to switch'
=> 'Unable to undo, unable to switch',

   'Unable to write to'
=> 'Unable to write to',

   'Unavailable course'
=> 'Unavailable course',

   'Uncheck All'
=> 'Uncheck All',

   'Uncompleted Homework'
=> 'Uncompleted Homework',

   'Undetermined - ISO'
=> 'Undetermined - ISO',

   'Undid changes, Switched'
=> 'Undid changes, Switched',

   'Unit:'
=> 'Unit:',

   'Units incorrect.'
=> 'Units incorrect.',

   'Units required'
=> 'Units required',

   'Unknown Action'
=> 'Unknown Action',

   'Unknown ID'
=> 'Unknown ID',

   'Unknown message'
=> 'Unknown message',

   'Unknown user'
=> 'Unknown user',

   'Unpublished'
=> 'Unpublished',

   'Unselect All'
=> 'Unselect All',

   'Unselect All Files'
=> 'Unselect All Files',

   'Unselect All Published'
=> 'Unselect All Published',

   'Unselect All Resources'
=> 'Unselect All Resources',

   'Unselect All Students'
=> 'Unselect All Students',

   'Unselect for Section/Group'
=> 'Unselect for Section/Group',

   'Unsuccessful Login'
=> 'Unsuccessful Login',

   'Unsupported character combination'
=> 'Unsupported character combination',

   'Up'
=> 'Up',

   'Update Course Assessment Parameter Display'
=> 'Update Course Assessment Parameter Display',

   'Update Display'
=> 'Update Display',

   'Update Section or Specific User'
=> 'Update Section or Specific User',

   'Update Student Data'
=> 'Update Student Data',

   'Updating discussion time'
=> 'Updating discussion time',

   'Upload Document'
=> 'Upload Document',

   'Upload Scantron data'
=> 'Upload Scantron data',

   'Upload a Photo'
=> 'Upload a Photo',

   'Upload a class list'
=> 'Upload a class list',

   'Upload a new main course document'
=> 'Upload a new main course document',

   'Upload a new supplemental course document'
=> 'Upload a new supplemental course document',

   'Upload class list'
=> 'Upload class list',

   'Upload file'
=> 'Upload file',

   'Upload file to Construction Space'
=> 'Upload file to Construction Space',

   'Uploaded'
=> 'Uploaded',

   'Uploaded Document'
=> 'Uploaded Document',

   'Uploading Class List'
=> 'Uploading Class List',

   'Use or edit my bookmark collection'
=> 'Use or edit my bookmark collection',

   'User'
=> 'User',

   'User Load'
=> 'User Load',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'User Notes, Records of Face-to-Face Discussions, and Critical Messages',

   'User Role'
=> 'User Role',

   'User Roles'
=> 'User Roles',

   'Username'
=> 'Username',

   'Users with Roles Assigned by'
=> 'Users with Roles Assigned by',

   'VIEW'
=> 'VIEW',

   'Value'
=> 'Value',

   'Verify Content'
=> 'Verify Content',

   'Verify Course Documents'
=> 'Verify Course Documents',

   'Verify Selection'
=> 'Verify Selection',

   'Version'
=> 'Version',

   'Version Number'
=> 'Version Number',

   'Version changes since Yesterday'
=> 'Version changes since Yesterday',

   'Version changes since last Month'
=> 'Version changes since last Month',

   'Version changes since last Week'
=> 'Version changes since last Week',

   'Version changes since start of Course'
=> 'Version changes since start of Course',

   'Version used in Course'
=> 'Version used in Course',

   'View'
=> 'View',

   'View All Messages'
=> 'View All Messages',

   'View Class List'
=> 'View Class List',

   'View Critical Messages'
=> 'View Critical Messages',

   'View Published Version'
=> 'View Published Version',

   'View course assessment statistics'
=> 'View course assessment statistics',

   'View documents included in this course'
=> 'View documents included in this course',

   'View file'
=> 'View file',

   'View the FAQ'
=> 'View the FAQ',

   'View the course assessment progress chart'
=> 'View the course assessment progress chart',

   'View user submissions for this assessment resource'
=> 'View user submissions for this assessment resource',

   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',

   'Warning!'
=> 'Warning!',

   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',

   'Warning: target file exists!'
=> 'Warning: target file exists!',

   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',

   'Was due'
=> 'Was due',

   'Web Links'
=> 'Web Links',

   'Web References'
=> 'Web References',

   'Wed'
=> 'Wed',

   'Weight (weight)'
=> 'Weight (weight)',

   'Welcome'
=> 'Welcome',

   'Welcome to Your New LON-CAPA Course'
=> 'Welcome to Your New LON-CAPA Course',

   'Welcome to the Assignment Parameter Helper'
=> 'Welcome to the Assignment Parameter Helper',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up',

   'What parameter do you want to set for all problems in the course?'
=> 'What parameter do you want to set for all problems in the course?',

   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',

   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',

   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',

   'What should the due date be set to?'
=> 'What should the due date be set to?',

   'What should the opening date be set to?'
=> 'What should the opening date be set to?',

   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',

   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',

   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',

   'Which Problem or Problems?'
=> 'Which Problem or Problems?',

   'Which problems do you wish to set a parameter for?'
=> 'Which problems do you wish to set a parameter for?',

   'Width'
=> 'Width',

   'Width(pixel):'
=> 'Width(pixel):',

   'With Answers'
=> 'With Answers',

   'Without Answers'
=> 'Without Answers',

   'Words'
=> 'Words',

   'Wrote Metadata'
=> 'Wrote Metadata',

   'XML/SGML'
=> 'XML/SGML',

   'Yes'
=> 'Yes',

   'You are correct.'
=> 'You are correct.',

   'You are excused from the problem.'
=> 'You are excused from the problem.',

   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',

   'You did not select a template.'
=> 'You did not select a template.',

   'You do not have authoring privileges for this resource'
=> 'You do not have authoring privileges for this resource',

   'You have entered that answer before'
=> 'You have entered that answer before',

   'You have no critical messages.'
=> 'You have no critical messages.',

   'You have no unread messages'
=> 'You have no unread messages',

   'You have provided an invalid ranking'
=> 'You have provided an invalid ranking',

   'You must choose an authentication type.'
=> 'You must choose an authentication type.',

   'You must choose at least one student to continue.'
=> 'You must choose at least one student to continue.',

   'You must choose one or more choices to continue.'
=> 'You must choose one or more choices to continue.',

   'You need to choose another user role or enter a specific course for this function'
=> 'You need to choose another user role or enter a specific course for this function',

   'You need to specify the Kerberos domain.'
=> 'You need to specify the Kerberos domain.',

   'You need to specify the initial password.'
=> 'You need to specify the initial password.',

   'You need to specify the username field.'
=> 'You need to specify the username field.',

   'Your Excel Spreadsheet'
=> 'Your Excel Spreadsheet',

   'Your Version Settings have been Stored'
=> 'Your Version Settings have been Stored',

   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.',

   'Your home server is '
=> 'Your home server is ',

   'Your receipt is'
=> 'Your receipt is',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',

   'Your submission has been recorded.'
=> 'Your submission has been recorded.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',

   '[_1] Do not change login data'
=> '[_1] Do not change login data',

   '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])'
=> '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2])',

   '[_1] Internally authenticated (mit Anfangspasswort [_2])'
=> '[_1] Internally authenticated (mit Anfangspasswort [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Internally authenticated (with initial password [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local Authentication with arguement [_2]',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',

   '[_1] Records per Page'
=> '[_1] Records per Page',

   '[_1] minutes'
=> '[_1] minutes',

   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',

   '[_1] with value [_2]'
=> '[_1] with value [_2]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',

   '[_2] seconds'
=> '[_2] seconds',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',

   'a.m.'
=> 'a.m.',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'abstract'
=> 'abstract',

   'acc keys'
=> 'acc keys',

   'acc keys[_1]'
=> 'acc keys[_1]',

   'access denied'
=> 'access denied',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'according to course preferences'
=> 'according to course preferences',

   'according to resource settings'
=> 'according to resource settings',

   'according to user session state'
=> 'according to user session state',

   'after selected'
=> 'after selected',

   'all'
=> 'all',

   'all resources in the course'
=> 'all resources in the course',

   'all students in course'
=> 'all students in course',

   'an indeterminate date'
=> 'an indeterminate date',

   'an unknown date'
=> 'an unknown date',

   'and'
=> 'and',

   'and return receipt'
=> 'and return receipt',

   'anno-'
=> 'anno-',

   'anno-[_1]'
=> 'anno-[_1]',

   'anno.gif'
=> 'anno.gif',

   'announce'
=> 'announce',

   'announce[_1]'
=> 'announce[_1]',

   'anonymous'
=> 'anonymous',

   'anonymous students'
=> 'anonymous students',

   'anot.gif'
=> 'anot.gif',

   'answer date'
=> 'answer date',

   'at'
=> 'at',

   'at Domain'
=> 'at Domain',

   'at domain'
=> 'at domain',

   'audio'
=> 'audio',

   'author'
=> 'author',

   'backward'
=> 'backward',

   'backward[_1]'
=> 'backward[_1]',

   'bchat.gif'
=> 'bchat.gif',

   'between'
=> 'between',

   'bookmark'
=> 'bookmark',

   'bookmark[_1]'
=> 'bookmark[_1]',

   'bookmark[_2]'
=> 'bookmark[_2]',

   'button'
=> 'button',

   'by'
=> 'by',

   'bytes'
=> 'bytes',

   'calendar'
=> 'calendar',

   'calendar[_1]'
=> 'calendar[_1]',

   'can not be accessed from your location.'
=> 'can not be accessed from your location.',

   'catalog'
=> 'catalog',

   'catalog.gif'
=> 'catalog.gif',

   'catalog[_1]'
=> 'catalog[_1]',

   'ccrs.gif'
=> 'ccrs.gif',

   'changes will not show until next login'
=> 'changes will not show until next login',

   'chart'
=> 'chart',

   'chart[_1]'
=> 'chart[_1]',

   'chat'
=> 'chat',

   'chat[_1]'
=> 'chat[_1]',

   'check all'
=> 'check all',

   'chmod error'
=> 'chmod error',

   'choose'
=> 'choose',

   'choose[_1]'
=> 'choose[_1]',

   'choose[_2]'
=> 'choose[_2]',

   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'click on the',

   'close this window'
=> 'close this window',

   'co con-'
=> 'co con-',

   'co con-[_1]'
=> 'co con-[_1]',

   'co res'
=> 'co res',

   'co res[_1]'
=> 'co res[_1]',

   'com.gif'
=> 'com.gif',

   'commu-'
=> 'commu-',

   'commu-[_1]'
=> 'commu-[_1]',

   'con-'
=> 'con-',

   'con-[_1]'
=> 'con-[_1]',

   'connection down'
=> 'connection down',

   'contacting'
=> 'contacting',

   'contacting [_1]'
=> 'contacting [_1]',

   'contents'
=> 'contents',

   'contents[_1]'
=> 'contents[_1]',

   'copy Error'
=> 'copy Error',

   'copyright'
=> 'copyright',

   'could not be copied.'
=> 'could not be copied.',

   'course'
=> 'course',

   'course[_10]'
=> 'course[_10]',

   'course[_11]'
=> 'course[_11]',

   'course[_1]'
=> 'course[_1]',

   'course[_2]'
=> 'course[_2]',

   'course[_3]'
=> 'course[_3]',

   'course[_4]'
=> 'course[_4]',

   'course[_5]'
=> 'course[_5]',

   'course[_6]'
=> 'course[_6]',

   'course[_7]'
=> 'course[_7]',

   'course[_8]'
=> 'course[_8]',

   'course[_9]'
=> 'course[_9]',

   'courses.gif'
=> 'courses.gif',

   'cprv.gif'
=> 'cprv.gif',

   'create'
=> 'create',

   'create[_1]'
=> 'create[_1]',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'currently does not exist',

   'custom'
=> 'custom',

   'custom distribution file'
=> 'custom distribution file',

   'customdistributionfile'
=> 'customdistributionfile',

   'date_am'
=> 'date_am',

   'date_days'
=> 'date_days',

   'date_locale'
=> 'date_locale',

   'date_months'
=> 'date_months',

   'date_pm'
=> 'date_pm',

   'default'
=> 'default',

   'directory'
=> 'directory',

   'discuss'
=> 'discuss',

   'discuss[_1]'
=> 'discuss[_1]',

   'docs'
=> 'docs',

   'docs.gif'
=> 'docs.gif',

   'docs[_1]'
=> 'docs[_1]',

   'docs[_2]'
=> 'docs[_2]',

   'domain'
=> 'domain',

   'due date'
=> 'due date',

   'during the last'
=> 'during the last',

   'edit'
=> 'edit',

   'edit crs'
=> 'edit crs',

   'edit crs[_1]'
=> 'edit crs[_1]',

   'egrd.gif'
=> 'egrd.gif',

   'ences'
=> 'ences',

   'ences[_1]'
=> 'ences[_1]',

   'enrl.gif'
=> 'enrl.gif',

   'enroll'
=> 'enroll',

   'enroll[_1]'
=> 'enroll[_1]',

   'enter'
=> 'enter',

   'enter[_1]'
=> 'enter[_1]',

   'eval.gif'
=> 'eval.gif',

   'evaluate'
=> 'evaluate',

   'evaluate[_1]'
=> 'evaluate[_1]',

   'exit'
=> 'exit',

   'exit[_1]'
=> 'exit[_1]',

   'expired or revoked'
=> 'expired or revoked',

   'extension'
=> 'extension',

   'external'
=> 'external',

   'fas'
=> 'fas',

   'fdbk.gif'
=> 'fdbk.gif',

   'feedback'
=> 'feedback',

   'feedback[_1]'
=> 'feedback[_1]',

   'file<br />extension'
=> 'file<br />extension',

   'first name'
=> 'first name',

   'for'
=> 'for',

   'for <b>all resources in the course</b>'
=> 'for <b>all resources in the course</b>',

   'for <b>all students in course</b>'
=> 'for <b>all students in course</b>',

   'for Enclosing Map or Folder'
=> 'for Enclosing Map or Folder',

   'for Resource'
=> 'for Resource',

   'for [_1]'
=> 'for [_1]',

   'for section [_1]'
=> 'for section [_1]',

   'for the map named [_1]'
=> 'for the map named [_1]',

   'for the resource named [_1]'
=> 'for the resource named [_1]',

   'for visible separation'
=> 'for visible separation',

   'forward'
=> 'forward',

   'forward[_1]'
=> 'forward[_1]',

   'from'
=> 'from',

   'from Enclosing Map or Folder'
=> 'from Enclosing Map or Folder',

   'from current subdirectory'
=> 'from current subdirectory',

   'general'
=> 'general',

   'generation'
=> 'generation',

   'grades'
=> 'grades',

   'grades[_1]'
=> 'grades[_1]',

   'grades[_2]'
=> 'grades[_2]',

   'grds.gif'
=> 'grds.gif',

   'have different numbers and answers'
=> 'have different numbers and answers',

   'helper'
=> 'helper',

   'htmlarea_lang'
=> 'htmlarea_lang',

   'in'
=> 'in',

   'in Course'
=> 'in Course',

   'in Section/Group'
=> 'in Section/Group',

   'in domain'
=> 'in domain',

   'info'
=> 'info',

   'instructor'
=> 'instructor',

   'interface available'
=> 'interface available',

   'internal'
=> 'internal',

   'is closed but you are allowed to view it'
=> 'is closed but you are allowed to view it',

   'is due at'
=> 'is due at',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',

   'is in under construction'
=> 'is in under construction',

   'is not analyzable at this time'
=> 'is not analyzable at this time',

   'is ready for download'
=> 'is ready for download',

   'keys.gif'
=> 'keys.gif',

   'keywords'
=> 'keywords',

   'language'
=> 'language',

   'last month'
=> 'last month',

   'last name'
=> 'last name',

   'last problem'
=> 'last problem',

   'last six months'
=> 'last six months',

   'last student'
=> 'last student',

   'last three months'
=> 'last three months',

   'last week'
=> 'last week',

   'last year'
=> 'last year',

   'library'
=> 'library',

   'library[_1]'
=> 'library[_1]',

   'log in again'
=> 'log in again',

   'loginproblems.html'
=> 'loginproblems.html',

   'logout.gif'
=> 'logout.gif',

   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',

   'manage'
=> 'manage',

   'manage[_1]'
=> 'manage[_1]',

   'may be open from a different computer.'
=> 'may be open from a different computer.',

   'may open later.'
=> 'may open later.',

   'middle name'
=> 'middle name',

   'midnight'
=> 'midnight',

   'minutes'
=> 'minutes',

   'missions'
=> 'missions',

   'most recent'
=> 'most recent',

   'movies'
=> 'movies',

   'my'
=> 'my',

   'my[_1]'
=> 'my[_1]',

   'name'
=> 'name',

   'name only visible to course faculty'
=> 'name only visible to course faculty',

   'nav.gif'
=> 'nav.gif',

   'navigate'
=> 'navigate',

   'navigate[_1]'
=> 'navigate[_1]',

   'never'
=> 'never',

   'nication'
=> 'nication',

   'nication[_1]'
=> 'nication[_1]',

   'no ending date'
=> 'no ending date',

   'noon'
=> 'noon',

   'not displayed'
=> 'not displayed',

   'not found'
=> 'not found',

   'notes'
=> 'notes',

   'num_override'
=> 'num_override',

   'number'
=> 'number',

   'number of tries'
=> 'number of tries',

   'obsolete'
=> 'obsolete',

   'obsolete replacement'
=> 'obsolete replacement',

   'obsoletereplacement'
=> 'obsoletereplacement',

   'of'
=> 'of',

   'only check if you know what you are doing'
=> 'only check if you know what you are doing',

   'only search domain'
=> 'only search domain',

   'opening date'
=> 'opening date',

   'optional'
=> 'optional',

   'or'
=> 'or',

   'or ID'
=> 'or ID',

   'or any other value'
=> 'or any other value',

   'p.m.'
=> 'p.m.',

   'pages'
=> 'pages',

   'parm.gif'
=> 'parm.gif',

   'parms'
=> 'parms',

   'parms[_1]'
=> 'parms[_1]',

   'part'
=> 'part',

   'percent'
=> 'percent',

   'pictures'
=> 'pictures',

   'please refer to'
=> 'please refer to',

   'pref.gif'
=> 'pref.gif',

   'prefer-'
=> 'prefer-',

   'prefer-[_1]'
=> 'prefer-[_1]',

   'prepare'
=> 'prepare',

   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',

   'printout'
=> 'printout',

   'private'
=> 'private',

   'problem'
=> 'problem',

   'problem statistics grouped by sequence'
=> 'problem statistics grouped by sequence',

   'problem statistics ungrouped'
=> 'problem statistics ungrouped',

   'problem statistics, Excel'
=> 'problem statistics, Excel',

   'problem weight'
=> 'problem weight',

   'prt.gif'
=> 'prt.gif',

   'public'
=> 'public',

   'publisher<br />owner'
=> 'publisher<br />owner',

   're-initializing course'
=> 're-initializing course',

   'remaining'
=> 'remaining',

   'res.gif'
=> 'res.gif',

   'resource'
=> 'resource',

   'resource[_1]'
=> 'resource[_1]',

   'resources'
=> 'resources',

   'role'
=> 'role',

   'role,role,...'
=> 'role,role,...',

   'role[_1]'
=> 'role[_1]',

   'role[_2]'
=> 'role[_2]',

   'roles'
=> 'roles',

   'roles.gif'
=> 'roles.gif',

   'roles[_1]'
=> 'roles[_1]',

   'sbkm.gif'
=> 'sbkm.gif',

   'scantron[_1]'
=> 'scantron[_1]',

   'search'
=> 'search',

   'search[_1]'
=> 'search[_1]',

   'search[_2]'
=> 'search[_2]',

   'second'
=> 'second',

   'seconds'
=> 'seconds',

   'seconds for'
=> 'seconds for',

   'section'
=> 'section',

   'selected students'
=> 'selected students',

   'send[_1]'
=> 'send[_1]',

   'sequence'
=> 'sequence',

   'set'
=> 'set',

   'set[_1]'
=> 'set[_1]',

   'space'
=> 'space',

   'space[_1]'
=> 'space[_1]',

   'space[_2]'
=> 'space[_2]',

   'spacer.gif'
=> 'spacer.gif',

   'spellcheck_lang'
=> 'spellcheck_lang',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'standard'
=> 'standard',

   'standard LaTeX mode'
=> 'standard LaTeX mode',

   'standard courses only'
=> 'standard courses only',

   'stat.gif'
=> 'stat.gif',

   'stats'
=> 'stats',

   'stats[_1]'
=> 'stats[_1]',

   'struct'
=> 'struct',

   'struct[_1]'
=> 'struct[_1]',

   'struct[_2]'
=> 'struct[_2]',

   'student'
=> 'student',

   'student name'
=> 'student name',

   'subject'
=> 'subject',

   'switch'
=> 'switch',

   'switch[_1]'
=> 'switch[_1]',

   'switch[_2]'
=> 'switch[_2]',

   'system wide'
=> 'system wide',

   'tations'
=> 'tations',

   'template'
=> 'template',

   'textual_remote_display'
=> 'textual_remote_display',

   'this'
=> 'this',

   'title'
=> 'title',

   'to'
=> 'to',

   'to [_1] ([_2])'
=> 'to [_1] ([_2])',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',

   'today'
=> 'today',

   'unable to enroll'
=> 'unable to enroll',

   'uncheck all'
=> 'uncheck all',

   'undo'
=> 'undo',

   'unless locked'
=> 'unless locked',

   'untitled'
=> 'untitled',

   'updated periodically'
=> 'updated periodically',

   'use related words'
=> 'use related words',

   'user'
=> 'user',

   'user[_1]'
=> 'user[_1]',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'username'
=> 'username',

   'users in'
=> 'users in',

   'vbkm.gif'
=> 'vbkm.gif',

   'versions of this problem'
=> 'versions of this problem',

   'versus'
=> 'versus',

   'view'
=> 'view',

   'view sub-'
=> 'view sub-',

   'view[_1]'
=> 'view[_1]',

   'visible to author and co-authors only'
=> 'visible to author and co-authors only',

   'waiting on'
=> 'waiting on',

   'waiting on [_1]'
=> 'waiting on [_1]',

   'warning(s)'
=> 'warning(s)',

   'was due on'
=> 'was due on',

   'what you just saw on the screen'
=> 'what you just saw on the screen',

   'will open on'
=> 'will open on',

   'with server'
=> 'with server',

   'yes'
=> 'yes',



#SYNC Fri Aug 18 20:45:22 2006
